% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_node_attrs_ws.R
\name{set_node_attrs_ws}
\alias{set_node_attrs_ws}
\title{Set node attributes with a node selection}
\usage{
set_node_attrs_ws(graph, node_attr, value)
}
\arguments{
\item{graph}{A graph object of class \code{dgr_graph}.}

\item{node_attr}{The name of the attribute to set.}

\item{value}{The value to be set for the chosen attribute for the nodes in
the current selection.}
}
\value{
A graph object of class \code{dgr_graph}.
}
\description{
From a graph object of class \code{dgr_graph} or a node data frame, set node
attribute properties for nodes present in a node selection.

This function makes use of an active selection of nodes (and the function
ending with \verb{_ws} hints at this).

Selections of nodes can be performed using the following node selection
(\verb{select_*()}) functions: \code{\link[=select_nodes]{select_nodes()}}, \code{\link[=select_last_nodes_created]{select_last_nodes_created()}},
\code{\link[=select_nodes_by_degree]{select_nodes_by_degree()}}, \code{\link[=select_nodes_by_id]{select_nodes_by_id()}}, or
\code{\link[=select_nodes_in_neighborhood]{select_nodes_in_neighborhood()}}.

Selections of nodes can also be performed using the following traversal
(\verb{trav_*()}) functions: \code{\link[=trav_out]{trav_out()}}, \code{\link[=trav_in]{trav_in()}}, \code{\link[=trav_both]{trav_both()}},
\code{\link[=trav_out_node]{trav_out_node()}}, \code{\link[=trav_in_node]{trav_in_node()}}, \code{\link[=trav_out_until]{trav_out_until()}}, or
\code{\link[=trav_in_until]{trav_in_until()}}.
}
\examples{
# Create a simple graph
graph <-
  create_graph() \%>\%
  add_path(n = 6)

# Select specific nodes from the graph and
# apply the node attribute `color = blue` to
# those selected nodes
graph <-
  graph \%>\%
  select_nodes_by_id(
    nodes = 1:4) \%>\%
  trav_out() \%>\%
  set_node_attrs_ws(
    node_attr = color,
    value = "blue")

# Show the internal node data frame to verify
# that the node attribute has been set for
# specific node
graph \%>\% get_node_df()

}
\seealso{
Other node creation and removal: 
\code{\link{add_n_node_clones}()},
\code{\link{add_n_nodes}()},
\code{\link{add_n_nodes_ws}()},
\code{\link{add_node}()},
\code{\link{add_node_clones_ws}()},
\code{\link{add_node_df}()},
\code{\link{add_nodes_from_df_cols}()},
\code{\link{add_nodes_from_table}()},
\code{\link{colorize_node_attrs}()},
\code{\link{copy_node_attrs}()},
\code{\link{create_node_df}()},
\code{\link{delete_node}()},
\code{\link{delete_nodes_ws}()},
\code{\link{drop_node_attrs}()},
\code{\link{join_node_attrs}()},
\code{\link{layout_nodes_w_string}()},
\code{\link{mutate_node_attrs}()},
\code{\link{mutate_node_attrs_ws}()},
\code{\link{node_data}()},
\code{\link{recode_node_attrs}()},
\code{\link{rename_node_attrs}()},
\code{\link{rescale_node_attrs}()},
\code{\link{set_node_attr_to_display}()},
\code{\link{set_node_attr_w_fcn}()},
\code{\link{set_node_attrs}()},
\code{\link{set_node_position}()}
}
\concept{node creation and removal}
