% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_add_reference_rows.R
\name{tidy_add_reference_rows}
\alias{tidy_add_reference_rows}
\title{Add references rows for categorical variables}
\usage{
tidy_add_reference_rows(
  x,
  no_reference_row = NULL,
  model = tidy_get_model(x),
  quiet = FALSE
)
}
\arguments{
\item{x}{a tidy tibble}

\item{no_reference_row}{a vector indicating the name of variables
for those no reference row should be added.
Accepts \link[dplyr:select]{tidyselect} syntax. Default is \code{NULL}.
See also \code{\link[=all_categorical]{all_categorical()}} and \code{\link[=all_dichotomous]{all_dichotomous()}}}

\item{model}{the corresponding model, if not attached to \code{x}}

\item{quiet}{logical argument whether broom.helpers should not return
a message when requested output cannot be generated. Default is \code{FALSE}}
}
\description{
For categorical variables with a treatment contrast
(\code{\link[stats:contrast]{stats::contr.treatment()}}), a SAS contrast (\code{\link[stats:contrast]{stats::contr.SAS()}})
a sum contrast (\code{\link[stats:contrast]{stats::contr.sum()}}), or successive differences contrast
(\code{\link[MASS:contr.sdif]{MASS::contr.sdif()}}) add a reference row.
}
\details{
The added \code{reference_row} column will be equal to:
\itemize{
\item \code{TRUE} for a reference row;
\item \code{FALSE} for a normal row of a variable with a reference row;
\item \code{NA} for variables without a reference row.
}

If the \code{contrasts} column is not yet available in \code{x},
\code{\link[=tidy_add_contrasts]{tidy_add_contrasts()}} will be automatically applied.

\code{tidy_add_reference_rows()} will not populate the label
of the reference term. It is therefore better to apply
\code{\link[=tidy_add_term_labels]{tidy_add_term_labels()}} after \code{tidy_add_reference_rows()}
rather than before. Similarly, it is better to apply
\code{tidy_add_reference_rows()} before \code{\link[=tidy_add_n]{tidy_add_n()}}.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
if (.assert_package("gtsummary", boolean = TRUE)) {
  df <- Titanic \%>\%
    dplyr::as_tibble() \%>\%
    dplyr::mutate(Survived = factor(Survived, c("No", "Yes")))

  res <- df \%>\%
    glm(
      Survived ~ Class + Age + Sex,
      data = ., weights = .$n, family = binomial,
      contrasts = list(Age = contr.sum, Class = "contr.SAS")
    ) \%>\%
    tidy_and_attach()
  res \%>\% tidy_add_reference_rows()
  res \%>\% tidy_add_reference_rows(no_reference_row = all_dichotomous())
  res \%>\% tidy_add_reference_rows(no_reference_row = "Class")

  glm(
    response ~ stage + grade * trt,
    gtsummary::trial,
    family = binomial,
    contrasts = list(
      stage = contr.treatment(4, base = 3),
      grade = contr.treatment(3, base = 2),
      trt = contr.treatment(2, base = 2)
    )
  ) \%>\%
    tidy_and_attach() \%>\%
    tidy_add_reference_rows()
}
\dontshow{\}) # examplesIf}
}
\seealso{
Other tidy_helpers: 
\code{\link{tidy_add_coefficients_type}()},
\code{\link{tidy_add_contrasts}()},
\code{\link{tidy_add_estimate_to_reference_rows}()},
\code{\link{tidy_add_header_rows}()},
\code{\link{tidy_add_n}()},
\code{\link{tidy_add_pairwise_contrasts}()},
\code{\link{tidy_add_term_labels}()},
\code{\link{tidy_add_variable_labels}()},
\code{\link{tidy_attach_model}()},
\code{\link{tidy_disambiguate_terms}()},
\code{\link{tidy_identify_variables}()},
\code{\link{tidy_plus_plus}()},
\code{\link{tidy_remove_intercept}()},
\code{\link{tidy_select_variables}()}
}
\concept{tidy_helpers}
