% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getMaxIndex.R
\name{getMaxIndex}
\alias{getMaxIndex}
\alias{getMinIndex}
\alias{getBestIndex}
\title{Return index of maximal/minimal/best element in numerical vector.}
\usage{
getMaxIndex(x, weights = NULL, ties.method = "random", na.rm = FALSE)

getMinIndex(x, weights = NULL, ties.method = "random", na.rm = FALSE)

getBestIndex(x, weights = NULL, minimize = TRUE, ...)
}
\arguments{
\item{x}{[\code{numeric}]\cr
Input vector.}

\item{weights}{[\code{numeric}]\cr
Weights (same length as \code{x}).
If these are specified, the index is selected from \code{x * w}.
Default is \code{NULL} which means no weights.}

\item{ties.method}{[\code{character(1)}]\cr
How should ties be handled?
Possible are: \dQuote{random}, \dQuote{first}, \dQuote{last}.
Default is \dQuote{random}.}

\item{na.rm}{[\code{logical(1)}]\cr
If \code{FALSE}, NA is returned if an NA is encountered in \code{x}.
If \code{TRUE}, NAs are disregarded.
Default is \code{FALSE}}

\item{minimize}{[\code{logical(1)}]\cr
Minimal element is considered best?
Default is \code{TRUE}.}

\item{...}{[any]\cr
Further arguments passed down to the delegate.}
}
\value{
[\code{integer(1)}].
}
\description{
If \code{x} is empty or only contains NAs which are to be removed,
-1 is returned.
}
\note{
Function \code{getBestIndex} is a simple wrapper for \code{getMinIndex} or
\code{getMaxIndex} respectively depending on the argument \code{minimize}.
}
