% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_simpson.R
\name{simulate_simpson}
\alias{simulate_simpson}
\title{Simpson's paradox dataset simulation}
\usage{
simulate_simpson(
  n = 100,
  r = 0.5,
  groups = 3,
  difference = 1,
  group_prefix = "G_"
)
}
\arguments{
\item{n}{The number of observations for each group to be generated (minimum 4).}

\item{r}{A value or vector corresponding to the desired correlation
coefficients.}

\item{groups}{Number of groups (groups can be participants, clusters, anything).}

\item{difference}{Difference between groups.}

\item{group_prefix}{The prefix of the group name (e.g., "G_1", "G_2", "G_3", ...).}
}
\value{
A dataset.
}
\description{
Simpson's paradox, or the Yule-Simpson effect, is a phenomenon in probability
and statistics, in which a trend appears in several different groups of data
but disappears or reverses when these groups are combined.
}
\examples{
\dontshow{if (requireNamespace("MASS", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
data <- simulate_simpson(n = 10, groups = 5, r = 0.5)

if (require("ggplot2")) {
  ggplot(data, aes(x = V1, y = V2)) +
    geom_point(aes(color = Group)) +
    geom_smooth(aes(color = Group), method = "lm") +
    geom_smooth(method = "lm")
}
\dontshow{\}) # examplesIf}
}
