% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rowCummaxs.R
\name{rowCummaxs}
\alias{rowCummaxs}
\alias{rowCummaxs,matrix_OR_array_OR_table_OR_numeric-method}
\alias{rowCummaxs,ANY-method}
\alias{colCummaxs}
\alias{colCummaxs,matrix_OR_array_OR_table_OR_numeric-method}
\alias{colCummaxs,ANY-method}
\title{Calculates the cumulative maxima for each row (column) of a matrix-like
object}
\usage{
rowCummaxs(x, rows = NULL, cols = NULL, ..., useNames = NA)

\S4method{rowCummaxs}{matrix_OR_array_OR_table_OR_numeric}(x, rows = NULL, cols = NULL, dim. = dim(x), ..., useNames = NA)

\S4method{rowCummaxs}{ANY}(x, rows = NULL, cols = NULL, ..., useNames = NA)

colCummaxs(x, rows = NULL, cols = NULL, ..., useNames = NA)

\S4method{colCummaxs}{matrix_OR_array_OR_table_OR_numeric}(x, rows = NULL, cols = NULL, dim. = dim(x), ..., useNames = NA)

\S4method{colCummaxs}{ANY}(x, rows = NULL, cols = NULL, ..., useNames = NA)
}
\arguments{
\item{x}{An NxK matrix-like object.}

\item{rows, cols}{A \code{\link{vector}} indicating the subset of rows
(and/or columns) to operate over. If \code{\link{NULL}}, no subsetting is
done.}

\item{...}{Additional arguments passed to specific methods.}

\item{useNames}{If \code{\link{NA}}, the default behavior of the function about naming support is remained. If \code{\link{FALSE}}, no naming support is done. Else if \code{\link{TRUE}}, names attributes of result are set.}

\item{dim.}{An \code{\link{integer}} \code{\link{vector}} of length two
specifying the dimension of \code{x}, essential when x is a
\code{\link{numeric}} vector. Note, that this is not a generic
argument and not all methods need provide it.}
}
\value{
Returns a \code{\link{numeric}} \code{\link{matrix}}with the same
dimensions as \code{x}.
}
\description{
Calculates the cumulative maxima for each row (column) of a matrix-like
object.
}
\details{
The S4 methods for \code{x} of type \code{\link{matrix}},
\code{\link{array}}, or \code{\link{numeric}} call
\code{matrixStats::rowCummaxs}
/ \code{matrixStats::colCummaxs}.
}
\examples{
  mat <- matrix(rnorm(15), nrow = 5, ncol = 3)
  mat[2, 1] <- NA
  mat[3, 3] <- Inf
  mat[4, 1] <- 0
  
  print(mat)
  
  rowCummaxs(mat)
  colCummaxs(mat)
  
}
\seealso{
\itemize{
\item \code{matrixStats::\link[matrixStats:rowCumsums]{rowCummaxs}()} and
\code{matrixStats::\link[matrixStats:rowCumsums]{colCummaxs}()} which are
used when the input is a \code{matrix} or \code{numeric} vector.
\item For single maximum estimates, see \code{\link{rowMaxs}()}.
\item \code{base::\link{cummax}()}.
}
}
\keyword{array}
\keyword{iteration}
\keyword{robust}
\keyword{univar}
