with Standard_Natural_Numbers;            use Standard_Natural_Numbers;
with Multprec_Floating_Numbers;           use Multprec_Floating_Numbers;

package Multprec_Floating_Constants is

-- DESCRIPTION :
--   This package provides multiprecision approximations of Pi.

  strpi : constant string := "3.141592653589793238462643383279502884197"
  & "169399375105820974944592307816406286208998628034825342117067982148"
  & "086513282306647093844609550582231725359408128481117450284102701938"
  & "521105559644622948954930381964428810975665933446128475648233786783"
  & "165271201909145648566923460348610454326648213393607260249141273724"
  & "587006606315588174881520920962829254091715364367892590360011330530"
  & "548820466521384146951941511609433057270365759591953092186117381932"
  & "611793105118548074462379962749567351885752724891227938183011949129"
  & "833673362440656643086021394946395224737190702179860943702770539217"
  & "176293176752384674818467669405132000568127145263560827785771342757"
  & "789609173637178721468440901224953430146549585371050792279689258923"
  & "542019956112129021960864034418159813629774771309960518707211349999"
  & "998372978049951059731732816096318595024459455346908302642522308253"
  & "344685035261931188171010003137838752886587533208381420617177669147"
  & "303598253490428755468731159562863882353787593751957781857780532171"
  & "226806613001927876611195909216420199";

  strtwopi : constant string := "6.283185307179586476925286766559005768"
  & "394338798750211641949889184615632812572417997256069650684234135964"
  & "296173026564613294187689219101164463450718816256962234900568205403"
  & "877042211119289245897909860763928857621951331866892256951296467573"
  & "566330542403818291297133846920697220908653296426787214520498282547"
  & "449174013212631176349763041841925658508183430728735785180720022661"
  & "061097640933042768293903883023218866114540731519183906184372234763"
  & "865223586210237096148924759925499134703771505449782455876366023898"
  & "259667346724881313286172042789892790449474381404359721887405541078"
  & "434352586353504769349636935338810264001136254290527121655571542685"
  & "515579218347274357442936881802449906860293099170742101584559378517"
  & "847084039912224258043921728068836319627259549542619921037414422699"
  & "999996745956099902119463465632192637190048918910693816605285044616"
  & "506689370070523862376342020006275677505773175066416762841234355338"
  & "294607196506980857510937462319125727764707575187503915563715561064"
  & "342453613226003855753222391818432840398";

  function Pi ( d : natural32 ) return Floating_Number;

  -- DESCRIPTION :
  --   Provides an approximation of Pi with d decimal places.

  function TwoPi ( d : natural32 ) return Floating_Number;

  -- DESCRIPTION :
  --   Provides an approximation of 2*Pi with d decimal places.

end Multprec_Floating_Constants;
