//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/recoveryservices/armrecoveryservicessiterecovery/v2"
	"net/http"
	"net/url"
	"regexp"
)

// SupportedOperatingSystemsServer is a fake server for instances of the armrecoveryservicessiterecovery.SupportedOperatingSystemsClient type.
type SupportedOperatingSystemsServer struct {
	// Get is the fake for method SupportedOperatingSystemsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceName string, resourceGroupName string, options *armrecoveryservicessiterecovery.SupportedOperatingSystemsClientGetOptions) (resp azfake.Responder[armrecoveryservicessiterecovery.SupportedOperatingSystemsClientGetResponse], errResp azfake.ErrorResponder)
}

// NewSupportedOperatingSystemsServerTransport creates a new instance of SupportedOperatingSystemsServerTransport with the provided implementation.
// The returned SupportedOperatingSystemsServerTransport instance is connected to an instance of armrecoveryservicessiterecovery.SupportedOperatingSystemsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewSupportedOperatingSystemsServerTransport(srv *SupportedOperatingSystemsServer) *SupportedOperatingSystemsServerTransport {
	return &SupportedOperatingSystemsServerTransport{srv: srv}
}

// SupportedOperatingSystemsServerTransport connects instances of armrecoveryservicessiterecovery.SupportedOperatingSystemsClient to instances of SupportedOperatingSystemsServer.
// Don't use this type directly, use NewSupportedOperatingSystemsServerTransport instead.
type SupportedOperatingSystemsServerTransport struct {
	srv *SupportedOperatingSystemsServer
}

// Do implements the policy.Transporter interface for SupportedOperatingSystemsServerTransport.
func (s *SupportedOperatingSystemsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "SupportedOperatingSystemsClient.Get":
		resp, err = s.dispatchGet(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (s *SupportedOperatingSystemsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if s.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.RecoveryServices/vaults/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationSupportedOperatingSystems`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	instanceTypeUnescaped, err := url.QueryUnescape(qp.Get("instanceType"))
	if err != nil {
		return nil, err
	}
	instanceTypeParam := getOptional(instanceTypeUnescaped)
	var options *armrecoveryservicessiterecovery.SupportedOperatingSystemsClientGetOptions
	if instanceTypeParam != nil {
		options = &armrecoveryservicessiterecovery.SupportedOperatingSystemsClientGetOptions{
			InstanceType: instanceTypeParam,
		}
	}
	respr, errRespr := s.srv.Get(req.Context(), resourceNameParam, resourceGroupNameParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SupportedOperatingSystems, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
