#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# Fenrir TTY screen reader
# By Chrys, Storm Dragon, and contributors.

from fenrirscreenreader.core.i18n import _
from fenrirscreenreader.utils import mark_utils


class command:
    def __init__(self):
        pass

    def initialize(self, environment):
        self.env = environment

    def shutdown(self):
        pass

    def get_description(self):
        return _(
            "Presents the currently selected text that will be copied to the "
            "clipboard"
        )

    def run(self):
        if not (
            self.env["commandBuffer"]["Marks"]["1"]
            and self.env["commandBuffer"]["Marks"]["2"]
        ):
            self.env["runtime"]["OutputManager"].present_text(
                _("please set begin and endmark"), interrupt=True
            )
            return

        # use the last first and the last setted mark as range
        start_mark = self.env["commandBuffer"]["Marks"]["1"].copy()
        end_mark = self.env["commandBuffer"]["Marks"]["2"].copy()

        marked = mark_utils.get_text_between_marks(
            start_mark, end_mark, self.env["screen"]["new_content_text"]
        )

        if marked.isspace():
            self.env["runtime"]["OutputManager"].present_text(
                _("blank"), sound_icon="EmptyLine", interrupt=True
            )
        else:
            self.env["runtime"]["OutputManager"].present_text(
                marked, interrupt=True
            )

    def set_callback(self, callback):
        pass
