/* powerpc64-linux.elf-fold.h
   created from powerpc64-linux.elf-fold.bin, 21437 (0x53bd) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) Markus Franz Xaver Johannes Oberhumer
   Copyright (C) Laszlo Molnar
   Copyright (C) John F. Reiser
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <markus@oberhumer.com>               <ezerotven+github@gmail.com>

   John F. Reiser
   <jreiser@users.sourceforge.net>
 */

/* clang-format off */

#define STUB_POWERPC64_LINUX_ELF_FOLD_SIZE    21437
#define STUB_POWERPC64_LINUX_ELF_FOLD_ADLER32 0xb6a72e79
#define STUB_POWERPC64_LINUX_ELF_FOLD_CRC32   0x431a3d72

unsigned char stub_powerpc64_linux_elf_fold[21437] = {
/* 0x0000 */ 127, 69, 76, 70,  2,  2,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0010 */   0,  1,  0, 21,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0020 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 57,160,
/* 0x0030 */   0,  0,  0,  0,  0, 64,  0,  0,  0,  0,  0, 64,  0, 22,  0, 19,
/* 0x0040 */ 255,255,255,255,255,255,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0050 */  72,  0,  0,212,124,  8,  2,166, 72,  0,  0,  5,124,104,  2,166,
/* 0x0060 */ 124,  8,  3,166,232, 99,255,228, 78,128,  0, 32,124,  8,  2,166,
/* 0x0070 */  72,  0,  0,  5,124,200,  2,166,124,  8,  3,166,232,  6,255,204,
/* 0x0080 */ 124, 96,  0,120,124, 96, 24, 80,124,132,  2, 20, 72,  0,  0,  0,
/* 0x0090 */ 124,  8,  2,166, 72,  0,  0,  5,124,200,  2,166,124,  8,  3,166,
/* 0x00a0 */ 232,  6,255,168,124, 96,  0,120,124, 96, 24, 80,124,132,  2, 20,
/* 0x00b0 */ 124,227, 34, 20, 56,231,255,255, 96,102,  0,127,124,  0, 48,108,
/* 0x00c0 */ 124,  6, 56, 64,124,  0, 55,172, 56,198,  0,128, 65,128,255,240,
/* 0x00d0 */ 124,  0,  4,172, 76,  0,  1, 44, 72,  0,  0,  0,124,  8,  2,166,
/* 0x00e0 */  72,  0,  0,  5,124,200,  2,166,124,  8,  3,166,232,  6,255, 92,
/* 0x00f0 */ 124, 96,  0,120,124, 96, 24, 80,124,132,  2, 20, 72,  0,  0,  0,
/* 0x0100 */ 124,  8,  2,166, 72,  0,  0,  5,124,200,  2,166,124,  8,  3,166,
/* 0x0110 */ 232,  6,255, 56,124, 96,  0,120,124, 96, 24, 80,124,132,  2, 20,
/* 0x0120 */  72,  0,  0,  0,124,  9,  3,166,128, 22,  0,  0, 84,  0, 96, 38,
/* 0x0130 */ 124, 16,129, 32, 72,  0,  0, 25, 32, 32, 32, 61, 47,112,114,111,
/* 0x0140 */  99, 47,115,101,108,102, 47,101,120,101,  0,  0,126,200,  2,166,
/* 0x0150 */  58,214,  0,  4, 56,129,255,248, 65,146,  0, 16, 56,  0, 16,  4,
/* 0x0160 */ 124, 32,  8, 80,120, 33,  6,228, 56, 97,255,248, 59, 90,255,248,
/* 0x0170 */ 232,  4,  0,  9,127,164,208, 64,248,  3,  0,  9, 65,156,255,244,
/* 0x0180 */  59, 67,  0, 16,248,  3,  0,  9,232,  4,  0,  8, 43,160,  0,  0,
/* 0x0190 */ 248,  3,  0,  8,232,  4,  0, 17,248,  3,  0, 17, 64,158,255,236,
/* 0x01a0 */  58,163,  0,  8, 65,146,  0,180,126,122,168, 80,128, 22,255,252,
/* 0x01b0 */  58, 68,  0,  8,148,  3,  0,  8, 59,195,  0,  4, 56,128,  0,  0,
/* 0x01c0 */ 126,195,179,120, 72,  0,  0,  1,124,123, 27,120, 56,160, 15,255,
/* 0x01d0 */ 127,196,243,120,126,195,179,120, 72,  0,  0,  1, 56,190,255,252,
/* 0x01e0 */  44, 35,  0,  0, 65,129,  0, 12, 56,182,255,252, 56, 96,  0, 12,
/* 0x01f0 */  56, 99,  0,  4,124,133, 26, 20,124,105,  3,166,126, 67,147,120,
/* 0x0200 */  56,160,  0,  0,156,163,255,255,140,  4,255,255,156,  3,255,255,
/* 0x0210 */  66,  0,255,248,248,122,255,240,120, 99,  7, 36,124, 32, 34,120,
/* 0x0220 */ 124,  0, 26,120,120,  0,  7, 32,124, 96, 24, 80,126,164,171,120,
/* 0x0230 */  56,  0,  0,  0,248,  3,255,249,248,  3,255,249,124,117, 27,120,
/* 0x0240 */ 127, 83, 24, 80,232,  4,255,249,127,164,  8, 64,248,  3,255,249,
/* 0x0250 */  65,253,255,244,124, 97, 27,120, 57, 33,  1,136,251, 41,  0,  0,
/* 0x0260 */ 248, 33,247,113,127,  3,195,120,126,228,187,120, 56,161,  0,144,
/* 0x0270 */ 127, 70,211,120, 56,225, 10, 24,251, 39,  0,  0, 72,  0,  0,  1,
/* 0x0280 */  56, 33,  8,144,126,162,171,120,112, 96,  0,  7, 64,130,  0, 36,
/* 0x0290 */ 128,  3,  0,  0, 40,  0,  0,  0, 64,130,  0, 24,232,  1,  1,136,
/* 0x02a0 */ 232, 67,  0,  8,124, 66,  2, 20,232, 99,  0,  0,124, 99,  2, 20,
/* 0x02b0 */ 248,117,  0,  0,124,127, 27,120,127, 35,203,120, 72,  0,  0,  1,
/* 0x02c0 */ 232,153,  0,160,127, 35,203,120, 72,  0,  0,  1, 65,146,  0, 48,
/* 0x02d0 */  57,  0,  0,  0,127,103,219,120, 44,  7,  0,  0, 65,128,  0, 32,
/* 0x02e0 */  56,192,  0,  2, 56,160,  0,  1,124,148,  0,208, 56, 96,  0,  0,
/* 0x02f0 */  72,  0,  0,  1,127, 99,219,120, 72,  0,  0,  1,232, 21,255,248,
/* 0x0300 */ 124,  9,  3,166,251,225,  1,128,127,163,235,120,127,132,227,120,
/* 0x0310 */  56,  0,  0, 91,127,232,  3,166,232,161,  0,176,232,193,  0,184,
/* 0x0320 */ 232,225,  0,192,233,  1,  0,200,233, 33,  0,208,233, 65,  0,216,
/* 0x0330 */ 233, 97,  0,224,233,129,  0,232,233,161,  0,240,233,193,  0,248,
/* 0x0340 */ 233,225,  1,  0,234,  1,  1,  8,234, 33,  1, 16,234, 65,  1, 24,
/* 0x0350 */ 234, 97,  1, 32,234,129,  1, 40,234,161,  1, 48,234,193,  1, 56,
/* 0x0360 */ 234,225,  1, 64,235,  1,  1, 72,235, 33,  1, 80,235, 65,  1, 88,
/* 0x0370 */ 235, 97,  1, 96,235,129,  1,104,235,161,  1,112,235,193,  1,120,
/* 0x0380 */ 235,225,  1,128, 56, 33,  1,144, 78,128,  4, 32,233,  3,  0,  8,
/* 0x0390 */ 233, 67,  0,  0,127,170, 40, 64, 65,220,  0, 40, 57, 37,255,255,
/* 0x03a0 */  57, 72,255,255, 56,132,255,255,125, 40, 74, 20,125, 42, 72, 80,
/* 0x03b0 */ 125, 41,  3,166, 47,165,  0,  0, 64,158,  0, 32, 72,  0,  0, 40,
/* 0x03c0 */ 124,  8,  2,166,248,  1,  0, 16,248, 33,255,145, 56, 96,  0,127,
/* 0x03d0 */  72,  0,  0,  1, 96,  0,  0,  0,141, 42,  0,  1,157, 36,  0,  1,
/* 0x03e0 */  66,  0,255,248,233, 35,  0,  8,125, 41, 42, 20,249, 35,  0,  8,
/* 0x03f0 */ 233, 35,  0,  0,124,165, 72, 80,248,163,  0,  0, 78,128,  0, 32,
/* 0x0400 */   0,  0,  0,  0,  0,  0,  0,  1,128,  0,  0,  0,124,106, 27,121,
/* 0x0410 */  65,130,  0,144,121, 73,  7,225, 64,130,  0,144, 57,  0,  0,  0,
/* 0x0420 */  56,192,  0,  0, 56, 96,  0,  0,233, 42,  0,  0,124,135, 35,120,
/* 0x0430 */ 127,169, 32, 64, 64,158,  0, 24,248,170,  0,  8, 57,  8,  0,  1,
/* 0x0440 */ 125,  8,  7,180,125, 67, 83,120, 72,  0,  0, 12, 43,169,  0,  1,
/* 0x0450 */  65,158,  0, 68, 47,169,  0,  0, 64,158,  0, 64, 47,168,  0,  0,
/* 0x0460 */  76,158,  0, 32, 47,166,  0,  0, 65,222,  0, 20,248,230,  0,  0,
/* 0x0470 */ 248,166,  0,  8,124,195, 51,120, 78,128,  0, 32,124,  8,  2,166,
/* 0x0480 */ 248,  1,  0, 16,248, 33,255,145, 56, 96,  0,127, 72,  0,  0,  1,
/* 0x0490 */  96,  0,  0,  0,125, 70, 83,120, 57, 74,  0, 16, 75,255,255,140,
/* 0x04a0 */ 125, 67, 83,120, 78,128,  0, 32, 56, 96,  0,  0, 78,128,  0, 32,
/* 0x04b0 */   0,  0,  0,  0,  0,  0,  0,  1,128,  0,  0,  0,233, 36,  0,  0,
/* 0x04c0 */  47,169,  0,  0, 77,158,  0, 32,124,  8,  2,166,248,  1,  0, 16,
/* 0x04d0 */ 251,193,255,240,251,225,255,248,248, 33,255, 97,124,159, 35,120,
/* 0x04e0 */ 124,126, 27,120,127,195,243,120, 56,129,  0,112, 56,160,  0, 12,
/* 0x04f0 */  75,255,254,157,129, 33,  0,112, 47,169,  0,  0, 64,158,  0, 40,
/* 0x0500 */ 129, 33,  0,116, 61, 64, 33, 88, 97, 74, 80, 85,127,137, 80,  0,
/* 0x0510 */  64,222,  0, 32,233, 62,  0,  0, 47,169,  0,  0, 65,254,  0,204,
/* 0x0520 */  72,  0,  0, 16,128,161,  0,116, 47,165,  0,  0, 64,254,  0, 16,
/* 0x0530 */  56, 96,  0,127, 72,  0,  0,  1, 96,  0,  0,  0,127,137, 40, 64,
/* 0x0540 */  65,220,255,240,233, 95,  0,  0,127,169, 80, 64, 65,221,255,228,
/* 0x0550 */ 127,137, 40, 64, 64,157,  0, 88,249, 33,  0,128,232,126,  0,  8,
/* 0x0560 */  56, 99,255,244,232,159,  0,  8, 56,161,  0,128, 72,  0,  0,  1,
/* 0x0570 */  96,  0,  0,  0, 47,163,  0,  0, 64,222,255,184,129, 33,  0,112,
/* 0x0580 */ 233, 65,  0,128,127,169, 80,  0, 64,222,255,168,129,  1,  0,116,
/* 0x0590 */ 233, 94,  0,  8,125, 74, 66, 20,249, 94,  0,  8,233, 62,  0,  0,
/* 0x05a0 */ 125, 40, 72, 80,249, 62,  0,  0, 72,  0,  0, 28,233, 62,  0,  0,
/* 0x05b0 */  57, 41,  0, 12,249, 62,  0,  0,127,195,243,120,232,159,  0,  8,
/* 0x05c0 */  75,255,253,205,129,  1,  0,112,233, 95,  0,  8,125, 74, 66, 20,
/* 0x05d0 */ 249, 95,  0,  8,233, 63,  0,  0,125, 40, 72, 80,249, 63,  0,  0,
/* 0x05e0 */  47,169,  0,  0, 64,158,255,  0, 56, 33,  0,160,232,  1,  0, 16,
/* 0x05f0 */ 124,  8,  3,166,235,193,255,240,235,225,255,248, 78,128,  0, 32,
/* 0x0600 */   0,  0,  0,  0,  0,  0,  0,  1,128,  2,  0,  0,124,  8,  2,166,
/* 0x0610 */ 248,  1,  0, 16,251,161,255,232,251,193,255,240,251,225,255,248,
/* 0x0620 */ 248, 33,239,113,124,125, 27,120,124,159, 35,120,124,190, 43,120,
/* 0x0630 */  56, 97,  0,112, 72,  0,  0,  1, 96,  0,  0,  0,127,227,251,120,
/* 0x0640 */ 127,164,235,120, 56,160,  0,  3, 56,192,  0, 50, 56,224,255,255,
/* 0x0650 */  57,  0,  0,  0, 72,  0,  0,  1, 96,  0,  0,  0,127,227,251,120,
/* 0x0660 */  56,129,  0,112,127,197,243,120, 72,  0,  0,  1, 96,  0,  0,  0,
/* 0x0670 */  56, 33, 16,144,232,  1,  0, 16,124,  8,  3,166,235,161,255,232,
/* 0x0680 */ 235,193,255,240,235,225,255,248, 78,128,  0, 32,  0,  0,  0,  0,
/* 0x0690 */   0,  0,  0,  1,128,  3,  0,  0,124,  8,  2,166,248,  1,  0, 16,
/* 0x06a0 */ 250,193,255,176,250,225,255,184,251,  1,255,192,251, 33,255,200,
/* 0x06b0 */ 251, 65,255,208,251, 97,255,216,251,129,255,224,251,161,255,232,
/* 0x06c0 */ 251,193,255,240,251,225,255,248,248, 33,255, 65,124,123, 27,120,
/* 0x06d0 */ 124,159, 35,120,124,190, 43,120,124,220, 51,120, 72,  0,  0,  1,
/* 0x06e0 */  96,  0,  0,  0, 56,190,255,255,124,169,  7,180, 47,133,  0,  0,
/* 0x06f0 */  65,156,  0,120, 59,192, 16,  0, 56,224,  0,  0, 59, 32,255,255,
/* 0x0700 */ 121, 42,  0, 32, 57, 74,  0,  1,125, 73,  3,166,129, 95,  0,  0,
/* 0x0710 */  47,138,  0,  1, 64,158,  0, 64,233, 95,  0, 40, 47,170,  0,  0,
/* 0x0720 */  65,158,  0, 52,233, 31,  0, 16,127,185, 64, 64, 64,157,  0,  8,
/* 0x0730 */ 125, 25, 67,120,125, 72, 82, 20,127,167, 80, 64, 64,156,  0,  8,
/* 0x0740 */ 125, 71, 83,120,233, 95,  0, 48,127,190, 80, 64, 64,156,  0,  8,
/* 0x0750 */ 125, 94, 83,120, 59,255,  0, 56, 57, 41,255,255,125, 41,  7,180,
/* 0x0760 */  66,  0,255,172, 72,  0,  0, 16, 59,192, 16,  0, 56,224,  0,  0,
/* 0x0770 */  59, 32,255,255,125,  3,  0,208,127, 57, 24, 56,124,122, 24,248,
/* 0x0780 */ 124,250, 58, 20,124,249, 56, 80,124,250, 24, 56,127,168,240, 64,
/* 0x0790 */  64,156,  0,168, 57, 64,  0,  1,121, 74,  8, 40,125, 40, 81,210,
/* 0x07a0 */ 127,169,240, 64, 65,156,255,244,123, 87,  0, 32, 57, 74,255,255,
/* 0x07b0 */ 125, 74, 65,214,127,170,186, 20,123,184,  0, 32, 99,102,  0, 34,
/* 0x07c0 */ 127, 35,203,120,127,  4,195,120, 56,160,  0,  0,124,198,  7,180,
/* 0x07d0 */  56,224,255,255, 57,  0,  0,  0, 72,  0,  0,  1, 96,  0,  0,  0,
/* 0x07e0 */ 124,118, 27,120,124,123, 27,120,127,227,  0,208, 59,222,255,255,
/* 0x07f0 */ 127,255,240, 57, 65,130,  0, 28,127,228,251,120, 72,  0,  0,  1,
/* 0x0800 */  96,  0,  0,  0,127,118,250, 20,127,255,232, 80,123,248,  0, 32,
/* 0x0810 */ 127,247,192, 80,123,228,  0, 33, 65,130,  0, 16,124,123,210, 20,
/* 0x0820 */  72,  0,  0,  1, 96,  0,  0,  0,127, 91,210, 20,251, 92,  0,  0,
/* 0x0830 */ 124,121,216, 80, 72,  0,  0, 48, 99,102,  0, 34,127, 35,203,120,
/* 0x0840 */ 123, 68,  0, 32, 56,160,  0,  0,124,198,  7,180, 56,224,255,255,
/* 0x0850 */  57,  0,  0,  0, 72,  0,  0,  1, 96,  0,  0,  0,124,123, 27,120,
/* 0x0860 */  75,255,255,200, 56, 33,  0,192,232,  1,  0, 16,124,  8,  3,166,
/* 0x0870 */ 234,193,255,176,234,225,255,184,235,  1,255,192,235, 33,255,200,
/* 0x0880 */ 235, 65,255,208,235, 97,255,216,235,129,255,224,235,161,255,232,
/* 0x0890 */ 235,193,255,240,235,225,255,248, 78,128,  0, 32,  0,  0,  0,  0,
/* 0x08a0 */   0,  0,  0,  1,128, 10,  0,  0,124,  8,  2,166,248,  1,  0, 16,
/* 0x08b0 */ 125,128,  0, 38,249,193,255,112,249,225,255,120,250,  1,255,128,
/* 0x08c0 */ 250, 33,255,136,250, 65,255,144,250, 97,255,152,250,129,255,160,
/* 0x08d0 */ 250,161,255,168,250,193,255,176,250,225,255,184,251,  1,255,192,
/* 0x08e0 */ 251, 33,255,200,251, 65,255,208,251, 97,255,216,251,129,255,224,
/* 0x08f0 */ 251,161,255,232,251,193,255,240,251,225,255,248,145,129,  0,  8,
/* 0x0900 */ 248, 33,254,177,124,122, 27,120,248,161,  1,144,248,193,  1,152,
/* 0x0910 */ 235,227,  0, 32,127,227,250, 20, 57, 32,  0,  0,249, 33,  0,112,
/* 0x0920 */ 124,145, 35,121, 65,130,  0,112, 57, 71,  0, 64,161, 35,  0, 16,
/* 0x0930 */  58,192,  0,  0, 47,137,  0,  3, 64,158,  0, 32,234,202,  0, 72,
/* 0x0940 */ 126,214, 56, 80,233, 10,  0, 40,233, 42,  0, 16,125, 40, 74, 20,
/* 0x0950 */ 124,233, 58, 20,248,225,  0,112,232,106,  0, 16,124,118, 26, 20,
/* 0x0960 */ 232,138,  0, 40, 56,160,  0,  3, 56,192,  0, 50, 56,224,255,255,
/* 0x0970 */  57,  0,  0,  0, 72,  0,  0,  1, 96,  0,  0,  0, 72,  0,  0,  1,
/* 0x0980 */  96,  0,  0,  0,161, 58,  0, 56, 47,137,  0,  0, 65,157,  0, 68,
/* 0x0990 */  72,  0,  4, 64,161, 35,  0, 16, 56, 96,  0, 16, 47,137,  0,  3,
/* 0x09a0 */  64,158,  0,  8, 56, 96,  0,  0,127,228,251,120,160,186,  0, 56,
/* 0x09b0 */  56,193,  0,112, 72,  0,  0,  1,124,118, 27,120, 72,  0,  0,  1,
/* 0x09c0 */  96,  0,  0,  0,161, 58,  0, 56, 47,137,  0,  0, 64,157,  4, 44,
/* 0x09d0 */  59,192,  0,  0, 58, 64,  0,  0, 46, 49,  0,  0, 61,224,115, 81,
/* 0x09e0 */  97,239, 98, 64,124,116, 24,248, 72,  0,  0, 21, 68,  0,  0,  2,
/* 0x09f0 */ 127,236,251,120, 56,128,  0,  0, 78,128,  0, 32,124,168,  2,166,
/* 0x0a00 */ 248,161,  0,160, 61,192,  0,  1,121,206,131,228, 97,206,  0,  1,
/* 0x0a10 */ 124, 99, 24,248,144, 97,  0,144,120,104,  0, 32,249,  1,  0,168,
/* 0x0a20 */  72,  0,  0,  9,117,112,120,  0,125, 40,  2,166,249, 33,  0,176,
/* 0x0a30 */  58, 96,  0,  0, 72,  0,  0,  9,117,112,120,  0,125, 72,  2,166,
/* 0x0a40 */ 249, 65,  0,152, 65,146,  0, 40,129, 63,  0,  0, 47,137,  0,  6,
/* 0x0a50 */  64,158,  0, 28,232,191,  0, 16,232, 97,  1,152, 56,128,  0,  3,
/* 0x0a60 */ 124,182, 42, 20, 75,255,249,169, 72,  0,  3, 72,129, 63,  0,  0,
/* 0x0a70 */  47,137,  0,  1, 64,158,  3, 60,233, 63,  0, 40, 47,169,  0,  0,
/* 0x0a80 */  65,158,  3, 48,131,159,  0,  4, 87,156, 22,250,125,252,228, 48,
/* 0x0a90 */  87,151,  7,126,122,240,  0, 32, 65,146,  0, 76,233, 63,  0,  8,
/* 0x0aa0 */  47,169,  0,  0, 64,158,  0, 64,233, 58,  0, 32,125, 54, 74, 20,
/* 0x0ab0 */ 232,191,  0, 16,232, 97,  1,152, 56,128,  0,  3,124,169, 42, 20,
/* 0x0ac0 */  75,255,249, 77,232, 97,  1,152, 56,128,  0,  5,160,186,  0, 56,
/* 0x0ad0 */  75,255,249, 61,232, 97,  1,152, 56,128,  0,  4,160,186,  0, 54,
/* 0x0ae0 */  75,255,249, 45,235,127,  0, 32,251, 97,  0,120,235,191,  0, 16,
/* 0x0af0 */ 127,182,234, 20,251,161,  0,128,235, 31,  0, 40,127, 29,194, 20,
/* 0x0b00 */ 127, 61,218, 20,127,170,160, 56,127,106,218, 20,127,170,232, 80,
/* 0x0b10 */ 125, 61,218, 20,125, 41,  0,208,125, 41,160, 56,127,105,218, 20,
/* 0x0b20 */  65,146,  0,144,129, 63,  0,  4,121, 37,  7,225, 65,130,  0, 80,
/* 0x0b30 */ 232, 97,  0,152, 56,128,  0, 16, 72,  0,  0,  1, 96,  0,  0,  0,
/* 0x0b40 */ 124,117, 27,120,127,100,219,120, 72,  0,  0,  1, 96,  0,  0,  0,
/* 0x0b50 */ 127,163,235,120,127,100,219,120, 56,160,  0,  3, 56,192,  0, 17,
/* 0x0b60 */ 126,167,171,120, 57,  0,  0,  0, 72,  0,  0,  1, 96,  0,  0,  0,
/* 0x0b70 */ 127,189, 24,  0, 65,254,  2,108, 72,  0,  1,252,123,133,  7,224,
/* 0x0b80 */ 127,163,235,120,127,100,219,120, 96,165,  0,  2, 56,192,  0, 50,
/* 0x0b90 */  56,224,255,255, 57,  0,  0,  0, 72,  0,  0,  1, 96,  0,  0,  0,
/* 0x0ba0 */ 127,189, 24,  0, 64,222,  1,208, 58,160,  0,  0, 72,  0,  2, 52,
/* 0x0bb0 */ 233, 31,  0,  8,127,163,235,120,127,100,219,120,126,229,  7,180,
/* 0x0bc0 */  56,192,  0, 18,232,225,  1,144,125, 10, 64, 80, 72,  0,  0,  1,
/* 0x0bd0 */  96,  0,  0,  0,127,189, 24,  0, 64,222,  1,156,123,136,255,227,
/* 0x0be0 */  65,130,  1,112, 58,160,  0,  0,125, 57,  0,208,129, 65,  0,144,
/* 0x0bf0 */ 125, 41, 80, 56,121, 42,  0, 33, 65,130,  0, 20, 57, 57,255,255,
/* 0x0c00 */ 125, 73,  3,166,158,105,  0,  1, 66,  0,255,252,127, 57, 82, 20,
/* 0x0c10 */  65,210,  1, 64,129, 63,  0,  4,121, 37,  7,225, 65,130,  1, 52,
/* 0x0c20 */  47,178,  0,  0, 64,158,  0,208,233, 33,  0,128, 57, 41,  0,  3,
/* 0x0c30 */ 121, 42,  7,100,125, 82, 83,120,233, 63,  0,  0,121, 41,  7,194,
/* 0x0c40 */ 121, 41,  0,  2,127,169,112,  0, 64,158,  0,148,125, 42,  0,208,
/* 0x0c50 */ 233,  1,  0,168,125,  9, 72, 56, 47,169,  0, 15, 64,157,  0, 44,
/* 0x0c60 */ 233, 33,  0,160,128,201,  0,  0,128,233,  0,  4,129,  9,  0,  8,
/* 0x0c70 */ 129, 41,  0, 12,144,202,  0,  0,144,234,  0,  4,145, 10,  0,  8,
/* 0x0c80 */ 145, 42,  0, 12, 72,  0,  0, 88,232, 97,  0,176, 56,128,  0, 16,
/* 0x0c90 */  72,  0,  0,  1, 96,  0,  0,  0,124,124, 27,120,232,129,  0,160,
/* 0x0ca0 */  56,160,  0, 16, 72,  0,  0,  1, 96,  0,  0,  0, 56, 96,  0,  0,
/* 0x0cb0 */  56,128,  0, 16, 56,160,  0,  5, 56,192,  0,  1,127,135,227,120,
/* 0x0cc0 */  57,  0,  0,  0, 72,  0,  0,  1, 96,  0,  0,  0,124,114, 27,120,
/* 0x0cd0 */ 127,131,227,120, 72,  0,  0,  1, 96,  0,  0,  0, 47,178,  0,  0,
/* 0x0ce0 */  65,158,  0, 20,232, 97,  1,152, 56,128,  0,  0,126, 69,147,120,
/* 0x0cf0 */  75,255,247, 29,127,163,235,120,127,100,219,120, 56,160,  0,  4,
/* 0x0d00 */  72,  0,  0,  1, 96,  0,  0,  0,127,163,235,120,127,100,219,120,
/* 0x0d10 */  72,  0,  0,  1, 96,  0,  0,  0,127,163,235,120,127,100,219,120,
/* 0x0d20 */ 126,229,  7,180, 56,192,  0, 17,126,167,171,120, 57,  0,  0,  0,
/* 0x0d30 */  72,  0,  0,  1, 96,  0,  0,  0,127,189, 24,  0, 64,222,  0, 56,
/* 0x0d40 */ 126,163,171,120, 72,  0,  0,  1, 96,  0,  0,  0, 72,  0,  0, 52,
/* 0x0d50 */  43,151,  0,  3, 65,158,  0, 44,127,163,235,120,127,100,219,120,
/* 0x0d60 */ 126,  5,131,120, 72,  0,  0,  1, 96,  0,  0,  0, 47,163,  0,  0,
/* 0x0d70 */  65,254,  0, 16, 56, 96,  0,127, 72,  0,  0,  1, 96,  0,  0,  0,
/* 0x0d80 */ 127,184,200, 64, 64,157,  0, 44,127, 35,203,120,124,153,192, 80,
/* 0x0d90 */ 126,229,  7,180, 56,192,  0, 50, 56,224,255,255, 57,  0,  0,  0,
/* 0x0da0 */  72,  0,  0,  1, 96,  0,  0,  0,127,185, 24,  0, 64,222,255,200,
/* 0x0db0 */  59,255,  0, 56, 57, 94,  0,  1,125, 94,  7,180,161, 58,  0, 56,
/* 0x0dc0 */ 127,137, 80,  0, 65,157,252,128, 47,177,  0,  0, 65,158,  0, 44,
/* 0x0dd0 */ 232, 97,  0,112, 72,  0,  0,  1, 96,  0,  0,  0, 72,  0,  0, 28,
/* 0x0de0 */ 126, 35,139,120, 56,129,  0,120, 75,255,246,213,123,138,255,227,
/* 0x0df0 */  65,130,254, 36, 75,255,253,244,126,195,179,120, 56, 33,  1, 80,
/* 0x0e00 */ 232,  1,  0, 16,129,129,  0,  8,124,  8,  3,166,233,193,255,112,
/* 0x0e10 */ 233,225,255,120,234,  1,255,128,234, 33,255,136,234, 65,255,144,
/* 0x0e20 */ 234, 97,255,152,234,129,255,160,234,161,255,168,234,193,255,176,
/* 0x0e30 */ 234,225,255,184,235,  1,255,192,235, 33,255,200,235, 65,255,208,
/* 0x0e40 */ 235, 97,255,216,235,129,255,224,235,161,255,232,235,193,255,240,
/* 0x0e50 */ 235,225,255,248,125,144,129, 32, 78,128,  0, 32,  0,  0,  0,  0,
/* 0x0e60 */   0,  0,  0,  3,128, 18,  0,  0,124,  8,  2,166,248,  1,  0, 16,
/* 0x0e70 */ 251,129,255,224,251,161,255,232,251,193,255,240,251,225,255,248,
/* 0x0e80 */ 248, 33,255, 65,124,191, 43,120,124,221, 51,120,235,199,  0,  0,
/* 0x0e90 */ 248,161,  0,120,129, 35,  0,  0,249, 33,  0,112,248, 97,  0,152,
/* 0x0ea0 */ 129, 35,  0,  4, 57, 41,  0, 12,249, 33,  0,144,248, 97,  0,136,
/* 0x0eb0 */ 248,129,  0,128, 56, 97,  0,144, 56,129,  0,112, 75,255,246,  1,
/* 0x0ec0 */  72,  0,  0,  1, 96,  0,  0,  0,127,227,251,120, 56,129,  0,128,
/* 0x0ed0 */  56,160,  0,  0,127,166,235,120,127,199,243,120, 75,255,249,205,
/* 0x0ee0 */ 124,124, 27,120,235,223,  0, 24,127,195,242, 20,127,163,235,120,
/* 0x0ef0 */  56,128,  0,  9,127,197,243,120, 75,255,245, 21, 57, 63,  0, 64,
/* 0x0f00 */ 161, 95,  0, 56, 47,138,  0,  0, 65,158,  0,208,129, 31,  0, 64,
/* 0x0f10 */  47,136,  0,  3, 64,158,  0,156, 72,  0,  0, 16,129, 73,  0,  0,
/* 0x0f20 */  47,138,  0,  3, 64,158,  0,168,232,105,  0, 16,124,124, 26, 20,
/* 0x0f30 */  56,128,  0,  0, 56,160,  0,  0, 72,  0,  0,  1, 96,  0,  0,  0,
/* 0x0f40 */ 124,124, 27,120, 47,131,  0,  0, 65,220,  0, 28,127,228,251,120,
/* 0x0f50 */  56,160,  4,  0, 72,  0,  0,  1, 96,  0,  0,  0, 47,163,  4,  0,
/* 0x0f60 */  65,254,  0, 16, 56, 96,  0,127, 72,  0,  0,  1, 96,  0,  0,  0,
/* 0x0f70 */ 127,227,251,120, 56,128,  0,  0,127,133,227,120, 56,192,  0,  0,
/* 0x0f80 */  56,224,  0,  0, 75,255,249, 37,124,101, 27,120,235,195,  0, 24,
/* 0x0f90 */ 127,195,242, 20,127,163,235,120, 56,128,  0,  7, 75,255,244,113,
/* 0x0fa0 */ 127,131,227,120, 72,  0,  0,  1, 96,  0,  0,  0, 72,  0,  0, 44,
/* 0x0fb0 */  57, 74,255,255,121, 74,  0, 32,121, 72, 31, 36,121, 74, 54,100,
/* 0x0fc0 */ 125,  8, 80, 80, 57,  8,  0,120,125, 31, 66, 20, 57, 41,  0, 56,
/* 0x0fd0 */ 127,169, 64, 64, 64,158,255, 72,127,195,243,120, 56, 33,  0,192,
/* 0x0fe0 */ 232,  1,  0, 16,124,  8,  3,166,235,129,255,224,235,161,255,232,
/* 0x0ff0 */ 235,193,255,240,235,225,255,248, 78,128,  0, 32,  0,  0,  0,  0,
/* 0x1000 */   0,  0,  0,  1,128,  4,  0,  0, 56,  0,  9,153,124,128,  0,  8,
/* 0x1010 */ 120,231,  0, 32, 56,  0,  0, 90, 68,  0,  0,  2, 64,227,  0,  8,
/* 0x1020 */ 124, 99,  0,208, 78,128,  0, 32, 56,  0,  0, 91, 72,  0,  0,  8,
/* 0x1030 */  56,  0,  0,125, 72,  0,  0,  8, 56,  0,  0,144, 72,  0,  0,  8,
/* 0x1040 */  56,  0,  0, 93, 72,  0,  0,  8, 56,  0,  0,  1, 72,  0,  0,  8,
/* 0x1050 */  56,  0,  0, 45, 72,  0,  0,  8, 56,  0,  0, 85, 72,  0,  0,  8,
/* 0x1060 */  56,  0,  0,  4, 72,  0,  0,  8, 56,  0,  0,  3, 72,  0,  0,  8,
/* 0x1070 */  56,  0,  0,  5, 72,  0,  0,  8, 56,  0,  1, 30, 72,  0,  0,  8,
/* 0x1080 */  56,  0,  0,  6, 75,255,255,148,248, 97,255,241,232, 97,  0,  0,
/* 0x1090 */  56,  0,  1,104, 68,  0,  0,  2, 64,227,  0, 84, 44,  3,  0, 22,
/* 0x10a0 */  64,130,  0, 72, 44,  4,  0,  0, 65,130,  0, 12, 56,128,  0,  0,
/* 0x10b0 */  75,255,255,220,124,200,  2,166, 72,  0,  0, 17, 47,100,101,118,
/* 0x10c0 */  47,115,104,109,  0,  0,  0,  0,124,104,  2,166,124,200,  3,166,
/* 0x10d0 */  56,160,  1,192, 60,128,  0, 64, 96,132, 64,  2, 56,  0,  0,  5,
/* 0x10e0 */  68,  0,  0,  2, 64,227,  0,  8,124,128,  0,  8, 56, 33,  0, 16,
/* 0x10f0 */  78,128,  0, 32,124,200,  2,166, 56,128,  0, 16, 72,  0,  0,  9,
/* 0x1100 */ 117,112,120,  0,124,104,  2,166, 56,  0,  1,104, 68,  0,  0,  2,
/* 0x1110 */  64,227,  0, 32, 47,132,  0,  0, 64,158,  0,  8,124,128,  0,  8,
/* 0x1120 */  47,131,  0, 22, 64,158,255,248, 56,128,  0,  0, 75,255,255,208,
/* 0x1130 */ 124,200,  3,166, 78,128,  0, 32, 44,  5,  0,  0, 65,194,  0, 28,
/* 0x1140 */ 124,169,  3,166, 56,195,255,255, 56,132,255,255,140,  4,  0,  1,
/* 0x1150 */ 156,  6,  0,  1, 66,  0,255,248, 78,128,  0, 32,124,128,  0,  8,
/* 0x1160 */  78,128,  0, 32,124,  8,  2,166,248, 97,255,225,248,129,  0,  8,
/* 0x1170 */ 248,161,  0, 16,248,  1,  0, 24,136,227,  0,  8,124,166, 43,120,
/* 0x1180 */ 124,133, 35,120,128,131,  0,  4, 56, 99,  0, 12, 72,  0,  0,133,
/* 0x1190 */ 124,102, 27,120,232,161,  0,  0,232, 97,  0,  8,232,129,  0, 16,
/* 0x11a0 */  56, 33,  0, 24,232,132,  0,  0,248, 97,255,233,248,129,  0,  8,
/* 0x11b0 */ 248,193,  0, 16,136,197,  0,  9,136,165,  0, 10, 44,  6,  0,  0,
/* 0x11c0 */  65,130,  0,  8, 72,  0,  0,  1,232, 97,  0,  0,232,129,  0,  8,
/* 0x11d0 */  56, 33,  0, 16,124,132, 26, 20, 56,132,255,255, 96, 99,  0, 31,
/* 0x11e0 */ 124,  0, 24,108,124,  3, 32, 64,124,  0, 31,172, 56, 99,  0, 32,
/* 0x11f0 */  65,128,255,240,124,  0,  4,172, 76,  0,  1, 44,232, 97,  0,  0,
/* 0x1200 */ 232,  1,  0,  8, 56, 33,  0, 16,124,  8,  3,166, 78,128,  0, 32,
/* 0x1210 */ 124,227, 59,120,124,131, 24,  8,232,230,  0,  0,125,168,  3,166,
/* 0x1220 */ 124,100, 24, 80,124,135, 40, 80, 56, 99,  0,  1, 56,132,  0,  1,
/* 0x1230 */ 248,134,  0,  0, 78,128,  0, 32, 40,  6,  0,208, 76,194,  0, 32,
/* 0x1240 */  84,132,240,191, 77,194,  0, 32, 60,  0,  0, 16,124,  4,  0, 64,
/* 0x1250 */  65,128,  0,  8,124,  4,  3,120, 56,165,  1, 32,124,103, 27,120,
/* 0x1260 */  56, 99,255,252,124,137,  3,166, 72,  0,  0, 28, 84, 11,  2,186,
/* 0x1270 */ 125, 99, 88, 80,125,107, 58, 20, 81, 96,  1,186,144,  3,  0,  0,
/* 0x1280 */  79, 64,  0, 32,132,  3,  0,  4, 84, 11, 85,190,124, 11, 40, 64,
/* 0x1290 */  65,194,255,220, 67, 32,255,240, 78,128,  0, 32, 44,  7,  0,  8,
/* 0x12a0 */  64,130,  1, 88,124,  0, 41,236,125,168,  2,166, 40,  7,  0,  8,
/* 0x12b0 */  64,130,  1, 72,248,166,  0,  0,124,132, 26, 20, 60,  0,128,  0,
/* 0x12c0 */ 120,  0,  7,198,124,  9,  3,120, 56, 99,255,255, 56,165,255,255,
/* 0x12d0 */  57, 64,255,255, 72,  0,  1, 20, 57, 32,  0,  1,125, 41, 28, 44,
/* 0x12e0 */  56, 99,  0,  4,125, 41, 73, 20,121, 41,248, 36,124, 41,  0, 64,
/* 0x12f0 */ 125, 41, 72, 20, 78,128,  0, 32,141,  3,  0,  1,157,  5,  0,  1,
/* 0x1300 */ 124, 41,  0, 64,125, 41, 72, 20, 65,194,255,209, 65,225,255,236,
/* 0x1310 */  56,224,  0,  1, 72,  0,  0, 20, 56,231,255,255,125, 41, 72, 21,
/* 0x1320 */  65,194,255,185,124,231, 57, 20,125, 41, 72, 21, 65,194,255,173,
/* 0x1330 */ 124,231, 57, 20,124, 41,  0, 64,125, 41, 72, 20, 65,194,255,157,
/* 0x1340 */  65,192,255,216, 52,231,255,253, 57,  0,  0,  0, 65,192,  0, 40,
/* 0x1350 */ 141, 99,  0,  1,120,231, 69,198,124,231,  6,118,124,234, 88,249,
/* 0x1360 */ 125, 74, 14,116, 65,194,  0,  0,113,107,  0,  1, 65,226,  0, 80,
/* 0x1370 */  72,  0,  0, 20,124, 41,  0, 64,125, 41, 72, 20, 65,194,255, 93,
/* 0x1380 */  65,225,  0, 60, 57,  0,  0,  1,124, 41,  0, 64,125, 41, 72, 20,
/* 0x1390 */  65,194,255, 73, 65,225,  0, 40,125, 41, 72, 21, 65,194,255, 61,
/* 0x13a0 */ 125,  8, 65, 20,124, 41,  0, 64,125, 41, 72, 20, 65,194,255, 45,
/* 0x13b0 */  65,192,255,232, 57,  8,  0,  2, 72,  0,  0, 16,125, 41, 72, 21,
/* 0x13c0 */  65,194,255, 25,125,  8, 65, 20, 33,106,250,255, 57,  8,  0,  2,
/* 0x13d0 */ 125,  8,  1,148,124,234, 42, 20,125,  9,  3,166,141,103,  0,  1,
/* 0x13e0 */ 157,101,  0,  1, 67, 32,255,248, 56,224,  1,  0,124,  7, 41,236,
/* 0x13f0 */ 124,  7, 26, 44, 75,255,255, 12, 44,  7,  0,  5, 64,130,  1, 64,
/* 0x1400 */ 124,  0, 41,236,125,168,  2,166, 40,  7,  0,  5, 64,130,  1, 48,
/* 0x1410 */ 248,166,  0,  0,124,132, 26, 20, 60,  0,128,  0,120,  0,  7,198,
/* 0x1420 */  61, 32,128,  0,121, 41,  7,198, 56, 99,255,255, 56,165,255,255,
/* 0x1430 */  57, 64,255,255, 72,  0,  0,248, 57, 32,  0,  1,125, 41, 28, 44,
/* 0x1440 */  56, 99,  0,  4,125, 41, 73, 20,121, 41,248, 36,124, 41,  0, 64,
/* 0x1450 */ 125, 41, 72, 20, 78,128,  0, 32,141,  3,  0,  1,157,  5,  0,  1,
/* 0x1460 */ 124, 41,  0, 64,125, 41, 72, 20, 65,194,255,209, 65,225,255,236,
/* 0x1470 */  56,224,  0,  1, 72,  0,  0, 20, 56,231,255,255,125, 41, 72, 21,
/* 0x1480 */  65,194,255,185,124,231, 57, 21,125, 41, 72, 21, 65,194,255,173,
/* 0x1490 */ 124,231, 57, 21,124, 41,  0, 64,125, 41, 72, 20, 65,194,255,157,
/* 0x14a0 */  65,192,255,216, 57,  0,  0,  0, 52,231,255,253, 84,231, 64, 46,
/* 0x14b0 */  65,192,  0, 28,141, 99,  0,  1,124,234, 88,249,125, 74, 14,112,
/* 0x14c0 */  44, 42,  0,  0, 65,194,  0,  0, 72,  0,  0, 12,125, 41, 72, 21,
/* 0x14d0 */  65,194,255,105,125,  8, 65, 21,125, 41, 72, 21, 65,194,255, 93,
/* 0x14e0 */ 125,  8, 65, 21, 64,130,  0, 40, 57,  0,  0,  1,125, 41, 72, 21,
/* 0x14f0 */  65,194,255, 73,125,  8, 65, 21,124, 41,  0, 64,125, 41, 72, 20,
/* 0x1500 */  65,194,255, 57, 65,192,255,232, 57,  8,  0,  2, 32,234,250,255,
/* 0x1510 */  57,  8,  0,  1,125,  8,  1,148,124,234, 42, 20,125,  9,  3,166,
/* 0x1520 */ 141,  7,  0,  1,157,  5,  0,  1, 67, 32,255,248, 56,224,  1,  0,
/* 0x1530 */ 124,  7, 41,236,124,  7, 26, 44, 75,255,255, 40, 44,  7,  0,  2,
/* 0x1540 */  64,130,  0,252,124,  0, 41,236,125,168,  2,166, 40,  7,  0,  2,
/* 0x1550 */  64,130,  0,236,248,166,  0,  0,124,132, 26, 20, 60,  0,128,  0,
/* 0x1560 */ 120,  0,  7,198,124,  9,  3,120, 56, 99,255,255, 56,165,255,255,
/* 0x1570 */  57, 64,255,255, 72,  0,  0,184,125, 41, 73, 20,121, 41,248, 36,
/* 0x1580 */ 124, 41,  0, 64,125, 41, 72, 20, 76,226,  0, 32, 57, 32,  0,  1,
/* 0x1590 */ 125, 41, 28, 44, 56, 99,  0,  4, 75,255,255,224,141,  3,  0,  1,
/* 0x15a0 */ 157,  5,  0,  1, 75,255,255,221, 65,225,255,244, 56,224,  0,  1,
/* 0x15b0 */  75,255,255,209,124,231, 57, 21, 75,255,255,201, 65,192,255,244,
/* 0x15c0 */  52,231,255,253, 57,  0,  0,  0, 65,192,  0, 24,141, 99,  0,  1,
/* 0x15d0 */  84,231, 64, 46,124,234, 88,248, 85, 75,  0, 63, 65,194,  0,  0,
/* 0x15e0 */  75,255,255,161,125,  8, 65, 21, 75,255,255,153,125,  8, 65, 21,
/* 0x15f0 */  56,224,  0,  1, 64,194,  0, 28, 56,224,  0,  3, 57,  0,  0,  1,
/* 0x1600 */  75,255,255,129,125,  8, 65, 21, 75,255,255,121, 65,192,255,244,
/* 0x1610 */  33,106,242,255,125,  8, 57, 20,124,234, 42, 20,125,  9,  3,166,
/* 0x1620 */ 141,  7,  0,  1,157,  5,  0,  1, 67, 32,255,248, 56,224,  1,  0,
/* 0x1630 */ 124,  7, 41,236,124,  7, 26, 44, 75,255,255,108, 44,  7,  0, 14,
/* 0x1640 */  64,130,  0,  0,124, 42, 11,120, 57, 38,  0,  4,129,  6,  0,  4,
/* 0x1650 */ 124,167, 43,120, 56,164,255,254, 56,131,  0,  2,137,131,  0,  0,
/* 0x1660 */ 121,139,232,194,121,140,  7, 96, 56, 96,250,  0,124, 99, 88, 54,
/* 0x1670 */  56, 99,241,100,124, 33, 26, 20,120, 33,  6,100, 56,  0,  0,  0,
/* 0x1680 */ 125, 67, 83,120,144,  9,  0,  0,248,  3,255,249,124, 33, 24, 64,
/* 0x1690 */  65,128,255,248,136,  4,255,255, 56,193,  0, 36, 56, 97,  0, 40,
/* 0x16a0 */ 153,131,  0,  2,248,225,  0, 16,249, 33,  0, 24,120, 11,225,  2,
/* 0x16b0 */ 120,  0,  7, 32,153, 99,  0,  1,152,  3,  0,  0,249, 65,255,145,
/* 0x16c0 */ 124,  8,  2,166,248,  1,  0, 16, 72,  0,  0, 21,232,  1,  0, 16,
/* 0x16d0 */ 232, 33,  0,  0,124,  8,  3,166, 78,128,  0, 32, 56, 33,  0,112,
/* 0x16e0 */ 232,161,  0, 24,232,225,  0, 16,128,165,  0,  0,232, 33,  0,  0,
/* 0x16f0 */ 124,165, 58, 20,232,  1,  0, 16, 56,165,255,255,124,  8,  3,166,
/* 0x1700 */ 232, 33,  0,  0, 78,128,  0, 32, 78,128,  0, 32,124,  8,  2,166,
/* 0x1710 */  57, 64,  0,  1, 72,  0,  0,  1, 59, 99,  0,  4, 59,227,  0,  2,
/* 0x1720 */  56,  0,  4,  0,137, 99,  0,  2,125, 75, 88, 48, 57,107,255,255,
/* 0x1730 */ 121,107,  0, 32,249, 97,255, 96,137, 99,  0,  1,125, 74, 88, 48,
/* 0x1740 */  57, 96,  0,  0, 57, 74,255,255,121, 74,  0, 32,249, 65,255,104,
/* 0x1750 */ 137, 67,  0,  0,145,102,  0,  0,145,105,  0,  0,125, 85,  7,180,
/* 0x1760 */ 137, 99,  0,  1,125, 75, 82, 20, 57, 96,  3,  0,125,106, 80, 48,
/* 0x1770 */  57, 74,  7, 54,121, 74,  0, 32, 47,138,  0,  0, 57,106,  0,  1,
/* 0x1780 */  64,254,  0,  8, 57, 96,  0,  1, 53,107,255,255, 65,130,  0, 12,
/* 0x1790 */ 180, 31,  0,  2, 75,255,255,244, 56,  0,  0,  5,124,164, 42, 20,
/* 0x17a0 */ 124,  9,  3,166, 57,100,  0,  5,124,159, 35,120, 57, 64,  0,  0,
/* 0x17b0 */ 127,191, 40, 64, 64,158,  0, 12, 56, 96,  0,  1, 72,  0, 10, 88,
/* 0x17c0 */  59,255,  0,  1,136, 31,255,255, 85, 74, 64, 46,124, 10, 83,120,
/* 0x17d0 */ 121, 74,  0, 32, 66,  0,255,220, 56,  0,255,255, 63, 32,  0,255,
/* 0x17e0 */ 120,  0,  0, 32, 58,192,  0,  1, 59,  0,  0,  1, 58,224,  0,  1,
/* 0x17f0 */  58, 64,  0,  1, 57,128,  0,  0, 59,192,  0,  0, 59, 64,  0,  0,
/* 0x1800 */  99, 57,255,255, 58,128,  0,  1, 34,117,  0,  8,127,154, 64, 64,
/* 0x1810 */  64,156,  9,216,235,161,255, 96,127,128,200, 64,127, 95,232, 56,
/* 0x1820 */  85,157, 32, 54,127,252,  7,180,127,189,  7,180,127,188,234, 20,
/* 0x1830 */ 123,189, 15,164, 65,157,  0, 36,127,171, 40, 64, 65,158,255,124,
/* 0x1840 */ 139,139,  0,  0, 85, 74, 64, 46,120,  0, 64, 40, 57,107,  0,  1,
/* 0x1850 */ 127,138, 83,120,121, 74,  0, 32,125,251,234, 46, 84, 16,170,254,
/* 0x1860 */ 126, 16,121,214,127,138,128, 64,122, 28,  0, 32, 64,156,  1,228,
/* 0x1870 */  32, 15,  8,  0,235,225,255,104,127,222,158, 48,124,  0, 46,112,
/* 0x1880 */ 125,224,122, 20,127, 64,248, 56,125,251,235, 46,124, 29,168, 48,
/* 0x1890 */  47,140,  0,  6,127,190,234, 20, 31,189,  3,  0,123,189,  0, 32,
/* 0x18a0 */  59,189,  7, 54,123,189, 15,164,127,187,234, 20, 65,157,  0, 16,
/* 0x18b0 */  59,192,  0,  1,127,128,227,120, 72,  0,  1, 12,124, 18,208, 80,
/* 0x18c0 */  59,192,  0,  1,120,  0,  0, 32,125,231,  0,174, 85,255,  8, 60,
/* 0x18d0 */ 127,239,  7,180, 87,255,  5,238,127,156,200, 64,127,255,  7,180,
/* 0x18e0 */  58, 63,  1,  0,126, 49,242, 20,122, 49, 15,164, 65,157,  0, 36,
/* 0x18f0 */ 127,171, 40, 64, 65,158,254,196,136, 11,  0,  0, 85, 74, 64, 46,
/* 0x1900 */ 123,156, 64, 40, 57,107,  0,  1,124, 10, 83,120,121, 74,  0, 32,
/* 0x1910 */ 126, 29,138, 46, 87,128,170,254, 87,222,  8, 60,124,  0,129,214,
/* 0x1920 */ 127, 10,  0, 64,120, 14,  0, 32, 47,191,  0,  0, 64,152,  0, 36,
/* 0x1930 */  32, 16,  8,  0,127,222,  7,180,124,  0, 46,112,126,  0,130, 20,
/* 0x1940 */ 125,220,115,120,126, 29,139, 46, 65,158,  0, 48, 75,255,255,104,
/* 0x1950 */ 127,128,224, 80,125, 64, 80, 80, 86,  0,217,126,126,  0,128, 80,
/* 0x1960 */  59,222,  0,  1,123,156,  0, 32,121, 74,  0, 32,126, 29,139, 46,
/* 0x1970 */ 127,222,  7,180, 65,158,255, 64, 47,158,  0,255, 64,157,255, 80,
/* 0x1980 */  75,255,255, 52,127,128,200, 64,123,208, 15,164, 64,157,  0, 68,
/* 0x1990 */ 127,157,130, 46, 84, 31,170,254, 87,222,  8, 60,127,255,225,214,
/* 0x19a0 */ 127,138,248, 64,123,241,  0, 32, 64,156,  0, 76, 32, 28,  8,  0,
/* 0x19b0 */ 127,222,  7,180,124,  0, 46,112,127,128,226, 20,127,157,131, 46,
/* 0x19c0 */ 126, 32,139,120, 47,158,  0,255, 64,157,255,188, 72,  0,  0, 80,
/* 0x19d0 */ 127,171, 40, 64, 65,158,253,228,139,235,  0,  0, 85, 74, 64, 46,
/* 0x19e0 */ 120,  0, 64, 40, 57,107,  0,  1,127,234, 83,120,121, 74,  0, 32,
/* 0x19f0 */  75,255,255,160,124, 31,  0, 80,125, 95, 80, 80, 87,159,217,126,
/* 0x1a00 */ 127,159,224, 80, 59,222,  0,  1,121, 74,  0, 32,127,157,131, 46,
/* 0x1a10 */ 127,222,  7,180,120, 17,  0, 32, 75,255,255,168,123,222,  6, 32,
/* 0x1a20 */  59,250,  0,  1, 47,140,  0,  3,123,255,  0, 32,127,199,209,174,
/* 0x1a30 */  64,157,  7,172, 47,140,  0,  9, 65,157,  0, 12, 57,140,255,253,
/* 0x1a40 */  72,  0,  0,  8, 57,140,255,250,125,140,  7,180, 72,  0,  7,148,
/* 0x1a50 */ 124, 16,  0, 80, 85,254,217,126,126, 16, 80, 80,125,254,120, 80,
/* 0x1a60 */  59,140,  0,192,127,128,200, 64,125,251,235, 46,120, 17,  0, 32,
/* 0x1a70 */ 122, 10,  0, 32,123,156, 15,164, 65,157,  0, 36,127,171, 40, 64,
/* 0x1a80 */  65,158,253, 56,137, 75,  0,  0, 86, 16, 64, 46,120, 17, 64, 40,
/* 0x1a90 */  57,107,  0,  1,125, 74,131,120,121, 74,  0, 32,126, 27,226, 46,
/* 0x1aa0 */  86, 32,170,254,124,  0,129,214,127,138,  0, 64,120, 30,  0, 32,
/* 0x1ab0 */  64,156,  0, 68, 47,140,  0,  7, 32, 16,  8,  0,125,144, 16, 38,
/* 0x1ac0 */  85,140,239,254,124,  0, 46,112,126,  0,130, 20,127, 22,195,120,
/* 0x1ad0 */ 125,140,  0,208,126,248,187,120,126, 27,227, 46,121,140,240, 66,
/* 0x1ae0 */  59,163,  6,104,121,140, 16,  0,126, 87,147,120, 57,140,  0,  3,
/* 0x1af0 */  72,  0,  2,124,127,192,136, 80, 86, 15,217,126,126, 15,128, 80,
/* 0x1b00 */ 124,  0, 80, 80,127,158,200, 64,126, 27,227, 46,123,209,  0, 32,
/* 0x1b10 */ 120, 10,  0, 32, 58, 28,  0, 24, 65,157,  0, 36,127,171, 40, 64,
/* 0x1b20 */  65,158,252,152,137, 75,  0,  0, 84,  0, 64, 46,123,209, 64, 40,
/* 0x1b30 */  57,107,  0,  1,125, 74,  3,120,121, 74,  0, 32,125,251,130, 46,
/* 0x1b40 */  86, 32,170,254,124,  0,121,214,127,138,  0, 64,120, 30,  0, 32,
/* 0x1b50 */  64,156,  0,208, 35,143,  8,  0,127,128,200, 64,127,156, 46,112,
/* 0x1b60 */ 125,252,122, 20, 59,189,  1,224,125,251,131, 46, 65,157,  0, 36,
/* 0x1b70 */ 127,171, 40, 64, 65,158,252, 68,120, 30, 64, 40,136, 11,  0,  0,
/* 0x1b80 */  85, 74, 64, 46, 57,107,  0,  1,124, 10, 83,120,121, 74,  0, 32,
/* 0x1b90 */ 126, 59,234, 46, 87,220,170,254,127,156,137,214,127,138,224, 64,
/* 0x1ba0 */ 123,128,  0, 32, 64,156,  0, 80, 35,241,  8,  0, 47,186,  0,  0,
/* 0x1bb0 */ 127,255, 46,112,126, 63,138, 20,126, 59,235, 46, 65,158,251,252,
/* 0x1bc0 */  47,140,  0,  7,127,242,208, 80,125,144, 16, 38, 85,140,239,254,
/* 0x1bd0 */ 123,255,  0, 32,125,140,  0,208,127,199,248,174,121,140,  7,164,
/* 0x1be0 */  59,250,  0,  1, 57,140,  0, 11,123,255,  0, 32,127,199,209,174,
/* 0x1bf0 */  72,  0,  5,240, 86, 32,217,126,124,  0,136, 80,127,220,240, 80,
/* 0x1c00 */ 125, 92, 80, 80,124, 27,235, 46,123,222,  0, 32,127,  0,195,120,
/* 0x1c10 */ 121, 74,  0, 32,126, 88,147,120,126,242,187,120, 72,  0,  0,124,
/* 0x1c20 */ 126, 32,136, 80, 85,254,217,126,124,  0, 80, 80,125,254,120, 80,
/* 0x1c30 */ 127,145,200, 64,125,251,131, 46,122, 61,  0, 32,120, 10,  0, 32,
/* 0x1c40 */  58, 28,  0, 48, 65,157,  0, 36,127,171, 40, 64, 65,158,251,108,
/* 0x1c50 */ 137, 75,  0,  0, 84,  0, 64, 46,122, 61, 64, 40, 57,107,  0,  1,
/* 0x1c60 */ 125, 74,  3,120,121, 74,  0, 32,126, 59,130, 46, 87,160,170,254,
/* 0x1c70 */ 124,  0,137,214,127,138,  0, 64,120, 30,  0, 32, 64,156,  0, 36,
/* 0x1c80 */  32, 17,  8,  0,124,  0, 46,112,126, 32,138, 20,127,  0,195,120,
/* 0x1c90 */ 126, 59,131, 46,126,248,187,120,124, 23,  3,120, 72,  0,  0,160,
/* 0x1ca0 */ 127,160,232, 80, 86, 62,217,126,124,  0, 80, 80,126, 62,136, 80,
/* 0x1cb0 */ 127,157,200, 64,123,175,  0, 32,126, 59,131, 46,120, 10,  0, 32,
/* 0x1cc0 */  59,156,  0, 72, 65,157,  0, 36,127,171, 40, 64, 65,158,250,236,
/* 0x1cd0 */ 137, 75,  0,  0, 84,  0, 64, 46,123,175, 64, 40, 57,107,  0,  1,
/* 0x1ce0 */ 125, 74,  3,120,121, 74,  0, 32,127,187,226, 46, 85,224,170,254,
/* 0x1cf0 */ 124,  0,233,214,127,138,  0, 64,120, 30,  0, 32, 64,156,  0, 24,
/* 0x1d00 */  32, 29,  8,  0,124,  0, 46,112,124,  0,234, 20,124, 27,227, 46,
/* 0x1d10 */  72,  0,  0, 44,127,192,120, 80,125, 64, 80, 80, 87,160,217,126,
/* 0x1d20 */ 124,  0,232, 80,121, 74,  0, 32,124, 27,227, 46,127,  0,195,120,
/* 0x1d30 */ 123,222,  0, 32,126,216,179,120,124, 22,  3,120, 47,140,  0,  7,
/* 0x1d40 */ 126, 64,147,120,125,144, 16, 38, 85,140,239,254,127, 18,195,120,
/* 0x1d50 */  59,163, 10,108,126,248,187,120,124, 23,  3,120,125,140,  0,208,
/* 0x1d60 */ 121,140,240, 66,121,140, 16,  0, 57,140,  0, 11,127,158,200, 64,
/* 0x1d70 */  65,157,  0, 36,127,171, 40, 64, 65,158,250, 64,136, 11,  0,  0,
/* 0x1d80 */  85, 74, 64, 46,123,222, 64, 40, 57,107,  0,  1,124, 10, 83,120,
/* 0x1d90 */ 121, 74,  0, 32,161,253,  0,  0, 87,220,170,254,127,156,121,214,
/* 0x1da0 */ 127,138,224, 64,123,128,  0, 32, 64,156,  0, 48, 87,255, 24, 56,
/* 0x1db0 */  34, 47,  8,  0,127,255,  7,180,126, 49, 46,112, 59,255,  0,  2,
/* 0x1dc0 */ 126, 49,122, 20,123,255, 15,164,178, 61,  0,  0, 58,  0,  0,  0,
/* 0x1dd0 */ 127,189,250, 20, 72,  0,  0,136,127,220,240, 80, 85,241,217,126,
/* 0x1de0 */ 127,156, 80, 80,126, 49,120, 80,127,158,200, 64,123,208,  0, 32,
/* 0x1df0 */ 178, 61,  0,  0,123,138,  0, 32, 65,157,  0, 36,127,171, 40, 64,
/* 0x1e00 */  65,158,249,184,137, 75,  0,  0, 87,156, 64, 46,123,208, 64, 40,
/* 0x1e10 */  57,107,  0,  1,125, 74,227,120,121, 74,  0, 32,163,157,  0,  2,
/* 0x1e20 */  86, 30,170,254,127,222,225,214,127,138,240, 64,123,192,  0, 32,
/* 0x1e30 */  64,156,  0, 52, 87,255, 24, 56, 35,220,  8,  0,127,255,  7,180,
/* 0x1e40 */ 127,222, 46,112, 59,255,  0,130,127,158,226, 20,123,255, 15,164,
/* 0x1e50 */ 179,157,  0,  2, 58,  0,  0,  8,127,189,250, 20, 58, 32,  0,  3,
/* 0x1e60 */  72,  0,  0, 44, 87,159,217,126,124, 30,128, 80,125, 94, 80, 80,
/* 0x1e70 */ 127,255,224, 80,121, 74,  0, 32,179,253,  0,  2,120,  0,  0, 32,
/* 0x1e80 */  59,189,  2,  4, 58,  0,  0, 16, 58, 32,  0,  8, 59,241,255,255,
/* 0x1e90 */  59,192,  0,  1,123,255,  0, 32, 59,255,  0,  1,127,233,  3,166,
/* 0x1ea0 */ 123,220, 15,164,127,128,200, 64,127,157,226, 20, 65,157,  0, 36,
/* 0x1eb0 */ 127,171, 40, 64, 65,158,249,  4,139,235,  0,  0, 85, 74, 64, 46,
/* 0x1ec0 */ 120,  0, 64, 40, 57,107,  0,  1,127,234, 83,120,121, 74,  0, 32,
/* 0x1ed0 */ 161,252,  0,  0, 84, 31,170,254, 87,222,  8, 60,127,255,121,214,
/* 0x1ee0 */ 127,138,248, 64,123,238,  0, 32, 64,156,  0, 32, 32, 15,  8,  0,
/* 0x1ef0 */ 127,222,  7,180,124,  0, 46,112,125,224,122, 20,125,192,115,120,
/* 0x1f00 */ 177,252,  0,  0, 72,  0,  0, 40,124, 31,  0, 80,125, 95, 80, 80,
/* 0x1f10 */  85,255,217,126,125,255,120, 80, 59,222,  0,  1,177,252,  0,  0,
/* 0x1f20 */ 120,  0,  0, 32,121, 74,  0, 32,127,222,  7,180, 66,  0,255,116,
/* 0x1f30 */ 126,145,136, 48, 47,140,  0,  3,126, 49,128, 80,127,145,242, 20,
/* 0x1f40 */  65,157,  2, 80, 47,156,  0,  3,127,158,227,120, 64,157,  0,  8,
/* 0x1f50 */  59,192,  0,  3, 87,222, 48, 50,127,222,  7,180, 59,160,  0,  6,
/* 0x1f60 */  59,222,  1,176,127,169,  3,166,123,222, 15,164, 59,224,  0,  1,
/* 0x1f70 */ 123,241, 15,164,127,128,200, 64,126, 49,242, 20, 65,157,  0, 36,
/* 0x1f80 */ 127,171, 40, 64, 65,158,248, 52,139,171,  0,  0, 85, 74, 64, 46,
/* 0x1f90 */ 120,  0, 64, 40, 57,107,  0,  1,127,170, 83,120,121, 74,  0, 32,
/* 0x1fa0 */ 126, 91,138, 46, 84, 29,170,254, 87,255,  8, 60,127,189,145,214,
/* 0x1fb0 */ 127,138,232, 64,123,176,  0, 32, 64,156,  0, 32, 32, 18,  8,  0,
/* 0x1fc0 */ 127,255,  7,180,124,  0, 46,112,126, 64,146, 20,126,  0,131,120,
/* 0x1fd0 */ 126, 91,139, 46, 72,  0,  0, 40,124, 29,  0, 80,125, 93, 80, 80,
/* 0x1fe0 */  86, 93,217,126,126, 93,144, 80, 59,255,  0,  1,126, 91,139, 46,
/* 0x1ff0 */ 120,  0,  0, 32,121, 74,  0, 32,127,255,  7,180, 66,  0,255,116,
/* 0x2000 */  59,255,255,192, 47,159,  0,  3,127,242,  7,180, 64,157,  1,108,
/* 0x2010 */  87,241,  7,254, 47,159,  0, 13, 98, 49,  0,  2,127,254, 14,112,
/* 0x2020 */ 122, 61,  0, 32, 65,157,  0, 40, 59,254,255,255, 35,210,  2,176,
/* 0x2030 */ 127,253,  7,180,126, 63,248, 48,127,222,250, 20,123,222, 15,164,
/* 0x2040 */  59,222,255,254,127,219,242, 20, 72,  0,  0,116, 59,222,255,250,
/* 0x2050 */ 123,222,  0, 32, 59,222,  0,  1,127,201,  3,166,127,128,200, 64,
/* 0x2060 */  65,157,  0, 36,127,171, 40, 64, 65,158,247, 80,139,235,  0,  0,
/* 0x2070 */  85, 74, 64, 46,120,  0, 64, 40, 57,107,  0,  1,127,234, 83,120,
/* 0x2080 */ 121, 74,  0, 32, 84, 30,248,126, 87,191,  8, 60,127,138,240, 64,
/* 0x2090 */ 123,192,  0, 32,123,253,  0, 32, 65,156,  0, 20,125, 94, 80, 80,
/* 0x20a0 */  99,255,  0,  1,121, 74,  0, 32,123,253,  0, 32, 66,  0,255,176,
/* 0x20b0 */ 123,191, 32, 40, 59,195,  6, 72, 59,160,  0,  4, 59,189,255,255,
/* 0x20c0 */  58, 64,  0,  1,123,189,  0, 32, 58, 32,  0,  1, 59,189,  0,  1,
/* 0x20d0 */ 127,169,  3,166,122, 80, 15,164,127,128,200, 64,126, 30,130, 20,
/* 0x20e0 */  65,157,  0, 36,127,171, 40, 64, 65,158,246,208,139,171,  0,  0,
/* 0x20f0 */  85, 74, 64, 46,120,  0, 64, 40, 57,107,  0,  1,127,170, 83,120,
/* 0x2100 */ 121, 74,  0, 32,161,240,  0,  0, 84, 29,170,254, 86, 82,  8, 60,
/* 0x2110 */ 127,189,121,214,127,138,232, 64,123,174,  0, 32, 64,156,  0, 32,
/* 0x2120 */  32, 15,  8,  0,126, 82,  7,180,124,  0, 46,112,125,224,122, 20,
/* 0x2130 */ 125,192,115,120,177,240,  0,  0, 72,  0,  0, 48,124, 29,  0, 80,
/* 0x2140 */ 125, 93, 80, 80, 85,253,217,126,125,253,120, 80, 58, 82,  0,  1,
/* 0x2150 */ 177,240,  0,  0,126, 63,251,120,120,  0,  0, 32,121, 74,  0, 32,
/* 0x2160 */ 126, 82,  7,180,123,255,  0, 32, 86, 49,  8, 60,126, 49,  7,180,
/* 0x2170 */  66,  0,255,100, 72,  0,  0,  8,123,255,  0, 32, 59,255,  0,  1,
/* 0x2180 */ 123,242,  0, 33, 65,130,  0,100, 57,140,  0,  7,125,140,  7,180,
/* 0x2190 */  59,220,  0,  2,127,146,208, 64,127,222,  7,180, 65,157,246, 28,
/* 0x21a0 */  59,222,255,255,123,222,  0, 32, 59,222,  0,  1,127,201,  3,166,
/* 0x21b0 */ 127,242,208, 80, 59,186,  0,  1,123,255,  0, 32,127,199,248,174,
/* 0x21c0 */ 123,191,  0, 32,127,199,209,174, 66, 64,  0, 24,127,157, 64, 64,
/* 0x21d0 */ 127,250,251,120, 65,156,255,220, 72,  0,  0,  8, 57,128,  0,  0,
/* 0x21e0 */ 127,250,251,120, 75,255,246, 40, 61, 64,  0,255, 97, 74,255,255,
/* 0x21f0 */ 127,128, 80, 64, 65,157,  0, 16,127,171, 40, 64, 65,158,245,188,
/* 0x2200 */  57,107,  0,  1,124,132, 88, 80, 56, 96,  0,  0,144,134,  0,  0,
/* 0x2210 */ 147, 73,  0,  0, 72,  0,  0,  0,249,193,255,112,249,225,255,120,
/* 0x2220 */ 250,  1,255,128,250, 33,255,136,250, 65,255,144,250, 97,255,152,
/* 0x2230 */ 250,129,255,160,250,161,255,168,250,193,255,176,250,225,255,184,
/* 0x2240 */ 251,  1,255,192,251, 33,255,200,251, 65,255,208,251, 97,255,216,
/* 0x2250 */ 251,129,255,224,251,161,255,232,251,193,255,240,251,225,255,248,
/* 0x2260 */ 248,  1,  0, 16, 78,128,  0, 32,233,193,255,112,233,225,255,120,
/* 0x2270 */ 234,  1,255,128,234, 33,255,136,234, 65,255,144,234, 97,255,152,
/* 0x2280 */ 234,129,255,160,234,161,255,168,234,193,255,176,234,225,255,184,
/* 0x2290 */ 235,  1,255,192,235, 33,255,200,235, 65,255,208,235, 97,255,216,
/* 0x22a0 */ 235,129,255,224,232,  1,  0, 16,235,161,255,232,124,  8,  3,166,
/* 0x22b0 */ 235,193,255,240,235,225,255,248, 78,128,  0, 32,  0,  0,  0,  0,
/* 0x22c0 */   0,  0,  0,  1,249,225,255,120,249,193,255,112, 56,  0,  0,  0,
/* 0x22d0 */  57, 96,  0,  1,250, 97,255,152,250, 65,255,144, 58, 99,  0,  4,
/* 0x22e0 */ 251,225,255,248,251,193,255,240, 59,227,  0,  2,250,  1,255,128,
/* 0x22f0 */ 250, 33,255,136,250,129,255,160,250,161,255,168,250,193,255,176,
/* 0x2300 */ 250,225,255,184,251,  1,255,192,251, 33,255,200,251, 65,255,208,
/* 0x2310 */ 251, 97,255,216,251,129,255,224,251,161,255,232,137, 67,  0,  0,
/* 0x2320 */ 138, 67,  0,  1,138, 35,  0,  2,144,  6,  0,  0,144,  9,  0,  0,
/* 0x2330 */ 125, 79,  7,180,125,113,136, 48,125,107,144, 48, 58, 49,255,255,
/* 0x2340 */  57,107,255,255,122, 49,  0, 32,121,114,  0, 32,137, 99,  0,  1,
/* 0x2350 */ 125,107, 82, 20, 57, 64,  3,  0,125, 74, 88, 48, 57, 74,  7, 54,
/* 0x2360 */ 121, 75,  0, 33, 65,130,  0, 40, 57, 75,255,255, 57, 96,  4,  0,
/* 0x2370 */ 121, 74,  0, 32, 57, 74,  0,  1,125, 73,  3,166, 96,  0,  0,  0,
/* 0x2380 */  96,  0,  0,  0,181,127,  0,  2, 66,  0,255,252,124,164, 42, 20,
/* 0x2390 */ 127,164, 40, 64, 65,158,  2,240, 59,224,  0,  4,137, 68,  0,  0,
/* 0x23a0 */  57,100,  0,  1,127,233,  3,166, 57,132,  0,  5,127,171, 40, 64,
/* 0x23b0 */  85, 74, 64, 46, 57,107,  0,  1, 65,158,  2,204,136, 11,255,255,
/* 0x23c0 */ 124, 10, 83,120,121, 74,  0, 32, 66,  0,255,228, 47,168,  0,  0,
/* 0x23d0 */  65,158, 11, 80, 56,  0,  0,  1, 57, 96,  0,  1,248,  1,255, 96,
/* 0x23e0 */ 249, 97,255, 88, 32, 15,  0,  8, 59,224,255,255,144,  1,255, 84,
/* 0x23f0 */  63, 32,  0,255,123,255,  0, 32, 57,192,  0,  1, 58,  0,  0,  1,
/* 0x2400 */  58,160,  0,  0, 57, 96,  0,  0, 58,192,  0,  0, 99, 57,255,255,
/* 0x2410 */ 126,221,136, 56, 86,160, 32, 54,127,190,  7,180,124,  0,  7,180,
/* 0x2420 */ 127,222,  2, 20,127,159,200, 64,123,222, 15,164, 65,157,  0, 36,
/* 0x2430 */ 127,172, 40, 64, 65,158,  2, 80,136, 12,  0,  0, 85, 74, 64, 46,
/* 0x2440 */ 123,255, 64, 40, 57,140,  0,  1,124, 10, 83,120,121, 74,  0, 32,
/* 0x2450 */ 127,147,242, 46, 87,251,170,254,127,123,225,214,127,138,216, 64,
/* 0x2460 */ 123, 96,  0, 32, 64,156,  2,112,131,225,255, 84,126,221,144, 56,
/* 0x2470 */  47,149,  0,  6,127,189,120, 48,125,107,254, 48, 35,252,  8,  0,
/* 0x2480 */ 127,255, 46,112,127,255,226, 20,125,107,234, 20,127,243,243, 46,
/* 0x2490 */  85,125, 64, 46, 85,107, 80, 42,127,189, 88, 80, 57, 96,  0,  1,
/* 0x24a0 */ 123,189,  0, 32, 59,189,  7, 54,123,189, 15,164,127,179,234, 20,
/* 0x24b0 */  64,157,  1, 40,127,240,176, 80, 57, 96,  0,  1,123,255,  0, 32,
/* 0x24c0 */ 127, 71,248,174, 72,  0,  0, 40, 96,  0,  0,  0, 96,  0,  0,  0,
/* 0x24d0 */  96,  0,  0,  0,127,125,243, 46,125,107,  7,180,127,224,251,120,
/* 0x24e0 */  64,130,  0,172, 47,139,  0,255, 65,157,  0,172, 87, 90,  8, 60,
/* 0x24f0 */  87, 95,  5,238, 85,120,  8, 60,127,255,  7,180, 59,223,  1,  0,
/* 0x2500 */  44, 63,  0,  0,127,222, 90, 20,127,  0,200, 64, 79,128,  0,  0,
/* 0x2510 */ 127, 11,195,120,124,172, 40, 64, 59, 24,  0,  1, 85, 95, 64, 46,
/* 0x2520 */ 123,222, 15,164,127, 90,  7,180, 65,153,  0, 28, 65,134,  1, 88,
/* 0x2530 */ 137, 76,  0,  0,120,  0, 64, 40, 57,140,  0,  1,125, 74,251,120,
/* 0x2540 */ 121, 74,  0, 32,127,157,242, 46, 84, 27,170,254,127,251,225,214,
/* 0x2550 */  35,124,  8,  0, 87,151,217,126,127,123, 46,112,127, 10,248, 64,
/* 0x2560 */ 127,123,226, 20,124, 31,  0, 80,126,159, 80, 80,127,151,224, 80,
/* 0x2570 */ 123,255,  0, 32, 65,152,255, 96,127,157,243, 46,127, 11,  7,180,
/* 0x2580 */ 120,  0,  0, 32,122,138,  0, 32, 64,158,255, 92, 47,139,  0,255,
/* 0x2590 */  64,253,  0, 72,121,107,  6, 32, 59,214,  0,  1,125,103,177,174,
/* 0x25a0 */ 124, 31,  3,120,123,214,  0, 32, 47,149,  0,  9, 65,157,  8,104,
/* 0x25b0 */  58,181,255,253,126,181,  7,180, 72,  0,  6, 84, 96,  0,  0,  0,
/* 0x25c0 */  96,  0,  0,  0,127,107,  7,180, 47,139,  0,255,127,221,227, 46,
/* 0x25d0 */ 127, 64,211,120, 65,157,  0,136, 85,123,  8, 60,127,128,200, 64,
/* 0x25e0 */ 127, 44, 40, 64,127,120,219,120, 85, 95, 64, 46,121,124, 15,164,
/* 0x25f0 */  65,157,  0, 28, 65,154,  0,144,137, 76,  0,  0,120,  0, 64, 40,
/* 0x2600 */  57,140,  0,  1,125, 74,251,120,121, 74,  0, 32,127, 93,226, 46,
/* 0x2610 */  84, 31,170,254, 57,120,  0,  1,127,255,209,214, 35,218,  8,  0,
/* 0x2620 */  87, 88,217,126,127,222, 46,112,127,138,248, 64,127, 24,208, 80,
/* 0x2630 */ 127,222,210, 20,123,250,  0, 32, 65,156,255,140,125,107,  7,180,
/* 0x2640 */ 124, 31,  0, 80,125, 95, 80, 80,127, 29,227, 46, 47,139,  0,255,
/* 0x2650 */ 120,  0,  0, 32,121, 74,  0, 32, 64,157,255,128, 59,214,  0,  1,
/* 0x2660 */ 121,107,  6, 32,123,222,  0, 32, 47,149,  0,  3,125,103,177,174,
/* 0x2670 */ 124, 31,  3,120,127,214,243,120, 65,157,255, 48, 58,160,  0,  0,
/* 0x2680 */  72,  0,  5,140, 56, 96,  0,  1,233,193,255,112,233,225,255,120,
/* 0x2690 */ 234,  1,255,128,234, 33,255,136,234, 65,255,144,234, 97,255,152,
/* 0x26a0 */ 234,129,255,160,234,161,255,168,234,193,255,176,234,225,255,184,
/* 0x26b0 */ 235,  1,255,192,235, 33,255,200,235, 65,255,208,235, 97,255,216,
/* 0x26c0 */ 235,129,255,224,235,161,255,232,235,193,255,240,235,225,255,248,
/* 0x26d0 */  78,128,  0, 32,124, 27,248, 80, 87,159,217,126,127,123, 80, 80,
/* 0x26e0 */ 127,255,224, 80, 57,117,  0,192,127,128,200, 64,127,243,243, 46,
/* 0x26f0 */ 120, 26,  0, 32,123,106,  0, 32,121,107, 15,164, 65,157,  0, 36,
/* 0x2700 */ 127,172, 40, 64, 65,158,255,128,137, 76,  0,  0, 87,123, 64, 46,
/* 0x2710 */ 120, 26, 64, 40, 57,140,  0,  1,125, 74,219,120,121, 74,  0, 32,
/* 0x2720 */ 127,115, 90, 46, 87, 64,170,254,124,  0,217,214,127,138,  0, 64,
/* 0x2730 */ 120, 28,  0, 32, 64,156,  3, 16, 32, 27,  8,  0,250,  1,255,104,
/* 0x2740 */  47,149,  0,  7,124,  0, 46,112,127, 96,218, 20, 59,  3,  6,104,
/* 0x2750 */ 127,115, 91, 46,126,176, 16, 38, 86,181,239,254,126,181,  0,208,
/* 0x2760 */ 122,181,240, 66,122,181, 16,  0, 58,181,  0,  3,127,156,200, 64,
/* 0x2770 */  65,157,  0, 36,127,172, 40, 64, 65,158,255, 12,137,108,  0,  0,
/* 0x2780 */  85, 74, 64, 46,123,156, 64, 40, 57,140,  0,  1,125,106, 83,120,
/* 0x2790 */ 121, 74,  0, 32,160, 24,  0,  0, 87,139,170,254,125,107,  1,214,
/* 0x27a0 */ 127,138, 88, 64,121,127,  0, 32, 64,156,  4,156, 87,171, 24, 56,
/* 0x27b0 */  35,192,  8,  0,125,107,  7,180,127,222, 46,112, 57,107,  0,  2,
/* 0x27c0 */ 124, 30,  2, 20,121,107, 15,164,176, 24,  0,  0, 58,128,  0,  0,
/* 0x27d0 */ 127, 24, 90, 20, 58,224,  0,  3, 57,119,255,255, 56,  0,  0,  1,
/* 0x27e0 */ 121,107,  0, 32, 57,107,  0,  1,125,105,  3,166, 96,  0,  0,  0,
/* 0x27f0 */  96,  0,  0,  0,120, 28, 15,164, 84, 26,  8, 60,127,159,200, 64,
/* 0x2800 */ 127, 44, 40, 64,127, 93,211,120, 85, 75, 64, 46,127,152,226, 20,
/* 0x2810 */  65,157,  0, 28, 65,154,254,112,137, 76,  0,  0,123,255, 64, 40,
/* 0x2820 */  57,140,  0,  1,125, 74, 91,120,121, 74,  0, 32,163,220,  0,  0,
/* 0x2830 */  87,235,170,254, 56, 29,  0,  1,125,107,241,214, 35,190,  8,  0,
/* 0x2840 */  87,219,217,126,127,189, 46,112,127,138, 88, 64,127,123,240, 80,
/* 0x2850 */ 127,221,242, 20,121,125,  0, 32, 64,156,  2,236,127, 64,  7,180,
/* 0x2860 */ 179,220,  0,  0,127,191,235,120, 66,  0,255,140, 57, 96,  0,  1,
/* 0x2870 */  47,149,  0,  3,125,119,184, 48,126,247,160, 80,126,247,  2, 20,
/* 0x2880 */ 146,225,255, 80, 65,157,  3, 24, 47,151,  0,  3,122,235,  0, 32,
/* 0x2890 */  65,157,  5,148, 85,120, 48, 50,127, 24,  7,180, 56,  0,  0,  6,
/* 0x28a0 */  59, 24,  1,176,124,  9,  3,166,123, 24, 15,164, 57, 96,  0,  1,
/* 0x28b0 */  96,  0,  0,  0,121,124, 15,164, 85,119,  8, 60,127,159,200, 64,
/* 0x28c0 */ 127, 44, 40, 64,126,235,187,120, 85, 64, 64, 46,127,156,194, 20,
/* 0x28d0 */  65,157,  0, 28, 65,154,253,176,137, 76,  0,  0,123,255, 64, 40,
/* 0x28e0 */  57,140,  0,  1,125, 74,  3,120,121, 74,  0, 32,127,211,226, 46,
/* 0x28f0 */  87,224,170,254, 57,107,  0,  1,124,  0,241,214, 35,190,  8,  0,
/* 0x2900 */  87,219,217,126,127,189, 46,112,127,138,  0, 64,127,123,240, 80,
/* 0x2910 */ 127,221,242, 20,120, 29,  0, 32, 64,156,  2, 76,126,235,  7,180,
/* 0x2920 */ 127,211,227, 46,127,191,235,120, 66,  0,255,140, 57,107,255,192,
/* 0x2930 */  47,139,  0,  3,125,126,  7,180, 64,157,  2, 76, 85,122,  7,254,
/* 0x2940 */  47,139,  0, 13, 99, 90,  0,  2,125,107, 14,112,123, 64,  0, 32,
/* 0x2950 */  65,157,  5, 48, 57,107,255,255, 34, 30,  2,176,127, 90, 88, 48,
/* 0x2960 */ 125,107,  7,180,126, 16,210, 20,122, 16, 15,164, 58, 16,255,254,
/* 0x2970 */ 126, 19,130, 20, 57,107,255,255, 59,192,  0,  1,121,107,  0, 32,
/* 0x2980 */  59,128,  0,  1, 57,107,  0,  1,125,105,  3,166, 72,  0,  0, 32,
/* 0x2990 */  96,  0,  0,  0,176, 27,  0,  0,126,254,  7,180,127,191,235,120,
/* 0x29a0 */  87,156,  8, 60,127,156,  7,180, 66, 64,  1,224,123,219, 15,164,
/* 0x29b0 */  87,215,  8, 60,127,159,200, 64,127, 44, 40, 64,126,254,187,120,
/* 0x29c0 */  85, 75, 64, 46,127,112,218, 20, 65,157,  0, 28, 65,154,252,184,
/* 0x29d0 */ 137, 76,  0,  0,123,255, 64, 40, 57,140,  0,  1,125, 74, 91,120,
/* 0x29e0 */ 121, 74,  0, 32,160, 27,  0,  0, 87,235,170,254,127,148,211,120,
/* 0x29f0 */ 125,107,  1,214, 35,160,  8,  0, 84, 24,217,126,127,189, 46,112,
/* 0x2a00 */ 127,138, 88, 64,127, 24,  0, 80,124, 29,  2, 20,121,125,  0, 32,
/* 0x2a10 */  65,156,255,132,127,235,248, 80,125, 75, 80, 80,179, 27,  0,  0,
/* 0x2a20 */  59,222,  0,  1,123,255,  0, 32,121, 74,  0, 32,127,222,  7,180,
/* 0x2a30 */ 122,154,  0, 32, 75,255,255,108, 96,  0,  0,  0, 96,  0,  0,  0,
/* 0x2a40 */  96,  0,  0,  0,127,224,208, 80, 87,124,217,126,127,124,216, 80,
/* 0x2a50 */ 124,  0, 80, 80,127,159,200, 64,123,250,  0, 32,127,115, 91, 46,
/* 0x2a60 */ 120, 10,  0, 32, 59,139,  0, 24, 65,157,  0, 36,127,172, 40, 64,
/* 0x2a70 */  65,158,252, 20,137, 76,  0,  0, 84,  0, 64, 46,123,250, 64, 40,
/* 0x2a80 */  57,140,  0,  1,125, 74,  3,120,121, 74,  0, 32,127,243,226, 46,
/* 0x2a90 */  87, 64,170,254,124,  0,249,214,127,138,  0, 64,120, 27,  0, 32,
/* 0x2aa0 */  64,156,  2, 52, 33,127,  8,  0,127,128,200, 64,125,107, 46,112,
/* 0x2ab0 */ 127,235,250, 20, 59,222,  1,224,127,243,227, 46, 65,157,  0, 36,
/* 0x2ac0 */ 127,172, 40, 64, 65,158,251,192,137,108,  0,  0, 85, 74, 64, 46,
/* 0x2ad0 */ 120, 27, 64, 40, 57,140,  0,  1,125,106, 83,120,121, 74,  0, 32,
/* 0x2ae0 */ 124, 19,242, 46, 87,107,170,254,125,107,  1,214,127,138, 88, 64,
/* 0x2af0 */ 121,127,  0, 32, 64,156,  3, 56, 33, 96,  8,  0, 47,182,  0,  0,
/* 0x2b00 */ 125,107, 46,112,124, 11,  2, 20,124, 19,243, 46, 65,158,251,120,
/* 0x2b10 */  47,149,  0,  7,125,112,176, 80,126,176, 16, 38, 86,181,239,254,
/* 0x2b20 */ 121,107,  0, 32, 56, 22,  0,  1,126,181,  0,208,122,181,  7,164,
/* 0x2b30 */ 125,103, 88,174,125,103,177,174, 58,181,  0, 11,120, 22,  0, 32,
/* 0x2b40 */  72,  0,  0,204,127,235,248, 80,125, 75, 80, 80,179,124,  0,  0,
/* 0x2b50 */ 123,255,  0, 32,121, 74,  0, 32,124,  0,  7,180, 66,  0,252,152,
/* 0x2b60 */  75,255,253, 12,127,224,248, 80,125, 64, 80, 80,127,115,227, 46,
/* 0x2b70 */ 123,255,  0, 32,121, 74,  0, 32,125,107,  7,180, 66,  0,253, 56,
/* 0x2b80 */  75,255,253,172,121,122,  0, 32, 59, 90,  0,  1,123, 80,  0, 33,
/* 0x2b90 */  65,130,  0,132, 58,181,  0,  7,126,181,  7,180,127,144,176, 64,
/* 0x2ba0 */  65,157,250,228,128,  1,255, 80, 59,182,  0,  1,127,208,176, 80,
/* 0x2bb0 */ 123,222,  0, 32,126,220,179,120,125,125,  2, 20,125,112, 88, 80,
/* 0x2bc0 */ 125,126, 88, 80,121,107,  0, 32, 57,107,  0,  1,125,105,  3,166,
/* 0x2bd0 */  72,  0,  0, 20,126,220,179,120,123,222,  0, 32, 64,157,  0, 56,
/* 0x2be0 */  59,182,  0,  1,125,103,240,174,127,136,232, 64, 59,222,  0,  1,
/* 0x2bf0 */ 123,182,  0, 32,125,103,225,174, 66,  0,255,220,232,  1,255,104,
/* 0x2c00 */ 249,193,255, 96,233,193,255, 88,248,  1,255, 88,127,136,176, 64,
/* 0x2c10 */  65,253,248,  0, 61, 64,  0,255, 97, 74,255,255,127,159, 80, 64,
/* 0x2c20 */  65,157,  0, 16,127,172, 40, 64, 65,158,250, 92, 57,140,  0,  1,
/* 0x2c30 */ 124,132, 96, 80, 56, 96,  0,  0,144,134,  0,  0,146,201,  0,  0,
/* 0x2c40 */  75,255,250, 72,127,139,224, 80, 84, 31,217,126,125,107, 80, 80,
/* 0x2c50 */ 124, 31,  0, 80,127,156,200, 64,123,158,  0, 32,176, 24,  0,  0,
/* 0x2c60 */ 121,106,  0, 32, 65,157,  0, 36,127,172, 40, 64, 65,158,250, 24,
/* 0x2c70 */ 137, 76,  0,  0, 85,107, 64, 46,123,158, 64, 40, 57,140,  0,  1,
/* 0x2c80 */ 125, 74, 91,120,121, 74,  0, 32,160, 24,  0,  2, 87,203,170,254,
/* 0x2c90 */ 125,107,  1,214,127,138, 88, 64,121,127,  0, 32, 64,156,  1, 72,
/* 0x2ca0 */  87,171, 24, 56, 35,192,  8,  0,125,107,  7,180,127,222, 46,112,
/* 0x2cb0 */  57,107,  0,130,124, 30,  2, 20,121,107, 15,164,176, 24,  0,  2,
/* 0x2cc0 */  58,128,  0,  8,127, 24, 90, 20, 58,224,  0,  3, 75,255,251, 12,
/* 0x2cd0 */  96,  0,  0,  0,127, 64,208, 80, 87,251,217,126,127,192, 80, 80,
/* 0x2ce0 */ 127,251,248, 80,127,154,200, 64,127,243,227, 46,123, 64,  0, 32,
/* 0x2cf0 */ 123,202,  0, 32, 59,235,  0, 48, 65,157,  0, 36,127,172, 40, 64,
/* 0x2d00 */  65,158,249,132,137, 76,  0,  0, 87,192, 64, 46, 57,140,  0,  1,
/* 0x2d10 */ 125, 74,  3,120,123, 64, 64, 40,121, 74,  0, 32,127,115,250, 46,
/* 0x2d20 */  84, 30,170,254,127,222,217,214,127,138,240, 64,123,220,  0, 32,
/* 0x2d30 */  65,156,  1, 44,124, 30,  0, 80, 87,124,217,126,127,222, 80, 80,
/* 0x2d40 */ 127,156,216, 80,127,128,200, 64,120, 26,  0, 32,127,147,251, 46,
/* 0x2d50 */ 123,202,  0, 32, 57,107,  0, 72, 65,157,  0, 36,127,172, 40, 64,
/* 0x2d60 */  65,158,249, 36,137, 76,  0,  0, 87,222, 64, 46,120, 26, 64, 40,
/* 0x2d70 */  57,140,  0,  1,125, 74,243,120,121, 74,  0, 32,127,243, 90, 46,
/* 0x2d80 */  87, 64,170,254,124,  0,249,214,127,138,  0, 64,120, 28,  0, 32,
/* 0x2d90 */  64,156,  1,104, 32, 31,  8,  0,250,  1,255,104,125,208,115,120,
/* 0x2da0 */ 233,193,255, 96,124,  0, 46,112,127,224,250, 20,127,243, 91, 46,
/* 0x2db0 */  96,  0,  0,  0, 47,149,  0,  7, 59,  3, 10,108,126,176, 16, 38,
/* 0x2dc0 */  86,181,239,254,126,181,  0,208,122,181,240, 66,122,181, 16,  0,
/* 0x2dd0 */  58,181,  0, 11, 75,255,249,152, 96,  0,  0,  0, 96,  0,  0,  0,
/* 0x2de0 */  96,  0,  0,  0, 84, 31,217,126,124, 31,  0, 80,125, 75, 80, 80,
/* 0x2df0 */ 127,235,240, 80,176, 24,  0,  2,121, 74,  0, 32, 59, 24,  2,  4,
/* 0x2e00 */ 123,255,  0, 32, 58,128,  0, 16, 58,224,  0,  8, 75,255,249,204,
/* 0x2e10 */  96,  0,  0,  0, 58,181,255,250,126,181,  7,180, 75,255,253,240,
/* 0x2e20 */  96,  0,  0,  0, 57, 96,  0,  3, 75,255,250,108, 84, 31,217,126,
/* 0x2e30 */ 127,139,216, 80,125, 75, 80, 80,233, 97,255, 88,249,193,255, 88,
/* 0x2e40 */ 124, 31,  0, 80,249, 97,255,104,123,156,  0, 32,233,193,255, 96,
/* 0x2e50 */ 121, 74,  0, 32,124, 19,243, 46, 75,255,255, 92, 33,123,  8,  0,
/* 0x2e60 */ 250,  1,255,104,234,  1,255, 88,125,107, 46,112,127,107,218, 20,
/* 0x2e70 */ 249,193,255, 88,233,193,255, 96,127,115,251, 46, 75,255,255, 56,
/* 0x2e80 */  57,107,255,250,121,107,  0, 32, 57,107,  0,  1,125,105,  3,166,
/* 0x2e90 */  96,  0,  0,  0,127,159,200, 64, 84, 26,  8, 60,127, 44, 40, 64,
/* 0x2ea0 */  85, 75, 64, 46, 65,157,  0, 28, 65,154,247,220,137, 76,  0,  0,
/* 0x2eb0 */ 123,255, 64, 40, 57,140,  0,  1,125, 74, 91,120,121, 74,  0, 32,
/* 0x2ec0 */  87,235,248,126,127,138, 88, 64,123, 64,  0, 32,121,127,  0, 32,
/* 0x2ed0 */  65,156,  0, 20,125, 75, 80, 80, 99, 90,  0,  1,121, 74,  0, 32,
/* 0x2ee0 */ 123, 64,  0, 32, 66,  0,255,176, 58,  3,  6, 72,120, 26, 32, 40,
/* 0x2ef0 */  57, 96,  0,  4, 75,255,250,128, 87,254,217,126,127,254,248, 80,
/* 0x2f00 */ 127,128,208, 80,250,  1,255,104,234,  1,255, 96,125, 64, 80, 80,
/* 0x2f10 */ 127,243, 91, 46,123,156,  0, 32,121, 74,  0, 32, 75,255,254,152,
/* 0x2f20 */  58,192,  0,  0, 75,255,253, 12,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2f30 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2f40 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0,  0,  6,
/* 0x2f50 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2f60 */   0,  0,  0,  0,  3,  0,  0, 16,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2f70 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0,  0,  1,
/* 0x2f80 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2f90 */   0,  0,  0,  0,  3,  0,  0,  3,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2fa0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0,  0,  4,
/* 0x2fb0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2fc0 */   0,  0,  0,  0,  3,  0,  0,  7,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2fd0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0,  0,  9,
/* 0x2fe0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2ff0 */   0,  0,  0,  0,  3,  0,  0, 11,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3000 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0,  0, 13,
/* 0x3010 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3020 */   0,  0,  0,  0,  3,  0,  0, 15,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3030 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0,  0, 17,
/* 0x3040 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3050 */   0,  0,  0,  0,  3,  0,  0, 18,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3060 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1, 16,  0,  0,  1,
/* 0x3070 */   0,  0,  0,  0,  0,  0,  0,156,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3080 */   0,  0,  0,  6, 18,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3090 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 15, 16,  0,  0,  1,
/* 0x30a0 */   0,  0,  0,  0,  0,  0,  0, 20,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x30b0 */   0,  0,  0, 29, 16,  0,  0,  3,  0,  0,  0,  0,  0,  0,  0, 32,
/* 0x30c0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 36, 16,  0,  0,  3,
/* 0x30d0 */   0,  0,  0,  0,  0,  0,  1, 48,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x30e0 */   0,  0,  0, 43, 18,  0,  0,  1,  0,  0,  0,  0,  0,  0,  6, 88,
/* 0x30f0 */   0,  0,  0,  0,  0,  0,  2, 16,  0,  0,  0, 55, 16,  0,  0,  3,
/* 0x3100 */   0,  0,  0,  0,  0,  0,  0, 80,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3110 */   0,  0,  0, 64, 16,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0, 80,
/* 0x3120 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 70, 16,  0,  0,  3,
/* 0x3130 */   0,  0,  0,  0,  0,  0,  0,112,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3140 */   0,  0,  0, 79, 16,  0,  0,  3,  0,  0,  0,  0,  0,  0,  0, 56,
/* 0x3150 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 89, 16,  0,  0,  3,
/* 0x3160 */   0,  0,  0,  0,  0,  0,  0,  8,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3170 */   0,  0,  0, 94, 16,  0,  0,  3,  0,  0,  0,  0,  0,  0,  0, 88,
/* 0x3180 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,100, 18,  0,  0,  1,
/* 0x3190 */   0,  0,  0,  0,  0,  0, 14, 40,  0,  0,  0,  0,  0,  0,  1,160,
/* 0x31a0 */   0,  0,  0,110, 16,  0,  0,  3,  0,  0,  0,  0,  0,  0,  0,236,
/* 0x31b0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,123, 16,  0,  0,  3,
/* 0x31c0 */   0,  0,  0,  0,  0,  0,  0, 96,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x31d0 */   0,  0,  0,128, 18,  0,  0,  1,  0,  0,  0,  0,  0,  0,  5,204,
/* 0x31e0 */   0,  0,  0,  0,  0,  0,  0,140,  0,  0,  0,137, 16,  0,  0,  3,
/* 0x31f0 */   0,  0,  0,  0,  0,  0,  0, 48,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3200 */   0,  0,  0,143, 16,  0,  0,  3,  0,  0,  0,  0,  0,  0,  0,128,
/* 0x3210 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,156, 16,  0,  0,  6,
/* 0x3220 */   0,  0,  0,  0,  0,  0,  0,  8,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3230 */   0,  0,  0,164, 16,  0,  0,  3,  0,  0,  0,  0,  0,  0,  1, 84,
/* 0x3240 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,172, 16,  0,  0,  1,
/* 0x3250 */   0,  0,  0,  0,  0,  0,  0, 44,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3260 */   0,  0,  0,181, 16,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,192,
/* 0x3270 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,188, 16,  0,  0,  3,
/* 0x3280 */   0,  0,  0,  0,  0,  0,  0, 64,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3290 */   0,  0,  0,193, 16,  0,  0,  3,  0,  0,  0,  0,  0,  0,  0, 72,
/* 0x32a0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,197, 16,  0,  0,  3,
/* 0x32b0 */   0,  0,  0,  0,  0,  0,  0,112,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x32c0 */   0,  0,  0,204, 16,  0,  0,  3,  0,  0,  0,  0,  0,  0,  0,104,
/* 0x32d0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,209, 16,  0,  0,  3,
/* 0x32e0 */   0,  0,  0,  0,  0,  0,  0, 40,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x32f0 */   0,  0,  0,218, 16,  0,  0,  3,  0,  0,  0,  0,  0,  0,  0,120,
/* 0x3300 */   0,  0,  0,  0,  0,  0,  0,  0,  0, 80,109, 97,112,  0,102, 95,
/* 0x3310 */ 101,120,112, 97,110,100,  0,103,101,116, 95,112, 97,103,101, 95,
/* 0x3320 */ 109, 97,115,107,  0,109,117,110,109, 97,112,  0,109,101,109, 99,
/* 0x3330 */ 112,121,  0,120,102,105,110,100, 95,112, 97,103,101,115,  0,114,
/* 0x3340 */ 101, 97,100,108,105,110,107,  0, 80,115,121,110, 99,  0,111,112,
/* 0x3350 */ 101,110, 97,116, 54, 52,  0,102,116,114,117,110, 99, 97,116,101,
/* 0x3360 */   0,109,109, 97,112,  0,119,114,105,116,101,  0,117,112,120, 95,
/* 0x3370 */ 109, 97,105,110, 50,  0,109,101,109,102,100, 95, 99,114,101, 97,
/* 0x3380 */ 116,101,  0,114,101, 97,100,  0,117,110,100,101,114,108, 97,121,
/* 0x3390 */   0,109,115,121,110, 99,  0,117,112,120,102,100, 95, 99,114,101,
/* 0x33a0 */  97,116,101,  0,101,111,102, 95,110,114,118,  0,109,121, 95, 98,
/* 0x33b0 */ 107,112,116,  0, 80,112,114,111,116,101, 99,116,  0, 80,117,110,
/* 0x33c0 */ 109, 97,112,  0,101,120,105,116,  0, 98,114,107,  0,111,112,101,
/* 0x33d0 */ 110, 97,116,  0,111,112,101,110,  0,109,112,114,111,116,101, 99,
/* 0x33e0 */ 116,  0, 99,108,111,115,101,  0,  0,  0,  0,  0,  0,  0,  0, 76,
/* 0x33f0 */   0,  0,  0, 39,  0,  0,  0, 10,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3400 */   0,  0,  0,  0,  0,  0,  0,152,  0,  0,  0, 29,  0,  0,  0, 10,
/* 0x3410 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,188,
/* 0x3420 */   0,  0,  0, 23,  0,  0,  0, 10,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3430 */   0,  0,  0,  0,  0,  0,  0,224,  0,  0,  0, 16,  0,  0,  0, 10,
/* 0x3440 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,132,
/* 0x3450 */   0,  0,  0, 38,  0,  0,  0, 10,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3460 */   0,  0,  0,  0,  0,  0,  1,152,  0,  0,  0, 19,  0,  0,  0, 10,
/* 0x3470 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  2, 60,
/* 0x3480 */   0,  0,  0, 25,  0,  0,  0, 10,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3490 */   0,  0,  0,  0,  0,  0,  2,124,  0,  0,  0, 36,  0,  0,  0, 10,
/* 0x34a0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  2,136,
/* 0x34b0 */   0,  0,  0, 16,  0,  0,  0, 10,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x34c0 */   0,  0,  0,  0,  0,  0,  2,176,  0,  0,  0, 23,  0,  0,  0, 10,
/* 0x34d0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  2,184,
/* 0x34e0 */   0,  0,  0, 40,  0,  0,  0, 10,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x34f0 */   0,  0,  0,  0,  0,  0,  3,144,  0,  0,  0, 35,  0,  0,  0, 10,
/* 0x3500 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  4, 76,
/* 0x3510 */   0,  0,  0, 35,  0,  0,  0, 10,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3520 */   0,  0,  0,  0,  0,  0,  4,244,  0,  0,  0, 35,  0,  0,  0, 10,
/* 0x3530 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  5, 44,
/* 0x3540 */   0,  0,  0, 14,  0,  0,  0, 10,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3550 */   0,  0,  0,  0,  0,  0,  5,244,  0,  0,  0, 17,  0,  0,  0, 10,
/* 0x3560 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  6, 20,
/* 0x3570 */   0,  0,  0, 23,  0,  0,  0, 10,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3580 */   0,  0,  0,  0,  0,  0,  6, 40,  0,  0,  0, 17,  0,  0,  0, 10,
/* 0x3590 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  6,156,
/* 0x35a0 */   0,  0,  0, 15,  0,  0,  0, 10,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x35b0 */   0,  0,  0,  0,  0,  0,  7,152,  0,  0,  0, 23,  0,  0,  0, 10,
/* 0x35c0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  7,188,
/* 0x35d0 */   0,  0,  0, 16,  0,  0,  0, 10,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x35e0 */   0,  0,  0,  0,  0,  0,  7,224,  0,  0,  0, 16,  0,  0,  0, 10,
/* 0x35f0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  8, 20,
/* 0x3600 */   0,  0,  0, 23,  0,  0,  0, 10,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3610 */   0,  0,  0,  0,  0,  0,  9, 52,  0,  0,  0, 23,  0,  0,  0, 10,
/* 0x3620 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  9, 60,
/* 0x3630 */   0,  0,  0, 15,  0,  0,  0, 10,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3640 */   0,  0,  0,  0,  0,  0,  9,116,  0,  0,  0, 18,  0,  0,  0, 10,
/* 0x3650 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  9,124,
/* 0x3660 */   0,  0,  0, 15,  0,  0,  0, 10,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3670 */   0,  0,  0,  0,  0,  0, 10,248,  0,  0,  0, 30,  0,  0,  0, 10,
/* 0x3680 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 11,  8,
/* 0x3690 */   0,  0,  0, 22,  0,  0,  0, 10,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x36a0 */   0,  0,  0,  0,  0,  0, 11, 40,  0,  0,  0, 23,  0,  0,  0, 10,
/* 0x36b0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 11, 88,
/* 0x36c0 */   0,  0,  0, 23,  0,  0,  0, 10,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x36d0 */   0,  0,  0,  0,  0,  0, 11,140,  0,  0,  0, 23,  0,  0,  0, 10,
/* 0x36e0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 12, 80,
/* 0x36f0 */   0,  0,  0, 30,  0,  0,  0, 10,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3700 */   0,  0,  0,  0,  0,  0, 12,100,  0,  0,  0, 24,  0,  0,  0, 10,
/* 0x3710 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 12,132,
/* 0x3720 */   0,  0,  0, 23,  0,  0,  0, 10,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3730 */   0,  0,  0,  0,  0,  0, 12,148,  0,  0,  0, 40,  0,  0,  0, 10,
/* 0x3740 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 12,192,
/* 0x3750 */   0,  0,  0, 20,  0,  0,  0, 10,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3760 */   0,  0,  0,  0,  0,  0, 12,208,  0,  0,  0, 16,  0,  0,  0, 10,
/* 0x3770 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 12,240,
/* 0x3780 */   0,  0,  0, 23,  0,  0,  0, 10,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3790 */   0,  0,  0,  0,  0,  0, 13,  4,  0,  0,  0, 40,  0,  0,  0, 10,
/* 0x37a0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13, 36,
/* 0x37b0 */   0,  0,  0, 33,  0,  0,  0, 10,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x37c0 */   0,  0,  0,  0,  0,  0, 13, 56,  0,  0,  0, 35,  0,  0,  0, 10,
/* 0x37d0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13, 96,
/* 0x37e0 */   0,  0,  0, 23,  0,  0,  0, 10,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x37f0 */   0,  0,  0,  0,  0,  0, 13,148,  0,  0,  0, 36,  0,  0,  0, 10,
/* 0x3800 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 14,128,
/* 0x3810 */   0,  0,  0, 15,  0,  0,  0, 10,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3820 */   0,  0,  0,  0,  0,  0, 14,248,  0,  0,  0, 38,  0,  0,  0, 10,
/* 0x3830 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 15, 20,
/* 0x3840 */   0,  0,  0, 27,  0,  0,  0, 10,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3850 */   0,  0,  0,  0,  0,  0, 15, 40,  0,  0,  0, 35,  0,  0,  0, 10,
/* 0x3860 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 15,100,
/* 0x3870 */   0,  0,  0, 40,  0,  0,  0, 10,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3880 */   0,  0,  0,  0,  0,  0,  0, 96,  0,  0,  0,  1,  0,  0,  0, 10,
/* 0x3890 */   0,  0,  0,  0,  0,  0,  0, 40,  0,  0,  0,  0,  0,  0,  0,200,
/* 0x38a0 */   0,  0,  0, 31,  0,  0,  0, 11,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x38b0 */   0,  0,  0,  0,  0,  0,  0,204,  0,  0,  0, 31,  0,  0,  0, 11,
/* 0x38c0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,160,
/* 0x38d0 */   0,  0,  0, 31,  0,  0,  0, 11,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x38e0 */   0,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0,  2,  0,  0,  0, 11,
/* 0x38f0 */   0,  0,  0,  0,  0,  0,  0, 48,  0, 46,115,121,109,116, 97, 98,
/* 0x3900 */   0, 46,115,116,114,116, 97, 98,  0, 46,115,104,115,116,114,116,
/* 0x3910 */  97, 98,  0, 46,114,101,108, 97, 46,116,101,120,116,  0, 83, 89,
/* 0x3920 */  83, 67, 65, 76, 76, 83,  0, 46,114,101,108, 97, 69, 88, 80, 95,
/* 0x3930 */  72, 69, 65, 68,  0, 69, 88, 80, 95, 84, 65, 73, 76,  0, 46,114,
/* 0x3940 */ 101,108, 97, 78, 82, 86, 50, 69,  0, 46,114,101,108, 97, 78, 82,
/* 0x3950 */  86, 50, 68,  0, 46,114,101,108, 97, 78, 82, 86, 50, 66,  0, 46,
/* 0x3960 */ 114,101,108, 97, 76, 90, 77, 65, 95, 68, 65, 73, 83, 89,  0, 76,
/* 0x3970 */  90, 77, 65, 95, 69, 76, 70, 48, 48,  0, 76, 90, 77, 65, 95, 68,
/* 0x3980 */  69, 67, 51, 48,  0, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,  0,
/* 0x3990 */  76, 90, 77, 65, 95, 68, 69, 67, 50, 48,  0,  0,  0,  0,  0,  0,
/* 0x39a0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x39b0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x39c0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x39d0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x39e0 */   0,  0,  0, 32,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  6,
/* 0x39f0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 64,
/* 0x3a00 */   0,  0,  0,  0,  0,  0, 15,200,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3a10 */   0,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3a20 */   0,  0,  0, 27,  0,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0, 64,
/* 0x3a30 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 51,232,
/* 0x3a40 */   0,  0,  0,  0,  0,  0,  4,152,  0,  0,  0, 20,  0,  0,  0,  1,
/* 0x3a50 */   0,  0,  0,  0,  0,  0,  0,  8,  0,  0,  0,  0,  0,  0,  0, 24,
/* 0x3a60 */   0,  0,  0, 38,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3a70 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 16,  8,
/* 0x3a80 */   0,  0,  0,  0,  0,  0,  1, 92,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3a90 */   0,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3aa0 */   0,  0,  0, 52,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3ab0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 17,100,
/* 0x3ac0 */   0,  0,  0,  0,  0,  0,  0,172,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3ad0 */   0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3ae0 */   0,  0,  0, 47,  0,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0, 64,
/* 0x3af0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 56,128,
/* 0x3b00 */   0,  0,  0,  0,  0,  0,  0, 24,  0,  0,  0, 20,  0,  0,  0,  4,
/* 0x3b10 */   0,  0,  0,  0,  0,  0,  0,  8,  0,  0,  0,  0,  0,  0,  0, 24,
/* 0x3b20 */   0,  0,  0, 61,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3b30 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 18, 16,
/* 0x3b40 */   0,  0,  0,  0,  0,  0,  0,140,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3b50 */   0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3b60 */   0,  0,  0, 75,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3b70 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 18,156,
/* 0x3b80 */   0,  0,  0,  0,  0,  0,  1, 92,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3b90 */   0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3ba0 */   0,  0,  0, 70,  0,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0, 64,
/* 0x3bb0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 56,152,
/* 0x3bc0 */   0,  0,  0,  0,  0,  0,  0, 24,  0,  0,  0, 20,  0,  0,  0,  7,
/* 0x3bd0 */   0,  0,  0,  0,  0,  0,  0,  8,  0,  0,  0,  0,  0,  0,  0, 24,
/* 0x3be0 */   0,  0,  0, 86,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3bf0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 19,248,
/* 0x3c00 */   0,  0,  0,  0,  0,  0,  1, 68,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3c10 */   0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3c20 */   0,  0,  0, 81,  0,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0, 64,
/* 0x3c30 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 56,176,
/* 0x3c40 */   0,  0,  0,  0,  0,  0,  0, 24,  0,  0,  0, 20,  0,  0,  0,  9,
/* 0x3c50 */   0,  0,  0,  0,  0,  0,  0,  8,  0,  0,  0,  0,  0,  0,  0, 24,
/* 0x3c60 */   0,  0,  0, 97,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3c70 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 21, 60,
/* 0x3c80 */   0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3c90 */   0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3ca0 */   0,  0,  0, 92,  0,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0, 64,
/* 0x3cb0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 56,200,
/* 0x3cc0 */   0,  0,  0,  0,  0,  0,  0, 24,  0,  0,  0, 20,  0,  0,  0, 11,
/* 0x3cd0 */   0,  0,  0,  0,  0,  0,  0,  8,  0,  0,  0,  0,  0,  0,  0, 24,
/* 0x3ce0 */   0,  0,  0,108,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3cf0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 22, 60,
/* 0x3d00 */   0,  0,  0,  0,  0,  0,  0,  8,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3d10 */   0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3d20 */   0,  0,  0,103,  0,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0, 64,
/* 0x3d30 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 56,224,
/* 0x3d40 */   0,  0,  0,  0,  0,  0,  0, 24,  0,  0,  0, 20,  0,  0,  0, 13,
/* 0x3d50 */   0,  0,  0,  0,  0,  0,  0,  8,  0,  0,  0,  0,  0,  0,  0, 24,
/* 0x3d60 */   0,  0,  0,119,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3d70 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 22, 68,
/* 0x3d80 */   0,  0,  0,  0,  0,  0,  0,152,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3d90 */   0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3da0 */   0,  0,  0,130,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3db0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 22,220,
/* 0x3dc0 */   0,  0,  0,  0,  0,  0,  0, 48,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3dd0 */   0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3de0 */   0,  0,  0,141,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3df0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 23, 12,
/* 0x3e00 */   0,  0,  0,  0,  0,  0, 11,184,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3e10 */   0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3e20 */   0,  0,  0,152,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3e30 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 34,196,
/* 0x3e40 */   0,  0,  0,  0,  0,  0, 12,108,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3e50 */   0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3e60 */   0,  0,  0, 17,  0,  0,  0,  3,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3e70 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 56,248,
/* 0x3e80 */   0,  0,  0,  0,  0,  0,  0,163,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3e90 */   0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3ea0 */   0,  0,  0,  1,  0,  0,  0,  2,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3eb0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 47, 48,
/* 0x3ec0 */   0,  0,  0,  0,  0,  0,  3,216,  0,  0,  0, 21,  0,  0,  0, 13,
/* 0x3ed0 */   0,  0,  0,  0,  0,  0,  0,  8,  0,  0,  0,  0,  0,  0,  0, 24,
/* 0x3ee0 */   0,  0,  0,  9,  0,  0,  0,  3,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3ef0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 51,  8,
/* 0x3f00 */   0,  0,  0,  0,  0,  0,  0,224,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3f10 */   0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3f20 */ 102,105,108,101, 32,102,111,114,109, 97,116, 32,101,108,102, 54,
/* 0x3f30 */  52, 45,112,111,119,101,114,112, 99, 10, 10, 83,101, 99,116,105,
/* 0x3f40 */ 111,110,115, 58, 10, 73,100,120, 32, 78, 97,109,101, 32, 32, 32,
/* 0x3f50 */  32, 32, 32, 32, 32, 32, 32, 83,105,122,101, 32, 32, 32, 32, 32,
/* 0x3f60 */  32, 86, 77, 65, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x3f70 */  32, 32, 32, 76, 77, 65, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x3f80 */  32, 32, 32, 32, 32, 70,105,108,101, 32,111,102,102, 32, 32, 65,
/* 0x3f90 */ 108,103,110, 32, 32, 70,108, 97,103,115, 10, 32, 32, 48, 32, 46,
/* 0x3fa0 */ 116,101,120,116, 32, 32, 32, 32, 32, 32, 32, 32, 32, 48,102, 99,
/* 0x3fb0 */  56, 32, 32, 48, 32, 32, 48, 32, 32, 48, 52, 48, 32, 32, 50, 42,
/* 0x3fc0 */  42, 50, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 49,
/* 0x3fd0 */  32, 83, 89, 83, 67, 65, 76, 76, 83, 32, 32, 32, 32, 32, 32, 48,
/* 0x3fe0 */  49, 53, 99, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 48, 48, 56,
/* 0x3ff0 */  32, 32, 50, 42, 42, 50, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x4000 */  10, 32, 32, 50, 32, 69, 88, 80, 95, 72, 69, 65, 68, 32, 32, 32,
/* 0x4010 */  32, 32, 32, 48, 97, 99, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49,
/* 0x4020 */  49, 54, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x4030 */  78, 84, 83, 10, 32, 32, 51, 32, 69, 88, 80, 95, 84, 65, 73, 76,
/* 0x4040 */  32, 32, 32, 32, 32, 32, 48, 56, 99, 32, 32, 48, 32, 32, 48, 32,
/* 0x4050 */  32, 48, 49, 50, 49, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x4060 */  78, 84, 69, 78, 84, 83, 10, 32, 32, 52, 32, 78, 82, 86, 50, 69,
/* 0x4070 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 48, 49, 53, 99, 32, 32, 48,
/* 0x4080 */  32, 32, 48, 32, 32, 48, 49, 50, 57, 99, 32, 32, 50, 42, 42, 48,
/* 0x4090 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 53, 32, 78,
/* 0x40a0 */  82, 86, 50, 68, 32, 32, 32, 32, 32, 32, 32, 32, 32, 48, 49, 52,
/* 0x40b0 */  52, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 51,102, 56, 32, 32,
/* 0x40c0 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32,
/* 0x40d0 */  32, 54, 32, 78, 82, 86, 50, 66, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x40e0 */  32, 48, 49, 48, 48, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 53,
/* 0x40f0 */  51, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x4100 */  84, 83, 10, 32, 32, 55, 32, 76, 90, 77, 65, 95, 68, 65, 73, 83,
/* 0x4110 */  89, 32, 32, 32, 32, 48, 56, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x4120 */  49, 54, 51, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x4130 */  69, 78, 84, 83, 10, 32, 32, 56, 32, 76, 90, 77, 65, 95, 69, 76,
/* 0x4140 */  70, 48, 48, 32, 32, 32, 32, 48, 57, 56, 32, 32, 48, 32, 32, 48,
/* 0x4150 */  32, 32, 48, 49, 54, 52, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x4160 */  79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 57, 32, 76, 90, 77, 65,
/* 0x4170 */  95, 68, 69, 67, 51, 48, 32, 32, 32, 32, 48, 51, 48, 32, 32, 48,
/* 0x4180 */  32, 32, 48, 32, 32, 48, 49, 54,100, 99, 32, 32, 50, 42, 42, 48,
/* 0x4190 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 48, 32, 76,
/* 0x41a0 */  90, 77, 65, 95, 68, 69, 67, 49, 48, 32, 32, 32, 32, 48, 98, 98,
/* 0x41b0 */  56, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 55, 48, 99, 32, 32,
/* 0x41c0 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32,
/* 0x41d0 */  49, 49, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 32, 32, 32,
/* 0x41e0 */  32, 48, 99, 54, 99, 32, 32, 48, 32, 32, 48, 32, 32, 48, 50, 50,
/* 0x41f0 */  99, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x4200 */  84, 83, 10, 83, 89, 77, 66, 79, 76, 32, 84, 65, 66, 76, 69, 58,
/* 0x4210 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4220 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 69, 88, 80, 95, 84, 65,
/* 0x4230 */  73, 76, 32, 48, 32, 69, 88, 80, 95, 84, 65, 73, 76, 10, 48, 48,
/* 0x4240 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x4250 */  32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51,
/* 0x4260 */  48, 32, 48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51, 48, 10, 48,
/* 0x4270 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x4280 */ 108, 32, 32, 32, 32,100, 32, 32, 46,116,101,120,116, 32, 48, 32,
/* 0x4290 */  46,116,101,120,116, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x42a0 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 83,
/* 0x42b0 */  89, 83, 67, 65, 76, 76, 83, 32, 48, 32, 83, 89, 83, 67, 65, 76,
/* 0x42c0 */  76, 83, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x42d0 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 69, 88, 80, 95,
/* 0x42e0 */  72, 69, 65, 68, 32, 48, 32, 69, 88, 80, 95, 72, 69, 65, 68, 10,
/* 0x42f0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4300 */  32,108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86, 50, 69, 32, 48,
/* 0x4310 */  32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4320 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x4330 */  78, 82, 86, 50, 68, 32, 48, 32, 78, 82, 86, 50, 68, 10, 48, 48,
/* 0x4340 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x4350 */  32, 32, 32, 32,100, 32, 32, 78, 82, 86, 50, 66, 32, 48, 32, 78,
/* 0x4360 */  82, 86, 50, 66, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4370 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90,
/* 0x4380 */  77, 65, 95, 68, 65, 73, 83, 89, 32, 48, 32, 76, 90, 77, 65, 95,
/* 0x4390 */  68, 65, 73, 83, 89, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x43a0 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76,
/* 0x43b0 */  90, 77, 65, 95, 69, 76, 70, 48, 48, 32, 48, 32, 76, 90, 77, 65,
/* 0x43c0 */  95, 69, 76, 70, 48, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x43d0 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x43e0 */  76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 32, 48, 32, 76, 90, 77,
/* 0x43f0 */  65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4400 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x4410 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 32, 48, 32, 76, 90,
/* 0x4420 */  77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x4430 */  48, 48, 48, 48, 48, 48, 48, 57, 99, 32,103, 32, 32, 32, 32, 32,
/* 0x4440 */  32, 32, 46,116,101,120,116, 32, 48, 32, 80,109, 97,112, 10, 48,
/* 0x4450 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x4460 */ 103, 32, 32, 32, 32, 32, 70, 32, 69, 88, 80, 95, 72, 69, 65, 68,
/* 0x4470 */  32, 48, 32,102, 95,101,120,112, 97,110,100, 10, 48, 48, 48, 48,
/* 0x4480 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 52, 32,103, 32, 32,
/* 0x4490 */  32, 32, 32, 32, 32, 46,116,101,120,116, 32, 48, 32,103,101,116,
/* 0x44a0 */  95,112, 97,103,101, 95,109, 97,115,107, 10, 48, 48, 48, 48, 48,
/* 0x44b0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 50, 48, 32,103, 32, 32, 32,
/* 0x44c0 */  32, 32, 32, 32, 83, 89, 83, 67, 65, 76, 76, 83, 32, 48, 32,109,
/* 0x44d0 */ 117,110,109, 97,112, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x44e0 */  48, 48, 48, 49, 51, 48, 32,103, 32, 32, 32, 32, 32, 32, 32, 83,
/* 0x44f0 */  89, 83, 67, 65, 76, 76, 83, 32, 48, 32,109,101,109, 99,112,121,
/* 0x4500 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 54, 53,
/* 0x4510 */  56, 32,103, 32, 32, 32, 32, 32, 70, 32, 46,116,101,120,116, 32,
/* 0x4520 */  48, 50, 49, 48, 32,120,102,105,110,100, 95,112, 97,103,101,115,
/* 0x4530 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 53,
/* 0x4540 */  48, 32,103, 32, 32, 32, 32, 32, 32, 32, 83, 89, 83, 67, 65, 76,
/* 0x4550 */  76, 83, 32, 48, 32,114,101, 97,100,108,105,110,107, 10, 48, 48,
/* 0x4560 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 53, 48, 32,103,
/* 0x4570 */  32, 32, 32, 32, 32, 32, 32, 46,116,101,120,116, 32, 48, 32, 80,
/* 0x4580 */ 115,121,110, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4590 */  48, 48, 48, 55, 48, 32,103, 32, 32, 32, 32, 32, 32, 32, 83, 89,
/* 0x45a0 */  83, 67, 65, 76, 76, 83, 32, 48, 32,111,112,101,110, 97,116, 54,
/* 0x45b0 */  52, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x45c0 */  51, 56, 32,103, 32, 32, 32, 32, 32, 32, 32, 83, 89, 83, 67, 65,
/* 0x45d0 */  76, 76, 83, 32, 48, 32,102,116,114,117,110, 99, 97,116,101, 10,
/* 0x45e0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 56,
/* 0x45f0 */  32,103, 32, 32, 32, 32, 32, 32, 32, 83, 89, 83, 67, 65, 76, 76,
/* 0x4600 */  83, 32, 48, 32,109,109, 97,112, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x4610 */  48, 48, 48, 48, 48, 48, 48, 53, 56, 32,103, 32, 32, 32, 32, 32,
/* 0x4620 */  32, 32, 83, 89, 83, 67, 65, 76, 76, 83, 32, 48, 32,119,114,105,
/* 0x4630 */ 116,101, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4640 */ 101, 50, 56, 32,103, 32, 32, 32, 32, 32, 70, 32, 46,116,101,120,
/* 0x4650 */ 116, 32, 48, 49, 97, 48, 32,117,112,120, 95,109, 97,105,110, 50,
/* 0x4660 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,101,
/* 0x4670 */  99, 32,103, 32, 32, 32, 32, 32, 32, 32, 83, 89, 83, 67, 65, 76,
/* 0x4680 */  76, 83, 32, 48, 32,109,101,109,102,100, 95, 99,114,101, 97,116,
/* 0x4690 */ 101, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x46a0 */  54, 48, 32,103, 32, 32, 32, 32, 32, 32, 32, 83, 89, 83, 67, 65,
/* 0x46b0 */  76, 76, 83, 32, 48, 32,114,101, 97,100, 10, 48, 48, 48, 48, 48,
/* 0x46c0 */  48, 48, 48, 48, 48, 48, 48, 48, 53, 99, 99, 32,103, 32, 32, 32,
/* 0x46d0 */  32, 32, 70, 32, 46,116,101,120,116, 32, 48, 56, 99, 32,117,110,
/* 0x46e0 */ 100,101,114,108, 97,121, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x46f0 */  48, 48, 48, 48, 48, 51, 48, 32,103, 32, 32, 32, 32, 32, 32, 32,
/* 0x4700 */  83, 89, 83, 67, 65, 76, 76, 83, 32, 48, 32,109,115,121,110, 99,
/* 0x4710 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 56,
/* 0x4720 */  48, 32,103, 32, 32, 32, 32, 32, 32, 32, 83, 89, 83, 67, 65, 76,
/* 0x4730 */  76, 83, 32, 48, 32,117,112,120,102,100, 95, 99,114,101, 97,116,
/* 0x4740 */ 101, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4750 */  48, 56, 32,103, 32, 32, 32, 32, 32, 32, 32, 69, 88, 80, 95, 84,
/* 0x4760 */  65, 73, 76, 32, 48, 32,101,111,102, 95,110,114,118, 10, 48, 48,
/* 0x4770 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 53, 52, 32,103,
/* 0x4780 */  32, 32, 32, 32, 32, 32, 32, 83, 89, 83, 67, 65, 76, 76, 83, 32,
/* 0x4790 */  48, 32,109,121, 95, 98,107,112,116, 10, 48, 48, 48, 48, 48, 48,
/* 0x47a0 */  48, 48, 48, 48, 48, 48, 48, 48, 50, 99, 32,103, 32, 32, 32, 32,
/* 0x47b0 */  32, 32, 32, 46,116,101,120,116, 32, 48, 32, 80,112,114,111,116,
/* 0x47c0 */ 101, 99,116, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x47d0 */  48, 48, 99, 48, 32,103, 32, 32, 32, 32, 32, 32, 32, 46,116,101,
/* 0x47e0 */ 120,116, 32, 48, 32, 80,117,110,109, 97,112, 10, 48, 48, 48, 48,
/* 0x47f0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 52, 48, 32,103, 32, 32,
/* 0x4800 */  32, 32, 32, 32, 32, 83, 89, 83, 67, 65, 76, 76, 83, 32, 48, 32,
/* 0x4810 */ 101,120,105,116, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4820 */  48, 48, 48, 52, 56, 32,103, 32, 32, 32, 32, 32, 32, 32, 83, 89,
/* 0x4830 */  83, 67, 65, 76, 76, 83, 32, 48, 32, 98,114,107, 10, 48, 48, 48,
/* 0x4840 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 55, 48, 32,103, 32,
/* 0x4850 */  32, 32, 32, 32, 32, 32, 83, 89, 83, 67, 65, 76, 76, 83, 32, 48,
/* 0x4860 */  32,111,112,101,110, 97,116, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4870 */  48, 48, 48, 48, 48, 48, 54, 56, 32,103, 32, 32, 32, 32, 32, 32,
/* 0x4880 */  32, 83, 89, 83, 67, 65, 76, 76, 83, 32, 48, 32,111,112,101,110,
/* 0x4890 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 50,
/* 0x48a0 */  56, 32,103, 32, 32, 32, 32, 32, 32, 32, 83, 89, 83, 67, 65, 76,
/* 0x48b0 */  76, 83, 32, 48, 32,109,112,114,111,116,101, 99,116, 10, 48, 48,
/* 0x48c0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 55, 56, 32,103,
/* 0x48d0 */  32, 32, 32, 32, 32, 32, 32, 83, 89, 83, 67, 65, 76, 76, 83, 32,
/* 0x48e0 */  48, 32, 99,108,111,115,101, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x48f0 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x4900 */  91, 46,116,101,120,116, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,
/* 0x4910 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 84, 89, 80, 69, 32, 32,
/* 0x4920 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,
/* 0x4930 */  69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4940 */  52, 99, 32, 82, 95, 80, 80, 67, 54, 52, 95, 82, 69, 76, 50, 52,
/* 0x4950 */  32, 32, 32, 32, 32,109,112,114,111,116,101, 99,116, 10, 48, 48,
/* 0x4960 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 57, 56, 32, 82,
/* 0x4970 */  95, 80, 80, 67, 54, 52, 95, 82, 69, 76, 50, 52, 32, 32, 32, 32,
/* 0x4980 */  32,109,115,121,110, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4990 */  48, 48, 48, 48, 48, 98, 99, 32, 82, 95, 80, 80, 67, 54, 52, 95,
/* 0x49a0 */  82, 69, 76, 50, 52, 32, 32, 32, 32, 32,109,109, 97,112, 10, 48,
/* 0x49b0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,101, 48, 32,
/* 0x49c0 */  82, 95, 80, 80, 67, 54, 52, 95, 82, 69, 76, 50, 52, 32, 32, 32,
/* 0x49d0 */  32, 32,109,117,110,109, 97,112, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x49e0 */  48, 48, 48, 48, 48, 48, 49, 56, 52, 32, 82, 95, 80, 80, 67, 54,
/* 0x49f0 */  52, 95, 82, 69, 76, 50, 52, 32, 32, 32, 32, 32,111,112,101,110,
/* 0x4a00 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 57,
/* 0x4a10 */  56, 32, 82, 95, 80, 80, 67, 54, 52, 95, 82, 69, 76, 50, 52, 32,
/* 0x4a20 */  32, 32, 32, 32,114,101, 97,100,108,105,110,107, 10, 48, 48, 48,
/* 0x4a30 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 50, 51, 99, 32, 82, 95,
/* 0x4a40 */  80, 80, 67, 54, 52, 95, 82, 69, 76, 50, 52, 32, 32, 32, 32, 32,
/* 0x4a50 */ 117,112,120, 95,109, 97,105,110, 50, 10, 48, 48, 48, 48, 48, 48,
/* 0x4a60 */  48, 48, 48, 48, 48, 48, 48, 50, 55, 99, 32, 82, 95, 80, 80, 67,
/* 0x4a70 */  54, 52, 95, 82, 69, 76, 50, 52, 32, 32, 32, 32, 32, 98,114,107,
/* 0x4a80 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 50, 56,
/* 0x4a90 */  56, 32, 82, 95, 80, 80, 67, 54, 52, 95, 82, 69, 76, 50, 52, 32,
/* 0x4aa0 */  32, 32, 32, 32,109,117,110,109, 97,112, 10, 48, 48, 48, 48, 48,
/* 0x4ab0 */  48, 48, 48, 48, 48, 48, 48, 48, 50, 98, 48, 32, 82, 95, 80, 80,
/* 0x4ac0 */  67, 54, 52, 95, 82, 69, 76, 50, 52, 32, 32, 32, 32, 32,109,109,
/* 0x4ad0 */  97,112, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4ae0 */  50, 98, 56, 32, 82, 95, 80, 80, 67, 54, 52, 95, 82, 69, 76, 50,
/* 0x4af0 */  52, 32, 32, 32, 32, 32, 99,108,111,115,101, 10, 48, 48, 48, 48,
/* 0x4b00 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 51, 57, 48, 32, 82, 95, 80,
/* 0x4b10 */  80, 67, 54, 52, 95, 82, 69, 76, 50, 52, 32, 32, 32, 32, 32,101,
/* 0x4b20 */ 120,105,116, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4b30 */  48, 52, 52, 99, 32, 82, 95, 80, 80, 67, 54, 52, 95, 82, 69, 76,
/* 0x4b40 */  50, 52, 32, 32, 32, 32, 32,101,120,105,116, 10, 48, 48, 48, 48,
/* 0x4b50 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 52,102, 52, 32, 82, 95, 80,
/* 0x4b60 */  80, 67, 54, 52, 95, 82, 69, 76, 50, 52, 32, 32, 32, 32, 32,101,
/* 0x4b70 */ 120,105,116, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4b80 */  48, 53, 50, 99, 32, 82, 95, 80, 80, 67, 54, 52, 95, 82, 69, 76,
/* 0x4b90 */  50, 52, 32, 32, 32, 32, 32,102, 95,101,120,112, 97,110,100, 10,
/* 0x4ba0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 53,102, 52,
/* 0x4bb0 */  32, 82, 95, 80, 80, 67, 54, 52, 95, 82, 69, 76, 50, 52, 32, 32,
/* 0x4bc0 */  32, 32, 32,109,101,109, 99,112,121, 10, 48, 48, 48, 48, 48, 48,
/* 0x4bd0 */  48, 48, 48, 48, 48, 48, 48, 54, 49, 52, 32, 82, 95, 80, 80, 67,
/* 0x4be0 */  54, 52, 95, 82, 69, 76, 50, 52, 32, 32, 32, 32, 32,109,109, 97,
/* 0x4bf0 */ 112, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 54,
/* 0x4c00 */  50, 56, 32, 82, 95, 80, 80, 67, 54, 52, 95, 82, 69, 76, 50, 52,
/* 0x4c10 */  32, 32, 32, 32, 32,109,101,109, 99,112,121, 10, 48, 48, 48, 48,
/* 0x4c20 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 54, 57, 99, 32, 82, 95, 80,
/* 0x4c30 */  80, 67, 54, 52, 95, 82, 69, 76, 50, 52, 32, 32, 32, 32, 32,103,
/* 0x4c40 */ 101,116, 95,112, 97,103,101, 95,109, 97,115,107, 10, 48, 48, 48,
/* 0x4c50 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 55, 57, 56, 32, 82, 95,
/* 0x4c60 */  80, 80, 67, 54, 52, 95, 82, 69, 76, 50, 52, 32, 32, 32, 32, 32,
/* 0x4c70 */ 109,109, 97,112, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4c80 */  48, 48, 55, 98, 99, 32, 82, 95, 80, 80, 67, 54, 52, 95, 82, 69,
/* 0x4c90 */  76, 50, 52, 32, 32, 32, 32, 32,109,117,110,109, 97,112, 10, 48,
/* 0x4ca0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 55,101, 48, 32,
/* 0x4cb0 */  82, 95, 80, 80, 67, 54, 52, 95, 82, 69, 76, 50, 52, 32, 32, 32,
/* 0x4cc0 */  32, 32,109,117,110,109, 97,112, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x4cd0 */  48, 48, 48, 48, 48, 48, 56, 49, 52, 32, 82, 95, 80, 80, 67, 54,
/* 0x4ce0 */  52, 95, 82, 69, 76, 50, 52, 32, 32, 32, 32, 32,109,109, 97,112,
/* 0x4cf0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 57, 51,
/* 0x4d00 */  52, 32, 82, 95, 80, 80, 67, 54, 52, 95, 82, 69, 76, 50, 52, 32,
/* 0x4d10 */  32, 32, 32, 32,109,109, 97,112, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x4d20 */  48, 48, 48, 48, 48, 48, 57, 51, 99, 32, 82, 95, 80, 80, 67, 54,
/* 0x4d30 */  52, 95, 82, 69, 76, 50, 52, 32, 32, 32, 32, 32,103,101,116, 95,
/* 0x4d40 */ 112, 97,103,101, 95,109, 97,115,107, 10, 48, 48, 48, 48, 48, 48,
/* 0x4d50 */  48, 48, 48, 48, 48, 48, 48, 57, 55, 52, 32, 82, 95, 80, 80, 67,
/* 0x4d60 */  54, 52, 95, 82, 69, 76, 50, 52, 32, 32, 32, 32, 32,120,102,105,
/* 0x4d70 */ 110,100, 95,112, 97,103,101,115, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x4d80 */  48, 48, 48, 48, 48, 48, 57, 55, 99, 32, 82, 95, 80, 80, 67, 54,
/* 0x4d90 */  52, 95, 82, 69, 76, 50, 52, 32, 32, 32, 32, 32,103,101,116, 95,
/* 0x4da0 */ 112, 97,103,101, 95,109, 97,115,107, 10, 48, 48, 48, 48, 48, 48,
/* 0x4db0 */  48, 48, 48, 48, 48, 48, 48, 97,102, 56, 32, 82, 95, 80, 80, 67,
/* 0x4dc0 */  54, 52, 95, 82, 69, 76, 50, 52, 32, 32, 32, 32, 32,117,112,120,
/* 0x4dd0 */ 102,100, 95, 99,114,101, 97,116,101, 10, 48, 48, 48, 48, 48, 48,
/* 0x4de0 */  48, 48, 48, 48, 48, 48, 48, 98, 48, 56, 32, 82, 95, 80, 80, 67,
/* 0x4df0 */  54, 52, 95, 82, 69, 76, 50, 52, 32, 32, 32, 32, 32,102,116,114,
/* 0x4e00 */ 117,110, 99, 97,116,101, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4e10 */  48, 48, 48, 48, 98, 50, 56, 32, 82, 95, 80, 80, 67, 54, 52, 95,
/* 0x4e20 */  82, 69, 76, 50, 52, 32, 32, 32, 32, 32,109,109, 97,112, 10, 48,
/* 0x4e30 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 98, 53, 56, 32,
/* 0x4e40 */  82, 95, 80, 80, 67, 54, 52, 95, 82, 69, 76, 50, 52, 32, 32, 32,
/* 0x4e50 */  32, 32,109,109, 97,112, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4e60 */  48, 48, 48, 48, 98, 56, 99, 32, 82, 95, 80, 80, 67, 54, 52, 95,
/* 0x4e70 */  82, 69, 76, 50, 52, 32, 32, 32, 32, 32,109,109, 97,112, 10, 48,
/* 0x4e80 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 99, 53, 48, 32,
/* 0x4e90 */  82, 95, 80, 80, 67, 54, 52, 95, 82, 69, 76, 50, 52, 32, 32, 32,
/* 0x4ea0 */  32, 32,117,112,120,102,100, 95, 99,114,101, 97,116,101, 10, 48,
/* 0x4eb0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 99, 54, 52, 32,
/* 0x4ec0 */  82, 95, 80, 80, 67, 54, 52, 95, 82, 69, 76, 50, 52, 32, 32, 32,
/* 0x4ed0 */  32, 32,119,114,105,116,101, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4ee0 */  48, 48, 48, 48, 48, 99, 56, 52, 32, 82, 95, 80, 80, 67, 54, 52,
/* 0x4ef0 */  95, 82, 69, 76, 50, 52, 32, 32, 32, 32, 32,109,109, 97,112, 10,
/* 0x4f00 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 99, 57, 52,
/* 0x4f10 */  32, 82, 95, 80, 80, 67, 54, 52, 95, 82, 69, 76, 50, 52, 32, 32,
/* 0x4f20 */  32, 32, 32, 99,108,111,115,101, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x4f30 */  48, 48, 48, 48, 48, 48, 99, 99, 48, 32, 82, 95, 80, 80, 67, 54,
/* 0x4f40 */  52, 95, 82, 69, 76, 50, 52, 32, 32, 32, 32, 32, 80,115,121,110,
/* 0x4f50 */  99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 99,
/* 0x4f60 */ 100, 48, 32, 82, 95, 80, 80, 67, 54, 52, 95, 82, 69, 76, 50, 52,
/* 0x4f70 */  32, 32, 32, 32, 32,109,117,110,109, 97,112, 10, 48, 48, 48, 48,
/* 0x4f80 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 99,102, 48, 32, 82, 95, 80,
/* 0x4f90 */  80, 67, 54, 52, 95, 82, 69, 76, 50, 52, 32, 32, 32, 32, 32,109,
/* 0x4fa0 */ 109, 97,112, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4fb0 */  48,100, 48, 52, 32, 82, 95, 80, 80, 67, 54, 52, 95, 82, 69, 76,
/* 0x4fc0 */  50, 52, 32, 32, 32, 32, 32, 99,108,111,115,101, 10, 48, 48, 48,
/* 0x4fd0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48,100, 50, 52, 32, 82, 95,
/* 0x4fe0 */  80, 80, 67, 54, 52, 95, 82, 69, 76, 50, 52, 32, 32, 32, 32, 32,
/* 0x4ff0 */  80,112,114,111,116,101, 99,116, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x5000 */  48, 48, 48, 48, 48, 48,100, 51, 56, 32, 82, 95, 80, 80, 67, 54,
/* 0x5010 */  52, 95, 82, 69, 76, 50, 52, 32, 32, 32, 32, 32,101,120,105,116,
/* 0x5020 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,100, 54,
/* 0x5030 */  48, 32, 82, 95, 80, 80, 67, 54, 52, 95, 82, 69, 76, 50, 52, 32,
/* 0x5040 */  32, 32, 32, 32,109,109, 97,112, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x5050 */  48, 48, 48, 48, 48, 48,100, 57, 52, 32, 82, 95, 80, 80, 67, 54,
/* 0x5060 */  52, 95, 82, 69, 76, 50, 52, 32, 32, 32, 32, 32, 98,114,107, 10,
/* 0x5070 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,101, 56, 48,
/* 0x5080 */  32, 82, 95, 80, 80, 67, 54, 52, 95, 82, 69, 76, 50, 52, 32, 32,
/* 0x5090 */  32, 32, 32,103,101,116, 95,112, 97,103,101, 95,109, 97,115,107,
/* 0x50a0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,101,102,
/* 0x50b0 */  56, 32, 82, 95, 80, 80, 67, 54, 52, 95, 82, 69, 76, 50, 52, 32,
/* 0x50c0 */  32, 32, 32, 32,111,112,101,110, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x50d0 */  48, 48, 48, 48, 48, 48,102, 49, 52, 32, 82, 95, 80, 80, 67, 54,
/* 0x50e0 */  52, 95, 82, 69, 76, 50, 52, 32, 32, 32, 32, 32,114,101, 97,100,
/* 0x50f0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,102, 50,
/* 0x5100 */  56, 32, 82, 95, 80, 80, 67, 54, 52, 95, 82, 69, 76, 50, 52, 32,
/* 0x5110 */  32, 32, 32, 32,101,120,105,116, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x5120 */  48, 48, 48, 48, 48, 48,102, 54, 52, 32, 82, 95, 80, 80, 67, 54,
/* 0x5130 */  52, 95, 82, 69, 76, 50, 52, 32, 32, 32, 32, 32, 99,108,111,115,
/* 0x5140 */ 101, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,
/* 0x5150 */  67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 69, 88, 80, 95, 72,
/* 0x5160 */  69, 65, 68, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 32,
/* 0x5170 */  32, 32, 32, 32, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,
/* 0x5180 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,
/* 0x5190 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 54, 48, 32,
/* 0x51a0 */  82, 95, 80, 80, 67, 54, 52, 95, 82, 69, 76, 50, 52, 32, 32, 32,
/* 0x51b0 */  32, 32, 69, 88, 80, 95, 84, 65, 73, 76, 43, 48,120, 48, 48, 48,
/* 0x51c0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 50, 56, 10, 10, 82,
/* 0x51d0 */  69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68,
/* 0x51e0 */  83, 32, 70, 79, 82, 32, 91, 78, 82, 86, 50, 69, 93, 58, 10, 79,
/* 0x51f0 */  70, 70, 83, 69, 84, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5200 */  84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5210 */  32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x5220 */  48, 48, 48, 48, 48, 48, 99, 56, 32, 82, 95, 80, 80, 67, 54, 52,
/* 0x5230 */  95, 82, 69, 76, 49, 52, 32, 32, 32, 32, 32,101,111,102, 95,110,
/* 0x5240 */ 114,118, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,
/* 0x5250 */  69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 82, 86, 50,
/* 0x5260 */  68, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 32, 32, 32,
/* 0x5270 */  32, 32, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x5280 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x5290 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 99, 99, 32, 82, 95,
/* 0x52a0 */  80, 80, 67, 54, 52, 95, 82, 69, 76, 49, 52, 32, 32, 32, 32, 32,
/* 0x52b0 */ 101,111,102, 95,110,114,118, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x52c0 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x52d0 */  91, 78, 82, 86, 50, 66, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,
/* 0x52e0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 84, 89, 80, 69, 32, 32,
/* 0x52f0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,
/* 0x5300 */  69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x5310 */  97, 48, 32, 82, 95, 80, 80, 67, 54, 52, 95, 82, 69, 76, 49, 52,
/* 0x5320 */  32, 32, 32, 32, 32,101,111,102, 95,110,114,118, 10, 10, 82, 69,
/* 0x5330 */  76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,
/* 0x5340 */  32, 70, 79, 82, 32, 91, 76, 90, 77, 65, 95, 68, 65, 73, 83, 89,
/* 0x5350 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 32, 32, 32, 32,
/* 0x5360 */  32, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5370 */  32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,
/* 0x5380 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 52, 32, 82, 95, 80,
/* 0x5390 */  80, 67, 54, 52, 95, 82, 69, 76, 49, 52, 32, 32, 32, 32, 32, 76,
/* 0x53a0 */  90, 77, 65, 95, 68, 69, 67, 51, 48, 43, 48,120, 48, 48, 48, 48,
/* 0x53b0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 51, 48, 10
};
