; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mattr=+sve -force-streaming-compatible  < %s | FileCheck %s
; RUN: llc -mattr=+sme -force-streaming  < %s | FileCheck %s
; RUN: llc -force-streaming-compatible < %s | FileCheck %s --check-prefix=NONEON-NOSVE

target triple = "aarch64-unknown-linux-gnu"

define <4 x i32> @test(ptr %arg1, ptr %arg2) {
; CHECK-LABEL: test:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ldp q0, q1, [x0, #32]
; CHECK-NEXT:    ldp q3, q4, [x0]
; CHECK-NEXT:    add z2.s, z0.s, z0.s
; CHECK-NEXT:    add z5.s, z1.s, z1.s
; CHECK-NEXT:    mov z0.s, z1.s[2]
; CHECK-NEXT:    add z1.s, z3.s, z3.s
; CHECK-NEXT:    add z3.s, z4.s, z4.s
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    stp q2, q5, [x0, #32]
; CHECK-NEXT:    stp q1, q3, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: test:
; NONEON-NOSVE:       // %bb.0: // %entry
; NONEON-NOSVE-NEXT:    sub sp, sp, #144
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 144
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0, #32]
; NONEON-NOSVE-NEXT:    ldp q2, q3, [x0]
; NONEON-NOSVE-NEXT:    str q1, [sp, #64]
; NONEON-NOSVE-NEXT:    stp q0, q3, [sp, #32]
; NONEON-NOSVE-NEXT:    ldr w9, [sp, #60]
; NONEON-NOSVE-NEXT:    str q2, [sp, #16]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #40]
; NONEON-NOSVE-NEXT:    add w9, w9, w9
; NONEON-NOSVE-NEXT:    stp w8, w8, [sp, #8]
; NONEON-NOSVE-NEXT:    str w9, [sp, #124]
; NONEON-NOSVE-NEXT:    ldr w9, [sp, #56]
; NONEON-NOSVE-NEXT:    stp w8, w8, [sp]
; NONEON-NOSVE-NEXT:    add w8, w8, w8
; NONEON-NOSVE-NEXT:    add w9, w9, w9
; NONEON-NOSVE-NEXT:    ldr q0, [sp]
; NONEON-NOSVE-NEXT:    str w9, [sp, #120]
; NONEON-NOSVE-NEXT:    ldr w9, [sp, #52]
; NONEON-NOSVE-NEXT:    add w9, w9, w9
; NONEON-NOSVE-NEXT:    str w9, [sp, #116]
; NONEON-NOSVE-NEXT:    ldr w9, [sp, #48]
; NONEON-NOSVE-NEXT:    add w9, w9, w9
; NONEON-NOSVE-NEXT:    str w9, [sp, #112]
; NONEON-NOSVE-NEXT:    ldr w9, [sp, #28]
; NONEON-NOSVE-NEXT:    add w9, w9, w9
; NONEON-NOSVE-NEXT:    str w9, [sp, #92]
; NONEON-NOSVE-NEXT:    ldr w9, [sp, #24]
; NONEON-NOSVE-NEXT:    add w9, w9, w9
; NONEON-NOSVE-NEXT:    str w9, [sp, #88]
; NONEON-NOSVE-NEXT:    ldr w9, [sp, #20]
; NONEON-NOSVE-NEXT:    add w9, w9, w9
; NONEON-NOSVE-NEXT:    str w9, [sp, #84]
; NONEON-NOSVE-NEXT:    ldr w9, [sp, #16]
; NONEON-NOSVE-NEXT:    add w9, w9, w9
; NONEON-NOSVE-NEXT:    str w9, [sp, #80]
; NONEON-NOSVE-NEXT:    ldr w9, [sp, #44]
; NONEON-NOSVE-NEXT:    add w9, w9, w9
; NONEON-NOSVE-NEXT:    stp w8, w9, [sp, #104]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #36]
; NONEON-NOSVE-NEXT:    add w8, w8, w8
; NONEON-NOSVE-NEXT:    str w8, [sp, #100]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #32]
; NONEON-NOSVE-NEXT:    add w8, w8, w8
; NONEON-NOSVE-NEXT:    str w8, [sp, #96]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #76]
; NONEON-NOSVE-NEXT:    ldp q4, q2, [sp, #80]
; NONEON-NOSVE-NEXT:    add w8, w8, w8
; NONEON-NOSVE-NEXT:    str w8, [sp, #140]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #72]
; NONEON-NOSVE-NEXT:    add w8, w8, w8
; NONEON-NOSVE-NEXT:    str w8, [sp, #136]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #68]
; NONEON-NOSVE-NEXT:    add w8, w8, w8
; NONEON-NOSVE-NEXT:    str w8, [sp, #132]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #64]
; NONEON-NOSVE-NEXT:    add w8, w8, w8
; NONEON-NOSVE-NEXT:    str w8, [sp, #128]
; NONEON-NOSVE-NEXT:    ldp q3, q1, [sp, #112]
; NONEON-NOSVE-NEXT:    stp q4, q3, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q2, [x0, #32]
; NONEON-NOSVE-NEXT:    add sp, sp, #144
; NONEON-NOSVE-NEXT:    ret
entry:
  %0 = load <16 x i32>, ptr %arg1, align 256
  %1 = load <16 x i32>, ptr %arg2, align 256
  %shvec = shufflevector <16 x i32> %0, <16 x i32> %1, <4 x i32> <i32 14, i32 14, i32 14, i32 14>
  %2 = add <16 x i32> %0, %0
  store <16 x i32> %2, ptr %arg1, align 256
  ret <4 x i32> %shvec
}

define <2 x i32> @test2(ptr %arg1, ptr %arg2) {
; CHECK-LABEL: test2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ldp q1, q0, [x0, #32]
; CHECK-NEXT:    ldp q3, q4, [x0]
; CHECK-NEXT:    add z2.s, z0.s, z0.s
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    add z1.s, z1.s, z1.s
; CHECK-NEXT:    add z3.s, z3.s, z3.s
; CHECK-NEXT:    add z4.s, z4.s, z4.s
; CHECK-NEXT:    mov z0.s, s0
; CHECK-NEXT:    stp q1, q2, [x0, #32]
; CHECK-NEXT:    stp q3, q4, [x0]
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: test2:
; NONEON-NOSVE:       // %bb.0: // %entry
; NONEON-NOSVE-NEXT:    sub sp, sp, #144
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 144
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0, #32]
; NONEON-NOSVE-NEXT:    ldp q2, q3, [x0]
; NONEON-NOSVE-NEXT:    str q1, [sp, #64]
; NONEON-NOSVE-NEXT:    stp q0, q3, [sp, #32]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #40]
; NONEON-NOSVE-NEXT:    str q2, [sp, #16]
; NONEON-NOSVE-NEXT:    str d0, [sp]
; NONEON-NOSVE-NEXT:    ldr w8, [sp]
; NONEON-NOSVE-NEXT:    stp w8, w8, [sp, #8]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #60]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #8]
; NONEON-NOSVE-NEXT:    add w8, w8, w8
; NONEON-NOSVE-NEXT:    str w8, [sp, #124]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #56]
; NONEON-NOSVE-NEXT:    add w8, w8, w8
; NONEON-NOSVE-NEXT:    str w8, [sp, #120]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #52]
; NONEON-NOSVE-NEXT:    add w8, w8, w8
; NONEON-NOSVE-NEXT:    str w8, [sp, #116]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #48]
; NONEON-NOSVE-NEXT:    add w8, w8, w8
; NONEON-NOSVE-NEXT:    str w8, [sp, #112]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #28]
; NONEON-NOSVE-NEXT:    add w8, w8, w8
; NONEON-NOSVE-NEXT:    str w8, [sp, #92]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #24]
; NONEON-NOSVE-NEXT:    add w8, w8, w8
; NONEON-NOSVE-NEXT:    str w8, [sp, #88]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #20]
; NONEON-NOSVE-NEXT:    add w8, w8, w8
; NONEON-NOSVE-NEXT:    str w8, [sp, #84]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #16]
; NONEON-NOSVE-NEXT:    add w8, w8, w8
; NONEON-NOSVE-NEXT:    str w8, [sp, #80]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #44]
; NONEON-NOSVE-NEXT:    add w8, w8, w8
; NONEON-NOSVE-NEXT:    str w8, [sp, #108]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #40]
; NONEON-NOSVE-NEXT:    add w8, w8, w8
; NONEON-NOSVE-NEXT:    str w8, [sp, #104]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #36]
; NONEON-NOSVE-NEXT:    add w8, w8, w8
; NONEON-NOSVE-NEXT:    str w8, [sp, #100]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #32]
; NONEON-NOSVE-NEXT:    add w8, w8, w8
; NONEON-NOSVE-NEXT:    str w8, [sp, #96]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #76]
; NONEON-NOSVE-NEXT:    ldp q4, q2, [sp, #80]
; NONEON-NOSVE-NEXT:    add w8, w8, w8
; NONEON-NOSVE-NEXT:    str w8, [sp, #140]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #72]
; NONEON-NOSVE-NEXT:    add w8, w8, w8
; NONEON-NOSVE-NEXT:    str w8, [sp, #136]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #68]
; NONEON-NOSVE-NEXT:    add w8, w8, w8
; NONEON-NOSVE-NEXT:    str w8, [sp, #132]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #64]
; NONEON-NOSVE-NEXT:    add w8, w8, w8
; NONEON-NOSVE-NEXT:    str w8, [sp, #128]
; NONEON-NOSVE-NEXT:    ldp q3, q1, [sp, #112]
; NONEON-NOSVE-NEXT:    stp q4, q3, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q2, [x0, #32]
; NONEON-NOSVE-NEXT:    add sp, sp, #144
; NONEON-NOSVE-NEXT:    ret
entry:
  %0 = load <16 x i32>, ptr %arg1, align 256
  %1 = load <16 x i32>, ptr %arg2, align 256
  %shvec = shufflevector <16 x i32> %0, <16 x i32> %1, <2 x i32> <i32 14, i32 14>
  %2 = add <16 x i32> %0, %0
  store <16 x i32> %2, ptr %arg1, align 256
  ret <2 x i32> %shvec
}
