; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple riscv64 -mattr=+f,+d,+v,+zfh,+zfbfmin,+zvfh,+zvfbfmin \
; RUN:   -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,NOVLDEP,ZVFH
; RUN: llc -mtriple riscv64 -mattr=+f,+d,+v,+zfh,+zfbfmin,+zvfhmin,+zvfbfmin \
; RUN:   -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,NOVLDEP,ZVFHMIN
; RUN: llc -mtriple riscv64 -mattr=+f,+d,+v,+zfh,+zfbfmin,+zvfh,+zvfbfmin,+vl-dependent-latency \
; RUN:   -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,VLDEP,ZVFH
; RUN: llc -mtriple riscv64 -mattr=+f,+d,+v,+zfh,+zfbfmin,+zvfhmin,+zvfbfmin,+vl-dependent-latency \
; RUN:   -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,VLDEP,ZVFHMIN

define <vscale x 2 x i64> @test_vp_splice_nxv2i64(<vscale x 2 x i64> %va, <vscale x 2 x i64> %vb, i32 zeroext %evla, i32 zeroext %evlb) #0 {
; NOVLDEP-LABEL: test_vp_splice_nxv2i64:
; NOVLDEP:       # %bb.0:
; NOVLDEP-NEXT:    vsetvli zero, a1, e64, m2, ta, ma
; NOVLDEP-NEXT:    vslidedown.vi v8, v8, 3
; NOVLDEP-NEXT:    addi a0, a0, -3
; NOVLDEP-NEXT:    vslideup.vx v8, v10, a0
; NOVLDEP-NEXT:    ret
;
; VLDEP-LABEL: test_vp_splice_nxv2i64:
; VLDEP:       # %bb.0:
; VLDEP-NEXT:    addi a0, a0, -3
; VLDEP-NEXT:    vsetvli zero, a0, e64, m2, ta, ma
; VLDEP-NEXT:    vslidedown.vi v8, v8, 3
; VLDEP-NEXT:    vsetvli zero, a1, e64, m2, ta, ma
; VLDEP-NEXT:    vslideup.vx v8, v10, a0
; VLDEP-NEXT:    ret
  %v = call <vscale x 2 x i64> @llvm.experimental.vp.splice.nxv2i64(<vscale x 2 x i64> %va, <vscale x 2 x i64> %vb, i32 3, <vscale x 2 x i1> splat (i1 1), i32 %evla, i32 %evlb)
  ret <vscale x 2 x i64> %v
}

define <vscale x 2 x i64> @test_vp_splice_nxv2i64_negative_offset(<vscale x 2 x i64> %va, <vscale x 2 x i64> %vb, i32 zeroext %evla, i32 zeroext %evlb) #0 {
; NOVLDEP-LABEL: test_vp_splice_nxv2i64_negative_offset:
; NOVLDEP:       # %bb.0:
; NOVLDEP-NEXT:    addi a0, a0, -3
; NOVLDEP-NEXT:    vsetvli zero, a1, e64, m2, ta, ma
; NOVLDEP-NEXT:    vslidedown.vx v8, v8, a0
; NOVLDEP-NEXT:    vslideup.vi v8, v10, 3
; NOVLDEP-NEXT:    ret
;
; VLDEP-LABEL: test_vp_splice_nxv2i64_negative_offset:
; VLDEP:       # %bb.0:
; VLDEP-NEXT:    addi a0, a0, -3
; VLDEP-NEXT:    vsetivli zero, 3, e64, m2, ta, ma
; VLDEP-NEXT:    vslidedown.vx v8, v8, a0
; VLDEP-NEXT:    vsetvli zero, a1, e64, m2, ta, ma
; VLDEP-NEXT:    vslideup.vi v8, v10, 3
; VLDEP-NEXT:    ret
  %v = call <vscale x 2 x i64> @llvm.experimental.vp.splice.nxv2i64(<vscale x 2 x i64> %va, <vscale x 2 x i64> %vb, i32 -3, <vscale x 2 x i1> splat (i1 1), i32 %evla, i32 %evlb)
  ret <vscale x 2 x i64> %v
}

define <vscale x 2 x i64> @test_vp_splice_nxv2i64_zero_offset(<vscale x 2 x i64> %va, <vscale x 2 x i64> %vb, i32 zeroext %evla, i32 zeroext %evlb) #0 {
; CHECK-LABEL: test_vp_splice_nxv2i64_zero_offset:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a1, e64, m2, ta, ma
; CHECK-NEXT:    vslideup.vx v8, v10, a0
; CHECK-NEXT:    ret
  %v = call <vscale x 2 x i64> @llvm.experimental.vp.splice.nxv2i64(<vscale x 2 x i64> %va, <vscale x 2 x i64> %vb, i32 0, <vscale x 2 x i1> splat (i1 1), i32 %evla, i32 %evlb)
  ret <vscale x 2 x i64> %v
}

define <vscale x 2 x i64> @test_vp_splice_nxv2i64_masked(<vscale x 2 x i64> %va, <vscale x 2 x i64> %vb, <vscale x 2 x i1> %mask, i32 zeroext %evla, i32 zeroext %evlb) #0 {
; NOVLDEP-LABEL: test_vp_splice_nxv2i64_masked:
; NOVLDEP:       # %bb.0:
; NOVLDEP-NEXT:    vsetvli zero, a1, e64, m2, ta, ma
; NOVLDEP-NEXT:    vslidedown.vi v8, v8, 3, v0.t
; NOVLDEP-NEXT:    addi a0, a0, -3
; NOVLDEP-NEXT:    vsetvli zero, zero, e64, m2, ta, mu
; NOVLDEP-NEXT:    vslideup.vx v8, v10, a0, v0.t
; NOVLDEP-NEXT:    ret
;
; VLDEP-LABEL: test_vp_splice_nxv2i64_masked:
; VLDEP:       # %bb.0:
; VLDEP-NEXT:    addi a0, a0, -3
; VLDEP-NEXT:    vsetvli zero, a0, e64, m2, ta, ma
; VLDEP-NEXT:    vslidedown.vi v8, v8, 3, v0.t
; VLDEP-NEXT:    vsetvli zero, a1, e64, m2, ta, mu
; VLDEP-NEXT:    vslideup.vx v8, v10, a0, v0.t
; VLDEP-NEXT:    ret
  %v = call <vscale x 2 x i64> @llvm.experimental.vp.splice.nxv2i64(<vscale x 2 x i64> %va, <vscale x 2 x i64> %vb, i32 3, <vscale x 2 x i1> %mask, i32 %evla, i32 %evlb)
  ret <vscale x 2 x i64> %v
}

define <vscale x 1 x i64> @test_vp_splice_nxv1i64(<vscale x 1 x i64> %va, <vscale x 1 x i64> %vb, i32 zeroext %evla, i32 zeroext %evlb) #0 {
; NOVLDEP-LABEL: test_vp_splice_nxv1i64:
; NOVLDEP:       # %bb.0:
; NOVLDEP-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; NOVLDEP-NEXT:    vslidedown.vi v8, v8, 1
; NOVLDEP-NEXT:    addi a0, a0, -1
; NOVLDEP-NEXT:    vslideup.vx v8, v9, a0
; NOVLDEP-NEXT:    ret
;
; VLDEP-LABEL: test_vp_splice_nxv1i64:
; VLDEP:       # %bb.0:
; VLDEP-NEXT:    addi a0, a0, -1
; VLDEP-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; VLDEP-NEXT:    vslidedown.vi v8, v8, 1
; VLDEP-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; VLDEP-NEXT:    vslideup.vx v8, v9, a0
; VLDEP-NEXT:    ret
  %v = call <vscale x 1 x i64> @llvm.experimental.vp.splice.nxv1i64(<vscale x 1 x i64> %va, <vscale x 1 x i64> %vb, i32 1, <vscale x 1 x i1> splat (i1 1), i32 %evla, i32 %evlb)
  ret <vscale x 1 x i64> %v
}

define <vscale x 1 x i64> @test_vp_splice_nxv1i64_negative_offset(<vscale x 1 x i64> %va, <vscale x 1 x i64> %vb, i32 zeroext %evla, i32 zeroext %evlb) #0 {
; NOVLDEP-LABEL: test_vp_splice_nxv1i64_negative_offset:
; NOVLDEP:       # %bb.0:
; NOVLDEP-NEXT:    addi a0, a0, -2
; NOVLDEP-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; NOVLDEP-NEXT:    vslidedown.vx v8, v8, a0
; NOVLDEP-NEXT:    vslideup.vi v8, v9, 2
; NOVLDEP-NEXT:    ret
;
; VLDEP-LABEL: test_vp_splice_nxv1i64_negative_offset:
; VLDEP:       # %bb.0:
; VLDEP-NEXT:    addi a0, a0, -2
; VLDEP-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; VLDEP-NEXT:    vslidedown.vx v8, v8, a0
; VLDEP-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; VLDEP-NEXT:    vslideup.vi v8, v9, 2
; VLDEP-NEXT:    ret
  %v = call <vscale x 1 x i64> @llvm.experimental.vp.splice.nxv1i64(<vscale x 1 x i64> %va, <vscale x 1 x i64> %vb, i32 -2, <vscale x 1 x i1> splat (i1 1), i32 %evla, i32 %evlb)
  ret <vscale x 1 x i64> %v
}

define <vscale x 1 x i64> @test_vp_splice_nxv1i64_masked(<vscale x 1 x i64> %va, <vscale x 1 x i64> %vb, <vscale x 1 x i1> %mask, i32 zeroext %evla, i32 zeroext %evlb) #0 {
; NOVLDEP-LABEL: test_vp_splice_nxv1i64_masked:
; NOVLDEP:       # %bb.0:
; NOVLDEP-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; NOVLDEP-NEXT:    vslidedown.vi v8, v8, 1, v0.t
; NOVLDEP-NEXT:    addi a0, a0, -1
; NOVLDEP-NEXT:    vsetvli zero, zero, e64, m1, ta, mu
; NOVLDEP-NEXT:    vslideup.vx v8, v9, a0, v0.t
; NOVLDEP-NEXT:    ret
;
; VLDEP-LABEL: test_vp_splice_nxv1i64_masked:
; VLDEP:       # %bb.0:
; VLDEP-NEXT:    addi a0, a0, -1
; VLDEP-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; VLDEP-NEXT:    vslidedown.vi v8, v8, 1, v0.t
; VLDEP-NEXT:    vsetvli zero, a1, e64, m1, ta, mu
; VLDEP-NEXT:    vslideup.vx v8, v9, a0, v0.t
; VLDEP-NEXT:    ret
  %v = call <vscale x 1 x i64> @llvm.experimental.vp.splice.nxv1i64(<vscale x 1 x i64> %va, <vscale x 1 x i64> %vb, i32 1, <vscale x 1 x i1> %mask, i32 %evla, i32 %evlb)
  ret <vscale x 1 x i64> %v
}

define <vscale x 2 x i32> @test_vp_splice_nxv2i32(<vscale x 2 x i32> %va, <vscale x 2 x i32> %vb, i32 zeroext %evla, i32 zeroext %evlb) #0 {
; NOVLDEP-LABEL: test_vp_splice_nxv2i32:
; NOVLDEP:       # %bb.0:
; NOVLDEP-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; NOVLDEP-NEXT:    vslidedown.vi v8, v8, 3
; NOVLDEP-NEXT:    addi a0, a0, -3
; NOVLDEP-NEXT:    vslideup.vx v8, v9, a0
; NOVLDEP-NEXT:    ret
;
; VLDEP-LABEL: test_vp_splice_nxv2i32:
; VLDEP:       # %bb.0:
; VLDEP-NEXT:    addi a0, a0, -3
; VLDEP-NEXT:    vsetvli zero, a0, e32, m1, ta, ma
; VLDEP-NEXT:    vslidedown.vi v8, v8, 3
; VLDEP-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; VLDEP-NEXT:    vslideup.vx v8, v9, a0
; VLDEP-NEXT:    ret
  %v = call <vscale x 2 x i32> @llvm.experimental.vp.splice.nxv2i32(<vscale x 2 x i32> %va, <vscale x 2 x i32> %vb, i32 3, <vscale x 2 x i1> splat (i1 1), i32 %evla, i32 %evlb)
  ret <vscale x 2 x i32> %v
}

define <vscale x 2 x i32> @test_vp_splice_nxv2i32_negative_offset(<vscale x 2 x i32> %va, <vscale x 2 x i32> %vb, i32 zeroext %evla, i32 zeroext %evlb) #0 {
; NOVLDEP-LABEL: test_vp_splice_nxv2i32_negative_offset:
; NOVLDEP:       # %bb.0:
; NOVLDEP-NEXT:    addi a0, a0, -4
; NOVLDEP-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; NOVLDEP-NEXT:    vslidedown.vx v8, v8, a0
; NOVLDEP-NEXT:    vslideup.vi v8, v9, 4
; NOVLDEP-NEXT:    ret
;
; VLDEP-LABEL: test_vp_splice_nxv2i32_negative_offset:
; VLDEP:       # %bb.0:
; VLDEP-NEXT:    addi a0, a0, -4
; VLDEP-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; VLDEP-NEXT:    vslidedown.vx v8, v8, a0
; VLDEP-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; VLDEP-NEXT:    vslideup.vi v8, v9, 4
; VLDEP-NEXT:    ret
  %v = call <vscale x 2 x i32> @llvm.experimental.vp.splice.nxv2i32(<vscale x 2 x i32> %va, <vscale x 2 x i32> %vb, i32 -4, <vscale x 2 x i1> splat (i1 1), i32 %evla, i32 %evlb)
  ret <vscale x 2 x i32> %v
}

define <vscale x 2 x i32> @test_vp_splice_nxv2i32_masked(<vscale x 2 x i32> %va, <vscale x 2 x i32> %vb, <vscale x 2 x i1> %mask, i32 zeroext %evla, i32 zeroext %evlb) #0 {
; NOVLDEP-LABEL: test_vp_splice_nxv2i32_masked:
; NOVLDEP:       # %bb.0:
; NOVLDEP-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; NOVLDEP-NEXT:    vslidedown.vi v8, v8, 3, v0.t
; NOVLDEP-NEXT:    addi a0, a0, -3
; NOVLDEP-NEXT:    vsetvli zero, zero, e32, m1, ta, mu
; NOVLDEP-NEXT:    vslideup.vx v8, v9, a0, v0.t
; NOVLDEP-NEXT:    ret
;
; VLDEP-LABEL: test_vp_splice_nxv2i32_masked:
; VLDEP:       # %bb.0:
; VLDEP-NEXT:    addi a0, a0, -3
; VLDEP-NEXT:    vsetvli zero, a0, e32, m1, ta, ma
; VLDEP-NEXT:    vslidedown.vi v8, v8, 3, v0.t
; VLDEP-NEXT:    vsetvli zero, a1, e32, m1, ta, mu
; VLDEP-NEXT:    vslideup.vx v8, v9, a0, v0.t
; VLDEP-NEXT:    ret
  %v = call <vscale x 2 x i32> @llvm.experimental.vp.splice.nxv2i32(<vscale x 2 x i32> %va, <vscale x 2 x i32> %vb, i32 3, <vscale x 2 x i1> %mask, i32 %evla, i32 %evlb)
  ret <vscale x 2 x i32> %v
}

define <vscale x 4 x i16> @test_vp_splice_nxv4i16(<vscale x 4 x i16> %va, <vscale x 4 x i16> %vb, i32 zeroext %evla, i32 zeroext %evlb) #0 {
; NOVLDEP-LABEL: test_vp_splice_nxv4i16:
; NOVLDEP:       # %bb.0:
; NOVLDEP-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; NOVLDEP-NEXT:    vslidedown.vi v8, v8, 5
; NOVLDEP-NEXT:    addi a0, a0, -5
; NOVLDEP-NEXT:    vslideup.vx v8, v9, a0
; NOVLDEP-NEXT:    ret
;
; VLDEP-LABEL: test_vp_splice_nxv4i16:
; VLDEP:       # %bb.0:
; VLDEP-NEXT:    addi a0, a0, -5
; VLDEP-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; VLDEP-NEXT:    vslidedown.vi v8, v8, 5
; VLDEP-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; VLDEP-NEXT:    vslideup.vx v8, v9, a0
; VLDEP-NEXT:    ret
  %v = call <vscale x 4 x i16> @llvm.experimental.vp.splice.nxv4i16(<vscale x 4 x i16> %va, <vscale x 4 x i16> %vb, i32 5, <vscale x 4 x i1> splat (i1 1), i32 %evla, i32 %evlb)
  ret <vscale x 4 x i16> %v
}

define <vscale x 4 x i16> @test_vp_splice_nxv4i16_negative_offset(<vscale x 4 x i16> %va, <vscale x 4 x i16> %vb, i32 zeroext %evla, i32 zeroext %evlb) #0 {
; NOVLDEP-LABEL: test_vp_splice_nxv4i16_negative_offset:
; NOVLDEP:       # %bb.0:
; NOVLDEP-NEXT:    addi a0, a0, -5
; NOVLDEP-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; NOVLDEP-NEXT:    vslidedown.vx v8, v8, a0
; NOVLDEP-NEXT:    vslideup.vi v8, v9, 5
; NOVLDEP-NEXT:    ret
;
; VLDEP-LABEL: test_vp_splice_nxv4i16_negative_offset:
; VLDEP:       # %bb.0:
; VLDEP-NEXT:    addi a0, a0, -5
; VLDEP-NEXT:    vsetivli zero, 5, e16, m1, ta, ma
; VLDEP-NEXT:    vslidedown.vx v8, v8, a0
; VLDEP-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; VLDEP-NEXT:    vslideup.vi v8, v9, 5
; VLDEP-NEXT:    ret
  %v = call <vscale x 4 x i16> @llvm.experimental.vp.splice.nxv4i16(<vscale x 4 x i16> %va, <vscale x 4 x i16> %vb, i32 -5, <vscale x 4 x i1> splat (i1 1), i32 %evla, i32 %evlb)
  ret <vscale x 4 x i16> %v
}

define <vscale x 4 x i16> @test_vp_splice_nxv4i16_masked(<vscale x 4 x i16> %va, <vscale x 4 x i16> %vb, <vscale x 4 x i1> %mask, i32 zeroext %evla, i32 zeroext %evlb) #0 {
; NOVLDEP-LABEL: test_vp_splice_nxv4i16_masked:
; NOVLDEP:       # %bb.0:
; NOVLDEP-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; NOVLDEP-NEXT:    vslidedown.vi v8, v8, 5, v0.t
; NOVLDEP-NEXT:    addi a0, a0, -5
; NOVLDEP-NEXT:    vsetvli zero, zero, e16, m1, ta, mu
; NOVLDEP-NEXT:    vslideup.vx v8, v9, a0, v0.t
; NOVLDEP-NEXT:    ret
;
; VLDEP-LABEL: test_vp_splice_nxv4i16_masked:
; VLDEP:       # %bb.0:
; VLDEP-NEXT:    addi a0, a0, -5
; VLDEP-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; VLDEP-NEXT:    vslidedown.vi v8, v8, 5, v0.t
; VLDEP-NEXT:    vsetvli zero, a1, e16, m1, ta, mu
; VLDEP-NEXT:    vslideup.vx v8, v9, a0, v0.t
; VLDEP-NEXT:    ret
  %v = call <vscale x 4 x i16> @llvm.experimental.vp.splice.nxv4i16(<vscale x 4 x i16> %va, <vscale x 4 x i16> %vb, i32 5, <vscale x 4 x i1> %mask, i32 %evla, i32 %evlb)
  ret <vscale x 4 x i16> %v
}

define <vscale x 8 x i8> @test_vp_splice_nxv8i8(<vscale x 8 x i8> %va, <vscale x 8 x i8> %vb, i32 zeroext %evla, i32 zeroext %evlb) #0 {
; NOVLDEP-LABEL: test_vp_splice_nxv8i8:
; NOVLDEP:       # %bb.0:
; NOVLDEP-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; NOVLDEP-NEXT:    vslidedown.vi v8, v8, 5
; NOVLDEP-NEXT:    addi a0, a0, -5
; NOVLDEP-NEXT:    vslideup.vx v8, v9, a0
; NOVLDEP-NEXT:    ret
;
; VLDEP-LABEL: test_vp_splice_nxv8i8:
; VLDEP:       # %bb.0:
; VLDEP-NEXT:    addi a0, a0, -5
; VLDEP-NEXT:    vsetvli zero, a0, e8, m1, ta, ma
; VLDEP-NEXT:    vslidedown.vi v8, v8, 5
; VLDEP-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; VLDEP-NEXT:    vslideup.vx v8, v9, a0
; VLDEP-NEXT:    ret
  %v = call <vscale x 8 x i8> @llvm.experimental.vp.splice.nxv8i8(<vscale x 8 x i8> %va, <vscale x 8 x i8> %vb, i32 5, <vscale x 8 x i1> splat (i1 1), i32 %evla, i32 %evlb)
  ret <vscale x 8 x i8> %v
}

define <vscale x 8 x i8> @test_vp_splice_nxv8i8_negative_offset(<vscale x 8 x i8> %va, <vscale x 8 x i8> %vb, i32 zeroext %evla, i32 zeroext %evlb) #0 {
; NOVLDEP-LABEL: test_vp_splice_nxv8i8_negative_offset:
; NOVLDEP:       # %bb.0:
; NOVLDEP-NEXT:    addi a0, a0, -5
; NOVLDEP-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; NOVLDEP-NEXT:    vslidedown.vx v8, v8, a0
; NOVLDEP-NEXT:    vslideup.vi v8, v9, 5
; NOVLDEP-NEXT:    ret
;
; VLDEP-LABEL: test_vp_splice_nxv8i8_negative_offset:
; VLDEP:       # %bb.0:
; VLDEP-NEXT:    addi a0, a0, -5
; VLDEP-NEXT:    vsetivli zero, 5, e8, m1, ta, ma
; VLDEP-NEXT:    vslidedown.vx v8, v8, a0
; VLDEP-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; VLDEP-NEXT:    vslideup.vi v8, v9, 5
; VLDEP-NEXT:    ret
  %v = call <vscale x 8 x i8> @llvm.experimental.vp.splice.nxv8i8(<vscale x 8 x i8> %va, <vscale x 8 x i8> %vb, i32 -5, <vscale x 8 x i1> splat (i1 1), i32 %evla, i32 %evlb)
  ret <vscale x 8 x i8> %v
}

define <vscale x 8 x i8> @test_vp_splice_nxv8i8_masked(<vscale x 8 x i8> %va, <vscale x 8 x i8> %vb, <vscale x 8 x i1> %mask, i32 zeroext %evla, i32 zeroext %evlb) #0 {
; NOVLDEP-LABEL: test_vp_splice_nxv8i8_masked:
; NOVLDEP:       # %bb.0:
; NOVLDEP-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; NOVLDEP-NEXT:    vslidedown.vi v8, v8, 5, v0.t
; NOVLDEP-NEXT:    addi a0, a0, -5
; NOVLDEP-NEXT:    vsetvli zero, zero, e8, m1, ta, mu
; NOVLDEP-NEXT:    vslideup.vx v8, v9, a0, v0.t
; NOVLDEP-NEXT:    ret
;
; VLDEP-LABEL: test_vp_splice_nxv8i8_masked:
; VLDEP:       # %bb.0:
; VLDEP-NEXT:    addi a0, a0, -5
; VLDEP-NEXT:    vsetvli zero, a0, e8, m1, ta, ma
; VLDEP-NEXT:    vslidedown.vi v8, v8, 5, v0.t
; VLDEP-NEXT:    vsetvli zero, a1, e8, m1, ta, mu
; VLDEP-NEXT:    vslideup.vx v8, v9, a0, v0.t
; VLDEP-NEXT:    ret
  %v = call <vscale x 8 x i8> @llvm.experimental.vp.splice.nxv8i8(<vscale x 8 x i8> %va, <vscale x 8 x i8> %vb, i32 5, <vscale x 8 x i1> %mask, i32 %evla, i32 %evlb)
  ret <vscale x 8 x i8> %v
}

define <vscale x 1 x double> @test_vp_splice_nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x double> %vb, i32 zeroext %evla, i32 zeroext %evlb) #0 {
; NOVLDEP-LABEL: test_vp_splice_nxv1f64:
; NOVLDEP:       # %bb.0:
; NOVLDEP-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; NOVLDEP-NEXT:    vslidedown.vi v8, v8, 1
; NOVLDEP-NEXT:    addi a0, a0, -1
; NOVLDEP-NEXT:    vslideup.vx v8, v9, a0
; NOVLDEP-NEXT:    ret
;
; VLDEP-LABEL: test_vp_splice_nxv1f64:
; VLDEP:       # %bb.0:
; VLDEP-NEXT:    addi a0, a0, -1
; VLDEP-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; VLDEP-NEXT:    vslidedown.vi v8, v8, 1
; VLDEP-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; VLDEP-NEXT:    vslideup.vx v8, v9, a0
; VLDEP-NEXT:    ret
  %v = call <vscale x 1 x double> @llvm.experimental.vp.splice.nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x double> %vb, i32 1, <vscale x 1 x i1> splat (i1 1), i32 %evla, i32 %evlb)
  ret <vscale x 1 x double> %v
}

define <vscale x 1 x double> @test_vp_splice_nxv1f64_negative_offset(<vscale x 1 x double> %va, <vscale x 1 x double> %vb, i32 zeroext %evla, i32 zeroext %evlb) #0 {
; NOVLDEP-LABEL: test_vp_splice_nxv1f64_negative_offset:
; NOVLDEP:       # %bb.0:
; NOVLDEP-NEXT:    addi a0, a0, -2
; NOVLDEP-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; NOVLDEP-NEXT:    vslidedown.vx v8, v8, a0
; NOVLDEP-NEXT:    vslideup.vi v8, v9, 2
; NOVLDEP-NEXT:    ret
;
; VLDEP-LABEL: test_vp_splice_nxv1f64_negative_offset:
; VLDEP:       # %bb.0:
; VLDEP-NEXT:    addi a0, a0, -2
; VLDEP-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; VLDEP-NEXT:    vslidedown.vx v8, v8, a0
; VLDEP-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; VLDEP-NEXT:    vslideup.vi v8, v9, 2
; VLDEP-NEXT:    ret
  %v = call <vscale x 1 x double> @llvm.experimental.vp.splice.nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x double> %vb, i32 -2, <vscale x 1 x i1> splat (i1 1), i32 %evla, i32 %evlb)
  ret <vscale x 1 x double> %v
}

define <vscale x 1 x double> @test_vp_splice_nxv1f64_masked(<vscale x 1 x double> %va, <vscale x 1 x double> %vb, <vscale x 1 x i1> %mask, i32 zeroext %evla, i32 zeroext %evlb) #0 {
; NOVLDEP-LABEL: test_vp_splice_nxv1f64_masked:
; NOVLDEP:       # %bb.0:
; NOVLDEP-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; NOVLDEP-NEXT:    vslidedown.vi v8, v8, 1, v0.t
; NOVLDEP-NEXT:    addi a0, a0, -1
; NOVLDEP-NEXT:    vsetvli zero, zero, e64, m1, ta, mu
; NOVLDEP-NEXT:    vslideup.vx v8, v9, a0, v0.t
; NOVLDEP-NEXT:    ret
;
; VLDEP-LABEL: test_vp_splice_nxv1f64_masked:
; VLDEP:       # %bb.0:
; VLDEP-NEXT:    addi a0, a0, -1
; VLDEP-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; VLDEP-NEXT:    vslidedown.vi v8, v8, 1, v0.t
; VLDEP-NEXT:    vsetvli zero, a1, e64, m1, ta, mu
; VLDEP-NEXT:    vslideup.vx v8, v9, a0, v0.t
; VLDEP-NEXT:    ret
  %v = call <vscale x 1 x double> @llvm.experimental.vp.splice.nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x double> %vb, i32 1, <vscale x 1 x i1> %mask, i32 %evla, i32 %evlb)
  ret <vscale x 1 x double> %v
}

define <vscale x 2 x float> @test_vp_splice_nxv2f32(<vscale x 2 x float> %va, <vscale x 2 x float> %vb, i32 zeroext %evla, i32 zeroext %evlb) #0 {
; NOVLDEP-LABEL: test_vp_splice_nxv2f32:
; NOVLDEP:       # %bb.0:
; NOVLDEP-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; NOVLDEP-NEXT:    vslidedown.vi v8, v8, 3
; NOVLDEP-NEXT:    addi a0, a0, -3
; NOVLDEP-NEXT:    vslideup.vx v8, v9, a0
; NOVLDEP-NEXT:    ret
;
; VLDEP-LABEL: test_vp_splice_nxv2f32:
; VLDEP:       # %bb.0:
; VLDEP-NEXT:    addi a0, a0, -3
; VLDEP-NEXT:    vsetvli zero, a0, e32, m1, ta, ma
; VLDEP-NEXT:    vslidedown.vi v8, v8, 3
; VLDEP-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; VLDEP-NEXT:    vslideup.vx v8, v9, a0
; VLDEP-NEXT:    ret
  %v = call <vscale x 2 x float> @llvm.experimental.vp.splice.nxv2f32(<vscale x 2 x float> %va, <vscale x 2 x float> %vb, i32 3, <vscale x 2 x i1> splat (i1 1), i32 %evla, i32 %evlb)
  ret <vscale x 2 x float> %v
}

define <vscale x 2 x float> @test_vp_splice_nxv2f32_negative_offset(<vscale x 2 x float> %va, <vscale x 2 x float> %vb, i32 zeroext %evla, i32 zeroext %evlb) #0 {
; NOVLDEP-LABEL: test_vp_splice_nxv2f32_negative_offset:
; NOVLDEP:       # %bb.0:
; NOVLDEP-NEXT:    addi a0, a0, -3
; NOVLDEP-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; NOVLDEP-NEXT:    vslidedown.vx v8, v8, a0
; NOVLDEP-NEXT:    vslideup.vi v8, v9, 3
; NOVLDEP-NEXT:    ret
;
; VLDEP-LABEL: test_vp_splice_nxv2f32_negative_offset:
; VLDEP:       # %bb.0:
; VLDEP-NEXT:    addi a0, a0, -3
; VLDEP-NEXT:    vsetivli zero, 3, e32, m1, ta, ma
; VLDEP-NEXT:    vslidedown.vx v8, v8, a0
; VLDEP-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; VLDEP-NEXT:    vslideup.vi v8, v9, 3
; VLDEP-NEXT:    ret
  %v = call <vscale x 2 x float> @llvm.experimental.vp.splice.nxv2f32(<vscale x 2 x float> %va, <vscale x 2 x float> %vb, i32 -3, <vscale x 2 x i1> splat (i1 1), i32 %evla, i32 %evlb)
  ret <vscale x 2 x float> %v
}

define <vscale x 2 x float> @test_vp_splice_nxv2f32_masked(<vscale x 2 x float> %va, <vscale x 2 x float> %vb, <vscale x 2 x i1> %mask, i32 zeroext %evla, i32 zeroext %evlb) #0 {
; NOVLDEP-LABEL: test_vp_splice_nxv2f32_masked:
; NOVLDEP:       # %bb.0:
; NOVLDEP-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; NOVLDEP-NEXT:    vslidedown.vi v8, v8, 3, v0.t
; NOVLDEP-NEXT:    addi a0, a0, -3
; NOVLDEP-NEXT:    vsetvli zero, zero, e32, m1, ta, mu
; NOVLDEP-NEXT:    vslideup.vx v8, v9, a0, v0.t
; NOVLDEP-NEXT:    ret
;
; VLDEP-LABEL: test_vp_splice_nxv2f32_masked:
; VLDEP:       # %bb.0:
; VLDEP-NEXT:    addi a0, a0, -3
; VLDEP-NEXT:    vsetvli zero, a0, e32, m1, ta, ma
; VLDEP-NEXT:    vslidedown.vi v8, v8, 3, v0.t
; VLDEP-NEXT:    vsetvli zero, a1, e32, m1, ta, mu
; VLDEP-NEXT:    vslideup.vx v8, v9, a0, v0.t
; VLDEP-NEXT:    ret
  %v = call <vscale x 2 x float> @llvm.experimental.vp.splice.nxv2f32(<vscale x 2 x float> %va, <vscale x 2 x float> %vb, i32 3, <vscale x 2 x i1> %mask, i32 %evla, i32 %evlb)
  ret <vscale x 2 x float> %v
}

define <vscale x 16 x i64> @test_vp_splice_nxv16i64(<vscale x 16 x i64> %va, <vscale x 16 x i64> %vb, i32 zeroext %evla, i32 zeroext %evlb) #0 {
; CHECK-LABEL: test_vp_splice_nxv16i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    csrr a4, vlenb
; CHECK-NEXT:    slli a5, a4, 1
; CHECK-NEXT:    addi a5, a5, -1
; CHECK-NEXT:    slli a1, a4, 3
; CHECK-NEXT:    mv a7, a2
; CHECK-NEXT:    bltu a2, a5, .LBB22_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    mv a7, a5
; CHECK-NEXT:  .LBB22_2:
; CHECK-NEXT:    addi sp, sp, -80
; CHECK-NEXT:    sd ra, 72(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s0, 64(sp) # 8-byte Folded Spill
; CHECK-NEXT:    addi s0, sp, 80
; CHECK-NEXT:    csrr a5, vlenb
; CHECK-NEXT:    slli a5, a5, 5
; CHECK-NEXT:    sub sp, sp, a5
; CHECK-NEXT:    andi sp, sp, -64
; CHECK-NEXT:    add a5, a0, a1
; CHECK-NEXT:    slli a7, a7, 3
; CHECK-NEXT:    addi a6, sp, 64
; CHECK-NEXT:    mv t0, a2
; CHECK-NEXT:    bltu a2, a4, .LBB22_4
; CHECK-NEXT:  # %bb.3:
; CHECK-NEXT:    mv t0, a4
; CHECK-NEXT:  .LBB22_4:
; CHECK-NEXT:    vl8re64.v v24, (a5)
; CHECK-NEXT:    add a5, a6, a7
; CHECK-NEXT:    vl8re64.v v0, (a0)
; CHECK-NEXT:    vsetvli zero, t0, e64, m8, ta, ma
; CHECK-NEXT:    vse64.v v8, (a6)
; CHECK-NEXT:    sub a0, a2, a4
; CHECK-NEXT:    sltu a2, a2, a0
; CHECK-NEXT:    addi a2, a2, -1
; CHECK-NEXT:    and a0, a2, a0
; CHECK-NEXT:    add a6, a6, a1
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    vse64.v v16, (a6)
; CHECK-NEXT:    mv a0, a3
; CHECK-NEXT:    bltu a3, a4, .LBB22_6
; CHECK-NEXT:  # %bb.5:
; CHECK-NEXT:    mv a0, a4
; CHECK-NEXT:  .LBB22_6:
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    vse64.v v0, (a5)
; CHECK-NEXT:    sub a2, a3, a4
; CHECK-NEXT:    add a5, a5, a1
; CHECK-NEXT:    sltu a3, a3, a2
; CHECK-NEXT:    addi a3, a3, -1
; CHECK-NEXT:    and a2, a3, a2
; CHECK-NEXT:    addi a3, sp, 104
; CHECK-NEXT:    add a1, a3, a1
; CHECK-NEXT:    vsetvli zero, a2, e64, m8, ta, ma
; CHECK-NEXT:    vse64.v v24, (a5)
; CHECK-NEXT:    vle64.v v16, (a1)
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    vle64.v v8, (a3)
; CHECK-NEXT:    addi sp, s0, -80
; CHECK-NEXT:    ld ra, 72(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s0, 64(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 80
; CHECK-NEXT:    ret
  %v = call <vscale x 16 x i64> @llvm.experimental.vp.splice.nxv16i64(<vscale x 16 x i64> %va, <vscale x 16 x i64> %vb, i32 5, <vscale x 16 x i1> splat (i1 1), i32 %evla, i32 %evlb)
  ret <vscale x 16 x i64> %v
}

define <vscale x 16 x i64> @test_vp_splice_nxv16i64_negative_offset(<vscale x 16 x i64> %va, <vscale x 16 x i64> %vb, i32 zeroext %evla, i32 zeroext %evlb) #0 {
; CHECK-LABEL: test_vp_splice_nxv16i64_negative_offset:
; CHECK:       # %bb.0:
; CHECK-NEXT:    csrr a5, vlenb
; CHECK-NEXT:    slli a6, a5, 1
; CHECK-NEXT:    addi a6, a6, -1
; CHECK-NEXT:    slli a1, a5, 3
; CHECK-NEXT:    mv a4, a2
; CHECK-NEXT:    bltu a2, a6, .LBB23_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    mv a4, a6
; CHECK-NEXT:  .LBB23_2:
; CHECK-NEXT:    addi sp, sp, -80
; CHECK-NEXT:    sd ra, 72(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s0, 64(sp) # 8-byte Folded Spill
; CHECK-NEXT:    addi s0, sp, 80
; CHECK-NEXT:    csrr a6, vlenb
; CHECK-NEXT:    slli a6, a6, 5
; CHECK-NEXT:    sub sp, sp, a6
; CHECK-NEXT:    andi sp, sp, -64
; CHECK-NEXT:    add a6, a0, a1
; CHECK-NEXT:    slli a4, a4, 3
; CHECK-NEXT:    addi a7, sp, 64
; CHECK-NEXT:    mv t0, a2
; CHECK-NEXT:    bltu a2, a5, .LBB23_4
; CHECK-NEXT:  # %bb.3:
; CHECK-NEXT:    mv t0, a5
; CHECK-NEXT:  .LBB23_4:
; CHECK-NEXT:    vl8re64.v v24, (a6)
; CHECK-NEXT:    add a6, a7, a4
; CHECK-NEXT:    vl8re64.v v0, (a0)
; CHECK-NEXT:    vsetvli zero, t0, e64, m8, ta, ma
; CHECK-NEXT:    vse64.v v8, (a7)
; CHECK-NEXT:    sub a0, a2, a5
; CHECK-NEXT:    sltu a2, a2, a0
; CHECK-NEXT:    addi a2, a2, -1
; CHECK-NEXT:    and a0, a2, a0
; CHECK-NEXT:    add a7, a7, a1
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    vse64.v v16, (a7)
; CHECK-NEXT:    mv a0, a3
; CHECK-NEXT:    bltu a3, a5, .LBB23_6
; CHECK-NEXT:  # %bb.5:
; CHECK-NEXT:    mv a0, a5
; CHECK-NEXT:  .LBB23_6:
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    vse64.v v0, (a6)
; CHECK-NEXT:    sub a2, a3, a5
; CHECK-NEXT:    add a5, a6, a1
; CHECK-NEXT:    sltu a3, a3, a2
; CHECK-NEXT:    addi a3, a3, -1
; CHECK-NEXT:    and a2, a3, a2
; CHECK-NEXT:    li a3, 8
; CHECK-NEXT:    vsetvli zero, a2, e64, m8, ta, ma
; CHECK-NEXT:    vse64.v v24, (a5)
; CHECK-NEXT:    bltu a4, a3, .LBB23_8
; CHECK-NEXT:  # %bb.7:
; CHECK-NEXT:    li a4, 8
; CHECK-NEXT:  .LBB23_8:
; CHECK-NEXT:    sub a2, a6, a4
; CHECK-NEXT:    add a1, a2, a1
; CHECK-NEXT:    vle64.v v16, (a1)
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    vle64.v v8, (a2)
; CHECK-NEXT:    addi sp, s0, -80
; CHECK-NEXT:    ld ra, 72(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s0, 64(sp) # 8-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 80
; CHECK-NEXT:    ret
  %v = call <vscale x 16 x i64> @llvm.experimental.vp.splice.nxv16i64(<vscale x 16 x i64> %va, <vscale x 16 x i64> %vb, i32 -1, <vscale x 16 x i1> splat (i1 1), i32 %evla, i32 %evlb)
  ret <vscale x 16 x i64> %v
}

define <vscale x 2 x half> @test_vp_splice_nxv2f16(<vscale x 2 x half> %va, <vscale x 2 x half> %vb, i32 zeroext %evla, i32 zeroext %evlb) #0 {
; NOVLDEP-LABEL: test_vp_splice_nxv2f16:
; NOVLDEP:       # %bb.0:
; NOVLDEP-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; NOVLDEP-NEXT:    vslidedown.vi v8, v8, 3
; NOVLDEP-NEXT:    addi a0, a0, -3
; NOVLDEP-NEXT:    vslideup.vx v8, v9, a0
; NOVLDEP-NEXT:    ret
;
; VLDEP-LABEL: test_vp_splice_nxv2f16:
; VLDEP:       # %bb.0:
; VLDEP-NEXT:    addi a0, a0, -3
; VLDEP-NEXT:    vsetvli zero, a0, e16, mf2, ta, ma
; VLDEP-NEXT:    vslidedown.vi v8, v8, 3
; VLDEP-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; VLDEP-NEXT:    vslideup.vx v8, v9, a0
; VLDEP-NEXT:    ret
  %v = call <vscale x 2 x half> @llvm.experimental.vp.splice.nxv2f16(<vscale x 2 x half> %va, <vscale x 2 x half> %vb, i32 3, <vscale x 2 x i1> splat (i1 1), i32 %evla, i32 %evlb)
  ret <vscale x 2 x half> %v
}

define <vscale x 2 x half> @test_vp_splice_nxv2f16_negative_offset(<vscale x 2 x half> %va, <vscale x 2 x half> %vb, i32 zeroext %evla, i32 zeroext %evlb) #0 {
; NOVLDEP-LABEL: test_vp_splice_nxv2f16_negative_offset:
; NOVLDEP:       # %bb.0:
; NOVLDEP-NEXT:    addi a0, a0, -3
; NOVLDEP-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; NOVLDEP-NEXT:    vslidedown.vx v8, v8, a0
; NOVLDEP-NEXT:    vslideup.vi v8, v9, 3
; NOVLDEP-NEXT:    ret
;
; VLDEP-LABEL: test_vp_splice_nxv2f16_negative_offset:
; VLDEP:       # %bb.0:
; VLDEP-NEXT:    addi a0, a0, -3
; VLDEP-NEXT:    vsetivli zero, 3, e16, mf2, ta, ma
; VLDEP-NEXT:    vslidedown.vx v8, v8, a0
; VLDEP-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; VLDEP-NEXT:    vslideup.vi v8, v9, 3
; VLDEP-NEXT:    ret
  %v = call <vscale x 2 x half> @llvm.experimental.vp.splice.nxv2f16(<vscale x 2 x half> %va, <vscale x 2 x half> %vb, i32 -3, <vscale x 2 x i1> splat (i1 1), i32 %evla, i32 %evlb)
  ret <vscale x 2 x half> %v
}

define <vscale x 2 x half> @test_vp_splice_nxv2f16_masked(<vscale x 2 x half> %va, <vscale x 2 x half> %vb, <vscale x 2 x i1> %mask, i32 zeroext %evla, i32 zeroext %evlb) #0 {
; NOVLDEP-LABEL: test_vp_splice_nxv2f16_masked:
; NOVLDEP:       # %bb.0:
; NOVLDEP-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; NOVLDEP-NEXT:    vslidedown.vi v8, v8, 3, v0.t
; NOVLDEP-NEXT:    addi a0, a0, -3
; NOVLDEP-NEXT:    vsetvli zero, zero, e16, mf2, ta, mu
; NOVLDEP-NEXT:    vslideup.vx v8, v9, a0, v0.t
; NOVLDEP-NEXT:    ret
;
; VLDEP-LABEL: test_vp_splice_nxv2f16_masked:
; VLDEP:       # %bb.0:
; VLDEP-NEXT:    addi a0, a0, -3
; VLDEP-NEXT:    vsetvli zero, a0, e16, mf2, ta, ma
; VLDEP-NEXT:    vslidedown.vi v8, v8, 3, v0.t
; VLDEP-NEXT:    vsetvli zero, a1, e16, mf2, ta, mu
; VLDEP-NEXT:    vslideup.vx v8, v9, a0, v0.t
; VLDEP-NEXT:    ret
  %v = call <vscale x 2 x half> @llvm.experimental.vp.splice.nxv2f16(<vscale x 2 x half> %va, <vscale x 2 x half> %vb, i32 3, <vscale x 2 x i1> %mask, i32 %evla, i32 %evlb)
  ret <vscale x 2 x half> %v
}

define <vscale x 2 x bfloat> @test_vp_splice_nxv2bf16(<vscale x 2 x bfloat> %va, <vscale x 2 x bfloat> %vb, i32 zeroext %evla, i32 zeroext %evlb) #0 {
; NOVLDEP-LABEL: test_vp_splice_nxv2bf16:
; NOVLDEP:       # %bb.0:
; NOVLDEP-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; NOVLDEP-NEXT:    vslidedown.vi v8, v8, 3
; NOVLDEP-NEXT:    addi a0, a0, -3
; NOVLDEP-NEXT:    vslideup.vx v8, v9, a0
; NOVLDEP-NEXT:    ret
;
; VLDEP-LABEL: test_vp_splice_nxv2bf16:
; VLDEP:       # %bb.0:
; VLDEP-NEXT:    addi a0, a0, -3
; VLDEP-NEXT:    vsetvli zero, a0, e16, mf2, ta, ma
; VLDEP-NEXT:    vslidedown.vi v8, v8, 3
; VLDEP-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; VLDEP-NEXT:    vslideup.vx v8, v9, a0
; VLDEP-NEXT:    ret
  %v = call <vscale x 2 x bfloat> @llvm.experimental.vp.splice.nxv2bf16(<vscale x 2 x bfloat> %va, <vscale x 2 x bfloat> %vb, i32 3, <vscale x 2 x i1> splat (i1 1), i32 %evla, i32 %evlb)
  ret <vscale x 2 x bfloat> %v
}

define <vscale x 2 x bfloat> @test_vp_splice_nxv2bf16_negative_offset(<vscale x 2 x bfloat> %va, <vscale x 2 x bfloat> %vb, i32 zeroext %evla, i32 zeroext %evlb) #0 {
; NOVLDEP-LABEL: test_vp_splice_nxv2bf16_negative_offset:
; NOVLDEP:       # %bb.0:
; NOVLDEP-NEXT:    addi a0, a0, -3
; NOVLDEP-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; NOVLDEP-NEXT:    vslidedown.vx v8, v8, a0
; NOVLDEP-NEXT:    vslideup.vi v8, v9, 3
; NOVLDEP-NEXT:    ret
;
; VLDEP-LABEL: test_vp_splice_nxv2bf16_negative_offset:
; VLDEP:       # %bb.0:
; VLDEP-NEXT:    addi a0, a0, -3
; VLDEP-NEXT:    vsetivli zero, 3, e16, mf2, ta, ma
; VLDEP-NEXT:    vslidedown.vx v8, v8, a0
; VLDEP-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; VLDEP-NEXT:    vslideup.vi v8, v9, 3
; VLDEP-NEXT:    ret
  %v = call <vscale x 2 x bfloat> @llvm.experimental.vp.splice.nxv2bf16(<vscale x 2 x bfloat> %va, <vscale x 2 x bfloat> %vb, i32 -3, <vscale x 2 x i1> splat (i1 1), i32 %evla, i32 %evlb)
  ret <vscale x 2 x bfloat> %v
}

define <vscale x 2 x bfloat> @test_vp_splice_nxv2bf16_masked(<vscale x 2 x bfloat> %va, <vscale x 2 x bfloat> %vb, <vscale x 2 x i1> %mask, i32 zeroext %evla, i32 zeroext %evlb) #0 {
; NOVLDEP-LABEL: test_vp_splice_nxv2bf16_masked:
; NOVLDEP:       # %bb.0:
; NOVLDEP-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; NOVLDEP-NEXT:    vslidedown.vi v8, v8, 3, v0.t
; NOVLDEP-NEXT:    addi a0, a0, -3
; NOVLDEP-NEXT:    vsetvli zero, zero, e16, mf2, ta, mu
; NOVLDEP-NEXT:    vslideup.vx v8, v9, a0, v0.t
; NOVLDEP-NEXT:    ret
;
; VLDEP-LABEL: test_vp_splice_nxv2bf16_masked:
; VLDEP:       # %bb.0:
; VLDEP-NEXT:    addi a0, a0, -3
; VLDEP-NEXT:    vsetvli zero, a0, e16, mf2, ta, ma
; VLDEP-NEXT:    vslidedown.vi v8, v8, 3, v0.t
; VLDEP-NEXT:    vsetvli zero, a1, e16, mf2, ta, mu
; VLDEP-NEXT:    vslideup.vx v8, v9, a0, v0.t
; VLDEP-NEXT:    ret
  %v = call <vscale x 2 x bfloat> @llvm.experimental.vp.splice.nxv2bf16(<vscale x 2 x bfloat> %va, <vscale x 2 x bfloat> %vb, i32 3, <vscale x 2 x i1> %mask, i32 %evla, i32 %evlb)
  ret <vscale x 2 x bfloat> %v
}

define <vscale x 2 x i32> @test_vp_splice_nxv2i32_with_firstelt(i32 %first, <vscale x 2 x i32> %vb, <vscale x 2 x i1> %mask, i32 zeroext %evl) #0 {
; CHECK-LABEL: test_vp_splice_nxv2i32_with_firstelt:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vslide1up.vx v9, v8, a0, v0.t
; CHECK-NEXT:    vmv.v.v v8, v9
; CHECK-NEXT:    ret
  %va = insertelement <vscale x 2 x i32> poison, i32 %first, i32 0
  %v = call <vscale x 2 x i32> @llvm.experimental.vp.splice.nxv2i32(<vscale x 2 x i32> %va, <vscale x 2 x i32> %vb, i32 0, <vscale x 2 x i1> %mask, i32 1, i32 %evl)
  ret <vscale x 2 x i32> %v
}

define <vscale x 2 x i32> @test_vp_splice_nxv2i32_with_splat_firstelt(i32 %first, <vscale x 2 x i32> %vb, <vscale x 2 x i1> %mask, i32 zeroext %evl) #0 {
; CHECK-LABEL: test_vp_splice_nxv2i32_with_splat_firstelt:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vslide1up.vx v9, v8, a0, v0.t
; CHECK-NEXT:    vmv.v.v v8, v9
; CHECK-NEXT:    ret
  %ins = insertelement <vscale x 2 x i32> poison, i32 %first, i32 0
  %splat = shufflevector <vscale x 2 x i32> %ins, <vscale x 2 x i32> poison, <vscale x 2 x i32> zeroinitializer
  %v = call <vscale x 2 x i32> @llvm.experimental.vp.splice.nxv2i32(<vscale x 2 x i32> %splat, <vscale x 2 x i32> %vb, i32 0, <vscale x 2 x i1> %mask, i32 1, i32 %evl)
  ret <vscale x 2 x i32> %v
}

define <vscale x 2 x float> @test_vp_splice_nxv2f32_with_firstelt(float %first, <vscale x 2 x float> %vb, <vscale x 2 x i1> %mask, i32 zeroext %evl) #0 {
; CHECK-LABEL: test_vp_splice_nxv2f32_with_firstelt:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, m1, ta, ma
; CHECK-NEXT:    vfslide1up.vf v9, v8, fa0, v0.t
; CHECK-NEXT:    vmv.v.v v8, v9
; CHECK-NEXT:    ret
  %va = insertelement <vscale x 2 x float> poison, float %first, i32 0
  %v = call <vscale x 2 x float> @llvm.experimental.vp.splice.nxv2f32(<vscale x 2 x float> %va, <vscale x 2 x float> %vb, i32 0, <vscale x 2 x i1> %mask, i32 1, i32 %evl)
  ret <vscale x 2 x float> %v
}

define <vscale x 2 x half> @test_vp_splice_nxv2f16_with_firstelt(half %first, <vscale x 2 x half> %vb, <vscale x 2 x i1> %mask, i32 zeroext %evl) #0 {
; ZVFH-LABEL: test_vp_splice_nxv2f16_with_firstelt:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, mf2, ta, ma
; ZVFH-NEXT:    vfslide1up.vf v9, v8, fa0, v0.t
; ZVFH-NEXT:    vmv1r.v v8, v9
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: test_vp_splice_nxv2f16_with_firstelt:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fmv.x.h a1, fa0
; ZVFHMIN-NEXT:    vsetvli zero, a0, e16, mf2, ta, ma
; ZVFHMIN-NEXT:    vslide1up.vx v9, v8, a1, v0.t
; ZVFHMIN-NEXT:    vmv1r.v v8, v9
; ZVFHMIN-NEXT:    ret
  %va = insertelement <vscale x 2 x half> poison, half %first, i32 0
  %v = call <vscale x 2 x half> @llvm.experimental.vp.splice.nxv2f16(<vscale x 2 x half> %va, <vscale x 2 x half> %vb, i32 0, <vscale x 2 x i1> %mask, i32 1, i32 %evl)
  ret <vscale x 2 x half> %v
}

define <vscale x 2 x bfloat> @test_vp_splice_nxv2bf16_with_firstelt(bfloat %first, <vscale x 2 x bfloat> %vb, <vscale x 2 x i1> %mask, i32 zeroext %evl) #0 {
; CHECK-LABEL: test_vp_splice_nxv2bf16_with_firstelt:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fmv.x.h a1, fa0
; CHECK-NEXT:    vsetvli zero, a0, e16, mf2, ta, ma
; CHECK-NEXT:    vslide1up.vx v9, v8, a1, v0.t
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %va = insertelement <vscale x 2 x bfloat> poison, bfloat %first, i32 0
  %v = call <vscale x 2 x bfloat> @llvm.experimental.vp.splice.nxv2bf16(<vscale x 2 x bfloat> %va, <vscale x 2 x bfloat> %vb, i32 0, <vscale x 2 x i1> %mask, i32 1, i32 %evl)
  ret <vscale x 2 x bfloat> %v
}

attributes #0 = { nounwind vscale_range(2,0) }
