; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=arm-eabi %s -o - | FileCheck %s --check-prefix=ARM
; RUN: llc -mtriple=thumbv6t2-eabi %s -o - | FileCheck %s --check-prefix=THUMB2
; RUN: llc -mtriple=thumb-eabi %s -o - | FileCheck %s --check-prefix=THUMB

define i32 @t9(i32 %v) nounwind readnone {
; ARM-LABEL: t9:
; ARM:       @ %bb.0: @ %entry
; ARM-NEXT:    add r0, r0, r0, lsl #3
; ARM-NEXT:    mov pc, lr
;
; THUMB2-LABEL: t9:
; THUMB2:       @ %bb.0: @ %entry
; THUMB2-NEXT:    add.w r0, r0, r0, lsl #3
; THUMB2-NEXT:    bx lr
;
; THUMB-LABEL: t9:
; THUMB:       @ %bb.0: @ %entry
; THUMB-NEXT:    movs r1, #9
; THUMB-NEXT:    muls r0, r1, r0
; THUMB-NEXT:    bx lr
entry:
	%0 = mul i32 %v, 9
	ret i32 %0
}

define i32 @t7(i32 %v) nounwind readnone {
; ARM-LABEL: t7:
; ARM:       @ %bb.0: @ %entry
; ARM-NEXT:    rsb r0, r0, r0, lsl #3
; ARM-NEXT:    mov pc, lr
;
; THUMB2-LABEL: t7:
; THUMB2:       @ %bb.0: @ %entry
; THUMB2-NEXT:    rsb r0, r0, r0, lsl #3
; THUMB2-NEXT:    bx lr
;
; THUMB-LABEL: t7:
; THUMB:       @ %bb.0: @ %entry
; THUMB-NEXT:    movs r1, #7
; THUMB-NEXT:    muls r0, r1, r0
; THUMB-NEXT:    bx lr
entry:
	%0 = mul i32 %v, 7
	ret i32 %0
}

define i32 @t5(i32 %v) nounwind readnone {
; ARM-LABEL: t5:
; ARM:       @ %bb.0: @ %entry
; ARM-NEXT:    add r0, r0, r0, lsl #2
; ARM-NEXT:    mov pc, lr
;
; THUMB2-LABEL: t5:
; THUMB2:       @ %bb.0: @ %entry
; THUMB2-NEXT:    add.w r0, r0, r0, lsl #2
; THUMB2-NEXT:    bx lr
;
; THUMB-LABEL: t5:
; THUMB:       @ %bb.0: @ %entry
; THUMB-NEXT:    movs r1, #5
; THUMB-NEXT:    muls r0, r1, r0
; THUMB-NEXT:    bx lr
entry:
        %0 = mul i32 %v, 5
        ret i32 %0
}

define i32 @t3(i32 %v) nounwind readnone {
; ARM-LABEL: t3:
; ARM:       @ %bb.0: @ %entry
; ARM-NEXT:    add r0, r0, r0, lsl #1
; ARM-NEXT:    mov pc, lr
;
; THUMB2-LABEL: t3:
; THUMB2:       @ %bb.0: @ %entry
; THUMB2-NEXT:    add.w r0, r0, r0, lsl #1
; THUMB2-NEXT:    bx lr
;
; THUMB-LABEL: t3:
; THUMB:       @ %bb.0: @ %entry
; THUMB-NEXT:    movs r1, #3
; THUMB-NEXT:    muls r0, r1, r0
; THUMB-NEXT:    bx lr
entry:
        %0 = mul i32 %v, 3
        ret i32 %0
}

define i32 @t12288(i32 %v) nounwind readnone {
; ARM-LABEL: t12288:
; ARM:       @ %bb.0: @ %entry
; ARM-NEXT:    add r0, r0, r0, lsl #1
; ARM-NEXT:    lsl r0, r0, #12
; ARM-NEXT:    mov pc, lr
;
; THUMB2-LABEL: t12288:
; THUMB2:       @ %bb.0: @ %entry
; THUMB2-NEXT:    add.w r0, r0, r0, lsl #1
; THUMB2-NEXT:    lsls r0, r0, #12
; THUMB2-NEXT:    bx lr
;
; THUMB-LABEL: t12288:
; THUMB:       @ %bb.0: @ %entry
; THUMB-NEXT:    movs r1, #3
; THUMB-NEXT:    lsls r1, r1, #12
; THUMB-NEXT:    muls r0, r1, r0
; THUMB-NEXT:    bx lr
entry:
        %0 = mul i32 %v, 12288
        ret i32 %0
}

define i32 @tn9(i32 %v) nounwind readnone {
; ARM-LABEL: tn9:
; ARM:       @ %bb.0: @ %entry
; ARM-NEXT:    add r0, r0, r0, lsl #3
; ARM-NEXT:    rsb r0, r0, #0
; ARM-NEXT:    mov pc, lr
;
; THUMB2-LABEL: tn9:
; THUMB2:       @ %bb.0: @ %entry
; THUMB2-NEXT:    add.w r0, r0, r0, lsl #3
; THUMB2-NEXT:    rsbs r0, r0, #0
; THUMB2-NEXT:    bx lr
;
; THUMB-LABEL: tn9:
; THUMB:       @ %bb.0: @ %entry
; THUMB-NEXT:    movs r1, #8
; THUMB-NEXT:    mvns r1, r1
; THUMB-NEXT:    muls r0, r1, r0
; THUMB-NEXT:    bx lr
entry:
        %0 = mul i32 %v, -9
        ret i32 %0
}

define i32 @tn7(i32 %v) nounwind readnone {
; ARM-LABEL: tn7:
; ARM:       @ %bb.0: @ %entry
; ARM-NEXT:    sub r0, r0, r0, lsl #3
; ARM-NEXT:    mov pc, lr
;
; THUMB2-LABEL: tn7:
; THUMB2:       @ %bb.0: @ %entry
; THUMB2-NEXT:    sub.w r0, r0, r0, lsl #3
; THUMB2-NEXT:    bx lr
;
; THUMB-LABEL: tn7:
; THUMB:       @ %bb.0: @ %entry
; THUMB-NEXT:    movs r1, #6
; THUMB-NEXT:    mvns r1, r1
; THUMB-NEXT:    muls r0, r1, r0
; THUMB-NEXT:    bx lr
entry:
	%0 = mul i32 %v, -7
	ret i32 %0
}

define i32 @tn5(i32 %v) nounwind readnone {
; ARM-LABEL: tn5:
; ARM:       @ %bb.0: @ %entry
; ARM-NEXT:    add r0, r0, r0, lsl #2
; ARM-NEXT:    rsb r0, r0, #0
; ARM-NEXT:    mov pc, lr
;
; THUMB2-LABEL: tn5:
; THUMB2:       @ %bb.0: @ %entry
; THUMB2-NEXT:    add.w r0, r0, r0, lsl #2
; THUMB2-NEXT:    rsbs r0, r0, #0
; THUMB2-NEXT:    bx lr
;
; THUMB-LABEL: tn5:
; THUMB:       @ %bb.0: @ %entry
; THUMB-NEXT:    movs r1, #4
; THUMB-NEXT:    mvns r1, r1
; THUMB-NEXT:    muls r0, r1, r0
; THUMB-NEXT:    bx lr
entry:
        %0 = mul i32 %v, -5
        ret i32 %0
}

define i32 @tn3(i32 %v) nounwind readnone {
; ARM-LABEL: tn3:
; ARM:       @ %bb.0: @ %entry
; ARM-NEXT:    sub r0, r0, r0, lsl #2
; ARM-NEXT:    mov pc, lr
;
; THUMB2-LABEL: tn3:
; THUMB2:       @ %bb.0: @ %entry
; THUMB2-NEXT:    sub.w r0, r0, r0, lsl #2
; THUMB2-NEXT:    bx lr
;
; THUMB-LABEL: tn3:
; THUMB:       @ %bb.0: @ %entry
; THUMB-NEXT:    movs r1, #2
; THUMB-NEXT:    mvns r1, r1
; THUMB-NEXT:    muls r0, r1, r0
; THUMB-NEXT:    bx lr
entry:
; CHECK-LABEL: tn3:
; CHECK: sub r0, r0, r0, lsl #2
        %0 = mul i32 %v, -3
        ret i32 %0
}

define i32 @tn12288(i32 %v) nounwind readnone {
; ARM-LABEL: tn12288:
; ARM:       @ %bb.0: @ %entry
; ARM-NEXT:    sub r0, r0, r0, lsl #2
; ARM-NEXT:    lsl r0, r0, #12
; ARM-NEXT:    mov pc, lr
;
; THUMB2-LABEL: tn12288:
; THUMB2:       @ %bb.0: @ %entry
; THUMB2-NEXT:    sub.w r0, r0, r0, lsl #2
; THUMB2-NEXT:    lsls r0, r0, #12
; THUMB2-NEXT:    bx lr
;
; THUMB-LABEL: tn12288:
; THUMB:       @ %bb.0: @ %entry
; THUMB-NEXT:    ldr r1, .LCPI9_0
; THUMB-NEXT:    muls r0, r1, r0
; THUMB-NEXT:    bx lr
; THUMB-NEXT:    .p2align 2
; THUMB-NEXT:  @ %bb.1:
; THUMB-NEXT:  .LCPI9_0:
; THUMB-NEXT:    .long 4294955008 @ 0xffffd000
entry:
; CHECK-LABEL: tn12288:
; CHECK: sub r0, r0, r0, lsl #2
; CHECK: lsl{{.*}}#12
        %0 = mul i32 %v, -12288
        ret i32 %0
}
