/* A Bison parser, made by GNU Bison 3.8.2.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2015, 2018-2021 Free Software Foundation,
   Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <https://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* DO NOT RELY ON FEATURES THAT ARE NOT DOCUMENTED in the manual,
   especially those whose name start with YY_ or yy_.  They are
   private implementation details that can be changed or removed.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output, and Bison version.  */
#define YYBISON 30802

/* Bison version string.  */
#define YYBISON_VERSION "3.8.2"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 2

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1




/* First part of user prologue.  */
#line 30 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"


#define yyerror Lily_parser::parser_error

/* We use custom location type: Input objects */
#define YYLTYPE Input
#define YYSTYPE SCM
#define YYLLOC_DEFAULT(Current,Rhs,N) \
	((Current).set_location ((Rhs)[1], (Rhs)[N]))

#define YYPRINT(file, type, value)					\
	do {								\
		if (scm_is_eq (value, SCM_UNSPECIFIED))			\
			break;						\
		SCM s = Display::value_to_lily_string (value);		\
		char *p = scm_to_locale_string (s);			\
		fputs (p, file);					\
		free (p);						\
	} while (0)


#define lookup_identifier(x) lookup_identifier_symbol (ly_symbol2scm (x))

#line 101 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
 // -*-Fundamental-*-

/*
FIXME:

   * The rules for who is protecting what are very shady.  Uniformise
     this.

   * There are too many lexical modes?
*/

#include "config.hh"

#include <cctype>
#include <cstdlib>
#include <cstdio>

#include "book.hh"
#include "context.hh"
#include "context-def.hh"
#include "context-mod.hh"
#include "dimensions.hh"
#include "file-path.hh"
#include "input.hh"
#include "international.hh"
#include "lily-guile.hh"
#include "lily-lexer.hh"
#include "lily-parser.hh"
#include "ly-module.hh"
#include "ly-scm-list.hh"
#include "misc.hh"
#include "music.hh"
#include "output-def.hh"
#include "scm-hash.hh"
#include "score.hh"
#include "std-vector.hh"
#include "text-interface.hh"
#include "warn.hh"
#include "lily-imports.hh"

void
Lily_parser::parser_error (Input const *i, Lily_parser *parser, SCM *, const std::string &s)
{
	parser->parser_error (*i, s);
}

// The following are somewhat precarious constructs as they may change
// the value of the lookahead token.  That implies that the lookahead
// token must not yet have made an impact on the state stack other
// than causing the reduction of the current rule, or switching the
// lookahead token while Bison is mulling it over will cause trouble.

#define MYBACKUP(Token, Value, Location)				\
	do {								\
		if (yychar != YYEMPTY)					\
			parser->lexer_->push_extra_token		\
				(yylloc, yychar, yylval);		\
		parser->lexer_->push_extra_token			\
			(Location, Token, Value);			\
		parser->lexer_->push_extra_token (Location, BACKUP);	\
		yychar = YYEMPTY;					\
	} while (0)


#define MYREPARSE(Location, Pred, Token, Value)				\
	do {								\
		if (yychar != YYEMPTY)					\
			parser->lexer_->push_extra_token		\
				(yylloc, yychar, yylval);		\
		parser->lexer_->push_extra_token			\
			(Location, Token, Value);			\
		parser->lexer_->push_extra_token			\
			(Location, REPARSE, Pred);			\
		yychar = YYEMPTY;					\
	} while (0)

#line 180 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"


#define MY_MAKE_MUSIC(x, spot) \
	make_music_with_input (ly_symbol2scm (x), \
			       parser->lexer_->override_input (spot))

/* ES TODO:
- delay application of the function
*/

#define LOWLEVEL_MAKE_SYNTAX(location, proc, ...)			\
	with_location							\
		(parser->lexer_->override_input (location).smobbed_copy (), \
		 proc,							\
		 ##__VA_ARGS__)

/* Syntactic Sugar. */
#define MAKE_SYNTAX(name, location, ...)				\
	LOWLEVEL_MAKE_SYNTAX (location, Syntax::name, ##__VA_ARGS__)

#define START_MAKE_SYNTAX(name, ...)					\
	ly_list (Syntax::name, ##__VA_ARGS__)

#define FINISH_MAKE_SYNTAX(start, location, ...)			\
	LOWLEVEL_MAKE_SYNTAX						\
		(location,						\
		 Guile_user::apply,					\
		 scm_car (start),					\
		 scm_append_x						\
		 (ly_list (scm_cdr (start),				\
		           ly_list (__VA_ARGS__))))

#undef _
#if !HAVE_GETTEXT
#define _(x) x
#else
#include <libintl.h>
#define _(x) gettext (x)
#endif

using std::string;

static Music *make_music_with_input (SCM name, Input where);
bool add_post_events (Music *music, SCM events);
SCM reverse_music_list (Lily_parser *parser, Input loc, SCM lst, bool preserve, bool compress);
SCM check_scheme_arg (Lily_parser *parser, Input loc,
		      SCM arg, SCM args, SCM pred, SCM disp = SCM_UNDEFINED);
SCM make_music_from_simple (Lily_parser *parser, Input loc, SCM pitch);
SCM loc_on_copy (Lily_parser *parser, Input loc, SCM arg);
SCM make_chord_elements (Input loc, SCM pitch, SCM dur, SCM modification_list);
SCM make_chord_step (SCM step, Rational alter);
SCM make_simple_markup (SCM a);
SCM make_duration (SCM t, int dots = 0, SCM factor = SCM_UNDEFINED);
bool is_regular_identifier (SCM id, bool multiple=false);
SCM make_reverse_key_list (SCM keys);
SCM try_word_variants (SCM pred, SCM str);
SCM try_string_variants (SCM pred, SCM str);
SCM post_event_cons (SCM ev, SCM tail);
void property_path_dot_warning (Input loc, SCM lst);
int yylex (YYSTYPE *s, YYLTYPE *loc, Lily_parser *parser);


// generated code may trigger conversion warnings
#pragma GCC diagnostic ignored "-Wconversion"

// generated code triggers a false positive in GCC 11
// https://gcc.gnu.org/bugzilla/show_bug.cgi?id=98753
#pragma GCC diagnostic ignored "-Wfree-nonheap-object"

// generated code contains some old-style casts
#pragma GCC diagnostic ignored "-Wold-style-cast"

// generated code contains some useless casts
#pragma GCC diagnostic ignored "-Wuseless-cast"


#line 249 "./out/parser.cc"

# ifndef YY_CAST
#  ifdef __cplusplus
#   define YY_CAST(Type, Val) static_cast<Type> (Val)
#   define YY_REINTERPRET_CAST(Type, Val) reinterpret_cast<Type> (Val)
#  else
#   define YY_CAST(Type, Val) ((Type) (Val))
#   define YY_REINTERPRET_CAST(Type, Val) ((Type) (Val))
#  endif
# endif
# ifndef YY_NULLPTR
#  if defined __cplusplus
#   if 201103L <= __cplusplus
#    define YY_NULLPTR nullptr
#   else
#    define YY_NULLPTR 0
#   endif
#  else
#   define YY_NULLPTR ((void*)0)
#  endif
# endif

#include "parser.hh"
/* Symbol kind.  */
enum yysymbol_kind_t
{
  YYSYMBOL_YYEMPTY = -2,
  YYSYMBOL_YYEOF = 0,                      /* "end of input"  */
  YYSYMBOL_YYerror = 1,                    /* error  */
  YYSYMBOL_YYUNDEF = 2,                    /* "invalid token"  */
  YYSYMBOL_PREC_BOT = 3,                   /* PREC_BOT  */
  YYSYMBOL_COMPOSITE = 4,                  /* COMPOSITE  */
  YYSYMBOL_5_ = 5,                         /* ':'  */
  YYSYMBOL_6_ = 6,                         /* '^'  */
  YYSYMBOL_7___ = 7,                       /* '_'  */
  YYSYMBOL_8_ = 8,                         /* '!'  */
  YYSYMBOL_9_ = 9,                         /* '\''  */
  YYSYMBOL_10_ = 10,                       /* ','  */
  YYSYMBOL_PREC_TOP = 11,                  /* PREC_TOP  */
  YYSYMBOL_ACCEPTS = 12,                   /* "\\accepts"  */
  YYSYMBOL_ADDLYRICS = 13,                 /* "\\addlyrics"  */
  YYSYMBOL_ALIAS = 14,                     /* "\\alias"  */
  YYSYMBOL_ALTERNATIVE = 15,               /* "\\alternative"  */
  YYSYMBOL_BOOK = 16,                      /* "\\book"  */
  YYSYMBOL_BOOKPART = 17,                  /* "\\bookpart"  */
  YYSYMBOL_CHANGE = 18,                    /* "\\change"  */
  YYSYMBOL_CHORDMODE = 19,                 /* "\\chordmode"  */
  YYSYMBOL_CHORDS = 20,                    /* "\\chords"  */
  YYSYMBOL_CONSISTS = 21,                  /* "\\consists"  */
  YYSYMBOL_CONTEXT = 22,                   /* "\\context"  */
  YYSYMBOL_DEFAULT = 23,                   /* "\\default"  */
  YYSYMBOL_DEFAULTCHILD = 24,              /* "\\defaultchild"  */
  YYSYMBOL_DENIES = 25,                    /* "\\denies"  */
  YYSYMBOL_DESCRIPTION = 26,               /* "\\description"  */
  YYSYMBOL_DRUMMODE = 27,                  /* "\\drummode"  */
  YYSYMBOL_DRUMS = 28,                     /* "\\drums"  */
  YYSYMBOL_ETC = 29,                       /* "\\etc"  */
  YYSYMBOL_FIGUREMODE = 30,                /* "\\figuremode"  */
  YYSYMBOL_FIGURES = 31,                   /* "\\figures"  */
  YYSYMBOL_HEADER = 32,                    /* "\\header"  */
  YYSYMBOL_INVALID = 33,                   /* "\\version-error"  */
  YYSYMBOL_LAYOUT = 34,                    /* "\\layout"  */
  YYSYMBOL_LYRICMODE = 35,                 /* "\\lyricmode"  */
  YYSYMBOL_LYRICS = 36,                    /* "\\lyrics"  */
  YYSYMBOL_LYRICSTO = 37,                  /* "\\lyricsto"  */
  YYSYMBOL_MARKUP = 38,                    /* "\\markup"  */
  YYSYMBOL_MARKUPLIST = 39,                /* "\\markuplist"  */
  YYSYMBOL_MIDI = 40,                      /* "\\midi"  */
  YYSYMBOL_NAME = 41,                      /* "\\name"  */
  YYSYMBOL_NOTEMODE = 42,                  /* "\\notemode"  */
  YYSYMBOL_OVERRIDE = 43,                  /* "\\override"  */
  YYSYMBOL_PAPER = 44,                     /* "\\paper"  */
  YYSYMBOL_REMOVE = 45,                    /* "\\remove"  */
  YYSYMBOL_REPEAT = 46,                    /* "\\repeat"  */
  YYSYMBOL_REST = 47,                      /* "\\rest"  */
  YYSYMBOL_REVERT = 48,                    /* "\\revert"  */
  YYSYMBOL_SCORE = 49,                     /* "\\score"  */
  YYSYMBOL_SCORELINES = 50,                /* "\\score-lines"  */
  YYSYMBOL_SEQUENTIAL = 51,                /* "\\sequential"  */
  YYSYMBOL_SET = 52,                       /* "\\set"  */
  YYSYMBOL_SIMULTANEOUS = 53,              /* "\\simultaneous"  */
  YYSYMBOL_TEMPO = 54,                     /* "\\tempo"  */
  YYSYMBOL_TYPE = 55,                      /* "\\type"  */
  YYSYMBOL_UNSET = 56,                     /* "\\unset"  */
  YYSYMBOL_WITH = 57,                      /* "\\with"  */
  YYSYMBOL_NEWCONTEXT = 58,                /* "\\new"  */
  YYSYMBOL_CHORD_BASS = 59,                /* "/+"  */
  YYSYMBOL_CHORD_CARET = 60,               /* "^"  */
  YYSYMBOL_CHORD_COLON = 61,               /* ":"  */
  YYSYMBOL_CHORD_MINUS = 62,               /* "-"  */
  YYSYMBOL_CHORD_SLASH = 63,               /* "/"  */
  YYSYMBOL_ANGLE_OPEN = 64,                /* "<"  */
  YYSYMBOL_ANGLE_CLOSE = 65,               /* ">"  */
  YYSYMBOL_DOUBLE_ANGLE_OPEN = 66,         /* "<<"  */
  YYSYMBOL_DOUBLE_ANGLE_CLOSE = 67,        /* ">>"  */
  YYSYMBOL_E_BACKSLASH = 68,               /* "\\\\"  */
  YYSYMBOL_E_EXCLAMATION = 69,             /* "\\!"  */
  YYSYMBOL_E_PLUS = 70,                    /* "\\+"  */
  YYSYMBOL_EXTENDER = 71,                  /* "__"  */
  YYSYMBOL_FIGURE_CLOSE = 72,              /* FIGURE_CLOSE  */
  YYSYMBOL_FIGURE_OPEN = 73,               /* FIGURE_OPEN  */
  YYSYMBOL_FIGURE_SPACE = 74,              /* "_"  */
  YYSYMBOL_FIGURE_ALTERATION_EXPR = 75,    /* FIGURE_ALTERATION_EXPR  */
  YYSYMBOL_HYPHEN = 76,                    /* "--"  */
  YYSYMBOL_MULTI_MEASURE_REST = 77,        /* MULTI_MEASURE_REST  */
  YYSYMBOL_E_UNSIGNED = 78,                /* E_UNSIGNED  */
  YYSYMBOL_UNSIGNED = 79,                  /* UNSIGNED  */
  YYSYMBOL_EXPECT_MARKUP = 80,             /* "markup?"  */
  YYSYMBOL_EXPECT_SCM = 81,                /* "scheme?"  */
  YYSYMBOL_BACKUP = 82,                    /* "(backed-up?)"  */
  YYSYMBOL_REPARSE = 83,                   /* "(reparsed?)"  */
  YYSYMBOL_EXPECT_MARKUP_LIST = 84,        /* "markup-list?"  */
  YYSYMBOL_EXPECT_OPTIONAL = 85,           /* "optional?"  */
  YYSYMBOL_EXPECT_NO_MORE_ARGS = 86,       /* EXPECT_NO_MORE_ARGS  */
  YYSYMBOL_EMBEDDED_LILY = 87,             /* "#{"  */
  YYSYMBOL_BOOK_IDENTIFIER = 88,           /* BOOK_IDENTIFIER  */
  YYSYMBOL_CHORD_MODIFIER = 89,            /* CHORD_MODIFIER  */
  YYSYMBOL_CHORD_REPETITION = 90,          /* CHORD_REPETITION  */
  YYSYMBOL_DRUM_PITCH = 91,                /* DRUM_PITCH  */
  YYSYMBOL_DURATION_ARG = 92,              /* DURATION_ARG  */
  YYSYMBOL_DURATION_IDENTIFIER = 93,       /* DURATION_IDENTIFIER  */
  YYSYMBOL_EVENT_IDENTIFIER = 94,          /* EVENT_IDENTIFIER  */
  YYSYMBOL_EVENT_FUNCTION = 95,            /* EVENT_FUNCTION  */
  YYSYMBOL_FRACTION = 96,                  /* FRACTION  */
  YYSYMBOL_LOOKUP_IDENTIFIER = 97,         /* LOOKUP_IDENTIFIER  */
  YYSYMBOL_LYRIC_ELEMENT = 98,             /* LYRIC_ELEMENT  */
  YYSYMBOL_MARKUP_FUNCTION = 99,           /* MARKUP_FUNCTION  */
  YYSYMBOL_MARKUP_LIST_FUNCTION = 100,     /* MARKUP_LIST_FUNCTION  */
  YYSYMBOL_MARKUP_IDENTIFIER = 101,        /* MARKUP_IDENTIFIER  */
  YYSYMBOL_MARKUPLIST_IDENTIFIER = 102,    /* MARKUPLIST_IDENTIFIER  */
  YYSYMBOL_MUSIC_FUNCTION = 103,           /* MUSIC_FUNCTION  */
  YYSYMBOL_MUSIC_IDENTIFIER = 104,         /* MUSIC_IDENTIFIER  */
  YYSYMBOL_NOTENAME_PITCH = 105,           /* NOTENAME_PITCH  */
  YYSYMBOL_NUMBER_IDENTIFIER = 106,        /* NUMBER_IDENTIFIER  */
  YYSYMBOL_PITCH_IDENTIFIER = 107,         /* PITCH_IDENTIFIER  */
  YYSYMBOL_REAL = 108,                     /* REAL  */
  YYSYMBOL_RESTNAME = 109,                 /* RESTNAME  */
  YYSYMBOL_SCM_ARG = 110,                  /* SCM_ARG  */
  YYSYMBOL_SCM_FUNCTION = 111,             /* SCM_FUNCTION  */
  YYSYMBOL_SCM_IDENTIFIER = 112,           /* SCM_IDENTIFIER  */
  YYSYMBOL_SCM_TOKEN = 113,                /* SCM_TOKEN  */
  YYSYMBOL_STRING = 114,                   /* STRING  */
  YYSYMBOL_SYMBOL_LIST = 115,              /* SYMBOL_LIST  */
  YYSYMBOL_TONICNAME_PITCH = 116,          /* TONICNAME_PITCH  */
  YYSYMBOL_SYMBOL = 117,                   /* SYMBOL  */
  YYSYMBOL_118_ = 118,                     /* '-'  */
  YYSYMBOL_119_ = 119,                     /* '+'  */
  YYSYMBOL_UNARY_MINUS = 120,              /* UNARY_MINUS  */
  YYSYMBOL_121_ = 121,                     /* '.'  */
  YYSYMBOL_122_ = 122,                     /* '{'  */
  YYSYMBOL_123_ = 123,                     /* '}'  */
  YYSYMBOL_124_ = 124,                     /* '='  */
  YYSYMBOL_125_ = 125,                     /* '*'  */
  YYSYMBOL_126_ = 126,                     /* ']'  */
  YYSYMBOL_127_ = 127,                     /* '/'  */
  YYSYMBOL_128_ = 128,                     /* '['  */
  YYSYMBOL_129_ = 129,                     /* '?'  */
  YYSYMBOL_YYACCEPT = 130,                 /* $accept  */
  YYSYMBOL_start_symbol = 131,             /* start_symbol  */
  YYSYMBOL_132_1 = 132,                    /* $@1  */
  YYSYMBOL_lilypond = 133,                 /* lilypond  */
  YYSYMBOL_toplevel_expression = 134,      /* toplevel_expression  */
  YYSYMBOL_lookup = 135,                   /* lookup  */
  YYSYMBOL_embedded_scm_bare = 136,        /* embedded_scm_bare  */
  YYSYMBOL_embedded_scm_active = 137,      /* embedded_scm_active  */
  YYSYMBOL_embedded_scm_bare_arg = 138,    /* embedded_scm_bare_arg  */
  YYSYMBOL_embedded_scm = 139,             /* embedded_scm  */
  YYSYMBOL_embedded_scm_arg = 140,         /* embedded_scm_arg  */
  YYSYMBOL_scm_function_call = 141,        /* scm_function_call  */
  YYSYMBOL_embedded_lilypond_number = 142, /* embedded_lilypond_number  */
  YYSYMBOL_embedded_lilypond = 143,        /* embedded_lilypond  */
  YYSYMBOL_lilypond_header_body = 144,     /* lilypond_header_body  */
  YYSYMBOL_lilypond_header = 145,          /* lilypond_header  */
  YYSYMBOL_header_block = 146,             /* header_block  */
  YYSYMBOL_147_2 = 147,                    /* $@2  */
  YYSYMBOL_assignment_id = 148,            /* assignment_id  */
  YYSYMBOL_assignment = 149,               /* assignment  */
  YYSYMBOL_identifier_init = 150,          /* identifier_init  */
  YYSYMBOL_identifier_init_nonumber = 151, /* identifier_init_nonumber  */
  YYSYMBOL_partial_function_scriptable = 152, /* partial_function_scriptable  */
  YYSYMBOL_partial_function = 153,         /* partial_function  */
  YYSYMBOL_context_def_spec_block = 154,   /* context_def_spec_block  */
  YYSYMBOL_context_mod_arg = 155,          /* context_mod_arg  */
  YYSYMBOL_156_3 = 156,                    /* $@3  */
  YYSYMBOL_context_def_spec_body = 157,    /* context_def_spec_body  */
  YYSYMBOL_book_block = 158,               /* book_block  */
  YYSYMBOL_book_body = 159,                /* book_body  */
  YYSYMBOL_160_4 = 160,                    /* $@4  */
  YYSYMBOL_bookpart_block = 161,           /* bookpart_block  */
  YYSYMBOL_bookpart_body = 162,            /* bookpart_body  */
  YYSYMBOL_163_5 = 163,                    /* $@5  */
  YYSYMBOL_score_block = 164,              /* score_block  */
  YYSYMBOL_score_body = 165,               /* score_body  */
  YYSYMBOL_score_item = 166,               /* score_item  */
  YYSYMBOL_score_items = 167,              /* score_items  */
  YYSYMBOL_168_6 = 168,                    /* $@6  */
  YYSYMBOL_paper_block = 169,              /* paper_block  */
  YYSYMBOL_output_def = 170,               /* output_def  */
  YYSYMBOL_output_def_head = 171,          /* output_def_head  */
  YYSYMBOL_output_def_head_with_mode_switch = 172, /* output_def_head_with_mode_switch  */
  YYSYMBOL_music_or_context_def = 173,     /* music_or_context_def  */
  YYSYMBOL_output_def_body = 174,          /* output_def_body  */
  YYSYMBOL_175_7 = 175,                    /* $@7  */
  YYSYMBOL_tempo_event = 176,              /* tempo_event  */
  YYSYMBOL_music_list = 177,               /* music_list  */
  YYSYMBOL_braced_music_list = 178,        /* braced_music_list  */
  YYSYMBOL_music = 179,                    /* music  */
  YYSYMBOL_pitch_as_music = 180,           /* pitch_as_music  */
  YYSYMBOL_music_embedded = 181,           /* music_embedded  */
  YYSYMBOL_music_embedded_backup = 182,    /* music_embedded_backup  */
  YYSYMBOL_music_assign = 183,             /* music_assign  */
  YYSYMBOL_repeated_music = 184,           /* repeated_music  */
  YYSYMBOL_sequential_alternative_music = 185, /* sequential_alternative_music  */
  YYSYMBOL_sequential_music = 186,         /* sequential_music  */
  YYSYMBOL_simultaneous_music = 187,       /* simultaneous_music  */
  YYSYMBOL_simple_music = 188,             /* simple_music  */
  YYSYMBOL_context_modification = 189,     /* context_modification  */
  YYSYMBOL_190_8 = 190,                    /* $@8  */
  YYSYMBOL_context_modification_arg = 191, /* context_modification_arg  */
  YYSYMBOL_optional_context_mods = 192,    /* optional_context_mods  */
  YYSYMBOL_context_modification_mods_list = 193, /* context_modification_mods_list  */
  YYSYMBOL_context_mod_list = 194,         /* context_mod_list  */
  YYSYMBOL_context_prefix = 195,           /* context_prefix  */
  YYSYMBOL_new_lyrics = 196,               /* new_lyrics  */
  YYSYMBOL_basic_music = 197,              /* basic_music  */
  YYSYMBOL_contextable_music = 198,        /* contextable_music  */
  YYSYMBOL_contexted_basic_music = 199,    /* contexted_basic_music  */
  YYSYMBOL_composite_music = 200,          /* composite_music  */
  YYSYMBOL_music_bare = 201,               /* music_bare  */
  YYSYMBOL_grouped_music_list = 202,       /* grouped_music_list  */
  YYSYMBOL_symbol_list_arg = 203,          /* symbol_list_arg  */
  YYSYMBOL_symbol_list_rev = 204,          /* symbol_list_rev  */
  YYSYMBOL_symbol_list_part = 205,         /* symbol_list_part  */
  YYSYMBOL_symbol_list_element = 206,      /* symbol_list_element  */
  YYSYMBOL_symbol_list_part_bare = 207,    /* symbol_list_part_bare  */
  YYSYMBOL_function_arglist_nonbackup = 208, /* function_arglist_nonbackup  */
  YYSYMBOL_reparsed_rhythm = 209,          /* reparsed_rhythm  */
  YYSYMBOL_function_arglist_nonbackup_reparse = 210, /* function_arglist_nonbackup_reparse  */
  YYSYMBOL_function_arglist_backup = 211,  /* function_arglist_backup  */
  YYSYMBOL_function_arglist = 212,         /* function_arglist  */
  YYSYMBOL_function_arglist_skip_nonbackup = 213, /* function_arglist_skip_nonbackup  */
  YYSYMBOL_function_arglist_partial = 214, /* function_arglist_partial  */
  YYSYMBOL_function_arglist_partial_optional = 215, /* function_arglist_partial_optional  */
  YYSYMBOL_function_arglist_common = 216,  /* function_arglist_common  */
  YYSYMBOL_function_arglist_common_reparse = 217, /* function_arglist_common_reparse  */
  YYSYMBOL_function_arglist_optional = 218, /* function_arglist_optional  */
  YYSYMBOL_function_arglist_skip_backup = 219, /* function_arglist_skip_backup  */
  YYSYMBOL_music_function_call = 220,      /* music_function_call  */
  YYSYMBOL_optional_id = 221,              /* optional_id  */
  YYSYMBOL_lyric_mode_music = 222,         /* lyric_mode_music  */
  YYSYMBOL_223_9 = 223,                    /* $@9  */
  YYSYMBOL_mode_changed_music = 224,       /* mode_changed_music  */
  YYSYMBOL_mode_changing_head = 225,       /* mode_changing_head  */
  YYSYMBOL_mode_changing_head_with_context = 226, /* mode_changing_head_with_context  */
  YYSYMBOL_context_change = 227,           /* context_change  */
  YYSYMBOL_property_path = 228,            /* property_path  */
  YYSYMBOL_property_operation = 229,       /* property_operation  */
  YYSYMBOL_revert_arg = 230,               /* revert_arg  */
  YYSYMBOL_revert_arg_backup = 231,        /* revert_arg_backup  */
  YYSYMBOL_revert_arg_part = 232,          /* revert_arg_part  */
  YYSYMBOL_context_def_mod = 233,          /* context_def_mod  */
  YYSYMBOL_context_mod = 234,              /* context_mod  */
  YYSYMBOL_grob_prop_spec = 235,           /* grob_prop_spec  */
  YYSYMBOL_grob_prop_path = 236,           /* grob_prop_path  */
  YYSYMBOL_context_prop_spec = 237,        /* context_prop_spec  */
  YYSYMBOL_simple_revert_context = 238,    /* simple_revert_context  */
  YYSYMBOL_music_property_def = 239,       /* music_property_def  */
  YYSYMBOL_string = 240,                   /* string  */
  YYSYMBOL_text = 241,                     /* text  */
  YYSYMBOL_simple_string = 242,            /* simple_string  */
  YYSYMBOL_symbol = 243,                   /* symbol  */
  YYSYMBOL_scalar = 244,                   /* scalar  */
  YYSYMBOL_event_chord = 245,              /* event_chord  */
  YYSYMBOL_note_chord_element = 246,       /* note_chord_element  */
  YYSYMBOL_chord_body = 247,               /* chord_body  */
  YYSYMBOL_chord_body_elements = 248,      /* chord_body_elements  */
  YYSYMBOL_chord_body_element = 249,       /* chord_body_element  */
  YYSYMBOL_music_function_chord_body = 250, /* music_function_chord_body  */
  YYSYMBOL_event_function_event = 251,     /* event_function_event  */
  YYSYMBOL_post_events = 252,              /* post_events  */
  YYSYMBOL_post_event_nofinger = 253,      /* post_event_nofinger  */
  YYSYMBOL_post_event = 254,               /* post_event  */
  YYSYMBOL_string_number_event = 255,      /* string_number_event  */
  YYSYMBOL_direction_less_event = 256,     /* direction_less_event  */
  YYSYMBOL_direction_reqd_event = 257,     /* direction_reqd_event  */
  YYSYMBOL_octave_check = 258,             /* octave_check  */
  YYSYMBOL_quotes = 259,                   /* quotes  */
  YYSYMBOL_erroneous_quotes = 260,         /* erroneous_quotes  */
  YYSYMBOL_sup_quotes = 261,               /* sup_quotes  */
  YYSYMBOL_sub_quotes = 262,               /* sub_quotes  */
  YYSYMBOL_steno_pitch = 263,              /* steno_pitch  */
  YYSYMBOL_steno_tonic_pitch = 264,        /* steno_tonic_pitch  */
  YYSYMBOL_pitch = 265,                    /* pitch  */
  YYSYMBOL_pitch_or_tonic_pitch = 266,     /* pitch_or_tonic_pitch  */
  YYSYMBOL_gen_text_def = 267,             /* gen_text_def  */
  YYSYMBOL_fingering = 268,                /* fingering  */
  YYSYMBOL_script_abbreviation = 269,      /* script_abbreviation  */
  YYSYMBOL_script_dir = 270,               /* script_dir  */
  YYSYMBOL_maybe_notemode_duration = 271,  /* maybe_notemode_duration  */
  YYSYMBOL_optional_notemode_duration = 272, /* optional_notemode_duration  */
  YYSYMBOL_steno_duration = 273,           /* steno_duration  */
  YYSYMBOL_duration = 274,                 /* duration  */
  YYSYMBOL_dots = 275,                     /* dots  */
  YYSYMBOL_multiplier_scm = 276,           /* multiplier_scm  */
  YYSYMBOL_multipliers = 277,              /* multipliers  */
  YYSYMBOL_tremolo_type = 278,             /* tremolo_type  */
  YYSYMBOL_bass_number = 279,              /* bass_number  */
  YYSYMBOL_bass_figure = 280,              /* bass_figure  */
  YYSYMBOL_figured_bass_modification = 281, /* figured_bass_modification  */
  YYSYMBOL_br_bass_figure = 282,           /* br_bass_figure  */
  YYSYMBOL_figure_list = 283,              /* figure_list  */
  YYSYMBOL_optional_rest = 284,            /* optional_rest  */
  YYSYMBOL_pitch_or_music = 285,           /* pitch_or_music  */
  YYSYMBOL_simple_element = 286,           /* simple_element  */
  YYSYMBOL_lyric_element = 287,            /* lyric_element  */
  YYSYMBOL_lyric_element_music = 288,      /* lyric_element_music  */
  YYSYMBOL_new_chord = 289,                /* new_chord  */
  YYSYMBOL_chord_items = 290,              /* chord_items  */
  YYSYMBOL_chord_separator = 291,          /* chord_separator  */
  YYSYMBOL_chord_item = 292,               /* chord_item  */
  YYSYMBOL_step_numbers = 293,             /* step_numbers  */
  YYSYMBOL_step_number = 294,              /* step_number  */
  YYSYMBOL_tempo_range = 295,              /* tempo_range  */
  YYSYMBOL_number_expression = 296,        /* number_expression  */
  YYSYMBOL_number_term = 297,              /* number_term  */
  YYSYMBOL_number_factor = 298,            /* number_factor  */
  YYSYMBOL_bare_number_common = 299,       /* bare_number_common  */
  YYSYMBOL_bare_number = 300,              /* bare_number  */
  YYSYMBOL_unsigned_number = 301,          /* unsigned_number  */
  YYSYMBOL_exclamations = 302,             /* exclamations  */
  YYSYMBOL_questions = 303,                /* questions  */
  YYSYMBOL_full_markup_list = 304,         /* full_markup_list  */
  YYSYMBOL_305_10 = 305,                   /* $@10  */
  YYSYMBOL_markup_mode = 306,              /* markup_mode  */
  YYSYMBOL_markup_mode_word = 307,         /* markup_mode_word  */
  YYSYMBOL_full_markup = 308,              /* full_markup  */
  YYSYMBOL_partial_markup = 309,           /* partial_markup  */
  YYSYMBOL_markup_top = 310,               /* markup_top  */
  YYSYMBOL_markup_scm = 311,               /* markup_scm  */
  YYSYMBOL_312_11 = 312,                   /* $@11  */
  YYSYMBOL_markup_list = 313,              /* markup_list  */
  YYSYMBOL_markup_uncomposed_list = 314,   /* markup_uncomposed_list  */
  YYSYMBOL_315_12 = 315,                   /* $@12  */
  YYSYMBOL_markup_composed_list = 316,     /* markup_composed_list  */
  YYSYMBOL_markup_braced_list = 317,       /* markup_braced_list  */
  YYSYMBOL_markup_braced_list_body = 318,  /* markup_braced_list_body  */
  YYSYMBOL_markup_command_list = 319,      /* markup_command_list  */
  YYSYMBOL_markup_command_embedded_lilypond = 320, /* markup_command_embedded_lilypond  */
  YYSYMBOL_321_13 = 321,                   /* $@13  */
  YYSYMBOL_markup_command_basic_arguments = 322, /* markup_command_basic_arguments  */
  YYSYMBOL_markup_command_list_arguments = 323, /* markup_command_list_arguments  */
  YYSYMBOL_markup_partial_function = 324,  /* markup_partial_function  */
  YYSYMBOL_markup_arglist_partial = 325,   /* markup_arglist_partial  */
  YYSYMBOL_markup_head_1_item = 326,       /* markup_head_1_item  */
  YYSYMBOL_markup_head_1_list = 327,       /* markup_head_1_list  */
  YYSYMBOL_markup_word = 328,              /* markup_word  */
  YYSYMBOL_simple_markup = 329,            /* simple_markup  */
  YYSYMBOL_simple_markup_noword = 330,     /* simple_markup_noword  */
  YYSYMBOL_331_14 = 331,                   /* $@14  */
  YYSYMBOL_markup = 332                    /* markup  */
};
typedef enum yysymbol_kind_t yysymbol_kind_t;




#ifdef short
# undef short
#endif

/* On compilers that do not define __PTRDIFF_MAX__ etc., make sure
   <limits.h> and (if available) <stdint.h> are included
   so that the code can choose integer types of a good width.  */

#ifndef __PTRDIFF_MAX__
# include <limits.h> /* INFRINGES ON USER NAME SPACE */
# if defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stdint.h> /* INFRINGES ON USER NAME SPACE */
#  define YY_STDINT_H
# endif
#endif

/* Narrow types that promote to a signed type and that can represent a
   signed or unsigned integer of at least N bits.  In tables they can
   save space and decrease cache pressure.  Promoting to a signed type
   helps avoid bugs in integer arithmetic.  */

#ifdef __INT_LEAST8_MAX__
typedef __INT_LEAST8_TYPE__ yytype_int8;
#elif defined YY_STDINT_H
typedef int_least8_t yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef __INT_LEAST16_MAX__
typedef __INT_LEAST16_TYPE__ yytype_int16;
#elif defined YY_STDINT_H
typedef int_least16_t yytype_int16;
#else
typedef short yytype_int16;
#endif

/* Work around bug in HP-UX 11.23, which defines these macros
   incorrectly for preprocessor constants.  This workaround can likely
   be removed in 2023, as HPE has promised support for HP-UX 11.23
   (aka HP-UX 11i v2) only through the end of 2022; see Table 2 of
   <https://h20195.www2.hpe.com/V2/getpdf.aspx/4AA4-7673ENW.pdf>.  */
#ifdef __hpux
# undef UINT_LEAST8_MAX
# undef UINT_LEAST16_MAX
# define UINT_LEAST8_MAX 255
# define UINT_LEAST16_MAX 65535
#endif

#if defined __UINT_LEAST8_MAX__ && __UINT_LEAST8_MAX__ <= __INT_MAX__
typedef __UINT_LEAST8_TYPE__ yytype_uint8;
#elif (!defined __UINT_LEAST8_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST8_MAX <= INT_MAX)
typedef uint_least8_t yytype_uint8;
#elif !defined __UINT_LEAST8_MAX__ && UCHAR_MAX <= INT_MAX
typedef unsigned char yytype_uint8;
#else
typedef short yytype_uint8;
#endif

#if defined __UINT_LEAST16_MAX__ && __UINT_LEAST16_MAX__ <= __INT_MAX__
typedef __UINT_LEAST16_TYPE__ yytype_uint16;
#elif (!defined __UINT_LEAST16_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST16_MAX <= INT_MAX)
typedef uint_least16_t yytype_uint16;
#elif !defined __UINT_LEAST16_MAX__ && USHRT_MAX <= INT_MAX
typedef unsigned short yytype_uint16;
#else
typedef int yytype_uint16;
#endif

#ifndef YYPTRDIFF_T
# if defined __PTRDIFF_TYPE__ && defined __PTRDIFF_MAX__
#  define YYPTRDIFF_T __PTRDIFF_TYPE__
#  define YYPTRDIFF_MAXIMUM __PTRDIFF_MAX__
# elif defined PTRDIFF_MAX
#  ifndef ptrdiff_t
#   include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  endif
#  define YYPTRDIFF_T ptrdiff_t
#  define YYPTRDIFF_MAXIMUM PTRDIFF_MAX
# else
#  define YYPTRDIFF_T long
#  define YYPTRDIFF_MAXIMUM LONG_MAX
# endif
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned
# endif
#endif

#define YYSIZE_MAXIMUM                                  \
  YY_CAST (YYPTRDIFF_T,                                 \
           (YYPTRDIFF_MAXIMUM < YY_CAST (YYSIZE_T, -1)  \
            ? YYPTRDIFF_MAXIMUM                         \
            : YY_CAST (YYSIZE_T, -1)))

#define YYSIZEOF(X) YY_CAST (YYPTRDIFF_T, sizeof (X))


/* Stored state numbers (used for stacks). */
typedef yytype_int16 yy_state_t;

/* State numbers in computations.  */
typedef int yy_state_fast_t;

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif


#ifndef YY_ATTRIBUTE_PURE
# if defined __GNUC__ && 2 < __GNUC__ + (96 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_PURE __attribute__ ((__pure__))
# else
#  define YY_ATTRIBUTE_PURE
# endif
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# if defined __GNUC__ && 2 < __GNUC__ + (7 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_UNUSED __attribute__ ((__unused__))
# else
#  define YY_ATTRIBUTE_UNUSED
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YY_USE(E) ((void) (E))
#else
# define YY_USE(E) /* empty */
#endif

/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
#if defined __GNUC__ && ! defined __ICC && 406 <= __GNUC__ * 100 + __GNUC_MINOR__
# if __GNUC__ * 100 + __GNUC_MINOR__ < 407
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")
# else
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")              \
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# endif
# define YY_IGNORE_MAYBE_UNINITIALIZED_END      \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif

#if defined __cplusplus && defined __GNUC__ && ! defined __ICC && 6 <= __GNUC__
# define YY_IGNORE_USELESS_CAST_BEGIN                          \
    _Pragma ("GCC diagnostic push")                            \
    _Pragma ("GCC diagnostic ignored \"-Wuseless-cast\"")
# define YY_IGNORE_USELESS_CAST_END            \
    _Pragma ("GCC diagnostic pop")
#endif
#ifndef YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_END
#endif


#define YY_ASSERT(E) ((void) (0 && (E)))

#if 1

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* 1 */

#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL \
             && defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yy_state_t yyss_alloc;
  YYSTYPE yyvs_alloc;
  YYLTYPE yyls_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (YYSIZEOF (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (YYSIZEOF (yy_state_t) + YYSIZEOF (YYSTYPE) \
             + YYSIZEOF (YYLTYPE)) \
      + 2 * YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYPTRDIFF_T yynewbytes;                                         \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * YYSIZEOF (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / YYSIZEOF (*yyptr);                        \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, YY_CAST (YYSIZE_T, (Count)) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYPTRDIFF_T yyi;                      \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  5
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   4784

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  130
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  203
/* YYNRULES -- Number of rules.  */
#define YYNRULES  610
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  902

/* YYMAXUTOK -- Last valid token kind.  */
#define YYMAXUTOK   367


/* YYTRANSLATE(TOKEN-NUM) -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, with out-of-bounds checking.  */
#define YYTRANSLATE(YYX)                                \
  (0 <= (YYX) && (YYX) <= YYMAXUTOK                     \
   ? YY_CAST (yysymbol_kind_t, yytranslate[YYX])        \
   : YYSYMBOL_YYUNDEF)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex.  */
static const yytype_uint8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     8,     2,     2,     2,     2,     2,     9,
       2,     2,   125,   119,    10,   118,   121,   127,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     5,     2,
       2,   124,     2,   129,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,   128,     2,   126,     6,     7,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   122,     2,   123,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
      11,    12,    13,    14,    15,    16,    17,    18,    19,    20,
      21,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    34,    35,    36,    37,    38,    39,    40,
      41,    42,    43,    44,    45,    46,    47,    48,    49,    50,
      51,    52,    53,    54,    55,    56,    57,    58,    59,    60,
      61,    62,    63,    64,    65,    66,    67,    68,    69,    70,
      71,    72,    73,    74,    75,    76,    77,    78,    79,    80,
      81,    82,    83,    84,    85,    86,    87,    88,    89,    90,
      91,    92,    93,    94,    95,    96,    97,    98,    99,   100,
     101,   102,   103,   104,   105,   106,   107,   108,   109,   110,
     111,   112,   113,   114,   115,   116,   117,   120
};

#if YYDEBUG
/* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_int16 yyrline[] =
{
       0,   403,   403,   404,   404,   412,   413,   415,   417,   420,
     427,   430,   434,   438,   446,   450,   454,   458,   462,   466,
     501,   517,   518,   526,   530,   534,   535,   536,   540,   541,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   561,   562,   563,   576,   577,   578,   582,   589,   593,
     594,   602,   609,   610,   611,   616,   628,   646,   650,   658,
     659,   662,   666,   675,   681,   681,   692,   696,   703,   707,
     712,   727,   728,   729,   733,   737,   753,   754,   755,   756,
     757,   758,   759,   760,   761,   762,   763,   764,   765,   766,
     767,   777,   781,   785,   789,   793,   797,   801,   805,   809,
     816,   817,   827,   837,   847,   857,   861,   865,   869,   874,
     884,   890,   899,   912,   914,   914,   926,   929,   939,   950,
     978,   990,  1000,  1003,  1007,  1011,  1015,  1019,  1023,  1027,
    1031,  1061,  1060,  1064,  1073,  1081,  1086,  1089,  1092,  1096,
    1100,  1104,  1108,  1112,  1143,  1142,  1149,  1157,  1164,  1181,
    1187,  1188,  1189,  1194,  1197,  1258,  1257,  1280,  1294,  1304,
    1310,  1315,  1324,  1336,  1337,  1341,  1348,  1352,  1380,  1387,
    1386,  1403,  1409,  1412,  1415,  1424,  1427,  1431,  1441,  1447,
    1448,  1449,  1453,  1465,  1466,  1467,  1471,  1475,  1490,  1508,
    1509,  1513,  1517,  1524,  1528,  1532,  1535,  1538,  1544,  1547,
    1555,  1556,  1557,  1562,  1561,  1569,  1588,  1589,  1597,  1611,
    1614,  1627,  1630,  1634,  1648,  1651,  1657,  1660,  1682,  1683,
    1684,  1685,  1688,  1695,  1696,  1697,  1701,  1708,  1712,  1719,
    1720,  1721,  1728,  1729,  1730,  1734,  1735,  1792,  1793,  1797,
    1804,  1805,  1809,  1818,  1819,  1831,  1835,  1840,  1849,  1856,
    1857,  1861,  1873,  1879,  1885,  1895,  1899,  1909,  1913,  1917,
    1921,  1925,  1929,  1937,  1951,  1968,  1979,  1990,  2007,  2024,
    2037,  2060,  2078,  2079,  2094,  2104,  2120,  2136,  2145,  2172,
    2183,  2193,  2212,  2223,  2233,  2247,  2262,  2277,  2292,  2302,
    2307,  2312,  2317,  2324,  2325,  2332,  2333,  2352,  2356,  2360,
    2364,  2371,  2375,  2379,  2383,  2390,  2393,  2403,  2408,  2413,
    2418,  2423,  2428,  2438,  2443,  2448,  2453,  2460,  2478,  2489,
    2500,  2518,  2536,  2550,  2573,  2585,  2601,  2610,  2611,  2615,
    2619,  2620,  2627,  2635,  2636,  2648,  2648,  2655,  2659,  2670,
    2681,  2686,  2691,  2696,  2703,  2710,  2714,  2719,  2725,  2732,
    2739,  2745,  2748,  2751,  2762,  2791,  2798,  2810,  2811,  2815,
    2819,  2827,  2828,  2830,  2831,  2832,  2834,  2835,  2836,  2837,
    2841,  2842,  2845,  2848,  2865,  2873,  2888,  2911,  2943,  2961,
    2970,  2973,  2982,  2993,  2994,  2995,  2999,  3000,  3001,  3002,
    3013,  3014,  3015,  3027,  3030,  3036,  3052,  3053,  3054,  3055,
    3063,  3067,  3068,  3072,  3079,  3086,  3090,  3094,  3095,  3100,
    3118,  3124,  3131,  3132,  3139,  3165,  3175,  3191,  3195,  3196,
    3197,  3201,  3208,  3211,  3217,  3220,  3232,  3237,  3242,  3252,
    3259,  3266,  3276,  3277,  3284,  3292,  3293,  3296,  3301,  3305,
    3308,  3335,  3336,  3341,  3344,  3345,  3350,  3357,  3360,  3366,
    3369,  3375,  3390,  3401,  3402,  3413,  3414,  3418,  3423,  3429,
    3436,  3444,  3452,  3455,  3458,  3461,  3464,  3467,  3470,  3476,
    3477,  3478,  3482,  3485,  3493,  3501,  3509,  3515,  3521,  3524,
    3530,  3531,  3536,  3539,  3546,  3554,  3567,  3570,  3582,  3583,
    3584,  3585,  3586,  3601,  3605,  3616,  3620,  3649,  3657,  3660,
    3663,  3666,  3672,  3675,  3682,  3685,  3691,  3692,  3700,  3759,
    3779,  3786,  3802,  3807,  3812,  3817,  3821,  3831,  3837,  3844,
    3847,  3853,  3856,  3859,  3862,  3868,  3871,  3874,  3880,  3881,
    3887,  3890,  3893,  3899,  3902,  3914,  3917,  3920,  3924,  3927,
    3930,  3936,  3939,  3943,  3944,  3945,  3952,  3953,  3954,  3960,
    3961,  3970,  3982,  3983,  3999,  4000,  4011,  4010,  4019,  4035,
    4044,  4048,  4055,  4063,  4066,  4071,  4078,  4077,  4094,  4097,
    4101,  4104,  4107,  4111,  4111,  4127,  4134,  4140,  4141,  4144,
    4150,  4156,  4156,  4166,  4169,  4172,  4176,  4179,  4182,  4185,
    4191,  4192,  4198,  4202,  4210,  4214,  4218,  4222,  4229,  4235,
    4238,  4244,  4245,  4249,  4253,  4257,  4257,  4270,  4273,  4280,
    4285
};
#endif

/** Accessing symbol of state STATE.  */
#define YY_ACCESSING_SYMBOL(State) YY_CAST (yysymbol_kind_t, yystos[State])

#if 1
/* The user-facing name of the symbol whose (internal) number is
   YYSYMBOL.  No bounds checking.  */
static const char *yysymbol_name (yysymbol_kind_t yysymbol) YY_ATTRIBUTE_UNUSED;

/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "\"end of input\"", "error", "\"invalid token\"", "PREC_BOT",
  "COMPOSITE", "':'", "'^'", "'_'", "'!'", "'\\''", "','", "PREC_TOP",
  "\"\\\\accepts\"", "\"\\\\addlyrics\"", "\"\\\\alias\"",
  "\"\\\\alternative\"", "\"\\\\book\"", "\"\\\\bookpart\"",
  "\"\\\\change\"", "\"\\\\chordmode\"", "\"\\\\chords\"",
  "\"\\\\consists\"", "\"\\\\context\"", "\"\\\\default\"",
  "\"\\\\defaultchild\"", "\"\\\\denies\"", "\"\\\\description\"",
  "\"\\\\drummode\"", "\"\\\\drums\"", "\"\\\\etc\"", "\"\\\\figuremode\"",
  "\"\\\\figures\"", "\"\\\\header\"", "\"\\\\version-error\"",
  "\"\\\\layout\"", "\"\\\\lyricmode\"", "\"\\\\lyrics\"",
  "\"\\\\lyricsto\"", "\"\\\\markup\"", "\"\\\\markuplist\"",
  "\"\\\\midi\"", "\"\\\\name\"", "\"\\\\notemode\"", "\"\\\\override\"",
  "\"\\\\paper\"", "\"\\\\remove\"", "\"\\\\repeat\"", "\"\\\\rest\"",
  "\"\\\\revert\"", "\"\\\\score\"", "\"\\\\score-lines\"",
  "\"\\\\sequential\"", "\"\\\\set\"", "\"\\\\simultaneous\"",
  "\"\\\\tempo\"", "\"\\\\type\"", "\"\\\\unset\"", "\"\\\\with\"",
  "\"\\\\new\"", "\"/+\"", "\"^\"", "\":\"", "\"-\"", "\"/\"", "\"<\"",
  "\">\"", "\"<<\"", "\">>\"", "\"\\\\\\\\\"", "\"\\\\!\"", "\"\\\\+\"",
  "\"__\"", "FIGURE_CLOSE", "FIGURE_OPEN", "\"_\"",
  "FIGURE_ALTERATION_EXPR", "\"--\"", "MULTI_MEASURE_REST", "E_UNSIGNED",
  "UNSIGNED", "\"markup?\"", "\"scheme?\"", "\"(backed-up?)\"",
  "\"(reparsed?)\"", "\"markup-list?\"", "\"optional?\"",
  "EXPECT_NO_MORE_ARGS", "\"#{\"", "BOOK_IDENTIFIER", "CHORD_MODIFIER",
  "CHORD_REPETITION", "DRUM_PITCH", "DURATION_ARG", "DURATION_IDENTIFIER",
  "EVENT_IDENTIFIER", "EVENT_FUNCTION", "FRACTION", "LOOKUP_IDENTIFIER",
  "LYRIC_ELEMENT", "MARKUP_FUNCTION", "MARKUP_LIST_FUNCTION",
  "MARKUP_IDENTIFIER", "MARKUPLIST_IDENTIFIER", "MUSIC_FUNCTION",
  "MUSIC_IDENTIFIER", "NOTENAME_PITCH", "NUMBER_IDENTIFIER",
  "PITCH_IDENTIFIER", "REAL", "RESTNAME", "SCM_ARG", "SCM_FUNCTION",
  "SCM_IDENTIFIER", "SCM_TOKEN", "STRING", "SYMBOL_LIST",
  "TONICNAME_PITCH", "SYMBOL", "'-'", "'+'", "UNARY_MINUS", "'.'", "'{'",
  "'}'", "'='", "'*'", "']'", "'/'", "'['", "'?'", "$accept",
  "start_symbol", "$@1", "lilypond", "toplevel_expression", "lookup",
  "embedded_scm_bare", "embedded_scm_active", "embedded_scm_bare_arg",
  "embedded_scm", "embedded_scm_arg", "scm_function_call",
  "embedded_lilypond_number", "embedded_lilypond", "lilypond_header_body",
  "lilypond_header", "header_block", "$@2", "assignment_id", "assignment",
  "identifier_init", "identifier_init_nonumber",
  "partial_function_scriptable", "partial_function",
  "context_def_spec_block", "context_mod_arg", "$@3",
  "context_def_spec_body", "book_block", "book_body", "$@4",
  "bookpart_block", "bookpart_body", "$@5", "score_block", "score_body",
  "score_item", "score_items", "$@6", "paper_block", "output_def",
  "output_def_head", "output_def_head_with_mode_switch",
  "music_or_context_def", "output_def_body", "$@7", "tempo_event",
  "music_list", "braced_music_list", "music", "pitch_as_music",
  "music_embedded", "music_embedded_backup", "music_assign",
  "repeated_music", "sequential_alternative_music", "sequential_music",
  "simultaneous_music", "simple_music", "context_modification", "$@8",
  "context_modification_arg", "optional_context_mods",
  "context_modification_mods_list", "context_mod_list", "context_prefix",
  "new_lyrics", "basic_music", "contextable_music",
  "contexted_basic_music", "composite_music", "music_bare",
  "grouped_music_list", "symbol_list_arg", "symbol_list_rev",
  "symbol_list_part", "symbol_list_element", "symbol_list_part_bare",
  "function_arglist_nonbackup", "reparsed_rhythm",
  "function_arglist_nonbackup_reparse", "function_arglist_backup",
  "function_arglist", "function_arglist_skip_nonbackup",
  "function_arglist_partial", "function_arglist_partial_optional",
  "function_arglist_common", "function_arglist_common_reparse",
  "function_arglist_optional", "function_arglist_skip_backup",
  "music_function_call", "optional_id", "lyric_mode_music", "$@9",
  "mode_changed_music", "mode_changing_head",
  "mode_changing_head_with_context", "context_change", "property_path",
  "property_operation", "revert_arg", "revert_arg_backup",
  "revert_arg_part", "context_def_mod", "context_mod", "grob_prop_spec",
  "grob_prop_path", "context_prop_spec", "simple_revert_context",
  "music_property_def", "string", "text", "simple_string", "symbol",
  "scalar", "event_chord", "note_chord_element", "chord_body",
  "chord_body_elements", "chord_body_element", "music_function_chord_body",
  "event_function_event", "post_events", "post_event_nofinger",
  "post_event", "string_number_event", "direction_less_event",
  "direction_reqd_event", "octave_check", "quotes", "erroneous_quotes",
  "sup_quotes", "sub_quotes", "steno_pitch", "steno_tonic_pitch", "pitch",
  "pitch_or_tonic_pitch", "gen_text_def", "fingering",
  "script_abbreviation", "script_dir", "maybe_notemode_duration",
  "optional_notemode_duration", "steno_duration", "duration", "dots",
  "multiplier_scm", "multipliers", "tremolo_type", "bass_number",
  "bass_figure", "figured_bass_modification", "br_bass_figure",
  "figure_list", "optional_rest", "pitch_or_music", "simple_element",
  "lyric_element", "lyric_element_music", "new_chord", "chord_items",
  "chord_separator", "chord_item", "step_numbers", "step_number",
  "tempo_range", "number_expression", "number_term", "number_factor",
  "bare_number_common", "bare_number", "unsigned_number", "exclamations",
  "questions", "full_markup_list", "$@10", "markup_mode",
  "markup_mode_word", "full_markup", "partial_markup", "markup_top",
  "markup_scm", "$@11", "markup_list", "markup_uncomposed_list", "$@12",
  "markup_composed_list", "markup_braced_list", "markup_braced_list_body",
  "markup_command_list", "markup_command_embedded_lilypond", "$@13",
  "markup_command_basic_arguments", "markup_command_list_arguments",
  "markup_partial_function", "markup_arglist_partial",
  "markup_head_1_item", "markup_head_1_list", "markup_word",
  "simple_markup", "simple_markup_noword", "$@14", "markup", YY_NULLPTR
};

static const char *
yysymbol_name (yysymbol_kind_t yysymbol)
{
  return yytname[yysymbol];
}
#endif

#define YYPACT_NINF (-621)

#define yypact_value_is_default(Yyn) \
  ((Yyn) == YYPACT_NINF)

#define YYTABLE_NINF (-597)

#define yytable_value_is_error(Yyn) \
  0

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
static const yytype_int16 yypact[] =
{
      17,  -621,   110,  1947,  1495,  -621,  -621,    52,    -2,    38,
    -621,  -621,   649,  -621,  -621,  -621,  -621,  -621,  -621,  -621,
    -621,   660,  -621,  -621,  -621,  -621,  -621,   854,    56,    65,
      65,   649,  -621,  -621,     5,   419,  -621,   419,  -621,  -621,
    -621,  -621,  -621,  -621,  -621,  -621,  -621,  -621,    98,    42,
    -621,  -621,  -621,  -621,  -621,  -621,    87,  1832,  -621,  -621,
    -621,  -621,  -621,  4569,   159,  -621,  -621,  -621,  -621,  -621,
    -621,   625,  -621,  -621,  1059,    90,  -621,  -621,   140,   145,
     145,   649,   580,  1257,   373,   854,   373,   373,  1036,   373,
     221,  -621,  -621,  -621,  -621,   105,  -621,   152,   105,   105,
    -621,  -621,   515,  -621,  -621,   596,    50,  -621,    50,   172,
     105,   668,  -621,  -621,    62,    50,    83,   369,  -621,  -621,
      99,  -621,  -621,  -621,  -621,  -621,  -621,   285,  -621,  -621,
    -621,  -621,  -621,  -621,  -621,  -621,  3563,   183,   127,  -621,
    -621,  -621,  -621,  -621,  -621,  -621,  -621,   105,  -621,  -621,
     132,  -621,  -621,  -621,   105,  -621,  1119,  -621,  -621,  -621,
     136,  -621,   105,  -621,  -621,  -621,  -621,  1288,  -621,   157,
    -621,  -621,  -621,   259,   269,  -621,  -621,  -621,   200,   237,
     247,   258,   286,   273,   949,  -621,  -621,  -621,   435,  -621,
    -621,  -621,   200,  2195,   373,   744,   312,  -621,  -621,   334,
    -621,  -621,   344,  -621,  1723,   307,  -621,   373,  3449,  -621,
    -621,  -621,  -621,  -621,  -621,  4504,   199,    90,  -621,  -621,
     159,  -621,  -621,  -621,  -621,   422,  -621,   625,   383,  -621,
    -621,   459,   702,  -621,  -621,  -621,  -621,  -621,    91,  -621,
    -621,  -621,  -621,  -621,  -621,  1059,  -621,  -621,  3449,  -621,
    -621,  -621,  -621,   318,  -621,  -621,  -621,  -621,  -621,  -621,
     102,  -621,  -621,  -621,   373,   327,  3983,  -621,   373,   102,
     337,  -621,  -621,  -621,  -621,   105,   339,  -621,  -621,  -621,
    -621,   336,  -621,  2069,   844,  -621,  -621,  -621,  -621,   349,
    -621,  -621,   349,   751,   386,  -621,  -621,   751,   395,  -621,
    -621,  -621,  -621,   484,   486,  -621,  -621,  -621,   751,   421,
    -621,  -621,   152,  -621,  -621,  -621,   373,   373,   419,  -621,
    -621,   145,  -621,  -621,  -621,  -621,  3956,  -621,  -621,   282,
    -621,  1026,  1140,   501,  -621,  -621,  -621,  -621,  -621,  -621,
    -621,  -621,  -621,  -621,  -621,  -621,  -621,  -621,  -621,  -621,
    1288,  -621,   403,   987,  1017,  -621,  1017,   761,   482,  2107,
    -621,  1987,  -621,  2086,   854,  -621,  -621,  -621,   625,   854,
     455,   447,  -621,   949,  -621,  -621,  -621,  4411,    73,  4306,
    -621,  -621,  -621,  -621,   102,   461,   225,  -621,  3335,   492,
     795,  1810,  4046,  -621,  -621,   102,   464,    74,   154,   155,
     376,  -621,  -621,  -621,  -621,   163,  -621,  -621,   305,  -621,
     217,  -621,  -621,  -621,  -621,  -621,  -621,   422,   286,  -621,
    -621,  -621,   470,   483,   702,   702,   702,  -621,  -621,   702,
    -621,  -621,  1020,   531,  -621,  -621,  -621,  -621,  -621,  -621,
    -621,  -621,   854,  4067,   373,   373,  -621,  3676,  -621,  -621,
     373,   854,   373,   118,   236,  -621,  -621,   346,  3902,  -621,
    -621,   550,  -621,  3789,   509,   435,  -621,  -621,  -621,  -621,
    -621,  -621,  -621,  -621,  -621,  -621,  -621,  -621,  -621,  -621,
    -621,  -621,  -621,   872,  -621,  -621,   396,  -621,  -621,  1017,
    -621,  1017,   751,   557,  -621,  2765,   848,  2765,   848,  -621,
    -621,  2765,   848,   526,   527,  1376,  1017,  -621,  1017,   537,
    -621,  -621,   537,  -621,  -621,     0,  -621,   240,  -621,  1017,
     828,   828,  -621,  -621,   761,  -621,  -621,  -621,  -621,    98,
    -621,  -621,  -621,  -621,  -621,  -621,  -621,  -621,  -621,  -621,
    -621,    98,  -621,  -621,  -621,  -621,  -621,  -621,  -621,  -621,
     286,   648,  -621,  -621,  -621,  -621,    98,  -621,  -621,  -621,
     863,  1750,  -621,  -621,  -621,  -621,  -621,  -621,  -621,  -621,
     496,  -621,  -621,  -621,  -621,  -621,  -621,  -621,  -621,  -621,
    -621,  -621,  -621,  -621,  -621,  -621,  -621,  -621,  -621,  -621,
    -621,   585,  2879,   645,  -621,  -621,   180,  -621,  -621,  -621,
    -621,  -621,  -621,  -621,  -621,  -621,  -621,  -621,  -621,  -621,
     547,  3449,  -621,   567,    71,  -621,   373,   373,  1017,    71,
      71,    71,    71,  -621,   286,  -621,  -621,  -621,  4544,   949,
     572,  -621,  -621,  1059,  -621,  -621,  -621,  -621,  -621,  -621,
    -621,  -621,  -621,  -621,  -621,   373,  -621,   373,  -621,   649,
    -621,   258,  -621,  -621,  4662,  -621,  -621,   440,  -621,   551,
    -621,  -621,  -621,   376,  -621,  -621,   184,  -621,  -621,  -621,
    -621,   556,  3983,   566,   751,   593,   751,   618,   245,   601,
    -621,    23,  -621,  -621,   435,  -621,   594,  4092,  1017,   501,
     396,  -621,  -621,  -621,  -621,  -621,  -621,  -621,  -621,  2993,
     889,  -621,   751,   630,  2423,  -621,  -621,  2423,  -621,  2423,
    4201,  4201,  -621,  -621,   734,    50,  -621,   105,  -621,  -621,
    -621,  -621,  -621,   828,   689,  -621,  4544,  -621,  -621,  -621,
    -621,  -621,  -621,  -621,   639,  2537,   700,  -621,  -621,  -621,
    -621,  -621,  -621,  -621,  -621,   795,  -621,  -621,  -621,  -621,
    -621,   503,  -621,  -621,  -621,  -621,  -621,  -621,  -621,   349,
     373,   373,  -621,  -621,  -621,  -621,  -621,  -621,  -621,  -621,
    -621,  -621,  -621,  -621,    92,   144,  -621,  -621,  -621,  -621,
    -621,  -621,  -621,   629,   572,  -621,  -621,   612,  -621,  -621,
    -621,  -621,  -621,  -621,  4201,  -621,   373,   373,   893,   893,
     893,   893,   897,   893,   897,   751,   665,   437,   652,   333,
    -621,  -621,   435,  -621,  -621,  -621,     0,   671,  2309,  -621,
    3107,   848,  -621,  -621,  -621,   376,    43,  -621,  -621,  -621,
     634,  -621,  -621,    50,   572,   863,  -621,  -621,  -621,  -621,
    -621,  -621,  -621,   535,  -621,  -621,  -621,  -621,  -621,  -621,
    -621,  -621,  -621,  -621,   403,   102,   102,  -621,  -621,  1609,
    4201,  -621,  -621,  -621,   679,   893,   893,   893,   897,   828,
     437,   373,   373,  -621,  -621,  -621,   889,  2651,  -621,  -621,
     688,  -621,   722,  -621,  -621,  -621,  -621,  1017,   655,  -621,
     897,   893,  -621,  -621,  -621,  1017,  -621,  -621,  -621,  -621,
    3221,  1017
};

/* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
   Performed when YYTABLE does not specify something else to do.  Zero
   means the default is an error.  */
static const yytype_int16 yydefact[] =
{
       5,     3,     0,     0,     0,     1,     8,     0,     0,     0,
     343,   347,     0,   341,   345,   342,   346,     9,   161,   344,
     348,     0,   558,   556,   160,   340,   159,     0,     0,     0,
       0,     0,   175,    13,    21,     0,   233,     0,    25,    18,
      66,    67,   175,     6,    27,    19,    26,    10,     0,     0,
       7,    11,    12,    14,    20,   162,     0,     0,   197,   219,
     195,   236,   235,     0,   229,   230,    15,   220,   234,   218,
     232,     0,   209,    17,     0,   561,    16,    57,   486,   470,
     469,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     203,   412,   427,   504,   426,   472,   434,   478,   472,   472,
     478,   436,     0,    84,   515,     0,   443,   544,   443,   543,
     472,     0,    24,    23,   514,   443,   513,   471,    43,    41,
     188,    42,    53,     4,    76,    52,   100,     0,    81,    78,
      79,    77,    80,   407,   183,   181,     0,   185,   179,   189,
      89,   190,   202,   201,    85,   200,   408,   472,   438,   432,
     184,   435,   424,   453,   472,   552,   111,   482,   422,   437,
     182,   422,   472,   180,   422,    49,    88,     0,   561,   512,
      87,   194,   193,   121,   135,   393,   394,   395,   333,   390,
     391,   392,   335,     0,     0,   390,   391,   392,     0,   153,
     196,   198,   333,     0,     0,     0,     0,   305,   293,     0,
     332,   249,     0,    47,     0,     0,    65,     0,    64,   165,
     171,   168,   158,   167,   166,     0,     0,     0,   224,   223,
     227,   228,   225,   182,   209,   231,   338,     0,   208,   605,
     573,     0,     0,   601,   602,   577,   566,   560,     0,   563,
     569,   568,   570,   571,   599,     0,   559,   565,    64,   487,
     461,   430,   431,     0,   116,    58,   246,   245,   247,   244,
     374,   240,   248,   243,   375,     0,   107,   378,     0,   377,
       0,   478,   386,   387,   389,   174,     0,   388,   382,   207,
     206,     0,   205,     0,     0,   474,   422,   473,    50,   475,
     422,   510,   476,     0,     0,   421,    92,     0,     0,    91,
     447,   449,   451,   445,   444,   454,   545,   511,     0,     0,
      93,   452,   461,    48,   433,    90,     0,     0,     0,   514,
     513,   471,   188,   175,   179,   184,     0,   422,   512,     0,
     422,   517,     0,   554,   462,   468,   465,   466,   458,   459,
     464,   463,   467,   460,   110,   425,   429,   428,   439,   440,
       0,   457,   477,   187,   404,   422,   509,     0,     0,     0,
     122,     0,   136,     0,     0,   209,   337,   221,     0,     0,
       0,     0,   557,     0,   549,   550,   551,     0,     0,   148,
     209,   177,   199,   176,    22,     0,   327,   272,    64,     0,
       0,     0,     0,   178,    59,   350,     0,   547,   383,   384,
     471,    86,    68,    71,    82,     0,   422,    83,    72,   537,
     538,   546,   542,   385,   164,   170,   163,   226,   335,   209,
     339,   210,     0,     0,     0,     0,     0,   589,   607,     0,
     590,   580,     0,     0,   608,   572,   575,   600,   603,   564,
     604,    70,     0,   114,     0,     0,   376,    64,   470,   469,
       0,     0,     0,     0,     0,   471,   108,   111,   105,   357,
     380,     0,   356,    64,     0,     0,   211,   410,   422,   419,
     420,   418,   413,   416,   417,   456,   455,   552,   411,   493,
     488,   489,   490,     0,   492,   494,   502,   505,   491,   406,
     479,   405,     0,     0,   298,    64,     0,    64,     0,   448,
     450,    64,     0,     0,     0,     0,   187,   186,   409,     0,
     522,   521,     0,   519,   553,   441,   109,     0,   423,   516,
       0,     0,   592,   562,     0,   133,   129,   120,   130,     0,
     124,   125,   123,   157,   126,   128,   127,   146,   142,   134,
     143,     0,   138,   137,   139,   141,   140,   334,   214,   336,
     335,   191,   149,   147,   150,   154,     0,   152,   151,   215,
       0,     0,   323,   324,    30,    28,   317,    29,   320,   321,
     471,    40,    44,   306,    45,    34,    36,    37,    38,    35,
      39,    46,    33,   308,   319,   318,   307,    32,   322,    31,
     329,     0,    64,     0,   478,   260,   237,   262,   258,   257,
     256,   261,   259,   310,   316,   315,   314,   312,   311,   313,
       0,    64,   548,   547,     0,   541,     0,     0,    75,     0,
       0,     0,     0,   216,   335,   153,   153,   598,     0,     0,
       0,   576,   579,     0,   610,   578,   567,   349,   363,   366,
     361,   364,   365,   368,   369,     0,   362,     0,   367,     0,
     112,    41,   113,   119,     0,   118,   370,     0,   117,     0,
     242,   241,   398,   471,   396,   103,     0,   401,   379,   397,
     399,     0,   107,     0,     0,     0,     0,     0,     0,     0,
     106,     0,   104,   381,     0,   172,   533,   114,   415,   554,
     503,   501,   499,   498,   496,   495,   500,   497,   302,    64,
       0,    95,     0,     0,    64,   300,    94,    64,    96,    64,
      64,    64,   524,   523,   518,   443,   555,   472,   483,   484,
     480,   481,   485,     0,   598,   594,   597,   595,   593,   132,
     145,   222,   192,   156,     0,   330,   331,   292,   291,   290,
     288,   289,   325,   309,   326,     0,   270,   271,   264,   267,
     268,   471,   254,   250,   266,   265,   255,   269,   294,   482,
       0,     0,    61,    63,    62,    60,    69,    74,    73,   536,
     535,   539,   540,   217,     0,     0,   587,   588,   581,   584,
     586,   585,   583,     0,     0,   591,   609,     0,   354,   352,
     115,   371,   372,   373,    64,   400,     0,     0,   101,   105,
     102,   297,     0,   297,     0,     0,     0,     0,     0,     0,
     355,   173,     0,   204,   213,   212,   441,     0,   330,   304,
      64,     0,    98,    97,    99,     0,   530,   527,   525,   520,
     526,   528,   442,   443,   596,     0,   278,   284,   280,   279,
     285,   286,   287,   471,   273,   274,   276,   275,   277,   328,
     296,   251,   253,   252,   422,   239,   238,   606,   574,     0,
      64,   351,   403,   402,     0,   299,   299,   297,     0,     0,
       0,     0,     0,   360,   534,   422,     0,    64,   532,   531,
       0,   446,   506,   331,   281,   283,   282,   263,     0,   353,
       0,   299,   597,   359,   358,   414,   529,   507,   422,   582,
      64,   508
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
    -621,  -621,  -621,  -621,  -621,     6,   204,   -24,  -621,   147,
     329,    15,   663,   -78,  -621,  -410,    -1,  -621,  -621,   -26,
    -195,  -180,  -116,   301,    31,    97,  -621,  -621,    20,  -621,
    -621,     4,  -621,  -621,    12,   -65,  -621,  -621,  -621,   424,
       9,  -621,  -621,  -621,  -621,  -621,  -621,    33,   299,  -256,
     736,   -86,  -621,    25,  -621,   250,  -621,  -621,  -621,    13,
    -621,  -621,  -109,  -621,  -621,  -621,   583,   743,  -621,   745,
       3,  -621,   -30,  -313,   -18,   -82,  -621,  -132,   101,  -298,
    -621,  -490,    41,  -620,   -44,  -456,   279,  -621,  -138,  -487,
     -56,   620,  -362,  -621,  -526,  -621,  -621,  -621,  -178,  -621,
    -508,  -621,  -621,  -621,   123,  -621,  -268,   -45,  -621,  -621,
    -305,  -621,    64,    16,  -417,   764,  -621,  -621,  -621,  -621,
    -621,  -621,  -119,   321,    39,  -621,   -75,  -621,    27,   -76,
    -621,  -621,  -621,  -621,   343,   310,  -621,  -621,   491,  -621,
      61,  -140,  1080,   -11,    45,   -81,  -621,    55,  -621,  -621,
     365,  -621,  -621,  -621,  -621,    34,  -621,  -621,  -223,  -621,
    -621,   153,  -621,  -621,   -10,   170,  -621,     8,  -310,    30,
     232,  -177,   392,   189,    18,  -621,   862,     7,    -3,    26,
    -621,   -96,  -621,  -130,  -219,  -621,  -621,  -621,  -621,  -621,
    -621,  -621,  -174,  -129,   719,  -469,  -225,   -49,    37,  -218,
      24,  -621,   456
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
       0,     2,     4,     3,    43,   118,   119,    45,   572,   236,
     573,   121,   122,   123,   610,   206,   575,    48,    49,    50,
     402,   125,   126,   127,   576,   653,   654,   443,   577,   361,
     529,   578,   363,   541,   579,   378,   555,   379,   556,   532,
     580,    55,    56,   415,    57,   215,   133,   193,    58,   134,
     135,   136,   137,   581,    59,    60,    61,    62,   139,   582,
     281,   282,   227,   228,   687,    63,   225,    64,   220,    65,
     141,    67,    68,   597,   395,   261,   262,   263,   198,   598,
     199,   386,   200,   593,   705,   494,   201,   202,   388,   389,
      69,   365,   367,   368,    70,    71,    72,   142,   396,   656,
     460,   461,   462,   657,   658,   264,   265,   270,   268,   143,
     144,   275,   182,   178,   668,   145,   146,   147,   283,   472,
     473,   148,   353,   149,   518,   151,   152,   347,   717,   302,
     882,   303,   304,   153,   154,   155,   477,   348,   314,   349,
     326,   285,   286,   157,   287,   289,   722,   352,   159,   485,
     486,   697,   487,   284,   898,   223,   161,   162,   163,   164,
     714,   513,   829,   830,   831,   685,   408,   409,   410,   411,
     412,   686,   333,   515,   587,   184,   167,   168,   328,   589,
     237,   238,   433,   239,   240,   423,   241,   242,   432,   243,
     781,   859,   430,   431,   516,   522,   244,   359,   438,   634,
     440,   422,   785
};

/* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule whose
   number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int16 yytable[] =
{
      76,   169,    47,   124,   267,   255,    66,    52,   130,    44,
      75,   377,    54,   132,   331,    53,   131,   140,    46,   292,
     437,    73,   166,    51,   129,   245,   436,   439,   403,   138,
     170,   214,   305,   213,   165,   128,   698,   183,   160,   311,
     344,   226,   354,   150,   278,   356,   683,   192,   503,   158,
     323,   725,   727,   441,   372,   728,   623,   428,   296,   300,
     301,   299,  -383,    44,   217,   156,   260,   310,   403,   269,
     735,   269,    46,   736,   552,   204,   405,   276,   203,   604,
     169,   346,   124,  -384,  -246,   277,   446,   130,   371,   458,
     615,   188,   132,   552,   605,   131,   140,   253,   247,   -86,
     345,   166,   780,   129,     1,   878,   507,   383,   138,   170,
       5,   246,   444,   165,   128,   418,   405,   160,   383,   729,
     173,   551,   150,   558,   715,   850,   194,   -82,   158,   716,
     205,   730,   -54,   809,   437,   373,   -83,   787,   596,   788,
     436,   439,   667,   295,   156,   552,   733,   165,   437,   266,
     613,   120,   203,   351,   436,   495,   171,  -385,   667,   497,
     174,   324,   879,   207,  -245,  -247,   208,   489,   601,   608,
     501,   491,   224,   616,    42,   325,   384,   107,   189,   109,
     612,   327,   671,   428,   271,  -383,   459,    42,   731,   614,
     760,   247,   434,   435,   796,  -246,   553,   420,   100,   674,
     780,   850,   551,   675,   246,   413,  -384,   124,   506,   209,
     818,   508,   130,   736,   248,   857,   177,   132,   324,   249,
     131,   140,   -86,   445,   250,   181,   166,   471,   129,   324,
     120,   187,   325,   404,   170,   177,   519,   280,   327,   128,
     416,   421,   407,   325,   819,   413,   414,   124,   737,   327,
     -82,   346,   130,   246,   725,   -54,   548,   132,   288,   -83,
     131,   140,   773,   738,   464,   329,   166,   858,   129,   156,
     345,   559,   504,   404,   170,  -245,  -247,   371,   306,   128,
    -385,   488,   407,   322,   617,   177,   177,   618,   259,   187,
     259,   259,   274,   259,   683,   627,   628,   629,   260,   269,
     630,   761,   632,   343,   615,   797,   172,  -330,   561,   156,
     624,   771,   772,   233,   315,   666,   234,   676,    34,   718,
      22,   677,   474,   351,   364,   279,   805,   457,   190,   191,
     806,   666,    37,   112,   113,   376,   719,   528,   549,   540,
     322,   344,   621,   871,   622,   735,   720,   360,   883,   688,
     428,   322,   112,   113,   699,   401,   505,   362,   536,   295,
     546,  -393,   660,   661,   534,   530,   544,    44,   810,    44,
     533,  -394,   533,   531,   247,   542,    46,   861,    46,   535,
     104,   545,  -395,   633,    22,   588,   818,   246,   557,   883,
     366,   724,   726,   390,   571,   401,   319,   369,   259,   320,
     727,   728,   324,   574,   324,   667,   667,   673,   437,   296,
     299,   259,   256,   376,   436,   786,   766,   391,   586,   383,
     819,   602,   609,   619,   620,   600,   607,   392,   547,   394,
     470,   403,   260,   550,   269,   419,   599,   606,   767,   768,
      90,   453,   442,   889,   413,   112,   113,   257,   312,   454,
     258,   447,   256,   571,   872,   613,   655,   678,   466,   659,
     413,   463,   574,   465,   691,   692,   693,   496,   259,   571,
     490,   694,   259,   343,   387,   107,   498,   109,   574,   405,
     488,   669,   107,   324,   109,   112,   113,   257,   484,   667,
     258,   592,   588,   499,   588,   799,   500,   669,   588,   782,
     195,   571,   502,   571,   196,   197,   637,   571,   457,   514,
     574,   523,   574,   759,   374,   672,   574,   520,   869,   457,
     259,   259,   695,   696,   457,   586,   554,   586,   517,   406,
     324,   586,    34,   371,   783,   424,   801,    34,   803,   424,
     425,   375,   560,   426,   325,   427,    37,   112,   113,   435,
     327,    37,   112,   113,   791,   667,   156,   792,   156,   437,
     774,   775,   156,   459,   820,   459,   786,   456,   187,   406,
     251,   252,   387,   187,   590,   742,   387,   833,   666,   666,
     373,   784,   851,   437,   765,    22,   764,   387,   611,   757,
     652,   741,   625,   476,   834,   740,   293,   704,   571,   707,
     294,   197,   743,   709,   744,   626,   739,   574,   413,   852,
     124,   853,   376,   636,   884,   130,    44,   217,   862,   863,
     132,   229,   756,   131,   140,    46,   475,   769,   770,   166,
     808,   129,   681,   684,   310,   874,   404,   170,   700,   832,
       7,   885,   128,   886,    34,   407,   187,   651,   259,   259,
     710,   711,   322,   115,   259,   187,   259,   790,    37,    38,
     762,    40,   666,     7,    41,   789,   745,   867,   758,    34,
     763,   231,   156,   612,   802,   794,    29,   297,    30,   670,
     798,   298,   197,    37,   112,   113,   233,   484,   783,   234,
     800,    32,   112,   113,   175,   670,   588,   176,   585,   804,
     807,   757,   254,   659,   757,   571,   757,   413,   413,   583,
     571,   821,   812,   571,   574,   571,   571,   571,  -596,   574,
     835,   721,   574,   849,   574,   574,   574,   873,   666,   586,
     434,   584,   848,   457,   756,   887,   860,   756,   783,   756,
     892,   571,   855,   856,   669,   669,   868,    42,   665,   308,
     574,   870,   876,   309,   197,   880,   895,   881,   401,   680,
     890,   112,   113,   175,   682,   156,   176,   826,   156,   897,
     156,   387,   112,   113,   179,   779,   664,   180,   899,   901,
     313,   888,   429,   425,   814,   784,   426,   543,   427,   893,
     894,   413,   664,   509,   510,   511,   701,   512,   706,   218,
     571,   732,   708,   417,   793,   585,   219,   585,   221,   574,
     815,   585,   380,   826,   854,   848,   583,   588,   583,   376,
     259,   259,   583,   827,   571,   195,   571,   222,   669,   385,
     197,   376,   492,   574,   652,   574,   493,   197,   584,   387,
     584,   520,   521,   875,   584,   426,   592,   427,   690,   259,
     586,   259,   712,   177,   811,   713,   169,   413,   124,   457,
     457,   457,   457,   130,   457,    74,   571,   828,   132,   689,
     896,   131,   140,   779,   757,   574,   195,   166,   816,   129,
     591,   197,    22,   571,   138,   170,   358,     0,   635,   165,
     128,   651,   574,   160,   669,   795,     0,   757,   150,   448,
     449,     0,   755,   865,   158,   866,   571,   756,   723,   521,
      22,     0,   426,   753,   427,   574,   478,     0,   479,   216,
     156,   752,   877,   480,     0,     0,   457,   457,   457,   702,
     756,     0,   406,   703,   197,   754,   450,     0,     0,   451,
       0,     0,   670,   670,   195,   452,   479,     0,   734,   197,
      74,   480,   457,   387,     0,   387,   112,   113,   481,   376,
       0,   482,     0,     0,   259,   259,   112,   113,   185,   891,
     492,   186,   483,   456,   817,   197,     0,     0,   702,   387,
       0,   387,   864,   197,   112,   113,   481,   -55,   453,   482,
       0,   900,    78,    79,    80,     0,   454,     0,    74,   230,
     259,   259,     0,     0,   678,   822,   120,     0,   823,   585,
     824,   455,     0,   259,   755,     0,     0,   755,   350,   755,
     583,     0,    78,    79,    80,   753,   670,     0,   753,     0,
     753,     0,     0,   752,     0,     0,   752,     0,   752,   664,
     664,     0,   584,     0,     0,   847,    34,   754,   370,   232,
     754,     0,   754,     0,     0,    74,   845,   795,    92,     0,
      37,   112,   113,    94,   844,    96,    74,     0,     0,   229,
     230,   235,     0,     0,    22,   259,   259,     0,   846,     0,
       0,   101,   318,     0,   387,  -474,  -474,  -474,    92,  -474,
       0,     0,   670,    94,     0,    96,     0,     0,     0,   665,
     680,   682,   701,     0,   706,   321,     0,     0,   229,   230,
     -55,   101,   318,     0,   387,   271,     0,    34,     0,   231,
     232,     0,     0,   664,    78,   334,   335,   336,   847,   100,
     585,    37,   112,   113,   233,   321,     0,   234,     0,   845,
       0,   583,   235,   631,     0,     0,    74,   844,   112,   113,
     272,     0,     0,   273,     0,   387,    34,    22,   231,   232,
       0,   846,     0,   584,     0,     0,   822,   823,   708,     0,
      37,   112,   113,   233,     0,     0,   234,     0,   290,   291,
       0,   235,     0,     0,   337,     0,     0,   755,    74,   664,
     307,    74,   824,     0,     0,     0,     0,    96,   753,   509,
     510,   511,     0,   512,     0,     0,   752,     0,     0,     0,
     755,     0,     0,   101,   102,     0,    34,     0,     0,     0,
     754,   753,   105,    74,     0,    74,     0,   330,     0,   752,
     111,   112,   113,   338,   332,     0,   339,   340,   341,    74,
     342,    74,   355,   754,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    74,    74,     0,     0,   -51,    77,     0,
       0,     0,    78,    79,    80,     0,     0,     0,     0,     0,
       0,     0,     7,     8,     9,    81,    10,    11,     0,    82,
       0,     0,     0,     0,    13,    14,     0,    15,    16,   -64,
      83,    18,    19,    20,    21,    22,    23,    24,     0,    25,
      84,    26,     0,    85,     0,    86,    28,     0,    29,    87,
      30,    88,     0,    89,    90,    31,     0,     0,     0,   679,
      74,    91,     0,    32,     0,     0,     0,     0,    92,     0,
      93,     0,     0,    94,    95,    96,    97,   229,   230,     0,
       0,     0,     0,     0,     0,    74,     0,    98,    99,     0,
     100,   101,   102,   103,    34,   104,     0,     0,     0,     0,
     105,    36,   106,   107,   108,   109,   110,    74,   111,   112,
     113,   114,     0,   115,   116,   117,   -56,   381,     0,    42,
     -51,    78,    79,    80,     0,    34,     0,   357,   232,     0,
       0,     7,     0,     0,    81,    10,    11,     0,    12,    37,
     112,   113,   233,    13,    14,   234,    15,    16,     0,     0,
     235,    19,    20,    21,    22,     0,     0,     0,    25,   316,
       0,     0,    27,     0,    86,     0,     0,    29,   317,    30,
      88,     0,    89,     0,    31,     0,     0,     0,     0,     0,
      91,     0,    32,     0,     0,     0,     0,    92,     0,    93,
       0,     0,    94,    95,    96,   271,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    98,    99,     0,   100,
     101,   318,   216,    34,   104,     0,     0,     0,     0,    35,
      36,   106,     0,   108,     0,   110,     0,    37,   112,   113,
     319,     0,   115,   320,   321,   -51,    77,     0,    42,   -56,
      78,    79,    80,     0,     0,     0,     0,     0,     0,     0,
       7,     8,     9,    81,    10,    11,     0,    82,     0,     0,
       0,     0,    13,    14,     0,    15,    16,   -64,    83,    18,
      19,    20,    21,    22,    23,    24,     0,    25,    84,    26,
       0,    85,     0,    86,    28,     0,    29,    87,    30,    88,
       0,    89,    90,    31,     0,     0,     0,     0,     0,    91,
       0,    32,     0,     0,     0,     0,    92,     0,    93,     0,
       0,    94,    95,    96,    97,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    98,    99,     0,   100,   101,
     102,   103,    34,   104,     0,     0,     0,     0,   105,    36,
     106,   107,   108,   109,   110,     0,   111,   112,   113,   114,
      77,   115,   116,   117,    78,    79,    80,    42,     0,     0,
       0,     0,     0,     0,     7,     8,     9,    81,    10,    11,
       0,    82,     0,     0,     0,     0,    13,    14,     0,    15,
      16,   -64,    83,    18,    19,    20,    21,    22,    23,    24,
       0,    25,    84,    26,     0,    85,     0,    86,    28,     0,
      29,    87,    30,    88,     0,    89,    90,    31,     0,     0,
       0,     0,     0,    91,     0,    32,     0,     0,     0,     0,
      92,     0,    93,     0,     0,    94,    95,    96,    97,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    98,
      99,     0,   100,   101,   102,   103,    34,   104,     0,     0,
       0,     0,   105,    36,   106,   107,   108,   109,   110,     0,
     111,   112,   113,   114,   381,   115,   116,   117,    78,    79,
      80,    42,   -51,     0,     0,     0,     0,     0,     7,     0,
       0,    81,    10,    11,     0,    12,     0,     0,     0,     0,
      13,    14,     0,    15,    16,     0,     0,     0,    19,    20,
      21,    22,     0,     0,     0,    25,   316,     0,     0,    27,
       0,    86,     0,     0,    29,   317,    30,    88,     0,    89,
       0,    31,     0,     0,     0,     0,     0,    91,     0,    32,
       0,     0,     0,     0,    92,     0,    93,     0,     0,    94,
      95,    96,   271,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    98,    99,     0,   100,   101,   318,     0,
      34,   104,     0,     0,     0,     0,    35,    36,   106,   271,
     108,     0,   110,   210,    37,   112,   113,   319,     0,   115,
     320,   321,   594,   100,     0,    42,   393,  -169,    22,     0,
    -169,  -169,  -169,     0,  -169,   106,   107,   108,   109,  -169,
    -169,     0,  -169,  -169,     0,   596,   115,  -169,  -169,  -169,
      22,     0,     0,     0,  -169,  -169,     0,     0,  -169,     0,
    -169,     0,     0,  -169,  -169,  -169,  -169,     0,  -169,   271,
    -169,     0,     0,     0,     0,     0,  -169,     0,  -169,     0,
       0,     0,   594,   100,     0,  -169,     0,     0,   104,  -169,
       0,     0,     0,     0,     0,   106,   107,   108,   109,     0,
     595,     0,  -169,  -169,   319,   596,   115,   320,     0,    34,
       0,     0,     0,     0,     0,  -169,  -169,     0,     0,     0,
       0,  -169,     0,    37,    38,   211,    40,    -2,     6,    41,
       0,     0,     0,     0,  -169,   212,     0,     0,     0,     0,
       0,     0,     7,     8,     9,     0,    10,    11,     0,    12,
       0,     0,     0,     0,    13,    14,     0,    15,    16,   -64,
      17,    18,    19,    20,    21,    22,    23,    24,   525,    25,
       0,    26,     0,    27,     0,     0,    28,     0,    29,     0,
      30,     0,     7,     0,     9,    31,    10,    11,     0,    12,
       0,     0,     0,    32,    13,    14,     0,    15,    16,  -131,
       0,    18,    19,    20,    21,    22,    23,    24,     0,    25,
       0,    26,     0,    27,     0,    33,    28,     0,    29,     0,
      30,     0,     0,     0,    34,    31,     0,     0,     0,     0,
      35,    36,     0,    32,     0,     0,     0,     0,    37,    38,
      39,    40,     0,     0,    41,     0,     0,     0,     0,    42,
       0,     0,     0,     0,    78,    79,    80,     0,     0,     0,
       0,     0,     0,     0,    34,     0,     0,   537,     0,     0,
      35,    36,     0,     0,     0,     0,     0,     0,    37,    38,
     526,     7,     0,     0,     0,    10,    11,     0,    12,    42,
     527,     0,     0,    13,    14,     0,    15,    16,  -144,     0,
      18,    19,    20,    21,    22,    23,    24,     0,    25,     0,
      26,     0,    27,     0,   467,    28,     0,    29,     0,    30,
      92,     0,     0,     0,    31,    94,     0,    96,     0,     0,
       0,     0,    32,     0,     0,     0,   229,   230,     0,     0,
     468,     0,     0,   101,   318,     0,    34,     0,     0,     0,
       0,     0,    35,   469,   106,     0,   108,     0,     0,     0,
      37,   112,   113,    34,     0,   115,     0,   321,     0,    35,
      36,     0,     0,     0,     0,     0,   381,    37,    38,   538,
      78,    79,    80,     0,    34,     0,   524,   232,    42,   539,
       7,     0,     0,    81,    10,    11,     0,    12,    37,   112,
     113,   233,    13,    14,   234,    15,    16,     0,     0,   235,
      19,    20,    21,    22,     0,     0,     0,    25,   316,     0,
       0,    27,     0,    86,     0,     0,    29,   317,    30,    88,
       0,    89,     0,    31,     0,     0,     0,     0,     0,    91,
       0,    32,   382,     0,     0,     0,    92,     0,    93,     0,
       0,    94,    95,    96,   271,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    98,    99,     0,   100,   101,
     318,     0,    34,   104,     0,     0,     0,     0,    35,    36,
     106,     0,   108,     0,   110,     0,    37,   112,   113,   319,
       0,   115,   320,   321,    78,    79,    80,    42,     0,     0,
       0,     0,     0,     0,     7,     8,     9,    81,    10,    11,
       0,    82,     0,     0,     0,     0,    13,    14,  -303,    15,
      16,   -64,     0,    18,    19,    20,    21,    22,    23,    24,
       0,    25,   316,    26,     0,    27,     0,    86,    28,     0,
      29,   317,    30,    88,     0,    89,    90,    31,     0,     0,
       0,     0,     0,    91,     0,    32,     0,     0,     0,     0,
      92,     0,    93,     0,     0,    94,    95,    96,   836,     0,
       0,     0,   561,     0,     0,     0,     0,     0,     0,    98,
      99,     0,   837,   101,   318,   564,    34,     0,     0,     0,
       0,     0,    35,    36,   106,   838,   108,   839,   110,   565,
      37,   840,   567,   841,     0,   115,   842,   843,    78,    79,
      80,    42,     0,     0,     0,     0,     0,     0,     7,     8,
       9,    81,    10,    11,     0,    82,  -295,     0,     0,     0,
      13,    14,  -299,    15,    16,     0,     0,    18,    19,    20,
      21,    22,    23,    24,     0,    25,    84,    26,     0,    85,
       0,    86,    28,     0,    29,    87,    30,    88,     0,    89,
      90,    31,     0,     0,     0,     0,     0,    91,     0,    32,
       0,     0,     0,     0,    92,     0,    93,     0,     0,    94,
      95,    96,   746,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    98,    99,     0,   747,   101,   102,   564,
      34,     0,     0,     0,     0,     0,   105,    36,   106,   107,
     108,   109,   110,   565,   111,   748,   567,   749,     0,   115,
     750,   751,    78,    79,    80,    42,     0,     0,     0,     0,
       0,     0,     7,     8,     9,    81,    10,    11,     0,    82,
       0,     0,     0,     0,    13,    14,     0,    15,    16,   -64,
       0,    18,    19,    20,    21,    22,    23,    24,     0,    25,
     316,    26,     0,    27,     0,    86,    28,     0,    29,   317,
      30,    88,     0,    89,    90,    31,     0,     0,     0,     0,
       0,    91,     0,    32,     0,     0,     0,     0,    92,     0,
      93,     0,     0,    94,    95,    96,   836,     0,     0,     0,
     561,     0,     0,     0,     0,     0,     0,    98,    99,     0,
     837,   101,   318,   564,    34,     0,     0,     0,     0,     0,
      35,    36,   106,   838,   108,   839,   110,   565,    37,   840,
     567,   841,     0,   115,   842,   843,    78,    79,    80,    42,
       0,     0,     0,     0,     0,     0,     7,     8,     9,    81,
      10,    11,     0,    82,  -295,     0,     0,     0,    13,    14,
    -299,    15,    16,     0,     0,    18,    19,    20,    21,    22,
      23,    24,     0,    25,   316,    26,     0,    27,     0,    86,
      28,     0,    29,   317,    30,    88,     0,    89,    90,    31,
       0,     0,     0,     0,     0,    91,     0,    32,     0,     0,
       0,     0,    92,     0,    93,     0,     0,    94,    95,    96,
     746,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    98,    99,     0,   747,   101,   318,   564,    34,     0,
       0,     0,     0,     0,    35,    36,   106,   107,   108,   109,
     110,   565,    37,   748,   567,   749,     0,   115,   750,   751,
      78,    79,    80,    42,     0,     0,     0,     0,     0,     0,
       7,     8,     9,    81,    10,    11,     0,    82,     0,     0,
       0,     0,    13,    14,  -297,    15,    16,     0,     0,    18,
      19,    20,    21,    22,    23,    24,     0,    25,    84,    26,
       0,    85,     0,    86,    28,     0,    29,    87,    30,    88,
       0,    89,    90,    31,     0,     0,     0,     0,     0,    91,
       0,    32,     0,     0,     0,     0,    92,     0,    93,     0,
       0,    94,    95,    96,   562,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    98,    99,     0,   563,   101,
     102,   564,    34,     0,     0,     0,     0,     0,   105,    36,
     106,   107,   108,   109,   110,   565,   111,   566,   567,   568,
       0,   115,   569,   570,    78,    79,    80,    42,     0,     0,
       0,     0,     0,     0,     7,     8,     9,    81,    10,    11,
       0,    82,  -295,     0,     0,     0,    13,    14,     0,    15,
      16,     0,     0,    18,    19,    20,    21,    22,    23,    24,
       0,    25,   316,    26,     0,    27,     0,    86,    28,     0,
      29,   317,    30,    88,     0,    89,    90,    31,     0,     0,
       0,     0,     0,    91,     0,    32,     0,     0,     0,     0,
      92,     0,    93,     0,     0,    94,    95,    96,   746,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    98,
      99,     0,   747,   101,   318,   564,    34,     0,     0,     0,
       0,     0,    35,    36,   106,   107,   108,   109,   110,   565,
      37,   748,   567,   749,     0,   115,   750,   751,    78,    79,
      80,    42,     0,     0,     0,     0,     0,     0,     7,     8,
       9,    81,    10,    11,     0,    82,     0,     0,     0,     0,
      13,    14,  -301,    15,    16,     0,     0,    18,    19,    20,
      21,    22,    23,    24,     0,    25,   316,    26,     0,    27,
       0,    86,    28,     0,    29,   317,    30,    88,     0,    89,
      90,    31,     0,     0,     0,     0,     0,    91,     0,    32,
       0,     0,     0,     0,    92,     0,    93,     0,     0,    94,
      95,    96,   562,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    98,    99,     0,   563,   101,   318,   564,
      34,     0,     0,     0,     0,     0,    35,    36,   106,   107,
     108,   109,   110,   565,    37,   566,   567,   568,     0,   115,
     569,   570,    78,    79,    80,    42,     0,     0,     0,     0,
       0,     0,     7,     8,     9,    81,    10,    11,     0,    82,
       0,     0,     0,     0,    13,    14,  -297,    15,    16,     0,
       0,    18,    19,    20,    21,    22,    23,    24,     0,    25,
     316,    26,     0,    27,     0,    86,    28,     0,    29,   317,
      30,    88,     0,    89,    90,    31,     0,     0,     0,     0,
       0,    91,     0,    32,     0,     0,     0,     0,    92,     0,
      93,     0,     0,    94,    95,    96,   562,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    98,    99,     0,
     563,   101,   318,   564,    34,     0,     0,     0,     0,     0,
      35,    36,   106,   107,   108,   109,   110,   565,    37,   566,
     567,   568,     0,   115,   569,   570,    78,    79,    80,    42,
       0,     0,     0,     0,     0,     0,     7,     8,     9,    81,
      10,    11,     0,    82,     0,     0,     0,     0,    13,    14,
    -299,    15,    16,     0,     0,    18,    19,    20,    21,    22,
      23,    24,     0,    25,   316,    26,     0,    27,     0,    86,
      28,     0,    29,   317,    30,    88,     0,    89,    90,    31,
       0,     0,     0,     0,     0,    91,     0,    32,     0,     0,
       0,     0,    92,     0,    93,     0,     0,    94,    95,    96,
     746,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    98,    99,     0,   747,   101,   318,   564,    34,     0,
       0,     0,     0,     0,    35,    36,   106,   107,   108,   109,
     110,   565,    37,   748,   567,   749,     0,   115,   750,   751,
      78,    79,    80,    42,     0,     0,     0,     0,     0,     0,
       7,     8,     9,    81,    10,    11,     0,    82,     0,     0,
       0,     0,    13,    14,     0,    15,    16,     0,     0,    18,
      19,    20,    21,    22,    23,    24,     0,    25,   316,    26,
       0,    27,     0,    86,    28,     0,    29,   317,    30,    88,
       0,    89,    90,    31,     0,     0,     0,     0,     0,    91,
       0,    32,     0,     0,     0,     0,    92,     0,    93,     0,
       0,    94,    95,    96,   562,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    98,    99,     0,   563,   101,
     318,   564,    34,     0,     0,     0,     0,     0,    35,    36,
     106,   107,   108,   109,   110,   565,    37,   566,   567,   568,
       0,   115,   569,   570,    78,    79,    80,    42,     0,     0,
       0,     0,     0,     0,     7,     8,     9,    81,    10,    11,
       0,    82,     0,     0,     0,     0,    13,    14,     0,    15,
      16,     0,     0,    18,    19,    20,    21,    22,    23,    24,
       0,    25,    84,    26,     0,    85,     0,    86,    28,     0,
      29,    87,    30,    88,     0,    89,    90,    31,     0,     0,
       0,     0,     0,    91,     0,    32,     0,     0,     0,     0,
      92,     0,    93,     0,     0,    94,    95,    96,   397,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    98,
      99,     0,     0,   101,   102,   103,    34,     0,     0,     0,
       0,     0,   105,    36,   106,   107,   108,   109,   110,     0,
     111,   112,   113,   398,     0,   115,   399,   400,    78,    79,
      80,    42,     0,     0,     0,     0,     0,     0,     7,     0,
       0,    81,    10,    11,     0,    12,     0,     0,     0,     0,
      13,    14,     0,    15,    16,     0,     0,     0,    19,    20,
      21,    22,     0,     0,     0,    25,   316,     0,     0,    27,
       0,    86,     0,     0,    29,   317,    30,    88,     0,    89,
       0,    31,     0,     0,     0,     0,     0,    91,     0,    32,
       0,     0,     0,     0,    92,     0,    93,     0,     0,    94,
      95,    96,   271,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    98,    99,     0,   100,   101,   318,     0,
      34,   104,     0,     0,     0,     0,    35,    36,   106,     0,
     108,     0,   110,     0,    37,   112,   113,   319,     0,   115,
     320,   321,   448,   449,     0,    42,     0,     0,     0,     0,
       0,     7,     8,     9,    81,    10,    11,     0,    82,     0,
       0,     0,     0,    13,    14,  -101,    15,    16,     0,     0,
      18,    19,    20,    21,    22,    23,    24,     0,    25,    84,
      26,     0,    85,     0,    86,    28,     0,    29,    87,    30,
      88,     0,    89,    90,    31,     0,     0,     0,     0,     0,
      91,     0,    32,     0,     0,     0,     0,     0,     0,    93,
       0,     0,     0,    95,     0,   397,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    98,    99,     0,     0,
       0,   453,   564,    34,     0,     0,     0,     0,     0,   105,
      36,   106,   107,   108,   109,   110,   565,   111,   662,   567,
     398,     0,   115,   399,   663,   448,   449,     0,    42,     0,
       0,     0,     0,     0,     7,     8,     9,    81,    10,    11,
       0,    82,     0,     0,     0,     0,    13,    14,  -102,    15,
      16,     0,     0,    18,    19,    20,    21,    22,    23,    24,
       0,    25,    84,    26,     0,    85,     0,    86,    28,     0,
      29,    87,    30,    88,     0,    89,    90,    31,     0,     0,
       0,     0,     0,    91,     0,    32,     0,     0,     0,     0,
       0,     0,    93,     0,     0,     0,    95,     0,   397,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    98,
      99,     0,     0,     0,   453,   564,    34,     0,     0,     0,
       0,     0,   105,    36,   106,   107,   108,   109,   110,   565,
     111,   662,   567,   398,     0,   115,   399,   663,   448,   449,
       0,    42,     0,     0,     0,     0,     0,     7,     0,     0,
      81,    10,    11,     0,    12,     0,     0,     0,     0,    13,
      14,     0,    15,    16,     0,     0,     0,    19,    20,    21,
      22,     0,     0,     0,    25,    84,     0,     0,    85,     0,
      86,     0,     0,    29,    87,    30,    88,     0,    89,     0,
      31,    78,   334,   335,   336,     0,    91,     0,    32,     0,
       0,     0,     0,     0,     0,    93,     0,     0,     0,    95,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   448,
     449,     0,    98,    99,    22,     0,     0,   453,     0,     0,
     104,     0,     0,     0,     0,   105,    36,   106,     0,   108,
       0,   110,     0,   678,     0,     0,   319,     0,   115,   320,
     455,   337,     0,     0,    42,     0,   450,     0,     0,   451,
       0,     0,     0,     0,    96,   452,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     101,   318,     0,    34,     0,     0,     0,     0,     0,    35,
       0,     0,   374,     0,     0,     0,     0,    37,   112,   113,
     338,     0,     0,   339,   340,   341,     0,   342,   453,   638,
      34,   639,     0,     0,    22,     0,   454,     0,   640,   375,
       0,   641,   642,   643,   111,   112,   113,     0,     0,     0,
       0,   455,     0,     0,   638,     0,   639,     0,   644,     0,
     645,     0,   646,   640,     0,   647,   641,   642,   643,     0,
       0,     0,   648,   649,    90,   271,     0,     0,     0,     0,
       0,     0,     0,   644,     0,   645,     0,   646,   594,   100,
     647,     0,     0,     0,   104,     0,     0,   648,   649,     0,
       0,   106,   107,   108,   109,     0,   603,     0,     0,     0,
     319,   596,   115,   320,    34,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    37,   112,
     113,   175,     0,     0,   176,     0,     0,     0,     0,    34,
     650,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    37,   112,   113,   175,     0,     0,   176,
       0,     0,     0,     0,     0,   813,     7,     8,     9,    81,
      10,    11,     0,    82,     0,     0,     0,     0,    13,    14,
       0,    15,    16,     0,     0,    18,    19,    20,    21,    22,
      23,    24,     0,    25,   316,    26,     0,    27,     0,    86,
      28,     0,    29,   317,    30,    88,     0,    89,    90,    31,
       0,     0,     0,     0,     0,    91,     0,    32,     0,     0,
       0,     0,     0,     0,    93,     0,     0,     0,    95,     0,
     397,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    98,    99,     0,     0,     0,     0,   564,    34,     0,
       0,     0,     0,     0,    35,    36,   106,   107,   108,   109,
     110,   565,    37,   662,   567,   398,     0,   115,   399,   825,
       0,     7,     0,    42,    81,    10,    11,     0,    12,     0,
       0,     0,     0,    13,    14,     0,    15,    16,  -155,     0,
      18,    19,    20,    21,    22,     0,    24,     0,    25,   316,
      26,     0,    27,     0,    86,     0,     0,    29,   317,    30,
      88,     0,    89,     0,    31,     0,     0,     0,     0,     0,
      91,     0,    32,     0,     0,     0,     0,     0,     0,    93,
       0,     0,     0,    95,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    98,    99,     0,     0,
       0,     0,     0,    34,   104,     0,     0,     0,     0,    35,
      36,   106,     0,   108,     0,   110,     0,    37,   112,   113,
     319,     0,   115,   320,     0,     0,     7,     0,    42,    81,
      10,    11,     0,    12,     0,     0,     0,     0,    13,    14,
       0,    15,    16,     0,     0,     0,    19,    20,    21,    22,
       0,     0,     0,    25,   316,     0,     0,    27,     0,    86,
       0,     0,    29,   317,    30,    88,     0,    89,     0,    31,
       0,     0,     0,     0,     0,    91,     0,    32,     0,     0,
       0,     0,     0,     0,    93,     0,     0,     0,    95,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    98,    99,     0,     0,     0,     0,     0,     0,   104,
       0,     0,     0,     0,    35,    36,   106,     0,   108,     7,
     110,     0,    81,    10,    11,   319,    82,   115,   320,     0,
       0,    13,    14,    42,    15,    16,     0,     0,     0,    19,
      20,    21,     0,     0,     0,     0,    25,   316,     0,     0,
      27,     0,    86,     0,     0,    29,   317,    30,    88,     0,
      89,     0,    31,    10,    11,     0,     0,     0,    91,     0,
      32,    13,    14,     0,    15,    16,     0,    93,     0,    19,
      20,    95,     0,     0,     7,     0,    25,     0,    10,    11,
       0,    12,     0,     0,    98,    99,    13,    14,     0,    15,
      16,     0,     0,     0,    19,    20,    21,    35,    36,     0,
       0,    25,     0,   110,     0,    27,     0,     0,     0,     0,
      29,     0,    30,    88,     0,     0,    42,    31,     0,     0,
       0,     0,     0,    91,     0,    32,     0,     0,     0,     0,
       0,    34,    93,     0,     0,     0,    95,     0,   776,     0,
       0,     0,     0,     0,     0,    37,   112,   113,   777,    98,
      99,     0,     0,     0,     0,     0,   778,     0,     0,     0,
       0,     0,    35,    36,   106,     0,   108,     7,   110,     0,
       0,    10,    11,     0,    12,   115,     0,     0,     0,    13,
      14,    42,    15,    16,     0,     0,     0,    19,    20,    21,
       0,     0,     0,     0,    25,     0,     0,     0,    27,     0,
       0,     0,     0,    29,     0,    30,     0,     0,     0,     0,
      31,     0,     0,     0,     0,     0,     0,     0,    32,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    35,    36,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    42
};

static const yytype_int16 yycheck[] =
{
       3,     4,     3,     4,    86,    83,     3,     3,     4,     3,
       3,   188,     3,     4,   154,     3,     4,     4,     3,   100,
     245,     3,     4,     3,     4,    74,   245,   245,   208,     4,
       4,    57,   108,    57,     4,     4,   492,    21,     4,   115,
     156,    71,   161,     4,    89,   164,   463,    31,   316,     4,
     136,   520,   521,   248,   184,   524,   418,   231,   102,     9,
      10,   105,     0,    57,    57,     4,    84,   111,   248,    87,
     560,    89,    57,   560,     1,    42,   208,    88,    37,   392,
      83,   156,    83,     0,    10,    88,   264,    83,   184,   266,
     400,    27,    83,     1,   392,    83,    83,    81,    74,     0,
     156,    83,   628,    83,    87,    62,   329,   193,    83,    83,
       0,    74,    10,    83,    83,   224,   248,    83,   204,   529,
     122,   377,    83,   379,   124,   745,   121,     0,    83,   129,
      32,   541,     0,   110,   359,   184,     0,   645,   115,   647,
     359,   359,   447,   102,    83,     1,   556,   117,   373,    85,
      79,     4,   111,   156,   373,   293,   104,     0,   463,   297,
     122,   136,   119,   121,    10,    10,   124,   286,   391,   392,
     308,   290,    13,    10,   122,   136,   194,   106,   122,   108,
     106,   136,   450,   357,    79,   123,   268,   122,   550,   118,
      10,   167,   101,   102,    10,   121,   123,   227,    93,    81,
     726,   821,   458,    85,   167,   208,   123,   208,   327,   122,
     700,   330,   208,   700,   124,   123,    12,   208,   193,    79,
     208,   208,   123,   121,    79,    21,   208,   283,   208,   204,
      83,    27,   193,   208,   208,    31,   355,    90,   193,   208,
     215,   228,   208,   204,   700,   248,   215,   248,   561,   204,
     123,   326,   248,   216,   723,   123,   365,   248,   106,   123,
     248,   248,   624,   561,   275,    82,   248,   123,   248,   208,
     326,   380,   317,   248,   248,   121,   121,   373,   106,   248,
     123,   284,   248,   136,   121,    81,    82,   406,    84,    85,
      86,    87,    88,    89,   711,   424,   425,   426,   316,   317,
     429,   121,   432,   156,   614,   121,     7,    82,    83,   248,
     419,   621,   622,   114,    29,   447,   117,    81,    97,    79,
      38,    85,   283,   326,   124,   104,    81,   266,    29,    30,
      85,   463,   111,   112,   113,   188,    96,   361,   368,   363,
     193,   457,   125,    10,   127,   835,   106,    88,   835,   468,
     524,   204,   112,   113,   492,   208,   323,    88,   361,   318,
     363,   124,   444,   445,   361,   361,   363,   361,   681,   363,
     361,   124,   363,   361,   350,   363,   361,   794,   363,   361,
      98,   363,   124,   432,    38,   388,   876,   350,   379,   876,
     104,   520,   521,    81,   388,   248,   114,   124,   194,   117,
     869,   870,   377,   388,   379,   710,   711,   452,   633,   453,
     454,   207,    79,   266,   633,   633,   611,    83,   388,   505,
     876,   391,   392,   118,   119,   391,   392,    83,   364,   122,
     283,   611,   450,   369,   452,    13,   391,   392,   616,   617,
      57,    95,   124,   860,   447,   112,   113,   114,    79,   103,
     117,   124,    79,   447,   121,    79,   443,   111,   122,   443,
     463,   124,   447,   124,    68,    69,    70,    81,   264,   463,
     121,    75,   268,   326,   195,   106,    81,   108,   463,   611,
     483,   447,   106,   458,   108,   112,   113,   114,   284,   794,
     117,   390,   495,     9,   497,   672,    10,   463,   501,   629,
      81,   495,    81,   497,    85,    86,   442,   501,   447,     8,
     495,    29,   497,   594,    79,   451,   501,    80,    81,   458,
     316,   317,   126,   127,   463,   495,   379,   497,   125,   208,
     505,   501,    97,   629,   630,    80,   674,    97,   676,    80,
      81,   106,    81,    84,   505,    86,   111,   112,   113,   102,
     505,   111,   112,   113,   114,   860,   495,   117,   497,   784,
     625,   626,   501,   645,   702,   647,   784,   266,   364,   248,
      79,    80,   293,   369,    82,    79,   297,   717,   710,   711,
     629,   630,    79,   808,   610,    38,   610,   308,   124,   592,
     443,   561,   122,   283,   723,   561,    81,   496,   592,   498,
      85,    86,   106,   502,   108,   122,   561,   592,   611,   106,
     611,   108,   465,    82,    79,   611,   610,   610,   796,   797,
     611,    49,   592,   611,   611,   610,   283,   619,   620,   611,
     679,   611,    82,   124,   678,   812,   611,   611,    81,   715,
      15,   106,   611,   108,    97,   611,   442,   443,   444,   445,
     124,   124,   505,   116,   450,   451,   452,   654,   111,   112,
     113,   114,   794,    15,   117,   649,    81,   805,    23,    97,
     123,    99,   611,   106,    81,   124,    51,    81,    53,   447,
     124,    85,    86,   111,   112,   113,   114,   483,   784,   117,
     124,    66,   112,   113,   114,   463,   699,   117,   388,    81,
      99,   704,   122,   687,   707,   699,   709,   710,   711,   388,
     704,    81,   118,   707,   699,   709,   710,   711,    29,   704,
      81,   517,   707,    23,   709,   710,   711,   809,   860,   699,
     101,   388,   735,   672,   704,   854,   124,   707,   834,   709,
     869,   735,   760,   761,   710,   711,    81,   122,   447,    81,
     735,    99,    81,    85,    86,   121,   875,   833,   611,   458,
      81,   112,   113,   114,   463,   704,   117,    79,   707,    47,
     709,   492,   112,   113,   114,   628,   447,   117,   123,   898,
     117,   859,    80,    81,   687,   834,    84,   363,    86,   871,
     872,   794,   463,    59,    60,    61,   495,    63,   497,    63,
     794,   551,   501,   220,   657,   495,    63,   497,    63,   794,
     687,   501,   192,    79,   759,   818,   495,   820,   497,   672,
     616,   617,   501,    89,   818,    81,   820,    63,   794,    85,
      86,   684,    81,   818,   687,   820,    85,    86,   495,   560,
     497,    80,    81,   816,   501,    84,   745,    86,   483,   645,
     820,   647,   509,   649,   684,   512,   859,   860,   859,   798,
     799,   800,   801,   859,   803,     3,   860,   714,   859,   477,
     880,   859,   859,   726,   877,   860,    81,   859,   689,   859,
      85,    86,    38,   877,   859,   859,   167,    -1,   432,   859,
     859,   687,   877,   859,   860,   663,    -1,   900,   859,     6,
       7,    -1,   592,   802,   859,   804,   900,   877,    80,    81,
      38,    -1,    84,   592,    86,   900,    72,    -1,    74,    57,
     859,   592,   821,    79,    -1,    -1,   865,   866,   867,    81,
     900,    -1,   611,    85,    86,   592,    43,    -1,    -1,    46,
      -1,    -1,   710,   711,    81,    52,    74,    -1,    85,    86,
      88,    79,   891,   674,    -1,   676,   112,   113,   114,   812,
      -1,   117,    -1,    -1,   760,   761,   112,   113,   114,   868,
      81,   117,   128,   672,    85,    86,    -1,    -1,    81,   700,
      -1,   702,    85,    86,   112,   113,   114,     0,    95,   117,
      -1,   890,     5,     6,     7,    -1,   103,    -1,   136,    50,
     796,   797,    -1,    -1,   111,   704,   859,    -1,   707,   699,
     709,   118,    -1,   809,   704,    -1,    -1,   707,   156,   709,
     699,    -1,     5,     6,     7,   704,   794,    -1,   707,    -1,
     709,    -1,    -1,   704,    -1,    -1,   707,    -1,   709,   710,
     711,    -1,   699,    -1,    -1,   735,    97,   704,    99,   100,
     707,    -1,   709,    -1,    -1,   193,   735,   825,    71,    -1,
     111,   112,   113,    76,   735,    78,   204,    -1,    -1,    49,
      50,   122,    -1,    -1,    38,   871,   872,    -1,   735,    -1,
      -1,    94,    95,    -1,   805,    59,    60,    61,    71,    63,
      -1,    -1,   860,    76,    -1,    78,    -1,    -1,    -1,   798,
     799,   800,   801,    -1,   803,   118,    -1,    -1,    49,    50,
     123,    94,    95,    -1,   835,    79,    -1,    97,    -1,    99,
     100,    -1,    -1,   794,     5,     6,     7,     8,   818,    93,
     820,   111,   112,   113,   114,   118,    -1,   117,    -1,   818,
      -1,   820,   122,   123,    -1,    -1,   284,   818,   112,   113,
     114,    -1,    -1,   117,    -1,   876,    97,    38,    99,   100,
      -1,   818,    -1,   820,    -1,    -1,   865,   866,   867,    -1,
     111,   112,   113,   114,    -1,    -1,   117,    -1,    98,    99,
      -1,   122,    -1,    -1,    65,    -1,    -1,   877,   326,   860,
     110,   329,   891,    -1,    -1,    -1,    -1,    78,   877,    59,
      60,    61,    -1,    63,    -1,    -1,   877,    -1,    -1,    -1,
     900,    -1,    -1,    94,    95,    -1,    97,    -1,    -1,    -1,
     877,   900,   103,   361,    -1,   363,    -1,   147,    -1,   900,
     111,   112,   113,   114,   154,    -1,   117,   118,   119,   377,
     121,   379,   162,   900,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   391,   392,    -1,    -1,     0,     1,    -1,
      -1,    -1,     5,     6,     7,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    15,    16,    17,    18,    19,    20,    -1,    22,
      -1,    -1,    -1,    -1,    27,    28,    -1,    30,    31,    32,
      33,    34,    35,    36,    37,    38,    39,    40,    -1,    42,
      43,    44,    -1,    46,    -1,    48,    49,    -1,    51,    52,
      53,    54,    -1,    56,    57,    58,    -1,    -1,    -1,   457,
     458,    64,    -1,    66,    -1,    -1,    -1,    -1,    71,    -1,
      73,    -1,    -1,    76,    77,    78,    79,    49,    50,    -1,
      -1,    -1,    -1,    -1,    -1,   483,    -1,    90,    91,    -1,
      93,    94,    95,    96,    97,    98,    -1,    -1,    -1,    -1,
     103,   104,   105,   106,   107,   108,   109,   505,   111,   112,
     113,   114,    -1,   116,   117,   118,     0,     1,    -1,   122,
     123,     5,     6,     7,    -1,    97,    -1,    99,   100,    -1,
      -1,    15,    -1,    -1,    18,    19,    20,    -1,    22,   111,
     112,   113,   114,    27,    28,   117,    30,    31,    -1,    -1,
     122,    35,    36,    37,    38,    -1,    -1,    -1,    42,    43,
      -1,    -1,    46,    -1,    48,    -1,    -1,    51,    52,    53,
      54,    -1,    56,    -1,    58,    -1,    -1,    -1,    -1,    -1,
      64,    -1,    66,    -1,    -1,    -1,    -1,    71,    -1,    73,
      -1,    -1,    76,    77,    78,    79,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    90,    91,    -1,    93,
      94,    95,   610,    97,    98,    -1,    -1,    -1,    -1,   103,
     104,   105,    -1,   107,    -1,   109,    -1,   111,   112,   113,
     114,    -1,   116,   117,   118,     0,     1,    -1,   122,   123,
       5,     6,     7,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      15,    16,    17,    18,    19,    20,    -1,    22,    -1,    -1,
      -1,    -1,    27,    28,    -1,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    -1,    42,    43,    44,
      -1,    46,    -1,    48,    49,    -1,    51,    52,    53,    54,
      -1,    56,    57,    58,    -1,    -1,    -1,    -1,    -1,    64,
      -1,    66,    -1,    -1,    -1,    -1,    71,    -1,    73,    -1,
      -1,    76,    77,    78,    79,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    90,    91,    -1,    93,    94,
      95,    96,    97,    98,    -1,    -1,    -1,    -1,   103,   104,
     105,   106,   107,   108,   109,    -1,   111,   112,   113,   114,
       1,   116,   117,   118,     5,     6,     7,   122,    -1,    -1,
      -1,    -1,    -1,    -1,    15,    16,    17,    18,    19,    20,
      -1,    22,    -1,    -1,    -1,    -1,    27,    28,    -1,    30,
      31,    32,    33,    34,    35,    36,    37,    38,    39,    40,
      -1,    42,    43,    44,    -1,    46,    -1,    48,    49,    -1,
      51,    52,    53,    54,    -1,    56,    57,    58,    -1,    -1,
      -1,    -1,    -1,    64,    -1,    66,    -1,    -1,    -1,    -1,
      71,    -1,    73,    -1,    -1,    76,    77,    78,    79,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    90,
      91,    -1,    93,    94,    95,    96,    97,    98,    -1,    -1,
      -1,    -1,   103,   104,   105,   106,   107,   108,   109,    -1,
     111,   112,   113,   114,     1,   116,   117,   118,     5,     6,
       7,   122,   123,    -1,    -1,    -1,    -1,    -1,    15,    -1,
      -1,    18,    19,    20,    -1,    22,    -1,    -1,    -1,    -1,
      27,    28,    -1,    30,    31,    -1,    -1,    -1,    35,    36,
      37,    38,    -1,    -1,    -1,    42,    43,    -1,    -1,    46,
      -1,    48,    -1,    -1,    51,    52,    53,    54,    -1,    56,
      -1,    58,    -1,    -1,    -1,    -1,    -1,    64,    -1,    66,
      -1,    -1,    -1,    -1,    71,    -1,    73,    -1,    -1,    76,
      77,    78,    79,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    90,    91,    -1,    93,    94,    95,    -1,
      97,    98,    -1,    -1,    -1,    -1,   103,   104,   105,    79,
     107,    -1,   109,     1,   111,   112,   113,   114,    -1,   116,
     117,   118,    92,    93,    -1,   122,   123,    15,    38,    -1,
      18,    19,    20,    -1,    22,   105,   106,   107,   108,    27,
      28,    -1,    30,    31,    -1,   115,   116,    35,    36,    37,
      38,    -1,    -1,    -1,    42,    43,    -1,    -1,    46,    -1,
      48,    -1,    -1,    51,    52,    53,    54,    -1,    56,    79,
      58,    -1,    -1,    -1,    -1,    -1,    64,    -1,    66,    -1,
      -1,    -1,    92,    93,    -1,    73,    -1,    -1,    98,    77,
      -1,    -1,    -1,    -1,    -1,   105,   106,   107,   108,    -1,
     110,    -1,    90,    91,   114,   115,   116,   117,    -1,    97,
      -1,    -1,    -1,    -1,    -1,   103,   104,    -1,    -1,    -1,
      -1,   109,    -1,   111,   112,   113,   114,     0,     1,   117,
      -1,    -1,    -1,    -1,   122,   123,    -1,    -1,    -1,    -1,
      -1,    -1,    15,    16,    17,    -1,    19,    20,    -1,    22,
      -1,    -1,    -1,    -1,    27,    28,    -1,    30,    31,    32,
      33,    34,    35,    36,    37,    38,    39,    40,     1,    42,
      -1,    44,    -1,    46,    -1,    -1,    49,    -1,    51,    -1,
      53,    -1,    15,    -1,    17,    58,    19,    20,    -1,    22,
      -1,    -1,    -1,    66,    27,    28,    -1,    30,    31,    32,
      -1,    34,    35,    36,    37,    38,    39,    40,    -1,    42,
      -1,    44,    -1,    46,    -1,    88,    49,    -1,    51,    -1,
      53,    -1,    -1,    -1,    97,    58,    -1,    -1,    -1,    -1,
     103,   104,    -1,    66,    -1,    -1,    -1,    -1,   111,   112,
     113,   114,    -1,    -1,   117,    -1,    -1,    -1,    -1,   122,
      -1,    -1,    -1,    -1,     5,     6,     7,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    97,    -1,    -1,     1,    -1,    -1,
     103,   104,    -1,    -1,    -1,    -1,    -1,    -1,   111,   112,
     113,    15,    -1,    -1,    -1,    19,    20,    -1,    22,   122,
     123,    -1,    -1,    27,    28,    -1,    30,    31,    32,    -1,
      34,    35,    36,    37,    38,    39,    40,    -1,    42,    -1,
      44,    -1,    46,    -1,    65,    49,    -1,    51,    -1,    53,
      71,    -1,    -1,    -1,    58,    76,    -1,    78,    -1,    -1,
      -1,    -1,    66,    -1,    -1,    -1,    49,    50,    -1,    -1,
      91,    -1,    -1,    94,    95,    -1,    97,    -1,    -1,    -1,
      -1,    -1,   103,   104,   105,    -1,   107,    -1,    -1,    -1,
     111,   112,   113,    97,    -1,   116,    -1,   118,    -1,   103,
     104,    -1,    -1,    -1,    -1,    -1,     1,   111,   112,   113,
       5,     6,     7,    -1,    97,    -1,    99,   100,   122,   123,
      15,    -1,    -1,    18,    19,    20,    -1,    22,   111,   112,
     113,   114,    27,    28,   117,    30,    31,    -1,    -1,   122,
      35,    36,    37,    38,    -1,    -1,    -1,    42,    43,    -1,
      -1,    46,    -1,    48,    -1,    -1,    51,    52,    53,    54,
      -1,    56,    -1,    58,    -1,    -1,    -1,    -1,    -1,    64,
      -1,    66,    67,    -1,    -1,    -1,    71,    -1,    73,    -1,
      -1,    76,    77,    78,    79,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    90,    91,    -1,    93,    94,
      95,    -1,    97,    98,    -1,    -1,    -1,    -1,   103,   104,
     105,    -1,   107,    -1,   109,    -1,   111,   112,   113,   114,
      -1,   116,   117,   118,     5,     6,     7,   122,    -1,    -1,
      -1,    -1,    -1,    -1,    15,    16,    17,    18,    19,    20,
      -1,    22,    -1,    -1,    -1,    -1,    27,    28,    29,    30,
      31,    32,    -1,    34,    35,    36,    37,    38,    39,    40,
      -1,    42,    43,    44,    -1,    46,    -1,    48,    49,    -1,
      51,    52,    53,    54,    -1,    56,    57,    58,    -1,    -1,
      -1,    -1,    -1,    64,    -1,    66,    -1,    -1,    -1,    -1,
      71,    -1,    73,    -1,    -1,    76,    77,    78,    79,    -1,
      -1,    -1,    83,    -1,    -1,    -1,    -1,    -1,    -1,    90,
      91,    -1,    93,    94,    95,    96,    97,    -1,    -1,    -1,
      -1,    -1,   103,   104,   105,   106,   107,   108,   109,   110,
     111,   112,   113,   114,    -1,   116,   117,   118,     5,     6,
       7,   122,    -1,    -1,    -1,    -1,    -1,    -1,    15,    16,
      17,    18,    19,    20,    -1,    22,    23,    -1,    -1,    -1,
      27,    28,    29,    30,    31,    -1,    -1,    34,    35,    36,
      37,    38,    39,    40,    -1,    42,    43,    44,    -1,    46,
      -1,    48,    49,    -1,    51,    52,    53,    54,    -1,    56,
      57,    58,    -1,    -1,    -1,    -1,    -1,    64,    -1,    66,
      -1,    -1,    -1,    -1,    71,    -1,    73,    -1,    -1,    76,
      77,    78,    79,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    90,    91,    -1,    93,    94,    95,    96,
      97,    -1,    -1,    -1,    -1,    -1,   103,   104,   105,   106,
     107,   108,   109,   110,   111,   112,   113,   114,    -1,   116,
     117,   118,     5,     6,     7,   122,    -1,    -1,    -1,    -1,
      -1,    -1,    15,    16,    17,    18,    19,    20,    -1,    22,
      -1,    -1,    -1,    -1,    27,    28,    -1,    30,    31,    32,
      -1,    34,    35,    36,    37,    38,    39,    40,    -1,    42,
      43,    44,    -1,    46,    -1,    48,    49,    -1,    51,    52,
      53,    54,    -1,    56,    57,    58,    -1,    -1,    -1,    -1,
      -1,    64,    -1,    66,    -1,    -1,    -1,    -1,    71,    -1,
      73,    -1,    -1,    76,    77,    78,    79,    -1,    -1,    -1,
      83,    -1,    -1,    -1,    -1,    -1,    -1,    90,    91,    -1,
      93,    94,    95,    96,    97,    -1,    -1,    -1,    -1,    -1,
     103,   104,   105,   106,   107,   108,   109,   110,   111,   112,
     113,   114,    -1,   116,   117,   118,     5,     6,     7,   122,
      -1,    -1,    -1,    -1,    -1,    -1,    15,    16,    17,    18,
      19,    20,    -1,    22,    23,    -1,    -1,    -1,    27,    28,
      29,    30,    31,    -1,    -1,    34,    35,    36,    37,    38,
      39,    40,    -1,    42,    43,    44,    -1,    46,    -1,    48,
      49,    -1,    51,    52,    53,    54,    -1,    56,    57,    58,
      -1,    -1,    -1,    -1,    -1,    64,    -1,    66,    -1,    -1,
      -1,    -1,    71,    -1,    73,    -1,    -1,    76,    77,    78,
      79,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    90,    91,    -1,    93,    94,    95,    96,    97,    -1,
      -1,    -1,    -1,    -1,   103,   104,   105,   106,   107,   108,
     109,   110,   111,   112,   113,   114,    -1,   116,   117,   118,
       5,     6,     7,   122,    -1,    -1,    -1,    -1,    -1,    -1,
      15,    16,    17,    18,    19,    20,    -1,    22,    -1,    -1,
      -1,    -1,    27,    28,    29,    30,    31,    -1,    -1,    34,
      35,    36,    37,    38,    39,    40,    -1,    42,    43,    44,
      -1,    46,    -1,    48,    49,    -1,    51,    52,    53,    54,
      -1,    56,    57,    58,    -1,    -1,    -1,    -1,    -1,    64,
      -1,    66,    -1,    -1,    -1,    -1,    71,    -1,    73,    -1,
      -1,    76,    77,    78,    79,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    90,    91,    -1,    93,    94,
      95,    96,    97,    -1,    -1,    -1,    -1,    -1,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
      -1,   116,   117,   118,     5,     6,     7,   122,    -1,    -1,
      -1,    -1,    -1,    -1,    15,    16,    17,    18,    19,    20,
      -1,    22,    23,    -1,    -1,    -1,    27,    28,    -1,    30,
      31,    -1,    -1,    34,    35,    36,    37,    38,    39,    40,
      -1,    42,    43,    44,    -1,    46,    -1,    48,    49,    -1,
      51,    52,    53,    54,    -1,    56,    57,    58,    -1,    -1,
      -1,    -1,    -1,    64,    -1,    66,    -1,    -1,    -1,    -1,
      71,    -1,    73,    -1,    -1,    76,    77,    78,    79,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    90,
      91,    -1,    93,    94,    95,    96,    97,    -1,    -1,    -1,
      -1,    -1,   103,   104,   105,   106,   107,   108,   109,   110,
     111,   112,   113,   114,    -1,   116,   117,   118,     5,     6,
       7,   122,    -1,    -1,    -1,    -1,    -1,    -1,    15,    16,
      17,    18,    19,    20,    -1,    22,    -1,    -1,    -1,    -1,
      27,    28,    29,    30,    31,    -1,    -1,    34,    35,    36,
      37,    38,    39,    40,    -1,    42,    43,    44,    -1,    46,
      -1,    48,    49,    -1,    51,    52,    53,    54,    -1,    56,
      57,    58,    -1,    -1,    -1,    -1,    -1,    64,    -1,    66,
      -1,    -1,    -1,    -1,    71,    -1,    73,    -1,    -1,    76,
      77,    78,    79,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    90,    91,    -1,    93,    94,    95,    96,
      97,    -1,    -1,    -1,    -1,    -1,   103,   104,   105,   106,
     107,   108,   109,   110,   111,   112,   113,   114,    -1,   116,
     117,   118,     5,     6,     7,   122,    -1,    -1,    -1,    -1,
      -1,    -1,    15,    16,    17,    18,    19,    20,    -1,    22,
      -1,    -1,    -1,    -1,    27,    28,    29,    30,    31,    -1,
      -1,    34,    35,    36,    37,    38,    39,    40,    -1,    42,
      43,    44,    -1,    46,    -1,    48,    49,    -1,    51,    52,
      53,    54,    -1,    56,    57,    58,    -1,    -1,    -1,    -1,
      -1,    64,    -1,    66,    -1,    -1,    -1,    -1,    71,    -1,
      73,    -1,    -1,    76,    77,    78,    79,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    90,    91,    -1,
      93,    94,    95,    96,    97,    -1,    -1,    -1,    -1,    -1,
     103,   104,   105,   106,   107,   108,   109,   110,   111,   112,
     113,   114,    -1,   116,   117,   118,     5,     6,     7,   122,
      -1,    -1,    -1,    -1,    -1,    -1,    15,    16,    17,    18,
      19,    20,    -1,    22,    -1,    -1,    -1,    -1,    27,    28,
      29,    30,    31,    -1,    -1,    34,    35,    36,    37,    38,
      39,    40,    -1,    42,    43,    44,    -1,    46,    -1,    48,
      49,    -1,    51,    52,    53,    54,    -1,    56,    57,    58,
      -1,    -1,    -1,    -1,    -1,    64,    -1,    66,    -1,    -1,
      -1,    -1,    71,    -1,    73,    -1,    -1,    76,    77,    78,
      79,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    90,    91,    -1,    93,    94,    95,    96,    97,    -1,
      -1,    -1,    -1,    -1,   103,   104,   105,   106,   107,   108,
     109,   110,   111,   112,   113,   114,    -1,   116,   117,   118,
       5,     6,     7,   122,    -1,    -1,    -1,    -1,    -1,    -1,
      15,    16,    17,    18,    19,    20,    -1,    22,    -1,    -1,
      -1,    -1,    27,    28,    -1,    30,    31,    -1,    -1,    34,
      35,    36,    37,    38,    39,    40,    -1,    42,    43,    44,
      -1,    46,    -1,    48,    49,    -1,    51,    52,    53,    54,
      -1,    56,    57,    58,    -1,    -1,    -1,    -1,    -1,    64,
      -1,    66,    -1,    -1,    -1,    -1,    71,    -1,    73,    -1,
      -1,    76,    77,    78,    79,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    90,    91,    -1,    93,    94,
      95,    96,    97,    -1,    -1,    -1,    -1,    -1,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
      -1,   116,   117,   118,     5,     6,     7,   122,    -1,    -1,
      -1,    -1,    -1,    -1,    15,    16,    17,    18,    19,    20,
      -1,    22,    -1,    -1,    -1,    -1,    27,    28,    -1,    30,
      31,    -1,    -1,    34,    35,    36,    37,    38,    39,    40,
      -1,    42,    43,    44,    -1,    46,    -1,    48,    49,    -1,
      51,    52,    53,    54,    -1,    56,    57,    58,    -1,    -1,
      -1,    -1,    -1,    64,    -1,    66,    -1,    -1,    -1,    -1,
      71,    -1,    73,    -1,    -1,    76,    77,    78,    79,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    90,
      91,    -1,    -1,    94,    95,    96,    97,    -1,    -1,    -1,
      -1,    -1,   103,   104,   105,   106,   107,   108,   109,    -1,
     111,   112,   113,   114,    -1,   116,   117,   118,     5,     6,
       7,   122,    -1,    -1,    -1,    -1,    -1,    -1,    15,    -1,
      -1,    18,    19,    20,    -1,    22,    -1,    -1,    -1,    -1,
      27,    28,    -1,    30,    31,    -1,    -1,    -1,    35,    36,
      37,    38,    -1,    -1,    -1,    42,    43,    -1,    -1,    46,
      -1,    48,    -1,    -1,    51,    52,    53,    54,    -1,    56,
      -1,    58,    -1,    -1,    -1,    -1,    -1,    64,    -1,    66,
      -1,    -1,    -1,    -1,    71,    -1,    73,    -1,    -1,    76,
      77,    78,    79,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    90,    91,    -1,    93,    94,    95,    -1,
      97,    98,    -1,    -1,    -1,    -1,   103,   104,   105,    -1,
     107,    -1,   109,    -1,   111,   112,   113,   114,    -1,   116,
     117,   118,     6,     7,    -1,   122,    -1,    -1,    -1,    -1,
      -1,    15,    16,    17,    18,    19,    20,    -1,    22,    -1,
      -1,    -1,    -1,    27,    28,    29,    30,    31,    -1,    -1,
      34,    35,    36,    37,    38,    39,    40,    -1,    42,    43,
      44,    -1,    46,    -1,    48,    49,    -1,    51,    52,    53,
      54,    -1,    56,    57,    58,    -1,    -1,    -1,    -1,    -1,
      64,    -1,    66,    -1,    -1,    -1,    -1,    -1,    -1,    73,
      -1,    -1,    -1,    77,    -1,    79,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    90,    91,    -1,    -1,
      -1,    95,    96,    97,    -1,    -1,    -1,    -1,    -1,   103,
     104,   105,   106,   107,   108,   109,   110,   111,   112,   113,
     114,    -1,   116,   117,   118,     6,     7,    -1,   122,    -1,
      -1,    -1,    -1,    -1,    15,    16,    17,    18,    19,    20,
      -1,    22,    -1,    -1,    -1,    -1,    27,    28,    29,    30,
      31,    -1,    -1,    34,    35,    36,    37,    38,    39,    40,
      -1,    42,    43,    44,    -1,    46,    -1,    48,    49,    -1,
      51,    52,    53,    54,    -1,    56,    57,    58,    -1,    -1,
      -1,    -1,    -1,    64,    -1,    66,    -1,    -1,    -1,    -1,
      -1,    -1,    73,    -1,    -1,    -1,    77,    -1,    79,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    90,
      91,    -1,    -1,    -1,    95,    96,    97,    -1,    -1,    -1,
      -1,    -1,   103,   104,   105,   106,   107,   108,   109,   110,
     111,   112,   113,   114,    -1,   116,   117,   118,     6,     7,
      -1,   122,    -1,    -1,    -1,    -1,    -1,    15,    -1,    -1,
      18,    19,    20,    -1,    22,    -1,    -1,    -1,    -1,    27,
      28,    -1,    30,    31,    -1,    -1,    -1,    35,    36,    37,
      38,    -1,    -1,    -1,    42,    43,    -1,    -1,    46,    -1,
      48,    -1,    -1,    51,    52,    53,    54,    -1,    56,    -1,
      58,     5,     6,     7,     8,    -1,    64,    -1,    66,    -1,
      -1,    -1,    -1,    -1,    -1,    73,    -1,    -1,    -1,    77,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,     6,
       7,    -1,    90,    91,    38,    -1,    -1,    95,    -1,    -1,
      98,    -1,    -1,    -1,    -1,   103,   104,   105,    -1,   107,
      -1,   109,    -1,   111,    -1,    -1,   114,    -1,   116,   117,
     118,    65,    -1,    -1,   122,    -1,    43,    -1,    -1,    46,
      -1,    -1,    -1,    -1,    78,    52,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      94,    95,    -1,    97,    -1,    -1,    -1,    -1,    -1,   103,
      -1,    -1,    79,    -1,    -1,    -1,    -1,   111,   112,   113,
     114,    -1,    -1,   117,   118,   119,    -1,   121,    95,    12,
      97,    14,    -1,    -1,    38,    -1,   103,    -1,    21,   106,
      -1,    24,    25,    26,   111,   112,   113,    -1,    -1,    -1,
      -1,   118,    -1,    -1,    12,    -1,    14,    -1,    41,    -1,
      43,    -1,    45,    21,    -1,    48,    24,    25,    26,    -1,
      -1,    -1,    55,    56,    57,    79,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    41,    -1,    43,    -1,    45,    92,    93,
      48,    -1,    -1,    -1,    98,    -1,    -1,    55,    56,    -1,
      -1,   105,   106,   107,   108,    -1,   110,    -1,    -1,    -1,
     114,   115,   116,   117,    97,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   111,   112,
     113,   114,    -1,    -1,   117,    -1,    -1,    -1,    -1,    97,
     123,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   111,   112,   113,   114,    -1,    -1,   117,
      -1,    -1,    -1,    -1,    -1,   123,    15,    16,    17,    18,
      19,    20,    -1,    22,    -1,    -1,    -1,    -1,    27,    28,
      -1,    30,    31,    -1,    -1,    34,    35,    36,    37,    38,
      39,    40,    -1,    42,    43,    44,    -1,    46,    -1,    48,
      49,    -1,    51,    52,    53,    54,    -1,    56,    57,    58,
      -1,    -1,    -1,    -1,    -1,    64,    -1,    66,    -1,    -1,
      -1,    -1,    -1,    -1,    73,    -1,    -1,    -1,    77,    -1,
      79,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    90,    91,    -1,    -1,    -1,    -1,    96,    97,    -1,
      -1,    -1,    -1,    -1,   103,   104,   105,   106,   107,   108,
     109,   110,   111,   112,   113,   114,    -1,   116,   117,   118,
      -1,    15,    -1,   122,    18,    19,    20,    -1,    22,    -1,
      -1,    -1,    -1,    27,    28,    -1,    30,    31,    32,    -1,
      34,    35,    36,    37,    38,    -1,    40,    -1,    42,    43,
      44,    -1,    46,    -1,    48,    -1,    -1,    51,    52,    53,
      54,    -1,    56,    -1,    58,    -1,    -1,    -1,    -1,    -1,
      64,    -1,    66,    -1,    -1,    -1,    -1,    -1,    -1,    73,
      -1,    -1,    -1,    77,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    90,    91,    -1,    -1,
      -1,    -1,    -1,    97,    98,    -1,    -1,    -1,    -1,   103,
     104,   105,    -1,   107,    -1,   109,    -1,   111,   112,   113,
     114,    -1,   116,   117,    -1,    -1,    15,    -1,   122,    18,
      19,    20,    -1,    22,    -1,    -1,    -1,    -1,    27,    28,
      -1,    30,    31,    -1,    -1,    -1,    35,    36,    37,    38,
      -1,    -1,    -1,    42,    43,    -1,    -1,    46,    -1,    48,
      -1,    -1,    51,    52,    53,    54,    -1,    56,    -1,    58,
      -1,    -1,    -1,    -1,    -1,    64,    -1,    66,    -1,    -1,
      -1,    -1,    -1,    -1,    73,    -1,    -1,    -1,    77,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    90,    91,    -1,    -1,    -1,    -1,    -1,    -1,    98,
      -1,    -1,    -1,    -1,   103,   104,   105,    -1,   107,    15,
     109,    -1,    18,    19,    20,   114,    22,   116,   117,    -1,
      -1,    27,    28,   122,    30,    31,    -1,    -1,    -1,    35,
      36,    37,    -1,    -1,    -1,    -1,    42,    43,    -1,    -1,
      46,    -1,    48,    -1,    -1,    51,    52,    53,    54,    -1,
      56,    -1,    58,    19,    20,    -1,    -1,    -1,    64,    -1,
      66,    27,    28,    -1,    30,    31,    -1,    73,    -1,    35,
      36,    77,    -1,    -1,    15,    -1,    42,    -1,    19,    20,
      -1,    22,    -1,    -1,    90,    91,    27,    28,    -1,    30,
      31,    -1,    -1,    -1,    35,    36,    37,   103,   104,    -1,
      -1,    42,    -1,   109,    -1,    46,    -1,    -1,    -1,    -1,
      51,    -1,    53,    54,    -1,    -1,   122,    58,    -1,    -1,
      -1,    -1,    -1,    64,    -1,    66,    -1,    -1,    -1,    -1,
      -1,    97,    73,    -1,    -1,    -1,    77,    -1,   104,    -1,
      -1,    -1,    -1,    -1,    -1,   111,   112,   113,   114,    90,
      91,    -1,    -1,    -1,    -1,    -1,   122,    -1,    -1,    -1,
      -1,    -1,   103,   104,   105,    -1,   107,    15,   109,    -1,
      -1,    19,    20,    -1,    22,   116,    -1,    -1,    -1,    27,
      28,   122,    30,    31,    -1,    -1,    -1,    35,    36,    37,
      -1,    -1,    -1,    -1,    42,    -1,    -1,    -1,    46,    -1,
      -1,    -1,    -1,    51,    -1,    53,    -1,    -1,    -1,    -1,
      58,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    66,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   103,   104,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   122
};

/* YYSTOS[STATE-NUM] -- The symbol kind of the accessing symbol of
   state STATE-NUM.  */
static const yytype_int16 yystos[] =
{
       0,    87,   131,   133,   132,     0,     1,    15,    16,    17,
      19,    20,    22,    27,    28,    30,    31,    33,    34,    35,
      36,    37,    38,    39,    40,    42,    44,    46,    49,    51,
      53,    58,    66,    88,    97,   103,   104,   111,   112,   113,
     114,   117,   122,   134,   135,   137,   141,   146,   147,   148,
     149,   158,   161,   164,   170,   171,   172,   174,   178,   184,
     185,   186,   187,   195,   197,   199,   200,   201,   202,   220,
     224,   225,   226,   304,   306,   307,   308,     1,     5,     6,
       7,    18,    22,    33,    43,    46,    48,    52,    54,    56,
      57,    64,    71,    73,    76,    77,    78,    79,    90,    91,
      93,    94,    95,    96,    98,   103,   105,   106,   107,   108,
     109,   111,   112,   113,   114,   116,   117,   118,   135,   136,
     139,   141,   142,   143,   146,   151,   152,   153,   154,   158,
     161,   164,   170,   176,   179,   180,   181,   182,   183,   188,
     189,   200,   227,   239,   240,   245,   246,   247,   251,   253,
     254,   255,   256,   263,   264,   265,   270,   273,   274,   278,
     285,   286,   287,   288,   289,   299,   304,   306,   307,   308,
     309,   104,   178,   122,   122,   114,   117,   136,   243,   114,
     117,   136,   242,   243,   305,   114,   117,   136,   242,   122,
     178,   178,   243,   177,   121,    81,    85,    86,   208,   210,
     212,   216,   217,   212,   177,    32,   145,   121,   124,   122,
       1,   113,   123,   137,   149,   175,   306,   307,   180,   197,
     198,   199,   245,   285,    13,   196,   202,   192,   193,    49,
      50,    99,   100,   114,   117,   122,   139,   310,   311,   313,
     314,   316,   317,   319,   326,   327,   328,   330,   124,    79,
      79,   268,   268,   243,   122,   143,    79,   114,   117,   136,
     204,   205,   206,   207,   235,   236,   242,   205,   238,   204,
     237,    79,   114,   117,   136,   241,   273,   308,   237,   104,
     139,   190,   191,   248,   283,   271,   272,   274,   106,   275,
     272,   272,   275,    81,    85,   212,   214,    81,    85,   214,
       9,    10,   259,   261,   262,   259,   106,   272,    81,    85,
     214,   259,    79,   142,   268,    29,    43,    52,    95,   114,
     117,   118,   139,   181,   183,   254,   270,   274,   308,    82,
     272,   271,   272,   302,     6,     7,     8,    65,   114,   117,
     118,   119,   121,   139,   152,   220,   256,   257,   267,   269,
     306,   308,   277,   252,   252,   272,   252,    99,   324,   327,
      88,   159,    88,   162,   124,   221,   104,   222,   223,   124,
      99,   311,   313,   327,    79,   106,   139,   301,   165,   167,
     221,     1,    67,   181,   204,    85,   211,   216,   218,   219,
      81,    83,    83,   123,   122,   204,   228,    79,   114,   117,
     118,   139,   150,   151,   183,   207,   253,   285,   296,   297,
     298,   299,   300,   308,   154,   173,   183,   196,   192,    13,
     202,   189,   331,   315,    80,    81,    84,    86,   322,    80,
     322,   323,   318,   312,   101,   102,   314,   326,   328,   329,
     330,   150,   124,   157,    10,   121,   228,   124,     6,     7,
      43,    46,    52,    95,   103,   118,   153,   270,   301,   205,
     230,   231,   232,   124,   273,   124,   122,    65,    91,   104,
     139,   220,   249,   250,   254,   264,   265,   266,    72,    74,
      79,   114,   117,   128,   136,   279,   280,   282,   308,   252,
     121,   252,    81,    85,   215,   218,    81,   218,    81,     9,
      10,   218,    81,   236,   237,   177,   252,   288,   252,    59,
      60,    61,    63,   291,     8,   303,   324,   125,   254,   252,
      80,    81,   325,    29,    99,     1,   113,   123,   137,   160,
     161,   164,   169,   170,   200,   304,   308,     1,   113,   123,
     137,   163,   164,   169,   200,   304,   308,   242,   192,   202,
     242,   179,     1,   123,   139,   166,   168,   170,   179,   192,
      81,    83,    79,    93,    96,   110,   112,   113,   114,   117,
     118,   135,   138,   140,   141,   146,   154,   158,   161,   164,
     170,   183,   189,   253,   264,   265,   299,   304,   308,   309,
      82,    85,   208,   213,    92,   110,   115,   203,   209,   274,
     285,   288,   299,   110,   203,   209,   274,   285,   288,   299,
     144,   124,   106,    79,   118,   298,    10,   121,   252,   118,
     119,   125,   127,   222,   192,   122,   122,   323,   323,   323,
     323,   123,   313,   327,   329,   332,    82,   242,    12,    14,
      21,    24,    25,    26,    41,    43,    45,    48,    55,    56,
     123,   136,   139,   155,   156,   189,   229,   233,   234,   243,
     205,   205,   112,   118,   140,   153,   207,   240,   244,   285,
     300,   236,   242,   237,    81,    85,    81,    85,   111,   306,
     153,    82,   153,   244,   124,   295,   301,   194,   252,   302,
     280,    68,    69,    70,    75,   126,   127,   281,   215,   218,
      81,   153,    81,    85,   208,   214,   153,   208,   153,   208,
     124,   124,   264,   264,   290,   124,   129,   258,    79,    96,
     106,   136,   276,    80,   323,   325,   323,   325,   325,   145,
     145,   222,   185,   145,    85,   211,   219,   203,   209,   274,
     285,   299,    79,   106,   108,    81,    79,    93,   112,   114,
     117,   118,   140,   253,   264,   265,   299,   308,    23,   275,
      10,   121,   113,   123,   137,   149,   150,   228,   228,   297,
     297,   298,   298,   222,   165,   165,   104,   114,   122,   139,
     224,   320,   313,   311,   327,   332,   329,   230,   230,   243,
     200,   114,   117,   139,   124,   300,    10,   121,   124,   301,
     124,   218,    81,   218,    81,    81,    85,    99,   327,   110,
     203,   295,   118,   123,   155,   234,   303,    85,   211,   215,
     218,    81,   153,   153,   153,   118,    79,    89,   291,   292,
     293,   294,   259,   271,   323,    81,    79,    93,   106,   108,
     112,   114,   117,   118,   140,   253,   264,   265,   308,    23,
     213,    79,   106,   108,   277,   204,   204,   123,   123,   321,
     124,   244,   228,   228,    85,   208,   208,   218,    81,    81,
      99,    10,   121,   205,   301,   258,    81,   208,    62,   119,
     121,   259,   260,   219,    79,   106,   108,   252,   143,   244,
      81,   208,   323,   205,   205,   252,   294,    47,   284,   123,
     208,   252
};

/* YYR1[RULE-NUM] -- Symbol kind of the left-hand side of rule RULE-NUM.  */
static const yytype_int16 yyr1[] =
{
       0,   130,   131,   132,   131,   133,   133,   133,   133,   133,
     134,   134,   134,   134,   134,   134,   134,   134,   134,   134,
     134,   135,   135,   136,   136,   137,   137,   137,   138,   138,
     138,   138,   138,   138,   138,   138,   138,   138,   138,   138,
     138,   139,   139,   139,   140,   140,   140,   141,   142,   142,
     142,   143,   143,   143,   143,   143,   143,   143,   143,   144,
     144,   144,   144,   145,   147,   146,   148,   148,   149,   149,
     149,   150,   150,   150,   150,   150,   151,   151,   151,   151,
     151,   151,   151,   151,   151,   151,   151,   151,   151,   151,
     151,   152,   152,   152,   152,   152,   152,   152,   152,   152,
     153,   153,   153,   153,   153,   153,   153,   153,   153,   153,
     153,   153,   154,   155,   156,   155,   157,   157,   157,   157,
     158,   159,   159,   159,   159,   159,   159,   159,   159,   159,
     159,   160,   159,   159,   161,   162,   162,   162,   162,   162,
     162,   162,   162,   162,   163,   162,   162,   164,   165,   165,
     166,   166,   166,   167,   167,   168,   167,   169,   170,   171,
     171,   171,   172,   173,   173,   174,   174,   174,   174,   175,
     174,   174,   176,   176,   176,   177,   177,   177,   178,   179,
     179,   179,   180,   181,   181,   181,   181,   181,   182,   183,
     183,   184,   184,   185,   185,   186,   186,   186,   187,   187,
     188,   188,   188,   190,   189,   189,   191,   191,   192,   193,
     193,   194,   194,   194,   195,   195,   196,   196,   197,   197,
     197,   197,   197,   198,   198,   198,   199,   199,   199,   200,
     200,   200,   201,   201,   201,   202,   202,   203,   203,   203,
     204,   204,   204,   205,   205,   206,   206,   207,   207,   208,
     208,   208,   208,   208,   208,   208,   208,   208,   208,   208,
     208,   208,   208,   209,   210,   210,   210,   210,   210,   210,
     210,   210,   211,   211,   211,   211,   211,   211,   211,   211,
     211,   211,   211,   211,   211,   211,   211,   211,   211,   211,
     211,   211,   211,   212,   212,   213,   213,   214,   214,   214,
     214,   215,   215,   215,   215,   216,   216,   216,   216,   216,
     216,   216,   216,   216,   216,   216,   216,   217,   217,   217,
     217,   217,   217,   217,   217,   217,   217,   218,   218,   218,
     219,   219,   220,   221,   221,   223,   222,   222,   224,   224,
     225,   225,   225,   225,   225,   226,   226,   226,   226,   227,
     228,   229,   229,   229,   229,   230,   231,   232,   232,   232,
     232,   233,   233,   233,   233,   233,   233,   233,   233,   233,
     234,   234,   234,   234,   235,   236,   236,   237,   238,   239,
     239,   239,   239,   240,   240,   240,   241,   241,   241,   241,
     242,   242,   242,   243,   243,   243,   244,   244,   244,   244,
     244,   244,   244,   244,   245,   245,   245,   245,   245,   246,
     247,   247,   248,   248,   249,   249,   249,   249,   250,   250,
     250,   251,   252,   252,   253,   253,   253,   253,   253,   253,
     253,   253,   254,   254,   255,   256,   256,   256,   256,   257,
     257,   258,   258,   259,   259,   259,   260,   261,   261,   262,
     262,   263,   264,   265,   265,   266,   266,   267,   267,   267,
     267,   268,   269,   269,   269,   269,   269,   269,   269,   270,
     270,   270,   271,   271,   272,   273,   273,   274,   275,   275,
     276,   276,   277,   277,   277,   277,   278,   278,   279,   279,
     279,   279,   279,   280,   280,   280,   280,   280,   281,   281,
     281,   281,   282,   282,   283,   283,   284,   284,   285,   285,
     286,   286,   287,   287,   287,   287,   288,   289,   289,   290,
     290,   291,   291,   291,   291,   292,   292,   292,   293,   293,
     294,   294,   294,   295,   295,   296,   296,   296,   297,   297,
     297,   298,   298,   299,   299,   299,   300,   300,   300,   301,
     301,   301,   302,   302,   303,   303,   305,   304,   306,   307,
     308,   308,   309,   310,   310,   310,   312,   311,   313,   313,
     314,   314,   314,   315,   314,   316,   317,   318,   318,   318,
     319,   321,   320,   322,   322,   322,   322,   322,   322,   322,
     323,   323,   324,   324,   325,   325,   325,   325,   326,   327,
     327,   328,   328,   329,   329,   331,   330,   330,   330,   332,
     332
};

/* YYR2[RULE-NUM] -- Number of symbols on the right-hand side of rule RULE-NUM.  */
static const yytype_int8 yyr2[] =
{
       0,     2,     1,     0,     3,     0,     2,     2,     2,     2,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     3,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     2,     2,     1,
       2,     0,     1,     1,     1,     2,     3,     1,     2,     0,
       2,     2,     2,     4,     0,     2,     1,     1,     3,     5,
       3,     1,     1,     3,     3,     2,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       2,     2,     2,     2,     4,     4,     4,     5,     5,     5,
       1,     3,     3,     4,     4,     3,     4,     2,     3,     3,
       2,     1,     4,     1,     0,     2,     0,     2,     2,     2,
       4,     0,     1,     2,     2,     2,     2,     2,     2,     2,
       2,     0,     3,     2,     4,     0,     1,     2,     2,     2,
       2,     2,     2,     2,     0,     3,     2,     4,     1,     2,
       1,     1,     1,     0,     2,     0,     3,     1,     2,     1,
       1,     1,     1,     1,     1,     2,     2,     2,     2,     0,
       3,     2,     4,     5,     2,     0,     2,     2,     3,     1,
       1,     1,     1,     1,     1,     1,     3,     2,     1,     1,
       1,     4,     5,     2,     2,     1,     2,     1,     2,     3,
       1,     1,     1,     0,     5,     2,     1,     1,     1,     0,
       2,     0,     2,     2,     4,     4,     3,     4,     1,     1,
       1,     3,     5,     1,     1,     1,     3,     2,     2,     1,
       1,     2,     1,     1,     1,     1,     1,     1,     3,     3,
       1,     3,     3,     1,     1,     1,     1,     1,     1,     1,
       4,     5,     5,     5,     4,     4,     3,     3,     3,     3,
       3,     3,     3,     4,     4,     4,     4,     4,     4,     4,
       4,     4,     1,     4,     4,     4,     4,     4,     4,     4,
       4,     5,     5,     5,     4,     4,     4,     4,     3,     3,
       3,     3,     3,     1,     4,     1,     3,     2,     2,     3,
       3,     2,     2,     3,     3,     1,     3,     3,     3,     4,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     4,     4,     1,     4,     2,
       1,     3,     2,     0,     2,     0,     2,     1,     2,     3,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     4,
       1,     3,     2,     4,     2,     3,     1,     1,     5,     5,
       4,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     2,     2,     2,     1,     1,     2,     1,     1,     4,
       3,     4,     2,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       2,     1,     3,     3,     2,     3,     3,     1,     1,     3,
       3,     3,     0,     2,     5,     2,     1,     1,     1,     1,
       1,     2,     0,     2,     1,     2,     1,     1,     2,     2,
       2,     2,     1,     2,     1,     1,     1,     1,     1,     1,
       1,     0,     2,     0,     1,     1,     1,     1,     2,     1,
       2,     2,     2,     1,     2,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     0,     1,     1,     2,     2,     2,     0,     2,
       1,     1,     0,     3,     3,     3,     1,     2,     1,     1,
       1,     1,     1,     1,     1,     2,     2,     2,     1,     1,
       1,     1,     1,     2,     0,     2,     0,     1,     8,     2,
       2,     2,     1,     1,     1,     1,     3,     2,     4,     0,
       2,     1,     1,     2,     2,     1,     1,     1,     1,     3,
       1,     2,     2,     1,     3,     3,     3,     1,     1,     3,
       3,     2,     1,     1,     1,     2,     1,     1,     2,     1,
       1,     1,     0,     2,     0,     2,     0,     3,     1,     2,
       2,     1,     3,     1,     2,     1,     0,     3,     1,     1,
       1,     1,     2,     0,     5,     2,     3,     0,     2,     2,
       2,     0,     4,     3,     3,     3,     3,     3,     3,     1,
       1,     3,     2,     3,     2,     2,     2,     2,     3,     1,
       2,     1,     1,     1,     1,     0,     5,     2,     2,     2,
       1
};


enum { YYENOMEM = -2 };

#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = YYEMPTY)

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab
#define YYNOMEM         goto yyexhaustedlab


#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                    \
  do                                                              \
    if (yychar == YYEMPTY)                                        \
      {                                                           \
        yychar = (Token);                                         \
        yylval = (Value);                                         \
        YYPOPSTACK (yylen);                                       \
        yystate = *yyssp;                                         \
        goto yybackup;                                            \
      }                                                           \
    else                                                          \
      {                                                           \
        yyerror (&yylloc, parser, retval, YY_("syntax error: cannot back up")); \
        YYERROR;                                                  \
      }                                                           \
  while (0)

/* Backward compatibility with an undocumented macro.
   Use YYerror or YYUNDEF. */
#define YYERRCODE YYUNDEF

/* YYLLOC_DEFAULT -- Set CURRENT to span from RHS[1] to RHS[N].
   If N is 0, then set CURRENT to the empty location which ends
   the previous symbol: RHS[0] (always defined).  */

#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)                                \
    do                                                                  \
      if (N)                                                            \
        {                                                               \
          (Current).first_line   = YYRHSLOC (Rhs, 1).first_line;        \
          (Current).first_column = YYRHSLOC (Rhs, 1).first_column;      \
          (Current).last_line    = YYRHSLOC (Rhs, N).last_line;         \
          (Current).last_column  = YYRHSLOC (Rhs, N).last_column;       \
        }                                                               \
      else                                                              \
        {                                                               \
          (Current).first_line   = (Current).last_line   =              \
            YYRHSLOC (Rhs, 0).last_line;                                \
          (Current).first_column = (Current).last_column =              \
            YYRHSLOC (Rhs, 0).last_column;                              \
        }                                                               \
    while (0)
#endif

#define YYRHSLOC(Rhs, K) ((Rhs)[K])


/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)                        \
do {                                            \
  if (yydebug)                                  \
    YYFPRINTF Args;                             \
} while (0)


/* YYLOCATION_PRINT -- Print the location on the stream.
   This macro was not mandated originally: define only if we know
   we won't break user code: when these are the locations we know.  */

# ifndef YYLOCATION_PRINT

#  if defined YY_LOCATION_PRINT

   /* Temporary convenience wrapper in case some people defined the
      undocumented and private YY_LOCATION_PRINT macros.  */
#   define YYLOCATION_PRINT(File, Loc)  YY_LOCATION_PRINT(File, *(Loc))

#  elif defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL

/* Print *YYLOCP on YYO.  Private, do not rely on its existence. */

YY_ATTRIBUTE_UNUSED
static int
yy_location_print_ (FILE *yyo, YYLTYPE const * const yylocp)
{
  int res = 0;
  int end_col = 0 != yylocp->last_column ? yylocp->last_column - 1 : 0;
  if (0 <= yylocp->first_line)
    {
      res += YYFPRINTF (yyo, "%d", yylocp->first_line);
      if (0 <= yylocp->first_column)
        res += YYFPRINTF (yyo, ".%d", yylocp->first_column);
    }
  if (0 <= yylocp->last_line)
    {
      if (yylocp->first_line < yylocp->last_line)
        {
          res += YYFPRINTF (yyo, "-%d", yylocp->last_line);
          if (0 <= end_col)
            res += YYFPRINTF (yyo, ".%d", end_col);
        }
      else if (0 <= end_col && yylocp->first_column < end_col)
        res += YYFPRINTF (yyo, "-%d", end_col);
    }
  return res;
}

#   define YYLOCATION_PRINT  yy_location_print_

    /* Temporary convenience wrapper in case some people defined the
       undocumented and private YY_LOCATION_PRINT macros.  */
#   define YY_LOCATION_PRINT(File, Loc)  YYLOCATION_PRINT(File, &(Loc))

#  else

#   define YYLOCATION_PRINT(File, Loc) ((void) 0)
    /* Temporary convenience wrapper in case some people defined the
       undocumented and private YY_LOCATION_PRINT macros.  */
#   define YY_LOCATION_PRINT  YYLOCATION_PRINT

#  endif
# endif /* !defined YYLOCATION_PRINT */


# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)                    \
do {                                                                      \
  if (yydebug)                                                            \
    {                                                                     \
      YYFPRINTF (stderr, "%s ", Title);                                   \
      yy_symbol_print (stderr,                                            \
                  Kind, Value, Location, parser, retval); \
      YYFPRINTF (stderr, "\n");                                           \
    }                                                                     \
} while (0)


/*-----------------------------------.
| Print this symbol's value on YYO.  |
`-----------------------------------*/

static void
yy_symbol_value_print (FILE *yyo,
                       yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep, YYLTYPE const * const yylocationp, Lily_parser *parser, SCM *retval)
{
  FILE *yyoutput = yyo;
  YY_USE (yyoutput);
  YY_USE (yylocationp);
  YY_USE (parser);
  YY_USE (retval);
  if (!yyvaluep)
    return;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/*---------------------------.
| Print this symbol on YYO.  |
`---------------------------*/

static void
yy_symbol_print (FILE *yyo,
                 yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep, YYLTYPE const * const yylocationp, Lily_parser *parser, SCM *retval)
{
  YYFPRINTF (yyo, "%s %s (",
             yykind < YYNTOKENS ? "token" : "nterm", yysymbol_name (yykind));

  YYLOCATION_PRINT (yyo, yylocationp);
  YYFPRINTF (yyo, ": ");
  yy_symbol_value_print (yyo, yykind, yyvaluep, yylocationp, parser, retval);
  YYFPRINTF (yyo, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

static void
yy_stack_print (yy_state_t *yybottom, yy_state_t *yytop)
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)                            \
do {                                                            \
  if (yydebug)                                                  \
    yy_stack_print ((Bottom), (Top));                           \
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

static void
yy_reduce_print (yy_state_t *yyssp, YYSTYPE *yyvsp, YYLTYPE *yylsp,
                 int yyrule, Lily_parser *parser, SCM *retval)
{
  int yylno = yyrline[yyrule];
  int yynrhs = yyr2[yyrule];
  int yyi;
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %d):\n",
             yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr,
                       YY_ACCESSING_SYMBOL (+yyssp[yyi + 1 - yynrhs]),
                       &yyvsp[(yyi + 1) - (yynrhs)],
                       &(yylsp[(yyi + 1) - (yynrhs)]), parser, retval);
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)          \
do {                                    \
  if (yydebug)                          \
    yy_reduce_print (yyssp, yyvsp, yylsp, Rule, parser, retval); \
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args) ((void) 0)
# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif


/* Context of a parse error.  */
typedef struct
{
  yy_state_t *yyssp;
  yysymbol_kind_t yytoken;
  YYLTYPE *yylloc;
} yypcontext_t;

/* Put in YYARG at most YYARGN of the expected tokens given the
   current YYCTX, and return the number of tokens stored in YYARG.  If
   YYARG is null, return the number of expected tokens (guaranteed to
   be less than YYNTOKENS).  Return YYENOMEM on memory exhaustion.
   Return 0 if there are more than YYARGN expected tokens, yet fill
   YYARG up to YYARGN. */
static int
yypcontext_expected_tokens (const yypcontext_t *yyctx,
                            yysymbol_kind_t yyarg[], int yyargn)
{
  /* Actual size of YYARG. */
  int yycount = 0;
  int yyn = yypact[+*yyctx->yyssp];
  if (!yypact_value_is_default (yyn))
    {
      /* Start YYX at -YYN if negative to avoid negative indexes in
         YYCHECK.  In other words, skip the first -YYN actions for
         this state because they are default actions.  */
      int yyxbegin = yyn < 0 ? -yyn : 0;
      /* Stay within bounds of both yycheck and yytname.  */
      int yychecklim = YYLAST - yyn + 1;
      int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
      int yyx;
      for (yyx = yyxbegin; yyx < yyxend; ++yyx)
        if (yycheck[yyx + yyn] == yyx && yyx != YYSYMBOL_YYerror
            && !yytable_value_is_error (yytable[yyx + yyn]))
          {
            if (!yyarg)
              ++yycount;
            else if (yycount == yyargn)
              return 0;
            else
              yyarg[yycount++] = YY_CAST (yysymbol_kind_t, yyx);
          }
    }
  if (yyarg && yycount == 0 && 0 < yyargn)
    yyarg[0] = YYSYMBOL_YYEMPTY;
  return yycount;
}




#ifndef yystrlen
# if defined __GLIBC__ && defined _STRING_H
#  define yystrlen(S) (YY_CAST (YYPTRDIFF_T, strlen (S)))
# else
/* Return the length of YYSTR.  */
static YYPTRDIFF_T
yystrlen (const char *yystr)
{
  YYPTRDIFF_T yylen;
  for (yylen = 0; yystr[yylen]; yylen++)
    continue;
  return yylen;
}
# endif
#endif

#ifndef yystpcpy
# if defined __GLIBC__ && defined _STRING_H && defined _GNU_SOURCE
#  define yystpcpy stpcpy
# else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
yystpcpy (char *yydest, const char *yysrc)
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
# endif
#endif

#ifndef yytnamerr
/* Copy to YYRES the contents of YYSTR after stripping away unnecessary
   quotes and backslashes, so that it's suitable for yyerror.  The
   heuristic is that double-quoting is unnecessary unless the string
   contains an apostrophe, a comma, or backslash (other than
   backslash-backslash).  YYSTR is taken from yytname.  If YYRES is
   null, do not copy; instead, return the length of what the result
   would have been.  */
static YYPTRDIFF_T
yytnamerr (char *yyres, const char *yystr)
{
  if (*yystr == '"')
    {
      YYPTRDIFF_T yyn = 0;
      char const *yyp = yystr;
      for (;;)
        switch (*++yyp)
          {
          case '\'':
          case ',':
            goto do_not_strip_quotes;

          case '\\':
            if (*++yyp != '\\')
              goto do_not_strip_quotes;
            else
              goto append;

          append:
          default:
            if (yyres)
              yyres[yyn] = *yyp;
            yyn++;
            break;

          case '"':
            if (yyres)
              yyres[yyn] = '\0';
            return yyn;
          }
    do_not_strip_quotes: ;
    }

  if (yyres)
    return yystpcpy (yyres, yystr) - yyres;
  else
    return yystrlen (yystr);
}
#endif


static int
yy_syntax_error_arguments (const yypcontext_t *yyctx,
                           yysymbol_kind_t yyarg[], int yyargn)
{
  /* Actual size of YYARG. */
  int yycount = 0;
  /* There are many possibilities here to consider:
     - If this state is a consistent state with a default action, then
       the only way this function was invoked is if the default action
       is an error action.  In that case, don't check for expected
       tokens because there are none.
     - The only way there can be no lookahead present (in yychar) is if
       this state is a consistent state with a default action.  Thus,
       detecting the absence of a lookahead is sufficient to determine
       that there is no unexpected or expected token to report.  In that
       case, just report a simple "syntax error".
     - Don't assume there isn't a lookahead just because this state is a
       consistent state with a default action.  There might have been a
       previous inconsistent state, consistent state with a non-default
       action, or user semantic action that manipulated yychar.
     - Of course, the expected token list depends on states to have
       correct lookahead information, and it depends on the parser not
       to perform extra reductions after fetching a lookahead from the
       scanner and before detecting a syntax error.  Thus, state merging
       (from LALR or IELR) and default reductions corrupt the expected
       token list.  However, the list is correct for canonical LR with
       one exception: it will still contain any token that will not be
       accepted due to an error action in a later state.
  */
  if (yyctx->yytoken != YYSYMBOL_YYEMPTY)
    {
      int yyn;
      if (yyarg)
        yyarg[yycount] = yyctx->yytoken;
      ++yycount;
      yyn = yypcontext_expected_tokens (yyctx,
                                        yyarg ? yyarg + 1 : yyarg, yyargn - 1);
      if (yyn == YYENOMEM)
        return YYENOMEM;
      else
        yycount += yyn;
    }
  return yycount;
}

/* Copy into *YYMSG, which is of size *YYMSG_ALLOC, an error message
   about the unexpected token YYTOKEN for the state stack whose top is
   YYSSP.

   Return 0 if *YYMSG was successfully written.  Return -1 if *YYMSG is
   not large enough to hold the message.  In that case, also set
   *YYMSG_ALLOC to the required number of bytes.  Return YYENOMEM if the
   required number of bytes is too large to store.  */
static int
yysyntax_error (YYPTRDIFF_T *yymsg_alloc, char **yymsg,
                const yypcontext_t *yyctx)
{
  enum { YYARGS_MAX = 5 };
  /* Internationalized format string. */
  const char *yyformat = YY_NULLPTR;
  /* Arguments of yyformat: reported tokens (one for the "unexpected",
     one per "expected"). */
  yysymbol_kind_t yyarg[YYARGS_MAX];
  /* Cumulated lengths of YYARG.  */
  YYPTRDIFF_T yysize = 0;

  /* Actual size of YYARG. */
  int yycount = yy_syntax_error_arguments (yyctx, yyarg, YYARGS_MAX);
  if (yycount == YYENOMEM)
    return YYENOMEM;

  switch (yycount)
    {
#define YYCASE_(N, S)                       \
      case N:                               \
        yyformat = S;                       \
        break
    default: /* Avoid compiler warnings. */
      YYCASE_(0, YY_("syntax error"));
      YYCASE_(1, YY_("syntax error, unexpected %s"));
      YYCASE_(2, YY_("syntax error, unexpected %s, expecting %s"));
      YYCASE_(3, YY_("syntax error, unexpected %s, expecting %s or %s"));
      YYCASE_(4, YY_("syntax error, unexpected %s, expecting %s or %s or %s"));
      YYCASE_(5, YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s"));
#undef YYCASE_
    }

  /* Compute error message size.  Don't count the "%s"s, but reserve
     room for the terminator.  */
  yysize = yystrlen (yyformat) - 2 * yycount + 1;
  {
    int yyi;
    for (yyi = 0; yyi < yycount; ++yyi)
      {
        YYPTRDIFF_T yysize1
          = yysize + yytnamerr (YY_NULLPTR, yytname[yyarg[yyi]]);
        if (yysize <= yysize1 && yysize1 <= YYSTACK_ALLOC_MAXIMUM)
          yysize = yysize1;
        else
          return YYENOMEM;
      }
  }

  if (*yymsg_alloc < yysize)
    {
      *yymsg_alloc = 2 * yysize;
      if (! (yysize <= *yymsg_alloc
             && *yymsg_alloc <= YYSTACK_ALLOC_MAXIMUM))
        *yymsg_alloc = YYSTACK_ALLOC_MAXIMUM;
      return -1;
    }

  /* Avoid sprintf, as that infringes on the user's name space.
     Don't have undefined behavior even if the translation
     produced a string with the wrong number of "%s"s.  */
  {
    char *yyp = *yymsg;
    int yyi = 0;
    while ((*yyp = *yyformat) != '\0')
      if (*yyp == '%' && yyformat[1] == 's' && yyi < yycount)
        {
          yyp += yytnamerr (yyp, yytname[yyarg[yyi++]]);
          yyformat += 2;
        }
      else
        {
          ++yyp;
          ++yyformat;
        }
  }
  return 0;
}


/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg,
            yysymbol_kind_t yykind, YYSTYPE *yyvaluep, YYLTYPE *yylocationp, Lily_parser *parser, SCM *retval)
{
  YY_USE (yyvaluep);
  YY_USE (yylocationp);
  YY_USE (parser);
  YY_USE (retval);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yykind, yyvaluep, yylocationp);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}






/*----------.
| yyparse.  |
`----------*/

int
yyparse (Lily_parser *parser, SCM *retval)
{
/* Lookahead token kind.  */
int yychar;


/* The semantic value of the lookahead symbol.  */
/* Default value used for initialization, for pacifying older GCCs
   or non-GCC compilers.  */
YY_INITIAL_VALUE (static YYSTYPE yyval_default;)
YYSTYPE yylval YY_INITIAL_VALUE (= yyval_default);

/* Location data for the lookahead symbol.  */
static YYLTYPE yyloc_default
# if defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL
  = { 1, 1, 1, 1 }
# endif
;
YYLTYPE yylloc = yyloc_default;

    /* Number of syntax errors so far.  */
    int yynerrs = 0;

    yy_state_fast_t yystate = 0;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus = 0;

    /* Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* Their size.  */
    YYPTRDIFF_T yystacksize = YYINITDEPTH;

    /* The state stack: array, bottom, top.  */
    yy_state_t yyssa[YYINITDEPTH];
    yy_state_t *yyss = yyssa;
    yy_state_t *yyssp = yyss;

    /* The semantic value stack: array, bottom, top.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs = yyvsa;
    YYSTYPE *yyvsp = yyvs;

    /* The location stack: array, bottom, top.  */
    YYLTYPE yylsa[YYINITDEPTH];
    YYLTYPE *yyls = yylsa;
    YYLTYPE *yylsp = yyls;

  int yyn;
  /* The return value of yyparse.  */
  int yyresult;
  /* Lookahead symbol kind.  */
  yysymbol_kind_t yytoken = YYSYMBOL_YYEMPTY;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;
  YYLTYPE yyloc;

  /* The locations where the error started and ended.  */
  YYLTYPE yyerror_range[3];

  /* Buffer for error messages, and its allocated size.  */
  char yymsgbuf[128];
  char *yymsg = yymsgbuf;
  YYPTRDIFF_T yymsg_alloc = sizeof yymsgbuf;

#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N), yylsp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yychar = YYEMPTY; /* Cause a token to be read.  */

  yylsp[0] = yylloc;
  goto yysetstate;


/*------------------------------------------------------------.
| yynewstate -- push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;


/*--------------------------------------------------------------------.
| yysetstate -- set current state (the top of the stack) to yystate.  |
`--------------------------------------------------------------------*/
yysetstate:
  YYDPRINTF ((stderr, "Entering state %d\n", yystate));
  YY_ASSERT (0 <= yystate && yystate < YYNSTATES);
  YY_IGNORE_USELESS_CAST_BEGIN
  *yyssp = YY_CAST (yy_state_t, yystate);
  YY_IGNORE_USELESS_CAST_END
  YY_STACK_PRINT (yyss, yyssp);

  if (yyss + yystacksize - 1 <= yyssp)
#if !defined yyoverflow && !defined YYSTACK_RELOCATE
    YYNOMEM;
#else
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYPTRDIFF_T yysize = yyssp - yyss + 1;

# if defined yyoverflow
      {
        /* Give user a chance to reallocate the stack.  Use copies of
           these so that the &'s don't force the real ones into
           memory.  */
        yy_state_t *yyss1 = yyss;
        YYSTYPE *yyvs1 = yyvs;
        YYLTYPE *yyls1 = yyls;

        /* Each stack pointer address is followed by the size of the
           data in use in that stack, in bytes.  This used to be a
           conditional around just the two extra args, but that might
           be undefined if yyoverflow is a macro.  */
        yyoverflow (YY_("memory exhausted"),
                    &yyss1, yysize * YYSIZEOF (*yyssp),
                    &yyvs1, yysize * YYSIZEOF (*yyvsp),
                    &yyls1, yysize * YYSIZEOF (*yylsp),
                    &yystacksize);
        yyss = yyss1;
        yyvs = yyvs1;
        yyls = yyls1;
      }
# else /* defined YYSTACK_RELOCATE */
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
        YYNOMEM;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
        yystacksize = YYMAXDEPTH;

      {
        yy_state_t *yyss1 = yyss;
        union yyalloc *yyptr =
          YY_CAST (union yyalloc *,
                   YYSTACK_ALLOC (YY_CAST (YYSIZE_T, YYSTACK_BYTES (yystacksize))));
        if (! yyptr)
          YYNOMEM;
        YYSTACK_RELOCATE (yyss_alloc, yyss);
        YYSTACK_RELOCATE (yyvs_alloc, yyvs);
        YYSTACK_RELOCATE (yyls_alloc, yyls);
#  undef YYSTACK_RELOCATE
        if (yyss1 != yyssa)
          YYSTACK_FREE (yyss1);
      }
# endif

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;
      yylsp = yyls + yysize - 1;

      YY_IGNORE_USELESS_CAST_BEGIN
      YYDPRINTF ((stderr, "Stack size increased to %ld\n",
                  YY_CAST (long, yystacksize)));
      YY_IGNORE_USELESS_CAST_END

      if (yyss + yystacksize - 1 <= yyssp)
        YYABORT;
    }
#endif /* !defined yyoverflow && !defined YYSTACK_RELOCATE */


  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;


/*-----------.
| yybackup.  |
`-----------*/
yybackup:
  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either empty, or end-of-input, or a valid lookahead.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token\n"));
      yychar = yylex (&yylval, &yylloc, parser);
    }

  if (yychar <= END_OF_FILE)
    {
      yychar = END_OF_FILE;
      yytoken = YYSYMBOL_YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else if (yychar == YYerror)
    {
      /* The scanner already issued an error message, process directly
         to error recovery.  But do not keep the error token as
         lookahead, it is too special and may lead us to an endless
         loop in error recovery. */
      yychar = YYUNDEF;
      yytoken = YYSYMBOL_YYerror;
      yyerror_range[1] = yylloc;
      goto yyerrlab1;
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);
  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END
  *++yylsp = yylloc;

  /* Discard the shifted token.  */
  yychar = YYEMPTY;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     '$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];

  /* Default location. */
  YYLLOC_DEFAULT (yyloc, (yylsp - yylen), yylen);
  yyerror_range[1] = yyloc;
  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
  case 3: /* $@1: %empty  */
#line 404 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                        {
		parser->lexer_->push_note_state ();
	}
#line 3506 "./out/parser.cc"
    break;

  case 4: /* start_symbol: "#{" $@1 embedded_lilypond  */
#line 406 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                            {
		parser->lexer_->pop_state ();
                *retval = yyvsp[0];
 	}
#line 3515 "./out/parser.cc"
    break;

  case 5: /* lilypond: %empty  */
#line 412 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                            { yyval = SCM_UNSPECIFIED; }
#line 3521 "./out/parser.cc"
    break;

  case 6: /* lilypond: lilypond toplevel_expression  */
#line 413 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                       {
	}
#line 3528 "./out/parser.cc"
    break;

  case 7: /* lilypond: lilypond assignment  */
#line 415 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                              {
	}
#line 3535 "./out/parser.cc"
    break;

  case 8: /* lilypond: lilypond error  */
#line 417 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                         {
		parser->error_level_ = 1;
	}
#line 3543 "./out/parser.cc"
    break;

  case 9: /* lilypond: lilypond "\\version-error"  */
#line 420 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                {
		parser->error_level_ = 1;
	}
#line 3551 "./out/parser.cc"
    break;

  case 10: /* toplevel_expression: header_block  */
#line 427 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                     {
		parser->lexer_->set_identifier (ly_symbol2scm ("$defaultheader"), yyvsp[0]);
	}
#line 3559 "./out/parser.cc"
    break;

  case 11: /* toplevel_expression: book_block  */
#line 430 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                     {
		SCM proc = parser->lexer_->lookup_identifier ("toplevel-book-handler");
		ly_call (proc, yyvsp[0]);
	}
#line 3568 "./out/parser.cc"
    break;

  case 12: /* toplevel_expression: bookpart_block  */
#line 434 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                         {
		SCM proc = parser->lexer_->lookup_identifier ("toplevel-bookpart-handler");
		ly_call (proc, yyvsp[0]);
	}
#line 3577 "./out/parser.cc"
    break;

  case 13: /* toplevel_expression: BOOK_IDENTIFIER  */
#line 438 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                          {
		SCM sym = unsmob<Book>(yyvsp[0])->paper_
			? ly_symbol2scm ("toplevel-book-handler")
			: ly_symbol2scm ("toplevel-bookpart-handler");

		SCM proc = parser->lexer_->lookup_identifier_symbol (sym);
		ly_call (proc, yyvsp[0]);
	}
#line 3590 "./out/parser.cc"
    break;

  case 14: /* toplevel_expression: score_block  */
#line 446 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                      {
		SCM proc = parser->lexer_->lookup_identifier ("toplevel-score-handler");
		ly_call (proc, yyvsp[0]);
	}
#line 3599 "./out/parser.cc"
    break;

  case 15: /* toplevel_expression: composite_music  */
#line 450 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                          {
		SCM proc = parser->lexer_->lookup_identifier ("toplevel-music-handler");
		ly_call (proc, yyvsp[0]);
	}
#line 3608 "./out/parser.cc"
    break;

  case 16: /* toplevel_expression: full_markup  */
#line 454 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                      {
		SCM proc = parser->lexer_->lookup_identifier ("toplevel-text-handler");
		ly_call (proc, ly_list (yyvsp[0]));
	}
#line 3617 "./out/parser.cc"
    break;

  case 17: /* toplevel_expression: full_markup_list  */
#line 458 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                           {
		SCM proc = parser->lexer_->lookup_identifier ("toplevel-text-handler");
		ly_call (proc, yyvsp[0]);
	}
#line 3626 "./out/parser.cc"
    break;

  case 18: /* toplevel_expression: SCM_TOKEN  */
#line 462 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                    {
		// Evaluate and ignore #xxx, as opposed to \xxx
		parser->lexer_->eval_scm_token (yyvsp[0], (yylsp[0]));
	}
#line 3635 "./out/parser.cc"
    break;

  case 19: /* toplevel_expression: embedded_scm_active  */
#line 467 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		SCM out = SCM_UNDEFINED;
		if (Text_interface::is_markup (yyvsp[0]))
			out = ly_list (yyvsp[0]);
		else if (Text_interface::is_markup_list (yyvsp[0]))
			out = yyvsp[0];
		if (scm_is_pair (out))
		{
			SCM proc = parser->lexer_->lookup_identifier ("toplevel-text-handler");
			ly_call (proc, out);
		} else if (unsmob<Score> (yyvsp[0]))
		{
			SCM proc = parser->lexer_->lookup_identifier ("toplevel-score-handler");
			ly_call (proc, yyvsp[0]);
		} else if (Output_def * od = unsmob<Output_def> (yyvsp[0])) {
			SCM id = SCM_EOL;
			SCM kind = od->c_variable ("output-def-kind");
			if (scm_is_eq (kind, ly_symbol2scm ("paper")))
				id = ly_symbol2scm ("$defaultpaper");
			else if (scm_is_eq (kind, ly_symbol2scm ("midi")))
				id = ly_symbol2scm ("$defaultmidi");
			else if (scm_is_eq (kind, ly_symbol2scm ("layout")))
				id = ly_symbol2scm ("$defaultlayout");

			parser->lexer_->set_identifier (id, yyvsp[0]);
		} else if (ly_is_module (yyvsp[0]))
		{
			SCM module = get_header (parser);
			ly_module_copy (module, yyvsp[0]);
			parser->lexer_->set_identifier
				(ly_symbol2scm ("$defaultheader"), module);
		} else if (!scm_is_eq (yyvsp[0], SCM_UNSPECIFIED))
			parser->parser_error ((yylsp[0]), _("bad expression type"));
	}
#line 3674 "./out/parser.cc"
    break;

  case 20: /* toplevel_expression: output_def  */
#line 501 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                     {
		SCM id = SCM_EOL;
		Output_def * od = unsmob<Output_def> (yyvsp[0]);
		SCM kind = od->c_variable ("output-def-kind");
		if (scm_is_eq (kind, ly_symbol2scm ("paper")))
			id = ly_symbol2scm ("$defaultpaper");
		else if (scm_is_eq (kind, ly_symbol2scm ("midi")))
			id = ly_symbol2scm ("$defaultmidi");
		else if (scm_is_eq (kind, ly_symbol2scm ("layout")))
			id = ly_symbol2scm ("$defaultlayout");

		parser->lexer_->set_identifier (id, yyvsp[0]);
	}
#line 3692 "./out/parser.cc"
    break;

  case 22: /* lookup: LOOKUP_IDENTIFIER '.' symbol_list_rev  */
#line 519 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = loc_on_copy (parser, (yyloc),
				  nested_property (yyvsp[-2], scm_reverse_x (yyvsp[0], SCM_EOL)));
	}
#line 3701 "./out/parser.cc"
    break;

  case 23: /* embedded_scm_bare: SCM_TOKEN  */
#line 527 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = parser->lexer_->eval_scm_token (yyvsp[0], (yylsp[0]));
	}
#line 3709 "./out/parser.cc"
    break;

  case 29: /* embedded_scm_bare_arg: SCM_TOKEN  */
#line 542 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = parser->lexer_->eval_scm_token (yyvsp[0], (yylsp[0]));
	}
#line 3717 "./out/parser.cc"
    break;

  case 47: /* scm_function_call: SCM_FUNCTION function_arglist  */
#line 582 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                      {
		yyval = MAKE_SYNTAX (music_function, (yyloc),
				  yyvsp[-1], yyvsp[0]);
	}
#line 3726 "./out/parser.cc"
    break;

  case 48: /* embedded_lilypond_number: '-' embedded_lilypond_number  */
#line 590 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = scm_difference (yyvsp[0], SCM_UNDEFINED);
	}
#line 3734 "./out/parser.cc"
    break;

  case 50: /* embedded_lilypond_number: UNSIGNED NUMBER_IDENTIFIER  */
#line 595 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = scm_product (yyvsp[-1], yyvsp[0]);
	}
#line 3742 "./out/parser.cc"
    break;

  case 51: /* embedded_lilypond: %empty  */
#line 602 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		// FIXME: @$ does not contain a useful source location
		// for empty rules, and the only token in the whole
		// production, EMBEDDED_LILY, is synthetic and also
		// contains no source location.
		yyval = MAKE_SYNTAX (void_music, (yyloc));
	}
#line 3754 "./out/parser.cc"
    break;

  case 54: /* embedded_lilypond: post_event  */
#line 612 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		if (!unsmob<Music> (yyvsp[0]))
			yyval = MY_MAKE_MUSIC ("PostEvents", (yyloc))->unprotect ();
	}
#line 3763 "./out/parser.cc"
    break;

  case 55: /* embedded_lilypond: duration post_events  */
#line 617 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		if (scm_is_pair (yyvsp[0])) {
			Music *n = MY_MAKE_MUSIC ("NoteEvent", (yyloc));

			parser->default_duration_ = *unsmob<Duration> (yyvsp[-1]);
			set_property (n, "duration", yyvsp[-1]);
			set_property (n, "articulations",
					 scm_reverse_x (yyvsp[0], SCM_EOL));
			yyval = n->unprotect ();
		}
	}
#line 3779 "./out/parser.cc"
    break;

  case 56: /* embedded_lilypond: music_embedded music_embedded music_list  */
#line 628 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                                   {
		SCM tail = SCM_EOL;
		if (unsmob<Music> (yyvsp[-2]))
			tail = scm_cons (yyvsp[-2], tail);
		if (unsmob<Music> (yyvsp[-1]))
			tail = scm_cons (yyvsp[-1], tail);
		yyval = reverse_music_list (parser, (yyloc),
					 scm_append_x (ly_list (yyvsp[0], tail)),
					 true, true);
		if (scm_is_pair (yyval)) // unpackaged list
			if (scm_is_null (scm_cdr (yyval)))
				yyval = scm_car (yyval); // single expression
			else
				yyval = MAKE_SYNTAX (sequential_music, (yyloc), yyval);
		else if (scm_is_null (yyval))
			yyval = MAKE_SYNTAX (void_music, (yyloc));
		// else already packaged post-event
	}
#line 3802 "./out/parser.cc"
    break;

  case 57: /* embedded_lilypond: error  */
#line 646 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                {
		parser->error_level_ = 1;
                yyval = SCM_UNSPECIFIED;
	}
#line 3811 "./out/parser.cc"
    break;

  case 58: /* embedded_lilypond: "\\version-error" embedded_lilypond  */
#line 650 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                    {
		parser->error_level_ = 1;
                yyval = yyvsp[0];
	}
#line 3820 "./out/parser.cc"
    break;

  case 59: /* lilypond_header_body: %empty  */
#line 658 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                    { yyval = SCM_UNSPECIFIED; }
#line 3826 "./out/parser.cc"
    break;

  case 60: /* lilypond_header_body: lilypond_header_body assignment  */
#line 659 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                           {

	}
#line 3834 "./out/parser.cc"
    break;

  case 61: /* lilypond_header_body: lilypond_header_body SCM_TOKEN  */
#line 662 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                         {
		// Evaluate and ignore #xxx, as opposed to \xxx
		parser->lexer_->eval_scm_token (yyvsp[0], (yylsp[0]));
	}
#line 3843 "./out/parser.cc"
    break;

  case 62: /* lilypond_header_body: lilypond_header_body embedded_scm_active  */
#line 666 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                                   {
		if (ly_is_module (yyvsp[0]))
			ly_module_copy (scm_current_module (), yyvsp[0]);
		else if (!scm_is_eq (yyvsp[0], SCM_UNSPECIFIED))
			parser->parser_error ((yylsp[0]), _("bad expression type"));
	}
#line 3854 "./out/parser.cc"
    break;

  case 63: /* lilypond_header: "\\header" '{' lilypond_header_body '}'  */
#line 675 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                                {
		yyval = parser->lexer_->remove_scope ();
	}
#line 3862 "./out/parser.cc"
    break;

  case 64: /* $@2: %empty  */
#line 681 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		parser->lexer_->add_scope (get_header (parser));
	}
#line 3870 "./out/parser.cc"
    break;

  case 65: /* header_block: $@2 lilypond_header  */
#line 683 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                          {
		yyval = yyvsp[0];
	}
#line 3878 "./out/parser.cc"
    break;

  case 66: /* assignment_id: STRING  */
#line 693 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = scm_string_to_symbol (yyvsp[0]);
	}
#line 3886 "./out/parser.cc"
    break;

  case 67: /* assignment_id: SYMBOL  */
#line 697 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = scm_string_to_symbol (yyvsp[0]);
	}
#line 3894 "./out/parser.cc"
    break;

  case 68: /* assignment: assignment_id '=' identifier_init  */
#line 703 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                           {
	        parser->lexer_->set_identifier (yyvsp[-2], yyvsp[0]);
                yyval = SCM_UNSPECIFIED;
	}
#line 3903 "./out/parser.cc"
    break;

  case 69: /* assignment: assignment_id '.' property_path '=' identifier_init  */
#line 707 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                                              {
		SCM path = scm_cons (yyvsp[-4], yyvsp[-2]);
		parser->lexer_->set_identifier (path, yyvsp[0]);
                yyval = SCM_UNSPECIFIED;
	}
#line 3913 "./out/parser.cc"
    break;

  case 70: /* assignment: markup_mode_word '=' identifier_init  */
#line 713 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		if (scm_is_false (Lily::markup_function_p (yyvsp[0])))
		{
			parser->parser_error ((yylsp[0]), _ ("Not a markup function"));
		} else {
			Lily::define_markup_command_internal
 				(scm_string_to_symbol (yyvsp[-2]), yyvsp[0], SCM_BOOL_F);
		}
		yyval = SCM_UNSPECIFIED;
	}
#line 3928 "./out/parser.cc"
    break;

  case 73: /* identifier_init: symbol_list_part_bare '.' property_path  */
#line 730 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = scm_reverse_x (yyvsp[-2], yyvsp[0]);
	}
#line 3936 "./out/parser.cc"
    break;

  case 74: /* identifier_init: symbol_list_part_bare ',' property_path  */
#line 734 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = scm_reverse_x (yyvsp[-2], yyvsp[0]);
	}
#line 3944 "./out/parser.cc"
    break;

  case 75: /* identifier_init: post_event_nofinger post_events  */
#line 738 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = post_event_cons (yyvsp[-1], scm_reverse_x (yyvsp[0], SCM_EOL));
		if (scm_is_pair (yyval)
		    && scm_is_null (scm_cdr (yyval)))
			yyval = scm_car (yyval);
		else
		{
			Music * m = MY_MAKE_MUSIC ("PostEvents", (yyloc));
			set_property (m, "elements", yyval);
			yyval = m->unprotect ();
		}
	}
#line 3961 "./out/parser.cc"
    break;

  case 90: /* identifier_init_nonumber: partial_function "\\etc"  */
#line 768 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = MAKE_SYNTAX (partial_music_function, (yyloc),
				  scm_reverse_x (yyvsp[-1], SCM_EOL));
	}
#line 3970 "./out/parser.cc"
    break;

  case 91: /* partial_function_scriptable: MUSIC_FUNCTION function_arglist_partial  */
#line 778 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = scm_acons (yyvsp[-1], yyvsp[0], SCM_EOL);
	}
#line 3978 "./out/parser.cc"
    break;

  case 92: /* partial_function_scriptable: EVENT_FUNCTION function_arglist_partial  */
#line 782 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = scm_acons (yyvsp[-1], yyvsp[0], SCM_EOL);
	}
#line 3986 "./out/parser.cc"
    break;

  case 93: /* partial_function_scriptable: SCM_FUNCTION function_arglist_partial  */
#line 786 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = scm_acons (yyvsp[-1], yyvsp[0], SCM_EOL);
	}
#line 3994 "./out/parser.cc"
    break;

  case 94: /* partial_function_scriptable: MUSIC_FUNCTION "scheme?" function_arglist_optional partial_function  */
#line 790 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = scm_acons (yyvsp[-3], yyvsp[-1], yyvsp[0]);
	}
#line 4002 "./out/parser.cc"
    break;

  case 95: /* partial_function_scriptable: EVENT_FUNCTION "scheme?" function_arglist_optional partial_function  */
#line 794 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = scm_acons (yyvsp[-3], yyvsp[-1], yyvsp[0]);
	}
#line 4010 "./out/parser.cc"
    break;

  case 96: /* partial_function_scriptable: SCM_FUNCTION "scheme?" function_arglist_optional partial_function  */
#line 798 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = scm_acons (yyvsp[-3], yyvsp[-1], yyvsp[0]);
	}
#line 4018 "./out/parser.cc"
    break;

  case 97: /* partial_function_scriptable: MUSIC_FUNCTION "optional?" "scheme?" function_arglist_nonbackup partial_function  */
#line 802 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = scm_acons (yyvsp[-4], yyvsp[-1], yyvsp[0]);
	}
#line 4026 "./out/parser.cc"
    break;

  case 98: /* partial_function_scriptable: EVENT_FUNCTION "optional?" "scheme?" function_arglist_nonbackup partial_function  */
#line 806 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = scm_acons (yyvsp[-4], yyvsp[-1], yyvsp[0]);
	}
#line 4034 "./out/parser.cc"
    break;

  case 99: /* partial_function_scriptable: SCM_FUNCTION "optional?" "scheme?" function_arglist_nonbackup partial_function  */
#line 810 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = scm_acons (yyvsp[-4], yyvsp[-1], yyvsp[0]);
	}
#line 4042 "./out/parser.cc"
    break;

  case 101: /* partial_function: "\\override" grob_prop_path '='  */
#line 818 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		if (SCM_UNBNDP (yyvsp[-1]))
			yyval = ly_list (SCM_BOOL_F);
		else
			yyval = scm_cons
				(ly_list (Syntax::property_override,
			                  scm_cdr (yyvsp[-1]), scm_car (yyvsp[-1])),
				 SCM_EOL);
	}
#line 4056 "./out/parser.cc"
    break;

  case 102: /* partial_function: "\\set" context_prop_spec '='  */
#line 828 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		if (SCM_UNBNDP (yyvsp[-1]))
			yyval = ly_list (SCM_BOOL_F);
		else
			yyval = scm_cons
				(ly_list (Syntax::property_set,
				          scm_cadr (yyvsp[-1]), scm_car (yyvsp[-1])),
				 SCM_EOL);
	}
#line 4070 "./out/parser.cc"
    break;

  case 103: /* partial_function: "\\override" grob_prop_path '=' partial_function  */
#line 838 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		if (SCM_UNBNDP (yyvsp[-2]))
			yyval = ly_list (SCM_BOOL_F);
		else
			yyval = scm_cons
				(ly_list (Syntax::property_override,
			       	          scm_cdr (yyvsp[-2]), scm_car (yyvsp[-2])),
				 yyvsp[0]);
	}
#line 4084 "./out/parser.cc"
    break;

  case 104: /* partial_function: "\\set" context_prop_spec '=' partial_function  */
#line 848 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		if (SCM_UNBNDP (yyvsp[-2]))
			yyval = ly_list (SCM_BOOL_F);
		else
			yyval = scm_cons
				(ly_list (Syntax::property_set,
					  scm_cadr (yyvsp[-2]), scm_car (yyvsp[-2])),
				 yyvsp[0]);
	}
#line 4098 "./out/parser.cc"
    break;

  case 105: /* partial_function: "\\repeat" simple_string unsigned_number  */
#line 858 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = scm_cons (ly_list (Syntax::repeat, yyvsp[0], yyvsp[-1]), SCM_EOL);
	}
#line 4106 "./out/parser.cc"
    break;

  case 106: /* partial_function: "\\repeat" simple_string unsigned_number partial_function  */
#line 862 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = scm_cons (ly_list (Syntax::repeat, yyvsp[-1], yyvsp[-2]), yyvsp[0]);
	}
#line 4114 "./out/parser.cc"
    break;

  case 107: /* partial_function: "\\repeat" simple_string  */
#line 866 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = scm_cons (ly_list (Syntax::repeat, yyvsp[0]), SCM_EOL);
	}
#line 4122 "./out/parser.cc"
    break;

  case 108: /* partial_function: "\\repeat" simple_string partial_function  */
#line 870 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = scm_cons (ly_list (Syntax::repeat, yyvsp[-1]), yyvsp[0]);
	}
#line 4130 "./out/parser.cc"
    break;

  case 109: /* partial_function: script_dir markup_mode markup_partial_function  */
#line 875 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		if (SCM_UNBNDP (yyvsp[-2]))
			yyvsp[-2] = SCM_INUM0;
		yyvsp[0] = MAKE_SYNTAX (partial_markup, (yylsp[0]), yyvsp[0]);
		parser->lexer_->pop_state ();
// This relies on partial_function always being followed by ETC
		yyval = ly_list (ly_list (MAKE_SYNTAX (partial_text_script, (yyloc), yyvsp[0]),
				       yyvsp[0], yyvsp[-2]));
	}
#line 4144 "./out/parser.cc"
    break;

  case 110: /* partial_function: script_dir partial_function_scriptable  */
#line 885 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		if (SCM_UNBNDP (yyvsp[-1]))
			yyvsp[-1] = SCM_INUM0;
		yyval = scm_acons (Syntax::create_script_function, ly_list (yyvsp[-1]), yyvsp[0]);
	}
#line 4154 "./out/parser.cc"
    break;

  case 111: /* partial_function: script_dir  */
#line 891 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		if (SCM_UNBNDP (yyvsp[0]))
			yyvsp[0] = SCM_INUM0;
		yyval = scm_acons (Syntax::create_script_function, ly_list (yyvsp[0]), SCM_EOL);
	}
#line 4164 "./out/parser.cc"
    break;

  case 112: /* context_def_spec_block: "\\context" '{' context_def_spec_body '}'  */
#line 900 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = yyvsp[-1];
		Context_def *td = unsmob<Context_def> (yyval);
		if (!td) {
			yyval = Context_def::make_scm ();
			td = unsmob<Context_def> (yyval);
		}
		td->origin ()->set_spot ((yyloc));
	}
#line 4178 "./out/parser.cc"
    break;

  case 114: /* $@3: %empty  */
#line 914 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		parser->lexer_->push_note_state ();
	}
#line 4186 "./out/parser.cc"
    break;

  case 115: /* context_mod_arg: $@3 composite_music  */
#line 918 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		parser->lexer_->pop_state ();
		yyval = yyvsp[0];
	}
#line 4195 "./out/parser.cc"
    break;

  case 116: /* context_def_spec_body: %empty  */
#line 926 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
             {
		yyval = SCM_UNSPECIFIED;
	}
#line 4203 "./out/parser.cc"
    break;

  case 117: /* context_def_spec_body: context_def_spec_body context_mod  */
#line 929 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                            {
		if (!SCM_UNBNDP (yyvsp[0])) {
			Context_def *td = unsmob<Context_def> (yyval);
			if (!td) {
				yyval = Context_def::make_scm ();
				td = unsmob<Context_def> (yyval);
			}
			unsmob<Context_def> (yyval)->add_context_mod (yyvsp[0]);
		}
	}
#line 4218 "./out/parser.cc"
    break;

  case 118: /* context_def_spec_body: context_def_spec_body context_modification  */
#line 939 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                                     {
                Context_def *td = unsmob<Context_def> (yyval);
		if (!td) {
			yyval = Context_def::make_scm ();
			td = unsmob<Context_def> (yyval);
		}
                SCM new_mods = unsmob<Context_mod> (yyvsp[0])->get_mods ();
                for (SCM m = new_mods; scm_is_pair (m); m = scm_cdr (m)) {
                    td->add_context_mod (scm_car (m));
                }
	}
#line 4234 "./out/parser.cc"
    break;

  case 119: /* context_def_spec_body: context_def_spec_body context_mod_arg  */
#line 950 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                                {
		Context_def *td = unsmob<Context_def> (yyvsp[-1]);
		if (scm_is_eq (yyvsp[0], SCM_UNSPECIFIED))
			;
		else if (!td && unsmob<Context_def> (yyvsp[0]))
			yyval = yyvsp[0];
		else {
			if (!td) {
				yyval = Context_def::make_scm ();
				td = unsmob<Context_def> (yyval);
			}
			if (unsmob<Music> (yyvsp[0])) {
				SCM proc = parser->lexer_->lookup_identifier ("context-mod-music-handler");
				yyvsp[0] = ly_call (proc, yyvsp[0]);
			}
			if (Context_mod *cm = unsmob<Context_mod> (yyvsp[0])) {
				for (SCM m = cm->get_mods (); scm_is_pair (m); m = scm_cdr (m)) {
					td->add_context_mod (scm_car (m));
				}
			} else
				parser->parser_error ((yylsp[0]), _ ("not a context mod"));
		}
	}
#line 4262 "./out/parser.cc"
    break;

  case 120: /* book_block: "\\book" '{' book_body '}'  */
#line 978 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                {
		yyval = yyvsp[-1];
		unsmob<Book> (yyval)->origin ()->set_spot ((yyloc));
		pop_paper (parser);
		parser->lexer_->set_identifier (ly_symbol2scm ("$current-book"), SCM_BOOL_F);
	}
#line 4273 "./out/parser.cc"
    break;

  case 121: /* book_body: %empty  */
#line 990 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		Book *book = new Book;
		init_papers (parser);
		book->paper_ = unsmob<Output_def> (parser->lexer_->lookup_identifier ("$defaultpaper"))->clone ();
		book->paper_->unprotect ();
		push_paper (parser, book->paper_);
		book->header_ = get_header (parser);
                yyval = book->unprotect ();
		parser->lexer_->set_identifier (ly_symbol2scm ("$current-book"), yyval);
	}
#line 4288 "./out/parser.cc"
    break;

  case 122: /* book_body: BOOK_IDENTIFIER  */
#line 1000 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                          {
		parser->lexer_->set_identifier (ly_symbol2scm ("$current-book"), yyvsp[0]);
	}
#line 4296 "./out/parser.cc"
    break;

  case 123: /* book_body: book_body paper_block  */
#line 1003 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                {
		unsmob<Book> (yyvsp[-1])->paper_ = unsmob<Output_def> (yyvsp[0]);
		set_paper (parser, unsmob<Output_def> (yyvsp[0]));
	}
#line 4305 "./out/parser.cc"
    break;

  case 124: /* book_body: book_body bookpart_block  */
#line 1007 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                   {
		SCM proc = parser->lexer_->lookup_identifier ("book-bookpart-handler");
		ly_call (proc, yyvsp[-1], yyvsp[0]);
	}
#line 4314 "./out/parser.cc"
    break;

  case 125: /* book_body: book_body score_block  */
#line 1011 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                {
		SCM proc = parser->lexer_->lookup_identifier ("book-score-handler");
		ly_call (proc, yyvsp[-1], yyvsp[0]);
	}
#line 4323 "./out/parser.cc"
    break;

  case 126: /* book_body: book_body composite_music  */
#line 1015 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                    {
		SCM proc = parser->lexer_->lookup_identifier ("book-music-handler");
		ly_call (proc, yyvsp[-1], yyvsp[0]);
	}
#line 4332 "./out/parser.cc"
    break;

  case 127: /* book_body: book_body full_markup  */
#line 1019 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                {
		SCM proc = parser->lexer_->lookup_identifier ("book-text-handler");
		ly_call (proc, yyvsp[-1], ly_list (yyvsp[0]));
	}
#line 4341 "./out/parser.cc"
    break;

  case 128: /* book_body: book_body full_markup_list  */
#line 1023 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                     {
		SCM proc = parser->lexer_->lookup_identifier ("book-text-handler");
		ly_call (proc, yyvsp[-1], yyvsp[0]);
	}
#line 4350 "./out/parser.cc"
    break;

  case 129: /* book_body: book_body SCM_TOKEN  */
#line 1027 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                              {
		// Evaluate and ignore #xxx, as opposed to \xxx
		parser->lexer_->eval_scm_token (yyvsp[0], (yylsp[0]));
	}
#line 4359 "./out/parser.cc"
    break;

  case 130: /* book_body: book_body embedded_scm_active  */
#line 1032 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		SCM out = SCM_UNDEFINED;
		if (Text_interface::is_markup (yyvsp[0]))
			out = ly_list (yyvsp[0]);
		else if (Text_interface::is_markup_list (yyvsp[0]))
			out = yyvsp[0];
		if (scm_is_pair (out))
		{
			SCM proc = parser->lexer_->lookup_identifier ("book-text-handler");
			ly_call (proc, yyvsp[-1], out);
		} else if (unsmob<Score> (yyvsp[0]))
		{
			SCM proc = parser->lexer_->lookup_identifier ("book-score-handler");
			ly_call (proc, yyvsp[-1], yyvsp[0]);
		} else if (Output_def *od = unsmob<Output_def> (yyvsp[0])) {
			if (scm_is_eq (od->lookup_variable (ly_symbol2scm ("output-def-kind")),
				       ly_symbol2scm ("paper"))) {
				unsmob<Book> (yyvsp[-1])->paper_ = od;
				set_paper (parser, od);
			} else {
				parser->parser_error ((yylsp[0]), _ ("need \\paper for paper block"));
			}
		} else if (ly_is_module (yyvsp[0]))
		{
			ly_module_copy (unsmob<Book> (yyvsp[-1])->header_, yyvsp[0]);
		} else if (!scm_is_eq (yyvsp[0], SCM_UNSPECIFIED))
			parser->parser_error ((yylsp[0]), _("bad expression type"));
	}
#line 4392 "./out/parser.cc"
    break;

  case 131: /* $@4: %empty  */
#line 1061 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		parser->lexer_->add_scope (unsmob<Book> (yyvsp[0])->header_);
	}
#line 4400 "./out/parser.cc"
    break;

  case 133: /* book_body: book_body error  */
#line 1064 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                          {
                Book *book = unsmob<Book> (yyvsp[-1]);
		book->paper_ = 0;
		book->scores_ = SCM_EOL;
		book->bookparts_ = SCM_EOL;
	}
#line 4411 "./out/parser.cc"
    break;

  case 134: /* bookpart_block: "\\bookpart" '{' bookpart_body '}'  */
#line 1073 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                       {
		yyval = yyvsp[-1];
		unsmob<Book> (yyval)->origin ()->set_spot ((yyloc));
		parser->lexer_->set_identifier (ly_symbol2scm ("$current-bookpart"), SCM_BOOL_F);
	}
#line 4421 "./out/parser.cc"
    break;

  case 135: /* bookpart_body: %empty  */
#line 1081 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		Book *book = new Book;
                yyval = book->unprotect ();
		parser->lexer_->set_identifier (ly_symbol2scm ("$current-bookpart"), yyval);
	}
#line 4431 "./out/parser.cc"
    break;

  case 136: /* bookpart_body: BOOK_IDENTIFIER  */
#line 1086 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                          {
		parser->lexer_->set_identifier (ly_symbol2scm ("$current-bookpart"), yyvsp[0]);
	}
#line 4439 "./out/parser.cc"
    break;

  case 137: /* bookpart_body: bookpart_body paper_block  */
#line 1089 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                    {
		unsmob<Book> (yyval)->paper_ = unsmob<Output_def> (yyvsp[0]);
	}
#line 4447 "./out/parser.cc"
    break;

  case 138: /* bookpart_body: bookpart_body score_block  */
#line 1092 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                    {
		SCM proc = parser->lexer_->lookup_identifier ("bookpart-score-handler");
		ly_call (proc, yyvsp[-1], yyvsp[0]);
	}
#line 4456 "./out/parser.cc"
    break;

  case 139: /* bookpart_body: bookpart_body composite_music  */
#line 1096 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                        {
		SCM proc = parser->lexer_->lookup_identifier ("bookpart-music-handler");
		ly_call (proc, yyvsp[-1], yyvsp[0]);
	}
#line 4465 "./out/parser.cc"
    break;

  case 140: /* bookpart_body: bookpart_body full_markup  */
#line 1100 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                    {
		SCM proc = parser->lexer_->lookup_identifier ("bookpart-text-handler");
		ly_call (proc, yyvsp[-1], ly_list (yyvsp[0]));
	}
#line 4474 "./out/parser.cc"
    break;

  case 141: /* bookpart_body: bookpart_body full_markup_list  */
#line 1104 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                         {
		SCM proc = parser->lexer_->lookup_identifier ("bookpart-text-handler");
		ly_call (proc, yyvsp[-1], yyvsp[0]);
	}
#line 4483 "./out/parser.cc"
    break;

  case 142: /* bookpart_body: bookpart_body SCM_TOKEN  */
#line 1108 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                  {
		// Evaluate and ignore #xxx, as opposed to \xxx
		parser->lexer_->eval_scm_token (yyvsp[0], (yylsp[0]));
	}
#line 4492 "./out/parser.cc"
    break;

  case 143: /* bookpart_body: bookpart_body embedded_scm_active  */
#line 1113 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		SCM out = SCM_UNDEFINED;
		if (Text_interface::is_markup (yyvsp[0]))
			out = ly_list (yyvsp[0]);
		else if (Text_interface::is_markup_list (yyvsp[0]))
			out = yyvsp[0];
		if (scm_is_pair (out))
		{
			SCM proc = parser->lexer_->lookup_identifier ("bookpart-text-handler");
			ly_call (proc, yyvsp[-1], out);
		} else if (unsmob<Score> (yyvsp[0]))
		{
			SCM proc = parser->lexer_->lookup_identifier ("bookpart-score-handler");
			ly_call (proc, yyvsp[-1], yyvsp[0]);
		} else if (Output_def *od = unsmob<Output_def> (yyvsp[0])) {
			if (scm_is_eq (od->lookup_variable (ly_symbol2scm ("output-def-kind")),
				       ly_symbol2scm ("paper"))) {
				unsmob<Book> (yyvsp[-1])->paper_ = od;
			} else {
				parser->parser_error ((yylsp[0]), _ ("need \\paper for paper block"));
			}
		} else if (ly_is_module (yyvsp[0])) {
			Book *book = unsmob<Book> (yyvsp[-1]);
			if (!ly_is_module (book->header_))
				book->header_ = ly_make_module ();
			ly_module_copy (book->header_, yyvsp[0]);
		} else if (!scm_is_eq (yyvsp[0], SCM_UNSPECIFIED))
			parser->parser_error ((yylsp[0]), _("bad expression type"));
	}
#line 4526 "./out/parser.cc"
    break;

  case 144: /* $@5: %empty  */
#line 1143 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
                Book *book = unsmob<Book> (yyvsp[0]);
		if (!ly_is_module (book->header_))
			book->header_ = ly_make_module ();
		parser->lexer_->add_scope (book->header_);
	}
#line 4537 "./out/parser.cc"
    break;

  case 146: /* bookpart_body: bookpart_body error  */
#line 1149 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                              {
                Book *book = unsmob<Book> (yyvsp[-1]);
		book->paper_ = 0;
		book->scores_ = SCM_EOL;
	}
#line 4547 "./out/parser.cc"
    break;

  case 147: /* score_block: "\\score" '{' score_body '}'  */
#line 1157 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                        {
		unsmob<Score> (yyvsp[-1])->origin ()->set_spot ((yyloc));
		yyval = yyvsp[-1];
	}
#line 4556 "./out/parser.cc"
    break;

  case 148: /* score_body: score_items  */
#line 1164 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                    {
		if (!unsmob<Score> (yyvsp[0])) {
			parser->parser_error ((yylsp[0]), _("Missing music in \\score"));
			yyval = (new Score)->unprotect ();
			if (scm_is_pair (yyvsp[0]) && ly_is_module (scm_car (yyvsp[0])))
			{
				unsmob<Score> (yyval)->set_header (scm_car (yyvsp[0]));
				yyvsp[0] = scm_cdr (yyvsp[0]);
			}
			for (SCM p = scm_reverse_x (yyvsp[0], SCM_EOL);
			     scm_is_pair (p); p = scm_cdr (p))
			{
				unsmob<Score> (yyval)->
					add_output_def (unsmob<Output_def> (scm_car (p)));
			}
		}
	}
#line 4578 "./out/parser.cc"
    break;

  case 149: /* score_body: score_body error  */
#line 1181 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                           {
		unsmob<Score> (yyval)->error_found_ = true;
	}
#line 4586 "./out/parser.cc"
    break;

  case 153: /* score_items: %empty  */
#line 1194 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = SCM_EOL;
	}
#line 4594 "./out/parser.cc"
    break;

  case 154: /* score_items: score_items score_item  */
#line 1198 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		Output_def *od = unsmob<Output_def> (yyvsp[0]);
		if (od) {
			if (scm_is_eq (od->lookup_variable (ly_symbol2scm ("output-def-kind")),
				       ly_symbol2scm ("paper")))
			{
				parser->parser_error ((yylsp[0]), _("\\paper cannot be used in \\score, use \\layout instead"));
				od = 0;
				yyvsp[0] = SCM_UNSPECIFIED;
			}
		} else if (!unsmob<Score> (yyval)) {
			if (unsmob<Music> (yyvsp[0])) {
				yyvsp[0] = Lily::scorify_music (yyvsp[0]);
			}
			if (unsmob<Score> (yyvsp[0]))
			{
				yyval = yyvsp[0];
				yyvsp[0] = SCM_UNSPECIFIED;
			}
		}
		Score *score = unsmob<Score> (yyval);
		if (score && scm_is_pair (yyvsp[-1])) {
			if (ly_is_module (scm_car (yyvsp[-1])))
			{
				score->set_header (scm_car (yyvsp[-1]));
				yyvsp[-1] = scm_cdr (yyvsp[-1]);
			}
			for (SCM p = scm_reverse_x (yyvsp[-1], SCM_EOL);
			     scm_is_pair (p); p = scm_cdr (p))
			{
				score->add_output_def (unsmob<Output_def> (scm_car (p)));
			}
		}
		if (od) {
			if (score)
				score->add_output_def (od);
			else if (scm_is_pair (yyval) && ly_is_module (scm_car (yyval)))
				scm_set_cdr_x (yyval, scm_cons (yyvsp[0], scm_cdr (yyval)));
			else
				yyval = scm_cons (yyvsp[0], yyval);
		} else if (ly_is_module (yyvsp[0])) {
			SCM module = SCM_UNSPECIFIED;
			if (score) {
				module = score->get_header ();
				if (!ly_is_module (module))
				{
					module = ly_make_module ();
					score->set_header (module);
				}
			} else if (scm_is_pair (yyval) && ly_is_module (scm_car (yyval)))
				module = scm_car (yyval);
			else {
				module = ly_make_module ();
				yyval = scm_cons (module, yyval);
			}
			ly_module_copy (module, yyvsp[0]);
		} else if (!scm_is_eq (yyvsp[0], SCM_UNSPECIFIED))
			parser->parser_error ((yylsp[0]), _("Spurious expression in \\score"));
	}
#line 4658 "./out/parser.cc"
    break;

  case 155: /* $@6: %empty  */
#line 1258 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		if (Score *score = unsmob<Score> (yyvsp[0])) {
			if (!ly_is_module (score->get_header ()))
				score->set_header (ly_make_module ());
			parser->lexer_->add_scope (score->get_header ());
		} else {
			if (!scm_is_pair (yyvsp[0]) || !ly_is_module (scm_car (yyvsp[0])))
				yyvsp[0] = scm_cons (ly_make_module (), yyvsp[0]);
			parser->lexer_->add_scope (scm_car (yyvsp[0]));
		}
	}
#line 4674 "./out/parser.cc"
    break;

  case 156: /* score_items: score_items $@6 lilypond_header  */
#line 1269 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = yyvsp[-2];
	}
#line 4682 "./out/parser.cc"
    break;

  case 157: /* paper_block: output_def  */
#line 1280 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                   {
                Output_def *od = unsmob<Output_def> (yyvsp[0]);

		if (!scm_is_eq (od->lookup_variable (ly_symbol2scm ("output-def-kind")),
				ly_symbol2scm ("paper")))
		{
			parser->parser_error ((yylsp[0]), _ ("need \\paper for paper block"));
			yyval = get_paper (parser)->unprotect ();
		}
	}
#line 4697 "./out/parser.cc"
    break;

  case 158: /* output_def: output_def_body '}'  */
#line 1294 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                            {
		if (scm_is_pair (yyvsp[-1]))
			yyval = scm_car (yyvsp[-1]);

		parser->lexer_->remove_scope ();
		parser->lexer_->pop_state ();
	}
#line 4709 "./out/parser.cc"
    break;

  case 159: /* output_def_head: "\\paper"  */
#line 1304 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
              {
                Output_def *p = get_paper (parser);
		p->input_origin_ = (yyloc);
		parser->lexer_->add_scope (p->scope_);
                yyval = p->unprotect ();
	}
#line 4720 "./out/parser.cc"
    break;

  case 160: /* output_def_head: "\\midi"  */
#line 1310 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                  {
		Output_def *p = get_midi (parser);
		yyval = p->unprotect ();
		parser->lexer_->add_scope (p->scope_);
	}
#line 4730 "./out/parser.cc"
    break;

  case 161: /* output_def_head: "\\layout"  */
#line 1315 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                        {
		Output_def *p = get_layout (parser);

		parser->lexer_->add_scope (p->scope_);
		yyval = p->unprotect ();
	}
#line 4741 "./out/parser.cc"
    break;

  case 162: /* output_def_head_with_mode_switch: output_def_head  */
#line 1324 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                        {
		parser->lexer_->push_initial_state ();
		yyval = yyvsp[0];
	}
#line 4750 "./out/parser.cc"
    break;

  case 165: /* output_def_body: output_def_head_with_mode_switch '{'  */
#line 1341 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                             {
		unsmob<Output_def> (yyvsp[-1])->input_origin_.set_spot ((yyloc));
		// This is a stupid trick to mark the beginning of the
		// body for deciding whether to allow
		// embedded_scm_active to have an output definition
		yyval = ly_list (yyvsp[-1]);
	}
#line 4762 "./out/parser.cc"
    break;

  case 166: /* output_def_body: output_def_body assignment  */
#line 1348 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                      {
		if (scm_is_pair (yyvsp[-1]))
			yyval = scm_car (yyvsp[-1]);
	}
#line 4771 "./out/parser.cc"
    break;

  case 167: /* output_def_body: output_def_body embedded_scm_active  */
#line 1353 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		// We don't switch into note mode for Scheme functions
		// here.  Does not seem warranted/required in output
		// definitions.
		if (scm_is_pair (yyvsp[-1]))
		{
			Output_def *o = unsmob<Output_def> (yyvsp[0]);
			if (o) {
				o->input_origin_.set_spot ((yyloc));
				yyvsp[-1] = o->self_scm ();
				parser->lexer_->remove_scope ();
				parser->lexer_->add_scope (o->scope_);
				yyvsp[0] = SCM_UNSPECIFIED;
			} else
				yyvsp[-1] = scm_car (yyvsp[-1]);
		}
		if (unsmob<Context_def> (yyvsp[0]))
			assign_context_def (unsmob<Output_def> (yyvsp[-1]), yyvsp[0]);
		// Seems unlikely, but let's be complete:
		else if (unsmob<Music> (yyvsp[0]))
		{
			SCM proc = parser->lexer_->lookup_identifier ("output-def-music-handler");
			ly_call (proc, yyvsp[-1], yyvsp[0]);
		} else if (!scm_is_eq (yyvsp[0], SCM_UNSPECIFIED))
			parser->parser_error ((yylsp[0]), _("bad expression type"));
		yyval = yyvsp[-1];
	}
#line 4803 "./out/parser.cc"
    break;

  case 168: /* output_def_body: output_def_body SCM_TOKEN  */
#line 1380 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                    {
		if (scm_is_pair (yyvsp[-1]))
			yyval = scm_car (yyvsp[-1]);
		// Evaluate and ignore #xxx, as opposed to \xxx
		parser->lexer_->eval_scm_token (yyvsp[0], (yylsp[0]));
	}
#line 4814 "./out/parser.cc"
    break;

  case 169: /* $@7: %empty  */
#line 1387 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		if (scm_is_pair (yyvsp[0]))
			yyvsp[0] = scm_car (yyvsp[0]);
		parser->lexer_->push_note_state ();
	}
#line 4824 "./out/parser.cc"
    break;

  case 170: /* output_def_body: output_def_body $@7 music_or_context_def  */
#line 1392 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		parser->lexer_->pop_state ();
		if (unsmob<Context_def> (yyvsp[0]))
			assign_context_def (unsmob<Output_def> (yyvsp[-2]), yyvsp[0]);
		else {

			SCM proc = parser->lexer_->lookup_identifier ("output-def-music-handler");
			ly_call (proc, yyvsp[-2], yyvsp[0]);
		}
		yyval = yyvsp[-2];
	}
#line 4840 "./out/parser.cc"
    break;

  case 171: /* output_def_body: output_def_body error  */
#line 1403 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                {

	}
#line 4848 "./out/parser.cc"
    break;

  case 172: /* tempo_event: "\\tempo" steno_duration '=' tempo_range  */
#line 1409 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                                {
		yyval = MAKE_SYNTAX (tempo, (yyloc), SCM_EOL, yyvsp[-2], yyvsp[0]);
	}
#line 4856 "./out/parser.cc"
    break;

  case 173: /* tempo_event: "\\tempo" text steno_duration '=' tempo_range  */
#line 1412 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                                        {
		yyval = MAKE_SYNTAX (tempo, (yyloc), yyvsp[-3], yyvsp[-2], yyvsp[0]);
	}
#line 4864 "./out/parser.cc"
    break;

  case 174: /* tempo_event: "\\tempo" text  */
#line 1415 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                     {
		yyval = MAKE_SYNTAX (tempo, (yyloc), yyvsp[0]);
	}
#line 4872 "./out/parser.cc"
    break;

  case 175: /* music_list: %empty  */
#line 1424 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                    {
		yyval = SCM_EOL;
	}
#line 4880 "./out/parser.cc"
    break;

  case 176: /* music_list: music_list music_embedded  */
#line 1427 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                    {
		if (unsmob<Music> (yyvsp[0]))
			yyval = scm_cons (yyvsp[0], yyvsp[-1]);
	}
#line 4889 "./out/parser.cc"
    break;

  case 177: /* music_list: music_list error  */
#line 1431 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                           {
		Music *m = MY_MAKE_MUSIC("Music", (yyloc));
		// ugh. code dup
		set_property (m, "error-found", SCM_BOOL_T);
		yyval = scm_cons (m->self_scm (), yyvsp[-1]);
		m->unprotect (); /* UGH */
	}
#line 4901 "./out/parser.cc"
    break;

  case 178: /* braced_music_list: '{' music_list '}'  */
#line 1442 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = reverse_music_list (parser, (yyloc), yyvsp[-1], true, false);
	}
#line 4909 "./out/parser.cc"
    break;

  case 182: /* pitch_as_music: pitch_or_music  */
#line 1454 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
	        yyval = make_music_from_simple (parser, (yylsp[0]), yyvsp[0]);
                if (!unsmob<Music> (yyval))
		{
                        parser->parser_error ((yylsp[0]), _ ("music expected"));
			yyval = MAKE_SYNTAX (void_music, (yyloc));
		}
	}
#line 4922 "./out/parser.cc"
    break;

  case 185: /* music_embedded: music_embedded_backup  */
#line 1468 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = yyvsp[0];
	}
#line 4930 "./out/parser.cc"
    break;

  case 186: /* music_embedded: music_embedded_backup "(backed-up?)" lyric_element_music  */
#line 1472 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = yyvsp[0];
	}
#line 4938 "./out/parser.cc"
    break;

  case 187: /* music_embedded: duration post_events  */
#line 1476 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		Music *n = MY_MAKE_MUSIC ("NoteEvent", (yyloc));

		parser->default_duration_ = *unsmob<Duration> (yyvsp[-1]);
		set_property (n, "duration", yyvsp[-1]);

		if (scm_is_pair (yyvsp[0]))
			set_property (n, "articulations",
					 scm_reverse_x (yyvsp[0], SCM_EOL));
		yyval = n->unprotect ();
	}
#line 4954 "./out/parser.cc"
    break;

  case 188: /* music_embedded_backup: embedded_scm  */
#line 1491 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		if (scm_is_eq (yyvsp[0], SCM_UNSPECIFIED)
		    || unsmob<Music> (yyvsp[0]))
			yyval = yyvsp[0];
		else if (parser->lexer_->is_lyric_state ()
			   && Text_interface::is_markup (yyvsp[0]))
			MYBACKUP (LYRIC_ELEMENT, yyvsp[0], (yylsp[0]));
		else {
			(yyloc).warning (_ ("Ignoring non-music expression"));
			yyval = SCM_UNSPECIFIED;
		}
	}
#line 4971 "./out/parser.cc"
    break;

  case 191: /* repeated_music: "\\repeat" simple_string unsigned_number music  */
#line 1514 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = MAKE_SYNTAX (repeat, (yyloc), yyvsp[-2], yyvsp[-1], yyvsp[0]);
	}
#line 4979 "./out/parser.cc"
    break;

  case 192: /* repeated_music: "\\repeat" simple_string unsigned_number music sequential_alternative_music  */
#line 1518 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = MAKE_SYNTAX (repeat_alt, (yyloc), yyvsp[-3], yyvsp[-2], yyvsp[-1], yyvsp[0]);
	}
#line 4987 "./out/parser.cc"
    break;

  case 193: /* sequential_alternative_music: "\\alternative" braced_music_list  */
#line 1524 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                      {
		yyval = MAKE_SYNTAX (sequential_alternative_music, (yyloc), yyvsp[0]);
	}
#line 4995 "./out/parser.cc"
    break;

  case 194: /* sequential_alternative_music: "\\alternative" MUSIC_IDENTIFIER  */
#line 1528 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                     { yyval = yyvsp[0]; }
#line 5001 "./out/parser.cc"
    break;

  case 195: /* sequential_music: sequential_alternative_music  */
#line 1532 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                     {
		yyval = yyvsp[0];
	}
#line 5009 "./out/parser.cc"
    break;

  case 196: /* sequential_music: "\\sequential" braced_music_list  */
#line 1535 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                       {
		yyval = MAKE_SYNTAX (sequential_music, (yyloc), yyvsp[0]);
	}
#line 5017 "./out/parser.cc"
    break;

  case 197: /* sequential_music: braced_music_list  */
#line 1538 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                            {
		yyval = MAKE_SYNTAX (sequential_music, (yyloc), yyvsp[0]);
	}
#line 5025 "./out/parser.cc"
    break;

  case 198: /* simultaneous_music: "\\simultaneous" braced_music_list  */
#line 1544 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                       {
		yyval = MAKE_SYNTAX (simultaneous_music, (yyloc), yyvsp[0]);
	}
#line 5033 "./out/parser.cc"
    break;

  case 199: /* simultaneous_music: "<<" music_list ">>"  */
#line 1547 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                                                {
		yyval = MAKE_SYNTAX (simultaneous_music, (yyloc),
				  reverse_music_list (parser, (yyloc), yyvsp[-1],
						      true, false));
	}
#line 5043 "./out/parser.cc"
    break;

  case 203: /* $@8: %empty  */
#line 1562 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		parser->lexer_->push_note_state ();
	}
#line 5051 "./out/parser.cc"
    break;

  case 204: /* context_modification: "\\with" $@8 '{' context_mod_list '}'  */
#line 1565 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
                parser->lexer_->pop_state ();
                yyval = yyvsp[-1];
        }
#line 5060 "./out/parser.cc"
    break;

  case 205: /* context_modification: "\\with" context_modification_arg  */
#line 1570 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		if (unsmob<Music> (yyvsp[0])) {
			SCM proc = parser->lexer_->lookup_identifier ("context-mod-music-handler");
			yyvsp[0] = ly_call (proc, yyvsp[0]);
		}
		if (unsmob<Context_mod> (yyvsp[0]))
			yyval = yyvsp[0];
		else {
			// let's permit \with #*unspecified* to go for
			// an empty context mod
			if (!scm_is_eq (yyvsp[0], SCM_UNSPECIFIED))
				parser->parser_error ((yylsp[0]), _ ("not a context mod"));
			yyval = Context_mod ().smobbed_copy ();
		}
	}
#line 5080 "./out/parser.cc"
    break;

  case 208: /* optional_context_mods: context_modification_mods_list  */
#line 1598 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		if (scm_is_pair (yyvsp[0]))
			yyval = scm_append_x (scm_reverse_x (yyvsp[0], SCM_EOL));
        }
#line 5089 "./out/parser.cc"
    break;

  case 209: /* context_modification_mods_list: %empty  */
#line 1611 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
             {
		yyval = SCM_EOL;
	}
#line 5097 "./out/parser.cc"
    break;

  case 210: /* context_modification_mods_list: context_modification_mods_list context_modification  */
#line 1615 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		if (Context_mod *m = unsmob<Context_mod> (yyvsp[0]))
			yyval = scm_cons (m->get_mods (), yyvsp[-1]);
	}
#line 5106 "./out/parser.cc"
    break;

  case 211: /* context_mod_list: %empty  */
#line 1627 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
             {
            yyval = Context_mod ().smobbed_copy ();
        }
#line 5114 "./out/parser.cc"
    break;

  case 212: /* context_mod_list: context_mod_list context_mod  */
#line 1630 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                        {
		if (!SCM_UNBNDP (yyvsp[0]))
			unsmob<Context_mod> (yyvsp[-1])->add_context_mod (yyvsp[0]);
        }
#line 5123 "./out/parser.cc"
    break;

  case 213: /* context_mod_list: context_mod_list context_mod_arg  */
#line 1634 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                           {
		if (unsmob<Music> (yyvsp[0])) {
			SCM proc = parser->lexer_->lookup_identifier ("context-mod-music-handler");
			yyvsp[0] = ly_call (proc, yyvsp[0]);
		}
		if (unsmob<Context_mod> (yyvsp[0]))
			unsmob<Context_mod> (yyval)->add_context_mods
				(unsmob<Context_mod> (yyvsp[0])->get_mods ());
		else if (!scm_is_eq (yyvsp[0], SCM_UNSPECIFIED))
			parser->parser_error ((yylsp[0]), _ ("not a context mod"));
        }
#line 5139 "./out/parser.cc"
    break;

  case 214: /* context_prefix: "\\context" symbol optional_id optional_context_mods  */
#line 1648 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                                         {
		yyval = START_MAKE_SYNTAX (context_find_or_create, yyvsp[-2], yyvsp[-1], yyvsp[0]);
	}
#line 5147 "./out/parser.cc"
    break;

  case 215: /* context_prefix: "\\new" symbol optional_id optional_context_mods  */
#line 1651 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                                              {
		yyval = START_MAKE_SYNTAX (context_create, yyvsp[-2], yyvsp[-1], yyvsp[0]);
	}
#line 5155 "./out/parser.cc"
    break;

  case 216: /* new_lyrics: "\\addlyrics" optional_context_mods lyric_mode_music  */
#line 1657 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                                         {
		yyval = scm_acons (yyvsp[0], yyvsp[-1], SCM_EOL);
	}
#line 5163 "./out/parser.cc"
    break;

  case 217: /* new_lyrics: new_lyrics "\\addlyrics" optional_context_mods lyric_mode_music  */
#line 1660 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                                                      {
		yyval = scm_acons (yyvsp[0], yyvsp[-1], yyvsp[-3]);
	}
#line 5171 "./out/parser.cc"
    break;

  case 221: /* basic_music: "\\lyricsto" simple_string lyric_mode_music  */
#line 1685 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                                  {
		yyval = MAKE_SYNTAX (lyric_combine, (yyloc), yyvsp[-1], SCM_EOL, yyvsp[0]);
	}
#line 5179 "./out/parser.cc"
    break;

  case 222: /* basic_music: "\\lyricsto" symbol '=' simple_string lyric_mode_music  */
#line 1689 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = MAKE_SYNTAX (lyric_combine, (yyloc), yyvsp[-1], yyvsp[-3], yyvsp[0]);
	}
#line 5187 "./out/parser.cc"
    break;

  case 226: /* contexted_basic_music: context_prefix contextable_music new_lyrics  */
#line 1702 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		Input i;
		i.set_location ((yylsp[-2]), (yylsp[-1]));
		yyval = FINISH_MAKE_SYNTAX (yyvsp[-2], i, yyvsp[-1]);
		yyval = MAKE_SYNTAX (add_lyrics, (yyloc), yyval, scm_reverse_x (yyvsp[0], SCM_EOL));
	}
#line 5198 "./out/parser.cc"
    break;

  case 227: /* contexted_basic_music: context_prefix contextable_music  */
#line 1709 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = FINISH_MAKE_SYNTAX (yyvsp[-1], (yyloc), yyvsp[0]);
	}
#line 5206 "./out/parser.cc"
    break;

  case 228: /* contexted_basic_music: context_prefix contexted_basic_music  */
#line 1713 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = FINISH_MAKE_SYNTAX (yyvsp[-1], (yyloc), yyvsp[0]);
	}
#line 5214 "./out/parser.cc"
    break;

  case 231: /* composite_music: basic_music new_lyrics  */
#line 1722 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = MAKE_SYNTAX (add_lyrics, (yyloc), yyvsp[-1], scm_reverse_x (yyvsp[0], SCM_EOL));
	}
#line 5222 "./out/parser.cc"
    break;

  case 235: /* grouped_music_list: simultaneous_music  */
#line 1734 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                        { yyval = yyvsp[0]; }
#line 5228 "./out/parser.cc"
    break;

  case 236: /* grouped_music_list: sequential_music  */
#line 1735 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                        { yyval = yyvsp[0]; }
#line 5234 "./out/parser.cc"
    break;

  case 238: /* symbol_list_arg: SYMBOL_LIST '.' symbol_list_rev  */
#line 1794 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = ly_append (yyvsp[-2], scm_reverse_x (yyvsp[0], SCM_EOL));
	}
#line 5242 "./out/parser.cc"
    break;

  case 239: /* symbol_list_arg: SYMBOL_LIST ',' symbol_list_rev  */
#line 1798 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = ly_append (yyvsp[-2], scm_reverse_x (yyvsp[0], SCM_EOL));
	}
#line 5250 "./out/parser.cc"
    break;

  case 241: /* symbol_list_rev: symbol_list_rev '.' symbol_list_part  */
#line 1806 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = scm_append_x (ly_list (yyvsp[0], yyvsp[-2]));
	}
#line 5258 "./out/parser.cc"
    break;

  case 242: /* symbol_list_rev: symbol_list_rev ',' symbol_list_part  */
#line 1810 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = scm_append_x (ly_list (yyvsp[0], yyvsp[-2]));
	}
#line 5266 "./out/parser.cc"
    break;

  case 244: /* symbol_list_part: embedded_scm_bare  */
#line 1820 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = make_reverse_key_list (yyvsp[0]);
		if (SCM_UNBNDP (yyval)) {
			parser->parser_error ((yylsp[0]), _("not a key"));
			yyval = SCM_EOL;
		}
	}
#line 5278 "./out/parser.cc"
    break;

  case 245: /* symbol_list_element: STRING  */
#line 1832 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = scm_string_to_symbol (yyvsp[0]);
	}
#line 5286 "./out/parser.cc"
    break;

  case 247: /* symbol_list_part_bare: SYMBOL  */
#line 1841 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = try_word_variants (Lily::key_list_p, yyvsp[0]);
		if (SCM_UNBNDP (yyval)) {
			parser->parser_error ((yylsp[0]), _("not a key"));
			yyval = SCM_EOL;
		} else
			yyval = scm_reverse (yyval);
	}
#line 5299 "./out/parser.cc"
    break;

  case 248: /* symbol_list_part_bare: symbol_list_element  */
#line 1850 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = ly_list (yyvsp[0]);
	}
#line 5307 "./out/parser.cc"
    break;

  case 250: /* function_arglist_nonbackup: "optional?" "scheme?" function_arglist_nonbackup post_event_nofinger  */
#line 1858 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = check_scheme_arg (parser, (yylsp[0]), yyvsp[0], yyvsp[-1], yyvsp[-2]);
	}
#line 5315 "./out/parser.cc"
    break;

  case 251: /* function_arglist_nonbackup: "optional?" "scheme?" function_arglist_nonbackup '-' UNSIGNED  */
#line 1862 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		SCM n = scm_difference (yyvsp[0], SCM_UNDEFINED);
		if (scm_is_true (ly_call (yyvsp[-3], n)))
			yyval = scm_cons (n, yyvsp[-2]);
		else {
			Music *t = MY_MAKE_MUSIC ("FingeringEvent", (yylsp[0]));
			set_property (t, "digit", yyvsp[0]);
			yyval = check_scheme_arg (parser, (yylsp[-1]), t->unprotect (),
					       yyvsp[-2], yyvsp[-3], n);
		}
	}
#line 5331 "./out/parser.cc"
    break;

  case 252: /* function_arglist_nonbackup: "optional?" "scheme?" function_arglist_nonbackup '-' REAL  */
#line 1874 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = check_scheme_arg (parser, (yylsp[-1]),
				       scm_difference (yyvsp[0], SCM_UNDEFINED),
				       yyvsp[-2], yyvsp[-3]);
	}
#line 5341 "./out/parser.cc"
    break;

  case 253: /* function_arglist_nonbackup: "optional?" "scheme?" function_arglist_nonbackup '-' NUMBER_IDENTIFIER  */
#line 1880 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = check_scheme_arg (parser, (yylsp[-1]),
				       scm_difference (yyvsp[0], SCM_UNDEFINED),
				       yyvsp[-2], yyvsp[-3]);
	}
#line 5351 "./out/parser.cc"
    break;

  case 254: /* function_arglist_nonbackup: "optional?" "scheme?" function_arglist_nonbackup embedded_scm_arg  */
#line 1886 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		if (scm_is_true (ly_call (yyvsp[-2], yyvsp[0])))
			yyval = scm_cons (yyvsp[0], yyvsp[-1]);
		else
			yyval = check_scheme_arg (parser, (yylsp[0]),
					       make_music_from_simple
					       (parser, (yylsp[0]), yyvsp[0]),
					       yyvsp[-1], yyvsp[-2], yyvsp[0]);
	}
#line 5365 "./out/parser.cc"
    break;

  case 255: /* function_arglist_nonbackup: "optional?" "scheme?" function_arglist_nonbackup bare_number_common  */
#line 1896 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = check_scheme_arg (parser, (yylsp[0]), yyvsp[0], yyvsp[-1], yyvsp[-2]);
	}
#line 5373 "./out/parser.cc"
    break;

  case 256: /* function_arglist_nonbackup: function_arglist_nonbackup_reparse "(reparsed?)" pitch_or_music  */
#line 1900 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		if (scm_is_true (ly_call (yyvsp[-1], yyvsp[0])))
			yyval = scm_cons (yyvsp[0], yyvsp[-2]);
		else
			yyval = check_scheme_arg (parser, (yylsp[0]),
					       make_music_from_simple
					       (parser, (yylsp[0]), yyvsp[0]),
					       yyvsp[-2], yyvsp[-1], yyvsp[0]);
	}
#line 5387 "./out/parser.cc"
    break;

  case 257: /* function_arglist_nonbackup: function_arglist_nonbackup_reparse "(reparsed?)" duration  */
#line 1910 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = check_scheme_arg (parser, (yylsp[0]), yyvsp[0], yyvsp[-2], yyvsp[-1]);
	}
#line 5395 "./out/parser.cc"
    break;

  case 258: /* function_arglist_nonbackup: function_arglist_nonbackup_reparse "(reparsed?)" reparsed_rhythm  */
#line 1914 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = check_scheme_arg (parser, (yylsp[0]), yyvsp[0], yyvsp[-2], yyvsp[-1]);
	}
#line 5403 "./out/parser.cc"
    break;

  case 259: /* function_arglist_nonbackup: function_arglist_nonbackup_reparse "(reparsed?)" bare_number_common  */
#line 1918 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = check_scheme_arg (parser, (yylsp[0]), yyvsp[0], yyvsp[-2], yyvsp[-1]);
	}
#line 5411 "./out/parser.cc"
    break;

  case 260: /* function_arglist_nonbackup: function_arglist_nonbackup_reparse "(reparsed?)" SCM_ARG  */
#line 1922 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = check_scheme_arg (parser, (yylsp[0]), yyvsp[0], yyvsp[-2], yyvsp[-1]);
	}
#line 5419 "./out/parser.cc"
    break;

  case 261: /* function_arglist_nonbackup: function_arglist_nonbackup_reparse "(reparsed?)" lyric_element_music  */
#line 1926 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = check_scheme_arg (parser, (yylsp[0]), yyvsp[0], yyvsp[-2], yyvsp[-1]);
	}
#line 5427 "./out/parser.cc"
    break;

  case 262: /* function_arglist_nonbackup: function_arglist_nonbackup_reparse "(reparsed?)" symbol_list_arg  */
#line 1930 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = check_scheme_arg (parser, (yylsp[0]), yyvsp[0], yyvsp[-2], yyvsp[-1]);
	}
#line 5435 "./out/parser.cc"
    break;

  case 263: /* reparsed_rhythm: DURATION_ARG dots multipliers post_events  */
#line 1938 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		SCM d = make_duration (yyvsp[-3], from_scm<int> (yyvsp[-2]), yyvsp[-1]);
		parser->default_duration_ = *unsmob<Duration> (d);
		yyval = make_music_from_simple (parser, (yyloc), d);
		Music *m = unsmob<Music> (yyval);
		assert (m);
		if (scm_is_pair (yyvsp[0]))
			set_property (m, "articulations",
					 scm_reverse_x (yyvsp[0], SCM_EOL));
	}
#line 5450 "./out/parser.cc"
    break;

  case 264: /* function_arglist_nonbackup_reparse: "optional?" "scheme?" function_arglist_nonbackup SCM_IDENTIFIER  */
#line 1952 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = yyvsp[-1];
		SCM res = try_string_variants (yyvsp[-2], yyvsp[0]);
		if (!SCM_UNBNDP (res))
			if (scm_is_pair (res))
				MYREPARSE ((yylsp[0]), yyvsp[-2], SYMBOL_LIST, res);
			else
				MYREPARSE ((yylsp[0]), yyvsp[-2], SCM_ARG, res);
		else if (scm_is_true
			 (ly_call
			  (yyvsp[-2], make_music_from_simple
			   (parser, (yylsp[0]), yyvsp[0]))))
			MYREPARSE ((yylsp[0]), yyvsp[-2], STRING, yyvsp[0]);
		else
			MYREPARSE ((yylsp[0]), yyvsp[-2], SCM_ARG, yyvsp[0]);
	}
#line 5471 "./out/parser.cc"
    break;

  case 265: /* function_arglist_nonbackup_reparse: "optional?" "scheme?" function_arglist_nonbackup pitch  */
#line 1969 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = yyvsp[-1];
		if (scm_is_true
		    (ly_call
		     (yyvsp[-2], make_music_from_simple
		      (parser, (yylsp[0]), yyvsp[0]))))
			MYREPARSE ((yylsp[0]), yyvsp[-2], PITCH_IDENTIFIER, yyvsp[0]);
		else
			MYREPARSE ((yylsp[0]), yyvsp[-2], SCM_ARG, yyvsp[0]);
	}
#line 5486 "./out/parser.cc"
    break;

  case 266: /* function_arglist_nonbackup_reparse: "optional?" "scheme?" function_arglist_nonbackup steno_tonic_pitch  */
#line 1980 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = yyvsp[-1];
		if (scm_is_true
		    (ly_call
		     (yyvsp[-2], make_music_from_simple
		      (parser, (yylsp[0]), yyvsp[0]))))
			MYREPARSE ((yylsp[0]), yyvsp[-2], TONICNAME_PITCH, yyvsp[0]);
		else
			MYREPARSE ((yylsp[0]), yyvsp[-2], SCM_ARG, yyvsp[0]);
	}
#line 5501 "./out/parser.cc"
    break;

  case 267: /* function_arglist_nonbackup_reparse: "optional?" "scheme?" function_arglist_nonbackup STRING  */
#line 1991 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = yyvsp[-1];
		SCM res = try_string_variants (yyvsp[-2], yyvsp[0]);
		if (!SCM_UNBNDP (res))
			if (scm_is_pair (res))
				MYREPARSE ((yylsp[0]), yyvsp[-2], SYMBOL_LIST, res);
			else
				MYREPARSE ((yylsp[0]), yyvsp[-2], SCM_ARG, res);
		else if (scm_is_true
			 (ly_call
			  (yyvsp[-2], make_music_from_simple
			   (parser, (yylsp[0]), yyvsp[0]))))
			MYREPARSE ((yylsp[0]), yyvsp[-2], STRING, yyvsp[0]);
		else
			MYREPARSE ((yylsp[0]), yyvsp[-2], SCM_ARG, yyvsp[0]);
	}
#line 5522 "./out/parser.cc"
    break;

  case 268: /* function_arglist_nonbackup_reparse: "optional?" "scheme?" function_arglist_nonbackup SYMBOL  */
#line 2008 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = yyvsp[-1];
		SCM res = try_word_variants (yyvsp[-2], yyvsp[0]);
		if (!SCM_UNBNDP (res))
			if (scm_is_pair (res))
				MYREPARSE ((yylsp[0]), yyvsp[-2], SYMBOL_LIST, res);
			else
				MYREPARSE ((yylsp[0]), yyvsp[-2], SCM_ARG, res);
		else if (scm_is_true
			 (ly_call
			  (yyvsp[-2], make_music_from_simple
			   (parser, (yylsp[0]), yyvsp[0]))))
			MYREPARSE ((yylsp[0]), yyvsp[-2], STRING, yyvsp[0]);
		else
			MYREPARSE ((yylsp[0]), yyvsp[-2], SCM_ARG, yyvsp[0]);
	}
#line 5543 "./out/parser.cc"
    break;

  case 269: /* function_arglist_nonbackup_reparse: "optional?" "scheme?" function_arglist_nonbackup full_markup  */
#line 2025 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = yyvsp[-1];
		if (scm_is_true (ly_call (yyvsp[-2], yyvsp[0])))
			MYREPARSE ((yylsp[0]), yyvsp[-2], SCM_ARG, yyvsp[0]);
		else if (scm_is_true
			 (ly_call
			  (yyvsp[-2], make_music_from_simple
			   (parser, (yylsp[0]), yyvsp[0]))))
			MYREPARSE ((yylsp[0]), yyvsp[-2], STRING, yyvsp[0]);
		else
			MYREPARSE ((yylsp[0]), yyvsp[-2], SCM_ARG, yyvsp[0]);
	}
#line 5560 "./out/parser.cc"
    break;

  case 270: /* function_arglist_nonbackup_reparse: "optional?" "scheme?" function_arglist_nonbackup UNSIGNED  */
#line 2038 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = yyvsp[-1];
		if (scm_is_true (ly_call (yyvsp[-2], yyvsp[0])))
			// May be 3 \cm or similar
			MYREPARSE ((yylsp[0]), yyvsp[-2], REAL, yyvsp[0]);
		else if (scm_is_true (ly_call (yyvsp[-2], ly_list (yyvsp[0]))))
			MYREPARSE ((yylsp[0]), yyvsp[-2], SYMBOL_LIST, ly_list (yyvsp[0]));
		else {
			SCM d = make_duration (yyvsp[0]);
			if (!SCM_UNBNDP (d)) {
				if (scm_is_true (ly_call (yyvsp[-2], d)))
					MYREPARSE ((yylsp[0]), yyvsp[-2], DURATION_IDENTIFIER, d);
				else if (scm_is_true
					 (ly_call
					  (yyvsp[-2], make_music_from_simple (parser, (yylsp[0]), d))))
					MYREPARSE ((yylsp[0]), yyvsp[-2], DURATION_ARG, d);
				else
					MYREPARSE ((yylsp[0]), yyvsp[-2], SCM_ARG, yyvsp[0]); // trigger error
			} else
				MYREPARSE ((yylsp[0]), yyvsp[-2], SCM_ARG, yyvsp[0]); // trigger error
		}
	}
#line 5587 "./out/parser.cc"
    break;

  case 271: /* function_arglist_nonbackup_reparse: "optional?" "scheme?" function_arglist_nonbackup DURATION_IDENTIFIER  */
#line 2061 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = yyvsp[-1];
		if (scm_is_true (ly_call (yyvsp[-2], yyvsp[0])))
			MYREPARSE ((yylsp[0]), yyvsp[-2], DURATION_IDENTIFIER, yyvsp[0]);
		else if (scm_is_true
			 (ly_call
			  (yyvsp[-2], make_music_from_simple (parser, (yylsp[0]), yyvsp[0]))))
			MYREPARSE ((yylsp[0]), yyvsp[-2], DURATION_ARG, yyvsp[0]);
		else
			MYREPARSE ((yylsp[0]), yyvsp[-2], SCM_ARG, yyvsp[0]); // trigger error
	}
#line 5603 "./out/parser.cc"
    break;

  case 273: /* function_arglist_backup: "optional?" "scheme?" function_arglist_backup embedded_scm_arg  */
#line 2080 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		if (scm_is_true (ly_call (yyvsp[-2], yyvsp[0])))
			yyval = scm_cons (yyvsp[0], yyvsp[-1]);
		else {
			yyval = make_music_from_simple (parser, (yylsp[0]), yyvsp[0]);
			if (scm_is_true (ly_call (yyvsp[-2], yyval)))
				yyval = scm_cons (yyval, yyvsp[-1]);
			else
			{
				yyval = scm_cons (loc_on_copy (parser, (yylsp[-1]), yyvsp[-3]), yyvsp[-1]);
				MYBACKUP (SCM_ARG, yyvsp[0], (yylsp[0]));
			}
		}
	}
#line 5622 "./out/parser.cc"
    break;

  case 274: /* function_arglist_backup: "optional?" "scheme?" function_arglist_backup post_event_nofinger  */
#line 2095 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		if (scm_is_true (ly_call (yyvsp[-2], yyvsp[0])))
		{
			yyval = scm_cons (yyvsp[0], yyvsp[-1]);
		} else {
			yyval = scm_cons (loc_on_copy (parser, (yylsp[-1]), yyvsp[-3]), yyvsp[-1]);
			MYBACKUP (EVENT_IDENTIFIER, yyvsp[0], (yylsp[0]));
		}
	}
#line 5636 "./out/parser.cc"
    break;

  case 275: /* function_arglist_backup: "optional?" "scheme?" function_arglist_backup pitch  */
#line 2105 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		if (scm_is_true
		    (ly_call
		     (yyvsp[-2], make_music_from_simple
		      (parser, (yylsp[0]), yyvsp[0]))))
		{
			yyval = yyvsp[-1];
			MYREPARSE ((yylsp[0]), yyvsp[-2], PITCH_IDENTIFIER, yyvsp[0]);
		} else if (scm_is_true (ly_call (yyvsp[-2], yyvsp[0])))
			yyval = scm_cons (yyvsp[0], yyvsp[-1]);
		else {
			yyval = scm_cons (loc_on_copy (parser, (yylsp[-1]), yyvsp[-3]), yyvsp[-1]);
			MYBACKUP (PITCH_IDENTIFIER, yyvsp[0], (yylsp[0]));
		}
	}
#line 5656 "./out/parser.cc"
    break;

  case 276: /* function_arglist_backup: "optional?" "scheme?" function_arglist_backup steno_tonic_pitch  */
#line 2121 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		if (scm_is_true
		    (ly_call
		     (yyvsp[-2], make_music_from_simple
		      (parser, (yylsp[0]), yyvsp[0]))))
		{
			yyval = yyvsp[-1];
			MYREPARSE ((yylsp[0]), yyvsp[-2], TONICNAME_PITCH, yyvsp[0]);
		} else if (scm_is_true (ly_call (yyvsp[-2], yyvsp[0])))
			yyval = scm_cons (yyvsp[0], yyvsp[-1]);
		else {
			yyval = scm_cons (loc_on_copy (parser, (yylsp[-1]), yyvsp[-3]), yyvsp[-1]);
			MYBACKUP (TONICNAME_PITCH, yyvsp[0], (yylsp[0]));
		}
	}
#line 5676 "./out/parser.cc"
    break;

  case 277: /* function_arglist_backup: "optional?" "scheme?" function_arglist_backup full_markup  */
#line 2137 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		if (scm_is_true (ly_call (yyvsp[-2], yyvsp[0])))
			yyval = scm_cons (yyvsp[0], yyvsp[-1]);
		else {
			yyval = scm_cons (loc_on_copy (parser, (yylsp[-1]), yyvsp[-3]), yyvsp[-1]);
			MYBACKUP (SCM_IDENTIFIER, yyvsp[0], (yylsp[0]));
		}
	}
#line 5689 "./out/parser.cc"
    break;

  case 278: /* function_arglist_backup: "optional?" "scheme?" function_arglist_backup UNSIGNED  */
#line 2146 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = yyvsp[-1];
		if (scm_is_true (ly_call (yyvsp[-2], yyvsp[0])))
			// May be 3 \cm or similar
			MYREPARSE ((yylsp[0]), yyvsp[-2], REAL, yyvsp[0]);
		else if (scm_is_true (ly_call (yyvsp[-2], ly_list (yyvsp[0]))))
			MYREPARSE ((yylsp[0]), yyvsp[-2], SYMBOL_LIST, ly_list (yyvsp[0]));
		else {
			SCM d = make_duration (yyvsp[0]);
			if (!SCM_UNBNDP (d)) {
				if (scm_is_true (ly_call (yyvsp[-2], d)))
					MYREPARSE ((yylsp[0]), yyvsp[-2], DURATION_IDENTIFIER, d);
				else if (scm_is_true
					 (ly_call
					  (yyvsp[-2], make_music_from_simple (parser, (yylsp[0]), d))))
					MYREPARSE ((yylsp[0]), yyvsp[-2], DURATION_ARG, d);
				else {
					yyval = scm_cons (loc_on_copy (parser, (yylsp[-1]), yyvsp[-3]), yyvsp[-1]);
					MYBACKUP (UNSIGNED, yyvsp[0], (yylsp[0]));
				}
			} else {
				yyval = scm_cons (loc_on_copy (parser, (yylsp[-1]), yyvsp[-3]), yyvsp[-1]);
				MYBACKUP (UNSIGNED, yyvsp[0], (yylsp[0]));
			}
		}
	}
#line 5720 "./out/parser.cc"
    break;

  case 279: /* function_arglist_backup: "optional?" "scheme?" function_arglist_backup REAL  */
#line 2173 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		if (scm_is_true (ly_call (yyvsp[-2], yyvsp[0])))
		{
			yyval = yyvsp[-1];
			MYREPARSE ((yylsp[0]), yyvsp[-2], REAL, yyvsp[0]);
		} else {
			yyval = scm_cons (loc_on_copy (parser, (yylsp[-1]), yyvsp[-3]), yyvsp[-1]);
			MYBACKUP (REAL, yyvsp[0], (yylsp[0]));
		}
	}
#line 5735 "./out/parser.cc"
    break;

  case 280: /* function_arglist_backup: "optional?" "scheme?" function_arglist_backup NUMBER_IDENTIFIER  */
#line 2184 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		if (scm_is_true (ly_call (yyvsp[-2], yyvsp[0])))
		{
			yyval = scm_cons (yyvsp[0], yyvsp[-1]);
		} else {
			yyval = scm_cons (loc_on_copy (parser, (yylsp[-1]), yyvsp[-3]), yyvsp[-1]);
			MYBACKUP (NUMBER_IDENTIFIER, yyvsp[0], (yylsp[0]));
		}
	}
#line 5749 "./out/parser.cc"
    break;

  case 281: /* function_arglist_backup: "optional?" "scheme?" function_arglist_backup '-' UNSIGNED  */
#line 2194 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		SCM n = scm_difference (yyvsp[0], SCM_UNDEFINED);
		if (scm_is_true (ly_call (yyvsp[-3], n))) {
			yyval = yyvsp[-2];
			MYREPARSE ((yylsp[0]), yyvsp[-3], REAL, n);
		} else {
			Music *t = MY_MAKE_MUSIC ("FingeringEvent", (yylsp[0]));
			set_property (t, "digit", yyvsp[0]);
			yyval = t->unprotect ();
			if (scm_is_true (ly_call (yyvsp[-3], yyval)))
				yyval = scm_cons (yyval, yyvsp[-2]);
			else {
				yyval = scm_cons (loc_on_copy (parser, (yylsp[-2]), yyvsp[-4]), yyvsp[-2]);
				MYBACKUP (UNSIGNED, yyvsp[0], (yylsp[0]));
				parser->lexer_->push_extra_token ((yylsp[-1]), '-');
			}
		}
	}
#line 5772 "./out/parser.cc"
    break;

  case 282: /* function_arglist_backup: "optional?" "scheme?" function_arglist_backup '-' REAL  */
#line 2213 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		SCM n = scm_difference (yyvsp[0], SCM_UNDEFINED);
		if (scm_is_true (ly_call (yyvsp[-3], n))) {
			MYREPARSE ((yylsp[0]), yyvsp[-3], REAL, n);
			yyval = yyvsp[-2];
		} else {
			yyval = scm_cons (loc_on_copy (parser, (yylsp[-2]), yyvsp[-4]), yyvsp[-2]);
			MYBACKUP (REAL, n, (yylsp[0]));
		}
	}
#line 5787 "./out/parser.cc"
    break;

  case 283: /* function_arglist_backup: "optional?" "scheme?" function_arglist_backup '-' NUMBER_IDENTIFIER  */
#line 2224 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		SCM n = scm_difference (yyvsp[0], SCM_UNDEFINED);
		if (scm_is_true (ly_call (yyvsp[-3], n))) {
			yyval = scm_cons (n, yyvsp[-2]);
		} else {
			yyval = scm_cons (loc_on_copy (parser, (yylsp[-2]), yyvsp[-4]), yyvsp[-2]);
			MYBACKUP (NUMBER_IDENTIFIER, n, (yylsp[0]));
		}
	}
#line 5801 "./out/parser.cc"
    break;

  case 284: /* function_arglist_backup: "optional?" "scheme?" function_arglist_backup DURATION_IDENTIFIER  */
#line 2234 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = yyvsp[-1];
		if (scm_is_true (ly_call (yyvsp[-2], yyvsp[0])))
			MYREPARSE ((yylsp[0]), yyvsp[-2], DURATION_IDENTIFIER, yyvsp[0]);
		else if (scm_is_true
			 (ly_call
			  (yyvsp[-2], make_music_from_simple (parser, (yylsp[0]), yyvsp[0]))))
			MYREPARSE ((yylsp[0]), yyvsp[-2], DURATION_ARG, yyvsp[0]);
		else {
			yyval = scm_cons (loc_on_copy (parser, (yylsp[-1]), yyvsp[-3]), yyvsp[-1]);
			MYBACKUP (DURATION_IDENTIFIER, yyvsp[0], (yylsp[0]));
		}
	}
#line 5819 "./out/parser.cc"
    break;

  case 285: /* function_arglist_backup: "optional?" "scheme?" function_arglist_backup SCM_IDENTIFIER  */
#line 2248 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		SCM res = try_string_variants (yyvsp[-2], yyvsp[0]);
		if (!SCM_UNBNDP (res))
			if (scm_is_pair (res)) {
				yyval = yyvsp[-1];
				MYREPARSE ((yylsp[0]), yyvsp[-2], SYMBOL_LIST, res);
			}
			else
				yyval = scm_cons (res, yyvsp[-1]);
		else {
			yyval = scm_cons (loc_on_copy (parser, (yylsp[-1]), yyvsp[-3]), yyvsp[-1]);
			MYBACKUP (SCM_IDENTIFIER, yyvsp[0], (yylsp[0]));
		}
	}
#line 5838 "./out/parser.cc"
    break;

  case 286: /* function_arglist_backup: "optional?" "scheme?" function_arglist_backup STRING  */
#line 2263 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		SCM res = try_string_variants (yyvsp[-2], yyvsp[0]);
		if (!SCM_UNBNDP (res))
			if (scm_is_pair (res)) {
				yyval = yyvsp[-1];
				MYREPARSE ((yylsp[0]), yyvsp[-2], SYMBOL_LIST, res);
			}
			else
				yyval = scm_cons (res, yyvsp[-1]);
		else {
			yyval = scm_cons (loc_on_copy (parser, (yylsp[-1]), yyvsp[-3]), yyvsp[-1]);
			MYBACKUP (STRING, yyvsp[0], (yylsp[0]));
		}
	}
#line 5857 "./out/parser.cc"
    break;

  case 287: /* function_arglist_backup: "optional?" "scheme?" function_arglist_backup SYMBOL  */
#line 2278 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		SCM res = try_word_variants (yyvsp[-2], yyvsp[0]);
		if (!SCM_UNBNDP (res))
			if (scm_is_pair (res)) {
				yyval = yyvsp[-1];
				MYREPARSE ((yylsp[0]), yyvsp[-2], SYMBOL_LIST, res);
			}
			else
				yyval = scm_cons (res, yyvsp[-1]);
		else {
			yyval = scm_cons (loc_on_copy (parser, (yylsp[-1]), yyvsp[-3]), yyvsp[-1]);
			MYBACKUP (STRING, yyvsp[0], (yylsp[0]));
		}
	}
#line 5876 "./out/parser.cc"
    break;

  case 288: /* function_arglist_backup: function_arglist_backup "(reparsed?)" pitch_or_music  */
#line 2293 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		if (scm_is_true (ly_call (yyvsp[-1], yyvsp[0])))
			yyval = scm_cons (yyvsp[0], yyvsp[-2]);
		else
			yyval = check_scheme_arg (parser, (yylsp[0]),
					       make_music_from_simple
					       (parser, (yylsp[0]), yyvsp[0]),
					       yyvsp[-2], yyvsp[-1]);
	}
#line 5890 "./out/parser.cc"
    break;

  case 289: /* function_arglist_backup: function_arglist_backup "(reparsed?)" bare_number_common  */
#line 2303 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = check_scheme_arg (parser, (yylsp[0]),
				       yyvsp[0], yyvsp[-2], yyvsp[-1]);
	}
#line 5899 "./out/parser.cc"
    break;

  case 290: /* function_arglist_backup: function_arglist_backup "(reparsed?)" duration  */
#line 2308 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = check_scheme_arg (parser, (yylsp[0]),
				       yyvsp[0], yyvsp[-2], yyvsp[-1]);
	}
#line 5908 "./out/parser.cc"
    break;

  case 291: /* function_arglist_backup: function_arglist_backup "(reparsed?)" reparsed_rhythm  */
#line 2313 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = check_scheme_arg (parser, (yylsp[0]),
				       yyvsp[0], yyvsp[-2], yyvsp[-1]);
	}
#line 5917 "./out/parser.cc"
    break;

  case 292: /* function_arglist_backup: function_arglist_backup "(reparsed?)" symbol_list_arg  */
#line 2318 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = check_scheme_arg (parser, (yylsp[0]), yyvsp[0], yyvsp[-2], yyvsp[-1]);
	}
#line 5925 "./out/parser.cc"
    break;

  case 294: /* function_arglist: "optional?" "scheme?" function_arglist_skip_nonbackup "\\default"  */
#line 2326 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = scm_cons (loc_on_copy (parser, (yylsp[0]), yyvsp[-3]), yyvsp[-1]);
	}
#line 5933 "./out/parser.cc"
    break;

  case 296: /* function_arglist_skip_nonbackup: "optional?" "scheme?" function_arglist_skip_nonbackup  */
#line 2334 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = scm_cons (loc_on_copy (parser, (yylsp[0]), yyvsp[-2]), yyvsp[0]);
	}
#line 5941 "./out/parser.cc"
    break;

  case 297: /* function_arglist_partial: "scheme?" function_arglist_optional  */
#line 2353 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = yyvsp[0];
	}
#line 5949 "./out/parser.cc"
    break;

  case 298: /* function_arglist_partial: "scheme?" function_arglist_partial_optional  */
#line 2357 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = yyvsp[0];
	}
#line 5957 "./out/parser.cc"
    break;

  case 299: /* function_arglist_partial: "optional?" "scheme?" function_arglist_nonbackup  */
#line 2361 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = yyvsp[0];
	}
#line 5965 "./out/parser.cc"
    break;

  case 300: /* function_arglist_partial: "optional?" "scheme?" function_arglist_partial  */
#line 2365 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = yyvsp[0];
	}
#line 5973 "./out/parser.cc"
    break;

  case 301: /* function_arglist_partial_optional: "scheme?" function_arglist_optional  */
#line 2372 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = yyvsp[0];
	}
#line 5981 "./out/parser.cc"
    break;

  case 302: /* function_arglist_partial_optional: "scheme?" function_arglist_partial_optional  */
#line 2376 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = yyvsp[0];
	}
#line 5989 "./out/parser.cc"
    break;

  case 303: /* function_arglist_partial_optional: "optional?" "scheme?" function_arglist_backup  */
#line 2380 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = yyvsp[0];
	}
#line 5997 "./out/parser.cc"
    break;

  case 304: /* function_arglist_partial_optional: "optional?" "scheme?" function_arglist_partial_optional  */
#line 2384 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = yyvsp[0];
	}
#line 6005 "./out/parser.cc"
    break;

  case 305: /* function_arglist_common: EXPECT_NO_MORE_ARGS  */
#line 2390 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                            {
		yyval = SCM_EOL;
	}
#line 6013 "./out/parser.cc"
    break;

  case 306: /* function_arglist_common: "scheme?" function_arglist_optional embedded_scm_arg  */
#line 2394 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		if (scm_is_true (ly_call (yyvsp[-2], yyvsp[0])))
			yyval = scm_cons (yyvsp[0], yyvsp[-1]);
		else
			yyval = check_scheme_arg (parser, (yylsp[0]),
					       make_music_from_simple
					       (parser, (yylsp[0]), yyvsp[0]),
					       yyvsp[-1], yyvsp[-2], yyvsp[0]);
	}
#line 6027 "./out/parser.cc"
    break;

  case 307: /* function_arglist_common: "scheme?" function_arglist_optional bare_number_common  */
#line 2404 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = check_scheme_arg (parser, (yylsp[0]),
				       yyvsp[0], yyvsp[-1], yyvsp[-2]);
	}
#line 6036 "./out/parser.cc"
    break;

  case 308: /* function_arglist_common: "scheme?" function_arglist_optional post_event_nofinger  */
#line 2409 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = check_scheme_arg (parser, (yylsp[0]),
				       yyvsp[0], yyvsp[-1], yyvsp[-2]);
	}
#line 6045 "./out/parser.cc"
    break;

  case 309: /* function_arglist_common: "scheme?" function_arglist_optional '-' NUMBER_IDENTIFIER  */
#line 2414 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		SCM n = scm_difference (yyvsp[0], SCM_UNDEFINED);
		yyval = check_scheme_arg (parser, (yylsp[0]), n, yyvsp[-2], yyvsp[-3]);
	}
#line 6054 "./out/parser.cc"
    break;

  case 310: /* function_arglist_common: function_arglist_common_reparse "(reparsed?)" SCM_ARG  */
#line 2419 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = check_scheme_arg (parser, (yylsp[0]),
				       yyvsp[0], yyvsp[-2], yyvsp[-1]);
	}
#line 6063 "./out/parser.cc"
    break;

  case 311: /* function_arglist_common: function_arglist_common_reparse "(reparsed?)" lyric_element_music  */
#line 2424 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = check_scheme_arg (parser, (yylsp[0]),
				       yyvsp[0], yyvsp[-2], yyvsp[-1]);
	}
#line 6072 "./out/parser.cc"
    break;

  case 312: /* function_arglist_common: function_arglist_common_reparse "(reparsed?)" pitch_or_music  */
#line 2429 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		if (scm_is_true (ly_call (yyvsp[-1], yyvsp[0])))
			yyval = scm_cons (yyvsp[0], yyvsp[-2]);
		else
			yyval = check_scheme_arg (parser, (yylsp[0]),
					       make_music_from_simple
					       (parser, (yylsp[0]), yyvsp[0]),
					       yyvsp[-2], yyvsp[-1], yyvsp[0]);
	}
#line 6086 "./out/parser.cc"
    break;

  case 313: /* function_arglist_common: function_arglist_common_reparse "(reparsed?)" bare_number_common  */
#line 2439 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = check_scheme_arg (parser, (yylsp[0]),
				       yyvsp[0], yyvsp[-2], yyvsp[-1]);
	}
#line 6095 "./out/parser.cc"
    break;

  case 314: /* function_arglist_common: function_arglist_common_reparse "(reparsed?)" duration  */
#line 2444 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = check_scheme_arg (parser, (yylsp[0]),
				       yyvsp[0], yyvsp[-2], yyvsp[-1]);
	}
#line 6104 "./out/parser.cc"
    break;

  case 315: /* function_arglist_common: function_arglist_common_reparse "(reparsed?)" reparsed_rhythm  */
#line 2449 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = check_scheme_arg (parser, (yylsp[0]),
				       yyvsp[0], yyvsp[-2], yyvsp[-1]);
	}
#line 6113 "./out/parser.cc"
    break;

  case 316: /* function_arglist_common: function_arglist_common_reparse "(reparsed?)" symbol_list_arg  */
#line 2454 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = check_scheme_arg (parser, (yylsp[0]), yyvsp[0], yyvsp[-2], yyvsp[-1]);
	}
#line 6121 "./out/parser.cc"
    break;

  case 317: /* function_arglist_common_reparse: "scheme?" function_arglist_optional SCM_IDENTIFIER  */
#line 2461 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = yyvsp[-1];
		SCM res = try_string_variants (yyvsp[-2], yyvsp[0]);
		if (!SCM_UNBNDP (res))
			if (scm_is_pair (res))
				MYREPARSE ((yylsp[0]), yyvsp[-2], SYMBOL_LIST, res);
			else
				MYREPARSE ((yylsp[0]), yyvsp[-2], SCM_ARG, res);
		else if (scm_is_true
			 (ly_call
			  (yyvsp[-2], make_music_from_simple (parser, (yylsp[0]), yyvsp[0]))))
			MYREPARSE ((yylsp[0]), yyvsp[-2], LYRIC_ELEMENT, yyvsp[0]);
		else
			// This is going to flag a syntax error, we
			// know the predicate to be false.
			MYREPARSE ((yylsp[0]), yyvsp[-2], SCM_ARG, yyvsp[0]);
	}
#line 6143 "./out/parser.cc"
    break;

  case 318: /* function_arglist_common_reparse: "scheme?" function_arglist_optional pitch  */
#line 2479 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = yyvsp[-1];
		if (scm_is_true
		    (ly_call
		     (yyvsp[-2], make_music_from_simple
		      (parser, (yylsp[0]), yyvsp[0]))))
			MYREPARSE ((yylsp[0]), yyvsp[-2], PITCH_IDENTIFIER, yyvsp[0]);
		else
			MYREPARSE ((yylsp[0]), yyvsp[-2], SCM_ARG, yyvsp[0]);
	}
#line 6158 "./out/parser.cc"
    break;

  case 319: /* function_arglist_common_reparse: "scheme?" function_arglist_optional steno_tonic_pitch  */
#line 2490 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = yyvsp[-1];
		if (scm_is_true
		    (ly_call
		     (yyvsp[-2], make_music_from_simple
		      (parser, (yylsp[0]), yyvsp[0]))))
			MYREPARSE ((yylsp[0]), yyvsp[-2], TONICNAME_PITCH, yyvsp[0]);
		else
			MYREPARSE ((yylsp[0]), yyvsp[-2], SCM_ARG, yyvsp[0]);
	}
#line 6173 "./out/parser.cc"
    break;

  case 320: /* function_arglist_common_reparse: "scheme?" function_arglist_optional STRING  */
#line 2501 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = yyvsp[-1];
		SCM res = try_string_variants (yyvsp[-2], yyvsp[0]);
		if (!SCM_UNBNDP (res))
			if (scm_is_pair (res))
				MYREPARSE ((yylsp[0]), yyvsp[-2], SYMBOL_LIST, res);
			else
				MYREPARSE ((yylsp[0]), yyvsp[-2], SCM_ARG, res);
		else if (scm_is_true
			 (ly_call
			  (yyvsp[-2], make_music_from_simple (parser, (yylsp[0]), yyvsp[0]))))
			MYREPARSE ((yylsp[0]), yyvsp[-2], LYRIC_ELEMENT, yyvsp[0]);
		else
			// This is going to flag a syntax error, we
			// know the predicate to be false.
			MYREPARSE ((yylsp[0]), yyvsp[-2], SCM_ARG, yyvsp[0]);
	}
#line 6195 "./out/parser.cc"
    break;

  case 321: /* function_arglist_common_reparse: "scheme?" function_arglist_optional SYMBOL  */
#line 2519 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = yyvsp[-1];
		SCM res = try_word_variants (yyvsp[-2], yyvsp[0]);
		if (!SCM_UNBNDP (res))
			if (scm_is_pair (res))
				MYREPARSE ((yylsp[0]), yyvsp[-2], SYMBOL_LIST, res);
			else
				MYREPARSE ((yylsp[0]), yyvsp[-2], SCM_ARG, res);
		else if (scm_is_true
			 (ly_call
			  (yyvsp[-2], make_music_from_simple (parser, (yylsp[0]), yyvsp[0]))))
			MYREPARSE ((yylsp[0]), yyvsp[-2], LYRIC_ELEMENT, yyvsp[0]);
		else
			// This is going to flag a syntax error, we
			// know the predicate to be false.
			MYREPARSE ((yylsp[0]), yyvsp[-2], SCM_ARG, yyvsp[0]);
	}
#line 6217 "./out/parser.cc"
    break;

  case 322: /* function_arglist_common_reparse: "scheme?" function_arglist_optional full_markup  */
#line 2537 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = yyvsp[-1];
		if (scm_is_true (ly_call (yyvsp[-2], yyvsp[0])))
			MYREPARSE ((yylsp[0]), yyvsp[-2], SCM_ARG, yyvsp[0]);
		else if (scm_is_true
			 (ly_call
			  (yyvsp[-2], make_music_from_simple (parser, (yylsp[0]), yyvsp[0]))))
			MYREPARSE ((yylsp[0]), yyvsp[-2], LYRIC_ELEMENT, yyvsp[0]);
		else
			// This is going to flag a syntax error, we
			// know the predicate to be false.
			MYREPARSE ((yylsp[0]), yyvsp[-2], SCM_ARG, yyvsp[0]);
	}
#line 6235 "./out/parser.cc"
    break;

  case 323: /* function_arglist_common_reparse: "scheme?" function_arglist_optional UNSIGNED  */
#line 2551 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = yyvsp[-1];
		if (scm_is_true (ly_call (yyvsp[-2], yyvsp[0])))
			// May be 3 \cm or similar
			MYREPARSE ((yylsp[0]), yyvsp[-2], REAL, yyvsp[0]);
		else if (scm_is_true (ly_call (yyvsp[-2], ly_list (yyvsp[0]))))
			MYREPARSE ((yylsp[0]), yyvsp[-2], SYMBOL_LIST, ly_list (yyvsp[0]));
		else {
			SCM d = make_duration (yyvsp[0]);
			if (!SCM_UNBNDP (d)) {
				if (scm_is_true (ly_call (yyvsp[-2], d)))
					MYREPARSE ((yylsp[0]), yyvsp[-2], DURATION_IDENTIFIER, d);
				else if (scm_is_true
					 (ly_call
					  (yyvsp[-2], make_music_from_simple (parser, (yylsp[0]), d))))
					MYREPARSE ((yylsp[0]), yyvsp[-2], DURATION_ARG, d);
				else
					MYREPARSE ((yylsp[0]), yyvsp[-2], SCM_ARG, yyvsp[0]); // trigger error
			} else
				MYREPARSE ((yylsp[0]), yyvsp[-2], SCM_ARG, yyvsp[0]); // trigger error
		}
	}
#line 6262 "./out/parser.cc"
    break;

  case 324: /* function_arglist_common_reparse: "scheme?" function_arglist_optional DURATION_IDENTIFIER  */
#line 2574 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = yyvsp[-1];
		if (scm_is_true (ly_call (yyvsp[-2], yyvsp[0])))
			MYREPARSE ((yylsp[0]), yyvsp[-2], DURATION_IDENTIFIER, yyvsp[0]);
		else if (scm_is_true
			 (ly_call
			  (yyvsp[-2], make_music_from_simple (parser, (yylsp[0]), yyvsp[0]))))
			MYREPARSE ((yylsp[0]), yyvsp[-2], DURATION_ARG, yyvsp[0]);
		else
			MYREPARSE ((yylsp[0]), yyvsp[-2], SCM_ARG, yyvsp[0]); // trigger error
	}
#line 6278 "./out/parser.cc"
    break;

  case 325: /* function_arglist_common_reparse: "scheme?" function_arglist_optional '-' UNSIGNED  */
#line 2586 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = yyvsp[-2];
		SCM n = scm_difference (yyvsp[0], SCM_UNDEFINED);
		if (scm_is_true (ly_call (yyvsp[-3], n)))
			MYREPARSE ((yylsp[0]), yyvsp[-3], REAL, n);
		else {
			Music *t = MY_MAKE_MUSIC ("FingeringEvent", (yylsp[0]));
			set_property (t, "digit", yyvsp[0]);
			SCM m = t->unprotect ();
			if (scm_is_true (ly_call (yyvsp[-3], m)))
				MYREPARSE ((yylsp[0]), yyvsp[-3], SCM_ARG, m);
			else
				MYREPARSE ((yylsp[0]), yyvsp[-3], SCM_ARG, yyvsp[0]);
		}
	}
#line 6298 "./out/parser.cc"
    break;

  case 326: /* function_arglist_common_reparse: "scheme?" function_arglist_optional '-' REAL  */
#line 2602 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = yyvsp[-2];
		SCM n = scm_difference (yyvsp[0], SCM_UNDEFINED);
		MYREPARSE ((yylsp[0]), yyvsp[-3], REAL, n);
	}
#line 6308 "./out/parser.cc"
    break;

  case 328: /* function_arglist_optional: "optional?" "scheme?" function_arglist_skip_backup "\\default"  */
#line 2612 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = scm_cons (loc_on_copy (parser, (yylsp[0]), yyvsp[-3]), yyvsp[-1]);
	}
#line 6316 "./out/parser.cc"
    break;

  case 331: /* function_arglist_skip_backup: "optional?" "scheme?" function_arglist_skip_backup  */
#line 2621 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = scm_cons (loc_on_copy (parser, (yylsp[0]), yyvsp[-2]), yyvsp[0]);
	}
#line 6324 "./out/parser.cc"
    break;

  case 332: /* music_function_call: MUSIC_FUNCTION function_arglist  */
#line 2627 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                        {
		yyval = MAKE_SYNTAX (music_function, (yyloc),
				  yyvsp[-1], yyvsp[0]);
	}
#line 6333 "./out/parser.cc"
    break;

  case 333: /* optional_id: %empty  */
#line 2635 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
             { yyval = SCM_EOL; }
#line 6339 "./out/parser.cc"
    break;

  case 334: /* optional_id: '=' simple_string  */
#line 2636 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                            {
		yyval = yyvsp[0];
	}
#line 6347 "./out/parser.cc"
    break;

  case 335: /* $@9: %empty  */
#line 2648 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		parser->lexer_->push_lyric_state ();
	}
#line 6355 "./out/parser.cc"
    break;

  case 336: /* lyric_mode_music: $@9 grouped_music_list  */
#line 2651 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		parser->lexer_->pop_state ();
		yyval = yyvsp[0];
	}
#line 6364 "./out/parser.cc"
    break;

  case 338: /* mode_changed_music: mode_changing_head grouped_music_list  */
#line 2659 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                              {
		if (scm_is_eq (yyvsp[-1], ly_symbol2scm ("chords")))
		{
		  yyval = MAKE_SYNTAX (unrelativable_music, (yyloc), yyvsp[0]);
		}
		else
		{
		  yyval = yyvsp[0];
		}
		parser->lexer_->pop_state ();
	}
#line 6380 "./out/parser.cc"
    break;

  case 339: /* mode_changed_music: mode_changing_head_with_context optional_context_mods grouped_music_list  */
#line 2670 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                                                                   {
		yyval = MAKE_SYNTAX (context_create, (yyloc), yyvsp[-2], SCM_EOL, yyvsp[-1], yyvsp[0]);
		if (scm_is_eq (yyvsp[-2], ly_symbol2scm ("ChordNames")))
		{
		  yyval = MAKE_SYNTAX (unrelativable_music, (yyloc), yyval);
		}
		parser->lexer_->pop_state ();
	}
#line 6393 "./out/parser.cc"
    break;

  case 340: /* mode_changing_head: "\\notemode"  */
#line 2681 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                 {
		parser->lexer_->push_note_state ();

		yyval = ly_symbol2scm ("notes");
	}
#line 6403 "./out/parser.cc"
    break;

  case 341: /* mode_changing_head: "\\drummode"  */
#line 2687 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                {
		parser->lexer_->push_drum_state ();
		yyval = ly_symbol2scm ("drums");
	}
#line 6412 "./out/parser.cc"
    break;

  case 342: /* mode_changing_head: "\\figuremode"  */
#line 2691 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                     {
		parser->lexer_->push_figuredbass_state ();

		yyval = ly_symbol2scm ("figures");
	}
#line 6422 "./out/parser.cc"
    break;

  case 343: /* mode_changing_head: "\\chordmode"  */
#line 2696 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                    {
		SCM mods = parser->lexer_->lookup_identifier_symbol (ly_symbol2scm ("chordmodifiers"));
		parser->lexer_->chordmodifier_tab_ = alist_to_hashq (mods);
		parser->lexer_->push_chord_state ();
		yyval = ly_symbol2scm ("chords");

	}
#line 6434 "./out/parser.cc"
    break;

  case 344: /* mode_changing_head: "\\lyricmode"  */
#line 2704 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                { parser->lexer_->push_lyric_state ();
		yyval = ly_symbol2scm ("lyrics");
	}
#line 6442 "./out/parser.cc"
    break;

  case 345: /* mode_changing_head_with_context: "\\drums"  */
#line 2710 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
              {
		parser->lexer_->push_drum_state();
		yyval = ly_symbol2scm ("DrumStaff");
	}
#line 6451 "./out/parser.cc"
    break;

  case 346: /* mode_changing_head_with_context: "\\figures"  */
#line 2714 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                  {
		parser->lexer_->push_figuredbass_state ();

		yyval = ly_symbol2scm ("FiguredBass");
	}
#line 6461 "./out/parser.cc"
    break;

  case 347: /* mode_changing_head_with_context: "\\chords"  */
#line 2719 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                 {
		SCM mods = parser->lexer_->lookup_identifier_symbol (ly_symbol2scm ("chordmodifiers"));
		parser->lexer_->chordmodifier_tab_ = alist_to_hashq (mods);
		parser->lexer_->push_chord_state ();
		yyval = ly_symbol2scm ("ChordNames");
	}
#line 6472 "./out/parser.cc"
    break;

  case 348: /* mode_changing_head_with_context: "\\lyrics"  */
#line 2726 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                { parser->lexer_->push_lyric_state ();
		yyval = ly_symbol2scm ("Lyrics");
	}
#line 6480 "./out/parser.cc"
    break;

  case 349: /* context_change: "\\change" symbol '=' simple_string  */
#line 2732 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                         {
		yyval = MAKE_SYNTAX (context_change, (yyloc), yyvsp[-2], yyvsp[0]);
	}
#line 6488 "./out/parser.cc"
    break;

  case 350: /* property_path: symbol_list_rev  */
#line 2739 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                         {
		yyval = scm_reverse_x (yyvsp[0], SCM_EOL);
	}
#line 6496 "./out/parser.cc"
    break;

  case 351: /* property_operation: symbol '=' scalar  */
#line 2745 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                          {
		yyval = ly_list (ly_symbol2scm ("assign"), yyvsp[-2], yyvsp[0]);
	}
#line 6504 "./out/parser.cc"
    break;

  case 352: /* property_operation: "\\unset" symbol  */
#line 2748 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                       {
		yyval = ly_list (ly_symbol2scm ("unset"), yyvsp[0]);
	}
#line 6512 "./out/parser.cc"
    break;

  case 353: /* property_operation: "\\override" revert_arg '=' scalar  */
#line 2751 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                         {
		if (scm_ilength (yyvsp[-2]) < 2) {
			parser->parser_error ((yylsp[-2]), _("bad grob property path"));
			yyval = SCM_UNDEFINED;
		} else {
			yyval = scm_cons (ly_symbol2scm ("push"),
				       scm_cons2 (scm_car (yyvsp[-2]),
						  yyvsp[0],
						  scm_cdr (yyvsp[-2])));
		}
	}
#line 6528 "./out/parser.cc"
    break;

  case 354: /* property_operation: "\\revert" revert_arg  */
#line 2762 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                            {
		yyval = scm_cons (ly_symbol2scm ("pop"), yyvsp[0]);
	}
#line 6536 "./out/parser.cc"
    break;

  case 355: /* revert_arg: revert_arg_backup "(backed-up?)" symbol_list_arg  */
#line 2792 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = yyvsp[0];
	}
#line 6544 "./out/parser.cc"
    break;

  case 356: /* revert_arg_backup: revert_arg_part  */
#line 2799 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		if (scm_is_null (yyvsp[0])
		    || scm_is_null (scm_cdr (yyvsp[0])))
			MYBACKUP (SCM_ARG, yyvsp[0], (yylsp[0]));
		else
			MYBACKUP (SYMBOL_LIST, scm_reverse_x (yyvsp[0], SCM_EOL), (yylsp[0]));
	}
#line 6556 "./out/parser.cc"
    break;

  case 358: /* revert_arg_part: revert_arg_backup "(backed-up?)" SCM_ARG '.' symbol_list_part  */
#line 2812 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = scm_append_x (ly_list (yyvsp[0], yyvsp[-2]));
	}
#line 6564 "./out/parser.cc"
    break;

  case 359: /* revert_arg_part: revert_arg_backup "(backed-up?)" SCM_ARG ',' symbol_list_part  */
#line 2816 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = scm_append_x (ly_list (yyvsp[0], yyvsp[-2]));
	}
#line 6572 "./out/parser.cc"
    break;

  case 360: /* revert_arg_part: revert_arg_backup "(backed-up?)" SCM_ARG symbol_list_part  */
#line 2820 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = scm_append_x (ly_list (yyvsp[0], yyvsp[-1]));
		property_path_dot_warning ((yylsp[0]), scm_reverse (yyval));
	}
#line 6581 "./out/parser.cc"
    break;

  case 361: /* context_def_mod: "\\consists"  */
#line 2827 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                 { yyval = ly_symbol2scm ("consists"); }
#line 6587 "./out/parser.cc"
    break;

  case 362: /* context_def_mod: "\\remove"  */
#line 2828 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                 { yyval = ly_symbol2scm ("remove"); }
#line 6593 "./out/parser.cc"
    break;

  case 363: /* context_def_mod: "\\accepts"  */
#line 2830 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                  { yyval = ly_symbol2scm ("accepts"); }
#line 6599 "./out/parser.cc"
    break;

  case 364: /* context_def_mod: "\\defaultchild"  */
#line 2831 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                       { yyval = ly_symbol2scm ("default-child"); }
#line 6605 "./out/parser.cc"
    break;

  case 365: /* context_def_mod: "\\denies"  */
#line 2832 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                 { yyval = ly_symbol2scm ("denies"); }
#line 6611 "./out/parser.cc"
    break;

  case 366: /* context_def_mod: "\\alias"  */
#line 2834 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                { yyval = ly_symbol2scm ("alias"); }
#line 6617 "./out/parser.cc"
    break;

  case 367: /* context_def_mod: "\\type"  */
#line 2835 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
               { yyval = ly_symbol2scm ("translator-type"); }
#line 6623 "./out/parser.cc"
    break;

  case 368: /* context_def_mod: "\\description"  */
#line 2836 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                      { yyval = ly_symbol2scm ("description"); }
#line 6629 "./out/parser.cc"
    break;

  case 369: /* context_def_mod: "\\name"  */
#line 2837 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
               { yyval = ly_symbol2scm ("context-name"); }
#line 6635 "./out/parser.cc"
    break;

  case 370: /* context_mod: property_operation  */
#line 2841 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                           { yyval = yyvsp[0]; }
#line 6641 "./out/parser.cc"
    break;

  case 371: /* context_mod: context_def_mod STRING  */
#line 2842 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                 {
		yyval = ly_list (yyvsp[-1], yyvsp[0]);
	}
#line 6649 "./out/parser.cc"
    break;

  case 372: /* context_mod: context_def_mod SYMBOL  */
#line 2845 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                 {
		yyval = ly_list (yyvsp[-1], yyvsp[0]);
	}
#line 6657 "./out/parser.cc"
    break;

  case 373: /* context_mod: context_def_mod embedded_scm  */
#line 2849 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		if (!scm_is_string (yyvsp[0])
		    && !scm_is_eq (yyvsp[-1], ly_symbol2scm ("consists"))
		    && !scm_is_eq (yyvsp[-1], ly_symbol2scm ("remove")))
		{
			yyval = SCM_EOL;
			parser->parser_error ((yylsp[-1]), _ ("only \\consists and \\remove take non-string argument."));
		}
		else
		{
			yyval = ly_list (yyvsp[-1], yyvsp[0]);
		}
	}
#line 6675 "./out/parser.cc"
    break;

  case 374: /* grob_prop_spec: symbol_list_rev  */
#line 2866 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = scm_reverse_x (yyvsp[0], SCM_EOL);
	}
#line 6683 "./out/parser.cc"
    break;

  case 375: /* grob_prop_path: grob_prop_spec  */
#line 2874 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		if (scm_is_pair (yyvsp[0])
		    && from_scm<bool>
		    (scm_object_property (scm_car (yyvsp[0]),
					  ly_symbol2scm ("is-grob?"))))
			yyval = scm_cons (ly_symbol2scm ("Bottom"), yyvsp[0]);
		if (!scm_is_pair (yyval)
		    || !scm_is_pair (scm_cdr (yyval))
		    || !scm_is_pair (scm_cddr (yyval)))
		{
			parser->parser_error ((yylsp[0]), _ ("bad grob property path"));
			yyval = SCM_UNDEFINED;
		}
	}
#line 6702 "./out/parser.cc"
    break;

  case 376: /* grob_prop_path: grob_prop_spec property_path  */
#line 2889 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		if (scm_is_pair (yyvsp[-1])
		    && from_scm<bool>
		    (scm_object_property (scm_car (yyvsp[-1]),
					  ly_symbol2scm ("is-grob?"))))
			yyval = scm_cons (ly_symbol2scm ("Bottom"), yyvsp[-1]);
		if (!scm_is_pair (yyval)
		    || !scm_is_pair (scm_cdr (yyval))
		    || scm_is_pair (scm_cddr (yyval))
		    || !scm_is_pair (yyvsp[0]))
		{
			parser->parser_error ((yylsp[-1]), _ ("bad grob property path"));
			yyval = SCM_UNDEFINED;
		} else {
			property_path_dot_warning ((yylsp[0]), ly_append (yyvsp[-1], yyvsp[0]));
			yyval = scm_append_x (ly_list (yyval, yyvsp[0]));
		}
	}
#line 6725 "./out/parser.cc"
    break;

  case 377: /* context_prop_spec: symbol_list_rev  */
#line 2912 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		SCM l = scm_reverse_x (yyvsp[0], SCM_EOL);
		switch (scm_ilength (l)) {
		case 1:
			l = scm_cons (ly_symbol2scm ("Bottom"), l);
		case 2:
			break;
		default:
			parser->parser_error ((yylsp[0]), _ ("bad context property path"));
			l = SCM_UNDEFINED;
		}
		yyval = l;
	}
#line 6743 "./out/parser.cc"
    break;

  case 378: /* simple_revert_context: symbol_list_part  */
#line 2944 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyvsp[0] = scm_reverse_x (yyvsp[0], SCM_EOL);
		if (scm_is_null (yyvsp[0])
		    || from_scm<bool>
		    (scm_object_property (scm_car (yyvsp[0]),
					  ly_symbol2scm ("is-grob?")))) {
			yyval = ly_symbol2scm ("Bottom");
			parser->lexer_->push_extra_token ((yylsp[0]), SCM_IDENTIFIER, yyvsp[0]);
		} else {
			yyval = scm_car (yyvsp[0]);
			parser->lexer_->push_extra_token ((yylsp[0]), SCM_IDENTIFIER,
							  scm_cdr (yyvsp[0]));
		}
	}
#line 6762 "./out/parser.cc"
    break;

  case 379: /* music_property_def: "\\override" grob_prop_path '=' scalar  */
#line 2961 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                           {
		if (SCM_UNBNDP (yyvsp[-2]))
			yyval = MAKE_SYNTAX (void_music, (yyloc));
		else
			yyval = MAKE_SYNTAX (property_override, (yyloc),
					  scm_car (yyvsp[-2]),
					  scm_cdr (yyvsp[-2]),
					  yyvsp[0]);
	}
#line 6776 "./out/parser.cc"
    break;

  case 380: /* music_property_def: "\\revert" simple_revert_context revert_arg  */
#line 2970 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                                  {
		yyval = MAKE_SYNTAX (property_revert, (yyloc), yyvsp[-1], yyvsp[0]);
	}
#line 6784 "./out/parser.cc"
    break;

  case 381: /* music_property_def: "\\set" context_prop_spec '=' scalar  */
#line 2973 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                           {
		if (SCM_UNBNDP (yyvsp[-2]))
			yyval = MAKE_SYNTAX (void_music, (yyloc));
		else
			yyval = MAKE_SYNTAX (property_set, (yyloc),
					  scm_car (yyvsp[-2]),
					  scm_cadr (yyvsp[-2]),
					  yyvsp[0]);
	}
#line 6798 "./out/parser.cc"
    break;

  case 382: /* music_property_def: "\\unset" context_prop_spec  */
#line 2982 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                  {
		if (SCM_UNBNDP (yyvsp[0]))
			yyval = MAKE_SYNTAX (void_music, (yyloc));
		else
			yyval = MAKE_SYNTAX (property_unset, (yyloc),
					  scm_car (yyvsp[0]),
					  scm_cadr (yyvsp[0]));
	}
#line 6811 "./out/parser.cc"
    break;

  case 389: /* text: embedded_scm_bare  */
#line 3003 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		if (Text_interface::is_markup (yyvsp[0])) {
			yyval = yyvsp[0];
		} else {
			parser->parser_error ((yylsp[0]), (_ ("markup expected")));
			yyval = scm_string (SCM_EOL);
		}
	}
#line 6824 "./out/parser.cc"
    break;

  case 392: /* simple_string: embedded_scm_bare  */
#line 3016 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		if (scm_is_string (yyvsp[0])) {
			yyval = yyvsp[0];
		} else {
			parser->parser_error ((yylsp[0]), (_ ("simple string expected")));
			yyval = scm_string (SCM_EOL);
		}
	}
#line 6837 "./out/parser.cc"
    break;

  case 393: /* symbol: STRING  */
#line 3027 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
               {
		yyval = scm_string_to_symbol (yyvsp[0]);
	}
#line 6845 "./out/parser.cc"
    break;

  case 394: /* symbol: SYMBOL  */
#line 3031 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		if (!is_regular_identifier (yyvsp[0], false))
			parser->parser_error ((yylsp[0]), (_ ("symbol expected")));
		yyval = scm_string_to_symbol (yyvsp[0]);
	}
#line 6855 "./out/parser.cc"
    break;

  case 395: /* symbol: embedded_scm_bare  */
#line 3037 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		// This is a bit of overkill but makes the same
		// routine responsible for all symbol interpretations.
		yyval = try_string_variants (Guile_user::symbol_p, yyvsp[0]);
		if (SCM_UNBNDP (yyval))
		{
			parser->parser_error ((yylsp[0]), (_ ("symbol expected")));
			// Generate a unique symbol in case it is used
			// for an assignment or similar
			yyval = scm_make_symbol (ly_string2scm ("undefined"));
		}
	}
#line 6872 "./out/parser.cc"
    break;

  case 400: /* scalar: '-' bare_number  */
#line 3064 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = scm_difference (yyvsp[0], SCM_UNDEFINED);
	}
#line 6880 "./out/parser.cc"
    break;

  case 402: /* scalar: symbol_list_part_bare '.' property_path  */
#line 3069 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = scm_reverse_x (yyvsp[-2], yyvsp[0]);
	}
#line 6888 "./out/parser.cc"
    break;

  case 403: /* scalar: symbol_list_part_bare ',' property_path  */
#line 3073 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = scm_reverse_x (yyvsp[-2], yyvsp[0]);
	}
#line 6896 "./out/parser.cc"
    break;

  case 404: /* event_chord: simple_element post_events  */
#line 3079 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                   {
		// Let the rhythmic music iterator sort this mess out.
		if (scm_is_pair (yyvsp[0])) {
			set_property (unsmob<Music> (yyval), "articulations",
							 scm_reverse_x (yyvsp[0], SCM_EOL));
		}
	}
#line 6908 "./out/parser.cc"
    break;

  case 405: /* event_chord: CHORD_REPETITION optional_notemode_duration post_events  */
#line 3086 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                                                  {
		yyval = MAKE_SYNTAX (repetition_chord, (yyloc),
				  yyvsp[-1], scm_reverse_x (yyvsp[0], SCM_EOL));
	}
#line 6917 "./out/parser.cc"
    break;

  case 406: /* event_chord: MULTI_MEASURE_REST optional_notemode_duration post_events  */
#line 3090 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                                                    {
		yyval = MAKE_SYNTAX (multi_measure_rest, (yyloc), yyvsp[-1],
				  scm_reverse_x (yyvsp[0], SCM_EOL));
	}
#line 6926 "./out/parser.cc"
    break;

  case 409: /* note_chord_element: chord_body optional_notemode_duration post_events  */
#line 3101 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		Music *m = unsmob<Music> (yyvsp[-2]);
		SCM dur = unsmob<Duration> (yyvsp[-1])->smobbed_copy ();
		SCM es = get_property (m, "elements");
		SCM postevs = scm_reverse_x (yyvsp[0], SCM_EOL);

		for (SCM s = es; scm_is_pair (s); s = scm_cdr (s))
			set_property (unsmob<Music> (scm_car (s)), "duration", dur);
		es = ly_append (es, postevs);

		set_property (m, "elements", es);
		m->set_spot (parser->lexer_->override_input ((yyloc)));
		yyval = m->self_scm ();
	}
#line 6945 "./out/parser.cc"
    break;

  case 410: /* chord_body: "<" chord_body_elements ">"  */
#line 3119 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = MAKE_SYNTAX (event_chord, (yyloc),
				  reverse_music_list (parser, (yyloc),
						      yyvsp[-1], false, false));
	}
#line 6955 "./out/parser.cc"
    break;

  case 411: /* chord_body: FIGURE_OPEN figure_list FIGURE_CLOSE  */
#line 3125 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = MAKE_SYNTAX (event_chord, (yyloc), scm_reverse_x (yyvsp[-1], SCM_EOL));
	}
#line 6963 "./out/parser.cc"
    break;

  case 412: /* chord_body_elements: %empty  */
#line 3131 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                { yyval = SCM_EOL; }
#line 6969 "./out/parser.cc"
    break;

  case 413: /* chord_body_elements: chord_body_elements chord_body_element  */
#line 3132 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                                 {
		if (unsmob<Music> (yyvsp[0]))
			yyval = scm_cons (yyvsp[0], yyvsp[-1]);
	}
#line 6978 "./out/parser.cc"
    break;

  case 414: /* chord_body_element: pitch_or_tonic_pitch exclamations questions octave_check post_events  */
#line 3140 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		bool q = from_scm<bool> (yyvsp[-2]);
		bool ex = from_scm<bool> (yyvsp[-3]);
		SCM check = yyvsp[-1];
		SCM post = yyvsp[0];

		Music *n = MY_MAKE_MUSIC ("NoteEvent", (yyloc));
		set_property (n, "pitch", yyvsp[-4]);
		if (q)
			set_property (n, "cautionary", SCM_BOOL_T);
                if (ex || q)
			set_property (n, "force-accidental", SCM_BOOL_T);

		if (scm_is_pair (post)) {
			SCM arts = scm_reverse_x (post, SCM_EOL);
			set_property (n, "articulations", arts);
		}
		if (scm_is_number (check))
		{
			int q = from_scm<int> (check);
			set_property (n, "absolute-octave", to_scm (q-1));
		}

		yyval = n->unprotect ();
	}
#line 7008 "./out/parser.cc"
    break;

  case 415: /* chord_body_element: DRUM_PITCH post_events  */
#line 3165 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                           {
		Music *n = MY_MAKE_MUSIC ("NoteEvent", (yyloc));
		set_property (n, "drum-type", yyvsp[-1]);

		if (scm_is_pair (yyvsp[0])) {
			SCM arts = scm_reverse_x (yyvsp[0], SCM_EOL);
			set_property (n, "articulations", arts);
		}
		yyval = n->unprotect ();
	}
#line 7023 "./out/parser.cc"
    break;

  case 416: /* chord_body_element: music_function_chord_body  */
#line 3176 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		Music *m = unsmob<Music> (yyvsp[0]);

		if (m && !m->is_mus_type ("post-event")) {
			while (m && m->is_mus_type ("music-wrapper-music")) {
				yyval = get_property (m, "element");
				m = unsmob<Music> (yyval);
			}

			if (!(m && m->is_mus_type ("rhythmic-event"))) {
				parser->parser_error ((yyloc), _ ("not a rhythmic event"));
				yyval = SCM_UNSPECIFIED;
			}
		}
	}
#line 7043 "./out/parser.cc"
    break;

  case 421: /* event_function_event: EVENT_FUNCTION function_arglist  */
#line 3201 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                        {
		yyval = MAKE_SYNTAX (music_function, (yyloc),
				  yyvsp[-1], yyvsp[0]);
	}
#line 7052 "./out/parser.cc"
    break;

  case 422: /* post_events: %empty  */
#line 3208 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                    {
		yyval = SCM_EOL;
	}
#line 7060 "./out/parser.cc"
    break;

  case 423: /* post_events: post_events post_event  */
#line 3211 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                 {
		yyval = post_event_cons (yyvsp[0], yyvsp[-1]);
	}
#line 7068 "./out/parser.cc"
    break;

  case 424: /* post_event_nofinger: direction_less_event  */
#line 3217 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                             {
		yyval = yyvsp[0];
	}
#line 7076 "./out/parser.cc"
    break;

  case 425: /* post_event_nofinger: script_dir music_function_call  */
#line 3220 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                         {
		Music *m = unsmob<Music> (yyvsp[0]);
		if (!m->is_mus_type ("post-event")) {
			parser->parser_error ((yylsp[0]), _ ("post-event expected"));
			yyval = SCM_UNSPECIFIED;
		} else {
			m->set_spot (parser->lexer_->override_input ((yyloc)));
			if (!SCM_UNBNDP (yyvsp[-1]))
				set_property (m, "direction", yyvsp[-1]);
			yyval = yyvsp[0];
		}
	}
#line 7093 "./out/parser.cc"
    break;

  case 426: /* post_event_nofinger: "--"  */
#line 3232 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                 {
		if (!parser->lexer_->is_lyric_state ())
			parser->parser_error ((yylsp[0]), _ ("have to be in Lyric mode for lyrics"));
		yyval = MY_MAKE_MUSIC ("HyphenEvent", (yyloc))->unprotect ();
	}
#line 7103 "./out/parser.cc"
    break;

  case 427: /* post_event_nofinger: "__"  */
#line 3237 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                   {
		if (!parser->lexer_->is_lyric_state ())
			parser->parser_error ((yylsp[0]), _ ("have to be in Lyric mode for lyrics"));
		yyval = MY_MAKE_MUSIC ("ExtenderEvent", (yyloc))->unprotect ();
	}
#line 7113 "./out/parser.cc"
    break;

  case 428: /* post_event_nofinger: script_dir direction_reqd_event  */
#line 3242 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                          {
		if (Music *m = unsmob<Music> (yyvsp[0])) {
			m->set_spot (parser->lexer_->override_input ((yyloc)));
			if (!SCM_UNBNDP (yyvsp[-1]))
			{
				set_property (m, "direction", yyvsp[-1]);
			}
		}
		yyval = yyvsp[0];
	}
#line 7128 "./out/parser.cc"
    break;

  case 429: /* post_event_nofinger: script_dir direction_less_event  */
#line 3252 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                          {
		Music *m = unsmob<Music> (yyvsp[0]);
		m->set_spot (parser->lexer_->override_input ((yyloc)));
		if (!SCM_UNBNDP (yyvsp[-1]))
			set_property (m, "direction", yyvsp[-1]);
		yyval = yyvsp[0];
	}
#line 7140 "./out/parser.cc"
    break;

  case 430: /* post_event_nofinger: '^' fingering  */
#line 3260 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		Music *m = unsmob<Music> (yyvsp[0]);
		m->set_spot (parser->lexer_->override_input ((yyloc)));
		set_property (m, "direction", to_scm (UP));
		yyval = yyvsp[0];
	}
#line 7151 "./out/parser.cc"
    break;

  case 431: /* post_event_nofinger: '_' fingering  */
#line 3267 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		Music *m = unsmob<Music> (yyvsp[0]);
		m->set_spot (parser->lexer_->override_input ((yyloc)));
		set_property (m, "direction", to_scm (DOWN));
		yyval = yyvsp[0];
	}
#line 7162 "./out/parser.cc"
    break;

  case 433: /* post_event: '-' fingering  */
#line 3277 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                        {
		unsmob<Music> (yyvsp[0])->set_spot (parser->lexer_->override_input ((yyloc)));
		yyval = yyvsp[0];
	}
#line 7171 "./out/parser.cc"
    break;

  case 434: /* string_number_event: E_UNSIGNED  */
#line 3284 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                   {
		Music *s = MY_MAKE_MUSIC ("StringNumberEvent", (yyloc));
		set_property (s, "string-number", yyvsp[0]);
		yyval = s->unprotect ();
	}
#line 7181 "./out/parser.cc"
    break;

  case 436: /* direction_less_event: EVENT_IDENTIFIER  */
#line 3293 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                {
		yyval = yyvsp[0];
	}
#line 7189 "./out/parser.cc"
    break;

  case 437: /* direction_less_event: tremolo_type  */
#line 3296 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                        {
               Music *a = MY_MAKE_MUSIC ("TremoloEvent", (yyloc));
               set_property (a, "tremolo-type", yyvsp[0]);
               yyval = a->unprotect ();
        }
#line 7199 "./out/parser.cc"
    break;

  case 439: /* direction_reqd_event: gen_text_def  */
#line 3305 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                     {
		yyval = yyvsp[0];
	}
#line 7207 "./out/parser.cc"
    break;

  case 440: /* direction_reqd_event: script_abbreviation  */
#line 3308 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                              {
		SCM sym = ly_symbol2scm ("dash" + ly_scm2string (yyvsp[0]));
		SCM s = parser->lexer_->lookup_identifier_symbol (sym);
		Music *original = unsmob<Music> (s);
		if (original && original->is_mus_type ("post-event")) {
			Music *a = original->clone ();
			// origin will be set by post_event_nofinger
			yyval = a->unprotect ();
// -----------------------------------------------------------------
// obsoletion handling, may be removed at some point (e.g. for 2.26)
		} else if (scm_is_string (s)) {
			string s_string = ly_scm2string (s);
			(yyloc).warning (_f ("Re-defining dash%s using a string is deprecated. \
Please try replacing \"%s\" by \\%s or run convert-ly.",
				ly_scm2string (yyvsp[0]), s_string, s_string));
			Music *a = MY_MAKE_MUSIC ("ArticulationEvent", (yyloc));
			set_property (a, "articulation-type", scm_string_to_symbol (s));
			yyval = a->unprotect ();
// -----------------------------------------------------------------
		} else {
			parser->parser_error ((yylsp[0]), _ ("expecting post-event as script definition"));
			yyval = SCM_UNSPECIFIED;
		}
	}
#line 7236 "./out/parser.cc"
    break;

  case 441: /* octave_check: %empty  */
#line 3335 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
             { yyval = SCM_EOL; }
#line 7242 "./out/parser.cc"
    break;

  case 442: /* octave_check: '=' quotes  */
#line 3336 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                     { yyval = yyvsp[0]; }
#line 7248 "./out/parser.cc"
    break;

  case 443: /* quotes: %empty  */
#line 3341 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
                yyval = SCM_INUM0;
	}
#line 7256 "./out/parser.cc"
    break;

  case 446: /* erroneous_quotes: quotes  */
#line 3350 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
               {
		if (scm_is_eq (SCM_INUM0, yyvsp[0]))
			yyval = SCM_UNDEFINED;
	}
#line 7265 "./out/parser.cc"
    break;

  case 447: /* sup_quotes: '\''  */
#line 3357 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
             {
		yyval = to_scm (1);
	}
#line 7273 "./out/parser.cc"
    break;

  case 448: /* sup_quotes: sup_quotes '\''  */
#line 3360 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                          {
		yyval = scm_oneplus (yyvsp[-1]);
	}
#line 7281 "./out/parser.cc"
    break;

  case 449: /* sub_quotes: ','  */
#line 3366 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
            {
		yyval = to_scm (-1);
	}
#line 7289 "./out/parser.cc"
    break;

  case 450: /* sub_quotes: sub_quotes ','  */
#line 3369 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                         {
		yyval = scm_oneminus (yyvsp[-1]);
	}
#line 7297 "./out/parser.cc"
    break;

  case 451: /* steno_pitch: NOTENAME_PITCH quotes  */
#line 3375 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                              {
                if (!scm_is_eq (SCM_INUM0, yyvsp[0]))
                {
                        Pitch p = *unsmob<Pitch> (yyvsp[-1]);
                        p = p.transposed (Pitch (from_scm<int> (yyvsp[0]), 0));
                        yyval = p.smobbed_copy ();
                }
	}
#line 7310 "./out/parser.cc"
    break;

  case 452: /* steno_tonic_pitch: TONICNAME_PITCH quotes  */
#line 3390 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                               {
                if (!scm_is_eq (SCM_INUM0, yyvsp[0]))
                {
                        Pitch p = *unsmob<Pitch> (yyvsp[-1]);
                        p = p.transposed (Pitch (from_scm<int> (yyvsp[0]), 0));
                        yyval = p.smobbed_copy ();
                }
	}
#line 7323 "./out/parser.cc"
    break;

  case 454: /* pitch: PITCH_IDENTIFIER quotes  */
#line 3402 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                  {
                if (!scm_is_eq (SCM_INUM0, yyvsp[0]))
                {
                        Pitch p = *unsmob<Pitch> (yyvsp[-1]);
                        p = p.transposed (Pitch (from_scm<int> (yyvsp[0]), 0));
                        yyval = p.smobbed_copy ();
                }
	}
#line 7336 "./out/parser.cc"
    break;

  case 457: /* gen_text_def: full_markup  */
#line 3418 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                    {
		Music *t = MY_MAKE_MUSIC ("TextScriptEvent", (yyloc));
		set_property (t, "text", yyvsp[0]);
		yyval = t->unprotect ();
	}
#line 7346 "./out/parser.cc"
    break;

  case 458: /* gen_text_def: STRING  */
#line 3423 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                 {
		Music *t = MY_MAKE_MUSIC ("TextScriptEvent", (yyloc));
		set_property (t, "text",
			make_simple_markup (yyvsp[0]));
		yyval = t->unprotect ();
	}
#line 7357 "./out/parser.cc"
    break;

  case 459: /* gen_text_def: SYMBOL  */
#line 3429 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                 {
		// Flag a warning? could be unintentional
		Music *t = MY_MAKE_MUSIC ("TextScriptEvent", (yyloc));
		set_property (t, "text",
			make_simple_markup (yyvsp[0]));
		yyval = t->unprotect ();
	}
#line 7369 "./out/parser.cc"
    break;

  case 460: /* gen_text_def: embedded_scm  */
#line 3437 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		// Could be using this for every gen_text_def but for speed
		yyval = MAKE_SYNTAX (create_script, (yylsp[0]), yyvsp[0]);
	}
#line 7378 "./out/parser.cc"
    break;

  case 461: /* fingering: UNSIGNED  */
#line 3444 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                 {
		Music *t = MY_MAKE_MUSIC ("FingeringEvent", (yyloc));
		set_property (t, "digit", yyvsp[0]);
		yyval = t->unprotect ();
	}
#line 7388 "./out/parser.cc"
    break;

  case 462: /* script_abbreviation: '^'  */
#line 3452 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                        {
		yyval = scm_from_latin1_string ("Hat");
	}
#line 7396 "./out/parser.cc"
    break;

  case 463: /* script_abbreviation: '+'  */
#line 3455 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                        {
		yyval = scm_from_latin1_string ("Plus");
	}
#line 7404 "./out/parser.cc"
    break;

  case 464: /* script_abbreviation: '-'  */
#line 3458 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                        {
		yyval = scm_from_latin1_string ("Dash");
	}
#line 7412 "./out/parser.cc"
    break;

  case 465: /* script_abbreviation: '!'  */
#line 3461 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                        {
		yyval = scm_from_latin1_string ("Bang");
	}
#line 7420 "./out/parser.cc"
    break;

  case 466: /* script_abbreviation: ">"  */
#line 3464 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                        {
		yyval = scm_from_latin1_string ("Larger");
	}
#line 7428 "./out/parser.cc"
    break;

  case 467: /* script_abbreviation: '.'  */
#line 3467 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                        {
		yyval = scm_from_latin1_string ("Dot");
	}
#line 7436 "./out/parser.cc"
    break;

  case 468: /* script_abbreviation: '_'  */
#line 3470 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
              {
		yyval = scm_from_latin1_string ("Underscore");
	}
#line 7444 "./out/parser.cc"
    break;

  case 469: /* script_dir: '_'  */
#line 3476 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                { yyval = to_scm (DOWN); }
#line 7450 "./out/parser.cc"
    break;

  case 470: /* script_dir: '^'  */
#line 3477 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                { yyval = to_scm (UP); }
#line 7456 "./out/parser.cc"
    break;

  case 471: /* script_dir: '-'  */
#line 3478 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                { yyval = SCM_UNDEFINED; }
#line 7462 "./out/parser.cc"
    break;

  case 472: /* maybe_notemode_duration: %empty  */
#line 3482 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = SCM_UNDEFINED;
	}
#line 7470 "./out/parser.cc"
    break;

  case 473: /* maybe_notemode_duration: duration  */
#line 3485 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                        {
		yyval = yyvsp[0];
		parser->default_duration_ = *unsmob<Duration> (yyval);
	}
#line 7479 "./out/parser.cc"
    break;

  case 474: /* optional_notemode_duration: maybe_notemode_duration  */
#line 3494 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		if (SCM_UNBNDP (yyval))
			yyval = parser->default_duration_.smobbed_copy ();
	}
#line 7488 "./out/parser.cc"
    break;

  case 475: /* steno_duration: UNSIGNED dots  */
#line 3501 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                {
		yyval = make_duration (yyvsp[-1], from_scm<int> (yyvsp[0]));
		if (SCM_UNBNDP (yyval))
		{
			parser->parser_error ((yylsp[-1]), _ ("not a duration"));
			yyval = Duration ().smobbed_copy ();
		}
	}
#line 7501 "./out/parser.cc"
    break;

  case 476: /* steno_duration: DURATION_IDENTIFIER dots  */
#line 3509 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                        {
		yyval = make_duration (yyvsp[-1], from_scm<int> (yyvsp[0]));
	}
#line 7509 "./out/parser.cc"
    break;

  case 477: /* duration: steno_duration multipliers  */
#line 3515 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                   {
		yyval = make_duration (yyvsp[-1], 0, yyvsp[0]);
	}
#line 7517 "./out/parser.cc"
    break;

  case 478: /* dots: %empty  */
#line 3521 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                        {
		yyval = SCM_INUM0;
	}
#line 7525 "./out/parser.cc"
    break;

  case 479: /* dots: dots '.'  */
#line 3524 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                   {
		yyval = scm_oneplus (yyvsp[-1]);
	}
#line 7533 "./out/parser.cc"
    break;

  case 482: /* multipliers: %empty  */
#line 3536 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = SCM_UNDEFINED;
	}
#line 7541 "./out/parser.cc"
    break;

  case 483: /* multipliers: multipliers '*' UNSIGNED  */
#line 3540 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		if (!SCM_UNBNDP (yyvsp[-2]))
			yyval = scm_product (yyvsp[-2], yyvsp[0]);
		else
			yyval = yyvsp[0];
	}
#line 7552 "./out/parser.cc"
    break;

  case 484: /* multipliers: multipliers '*' FRACTION  */
#line 3547 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		if (!SCM_UNBNDP (yyvsp[-2]))
			yyval = scm_product (yyvsp[-2], scm_divide (scm_car (yyvsp[0]),
							  scm_cdr (yyvsp[0])));
		else
			yyval = scm_divide (scm_car (yyvsp[0]), scm_cdr (yyvsp[0]));
	}
#line 7564 "./out/parser.cc"
    break;

  case 485: /* multipliers: multipliers '*' multiplier_scm  */
#line 3555 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		if (scm_is_false (Lily::scale_p (yyvsp[0])))
		{
			parser->parser_error ((yylsp[0]), _ ("not a multiplier"));
		} else if (SCM_UNBNDP (yyvsp[-2]))
			yyval = Lily::scale_to_factor (yyvsp[0]);
		else
			yyval = scm_product (yyvsp[-2], Lily::scale_to_factor (yyvsp[0]));
	}
#line 7578 "./out/parser.cc"
    break;

  case 486: /* tremolo_type: ':'  */
#line 3567 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                {
		yyval = to_scm (parser->default_tremolo_type_);
	}
#line 7586 "./out/parser.cc"
    break;

  case 487: /* tremolo_type: ':' UNSIGNED  */
#line 3570 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                       {
		if (SCM_UNBNDP (make_duration (yyvsp[0]))) {
			parser->parser_error ((yylsp[0]), _ ("not a duration"));
			yyval = to_scm (parser->default_tremolo_type_);
		} else {
			yyval = yyvsp[0];
			parser->default_tremolo_type_ = from_scm<int> (yyvsp[0]);
		}
	}
#line 7600 "./out/parser.cc"
    break;

  case 492: /* bass_number: embedded_scm_bare  */
#line 3587 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		// as an integer, it needs to be non-negative, and otherwise
		// it needs to be suitable as a markup.
		if (scm_is_integer (yyvsp[0])
		    ? scm_is_true (scm_negative_p (yyvsp[0]))
		    : !Text_interface::is_markup (yyvsp[0]))
		{
			parser->parser_error ((yylsp[0]), _ ("bass number expected"));
			yyval = SCM_INUM0;
		}
	}
#line 7616 "./out/parser.cc"
    break;

  case 493: /* bass_figure: "_"  */
#line 3601 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                     {
		Music *bfr = MY_MAKE_MUSIC ("BassFigureEvent", (yyloc));
		yyval = bfr->unprotect ();
	}
#line 7625 "./out/parser.cc"
    break;

  case 494: /* bass_figure: bass_number  */
#line 3605 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                       {
		Music *bfr = MY_MAKE_MUSIC ("BassFigureEvent", (yyloc));
		yyval = bfr->self_scm ();

		if (scm_is_number (yyvsp[0]))
			set_property (bfr, "figure", yyvsp[0]);
		else if (Text_interface::is_markup (yyvsp[0]))
			set_property (bfr, "text", yyvsp[0]);

		bfr->unprotect ();
	}
#line 7641 "./out/parser.cc"
    break;

  case 495: /* bass_figure: bass_figure ']'  */
#line 3616 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                          {
		yyval = yyvsp[-1];
		set_property (unsmob<Music> (yyvsp[-1]), "bracket-stop", SCM_BOOL_T);
	}
#line 7650 "./out/parser.cc"
    break;

  case 496: /* bass_figure: bass_figure FIGURE_ALTERATION_EXPR  */
#line 3620 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                             {
		Music *m = unsmob<Music> (yyvsp[-1]);

		if (scm_is_number (get_property (m, "alteration")))
			m->warning (_f ("Dropping surplus alteration symbols for bass figure."));
		else {
			string alter_expr = ly_scm2string (yyvsp[0]);
			Rational alter (0);
			bool bracket = false;

			for (string::iterator it=alter_expr.begin(); it != alter_expr.end (); it++)
			{
				int c = *it & 0xff;

				/* The friendly lexer guarantees that '[' has its matching ']',
				   so we don't have to check here. */
				if (c == '[')		bracket = true;

				/* "!" resets the counter: we mimic this traditional (pre-2.23.4) behavior. */
				else if (c == '!')	alter = 0;
				else if (c == '+')	alter += SHARP_ALTERATION;
				else if (c == '-')	alter += FLAT_ALTERATION;
			}

			set_property (m, "alteration", to_scm (alter));
			if (bracket)
				set_property (m, "alteration-bracket", SCM_BOOL_T);
		}
	}
#line 7684 "./out/parser.cc"
    break;

  case 497: /* bass_figure: bass_figure figured_bass_modification  */
#line 3649 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                                 {
		Music *m = unsmob<Music> (yyvsp[-1]);
		set_property (m, yyvsp[0], SCM_BOOL_T);
	}
#line 7693 "./out/parser.cc"
    break;

  case 498: /* figured_bass_modification: "\\+"  */
#line 3657 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                        {
		yyval = ly_symbol2scm ("augmented");
	}
#line 7701 "./out/parser.cc"
    break;

  case 499: /* figured_bass_modification: "\\!"  */
#line 3660 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                        {
		yyval = ly_symbol2scm ("no-continuation");
	}
#line 7709 "./out/parser.cc"
    break;

  case 500: /* figured_bass_modification: '/'  */
#line 3663 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                        {
		yyval = ly_symbol2scm ("diminished");
	}
#line 7717 "./out/parser.cc"
    break;

  case 501: /* figured_bass_modification: "\\\\"  */
#line 3666 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                      {
		yyval = ly_symbol2scm ("augmented-slash");
	}
#line 7725 "./out/parser.cc"
    break;

  case 502: /* br_bass_figure: bass_figure  */
#line 3672 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                    {
		yyval = yyvsp[0];
	}
#line 7733 "./out/parser.cc"
    break;

  case 503: /* br_bass_figure: '[' bass_figure  */
#line 3675 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                          {
		yyval = yyvsp[0];
		set_property (unsmob<Music> (yyval), "bracket-start", SCM_BOOL_T);
	}
#line 7742 "./out/parser.cc"
    break;

  case 504: /* figure_list: %empty  */
#line 3682 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                        {
		yyval = SCM_EOL;
	}
#line 7750 "./out/parser.cc"
    break;

  case 505: /* figure_list: figure_list br_bass_figure  */
#line 3685 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                     {
		yyval = scm_cons (yyvsp[0], yyvsp[-1]);
	}
#line 7758 "./out/parser.cc"
    break;

  case 506: /* optional_rest: %empty  */
#line 3691 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
               { yyval = SCM_BOOL_F; }
#line 7764 "./out/parser.cc"
    break;

  case 507: /* optional_rest: "\\rest"  */
#line 3692 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
               { yyval = SCM_BOOL_T; }
#line 7770 "./out/parser.cc"
    break;

  case 508: /* pitch_or_music: pitch exclamations questions octave_check maybe_notemode_duration erroneous_quotes optional_rest post_events  */
#line 3700 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                                                                                                     {
		if (!parser->lexer_->is_note_state ())
			parser->parser_error ((yylsp[-7]), _ ("have to be in Note mode for notes"));
		if (!SCM_UNBNDP (yyvsp[-2]))
		{
			// It's possible to get here without a
			// duration, like when there is no
			// octave_check but a question mark.  But we
			// point out the most frequent error of an
			// interspersed duration specifically
			if (!SCM_UNBNDP (yyvsp[-3]))
				parser->parser_error ((yylsp[-2]), _ ("octave marks must precede duration"));
			else
				parser->parser_error ((yylsp[-2]), _ ("badly placed octave marks"));
			// Try sorting the quotes to where they likely belong
			if (scm_is_number (yyvsp[-4])) {
				yyvsp[-4] = scm_sum (yyvsp[-4], yyvsp[-2]);
			} else {
				yyvsp[-7] = unsmob<Pitch> (yyvsp[-7])->transposed
					(Pitch (from_scm<int> (yyvsp[-2]), 0)).smobbed_copy ();
			}
		}

		if (!SCM_UNBNDP (yyvsp[-6])
                    || !SCM_UNBNDP (yyvsp[-5])
                    || scm_is_number (yyvsp[-4])
                    || !SCM_UNBNDP (yyvsp[-3])
		    || scm_is_true (yyvsp[-1])
		    || scm_is_pair (yyvsp[0]))
		{
			Music *n = 0;
			if (scm_is_true (yyvsp[-1]))
				n = MY_MAKE_MUSIC ("RestEvent", (yyloc));
			else
				n = MY_MAKE_MUSIC ("NoteEvent", (yyloc));

			set_property (n, "pitch", yyvsp[-7]);
			if (SCM_UNBNDP (yyvsp[-3]))
				set_property (n, "duration",
						 parser->default_duration_.smobbed_copy ());
			else
				set_property (n, "duration", yyvsp[-3]);

			if (scm_is_number (yyvsp[-4]))
			{
				int q = from_scm<int> (yyvsp[-4]);
				set_property (n, "absolute-octave", to_scm (q-1));
			}

			if (from_scm<bool> (yyvsp[-5]))
				set_property (n, "cautionary", SCM_BOOL_T);
			if (from_scm<bool> (yyvsp[-6]) || from_scm<bool> (yyvsp[-5]))
				set_property (n, "force-accidental", SCM_BOOL_T);
			if (scm_is_pair (yyvsp[0]))
				set_property (n, "articulations",
						 scm_reverse_x (yyvsp[0], SCM_EOL));
			yyval = n->unprotect ();
		}
	}
#line 7834 "./out/parser.cc"
    break;

  case 509: /* pitch_or_music: new_chord post_events  */
#line 3759 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                {
		if (!parser->lexer_->is_chord_state ())
                        parser->parser_error ((yylsp[-1]), _ ("have to be in Chord mode for chords"));
		if (scm_is_pair (yyvsp[0])) {
			if (unsmob<Pitch> (yyvsp[-1]))
				yyvsp[-1] = make_chord_elements ((yylsp[-1]),
							  yyvsp[-1],
							  parser->default_duration_.smobbed_copy (),
							  SCM_EOL);

			SCM elts = ly_append (yyvsp[-1], scm_reverse_x (yyvsp[0], SCM_EOL));

			yyval = MAKE_SYNTAX (event_chord, (yylsp[-1]), elts);
		} else if (!unsmob<Pitch> (yyvsp[-1]))
			yyval = MAKE_SYNTAX (event_chord, (yylsp[-1]), yyvsp[-1]);
		// A mere pitch drops through.
	}
#line 7856 "./out/parser.cc"
    break;

  case 510: /* simple_element: DRUM_PITCH optional_notemode_duration  */
#line 3779 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                              {
		Music *n = MY_MAKE_MUSIC ("NoteEvent", (yyloc));
		set_property (n, "duration", yyvsp[0]);
		set_property (n, "drum-type", yyvsp[-1]);

		yyval = n->unprotect ();
	}
#line 7868 "./out/parser.cc"
    break;

  case 511: /* simple_element: RESTNAME optional_notemode_duration  */
#line 3786 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                                        {
		Music *ev = 0;
 		if (ly_scm2string (yyvsp[-1]) == "s") {
			/* Space */
			ev = MY_MAKE_MUSIC ("SkipEvent", (yyloc));
		  }
		else {
			ev = MY_MAKE_MUSIC ("RestEvent", (yyloc));

		    }
		set_property (ev, "duration", yyvsp[0]);
 		yyval = ev->unprotect ();
	}
#line 7886 "./out/parser.cc"
    break;

  case 512: /* lyric_element: full_markup  */
#line 3802 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                    {
		if (!parser->lexer_->is_lyric_state ())
			parser->parser_error ((yylsp[0]), _ ("markup outside of text script or \\lyricmode"));
		yyval = yyvsp[0];
	}
#line 7896 "./out/parser.cc"
    break;

  case 513: /* lyric_element: SYMBOL  */
#line 3807 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                 {
		if (!parser->lexer_->is_lyric_state ())
			parser->parser_error ((yylsp[0]), _f ("not a note name: %s", ly_scm2string (yyvsp[0])));
		yyval = yyvsp[0];
	}
#line 7906 "./out/parser.cc"
    break;

  case 514: /* lyric_element: STRING  */
#line 3812 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                 {
		if (!parser->lexer_->is_lyric_state ())
			parser->parser_error ((yylsp[0]), _ ("string outside of text script or \\lyricmode"));
		yyval = yyvsp[0];
	}
#line 7916 "./out/parser.cc"
    break;

  case 516: /* lyric_element_music: lyric_element optional_notemode_duration post_events  */
#line 3821 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                                             {
		yyval = MAKE_SYNTAX (lyric_event, (yyloc), yyvsp[-2], yyvsp[-1]);
		if (scm_is_pair (yyvsp[0]))
			set_property
				(unsmob<Music> (yyval), "articulations", scm_reverse_x (yyvsp[0], SCM_EOL));
	}
#line 7927 "./out/parser.cc"
    break;

  case 517: /* new_chord: steno_tonic_pitch maybe_notemode_duration  */
#line 3831 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                                    {
		if (SCM_UNBNDP (yyvsp[0]))
			yyval = yyvsp[-1];
		else
			yyval = make_chord_elements ((yyloc), yyvsp[-1], yyvsp[0], SCM_EOL);
	}
#line 7938 "./out/parser.cc"
    break;

  case 518: /* new_chord: steno_tonic_pitch optional_notemode_duration chord_separator chord_items  */
#line 3837 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                                                                   {
		SCM its = scm_reverse_x (yyvsp[0], SCM_EOL);
		yyval = make_chord_elements ((yyloc), yyvsp[-3], yyvsp[-2], scm_cons (yyvsp[-1], its));
	}
#line 7947 "./out/parser.cc"
    break;

  case 519: /* chord_items: %empty  */
#line 3844 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
             {
		yyval = SCM_EOL;
	}
#line 7955 "./out/parser.cc"
    break;

  case 520: /* chord_items: chord_items chord_item  */
#line 3847 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                 {
		yyval = scm_cons (yyvsp[0], yyval);
	}
#line 7963 "./out/parser.cc"
    break;

  case 521: /* chord_separator: ":"  */
#line 3853 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                    {
		yyval = ly_symbol2scm ("chord-colon");
	}
#line 7971 "./out/parser.cc"
    break;

  case 522: /* chord_separator: "^"  */
#line 3856 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                      {
		yyval = ly_symbol2scm ("chord-caret");
	}
#line 7979 "./out/parser.cc"
    break;

  case 523: /* chord_separator: "/" steno_tonic_pitch  */
#line 3859 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                        {
 		yyval = ly_list (ly_symbol2scm ("chord-slash"), yyvsp[0]);
	}
#line 7987 "./out/parser.cc"
    break;

  case 524: /* chord_separator: "/+" steno_tonic_pitch  */
#line 3862 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                       {
		yyval = ly_list (ly_symbol2scm ("chord-bass"), yyvsp[0]);
	}
#line 7995 "./out/parser.cc"
    break;

  case 525: /* chord_item: chord_separator  */
#line 3868 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                        {
		yyval = yyvsp[0];
	}
#line 8003 "./out/parser.cc"
    break;

  case 526: /* chord_item: step_numbers  */
#line 3871 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                       {
		yyval = scm_reverse_x (yyvsp[0], SCM_EOL);
	}
#line 8011 "./out/parser.cc"
    break;

  case 527: /* chord_item: CHORD_MODIFIER  */
#line 3874 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                          {
		yyval = yyvsp[0];
	}
#line 8019 "./out/parser.cc"
    break;

  case 528: /* step_numbers: step_number  */
#line 3880 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                    { yyval = scm_cons (yyvsp[0], SCM_EOL); }
#line 8025 "./out/parser.cc"
    break;

  case 529: /* step_numbers: step_numbers '.' step_number  */
#line 3881 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                       {
		yyval = scm_cons (yyvsp[0], yyval);
	}
#line 8033 "./out/parser.cc"
    break;

  case 530: /* step_number: UNSIGNED  */
#line 3887 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                 {
		yyval = make_chord_step (yyvsp[0], 0);
        }
#line 8041 "./out/parser.cc"
    break;

  case 531: /* step_number: UNSIGNED '+'  */
#line 3890 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                       {
		yyval = make_chord_step (yyvsp[-1], SHARP_ALTERATION);
	}
#line 8049 "./out/parser.cc"
    break;

  case 532: /* step_number: UNSIGNED "-"  */
#line 3893 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                               {
		yyval = make_chord_step (yyvsp[-1], FLAT_ALTERATION);
	}
#line 8057 "./out/parser.cc"
    break;

  case 533: /* tempo_range: unsigned_number  */
#line 3899 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                        {
		yyval = yyvsp[0];
	}
#line 8065 "./out/parser.cc"
    break;

  case 534: /* tempo_range: unsigned_number '-' unsigned_number  */
#line 3902 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                              {
		yyval = scm_cons (yyvsp[-2], yyvsp[0]);
	}
#line 8073 "./out/parser.cc"
    break;

  case 535: /* number_expression: number_expression '+' number_term  */
#line 3914 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                          {
		yyval = scm_sum (yyvsp[-2], yyvsp[0]);
	}
#line 8081 "./out/parser.cc"
    break;

  case 536: /* number_expression: number_expression '-' number_term  */
#line 3917 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                            {
		yyval = scm_difference (yyvsp[-2], yyvsp[0]);
	}
#line 8089 "./out/parser.cc"
    break;

  case 538: /* number_term: number_factor  */
#line 3924 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                      {
		yyval = yyvsp[0];
	}
#line 8097 "./out/parser.cc"
    break;

  case 539: /* number_term: number_factor '*' number_factor  */
#line 3927 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                          {
		yyval = scm_product (yyvsp[-2], yyvsp[0]);
	}
#line 8105 "./out/parser.cc"
    break;

  case 540: /* number_term: number_factor '/' number_factor  */
#line 3930 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                          {
		yyval = scm_divide (yyvsp[-2], yyvsp[0]);
	}
#line 8113 "./out/parser.cc"
    break;

  case 541: /* number_factor: '-' number_factor  */
#line 3936 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                           { /* %prec UNARY_MINUS */
		yyval = scm_difference (yyvsp[0], SCM_UNDEFINED);
	}
#line 8121 "./out/parser.cc"
    break;

  case 545: /* bare_number_common: REAL NUMBER_IDENTIFIER  */
#line 3946 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = scm_product (yyvsp[-1], yyvsp[0]);
	}
#line 8129 "./out/parser.cc"
    break;

  case 548: /* bare_number: UNSIGNED NUMBER_IDENTIFIER  */
#line 3954 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                        {
		yyval = scm_product (yyvsp[-1], yyvsp[0]);
	}
#line 8137 "./out/parser.cc"
    break;

  case 550: /* unsigned_number: NUMBER_IDENTIFIER  */
#line 3962 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		if (!scm_is_integer (yyvsp[0])
		    || scm_is_true (scm_negative_p (yyvsp[0])))
		{
			parser->parser_error ((yylsp[0]), _("not an unsigned integer"));
			yyval = SCM_INUM0;
		}
	}
#line 8150 "./out/parser.cc"
    break;

  case 551: /* unsigned_number: embedded_scm  */
#line 3971 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		if (!scm_is_integer (yyvsp[0])
		    || scm_is_true (scm_negative_p (yyvsp[0])))
		{
			parser->parser_error ((yylsp[0]), _("not an unsigned integer"));
			yyval = SCM_INUM0;
		}
	}
#line 8163 "./out/parser.cc"
    break;

  case 552: /* exclamations: %empty  */
#line 3982 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                { yyval = SCM_UNDEFINED; }
#line 8169 "./out/parser.cc"
    break;

  case 553: /* exclamations: exclamations '!'  */
#line 3984 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
                if (SCM_UNBNDP (yyvsp[-1]))
                        yyval = SCM_BOOL_T;
                else
                        yyval = scm_not (yyvsp[-1]);
        }
#line 8180 "./out/parser.cc"
    break;

  case 554: /* questions: %empty  */
#line 3999 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        { yyval = SCM_UNDEFINED; }
#line 8186 "./out/parser.cc"
    break;

  case 555: /* questions: questions '?'  */
#line 4001 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
                if (SCM_UNBNDP (yyvsp[-1]))
                        yyval = SCM_BOOL_T;
                else
                        yyval = scm_not (yyvsp[-1]);
        }
#line 8197 "./out/parser.cc"
    break;

  case 556: /* $@10: %empty  */
#line 4011 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                { parser->lexer_->push_markup_state (); }
#line 8203 "./out/parser.cc"
    break;

  case 557: /* full_markup_list: "\\markuplist" $@10 markup_list  */
#line 4012 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                    {
		yyval = yyvsp[0];
		parser->lexer_->pop_state ();
	}
#line 8212 "./out/parser.cc"
    break;

  case 558: /* markup_mode: "\\markup"  */
#line 4020 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		parser->lexer_->push_markup_state ();
	}
#line 8220 "./out/parser.cc"
    break;

  case 559: /* markup_mode_word: markup_mode markup_word  */
#line 4036 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = yyvsp[0];
		parser->lexer_->pop_state ();
	}
#line 8229 "./out/parser.cc"
    break;

  case 560: /* full_markup: markup_mode markup_top  */
#line 4044 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                               {
		yyval = yyvsp[0];
		parser->lexer_->pop_state ();
	}
#line 8238 "./out/parser.cc"
    break;

  case 561: /* full_markup: markup_mode_word  */
#line 4049 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = make_simple_markup (yyvsp[0]);
	}
#line 8246 "./out/parser.cc"
    break;

  case 562: /* partial_markup: markup_mode markup_partial_function "\\etc"  */
#line 4056 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = MAKE_SYNTAX (partial_markup, (yylsp[-1]), yyvsp[-1]);
		parser->lexer_->pop_state ();
	}
#line 8255 "./out/parser.cc"
    break;

  case 563: /* markup_top: markup_list  */
#line 4063 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                    {
		yyval = ly_list (Lily::line_markup,  yyvsp[0]);
	}
#line 8263 "./out/parser.cc"
    break;

  case 564: /* markup_top: markup_head_1_list simple_markup  */
#line 4067 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = scm_car (MAKE_SYNTAX (composed_markup_list,
					   (yylsp[0]), yyvsp[-1], ly_list (yyvsp[0])));
	}
#line 8272 "./out/parser.cc"
    break;

  case 565: /* markup_top: simple_markup_noword  */
#line 4071 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                               {
		yyval = yyvsp[0];
	}
#line 8280 "./out/parser.cc"
    break;

  case 566: /* $@11: %empty  */
#line 4078 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		if (Text_interface::is_markup (yyvsp[0]))
			MYBACKUP (MARKUP_IDENTIFIER, yyvsp[0], (yylsp[0]));
		else if (Text_interface::is_markup_list (yyvsp[0]))
			MYBACKUP (MARKUPLIST_IDENTIFIER, yyvsp[0], (yylsp[0]));
		else if (scm_is_eq (yyvsp[0], SCM_UNSPECIFIED))
			MYBACKUP (MARKUPLIST_IDENTIFIER, SCM_EOL, (yylsp[0]));
		else {
			parser->parser_error ((yylsp[0]), _ ("not a markup"));
			MYBACKUP (MARKUP_IDENTIFIER, scm_string (SCM_EOL), (yylsp[0]));
		}
	}
#line 8297 "./out/parser.cc"
    break;

  case 568: /* markup_list: markup_composed_list  */
#line 4094 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                             {
		yyval = yyvsp[0];
	}
#line 8305 "./out/parser.cc"
    break;

  case 570: /* markup_uncomposed_list: markup_braced_list  */
#line 4101 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                           {
		yyval = yyvsp[0];
	}
#line 8313 "./out/parser.cc"
    break;

  case 571: /* markup_uncomposed_list: markup_command_list  */
#line 4104 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                              {
		yyval = ly_list (yyvsp[0]);
	}
#line 8321 "./out/parser.cc"
    break;

  case 572: /* markup_uncomposed_list: markup_scm MARKUPLIST_IDENTIFIER  */
#line 4108 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = yyvsp[0];
	}
#line 8329 "./out/parser.cc"
    break;

  case 573: /* $@12: %empty  */
#line 4111 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                     {
		parser->lexer_->push_note_state ();
	}
#line 8337 "./out/parser.cc"
    break;

  case 574: /* markup_uncomposed_list: "\\score-lines" $@12 '{' score_body '}'  */
#line 4113 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                             {
		Score *sc = unsmob<Score> (yyvsp[-1]);
		sc->origin ()->set_spot ((yyloc));
		if (sc->defs_.empty ()) {
			Output_def *od = get_layout (parser);
			sc->add_output_def (od);
			od->unprotect ();
		}
		yyval = ly_list (ly_list (Lily::score_lines_markup_list, yyvsp[-1]));
		parser->lexer_->pop_state ();
	}
#line 8353 "./out/parser.cc"
    break;

  case 575: /* markup_composed_list: markup_head_1_list markup_uncomposed_list  */
#line 4127 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                                  {
		yyval = MAKE_SYNTAX (composed_markup_list,
				  (yylsp[0]), yyvsp[-1], yyvsp[0]);
	}
#line 8362 "./out/parser.cc"
    break;

  case 576: /* markup_braced_list: '{' markup_braced_list_body '}'  */
#line 4134 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                        {
		yyval = scm_reverse_x (yyvsp[-1], SCM_EOL);
	}
#line 8370 "./out/parser.cc"
    break;

  case 577: /* markup_braced_list_body: %empty  */
#line 4140 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                        {  yyval = SCM_EOL; }
#line 8376 "./out/parser.cc"
    break;

  case 578: /* markup_braced_list_body: markup_braced_list_body markup  */
#line 4141 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                         {
		yyval = scm_cons (yyvsp[0], yyvsp[-1]);
	}
#line 8384 "./out/parser.cc"
    break;

  case 579: /* markup_braced_list_body: markup_braced_list_body markup_list  */
#line 4144 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                              {
		yyval = Srfi_1::append_reverse (yyvsp[0], yyvsp[-1]);
	}
#line 8392 "./out/parser.cc"
    break;

  case 580: /* markup_command_list: MARKUP_LIST_FUNCTION markup_command_list_arguments  */
#line 4150 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                                           {
	  yyval = scm_cons (yyvsp[-1], scm_reverse_x (yyvsp[0], SCM_EOL));
	}
#line 8400 "./out/parser.cc"
    break;

  case 581: /* $@13: %empty  */
#line 4156 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
            {
		parser->lexer_->push_note_state ();
	}
#line 8408 "./out/parser.cc"
    break;

  case 582: /* markup_command_embedded_lilypond: '{' $@13 embedded_lilypond '}'  */
#line 4158 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                {
		parser->lexer_->pop_state ();
                yyval = yyvsp[-1];
	}
#line 8417 "./out/parser.cc"
    break;

  case 583: /* markup_command_basic_arguments: "markup-list?" markup_command_list_arguments markup_list  */
#line 4166 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                                                     {
		yyval = scm_cons (yyvsp[0], yyvsp[-1]);
	}
#line 8425 "./out/parser.cc"
    break;

  case 584: /* markup_command_basic_arguments: "scheme?" markup_command_list_arguments embedded_scm  */
#line 4169 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                                                {
		yyval = check_scheme_arg (parser, (yylsp[0]), yyvsp[0], yyvsp[-1], yyvsp[-2]);
	}
#line 8433 "./out/parser.cc"
    break;

  case 585: /* markup_command_basic_arguments: "scheme?" markup_command_list_arguments markup_command_embedded_lilypond  */
#line 4173 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = check_scheme_arg (parser, (yylsp[0]), yyvsp[0], yyvsp[-1], yyvsp[-2]);
	}
#line 8441 "./out/parser.cc"
    break;

  case 586: /* markup_command_basic_arguments: "scheme?" markup_command_list_arguments mode_changed_music  */
#line 4176 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                                                      {
		yyval = check_scheme_arg (parser, (yylsp[0]), yyvsp[0], yyvsp[-1], yyvsp[-2]);
	}
#line 8449 "./out/parser.cc"
    break;

  case 587: /* markup_command_basic_arguments: "scheme?" markup_command_list_arguments MUSIC_IDENTIFIER  */
#line 4179 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                                                    {
		yyval = check_scheme_arg (parser, (yylsp[0]), yyvsp[0], yyvsp[-1], yyvsp[-2]);
	}
#line 8457 "./out/parser.cc"
    break;

  case 588: /* markup_command_basic_arguments: "scheme?" markup_command_list_arguments STRING  */
#line 4182 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                                          {
		yyval = check_scheme_arg (parser, (yylsp[0]), yyvsp[0], yyvsp[-1], yyvsp[-2]);
	}
#line 8465 "./out/parser.cc"
    break;

  case 589: /* markup_command_basic_arguments: EXPECT_NO_MORE_ARGS  */
#line 4185 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                              {
		yyval = SCM_EOL;
	}
#line 8473 "./out/parser.cc"
    break;

  case 590: /* markup_command_list_arguments: markup_command_basic_arguments  */
#line 4191 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                       { yyval = yyvsp[0]; }
#line 8479 "./out/parser.cc"
    break;

  case 591: /* markup_command_list_arguments: "markup?" markup_command_list_arguments markup  */
#line 4192 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                                             {
	  yyval = scm_cons (yyvsp[0], yyvsp[-1]);
	}
#line 8487 "./out/parser.cc"
    break;

  case 592: /* markup_partial_function: MARKUP_FUNCTION markup_arglist_partial  */
#line 4199 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = ly_list (scm_cons (yyvsp[-1], scm_reverse_x (yyvsp[0], SCM_EOL)));
	}
#line 8495 "./out/parser.cc"
    break;

  case 593: /* markup_partial_function: markup_head_1_list MARKUP_FUNCTION markup_arglist_partial  */
#line 4203 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = scm_cons (scm_cons (yyvsp[-1], scm_reverse_x (yyvsp[0], SCM_EOL)),
			       yyvsp[-2]);
	}
#line 8504 "./out/parser.cc"
    break;

  case 594: /* markup_arglist_partial: "markup?" markup_arglist_partial  */
#line 4211 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = yyvsp[0];
	}
#line 8512 "./out/parser.cc"
    break;

  case 595: /* markup_arglist_partial: "scheme?" markup_arglist_partial  */
#line 4215 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval= yyvsp[0];
	}
#line 8520 "./out/parser.cc"
    break;

  case 596: /* markup_arglist_partial: "markup?" markup_command_list_arguments  */
#line 4219 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = yyvsp[0];
	}
#line 8528 "./out/parser.cc"
    break;

  case 597: /* markup_arglist_partial: "scheme?" markup_command_list_arguments  */
#line 4223 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = yyvsp[0];
	}
#line 8536 "./out/parser.cc"
    break;

  case 598: /* markup_head_1_item: MARKUP_FUNCTION "markup?" markup_command_list_arguments  */
#line 4229 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                                                    {
	  yyval = scm_cons (yyvsp[-2], scm_reverse_x (yyvsp[0], SCM_EOL));
	}
#line 8544 "./out/parser.cc"
    break;

  case 599: /* markup_head_1_list: markup_head_1_item  */
#line 4235 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                {
		yyval = ly_list (yyvsp[0]);
	}
#line 8552 "./out/parser.cc"
    break;

  case 600: /* markup_head_1_list: markup_head_1_list markup_head_1_item  */
#line 4238 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                                {
		yyval = scm_cons (yyvsp[0], yyvsp[-1]);
	}
#line 8560 "./out/parser.cc"
    break;

  case 603: /* simple_markup: markup_word  */
#line 4250 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = make_simple_markup (yyvsp[0]);
	}
#line 8568 "./out/parser.cc"
    break;

  case 605: /* $@14: %empty  */
#line 4257 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
              {
		parser->lexer_->push_note_state ();
	}
#line 8576 "./out/parser.cc"
    break;

  case 606: /* simple_markup_noword: "\\score" $@14 '{' score_body '}'  */
#line 4259 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                             {
		Score *sc = unsmob<Score> (yyvsp[-1]);
		sc->origin ()->set_spot ((yyloc));
		if (sc->defs_.empty ()) {
			Output_def *od = get_layout (parser);
			sc->add_output_def (od);
			od->unprotect ();
		}
		yyval = ly_list (Lily::score_markup, yyvsp[-1]);
		parser->lexer_->pop_state ();
	}
#line 8592 "./out/parser.cc"
    break;

  case 607: /* simple_markup_noword: MARKUP_FUNCTION markup_command_basic_arguments  */
#line 4270 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                                                         {
		yyval = scm_cons (yyvsp[-1], scm_reverse_x (yyvsp[0], SCM_EOL));
	}
#line 8600 "./out/parser.cc"
    break;

  case 608: /* simple_markup_noword: markup_scm MARKUP_IDENTIFIER  */
#line 4274 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = yyvsp[0];
	}
#line 8608 "./out/parser.cc"
    break;

  case 609: /* markup: markup_head_1_list simple_markup  */
#line 4281 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
        {
		yyval = scm_car (MAKE_SYNTAX (composed_markup_list,
					   (yylsp[0]), yyvsp[-1], ly_list (yyvsp[0])));
	}
#line 8617 "./out/parser.cc"
    break;

  case 610: /* markup: simple_markup  */
#line 4285 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"
                        {
		yyval = yyvsp[0];
	}
#line 8625 "./out/parser.cc"
    break;


#line 8629 "./out/parser.cc"

      default: break;
    }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", YY_CAST (yysymbol_kind_t, yyr1[yyn]), &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;

  *++yyvsp = yyval;
  *++yylsp = yyloc;

  /* Now 'shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */
  {
    const int yylhs = yyr1[yyn] - YYNTOKENS;
    const int yyi = yypgoto[yylhs] + *yyssp;
    yystate = (0 <= yyi && yyi <= YYLAST && yycheck[yyi] == *yyssp
               ? yytable[yyi]
               : yydefgoto[yylhs]);
  }

  goto yynewstate;


/*--------------------------------------.
| yyerrlab -- here on detecting error.  |
`--------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == YYEMPTY ? YYSYMBOL_YYEMPTY : YYTRANSLATE (yychar);
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
      {
        yypcontext_t yyctx
          = {yyssp, yytoken, &yylloc};
        char const *yymsgp = YY_("syntax error");
        int yysyntax_error_status;
        yysyntax_error_status = yysyntax_error (&yymsg_alloc, &yymsg, &yyctx);
        if (yysyntax_error_status == 0)
          yymsgp = yymsg;
        else if (yysyntax_error_status == -1)
          {
            if (yymsg != yymsgbuf)
              YYSTACK_FREE (yymsg);
            yymsg = YY_CAST (char *,
                             YYSTACK_ALLOC (YY_CAST (YYSIZE_T, yymsg_alloc)));
            if (yymsg)
              {
                yysyntax_error_status
                  = yysyntax_error (&yymsg_alloc, &yymsg, &yyctx);
                yymsgp = yymsg;
              }
            else
              {
                yymsg = yymsgbuf;
                yymsg_alloc = sizeof yymsgbuf;
                yysyntax_error_status = YYENOMEM;
              }
          }
        yyerror (&yylloc, parser, retval, yymsgp);
        if (yysyntax_error_status == YYENOMEM)
          YYNOMEM;
      }
    }

  yyerror_range[1] = yylloc;
  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
         error, discard it.  */

      if (yychar <= END_OF_FILE)
        {
          /* Return failure if at end of input.  */
          if (yychar == END_OF_FILE)
            YYABORT;
        }
      else
        {
          yydestruct ("Error: discarding",
                      yytoken, &yylval, &yylloc, parser, retval);
          yychar = YYEMPTY;
        }
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:
  /* Pacify compilers when the user code never invokes YYERROR and the
     label yyerrorlab therefore never appears in user code.  */
  if (0)
    YYERROR;
  ++yynerrs;

  /* Do not reclaim the symbols of the rule whose action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;      /* Each real token shifted decrements this.  */

  /* Pop stack until we find a state that shifts the error token.  */
  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
        {
          yyn += YYSYMBOL_YYerror;
          if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYSYMBOL_YYerror)
            {
              yyn = yytable[yyn];
              if (0 < yyn)
                break;
            }
        }

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
        YYABORT;

      yyerror_range[1] = *yylsp;
      yydestruct ("Error: popping",
                  YY_ACCESSING_SYMBOL (yystate), yyvsp, yylsp, parser, retval);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  yyerror_range[2] = yylloc;
  ++yylsp;
  YYLLOC_DEFAULT (*yylsp, yyerror_range, 2);

  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", YY_ACCESSING_SYMBOL (yyn), yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturnlab;


/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturnlab;


/*-----------------------------------------------------------.
| yyexhaustedlab -- YYNOMEM (memory exhaustion) comes here.  |
`-----------------------------------------------------------*/
yyexhaustedlab:
  yyerror (&yylloc, parser, retval, YY_("memory exhausted"));
  yyresult = 2;
  goto yyreturnlab;


/*----------------------------------------------------------.
| yyreturnlab -- parsing is finished, clean up and return.  |
`----------------------------------------------------------*/
yyreturnlab:
  if (yychar != YYEMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval, &yylloc, parser, retval);
    }
  /* Do not reclaim the symbols of the rule whose action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
                  YY_ACCESSING_SYMBOL (+*yyssp), yyvsp, yylsp, parser, retval);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
  if (yymsg != yymsgbuf)
    YYSTACK_FREE (yymsg);
  return yyresult;
}

#line 4290 "/pub/devel/lilypond/lilypond-2.24.4-1.x86_64/src/lilypond-2.24.4/lily/parser.yy"


void
Lily_parser::set_yydebug (bool x)
{
	yydebug = x;
}

SCM
Lily_parser::do_yyparse ()
{
	return scm_c_with_fluid (Lily::f_parser,
				 self_scm (),
				 do_yyparse_trampoline,
				 static_cast <void *>(this));
}

SCM
Lily_parser::do_yyparse_trampoline (void *parser)
{
	SCM retval = SCM_UNDEFINED;
	yyparse (static_cast <Lily_parser *>(parser), &retval);
	return retval;
}



/*

It is a little strange to have this function in this file, but
otherwise, we have to import music classes into the lexer.

*/
int
Lily_lexer::try_special_identifiers (SCM *destination, SCM sid)
{
	if (unsmob<Book> (sid)) {
		Book *book =  unsmob<Book> (sid)->clone ();
		*destination = book->self_scm ();
		book->unprotect ();

		return BOOK_IDENTIFIER;
	} else if (scm_is_number (sid)) {
		*destination = sid;
		return NUMBER_IDENTIFIER;
	} else if (unsmob<Context_def> (sid))
	{
		*destination = unsmob<Context_def> (sid)->clone ()->unprotect ();
		return SCM_IDENTIFIER;
        } else if (unsmob<Context_mod> (sid)) {
                *destination = unsmob<Context_mod> (sid)->smobbed_copy ();
                return SCM_IDENTIFIER;
	} else if (Music *mus = unsmob<Music> (sid)) {
		mus = mus->clone ();
		*destination = mus->self_scm ();
		bool is_event = mus->is_mus_type ("post-event");
		mus->unprotect ();
		return is_event ? EVENT_IDENTIFIER : MUSIC_IDENTIFIER;
	} else if (unsmob<Pitch> (sid)) {
		*destination = unsmob<Pitch> (sid)->smobbed_copy ();
		return PITCH_IDENTIFIER;
	} else if (unsmob<Duration> (sid)) {
		*destination = unsmob<Duration> (sid)->smobbed_copy ();
		return DURATION_IDENTIFIER;
	} else if (unsmob<Output_def> (sid)) {
		*destination = unsmob<Output_def> (sid)->clone ()->unprotect ();
		return SCM_IDENTIFIER;
	} else if (unsmob<Score> (sid)) {
		*destination = unsmob<Score> (sid)->clone ()->unprotect ();
		return SCM_IDENTIFIER;
	} else if (scm_is_pair (sid)
		   && scm_is_pair (scm_car (sid))
		   && scm_is_true (Lily::key_p (scm_caar (sid)))) {
		*destination = sid;
		return LOOKUP_IDENTIFIER;
	}
	return -1;
}

// check_scheme_arg checks one argument with a given predicate for use
// in an argument list and throws a syntax error if it is unusable.
// The argument is prepended to the argument list in any case.  After
// throwing a syntax error, the argument list is terminated with #f as
// its last cdr in order to mark it as uncallable while not losing
// track of its total length.
//
// There are a few special considerations: if optional argument disp
// is given (otherwise it defaults to SCM_UNDEFINED), it will be used
// instead of arg in a prospective error message.  This is useful if
// arg is not the actual argument but rather a transformation of it.
//
// If arg itself is SCM_UNDEFINED, the predicate is considered false
// and an error message using disp is produced unconditionally.

SCM check_scheme_arg (Lily_parser *parser, Input loc,
		      SCM arg, SCM args, SCM pred, SCM disp)
{
	if (SCM_UNBNDP (arg))
		args = scm_cons (disp, args);
	else {
		args = scm_cons (arg, args);
		if (scm_is_true (ly_call (pred, arg)))
			return args;
	}
	scm_set_cdr_x (scm_last_pair (args), SCM_EOL);
	MAKE_SYNTAX (argument_error, loc, scm_length (args), pred,
		     SCM_UNBNDP (disp) ? arg : disp);
	scm_set_cdr_x (scm_last_pair (args), SCM_BOOL_F);
	return args;
}

SCM loc_on_copy (Lily_parser *parser, Input loc, SCM arg)
{
	if (Music *m = unsmob<Music> (arg))
	{
		m = m->clone ();
		m->set_spot (parser->lexer_->override_input (loc));
		return m->unprotect ();
	}
	if (Book *b = unsmob<Book> (arg))
	{
		b = b->clone ();
		b->origin ()->set_spot (parser->lexer_->override_input (loc));
		return b->unprotect ();
	}
	if (Context_def *cd = unsmob<Context_def> (arg))
	{
		cd = cd->clone ();
		cd->origin ()->set_spot (parser->lexer_->override_input (loc));
		return cd->unprotect ();
	}
	if (Output_def *od = unsmob<Output_def> (arg))
	{
		od = od->clone ();
		od->input_origin_ = parser->lexer_->override_input (loc);
		return od->unprotect ();
	}
	if (Score *s = unsmob<Score> (arg))
	{
		s = s->clone ();
		s->origin ()->set_spot (parser->lexer_->override_input (loc));
		return s->unprotect ();
	}
	if (Context_mod *cm = unsmob<Context_mod> (arg))
	{
		return cm->smobbed_copy ();
	}
	return arg;
}

SCM
make_reverse_key_list (SCM keys)
{
	if (scm_is_true (Lily::key_p (keys)))
		return ly_list (keys);
	if (scm_is_string (keys))
		return ly_list (scm_string_to_symbol (keys));
	if (!ly_is_list (keys))
		return SCM_UNDEFINED;
	SCM res = SCM_EOL;
	for (; scm_is_pair (keys); keys = scm_cdr (keys))
	{
		SCM elt = scm_car (keys);
		if (scm_is_true (Lily::key_p (elt)))
			res = scm_cons (elt, res);
		else if (scm_is_string (elt))
			res = scm_cons (scm_string_to_symbol (elt), res);
		else return SCM_UNDEFINED;
	}
	return res;
}

SCM
try_string_variants (SCM pred, SCM str)
{
	// a matching predicate is always ok
	if (scm_is_true (ly_call (pred, str)))
		return str;
	// a key may be interpreted as a list of keys if it helps
	if (scm_is_true (Lily::key_p (str))) {
		str = ly_list (str);
		if (scm_is_true (ly_call (pred, str)))
			return str;
		return SCM_UNDEFINED;
	}

	if (!scm_is_string (str))
		return SCM_UNDEFINED;

	// Let's attempt the symbol list interpretation first.

	str = scm_string_to_symbol (str);

	SCM lst = ly_list (str);

	if (scm_is_true (ly_call (pred, lst)))
		return lst;

	// Try the single symbol interpretation

	if (scm_is_true (ly_call (pred, str)))
		return str;

	return SCM_UNDEFINED;
}

SCM
try_word_variants (SCM pred, SCM str)
{
	// str is always a string when we come here

	if (scm_is_true (ly_call (pred, str)))
		return str;

	// If this cannot be a string representation of a symbol list,
	// we are through.

	if (!is_regular_identifier (str, true))
		return SCM_UNDEFINED;

	str = scm_string_split (str, SCM_MAKE_CHAR ('.'));
	for (SCM &p : as_ly_scm_list (str))
		p = scm_string_split (p, SCM_MAKE_CHAR (','));
	str = scm_append_x (str);
	for (SCM &p : as_ly_scm_list (str))
		p = scm_string_to_symbol (p);

	// Let's attempt the symbol list interpretation first.

	if (scm_is_true (ly_call (pred, str)))
		return str;

	// If there is just one symbol in the list, we might interpret
	// it as a single symbol

	if (scm_is_null (scm_cdr (str)))
	{
		str = scm_car (str);
		if (scm_is_true (ly_call (pred, str)))
			return str;
	}

	return SCM_UNDEFINED;
}

bool
is_regular_identifier (SCM id, bool multiple)
{
  if (!scm_is_string (id))
	  return false;

  string str = ly_scm2string (id);

  bool middle = false;

  for (string::iterator it=str.begin(); it != str.end (); it++)
  {
	  int c = *it & 0xff;
	  if ((c >= 'a' && c <= 'z')
	      || (c >= 'A' && c <= 'Z')
	      || c > 0x7f)
		  middle = true;
	  else if (middle && (c == '-' || c == '_' || (multiple &&
						       (c == '.' || c == ','))))
		  middle = false;
	  else
		  return false;
  }
  return middle;
}

SCM
make_music_from_simple (Lily_parser *parser, Input loc, SCM simple)
{
	if (unsmob<Music> (simple))
		return simple;

	if (scm_is_symbol (simple))
	{
		SCM out = SCM_UNDEFINED;
		switch (parser->lexer_->scan_word (out, simple))
		{
		case DRUM_PITCH:
		{
			Music *n = MY_MAKE_MUSIC ("NoteEvent", loc);
			set_property (n, "duration", parser->default_duration_.smobbed_copy ());
			set_property (n, "drum-type", out);
			return n->unprotect ();
		}
		case NOTENAME_PITCH:
		case TONICNAME_PITCH:
			// Take the parsed pitch
			simple = out;
			break;
		// Don't scan CHORD_MODIFIER etc.
		}
	}

	if (parser->lexer_->is_note_state ()) {
		if (unsmob<Pitch> (simple)) {
			Music *n = MY_MAKE_MUSIC ("NoteEvent", loc);
			set_property (n, "duration", parser->default_duration_.smobbed_copy ());
			set_property (n, "pitch", simple);
			return n->unprotect ();
		}
		SCM d = simple;
		if (scm_is_integer (simple))
			d = make_duration (simple);
		if (unsmob<Duration> (d)) {
			Music *n = MY_MAKE_MUSIC ("NoteEvent", loc);
			set_property (n, "duration", d);
			return n->unprotect ();
		}
		return simple;
	} else if (parser->lexer_->is_lyric_state ()) {
		if (Text_interface::is_markup (simple))
			return MAKE_SYNTAX (lyric_event, loc, simple,
					    parser->default_duration_.smobbed_copy ());
	} else if (parser->lexer_->is_chord_state ()) {
		if (unsmob<Pitch> (simple))
			return MAKE_SYNTAX
				(event_chord,
				 loc,
				 make_chord_elements (loc, simple,
						      parser->default_duration_.smobbed_copy (),
						      SCM_EOL));
	}
	return simple;
}

Music *
make_music_with_input (SCM name, Input where)
{
       Music *m = make_music_by_name (name);
       m->set_spot (where);
       return m;
}

SCM
make_simple_markup (SCM a)
{
	return a;
}

SCM
make_duration (SCM d, int dots, SCM factor)
{
	Duration k;

	if (Duration *dur = unsmob<Duration> (d)) {
		if (!dots && SCM_UNBNDP (factor))
			return d;
		k = *dur;
		if (dots)
			k = Duration (k.duration_log (), k.dot_count () + dots)
				.compressed (k.factor ());
	} else {
		int t = from_scm<int> (d);
		if (t > 0 && (t & (t-1)) == 0)
			k = Duration (intlog2 (t), dots);
		else
			return SCM_UNDEFINED;
	}

	if (!SCM_UNBNDP (factor))
		k = k.compressed (from_scm<Rational> (factor));

	return k.smobbed_copy ();
}

SCM
make_chord_step (SCM step_scm, Rational alter)
{
	Pitch m (0, from_scm<int> (step_scm) - 1, alter);

	// Notename/octave are normalized
	if (m.get_notename () == 6)
		m = m.transposed (Pitch (0, 0, FLAT_ALTERATION));

	return m.smobbed_copy ();
}


SCM
make_chord_elements (Input loc, SCM pitch, SCM dur, SCM modification_list)
{
	SCM res = Lily::construct_chord_elements (pitch, dur, modification_list);
	for (SCM s = res; scm_is_pair (s); s = scm_cdr (s))
	{
		unsmob<Music> (scm_car (s))->set_spot (loc);
	}
	return res;
}

// Return true if there are post events unaccounted for
bool
add_post_events (Music *m, SCM events)
{
	if (!scm_is_pair (events))
		return false;	// successfully added -- nothing

	while (m) {
		if (m->is_mus_type ("rhythmic-event")
		    || m->is_mus_type ("caesura-event")) {
			set_property
				(m, "articulations",
				 scm_append_x (ly_list
					       (get_property (m, "articulations"),
						events)));
			return false;
		}
		if (m->is_mus_type ("event-chord")) {
			set_property
				(m, "elements",
				 scm_append_x (ly_list
					       (get_property (m, "elements"),
						events)));
			return false;
		}
		if (m->is_mus_type ("sequential-music")) {
			SCM lp = scm_last_pair (get_property (m, "elements"));
			if (scm_is_pair (lp)) {
				m = unsmob<Music> (scm_car (lp));
				continue;
			}
			return true;
		}
		if (m->is_mus_type ("music-wrapper-music")
		    || m->is_mus_type ("time-scaled-music")) {
			m = unsmob<Music> (get_property (m, "element"));
			continue;
		}
		break;
	}
	return true;
}

// Returns either a list or a post-event
//
// If PRESERVE is true, unattachable post-events are not thrown away
// but rather added attached to empty chords.  If COMPRESS is true, a
// sequence consisting only of post-events may be returned as a single
// post-event.
SCM reverse_music_list (Lily_parser *parser, Input loc, SCM lst, bool preserve, bool compress)
{
	SCM res = SCM_EOL;	// Resulting reversed list
	SCM bad = SCM_EOL;	// Bad post events
	SCM post = SCM_EOL;	// current unattached events
	for (; scm_is_pair (lst); lst = scm_cdr (lst)) {
		SCM elt = scm_car (lst);
		Music *m = unsmob<Music> (elt);
		assert (m);
		if (m->is_mus_type ("post-event")) {
			post = post_event_cons (elt, post);
			continue;
		}
		if (add_post_events (m, post)) {
			bad = scm_cons (scm_car (post), bad);
			if (preserve) {
				Music *p = unsmob<Music> (scm_car (post));
				res = scm_cons (MAKE_SYNTAX (event_chord,
							     *p->origin (),
							     post),
						res);
			}
		}
		post = SCM_EOL;
		res = scm_cons (elt, res);
	}
	if (scm_is_pair (post)) {
		if (scm_is_null (res) && compress) { // pure postevent list
			if (scm_is_null (scm_cdr (post)))
				return scm_car (post);
			Music *m = MY_MAKE_MUSIC ("PostEvents", loc);
			set_property (m, "elements", post);
			return m->unprotect ();
		}
		bad = ly_append (post, bad);
		if (preserve) {
			Music *p = unsmob<Music> (scm_car (post));
			res = scm_cons (MAKE_SYNTAX (event_chord,
						     *p->origin (),
						     post),
					res);
		}
	}
	for (; scm_is_pair (bad); bad = scm_cdr (bad))
	{
		Music *what = unsmob<Music> (scm_car (bad));
		if (preserve)
			what->warning (_f ("Unattached %s", what->name ()));
		else
			what->warning (_f ("Dropping unattachable %s", what->name ()));
	}
	return res;
}

SCM post_event_cons (SCM post_event, SCM tail)
{
	Music *ev = unsmob<Music> (post_event);
	if (!ev)
		return tail;
	if (!ev->is_mus_type ("post-event-wrapper"))
		return scm_cons (post_event, tail);
	SCM elts = SCM_UNDEFINED;
	SCM props = SCM_EOL;
	SCM tweaks = SCM_UNDEFINED;
	for (SCM p = ev->get_property_alist (true);
	     scm_is_pair (p);
	     p = scm_cdr (p))
	{
		SCM pair = scm_car (p);
		SCM sym = scm_car (pair);
		if (scm_is_eq (sym, ly_symbol2scm ("origin")))
			continue;
		else if (scm_is_eq (sym, ly_symbol2scm ("elements"))
			 && SCM_UNBNDP (elts))
			elts = scm_cdr (pair);
		else if (scm_is_eq (sym, ly_symbol2scm ("tweaks"))
			 && SCM_UNBNDP (tweaks))
			tweaks = scm_cdr (pair);
		else
			props = scm_cons (pair, props);
	}
	if (!scm_is_pair (elts))
		return tail;
	elts = scm_reverse_x (elts, SCM_EOL);
	for (SCM p = elts; scm_is_pair (p); p = scm_cdr (p))
	{
		Music *ev = unsmob<Music> (scm_car (p));
		// tweaks are always collected in-order, newer tweaks
		// nearer to the front of the list
		if (scm_is_pair (tweaks))
			set_property (ev,
			              "tweaks",
			              Srfi_1::append_reverse (tweaks,
				                              get_property (ev, "tweaks")));
		// other properties are applied last to first so that
		// in case of duplicate properties, the actually
		// current one survives
		for (SCM q = props; scm_is_pair (q); q = scm_cdr (q))
			set_property (ev, scm_caar (q), scm_cdar (q));
	}
	return ly_append (elts, tail);
}

void property_path_dot_warning (Input loc, SCM lst)
{
	// if lst is empty, don't even venture a guess...
	if (scm_is_pair (lst)) {
		std::string out = ly_symbol2string (scm_car (lst));
		for (lst = scm_cdr (lst); scm_is_pair (lst); lst = scm_cdr (lst)) {
			out += ".";
			out += ly_symbol2string (scm_car (lst));
		}
		loc.warning (_f ("deprecated: missing `.' in property path %s", out));
	}
}


int
yylex (YYSTYPE *s, YYLTYPE *loc, Lily_parser *parser)
{
	Lily_lexer *lex = parser->lexer_;

	lex->lexval_ = s;
	lex->lexloc_ = loc;
	int tok = lex->pop_extra_token ();
	if (tok >= 0)
		return tok;
	lex->prepare_for_next_token ();
	return lex->yylex ();
}
