/* gnome-chess.c generated by valac 0.36.1.2-2a0ee, the Vala compiler
 * generated from gnome-chess.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2010-2013 Robert Ancell
 * Copyright (C) 2013-2014 Michael Catanzaro
 * Copyright (C) 2015-2016 Sahil Sareen
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include "libchess.h"
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <stdio.h>
#include <gdk/gdk.h>
#include <glib/gstdio.h>
#include <librsvg/rsvg.h>
#include <cairo.h>
#include <float.h>
#include <math.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <locale.h>


#define TYPE_CHESS_APPLICATION (chess_application_get_type ())
#define CHESS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_APPLICATION, ChessApplication))
#define CHESS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_APPLICATION, ChessApplicationClass))
#define IS_CHESS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_APPLICATION))
#define IS_CHESS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_APPLICATION))
#define CHESS_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_APPLICATION, ChessApplicationClass))

typedef struct _ChessApplication ChessApplication;
typedef struct _ChessApplicationClass ChessApplicationClass;
typedef struct _ChessApplicationPrivate ChessApplicationPrivate;

#define TYPE_CHESS_SCENE (chess_scene_get_type ())
#define CHESS_SCENE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_SCENE, ChessScene))
#define CHESS_SCENE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_SCENE, ChessSceneClass))
#define IS_CHESS_SCENE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_SCENE))
#define IS_CHESS_SCENE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_SCENE))
#define CHESS_SCENE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_SCENE, ChessSceneClass))

typedef struct _ChessScene ChessScene;
typedef struct _ChessSceneClass ChessSceneClass;

#define TYPE_CHESS_VIEW (chess_view_get_type ())
#define CHESS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_VIEW, ChessView))
#define CHESS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_VIEW, ChessViewClass))
#define IS_CHESS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_VIEW))
#define IS_CHESS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_VIEW))
#define CHESS_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_VIEW, ChessViewClass))

typedef struct _ChessView ChessView;
typedef struct _ChessViewClass ChessViewClass;

#define TYPE_AI_PROFILE (ai_profile_get_type ())
#define AI_PROFILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AI_PROFILE, AIProfile))
#define AI_PROFILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AI_PROFILE, AIProfileClass))
#define IS_AI_PROFILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AI_PROFILE))
#define IS_AI_PROFILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AI_PROFILE))
#define AI_PROFILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AI_PROFILE, AIProfileClass))

typedef struct _AIProfile AIProfile;
typedef struct _AIProfileClass AIProfileClass;

#define TYPE_CHESS_ENGINE (chess_engine_get_type ())
#define CHESS_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_ENGINE, ChessEngine))
#define CHESS_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_ENGINE, ChessEngineClass))
#define IS_CHESS_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_ENGINE))
#define IS_CHESS_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_ENGINE))
#define CHESS_ENGINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_ENGINE, ChessEngineClass))

typedef struct _ChessEngine ChessEngine;
typedef struct _ChessEngineClass ChessEngineClass;

#define CHESS_APPLICATION_TYPE_PROMOTION_TYPE_SELECTED (chess_application_promotion_type_selected_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))

#define TYPE_CHESS_ENGINE_CECP (chess_engine_cecp_get_type ())
#define CHESS_ENGINE_CECP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_ENGINE_CECP, ChessEngineCECP))
#define CHESS_ENGINE_CECP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_ENGINE_CECP, ChessEngineCECPClass))
#define IS_CHESS_ENGINE_CECP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_ENGINE_CECP))
#define IS_CHESS_ENGINE_CECP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_ENGINE_CECP))
#define CHESS_ENGINE_CECP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_ENGINE_CECP, ChessEngineCECPClass))

typedef struct _ChessEngineCECP ChessEngineCECP;
typedef struct _ChessEngineCECPClass ChessEngineCECPClass;

#define TYPE_CHESS_ENGINE_UCI (chess_engine_uci_get_type ())
#define CHESS_ENGINE_UCI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_ENGINE_UCI, ChessEngineUCI))
#define CHESS_ENGINE_UCI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_ENGINE_UCI, ChessEngineUCIClass))
#define IS_CHESS_ENGINE_UCI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_ENGINE_UCI))
#define IS_CHESS_ENGINE_UCI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_ENGINE_UCI))
#define CHESS_ENGINE_UCI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_ENGINE_UCI, ChessEngineUCIClass))

typedef struct _ChessEngineUCI ChessEngineUCI;
typedef struct _ChessEngineUCIClass ChessEngineUCIClass;
typedef struct _Block2Data Block2Data;
typedef struct _Block3Data Block3Data;
typedef struct _ChessScenePrivate ChessScenePrivate;

#define TYPE_CHESS_MODEL (chess_model_get_type ())
#define CHESS_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_MODEL, ChessModel))
#define CHESS_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_MODEL, ChessModelClass))
#define IS_CHESS_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_MODEL))
#define IS_CHESS_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_MODEL))
#define CHESS_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_MODEL, ChessModelClass))

typedef struct _ChessModel ChessModel;
typedef struct _ChessModelClass ChessModelClass;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ChessApplication {
	GtkApplication parent_instance;
	ChessApplicationPrivate * priv;
};

struct _ChessApplicationClass {
	GtkApplicationClass parent_class;
};

struct _ChessApplicationPrivate {
	gboolean is_tiled;
	gboolean is_maximized;
	gint window_width;
	gint window_height;
	GSettings* settings;
	GtkApplicationWindow* window;
	GtkContainer* view_container;
	ChessScene* scene;
	ChessView* view;
	GtkButton* pause_resume_button;
	GtkWidget* first_move_button;
	GtkWidget* prev_move_button;
	GtkWidget* next_move_button;
	GtkWidget* last_move_button;
	GtkComboBox* history_combo;
	GtkWidget* white_time_label;
	GtkWidget* black_time_label;
	GtkWidget* timer_increment_label;
	GtkHeaderBar* headerbar;
	GtkDialog* preferences_dialog;
	GtkComboBox* side_combo;
	GtkComboBox* difficulty_combo;
	GtkComboBox* duration_combo;
	GtkComboBox* clock_type_combo;
	GtkAdjustment* duration_adjustment;
	GtkAdjustment* timer_increment_adjustment;
	GtkBox* custom_duration_box;
	GtkBox* timer_increment_box;
	GtkComboBox* timer_increment_units_combo;
	GtkComboBox* custom_duration_units_combo;
	guint save_duration_timeout;
	GtkFileChooserDialog* open_dialog;
	GtkInfoBar* open_dialog_info_bar;
	GtkLabel* open_dialog_error_label;
	GtkFileChooserDialog* save_dialog;
	GtkInfoBar* save_dialog_info_bar;
	GtkLabel* save_dialog_error_label;
	GtkAboutDialog* about_dialog;
	PGNGame* pgn_game;
	ChessGame* game;
	gchar* autosave_filename;
	GFile* game_file;
	gboolean game_needs_saving;
	gboolean starting;
	GList* ai_profiles;
	ChessPlayer* opponent;
	ChessPlayer* human_player;
	ChessEngine* opponent_engine;
	gint engine_timeout_counter;
	gchar* copyrights;
};

typedef enum  {
	CHESS_APPLICATION_PROMOTION_TYPE_SELECTED_QUEEN,
	CHESS_APPLICATION_PROMOTION_TYPE_SELECTED_KNIGHT,
	CHESS_APPLICATION_PROMOTION_TYPE_SELECTED_ROOK,
	CHESS_APPLICATION_PROMOTION_TYPE_SELECTED_BISHOP
} ChessApplicationPromotionTypeSelected;

struct _Block1Data {
	int _ref_count_;
	ChessApplication* self;
	GtkInfoBar* no_engine_info_bar;
};

struct _Block2Data {
	int _ref_count_;
	ChessApplication* self;
	gchar* move;
};

struct _Block3Data {
	int _ref_count_;
	ChessApplication* self;
	ChessGame* original_game;
};

struct _ChessScene {
	GObject parent_instance;
	ChessScenePrivate * priv;
	GList* pieces;
	gboolean animating;
	gint selected_rank;
	gint selected_file;
};

struct _ChessSceneClass {
	GObjectClass parent_class;
};


static gpointer chess_application_parent_class = NULL;

GType chess_application_get_type (void) G_GNUC_CONST;
GType chess_scene_get_type (void) G_GNUC_CONST;
GType chess_view_get_type (void) G_GNUC_CONST;
GType ai_profile_get_type (void) G_GNUC_CONST;
GType chess_engine_get_type (void) G_GNUC_CONST;
#define CHESS_APPLICATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CHESS_APPLICATION, ChessApplicationPrivate))
enum  {
	CHESS_APPLICATION_DUMMY_PROPERTY
};
static GType chess_application_promotion_type_selected_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
void chess_application_preferences_cb (ChessApplication* self);
static void _chess_application_preferences_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
void chess_application_help_cb (ChessApplication* self);
static void _chess_application_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
void chess_application_about_cb (ChessApplication* self);
static void _chess_application_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
void chess_application_quit_cb (ChessApplication* self);
static void _chess_application_quit_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
#define CHESS_APPLICATION_NEW_GAME_ACTION_NAME "new"
#define CHESS_APPLICATION_OPEN_GAME_ACTION_NAME "open"
#define CHESS_APPLICATION_SAVE_GAME_ACTION_NAME "save"
#define CHESS_APPLICATION_SAVE_GAME_AS_ACTION_NAME "save-as"
#define CHESS_APPLICATION_UNDO_MOVE_ACTION_NAME "undo"
#define CHESS_APPLICATION_RESIGN_ACTION_NAME "resign"
#define CHESS_APPLICATION_PAUSE_RESUME_ACTION_NAME "pause-resume"
void chess_application_new_game_cb (ChessApplication* self);
static void _chess_application_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
void chess_application_open_game_cb (ChessApplication* self);
static void _chess_application_open_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
void chess_application_save_game_cb (ChessApplication* self);
static void _chess_application_save_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
void chess_application_save_game_as_cb (ChessApplication* self);
static void _chess_application_save_game_as_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
void chess_application_undo_move_cb (ChessApplication* self);
static void _chess_application_undo_move_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
void chess_application_resign_cb (ChessApplication* self);
static void _chess_application_resign_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
void chess_application_pause_resume_cb (ChessApplication* self);
static void _chess_application_pause_resume_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static ChessApplication* chess_application_new (void);
static ChessApplication* chess_application_construct (GType object_type);
static gint chess_application_real_handle_local_options (GApplication* base, GVariantDict* options);
static void chess_application_display_no_engine_info_bar (ChessApplication* self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void chess_application_add_info_bar_to_bin (ChessApplication* self, GtkBin* bin, GtkInfoBar* * info_bar, GtkLabel* * label);
static void __lambda10_ (Block1Data* _data1_);
static void ___lambda10__gtk_info_bar_response (GtkInfoBar* _sender, gint response_id, gpointer self);
static void chess_application_real_startup (GApplication* base);
static void chess_application_size_allocate_cb (ChessApplication* self, GtkAllocation* allocation);
static void _chess_application_size_allocate_cb_gtk_widget_size_allocate (GtkWidget* _sender, GtkAllocation* allocation, gpointer self);
static gboolean chess_application_window_state_event_cb (ChessApplication* self, GdkEventWindowState* event);
static gboolean _chess_application_window_state_event_cb_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self);
static void chess_application_update_pause_resume_button (ChessApplication* self);
ChessScene* chess_scene_new (void);
ChessScene* chess_scene_construct (GType object_type);
static gboolean __lambda11_ (ChessApplication* self, ChessPlayer* p);
static gboolean ___lambda11__chess_scene_is_human (ChessScene* _sender, ChessPlayer* player, gpointer self);
static void chess_application_scene_changed_cb (ChessApplication* self, ChessScene* scene);
static void _chess_application_scene_changed_cb_chess_scene_changed (ChessScene* _sender, gpointer self);
PieceType* chess_application_show_promotion_type_selector (ChessApplication* self);
static PieceType* _chess_application_show_promotion_type_selector_chess_scene_choose_promotion_type (ChessScene* _sender, gpointer self);
ChessView* chess_view_new (void);
ChessView* chess_view_construct (GType object_type);
void chess_view_set_scene (ChessView* self, ChessScene* value);
GList* ai_profile_load_ai_profiles (const gchar* filename);
const gchar* ai_profile_get_name (AIProfile* self);
const gchar* ai_profile_get_path (AIProfile* self);
static void chess_application_real_open (GApplication* base, GFile** files, int files_length1, const gchar* hint);
static void chess_application_real_activate (GApplication* base);
static void chess_application_start_new_game (ChessApplication* self);
static void chess_application_load_game (ChessApplication* self, GFile* file, GError** error);
static void chess_application_real_shutdown (GApplication* base);
void chess_engine_stop (ChessEngine* self, gboolean kill_engine);
const gchar* chess_scene_get_theme_name (ChessScene* self);
static void chess_application_set_piece_image (ChessApplication* self, GtkImage* image, const gchar* filename);
static PieceType* _piece_type_dup (PieceType* self);
void chess_application_quit_game (ChessApplication* self);
static gboolean chess_application_save_duration_cb (ChessApplication* self);
static void chess_application_autosave (ChessApplication* self);
static void chess_application_update_pgn_time_remaining (ChessApplication* self);
static void chess_application_update_history_panel (ChessApplication* self);
gint chess_scene_get_move_number (ChessScene* self);
static void chess_application_set_move_text (ChessApplication* self, GtkTreeIter* iter, ChessMove* move);
static void chess_application_start_game (ChessApplication* self);
static void chess_application_run_invalid_move_dialog (ChessApplication* self, const gchar* error_message);
static void chess_application_game_turn_cb (ChessApplication* self, ChessGame* game, ChessPlayer* player);
static void _chess_application_game_turn_cb_chess_game_turn_started (ChessGame* _sender, ChessPlayer* player, gpointer self);
static void chess_application_game_move_cb (ChessApplication* self, ChessGame* game, ChessMove* move);
static void _chess_application_game_move_cb_chess_game_moved (ChessGame* _sender, ChessMove* move, gpointer self);
static void chess_application_game_undo_cb (ChessApplication* self, ChessGame* game);
static void _chess_application_game_undo_cb_chess_game_undo (ChessGame* _sender, gpointer self);
static void chess_application_game_end_cb (ChessApplication* self);
static void _chess_application_game_end_cb_chess_game_ended (ChessGame* _sender, gpointer self);
static void chess_application_game_clock_tick_cb (ChessApplication* self, ChessClock* clock);
static void _chess_application_game_clock_tick_cb_chess_clock_tick (ChessClock* _sender, gpointer self);
void chess_scene_set_game (ChessScene* self, ChessGame* value);
static void chess_application_engine_ready_cb (ChessApplication* self, ChessEngine* engine);
static void _chess_application_engine_ready_cb_chess_engine_ready_changed (ChessEngine* _sender, gpointer self);
static void chess_application_engine_move_cb (ChessApplication* self, ChessEngine* engine, const gchar* move);
static void _chess_application_engine_move_cb_chess_engine_moved (ChessEngine* _sender, const gchar* move, gpointer self);
static void chess_application_engine_resigned_cb (ChessApplication* self, ChessEngine* engine);
static void _chess_application_engine_resigned_cb_chess_engine_resigned (ChessEngine* _sender, gpointer self);
static void chess_application_engine_stopped_unexpectedly_cb (ChessApplication* self, ChessEngine* engine);
static void _chess_application_engine_stopped_unexpectedly_cb_chess_engine_stopped_unexpectedly (ChessEngine* _sender, gpointer self);
static void chess_application_engine_error_cb (ChessApplication* self, ChessEngine* engine);
static void _chess_application_engine_error_cb_chess_engine_error (ChessEngine* _sender, gpointer self);
static void chess_application_engine_claim_draw_cb (ChessApplication* self, ChessEngine* engine);
static void _chess_application_engine_claim_draw_cb_chess_engine_claim_draw (ChessEngine* _sender, gpointer self);
static void chess_application_engine_offer_draw_cb (ChessApplication* self, ChessEngine* engine);
static void _chess_application_engine_offer_draw_cb_chess_engine_offer_draw (ChessEngine* _sender, gpointer self);
static ChessEngine* chess_application_get_engine (ChessApplication* self, const gchar* name, const gchar* difficulty);
gboolean chess_engine_start (ChessEngine* self);
static void chess_application_disable_window_action (ChessApplication* self, const gchar* name);
static void chess_application_enable_window_action (ChessApplication* self, const gchar* name);
void chess_engine_start_game (ChessEngine* self);
static void chess_application_update_action_status (ChessApplication* self);
static void chess_application_update_headerbar_title (ChessApplication* self);
void chess_engine_move (ChessEngine* self);
gchar** ai_profile_get_easy_options (AIProfile* self, int* result_length1);
static gchar** _vala_array_dup1 (gchar** self, int length);
gchar** ai_profile_get_easy_uci_go_options (AIProfile* self, int* result_length1);
static gchar** _vala_array_dup2 (gchar** self, int length);
gchar** ai_profile_get_easy_args (AIProfile* self, int* result_length1);
static gchar** _vala_array_dup3 (gchar** self, int length);
gchar** ai_profile_get_hard_options (AIProfile* self, int* result_length1);
static gchar** _vala_array_dup4 (gchar** self, int length);
gchar** ai_profile_get_hard_uci_go_options (AIProfile* self, int* result_length1);
static gchar** _vala_array_dup5 (gchar** self, int length);
gchar** ai_profile_get_hard_args (AIProfile* self, int* result_length1);
static gchar** _vala_array_dup6 (gchar** self, int length);
gchar** ai_profile_get_normal_options (AIProfile* self, int* result_length1);
static gchar** _vala_array_dup7 (gchar** self, int length);
gchar** ai_profile_get_normal_uci_go_options (AIProfile* self, int* result_length1);
static gchar** _vala_array_dup8 (gchar** self, int length);
gchar** ai_profile_get_normal_args (AIProfile* self, int* result_length1);
static gchar** _vala_array_dup9 (gchar** self, int length);
const gchar* ai_profile_get_protocol (AIProfile* self);
const gchar* ai_profile_get_binary (AIProfile* self);
guint ai_profile_get_delay_seconds (AIProfile* self);
ChessEngineCECP* chess_engine_cecp_new (const gchar* binary, gchar** args, int args_length1, guint delay_seconds, gchar** options, int options_length1);
ChessEngineCECP* chess_engine_cecp_construct (GType object_type, const gchar* binary, gchar** args, int args_length1, guint delay_seconds, gchar** options, int options_length1);
GType chess_engine_cecp_get_type (void) G_GNUC_CONST;
ChessEngineUCI* chess_engine_uci_new (const gchar* binary, gchar** args, int args_length1, guint delay_seconds, gchar** options, int options_length1, gchar** go_options, int go_options_length1);
ChessEngineUCI* chess_engine_uci_construct (GType object_type, const gchar* binary, gchar** args, int args_length1, guint delay_seconds, gchar** options, int options_length1, gchar** go_options, int go_options_length1);
GType chess_engine_uci_get_type (void) G_GNUC_CONST;
gboolean chess_engine_get_ready (ChessEngine* self);
static void chess_application_do_engine_move (ChessApplication* self, const gchar* move);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static gboolean ___lambda7_ (Block2Data* _data2_);
static gboolean ____lambda7__gsource_func (gpointer self);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static gboolean __lambda8_ (Block3Data* _data3_);
static gboolean ___lambda8__gsource_func (gpointer self);
static void chess_application_check_engine_timeout (ChessApplication* self);
static void chess_application_present_claim_draw_dialog (ChessApplication* self);
const gchar* chess_scene_get_move_format (ChessScene* self);
void chess_scene_set_move_number (ChessScene* self, gint value);
void chess_engine_report_move (ChessEngine* self, ChessMove* move);
void chess_engine_undo (ChessEngine* self);
gboolean gnome_chess_app_delete_event_cb (GtkWidget* widget, GdkEvent* event, ChessApplication* self);
static gboolean chess_application_prompt_save_game (ChessApplication* self, const gchar* prompt_text);
static void chess_application_present_save_dialog (ChessApplication* self, const gchar* cancel_button_label, const gchar* save_button_label);
GType chess_model_get_type (void) G_GNUC_CONST;
gboolean white_time_draw_cb (GtkWidget* widget, cairo_t* c, ChessApplication* self);
static void chess_application_draw_time (ChessApplication* self, GtkWidget* widget, cairo_t* c, const gchar* text, gdouble* fg, int fg_length1, gdouble* bg, int bg_length1);
static gchar* chess_application_make_clock_text (ChessApplication* self, ChessClock* clock, Color color);
gboolean black_time_draw_cb (GtkWidget* widget, cairo_t* c, ChessApplication* self);
static gint chess_application_compute_time_label_width_request (ChessApplication* self, cairo_t* c);
void history_combo_changed_cb (GtkComboBox* combo, ChessApplication* self);
void history_latest_clicked_cb (GtkWidget* widget, ChessApplication* self);
void history_next_clicked_cb (GtkWidget* widget, ChessApplication* self);
void history_previous_clicked_cb (GtkWidget* widget, ChessApplication* self);
void history_start_clicked_cb (GtkWidget* widget, ChessApplication* self);
static void chess_application_set_combo (ChessApplication* self, GtkComboBox* combo, gint value_index, const gchar* value);
static void chess_application_set_duration (ChessApplication* self, gint duration, gboolean simplify);
static void chess_application_set_clock_type (ChessApplication* self, gint clock_type);
static void chess_application_set_timer_increment (ChessApplication* self, gint timer_increment);
static gchar* chess_application_get_combo (ChessApplication* self, GtkComboBox* combo, gint value_index);
void side_combo_changed_cb (GtkComboBox* combo, ChessApplication* self);
void opponent_combo_changed_cb (GtkComboBox* combo, ChessApplication* self);
void difficulty_combo_changed_cb (GtkComboBox* combo, ChessApplication* self);
void clock_type_changed_cb (GtkComboBox* combo, ChessApplication* self);
void timer_increment_units_changed_cb (GtkWidget* widget, ChessApplication* self);
static gint chess_application_get_duration (ChessApplication* self);
void duration_changed_cb (GtkAdjustment* adjustment, ChessApplication* self);
static void chess_application_save_duration (ChessApplication* self);
void duration_units_changed_cb (GtkWidget* widget, ChessApplication* self);
static gboolean _chess_application_save_duration_cb_gsource_func (gpointer self);
void duration_combo_changed_cb (GtkComboBox* combo, ChessApplication* self);
void preferences_response_cb (GtkWidget* widget, gint response_id, ChessApplication* self);
gboolean preferences_delete_event_cb (GtkWidget* widget, GdkEvent* event, ChessApplication* self);
void piece_style_combo_changed_cb (GtkComboBox* combo, ChessApplication* self);
void move_format_combo_changed_cb (GtkComboBox* combo, ChessApplication* self);
void orientation_combo_changed_cb (GtkComboBox* combo, ChessApplication* self);
static void chess_application_about_response_cb (ChessApplication* self, gint response_id);
static void _chess_application_about_response_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static void chess_application_run_invalid_pgn_dialog (ChessApplication* self);
static void chess_application_save_dialog_cb (ChessApplication* self, gint response_id);
static void __lambda6_ (ChessApplication* self);
static void ___lambda6__gtk_file_chooser_file_activated (GtkFileChooser* _sender, gpointer self);
static void _chess_application_save_dialog_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static void __lambda9_ (ChessApplication* self);
static void chess_application_open_dialog_cb (ChessApplication* self, gint response_id);
static void ___lambda9__gtk_file_chooser_file_activated (GtkFileChooser* _sender, gpointer self);
static void _chess_application_open_dialog_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
gint chess_application_main (gchar** args, int args_length1);
static void chess_application_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GActionEntry CHESS_APPLICATION_app_entries[4] = {{"preferences", _chess_application_preferences_cb_gsimple_action_activate_callback}, {"help", _chess_application_help_cb_gsimple_action_activate_callback}, {"about", _chess_application_about_cb_gsimple_action_activate_callback}, {"quit", _chess_application_quit_cb_gsimple_action_activate_callback}};
static const GActionEntry CHESS_APPLICATION_window_entries[7] = {{CHESS_APPLICATION_NEW_GAME_ACTION_NAME, _chess_application_new_game_cb_gsimple_action_activate_callback}, {CHESS_APPLICATION_OPEN_GAME_ACTION_NAME, _chess_application_open_game_cb_gsimple_action_activate_callback}, {CHESS_APPLICATION_SAVE_GAME_ACTION_NAME, _chess_application_save_game_cb_gsimple_action_activate_callback}, {CHESS_APPLICATION_SAVE_GAME_AS_ACTION_NAME, _chess_application_save_game_as_cb_gsimple_action_activate_callback}, {CHESS_APPLICATION_UNDO_MOVE_ACTION_NAME, _chess_application_undo_move_cb_gsimple_action_activate_callback}, {CHESS_APPLICATION_RESIGN_ACTION_NAME, _chess_application_resign_cb_gsimple_action_activate_callback}, {CHESS_APPLICATION_PAUSE_RESUME_ACTION_NAME, _chess_application_pause_resume_cb_gsimple_action_activate_callback}};
static const GOptionEntry CHESS_APPLICATION_option_entries[2] = {{"version", 'v', 0, G_OPTION_ARG_NONE, NULL, N_ ("Show release version"), NULL}, {NULL}};
static const gchar* CHESS_APPLICATION_authors[2] = {"Robert Ancell <robert.ancell@gmail.com>", NULL};
static const gchar* CHESS_APPLICATION_artists[3] = {"Max Froumentin (pieces)", "Jakub Steiner (icon)", NULL};

static GType chess_application_promotion_type_selected_get_type (void) {
	static volatile gsize chess_application_promotion_type_selected_type_id__volatile = 0;
	if (g_once_init_enter (&chess_application_promotion_type_selected_type_id__volatile)) {
		static const GEnumValue values[] = {{CHESS_APPLICATION_PROMOTION_TYPE_SELECTED_QUEEN, "CHESS_APPLICATION_PROMOTION_TYPE_SELECTED_QUEEN", "queen"}, {CHESS_APPLICATION_PROMOTION_TYPE_SELECTED_KNIGHT, "CHESS_APPLICATION_PROMOTION_TYPE_SELECTED_KNIGHT", "knight"}, {CHESS_APPLICATION_PROMOTION_TYPE_SELECTED_ROOK, "CHESS_APPLICATION_PROMOTION_TYPE_SELECTED_ROOK", "rook"}, {CHESS_APPLICATION_PROMOTION_TYPE_SELECTED_BISHOP, "CHESS_APPLICATION_PROMOTION_TYPE_SELECTED_BISHOP", "bishop"}, {0, NULL, NULL}};
		GType chess_application_promotion_type_selected_type_id;
		chess_application_promotion_type_selected_type_id = g_enum_register_static ("ChessApplicationPromotionTypeSelected", values);
		g_once_init_leave (&chess_application_promotion_type_selected_type_id__volatile, chess_application_promotion_type_selected_type_id);
	}
	return chess_application_promotion_type_selected_type_id__volatile;
}


static void _g_object_unref0_ (gpointer var) {
#line 63 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 474 "gnome-chess.c"
}


static void _g_list_free__g_object_unref0_ (GList* self) {
#line 63 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
#line 63 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_list_free (self);
#line 483 "gnome-chess.c"
}


static void _chess_application_preferences_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 72 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	chess_application_preferences_cb ((ChessApplication*) self);
#line 490 "gnome-chess.c"
}


static void _chess_application_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 72 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	chess_application_help_cb ((ChessApplication*) self);
#line 497 "gnome-chess.c"
}


static void _chess_application_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 72 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	chess_application_about_cb ((ChessApplication*) self);
#line 504 "gnome-chess.c"
}


static void _chess_application_quit_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 72 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	chess_application_quit_cb ((ChessApplication*) self);
#line 511 "gnome-chess.c"
}


static void _chess_application_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 88 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	chess_application_new_game_cb ((ChessApplication*) self);
#line 518 "gnome-chess.c"
}


static void _chess_application_open_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 88 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	chess_application_open_game_cb ((ChessApplication*) self);
#line 525 "gnome-chess.c"
}


static void _chess_application_save_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 88 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	chess_application_save_game_cb ((ChessApplication*) self);
#line 532 "gnome-chess.c"
}


static void _chess_application_save_game_as_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 88 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	chess_application_save_game_as_cb ((ChessApplication*) self);
#line 539 "gnome-chess.c"
}


static void _chess_application_undo_move_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 88 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	chess_application_undo_move_cb ((ChessApplication*) self);
#line 546 "gnome-chess.c"
}


static void _chess_application_resign_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 88 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	chess_application_resign_cb ((ChessApplication*) self);
#line 553 "gnome-chess.c"
}


static void _chess_application_pause_resume_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 88 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	chess_application_pause_resume_cb ((ChessApplication*) self);
#line 560 "gnome-chess.c"
}


static ChessApplication* chess_application_construct (GType object_type) {
	ChessApplication * self = NULL;
#line 110 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	self = (ChessApplication*) g_object_new (object_type, "application-id", "org.gnome.chess", "flags", G_APPLICATION_HANDLES_OPEN, NULL);
#line 111 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_application_add_main_option_entries ((GApplication*) self, CHESS_APPLICATION_option_entries);
#line 108 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	return self;
#line 572 "gnome-chess.c"
}


static ChessApplication* chess_application_new (void) {
#line 108 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	return chess_application_construct (TYPE_CHESS_APPLICATION);
#line 579 "gnome-chess.c"
}


static gint chess_application_real_handle_local_options (GApplication* base, GVariantDict* options) {
	ChessApplication * self;
	gint result = 0;
	GVariantDict* _tmp0_;
	gboolean _tmp1_;
#line 114 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	self = (ChessApplication*) base;
#line 114 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (options != NULL, 0);
#line 116 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = options;
#line 116 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = g_variant_dict_contains (_tmp0_, "version");
#line 116 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp1_) {
#line 598 "gnome-chess.c"
		FILE* _tmp2_;
#line 119 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp2_ = stderr;
#line 119 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		fprintf (_tmp2_, "gnome-chess %s\n", VERSION);
#line 120 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		result = EXIT_SUCCESS;
#line 120 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		return result;
#line 608 "gnome-chess.c"
	}
#line 124 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	result = -1;
#line 124 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	return result;
#line 614 "gnome-chess.c"
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
#line 127 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_atomic_int_inc (&_data1_->_ref_count_);
#line 127 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	return _data1_;
#line 623 "gnome-chess.c"
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
#line 127 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
#line 632 "gnome-chess.c"
		ChessApplication* self;
#line 127 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		self = _data1_->self;
#line 127 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (_data1_->no_engine_info_bar);
#line 127 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (self);
#line 127 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		g_slice_free (Block1Data, _data1_);
#line 642 "gnome-chess.c"
	}
}


static void __lambda10_ (Block1Data* _data1_) {
	ChessApplication* self;
	GtkInfoBar* _tmp0_;
#line 139 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	self = _data1_->self;
#line 139 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = _data1_->no_engine_info_bar;
#line 139 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_widget_hide ((GtkWidget*) _tmp0_);
#line 656 "gnome-chess.c"
}


static void ___lambda10__gtk_info_bar_response (GtkInfoBar* _sender, gint response_id, gpointer self) {
#line 139 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	__lambda10_ (self);
#line 663 "gnome-chess.c"
}


static void chess_application_display_no_engine_info_bar (ChessApplication* self) {
	Block1Data* _data1_;
	GtkLabel* no_engine_error_label;
	GtkApplicationWindow* _tmp0_;
	GtkInfoBar* _tmp1_ = NULL;
	GtkLabel* _tmp2_ = NULL;
	GtkLabel* _tmp3_;
	GtkInfoBar* _tmp4_;
	GtkInfoBar* _tmp5_;
	GtkInfoBar* _tmp6_;
	GtkInfoBar* _tmp7_;
#line 127 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 127 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_data1_ = g_slice_new0 (Block1Data);
#line 127 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_data1_->_ref_count_ = 1;
#line 127 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_data1_->self = g_object_ref (self);
#line 129 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_data1_->no_engine_info_bar = NULL;
#line 130 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	no_engine_error_label = NULL;
#line 132 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->window;
#line 132 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	chess_application_add_info_bar_to_bin (self, (GtkBin*) _tmp0_, &_tmp1_, &_tmp2_);
#line 132 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (_data1_->no_engine_info_bar);
#line 132 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_data1_->no_engine_info_bar = _tmp1_;
#line 132 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (no_engine_error_label);
#line 132 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	no_engine_error_label = _tmp2_;
#line 134 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = no_engine_error_label;
#line 134 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_label_set_text (_tmp3_, _ ("No chess engine is installed. " "You will not be able to play against the computer."));
#line 136 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = _data1_->no_engine_info_bar;
#line 136 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_info_bar_set_message_type (_tmp4_, GTK_MESSAGE_ERROR);
#line 137 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = _data1_->no_engine_info_bar;
#line 137 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_widget_show ((GtkWidget*) _tmp5_);
#line 138 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = _data1_->no_engine_info_bar;
#line 138 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_info_bar_set_show_close_button (_tmp6_, TRUE);
#line 139 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = _data1_->no_engine_info_bar;
#line 139 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_signal_connect_data (_tmp7_, "response", (GCallback) ___lambda10__gtk_info_bar_response, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
#line 127 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (no_engine_error_label);
#line 127 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	block1_data_unref (_data1_);
#line 127 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_data1_ = NULL;
#line 728 "gnome-chess.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 151 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	return self ? g_object_ref (self) : NULL;
#line 735 "gnome-chess.c"
}


static void _chess_application_size_allocate_cb_gtk_widget_size_allocate (GtkWidget* _sender, GtkAllocation* allocation, gpointer self) {
#line 155 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	chess_application_size_allocate_cb ((ChessApplication*) self, allocation);
#line 742 "gnome-chess.c"
}


static gboolean _chess_application_window_state_event_cb_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self) {
	gboolean result;
	result = chess_application_window_state_event_cb ((ChessApplication*) self, event);
#line 156 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	return result;
#line 751 "gnome-chess.c"
}


static gboolean __lambda11_ (ChessApplication* self, ChessPlayer* p) {
	gboolean result = FALSE;
	ChessPlayer* _tmp0_;
	ChessPlayer* _tmp1_;
#line 183 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (p != NULL, FALSE);
#line 183 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = p;
#line 183 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = self->priv->human_player;
#line 183 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	result = _tmp0_ == _tmp1_;
#line 183 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	return result;
#line 769 "gnome-chess.c"
}


static gboolean ___lambda11__chess_scene_is_human (ChessScene* _sender, ChessPlayer* player, gpointer self) {
	gboolean result;
	result = __lambda11_ ((ChessApplication*) self, player);
#line 183 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	return result;
#line 778 "gnome-chess.c"
}


static void _chess_application_scene_changed_cb_chess_scene_changed (ChessScene* _sender, gpointer self) {
#line 184 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	chess_application_scene_changed_cb ((ChessApplication*) self, _sender);
#line 785 "gnome-chess.c"
}


static PieceType* _chess_application_show_promotion_type_selector_chess_scene_choose_promotion_type (ChessScene* _sender, gpointer self) {
	PieceType* result;
	result = chess_application_show_promotion_type_selector ((ChessApplication*) self);
#line 185 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	return result;
#line 794 "gnome-chess.c"
}


static void chess_application_real_startup (GApplication* base) {
	ChessApplication * self;
	GSettings* _tmp0_;
	GtkBuilder* builder;
	GtkBuilder* _tmp1_;
	GtkBuilder* _tmp2_;
	GObject* _tmp3_;
	GtkApplicationWindow* _tmp4_;
	GtkApplicationWindow* _tmp5_;
	GSettings* _tmp6_;
	gint _tmp7_;
	GSettings* _tmp8_;
	gint _tmp9_;
	GSettings* _tmp10_;
	gboolean _tmp11_;
	GtkApplicationWindow* _tmp13_;
	GtkApplicationWindow* _tmp14_;
	GtkBuilder* _tmp15_;
	GObject* _tmp16_;
	GtkButton* _tmp17_;
	GtkBuilder* _tmp18_;
	GObject* _tmp19_;
	GtkWidget* _tmp20_;
	GtkBuilder* _tmp21_;
	GObject* _tmp22_;
	GtkWidget* _tmp23_;
	GtkBuilder* _tmp24_;
	GObject* _tmp25_;
	GtkWidget* _tmp26_;
	GtkBuilder* _tmp27_;
	GObject* _tmp28_;
	GtkWidget* _tmp29_;
	GtkBuilder* _tmp30_;
	GObject* _tmp31_;
	GtkComboBox* _tmp32_;
	GtkBuilder* _tmp33_;
	GObject* _tmp34_;
	GtkWidget* _tmp35_;
	GtkBuilder* _tmp36_;
	GObject* _tmp37_;
	GtkWidget* _tmp38_;
	GtkBuilder* _tmp39_;
	GObject* _tmp40_;
	GtkContainer* _tmp41_;
	GtkBuilder* _tmp42_;
	GObject* _tmp43_;
	GtkHeaderBar* _tmp44_;
	GtkBuilder* _tmp45_;
	GtkApplicationWindow* _tmp46_;
	gchar* _tmp47_;
	gchar** _tmp48_;
	gchar** _tmp49_;
	gint _tmp49__length1;
	gchar* _tmp50_;
	gchar** _tmp51_;
	gchar** _tmp52_;
	gint _tmp52__length1;
	gchar* _tmp53_;
	gchar** _tmp54_;
	gchar** _tmp55_;
	gint _tmp55__length1;
	gchar* _tmp56_;
	gchar** _tmp57_;
	gchar** _tmp58_;
	gint _tmp58__length1;
	gchar* _tmp59_;
	gchar** _tmp60_;
	gchar** _tmp61_;
	gint _tmp61__length1;
	gchar* _tmp62_;
	gchar** _tmp63_;
	gchar** _tmp64_;
	gint _tmp64__length1;
	GtkApplicationWindow* _tmp65_;
	ChessScene* _tmp66_;
	ChessScene* _tmp67_;
	ChessScene* _tmp68_;
	ChessScene* _tmp69_;
	GSettings* _tmp70_;
	ChessScene* _tmp71_;
	GSettings* _tmp72_;
	ChessScene* _tmp73_;
	GSettings* _tmp74_;
	ChessScene* _tmp75_;
	GSettings* _tmp76_;
	ChessScene* _tmp77_;
	GSettings* _tmp78_;
	ChessScene* _tmp79_;
	ChessView* _tmp80_;
	ChessView* _tmp81_;
	ChessView* _tmp82_;
	ChessScene* _tmp83_;
	GtkContainer* _tmp84_;
	ChessView* _tmp85_;
	ChessView* _tmp86_;
	gchar* system_engine_cfg;
	gchar* _tmp87_;
	gchar* user_engine_cfg;
	const gchar* _tmp88_;
	gchar* _tmp89_;
	const gchar* _tmp90_;
	gboolean _tmp91_;
	GList* _tmp98_;
	GList* _tmp99_;
#line 142 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	self = (ChessApplication*) base;
#line 144 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	G_APPLICATION_CLASS (chess_application_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
#line 146 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = g_settings_new ("org.gnome.chess");
#line 146 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->settings);
#line 146 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	self->priv->settings = _tmp0_;
#line 148 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_action_map_add_action_entries ((GActionMap*) self, CHESS_APPLICATION_app_entries, G_N_ELEMENTS (CHESS_APPLICATION_app_entries), self);
#line 149 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = gtk_builder_new_from_resource ("/org/gnome/chess/ui/gnome-chess.ui");
#line 149 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	builder = _tmp1_;
#line 151 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = builder;
#line 151 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = gtk_builder_get_object (_tmp2_, "gnome_chess_app");
#line 151 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_application_window_get_type (), GtkApplicationWindow));
#line 151 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->window);
#line 151 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	self->priv->window = _tmp4_;
#line 152 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = self->priv->window;
#line 152 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = self->priv->settings;
#line 152 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = g_settings_get_int (_tmp6_, "width");
#line 152 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp8_ = self->priv->settings;
#line 152 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp9_ = g_settings_get_int (_tmp8_, "height");
#line 152 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_window_set_default_size ((GtkWindow*) _tmp5_, _tmp7_, _tmp9_);
#line 153 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp10_ = self->priv->settings;
#line 153 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp11_ = g_settings_get_boolean (_tmp10_, "maximized");
#line 153 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp11_) {
#line 946 "gnome-chess.c"
		GtkApplicationWindow* _tmp12_;
#line 154 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp12_ = self->priv->window;
#line 154 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		gtk_window_maximize ((GtkWindow*) _tmp12_);
#line 952 "gnome-chess.c"
	}
#line 155 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp13_ = self->priv->window;
#line 155 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_signal_connect_object ((GtkWidget*) _tmp13_, "size-allocate", (GCallback) _chess_application_size_allocate_cb_gtk_widget_size_allocate, self, 0);
#line 156 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp14_ = self->priv->window;
#line 156 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_signal_connect_object ((GtkWidget*) _tmp14_, "window-state-event", (GCallback) _chess_application_window_state_event_cb_gtk_widget_window_state_event, self, 0);
#line 158 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp15_ = builder;
#line 158 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp16_ = gtk_builder_get_object (_tmp15_, "pause_button");
#line 158 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp17_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, gtk_button_get_type (), GtkButton));
#line 158 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->pause_resume_button);
#line 158 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	self->priv->pause_resume_button = _tmp17_;
#line 159 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp18_ = builder;
#line 159 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp19_ = gtk_builder_get_object (_tmp18_, "first_move_button");
#line 159 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp20_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, gtk_widget_get_type (), GtkWidget));
#line 159 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->first_move_button);
#line 159 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	self->priv->first_move_button = _tmp20_;
#line 160 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp21_ = builder;
#line 160 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp22_ = gtk_builder_get_object (_tmp21_, "prev_move_button");
#line 160 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp23_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, gtk_widget_get_type (), GtkWidget));
#line 160 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->prev_move_button);
#line 160 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	self->priv->prev_move_button = _tmp23_;
#line 161 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp24_ = builder;
#line 161 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp25_ = gtk_builder_get_object (_tmp24_, "next_move_button");
#line 161 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp26_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, gtk_widget_get_type (), GtkWidget));
#line 161 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->next_move_button);
#line 161 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	self->priv->next_move_button = _tmp26_;
#line 162 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp27_ = builder;
#line 162 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp28_ = gtk_builder_get_object (_tmp27_, "last_move_button");
#line 162 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp29_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, gtk_widget_get_type (), GtkWidget));
#line 162 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->last_move_button);
#line 162 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	self->priv->last_move_button = _tmp29_;
#line 163 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp30_ = builder;
#line 163 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp31_ = gtk_builder_get_object (_tmp30_, "history_combo");
#line 163 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp32_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, gtk_combo_box_get_type (), GtkComboBox));
#line 163 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->history_combo);
#line 163 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	self->priv->history_combo = _tmp32_;
#line 164 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp33_ = builder;
#line 164 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp34_ = gtk_builder_get_object (_tmp33_, "white_time_label");
#line 164 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp35_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, gtk_widget_get_type (), GtkWidget));
#line 164 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->white_time_label);
#line 164 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	self->priv->white_time_label = _tmp35_;
#line 165 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp36_ = builder;
#line 165 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp37_ = gtk_builder_get_object (_tmp36_, "black_time_label");
#line 165 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp38_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, gtk_widget_get_type (), GtkWidget));
#line 165 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->black_time_label);
#line 165 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	self->priv->black_time_label = _tmp38_;
#line 166 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp39_ = builder;
#line 166 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp40_ = gtk_builder_get_object (_tmp39_, "view_container");
#line 166 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp41_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp40_, gtk_container_get_type (), GtkContainer));
#line 166 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->view_container);
#line 166 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	self->priv->view_container = _tmp41_;
#line 167 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp42_ = builder;
#line 167 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp43_ = gtk_builder_get_object (_tmp42_, "headerbar");
#line 167 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp44_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp43_, gtk_header_bar_get_type (), GtkHeaderBar));
#line 167 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->headerbar);
#line 167 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	self->priv->headerbar = _tmp44_;
#line 168 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp45_ = builder;
#line 168 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_builder_connect_signals (_tmp45_, self);
#line 170 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	chess_application_update_pause_resume_button (self);
#line 172 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp46_ = self->priv->window;
#line 172 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_action_map_add_action_entries ((GActionMap*) _tmp46_, CHESS_APPLICATION_window_entries, G_N_ELEMENTS (CHESS_APPLICATION_window_entries), self);
#line 173 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp47_ = g_strdup ("<Primary>N");
#line 173 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp48_ = g_new0 (gchar*, 1 + 1);
#line 173 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp48_[0] = _tmp47_;
#line 173 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp49_ = _tmp48_;
#line 173 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp49__length1 = 1;
#line 173 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win." CHESS_APPLICATION_NEW_GAME_ACTION_NAME, _tmp49_);
#line 173 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp49_ = (_vala_array_free (_tmp49_, _tmp49__length1, (GDestroyNotify) g_free), NULL);
#line 174 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp50_ = g_strdup ("<Primary>O");
#line 174 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp51_ = g_new0 (gchar*, 1 + 1);
#line 174 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp51_[0] = _tmp50_;
#line 174 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp52_ = _tmp51_;
#line 174 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp52__length1 = 1;
#line 174 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win." CHESS_APPLICATION_OPEN_GAME_ACTION_NAME, _tmp52_);
#line 174 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp52_ = (_vala_array_free (_tmp52_, _tmp52__length1, (GDestroyNotify) g_free), NULL);
#line 175 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp53_ = g_strdup ("<Primary>S");
#line 175 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp54_ = g_new0 (gchar*, 1 + 1);
#line 175 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp54_[0] = _tmp53_;
#line 175 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp55_ = _tmp54_;
#line 175 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp55__length1 = 1;
#line 175 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win." CHESS_APPLICATION_SAVE_GAME_ACTION_NAME, _tmp55_);
#line 175 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp55_ = (_vala_array_free (_tmp55_, _tmp55__length1, (GDestroyNotify) g_free), NULL);
#line 176 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp56_ = g_strdup ("<Shift><Primary>S");
#line 176 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp57_ = g_new0 (gchar*, 1 + 1);
#line 176 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp57_[0] = _tmp56_;
#line 176 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp58_ = _tmp57_;
#line 176 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp58__length1 = 1;
#line 176 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win." CHESS_APPLICATION_SAVE_GAME_AS_ACTION_NAME, _tmp58_);
#line 176 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp58_ = (_vala_array_free (_tmp58_, _tmp58__length1, (GDestroyNotify) g_free), NULL);
#line 177 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp59_ = g_strdup ("<Primary>Z");
#line 177 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp60_ = g_new0 (gchar*, 1 + 1);
#line 177 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp60_[0] = _tmp59_;
#line 177 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp61_ = _tmp60_;
#line 177 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp61__length1 = 1;
#line 177 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win." CHESS_APPLICATION_UNDO_MOVE_ACTION_NAME, _tmp61_);
#line 177 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp61_ = (_vala_array_free (_tmp61_, _tmp61__length1, (GDestroyNotify) g_free), NULL);
#line 178 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp62_ = g_strdup ("Pause");
#line 178 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp63_ = g_new0 (gchar*, 1 + 1);
#line 178 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp63_[0] = _tmp62_;
#line 178 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp64_ = _tmp63_;
#line 178 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp64__length1 = 1;
#line 178 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win." CHESS_APPLICATION_PAUSE_RESUME_ACTION_NAME, _tmp64_);
#line 178 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp64_ = (_vala_array_free (_tmp64_, _tmp64__length1, (GDestroyNotify) g_free), NULL);
#line 180 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp65_ = self->priv->window;
#line 180 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_application_add_window ((GtkApplication*) self, (GtkWindow*) _tmp65_);
#line 182 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp66_ = chess_scene_new ();
#line 182 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->scene);
#line 182 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	self->priv->scene = _tmp66_;
#line 183 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp67_ = self->priv->scene;
#line 183 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_signal_connect_object (_tmp67_, "is-human", (GCallback) ___lambda11__chess_scene_is_human, self, 0);
#line 184 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp68_ = self->priv->scene;
#line 184 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_signal_connect_object (_tmp68_, "changed", (GCallback) _chess_application_scene_changed_cb_chess_scene_changed, self, 0);
#line 185 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp69_ = self->priv->scene;
#line 185 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_signal_connect_object (_tmp69_, "choose-promotion-type", (GCallback) _chess_application_show_promotion_type_selector_chess_scene_choose_promotion_type, self, 0);
#line 187 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp70_ = self->priv->settings;
#line 187 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp71_ = self->priv->scene;
#line 187 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_settings_bind (_tmp70_, "show-move-hints", (GObject*) _tmp71_, "show-move-hints", G_SETTINGS_BIND_GET);
#line 188 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp72_ = self->priv->settings;
#line 188 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp73_ = self->priv->scene;
#line 188 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_settings_bind (_tmp72_, "show-numbering", (GObject*) _tmp73_, "show-numbering", G_SETTINGS_BIND_GET);
#line 189 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp74_ = self->priv->settings;
#line 189 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp75_ = self->priv->scene;
#line 189 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_settings_bind (_tmp74_, "piece-theme", (GObject*) _tmp75_, "theme-name", G_SETTINGS_BIND_GET);
#line 190 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp76_ = self->priv->settings;
#line 190 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp77_ = self->priv->scene;
#line 190 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_settings_bind (_tmp76_, "move-format", (GObject*) _tmp77_, "move-format", G_SETTINGS_BIND_GET);
#line 191 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp78_ = self->priv->settings;
#line 191 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp79_ = self->priv->scene;
#line 191 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_settings_bind (_tmp78_, "board-side", (GObject*) _tmp79_, "board-side", G_SETTINGS_BIND_GET);
#line 193 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp80_ = chess_view_new ();
#line 193 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_object_ref_sink (_tmp80_);
#line 193 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->view);
#line 193 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	self->priv->view = _tmp80_;
#line 194 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp81_ = self->priv->view;
#line 194 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_widget_set_size_request ((GtkWidget*) _tmp81_, 400, 400);
#line 195 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp82_ = self->priv->view;
#line 195 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp83_ = self->priv->scene;
#line 195 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	chess_view_set_scene (_tmp82_, _tmp83_);
#line 196 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp84_ = self->priv->view_container;
#line 196 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp85_ = self->priv->view;
#line 196 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_container_add (_tmp84_, (GtkWidget*) _tmp85_);
#line 197 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp86_ = self->priv->view;
#line 197 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_widget_show ((GtkWidget*) _tmp86_);
#line 199 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp87_ = g_build_filename (SYSCONFDIR, "gnome-chess", "engines.conf", NULL, NULL);
#line 199 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	system_engine_cfg = _tmp87_;
#line 200 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp88_ = g_get_user_config_dir ();
#line 200 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp89_ = g_build_filename (_tmp88_, "gnome-chess", "engines.conf", NULL, NULL);
#line 200 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	user_engine_cfg = _tmp89_;
#line 201 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp90_ = user_engine_cfg;
#line 201 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp91_ = g_file_test (_tmp90_, G_FILE_TEST_EXISTS);
#line 201 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp91_) {
#line 1252 "gnome-chess.c"
		const gchar* _tmp92_;
		GList* _tmp93_;
#line 202 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp92_ = user_engine_cfg;
#line 202 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp93_ = ai_profile_load_ai_profiles (_tmp92_);
#line 202 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		__g_list_free__g_object_unref0_0 (self->priv->ai_profiles);
#line 202 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		self->priv->ai_profiles = _tmp93_;
#line 1263 "gnome-chess.c"
	} else {
		const gchar* _tmp94_;
		gboolean _tmp95_;
#line 203 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp94_ = system_engine_cfg;
#line 203 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp95_ = g_file_test (_tmp94_, G_FILE_TEST_EXISTS);
#line 203 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		if (_tmp95_) {
#line 1273 "gnome-chess.c"
			const gchar* _tmp96_;
			GList* _tmp97_;
#line 204 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp96_ = system_engine_cfg;
#line 204 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp97_ = ai_profile_load_ai_profiles (_tmp96_);
#line 204 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			__g_list_free__g_object_unref0_0 (self->priv->ai_profiles);
#line 204 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			self->priv->ai_profiles = _tmp97_;
#line 1284 "gnome-chess.c"
		} else {
#line 206 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			g_warning ("gnome-chess.vala:206: engines.conf not found");
#line 1288 "gnome-chess.c"
		}
	}
#line 208 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp98_ = self->priv->ai_profiles;
#line 208 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp98_ == NULL) {
#line 209 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		chess_application_display_no_engine_info_bar (self);
#line 1297 "gnome-chess.c"
	}
#line 211 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp99_ = self->priv->ai_profiles;
#line 1301 "gnome-chess.c"
	{
		GList* profile_collection = NULL;
		GList* profile_it = NULL;
#line 211 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		profile_collection = _tmp99_;
#line 211 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		for (profile_it = profile_collection; profile_it != NULL; profile_it = profile_it->next) {
#line 1309 "gnome-chess.c"
			AIProfile* _tmp100_;
			AIProfile* profile = NULL;
#line 211 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp100_ = _g_object_ref0 ((AIProfile*) profile_it->data);
#line 211 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			profile = _tmp100_;
#line 1316 "gnome-chess.c"
			{
				AIProfile* _tmp101_;
				const gchar* _tmp102_;
				const gchar* _tmp103_;
				AIProfile* _tmp104_;
				const gchar* _tmp105_;
				const gchar* _tmp106_;
#line 212 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp101_ = profile;
#line 212 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp102_ = ai_profile_get_name (_tmp101_);
#line 212 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp103_ = _tmp102_;
#line 212 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp104_ = profile;
#line 212 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp105_ = ai_profile_get_path (_tmp104_);
#line 212 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp106_ = _tmp105_;
#line 212 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				g_debug ("gnome-chess.vala:212: Detected AI profile %s in %s", _tmp103_, _tmp106_);
#line 211 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_g_object_unref0 (profile);
#line 1340 "gnome-chess.c"
			}
		}
	}
#line 142 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_free0 (user_engine_cfg);
#line 142 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_free0 (system_engine_cfg);
#line 142 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (builder);
#line 1350 "gnome-chess.c"
}


static void chess_application_real_open (GApplication* base, GFile** files, int files_length1, const gchar* hint) {
	ChessApplication * self;
	GFile** _tmp0_;
	gint _tmp0__length1;
	GFile** _tmp1_;
	gint _tmp1__length1;
	GFile* _tmp2_;
	GFile* _tmp3_;
#line 215 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	self = (ChessApplication*) base;
#line 215 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (hint != NULL);
#line 217 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = files;
#line 217 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp0__length1 = files_length1;
#line 217 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp0__length1 != 1) {
#line 220 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		g_warning ("gnome-chess.vala:220: %s", _ ("GNOME Chess can only open one PGN at a time."));
#line 1374 "gnome-chess.c"
	}
#line 223 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = files;
#line 223 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp1__length1 = files_length1;
#line 223 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = _tmp1_[0];
#line 223 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 223 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->game_file);
#line 223 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	self->priv->game_file = _tmp3_;
#line 224 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_application_activate ((GApplication*) self);
#line 1390 "gnome-chess.c"
}


static void chess_application_real_activate (GApplication* base) {
	ChessApplication * self;
	GtkApplicationWindow* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GtkApplicationWindow* _tmp28_;
	GError * _inner_error_ = NULL;
#line 227 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	self = (ChessApplication*) base;
#line 229 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->window;
#line 229 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = gtk_widget_get_visible ((GtkWidget*) _tmp0_);
#line 229 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = _tmp1_;
#line 229 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (!_tmp2_) {
#line 1411 "gnome-chess.c"
		GFile* data_dir;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		GFile* _tmp6_;
		GFile* _tmp7_;
		GFile* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		GFile* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gboolean _tmp15_ = FALSE;
		GFile* _tmp16_;
		GFile* _tmp21_;
#line 231 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp3_ = g_get_user_data_dir ();
#line 231 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp4_ = g_build_filename (_tmp3_, "gnome-chess", NULL, NULL);
#line 231 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp5_ = _tmp4_;
#line 231 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp6_ = g_file_new_for_path (_tmp5_);
#line 231 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp7_ = _tmp6_;
#line 231 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_g_free0 (_tmp5_);
#line 231 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		data_dir = _tmp7_;
#line 232 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp8_ = data_dir;
#line 232 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp9_ = g_file_get_path (_tmp8_);
#line 232 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp10_ = _tmp9_;
#line 232 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		g_mkdir_with_parents (_tmp10_, 0755);
#line 232 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_g_free0 (_tmp10_);
#line 234 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp11_ = data_dir;
#line 234 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp12_ = g_file_get_path (_tmp11_);
#line 234 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp13_ = _tmp12_;
#line 234 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp14_ = g_strconcat (_tmp13_, "/autosave.pgn", NULL);
#line 234 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_g_free0 (self->priv->autosave_filename);
#line 234 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		self->priv->autosave_filename = _tmp14_;
#line 234 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_g_free0 (_tmp13_);
#line 237 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp16_ = self->priv->game_file;
#line 237 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		if (_tmp16_ == NULL) {
#line 1470 "gnome-chess.c"
			const gchar* _tmp17_;
			gboolean _tmp18_;
#line 237 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp17_ = self->priv->autosave_filename;
#line 237 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp18_ = g_file_test (_tmp17_, G_FILE_TEST_EXISTS);
#line 237 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp15_ = _tmp18_;
#line 1479 "gnome-chess.c"
		} else {
#line 237 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp15_ = FALSE;
#line 1483 "gnome-chess.c"
		}
#line 237 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		if (_tmp15_) {
#line 1487 "gnome-chess.c"
			const gchar* _tmp19_;
			GFile* _tmp20_;
#line 238 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp19_ = self->priv->autosave_filename;
#line 238 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp20_ = g_file_new_for_path (_tmp19_);
#line 238 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_g_object_unref0 (self->priv->game_file);
#line 238 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			self->priv->game_file = _tmp20_;
#line 1498 "gnome-chess.c"
		}
#line 240 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp21_ = self->priv->game_file;
#line 240 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		if (_tmp21_ == NULL) {
#line 242 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			chess_application_start_new_game (self);
#line 1506 "gnome-chess.c"
		} else {
			{
				GFile* _tmp22_;
#line 248 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp22_ = self->priv->game_file;
#line 248 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				chess_application_load_game (self, _tmp22_, &_inner_error_);
#line 248 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1516 "gnome-chess.c"
					goto __catch0_g_error;
				}
			}
			goto __finally0;
			__catch0_g_error:
			{
				GError* e = NULL;
				GFile* _tmp23_;
				gchar* _tmp24_;
				gchar* _tmp25_;
				GError* _tmp26_;
				const gchar* _tmp27_;
#line 246 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				e = _inner_error_;
#line 246 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_inner_error_ = NULL;
#line 252 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp23_ = self->priv->game_file;
#line 252 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp24_ = g_file_get_path (_tmp23_);
#line 252 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp25_ = _tmp24_;
#line 252 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp26_ = e;
#line 252 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp27_ = _tmp26_->message;
#line 252 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				g_warning ("gnome-chess.vala:252: Failed to load %s: %s\n", _tmp25_, _tmp27_);
#line 252 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_g_free0 (_tmp25_);
#line 253 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				g_application_quit ((GApplication*) self);
#line 246 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_g_error_free0 (e);
#line 1551 "gnome-chess.c"
			}
			__finally0:
#line 246 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 246 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_g_object_unref0 (data_dir);
#line 246 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 246 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				g_clear_error (&_inner_error_);
#line 246 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				return;
#line 1564 "gnome-chess.c"
			}
		}
#line 229 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (data_dir);
#line 1569 "gnome-chess.c"
	}
#line 258 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp28_ = self->priv->window;
#line 258 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_window_present ((GtkWindow*) _tmp28_);
#line 1575 "gnome-chess.c"
}


static void chess_application_real_shutdown (GApplication* base) {
	ChessApplication * self;
	ChessEngine* _tmp0_;
	GSettings* _tmp2_;
	gint _tmp3_;
	GSettings* _tmp4_;
	gint _tmp5_;
	GSettings* _tmp6_;
	gboolean _tmp7_;
#line 261 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	self = (ChessApplication*) base;
#line 263 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->opponent_engine;
#line 263 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp0_ != NULL) {
#line 1594 "gnome-chess.c"
		ChessEngine* _tmp1_;
#line 264 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp1_ = self->priv->opponent_engine;
#line 264 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		chess_engine_stop (_tmp1_, TRUE);
#line 1600 "gnome-chess.c"
	}
#line 266 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	G_APPLICATION_CLASS (chess_application_parent_class)->shutdown ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
#line 269 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = self->priv->settings;
#line 269 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = self->priv->window_width;
#line 269 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_settings_set_int (_tmp2_, "width", _tmp3_);
#line 270 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = self->priv->settings;
#line 270 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = self->priv->window_height;
#line 270 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_settings_set_int (_tmp4_, "height", _tmp5_);
#line 271 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = self->priv->settings;
#line 271 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = self->priv->is_maximized;
#line 271 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_settings_set_boolean (_tmp6_, "maximized", _tmp7_);
#line 1622 "gnome-chess.c"
}


static void chess_application_size_allocate_cb (ChessApplication* self, GtkAllocation* allocation) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	GtkApplicationWindow* _tmp3_;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
#line 274 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 274 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (allocation != NULL);
#line 276 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = self->priv->is_maximized;
#line 276 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp1_) {
#line 276 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp0_ = TRUE;
#line 1642 "gnome-chess.c"
	} else {
		gboolean _tmp2_;
#line 276 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp2_ = self->priv->is_tiled;
#line 276 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp0_ = _tmp2_;
#line 1649 "gnome-chess.c"
	}
#line 276 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp0_) {
#line 277 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		return;
#line 1655 "gnome-chess.c"
	}
#line 278 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = self->priv->window;
#line 278 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_window_get_size ((GtkWindow*) _tmp3_, &_tmp4_, &_tmp5_);
#line 278 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	self->priv->window_width = _tmp4_;
#line 278 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	self->priv->window_height = _tmp5_;
#line 1665 "gnome-chess.c"
}


static gboolean chess_application_window_state_event_cb (ChessApplication* self, GdkEventWindowState* event) {
	gboolean result = FALSE;
	GdkEventWindowState* _tmp0_;
	GdkWindowState _tmp1_;
	GdkEventWindowState* _tmp4_;
	GdkWindowState _tmp5_;
#line 281 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 281 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 283 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = event;
#line 283 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = _tmp0_->changed_mask;
#line 283 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if ((_tmp1_ & GDK_WINDOW_STATE_MAXIMIZED) != 0) {
#line 1685 "gnome-chess.c"
		GdkEventWindowState* _tmp2_;
		GdkWindowState _tmp3_;
#line 284 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp2_ = event;
#line 284 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp3_ = _tmp2_->new_window_state;
#line 284 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		self->priv->is_maximized = (_tmp3_ & GDK_WINDOW_STATE_MAXIMIZED) != 0;
#line 1694 "gnome-chess.c"
	}
#line 286 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = event;
#line 286 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = _tmp4_->changed_mask;
#line 286 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if ((_tmp5_ & GDK_WINDOW_STATE_TILED) != 0) {
#line 1702 "gnome-chess.c"
		GdkEventWindowState* _tmp6_;
		GdkWindowState _tmp7_;
#line 287 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp6_ = event;
#line 287 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp7_ = _tmp6_->new_window_state;
#line 287 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		self->priv->is_tiled = (_tmp7_ & GDK_WINDOW_STATE_TILED) != 0;
#line 1711 "gnome-chess.c"
	}
#line 288 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	result = FALSE;
#line 288 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	return result;
#line 1717 "gnome-chess.c"
}


static PieceType* _piece_type_dup (PieceType* self) {
	PieceType* dup;
#line 323 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	dup = g_new0 (PieceType, 1);
#line 323 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	memcpy (dup, self, sizeof (PieceType));
#line 323 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	return dup;
#line 1729 "gnome-chess.c"
}


static gpointer __piece_type_dup0 (gpointer self) {
#line 323 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	return self ? _piece_type_dup (self) : NULL;
#line 1736 "gnome-chess.c"
}


PieceType* chess_application_show_promotion_type_selector (ChessApplication* self) {
	PieceType* result = NULL;
	GtkBuilder* promotion_type_selector_builder;
	GtkBuilder* _tmp0_;
	GtkDialog* promotion_type_selector_dialog;
	GtkBuilder* _tmp1_;
	GObject* _tmp2_;
	GtkDialog* _tmp3_;
	GtkDialog* _tmp4_;
	GtkApplicationWindow* _tmp5_;
	gchar* color = NULL;
	ChessGame* _tmp6_;
	ChessPlayer* _tmp7_;
	ChessPlayer* _tmp8_;
	Color _tmp9_;
	gchar* filename;
	ChessScene* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	GtkBuilder* _tmp20_;
	GObject* _tmp21_;
	const gchar* _tmp22_;
	ChessScene* _tmp23_;
	const gchar* _tmp24_;
	const gchar* _tmp25_;
	const gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	GtkBuilder* _tmp30_;
	GObject* _tmp31_;
	const gchar* _tmp32_;
	ChessScene* _tmp33_;
	const gchar* _tmp34_;
	const gchar* _tmp35_;
	const gchar* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	GtkBuilder* _tmp40_;
	GObject* _tmp41_;
	const gchar* _tmp42_;
	ChessScene* _tmp43_;
	const gchar* _tmp44_;
	const gchar* _tmp45_;
	const gchar* _tmp46_;
	gchar* _tmp47_;
	gchar* _tmp48_;
	gchar* _tmp49_;
	GtkBuilder* _tmp50_;
	GObject* _tmp51_;
	const gchar* _tmp52_;
	GtkBuilder* _tmp53_;
	PieceType* selection;
	gint choice;
	GtkDialog* _tmp54_;
	gint _tmp55_;
	gint _tmp56_;
	GtkDialog* _tmp65_;
#line 291 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 293 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = gtk_builder_new_from_resource ("/org/gnome/chess/ui/promotion-type-selector.ui");
#line 293 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	promotion_type_selector_builder = _tmp0_;
#line 295 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = promotion_type_selector_builder;
#line 295 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = gtk_builder_get_object (_tmp1_, "dialog_promotion_type_selector");
#line 295 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gtk_dialog_get_type ()) ? ((GtkDialog*) _tmp2_) : NULL);
#line 295 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	promotion_type_selector_dialog = _tmp3_;
#line 296 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = promotion_type_selector_dialog;
#line 296 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = self->priv->window;
#line 296 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_window_set_transient_for ((GtkWindow*) _tmp4_, (GtkWindow*) _tmp5_);
#line 299 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = self->priv->game;
#line 299 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = chess_game_get_current_player (_tmp6_);
#line 299 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp8_ = _tmp7_;
#line 299 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp9_ = _tmp8_->color;
#line 299 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp9_ == COLOR_WHITE) {
#line 1834 "gnome-chess.c"
		gchar* _tmp10_;
#line 300 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp10_ = g_strdup ("white");
#line 300 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_g_free0 (color);
#line 300 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		color = _tmp10_;
#line 1842 "gnome-chess.c"
	} else {
		gchar* _tmp11_;
#line 302 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp11_ = g_strdup ("black");
#line 302 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_g_free0 (color);
#line 302 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		color = _tmp11_;
#line 1851 "gnome-chess.c"
	}
#line 304 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp12_ = self->priv->scene;
#line 304 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp13_ = chess_scene_get_theme_name (_tmp12_);
#line 304 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp14_ = _tmp13_;
#line 304 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp15_ = color;
#line 304 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp16_ = g_strdup_printf ("%sQueen.svg", _tmp15_);
#line 304 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp17_ = _tmp16_;
#line 304 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp18_ = g_build_filename (PKGDATADIR, "pieces", _tmp14_, _tmp17_, NULL);
#line 304 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp19_ = _tmp18_;
#line 304 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_free0 (_tmp17_);
#line 304 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	filename = _tmp19_;
#line 305 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp20_ = promotion_type_selector_builder;
#line 305 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp21_ = gtk_builder_get_object (_tmp20_, "image_queen");
#line 305 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp22_ = filename;
#line 305 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	chess_application_set_piece_image (self, G_TYPE_CHECK_INSTANCE_TYPE (_tmp21_, gtk_image_get_type ()) ? ((GtkImage*) _tmp21_) : NULL, _tmp22_);
#line 307 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp23_ = self->priv->scene;
#line 307 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp24_ = chess_scene_get_theme_name (_tmp23_);
#line 307 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp25_ = _tmp24_;
#line 307 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp26_ = color;
#line 307 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp27_ = g_strdup_printf ("%sKnight.svg", _tmp26_);
#line 307 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp28_ = _tmp27_;
#line 307 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp29_ = g_build_filename (PKGDATADIR, "pieces", _tmp25_, _tmp28_, NULL);
#line 307 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_free0 (filename);
#line 307 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	filename = _tmp29_;
#line 307 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_free0 (_tmp28_);
#line 308 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp30_ = promotion_type_selector_builder;
#line 308 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp31_ = gtk_builder_get_object (_tmp30_, "image_knight");
#line 308 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp32_ = filename;
#line 308 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	chess_application_set_piece_image (self, G_TYPE_CHECK_INSTANCE_TYPE (_tmp31_, gtk_image_get_type ()) ? ((GtkImage*) _tmp31_) : NULL, _tmp32_);
#line 310 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp33_ = self->priv->scene;
#line 310 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp34_ = chess_scene_get_theme_name (_tmp33_);
#line 310 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp35_ = _tmp34_;
#line 310 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp36_ = color;
#line 310 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp37_ = g_strdup_printf ("%sRook.svg", _tmp36_);
#line 310 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp38_ = _tmp37_;
#line 310 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp39_ = g_build_filename (PKGDATADIR, "pieces", _tmp35_, _tmp38_, NULL);
#line 310 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_free0 (filename);
#line 310 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	filename = _tmp39_;
#line 310 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_free0 (_tmp38_);
#line 311 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp40_ = promotion_type_selector_builder;
#line 311 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp41_ = gtk_builder_get_object (_tmp40_, "image_rook");
#line 311 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp42_ = filename;
#line 311 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	chess_application_set_piece_image (self, G_TYPE_CHECK_INSTANCE_TYPE (_tmp41_, gtk_image_get_type ()) ? ((GtkImage*) _tmp41_) : NULL, _tmp42_);
#line 313 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp43_ = self->priv->scene;
#line 313 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp44_ = chess_scene_get_theme_name (_tmp43_);
#line 313 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp45_ = _tmp44_;
#line 313 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp46_ = color;
#line 313 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp47_ = g_strdup_printf ("%sBishop.svg", _tmp46_);
#line 313 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp48_ = _tmp47_;
#line 313 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp49_ = g_build_filename (PKGDATADIR, "pieces", _tmp45_, _tmp48_, NULL);
#line 313 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_free0 (filename);
#line 313 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	filename = _tmp49_;
#line 313 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_free0 (_tmp48_);
#line 314 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp50_ = promotion_type_selector_builder;
#line 314 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp51_ = gtk_builder_get_object (_tmp50_, "image_bishop");
#line 314 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp52_ = filename;
#line 314 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	chess_application_set_piece_image (self, G_TYPE_CHECK_INSTANCE_TYPE (_tmp51_, gtk_image_get_type ()) ? ((GtkImage*) _tmp51_) : NULL, _tmp52_);
#line 316 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp53_ = promotion_type_selector_builder;
#line 316 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_builder_connect_signals (_tmp53_, self);
#line 318 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	selection = NULL;
#line 319 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp54_ = promotion_type_selector_dialog;
#line 319 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp55_ = gtk_dialog_run (_tmp54_);
#line 319 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	choice = _tmp55_;
#line 320 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp56_ = choice;
#line 320 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	switch (_tmp56_) {
#line 320 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		case CHESS_APPLICATION_PROMOTION_TYPE_SELECTED_QUEEN:
#line 1983 "gnome-chess.c"
		{
			PieceType _tmp57_;
			PieceType* _tmp58_;
#line 323 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp57_ = PIECE_TYPE_QUEEN;
#line 323 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp58_ = __piece_type_dup0 (&_tmp57_);
#line 323 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_g_free0 (selection);
#line 323 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			selection = _tmp58_;
#line 324 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			break;
#line 1997 "gnome-chess.c"
		}
#line 320 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		case CHESS_APPLICATION_PROMOTION_TYPE_SELECTED_KNIGHT:
#line 2001 "gnome-chess.c"
		{
			PieceType _tmp59_;
			PieceType* _tmp60_;
#line 326 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp59_ = PIECE_TYPE_KNIGHT;
#line 326 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp60_ = __piece_type_dup0 (&_tmp59_);
#line 326 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_g_free0 (selection);
#line 326 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			selection = _tmp60_;
#line 327 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			break;
#line 2015 "gnome-chess.c"
		}
#line 320 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		case CHESS_APPLICATION_PROMOTION_TYPE_SELECTED_ROOK:
#line 2019 "gnome-chess.c"
		{
			PieceType _tmp61_;
			PieceType* _tmp62_;
#line 329 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp61_ = PIECE_TYPE_ROOK;
#line 329 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp62_ = __piece_type_dup0 (&_tmp61_);
#line 329 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_g_free0 (selection);
#line 329 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			selection = _tmp62_;
#line 330 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			break;
#line 2033 "gnome-chess.c"
		}
#line 320 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		case CHESS_APPLICATION_PROMOTION_TYPE_SELECTED_BISHOP:
#line 2037 "gnome-chess.c"
		{
			PieceType _tmp63_;
			PieceType* _tmp64_;
#line 332 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp63_ = PIECE_TYPE_BISHOP;
#line 332 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp64_ = __piece_type_dup0 (&_tmp63_);
#line 332 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_g_free0 (selection);
#line 332 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			selection = _tmp64_;
#line 333 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			break;
#line 2051 "gnome-chess.c"
		}
		default:
#line 320 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		break;
#line 2056 "gnome-chess.c"
	}
#line 335 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp65_ = promotion_type_selector_dialog;
#line 335 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp65_);
#line 337 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	result = selection;
#line 337 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_free0 (filename);
#line 337 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_free0 (color);
#line 337 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (promotion_type_selector_dialog);
#line 337 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (promotion_type_selector_builder);
#line 337 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	return result;
#line 2074 "gnome-chess.c"
}


static void chess_application_set_piece_image (ChessApplication* self, GtkImage* image, const gchar* filename) {
	gint width = 0;
	gint height = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gboolean _tmp2_;
	GError * _inner_error_ = NULL;
#line 340 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 340 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (image != NULL);
#line 340 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (filename != NULL);
#line 343 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = gtk_icon_size_lookup (GTK_ICON_SIZE_DIALOG, &_tmp0_, &_tmp1_);
#line 343 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	width = _tmp0_;
#line 343 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	height = _tmp1_;
#line 343 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (!_tmp2_) {
#line 344 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		return;
#line 2101 "gnome-chess.c"
	}
	{
		RsvgHandle* h;
		const gchar* _tmp3_;
		RsvgHandle* _tmp4_;
		cairo_surface_t* s;
		gint _tmp5_;
		gint _tmp6_;
		cairo_surface_t* _tmp7_;
		cairo_t* c;
		cairo_surface_t* _tmp8_;
		cairo_t* _tmp9_;
		cairo_matrix_t m;
		gint _tmp10_;
		RsvgHandle* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		RsvgHandle* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		cairo_t* _tmp18_;
		cairo_matrix_t _tmp19_;
		RsvgHandle* _tmp20_;
		cairo_t* _tmp21_;
		GdkPixbuf* p;
		cairo_surface_t* _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		GdkPixbuf* _tmp25_;
		GtkImage* _tmp26_;
		GdkPixbuf* _tmp27_;
#line 348 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp3_ = filename;
#line 348 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp4_ = rsvg_handle_new_from_file (_tmp3_, &_inner_error_);
#line 348 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		h = _tmp4_;
#line 348 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2142 "gnome-chess.c"
			goto __catch1_g_error;
		}
#line 350 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp5_ = width;
#line 350 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp6_ = height;
#line 350 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp7_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, _tmp5_, _tmp6_);
#line 350 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		s = _tmp7_;
#line 351 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp8_ = s;
#line 351 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp9_ = cairo_create (_tmp8_);
#line 351 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		c = _tmp9_;
#line 352 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		cairo_matrix_init_identity (&m);
#line 353 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp10_ = width;
#line 353 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp11_ = h;
#line 353 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		g_object_get (_tmp11_, "width", &_tmp12_, NULL);
#line 353 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp13_ = _tmp12_;
#line 353 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp14_ = height;
#line 353 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp15_ = h;
#line 353 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		g_object_get (_tmp15_, "height", &_tmp16_, NULL);
#line 353 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp17_ = _tmp16_;
#line 353 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		cairo_matrix_scale (&m, ((gdouble) _tmp10_) / _tmp13_, ((gdouble) _tmp14_) / _tmp17_);
#line 354 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp18_ = c;
#line 354 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp19_ = m;
#line 354 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		cairo_set_matrix (_tmp18_, &_tmp19_);
#line 355 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp20_ = h;
#line 355 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp21_ = c;
#line 355 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		rsvg_handle_render_cairo (_tmp20_, _tmp21_);
#line 357 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp22_ = s;
#line 357 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp23_ = width;
#line 357 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp24_ = height;
#line 357 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp25_ = gdk_pixbuf_get_from_surface (_tmp22_, 0, 0, _tmp23_, _tmp24_);
#line 357 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		p = _tmp25_;
#line 358 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp26_ = image;
#line 358 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp27_ = p;
#line 358 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		gtk_image_set_from_pixbuf (_tmp26_, _tmp27_);
#line 346 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (p);
#line 346 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_cairo_destroy0 (c);
#line 346 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_cairo_surface_destroy0 (s);
#line 346 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (h);
#line 2215 "gnome-chess.c"
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp28_;
		GError* _tmp29_;
		const gchar* _tmp30_;
#line 346 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		e = _inner_error_;
#line 346 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_inner_error_ = NULL;
#line 362 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp28_ = filename;
#line 362 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp29_ = e;
#line 362 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp30_ = _tmp29_->message;
#line 362 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		g_warning ("gnome-chess.vala:362: Failed to load image %s: %s", _tmp28_, _tmp30_);
#line 363 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_g_error_free0 (e);
#line 363 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		return;
#line 2240 "gnome-chess.c"
	}
	__finally1:
#line 346 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 346 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 346 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		g_clear_error (&_inner_error_);
#line 346 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		return;
#line 2251 "gnome-chess.c"
	}
}


void chess_application_quit_game (ChessApplication* self) {
	guint _tmp0_;
	GtkApplicationWindow* _tmp1_;
#line 375 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 377 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->save_duration_timeout;
#line 377 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp0_ != ((guint) 0)) {
#line 378 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		chess_application_save_duration_cb (self);
#line 2267 "gnome-chess.c"
	}
#line 380 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	chess_application_autosave (self);
#line 381 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = self->priv->window;
#line 381 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp1_);
#line 2275 "gnome-chess.c"
}


static void chess_application_autosave (ChessApplication* self) {
	gboolean _tmp0_;
	GError * _inner_error_ = NULL;
#line 384 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 387 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->game_needs_saving;
#line 387 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (!_tmp0_) {
#line 2288 "gnome-chess.c"
		const gchar* _tmp1_;
#line 389 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp1_ = self->priv->autosave_filename;
#line 389 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		g_remove (_tmp1_);
#line 390 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		return;
#line 2296 "gnome-chess.c"
	}
	{
		GFile* autosave_file;
		const gchar* _tmp2_;
		GFile* _tmp3_;
		GFile* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		PGNGame* _tmp7_;
		GFile* _tmp8_;
#line 395 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp2_ = self->priv->autosave_filename;
#line 395 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp3_ = g_file_new_for_path (_tmp2_);
#line 395 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		autosave_file = _tmp3_;
#line 396 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp4_ = autosave_file;
#line 396 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp5_ = g_file_get_path (_tmp4_);
#line 396 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp6_ = _tmp5_;
#line 396 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		g_debug ("gnome-chess.vala:396: Writing current game to %s", _tmp6_);
#line 396 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_g_free0 (_tmp6_);
#line 397 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		chess_application_update_pgn_time_remaining (self);
#line 398 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp7_ = self->priv->pgn_game;
#line 398 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp8_ = autosave_file;
#line 398 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		pgn_game_write (_tmp7_, _tmp8_, &_inner_error_);
#line 398 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 398 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_g_object_unref0 (autosave_file);
#line 2335 "gnome-chess.c"
			goto __catch2_g_error;
		}
#line 393 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (autosave_file);
#line 2340 "gnome-chess.c"
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		GError* _tmp9_;
		const gchar* _tmp10_;
#line 393 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		e = _inner_error_;
#line 393 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_inner_error_ = NULL;
#line 402 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp9_ = e;
#line 402 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp10_ = _tmp9_->message;
#line 402 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		g_warning ("gnome-chess.vala:402: Failed to autosave: %s", _tmp10_);
#line 393 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_g_error_free0 (e);
#line 2360 "gnome-chess.c"
	}
	__finally2:
#line 393 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 393 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 393 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		g_clear_error (&_inner_error_);
#line 393 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		return;
#line 2371 "gnome-chess.c"
	}
}


static void chess_application_update_history_panel (ChessApplication* self) {
	ChessGame* _tmp0_;
	gint move_number;
	ChessScene* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint n_moves;
	ChessGame* _tmp4_;
	guint _tmp5_;
	guint _tmp6_;
	gint _tmp7_;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	gint _tmp12_;
	GtkWidget* _tmp17_;
	gboolean _tmp18_ = FALSE;
	gint _tmp19_;
	GtkWidget* _tmp23_;
	gboolean _tmp24_ = FALSE;
	gint _tmp25_;
	gint _tmp26_;
	GtkWidget* _tmp30_;
	gboolean _tmp31_ = FALSE;
	gboolean _tmp32_ = FALSE;
	gint _tmp33_;
	GtkWidget* _tmp39_;
	GtkComboBox* _tmp40_;
	ChessGame* _tmp41_;
	gboolean _tmp42_;
	gboolean _tmp43_;
	gint i;
	gint _tmp44_;
	ChessGame* _tmp45_;
	GList* _tmp46_;
	GtkComboBox* _tmp60_;
	gint _tmp61_;
#line 406 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 408 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->game;
#line 408 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp0_ == NULL) {
#line 409 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		return;
#line 2420 "gnome-chess.c"
	}
#line 411 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = self->priv->scene;
#line 411 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = chess_scene_get_move_number (_tmp1_);
#line 411 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = _tmp2_;
#line 411 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	move_number = _tmp3_;
#line 412 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = self->priv->game;
#line 412 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = chess_game_get_n_moves (_tmp4_);
#line 412 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = _tmp5_;
#line 412 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	n_moves = (gint) _tmp6_;
#line 413 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = move_number;
#line 413 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp7_ < 0) {
#line 2442 "gnome-chess.c"
		gint _tmp8_;
		gint _tmp9_;
#line 414 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp8_ = move_number;
#line 414 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp9_ = n_moves;
#line 414 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		move_number = _tmp8_ + (1 + _tmp9_);
#line 2451 "gnome-chess.c"
	}
#line 416 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp12_ = n_moves;
#line 416 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp12_ > 0) {
#line 2457 "gnome-chess.c"
		gint _tmp13_;
#line 416 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp13_ = move_number;
#line 416 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp11_ = _tmp13_ != 0;
#line 2463 "gnome-chess.c"
	} else {
#line 416 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp11_ = FALSE;
#line 2467 "gnome-chess.c"
	}
#line 416 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp11_) {
#line 2471 "gnome-chess.c"
		ChessGame* _tmp14_;
		gboolean _tmp15_;
		gboolean _tmp16_;
#line 416 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp14_ = self->priv->game;
#line 416 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp15_ = chess_game_get_is_paused (_tmp14_);
#line 416 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp16_ = _tmp15_;
#line 416 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp10_ = !_tmp16_;
#line 2483 "gnome-chess.c"
	} else {
#line 416 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp10_ = FALSE;
#line 2487 "gnome-chess.c"
	}
#line 416 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp17_ = self->priv->first_move_button;
#line 416 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_widget_set_sensitive (_tmp17_, _tmp10_);
#line 417 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp19_ = move_number;
#line 417 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp19_ > 0) {
#line 2497 "gnome-chess.c"
		ChessGame* _tmp20_;
		gboolean _tmp21_;
		gboolean _tmp22_;
#line 417 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp20_ = self->priv->game;
#line 417 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp21_ = chess_game_get_is_paused (_tmp20_);
#line 417 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp22_ = _tmp21_;
#line 417 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp18_ = !_tmp22_;
#line 2509 "gnome-chess.c"
	} else {
#line 417 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp18_ = FALSE;
#line 2513 "gnome-chess.c"
	}
#line 417 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp23_ = self->priv->prev_move_button;
#line 417 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_widget_set_sensitive (_tmp23_, _tmp18_);
#line 418 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp25_ = move_number;
#line 418 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp26_ = n_moves;
#line 418 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp25_ < _tmp26_) {
#line 2525 "gnome-chess.c"
		ChessGame* _tmp27_;
		gboolean _tmp28_;
		gboolean _tmp29_;
#line 418 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp27_ = self->priv->game;
#line 418 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp28_ = chess_game_get_is_paused (_tmp27_);
#line 418 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp29_ = _tmp28_;
#line 418 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp24_ = !_tmp29_;
#line 2537 "gnome-chess.c"
	} else {
#line 418 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp24_ = FALSE;
#line 2541 "gnome-chess.c"
	}
#line 418 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp30_ = self->priv->next_move_button;
#line 418 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_widget_set_sensitive (_tmp30_, _tmp24_);
#line 419 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp33_ = n_moves;
#line 419 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp33_ > 0) {
#line 2551 "gnome-chess.c"
		gint _tmp34_;
		gint _tmp35_;
#line 419 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp34_ = move_number;
#line 419 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp35_ = n_moves;
#line 419 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp32_ = _tmp34_ != _tmp35_;
#line 2560 "gnome-chess.c"
	} else {
#line 419 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp32_ = FALSE;
#line 2564 "gnome-chess.c"
	}
#line 419 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp32_) {
#line 2568 "gnome-chess.c"
		ChessGame* _tmp36_;
		gboolean _tmp37_;
		gboolean _tmp38_;
#line 419 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp36_ = self->priv->game;
#line 419 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp37_ = chess_game_get_is_paused (_tmp36_);
#line 419 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp38_ = _tmp37_;
#line 419 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp31_ = !_tmp38_;
#line 2580 "gnome-chess.c"
	} else {
#line 419 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp31_ = FALSE;
#line 2584 "gnome-chess.c"
	}
#line 419 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp39_ = self->priv->last_move_button;
#line 419 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_widget_set_sensitive (_tmp39_, _tmp31_);
#line 420 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp40_ = self->priv->history_combo;
#line 420 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp41_ = self->priv->game;
#line 420 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp42_ = chess_game_get_is_paused (_tmp41_);
#line 420 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp43_ = _tmp42_;
#line 420 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp40_, !_tmp43_);
#line 423 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp44_ = n_moves;
#line 423 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	i = _tmp44_;
#line 424 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp45_ = self->priv->game;
#line 424 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp46_ = _tmp45_->move_stack;
#line 2608 "gnome-chess.c"
	{
		GList* state_collection = NULL;
		GList* state_it = NULL;
#line 424 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		state_collection = _tmp46_;
#line 424 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		for (state_it = state_collection; state_it != NULL; state_it = state_it->next) {
#line 2616 "gnome-chess.c"
			ChessState* _tmp47_;
			ChessState* state = NULL;
#line 424 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp47_ = _g_object_ref0 ((ChessState*) state_it->data);
#line 424 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			state = _tmp47_;
#line 2623 "gnome-chess.c"
			{
				ChessState* _tmp48_;
				ChessMove* _tmp49_;
				gint _tmp59_;
#line 426 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp48_ = state;
#line 426 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp49_ = _tmp48_->last_move;
#line 426 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				if (_tmp49_ != NULL) {
#line 2634 "gnome-chess.c"
					GtkTreeIter iter = {0};
					GtkComboBox* _tmp50_;
					GtkTreeModel* _tmp51_;
					GtkTreeModel* _tmp52_;
					gint _tmp53_;
					GtkTreeIter _tmp54_ = {0};
					gboolean _tmp55_;
#line 429 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					_tmp50_ = self->priv->history_combo;
#line 429 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					_tmp51_ = gtk_combo_box_get_model (_tmp50_);
#line 429 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					_tmp52_ = _tmp51_;
#line 429 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					_tmp53_ = i;
#line 429 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					_tmp55_ = gtk_tree_model_iter_nth_child (_tmp52_, &_tmp54_, NULL, _tmp53_);
#line 429 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					iter = _tmp54_;
#line 429 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					if (_tmp55_) {
#line 2656 "gnome-chess.c"
						GtkTreeIter _tmp56_;
						ChessState* _tmp57_;
						ChessMove* _tmp58_;
#line 430 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
						_tmp56_ = iter;
#line 430 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
						_tmp57_ = state;
#line 430 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
						_tmp58_ = _tmp57_->last_move;
#line 430 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
						chess_application_set_move_text (self, &_tmp56_, _tmp58_);
#line 2668 "gnome-chess.c"
					}
				}
#line 432 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp59_ = i;
#line 432 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				i = _tmp59_ - 1;
#line 424 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_g_object_unref0 (state);
#line 2677 "gnome-chess.c"
			}
		}
	}
#line 435 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp60_ = self->priv->history_combo;
#line 435 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp61_ = move_number;
#line 435 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_combo_box_set_active (_tmp60_, _tmp61_);
#line 2687 "gnome-chess.c"
}


static void chess_application_scene_changed_cb (ChessApplication* self, ChessScene* scene) {
#line 438 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 438 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (scene != NULL);
#line 440 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	chess_application_update_history_panel (self);
#line 2698 "gnome-chess.c"
}


static void _chess_application_game_turn_cb_chess_game_turn_started (ChessGame* _sender, ChessPlayer* player, gpointer self) {
#line 502 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	chess_application_game_turn_cb ((ChessApplication*) self, _sender, player);
#line 2705 "gnome-chess.c"
}


static void _chess_application_game_move_cb_chess_game_moved (ChessGame* _sender, ChessMove* move, gpointer self) {
#line 503 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	chess_application_game_move_cb ((ChessApplication*) self, _sender, move);
#line 2712 "gnome-chess.c"
}


static void _chess_application_game_undo_cb_chess_game_undo (ChessGame* _sender, gpointer self) {
#line 504 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	chess_application_game_undo_cb ((ChessApplication*) self, _sender);
#line 2719 "gnome-chess.c"
}


static void _chess_application_game_end_cb_chess_game_ended (ChessGame* _sender, gpointer self) {
#line 505 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	chess_application_game_end_cb ((ChessApplication*) self);
#line 2726 "gnome-chess.c"
}


static void _chess_application_game_clock_tick_cb_chess_clock_tick (ChessClock* _sender, gpointer self) {
#line 507 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	chess_application_game_clock_tick_cb ((ChessApplication*) self, _sender);
#line 2733 "gnome-chess.c"
}


static void _chess_application_engine_ready_cb_chess_engine_ready_changed (ChessEngine* _sender, gpointer self) {
#line 526 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	chess_application_engine_ready_cb ((ChessApplication*) self, _sender);
#line 2740 "gnome-chess.c"
}


static void _chess_application_engine_move_cb_chess_engine_moved (ChessEngine* _sender, const gchar* move, gpointer self) {
#line 527 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	chess_application_engine_move_cb ((ChessApplication*) self, _sender, move);
#line 2747 "gnome-chess.c"
}


static void _chess_application_engine_resigned_cb_chess_engine_resigned (ChessEngine* _sender, gpointer self) {
#line 528 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	chess_application_engine_resigned_cb ((ChessApplication*) self, _sender);
#line 2754 "gnome-chess.c"
}


static void _chess_application_engine_stopped_unexpectedly_cb_chess_engine_stopped_unexpectedly (ChessEngine* _sender, gpointer self) {
#line 529 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	chess_application_engine_stopped_unexpectedly_cb ((ChessApplication*) self, _sender);
#line 2761 "gnome-chess.c"
}


static void _chess_application_engine_error_cb_chess_engine_error (ChessEngine* _sender, gpointer self) {
#line 530 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	chess_application_engine_error_cb ((ChessApplication*) self, _sender);
#line 2768 "gnome-chess.c"
}


static void _chess_application_engine_claim_draw_cb_chess_engine_claim_draw (ChessEngine* _sender, gpointer self) {
#line 531 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	chess_application_engine_claim_draw_cb ((ChessApplication*) self, _sender);
#line 2775 "gnome-chess.c"
}


static void _chess_application_engine_offer_draw_cb_chess_engine_offer_draw (ChessEngine* _sender, gpointer self) {
#line 532 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	chess_application_engine_offer_draw_cb ((ChessApplication*) self, _sender);
#line 2782 "gnome-chess.c"
}


static void chess_application_start_game (ChessApplication* self) {
	gboolean _tmp0_ = FALSE;
	GFile* _tmp1_;
	GtkListStore* model;
	GtkComboBox* _tmp11_;
	GtkTreeModel* _tmp12_;
	GtkTreeModel* _tmp13_;
	GtkListStore* _tmp14_;
	GtkListStore* _tmp15_;
	GtkTreeIter iter = {0};
	GtkListStore* _tmp16_;
	GtkTreeIter _tmp17_ = {0};
	GtkListStore* _tmp18_;
	GtkTreeIter _tmp19_;
	GtkComboBox* _tmp20_;
	GtkTreeIter _tmp21_;
	gchar* fen;
	gchar* _tmp22_;
	gchar** moves;
	PGNGame* _tmp23_;
	GList* _tmp24_;
	guint _tmp25_;
	gchar** _tmp26_;
	gint moves_length1;
	gint _moves_size_;
	gint i;
	PGNGame* _tmp27_;
	GList* _tmp28_;
	PGNGame* _tmp35_;
	gboolean _tmp36_;
	gboolean _tmp37_;
	gboolean _tmp52_ = FALSE;
	PGNGame* _tmp53_;
	const gchar* _tmp54_;
	const gchar* _tmp55_;
	ChessGame* _tmp83_;
	ChessGame* _tmp84_;
	ChessGame* _tmp85_;
	ChessGame* _tmp86_;
	ChessGame* _tmp87_;
	ChessClock* _tmp88_;
	ChessClock* _tmp89_;
	ChessScene* _tmp93_;
	ChessGame* _tmp94_;
	gchar* white_engine;
	PGNGame* _tmp95_;
	const gchar* _tmp96_;
	const gchar* _tmp97_;
	gchar* _tmp98_;
	gchar* white_level;
	PGNGame* _tmp99_;
	const gchar* _tmp100_;
	const gchar* _tmp101_;
	gchar* _tmp102_;
	const gchar* _tmp103_;
	gchar* black_engine;
	PGNGame* _tmp105_;
	const gchar* _tmp106_;
	const gchar* _tmp107_;
	gchar* _tmp108_;
	gchar* black_level;
	PGNGame* _tmp109_;
	const gchar* _tmp110_;
	const gchar* _tmp111_;
	gchar* _tmp112_;
	const gchar* _tmp113_;
	ChessEngine* _tmp115_;
	const gchar* _tmp131_;
	ChessEngine* _tmp159_;
	gboolean _tmp191_ = FALSE;
	GFile* _tmp192_;
	ChessGame* _tmp197_;
	gint timer_increment_adj_value;
	PGNGame* _tmp198_;
	const gchar* _tmp199_;
	const gchar* _tmp200_;
	ClockType clock_type;
	PGNGame* _tmp211_;
	const gchar* _tmp212_;
	const gchar* _tmp213_;
	ChessGame* _tmp226_;
	ChessClock* _tmp227_;
	ChessClock* _tmp228_;
	PGNGame* _tmp237_;
	const gchar* _tmp238_;
	const gchar* _tmp239_;
	const gchar* _tmp240_;
	ChessEngine* _tmp252_;
	gboolean _tmp254_ = FALSE;
	gchar** _tmp255_;
	gint _tmp255__length1;
	GtkWidget* _tmp262_;
	GtkWidget* _tmp263_;
	gboolean _tmp264_ = FALSE;
	gboolean _tmp265_ = FALSE;
	const gchar* _tmp266_;
	ChessGame* _tmp279_;
	ChessResult _tmp280_;
	GError * _inner_error_ = NULL;
#line 443 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 445 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	self->priv->starting = TRUE;
#line 447 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = self->priv->game_file;
#line 447 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp1_ != NULL) {
#line 2893 "gnome-chess.c"
		GFile* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		const gchar* _tmp5_;
#line 447 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp2_ = self->priv->game_file;
#line 447 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp3_ = g_file_get_path (_tmp2_);
#line 447 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp4_ = _tmp3_;
#line 447 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp5_ = self->priv->autosave_filename;
#line 447 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp0_ = g_strcmp0 (_tmp4_, _tmp5_) != 0;
#line 447 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_g_free0 (_tmp4_);
#line 2910 "gnome-chess.c"
	} else {
#line 447 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp0_ = FALSE;
#line 2914 "gnome-chess.c"
	}
#line 447 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp0_) {
#line 2918 "gnome-chess.c"
		GtkHeaderBar* _tmp6_;
		GFile* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
#line 448 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp6_ = self->priv->headerbar;
#line 448 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp7_ = self->priv->game_file;
#line 448 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp8_ = g_file_get_basename (_tmp7_);
#line 448 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp9_ = _tmp8_;
#line 448 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		gtk_header_bar_set_subtitle (_tmp6_, _tmp9_);
#line 448 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_g_free0 (_tmp9_);
#line 2935 "gnome-chess.c"
	} else {
		GtkHeaderBar* _tmp10_;
#line 450 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp10_ = self->priv->headerbar;
#line 450 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		gtk_header_bar_set_subtitle (_tmp10_, NULL);
#line 2942 "gnome-chess.c"
	}
#line 452 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp11_ = self->priv->history_combo;
#line 452 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp12_ = gtk_combo_box_get_model (_tmp11_);
#line 452 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp13_ = _tmp12_;
#line 452 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp14_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gtk_list_store_get_type (), GtkListStore));
#line 452 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	model = _tmp14_;
#line 453 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp15_ = model;
#line 453 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_list_store_clear (_tmp15_);
#line 455 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp16_ = model;
#line 455 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_list_store_append (_tmp16_, &_tmp17_);
#line 455 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	iter = _tmp17_;
#line 456 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp18_ = model;
#line 456 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp19_ = iter;
#line 456 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_list_store_set (_tmp18_, &_tmp19_, 0, _ ("Game Start"), 1, 0, -1, -1);
#line 459 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp20_ = self->priv->history_combo;
#line 459 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp21_ = iter;
#line 459 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_combo_box_set_active_iter (_tmp20_, &_tmp21_);
#line 461 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp22_ = g_strdup (CHESS_GAME_STANDARD_SETUP);
#line 461 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	fen = _tmp22_;
#line 462 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp23_ = self->priv->pgn_game;
#line 462 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp24_ = _tmp23_->moves;
#line 462 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp25_ = g_list_length (_tmp24_);
#line 462 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp26_ = g_new0 (gchar*, _tmp25_ + 1);
#line 462 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	moves = _tmp26_;
#line 462 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	moves_length1 = _tmp25_;
#line 462 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_moves_size_ = moves_length1;
#line 463 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	i = 0;
#line 464 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp27_ = self->priv->pgn_game;
#line 464 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp28_ = _tmp27_->moves;
#line 3000 "gnome-chess.c"
	{
		GList* move_collection = NULL;
		GList* move_it = NULL;
#line 464 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		move_collection = _tmp28_;
#line 464 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		for (move_it = move_collection; move_it != NULL; move_it = move_it->next) {
#line 3008 "gnome-chess.c"
			gchar* _tmp29_;
			gchar* move = NULL;
#line 464 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp29_ = g_strdup ((const gchar*) move_it->data);
#line 464 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			move = _tmp29_;
#line 3015 "gnome-chess.c"
			{
				gchar** _tmp30_;
				gint _tmp30__length1;
				gint _tmp31_;
				const gchar* _tmp32_;
				gchar* _tmp33_;
				gchar* _tmp34_;
#line 465 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp30_ = moves;
#line 465 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp30__length1 = moves_length1;
#line 465 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp31_ = i;
#line 465 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				i = _tmp31_ + 1;
#line 465 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp32_ = move;
#line 465 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp33_ = g_strdup (_tmp32_);
#line 465 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_g_free0 (_tmp30_[_tmp31_]);
#line 465 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp30_[_tmp31_] = _tmp33_;
#line 465 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp34_ = _tmp30_[_tmp31_];
#line 464 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_g_free0 (move);
#line 3043 "gnome-chess.c"
			}
		}
	}
#line 467 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp35_ = self->priv->pgn_game;
#line 467 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp36_ = pgn_game_get_set_up (_tmp35_);
#line 467 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp37_ = _tmp36_;
#line 467 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp37_) {
#line 3055 "gnome-chess.c"
		PGNGame* _tmp38_;
		const gchar* _tmp39_;
		const gchar* _tmp40_;
#line 469 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp38_ = self->priv->pgn_game;
#line 469 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp39_ = pgn_game_get_fen (_tmp38_);
#line 469 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp40_ = _tmp39_;
#line 469 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		if (_tmp40_ != NULL) {
#line 3067 "gnome-chess.c"
			PGNGame* _tmp41_;
			const gchar* _tmp42_;
			const gchar* _tmp43_;
			gchar* _tmp44_;
#line 470 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp41_ = self->priv->pgn_game;
#line 470 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp42_ = pgn_game_get_fen (_tmp41_);
#line 470 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp43_ = _tmp42_;
#line 470 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp44_ = g_strdup (_tmp43_);
#line 470 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_g_free0 (fen);
#line 470 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			fen = _tmp44_;
#line 3084 "gnome-chess.c"
		} else {
#line 472 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			g_warning ("gnome-chess.vala:472: Chess game has SetUp tag but no FEN tag");
#line 3088 "gnome-chess.c"
		}
	}
	{
		ChessGame* _tmp45_;
		const gchar* _tmp46_;
		gchar** _tmp47_;
		gint _tmp47__length1;
		ChessGame* _tmp48_;
		ChessGame* _tmp49_;
#line 477 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp46_ = fen;
#line 477 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp47_ = moves;
#line 477 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp47__length1 = moves_length1;
#line 477 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp48_ = chess_game_new (_tmp46_, _tmp47_, _tmp47__length1, &_inner_error_);
#line 477 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp45_ = _tmp48_;
#line 477 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 3110 "gnome-chess.c"
			goto __catch3_g_error;
		}
#line 477 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp49_ = _tmp45_;
#line 477 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp45_ = NULL;
#line 477 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (self->priv->game);
#line 477 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		self->priv->game = _tmp49_;
#line 475 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (_tmp45_);
#line 3123 "gnome-chess.c"
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		GError* _tmp50_;
		const gchar* _tmp51_;
#line 475 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		e = _inner_error_;
#line 475 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_inner_error_ = NULL;
#line 481 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp50_ = e;
#line 481 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp51_ = _tmp50_->message;
#line 481 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		chess_application_run_invalid_move_dialog (self, _tmp51_);
#line 482 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		chess_application_start_new_game (self);
#line 483 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_g_error_free0 (e);
#line 483 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		moves = (_vala_array_free (moves, moves_length1, (GDestroyNotify) g_free), NULL);
#line 483 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_g_free0 (fen);
#line 483 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (model);
#line 483 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		return;
#line 3153 "gnome-chess.c"
	}
	__finally3:
#line 475 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 475 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		moves = (_vala_array_free (moves, moves_length1, (GDestroyNotify) g_free), NULL);
#line 475 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_g_free0 (fen);
#line 475 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (model);
#line 475 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 475 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		g_clear_error (&_inner_error_);
#line 475 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		return;
#line 3170 "gnome-chess.c"
	}
#line 490 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp53_ = self->priv->pgn_game;
#line 490 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp54_ = pgn_game_get_time_control (_tmp53_);
#line 490 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp55_ = _tmp54_;
#line 490 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp55_ != NULL) {
#line 3180 "gnome-chess.c"
		PGNGame* _tmp56_;
		const gchar* _tmp57_;
		const gchar* _tmp58_;
		gint _tmp59_;
#line 490 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp56_ = self->priv->pgn_game;
#line 490 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp57_ = pgn_game_get_time_control (_tmp56_);
#line 490 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp58_ = _tmp57_;
#line 490 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp59_ = atoi (_tmp58_);
#line 490 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp52_ = _tmp59_ != 0;
#line 3195 "gnome-chess.c"
	} else {
#line 490 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp52_ = FALSE;
#line 3199 "gnome-chess.c"
	}
#line 490 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp52_) {
#line 3203 "gnome-chess.c"
		gboolean _tmp60_ = FALSE;
		PGNGame* _tmp61_;
		const gchar* _tmp62_;
		const gchar* _tmp63_;
#line 492 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp61_ = self->priv->pgn_game;
#line 492 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp62_ = pgn_game_get_white_time_left (_tmp61_);
#line 492 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp63_ = _tmp62_;
#line 492 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		if (_tmp63_ != NULL) {
#line 3216 "gnome-chess.c"
			PGNGame* _tmp64_;
			const gchar* _tmp65_;
			const gchar* _tmp66_;
#line 492 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp64_ = self->priv->pgn_game;
#line 492 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp65_ = pgn_game_get_black_time_left (_tmp64_);
#line 492 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp66_ = _tmp65_;
#line 492 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp60_ = _tmp66_ != NULL;
#line 3228 "gnome-chess.c"
		} else {
#line 492 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp60_ = FALSE;
#line 3232 "gnome-chess.c"
		}
#line 492 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		if (_tmp60_) {
#line 3236 "gnome-chess.c"
			gint white_seconds;
			PGNGame* _tmp67_;
			const gchar* _tmp68_;
			const gchar* _tmp69_;
			gint _tmp70_;
			gint black_seconds;
			PGNGame* _tmp71_;
			const gchar* _tmp72_;
			const gchar* _tmp73_;
			gint _tmp74_;
			gboolean _tmp75_ = FALSE;
			gint _tmp76_;
#line 494 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp67_ = self->priv->pgn_game;
#line 494 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp68_ = pgn_game_get_white_time_left (_tmp67_);
#line 494 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp69_ = _tmp68_;
#line 494 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp70_ = atoi (_tmp69_);
#line 494 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			white_seconds = _tmp70_;
#line 495 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp71_ = self->priv->pgn_game;
#line 495 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp72_ = pgn_game_get_black_time_left (_tmp71_);
#line 495 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp73_ = _tmp72_;
#line 495 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp74_ = atoi (_tmp73_);
#line 495 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			black_seconds = _tmp74_;
#line 497 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp76_ = white_seconds;
#line 497 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			if (_tmp76_ >= 0) {
#line 3273 "gnome-chess.c"
				gint _tmp77_;
#line 497 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp77_ = black_seconds;
#line 497 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp75_ = _tmp77_ >= 0;
#line 3279 "gnome-chess.c"
			} else {
#line 497 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp75_ = FALSE;
#line 3283 "gnome-chess.c"
			}
#line 497 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			if (_tmp75_) {
#line 3287 "gnome-chess.c"
				ChessGame* _tmp78_;
				gint _tmp79_;
				gint _tmp80_;
				ChessClock* _tmp81_;
				ChessClock* _tmp82_;
#line 498 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp78_ = self->priv->game;
#line 498 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp79_ = white_seconds;
#line 498 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp80_ = black_seconds;
#line 498 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp81_ = chess_clock_new (_tmp79_, _tmp80_);
#line 498 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp82_ = _tmp81_;
#line 498 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				chess_game_set_clock (_tmp78_, _tmp82_);
#line 498 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_g_object_unref0 (_tmp82_);
#line 3307 "gnome-chess.c"
			}
		}
	}
#line 502 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp83_ = self->priv->game;
#line 502 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_signal_connect_object (_tmp83_, "turn-started", (GCallback) _chess_application_game_turn_cb_chess_game_turn_started, self, 0);
#line 503 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp84_ = self->priv->game;
#line 503 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_signal_connect_object (_tmp84_, "moved", (GCallback) _chess_application_game_move_cb_chess_game_moved, self, 0);
#line 504 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp85_ = self->priv->game;
#line 504 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_signal_connect_object (_tmp85_, "undo", (GCallback) _chess_application_game_undo_cb_chess_game_undo, self, 0);
#line 505 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp86_ = self->priv->game;
#line 505 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_signal_connect_object (_tmp86_, "ended", (GCallback) _chess_application_game_end_cb_chess_game_ended, self, 0);
#line 506 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp87_ = self->priv->game;
#line 506 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp88_ = chess_game_get_clock (_tmp87_);
#line 506 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp89_ = _tmp88_;
#line 506 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp89_ != NULL) {
#line 3335 "gnome-chess.c"
		ChessGame* _tmp90_;
		ChessClock* _tmp91_;
		ChessClock* _tmp92_;
#line 507 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp90_ = self->priv->game;
#line 507 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp91_ = chess_game_get_clock (_tmp90_);
#line 507 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp92_ = _tmp91_;
#line 507 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		g_signal_connect_object (_tmp92_, "tick", (GCallback) _chess_application_game_clock_tick_cb_chess_clock_tick, self, 0);
#line 3347 "gnome-chess.c"
	}
#line 509 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp93_ = self->priv->scene;
#line 509 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp94_ = self->priv->game;
#line 509 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	chess_scene_set_game (_tmp93_, _tmp94_);
#line 511 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp95_ = self->priv->pgn_game;
#line 511 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp96_ = pgn_game_get_white_ai (_tmp95_);
#line 511 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp97_ = _tmp96_;
#line 511 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp98_ = g_strdup (_tmp97_);
#line 511 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	white_engine = _tmp98_;
#line 512 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp99_ = self->priv->pgn_game;
#line 512 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp100_ = pgn_game_get_white_level (_tmp99_);
#line 512 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp101_ = _tmp100_;
#line 512 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp102_ = g_strdup (_tmp101_);
#line 512 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	white_level = _tmp102_;
#line 513 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp103_ = white_level;
#line 513 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp103_ == NULL) {
#line 3379 "gnome-chess.c"
		gchar* _tmp104_;
#line 514 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp104_ = g_strdup ("normal");
#line 514 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_g_free0 (white_level);
#line 514 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		white_level = _tmp104_;
#line 3387 "gnome-chess.c"
	}
#line 516 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp105_ = self->priv->pgn_game;
#line 516 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp106_ = pgn_game_get_black_ai (_tmp105_);
#line 516 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp107_ = _tmp106_;
#line 516 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp108_ = g_strdup (_tmp107_);
#line 516 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	black_engine = _tmp108_;
#line 517 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp109_ = self->priv->pgn_game;
#line 517 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp110_ = pgn_game_get_black_level (_tmp109_);
#line 517 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp111_ = _tmp110_;
#line 517 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp112_ = g_strdup (_tmp111_);
#line 517 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	black_level = _tmp112_;
#line 518 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp113_ = black_level;
#line 518 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp113_ == NULL) {
#line 3413 "gnome-chess.c"
		gchar* _tmp114_;
#line 519 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp114_ = g_strdup ("normal");
#line 519 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_g_free0 (black_level);
#line 519 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		black_level = _tmp114_;
#line 3421 "gnome-chess.c"
	}
#line 521 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->human_player);
#line 521 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	self->priv->human_player = NULL;
#line 522 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->opponent);
#line 522 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	self->priv->opponent = NULL;
#line 523 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp115_ = self->priv->opponent_engine;
#line 523 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp115_ != NULL) {
#line 3435 "gnome-chess.c"
		ChessEngine* _tmp116_;
		ChessEngine* _tmp117_;
		guint _tmp118_;
		ChessEngine* _tmp119_;
		guint _tmp120_;
		ChessEngine* _tmp121_;
		guint _tmp122_;
		ChessEngine* _tmp123_;
		guint _tmp124_;
		ChessEngine* _tmp125_;
		guint _tmp126_;
		ChessEngine* _tmp127_;
		guint _tmp128_;
		ChessEngine* _tmp129_;
		guint _tmp130_;
#line 525 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp116_ = self->priv->opponent_engine;
#line 525 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		chess_engine_stop (_tmp116_, TRUE);
#line 526 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp117_ = self->priv->opponent_engine;
#line 526 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		g_signal_parse_name ("ready-changed", TYPE_CHESS_ENGINE, &_tmp118_, NULL, FALSE);
#line 526 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		g_signal_handlers_disconnect_matched (_tmp117_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp118_, 0, NULL, (GCallback) _chess_application_engine_ready_cb_chess_engine_ready_changed, self);
#line 527 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp119_ = self->priv->opponent_engine;
#line 527 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		g_signal_parse_name ("moved", TYPE_CHESS_ENGINE, &_tmp120_, NULL, FALSE);
#line 527 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		g_signal_handlers_disconnect_matched (_tmp119_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp120_, 0, NULL, (GCallback) _chess_application_engine_move_cb_chess_engine_moved, self);
#line 528 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp121_ = self->priv->opponent_engine;
#line 528 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		g_signal_parse_name ("resigned", TYPE_CHESS_ENGINE, &_tmp122_, NULL, FALSE);
#line 528 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		g_signal_handlers_disconnect_matched (_tmp121_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp122_, 0, NULL, (GCallback) _chess_application_engine_resigned_cb_chess_engine_resigned, self);
#line 529 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp123_ = self->priv->opponent_engine;
#line 529 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		g_signal_parse_name ("stopped-unexpectedly", TYPE_CHESS_ENGINE, &_tmp124_, NULL, FALSE);
#line 529 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		g_signal_handlers_disconnect_matched (_tmp123_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp124_, 0, NULL, (GCallback) _chess_application_engine_stopped_unexpectedly_cb_chess_engine_stopped_unexpectedly, self);
#line 530 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp125_ = self->priv->opponent_engine;
#line 530 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		g_signal_parse_name ("error", TYPE_CHESS_ENGINE, &_tmp126_, NULL, FALSE);
#line 530 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		g_signal_handlers_disconnect_matched (_tmp125_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp126_, 0, NULL, (GCallback) _chess_application_engine_error_cb_chess_engine_error, self);
#line 531 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp127_ = self->priv->opponent_engine;
#line 531 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		g_signal_parse_name ("claim-draw", TYPE_CHESS_ENGINE, &_tmp128_, NULL, FALSE);
#line 531 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		g_signal_handlers_disconnect_matched (_tmp127_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp128_, 0, NULL, (GCallback) _chess_application_engine_claim_draw_cb_chess_engine_claim_draw, self);
#line 532 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp129_ = self->priv->opponent_engine;
#line 532 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		g_signal_parse_name ("offer-draw", TYPE_CHESS_ENGINE, &_tmp130_, NULL, FALSE);
#line 532 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		g_signal_handlers_disconnect_matched (_tmp129_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp130_, 0, NULL, (GCallback) _chess_application_engine_offer_draw_cb_chess_engine_offer_draw, self);
#line 533 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (self->priv->opponent_engine);
#line 533 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		self->priv->opponent_engine = NULL;
#line 3501 "gnome-chess.c"
	}
#line 536 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp131_ = white_engine;
#line 536 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp131_ != NULL) {
#line 3507 "gnome-chess.c"
		ChessGame* _tmp132_;
		ChessPlayer* _tmp133_;
		ChessPlayer* _tmp134_;
		ChessPlayer* _tmp135_;
		ChessGame* _tmp136_;
		ChessPlayer* _tmp137_;
		ChessPlayer* _tmp138_;
		ChessPlayer* _tmp139_;
		const gchar* _tmp140_;
		const gchar* _tmp141_;
		ChessEngine* _tmp142_;
		ChessPlayer* _tmp143_;
		ChessPlayer* _tmp144_;
#line 538 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp132_ = self->priv->game;
#line 538 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp133_ = chess_game_get_white (_tmp132_);
#line 538 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp134_ = _tmp133_;
#line 538 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp135_ = _g_object_ref0 (_tmp134_);
#line 538 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (self->priv->opponent);
#line 538 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		self->priv->opponent = _tmp135_;
#line 539 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp136_ = self->priv->game;
#line 539 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp137_ = chess_game_get_black (_tmp136_);
#line 539 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp138_ = _tmp137_;
#line 539 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp139_ = _g_object_ref0 (_tmp138_);
#line 539 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (self->priv->human_player);
#line 539 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		self->priv->human_player = _tmp139_;
#line 540 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp140_ = white_engine;
#line 540 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp141_ = white_level;
#line 540 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp142_ = chess_application_get_engine (self, _tmp140_, _tmp141_);
#line 540 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (self->priv->opponent_engine);
#line 540 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		self->priv->opponent_engine = _tmp142_;
#line 541 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp143_ = self->priv->opponent;
#line 541 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		chess_player_set_local_human (_tmp143_, FALSE);
#line 542 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp144_ = self->priv->human_player;
#line 542 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		chess_player_set_local_human (_tmp144_, TRUE);
#line 3563 "gnome-chess.c"
	} else {
		const gchar* _tmp145_;
#line 544 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp145_ = black_engine;
#line 544 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		if (_tmp145_ != NULL) {
#line 3570 "gnome-chess.c"
			ChessGame* _tmp146_;
			ChessPlayer* _tmp147_;
			ChessPlayer* _tmp148_;
			ChessPlayer* _tmp149_;
			ChessGame* _tmp150_;
			ChessPlayer* _tmp151_;
			ChessPlayer* _tmp152_;
			ChessPlayer* _tmp153_;
			const gchar* _tmp154_;
			const gchar* _tmp155_;
			ChessEngine* _tmp156_;
			ChessPlayer* _tmp157_;
			ChessPlayer* _tmp158_;
#line 546 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp146_ = self->priv->game;
#line 546 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp147_ = chess_game_get_black (_tmp146_);
#line 546 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp148_ = _tmp147_;
#line 546 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp149_ = _g_object_ref0 (_tmp148_);
#line 546 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_g_object_unref0 (self->priv->opponent);
#line 546 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			self->priv->opponent = _tmp149_;
#line 547 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp150_ = self->priv->game;
#line 547 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp151_ = chess_game_get_white (_tmp150_);
#line 547 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp152_ = _tmp151_;
#line 547 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp153_ = _g_object_ref0 (_tmp152_);
#line 547 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_g_object_unref0 (self->priv->human_player);
#line 547 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			self->priv->human_player = _tmp153_;
#line 548 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp154_ = black_engine;
#line 548 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp155_ = black_level;
#line 548 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp156_ = chess_application_get_engine (self, _tmp154_, _tmp155_);
#line 548 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_g_object_unref0 (self->priv->opponent_engine);
#line 548 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			self->priv->opponent_engine = _tmp156_;
#line 549 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp157_ = self->priv->opponent;
#line 549 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			chess_player_set_local_human (_tmp157_, FALSE);
#line 550 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp158_ = self->priv->human_player;
#line 550 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			chess_player_set_local_human (_tmp158_, TRUE);
#line 3626 "gnome-chess.c"
		}
	}
#line 554 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp159_ = self->priv->opponent_engine;
#line 554 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp159_ == NULL) {
#line 3633 "gnome-chess.c"
		ChessGame* _tmp160_;
		ChessPlayer* _tmp161_;
		ChessPlayer* _tmp162_;
		ChessGame* _tmp163_;
		ChessPlayer* _tmp164_;
		ChessPlayer* _tmp165_;
#line 556 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp160_ = self->priv->game;
#line 556 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp161_ = chess_game_get_black (_tmp160_);
#line 556 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp162_ = _tmp161_;
#line 556 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		chess_player_set_local_human (_tmp162_, TRUE);
#line 557 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp163_ = self->priv->game;
#line 557 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp164_ = chess_game_get_white (_tmp163_);
#line 557 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp165_ = _tmp164_;
#line 557 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		chess_player_set_local_human (_tmp165_, TRUE);
#line 558 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (self->priv->human_player);
#line 558 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		self->priv->human_player = NULL;
#line 3660 "gnome-chess.c"
	} else {
		ChessEngine* _tmp166_;
		ChessEngine* _tmp167_;
		ChessEngine* _tmp168_;
		ChessEngine* _tmp169_;
		ChessEngine* _tmp170_;
		ChessEngine* _tmp171_;
		ChessEngine* _tmp172_;
		ChessEngine* _tmp173_;
		gboolean _tmp174_;
#line 562 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp166_ = self->priv->opponent_engine;
#line 562 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		g_signal_connect_object (_tmp166_, "ready-changed", (GCallback) _chess_application_engine_ready_cb_chess_engine_ready_changed, self, 0);
#line 563 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp167_ = self->priv->opponent_engine;
#line 563 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		g_signal_connect_object (_tmp167_, "moved", (GCallback) _chess_application_engine_move_cb_chess_engine_moved, self, 0);
#line 564 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp168_ = self->priv->opponent_engine;
#line 564 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		g_signal_connect_object (_tmp168_, "resigned", (GCallback) _chess_application_engine_resigned_cb_chess_engine_resigned, self, 0);
#line 565 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp169_ = self->priv->opponent_engine;
#line 565 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		g_signal_connect_object (_tmp169_, "stopped-unexpectedly", (GCallback) _chess_application_engine_stopped_unexpectedly_cb_chess_engine_stopped_unexpectedly, self, 0);
#line 566 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp170_ = self->priv->opponent_engine;
#line 566 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		g_signal_connect_object (_tmp170_, "error", (GCallback) _chess_application_engine_error_cb_chess_engine_error, self, 0);
#line 567 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp171_ = self->priv->opponent_engine;
#line 567 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		g_signal_connect_object (_tmp171_, "claim-draw", (GCallback) _chess_application_engine_claim_draw_cb_chess_engine_claim_draw, self, 0);
#line 568 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp172_ = self->priv->opponent_engine;
#line 568 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		g_signal_connect_object (_tmp172_, "offer-draw", (GCallback) _chess_application_engine_offer_draw_cb_chess_engine_offer_draw, self, 0);
#line 570 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp173_ = self->priv->opponent_engine;
#line 570 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp174_ = chess_engine_start (_tmp173_);
#line 570 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		if (!_tmp174_) {
#line 3705 "gnome-chess.c"
			ChessGame* _tmp175_;
			ChessGame* _tmp176_;
#line 572 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			chess_application_disable_window_action (self, CHESS_APPLICATION_SAVE_GAME_ACTION_NAME);
#line 573 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp175_ = self->priv->game;
#line 573 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp175_->result = CHESS_RESULT_BUG;
#line 574 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp176_ = self->priv->game;
#line 574 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp176_->rule = CHESS_RULE_BUG;
#line 575 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			chess_application_game_end_cb (self);
#line 576 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_g_free0 (black_level);
#line 576 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_g_free0 (black_engine);
#line 576 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_g_free0 (white_level);
#line 576 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_g_free0 (white_engine);
#line 576 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			moves = (_vala_array_free (moves, moves_length1, (GDestroyNotify) g_free), NULL);
#line 576 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_g_free0 (fen);
#line 576 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_g_object_unref0 (model);
#line 576 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			return;
#line 3736 "gnome-chess.c"
		}
	}
	{
		gint j;
		ChessGame* _tmp177_;
		GList* _tmp178_;
		guint _tmp179_;
#line 581 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp177_ = self->priv->game;
#line 581 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp178_ = _tmp177_->move_stack;
#line 581 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp179_ = g_list_length (_tmp178_);
#line 581 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		j = ((gint) _tmp179_) - 2;
#line 3752 "gnome-chess.c"
		{
			gboolean _tmp180_;
#line 581 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp180_ = TRUE;
#line 581 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			while (TRUE) {
#line 3759 "gnome-chess.c"
				gint _tmp182_;
				ChessState* state;
				ChessGame* _tmp183_;
				GList* _tmp184_;
				gint _tmp185_;
				gconstpointer _tmp186_;
				ChessState* _tmp187_;
				ChessGame* _tmp188_;
				ChessState* _tmp189_;
				ChessMove* _tmp190_;
#line 581 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				if (!_tmp180_) {
#line 3772 "gnome-chess.c"
					gint _tmp181_;
#line 581 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					_tmp181_ = j;
#line 581 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					j = _tmp181_ - 1;
#line 3778 "gnome-chess.c"
				}
#line 581 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp180_ = FALSE;
#line 581 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp182_ = j;
#line 581 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				if (!(_tmp182_ >= 0)) {
#line 581 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					break;
#line 3788 "gnome-chess.c"
				}
#line 583 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp183_ = self->priv->game;
#line 583 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp184_ = _tmp183_->move_stack;
#line 583 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp185_ = j;
#line 583 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp186_ = g_list_nth_data (_tmp184_, (guint) _tmp185_);
#line 583 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp187_ = _g_object_ref0 ((ChessState*) _tmp186_);
#line 583 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				state = _tmp187_;
#line 584 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp188_ = self->priv->game;
#line 584 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp189_ = state;
#line 584 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp190_ = _tmp189_->last_move;
#line 584 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				chess_application_game_move_cb (self, _tmp188_, _tmp190_);
#line 581 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_g_object_unref0 (state);
#line 3812 "gnome-chess.c"
			}
		}
	}
#line 587 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp192_ = self->priv->game_file;
#line 587 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp192_ != NULL) {
#line 3820 "gnome-chess.c"
		GFile* _tmp193_;
		gchar* _tmp194_;
		gchar* _tmp195_;
		const gchar* _tmp196_;
#line 587 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp193_ = self->priv->game_file;
#line 587 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp194_ = g_file_get_path (_tmp193_);
#line 587 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp195_ = _tmp194_;
#line 587 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp196_ = self->priv->autosave_filename;
#line 587 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp191_ = g_strcmp0 (_tmp195_, _tmp196_) == 0;
#line 587 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_g_free0 (_tmp195_);
#line 3837 "gnome-chess.c"
	} else {
#line 587 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp191_ = FALSE;
#line 3841 "gnome-chess.c"
	}
#line 587 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp191_) {
#line 589 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		self->priv->game_needs_saving = TRUE;
#line 590 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		chess_application_enable_window_action (self, CHESS_APPLICATION_SAVE_GAME_ACTION_NAME);
#line 3849 "gnome-chess.c"
	} else {
#line 594 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		self->priv->game_needs_saving = FALSE;
#line 595 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		chess_application_disable_window_action (self, CHESS_APPLICATION_SAVE_GAME_ACTION_NAME);
#line 3855 "gnome-chess.c"
	}
#line 598 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp197_ = self->priv->game;
#line 598 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	chess_game_start (_tmp197_);
#line 600 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	timer_increment_adj_value = 0;
#line 601 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp198_ = self->priv->pgn_game;
#line 601 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp199_ = pgn_game_get_timer_increment (_tmp198_);
#line 601 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp200_ = _tmp199_;
#line 601 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp200_ != NULL) {
#line 3871 "gnome-chess.c"
		PGNGame* _tmp201_;
		const gchar* _tmp202_;
		const gchar* _tmp203_;
		gint _tmp204_;
#line 602 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp201_ = self->priv->pgn_game;
#line 602 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp202_ = pgn_game_get_timer_increment (_tmp201_);
#line 602 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp203_ = _tmp202_;
#line 602 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp204_ = atoi (_tmp203_);
#line 602 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		timer_increment_adj_value = _tmp204_;
#line 3886 "gnome-chess.c"
	} else {
		GSettings* _tmp205_;
		gint _tmp206_;
		PGNGame* _tmp207_;
		gint _tmp208_;
		gchar* _tmp209_;
		gchar* _tmp210_;
#line 605 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp205_ = self->priv->settings;
#line 605 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp206_ = g_settings_get_int (_tmp205_, "timer-increment");
#line 605 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		timer_increment_adj_value = _tmp206_;
#line 606 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp207_ = self->priv->pgn_game;
#line 606 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp208_ = timer_increment_adj_value;
#line 606 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp209_ = g_strdup_printf ("%i", _tmp208_);
#line 606 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp210_ = _tmp209_;
#line 606 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		pgn_game_set_timer_increment (_tmp207_, _tmp210_);
#line 606 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_g_free0 (_tmp210_);
#line 3912 "gnome-chess.c"
	}
#line 609 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	clock_type = CLOCK_TYPE_SIMPLE;
#line 610 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp211_ = self->priv->pgn_game;
#line 610 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp212_ = pgn_game_get_clock_type (_tmp211_);
#line 610 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp213_ = _tmp212_;
#line 610 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp213_ != NULL) {
#line 3924 "gnome-chess.c"
		PGNGame* _tmp214_;
		const gchar* _tmp215_;
		const gchar* _tmp216_;
		ClockType _tmp217_;
#line 611 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp214_ = self->priv->pgn_game;
#line 611 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp215_ = pgn_game_get_clock_type (_tmp214_);
#line 611 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp216_ = _tmp215_;
#line 611 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp217_ = clock_type_string_to_enum (_tmp216_);
#line 611 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		clock_type = _tmp217_;
#line 3939 "gnome-chess.c"
	} else {
		GSettings* _tmp218_;
		gchar* _tmp219_;
		gchar* _tmp220_;
		ClockType _tmp221_;
		PGNGame* _tmp222_;
		ClockType _tmp223_;
		gchar* _tmp224_;
		gchar* _tmp225_;
#line 614 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp218_ = self->priv->settings;
#line 614 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp219_ = g_settings_get_string (_tmp218_, "clock-type");
#line 614 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp220_ = _tmp219_;
#line 614 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp221_ = clock_type_string_to_enum (_tmp220_);
#line 614 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		clock_type = _tmp221_;
#line 614 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_g_free0 (_tmp220_);
#line 615 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp222_ = self->priv->pgn_game;
#line 615 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp223_ = clock_type;
#line 615 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp224_ = clock_type_to_string (_tmp223_);
#line 615 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp225_ = _tmp224_;
#line 615 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		pgn_game_set_clock_type (_tmp222_, _tmp225_);
#line 615 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_g_free0 (_tmp225_);
#line 3973 "gnome-chess.c"
	}
#line 618 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp226_ = self->priv->game;
#line 618 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp227_ = chess_game_get_clock (_tmp226_);
#line 618 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp228_ = _tmp227_;
#line 618 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp228_ != NULL) {
#line 3983 "gnome-chess.c"
		ChessGame* _tmp229_;
		ChessClock* _tmp230_;
		ChessClock* _tmp231_;
		gint _tmp232_;
		ChessGame* _tmp233_;
		ChessClock* _tmp234_;
		ChessClock* _tmp235_;
		ClockType _tmp236_;
#line 620 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp229_ = self->priv->game;
#line 620 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp230_ = chess_game_get_clock (_tmp229_);
#line 620 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp231_ = _tmp230_;
#line 620 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp232_ = timer_increment_adj_value;
#line 620 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		chess_clock_set_extra_seconds (_tmp231_, (gint) _tmp232_);
#line 621 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp233_ = self->priv->game;
#line 621 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp234_ = chess_game_get_clock (_tmp233_);
#line 621 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp235_ = _tmp234_;
#line 621 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp236_ = clock_type;
#line 621 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		chess_clock_set_clock_type (_tmp235_, _tmp236_);
#line 4012 "gnome-chess.c"
	}
#line 625 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp237_ = self->priv->pgn_game;
#line 625 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp238_ = pgn_game_get_result (_tmp237_);
#line 625 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp239_ = _tmp238_;
#line 625 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp240_ = pgn_game_RESULT_WHITE;
#line 625 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (g_strcmp0 (_tmp239_, _tmp240_) == 0) {
#line 4024 "gnome-chess.c"
		ChessGame* _tmp241_;
#line 626 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp241_ = self->priv->game;
#line 626 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp241_->result = CHESS_RESULT_WHITE_WON;
#line 4030 "gnome-chess.c"
	} else {
		PGNGame* _tmp242_;
		const gchar* _tmp243_;
		const gchar* _tmp244_;
		const gchar* _tmp245_;
#line 627 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp242_ = self->priv->pgn_game;
#line 627 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp243_ = pgn_game_get_result (_tmp242_);
#line 627 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp244_ = _tmp243_;
#line 627 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp245_ = pgn_game_RESULT_BLACK;
#line 627 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		if (g_strcmp0 (_tmp244_, _tmp245_) == 0) {
#line 4046 "gnome-chess.c"
			ChessGame* _tmp246_;
#line 628 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp246_ = self->priv->game;
#line 628 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp246_->result = CHESS_RESULT_BLACK_WON;
#line 4052 "gnome-chess.c"
		} else {
			PGNGame* _tmp247_;
			const gchar* _tmp248_;
			const gchar* _tmp249_;
			const gchar* _tmp250_;
#line 629 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp247_ = self->priv->pgn_game;
#line 629 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp248_ = pgn_game_get_result (_tmp247_);
#line 629 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp249_ = _tmp248_;
#line 629 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp250_ = pgn_game_RESULT_DRAW;
#line 629 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			if (g_strcmp0 (_tmp249_, _tmp250_) == 0) {
#line 4068 "gnome-chess.c"
				ChessGame* _tmp251_;
#line 630 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp251_ = self->priv->game;
#line 630 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp251_->result = CHESS_RESULT_DRAW;
#line 4074 "gnome-chess.c"
			}
		}
	}
#line 632 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp252_ = self->priv->opponent_engine;
#line 632 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp252_ != NULL) {
#line 4082 "gnome-chess.c"
		ChessEngine* _tmp253_;
#line 633 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp253_ = self->priv->opponent_engine;
#line 633 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		chess_engine_start_game (_tmp253_);
#line 4088 "gnome-chess.c"
	}
#line 635 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp255_ = moves;
#line 635 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp255__length1 = moves_length1;
#line 635 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp255__length1 > 0) {
#line 4096 "gnome-chess.c"
		ChessGame* _tmp256_;
		ChessClock* _tmp257_;
		ChessClock* _tmp258_;
#line 635 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp256_ = self->priv->game;
#line 635 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp257_ = chess_game_get_clock (_tmp256_);
#line 635 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp258_ = _tmp257_;
#line 635 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp254_ = _tmp258_ != NULL;
#line 4108 "gnome-chess.c"
	} else {
#line 635 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp254_ = FALSE;
#line 4112 "gnome-chess.c"
	}
#line 635 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp254_) {
#line 4116 "gnome-chess.c"
		ChessGame* _tmp259_;
		ChessClock* _tmp260_;
		ChessClock* _tmp261_;
#line 637 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp259_ = self->priv->game;
#line 637 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp260_ = chess_game_get_clock (_tmp259_);
#line 637 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp261_ = _tmp260_;
#line 637 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		chess_clock_start (_tmp261_);
#line 638 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		chess_application_enable_window_action (self, CHESS_APPLICATION_PAUSE_RESUME_ACTION_NAME);
#line 4130 "gnome-chess.c"
	} else {
#line 642 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		chess_application_disable_window_action (self, CHESS_APPLICATION_PAUSE_RESUME_ACTION_NAME);
#line 4134 "gnome-chess.c"
	}
#line 645 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	chess_application_update_history_panel (self);
#line 646 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	chess_application_update_action_status (self);
#line 647 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	chess_application_update_pause_resume_button (self);
#line 648 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	chess_application_update_headerbar_title (self);
#line 650 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp262_ = self->priv->white_time_label;
#line 650 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_widget_queue_draw (_tmp262_);
#line 651 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp263_ = self->priv->black_time_label;
#line 651 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_widget_queue_draw (_tmp263_);
#line 653 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	self->priv->starting = FALSE;
#line 655 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp266_ = white_engine;
#line 655 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp266_ != NULL) {
#line 4158 "gnome-chess.c"
		ChessGame* _tmp267_;
		ChessPlayer* _tmp268_;
		ChessPlayer* _tmp269_;
		Color _tmp270_;
#line 655 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp267_ = self->priv->game;
#line 655 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp268_ = chess_game_get_current_player (_tmp267_);
#line 655 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp269_ = _tmp268_;
#line 655 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp270_ = _tmp269_->color;
#line 655 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp265_ = _tmp270_ == COLOR_WHITE;
#line 4173 "gnome-chess.c"
	} else {
#line 655 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp265_ = FALSE;
#line 4177 "gnome-chess.c"
	}
#line 655 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp265_) {
#line 655 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp264_ = TRUE;
#line 4183 "gnome-chess.c"
	} else {
		gboolean _tmp271_ = FALSE;
		const gchar* _tmp272_;
#line 656 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp272_ = black_engine;
#line 656 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		if (_tmp272_ != NULL) {
#line 4191 "gnome-chess.c"
			ChessGame* _tmp273_;
			ChessPlayer* _tmp274_;
			ChessPlayer* _tmp275_;
			Color _tmp276_;
#line 656 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp273_ = self->priv->game;
#line 656 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp274_ = chess_game_get_current_player (_tmp273_);
#line 656 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp275_ = _tmp274_;
#line 656 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp276_ = _tmp275_->color;
#line 656 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp271_ = _tmp276_ == COLOR_BLACK;
#line 4206 "gnome-chess.c"
		} else {
#line 656 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp271_ = FALSE;
#line 4210 "gnome-chess.c"
		}
#line 656 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp264_ = _tmp271_;
#line 4214 "gnome-chess.c"
	}
#line 655 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp264_) {
#line 4218 "gnome-chess.c"
		ChessEngine* _tmp277_;
		ChessEngine* _tmp278_;
#line 658 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp277_ = self->priv->opponent_engine;
#line 658 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_vala_assert (_tmp277_ != NULL, "opponent_engine != null");
#line 659 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp278_ = self->priv->opponent_engine;
#line 659 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		chess_engine_move (_tmp278_);
#line 4229 "gnome-chess.c"
	}
#line 663 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp279_ = self->priv->game;
#line 663 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp280_ = _tmp279_->result;
#line 663 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp280_ != CHESS_RESULT_IN_PROGRESS) {
#line 4237 "gnome-chess.c"
		ChessGame* _tmp281_;
		ChessGame* _tmp282_;
		ChessResult _tmp283_;
#line 664 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp281_ = self->priv->game;
#line 664 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp282_ = self->priv->game;
#line 664 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp283_ = _tmp282_->result;
#line 664 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		chess_game_stop (_tmp281_, _tmp283_, CHESS_RULE_UNKNOWN);
#line 4249 "gnome-chess.c"
	}
#line 443 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_free0 (black_level);
#line 443 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_free0 (black_engine);
#line 443 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_free0 (white_level);
#line 443 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_free0 (white_engine);
#line 443 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	moves = (_vala_array_free (moves, moves_length1, (GDestroyNotify) g_free), NULL);
#line 443 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_free0 (fen);
#line 443 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (model);
#line 4265 "gnome-chess.c"
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
#line 699 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	result = g_new0 (gchar*, length + 1);
#line 699 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	for (i = 0; i < length; i++) {
#line 4276 "gnome-chess.c"
		gchar* _tmp0_;
#line 699 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp0_ = g_strdup (self[i]);
#line 699 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		result[i] = _tmp0_;
#line 4282 "gnome-chess.c"
	}
#line 699 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	return result;
#line 4286 "gnome-chess.c"
}


static gchar** _vala_array_dup2 (gchar** self, int length) {
	gchar** result;
	int i;
#line 700 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	result = g_new0 (gchar*, length + 1);
#line 700 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	for (i = 0; i < length; i++) {
#line 4297 "gnome-chess.c"
		gchar* _tmp0_;
#line 700 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp0_ = g_strdup (self[i]);
#line 700 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		result[i] = _tmp0_;
#line 4303 "gnome-chess.c"
	}
#line 700 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	return result;
#line 4307 "gnome-chess.c"
}


static gchar** _vala_array_dup3 (gchar** self, int length) {
	gchar** result;
	int i;
#line 701 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	result = g_new0 (gchar*, length + 1);
#line 701 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	for (i = 0; i < length; i++) {
#line 4318 "gnome-chess.c"
		gchar* _tmp0_;
#line 701 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp0_ = g_strdup (self[i]);
#line 701 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		result[i] = _tmp0_;
#line 4324 "gnome-chess.c"
	}
#line 701 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	return result;
#line 4328 "gnome-chess.c"
}


static gchar** _vala_array_dup4 (gchar** self, int length) {
	gchar** result;
	int i;
#line 710 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	result = g_new0 (gchar*, length + 1);
#line 710 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	for (i = 0; i < length; i++) {
#line 4339 "gnome-chess.c"
		gchar* _tmp0_;
#line 710 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp0_ = g_strdup (self[i]);
#line 710 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		result[i] = _tmp0_;
#line 4345 "gnome-chess.c"
	}
#line 710 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	return result;
#line 4349 "gnome-chess.c"
}


static gchar** _vala_array_dup5 (gchar** self, int length) {
	gchar** result;
	int i;
#line 711 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	result = g_new0 (gchar*, length + 1);
#line 711 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	for (i = 0; i < length; i++) {
#line 4360 "gnome-chess.c"
		gchar* _tmp0_;
#line 711 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp0_ = g_strdup (self[i]);
#line 711 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		result[i] = _tmp0_;
#line 4366 "gnome-chess.c"
	}
#line 711 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	return result;
#line 4370 "gnome-chess.c"
}


static gchar** _vala_array_dup6 (gchar** self, int length) {
	gchar** result;
	int i;
#line 712 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	result = g_new0 (gchar*, length + 1);
#line 712 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	for (i = 0; i < length; i++) {
#line 4381 "gnome-chess.c"
		gchar* _tmp0_;
#line 712 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp0_ = g_strdup (self[i]);
#line 712 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		result[i] = _tmp0_;
#line 4387 "gnome-chess.c"
	}
#line 712 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	return result;
#line 4391 "gnome-chess.c"
}


static gchar** _vala_array_dup7 (gchar** self, int length) {
	gchar** result;
	int i;
#line 705 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	result = g_new0 (gchar*, length + 1);
#line 705 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	for (i = 0; i < length; i++) {
#line 4402 "gnome-chess.c"
		gchar* _tmp0_;
#line 705 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp0_ = g_strdup (self[i]);
#line 705 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		result[i] = _tmp0_;
#line 4408 "gnome-chess.c"
	}
#line 705 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	return result;
#line 4412 "gnome-chess.c"
}


static gchar** _vala_array_dup8 (gchar** self, int length) {
	gchar** result;
	int i;
#line 706 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	result = g_new0 (gchar*, length + 1);
#line 706 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	for (i = 0; i < length; i++) {
#line 4423 "gnome-chess.c"
		gchar* _tmp0_;
#line 706 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp0_ = g_strdup (self[i]);
#line 706 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		result[i] = _tmp0_;
#line 4429 "gnome-chess.c"
	}
#line 706 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	return result;
#line 4433 "gnome-chess.c"
}


static gchar** _vala_array_dup9 (gchar** self, int length) {
	gchar** result;
	int i;
#line 707 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	result = g_new0 (gchar*, length + 1);
#line 707 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	for (i = 0; i < length; i++) {
#line 4444 "gnome-chess.c"
		gchar* _tmp0_;
#line 707 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp0_ = g_strdup (self[i]);
#line 707 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		result[i] = _tmp0_;
#line 4450 "gnome-chess.c"
	}
#line 707 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	return result;
#line 4454 "gnome-chess.c"
}


static ChessEngine* chess_application_get_engine (ChessApplication* self, const gchar* name, const gchar* difficulty) {
	ChessEngine* result = NULL;
	ChessEngine* engine = NULL;
	AIProfile* profile;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GList* _tmp2_;
	AIProfile* _tmp12_;
	gchar** options = NULL;
	gint options_length1 = 0;
	gint _options_size_ = 0;
	gchar** uci_go_options = NULL;
	gint uci_go_options_length1 = 0;
	gint _uci_go_options_size_ = 0;
	gchar** args = NULL;
	gint args_length1 = 0;
	gint _args_size_ = 0;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	GQuark _tmp21_ = 0U;
#line 696 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	static GQuark _tmp20_label0 = 0;
#line 696 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	static GQuark _tmp20_label1 = 0;
#line 4482 "gnome-chess.c"
	AIProfile* _tmp58_;
	const gchar* _tmp59_;
	const gchar* _tmp60_;
#line 667 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 667 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 667 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (difficulty != NULL, NULL);
#line 670 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	profile = NULL;
#line 672 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = name;
#line 672 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (g_strcmp0 (_tmp0_, "human") == 0) {
#line 673 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		result = NULL;
#line 673 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (profile);
#line 673 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (engine);
#line 673 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		return result;
#line 4506 "gnome-chess.c"
	}
#line 676 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = name;
#line 676 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (g_strcmp0 (_tmp1_, "GNUchess") == 0) {
#line 677 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		name = "GNU Chess";
#line 4514 "gnome-chess.c"
	}
#line 679 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = self->priv->ai_profiles;
#line 4518 "gnome-chess.c"
	{
		GList* p_collection = NULL;
		GList* p_it = NULL;
#line 679 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		p_collection = _tmp2_;
#line 679 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		for (p_it = p_collection; p_it != NULL; p_it = p_it->next) {
#line 4526 "gnome-chess.c"
			AIProfile* _tmp3_;
			AIProfile* p = NULL;
#line 679 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp3_ = _g_object_ref0 ((AIProfile*) p_it->data);
#line 679 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			p = _tmp3_;
#line 4533 "gnome-chess.c"
			{
				gboolean _tmp4_ = FALSE;
				const gchar* _tmp5_;
#line 681 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp5_ = name;
#line 681 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				if (g_strcmp0 (_tmp5_, "") == 0) {
#line 681 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					_tmp4_ = TRUE;
#line 4543 "gnome-chess.c"
				} else {
					AIProfile* _tmp6_;
					const gchar* _tmp7_;
					const gchar* _tmp8_;
					const gchar* _tmp9_;
#line 681 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					_tmp6_ = p;
#line 681 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					_tmp7_ = ai_profile_get_name (_tmp6_);
#line 681 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					_tmp8_ = _tmp7_;
#line 681 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					_tmp9_ = name;
#line 681 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					_tmp4_ = g_strcmp0 (_tmp8_, _tmp9_) == 0;
#line 4559 "gnome-chess.c"
				}
#line 681 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				if (_tmp4_) {
#line 4563 "gnome-chess.c"
					AIProfile* _tmp10_;
					AIProfile* _tmp11_;
#line 683 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					_tmp10_ = p;
#line 683 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					_tmp11_ = _g_object_ref0 (_tmp10_);
#line 683 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					_g_object_unref0 (profile);
#line 683 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					profile = _tmp11_;
#line 684 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					_g_object_unref0 (p);
#line 684 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					break;
#line 4578 "gnome-chess.c"
				}
#line 679 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_g_object_unref0 (p);
#line 4582 "gnome-chess.c"
			}
		}
	}
#line 687 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp12_ = profile;
#line 687 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp12_ == NULL) {
#line 4590 "gnome-chess.c"
		const gchar* _tmp13_;
		GList* _tmp14_;
		GList* _tmp15_;
		gconstpointer _tmp16_;
		AIProfile* _tmp17_;
#line 689 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp13_ = name;
#line 689 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		g_warning ("gnome-chess.vala:689: Unknown AI profile %s", _tmp13_);
#line 690 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp14_ = self->priv->ai_profiles;
#line 690 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		if (_tmp14_ == NULL) {
#line 691 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			result = NULL;
#line 691 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_g_object_unref0 (profile);
#line 691 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_g_object_unref0 (engine);
#line 691 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			return result;
#line 4612 "gnome-chess.c"
		}
#line 692 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp15_ = self->priv->ai_profiles;
#line 692 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp16_ = _tmp15_->data;
#line 692 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp17_ = _g_object_ref0 ((AIProfile*) _tmp16_);
#line 692 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (profile);
#line 692 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		profile = _tmp17_;
#line 4624 "gnome-chess.c"
	}
#line 696 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp18_ = difficulty;
#line 696 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp19_ = _tmp18_;
#line 696 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp21_ = (NULL == _tmp19_) ? 0 : g_quark_from_string (_tmp19_);
#line 696 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp21_ == ((0 != _tmp20_label0) ? _tmp20_label0 : (_tmp20_label0 = g_quark_from_static_string ("easy")))) {
#line 696 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		switch (0) {
#line 4636 "gnome-chess.c"
			default:
			{
				AIProfile* _tmp22_;
				gchar** _tmp23_;
				gint _tmp23__length1;
				gchar** _tmp24_;
				gint _tmp24__length1;
				gchar** _tmp25_;
				gint _tmp25__length1;
				AIProfile* _tmp26_;
				gchar** _tmp27_;
				gint _tmp27__length1;
				gchar** _tmp28_;
				gint _tmp28__length1;
				gchar** _tmp29_;
				gint _tmp29__length1;
				AIProfile* _tmp30_;
				gchar** _tmp31_;
				gint _tmp31__length1;
				gchar** _tmp32_;
				gint _tmp32__length1;
				gchar** _tmp33_;
				gint _tmp33__length1;
#line 699 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp22_ = profile;
#line 699 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp23_ = ai_profile_get_easy_options (_tmp22_, &_tmp23__length1);
#line 699 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp24_ = _tmp23_;
#line 699 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp24__length1 = _tmp23__length1;
#line 699 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp25_ = (_tmp24_ != NULL) ? _vala_array_dup1 (_tmp24_, _tmp24__length1) : ((gpointer) _tmp24_);
#line 699 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp25__length1 = _tmp24__length1;
#line 699 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				options = (_vala_array_free (options, options_length1, (GDestroyNotify) g_free), NULL);
#line 699 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				options = _tmp25_;
#line 699 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				options_length1 = _tmp25__length1;
#line 699 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_options_size_ = options_length1;
#line 700 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp26_ = profile;
#line 700 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp27_ = ai_profile_get_easy_uci_go_options (_tmp26_, &_tmp27__length1);
#line 700 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp28_ = _tmp27_;
#line 700 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp28__length1 = _tmp27__length1;
#line 700 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp29_ = (_tmp28_ != NULL) ? _vala_array_dup2 (_tmp28_, _tmp28__length1) : ((gpointer) _tmp28_);
#line 700 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp29__length1 = _tmp28__length1;
#line 700 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				uci_go_options = (_vala_array_free (uci_go_options, uci_go_options_length1, (GDestroyNotify) g_free), NULL);
#line 700 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				uci_go_options = _tmp29_;
#line 700 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				uci_go_options_length1 = _tmp29__length1;
#line 700 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_uci_go_options_size_ = uci_go_options_length1;
#line 701 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp30_ = profile;
#line 701 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp31_ = ai_profile_get_easy_args (_tmp30_, &_tmp31__length1);
#line 701 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp32_ = _tmp31_;
#line 701 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp32__length1 = _tmp31__length1;
#line 701 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp33_ = (_tmp32_ != NULL) ? _vala_array_dup3 (_tmp32_, _tmp32__length1) : ((gpointer) _tmp32_);
#line 701 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp33__length1 = _tmp32__length1;
#line 701 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
#line 701 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				args = _tmp33_;
#line 701 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				args_length1 = _tmp33__length1;
#line 701 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_args_size_ = args_length1;
#line 702 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				break;
#line 4722 "gnome-chess.c"
			}
		}
	} else if (_tmp21_ == ((0 != _tmp20_label1) ? _tmp20_label1 : (_tmp20_label1 = g_quark_from_static_string ("hard")))) {
#line 696 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		switch (0) {
#line 4728 "gnome-chess.c"
			default:
			{
				AIProfile* _tmp34_;
				gchar** _tmp35_;
				gint _tmp35__length1;
				gchar** _tmp36_;
				gint _tmp36__length1;
				gchar** _tmp37_;
				gint _tmp37__length1;
				AIProfile* _tmp38_;
				gchar** _tmp39_;
				gint _tmp39__length1;
				gchar** _tmp40_;
				gint _tmp40__length1;
				gchar** _tmp41_;
				gint _tmp41__length1;
				AIProfile* _tmp42_;
				gchar** _tmp43_;
				gint _tmp43__length1;
				gchar** _tmp44_;
				gint _tmp44__length1;
				gchar** _tmp45_;
				gint _tmp45__length1;
#line 710 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp34_ = profile;
#line 710 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp35_ = ai_profile_get_hard_options (_tmp34_, &_tmp35__length1);
#line 710 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp36_ = _tmp35_;
#line 710 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp36__length1 = _tmp35__length1;
#line 710 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp37_ = (_tmp36_ != NULL) ? _vala_array_dup4 (_tmp36_, _tmp36__length1) : ((gpointer) _tmp36_);
#line 710 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp37__length1 = _tmp36__length1;
#line 710 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				options = (_vala_array_free (options, options_length1, (GDestroyNotify) g_free), NULL);
#line 710 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				options = _tmp37_;
#line 710 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				options_length1 = _tmp37__length1;
#line 710 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_options_size_ = options_length1;
#line 711 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp38_ = profile;
#line 711 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp39_ = ai_profile_get_hard_uci_go_options (_tmp38_, &_tmp39__length1);
#line 711 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp40_ = _tmp39_;
#line 711 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp40__length1 = _tmp39__length1;
#line 711 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp41_ = (_tmp40_ != NULL) ? _vala_array_dup5 (_tmp40_, _tmp40__length1) : ((gpointer) _tmp40_);
#line 711 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp41__length1 = _tmp40__length1;
#line 711 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				uci_go_options = (_vala_array_free (uci_go_options, uci_go_options_length1, (GDestroyNotify) g_free), NULL);
#line 711 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				uci_go_options = _tmp41_;
#line 711 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				uci_go_options_length1 = _tmp41__length1;
#line 711 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_uci_go_options_size_ = uci_go_options_length1;
#line 712 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp42_ = profile;
#line 712 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp43_ = ai_profile_get_hard_args (_tmp42_, &_tmp43__length1);
#line 712 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp44_ = _tmp43_;
#line 712 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp44__length1 = _tmp43__length1;
#line 712 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp45_ = (_tmp44_ != NULL) ? _vala_array_dup6 (_tmp44_, _tmp44__length1) : ((gpointer) _tmp44_);
#line 712 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp45__length1 = _tmp44__length1;
#line 712 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
#line 712 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				args = _tmp45_;
#line 712 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				args_length1 = _tmp45__length1;
#line 712 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_args_size_ = args_length1;
#line 713 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				break;
#line 4814 "gnome-chess.c"
			}
		}
	} else {
#line 696 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		switch (0) {
#line 4820 "gnome-chess.c"
			default:
			{
				AIProfile* _tmp46_;
				gchar** _tmp47_;
				gint _tmp47__length1;
				gchar** _tmp48_;
				gint _tmp48__length1;
				gchar** _tmp49_;
				gint _tmp49__length1;
				AIProfile* _tmp50_;
				gchar** _tmp51_;
				gint _tmp51__length1;
				gchar** _tmp52_;
				gint _tmp52__length1;
				gchar** _tmp53_;
				gint _tmp53__length1;
				AIProfile* _tmp54_;
				gchar** _tmp55_;
				gint _tmp55__length1;
				gchar** _tmp56_;
				gint _tmp56__length1;
				gchar** _tmp57_;
				gint _tmp57__length1;
#line 705 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp46_ = profile;
#line 705 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp47_ = ai_profile_get_normal_options (_tmp46_, &_tmp47__length1);
#line 705 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp48_ = _tmp47_;
#line 705 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp48__length1 = _tmp47__length1;
#line 705 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp49_ = (_tmp48_ != NULL) ? _vala_array_dup7 (_tmp48_, _tmp48__length1) : ((gpointer) _tmp48_);
#line 705 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp49__length1 = _tmp48__length1;
#line 705 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				options = (_vala_array_free (options, options_length1, (GDestroyNotify) g_free), NULL);
#line 705 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				options = _tmp49_;
#line 705 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				options_length1 = _tmp49__length1;
#line 705 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_options_size_ = options_length1;
#line 706 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp50_ = profile;
#line 706 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp51_ = ai_profile_get_normal_uci_go_options (_tmp50_, &_tmp51__length1);
#line 706 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp52_ = _tmp51_;
#line 706 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp52__length1 = _tmp51__length1;
#line 706 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp53_ = (_tmp52_ != NULL) ? _vala_array_dup8 (_tmp52_, _tmp52__length1) : ((gpointer) _tmp52_);
#line 706 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp53__length1 = _tmp52__length1;
#line 706 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				uci_go_options = (_vala_array_free (uci_go_options, uci_go_options_length1, (GDestroyNotify) g_free), NULL);
#line 706 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				uci_go_options = _tmp53_;
#line 706 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				uci_go_options_length1 = _tmp53__length1;
#line 706 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_uci_go_options_size_ = uci_go_options_length1;
#line 707 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp54_ = profile;
#line 707 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp55_ = ai_profile_get_normal_args (_tmp54_, &_tmp55__length1);
#line 707 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp56_ = _tmp55_;
#line 707 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp56__length1 = _tmp55__length1;
#line 707 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp57_ = (_tmp56_ != NULL) ? _vala_array_dup9 (_tmp56_, _tmp56__length1) : ((gpointer) _tmp56_);
#line 707 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp57__length1 = _tmp56__length1;
#line 707 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
#line 707 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				args = _tmp57_;
#line 707 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				args_length1 = _tmp57__length1;
#line 707 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_args_size_ = args_length1;
#line 708 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				break;
#line 4906 "gnome-chess.c"
			}
		}
	}
#line 716 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp58_ = profile;
#line 716 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp59_ = ai_profile_get_protocol (_tmp58_);
#line 716 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp60_ = _tmp59_;
#line 716 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (g_strcmp0 (_tmp60_, "cecp") == 0) {
#line 4918 "gnome-chess.c"
		gchar** _tmp61_;
		gint _tmp61__length1;
		AIProfile* _tmp62_;
		const gchar* _tmp63_;
		const gchar* _tmp64_;
		gchar** _tmp65_;
		gint _tmp65__length1;
		AIProfile* _tmp66_;
		guint _tmp67_;
		guint _tmp68_;
		gchar** _tmp69_;
		gint _tmp69__length1;
		ChessEngineCECP* _tmp70_;
#line 718 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp61_ = uci_go_options;
#line 718 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp61__length1 = uci_go_options_length1;
#line 718 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		g_warn_if_fail (_tmp61__length1 == 0);
#line 719 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp62_ = profile;
#line 719 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp63_ = ai_profile_get_binary (_tmp62_);
#line 719 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp64_ = _tmp63_;
#line 719 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp65_ = args;
#line 719 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp65__length1 = args_length1;
#line 719 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp66_ = profile;
#line 719 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp67_ = ai_profile_get_delay_seconds (_tmp66_);
#line 719 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp68_ = _tmp67_;
#line 719 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp69_ = options;
#line 719 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp69__length1 = options_length1;
#line 719 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp70_ = chess_engine_cecp_new (_tmp64_, _tmp65_, _tmp65__length1, _tmp68_, _tmp69_, _tmp69__length1);
#line 719 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (engine);
#line 719 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		engine = (ChessEngine*) _tmp70_;
#line 4964 "gnome-chess.c"
	} else {
		AIProfile* _tmp71_;
		const gchar* _tmp72_;
		const gchar* _tmp73_;
#line 721 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp71_ = profile;
#line 721 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp72_ = ai_profile_get_protocol (_tmp71_);
#line 721 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp73_ = _tmp72_;
#line 721 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		if (g_strcmp0 (_tmp73_, "uci") == 0) {
#line 4977 "gnome-chess.c"
			AIProfile* _tmp74_;
			const gchar* _tmp75_;
			const gchar* _tmp76_;
			gchar** _tmp77_;
			gint _tmp77__length1;
			AIProfile* _tmp78_;
			guint _tmp79_;
			guint _tmp80_;
			gchar** _tmp81_;
			gint _tmp81__length1;
			gchar** _tmp82_;
			gint _tmp82__length1;
			ChessEngineUCI* _tmp83_;
#line 723 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp74_ = profile;
#line 723 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp75_ = ai_profile_get_binary (_tmp74_);
#line 723 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp76_ = _tmp75_;
#line 723 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp77_ = args;
#line 723 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp77__length1 = args_length1;
#line 723 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp78_ = profile;
#line 723 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp79_ = ai_profile_get_delay_seconds (_tmp78_);
#line 723 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp80_ = _tmp79_;
#line 723 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp81_ = options;
#line 723 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp81__length1 = options_length1;
#line 723 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp82_ = uci_go_options;
#line 723 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp82__length1 = uci_go_options_length1;
#line 723 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp83_ = chess_engine_uci_new (_tmp76_, _tmp77_, _tmp77__length1, _tmp80_, _tmp81_, _tmp81__length1, _tmp82_, _tmp82__length1);
#line 723 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_g_object_unref0 (engine);
#line 723 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			engine = (ChessEngine*) _tmp83_;
#line 5021 "gnome-chess.c"
		} else {
			AIProfile* _tmp84_;
			const gchar* _tmp85_;
			const gchar* _tmp86_;
#line 727 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp84_ = profile;
#line 727 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp85_ = ai_profile_get_protocol (_tmp84_);
#line 727 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp86_ = _tmp85_;
#line 727 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			g_warning ("gnome-chess.vala:727: Unknown AI protocol %s", _tmp86_);
#line 728 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			result = NULL;
#line 728 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
#line 728 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			uci_go_options = (_vala_array_free (uci_go_options, uci_go_options_length1, (GDestroyNotify) g_free), NULL);
#line 728 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			options = (_vala_array_free (options, options_length1, (GDestroyNotify) g_free), NULL);
#line 728 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_g_object_unref0 (profile);
#line 728 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_g_object_unref0 (engine);
#line 728 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			return result;
#line 5048 "gnome-chess.c"
		}
	}
#line 731 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	result = engine;
#line 731 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
#line 731 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	uci_go_options = (_vala_array_free (uci_go_options, uci_go_options_length1, (GDestroyNotify) g_free), NULL);
#line 731 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	options = (_vala_array_free (options, options_length1, (GDestroyNotify) g_free), NULL);
#line 731 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (profile);
#line 731 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	return result;
#line 5063 "gnome-chess.c"
}


static void chess_application_engine_ready_cb (ChessApplication* self, ChessEngine* engine) {
	ChessEngine* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
#line 734 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 734 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (engine != NULL);
#line 736 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->opponent_engine;
#line 736 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = chess_engine_get_ready (_tmp0_);
#line 736 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = _tmp1_;
#line 736 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp2_) {
#line 5083 "gnome-chess.c"
		ChessView* _tmp3_;
#line 738 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp3_ = self->priv->view;
#line 738 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		gtk_widget_queue_draw ((GtkWidget*) _tmp3_);
#line 5089 "gnome-chess.c"
	}
}


static void chess_application_do_engine_move (ChessApplication* self, const gchar* move) {
	ChessPlayer* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_;
#line 742 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 742 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (move != NULL);
#line 744 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->opponent;
#line 744 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = move;
#line 744 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = chess_player_move (_tmp0_, _tmp1_, TRUE);
#line 744 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (!_tmp2_) {
#line 5110 "gnome-chess.c"
		const gchar* _tmp3_;
		ChessGame* _tmp4_;
#line 746 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp3_ = move;
#line 746 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		g_warning ("gnome-chess.vala:746: Engine's move %s is illegal! Engine desync?", _tmp3_);
#line 747 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp4_ = self->priv->game;
#line 747 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		chess_game_stop (_tmp4_, CHESS_RESULT_BUG, CHESS_RULE_BUG);
#line 5121 "gnome-chess.c"
	}
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
#line 751 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_atomic_int_inc (&_data2_->_ref_count_);
#line 751 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	return _data2_;
#line 5131 "gnome-chess.c"
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
#line 751 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
#line 5140 "gnome-chess.c"
		ChessApplication* self;
#line 751 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		self = _data2_->self;
#line 751 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_g_free0 (_data2_->move);
#line 751 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (self);
#line 751 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		g_slice_free (Block2Data, _data2_);
#line 5150 "gnome-chess.c"
	}
}


static gboolean ___lambda7_ (Block2Data* _data2_) {
	ChessApplication* self;
	gboolean result = FALSE;
	ChessGame* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
#line 759 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	self = _data2_->self;
#line 760 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->game;
#line 760 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = chess_game_get_is_paused (_tmp0_);
#line 760 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = _tmp1_;
#line 760 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp2_) {
#line 762 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		result = G_SOURCE_CONTINUE;
#line 762 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		return result;
#line 5175 "gnome-chess.c"
	} else {
		const gchar* _tmp3_;
#line 766 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp3_ = _data2_->move;
#line 766 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		chess_application_do_engine_move (self, _tmp3_);
#line 767 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		result = G_SOURCE_REMOVE;
#line 767 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		return result;
#line 5186 "gnome-chess.c"
	}
}


static gboolean ____lambda7__gsource_func (gpointer self) {
	gboolean result;
	result = ___lambda7_ (self);
#line 759 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	return result;
#line 5196 "gnome-chess.c"
}


static void chess_application_engine_move_cb (ChessApplication* self, ChessEngine* engine, const gchar* move) {
	Block2Data* _data2_;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	ChessGame* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
#line 751 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 751 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (engine != NULL);
#line 751 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (move != NULL);
#line 751 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_data2_ = g_slice_new0 (Block2Data);
#line 751 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_data2_->_ref_count_ = 1;
#line 751 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_data2_->self = g_object_ref (self);
#line 751 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = move;
#line 751 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 751 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_free0 (_data2_->move);
#line 751 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_data2_->move = _tmp1_;
#line 753 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = self->priv->game;
#line 753 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = chess_game_get_is_paused (_tmp2_);
#line 753 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = _tmp3_;
#line 753 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (!_tmp4_) {
#line 5235 "gnome-chess.c"
		const gchar* _tmp5_;
#line 755 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp5_ = _data2_->move;
#line 755 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		chess_application_do_engine_move (self, _tmp5_);
#line 5241 "gnome-chess.c"
	} else {
#line 759 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, ____lambda7__gsource_func, block2_data_ref (_data2_), block2_data_unref);
#line 5245 "gnome-chess.c"
	}
#line 751 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	block2_data_unref (_data2_);
#line 751 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_data2_ = NULL;
#line 5251 "gnome-chess.c"
}


static void chess_application_engine_resigned_cb (ChessApplication* self, ChessEngine* engine) {
	ChessPlayer* _tmp0_;
#line 773 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 773 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (engine != NULL);
#line 775 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->opponent;
#line 775 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	chess_player_resign (_tmp0_);
#line 5265 "gnome-chess.c"
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
#line 778 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_atomic_int_inc (&_data3_->_ref_count_);
#line 778 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	return _data3_;
#line 5274 "gnome-chess.c"
}


static void block3_data_unref (void * _userdata_) {
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
#line 778 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
#line 5283 "gnome-chess.c"
		ChessApplication* self;
#line 778 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		self = _data3_->self;
#line 778 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (_data3_->original_game);
#line 778 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (self);
#line 778 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		g_slice_free (Block3Data, _data3_);
#line 5293 "gnome-chess.c"
	}
}


static gboolean __lambda8_ (Block3Data* _data3_) {
	ChessApplication* self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ChessGame* _tmp1_;
#line 793 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	self = _data3_->self;
#line 794 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = self->priv->game;
#line 794 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp1_ == _data3_->original_game) {
#line 5309 "gnome-chess.c"
		ChessGame* _tmp2_;
		gboolean _tmp3_;
#line 794 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp2_ = self->priv->game;
#line 794 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp3_ = _tmp2_->is_started;
#line 794 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp0_ = _tmp3_;
#line 5318 "gnome-chess.c"
	} else {
#line 794 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp0_ = FALSE;
#line 5322 "gnome-chess.c"
	}
#line 794 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp0_) {
#line 5326 "gnome-chess.c"
		ChessGame* _tmp4_;
#line 795 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp4_ = self->priv->game;
#line 795 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		chess_game_stop (_tmp4_, CHESS_RESULT_BUG, CHESS_RULE_BUG);
#line 5332 "gnome-chess.c"
	}
#line 796 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	result = G_SOURCE_REMOVE;
#line 796 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	return result;
#line 5338 "gnome-chess.c"
}


static gboolean ___lambda8__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda8_ (self);
#line 793 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	return result;
#line 5347 "gnome-chess.c"
}


static void chess_application_engine_stopped_unexpectedly_cb (ChessApplication* self, ChessEngine* engine) {
	Block3Data* _data3_;
	ChessGame* _tmp0_;
	ChessGame* _tmp1_;
#line 778 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 778 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (engine != NULL);
#line 778 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_data3_ = g_slice_new0 (Block3Data);
#line 778 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_data3_->_ref_count_ = 1;
#line 778 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_data3_->self = g_object_ref (self);
#line 792 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->game;
#line 792 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 792 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_data3_->original_game = _tmp1_;
#line 793 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 2, ___lambda8__gsource_func, block3_data_ref (_data3_), block3_data_unref);
#line 778 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	block3_data_unref (_data3_);
#line 778 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_data3_ = NULL;
#line 5377 "gnome-chess.c"
}


static void chess_application_engine_error_cb (ChessApplication* self, ChessEngine* engine) {
	ChessGame* _tmp0_;
#line 800 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 800 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (engine != NULL);
#line 802 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->game;
#line 802 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	chess_game_stop (_tmp0_, CHESS_RESULT_BUG, CHESS_RULE_BUG);
#line 5391 "gnome-chess.c"
}


static void chess_application_engine_claim_draw_cb (ChessApplication* self, ChessEngine* engine) {
	ChessGame* _tmp0_;
	gboolean _tmp1_;
#line 805 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 805 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (engine != NULL);
#line 807 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->game;
#line 807 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = chess_game_can_claim_draw (_tmp0_);
#line 807 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (!_tmp1_) {
#line 5408 "gnome-chess.c"
		ChessGame* _tmp2_;
#line 808 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp2_ = self->priv->game;
#line 808 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		chess_game_stop (_tmp2_, CHESS_RESULT_BUG, CHESS_RULE_BUG);
#line 5414 "gnome-chess.c"
	}
}


static void chess_application_engine_offer_draw_cb (ChessApplication* self, ChessEngine* engine) {
	ChessPlayer* _tmp0_;
#line 811 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 811 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (engine != NULL);
#line 813 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->opponent;
#line 813 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	chess_player_claim_draw (_tmp0_);
#line 5429 "gnome-chess.c"
}


static void chess_application_check_engine_timeout (ChessApplication* self) {
	gint _tmp0_;
	ChessEngine* _tmp1_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	PGNGame* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gint _tmp23_;
#line 824 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 824 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->engine_timeout_counter;
#line 824 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_vala_return_if_fail (_tmp0_ >= 0, "engine_timeout_counter >= 0");
#line 828 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = self->priv->opponent_engine;
#line 828 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp1_ == NULL) {
#line 5452 "gnome-chess.c"
		gint _tmp2_;
#line 829 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp2_ = self->priv->engine_timeout_counter;
#line 829 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_vala_warn_if_fail (_tmp2_ >= 0, "engine_timeout_counter >= 0");
#line 829 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		return;
#line 5460 "gnome-chess.c"
	}
#line 831 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = self->priv->pgn_game;
#line 831 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = pgn_game_get_white_ai (_tmp5_);
#line 831 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = _tmp6_;
#line 831 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp7_ != NULL) {
#line 5470 "gnome-chess.c"
		ChessGame* _tmp8_;
		ChessPlayer* _tmp9_;
		ChessPlayer* _tmp10_;
		Color _tmp11_;
#line 831 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp8_ = self->priv->game;
#line 831 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp9_ = chess_game_get_current_player (_tmp8_);
#line 831 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp10_ = _tmp9_;
#line 831 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp11_ = _tmp10_->color;
#line 831 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp4_ = _tmp11_ == COLOR_WHITE;
#line 5485 "gnome-chess.c"
	} else {
#line 831 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp4_ = FALSE;
#line 5489 "gnome-chess.c"
	}
#line 831 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp4_) {
#line 831 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp3_ = TRUE;
#line 5495 "gnome-chess.c"
	} else {
		gboolean _tmp12_ = FALSE;
		PGNGame* _tmp13_;
		const gchar* _tmp14_;
		const gchar* _tmp15_;
#line 832 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp13_ = self->priv->pgn_game;
#line 832 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp14_ = pgn_game_get_black_ai (_tmp13_);
#line 832 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp15_ = _tmp14_;
#line 832 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		if (_tmp15_ != NULL) {
#line 5509 "gnome-chess.c"
			ChessGame* _tmp16_;
			ChessPlayer* _tmp17_;
			ChessPlayer* _tmp18_;
			Color _tmp19_;
#line 832 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp16_ = self->priv->game;
#line 832 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp17_ = chess_game_get_current_player (_tmp16_);
#line 832 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp18_ = _tmp17_;
#line 832 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp19_ = _tmp18_->color;
#line 832 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp12_ = _tmp19_ == COLOR_BLACK;
#line 5524 "gnome-chess.c"
		} else {
#line 832 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp12_ = FALSE;
#line 5528 "gnome-chess.c"
		}
#line 832 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp3_ = _tmp12_;
#line 5532 "gnome-chess.c"
	}
#line 831 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp3_) {
#line 5536 "gnome-chess.c"
		gint _tmp20_;
		gint _tmp21_;
#line 834 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp20_ = self->priv->engine_timeout_counter;
#line 834 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		self->priv->engine_timeout_counter = _tmp20_ - 1;
#line 836 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp21_ = self->priv->engine_timeout_counter;
#line 836 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		if (_tmp21_ == 0) {
#line 5547 "gnome-chess.c"
			ChessEngine* _tmp22_;
#line 840 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp22_ = self->priv->opponent_engine;
#line 840 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			chess_application_engine_error_cb (self, _tmp22_);
#line 5553 "gnome-chess.c"
		}
	} else {
#line 846 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		self->priv->engine_timeout_counter = 10;
#line 5558 "gnome-chess.c"
	}
#line 824 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp23_ = self->priv->engine_timeout_counter;
#line 824 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_vala_warn_if_fail (_tmp23_ >= 0, "engine_timeout_counter >= 0");
#line 5564 "gnome-chess.c"
}


static void chess_application_game_clock_tick_cb (ChessApplication* self, ChessClock* clock) {
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
#line 850 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 850 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (clock != NULL);
#line 852 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	chess_application_check_engine_timeout (self);
#line 853 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->white_time_label;
#line 853 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_widget_queue_draw (_tmp0_);
#line 854 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = self->priv->black_time_label;
#line 854 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_widget_queue_draw (_tmp1_);
#line 5585 "gnome-chess.c"
}


static void chess_application_game_turn_cb (ChessApplication* self, ChessGame* game, ChessPlayer* player) {
	ChessGame* _tmp0_;
	gboolean _tmp1_;
	ChessGame* _tmp2_;
	ChessClock* _tmp3_;
	ChessClock* _tmp4_;
	ChessGame* _tmp5_;
	gboolean _tmp6_;
#line 857 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 857 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (game != NULL);
#line 857 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (player != NULL);
#line 872 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = game;
#line 872 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = _tmp0_->is_started;
#line 872 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (!_tmp1_) {
#line 873 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		return;
#line 5611 "gnome-chess.c"
	}
#line 875 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = game;
#line 875 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = chess_game_get_clock (_tmp2_);
#line 875 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = _tmp3_;
#line 875 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp4_ != NULL) {
#line 876 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		chess_application_enable_window_action (self, CHESS_APPLICATION_PAUSE_RESUME_ACTION_NAME);
#line 5623 "gnome-chess.c"
	}
#line 878 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = game;
#line 878 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = chess_game_can_claim_draw (_tmp5_);
#line 878 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp6_) {
#line 879 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		chess_application_present_claim_draw_dialog (self);
#line 5633 "gnome-chess.c"
	}
}


static void chess_application_set_move_text (ChessApplication* self, GtkTreeIter* iter, ChessMove* move) {
#line 885 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	static const gchar* human_descriptions[] = {N_ ("White pawn moves from %1$s to %2$s"), N_ ("White pawn at %1$s takes the black pawn at %2$s"), N_ ("White pawn at %1$s takes the black rook at %2$s"), N_ ("White pawn at %1$s takes the black knight at %2$s"), N_ ("White pawn at %1$s takes the black bishop at %2$s"), N_ ("White pawn at %1$s takes the black queen at %2$s"), N_ ("White rook moves from %1$s to %2$s"), N_ ("White rook at %1$s takes the black pawn at %2$s"), N_ ("White rook at %1$s takes the black rook at %2$s"), N_ ("White rook at %1$s takes the black knight at %2$s"), N_ ("White rook at %1$s takes the black bishop at %2$s"), N_ ("White rook at %1$s takes the black queen at %2$s"), N_ ("White knight moves from %1$s to %2$s"), N_ ("White knight at %1$s takes the black pawn at %2$s"), N_ ("White knight at %1$s takes the black rook at %2$s"), N_ ("White knight at %1$s takes the black knight at %2$s"), N_ ("White knight at %1$s takes the black bishop at %2$s"), N_ ("White knight at %1$s takes the black queen at %2$s"), N_ ("White bishop moves from %1$s to %2$s"), N_ ("White bishop at %1$s takes the black pawn at %2$s"), N_ ("White bishop at %1$s takes the black rook at %2$s"), N_ ("White bishop at %1$s takes the black knight at %2$s"), N_ ("White bishop at %1$s takes the black bishop at %2$s"), N_ ("White bishop at %1$s takes the black queen at %2$s"), N_ ("White queen moves from %1$s to %2$s"), N_ ("White queen at %1$s takes the black pawn at %2$s"), N_ ("White queen at %1$s takes the black rook at %2$s"), N_ ("White queen at %1$s takes the black knight at %2$s"), N_ ("White queen at %1$s takes the black bishop at %2$s"), N_ ("White queen at %1$s takes the black queen at %2$s"), N_ ("White king moves from %1$s to %2$s"), N_ ("White king at %1$s takes the black pawn at %2$s"), N_ ("White king at %1$s takes the black rook at %2$s"), N_ ("White king at %1$s takes the black knight at %2$s"), N_ ("White king at %1$s takes the black bishop at %2$s"), N_ ("White king at %1$s takes the black queen at %2$s"), N_ ("Black pawn moves from %1$s to %2$s"), N_ ("Black pawn at %1$s takes the white pawn at %2$s"), N_ ("Black pawn at %1$s takes the white rook at %2$s"), N_ ("Black pawn at %1$s takes the white knight at %2$s"), N_ ("Black pawn at %1$s takes the white bishop at %2$s"), N_ ("Black pawn at %1$s takes the white queen at %2$s"), N_ ("Black rook moves from %1$s to %2$s"), N_ ("Black rook at %1$s takes the white pawn at %2$s"), N_ ("Black rook at %1$s takes the white rook at %2$s"), N_ ("Black rook at %1$s takes the white knight at %2$s"), N_ ("Black rook at %1$s takes the white bishop at %2$s"), N_ ("Black rook at %1$s takes the white queen at %2$s"), N_ ("Black knight moves from %1$s to %2$s"), N_ ("Black knight at %1$s takes the white pawn at %2$s"), N_ ("Black knight at %1$s takes the white rook at %2$s"), N_ ("Black knight at %1$s takes the white knight at %2$s"), N_ ("Black knight at %1$s takes the white bishop at %2$s"), N_ ("Black knight at %1$s takes the white queen at %2$s"), N_ ("Black bishop moves from %1$s to %2$s"), N_ ("Black bishop at %1$s takes the white pawn at %2$s"), N_ ("Black bishop at %1$s takes the white rook at %2$s"), N_ ("Black bishop at %1$s takes the white knight at %2$s"), N_ ("Black bishop at %1$s takes the white bishop at %2$s"), N_ ("Black bishop at %1$s takes the white queen at %2$s"), N_ ("Black queen moves from %1$s to %2$s"), N_ ("Black queen at %1$s takes the white pawn at %2$s"), N_ ("Black queen at %1$s takes the white rook at %2$s"), N_ ("Black queen at %1$s takes the white knight at %2$s"), N_ ("Black queen at %1$s takes the white bishop at %2$s"), N_ ("Black queen at %1$s takes the white queen at %2$s"), N_ ("Black king moves from %1$s to %2$s"), N_ ("Black king at %1$s takes the white pawn at %2$s"), N_ ("Black king at %1$s takes the white rook at %2$s"), N_ ("Black king at %1$s takes the white knight at %2$s"), N_ ("Black king at %1$s takes the white bishop at %2$s"), N_ ("Black king at %1$s takes the white queen at %2$s")};
#line 5641 "gnome-chess.c"
	gchar* move_text;
	gchar* _tmp0_;
	ChessScene* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GQuark _tmp6_ = 0U;
#line 1031 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	static GQuark _tmp5_label0 = 0;
#line 1031 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	static GQuark _tmp5_label1 = 0;
#line 1031 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	static GQuark _tmp5_label2 = 0;
#line 5655 "gnome-chess.c"
	GtkListStore* model;
	GtkComboBox* _tmp76_;
	GtkTreeModel* _tmp77_;
	GtkTreeModel* _tmp78_;
	GtkListStore* _tmp79_;
	gchar _tmp80_ = '\0';
	ChessMove* _tmp81_;
	gint _tmp82_;
	gchar* label;
	ChessMove* _tmp83_;
	gint _tmp84_;
	const gchar* _tmp85_;
	gchar* _tmp86_;
	GtkListStore* _tmp87_;
	GtkTreeIter _tmp88_;
#line 882 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 882 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (iter != NULL);
#line 882 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (move != NULL);
#line 1030 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = g_strdup ("");
#line 1030 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	move_text = _tmp0_;
#line 1031 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = self->priv->scene;
#line 1031 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = chess_scene_get_move_format (_tmp1_);
#line 1031 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = _tmp2_;
#line 1031 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = _tmp3_;
#line 1031 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = (NULL == _tmp4_) ? 0 : g_quark_from_string (_tmp4_);
#line 1031 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp6_ == ((0 != _tmp5_label0) ? _tmp5_label0 : (_tmp5_label0 = g_quark_from_static_string ("human")))) {
#line 1031 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		switch (0) {
#line 5695 "gnome-chess.c"
			default:
			{
				ChessMove* _tmp7_;
				ChessPiece* _tmp8_;
#line 1034 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp7_ = move;
#line 1034 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp8_ = _tmp7_->moved_rook;
#line 1034 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				if (_tmp8_ == NULL) {
#line 5706 "gnome-chess.c"
					gint index = 0;
					ChessMove* _tmp9_;
					ChessPiece* _tmp10_;
					gint _tmp14_;
					ChessMove* _tmp15_;
					ChessPiece* _tmp16_;
					PieceType _tmp17_;
					ChessMove* _tmp18_;
					ChessPiece* _tmp19_;
					ChessPlayer* _tmp20_;
					Color _tmp21_;
					gchar* start;
					ChessMove* _tmp23_;
					gint _tmp24_;
					ChessMove* _tmp25_;
					gint _tmp26_;
					gchar* _tmp27_;
					gchar* end;
					ChessMove* _tmp28_;
					gint _tmp29_;
					ChessMove* _tmp30_;
					gint _tmp31_;
					gchar* _tmp32_;
					gint _tmp33_;
					const gchar* _tmp34_;
					const gchar* _tmp35_;
					const gchar* _tmp36_;
					gchar* _tmp37_;
#line 1037 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					_tmp9_ = move;
#line 1037 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					_tmp10_ = _tmp9_->victim;
#line 1037 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					if (_tmp10_ == NULL) {
#line 1038 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
						index = 0;
#line 5743 "gnome-chess.c"
					} else {
						ChessMove* _tmp11_;
						ChessPiece* _tmp12_;
						PieceType _tmp13_;
#line 1040 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
						_tmp11_ = move;
#line 1040 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
						_tmp12_ = _tmp11_->victim;
#line 1040 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
						_tmp13_ = _tmp12_->type;
#line 1040 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
						index = (gint) (_tmp13_ + 1);
#line 5756 "gnome-chess.c"
					}
#line 1041 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					_tmp14_ = index;
#line 1041 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					_tmp15_ = move;
#line 1041 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					_tmp16_ = _tmp15_->piece;
#line 1041 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					_tmp17_ = _tmp16_->type;
#line 1041 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					index = _tmp14_ + (_tmp17_ * 6);
#line 1042 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					_tmp18_ = move;
#line 1042 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					_tmp19_ = _tmp18_->piece;
#line 1042 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					_tmp20_ = _tmp19_->player;
#line 1042 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					_tmp21_ = _tmp20_->color;
#line 1042 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					if (_tmp21_ == COLOR_BLACK) {
#line 5778 "gnome-chess.c"
						gint _tmp22_;
#line 1043 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
						_tmp22_ = index;
#line 1043 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
						index = _tmp22_ + 36;
#line 5784 "gnome-chess.c"
					}
#line 1045 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					_tmp23_ = move;
#line 1045 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					_tmp24_ = _tmp23_->f0;
#line 1045 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					_tmp25_ = move;
#line 1045 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					_tmp26_ = _tmp25_->r0;
#line 1045 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					_tmp27_ = g_strdup_printf ("%c%d", 'a' + _tmp24_, _tmp26_ + 1);
#line 1045 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					start = _tmp27_;
#line 1046 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					_tmp28_ = move;
#line 1046 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					_tmp29_ = _tmp28_->f1;
#line 1046 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					_tmp30_ = move;
#line 1046 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					_tmp31_ = _tmp30_->r1;
#line 1046 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					_tmp32_ = g_strdup_printf ("%c%d", 'a' + _tmp29_, _tmp31_ + 1);
#line 1046 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					end = _tmp32_;
#line 1047 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					_tmp33_ = index;
#line 1047 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					_tmp34_ = human_descriptions[_tmp33_];
#line 1047 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					_tmp35_ = start;
#line 1047 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					_tmp36_ = end;
#line 1047 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					_tmp37_ = g_strdup_printf (_ (_tmp34_), _tmp35_, _tmp36_);
#line 1047 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					_g_free0 (move_text);
#line 1047 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					move_text = _tmp37_;
#line 1034 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					_g_free0 (end);
#line 1034 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					_g_free0 (start);
#line 5828 "gnome-chess.c"
				} else {
					gboolean _tmp38_ = FALSE;
					ChessMove* _tmp39_;
					gint _tmp40_;
					ChessMove* _tmp41_;
					gint _tmp42_;
#line 1049 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					_tmp39_ = move;
#line 1049 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					_tmp40_ = _tmp39_->f0;
#line 1049 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					_tmp41_ = move;
#line 1049 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					_tmp42_ = _tmp41_->f1;
#line 1049 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					if (_tmp40_ < _tmp42_) {
#line 5845 "gnome-chess.c"
						ChessMove* _tmp43_;
						gint _tmp44_;
#line 1049 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
						_tmp43_ = move;
#line 1049 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
						_tmp44_ = _tmp43_->r0;
#line 1049 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
						_tmp38_ = _tmp44_ == 0;
#line 5854 "gnome-chess.c"
					} else {
#line 1049 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
						_tmp38_ = FALSE;
#line 5858 "gnome-chess.c"
					}
#line 1049 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					if (_tmp38_) {
#line 5862 "gnome-chess.c"
						gchar* _tmp45_;
#line 1051 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
						_tmp45_ = g_strdup (_ ("White castles kingside"));
#line 1051 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
						_g_free0 (move_text);
#line 1051 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
						move_text = _tmp45_;
#line 5870 "gnome-chess.c"
					} else {
						gboolean _tmp46_ = FALSE;
						ChessMove* _tmp47_;
						gint _tmp48_;
						ChessMove* _tmp49_;
						gint _tmp50_;
#line 1053 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
						_tmp47_ = move;
#line 1053 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
						_tmp48_ = _tmp47_->f1;
#line 1053 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
						_tmp49_ = move;
#line 1053 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
						_tmp50_ = _tmp49_->f0;
#line 1053 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
						if (_tmp48_ < _tmp50_) {
#line 5887 "gnome-chess.c"
							ChessMove* _tmp51_;
							gint _tmp52_;
#line 1053 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
							_tmp51_ = move;
#line 1053 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
							_tmp52_ = _tmp51_->r0;
#line 1053 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
							_tmp46_ = _tmp52_ == 0;
#line 5896 "gnome-chess.c"
						} else {
#line 1053 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
							_tmp46_ = FALSE;
#line 5900 "gnome-chess.c"
						}
#line 1053 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
						if (_tmp46_) {
#line 5904 "gnome-chess.c"
							gchar* _tmp53_;
#line 1055 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
							_tmp53_ = g_strdup (_ ("White castles queenside"));
#line 1055 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
							_g_free0 (move_text);
#line 1055 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
							move_text = _tmp53_;
#line 5912 "gnome-chess.c"
						} else {
							gboolean _tmp54_ = FALSE;
							ChessMove* _tmp55_;
							gint _tmp56_;
							ChessMove* _tmp57_;
							gint _tmp58_;
#line 1057 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
							_tmp55_ = move;
#line 1057 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
							_tmp56_ = _tmp55_->f0;
#line 1057 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
							_tmp57_ = move;
#line 1057 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
							_tmp58_ = _tmp57_->f1;
#line 1057 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
							if (_tmp56_ < _tmp58_) {
#line 5929 "gnome-chess.c"
								ChessMove* _tmp59_;
								gint _tmp60_;
#line 1057 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
								_tmp59_ = move;
#line 1057 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
								_tmp60_ = _tmp59_->r0;
#line 1057 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
								_tmp54_ = _tmp60_ == 7;
#line 5938 "gnome-chess.c"
							} else {
#line 1057 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
								_tmp54_ = FALSE;
#line 5942 "gnome-chess.c"
							}
#line 1057 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
							if (_tmp54_) {
#line 5946 "gnome-chess.c"
								gchar* _tmp61_;
#line 1059 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
								_tmp61_ = g_strdup (_ ("Black castles kingside"));
#line 1059 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
								_g_free0 (move_text);
#line 1059 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
								move_text = _tmp61_;
#line 5954 "gnome-chess.c"
							} else {
								gboolean _tmp62_ = FALSE;
								ChessMove* _tmp63_;
								gint _tmp64_;
								ChessMove* _tmp65_;
								gint _tmp66_;
#line 1061 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
								_tmp63_ = move;
#line 1061 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
								_tmp64_ = _tmp63_->f1;
#line 1061 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
								_tmp65_ = move;
#line 1061 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
								_tmp66_ = _tmp65_->f0;
#line 1061 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
								if (_tmp64_ < _tmp66_) {
#line 5971 "gnome-chess.c"
									ChessMove* _tmp67_;
									gint _tmp68_;
#line 1061 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
									_tmp67_ = move;
#line 1061 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
									_tmp68_ = _tmp67_->r0;
#line 1061 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
									_tmp62_ = _tmp68_ == 7;
#line 5980 "gnome-chess.c"
								} else {
#line 1061 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
									_tmp62_ = FALSE;
#line 5984 "gnome-chess.c"
								}
#line 1061 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
								if (_tmp62_) {
#line 5988 "gnome-chess.c"
									gchar* _tmp69_;
#line 1063 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
									_tmp69_ = g_strdup (_ ("Black castles queenside"));
#line 1063 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
									_g_free0 (move_text);
#line 1063 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
									move_text = _tmp69_;
#line 5996 "gnome-chess.c"
								} else {
#line 1065 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
									g_assert_not_reached ();
#line 6000 "gnome-chess.c"
								}
							}
						}
					}
				}
#line 1066 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				break;
#line 6008 "gnome-chess.c"
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label1) ? _tmp5_label1 : (_tmp5_label1 = g_quark_from_static_string ("san")))) {
#line 1031 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		switch (0) {
#line 6014 "gnome-chess.c"
			default:
			{
				ChessMove* _tmp70_;
				gchar* _tmp71_;
#line 1069 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp70_ = move;
#line 1069 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp71_ = chess_move_get_san (_tmp70_);
#line 1069 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_g_free0 (move_text);
#line 1069 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				move_text = _tmp71_;
#line 1070 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				break;
#line 6029 "gnome-chess.c"
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label2) ? _tmp5_label2 : (_tmp5_label2 = g_quark_from_static_string ("fan")))) {
#line 1031 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		switch (0) {
#line 6035 "gnome-chess.c"
			default:
			{
				ChessMove* _tmp72_;
				gchar* _tmp73_;
#line 1073 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp72_ = move;
#line 1073 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp73_ = chess_move_get_fan (_tmp72_);
#line 1073 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_g_free0 (move_text);
#line 1073 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				move_text = _tmp73_;
#line 1074 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				break;
#line 6050 "gnome-chess.c"
			}
		}
	} else {
#line 1031 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		switch (0) {
#line 6056 "gnome-chess.c"
			default:
			{
				ChessMove* _tmp74_;
				gchar* _tmp75_;
#line 1078 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp74_ = move;
#line 1078 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp75_ = chess_move_get_lan (_tmp74_);
#line 1078 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_g_free0 (move_text);
#line 1078 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				move_text = _tmp75_;
#line 1079 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				break;
#line 6071 "gnome-chess.c"
			}
		}
	}
#line 1082 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp76_ = self->priv->history_combo;
#line 1082 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp77_ = gtk_combo_box_get_model (_tmp76_);
#line 1082 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp78_ = _tmp77_;
#line 1082 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp79_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp78_, gtk_list_store_get_type (), GtkListStore));
#line 1082 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	model = _tmp79_;
#line 1083 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp81_ = move;
#line 1083 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp82_ = _tmp81_->number;
#line 1083 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if ((_tmp82_ % 2) == 0) {
#line 1083 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp80_ = 'b';
#line 6093 "gnome-chess.c"
	} else {
#line 1083 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp80_ = 'a';
#line 6097 "gnome-chess.c"
	}
#line 1083 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp83_ = move;
#line 1083 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp84_ = _tmp83_->number;
#line 1083 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp85_ = move_text;
#line 1083 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp86_ = g_strdup_printf ("%u%c. %s", (guint) ((_tmp84_ + 1) / 2), (gint) _tmp80_, _tmp85_);
#line 1083 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	label = _tmp86_;
#line 1084 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp87_ = model;
#line 1084 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp88_ = *iter;
#line 1084 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_list_store_set (_tmp87_, &_tmp88_, 0, label, -1, -1);
#line 882 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_free0 (label);
#line 882 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (model);
#line 882 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_free0 (move_text);
#line 6121 "gnome-chess.c"
}


static void chess_application_game_move_cb (ChessApplication* self, ChessGame* game, ChessMove* move) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ChessMove* _tmp2_;
	gint _tmp3_;
	ChessMove* _tmp7_;
	gint _tmp8_;
	PGNGame* _tmp9_;
	GList* _tmp10_;
	guint _tmp11_;
	ChessScene* _tmp15_;
	GtkListStore* model;
	GtkComboBox* _tmp16_;
	GtkTreeModel* _tmp17_;
	GtkTreeModel* _tmp18_;
	GtkListStore* _tmp19_;
	GtkTreeIter iter = {0};
	GtkListStore* _tmp20_;
	GtkTreeIter _tmp21_ = {0};
	GtkListStore* _tmp22_;
	GtkTreeIter _tmp23_;
	ChessMove* _tmp24_;
	gint _tmp25_;
	GtkTreeIter _tmp26_;
	ChessMove* _tmp27_;
	ChessMove* _tmp28_;
	gint _tmp29_;
	ChessGame* _tmp30_;
	guint _tmp31_;
	guint _tmp32_;
	ChessView* _tmp35_;
	ChessEngine* _tmp36_;
#line 1087 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1087 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (game != NULL);
#line 1087 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (move != NULL);
#line 1091 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	chess_application_enable_window_action (self, CHESS_APPLICATION_NEW_GAME_ACTION_NAME);
#line 1094 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	self->priv->game_needs_saving = TRUE;
#line 1097 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = move;
#line 1097 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = _tmp2_->number;
#line 1097 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp3_ == 1) {
#line 6173 "gnome-chess.c"
		ChessPlayer* _tmp4_;
#line 1097 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp4_ = self->priv->opponent;
#line 1097 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp1_ = _tmp4_ != NULL;
#line 6179 "gnome-chess.c"
	} else {
#line 1097 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp1_ = FALSE;
#line 6183 "gnome-chess.c"
	}
#line 1097 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp1_) {
#line 6187 "gnome-chess.c"
		ChessPlayer* _tmp5_;
		Color _tmp6_;
#line 1097 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp5_ = self->priv->opponent;
#line 1097 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp6_ = _tmp5_->color;
#line 1097 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp0_ = _tmp6_ == COLOR_WHITE;
#line 6196 "gnome-chess.c"
	} else {
#line 1097 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp0_ = FALSE;
#line 6200 "gnome-chess.c"
	}
#line 1097 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp0_) {
#line 1098 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		self->priv->game_needs_saving = FALSE;
#line 6206 "gnome-chess.c"
	}
#line 1100 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = move;
#line 1100 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp8_ = _tmp7_->number;
#line 1100 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp9_ = self->priv->pgn_game;
#line 1100 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp10_ = _tmp9_->moves;
#line 1100 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp11_ = g_list_length (_tmp10_);
#line 1100 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (((guint) _tmp8_) > _tmp11_) {
#line 6220 "gnome-chess.c"
		PGNGame* _tmp12_;
		ChessMove* _tmp13_;
		gchar* _tmp14_;
#line 1101 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp12_ = self->priv->pgn_game;
#line 1101 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp13_ = move;
#line 1101 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp14_ = chess_move_get_san (_tmp13_);
#line 1101 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp12_->moves = g_list_append (_tmp12_->moves, _tmp14_);
#line 6232 "gnome-chess.c"
	}
#line 1104 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp15_ = self->priv->scene;
#line 1104 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	chess_scene_set_move_number (_tmp15_, -1);
#line 1106 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp16_ = self->priv->history_combo;
#line 1106 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp17_ = gtk_combo_box_get_model (_tmp16_);
#line 1106 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp18_ = _tmp17_;
#line 1106 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp19_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, gtk_list_store_get_type (), GtkListStore));
#line 1106 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	model = _tmp19_;
#line 1108 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp20_ = model;
#line 1108 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_list_store_append (_tmp20_, &_tmp21_);
#line 1108 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	iter = _tmp21_;
#line 1109 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp22_ = model;
#line 1109 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp23_ = iter;
#line 1109 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp24_ = move;
#line 1109 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp25_ = _tmp24_->number;
#line 1109 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_list_store_set (_tmp22_, &_tmp23_, 1, _tmp25_, -1, -1);
#line 1110 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp26_ = iter;
#line 1110 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp27_ = move;
#line 1110 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	chess_application_set_move_text (self, &_tmp26_, _tmp27_);
#line 1113 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp28_ = move;
#line 1113 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp29_ = _tmp28_->number;
#line 1113 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp30_ = game;
#line 1113 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp31_ = chess_game_get_n_moves (_tmp30_);
#line 1113 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp32_ = _tmp31_;
#line 1113 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (((guint) _tmp29_) == _tmp32_) {
#line 6282 "gnome-chess.c"
		GtkComboBox* _tmp33_;
		GtkTreeIter _tmp34_;
#line 1114 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp33_ = self->priv->history_combo;
#line 1114 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp34_ = iter;
#line 1114 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		gtk_combo_box_set_active_iter (_tmp33_, &_tmp34_);
#line 6291 "gnome-chess.c"
	}
#line 1116 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	chess_application_enable_window_action (self, CHESS_APPLICATION_SAVE_GAME_ACTION_NAME);
#line 1117 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	chess_application_enable_window_action (self, CHESS_APPLICATION_SAVE_GAME_AS_ACTION_NAME);
#line 1118 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	chess_application_update_history_panel (self);
#line 1119 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	chess_application_update_action_status (self);
#line 1120 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	chess_application_update_headerbar_title (self);
#line 1122 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp35_ = self->priv->view;
#line 1122 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_widget_queue_draw ((GtkWidget*) _tmp35_);
#line 1124 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp36_ = self->priv->opponent_engine;
#line 1124 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp36_ != NULL) {
#line 6311 "gnome-chess.c"
		ChessEngine* _tmp37_;
		ChessMove* _tmp38_;
		gboolean _tmp39_ = FALSE;
		ChessMove* _tmp40_;
		ChessPiece* _tmp41_;
		Color _tmp42_;
		Color _tmp43_;
		ChessPlayer* _tmp44_;
		Color _tmp45_;
#line 1126 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp37_ = self->priv->opponent_engine;
#line 1126 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp38_ = move;
#line 1126 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		chess_engine_report_move (_tmp37_, _tmp38_);
#line 1128 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp40_ = move;
#line 1128 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp41_ = _tmp40_->piece;
#line 1128 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp42_ = chess_piece_get_color (_tmp41_);
#line 1128 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp43_ = _tmp42_;
#line 1128 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp44_ = self->priv->opponent;
#line 1128 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp45_ = _tmp44_->color;
#line 1128 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		if (_tmp43_ != _tmp45_) {
#line 6341 "gnome-chess.c"
			gboolean _tmp46_;
#line 1128 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp46_ = self->priv->starting;
#line 1128 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp39_ = !_tmp46_;
#line 6347 "gnome-chess.c"
		} else {
#line 1128 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp39_ = FALSE;
#line 6351 "gnome-chess.c"
		}
#line 1128 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		if (_tmp39_) {
#line 6355 "gnome-chess.c"
			ChessEngine* _tmp47_;
#line 1129 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp47_ = self->priv->opponent_engine;
#line 1129 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			chess_engine_move (_tmp47_);
#line 6361 "gnome-chess.c"
		}
	}
#line 1087 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (model);
#line 6366 "gnome-chess.c"
}


static void chess_application_game_undo_cb (ChessApplication* self, ChessGame* game) {
	ChessEngine* _tmp0_;
	PGNGame* _tmp2_;
	PGNGame* _tmp3_;
	GList* _tmp4_;
	GList* _tmp5_;
	GtkListStore* model;
	GtkComboBox* _tmp6_;
	GtkTreeModel* _tmp7_;
	GtkTreeModel* _tmp8_;
	GtkListStore* _tmp9_;
	GtkTreeIter iter = {0};
	GtkListStore* _tmp10_;
	GtkListStore* _tmp11_;
	gint _tmp12_;
	GtkTreeIter _tmp13_ = {0};
	GtkListStore* _tmp14_;
	ChessScene* _tmp15_;
	GtkListStore* _tmp16_;
	GtkListStore* _tmp17_;
	gint _tmp18_;
	GtkTreeIter _tmp19_ = {0};
	GtkComboBox* _tmp20_;
	GtkTreeIter _tmp21_;
	ChessView* _tmp22_;
	ChessGame* _tmp23_;
	guint _tmp24_;
	guint _tmp25_;
#line 1133 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1133 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (game != NULL);
#line 1136 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->opponent_engine;
#line 1136 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp0_ != NULL) {
#line 6406 "gnome-chess.c"
		ChessEngine* _tmp1_;
#line 1137 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp1_ = self->priv->opponent_engine;
#line 1137 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		chess_engine_undo (_tmp1_);
#line 6412 "gnome-chess.c"
	}
#line 1140 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = self->priv->pgn_game;
#line 1140 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = self->priv->pgn_game;
#line 1140 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = _tmp3_->moves;
#line 1140 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = g_list_last (_tmp4_);
#line 1140 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp2_->moves = g_list_remove_link (_tmp2_->moves, _tmp5_);
#line 1143 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = self->priv->history_combo;
#line 1143 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = gtk_combo_box_get_model (_tmp6_);
#line 1143 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp8_ = _tmp7_;
#line 1143 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_list_store_get_type (), GtkListStore));
#line 1143 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	model = _tmp9_;
#line 1145 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp10_ = model;
#line 1145 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp11_ = model;
#line 1145 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp12_ = gtk_tree_model_iter_n_children ((GtkTreeModel*) _tmp11_, NULL);
#line 1145 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_tree_model_iter_nth_child ((GtkTreeModel*) _tmp10_, &_tmp13_, NULL, _tmp12_ - 1);
#line 1145 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	iter = _tmp13_;
#line 1146 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp14_ = model;
#line 1146 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_list_store_remove (_tmp14_, &iter);
#line 1149 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp15_ = self->priv->scene;
#line 1149 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	chess_scene_set_move_number (_tmp15_, -1);
#line 1152 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp16_ = model;
#line 1152 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp17_ = model;
#line 1152 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp18_ = gtk_tree_model_iter_n_children ((GtkTreeModel*) _tmp17_, NULL);
#line 1152 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_tree_model_iter_nth_child ((GtkTreeModel*) _tmp16_, &_tmp19_, NULL, _tmp18_ - 1);
#line 1152 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	iter = _tmp19_;
#line 1153 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp20_ = self->priv->history_combo;
#line 1153 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp21_ = iter;
#line 1153 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_combo_box_set_active_iter (_tmp20_, &_tmp21_);
#line 1154 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp22_ = self->priv->view;
#line 1154 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_widget_queue_draw ((GtkWidget*) _tmp22_);
#line 1156 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp23_ = game;
#line 1156 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp24_ = chess_game_get_n_moves (_tmp23_);
#line 1156 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp25_ = _tmp24_;
#line 1156 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp25_ > ((guint) 0)) {
#line 1158 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		self->priv->game_needs_saving = TRUE;
#line 1159 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		chess_application_enable_window_action (self, CHESS_APPLICATION_SAVE_GAME_ACTION_NAME);
#line 1160 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		chess_application_enable_window_action (self, CHESS_APPLICATION_SAVE_GAME_AS_ACTION_NAME);
#line 6486 "gnome-chess.c"
	} else {
#line 1164 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		self->priv->game_needs_saving = FALSE;
#line 1165 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		chess_application_disable_window_action (self, CHESS_APPLICATION_NEW_GAME_ACTION_NAME);
#line 1166 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		chess_application_disable_window_action (self, CHESS_APPLICATION_SAVE_GAME_ACTION_NAME);
#line 1167 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		chess_application_disable_window_action (self, CHESS_APPLICATION_SAVE_GAME_AS_ACTION_NAME);
#line 6496 "gnome-chess.c"
	}
#line 1170 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	chess_application_update_history_panel (self);
#line 1171 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	chess_application_update_action_status (self);
#line 1172 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	chess_application_update_headerbar_title (self);
#line 1133 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (model);
#line 6506 "gnome-chess.c"
}


static void chess_application_update_action_status (ChessApplication* self) {
	gboolean _tmp0_ = FALSE;
	ChessGame* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	gboolean can_resign;
	gboolean _tmp7_;
	gboolean _tmp8_ = FALSE;
	ChessGame* _tmp9_;
	guint _tmp10_;
	guint _tmp11_;
	gboolean can_undo;
	gboolean _tmp15_ = FALSE;
	ChessPlayer* _tmp16_;
	gboolean _tmp26_;
#line 1175 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1177 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = self->priv->game;
#line 1177 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = chess_game_get_n_moves (_tmp1_);
#line 1177 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = _tmp2_;
#line 1177 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp3_ > ((guint) 0)) {
#line 6535 "gnome-chess.c"
		ChessGame* _tmp4_;
		gboolean _tmp5_;
		gboolean _tmp6_;
#line 1177 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp4_ = self->priv->game;
#line 1177 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp5_ = chess_game_get_is_paused (_tmp4_);
#line 1177 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp6_ = _tmp5_;
#line 1177 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp0_ = !_tmp6_;
#line 6547 "gnome-chess.c"
	} else {
#line 1177 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp0_ = FALSE;
#line 6551 "gnome-chess.c"
	}
#line 1177 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	can_resign = _tmp0_;
#line 1178 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = can_resign;
#line 1178 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp7_) {
#line 1179 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		chess_application_enable_window_action (self, CHESS_APPLICATION_RESIGN_ACTION_NAME);
#line 6561 "gnome-chess.c"
	} else {
#line 1181 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		chess_application_disable_window_action (self, CHESS_APPLICATION_RESIGN_ACTION_NAME);
#line 6565 "gnome-chess.c"
	}
#line 1184 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp9_ = self->priv->game;
#line 1184 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp10_ = chess_game_get_n_moves (_tmp9_);
#line 1184 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp11_ = _tmp10_;
#line 1184 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp11_ > ((guint) 0)) {
#line 6575 "gnome-chess.c"
		ChessGame* _tmp12_;
		gboolean _tmp13_;
		gboolean _tmp14_;
#line 1184 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp12_ = self->priv->game;
#line 1184 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp13_ = chess_game_get_is_paused (_tmp12_);
#line 1184 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp14_ = _tmp13_;
#line 1184 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp8_ = !_tmp14_;
#line 6587 "gnome-chess.c"
	} else {
#line 1184 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp8_ = FALSE;
#line 6591 "gnome-chess.c"
	}
#line 1184 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	can_undo = _tmp8_;
#line 1185 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp16_ = self->priv->opponent;
#line 1185 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp16_ != NULL) {
#line 6599 "gnome-chess.c"
		ChessPlayer* _tmp17_;
		Color _tmp18_;
#line 1185 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp17_ = self->priv->opponent;
#line 1185 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp18_ = _tmp17_->color;
#line 1185 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp15_ = _tmp18_ == COLOR_WHITE;
#line 6608 "gnome-chess.c"
	} else {
#line 1185 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp15_ = FALSE;
#line 6612 "gnome-chess.c"
	}
#line 1185 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp15_) {
#line 6616 "gnome-chess.c"
		gboolean _tmp19_ = FALSE;
		ChessGame* _tmp20_;
		guint _tmp21_;
		guint _tmp22_;
#line 1186 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp20_ = self->priv->game;
#line 1186 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp21_ = chess_game_get_n_moves (_tmp20_);
#line 1186 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp22_ = _tmp21_;
#line 1186 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		if (_tmp22_ > ((guint) 1)) {
#line 6629 "gnome-chess.c"
			ChessGame* _tmp23_;
			gboolean _tmp24_;
			gboolean _tmp25_;
#line 1186 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp23_ = self->priv->game;
#line 1186 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp24_ = chess_game_get_is_paused (_tmp23_);
#line 1186 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp25_ = _tmp24_;
#line 1186 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp19_ = !_tmp25_;
#line 6641 "gnome-chess.c"
		} else {
#line 1186 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp19_ = FALSE;
#line 6645 "gnome-chess.c"
		}
#line 1186 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		can_undo = _tmp19_;
#line 6649 "gnome-chess.c"
	}
#line 1188 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp26_ = can_undo;
#line 1188 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp26_) {
#line 1189 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		chess_application_enable_window_action (self, CHESS_APPLICATION_UNDO_MOVE_ACTION_NAME);
#line 6657 "gnome-chess.c"
	} else {
#line 1191 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		chess_application_disable_window_action (self, CHESS_APPLICATION_UNDO_MOVE_ACTION_NAME);
#line 6661 "gnome-chess.c"
	}
}


static void chess_application_update_headerbar_title (ChessApplication* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ChessPlayer* _tmp2_;
#line 1194 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1196 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = self->priv->human_player;
#line 1196 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp2_ == NULL) {
#line 1196 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp1_ = TRUE;
#line 6678 "gnome-chess.c"
	} else {
		ChessPlayer* _tmp3_;
		Color _tmp4_;
		ChessGame* _tmp5_;
		ChessPlayer* _tmp6_;
		ChessPlayer* _tmp7_;
		Color _tmp8_;
#line 1197 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp3_ = self->priv->human_player;
#line 1197 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp4_ = _tmp3_->color;
#line 1197 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp5_ = self->priv->game;
#line 1197 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp6_ = chess_game_get_current_player (_tmp5_);
#line 1197 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp7_ = _tmp6_;
#line 1197 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp8_ = _tmp7_->color;
#line 1197 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp1_ = _tmp4_ == _tmp8_;
#line 6700 "gnome-chess.c"
	}
#line 1196 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp1_) {
#line 6704 "gnome-chess.c"
		ChessGame* _tmp9_;
		ChessState* _tmp10_;
		ChessState* _tmp11_;
		ChessGame* _tmp12_;
		ChessPlayer* _tmp13_;
		ChessPlayer* _tmp14_;
		gboolean _tmp15_;
#line 1198 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp9_ = self->priv->game;
#line 1198 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp10_ = chess_game_get_current_state (_tmp9_);
#line 1198 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp11_ = _tmp10_;
#line 1198 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp12_ = self->priv->game;
#line 1198 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp13_ = chess_game_get_current_player (_tmp12_);
#line 1198 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp14_ = _tmp13_;
#line 1198 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp15_ = chess_state_is_in_check (_tmp11_, _tmp14_);
#line 1198 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp0_ = _tmp15_;
#line 6728 "gnome-chess.c"
	} else {
#line 1196 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp0_ = FALSE;
#line 6732 "gnome-chess.c"
	}
#line 1196 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp0_) {
#line 6736 "gnome-chess.c"
		ChessGame* _tmp16_;
		ChessPlayer* _tmp17_;
		ChessPlayer* _tmp18_;
		Color _tmp19_;
#line 1200 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp16_ = self->priv->game;
#line 1200 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp17_ = chess_game_get_current_player (_tmp16_);
#line 1200 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp18_ = _tmp17_;
#line 1200 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp19_ = _tmp18_->color;
#line 1200 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		if (_tmp19_ == COLOR_WHITE) {
#line 6751 "gnome-chess.c"
			GtkHeaderBar* _tmp20_;
#line 1202 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp20_ = self->priv->headerbar;
#line 1202 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			gtk_header_bar_set_title (_tmp20_, _ ("White is in Check"));
#line 6757 "gnome-chess.c"
		} else {
			GtkHeaderBar* _tmp21_;
#line 1205 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp21_ = self->priv->headerbar;
#line 1205 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			gtk_header_bar_set_title (_tmp21_, _ ("Black is in Check"));
#line 6764 "gnome-chess.c"
		}
	} else {
		ChessGame* _tmp22_;
		ChessPlayer* _tmp23_;
		ChessPlayer* _tmp24_;
		Color _tmp25_;
#line 1207 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp22_ = self->priv->game;
#line 1207 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp23_ = chess_game_get_current_player (_tmp22_);
#line 1207 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp24_ = _tmp23_;
#line 1207 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp25_ = _tmp24_->color;
#line 1207 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		if (_tmp25_ == COLOR_WHITE) {
#line 6781 "gnome-chess.c"
			gboolean _tmp26_ = FALSE;
			ChessPlayer* _tmp27_;
#line 1209 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp27_ = self->priv->human_player;
#line 1209 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			if (_tmp27_ == NULL) {
#line 1209 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp26_ = TRUE;
#line 6790 "gnome-chess.c"
			} else {
				ChessPlayer* _tmp28_;
				Color _tmp29_;
#line 1209 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp28_ = self->priv->human_player;
#line 1209 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp29_ = _tmp28_->color;
#line 1209 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp26_ = _tmp29_ == COLOR_WHITE;
#line 6800 "gnome-chess.c"
			}
#line 1209 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			if (_tmp26_) {
#line 6804 "gnome-chess.c"
				GtkHeaderBar* _tmp30_;
#line 1211 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp30_ = self->priv->headerbar;
#line 1211 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				gtk_header_bar_set_title (_tmp30_, _ ("White to Move"));
#line 6810 "gnome-chess.c"
			} else {
				GtkHeaderBar* _tmp31_;
#line 1214 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp31_ = self->priv->headerbar;
#line 1214 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				gtk_header_bar_set_title (_tmp31_, _ ("White is Thinking…"));
#line 6817 "gnome-chess.c"
			}
		} else {
			gboolean _tmp32_ = FALSE;
			ChessPlayer* _tmp33_;
#line 1218 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp33_ = self->priv->human_player;
#line 1218 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			if (_tmp33_ == NULL) {
#line 1218 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp32_ = TRUE;
#line 6828 "gnome-chess.c"
			} else {
				ChessPlayer* _tmp34_;
				Color _tmp35_;
#line 1218 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp34_ = self->priv->human_player;
#line 1218 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp35_ = _tmp34_->color;
#line 1218 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp32_ = _tmp35_ == COLOR_BLACK;
#line 6838 "gnome-chess.c"
			}
#line 1218 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			if (_tmp32_) {
#line 6842 "gnome-chess.c"
				GtkHeaderBar* _tmp36_;
#line 1220 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp36_ = self->priv->headerbar;
#line 1220 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				gtk_header_bar_set_title (_tmp36_, _ ("Black to Move"));
#line 6848 "gnome-chess.c"
			} else {
				GtkHeaderBar* _tmp37_;
#line 1223 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp37_ = self->priv->headerbar;
#line 1223 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				gtk_header_bar_set_title (_tmp37_, _ ("Black is Thinking…"));
#line 6855 "gnome-chess.c"
			}
		}
	}
}


static void chess_application_update_pause_resume_button (ChessApplication* self) {
	gboolean _tmp0_ = FALSE;
	ChessGame* _tmp1_;
	gboolean _tmp7_ = FALSE;
	ChessGame* _tmp8_;
#line 1227 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1229 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = self->priv->game;
#line 1229 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp1_ != NULL) {
#line 6873 "gnome-chess.c"
		ChessGame* _tmp2_;
		ChessClock* _tmp3_;
		ChessClock* _tmp4_;
#line 1229 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp2_ = self->priv->game;
#line 1229 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp3_ = chess_game_get_clock (_tmp2_);
#line 1229 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp4_ = _tmp3_;
#line 1229 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp0_ = _tmp4_ == NULL;
#line 6885 "gnome-chess.c"
	} else {
#line 1229 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp0_ = FALSE;
#line 6889 "gnome-chess.c"
	}
#line 1229 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp0_) {
#line 6893 "gnome-chess.c"
		GtkButton* _tmp5_;
#line 1230 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp5_ = self->priv->pause_resume_button;
#line 1230 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		gtk_widget_hide ((GtkWidget*) _tmp5_);
#line 6899 "gnome-chess.c"
	} else {
		GtkButton* _tmp6_;
#line 1232 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp6_ = self->priv->pause_resume_button;
#line 1232 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		gtk_widget_show ((GtkWidget*) _tmp6_);
#line 6906 "gnome-chess.c"
	}
#line 1234 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp8_ = self->priv->game;
#line 1234 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp8_ != NULL) {
#line 6912 "gnome-chess.c"
		ChessGame* _tmp9_;
		gboolean _tmp10_;
		gboolean _tmp11_;
#line 1234 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp9_ = self->priv->game;
#line 1234 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp10_ = chess_game_get_is_paused (_tmp9_);
#line 1234 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp11_ = _tmp10_;
#line 1234 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp7_ = _tmp11_;
#line 6924 "gnome-chess.c"
	} else {
#line 1234 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp7_ = FALSE;
#line 6928 "gnome-chess.c"
	}
#line 1234 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp7_) {
#line 6932 "gnome-chess.c"
		GtkButton* _tmp12_;
		GtkImage* _tmp13_;
		GtkImage* _tmp14_;
		GtkButton* _tmp15_;
#line 1236 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp12_ = self->priv->pause_resume_button;
#line 1236 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp13_ = (GtkImage*) gtk_image_new_from_icon_name ("media-playback-start-symbolic", GTK_ICON_SIZE_BUTTON);
#line 1236 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		g_object_ref_sink (_tmp13_);
#line 1236 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp14_ = _tmp13_;
#line 1236 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		gtk_button_set_image (_tmp12_, (GtkWidget*) _tmp14_);
#line 1236 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (_tmp14_);
#line 1238 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp15_ = self->priv->pause_resume_button;
#line 1238 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp15_, _ ("Unpause the game"));
#line 6953 "gnome-chess.c"
	} else {
		GtkButton* _tmp16_;
		GtkImage* _tmp17_;
		GtkImage* _tmp18_;
		GtkButton* _tmp19_;
#line 1242 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp16_ = self->priv->pause_resume_button;
#line 1242 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp17_ = (GtkImage*) gtk_image_new_from_icon_name ("media-playback-pause-symbolic", GTK_ICON_SIZE_BUTTON);
#line 1242 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		g_object_ref_sink (_tmp17_);
#line 1242 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp18_ = _tmp17_;
#line 1242 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		gtk_button_set_image (_tmp16_, (GtkWidget*) _tmp18_);
#line 1242 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (_tmp18_);
#line 1244 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp19_ = self->priv->pause_resume_button;
#line 1244 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp19_, _ ("Pause the game"));
#line 6975 "gnome-chess.c"
	}
}


static void chess_application_game_end_cb (ChessApplication* self) {
	ChessEngine* _tmp0_;
	gchar* title;
	gchar* _tmp2_;
	ChessGame* _tmp3_;
	ChessResult _tmp4_;
	gchar* reason;
	gchar* _tmp15_;
	ChessGame* _tmp16_;
	ChessRule _tmp17_;
	GtkHeaderBar* _tmp51_;
	const gchar* _tmp52_;
	GtkHeaderBar* _tmp53_;
	const gchar* _tmp54_;
	GtkWidget* _tmp55_;
	GtkWidget* _tmp56_;
#line 1248 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1250 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	chess_application_disable_window_action (self, CHESS_APPLICATION_RESIGN_ACTION_NAME);
#line 1251 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	chess_application_disable_window_action (self, CHESS_APPLICATION_UNDO_MOVE_ACTION_NAME);
#line 1252 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	chess_application_disable_window_action (self, CHESS_APPLICATION_PAUSE_RESUME_ACTION_NAME);
#line 1255 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	chess_application_enable_window_action (self, CHESS_APPLICATION_NEW_GAME_ACTION_NAME);
#line 1257 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	self->priv->game_needs_saving = FALSE;
#line 1259 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->opponent_engine;
#line 1259 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp0_ != NULL) {
#line 7012 "gnome-chess.c"
		ChessEngine* _tmp1_;
#line 1260 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp1_ = self->priv->opponent_engine;
#line 1260 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		chess_engine_stop (_tmp1_, TRUE);
#line 7018 "gnome-chess.c"
	}
#line 1262 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = g_strdup ("");
#line 1262 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	title = _tmp2_;
#line 1263 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = self->priv->game;
#line 1263 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = _tmp3_->result;
#line 1263 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	switch (_tmp4_) {
#line 1263 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		case CHESS_RESULT_WHITE_WON:
#line 7032 "gnome-chess.c"
		{
			gchar* _tmp5_;
			PGNGame* _tmp6_;
			const gchar* _tmp7_;
#line 1267 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp5_ = g_strdup (_ ("White Wins"));
#line 1267 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_g_free0 (title);
#line 1267 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			title = _tmp5_;
#line 1268 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp6_ = self->priv->pgn_game;
#line 1268 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp7_ = pgn_game_RESULT_WHITE;
#line 1268 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			pgn_game_set_result (_tmp6_, _tmp7_);
#line 1269 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			break;
#line 7051 "gnome-chess.c"
		}
#line 1263 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		case CHESS_RESULT_BLACK_WON:
#line 7055 "gnome-chess.c"
		{
			gchar* _tmp8_;
			PGNGame* _tmp9_;
			const gchar* _tmp10_;
#line 1272 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp8_ = g_strdup (_ ("Black Wins"));
#line 1272 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_g_free0 (title);
#line 1272 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			title = _tmp8_;
#line 1273 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp9_ = self->priv->pgn_game;
#line 1273 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp10_ = pgn_game_RESULT_BLACK;
#line 1273 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			pgn_game_set_result (_tmp9_, _tmp10_);
#line 1274 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			break;
#line 7074 "gnome-chess.c"
		}
#line 1263 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		case CHESS_RESULT_DRAW:
#line 7078 "gnome-chess.c"
		{
			gchar* _tmp11_;
			PGNGame* _tmp12_;
			const gchar* _tmp13_;
#line 1277 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp11_ = g_strdup (_ ("Game is Drawn"));
#line 1277 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_g_free0 (title);
#line 1277 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			title = _tmp11_;
#line 1278 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp12_ = self->priv->pgn_game;
#line 1278 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp13_ = pgn_game_RESULT_DRAW;
#line 1278 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			pgn_game_set_result (_tmp12_, _tmp13_);
#line 1279 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			break;
#line 7097 "gnome-chess.c"
		}
#line 1263 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		case CHESS_RESULT_BUG:
#line 7101 "gnome-chess.c"
		{
			gchar* _tmp14_;
#line 1289 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp14_ = g_strdup (_ ("Oops! Something has gone wrong."));
#line 1289 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_g_free0 (title);
#line 1289 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			title = _tmp14_;
#line 1291 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			break;
#line 7112 "gnome-chess.c"
		}
		default:
		{
#line 1293 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			break;
#line 7118 "gnome-chess.c"
		}
	}
#line 1296 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp15_ = g_strdup ("");
#line 1296 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	reason = _tmp15_;
#line 1297 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp16_ = self->priv->game;
#line 1297 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp17_ = _tmp16_->rule;
#line 1297 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	switch (_tmp17_) {
#line 1297 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		case CHESS_RULE_CHECKMATE:
#line 7133 "gnome-chess.c"
		{
			ChessGame* _tmp18_;
			ChessResult _tmp19_;
#line 1300 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp18_ = self->priv->game;
#line 1300 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp19_ = _tmp18_->result;
#line 1300 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			if (_tmp19_ == CHESS_RESULT_WHITE_WON) {
#line 7143 "gnome-chess.c"
				gchar* _tmp20_;
#line 1302 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp20_ = g_strdup (_ ("Black is in check and cannot move."));
#line 1302 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_g_free0 (reason);
#line 1302 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				reason = _tmp20_;
#line 7151 "gnome-chess.c"
			} else {
				ChessGame* _tmp21_;
				ChessResult _tmp22_;
#line 1303 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp21_ = self->priv->game;
#line 1303 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp22_ = _tmp21_->result;
#line 1303 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				if (_tmp22_ == CHESS_RESULT_BLACK_WON) {
#line 7161 "gnome-chess.c"
					gchar* _tmp23_;
#line 1305 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					_tmp23_ = g_strdup (_ ("White is in check and cannot move."));
#line 1305 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					_g_free0 (reason);
#line 1305 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					reason = _tmp23_;
#line 7169 "gnome-chess.c"
				} else {
#line 1307 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					g_assert_not_reached ();
#line 7173 "gnome-chess.c"
				}
			}
#line 1308 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			break;
#line 7178 "gnome-chess.c"
		}
#line 1297 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		case CHESS_RULE_STALEMATE:
#line 7182 "gnome-chess.c"
		{
			gchar* _tmp24_;
#line 1311 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp24_ = g_strdup (_ ("Opponent cannot move."));
#line 1311 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_g_free0 (reason);
#line 1311 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			reason = _tmp24_;
#line 1312 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			break;
#line 7193 "gnome-chess.c"
		}
#line 1297 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		case CHESS_RULE_FIFTY_MOVES:
#line 7197 "gnome-chess.c"
		{
			gchar* _tmp25_;
#line 1315 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp25_ = g_strdup (_ ("No piece was taken or pawn moved in fifty moves."));
#line 1315 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_g_free0 (reason);
#line 1315 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			reason = _tmp25_;
#line 1316 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			break;
#line 7208 "gnome-chess.c"
		}
#line 1297 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		case CHESS_RULE_SEVENTY_FIVE_MOVES:
#line 7212 "gnome-chess.c"
		{
			gchar* _tmp26_;
#line 1319 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp26_ = g_strdup (_ ("No piece was taken or pawn moved in 75 moves."));
#line 1319 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_g_free0 (reason);
#line 1319 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			reason = _tmp26_;
#line 1320 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			break;
#line 7223 "gnome-chess.c"
		}
#line 1297 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		case CHESS_RULE_TIMEOUT:
#line 7227 "gnome-chess.c"
		{
			ChessGame* _tmp27_;
			ChessResult _tmp28_;
#line 1322 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp27_ = self->priv->game;
#line 1322 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp28_ = _tmp27_->result;
#line 1322 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			if (_tmp28_ == CHESS_RESULT_WHITE_WON) {
#line 7237 "gnome-chess.c"
				gchar* _tmp29_;
#line 1324 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp29_ = g_strdup (_ ("Black has run out of time."));
#line 1324 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_g_free0 (reason);
#line 1324 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				reason = _tmp29_;
#line 7245 "gnome-chess.c"
			} else {
				ChessGame* _tmp30_;
				ChessResult _tmp31_;
#line 1325 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp30_ = self->priv->game;
#line 1325 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp31_ = _tmp30_->result;
#line 1325 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				if (_tmp31_ == CHESS_RESULT_BLACK_WON) {
#line 7255 "gnome-chess.c"
					gchar* _tmp32_;
#line 1327 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					_tmp32_ = g_strdup (_ ("White has run out of time."));
#line 1327 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					_g_free0 (reason);
#line 1327 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					reason = _tmp32_;
#line 7263 "gnome-chess.c"
				} else {
#line 1329 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					g_assert_not_reached ();
#line 7267 "gnome-chess.c"
				}
			}
#line 1330 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			break;
#line 7272 "gnome-chess.c"
		}
#line 1297 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		case CHESS_RULE_THREE_FOLD_REPETITION:
#line 7276 "gnome-chess.c"
		{
			gchar* _tmp33_;
#line 1333 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp33_ = g_strdup (_ ("The same board state has occurred three times."));
#line 1333 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_g_free0 (reason);
#line 1333 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			reason = _tmp33_;
#line 1334 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			break;
#line 7287 "gnome-chess.c"
		}
#line 1297 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		case CHESS_RULE_FIVE_FOLD_REPETITION:
#line 7291 "gnome-chess.c"
		{
			gchar* _tmp34_;
#line 1337 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp34_ = g_strdup (_ ("The same board state has occurred five times."));
#line 1337 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_g_free0 (reason);
#line 1337 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			reason = _tmp34_;
#line 1338 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			break;
#line 7302 "gnome-chess.c"
		}
#line 1297 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		case CHESS_RULE_INSUFFICIENT_MATERIAL:
#line 7306 "gnome-chess.c"
		{
			gchar* _tmp35_;
#line 1341 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp35_ = g_strdup (_ ("Neither player can checkmate."));
#line 1341 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_g_free0 (reason);
#line 1341 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			reason = _tmp35_;
#line 1342 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			break;
#line 7317 "gnome-chess.c"
		}
#line 1297 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		case CHESS_RULE_RESIGN:
#line 7321 "gnome-chess.c"
		{
			ChessGame* _tmp36_;
			ChessResult _tmp37_;
#line 1344 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp36_ = self->priv->game;
#line 1344 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp37_ = _tmp36_->result;
#line 1344 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			if (_tmp37_ == CHESS_RESULT_WHITE_WON) {
#line 7331 "gnome-chess.c"
				gchar* _tmp38_;
#line 1346 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp38_ = g_strdup (_ ("Black has resigned."));
#line 1346 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_g_free0 (reason);
#line 1346 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				reason = _tmp38_;
#line 7339 "gnome-chess.c"
			} else {
				ChessGame* _tmp39_;
				ChessResult _tmp40_;
#line 1347 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp39_ = self->priv->game;
#line 1347 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp40_ = _tmp39_->result;
#line 1347 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				if (_tmp40_ == CHESS_RESULT_BLACK_WON) {
#line 7349 "gnome-chess.c"
					gchar* _tmp41_;
#line 1349 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					_tmp41_ = g_strdup (_ ("White has resigned."));
#line 1349 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					_g_free0 (reason);
#line 1349 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					reason = _tmp41_;
#line 7357 "gnome-chess.c"
				} else {
#line 1351 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					g_assert_not_reached ();
#line 7361 "gnome-chess.c"
				}
			}
#line 1352 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			break;
#line 7366 "gnome-chess.c"
		}
#line 1297 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		case CHESS_RULE_ABANDONMENT:
#line 7370 "gnome-chess.c"
		{
			gchar* _tmp42_;
			PGNGame* _tmp43_;
			const gchar* _tmp44_;
#line 1355 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp42_ = g_strdup (_ ("The game has been abandoned."));
#line 1355 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_g_free0 (reason);
#line 1355 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			reason = _tmp42_;
#line 1356 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp43_ = self->priv->pgn_game;
#line 1356 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp44_ = pgn_game_TERMINATE_ABANDONED;
#line 1356 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			pgn_game_set_termination (_tmp43_, _tmp44_);
#line 1357 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			break;
#line 7389 "gnome-chess.c"
		}
#line 1297 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		case CHESS_RULE_DEATH:
#line 7393 "gnome-chess.c"
		{
			gchar* _tmp45_;
			PGNGame* _tmp46_;
			const gchar* _tmp47_;
#line 1361 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp45_ = g_strdup (_ ("The game log says a player died!"));
#line 1361 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_g_free0 (reason);
#line 1361 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			reason = _tmp45_;
#line 1362 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp46_ = self->priv->pgn_game;
#line 1362 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp47_ = pgn_game_TERMINATE_DEATH;
#line 1362 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			pgn_game_set_termination (_tmp46_, _tmp47_);
#line 1363 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			break;
#line 7412 "gnome-chess.c"
		}
#line 1297 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		case CHESS_RULE_BUG:
#line 7416 "gnome-chess.c"
		{
			gchar* _tmp48_;
#line 1367 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp48_ = g_strdup (_ ("The computer player is confused. The game cannot continue."));
#line 1367 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_g_free0 (reason);
#line 1367 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			reason = _tmp48_;
#line 1369 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			break;
#line 7427 "gnome-chess.c"
		}
#line 1297 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		case CHESS_RULE_UNKNOWN:
#line 7431 "gnome-chess.c"
		{
			GFile* _tmp49_;
			gchar* _tmp50_;
#line 1374 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp49_ = self->priv->game_file;
#line 1374 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp50_ = g_file_get_basename (_tmp49_);
#line 1374 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_g_free0 (reason);
#line 1374 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			reason = _tmp50_;
#line 1375 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			break;
#line 7445 "gnome-chess.c"
		}
		default:
#line 1297 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		break;
#line 7450 "gnome-chess.c"
	}
#line 1378 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp51_ = self->priv->headerbar;
#line 1378 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp52_ = title;
#line 1378 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_header_bar_set_title (_tmp51_, _tmp52_);
#line 1379 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp53_ = self->priv->headerbar;
#line 1379 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp54_ = reason;
#line 1379 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_header_bar_set_subtitle (_tmp53_, _tmp54_);
#line 1381 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp55_ = self->priv->white_time_label;
#line 1381 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_widget_queue_draw (_tmp55_);
#line 1382 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp56_ = self->priv->black_time_label;
#line 1382 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_widget_queue_draw (_tmp56_);
#line 1248 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_free0 (reason);
#line 1248 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_free0 (title);
#line 7476 "gnome-chess.c"
}


gboolean gnome_chess_app_delete_event_cb (GtkWidget* widget, GdkEvent* event, ChessApplication* self) {
	gboolean result = FALSE;
#line 1386 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1386 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (widget != NULL, FALSE);
#line 1386 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 1388 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	chess_application_quit_game (self);
#line 1389 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	result = FALSE;
#line 1389 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	return result;
#line 7494 "gnome-chess.c"
}


static gboolean chess_application_prompt_save_game (ChessApplication* self, const gchar* prompt_text) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	GtkMessageDialog* dialog;
	GtkApplicationWindow* _tmp1_;
	const gchar* _tmp2_;
	GtkMessageDialog* _tmp3_;
	GtkMessageDialog* _tmp4_;
	ChessGame* _tmp5_;
	ChessResult _tmp6_;
	gint _result_;
	GtkMessageDialog* _tmp11_;
	gint _tmp12_;
	GtkMessageDialog* _tmp13_;
	gboolean _tmp14_ = FALSE;
	gint _tmp15_;
#line 1392 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1392 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (prompt_text != NULL, FALSE);
#line 1394 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->game_needs_saving;
#line 1394 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (!_tmp0_) {
#line 1395 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		result = TRUE;
#line 1395 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		return result;
#line 7526 "gnome-chess.c"
	}
#line 1397 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = self->priv->window;
#line 1397 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = prompt_text;
#line 1397 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp1_, GTK_DIALOG_MODAL, GTK_MESSAGE_QUESTION, GTK_BUTTONS_NONE, "%s", _tmp2_);
#line 1397 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_object_ref_sink (_tmp3_);
#line 1397 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	dialog = _tmp3_;
#line 1402 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = dialog;
#line 1402 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_dialog_add_button ((GtkDialog*) _tmp4_, _ ("_Cancel"), (gint) GTK_RESPONSE_CANCEL);
#line 1404 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = self->priv->game;
#line 1404 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = _tmp5_->result;
#line 1404 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp6_ == CHESS_RESULT_IN_PROGRESS) {
#line 7548 "gnome-chess.c"
		GtkMessageDialog* _tmp7_;
		GtkMessageDialog* _tmp8_;
#line 1406 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp7_ = dialog;
#line 1406 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		gtk_dialog_add_button ((GtkDialog*) _tmp7_, _ ("_Abandon game"), (gint) GTK_RESPONSE_NO);
#line 1407 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp8_ = dialog;
#line 1407 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		gtk_dialog_add_button ((GtkDialog*) _tmp8_, _ ("_Save game for later"), (gint) GTK_RESPONSE_YES);
#line 7559 "gnome-chess.c"
	} else {
		GtkMessageDialog* _tmp9_;
		GtkMessageDialog* _tmp10_;
#line 1411 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp9_ = dialog;
#line 1411 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		gtk_dialog_add_button ((GtkDialog*) _tmp9_, _ ("_Discard game"), (gint) GTK_RESPONSE_NO);
#line 1412 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp10_ = dialog;
#line 1412 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		gtk_dialog_add_button ((GtkDialog*) _tmp10_, _ ("_Save game log"), (gint) GTK_RESPONSE_YES);
#line 7571 "gnome-chess.c"
	}
#line 1415 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp11_ = dialog;
#line 1415 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp12_ = gtk_dialog_run ((GtkDialog*) _tmp11_);
#line 1415 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_result_ = _tmp12_;
#line 1416 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp13_ = dialog;
#line 1416 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp13_);
#line 1418 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp15_ = _result_;
#line 1418 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp15_ == ((gint) GTK_RESPONSE_CANCEL)) {
#line 1418 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp14_ = TRUE;
#line 7589 "gnome-chess.c"
	} else {
		gint _tmp16_;
#line 1418 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp16_ = _result_;
#line 1418 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp14_ = _tmp16_ == ((gint) GTK_RESPONSE_DELETE_EVENT);
#line 7596 "gnome-chess.c"
	}
#line 1418 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp14_) {
#line 1420 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		result = FALSE;
#line 1420 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (dialog);
#line 1420 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		return result;
#line 7606 "gnome-chess.c"
	} else {
		gint _tmp17_;
#line 1422 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp17_ = _result_;
#line 1422 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		if (_tmp17_ == ((gint) GTK_RESPONSE_YES)) {
#line 1425 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			chess_application_present_save_dialog (self, _ ("_Discard"), _ ("_Save"));
#line 7615 "gnome-chess.c"
		} else {
			gint _tmp18_;
#line 1429 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp18_ = _result_;
#line 1429 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			g_warn_if_fail (_tmp18_ == ((gint) GTK_RESPONSE_NO));
#line 1431 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			self->priv->game_needs_saving = FALSE;
#line 1432 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			chess_application_autosave (self);
#line 7626 "gnome-chess.c"
		}
	}
#line 1435 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	result = TRUE;
#line 1435 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (dialog);
#line 1435 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	return result;
#line 7635 "gnome-chess.c"
}


static void chess_application_present_claim_draw_dialog (ChessApplication* self) {
	ChessGame* _tmp0_;
	gboolean _tmp1_;
	ChessGame* _tmp2_;
	GtkMessageDialog* dialog;
	GtkApplicationWindow* _tmp3_;
	GtkMessageDialog* _tmp4_;
	gchar* reason = NULL;
	ChessGame* _tmp5_;
	gboolean _tmp6_;
	GtkMessageDialog* _tmp11_;
	const gchar* _tmp12_;
	GtkMessageDialog* _tmp13_;
	gint response;
	GtkMessageDialog* _tmp14_;
	gint _tmp15_;
	GtkMessageDialog* _tmp16_;
	gint _tmp17_;
#line 1438 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1438 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->game;
#line 1438 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = chess_game_can_claim_draw (_tmp0_);
#line 1438 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_vala_return_if_fail (_tmp1_, "game.can_claim_draw ()");
#line 1441 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = self->priv->game;
#line 1441 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	chess_game_pause (_tmp2_, FALSE);
#line 1443 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = self->priv->window;
#line 1443 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp3_, GTK_DIALOG_MODAL, GTK_MESSAGE_QUESTION, GTK_BUTTONS_NONE, "%s", _ ("Would you like to claim a draw?"));
#line 1443 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_object_ref_sink (_tmp4_);
#line 1443 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	dialog = _tmp4_;
#line 1451 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = self->priv->game;
#line 1451 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = chess_game_is_fifty_move_rule_fulfilled (_tmp5_);
#line 1451 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp6_) {
#line 7683 "gnome-chess.c"
		gchar* _tmp7_;
#line 1454 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp7_ = g_strdup (_ ("Fifty moves have passed without a capture or pawn advancement."));
#line 1454 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_g_free0 (reason);
#line 1454 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		reason = _tmp7_;
#line 7691 "gnome-chess.c"
	} else {
		ChessGame* _tmp8_;
		gboolean _tmp9_;
#line 1456 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp8_ = self->priv->game;
#line 1456 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp9_ = chess_game_is_three_fold_repeat (_tmp8_);
#line 1456 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		if (_tmp9_) {
#line 7701 "gnome-chess.c"
			gchar* _tmp10_;
#line 1459 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp10_ = g_strdup (_ ("The current board position has occurred three times."));
#line 1459 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_g_free0 (reason);
#line 1459 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			reason = _tmp10_;
#line 7709 "gnome-chess.c"
		} else {
#line 1461 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			g_assert_not_reached ();
#line 7713 "gnome-chess.c"
		}
	}
#line 1463 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp11_ = dialog;
#line 1463 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp12_ = reason;
#line 1463 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_object_set (_tmp11_, "secondary-text", _tmp12_, NULL);
#line 1465 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp13_ = dialog;
#line 1465 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_dialog_add_buttons ((GtkDialog*) _tmp13_, _ ("_Keep Playing"), GTK_RESPONSE_REJECT, _ ("_Claim Draw"), GTK_RESPONSE_ACCEPT, NULL, NULL);
#line 1471 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp14_ = dialog;
#line 1471 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp15_ = gtk_dialog_run ((GtkDialog*) _tmp14_);
#line 1471 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	response = _tmp15_;
#line 1472 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp16_ = dialog;
#line 1472 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp16_);
#line 1474 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp17_ = response;
#line 1474 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp17_ == ((gint) GTK_RESPONSE_ACCEPT)) {
#line 7740 "gnome-chess.c"
		ChessGame* _tmp18_;
		ChessPlayer* _tmp19_;
		ChessPlayer* _tmp20_;
#line 1476 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp18_ = self->priv->game;
#line 1476 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp19_ = chess_game_get_current_player (_tmp18_);
#line 1476 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp20_ = _tmp19_;
#line 1476 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		chess_player_claim_draw (_tmp20_);
#line 7752 "gnome-chess.c"
	} else {
		ChessGame* _tmp21_;
#line 1480 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp21_ = self->priv->game;
#line 1480 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		chess_game_unpause (_tmp21_);
#line 7759 "gnome-chess.c"
	}
#line 1438 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_free0 (reason);
#line 1438 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (dialog);
#line 7765 "gnome-chess.c"
}


void chess_application_new_game_cb (ChessApplication* self) {
	gboolean _tmp0_;
#line 1484 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1486 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = chess_application_prompt_save_game (self, _ ("Save this game before starting a new one?"));
#line 1486 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp0_) {
#line 1487 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		chess_application_start_new_game (self);
#line 7779 "gnome-chess.c"
	}
}


void chess_application_resign_cb (ChessApplication* self) {
	ChessGame* _tmp0_;
	GtkMessageDialog* dialog;
	GtkApplicationWindow* _tmp1_;
	GtkMessageDialog* _tmp2_;
	GtkMessageDialog* _tmp3_;
	GtkMessageDialog* _tmp4_;
	gint response;
	GtkMessageDialog* _tmp5_;
	gint _tmp6_;
	GtkMessageDialog* _tmp7_;
	gint _tmp8_;
#line 1490 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1492 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->game;
#line 1492 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	chess_game_pause (_tmp0_, FALSE);
#line 1494 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = self->priv->window;
#line 1494 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp1_, GTK_DIALOG_MODAL, GTK_MESSAGE_QUESTION, GTK_BUTTONS_NONE, "%s", _ ("Are you sure you want to resign?"));
#line 1494 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_object_ref_sink (_tmp2_);
#line 1494 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	dialog = _tmp2_;
#line 1500 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = dialog;
#line 1500 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_message_dialog_format_secondary_text (_tmp3_, "%s", _ ("This makes sense if you plan to save the game as a record of your loss" \
"."));
#line 1503 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = dialog;
#line 1503 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_dialog_add_buttons ((GtkDialog*) _tmp4_, _ ("_Keep Playing"), GTK_RESPONSE_REJECT, _ ("_Resign"), GTK_RESPONSE_ACCEPT, NULL, NULL);
#line 1509 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = dialog;
#line 1509 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = gtk_dialog_run ((GtkDialog*) _tmp5_);
#line 1509 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	response = _tmp6_;
#line 1510 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = dialog;
#line 1510 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp7_);
#line 1512 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp8_ = response;
#line 1512 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp8_ == ((gint) GTK_RESPONSE_ACCEPT)) {
#line 7832 "gnome-chess.c"
		ChessPlayer* _tmp9_;
#line 1514 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp9_ = self->priv->human_player;
#line 1514 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		if (_tmp9_ != NULL) {
#line 7838 "gnome-chess.c"
			ChessPlayer* _tmp10_;
#line 1515 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp10_ = self->priv->human_player;
#line 1515 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			chess_player_resign (_tmp10_);
#line 7844 "gnome-chess.c"
		} else {
			ChessGame* _tmp11_;
			ChessPlayer* _tmp12_;
			ChessPlayer* _tmp13_;
#line 1517 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp11_ = self->priv->game;
#line 1517 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp12_ = chess_game_get_current_player (_tmp11_);
#line 1517 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp13_ = _tmp12_;
#line 1517 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			chess_player_resign (_tmp13_);
#line 7857 "gnome-chess.c"
		}
	} else {
		ChessGame* _tmp14_;
#line 1521 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp14_ = self->priv->game;
#line 1521 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		chess_game_unpause (_tmp14_);
#line 7865 "gnome-chess.c"
	}
#line 1490 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (dialog);
#line 7869 "gnome-chess.c"
}


void chess_application_undo_move_cb (ChessApplication* self) {
	ChessScene* _tmp0_;
	ChessScene* _tmp1_;
	ChessPlayer* _tmp2_;
#line 1525 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1528 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->scene;
#line 1528 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp0_->selected_rank = -1;
#line 1529 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = self->priv->scene;
#line 1529 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp1_->selected_file = -1;
#line 1531 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = self->priv->opponent;
#line 1531 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp2_ != NULL) {
#line 7891 "gnome-chess.c"
		ChessPlayer* _tmp3_;
#line 1532 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp3_ = self->priv->human_player;
#line 1532 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		chess_player_undo (_tmp3_);
#line 7897 "gnome-chess.c"
	} else {
		ChessGame* _tmp4_;
		ChessPlayer* _tmp5_;
		ChessPlayer* _tmp6_;
#line 1534 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp4_ = self->priv->game;
#line 1534 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp5_ = chess_game_get_opponent (_tmp4_);
#line 1534 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp6_ = _tmp5_;
#line 1534 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		chess_player_undo (_tmp6_);
#line 7910 "gnome-chess.c"
	}
}


void chess_application_pause_resume_cb (ChessApplication* self) {
	ChessGame* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
#line 1537 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1539 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->game;
#line 1539 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = chess_game_get_is_paused (_tmp0_);
#line 1539 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = _tmp1_;
#line 1539 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp2_) {
#line 7929 "gnome-chess.c"
		ChessGame* _tmp3_;
#line 1540 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp3_ = self->priv->game;
#line 1540 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		chess_game_unpause (_tmp3_);
#line 7935 "gnome-chess.c"
	} else {
		ChessGame* _tmp4_;
#line 1542 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp4_ = self->priv->game;
#line 1542 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		chess_game_pause (_tmp4_, TRUE);
#line 7942 "gnome-chess.c"
	}
#line 1544 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	chess_application_update_pause_resume_button (self);
#line 1545 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	chess_application_update_history_panel (self);
#line 1546 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	chess_application_update_action_status (self);
#line 7950 "gnome-chess.c"
}


void chess_application_quit_cb (ChessApplication* self) {
#line 1549 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1551 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	chess_application_quit_game (self);
#line 7959 "gnome-chess.c"
}


gboolean white_time_draw_cb (GtkWidget* widget, cairo_t* c, ChessApplication* self) {
	gboolean result = FALSE;
	gdouble fg[3];
	gdouble _tmp0_[3];
	gdouble bg[3];
	gdouble _tmp1_[3];
	GtkWidget* _tmp2_;
	cairo_t* _tmp3_;
	ChessGame* _tmp4_;
	ChessClock* _tmp5_;
	ChessClock* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
#line 1555 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1555 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (widget != NULL, FALSE);
#line 1555 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (c != NULL, FALSE);
#line 1557 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp0_[0] = 0.0;
#line 1557 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp0_[1] = 0.0;
#line 1557 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp0_[2] = 0.0;
#line 1557 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	memcpy (fg, _tmp0_, 3 * sizeof (gdouble));
#line 1558 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp1_[0] = 1.0;
#line 1558 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp1_[1] = 1.0;
#line 1558 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp1_[2] = 1.0;
#line 1558 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	memcpy (bg, _tmp1_, 3 * sizeof (gdouble));
#line 1560 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = widget;
#line 1560 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = c;
#line 1560 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = self->priv->game;
#line 1560 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = chess_game_get_clock (_tmp4_);
#line 1560 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = _tmp5_;
#line 1560 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = chess_application_make_clock_text (self, _tmp6_, COLOR_WHITE);
#line 1560 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp8_ = _tmp7_;
#line 1560 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	chess_application_draw_time (self, _tmp2_, _tmp3_, _tmp8_, fg, 3, bg, 3);
#line 1560 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_free0 (_tmp8_);
#line 1561 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	result = FALSE;
#line 1561 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	return result;
#line 8020 "gnome-chess.c"
}


gboolean black_time_draw_cb (GtkWidget* widget, cairo_t* c, ChessApplication* self) {
	gboolean result = FALSE;
	gdouble fg[3];
	gdouble _tmp0_[3];
	gdouble bg[3];
	gdouble _tmp1_[3];
	GtkWidget* _tmp2_;
	cairo_t* _tmp3_;
	ChessGame* _tmp4_;
	ChessClock* _tmp5_;
	ChessClock* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
#line 1565 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1565 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (widget != NULL, FALSE);
#line 1565 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (c != NULL, FALSE);
#line 1567 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp0_[0] = 1.0;
#line 1567 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp0_[1] = 1.0;
#line 1567 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp0_[2] = 1.0;
#line 1567 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	memcpy (fg, _tmp0_, 3 * sizeof (gdouble));
#line 1568 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp1_[0] = 0.0;
#line 1568 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp1_[1] = 0.0;
#line 1568 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp1_[2] = 0.0;
#line 1568 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	memcpy (bg, _tmp1_, 3 * sizeof (gdouble));
#line 1570 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = widget;
#line 1570 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = c;
#line 1570 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = self->priv->game;
#line 1570 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = chess_game_get_clock (_tmp4_);
#line 1570 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = _tmp5_;
#line 1570 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = chess_application_make_clock_text (self, _tmp6_, COLOR_BLACK);
#line 1570 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp8_ = _tmp7_;
#line 1570 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	chess_application_draw_time (self, _tmp2_, _tmp3_, _tmp8_, fg, 3, bg, 3);
#line 1570 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_free0 (_tmp8_);
#line 1571 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	result = FALSE;
#line 1571 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	return result;
#line 8081 "gnome-chess.c"
}


static gchar* chess_application_make_clock_text (ChessApplication* self, ChessClock* clock, Color color) {
	gchar* result = NULL;
	ChessClock* _tmp0_;
	gint time = 0;
	Color _tmp2_;
	gint _tmp33_;
#line 1574 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1576 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = clock;
#line 1576 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp0_ == NULL) {
#line 8097 "gnome-chess.c"
		gchar* _tmp1_;
#line 1577 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp1_ = g_strdup ("∞");
#line 1577 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		result = _tmp1_;
#line 1577 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		return result;
#line 8105 "gnome-chess.c"
	}
#line 1580 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = color;
#line 1580 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp2_ == COLOR_WHITE) {
#line 8111 "gnome-chess.c"
		ChessGame* _tmp3_;
		ChessClock* _tmp4_;
		ChessClock* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		ChessGame* _tmp8_;
		ChessClock* _tmp9_;
		ChessClock* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		ChessGame* _tmp13_;
		ChessClock* _tmp14_;
		ChessClock* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
#line 1581 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp3_ = self->priv->game;
#line 1581 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp4_ = chess_game_get_clock (_tmp3_);
#line 1581 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp5_ = _tmp4_;
#line 1581 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp6_ = chess_clock_get_white_initial_seconds (_tmp5_);
#line 1581 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp7_ = _tmp6_;
#line 1581 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp8_ = self->priv->game;
#line 1581 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp9_ = chess_game_get_clock (_tmp8_);
#line 1581 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp10_ = _tmp9_;
#line 1581 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp11_ = chess_clock_get_white_seconds_used (_tmp10_);
#line 1581 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp12_ = _tmp11_;
#line 1581 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp13_ = self->priv->game;
#line 1581 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp14_ = chess_game_get_clock (_tmp13_);
#line 1581 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp15_ = _tmp14_;
#line 1581 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp16_ = chess_clock_get_white_extra_seconds (_tmp15_);
#line 1581 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp17_ = _tmp16_;
#line 1581 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		time = (_tmp7_ - _tmp12_) + _tmp17_;
#line 8159 "gnome-chess.c"
	} else {
		ChessGame* _tmp18_;
		ChessClock* _tmp19_;
		ChessClock* _tmp20_;
		gint _tmp21_;
		gint _tmp22_;
		ChessGame* _tmp23_;
		ChessClock* _tmp24_;
		ChessClock* _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		ChessGame* _tmp28_;
		ChessClock* _tmp29_;
		ChessClock* _tmp30_;
		gint _tmp31_;
		gint _tmp32_;
#line 1583 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp18_ = self->priv->game;
#line 1583 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp19_ = chess_game_get_clock (_tmp18_);
#line 1583 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp20_ = _tmp19_;
#line 1583 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp21_ = chess_clock_get_black_initial_seconds (_tmp20_);
#line 1583 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp22_ = _tmp21_;
#line 1583 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp23_ = self->priv->game;
#line 1583 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp24_ = chess_game_get_clock (_tmp23_);
#line 1583 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp25_ = _tmp24_;
#line 1583 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp26_ = chess_clock_get_black_seconds_used (_tmp25_);
#line 1583 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp27_ = _tmp26_;
#line 1583 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp28_ = self->priv->game;
#line 1583 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp29_ = chess_game_get_clock (_tmp28_);
#line 1583 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp30_ = _tmp29_;
#line 1583 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp31_ = chess_clock_get_black_extra_seconds (_tmp30_);
#line 1583 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp32_ = _tmp31_;
#line 1583 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		time = (_tmp22_ - _tmp27_) + _tmp32_;
#line 8208 "gnome-chess.c"
	}
#line 1585 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp33_ = time;
#line 1585 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp33_ >= 60) {
#line 8214 "gnome-chess.c"
		gint _tmp34_;
		gint _tmp35_;
		gchar* _tmp36_;
#line 1586 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp34_ = time;
#line 1586 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp35_ = time;
#line 1586 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp36_ = g_strdup_printf ("%d∶\xE2\x80\x8E%02d", _tmp34_ / 60, _tmp35_ % 60);
#line 1586 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		result = _tmp36_;
#line 1586 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		return result;
#line 8228 "gnome-chess.c"
	} else {
		gint _tmp37_;
		gchar* _tmp38_;
#line 1588 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp37_ = time;
#line 1588 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp38_ = g_strdup_printf ("∶\xE2\x80\x8E%02d", _tmp37_);
#line 1588 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		result = _tmp38_;
#line 1588 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		return result;
#line 8240 "gnome-chess.c"
	}
}


static gint chess_application_compute_time_label_width_request (ChessApplication* self, cairo_t* c) {
	gint result = 0;
	cairo_text_extents_t extents = {0};
	gdouble max;
	cairo_t* _tmp0_;
	cairo_text_extents_t _tmp1_ = {0};
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_;
	cairo_text_extents_t _tmp4_;
	gdouble _tmp5_;
	cairo_t* _tmp9_;
	cairo_text_extents_t _tmp10_ = {0};
	gdouble _tmp11_ = 0.0;
	gdouble _tmp12_;
	cairo_text_extents_t _tmp13_;
	gdouble _tmp14_;
	cairo_t* _tmp18_;
	cairo_text_extents_t _tmp19_ = {0};
	gdouble _tmp20_ = 0.0;
	gdouble _tmp21_;
	cairo_text_extents_t _tmp22_;
	gdouble _tmp23_;
	cairo_t* _tmp27_;
	cairo_text_extents_t _tmp28_ = {0};
	gdouble _tmp29_ = 0.0;
	gdouble _tmp30_;
	cairo_text_extents_t _tmp31_;
	gdouble _tmp32_;
	cairo_t* _tmp36_;
	cairo_text_extents_t _tmp37_ = {0};
	gdouble _tmp38_ = 0.0;
	gdouble _tmp39_;
	cairo_text_extents_t _tmp40_;
	gdouble _tmp41_;
	cairo_t* _tmp45_;
	cairo_text_extents_t _tmp46_ = {0};
	gdouble _tmp47_ = 0.0;
	gdouble _tmp48_;
	cairo_text_extents_t _tmp49_;
	gdouble _tmp50_;
	cairo_t* _tmp54_;
	cairo_text_extents_t _tmp55_ = {0};
	gdouble _tmp56_ = 0.0;
	gdouble _tmp57_;
	cairo_text_extents_t _tmp58_;
	gdouble _tmp59_;
	cairo_t* _tmp63_;
	cairo_text_extents_t _tmp64_ = {0};
	gdouble _tmp65_ = 0.0;
	gdouble _tmp66_;
	cairo_text_extents_t _tmp67_;
	gdouble _tmp68_;
	cairo_t* _tmp72_;
	cairo_text_extents_t _tmp73_ = {0};
	gdouble _tmp74_ = 0.0;
	gdouble _tmp75_;
	cairo_text_extents_t _tmp76_;
	gdouble _tmp77_;
	cairo_t* _tmp81_;
	cairo_text_extents_t _tmp82_ = {0};
	gdouble _tmp83_ = 0.0;
	gdouble _tmp84_;
	cairo_text_extents_t _tmp85_;
	gdouble _tmp86_;
	gdouble _tmp90_;
	gdouble _tmp91_;
	gint _tmp92_;
	gint _tmp93_;
#line 1596 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1596 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (c != NULL, 0);
#line 1600 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	max = (gdouble) 0;
#line 1602 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = c;
#line 1602 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	cairo_text_extents (_tmp0_, "000∶00", &_tmp1_);
#line 1602 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	extents = _tmp1_;
#line 1603 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = max;
#line 1603 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = extents;
#line 1603 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = _tmp4_.width;
#line 1603 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp3_ > _tmp5_) {
#line 8333 "gnome-chess.c"
		gdouble _tmp6_;
#line 1603 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp6_ = max;
#line 1603 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp2_ = _tmp6_;
#line 8339 "gnome-chess.c"
	} else {
		cairo_text_extents_t _tmp7_;
		gdouble _tmp8_;
#line 1603 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp7_ = extents;
#line 1603 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp8_ = _tmp7_.width;
#line 1603 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp2_ = _tmp8_;
#line 8349 "gnome-chess.c"
	}
#line 1603 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	max = _tmp2_;
#line 1604 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp9_ = c;
#line 1604 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	cairo_text_extents (_tmp9_, "111∶11", &_tmp10_);
#line 1604 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	extents = _tmp10_;
#line 1605 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp12_ = max;
#line 1605 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp13_ = extents;
#line 1605 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp14_ = _tmp13_.width;
#line 1605 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp12_ > _tmp14_) {
#line 8367 "gnome-chess.c"
		gdouble _tmp15_;
#line 1605 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp15_ = max;
#line 1605 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp11_ = _tmp15_;
#line 8373 "gnome-chess.c"
	} else {
		cairo_text_extents_t _tmp16_;
		gdouble _tmp17_;
#line 1605 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp16_ = extents;
#line 1605 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp17_ = _tmp16_.width;
#line 1605 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp11_ = _tmp17_;
#line 8383 "gnome-chess.c"
	}
#line 1605 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	max = _tmp11_;
#line 1606 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp18_ = c;
#line 1606 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	cairo_text_extents (_tmp18_, "222∶22", &_tmp19_);
#line 1606 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	extents = _tmp19_;
#line 1607 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp21_ = max;
#line 1607 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp22_ = extents;
#line 1607 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp23_ = _tmp22_.width;
#line 1607 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp21_ > _tmp23_) {
#line 8401 "gnome-chess.c"
		gdouble _tmp24_;
#line 1607 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp24_ = max;
#line 1607 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp20_ = _tmp24_;
#line 8407 "gnome-chess.c"
	} else {
		cairo_text_extents_t _tmp25_;
		gdouble _tmp26_;
#line 1607 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp25_ = extents;
#line 1607 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp26_ = _tmp25_.width;
#line 1607 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp20_ = _tmp26_;
#line 8417 "gnome-chess.c"
	}
#line 1607 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	max = _tmp20_;
#line 1608 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp27_ = c;
#line 1608 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	cairo_text_extents (_tmp27_, "333∶33", &_tmp28_);
#line 1608 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	extents = _tmp28_;
#line 1609 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp30_ = max;
#line 1609 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp31_ = extents;
#line 1609 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp32_ = _tmp31_.width;
#line 1609 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp30_ > _tmp32_) {
#line 8435 "gnome-chess.c"
		gdouble _tmp33_;
#line 1609 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp33_ = max;
#line 1609 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp29_ = _tmp33_;
#line 8441 "gnome-chess.c"
	} else {
		cairo_text_extents_t _tmp34_;
		gdouble _tmp35_;
#line 1609 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp34_ = extents;
#line 1609 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp35_ = _tmp34_.width;
#line 1609 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp29_ = _tmp35_;
#line 8451 "gnome-chess.c"
	}
#line 1609 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	max = _tmp29_;
#line 1610 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp36_ = c;
#line 1610 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	cairo_text_extents (_tmp36_, "444∶44", &_tmp37_);
#line 1610 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	extents = _tmp37_;
#line 1611 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp39_ = max;
#line 1611 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp40_ = extents;
#line 1611 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp41_ = _tmp40_.width;
#line 1611 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp39_ > _tmp41_) {
#line 8469 "gnome-chess.c"
		gdouble _tmp42_;
#line 1611 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp42_ = max;
#line 1611 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp38_ = _tmp42_;
#line 8475 "gnome-chess.c"
	} else {
		cairo_text_extents_t _tmp43_;
		gdouble _tmp44_;
#line 1611 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp43_ = extents;
#line 1611 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp44_ = _tmp43_.width;
#line 1611 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp38_ = _tmp44_;
#line 8485 "gnome-chess.c"
	}
#line 1611 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	max = _tmp38_;
#line 1612 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp45_ = c;
#line 1612 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	cairo_text_extents (_tmp45_, "555∶55", &_tmp46_);
#line 1612 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	extents = _tmp46_;
#line 1613 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp48_ = max;
#line 1613 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp49_ = extents;
#line 1613 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp50_ = _tmp49_.width;
#line 1613 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp48_ > _tmp50_) {
#line 8503 "gnome-chess.c"
		gdouble _tmp51_;
#line 1613 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp51_ = max;
#line 1613 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp47_ = _tmp51_;
#line 8509 "gnome-chess.c"
	} else {
		cairo_text_extents_t _tmp52_;
		gdouble _tmp53_;
#line 1613 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp52_ = extents;
#line 1613 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp53_ = _tmp52_.width;
#line 1613 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp47_ = _tmp53_;
#line 8519 "gnome-chess.c"
	}
#line 1613 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	max = _tmp47_;
#line 1614 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp54_ = c;
#line 1614 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	cairo_text_extents (_tmp54_, "666∶66", &_tmp55_);
#line 1614 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	extents = _tmp55_;
#line 1615 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp57_ = max;
#line 1615 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp58_ = extents;
#line 1615 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp59_ = _tmp58_.width;
#line 1615 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp57_ > _tmp59_) {
#line 8537 "gnome-chess.c"
		gdouble _tmp60_;
#line 1615 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp60_ = max;
#line 1615 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp56_ = _tmp60_;
#line 8543 "gnome-chess.c"
	} else {
		cairo_text_extents_t _tmp61_;
		gdouble _tmp62_;
#line 1615 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp61_ = extents;
#line 1615 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp62_ = _tmp61_.width;
#line 1615 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp56_ = _tmp62_;
#line 8553 "gnome-chess.c"
	}
#line 1615 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	max = _tmp56_;
#line 1616 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp63_ = c;
#line 1616 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	cairo_text_extents (_tmp63_, "777∶77", &_tmp64_);
#line 1616 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	extents = _tmp64_;
#line 1617 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp66_ = max;
#line 1617 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp67_ = extents;
#line 1617 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp68_ = _tmp67_.width;
#line 1617 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp66_ > _tmp68_) {
#line 8571 "gnome-chess.c"
		gdouble _tmp69_;
#line 1617 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp69_ = max;
#line 1617 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp65_ = _tmp69_;
#line 8577 "gnome-chess.c"
	} else {
		cairo_text_extents_t _tmp70_;
		gdouble _tmp71_;
#line 1617 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp70_ = extents;
#line 1617 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp71_ = _tmp70_.width;
#line 1617 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp65_ = _tmp71_;
#line 8587 "gnome-chess.c"
	}
#line 1617 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	max = _tmp65_;
#line 1618 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp72_ = c;
#line 1618 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	cairo_text_extents (_tmp72_, "888∶88", &_tmp73_);
#line 1618 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	extents = _tmp73_;
#line 1619 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp75_ = max;
#line 1619 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp76_ = extents;
#line 1619 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp77_ = _tmp76_.width;
#line 1619 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp75_ > _tmp77_) {
#line 8605 "gnome-chess.c"
		gdouble _tmp78_;
#line 1619 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp78_ = max;
#line 1619 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp74_ = _tmp78_;
#line 8611 "gnome-chess.c"
	} else {
		cairo_text_extents_t _tmp79_;
		gdouble _tmp80_;
#line 1619 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp79_ = extents;
#line 1619 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp80_ = _tmp79_.width;
#line 1619 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp74_ = _tmp80_;
#line 8621 "gnome-chess.c"
	}
#line 1619 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	max = _tmp74_;
#line 1620 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp81_ = c;
#line 1620 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	cairo_text_extents (_tmp81_, "999∶99", &_tmp82_);
#line 1620 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	extents = _tmp82_;
#line 1621 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp84_ = max;
#line 1621 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp85_ = extents;
#line 1621 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp86_ = _tmp85_.width;
#line 1621 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp84_ > _tmp86_) {
#line 8639 "gnome-chess.c"
		gdouble _tmp87_;
#line 1621 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp87_ = max;
#line 1621 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp83_ = _tmp87_;
#line 8645 "gnome-chess.c"
	} else {
		cairo_text_extents_t _tmp88_;
		gdouble _tmp89_;
#line 1621 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp88_ = extents;
#line 1621 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp89_ = _tmp88_.width;
#line 1621 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp83_ = _tmp89_;
#line 8655 "gnome-chess.c"
	}
#line 1621 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	max = _tmp83_;
#line 1624 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp90_ = max;
#line 1624 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp91_ = ceil (_tmp90_);
#line 1624 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	result = ((gint) _tmp91_) + 6;
#line 1624 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp92_ = result;
#line 1624 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_vala_warn_if_fail (_tmp92_ > 0, "result > 0");
#line 1624 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	return result;
#line 8671 "gnome-chess.c"
}


static void chess_application_draw_time (ChessApplication* self, GtkWidget* widget, cairo_t* c, const gchar* text, gdouble* fg, int fg_length1, gdouble* bg, int bg_length1) {
	gdouble alpha;
	GtkWidget* _tmp0_;
	GtkStateFlags _tmp1_;
	cairo_t* _tmp2_;
	gdouble* _tmp3_;
	gint _tmp3__length1;
	gdouble _tmp4_;
	gdouble* _tmp5_;
	gint _tmp5__length1;
	gdouble _tmp6_;
	gdouble* _tmp7_;
	gint _tmp7__length1;
	gdouble _tmp8_;
	gdouble _tmp9_;
	cairo_t* _tmp10_;
	cairo_t* _tmp11_;
	gdouble* _tmp12_;
	gint _tmp12__length1;
	gdouble _tmp13_;
	gdouble* _tmp14_;
	gint _tmp14__length1;
	gdouble _tmp15_;
	gdouble* _tmp16_;
	gint _tmp16__length1;
	gdouble _tmp17_;
	gdouble _tmp18_;
	cairo_t* _tmp19_;
	cairo_t* _tmp20_;
	GtkWidget* _tmp21_;
	gint _tmp22_;
	cairo_text_extents_t extents = {0};
	cairo_t* _tmp23_;
	const gchar* _tmp24_;
	cairo_text_extents_t _tmp25_ = {0};
	cairo_t* _tmp26_;
	GtkWidget* _tmp27_;
	gint _tmp28_;
	cairo_text_extents_t _tmp29_;
	gdouble _tmp30_;
	cairo_text_extents_t _tmp31_;
	gdouble _tmp32_;
	GtkWidget* _tmp33_;
	gint _tmp34_;
	cairo_text_extents_t _tmp35_;
	gdouble _tmp36_;
	cairo_text_extents_t _tmp37_;
	gdouble _tmp38_;
	cairo_t* _tmp39_;
	const gchar* _tmp40_;
	gint width = 0;
	GtkWidget* _tmp41_;
	gint _tmp42_ = 0;
	gint _tmp43_;
#line 1627 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1627 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (widget != NULL);
#line 1627 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (c != NULL);
#line 1627 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (text != NULL);
#line 1629 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	alpha = 1.0;
#line 1631 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = widget;
#line 1631 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = gtk_widget_get_state_flags (_tmp0_);
#line 1631 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if ((_tmp1_ & GTK_STATE_FLAG_INSENSITIVE) != 0) {
#line 1632 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		alpha = 0.5;
#line 8747 "gnome-chess.c"
	}
#line 1633 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = c;
#line 1633 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = bg;
#line 1633 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp3__length1 = bg_length1;
#line 1633 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = _tmp3_[0];
#line 1633 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = bg;
#line 1633 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp5__length1 = bg_length1;
#line 1633 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = _tmp5_[1];
#line 1633 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = bg;
#line 1633 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp7__length1 = bg_length1;
#line 1633 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp8_ = _tmp7_[2];
#line 1633 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp9_ = alpha;
#line 1633 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	cairo_set_source_rgba (_tmp2_, _tmp4_, _tmp6_, _tmp8_, _tmp9_);
#line 1634 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp10_ = c;
#line 1634 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	cairo_paint (_tmp10_);
#line 1636 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp11_ = c;
#line 1636 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp12_ = fg;
#line 1636 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp12__length1 = fg_length1;
#line 1636 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp13_ = _tmp12_[0];
#line 1636 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp14_ = fg;
#line 1636 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp14__length1 = fg_length1;
#line 1636 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp15_ = _tmp14_[1];
#line 1636 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp16_ = fg;
#line 1636 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp16__length1 = fg_length1;
#line 1636 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp17_ = _tmp16_[2];
#line 1636 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp18_ = alpha;
#line 1636 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	cairo_set_source_rgba (_tmp11_, _tmp13_, _tmp15_, _tmp17_, _tmp18_);
#line 1637 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp19_ = c;
#line 1637 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	cairo_select_font_face (_tmp19_, "fixed", CAIRO_FONT_SLANT_NORMAL, CAIRO_FONT_WEIGHT_BOLD);
#line 1638 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp20_ = c;
#line 1638 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp21_ = widget;
#line 1638 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp22_ = gtk_widget_get_allocated_height (_tmp21_);
#line 1638 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	cairo_set_font_size (_tmp20_, 0.6 * _tmp22_);
#line 1640 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp23_ = c;
#line 1640 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp24_ = text;
#line 1640 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	cairo_text_extents (_tmp23_, _tmp24_, &_tmp25_);
#line 1640 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	extents = _tmp25_;
#line 1641 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp26_ = c;
#line 1641 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp27_ = widget;
#line 1641 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp28_ = gtk_widget_get_allocated_width (_tmp27_);
#line 1641 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp29_ = extents;
#line 1641 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp30_ = _tmp29_.width;
#line 1641 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp31_ = extents;
#line 1641 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp32_ = _tmp31_.x_bearing;
#line 1641 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp33_ = widget;
#line 1641 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp34_ = gtk_widget_get_allocated_height (_tmp33_);
#line 1641 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp35_ = extents;
#line 1641 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp36_ = _tmp35_.height;
#line 1641 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp37_ = extents;
#line 1641 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp38_ = _tmp37_.y_bearing;
#line 1641 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	cairo_move_to (_tmp26_, ((_tmp28_ - _tmp30_) / 2) - _tmp32_, ((_tmp34_ - _tmp36_) / 2) - _tmp38_);
#line 1643 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp39_ = c;
#line 1643 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp40_ = text;
#line 1643 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	cairo_show_text (_tmp39_, _tmp40_);
#line 1646 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp41_ = widget;
#line 1646 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_widget_get_size_request (_tmp41_, &_tmp42_, NULL);
#line 1646 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	width = _tmp42_;
#line 1647 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp43_ = width;
#line 1647 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp43_ == -1) {
#line 8865 "gnome-chess.c"
		GtkWidget* _tmp44_;
		cairo_t* _tmp45_;
		gint _tmp46_;
#line 1648 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp44_ = widget;
#line 1648 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp45_ = c;
#line 1648 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp46_ = chess_application_compute_time_label_width_request (self, _tmp45_);
#line 1648 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		gtk_widget_set_size_request (_tmp44_, _tmp46_, -1);
#line 8877 "gnome-chess.c"
	}
}


void history_combo_changed_cb (GtkComboBox* combo, ChessApplication* self) {
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_;
	gint move_number = 0;
	GtkComboBox* _tmp3_;
	GtkTreeModel* _tmp4_;
	GtkTreeModel* _tmp5_;
	GtkTreeIter _tmp6_;
	gboolean _tmp7_ = FALSE;
	ChessGame* _tmp8_;
	ChessScene* _tmp13_;
	gint _tmp14_;
#line 1652 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1652 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (combo != NULL);
#line 1655 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = combo;
#line 1655 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
#line 1655 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	iter = _tmp1_;
#line 1655 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (!_tmp2_) {
#line 1656 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		return;
#line 8910 "gnome-chess.c"
	}
#line 1658 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = combo;
#line 1658 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = gtk_combo_box_get_model (_tmp3_);
#line 1658 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = _tmp4_;
#line 1658 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = iter;
#line 1658 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_tree_model_get (_tmp5_, &_tmp6_, 1, &move_number, -1, -1);
#line 1659 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp8_ = self->priv->game;
#line 1659 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp8_ == NULL) {
#line 1659 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp7_ = TRUE;
#line 8928 "gnome-chess.c"
	} else {
		gint _tmp9_;
		ChessGame* _tmp10_;
		guint _tmp11_;
		guint _tmp12_;
#line 1659 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp9_ = move_number;
#line 1659 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp10_ = self->priv->game;
#line 1659 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp11_ = chess_game_get_n_moves (_tmp10_);
#line 1659 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp12_ = _tmp11_;
#line 1659 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp7_ = ((guint) _tmp9_) == _tmp12_;
#line 8944 "gnome-chess.c"
	}
#line 1659 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp7_) {
#line 1660 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		move_number = -1;
#line 8950 "gnome-chess.c"
	}
#line 1661 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp13_ = self->priv->scene;
#line 1661 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp14_ = move_number;
#line 1661 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	chess_scene_set_move_number (_tmp13_, _tmp14_);
#line 8958 "gnome-chess.c"
}


void history_latest_clicked_cb (GtkWidget* widget, ChessApplication* self) {
	ChessScene* _tmp0_;
#line 1665 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1665 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (widget != NULL);
#line 1667 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->scene;
#line 1667 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	chess_scene_set_move_number (_tmp0_, -1);
#line 8972 "gnome-chess.c"
}


void history_next_clicked_cb (GtkWidget* widget, ChessApplication* self) {
	ChessScene* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint move_number;
	ChessScene* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	ChessGame* _tmp7_;
	guint _tmp8_;
	guint _tmp9_;
#line 1671 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1671 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (widget != NULL);
#line 1673 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->scene;
#line 1673 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = chess_scene_get_move_number (_tmp0_);
#line 1673 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = _tmp1_;
#line 1673 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp2_ == -1) {
#line 1674 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		return;
#line 9002 "gnome-chess.c"
	}
#line 1676 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = self->priv->scene;
#line 1676 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = chess_scene_get_move_number (_tmp3_);
#line 1676 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = _tmp4_;
#line 1676 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	move_number = _tmp5_ + 1;
#line 1677 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = move_number;
#line 1677 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = self->priv->game;
#line 1677 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp8_ = chess_game_get_n_moves (_tmp7_);
#line 1677 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp9_ = _tmp8_;
#line 1677 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (((guint) _tmp6_) >= _tmp9_) {
#line 9022 "gnome-chess.c"
		ChessScene* _tmp10_;
#line 1678 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp10_ = self->priv->scene;
#line 1678 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		chess_scene_set_move_number (_tmp10_, -1);
#line 9028 "gnome-chess.c"
	} else {
		ChessScene* _tmp11_;
		gint _tmp12_;
#line 1680 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp11_ = self->priv->scene;
#line 1680 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp12_ = move_number;
#line 1680 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		chess_scene_set_move_number (_tmp11_, _tmp12_);
#line 9038 "gnome-chess.c"
	}
}


void history_previous_clicked_cb (GtkWidget* widget, ChessApplication* self) {
	ChessScene* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	ChessScene* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
#line 1684 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1684 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (widget != NULL);
#line 1686 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->scene;
#line 1686 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = chess_scene_get_move_number (_tmp0_);
#line 1686 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = _tmp1_;
#line 1686 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp2_ == 0) {
#line 1687 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		return;
#line 9064 "gnome-chess.c"
	}
#line 1689 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = self->priv->scene;
#line 1689 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = chess_scene_get_move_number (_tmp3_);
#line 1689 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = _tmp4_;
#line 1689 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp5_ == -1) {
#line 9074 "gnome-chess.c"
		ChessScene* _tmp6_;
		ChessGame* _tmp7_;
		guint _tmp8_;
		guint _tmp9_;
#line 1690 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp6_ = self->priv->scene;
#line 1690 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp7_ = self->priv->game;
#line 1690 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp8_ = chess_game_get_n_moves (_tmp7_);
#line 1690 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp9_ = _tmp8_;
#line 1690 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		chess_scene_set_move_number (_tmp6_, ((gint) _tmp9_) - 1);
#line 9089 "gnome-chess.c"
	} else {
		ChessScene* _tmp10_;
		ChessScene* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
#line 1692 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp10_ = self->priv->scene;
#line 1692 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp11_ = self->priv->scene;
#line 1692 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp12_ = chess_scene_get_move_number (_tmp11_);
#line 1692 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp13_ = _tmp12_;
#line 1692 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		chess_scene_set_move_number (_tmp10_, _tmp13_ - 1);
#line 9105 "gnome-chess.c"
	}
}


void history_start_clicked_cb (GtkWidget* widget, ChessApplication* self) {
	ChessScene* _tmp0_;
#line 1696 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1696 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (widget != NULL);
#line 1698 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->scene;
#line 1698 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	chess_scene_set_move_number (_tmp0_, 0);
#line 9120 "gnome-chess.c"
}


void chess_application_preferences_cb (ChessApplication* self) {
	GtkDialog* _tmp0_;
	GtkBuilder* preferences_builder;
	GtkBuilder* _tmp2_;
	GtkBuilder* _tmp3_;
	GObject* _tmp4_;
	GtkDialog* _tmp5_;
	GtkDialog* _tmp6_;
	GtkApplicationWindow* _tmp7_;
	GSettings* _tmp8_;
	GtkBuilder* _tmp9_;
	GObject* _tmp10_;
	GSettings* _tmp11_;
	GtkBuilder* _tmp12_;
	GObject* _tmp13_;
	GtkBuilder* _tmp14_;
	GObject* _tmp15_;
	GtkComboBox* _tmp16_;
	GtkComboBox* _tmp17_;
	GSettings* _tmp18_;
	gint _tmp19_;
	GtkComboBox* ai_combo;
	GtkBuilder* _tmp20_;
	GObject* _tmp21_;
	GtkComboBox* _tmp22_;
	GtkListStore* ai_model;
	GtkComboBox* _tmp23_;
	GtkTreeModel* _tmp24_;
	GtkTreeModel* _tmp25_;
	GtkListStore* _tmp26_;
	gchar* opponent_name;
	GSettings* _tmp27_;
	gchar* _tmp28_;
	const gchar* _tmp29_;
	GList* _tmp31_;
	GtkComboBox* _tmp54_;
	gint _tmp55_;
	GtkBuilder* _tmp58_;
	GObject* _tmp59_;
	GtkComboBox* _tmp60_;
	GtkComboBox* _tmp61_;
	GSettings* _tmp62_;
	gchar* _tmp63_;
	gchar* _tmp64_;
	GtkBuilder* _tmp65_;
	GObject* _tmp66_;
	GtkComboBox* _tmp67_;
	GtkBuilder* _tmp68_;
	GObject* _tmp69_;
	GtkComboBox* _tmp70_;
	GtkBuilder* _tmp71_;
	GObject* _tmp72_;
	GtkAdjustment* _tmp73_;
	GtkBuilder* _tmp74_;
	GObject* _tmp75_;
	GtkAdjustment* _tmp76_;
	GtkBuilder* _tmp77_;
	GObject* _tmp78_;
	GtkBox* _tmp79_;
	GtkBuilder* _tmp80_;
	GObject* _tmp81_;
	GtkBox* _tmp82_;
	GtkBuilder* _tmp83_;
	GObject* _tmp84_;
	GtkComboBox* _tmp85_;
	GSettings* _tmp86_;
	gint _tmp87_;
	GtkBuilder* _tmp88_;
	GObject* _tmp89_;
	GtkWidget* _tmp90_;
	GtkBuilder* _tmp91_;
	GObject* _tmp92_;
	GtkComboBox* _tmp93_;
	PGNGame* _tmp94_;
	const gchar* _tmp95_;
	const gchar* _tmp96_;
	PGNGame* _tmp105_;
	const gchar* _tmp106_;
	const gchar* _tmp107_;
	GtkComboBox* orientation_combo;
	GtkBuilder* _tmp114_;
	GObject* _tmp115_;
	GtkComboBox* _tmp116_;
	GtkComboBox* _tmp117_;
	GSettings* _tmp118_;
	gchar* _tmp119_;
	gchar* _tmp120_;
	GtkComboBox* move_combo;
	GtkBuilder* _tmp121_;
	GObject* _tmp122_;
	GtkComboBox* _tmp123_;
	GtkComboBox* _tmp124_;
	GSettings* _tmp125_;
	gchar* _tmp126_;
	gchar* _tmp127_;
	GtkComboBox* theme_combo;
	GtkBuilder* _tmp128_;
	GObject* _tmp129_;
	GtkComboBox* _tmp130_;
	GtkComboBox* _tmp131_;
	GSettings* _tmp132_;
	gchar* _tmp133_;
	gchar* _tmp134_;
	GtkBuilder* _tmp135_;
	GtkComboBox* _tmp136_;
	gint _tmp137_;
	GtkDialog* _tmp140_;
#line 1701 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1703 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->preferences_dialog;
#line 1703 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp0_ != NULL) {
#line 9237 "gnome-chess.c"
		GtkDialog* _tmp1_;
#line 1705 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp1_ = self->priv->preferences_dialog;
#line 1705 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		gtk_dialog_run (_tmp1_);
#line 1706 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		return;
#line 9245 "gnome-chess.c"
	}
#line 1709 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = gtk_builder_new_from_resource ("/org/gnome/chess/ui/preferences.ui");
#line 1709 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	preferences_builder = _tmp2_;
#line 1711 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = preferences_builder;
#line 1711 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = gtk_builder_get_object (_tmp3_, "preferences");
#line 1711 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_dialog_get_type (), GtkDialog));
#line 1711 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->preferences_dialog);
#line 1711 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	self->priv->preferences_dialog = _tmp5_;
#line 1712 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = self->priv->preferences_dialog;
#line 1712 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = self->priv->window;
#line 1712 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_window_set_transient_for ((GtkWindow*) _tmp6_, (GtkWindow*) _tmp7_);
#line 1714 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp8_ = self->priv->settings;
#line 1714 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp9_ = preferences_builder;
#line 1714 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp10_ = gtk_builder_get_object (_tmp9_, "show_numbering_check");
#line 1714 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_settings_bind (_tmp8_, "show-numbering", _tmp10_, "active", G_SETTINGS_BIND_DEFAULT);
#line 1716 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp11_ = self->priv->settings;
#line 1716 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp12_ = preferences_builder;
#line 1716 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp13_ = gtk_builder_get_object (_tmp12_, "show_move_hints_check");
#line 1716 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_settings_bind (_tmp11_, "show-move-hints", _tmp13_, "active", G_SETTINGS_BIND_DEFAULT);
#line 1719 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp14_ = preferences_builder;
#line 1719 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp15_ = gtk_builder_get_object (_tmp14_, "side_combo");
#line 1719 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp16_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_combo_box_get_type (), GtkComboBox));
#line 1719 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->side_combo);
#line 1719 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	self->priv->side_combo = _tmp16_;
#line 1720 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp17_ = self->priv->side_combo;
#line 1720 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp18_ = self->priv->settings;
#line 1720 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp19_ = g_settings_get_enum (_tmp18_, "play-as");
#line 1720 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_combo_box_set_active (_tmp17_, _tmp19_);
#line 1722 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp20_ = preferences_builder;
#line 1722 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp21_ = gtk_builder_get_object (_tmp20_, "opponent_combo");
#line 1722 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp22_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, gtk_combo_box_get_type (), GtkComboBox));
#line 1722 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	ai_combo = _tmp22_;
#line 1723 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp23_ = ai_combo;
#line 1723 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp24_ = gtk_combo_box_get_model (_tmp23_);
#line 1723 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp25_ = _tmp24_;
#line 1723 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp26_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, gtk_list_store_get_type (), GtkListStore));
#line 1723 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	ai_model = _tmp26_;
#line 1724 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp27_ = self->priv->settings;
#line 1724 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp28_ = g_settings_get_string (_tmp27_, "opponent");
#line 1724 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	opponent_name = _tmp28_;
#line 1725 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp29_ = opponent_name;
#line 1725 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (g_strcmp0 (_tmp29_, "human") == 0) {
#line 9329 "gnome-chess.c"
		GtkComboBox* _tmp30_;
#line 1726 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp30_ = ai_combo;
#line 1726 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		gtk_combo_box_set_active (_tmp30_, 0);
#line 9335 "gnome-chess.c"
	}
#line 1727 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp31_ = self->priv->ai_profiles;
#line 9339 "gnome-chess.c"
	{
		GList* p_collection = NULL;
		GList* p_it = NULL;
#line 1727 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		p_collection = _tmp31_;
#line 1727 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		for (p_it = p_collection; p_it != NULL; p_it = p_it->next) {
#line 9347 "gnome-chess.c"
			AIProfile* _tmp32_;
			AIProfile* p = NULL;
#line 1727 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp32_ = _g_object_ref0 ((AIProfile*) p_it->data);
#line 1727 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			p = _tmp32_;
#line 9354 "gnome-chess.c"
			{
				GtkTreeIter iter = {0};
				GtkListStore* _tmp33_;
				GtkTreeIter _tmp34_ = {0};
				GtkListStore* _tmp35_;
				GtkTreeIter _tmp36_;
				AIProfile* _tmp37_;
				const gchar* _tmp38_;
				const gchar* _tmp39_;
				AIProfile* _tmp40_;
				const gchar* _tmp41_;
				const gchar* _tmp42_;
				gboolean _tmp43_ = FALSE;
				AIProfile* _tmp44_;
				const gchar* _tmp45_;
				const gchar* _tmp46_;
				const gchar* _tmp47_;
#line 1730 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp33_ = ai_model;
#line 1730 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				gtk_list_store_append (_tmp33_, &_tmp34_);
#line 1730 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				iter = _tmp34_;
#line 1731 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp35_ = ai_model;
#line 1731 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp36_ = iter;
#line 1731 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp37_ = p;
#line 1731 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp38_ = ai_profile_get_name (_tmp37_);
#line 1731 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp39_ = _tmp38_;
#line 1731 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp40_ = p;
#line 1731 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp41_ = ai_profile_get_name (_tmp40_);
#line 1731 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp42_ = _tmp41_;
#line 1731 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				gtk_list_store_set (_tmp35_, &_tmp36_, 0, _tmp39_, 1, _tmp42_, -1, -1);
#line 1732 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp44_ = p;
#line 1732 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp45_ = ai_profile_get_name (_tmp44_);
#line 1732 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp46_ = _tmp45_;
#line 1732 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp47_ = opponent_name;
#line 1732 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				if (g_strcmp0 (_tmp46_, _tmp47_) == 0) {
#line 1732 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					_tmp43_ = TRUE;
#line 9408 "gnome-chess.c"
				} else {
					gboolean _tmp48_ = FALSE;
					const gchar* _tmp49_;
#line 1732 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					_tmp49_ = opponent_name;
#line 1732 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					if (g_strcmp0 (_tmp49_, "") == 0) {
#line 9416 "gnome-chess.c"
						GtkComboBox* _tmp50_;
						gint _tmp51_;
#line 1732 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
						_tmp50_ = ai_combo;
#line 1732 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
						_tmp51_ = gtk_combo_box_get_active (_tmp50_);
#line 1732 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
						_tmp48_ = _tmp51_ == -1;
#line 9425 "gnome-chess.c"
					} else {
#line 1732 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
						_tmp48_ = FALSE;
#line 9429 "gnome-chess.c"
					}
#line 1732 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					_tmp43_ = _tmp48_;
#line 9433 "gnome-chess.c"
				}
#line 1732 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				if (_tmp43_) {
#line 9437 "gnome-chess.c"
					GtkComboBox* _tmp52_;
					GtkTreeIter _tmp53_;
#line 1733 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					_tmp52_ = ai_combo;
#line 1733 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					_tmp53_ = iter;
#line 1733 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					gtk_combo_box_set_active_iter (_tmp52_, &_tmp53_);
#line 9446 "gnome-chess.c"
				}
#line 1727 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_g_object_unref0 (p);
#line 9450 "gnome-chess.c"
			}
		}
	}
#line 1735 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp54_ = ai_combo;
#line 1735 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp55_ = gtk_combo_box_get_active (_tmp54_);
#line 1735 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp55_ == -1) {
#line 9460 "gnome-chess.c"
		GtkComboBox* _tmp56_;
		GSettings* _tmp57_;
#line 1737 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp56_ = ai_combo;
#line 1737 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		gtk_combo_box_set_active (_tmp56_, 0);
#line 1738 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp57_ = self->priv->settings;
#line 1738 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		g_settings_set_string (_tmp57_, "opponent", "human");
#line 9471 "gnome-chess.c"
	}
#line 1741 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp58_ = preferences_builder;
#line 1741 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp59_ = gtk_builder_get_object (_tmp58_, "difficulty_combo");
#line 1741 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp60_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp59_, gtk_combo_box_get_type (), GtkComboBox));
#line 1741 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->difficulty_combo);
#line 1741 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	self->priv->difficulty_combo = _tmp60_;
#line 1742 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp61_ = self->priv->difficulty_combo;
#line 1742 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp62_ = self->priv->settings;
#line 1742 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp63_ = g_settings_get_string (_tmp62_, "difficulty");
#line 1742 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp64_ = _tmp63_;
#line 1742 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	chess_application_set_combo (self, _tmp61_, 1, _tmp64_);
#line 1742 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_free0 (_tmp64_);
#line 1744 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp65_ = preferences_builder;
#line 1744 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp66_ = gtk_builder_get_object (_tmp65_, "duration_combo");
#line 1744 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp67_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp66_, gtk_combo_box_get_type (), GtkComboBox));
#line 1744 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->duration_combo);
#line 1744 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	self->priv->duration_combo = _tmp67_;
#line 1745 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp68_ = preferences_builder;
#line 1745 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp69_ = gtk_builder_get_object (_tmp68_, "clock_type_combo");
#line 1745 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp70_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp69_, gtk_combo_box_get_type (), GtkComboBox));
#line 1745 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->clock_type_combo);
#line 1745 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	self->priv->clock_type_combo = _tmp70_;
#line 1746 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp71_ = preferences_builder;
#line 1746 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp72_ = gtk_builder_get_object (_tmp71_, "duration_adjustment");
#line 1746 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp73_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp72_, gtk_adjustment_get_type (), GtkAdjustment));
#line 1746 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->duration_adjustment);
#line 1746 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	self->priv->duration_adjustment = _tmp73_;
#line 1747 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp74_ = preferences_builder;
#line 1747 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp75_ = gtk_builder_get_object (_tmp74_, "timer_increment_adjustment");
#line 1747 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp76_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp75_, gtk_adjustment_get_type (), GtkAdjustment));
#line 1747 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->timer_increment_adjustment);
#line 1747 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	self->priv->timer_increment_adjustment = _tmp76_;
#line 1748 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp77_ = preferences_builder;
#line 1748 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp78_ = gtk_builder_get_object (_tmp77_, "custom_duration_box");
#line 1748 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp79_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp78_, gtk_box_get_type (), GtkBox));
#line 1748 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->custom_duration_box);
#line 1748 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	self->priv->custom_duration_box = _tmp79_;
#line 1749 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp80_ = preferences_builder;
#line 1749 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp81_ = gtk_builder_get_object (_tmp80_, "timer_increment_box");
#line 1749 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp82_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp81_, gtk_box_get_type (), GtkBox));
#line 1749 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->timer_increment_box);
#line 1749 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	self->priv->timer_increment_box = _tmp82_;
#line 1750 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp83_ = preferences_builder;
#line 1750 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp84_ = gtk_builder_get_object (_tmp83_, "custom_duration_units_combo");
#line 1750 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp85_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp84_, gtk_combo_box_get_type (), GtkComboBox));
#line 1750 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->custom_duration_units_combo);
#line 1750 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	self->priv->custom_duration_units_combo = _tmp85_;
#line 1751 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp86_ = self->priv->settings;
#line 1751 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp87_ = g_settings_get_int (_tmp86_, "duration");
#line 1751 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	chess_application_set_duration (self, _tmp87_, TRUE);
#line 1752 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp88_ = preferences_builder;
#line 1752 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp89_ = gtk_builder_get_object (_tmp88_, "timer_increment_label");
#line 1752 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp90_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp89_, gtk_widget_get_type (), GtkWidget));
#line 1752 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->timer_increment_label);
#line 1752 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	self->priv->timer_increment_label = _tmp90_;
#line 1753 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp91_ = preferences_builder;
#line 1753 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp92_ = gtk_builder_get_object (_tmp91_, "timer_increment_units_combo");
#line 1753 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp93_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp92_, gtk_combo_box_get_type (), GtkComboBox));
#line 1753 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->timer_increment_units_combo);
#line 1753 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	self->priv->timer_increment_units_combo = _tmp93_;
#line 1755 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp94_ = self->priv->pgn_game;
#line 1755 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp95_ = pgn_game_get_clock_type (_tmp94_);
#line 1755 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp96_ = _tmp95_;
#line 1755 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp96_ != NULL) {
#line 9599 "gnome-chess.c"
		PGNGame* _tmp97_;
		const gchar* _tmp98_;
		const gchar* _tmp99_;
		ClockType _tmp100_;
#line 1756 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp97_ = self->priv->pgn_game;
#line 1756 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp98_ = pgn_game_get_clock_type (_tmp97_);
#line 1756 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp99_ = _tmp98_;
#line 1756 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp100_ = clock_type_string_to_enum (_tmp99_);
#line 1756 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		chess_application_set_clock_type (self, (gint) _tmp100_);
#line 9614 "gnome-chess.c"
	} else {
		GSettings* _tmp101_;
		gchar* _tmp102_;
		gchar* _tmp103_;
		ClockType _tmp104_;
#line 1758 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp101_ = self->priv->settings;
#line 1758 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp102_ = g_settings_get_string (_tmp101_, "clock-type");
#line 1758 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp103_ = _tmp102_;
#line 1758 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp104_ = clock_type_string_to_enum (_tmp103_);
#line 1758 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		chess_application_set_clock_type (self, (gint) _tmp104_);
#line 1758 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_g_free0 (_tmp103_);
#line 9632 "gnome-chess.c"
	}
#line 1760 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp105_ = self->priv->pgn_game;
#line 1760 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp106_ = pgn_game_get_timer_increment (_tmp105_);
#line 1760 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp107_ = _tmp106_;
#line 1760 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp107_ != NULL) {
#line 9642 "gnome-chess.c"
		PGNGame* _tmp108_;
		const gchar* _tmp109_;
		const gchar* _tmp110_;
		gint _tmp111_;
#line 1761 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp108_ = self->priv->pgn_game;
#line 1761 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp109_ = pgn_game_get_timer_increment (_tmp108_);
#line 1761 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp110_ = _tmp109_;
#line 1761 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp111_ = atoi (_tmp110_);
#line 1761 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		chess_application_set_timer_increment (self, _tmp111_);
#line 9657 "gnome-chess.c"
	} else {
		GSettings* _tmp112_;
		gint _tmp113_;
#line 1763 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp112_ = self->priv->settings;
#line 1763 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp113_ = g_settings_get_int (_tmp112_, "timer-increment");
#line 1763 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		chess_application_set_timer_increment (self, _tmp113_);
#line 9667 "gnome-chess.c"
	}
#line 1765 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp114_ = preferences_builder;
#line 1765 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp115_ = gtk_builder_get_object (_tmp114_, "orientation_combo");
#line 1765 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp116_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp115_, gtk_combo_box_get_type (), GtkComboBox));
#line 1765 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	orientation_combo = _tmp116_;
#line 1766 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp117_ = orientation_combo;
#line 1766 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp118_ = self->priv->settings;
#line 1766 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp119_ = g_settings_get_string (_tmp118_, "board-side");
#line 1766 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp120_ = _tmp119_;
#line 1766 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	chess_application_set_combo (self, _tmp117_, 1, _tmp120_);
#line 1766 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_free0 (_tmp120_);
#line 1768 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp121_ = preferences_builder;
#line 1768 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp122_ = gtk_builder_get_object (_tmp121_, "move_format_combo");
#line 1768 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp123_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp122_, gtk_combo_box_get_type (), GtkComboBox));
#line 1768 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	move_combo = _tmp123_;
#line 1769 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp124_ = move_combo;
#line 1769 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp125_ = self->priv->settings;
#line 1769 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp126_ = g_settings_get_string (_tmp125_, "move-format");
#line 1769 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp127_ = _tmp126_;
#line 1769 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	chess_application_set_combo (self, _tmp124_, 1, _tmp127_);
#line 1769 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_free0 (_tmp127_);
#line 1771 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp128_ = preferences_builder;
#line 1771 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp129_ = gtk_builder_get_object (_tmp128_, "piece_style_combo");
#line 1771 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp130_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp129_, gtk_combo_box_get_type (), GtkComboBox));
#line 1771 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	theme_combo = _tmp130_;
#line 1772 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp131_ = theme_combo;
#line 1772 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp132_ = self->priv->settings;
#line 1772 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp133_ = g_settings_get_string (_tmp132_, "piece-theme");
#line 1772 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp134_ = _tmp133_;
#line 1772 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	chess_application_set_combo (self, _tmp131_, 1, _tmp134_);
#line 1772 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_free0 (_tmp134_);
#line 1774 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp135_ = preferences_builder;
#line 1774 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_builder_connect_signals (_tmp135_, self);
#line 1777 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp136_ = ai_combo;
#line 1777 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp137_ = gtk_combo_box_get_active (_tmp136_);
#line 1777 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp137_ == 0) {
#line 9739 "gnome-chess.c"
		GtkComboBox* _tmp138_;
		GtkComboBox* _tmp139_;
#line 1779 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp138_ = self->priv->side_combo;
#line 1779 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		gtk_widget_set_sensitive ((GtkWidget*) _tmp138_, FALSE);
#line 1780 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp139_ = self->priv->difficulty_combo;
#line 1780 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		gtk_widget_set_sensitive ((GtkWidget*) _tmp139_, FALSE);
#line 9750 "gnome-chess.c"
	}
#line 1783 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp140_ = self->priv->preferences_dialog;
#line 1783 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_dialog_run (_tmp140_);
#line 1701 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (theme_combo);
#line 1701 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (move_combo);
#line 1701 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (orientation_combo);
#line 1701 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_free0 (opponent_name);
#line 1701 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (ai_model);
#line 1701 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (ai_combo);
#line 1701 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (preferences_builder);
#line 9770 "gnome-chess.c"
}


static void chess_application_set_combo (ChessApplication* self, GtkComboBox* combo, gint value_index, const gchar* value) {
	GtkTreeIter iter = {0};
	GtkTreeModel* model;
	GtkComboBox* _tmp0_;
	GtkTreeModel* _tmp1_;
	GtkTreeModel* _tmp2_;
	GtkTreeModel* _tmp3_;
	GtkTreeModel* _tmp4_;
	GtkTreeIter _tmp5_ = {0};
	gboolean _tmp6_;
#line 1786 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1786 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (combo != NULL);
#line 1786 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (value != NULL);
#line 1789 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = combo;
#line 1789 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = gtk_combo_box_get_model (_tmp0_);
#line 1789 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = _tmp1_;
#line 1789 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 1789 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	model = _tmp3_;
#line 1790 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = model;
#line 1790 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = gtk_tree_model_get_iter_first (_tmp4_, &_tmp5_);
#line 1790 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	iter = _tmp5_;
#line 1790 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (!_tmp6_) {
#line 1791 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (model);
#line 1791 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		return;
#line 9812 "gnome-chess.c"
	}
	{
		gboolean _tmp7_;
#line 1792 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp7_ = TRUE;
#line 1792 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		while (TRUE) {
#line 9820 "gnome-chess.c"
			gchar* v = NULL;
			GtkTreeModel* _tmp10_;
			GtkTreeIter _tmp11_;
			gint _tmp12_;
			const gchar* _tmp13_;
			const gchar* _tmp14_;
#line 1792 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			if (!_tmp7_) {
#line 9829 "gnome-chess.c"
				GtkTreeModel* _tmp8_;
				gboolean _tmp9_;
#line 1801 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp8_ = model;
#line 1801 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp9_ = gtk_tree_model_iter_next (_tmp8_, &iter);
#line 1801 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				if (!_tmp9_) {
#line 1801 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					break;
#line 9840 "gnome-chess.c"
				}
			}
#line 1792 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp7_ = FALSE;
#line 1795 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp10_ = model;
#line 1795 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp11_ = iter;
#line 1795 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp12_ = value_index;
#line 1795 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			gtk_tree_model_get (_tmp10_, &_tmp11_, _tmp12_, &v, -1, -1);
#line 1796 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp13_ = v;
#line 1796 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp14_ = value;
#line 1796 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			if (g_strcmp0 (_tmp13_, _tmp14_) == 0) {
#line 9859 "gnome-chess.c"
				GtkComboBox* _tmp15_;
				GtkTreeIter _tmp16_;
#line 1798 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp15_ = combo;
#line 1798 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp16_ = iter;
#line 1798 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				gtk_combo_box_set_active_iter (_tmp15_, &_tmp16_);
#line 1799 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_g_free0 (v);
#line 1799 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_g_object_unref0 (model);
#line 1799 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				return;
#line 9874 "gnome-chess.c"
			}
#line 1792 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_g_free0 (v);
#line 9878 "gnome-chess.c"
		}
	}
#line 1786 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (model);
#line 9883 "gnome-chess.c"
}


static gchar* chess_application_get_combo (ChessApplication* self, GtkComboBox* combo, gint value_index) {
	gchar* result = NULL;
	gchar* value = NULL;
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_;
	GtkComboBox* _tmp3_;
	GtkTreeModel* _tmp4_;
	GtkTreeModel* _tmp5_;
	GtkTreeIter _tmp6_;
	gint _tmp7_;
#line 1804 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1804 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (combo != NULL, NULL);
#line 1808 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = combo;
#line 1808 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
#line 1808 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	iter = _tmp1_;
#line 1808 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (!_tmp2_) {
#line 1809 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		result = NULL;
#line 1809 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_g_free0 (value);
#line 1809 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		return result;
#line 9917 "gnome-chess.c"
	}
#line 1810 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = combo;
#line 1810 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = gtk_combo_box_get_model (_tmp3_);
#line 1810 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = _tmp4_;
#line 1810 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = iter;
#line 1810 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = value_index;
#line 1810 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_tree_model_get (_tmp5_, &_tmp6_, _tmp7_, &value, -1, -1);
#line 1811 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	result = value;
#line 1811 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	return result;
#line 9935 "gnome-chess.c"
}


void side_combo_changed_cb (GtkComboBox* combo, ChessApplication* self) {
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_;
	gint player = 0;
	GtkComboBox* _tmp3_;
	GtkTreeModel* _tmp4_;
	GtkTreeModel* _tmp5_;
	GtkTreeIter _tmp6_;
	GSettings* _tmp7_;
	gint _tmp8_;
#line 1815 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1815 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (combo != NULL);
#line 1818 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = combo;
#line 1818 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
#line 1818 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	iter = _tmp1_;
#line 1818 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (!_tmp2_) {
#line 1819 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		return;
#line 9965 "gnome-chess.c"
	}
#line 1821 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = combo;
#line 1821 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = gtk_combo_box_get_model (_tmp3_);
#line 1821 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = _tmp4_;
#line 1821 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = iter;
#line 1821 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_tree_model_get (_tmp5_, &_tmp6_, 1, &player, -1, -1);
#line 1823 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = self->priv->settings;
#line 1823 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp8_ = player;
#line 1823 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_settings_set_enum (_tmp7_, "play-as", _tmp8_);
#line 9983 "gnome-chess.c"
}


void opponent_combo_changed_cb (GtkComboBox* combo, ChessApplication* self) {
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_;
	gchar* opponent = NULL;
	GtkComboBox* _tmp3_;
	GtkTreeModel* _tmp4_;
	GtkTreeModel* _tmp5_;
	GtkTreeIter _tmp6_;
	GSettings* _tmp7_;
	const gchar* _tmp8_;
	gboolean vs_human;
	GtkComboBox* _tmp9_;
	gint _tmp10_;
	GtkComboBox* _tmp11_;
	gboolean _tmp12_;
	GtkComboBox* _tmp13_;
	gboolean _tmp14_;
#line 1827 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1827 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (combo != NULL);
#line 1830 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = combo;
#line 1830 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
#line 1830 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	iter = _tmp1_;
#line 1830 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (!_tmp2_) {
#line 1831 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		return;
#line 10020 "gnome-chess.c"
	}
#line 1833 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = combo;
#line 1833 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = gtk_combo_box_get_model (_tmp3_);
#line 1833 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = _tmp4_;
#line 1833 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = iter;
#line 1833 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_tree_model_get (_tmp5_, &_tmp6_, 1, &opponent, -1, -1);
#line 1834 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = self->priv->settings;
#line 1834 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp8_ = opponent;
#line 1834 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_settings_set_string (_tmp7_, "opponent", _tmp8_);
#line 1835 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp9_ = combo;
#line 1835 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp10_ = gtk_combo_box_get_active (_tmp9_);
#line 1835 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	vs_human = _tmp10_ == 0;
#line 1836 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp11_ = self->priv->side_combo;
#line 1836 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp12_ = vs_human;
#line 1836 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp11_, !_tmp12_);
#line 1837 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp13_ = self->priv->difficulty_combo;
#line 1837 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp14_ = vs_human;
#line 1837 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp13_, !_tmp14_);
#line 1827 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_free0 (opponent);
#line 10058 "gnome-chess.c"
}


void difficulty_combo_changed_cb (GtkComboBox* combo, ChessApplication* self) {
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_;
	gchar* difficulty = NULL;
	GtkComboBox* _tmp3_;
	GtkTreeModel* _tmp4_;
	GtkTreeModel* _tmp5_;
	GtkTreeIter _tmp6_;
	GSettings* _tmp7_;
	const gchar* _tmp8_;
#line 1841 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1841 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (combo != NULL);
#line 1844 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = combo;
#line 1844 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
#line 1844 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	iter = _tmp1_;
#line 1844 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (!_tmp2_) {
#line 1845 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		return;
#line 10088 "gnome-chess.c"
	}
#line 1847 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = combo;
#line 1847 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = gtk_combo_box_get_model (_tmp3_);
#line 1847 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = _tmp4_;
#line 1847 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = iter;
#line 1847 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_tree_model_get (_tmp5_, &_tmp6_, 1, &difficulty, -1, -1);
#line 1848 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = self->priv->settings;
#line 1848 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp8_ = difficulty;
#line 1848 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_settings_set_string (_tmp7_, "difficulty", _tmp8_);
#line 1841 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_free0 (difficulty);
#line 10108 "gnome-chess.c"
}


static void chess_application_set_clock_type (ChessApplication* self, gint clock_type) {
	GtkTreeModel* model;
	GtkComboBox* _tmp0_;
	GtkTreeModel* _tmp1_;
	GtkTreeModel* _tmp2_;
	GtkTreeModel* _tmp3_;
	GtkTreeIter iter = {0};
	GtkTreeIter active_iter_clock_type;
	GtkTreeIter _tmp4_ = {0};
	GtkTreeModel* _tmp5_;
	GtkTreeIter _tmp6_ = {0};
	gboolean _tmp7_;
	GtkComboBox* _tmp16_;
	GtkTreeIter _tmp17_;
	GtkComboBox* _tmp18_;
#line 1851 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1853 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->clock_type_combo;
#line 1853 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = gtk_combo_box_get_model (_tmp0_);
#line 1853 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = _tmp1_;
#line 1853 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 1853 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	model = _tmp3_;
#line 1854 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	active_iter_clock_type = _tmp4_;
#line 1857 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = model;
#line 1857 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = gtk_tree_model_get_iter_first (_tmp5_, &_tmp6_);
#line 1857 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	iter = _tmp6_;
#line 1857 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp7_) {
#line 10149 "gnome-chess.c"
		{
			gboolean _tmp8_;
#line 1859 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp8_ = TRUE;
#line 1859 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			while (TRUE) {
#line 10156 "gnome-chess.c"
				gint type = 0;
				GtkTreeModel* _tmp11_;
				GtkTreeIter _tmp12_;
				gint _tmp13_;
				gint _tmp14_;
#line 1859 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				if (!_tmp8_) {
#line 10164 "gnome-chess.c"
					GtkTreeModel* _tmp9_;
					gboolean _tmp10_;
#line 1867 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					_tmp9_ = model;
#line 1867 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					_tmp10_ = gtk_tree_model_iter_next (_tmp9_, &iter);
#line 1867 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					if (!_tmp10_) {
#line 1867 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
						break;
#line 10175 "gnome-chess.c"
					}
				}
#line 1859 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp8_ = FALSE;
#line 1862 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp11_ = model;
#line 1862 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp12_ = iter;
#line 1862 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				gtk_tree_model_get (_tmp11_, &_tmp12_, 1, &type, -1, -1);
#line 1863 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp13_ = type;
#line 1863 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp14_ = clock_type;
#line 1863 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				if (_tmp13_ == _tmp14_) {
#line 10192 "gnome-chess.c"
					GtkTreeIter _tmp15_;
#line 1865 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					_tmp15_ = iter;
#line 1865 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					active_iter_clock_type = _tmp15_;
#line 10198 "gnome-chess.c"
				}
			}
		}
	}
#line 1870 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp16_ = self->priv->clock_type_combo;
#line 1870 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp17_ = active_iter_clock_type;
#line 1870 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_combo_box_set_active_iter (_tmp16_, &_tmp17_);
#line 1871 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp18_ = self->priv->clock_type_combo;
#line 1871 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	clock_type_changed_cb (_tmp18_, self);
#line 1851 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (model);
#line 10215 "gnome-chess.c"
}


static void chess_application_set_timer_increment (ChessApplication* self, gint timer_increment) {
	gint timer_increment_multiplier;
	gint _tmp0_;
	GtkTreeModel* model;
	GtkComboBox* _tmp5_;
	GtkTreeModel* _tmp6_;
	GtkTreeModel* _tmp7_;
	GtkTreeModel* _tmp8_;
	GtkTreeIter iter = {0};
	GtkTreeIter reqd_iter;
	GtkTreeIter _tmp9_ = {0};
	GtkTreeModel* _tmp10_;
	GtkTreeIter _tmp11_ = {0};
	gboolean _tmp12_;
	GtkComboBox* _tmp21_;
	GtkTreeIter _tmp22_;
	GtkComboBox* _tmp23_;
#line 1874 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1876 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	timer_increment_multiplier = 1;
#line 1878 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = timer_increment;
#line 1878 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp0_ >= 60) {
#line 10244 "gnome-chess.c"
		GtkAdjustment* _tmp1_;
		gint _tmp2_;
#line 1880 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp1_ = self->priv->timer_increment_adjustment;
#line 1880 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp2_ = timer_increment;
#line 1880 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		gtk_adjustment_set_value (_tmp1_, (gdouble) (_tmp2_ / 60));
#line 1881 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		timer_increment_multiplier = 60;
#line 10255 "gnome-chess.c"
	} else {
		GtkAdjustment* _tmp3_;
		gint _tmp4_;
#line 1883 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp3_ = self->priv->timer_increment_adjustment;
#line 1883 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp4_ = timer_increment;
#line 1883 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		gtk_adjustment_set_value (_tmp3_, (gdouble) _tmp4_);
#line 10265 "gnome-chess.c"
	}
#line 1885 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = self->priv->timer_increment_units_combo;
#line 1885 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = gtk_combo_box_get_model (_tmp5_);
#line 1885 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = _tmp6_;
#line 1885 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp8_ = _g_object_ref0 (_tmp7_);
#line 1885 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	model = _tmp8_;
#line 1886 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	reqd_iter = _tmp9_;
#line 1889 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp10_ = model;
#line 1889 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp12_ = gtk_tree_model_get_iter_first (_tmp10_, &_tmp11_);
#line 1889 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	iter = _tmp11_;
#line 1889 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp12_) {
#line 10287 "gnome-chess.c"
		{
			gboolean _tmp13_;
#line 1891 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp13_ = TRUE;
#line 1891 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			while (TRUE) {
#line 10294 "gnome-chess.c"
				gint multiplier = 0;
				GtkTreeModel* _tmp16_;
				GtkTreeIter _tmp17_;
				gint _tmp18_;
				gint _tmp19_;
#line 1891 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				if (!_tmp13_) {
#line 10302 "gnome-chess.c"
					GtkTreeModel* _tmp14_;
					gboolean _tmp15_;
#line 1899 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					_tmp14_ = model;
#line 1899 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					_tmp15_ = gtk_tree_model_iter_next (_tmp14_, &iter);
#line 1899 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					if (!_tmp15_) {
#line 1899 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
						break;
#line 10313 "gnome-chess.c"
					}
				}
#line 1891 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp13_ = FALSE;
#line 1894 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp16_ = model;
#line 1894 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp17_ = iter;
#line 1894 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				gtk_tree_model_get (_tmp16_, &_tmp17_, 1, &multiplier, -1, -1);
#line 1895 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp18_ = multiplier;
#line 1895 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp19_ = timer_increment_multiplier;
#line 1895 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				if (_tmp18_ == _tmp19_) {
#line 10330 "gnome-chess.c"
					GtkTreeIter _tmp20_;
#line 1897 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					_tmp20_ = iter;
#line 1897 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					reqd_iter = _tmp20_;
#line 10336 "gnome-chess.c"
				}
			}
		}
	}
#line 1902 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp21_ = self->priv->timer_increment_units_combo;
#line 1902 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp22_ = reqd_iter;
#line 1902 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_combo_box_set_active_iter (_tmp21_, &_tmp22_);
#line 1903 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp23_ = self->priv->timer_increment_units_combo;
#line 1903 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	timer_increment_units_changed_cb ((GtkWidget*) _tmp23_, self);
#line 1874 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (model);
#line 10353 "gnome-chess.c"
}


static void chess_application_set_duration (ChessApplication* self, gint duration, gboolean simplify) {
	GtkTreeModel* model;
	GtkComboBox* _tmp0_;
	GtkTreeModel* _tmp1_;
	GtkTreeModel* _tmp2_;
	GtkTreeModel* _tmp3_;
	GtkTreeIter iter = {0};
	GtkTreeIter max_iter;
	GtkTreeIter _tmp4_ = {0};
	gint max_multiplier;
	GtkTreeModel* _tmp5_;
	GtkTreeIter _tmp6_ = {0};
	gboolean _tmp7_;
	gint value;
	gint _tmp20_;
	gboolean _tmp27_;
	GtkComboBox* _tmp28_;
	GtkTreeModel* _tmp29_;
	GtkTreeModel* _tmp30_;
	GtkTreeModel* _tmp31_;
	GtkTreeModel* _tmp32_;
	GtkTreeIter _tmp33_ = {0};
	gboolean _tmp34_;
#line 1906 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1908 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->custom_duration_units_combo;
#line 1908 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = gtk_combo_box_get_model (_tmp0_);
#line 1908 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = _tmp1_;
#line 1908 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 1908 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	model = _tmp3_;
#line 1909 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	max_iter = _tmp4_;
#line 1912 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	max_multiplier = 0;
#line 1913 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = model;
#line 1913 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = gtk_tree_model_get_iter_first (_tmp5_, &_tmp6_);
#line 1913 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	iter = _tmp6_;
#line 1913 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp7_) {
#line 10404 "gnome-chess.c"
		{
			gboolean _tmp8_;
#line 1915 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp8_ = TRUE;
#line 1915 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			while (TRUE) {
#line 10411 "gnome-chess.c"
				gint multiplier = 0;
				GtkTreeModel* _tmp11_;
				GtkTreeIter _tmp12_;
				gboolean _tmp13_ = FALSE;
				gint _tmp14_;
				gint _tmp15_;
#line 1915 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				if (!_tmp8_) {
#line 10420 "gnome-chess.c"
					GtkTreeModel* _tmp9_;
					gboolean _tmp10_;
#line 1924 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					_tmp9_ = model;
#line 1924 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					_tmp10_ = gtk_tree_model_iter_next (_tmp9_, &iter);
#line 1924 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					if (!_tmp10_) {
#line 1924 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
						break;
#line 10431 "gnome-chess.c"
					}
				}
#line 1915 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp8_ = FALSE;
#line 1918 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp11_ = model;
#line 1918 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp12_ = iter;
#line 1918 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				gtk_tree_model_get (_tmp11_, &_tmp12_, 1, &multiplier, -1, -1);
#line 1919 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp14_ = multiplier;
#line 1919 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp15_ = max_multiplier;
#line 1919 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				if (_tmp14_ > _tmp15_) {
#line 10448 "gnome-chess.c"
					gint _tmp16_;
					gint _tmp17_;
#line 1919 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					_tmp16_ = duration;
#line 1919 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					_tmp17_ = multiplier;
#line 1919 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					_tmp13_ = (_tmp16_ % _tmp17_) == 0;
#line 10457 "gnome-chess.c"
				} else {
#line 1919 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					_tmp13_ = FALSE;
#line 10461 "gnome-chess.c"
				}
#line 1919 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				if (_tmp13_) {
#line 10465 "gnome-chess.c"
					gint _tmp18_;
					GtkTreeIter _tmp19_;
#line 1921 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					_tmp18_ = multiplier;
#line 1921 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					max_multiplier = _tmp18_;
#line 1922 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					_tmp19_ = iter;
#line 1922 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					max_iter = _tmp19_;
#line 10476 "gnome-chess.c"
				}
			}
		}
	}
#line 1928 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	value = 0;
#line 1929 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp20_ = max_multiplier;
#line 1929 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp20_ > 0) {
#line 10487 "gnome-chess.c"
		gint _tmp21_;
		gint _tmp22_;
		GtkAdjustment* _tmp23_;
		gint _tmp24_;
		GtkComboBox* _tmp25_;
		GtkTreeIter _tmp26_;
#line 1931 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp21_ = duration;
#line 1931 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp22_ = max_multiplier;
#line 1931 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		value = _tmp21_ / _tmp22_;
#line 1932 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp23_ = self->priv->duration_adjustment;
#line 1932 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp24_ = value;
#line 1932 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		gtk_adjustment_set_value (_tmp23_, (gdouble) _tmp24_);
#line 1933 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp25_ = self->priv->custom_duration_units_combo;
#line 1933 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp26_ = max_iter;
#line 1933 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		gtk_combo_box_set_active_iter (_tmp25_, &_tmp26_);
#line 10512 "gnome-chess.c"
	}
#line 1936 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp27_ = simplify;
#line 1936 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (!_tmp27_) {
#line 1937 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (model);
#line 1937 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		return;
#line 10522 "gnome-chess.c"
	}
#line 1939 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp28_ = self->priv->duration_combo;
#line 1939 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp29_ = gtk_combo_box_get_model (_tmp28_);
#line 1939 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp30_ = _tmp29_;
#line 1939 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp31_ = _g_object_ref0 (_tmp30_);
#line 1939 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (model);
#line 1939 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	model = _tmp31_;
#line 1940 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp32_ = model;
#line 1940 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp34_ = gtk_tree_model_get_iter_first (_tmp32_, &_tmp33_);
#line 1940 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	iter = _tmp33_;
#line 1940 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (!_tmp34_) {
#line 1941 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (model);
#line 1941 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		return;
#line 10548 "gnome-chess.c"
	}
	{
		gboolean _tmp35_;
#line 1942 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp35_ = TRUE;
#line 1942 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		while (TRUE) {
#line 10556 "gnome-chess.c"
			gint v = 0;
			GtkTreeModel* _tmp38_;
			GtkTreeIter _tmp39_;
			gboolean _tmp40_ = FALSE;
			gint _tmp41_;
			gint _tmp42_;
#line 1942 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			if (!_tmp35_) {
#line 10565 "gnome-chess.c"
				GtkTreeModel* _tmp36_;
				gboolean _tmp37_;
#line 1952 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp36_ = model;
#line 1952 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp37_ = gtk_tree_model_iter_next (_tmp36_, &iter);
#line 1952 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				if (!_tmp37_) {
#line 1952 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					break;
#line 10576 "gnome-chess.c"
				}
			}
#line 1942 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp35_ = FALSE;
#line 1945 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp38_ = model;
#line 1945 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp39_ = iter;
#line 1945 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			gtk_tree_model_get (_tmp38_, &_tmp39_, 1, &v, -1, -1);
#line 1946 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp41_ = v;
#line 1946 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp42_ = duration;
#line 1946 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			if (_tmp41_ == _tmp42_) {
#line 1946 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp40_ = TRUE;
#line 10595 "gnome-chess.c"
			} else {
				gint _tmp43_;
#line 1946 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp43_ = v;
#line 1946 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp40_ = _tmp43_ == -1;
#line 10602 "gnome-chess.c"
			}
#line 1946 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			if (_tmp40_) {
#line 10606 "gnome-chess.c"
				GtkComboBox* _tmp44_;
				GtkTreeIter _tmp45_;
				GtkBox* _tmp46_;
				gint _tmp47_;
#line 1948 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp44_ = self->priv->duration_combo;
#line 1948 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp45_ = iter;
#line 1948 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				gtk_combo_box_set_active_iter (_tmp44_, &_tmp45_);
#line 1949 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp46_ = self->priv->custom_duration_box;
#line 1949 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp47_ = v;
#line 1949 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				gtk_widget_set_visible ((GtkWidget*) _tmp46_, _tmp47_ == -1);
#line 1950 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_g_object_unref0 (model);
#line 1950 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				return;
#line 10627 "gnome-chess.c"
			}
		}
	}
#line 1906 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (model);
#line 10633 "gnome-chess.c"
}


static gint chess_application_get_duration (ChessApplication* self) {
	gint result = 0;
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_;
	gint magnitude;
	GtkAdjustment* _tmp8_;
	gdouble _tmp9_;
	gdouble _tmp10_;
	gint multiplier;
	GtkComboBox* _tmp11_;
	GtkTreeIter _tmp12_ = {0};
	gboolean _tmp13_;
	gint _tmp18_;
	gint _tmp29_;
	gint _tmp30_;
#line 1955 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1958 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->duration_combo;
#line 1958 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
#line 1958 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	iter = _tmp1_;
#line 1958 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp2_) {
#line 10664 "gnome-chess.c"
		gint duration = 0;
		GtkComboBox* _tmp3_;
		GtkTreeModel* _tmp4_;
		GtkTreeModel* _tmp5_;
		GtkTreeIter _tmp6_;
		gint _tmp7_;
#line 1961 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp3_ = self->priv->duration_combo;
#line 1961 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp4_ = gtk_combo_box_get_model (_tmp3_);
#line 1961 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp5_ = _tmp4_;
#line 1961 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp6_ = iter;
#line 1961 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		gtk_tree_model_get (_tmp5_, &_tmp6_, 1, &duration, -1, -1);
#line 1962 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp7_ = duration;
#line 1962 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		if (_tmp7_ >= 0) {
#line 1963 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			result = duration;
#line 1963 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			return result;
#line 10689 "gnome-chess.c"
		}
	}
#line 1966 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp8_ = self->priv->duration_adjustment;
#line 1966 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp9_ = gtk_adjustment_get_value (_tmp8_);
#line 1966 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp10_ = _tmp9_;
#line 1966 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	magnitude = (gint) _tmp10_;
#line 1967 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	multiplier = 1;
#line 1968 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp11_ = self->priv->custom_duration_units_combo;
#line 1968 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp13_ = gtk_combo_box_get_active_iter (_tmp11_, &_tmp12_);
#line 1968 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	iter = _tmp12_;
#line 1968 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp13_) {
#line 10710 "gnome-chess.c"
		GtkComboBox* _tmp14_;
		GtkTreeModel* _tmp15_;
		GtkTreeModel* _tmp16_;
		GtkTreeIter _tmp17_;
#line 1969 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp14_ = self->priv->custom_duration_units_combo;
#line 1969 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp15_ = gtk_combo_box_get_model (_tmp14_);
#line 1969 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp16_ = _tmp15_;
#line 1969 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp17_ = iter;
#line 1969 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		gtk_tree_model_get (_tmp16_, &_tmp17_, 1, &multiplier, -1, -1);
#line 10725 "gnome-chess.c"
	}
#line 1971 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp18_ = multiplier;
#line 1971 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	switch (_tmp18_) {
#line 1971 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		case 60:
#line 10733 "gnome-chess.c"
		{
			GtkAdjustment* _tmp19_;
			gdouble _tmp20_;
#line 1974 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp19_ = self->priv->duration_adjustment;
#line 1974 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp20_ = gtk_adjustment_get_upper (_tmp19_);
#line 1974 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			if (_tmp20_ != ((gdouble) 600)) {
#line 10743 "gnome-chess.c"
				GtkAdjustment* _tmp21_;
#line 1975 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp21_ = self->priv->duration_adjustment;
#line 1975 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				gtk_adjustment_set_upper (_tmp21_, (gdouble) 600);
#line 10749 "gnome-chess.c"
			}
#line 1976 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			break;
#line 10753 "gnome-chess.c"
		}
#line 1971 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		case 3600:
#line 10757 "gnome-chess.c"
		{
			GtkAdjustment* _tmp22_;
			gdouble _tmp23_;
#line 1978 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp22_ = self->priv->duration_adjustment;
#line 1978 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp23_ = gtk_adjustment_get_upper (_tmp22_);
#line 1978 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			if (_tmp23_ != ((gdouble) 10)) {
#line 10767 "gnome-chess.c"
				GtkAdjustment* _tmp24_;
				GtkAdjustment* _tmp25_;
				gdouble _tmp26_;
				gdouble _tmp27_;
#line 1980 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp24_ = self->priv->duration_adjustment;
#line 1980 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				gtk_adjustment_set_upper (_tmp24_, (gdouble) 10);
#line 1981 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp25_ = self->priv->duration_adjustment;
#line 1981 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp26_ = gtk_adjustment_get_value (_tmp25_);
#line 1981 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp27_ = _tmp26_;
#line 1981 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				if (_tmp27_ > ((gdouble) 10)) {
#line 10784 "gnome-chess.c"
					GtkAdjustment* _tmp28_;
#line 1983 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					_tmp28_ = self->priv->duration_adjustment;
#line 1983 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					gtk_adjustment_set_value (_tmp28_, (gdouble) 10);
#line 1984 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					magnitude = 10;
#line 10792 "gnome-chess.c"
				}
			}
#line 1987 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			break;
#line 10797 "gnome-chess.c"
		}
		default:
		{
#line 1989 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			g_assert_not_reached ();
#line 10803 "gnome-chess.c"
		}
	}
#line 1992 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp29_ = magnitude;
#line 1992 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp30_ = multiplier;
#line 1992 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	result = _tmp29_ * _tmp30_;
#line 1992 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	return result;
#line 10814 "gnome-chess.c"
}


static gboolean chess_application_save_duration_cb (ChessApplication* self) {
	gboolean result = FALSE;
	GSettings* _tmp0_;
	gint _tmp1_;
	guint _tmp2_;
#line 1995 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1997 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->settings;
#line 1997 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = chess_application_get_duration (self);
#line 1997 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_settings_set_int (_tmp0_, "duration", _tmp1_);
#line 1998 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = self->priv->save_duration_timeout;
#line 1998 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_source_remove (_tmp2_);
#line 1999 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	self->priv->save_duration_timeout = (guint) 0;
#line 2000 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	result = G_SOURCE_REMOVE;
#line 2000 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	return result;
#line 10841 "gnome-chess.c"
}


void duration_changed_cb (GtkAdjustment* adjustment, ChessApplication* self) {
	GtkListStore* model;
	GtkComboBox* _tmp0_;
	GtkTreeModel* _tmp1_;
	GtkTreeModel* _tmp2_;
	GtkListStore* _tmp3_;
	GtkTreeIter iter = {0};
	GtkListStore* _tmp4_;
	GtkTreeIter _tmp5_ = {0};
	gboolean _tmp6_;
#line 2004 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 2004 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (adjustment != NULL);
#line 2006 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->custom_duration_units_combo;
#line 2006 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = gtk_combo_box_get_model (_tmp0_);
#line 2006 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = _tmp1_;
#line 2006 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_list_store_get_type (), GtkListStore));
#line 2006 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	model = _tmp3_;
#line 2009 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = model;
#line 2009 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp4_, &_tmp5_);
#line 2009 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	iter = _tmp5_;
#line 2009 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp6_) {
#line 10877 "gnome-chess.c"
		{
			gboolean _tmp7_;
#line 2011 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp7_ = TRUE;
#line 2011 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			while (TRUE) {
#line 10884 "gnome-chess.c"
				gint multiplier = 0;
				GtkListStore* _tmp10_;
				GtkTreeIter _tmp11_;
				gint _tmp12_;
#line 2011 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				if (!_tmp7_) {
#line 10891 "gnome-chess.c"
					GtkListStore* _tmp8_;
					gboolean _tmp9_;
#line 2028 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					_tmp8_ = model;
#line 2028 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					_tmp9_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp8_, &iter);
#line 2028 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					if (!_tmp9_) {
#line 2028 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
						break;
#line 10902 "gnome-chess.c"
					}
				}
#line 2011 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp7_ = FALSE;
#line 2014 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp10_ = model;
#line 2014 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp11_ = iter;
#line 2014 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				gtk_tree_model_get ((GtkTreeModel*) _tmp10_, &_tmp11_, 1, &multiplier, -1, -1);
#line 2015 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp12_ = multiplier;
#line 2015 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				switch (_tmp12_) {
#line 2015 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					case 60:
#line 10919 "gnome-chess.c"
					{
						GtkListStore* _tmp13_;
						GtkTreeIter _tmp14_;
						GtkAdjustment* _tmp15_;
						gdouble _tmp16_;
						gdouble _tmp17_;
#line 2018 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
						_tmp13_ = model;
#line 2018 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
						_tmp14_ = iter;
#line 2018 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
						_tmp15_ = adjustment;
#line 2018 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
						_tmp16_ = gtk_adjustment_get_value (_tmp15_);
#line 2018 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
						_tmp17_ = _tmp16_;
#line 2018 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
						gtk_list_store_set (_tmp13_, &_tmp14_, 0, ngettext ("minute", "minutes", (gulong) _tmp17_), -1, -1);
#line 2020 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
						break;
#line 10940 "gnome-chess.c"
					}
#line 2015 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					case 3600:
#line 10944 "gnome-chess.c"
					{
						GtkListStore* _tmp18_;
						GtkTreeIter _tmp19_;
						GtkAdjustment* _tmp20_;
						gdouble _tmp21_;
						gdouble _tmp22_;
#line 2022 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
						_tmp18_ = model;
#line 2022 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
						_tmp19_ = iter;
#line 2022 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
						_tmp20_ = adjustment;
#line 2022 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
						_tmp21_ = gtk_adjustment_get_value (_tmp20_);
#line 2022 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
						_tmp22_ = _tmp21_;
#line 2022 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
						gtk_list_store_set (_tmp18_, &_tmp19_, 0, ngettext ("hour", "hours", (gulong) _tmp22_), -1, -1);
#line 2024 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
						break;
#line 10965 "gnome-chess.c"
					}
					default:
					{
#line 2026 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
						g_assert_not_reached ();
#line 10971 "gnome-chess.c"
					}
				}
			}
		}
	}
#line 2031 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	chess_application_save_duration (self);
#line 2004 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (model);
#line 10981 "gnome-chess.c"
}


void duration_units_changed_cb (GtkWidget* widget, ChessApplication* self) {
#line 2035 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 2035 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (widget != NULL);
#line 2037 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	chess_application_save_duration (self);
#line 10992 "gnome-chess.c"
}


void timer_increment_units_changed_cb (GtkWidget* widget, ChessApplication* self) {
	GtkListStore* model;
	GtkComboBox* _tmp0_;
	GtkTreeModel* _tmp1_;
	GtkTreeModel* _tmp2_;
	GtkListStore* _tmp3_;
	GtkTreeIter iter = {0};
	gint multiplier;
	GtkListStore* _tmp4_;
	GtkTreeIter _tmp5_ = {0};
	gboolean _tmp6_;
	GtkComboBox* _tmp23_;
	GtkTreeIter _tmp24_ = {0};
	gboolean _tmp25_;
	gint _tmp30_;
	GSettings* _tmp41_;
	GtkAdjustment* _tmp42_;
	gdouble _tmp43_;
	gdouble _tmp44_;
	gint _tmp45_;
#line 2041 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 2041 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (widget != NULL);
#line 2043 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->timer_increment_units_combo;
#line 2043 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = gtk_combo_box_get_model (_tmp0_);
#line 2043 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = _tmp1_;
#line 2043 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_list_store_get_type (), GtkListStore));
#line 2043 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	model = _tmp3_;
#line 2045 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	multiplier = 0;
#line 2047 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = model;
#line 2047 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp4_, &_tmp5_);
#line 2047 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	iter = _tmp5_;
#line 2047 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp6_) {
#line 11040 "gnome-chess.c"
		{
			gboolean _tmp7_;
#line 2049 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp7_ = TRUE;
#line 2049 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			while (TRUE) {
#line 11047 "gnome-chess.c"
				GtkListStore* _tmp10_;
				GtkTreeIter _tmp11_;
				gint _tmp12_;
#line 2049 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				if (!_tmp7_) {
#line 11053 "gnome-chess.c"
					GtkListStore* _tmp8_;
					gboolean _tmp9_;
#line 2065 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					_tmp8_ = model;
#line 2065 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					_tmp9_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp8_, &iter);
#line 2065 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					if (!_tmp9_) {
#line 2065 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
						break;
#line 11064 "gnome-chess.c"
					}
				}
#line 2049 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp7_ = FALSE;
#line 2051 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp10_ = model;
#line 2051 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp11_ = iter;
#line 2051 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				gtk_tree_model_get ((GtkTreeModel*) _tmp10_, &_tmp11_, 1, &multiplier, -1, -1);
#line 2052 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp12_ = multiplier;
#line 2052 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				switch (_tmp12_) {
#line 2052 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					case 1:
#line 11081 "gnome-chess.c"
					{
						GtkListStore* _tmp13_;
						GtkTreeIter _tmp14_;
						GtkAdjustment* _tmp15_;
						gdouble _tmp16_;
						gdouble _tmp17_;
#line 2055 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
						_tmp13_ = model;
#line 2055 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
						_tmp14_ = iter;
#line 2055 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
						_tmp15_ = self->priv->timer_increment_adjustment;
#line 2055 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
						_tmp16_ = gtk_adjustment_get_value (_tmp15_);
#line 2055 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
						_tmp17_ = _tmp16_;
#line 2055 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
						gtk_list_store_set (_tmp13_, &_tmp14_, 0, ngettext ("second", "seconds", (gulong) _tmp17_), -1, -1);
#line 2057 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
						break;
#line 11102 "gnome-chess.c"
					}
#line 2052 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					case 60:
#line 11106 "gnome-chess.c"
					{
						GtkListStore* _tmp18_;
						GtkTreeIter _tmp19_;
						GtkAdjustment* _tmp20_;
						gdouble _tmp21_;
						gdouble _tmp22_;
#line 2059 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
						_tmp18_ = model;
#line 2059 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
						_tmp19_ = iter;
#line 2059 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
						_tmp20_ = self->priv->timer_increment_adjustment;
#line 2059 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
						_tmp21_ = gtk_adjustment_get_value (_tmp20_);
#line 2059 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
						_tmp22_ = _tmp21_;
#line 2059 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
						gtk_list_store_set (_tmp18_, &_tmp19_, 0, ngettext ("minute", "minutes", (gulong) _tmp22_), -1, -1);
#line 2061 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
						break;
#line 11127 "gnome-chess.c"
					}
					default:
					{
#line 2063 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
						g_assert_not_reached ();
#line 11133 "gnome-chess.c"
					}
				}
			}
		}
	}
#line 2068 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp23_ = self->priv->timer_increment_units_combo;
#line 2068 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp25_ = gtk_combo_box_get_active_iter (_tmp23_, &_tmp24_);
#line 2068 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	iter = _tmp24_;
#line 2068 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp25_) {
#line 11147 "gnome-chess.c"
		GtkComboBox* _tmp26_;
		GtkTreeModel* _tmp27_;
		GtkTreeModel* _tmp28_;
		GtkTreeIter _tmp29_;
#line 2069 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp26_ = self->priv->timer_increment_units_combo;
#line 2069 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp27_ = gtk_combo_box_get_model (_tmp26_);
#line 2069 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp28_ = _tmp27_;
#line 2069 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp29_ = iter;
#line 2069 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		gtk_tree_model_get (_tmp28_, &_tmp29_, 1, &multiplier, -1, -1);
#line 11162 "gnome-chess.c"
	}
#line 2071 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp30_ = multiplier;
#line 2071 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	switch (_tmp30_) {
#line 2071 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		case 1:
#line 11170 "gnome-chess.c"
		{
			GtkAdjustment* _tmp31_;
			gdouble _tmp32_;
#line 2074 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp31_ = self->priv->timer_increment_adjustment;
#line 2074 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp32_ = gtk_adjustment_get_upper (_tmp31_);
#line 2074 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			if (_tmp32_ != ((gdouble) 59)) {
#line 11180 "gnome-chess.c"
				GtkAdjustment* _tmp33_;
#line 2075 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp33_ = self->priv->timer_increment_adjustment;
#line 2075 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				gtk_adjustment_set_upper (_tmp33_, (gdouble) 59);
#line 11186 "gnome-chess.c"
			}
#line 2076 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			break;
#line 11190 "gnome-chess.c"
		}
#line 2071 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		case 60:
#line 11194 "gnome-chess.c"
		{
			GtkAdjustment* _tmp34_;
			gdouble _tmp35_;
#line 2078 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp34_ = self->priv->timer_increment_adjustment;
#line 2078 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp35_ = gtk_adjustment_get_upper (_tmp34_);
#line 2078 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			if (_tmp35_ != ((gdouble) 10)) {
#line 11204 "gnome-chess.c"
				GtkAdjustment* _tmp36_;
				GtkAdjustment* _tmp37_;
				gdouble _tmp38_;
				gdouble _tmp39_;
#line 2080 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp36_ = self->priv->timer_increment_adjustment;
#line 2080 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				gtk_adjustment_set_upper (_tmp36_, (gdouble) 10);
#line 2081 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp37_ = self->priv->timer_increment_adjustment;
#line 2081 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp38_ = gtk_adjustment_get_value (_tmp37_);
#line 2081 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp39_ = _tmp38_;
#line 2081 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				if (_tmp39_ > ((gdouble) 10)) {
#line 11221 "gnome-chess.c"
					GtkAdjustment* _tmp40_;
#line 2082 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					_tmp40_ = self->priv->timer_increment_adjustment;
#line 2082 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
					gtk_adjustment_set_value (_tmp40_, (gdouble) 10);
#line 11227 "gnome-chess.c"
				}
			}
#line 2084 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			break;
#line 11232 "gnome-chess.c"
		}
		default:
		{
#line 2086 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			g_assert_not_reached ();
#line 11238 "gnome-chess.c"
		}
	}
#line 2088 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp41_ = self->priv->settings;
#line 2088 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp42_ = self->priv->timer_increment_adjustment;
#line 2088 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp43_ = gtk_adjustment_get_value (_tmp42_);
#line 2088 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp44_ = _tmp43_;
#line 2088 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp45_ = multiplier;
#line 2088 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_settings_set_int (_tmp41_, "timer-increment", ((gint) _tmp44_) * _tmp45_);
#line 2041 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (model);
#line 11255 "gnome-chess.c"
}


static gboolean _chess_application_save_duration_cb_gsource_func (gpointer self) {
	gboolean result;
	result = chess_application_save_duration_cb ((ChessApplication*) self);
#line 2096 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	return result;
#line 11264 "gnome-chess.c"
}


static void chess_application_save_duration (ChessApplication* self) {
	guint _tmp0_;
	guint _tmp2_;
#line 2091 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 2094 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->save_duration_timeout;
#line 2094 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp0_ != ((guint) 0)) {
#line 11277 "gnome-chess.c"
		guint _tmp1_;
#line 2095 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp1_ = self->priv->save_duration_timeout;
#line 2095 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		g_source_remove (_tmp1_);
#line 11283 "gnome-chess.c"
	}
#line 2096 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 100, _chess_application_save_duration_cb_gsource_func, g_object_ref (self), g_object_unref);
#line 2096 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	self->priv->save_duration_timeout = _tmp2_;
#line 11289 "gnome-chess.c"
}


void duration_combo_changed_cb (GtkComboBox* combo, ChessApplication* self) {
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_;
	gint duration = 0;
	GtkComboBox* _tmp3_;
	GtkTreeModel* _tmp4_;
	GtkTreeModel* _tmp5_;
	GtkTreeIter _tmp6_;
	GtkBox* _tmp7_;
	gint _tmp8_;
	GtkComboBox* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
#line 2100 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 2100 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (combo != NULL);
#line 2103 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = combo;
#line 2103 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
#line 2103 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	iter = _tmp1_;
#line 2103 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (!_tmp2_) {
#line 2104 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		return;
#line 11323 "gnome-chess.c"
	}
#line 2106 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = combo;
#line 2106 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = gtk_combo_box_get_model (_tmp3_);
#line 2106 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = _tmp4_;
#line 2106 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = iter;
#line 2106 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_tree_model_get (_tmp5_, &_tmp6_, 1, &duration, -1, -1);
#line 2107 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = self->priv->custom_duration_box;
#line 2107 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp8_ = duration;
#line 2107 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp7_, _tmp8_ < 0);
#line 2108 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp9_ = self->priv->clock_type_combo;
#line 2108 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp10_ = duration;
#line 2108 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp9_, _tmp10_ != 0);
#line 2110 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp11_ = duration;
#line 2110 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp11_ == 0) {
#line 2111 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		chess_application_set_clock_type (self, (gint) CLOCK_TYPE_SIMPLE);
#line 11353 "gnome-chess.c"
	}
#line 2113 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp12_ = duration;
#line 2113 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp12_ >= 0) {
#line 11359 "gnome-chess.c"
		gint _tmp13_;
#line 2114 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp13_ = duration;
#line 2114 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		chess_application_set_duration (self, _tmp13_, FALSE);
#line 11365 "gnome-chess.c"
	} else {
		gint _tmp14_;
#line 2116 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp14_ = chess_application_get_duration (self);
#line 2116 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		if (_tmp14_ <= 0) {
#line 2117 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			chess_application_set_duration (self, 60 * 60, FALSE);
#line 11374 "gnome-chess.c"
		}
	}
#line 2119 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	chess_application_save_duration (self);
#line 11379 "gnome-chess.c"
}


void clock_type_changed_cb (GtkComboBox* combo, ChessApplication* self) {
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_;
	ClockType clock_type = 0;
	GtkComboBox* _tmp3_;
	GtkTreeModel* _tmp4_;
	GtkTreeModel* _tmp5_;
	GtkTreeIter _tmp6_;
	GtkBox* _tmp7_;
	ClockType _tmp8_;
	GtkWidget* _tmp9_;
	ClockType _tmp10_;
	GSettings* _tmp11_;
	ClockType _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
#line 2123 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 2123 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (combo != NULL);
#line 2126 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = combo;
#line 2126 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
#line 2126 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	iter = _tmp1_;
#line 2126 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (!_tmp2_) {
#line 2127 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		return;
#line 11415 "gnome-chess.c"
	}
#line 2129 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = combo;
#line 2129 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = gtk_combo_box_get_model (_tmp3_);
#line 2129 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = _tmp4_;
#line 2129 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = iter;
#line 2129 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_tree_model_get (_tmp5_, &_tmp6_, 1, &clock_type, -1, -1);
#line 2131 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = self->priv->timer_increment_box;
#line 2131 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp8_ = clock_type;
#line 2131 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp7_, _tmp8_ > 0);
#line 2132 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp9_ = self->priv->timer_increment_label;
#line 2132 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp10_ = clock_type;
#line 2132 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_widget_set_visible (_tmp9_, _tmp10_ > 0);
#line 2133 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp11_ = self->priv->settings;
#line 2133 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp12_ = clock_type;
#line 2133 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp13_ = clock_type_to_string (_tmp12_);
#line 2133 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp14_ = _tmp13_;
#line 2133 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_settings_set_string (_tmp11_, "clock-type", _tmp14_);
#line 2133 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_free0 (_tmp14_);
#line 11451 "gnome-chess.c"
}


void preferences_response_cb (GtkWidget* widget, gint response_id, ChessApplication* self) {
	GtkDialog* _tmp0_;
#line 2137 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 2137 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (widget != NULL);
#line 2139 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->preferences_dialog;
#line 2139 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_widget_hide ((GtkWidget*) _tmp0_);
#line 11465 "gnome-chess.c"
}


gboolean preferences_delete_event_cb (GtkWidget* widget, GdkEvent* event, ChessApplication* self) {
	gboolean result = FALSE;
	GtkWidget* _tmp0_;
#line 2143 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 2143 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (widget != NULL, FALSE);
#line 2143 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 2145 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = widget;
#line 2145 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	preferences_response_cb (_tmp0_, (gint) GTK_RESPONSE_CANCEL, self);
#line 2146 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	result = TRUE;
#line 2146 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	return result;
#line 11486 "gnome-chess.c"
}


void piece_style_combo_changed_cb (GtkComboBox* combo, ChessApplication* self) {
	GSettings* _tmp0_;
	GtkComboBox* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
#line 2150 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 2150 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (combo != NULL);
#line 2152 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->settings;
#line 2152 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = combo;
#line 2152 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = chess_application_get_combo (self, _tmp1_, 1);
#line 2152 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = _tmp2_;
#line 2152 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_settings_set_string (_tmp0_, "piece-theme", _tmp3_);
#line 2152 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_free0 (_tmp3_);
#line 11511 "gnome-chess.c"
}


void move_format_combo_changed_cb (GtkComboBox* combo, ChessApplication* self) {
	GSettings* _tmp0_;
	GtkComboBox* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
#line 2156 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 2156 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (combo != NULL);
#line 2158 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->settings;
#line 2158 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = combo;
#line 2158 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = chess_application_get_combo (self, _tmp1_, 1);
#line 2158 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = _tmp2_;
#line 2158 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_settings_set_string (_tmp0_, "move-format", _tmp3_);
#line 2158 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_free0 (_tmp3_);
#line 11536 "gnome-chess.c"
}


void orientation_combo_changed_cb (GtkComboBox* combo, ChessApplication* self) {
	GSettings* _tmp0_;
	GtkComboBox* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
#line 2162 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 2162 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (combo != NULL);
#line 2164 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->settings;
#line 2164 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = combo;
#line 2164 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = chess_application_get_combo (self, _tmp1_, 1);
#line 2164 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = _tmp2_;
#line 2164 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_settings_set_string (_tmp0_, "board-side", _tmp3_);
#line 2164 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_free0 (_tmp3_);
#line 11561 "gnome-chess.c"
}


void chess_application_help_cb (ChessApplication* self) {
	GError * _inner_error_ = NULL;
#line 2167 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 11569 "gnome-chess.c"
	{
		GtkApplicationWindow* _tmp0_;
		GdkScreen* _tmp1_;
		guint32 _tmp2_;
#line 2171 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp0_ = self->priv->window;
#line 2171 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp1_ = gtk_window_get_screen ((GtkWindow*) _tmp0_);
#line 2171 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp2_ = gtk_get_current_event_time ();
#line 2171 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		gtk_show_uri (_tmp1_, "help:gnome-chess", _tmp2_, &_inner_error_);
#line 2171 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 11584 "gnome-chess.c"
			goto __catch4_g_error;
		}
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
#line 2169 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		e = _inner_error_;
#line 2169 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_inner_error_ = NULL;
#line 2175 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp3_ = e;
#line 2175 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp4_ = _tmp3_->message;
#line 2175 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		g_warning ("gnome-chess.vala:2175: Unable to open help: %s", _tmp4_);
#line 2169 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_g_error_free0 (e);
#line 11606 "gnome-chess.c"
	}
	__finally4:
#line 2169 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2169 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2169 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		g_clear_error (&_inner_error_);
#line 2169 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		return;
#line 11617 "gnome-chess.c"
	}
}


static void _chess_application_about_response_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
#line 2203 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	chess_application_about_response_cb ((ChessApplication*) self, response_id);
#line 11625 "gnome-chess.c"
}


void chess_application_about_cb (ChessApplication* self) {
	GtkAboutDialog* _tmp0_;
	GtkAboutDialog* _tmp2_;
	GtkAboutDialog* _tmp3_;
	GtkApplicationWindow* _tmp4_;
	GtkAboutDialog* _tmp5_;
	GtkAboutDialog* _tmp6_;
	GtkAboutDialog* _tmp7_;
	GtkAboutDialog* _tmp8_;
	const gchar* _tmp9_;
	GtkAboutDialog* _tmp10_;
	GtkAboutDialog* _tmp11_;
	GtkAboutDialog* _tmp12_;
	GtkAboutDialog* _tmp13_;
	GtkAboutDialog* _tmp14_;
	GtkAboutDialog* _tmp15_;
	GtkAboutDialog* _tmp16_;
	GtkAboutDialog* _tmp17_;
	GtkAboutDialog* _tmp18_;
#line 2182 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 2184 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->about_dialog;
#line 2184 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp0_ != NULL) {
#line 11654 "gnome-chess.c"
		GtkAboutDialog* _tmp1_;
#line 2186 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp1_ = self->priv->about_dialog;
#line 2186 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		gtk_window_present ((GtkWindow*) _tmp1_);
#line 2187 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		return;
#line 11662 "gnome-chess.c"
	}
#line 2190 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = (GtkAboutDialog*) gtk_about_dialog_new ();
#line 2190 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_object_ref_sink (_tmp2_);
#line 2190 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->about_dialog);
#line 2190 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	self->priv->about_dialog = _tmp2_;
#line 2191 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = self->priv->about_dialog;
#line 2191 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = self->priv->window;
#line 2191 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_window_set_transient_for ((GtkWindow*) _tmp3_, (GtkWindow*) _tmp4_);
#line 2192 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = self->priv->about_dialog;
#line 2192 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_window_set_modal ((GtkWindow*) _tmp5_, TRUE);
#line 2193 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = self->priv->about_dialog;
#line 2193 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_about_dialog_set_program_name (_tmp6_, _ ("Chess"));
#line 2194 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = self->priv->about_dialog;
#line 2194 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_about_dialog_set_version (_tmp7_, VERSION);
#line 2195 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp8_ = self->priv->about_dialog;
#line 2195 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp9_ = self->priv->copyrights;
#line 2195 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_about_dialog_set_copyright (_tmp8_, _tmp9_);
#line 2196 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp10_ = self->priv->about_dialog;
#line 2196 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_about_dialog_set_license_type (_tmp10_, GTK_LICENSE_GPL_3_0);
#line 2197 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp11_ = self->priv->about_dialog;
#line 2197 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_about_dialog_set_comments (_tmp11_, _ ("A classic game of positional strategy"));
#line 2198 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp12_ = self->priv->about_dialog;
#line 2198 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_about_dialog_set_authors (_tmp12_, CHESS_APPLICATION_authors);
#line 2199 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp13_ = self->priv->about_dialog;
#line 2199 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_about_dialog_set_artists (_tmp13_, CHESS_APPLICATION_artists);
#line 2200 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp14_ = self->priv->about_dialog;
#line 2200 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_about_dialog_set_translator_credits (_tmp14_, _ ("translator-credits"));
#line 2201 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp15_ = self->priv->about_dialog;
#line 2201 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_about_dialog_set_website (_tmp15_, "https://wiki.gnome.org/Apps/Chess");
#line 2202 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp16_ = self->priv->about_dialog;
#line 2202 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_about_dialog_set_logo_icon_name (_tmp16_, "gnome-chess");
#line 2203 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp17_ = self->priv->about_dialog;
#line 2203 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_signal_connect_object ((GtkDialog*) _tmp17_, "response", (GCallback) _chess_application_about_response_cb_gtk_dialog_response, self, 0);
#line 2204 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp18_ = self->priv->about_dialog;
#line 2204 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_widget_show ((GtkWidget*) _tmp18_);
#line 11732 "gnome-chess.c"
}


static void chess_application_run_invalid_pgn_dialog (ChessApplication* self) {
	GtkMessageDialog* invalid_pgn_dialog;
	GtkApplicationWindow* _tmp0_;
	GtkMessageDialog* _tmp1_;
#line 2207 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 2209 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->window;
#line 2209 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp0_, GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_NONE, "%s", _ ("This does not look like a valid PGN game."));
#line 2209 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_object_ref_sink (_tmp1_);
#line 2209 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	invalid_pgn_dialog = _tmp1_;
#line 2214 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_dialog_add_button ((GtkDialog*) invalid_pgn_dialog, _ ("_OK"), (gint) GTK_RESPONSE_OK);
#line 2216 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_dialog_run ((GtkDialog*) invalid_pgn_dialog);
#line 2217 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_widget_destroy ((GtkWidget*) invalid_pgn_dialog);
#line 2207 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (invalid_pgn_dialog);
#line 11758 "gnome-chess.c"
}


static void chess_application_run_invalid_move_dialog (ChessApplication* self, const gchar* error_message) {
	GtkMessageDialog* invalid_move_dialog;
	GtkApplicationWindow* _tmp0_;
	const gchar* _tmp1_;
	GtkMessageDialog* _tmp2_;
#line 2220 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 2220 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (error_message != NULL);
#line 2222 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->window;
#line 2222 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = error_message;
#line 2222 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp0_, GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_NONE, "%s", _tmp1_);
#line 2222 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_object_ref_sink (_tmp2_);
#line 2222 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	invalid_move_dialog = _tmp2_;
#line 2227 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_dialog_add_button ((GtkDialog*) invalid_move_dialog, _ ("_OK"), (gint) GTK_RESPONSE_OK);
#line 2229 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_dialog_run ((GtkDialog*) invalid_move_dialog);
#line 2230 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_widget_destroy ((GtkWidget*) invalid_move_dialog);
#line 2220 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (invalid_move_dialog);
#line 11789 "gnome-chess.c"
}


static void chess_application_about_response_cb (ChessApplication* self, gint response_id) {
	GtkAboutDialog* _tmp0_;
#line 2233 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 2235 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->about_dialog;
#line 2235 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
#line 2236 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->about_dialog);
#line 2236 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	self->priv->about_dialog = NULL;
#line 11805 "gnome-chess.c"
}


static void chess_application_add_info_bar_to_bin (ChessApplication* self, GtkBin* bin, GtkInfoBar* * info_bar, GtkLabel* * label) {
	GtkInfoBar* _vala_info_bar = NULL;
	GtkLabel* _vala_label = NULL;
	GtkBox* vbox;
	GtkBox* _tmp0_;
	GtkInfoBar* _tmp1_;
	GtkContainer* content_area;
	GtkContainer* _tmp2_;
	GtkContainer* _tmp3_;
	GtkLabel* _tmp4_;
	GtkContainer* child;
	GtkBin* _tmp5_;
	GtkWidget* _tmp6_;
	GtkContainer* _tmp7_;
	GtkBin* _tmp8_;
	guint _tmp9_;
	guint _tmp10_;
	GtkBin* _tmp11_;
	GtkBin* _tmp12_;
#line 2239 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 2239 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (bin != NULL);
#line 2241 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
#line 2241 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_object_ref_sink (_tmp0_);
#line 2241 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	vbox = _tmp0_;
#line 2242 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_widget_show ((GtkWidget*) vbox);
#line 2244 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = (GtkInfoBar*) gtk_info_bar_new ();
#line 2244 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_object_ref_sink (_tmp1_);
#line 2244 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (_vala_info_bar);
#line 2244 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_vala_info_bar = _tmp1_;
#line 2245 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = gtk_info_bar_get_content_area (_vala_info_bar);
#line 2245 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_container_get_type (), GtkContainer));
#line 2245 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	content_area = _tmp3_;
#line 2246 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_box_pack_start (vbox, (GtkWidget*) _vala_info_bar, FALSE, TRUE, (guint) 0);
#line 2248 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = (GtkLabel*) gtk_label_new ("");
#line 2248 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_object_ref_sink (_tmp4_);
#line 2248 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (_vala_label);
#line 2248 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_vala_label = _tmp4_;
#line 2249 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_container_add (content_area, (GtkWidget*) _vala_label);
#line 2250 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_widget_show ((GtkWidget*) _vala_label);
#line 2252 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = bin;
#line 2252 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = gtk_bin_get_child (_tmp5_);
#line 2252 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_container_get_type (), GtkContainer));
#line 2252 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	child = _tmp7_;
#line 2253 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_widget_reparent ((GtkWidget*) child, (GtkWidget*) vbox);
#line 2254 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp8_ = bin;
#line 2254 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp9_ = gtk_container_get_border_width ((GtkContainer*) _tmp8_);
#line 2254 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp10_ = _tmp9_;
#line 2254 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_container_set_border_width (child, _tmp10_);
#line 2255 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp11_ = bin;
#line 2255 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_container_set_border_width ((GtkContainer*) _tmp11_, (guint) 0);
#line 2257 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_box_set_child_packing (vbox, (GtkWidget*) child, TRUE, TRUE, (guint) 0, GTK_PACK_START);
#line 2258 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp12_ = bin;
#line 2258 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_container_add ((GtkContainer*) _tmp12_, (GtkWidget*) vbox);
#line 2239 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (child);
#line 2239 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (content_area);
#line 2239 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (vbox);
#line 2239 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (info_bar) {
#line 2239 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		*info_bar = _vala_info_bar;
#line 11906 "gnome-chess.c"
	} else {
#line 2239 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (_vala_info_bar);
#line 11910 "gnome-chess.c"
	}
#line 2239 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (label) {
#line 2239 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		*label = _vala_label;
#line 11916 "gnome-chess.c"
	} else {
#line 2239 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (_vala_label);
#line 11920 "gnome-chess.c"
	}
}


static void chess_application_update_pgn_time_remaining (ChessApplication* self) {
	ChessGame* _tmp0_;
	ChessClock* _tmp1_;
	ChessClock* _tmp2_;
#line 2261 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 2263 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->game;
#line 2263 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = chess_game_get_clock (_tmp0_);
#line 2263 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = _tmp1_;
#line 2263 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp2_ != NULL) {
#line 11939 "gnome-chess.c"
		guint white_initial_time;
		PGNGame* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		gint _tmp6_;
		guint black_initial_time;
		PGNGame* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		gint _tmp10_;
		guint white_used;
		ChessGame* _tmp11_;
		ChessClock* _tmp12_;
		ChessClock* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		guint black_used;
		ChessGame* _tmp16_;
		ChessClock* _tmp17_;
		ChessClock* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		guint white_extra;
		ChessGame* _tmp21_;
		ChessClock* _tmp22_;
		ChessClock* _tmp23_;
		gint _tmp24_;
		gint _tmp25_;
		guint black_extra;
		ChessGame* _tmp26_;
		ChessClock* _tmp27_;
		ChessClock* _tmp28_;
		gint _tmp29_;
		gint _tmp30_;
		PGNGame* _tmp31_;
		guint _tmp32_;
		guint _tmp33_;
		guint _tmp34_;
		gchar* _tmp35_;
		gchar* _tmp36_;
		PGNGame* _tmp37_;
		guint _tmp38_;
		guint _tmp39_;
		guint _tmp40_;
		gchar* _tmp41_;
		gchar* _tmp42_;
#line 2266 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp3_ = self->priv->pgn_game;
#line 2266 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp4_ = pgn_game_get_white_time_left (_tmp3_);
#line 2266 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp5_ = _tmp4_;
#line 2266 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp6_ = atoi (_tmp5_);
#line 2266 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		white_initial_time = (guint) _tmp6_;
#line 2267 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp7_ = self->priv->pgn_game;
#line 2267 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp8_ = pgn_game_get_black_time_left (_tmp7_);
#line 2267 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp9_ = _tmp8_;
#line 2267 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp10_ = atoi (_tmp9_);
#line 2267 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		black_initial_time = (guint) _tmp10_;
#line 2269 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp11_ = self->priv->game;
#line 2269 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp12_ = chess_game_get_clock (_tmp11_);
#line 2269 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp13_ = _tmp12_;
#line 2269 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp14_ = chess_clock_get_white_seconds_used (_tmp13_);
#line 2269 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp15_ = _tmp14_;
#line 2269 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		white_used = (guint) _tmp15_;
#line 2270 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp16_ = self->priv->game;
#line 2270 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp17_ = chess_game_get_clock (_tmp16_);
#line 2270 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp18_ = _tmp17_;
#line 2270 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp19_ = chess_clock_get_black_seconds_used (_tmp18_);
#line 2270 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp20_ = _tmp19_;
#line 2270 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		black_used = (guint) _tmp20_;
#line 2272 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp21_ = self->priv->game;
#line 2272 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp22_ = chess_game_get_clock (_tmp21_);
#line 2272 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp23_ = _tmp22_;
#line 2272 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp24_ = chess_clock_get_white_extra_seconds (_tmp23_);
#line 2272 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp25_ = _tmp24_;
#line 2272 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		white_extra = (guint) _tmp25_;
#line 2273 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp26_ = self->priv->game;
#line 2273 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp27_ = chess_game_get_clock (_tmp26_);
#line 2273 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp28_ = _tmp27_;
#line 2273 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp29_ = chess_clock_get_black_extra_seconds (_tmp28_);
#line 2273 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp30_ = _tmp29_;
#line 2273 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		black_extra = (guint) _tmp30_;
#line 2275 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp31_ = self->priv->pgn_game;
#line 2275 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp32_ = white_initial_time;
#line 2275 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp33_ = white_used;
#line 2275 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp34_ = white_extra;
#line 2275 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp35_ = g_strdup_printf ("%u", (_tmp32_ - _tmp33_) + _tmp34_);
#line 2275 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp36_ = _tmp35_;
#line 2275 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		pgn_game_set_white_time_left (_tmp31_, _tmp36_);
#line 2275 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_g_free0 (_tmp36_);
#line 2276 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp37_ = self->priv->pgn_game;
#line 2276 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp38_ = black_initial_time;
#line 2276 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp39_ = black_used;
#line 2276 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp40_ = black_extra;
#line 2276 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp41_ = g_strdup_printf ("%u", (_tmp38_ - _tmp39_) + _tmp40_);
#line 2276 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp42_ = _tmp41_;
#line 2276 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		pgn_game_set_black_time_left (_tmp37_, _tmp42_);
#line 2276 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_g_free0 (_tmp42_);
#line 12086 "gnome-chess.c"
	}
}


static void chess_application_save_dialog_cb (ChessApplication* self, gint response_id) {
	gint _tmp0_;
	GtkFileChooserDialog* _tmp14_;
	GError * _inner_error_ = NULL;
#line 2280 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 2282 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = response_id;
#line 2282 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp0_ == ((gint) GTK_RESPONSE_OK)) {
#line 2284 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		chess_application_update_pgn_time_remaining (self);
#line 12103 "gnome-chess.c"
		{
			GtkFileChooserDialog* _tmp1_;
			GFile* _tmp2_;
			PGNGame* _tmp3_;
			GFile* _tmp4_;
			GtkHeaderBar* _tmp5_;
			GFile* _tmp6_;
			gchar* _tmp7_;
			gchar* _tmp8_;
#line 2288 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp1_ = self->priv->save_dialog;
#line 2288 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp2_ = gtk_file_chooser_get_file ((GtkFileChooser*) _tmp1_);
#line 2288 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_g_object_unref0 (self->priv->game_file);
#line 2288 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			self->priv->game_file = _tmp2_;
#line 2289 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp3_ = self->priv->pgn_game;
#line 2289 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp4_ = self->priv->game_file;
#line 2289 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			pgn_game_write (_tmp3_, _tmp4_, &_inner_error_);
#line 2289 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 12129 "gnome-chess.c"
				goto __catch5_g_error;
			}
#line 2290 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp5_ = self->priv->headerbar;
#line 2290 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp6_ = self->priv->game_file;
#line 2290 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp7_ = g_file_get_basename (_tmp6_);
#line 2290 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp8_ = _tmp7_;
#line 2290 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			gtk_header_bar_set_subtitle (_tmp5_, _tmp8_);
#line 2290 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_g_free0 (_tmp8_);
#line 2291 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			chess_application_disable_window_action (self, CHESS_APPLICATION_SAVE_GAME_ACTION_NAME);
#line 2292 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			self->priv->game_needs_saving = FALSE;
#line 12148 "gnome-chess.c"
		}
		goto __finally5;
		__catch5_g_error:
		{
			GError* e = NULL;
			GError* _tmp9_;
			const gchar* _tmp10_;
			GtkLabel* _tmp11_;
			GtkInfoBar* _tmp12_;
			GtkInfoBar* _tmp13_;
#line 2286 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			e = _inner_error_;
#line 2286 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_inner_error_ = NULL;
#line 2296 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp9_ = e;
#line 2296 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp10_ = _tmp9_->message;
#line 2296 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			g_warning ("gnome-chess.vala:2296: Failed to save game: %s", _tmp10_);
#line 2297 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp11_ = self->priv->save_dialog_error_label;
#line 2297 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			gtk_label_set_text (_tmp11_, _ ("Failed to save game"));
#line 2298 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp12_ = self->priv->save_dialog_info_bar;
#line 2298 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			gtk_info_bar_set_message_type (_tmp12_, GTK_MESSAGE_ERROR);
#line 2299 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp13_ = self->priv->save_dialog_info_bar;
#line 2299 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			gtk_widget_show ((GtkWidget*) _tmp13_);
#line 2300 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_g_error_free0 (e);
#line 2300 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			return;
#line 12185 "gnome-chess.c"
		}
		__finally5:
#line 2286 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2286 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2286 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			g_clear_error (&_inner_error_);
#line 2286 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			return;
#line 12196 "gnome-chess.c"
		}
	}
#line 2304 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp14_ = self->priv->save_dialog;
#line 2304 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp14_);
#line 2305 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->save_dialog);
#line 2305 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	self->priv->save_dialog = NULL;
#line 2306 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->save_dialog_info_bar);
#line 2306 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	self->priv->save_dialog_info_bar = NULL;
#line 2307 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->save_dialog_error_label);
#line 2307 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	self->priv->save_dialog_error_label = NULL;
#line 12215 "gnome-chess.c"
}


static void __lambda6_ (ChessApplication* self) {
#line 2327 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	chess_application_save_dialog_cb (self, (gint) GTK_RESPONSE_OK);
#line 12222 "gnome-chess.c"
}


static void ___lambda6__gtk_file_chooser_file_activated (GtkFileChooser* _sender, gpointer self) {
#line 2327 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	__lambda6_ ((ChessApplication*) self);
#line 12229 "gnome-chess.c"
}


static void _chess_application_save_dialog_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
#line 2328 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	chess_application_save_dialog_cb ((ChessApplication*) self, response_id);
#line 12236 "gnome-chess.c"
}


static void chess_application_present_save_dialog (ChessApplication* self, const gchar* cancel_button_label, const gchar* save_button_label) {
	GtkFileChooserDialog* _tmp0_;
	GtkApplicationWindow* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GtkFileChooserDialog* _tmp5_;
	GtkFileChooserDialog* _tmp6_;
	GtkInfoBar* _tmp7_ = NULL;
	GtkLabel* _tmp8_ = NULL;
	GtkFileChooserDialog* _tmp9_;
	GtkFileChooserDialog* _tmp10_;
	gboolean _tmp11_ = FALSE;
	GFile* _tmp12_;
	GtkFileFilter* pgn_filter;
	GtkFileFilter* _tmp24_;
	GtkFileFilter* _tmp25_;
	GtkFileFilter* _tmp26_;
	GtkFileChooserDialog* _tmp27_;
	GtkFileFilter* _tmp28_;
	GtkFileFilter* _tmp29_;
	GtkFileFilter* all_filter;
	GtkFileFilter* _tmp30_;
	GtkFileFilter* _tmp31_;
	GtkFileFilter* _tmp32_;
	GtkFileChooserDialog* _tmp33_;
	GtkFileFilter* _tmp34_;
	GtkFileFilter* _tmp35_;
	GtkFileChooserDialog* _tmp36_;
#line 2310 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 2310 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (cancel_button_label != NULL);
#line 2310 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (save_button_label != NULL);
#line 2314 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->save_dialog;
#line 2314 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp0_ != NULL) {
#line 12278 "gnome-chess.c"
		GtkFileChooserDialog* _tmp1_;
#line 2316 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp1_ = self->priv->save_dialog;
#line 2316 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		gtk_dialog_run ((GtkDialog*) _tmp1_);
#line 2317 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		return;
#line 12286 "gnome-chess.c"
	}
#line 2320 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = self->priv->window;
#line 2320 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = cancel_button_label;
#line 2320 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = save_button_label;
#line 2320 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = (GtkFileChooserDialog*) gtk_file_chooser_dialog_new (_ ("Save Chess Game"), (GtkWindow*) _tmp2_, GTK_FILE_CHOOSER_ACTION_SAVE, _ (_tmp3_), GTK_RESPONSE_CANCEL, _ (_tmp4_), GTK_RESPONSE_OK, NULL, NULL);
#line 2320 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_object_ref_sink (_tmp5_);
#line 2320 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->save_dialog);
#line 2320 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	self->priv->save_dialog = _tmp5_;
#line 2325 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = self->priv->save_dialog;
#line 2325 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	chess_application_add_info_bar_to_bin (self, (GtkBin*) _tmp6_, &_tmp7_, &_tmp8_);
#line 2325 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->save_dialog_info_bar);
#line 2325 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	self->priv->save_dialog_info_bar = _tmp7_;
#line 2325 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->save_dialog_error_label);
#line 2325 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	self->priv->save_dialog_error_label = _tmp8_;
#line 2327 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp9_ = self->priv->save_dialog;
#line 2327 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_signal_connect_object ((GtkFileChooser*) _tmp9_, "file-activated", (GCallback) ___lambda6__gtk_file_chooser_file_activated, self, 0);
#line 2328 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp10_ = self->priv->save_dialog;
#line 2328 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_signal_connect_object ((GtkDialog*) _tmp10_, "response", (GCallback) _chess_application_save_dialog_cb_gtk_dialog_response, self, 0);
#line 2330 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp12_ = self->priv->game_file;
#line 2330 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp12_ != NULL) {
#line 12326 "gnome-chess.c"
		GFile* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		const gchar* _tmp16_;
#line 2330 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp13_ = self->priv->game_file;
#line 2330 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp14_ = g_file_get_path (_tmp13_);
#line 2330 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp15_ = _tmp14_;
#line 2330 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp16_ = self->priv->autosave_filename;
#line 2330 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp11_ = g_strcmp0 (_tmp15_, _tmp16_) != 0;
#line 2330 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_g_free0 (_tmp15_);
#line 12343 "gnome-chess.c"
	} else {
#line 2330 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp11_ = FALSE;
#line 12347 "gnome-chess.c"
	}
#line 2330 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp11_) {
#line 12351 "gnome-chess.c"
		GtkFileChooserDialog* _tmp17_;
		GFile* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
#line 2331 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp17_ = self->priv->save_dialog;
#line 2331 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp18_ = self->priv->game_file;
#line 2331 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp19_ = g_file_get_path (_tmp18_);
#line 2331 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp20_ = _tmp19_;
#line 2331 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		gtk_file_chooser_set_filename ((GtkFileChooser*) _tmp17_, _tmp20_);
#line 2331 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_g_free0 (_tmp20_);
#line 12368 "gnome-chess.c"
	} else {
		GtkFileChooserDialog* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
#line 2333 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp21_ = self->priv->save_dialog;
#line 2333 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp22_ = g_strconcat (_ ("Untitled Chess Game"), ".pgn", NULL);
#line 2333 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp23_ = _tmp22_;
#line 2333 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		gtk_file_chooser_set_current_name ((GtkFileChooser*) _tmp21_, _tmp23_);
#line 2333 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_g_free0 (_tmp23_);
#line 12383 "gnome-chess.c"
	}
#line 2337 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp24_ = gtk_file_filter_new ();
#line 2337 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_object_ref_sink (_tmp24_);
#line 2337 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	pgn_filter = _tmp24_;
#line 2339 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp25_ = pgn_filter;
#line 2339 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_file_filter_set_name (_tmp25_, _ ("PGN files"));
#line 2340 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp26_ = pgn_filter;
#line 2340 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_file_filter_add_pattern (_tmp26_, "*.pgn");
#line 2341 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp27_ = self->priv->save_dialog;
#line 2341 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp28_ = pgn_filter;
#line 2341 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp29_ = _g_object_ref0 (_tmp28_);
#line 2341 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_file_chooser_add_filter ((GtkFileChooser*) _tmp27_, _tmp29_);
#line 2343 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp30_ = gtk_file_filter_new ();
#line 2343 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_object_ref_sink (_tmp30_);
#line 2343 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	all_filter = _tmp30_;
#line 2345 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp31_ = all_filter;
#line 2345 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_file_filter_set_name (_tmp31_, _ ("All files"));
#line 2346 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp32_ = all_filter;
#line 2346 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_file_filter_add_pattern (_tmp32_, "*");
#line 2347 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp33_ = self->priv->save_dialog;
#line 2347 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp34_ = all_filter;
#line 2347 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp35_ = _g_object_ref0 (_tmp34_);
#line 2347 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_file_chooser_add_filter ((GtkFileChooser*) _tmp33_, _tmp35_);
#line 2349 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp36_ = self->priv->save_dialog;
#line 2349 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_dialog_run ((GtkDialog*) _tmp36_);
#line 2310 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (all_filter);
#line 2310 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (pgn_filter);
#line 12437 "gnome-chess.c"
}


void chess_application_save_game_cb (ChessApplication* self) {
	gboolean _tmp0_ = FALSE;
	GFile* _tmp1_;
	GError * _inner_error_ = NULL;
#line 2352 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 2354 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = self->priv->game_file;
#line 2354 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp1_ == NULL) {
#line 2354 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp0_ = TRUE;
#line 12453 "gnome-chess.c"
	} else {
		GFile* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		const gchar* _tmp5_;
#line 2354 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp2_ = self->priv->game_file;
#line 2354 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp3_ = g_file_get_path (_tmp2_);
#line 2354 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp4_ = _tmp3_;
#line 2354 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp5_ = self->priv->autosave_filename;
#line 2354 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp0_ = g_strcmp0 (_tmp4_, _tmp5_) == 0;
#line 2354 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_g_free0 (_tmp4_);
#line 12471 "gnome-chess.c"
	}
#line 2354 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp0_) {
#line 2356 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		chess_application_present_save_dialog (self, N_ ("_Cancel"), N_ ("_Save"));
#line 2357 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		return;
#line 12479 "gnome-chess.c"
	}
#line 2360 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	chess_application_update_pgn_time_remaining (self);
#line 12483 "gnome-chess.c"
	{
		PGNGame* _tmp6_;
		GFile* _tmp7_;
#line 2364 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp6_ = self->priv->pgn_game;
#line 2364 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp7_ = self->priv->game_file;
#line 2364 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		pgn_game_write (_tmp6_, _tmp7_, &_inner_error_);
#line 2364 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 12495 "gnome-chess.c"
			goto __catch6_g_error;
		}
#line 2365 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		chess_application_disable_window_action (self, CHESS_APPLICATION_SAVE_GAME_ACTION_NAME);
#line 12500 "gnome-chess.c"
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError* e = NULL;
#line 2362 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		e = _inner_error_;
#line 2362 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_inner_error_ = NULL;
#line 2369 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		chess_application_present_save_dialog (self, N_ ("_Cancel"), N_ ("_Save"));
#line 2362 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_g_error_free0 (e);
#line 12514 "gnome-chess.c"
	}
	__finally6:
#line 2362 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2362 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2362 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		g_clear_error (&_inner_error_);
#line 2362 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		return;
#line 12525 "gnome-chess.c"
	}
}


void chess_application_save_game_as_cb (ChessApplication* self) {
#line 2373 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 2375 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	chess_application_present_save_dialog (self, N_ ("_Cancel"), N_ ("_Save"));
#line 12535 "gnome-chess.c"
}


static void __lambda9_ (ChessApplication* self) {
#line 2397 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	chess_application_open_dialog_cb (self, (gint) GTK_RESPONSE_OK);
#line 12542 "gnome-chess.c"
}


static void ___lambda9__gtk_file_chooser_file_activated (GtkFileChooser* _sender, gpointer self) {
#line 2397 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	__lambda9_ ((ChessApplication*) self);
#line 12549 "gnome-chess.c"
}


static void _chess_application_open_dialog_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
#line 2398 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	chess_application_open_dialog_cb ((ChessApplication*) self, response_id);
#line 12556 "gnome-chess.c"
}


void chess_application_open_game_cb (ChessApplication* self) {
	gboolean _tmp0_;
	GtkFileChooserDialog* _tmp1_;
	GtkApplicationWindow* _tmp3_;
	GtkFileChooserDialog* _tmp4_;
	GtkFileChooserDialog* _tmp5_;
	GtkInfoBar* _tmp6_ = NULL;
	GtkLabel* _tmp7_ = NULL;
	GtkFileChooserDialog* _tmp8_;
	GtkFileChooserDialog* _tmp9_;
	GtkFileFilter* pgn_filter;
	GtkFileFilter* _tmp10_;
	GtkFileFilter* _tmp11_;
	GtkFileFilter* _tmp12_;
	GtkFileChooserDialog* _tmp13_;
	GtkFileFilter* _tmp14_;
	GtkFileFilter* _tmp15_;
	GtkFileFilter* all_filter;
	GtkFileFilter* _tmp16_;
	GtkFileFilter* _tmp17_;
	GtkFileFilter* _tmp18_;
	GtkFileChooserDialog* _tmp19_;
	GtkFileFilter* _tmp20_;
	GtkFileFilter* _tmp21_;
	GtkFileChooserDialog* _tmp22_;
#line 2378 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 2380 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = chess_application_prompt_save_game (self, _ ("Save this game before loading another one?"));
#line 2380 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (!_tmp0_) {
#line 2381 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		return;
#line 12593 "gnome-chess.c"
	}
#line 2384 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = self->priv->open_dialog;
#line 2384 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp1_ != NULL) {
#line 12599 "gnome-chess.c"
		GtkFileChooserDialog* _tmp2_;
#line 2386 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp2_ = self->priv->open_dialog;
#line 2386 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		gtk_window_present ((GtkWindow*) _tmp2_);
#line 2387 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		return;
#line 12607 "gnome-chess.c"
	}
#line 2390 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = self->priv->window;
#line 2390 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = (GtkFileChooserDialog*) gtk_file_chooser_dialog_new (_ ("Load Chess Game"), (GtkWindow*) _tmp3_, GTK_FILE_CHOOSER_ACTION_OPEN, _ ("_Cancel"), GTK_RESPONSE_CANCEL, _ ("_Open"), GTK_RESPONSE_OK, NULL, NULL);
#line 2390 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_object_ref_sink (_tmp4_);
#line 2390 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->open_dialog);
#line 2390 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	self->priv->open_dialog = _tmp4_;
#line 2395 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = self->priv->open_dialog;
#line 2395 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	chess_application_add_info_bar_to_bin (self, (GtkBin*) _tmp5_, &_tmp6_, &_tmp7_);
#line 2395 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->open_dialog_info_bar);
#line 2395 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	self->priv->open_dialog_info_bar = _tmp6_;
#line 2395 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->open_dialog_error_label);
#line 2395 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	self->priv->open_dialog_error_label = _tmp7_;
#line 2397 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp8_ = self->priv->open_dialog;
#line 2397 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_signal_connect_object ((GtkFileChooser*) _tmp8_, "file-activated", (GCallback) ___lambda9__gtk_file_chooser_file_activated, self, 0);
#line 2398 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp9_ = self->priv->open_dialog;
#line 2398 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_signal_connect_object ((GtkDialog*) _tmp9_, "response", (GCallback) _chess_application_open_dialog_cb_gtk_dialog_response, self, 0);
#line 2401 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp10_ = gtk_file_filter_new ();
#line 2401 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_object_ref_sink (_tmp10_);
#line 2401 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	pgn_filter = _tmp10_;
#line 2403 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp11_ = pgn_filter;
#line 2403 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_file_filter_set_name (_tmp11_, _ ("PGN files"));
#line 2404 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp12_ = pgn_filter;
#line 2404 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_file_filter_add_pattern (_tmp12_, "*.pgn");
#line 2405 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp13_ = self->priv->open_dialog;
#line 2405 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp14_ = pgn_filter;
#line 2405 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp15_ = _g_object_ref0 (_tmp14_);
#line 2405 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_file_chooser_add_filter ((GtkFileChooser*) _tmp13_, _tmp15_);
#line 2407 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp16_ = gtk_file_filter_new ();
#line 2407 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_object_ref_sink (_tmp16_);
#line 2407 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	all_filter = _tmp16_;
#line 2409 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp17_ = all_filter;
#line 2409 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_file_filter_set_name (_tmp17_, _ ("All files"));
#line 2410 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp18_ = all_filter;
#line 2410 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_file_filter_add_pattern (_tmp18_, "*");
#line 2411 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp19_ = self->priv->open_dialog;
#line 2411 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp20_ = all_filter;
#line 2411 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp21_ = _g_object_ref0 (_tmp20_);
#line 2411 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_file_chooser_add_filter ((GtkFileChooser*) _tmp19_, _tmp21_);
#line 2413 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp22_ = self->priv->open_dialog;
#line 2413 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_window_present ((GtkWindow*) _tmp22_);
#line 2378 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (all_filter);
#line 2378 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (pgn_filter);
#line 12691 "gnome-chess.c"
}


static void chess_application_open_dialog_cb (ChessApplication* self, gint response_id) {
	gint _tmp0_;
	GtkFileChooserDialog* _tmp9_;
	GError * _inner_error_ = NULL;
#line 2416 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 2418 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = response_id;
#line 2418 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp0_ == ((gint) GTK_RESPONSE_OK)) {
#line 12705 "gnome-chess.c"
		{
			GtkFileChooserDialog* _tmp1_;
			GFile* _tmp2_;
			GFile* _tmp3_;
#line 2422 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp1_ = self->priv->open_dialog;
#line 2422 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp2_ = gtk_file_chooser_get_file ((GtkFileChooser*) _tmp1_);
#line 2422 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_g_object_unref0 (self->priv->game_file);
#line 2422 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			self->priv->game_file = _tmp2_;
#line 2423 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp3_ = self->priv->game_file;
#line 2423 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			chess_application_load_game (self, _tmp3_, &_inner_error_);
#line 2423 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 12724 "gnome-chess.c"
				goto __catch7_g_error;
			}
		}
		goto __finally7;
		__catch7_g_error:
		{
			GError* e = NULL;
			GError* _tmp4_;
			const gchar* _tmp5_;
			GtkLabel* _tmp6_;
			GtkInfoBar* _tmp7_;
			GtkInfoBar* _tmp8_;
#line 2420 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			e = _inner_error_;
#line 2420 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_inner_error_ = NULL;
#line 2427 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp4_ = e;
#line 2427 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp5_ = _tmp4_->message;
#line 2427 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			g_warning ("gnome-chess.vala:2427: Failed to open game: %s", _tmp5_);
#line 2428 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp6_ = self->priv->open_dialog_error_label;
#line 2428 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			gtk_label_set_text (_tmp6_, _ ("Failed to open game"));
#line 2429 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp7_ = self->priv->open_dialog_info_bar;
#line 2429 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			gtk_info_bar_set_message_type (_tmp7_, GTK_MESSAGE_ERROR);
#line 2430 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp8_ = self->priv->open_dialog_info_bar;
#line 2430 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			gtk_widget_show ((GtkWidget*) _tmp8_);
#line 2431 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_g_error_free0 (e);
#line 2431 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			return;
#line 12763 "gnome-chess.c"
		}
		__finally7:
#line 2420 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2420 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2420 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			g_clear_error (&_inner_error_);
#line 2420 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			return;
#line 12774 "gnome-chess.c"
		}
	}
#line 2435 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp9_ = self->priv->open_dialog;
#line 2435 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp9_);
#line 2436 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->open_dialog);
#line 2436 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	self->priv->open_dialog = NULL;
#line 2437 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->open_dialog_info_bar);
#line 2437 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	self->priv->open_dialog_info_bar = NULL;
#line 2438 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->open_dialog_error_label);
#line 2438 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	self->priv->open_dialog_error_label = NULL;
#line 12793 "gnome-chess.c"
}


static void chess_application_start_new_game (ChessApplication* self) {
	PGNGame* _tmp0_;
	GDateTime* now;
	GDateTime* _tmp1_;
	PGNGame* _tmp2_;
	GDateTime* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	PGNGame* _tmp6_;
	GDateTime* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gint duration;
	GSettings* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	gchar* engine_name;
	GSettings* _tmp25_;
	gchar* _tmp26_;
	const gchar* _tmp27_;
	gchar* engine_level;
	GSettings* _tmp35_;
	gchar* _tmp36_;
	gboolean _tmp37_ = FALSE;
	const gchar* _tmp38_;
#line 2441 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 2443 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->game_file);
#line 2443 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	self->priv->game_file = NULL;
#line 2445 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	chess_application_disable_window_action (self, CHESS_APPLICATION_NEW_GAME_ACTION_NAME);
#line 2446 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	chess_application_disable_window_action (self, CHESS_APPLICATION_SAVE_GAME_AS_ACTION_NAME);
#line 2448 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = pgn_game_new ();
#line 2448 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->pgn_game);
#line 2448 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	self->priv->pgn_game = _tmp0_;
#line 2449 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = g_date_time_new_now_local ();
#line 2449 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	now = _tmp1_;
#line 2450 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = self->priv->pgn_game;
#line 2450 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = now;
#line 2450 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = g_date_time_format (_tmp3_, "%Y.%m.%d");
#line 2450 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = _tmp4_;
#line 2450 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	pgn_game_set_date (_tmp2_, _tmp5_);
#line 2450 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_free0 (_tmp5_);
#line 2451 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = self->priv->pgn_game;
#line 2451 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = now;
#line 2451 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp8_ = g_date_time_format (_tmp7_, "%H:%M:%S");
#line 2451 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp9_ = _tmp8_;
#line 2451 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	pgn_game_set_time (_tmp6_, _tmp9_);
#line 2451 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_free0 (_tmp9_);
#line 2452 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp10_ = self->priv->settings;
#line 2452 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp11_ = g_settings_get_int (_tmp10_, "duration");
#line 2452 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	duration = _tmp11_;
#line 2453 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp12_ = duration;
#line 2453 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp12_ > 0) {
#line 12876 "gnome-chess.c"
		PGNGame* _tmp13_;
		gint _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		PGNGame* _tmp17_;
		gint _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		PGNGame* _tmp21_;
		gint _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
#line 2455 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp13_ = self->priv->pgn_game;
#line 2455 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp14_ = duration;
#line 2455 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp15_ = g_strdup_printf ("%i", _tmp14_);
#line 2455 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp16_ = _tmp15_;
#line 2455 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		pgn_game_set_time_control (_tmp13_, _tmp16_);
#line 2455 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_g_free0 (_tmp16_);
#line 2456 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp17_ = self->priv->pgn_game;
#line 2456 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp18_ = duration;
#line 2456 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp19_ = g_strdup_printf ("%i", _tmp18_);
#line 2456 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp20_ = _tmp19_;
#line 2456 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		pgn_game_set_white_time_left (_tmp17_, _tmp20_);
#line 2456 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_g_free0 (_tmp20_);
#line 2457 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp21_ = self->priv->pgn_game;
#line 2457 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp22_ = duration;
#line 2457 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp23_ = g_strdup_printf ("%i", _tmp22_);
#line 2457 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp24_ = _tmp23_;
#line 2457 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		pgn_game_set_black_time_left (_tmp21_, _tmp24_);
#line 2457 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_g_free0 (_tmp24_);
#line 12925 "gnome-chess.c"
	}
#line 2459 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp25_ = self->priv->settings;
#line 2459 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp26_ = g_settings_get_string (_tmp25_, "opponent");
#line 2459 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	engine_name = _tmp26_;
#line 2460 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp27_ = engine_name;
#line 2460 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (g_strcmp0 (_tmp27_, "") == 0) {
#line 12937 "gnome-chess.c"
		GList* _tmp28_;
#line 2462 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp28_ = self->priv->ai_profiles;
#line 2462 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		if (_tmp28_ != NULL) {
#line 12943 "gnome-chess.c"
			GList* _tmp29_;
			gconstpointer _tmp30_;
			const gchar* _tmp31_;
			const gchar* _tmp32_;
			gchar* _tmp33_;
#line 2463 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp29_ = self->priv->ai_profiles;
#line 2463 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp30_ = _tmp29_->data;
#line 2463 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp31_ = ai_profile_get_name ((AIProfile*) _tmp30_);
#line 2463 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp32_ = _tmp31_;
#line 2463 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp33_ = g_strdup (_tmp32_);
#line 2463 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_g_free0 (engine_name);
#line 2463 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			engine_name = _tmp33_;
#line 12963 "gnome-chess.c"
		} else {
			gchar* _tmp34_;
#line 2465 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp34_ = g_strdup ("human");
#line 2465 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_g_free0 (engine_name);
#line 2465 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			engine_name = _tmp34_;
#line 12972 "gnome-chess.c"
		}
	}
#line 2467 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp35_ = self->priv->settings;
#line 2467 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp36_ = g_settings_get_string (_tmp35_, "difficulty");
#line 2467 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	engine_level = _tmp36_;
#line 2468 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp38_ = engine_name;
#line 2468 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp38_ != NULL) {
#line 12985 "gnome-chess.c"
		const gchar* _tmp39_;
#line 2468 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp39_ = engine_name;
#line 2468 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp37_ = g_strcmp0 (_tmp39_, "human") != 0;
#line 12991 "gnome-chess.c"
	} else {
#line 2468 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp37_ = FALSE;
#line 12995 "gnome-chess.c"
	}
#line 2468 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp37_) {
#line 12999 "gnome-chess.c"
		gchar* play_as;
		GSettings* _tmp40_;
		gchar* _tmp41_;
		const gchar* _tmp42_;
		const gchar* _tmp48_;
		GSettings* _tmp58_;
		const gchar* _tmp59_;
#line 2470 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp40_ = self->priv->settings;
#line 2470 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp41_ = g_settings_get_string (_tmp40_, "play-as");
#line 2470 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		play_as = _tmp41_;
#line 2472 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp42_ = play_as;
#line 2472 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		if (g_strcmp0 (_tmp42_, "alternate") == 0) {
#line 13017 "gnome-chess.c"
			gchar* last_side;
			GSettings* _tmp43_;
			gchar* _tmp44_;
			const gchar* _tmp45_ = NULL;
			const gchar* _tmp46_;
			gchar* _tmp47_;
#line 2474 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp43_ = self->priv->settings;
#line 2474 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp44_ = g_settings_get_string (_tmp43_, "last-played-as");
#line 2474 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			last_side = _tmp44_;
#line 2475 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp46_ = last_side;
#line 2475 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			if (g_strcmp0 (_tmp46_, "white") == 0) {
#line 2475 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp45_ = "black";
#line 13036 "gnome-chess.c"
			} else {
#line 2475 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp45_ = "white";
#line 13040 "gnome-chess.c"
			}
#line 2475 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp47_ = g_strdup (_tmp45_);
#line 2475 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_g_free0 (play_as);
#line 2475 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			play_as = _tmp47_;
#line 2472 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_g_free0 (last_side);
#line 13050 "gnome-chess.c"
		}
#line 2478 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp48_ = play_as;
#line 2478 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		if (g_strcmp0 (_tmp48_, "white") == 0) {
#line 13056 "gnome-chess.c"
			PGNGame* _tmp49_;
			const gchar* _tmp50_;
			PGNGame* _tmp51_;
			const gchar* _tmp52_;
#line 2480 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp49_ = self->priv->pgn_game;
#line 2480 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp50_ = engine_name;
#line 2480 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			pgn_game_set_black_ai (_tmp49_, _tmp50_);
#line 2481 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp51_ = self->priv->pgn_game;
#line 2481 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp52_ = engine_level;
#line 2481 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			pgn_game_set_black_level (_tmp51_, _tmp52_);
#line 13073 "gnome-chess.c"
		} else {
			const gchar* _tmp53_;
#line 2483 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			_tmp53_ = play_as;
#line 2483 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
			if (g_strcmp0 (_tmp53_, "black") == 0) {
#line 13080 "gnome-chess.c"
				PGNGame* _tmp54_;
				const gchar* _tmp55_;
				PGNGame* _tmp56_;
				const gchar* _tmp57_;
#line 2485 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp54_ = self->priv->pgn_game;
#line 2485 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp55_ = engine_name;
#line 2485 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				pgn_game_set_white_ai (_tmp54_, _tmp55_);
#line 2486 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp56_ = self->priv->pgn_game;
#line 2486 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				_tmp57_ = engine_level;
#line 2486 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				pgn_game_set_white_level (_tmp56_, _tmp57_);
#line 13097 "gnome-chess.c"
			} else {
#line 2490 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
				g_assert_not_reached ();
#line 13101 "gnome-chess.c"
			}
		}
#line 2493 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp58_ = self->priv->settings;
#line 2493 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp59_ = play_as;
#line 2493 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		g_settings_set_string (_tmp58_, "last-played-as", _tmp59_);
#line 2468 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_g_free0 (play_as);
#line 13112 "gnome-chess.c"
	}
#line 2496 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	chess_application_start_game (self);
#line 2441 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_free0 (engine_level);
#line 2441 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_free0 (engine_name);
#line 2441 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_date_time_unref0 (now);
#line 13122 "gnome-chess.c"
}


static void chess_application_load_game (ChessApplication* self, GFile* file, GError** error) {
	PGN* pgn;
	GFile* _tmp0_;
	PGN* _tmp1_;
	GList* _tmp2_;
	gconstpointer _tmp3_;
	PGNGame* _tmp4_;
	PGNGame* _tmp5_;
	GError * _inner_error_ = NULL;
#line 2499 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 2499 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (file != NULL);
#line 2501 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	chess_application_enable_window_action (self, CHESS_APPLICATION_NEW_GAME_ACTION_NAME);
#line 2503 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = file;
#line 2503 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = pgn_new_from_file (_tmp0_, &_inner_error_);
#line 2503 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	pgn = _tmp1_;
#line 2503 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2503 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		g_propagate_error (error, _inner_error_);
#line 2503 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		return;
#line 13153 "gnome-chess.c"
	}
#line 2504 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = pgn->games;
#line 2504 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = g_list_nth_data (_tmp2_, (guint) 0);
#line 2504 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = _g_object_ref0 ((PGNGame*) _tmp3_);
#line 2504 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->pgn_game);
#line 2504 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	self->priv->pgn_game = _tmp4_;
#line 2506 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = self->priv->pgn_game;
#line 2506 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	if (_tmp5_ == NULL) {
#line 13169 "gnome-chess.c"
		PGNGame* _tmp6_;
#line 2508 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		chess_application_run_invalid_pgn_dialog (self);
#line 2509 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp6_ = pgn_game_new ();
#line 2509 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (self->priv->pgn_game);
#line 2509 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		self->priv->pgn_game = _tmp6_;
#line 2510 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (self->priv->game_file);
#line 2510 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		self->priv->game_file = NULL;
#line 13183 "gnome-chess.c"
	} else {
		GFile* _tmp7_;
		GFile* _tmp8_;
#line 2514 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp7_ = file;
#line 2514 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_tmp8_ = _g_object_ref0 (_tmp7_);
#line 2514 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (self->priv->game_file);
#line 2514 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		self->priv->game_file = _tmp8_;
#line 2515 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
		chess_application_start_game (self);
#line 13197 "gnome-chess.c"
	}
#line 2499 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (pgn);
#line 13201 "gnome-chess.c"
}


static void chess_application_enable_window_action (ChessApplication* self, const gchar* name) {
	GtkApplicationWindow* _tmp0_;
	const gchar* _tmp1_;
	GAction* _tmp2_;
#line 2519 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 2519 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (name != NULL);
#line 2521 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->window;
#line 2521 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = name;
#line 2521 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = g_action_map_lookup_action ((GActionMap*) _tmp0_, _tmp1_);
#line 2521 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, g_simple_action_get_type (), GSimpleAction), TRUE);
#line 13221 "gnome-chess.c"
}


static void chess_application_disable_window_action (ChessApplication* self, const gchar* name) {
	GtkApplicationWindow* _tmp0_;
	const gchar* _tmp1_;
	GAction* _tmp2_;
#line 2524 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 2524 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (name != NULL);
#line 2526 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->window;
#line 2526 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = name;
#line 2526 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = g_action_map_lookup_action ((GActionMap*) _tmp0_, _tmp1_);
#line 2526 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, g_simple_action_get_type (), GSimpleAction), FALSE);
#line 13241 "gnome-chess.c"
}


gint chess_application_main (gchar** args, int args_length1) {
	gint result = 0;
	ChessApplication* _tmp0_;
	ChessApplication* _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gint _tmp3_;
	gint _tmp4_;
#line 2531 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	setlocale (LC_ALL, "");
#line 2532 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
#line 2533 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
#line 2534 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	textdomain (GETTEXT_PACKAGE);
#line 2536 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_set_application_name (_ ("Chess"));
#line 2537 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	gtk_window_set_default_icon_name ("gnome-chess");
#line 2539 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = chess_application_new ();
#line 2539 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = _tmp0_;
#line 2539 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = args;
#line 2539 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp2__length1 = args_length1;
#line 2539 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = g_application_run ((GApplication*) _tmp1_, _tmp2__length1, _tmp2_);
#line 2539 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = _tmp3_;
#line 2539 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (_tmp1_);
#line 2539 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	result = _tmp4_;
#line 2539 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	return result;
#line 13283 "gnome-chess.c"
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
#line 2529 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	return chess_application_main (argv, argc);
#line 13293 "gnome-chess.c"
}


static void chess_application_class_init (ChessApplicationClass * klass) {
#line 14 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	chess_application_parent_class = g_type_class_peek_parent (klass);
#line 14 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	g_type_class_add_private (klass, sizeof (ChessApplicationPrivate));
#line 14 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	((GApplicationClass *) klass)->handle_local_options = (gint (*) (GApplication *, GVariantDict*)) chess_application_real_handle_local_options;
#line 14 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	((GApplicationClass *) klass)->startup = (void (*) (GApplication *)) chess_application_real_startup;
#line 14 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	((GApplicationClass *) klass)->open = (void (*) (GApplication *, GFile**, int, const gchar*)) chess_application_real_open;
#line 14 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	((GApplicationClass *) klass)->activate = (void (*) (GApplication *)) chess_application_real_activate;
#line 14 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	((GApplicationClass *) klass)->shutdown = (void (*) (GApplication *)) chess_application_real_shutdown;
#line 14 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	G_OBJECT_CLASS (klass)->finalize = chess_application_finalize;
#line 13314 "gnome-chess.c"
}


static void chess_application_instance_init (ChessApplication * self) {
	gchar* _tmp0_;
#line 14 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	self->priv = CHESS_APPLICATION_GET_PRIVATE (self);
#line 37 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	self->priv->preferences_dialog = NULL;
#line 48 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	self->priv->save_duration_timeout = (guint) 0;
#line 49 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	self->priv->open_dialog = NULL;
#line 50 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	self->priv->open_dialog_info_bar = NULL;
#line 51 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	self->priv->open_dialog_error_label = NULL;
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	self->priv->save_dialog = NULL;
#line 53 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	self->priv->save_dialog_info_bar = NULL;
#line 54 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	self->priv->save_dialog_error_label = NULL;
#line 55 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	self->priv->about_dialog = NULL;
#line 61 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	self->priv->game_needs_saving = FALSE;
#line 62 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	self->priv->starting = TRUE;
#line 64 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	self->priv->opponent = NULL;
#line 65 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	self->priv->human_player = NULL;
#line 66 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	self->priv->opponent_engine = NULL;
#line 67 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	self->priv->engine_timeout_counter = 10;
#line 68 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = g_strdup ("Copyright \302\251 2010\342\200\2232013 Robert Ancell\n" \
"Copyright \302\251 2013\342\200\2232014 Michael Catanzaro\n" \
"Copyright \302\251 2015\342\200\2232016 Sahil Sareen");
#line 68 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	self->priv->copyrights = _tmp0_;
#line 13356 "gnome-chess.c"
}


static void chess_application_finalize (GObject * obj) {
	ChessApplication * self;
#line 14 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CHESS_APPLICATION, ChessApplication);
#line 21 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->settings);
#line 22 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->window);
#line 23 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->view_container);
#line 24 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->scene);
#line 25 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->view);
#line 26 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->pause_resume_button);
#line 27 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->first_move_button);
#line 28 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->prev_move_button);
#line 29 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->next_move_button);
#line 30 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->last_move_button);
#line 31 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->history_combo);
#line 32 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->white_time_label);
#line 33 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->black_time_label);
#line 34 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->timer_increment_label);
#line 35 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->headerbar);
#line 37 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->preferences_dialog);
#line 38 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->side_combo);
#line 39 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->difficulty_combo);
#line 40 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->duration_combo);
#line 41 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->clock_type_combo);
#line 42 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->duration_adjustment);
#line 43 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->timer_increment_adjustment);
#line 44 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->custom_duration_box);
#line 45 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->timer_increment_box);
#line 46 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->timer_increment_units_combo);
#line 47 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->custom_duration_units_combo);
#line 49 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->open_dialog);
#line 50 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->open_dialog_info_bar);
#line 51 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->open_dialog_error_label);
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->save_dialog);
#line 53 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->save_dialog_info_bar);
#line 54 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->save_dialog_error_label);
#line 55 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->about_dialog);
#line 57 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->pgn_game);
#line 58 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->game);
#line 59 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_free0 (self->priv->autosave_filename);
#line 60 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->game_file);
#line 63 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	__g_list_free__g_object_unref0_0 (self->priv->ai_profiles);
#line 64 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->opponent);
#line 65 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->human_player);
#line 66 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->opponent_engine);
#line 68 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	_g_free0 (self->priv->copyrights);
#line 14 "/home/mcatanzaro/Projects/GNOME/gnome-chess/src/gnome-chess.vala"
	G_OBJECT_CLASS (chess_application_parent_class)->finalize (obj);
#line 13450 "gnome-chess.c"
}


GType chess_application_get_type (void) {
	static volatile gsize chess_application_type_id__volatile = 0;
	if (g_once_init_enter (&chess_application_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ChessApplicationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) chess_application_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ChessApplication), 0, (GInstanceInitFunc) chess_application_instance_init, NULL };
		GType chess_application_type_id;
		chess_application_type_id = g_type_register_static (gtk_application_get_type (), "ChessApplication", &g_define_type_info, 0);
		g_once_init_leave (&chess_application_type_id__volatile, chess_application_type_id);
	}
	return chess_application_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



