/* FavImageView.c generated by valac 0.36.4, the Vala compiler
 * generated from FavImageView.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2017 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include <glib/gstdio.h>


#define TYPE_FAV_IMAGE_VIEW (fav_image_view_get_type ())
#define FAV_IMAGE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FAV_IMAGE_VIEW, FavImageView))
#define FAV_IMAGE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FAV_IMAGE_VIEW, FavImageViewClass))
#define IS_FAV_IMAGE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FAV_IMAGE_VIEW))
#define IS_FAV_IMAGE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FAV_IMAGE_VIEW))
#define FAV_IMAGE_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FAV_IMAGE_VIEW, FavImageViewClass))

typedef struct _FavImageView FavImageView;
typedef struct _FavImageViewClass FavImageViewClass;
typedef struct _FavImageViewPrivate FavImageViewPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))

#define TYPE_FAV_IMAGE_ROW (fav_image_row_get_type ())
#define FAV_IMAGE_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FAV_IMAGE_ROW, FavImageRow))
#define FAV_IMAGE_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FAV_IMAGE_ROW, FavImageRowClass))
#define IS_FAV_IMAGE_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FAV_IMAGE_ROW))
#define IS_FAV_IMAGE_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FAV_IMAGE_ROW))
#define FAV_IMAGE_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FAV_IMAGE_ROW, FavImageRowClass))

typedef struct _FavImageRow FavImageRow;
typedef struct _FavImageRowClass FavImageRowClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _FavImageRowPrivate FavImageRowPrivate;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _gtk_target_list_unref0(var) ((var == NULL) ? NULL : (var = (gtk_target_list_unref (var), NULL)))
enum  {
	FAV_IMAGE_VIEW_IMAGE_SELECTED_SIGNAL,
	FAV_IMAGE_VIEW_LAST_SIGNAL
};
static guint fav_image_view_signals[FAV_IMAGE_VIEW_LAST_SIGNAL] = {0};

struct _FavImageView {
	GtkBox parent_instance;
	FavImageViewPrivate * priv;
};

struct _FavImageViewClass {
	GtkBoxClass parent_class;
};

struct _FavImageViewPrivate {
	GtkScrolledWindow* scrolled_window;
	GtkFlowBox* fav_image_list;
	GtkButton* new_fav_image_button;
	gboolean gifs_enabled;
};

struct _FavImageRow {
	GtkFlowBoxChild parent_instance;
	FavImageRowPrivate * priv;
	gboolean is_gif;
};

struct _FavImageRowClass {
	GtkFlowBoxChildClass parent_class;
};


static gpointer fav_image_view_parent_class = NULL;

GType fav_image_view_get_type (void) G_GNUC_CONST;
#define FAV_IMAGE_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_FAV_IMAGE_VIEW, FavImageViewPrivate))
enum  {
	FAV_IMAGE_VIEW_DUMMY_PROPERTY
};
void fav_image_view_load_images (FavImageView* self);
gchar* dirs_config (const gchar* path);
GType fav_image_row_get_type (void) G_GNUC_CONST;
FavImageRow* fav_image_row_new (const gchar* path);
FavImageRow* fav_image_row_construct (GType object_type, const gchar* path);
static void fav_image_view_fav_image_list_child_activated_cb (FavImageView* self, GtkFlowBoxChild* _child);
const gchar* fav_image_row_get_image_path (FavImageRow* self);
static void fav_image_view_fav_image_list_drag_data_received_cb (FavImageView* self, GdkDragContext* context, gint x, gint y, GtkSelectionData* selection_data, guint info, guint time);
static void fav_image_view_new_fav_image_button_clicked_cb (FavImageView* self);
void fav_image_view_set_gifs_enabled (FavImageView* self, gboolean enabled);
FavImageView* fav_image_view_new (void);
FavImageView* fav_image_view_construct (GType object_type);
static GObject * fav_image_view_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _fav_image_view_new_fav_image_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _fav_image_view_fav_image_list_child_activated_cb_gtk_flow_box_child_activated (GtkFlowBox* _sender, GtkFlowBoxChild* child, gpointer self);
static void _fav_image_view_fav_image_list_drag_data_received_cb_gtk_widget_drag_data_received (GtkWidget* _sender, GdkDragContext* context, gint x, gint y, GtkSelectionData* selection_data, guint info, guint time_, gpointer self);
static void fav_image_view_finalize (GObject * obj);


void fav_image_view_load_images (FavImageView* self) {
	GtkFlowBox* _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
	guint _tmp3_;
	gboolean _tmp4_;
	static const gint MAX_IMAGES = 50;
	gchar* fav_image_dir = NULL;
	gchar* _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (IS_FAV_IMAGE_VIEW (self));
	_tmp0_ = self->priv->fav_image_list;
	_tmp1_ = gtk_container_get_children (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_container_get_type (), GtkContainer));
	_tmp2_ = _tmp1_;
	_tmp3_ = g_list_length (_tmp2_);
	_tmp4_ = _tmp3_ > ((guint) 0);
	_g_list_free0 (_tmp2_);
	if (_tmp4_) {
		return;
	}
	_tmp5_ = dirs_config ("image-favorites/");
	fav_image_dir = _tmp5_;
	{
		GFile* dir = NULL;
		const gchar* _tmp6_;
		GFile* _tmp7_;
		GFileEnumerator* iter = NULL;
		GFile* _tmp8_;
		GFileEnumerator* _tmp9_;
		gint i = 0;
		GFileInfo* info = NULL;
		_tmp6_ = fav_image_dir;
		_tmp7_ = g_file_new_for_path (_tmp6_);
		dir = _tmp7_;
		_tmp8_ = dir;
		_tmp9_ = g_file_enumerate_children (_tmp8_, "standard::display-name,standard::content-type", G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
		iter = _tmp9_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (dir);
			goto __catch56_g_error;
		}
		i = 0;
		info = NULL;
		while (TRUE) {
			GFileInfo* _tmp10_ = NULL;
			GFileEnumerator* _tmp11_;
			GFileInfo* _tmp12_;
			GFileInfo* _tmp13_;
			GFileInfo* _tmp14_;
			gchar* content_type = NULL;
			GFileInfo* _tmp15_;
			const gchar* _tmp16_;
			gchar* _tmp17_;
			gboolean _tmp18_ = FALSE;
			gboolean _tmp19_ = FALSE;
			const gchar* _tmp20_;
			_tmp11_ = iter;
			_tmp12_ = g_file_enumerator_next_file (_tmp11_, NULL, &_inner_error_);
			_tmp10_ = _tmp12_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_object_unref0 (info);
				_g_object_unref0 (iter);
				_g_object_unref0 (dir);
				goto __catch56_g_error;
			}
			_tmp13_ = _tmp10_;
			_tmp10_ = NULL;
			_g_object_unref0 (info);
			info = _tmp13_;
			_tmp14_ = info;
			if (!(_tmp14_ != NULL)) {
				_g_object_unref0 (_tmp10_);
				break;
			}
			_tmp15_ = info;
			_tmp16_ = g_file_info_get_content_type (_tmp15_);
			_tmp17_ = g_strdup (_tmp16_);
			content_type = _tmp17_;
			_tmp20_ = content_type;
			if (g_strcmp0 (_tmp20_, "image/jpeg") == 0) {
				_tmp19_ = TRUE;
			} else {
				const gchar* _tmp21_;
				_tmp21_ = content_type;
				_tmp19_ = g_strcmp0 (_tmp21_, "image/png") == 0;
			}
			if (_tmp19_) {
				_tmp18_ = TRUE;
			} else {
				const gchar* _tmp22_;
				_tmp22_ = content_type;
				_tmp18_ = g_strcmp0 (_tmp22_, "image/gif") == 0;
			}
			if (_tmp18_) {
				GFile* file = NULL;
				GFile* _tmp23_;
				GFileInfo* _tmp24_;
				const gchar* _tmp25_;
				GFile* _tmp26_;
				FavImageRow* row = NULL;
				GFile* _tmp27_;
				gchar* _tmp28_;
				gchar* _tmp29_;
				FavImageRow* _tmp30_;
				FavImageRow* _tmp31_;
				const gchar* _tmp32_;
				FavImageRow* _tmp36_;
				GtkFlowBox* _tmp37_;
				FavImageRow* _tmp38_;
				gint _tmp39_;
				gint _tmp40_;
				_tmp23_ = dir;
				_tmp24_ = info;
				_tmp25_ = g_file_info_get_name (_tmp24_);
				_tmp26_ = g_file_get_child (_tmp23_, _tmp25_);
				file = _tmp26_;
				_tmp27_ = file;
				_tmp28_ = g_file_get_path (_tmp27_);
				_tmp29_ = _tmp28_;
				_tmp30_ = fav_image_row_new (_tmp29_);
				g_object_ref_sink (_tmp30_);
				_tmp31_ = _tmp30_;
				_g_free0 (_tmp29_);
				row = _tmp31_;
				_tmp32_ = content_type;
				if (g_strcmp0 (_tmp32_, "image/gif") == 0) {
					FavImageRow* _tmp33_;
					FavImageRow* _tmp34_;
					gboolean _tmp35_;
					_tmp33_ = row;
					_tmp33_->is_gif = TRUE;
					_tmp34_ = row;
					_tmp35_ = self->priv->gifs_enabled;
					gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, gtk_widget_get_type (), GtkWidget), _tmp35_);
				}
				_tmp36_ = row;
				gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, gtk_widget_get_type (), GtkWidget));
				_tmp37_ = self->priv->fav_image_list;
				_tmp38_ = row;
				gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, gtk_widget_get_type (), GtkWidget));
				_tmp39_ = i;
				i = _tmp39_ + 1;
				_tmp40_ = i;
				if (_tmp40_ >= MAX_IMAGES) {
					_g_object_unref0 (row);
					_g_object_unref0 (file);
					_g_free0 (content_type);
					_g_object_unref0 (_tmp10_);
					break;
				}
				_g_object_unref0 (row);
				_g_object_unref0 (file);
			}
			_g_free0 (content_type);
			_g_object_unref0 (_tmp10_);
		}
		_g_object_unref0 (info);
		_g_object_unref0 (iter);
		_g_object_unref0 (dir);
	}
	goto __finally56;
	__catch56_g_error:
	{
		GError* e = NULL;
		GError* _tmp41_;
		const gchar* _tmp42_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp41_ = e;
		_tmp42_ = _tmp41_->message;
		g_warning ("FavImageView.vala:101: %s", _tmp42_);
		_g_error_free0 (e);
	}
	__finally56:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (fav_image_dir);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (fav_image_dir);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void fav_image_view_fav_image_list_child_activated_cb (FavImageView* self, GtkFlowBoxChild* _child) {
	FavImageRow* child = NULL;
	GtkFlowBoxChild* _tmp0_;
	FavImageRow* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (IS_FAV_IMAGE_VIEW (self));
	g_return_if_fail (GTK_IS_FLOW_BOX_CHILD (_child));
	_tmp0_ = _child;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_FAV_IMAGE_ROW, FavImageRow));
	child = _tmp1_;
	_tmp2_ = fav_image_row_get_image_path (child);
	g_signal_emit (self, fav_image_view_signals[FAV_IMAGE_VIEW_IMAGE_SELECTED_SIGNAL], 0, _tmp2_);
	_g_object_unref0 (child);
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static void fav_image_view_fav_image_list_drag_data_received_cb (FavImageView* self, GdkDragContext* context, gint x, gint y, GtkSelectionData* selection_data, guint info, guint time) {
	guint _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (IS_FAV_IMAGE_VIEW (self));
	g_return_if_fail (GDK_IS_DRAG_CONTEXT (context));
	g_return_if_fail (selection_data != NULL);
	_tmp0_ = info;
	if (_tmp0_ == ((guint) 0)) {
		gchar* text = NULL;
		GtkSelectionData* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		const gchar* _tmp6_;
		gboolean _tmp7_;
		_tmp1_ = selection_data;
		_tmp2_ = gtk_selection_data_get_text (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = string_strip (_tmp3_);
		_tmp5_ = _tmp4_;
		_g_free0 (_tmp3_);
		text = _tmp5_;
		_tmp6_ = text;
		_tmp7_ = g_str_has_prefix (_tmp6_, "file://");
		if (_tmp7_) {
			GFile* file = NULL;
			const gchar* _tmp8_;
			GFile* _tmp9_;
			GFile* _tmp10_;
			gboolean _tmp11_;
			_tmp8_ = text;
			_tmp9_ = g_file_new_for_uri (_tmp8_);
			file = _tmp9_;
			_tmp10_ = file;
			_tmp11_ = g_file_query_exists (_tmp10_, NULL);
			if (!_tmp11_) {
				const gchar* _tmp12_;
				_tmp12_ = text;
				g_debug ("FavImageView.vala:124: File '%s' does not exist.", _tmp12_);
				_g_object_unref0 (file);
				_g_free0 (text);
				return;
			}
			{
				GFileInfo* file_info = NULL;
				GFile* _tmp13_;
				GFileInfo* _tmp14_;
				FavImageRow* row = NULL;
				const gchar* _tmp15_;
				GFile* _tmp16_;
				GFile* _tmp17_;
				gchar* _tmp18_;
				gchar* _tmp19_;
				FavImageRow* _tmp20_;
				FavImageRow* _tmp21_;
				GFileInfo* _tmp22_;
				const gchar* _tmp23_;
				FavImageRow* _tmp27_;
				GtkFlowBox* _tmp28_;
				FavImageRow* _tmp29_;
				_tmp13_ = file;
				_tmp14_ = g_file_query_info (_tmp13_, "standard::content-type", G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
				file_info = _tmp14_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					goto __catch57_g_error;
				}
				_tmp15_ = text;
				_tmp16_ = g_file_new_for_uri (_tmp15_);
				_tmp17_ = _tmp16_;
				_tmp18_ = g_file_get_path (_tmp17_);
				_tmp19_ = _tmp18_;
				_tmp20_ = fav_image_row_new (_tmp19_);
				g_object_ref_sink (_tmp20_);
				_tmp21_ = _tmp20_;
				_g_free0 (_tmp19_);
				_g_object_unref0 (_tmp17_);
				row = _tmp21_;
				_tmp22_ = file_info;
				_tmp23_ = g_file_info_get_content_type (_tmp22_);
				if (g_strcmp0 (_tmp23_, "image/gif") == 0) {
					FavImageRow* _tmp24_;
					FavImageRow* _tmp25_;
					gboolean _tmp26_;
					_tmp24_ = row;
					_tmp24_->is_gif = TRUE;
					_tmp25_ = row;
					_tmp26_ = self->priv->gifs_enabled;
					gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, gtk_widget_get_type (), GtkWidget), _tmp26_);
				}
				_tmp27_ = row;
				gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, gtk_widget_get_type (), GtkWidget));
				_tmp28_ = self->priv->fav_image_list;
				_tmp29_ = row;
				gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, gtk_widget_get_type (), GtkWidget));
				_g_object_unref0 (row);
				_g_object_unref0 (file_info);
			}
			goto __finally57;
			__catch57_g_error:
			{
				GError* e = NULL;
				GError* _tmp30_;
				const gchar* _tmp31_;
				e = _inner_error_;
				_inner_error_ = NULL;
				_tmp30_ = e;
				_tmp31_ = _tmp30_->message;
				g_warning ("FavImageView.vala:140: %s", _tmp31_);
				_g_error_free0 (e);
			}
			__finally57:
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_object_unref0 (file);
				_g_free0 (text);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			_g_object_unref0 (file);
		} else {
			const gchar* _tmp32_;
			_tmp32_ = text;
			g_debug ("FavImageView.vala:143: Can't handle '%s'", _tmp32_);
		}
		_g_free0 (text);
	} else {
		guint _tmp33_;
		_tmp33_ = info;
		g_warning ("FavImageView.vala:146: Unknown drag data info %u", _tmp33_);
	}
}


static void fav_image_view_new_fav_image_button_clicked_cb (FavImageView* self) {
	GtkFileChooserNative* filechooser = NULL;
	GtkWidget* _tmp0_;
	GtkFileChooserNative* _tmp1_;
	GtkFileFilter* filter = NULL;
	GtkFileFilter* _tmp2_;
	GtkFileFilter* _tmp3_;
	GtkFileFilter* _tmp4_;
	GtkFileFilter* _tmp5_;
	GtkFileChooserNative* _tmp6_;
	GtkFileFilter* _tmp7_;
	GtkFileChooserNative* _tmp8_;
	gint _tmp9_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (IS_FAV_IMAGE_VIEW (self));
	_tmp0_ = gtk_widget_get_toplevel (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_tmp1_ = gtk_file_chooser_native_new (_ ("Select Image"), G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, gtk_window_get_type ()) ? ((GtkWindow*) _tmp0_) : NULL, GTK_FILE_CHOOSER_ACTION_OPEN, _ ("Open"), _ ("Cancel"));
	filechooser = _tmp1_;
	_tmp2_ = gtk_file_filter_new ();
	g_object_ref_sink (_tmp2_);
	filter = _tmp2_;
	_tmp3_ = filter;
	gtk_file_filter_add_mime_type (_tmp3_, "image/png");
	_tmp4_ = filter;
	gtk_file_filter_add_mime_type (_tmp4_, "image/jpeg");
	_tmp5_ = filter;
	gtk_file_filter_add_mime_type (_tmp5_, "image/gif");
	_tmp6_ = filechooser;
	_tmp7_ = filter;
	gtk_file_chooser_set_filter (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GTK_TYPE_FILE_CHOOSER, GtkFileChooser), _tmp7_);
	_tmp8_ = filechooser;
	_tmp9_ = gtk_native_dialog_run (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GTK_TYPE_NATIVE_DIALOG, GtkNativeDialog));
	if (_tmp9_ == ((gint) GTK_RESPONSE_ACCEPT)) {
		{
			GFile* file = NULL;
			GtkFileChooserNative* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			GFile* _tmp13_;
			GFile* _tmp14_;
			GFileInfo* file_info = NULL;
			GFile* _tmp15_;
			GFileInfo* _tmp16_;
			GFile* dest_dir = NULL;
			gchar* _tmp17_;
			gchar* _tmp18_;
			GFile* _tmp19_;
			GFile* _tmp20_;
			GFile* dest_file = NULL;
			GFile* _tmp21_;
			GFileInfo* _tmp22_;
			const gchar* _tmp23_;
			GFile* _tmp24_;
			GFile* _tmp25_;
			gchar* _tmp26_;
			gchar* _tmp27_;
			gboolean _tmp28_;
			gboolean _tmp29_;
			GFile* _tmp45_;
			GFile* _tmp46_;
			FavImageRow* row = NULL;
			GFile* _tmp47_;
			gchar* _tmp48_;
			gchar* _tmp49_;
			FavImageRow* _tmp50_;
			FavImageRow* _tmp51_;
			GFileInfo* _tmp52_;
			const gchar* _tmp53_;
			FavImageRow* _tmp57_;
			GtkFlowBox* _tmp58_;
			FavImageRow* _tmp59_;
			_tmp10_ = filechooser;
			_tmp11_ = gtk_file_chooser_get_filename (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GTK_TYPE_FILE_CHOOSER, GtkFileChooser));
			_tmp12_ = _tmp11_;
			_tmp13_ = g_file_new_for_path (_tmp12_);
			_tmp14_ = _tmp13_;
			_g_free0 (_tmp12_);
			file = _tmp14_;
			_tmp15_ = file;
			_tmp16_ = g_file_query_info (_tmp15_, "standard::name,standard::content-type", G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
			file_info = _tmp16_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_object_unref0 (file);
				goto __catch58_g_error;
			}
			_tmp17_ = dirs_config ("image-favorites");
			_tmp18_ = _tmp17_;
			_tmp19_ = g_file_new_for_path (_tmp18_);
			_tmp20_ = _tmp19_;
			_g_free0 (_tmp18_);
			dest_dir = _tmp20_;
			_tmp21_ = dest_dir;
			_tmp22_ = file_info;
			_tmp23_ = g_file_info_get_name (_tmp22_);
			_tmp24_ = g_file_get_child (_tmp21_, _tmp23_);
			dest_file = _tmp24_;
			_tmp25_ = dest_file;
			_tmp26_ = g_file_get_path (_tmp25_);
			_tmp27_ = _tmp26_;
			_tmp28_ = g_file_test (_tmp27_, G_FILE_TEST_EXISTS);
			_tmp29_ = _tmp28_;
			_g_free0 (_tmp27_);
			if (_tmp29_) {
				GFile* _tmp30_;
				gchar* _tmp31_;
				gchar* _tmp32_;
				GFile* _tmp33_;
				gint64 _tmp34_;
				gchar* _tmp35_;
				gchar* _tmp36_;
				GFileInfo* _tmp37_;
				const gchar* _tmp38_;
				gchar* _tmp39_;
				gchar* _tmp40_;
				GFile* _tmp41_;
				GFile* _tmp42_;
				gchar* _tmp43_;
				gchar* _tmp44_;
				_tmp30_ = dest_file;
				_tmp31_ = g_file_get_path (_tmp30_);
				_tmp32_ = _tmp31_;
				g_debug ("FavImageView.vala:173: File '%s' already exists", _tmp32_);
				_g_free0 (_tmp32_);
				_tmp33_ = dest_dir;
				_tmp34_ = g_get_monotonic_time ();
				_tmp35_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp34_);
				_tmp36_ = _tmp35_;
				_tmp37_ = file_info;
				_tmp38_ = g_file_info_get_name (_tmp37_);
				_tmp39_ = g_strdup_printf ("%s_%s", _tmp36_, _tmp38_);
				_tmp40_ = _tmp39_;
				_tmp41_ = g_file_get_child (_tmp33_, _tmp40_);
				_g_object_unref0 (dest_file);
				dest_file = _tmp41_;
				_g_free0 (_tmp40_);
				_g_free0 (_tmp36_);
				_tmp42_ = dest_file;
				_tmp43_ = g_file_get_path (_tmp42_);
				_tmp44_ = _tmp43_;
				g_debug ("FavImageView.vala:176: New name: '%s'", _tmp44_);
				_g_free0 (_tmp44_);
			}
			_tmp45_ = file;
			_tmp46_ = dest_file;
			g_file_copy (_tmp45_, _tmp46_, G_FILE_COPY_NONE, NULL, NULL, NULL, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_object_unref0 (dest_file);
				_g_object_unref0 (dest_dir);
				_g_object_unref0 (file_info);
				_g_object_unref0 (file);
				goto __catch58_g_error;
			}
			_tmp47_ = dest_file;
			_tmp48_ = g_file_get_path (_tmp47_);
			_tmp49_ = _tmp48_;
			_tmp50_ = fav_image_row_new (_tmp49_);
			g_object_ref_sink (_tmp50_);
			_tmp51_ = _tmp50_;
			_g_free0 (_tmp49_);
			row = _tmp51_;
			_tmp52_ = file_info;
			_tmp53_ = g_file_info_get_content_type (_tmp52_);
			if (g_strcmp0 (_tmp53_, "image/gif") == 0) {
				FavImageRow* _tmp54_;
				FavImageRow* _tmp55_;
				gboolean _tmp56_;
				_tmp54_ = row;
				_tmp54_->is_gif = TRUE;
				_tmp55_ = row;
				_tmp56_ = self->priv->gifs_enabled;
				gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp55_, gtk_widget_get_type (), GtkWidget), _tmp56_);
			}
			_tmp57_ = row;
			gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp57_, gtk_widget_get_type (), GtkWidget));
			_tmp58_ = self->priv->fav_image_list;
			_tmp59_ = row;
			gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp58_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp59_, gtk_widget_get_type (), GtkWidget));
			_g_object_unref0 (row);
			_g_object_unref0 (dest_file);
			_g_object_unref0 (dest_dir);
			_g_object_unref0 (file_info);
			_g_object_unref0 (file);
		}
		goto __finally58;
		__catch58_g_error:
		{
			GError* e = NULL;
			GError* _tmp60_;
			const gchar* _tmp61_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp60_ = e;
			_tmp61_ = _tmp60_->message;
			g_warning ("FavImageView.vala:191: %s", _tmp61_);
			_g_error_free0 (e);
		}
		__finally58:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (filter);
			_g_object_unref0 (filechooser);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_g_object_unref0 (filter);
	_g_object_unref0 (filechooser);
}


void fav_image_view_set_gifs_enabled (FavImageView* self, gboolean enabled) {
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GtkFlowBox* _tmp3_;
	GList* _tmp4_;
	g_return_if_fail (IS_FAV_IMAGE_VIEW (self));
	_tmp0_ = enabled;
	_tmp1_ = self->priv->gifs_enabled;
	if (_tmp0_ == _tmp1_) {
		return;
	}
	_tmp2_ = enabled;
	self->priv->gifs_enabled = _tmp2_;
	_tmp3_ = self->priv->fav_image_list;
	_tmp4_ = gtk_container_get_children (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_container_get_type (), GtkContainer));
	{
		GList* w_collection = NULL;
		GList* w_it = NULL;
		w_collection = _tmp4_;
		for (w_it = w_collection; w_it != NULL; w_it = w_it->next) {
			GtkWidget* _tmp5_;
			GtkWidget* w = NULL;
			_tmp5_ = _g_object_ref0 ((GtkWidget*) w_it->data);
			w = _tmp5_;
			{
				FavImageRow* child = NULL;
				GtkWidget* _tmp6_;
				FavImageRow* _tmp7_;
				FavImageRow* _tmp8_;
				const gchar* _tmp9_;
				gchar* _tmp10_;
				gchar* _tmp11_;
				gboolean _tmp12_;
				gboolean _tmp13_;
				_tmp6_ = w;
				_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_FAV_IMAGE_ROW, FavImageRow));
				child = _tmp7_;
				_tmp8_ = child;
				_tmp9_ = fav_image_row_get_image_path (_tmp8_);
				_tmp10_ = g_utf8_strdown (_tmp9_, (gssize) -1);
				_tmp11_ = _tmp10_;
				_tmp12_ = g_str_has_suffix (_tmp11_, ".gif");
				_tmp13_ = _tmp12_;
				_g_free0 (_tmp11_);
				if (_tmp13_) {
					FavImageRow* _tmp14_;
					gboolean _tmp15_;
					_tmp14_ = child;
					_tmp15_ = self->priv->gifs_enabled;
					gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, gtk_widget_get_type (), GtkWidget), _tmp15_);
				}
				_g_object_unref0 (child);
				_g_object_unref0 (w);
			}
		}
		_g_list_free0 (w_collection);
	}
}


FavImageView* fav_image_view_construct (GType object_type) {
	FavImageView * self = NULL;
	self = (FavImageView*) g_object_new (object_type, NULL);
	return self;
}


FavImageView* fav_image_view_new (void) {
	return fav_image_view_construct (TYPE_FAV_IMAGE_VIEW);
}


static void _fav_image_view_new_fav_image_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	fav_image_view_new_fav_image_button_clicked_cb ((FavImageView*) self);
}


static void _fav_image_view_fav_image_list_child_activated_cb_gtk_flow_box_child_activated (GtkFlowBox* _sender, GtkFlowBoxChild* child, gpointer self) {
	fav_image_view_fav_image_list_child_activated_cb ((FavImageView*) self, child);
}


static void _fav_image_view_fav_image_list_drag_data_received_cb_gtk_widget_drag_data_received (GtkWidget* _sender, GdkDragContext* context, gint x, gint y, GtkSelectionData* selection_data, guint info, guint time_, gpointer self) {
	fav_image_view_fav_image_list_drag_data_received_cb ((FavImageView*) self, context, x, y, selection_data, info, time_);
}


static GObject * fav_image_view_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	FavImageView * self;
	GtkScrolledWindow* _tmp0_;
	GtkFlowBox* _tmp1_;
	GtkScrolledWindow* _tmp2_;
	GtkScrolledWindow* _tmp3_;
	GtkFlowBox* _tmp4_;
	GtkScrolledWindow* _tmp5_;
	GtkSeparator* _tmp6_;
	GtkSeparator* _tmp7_;
	GtkButton* _tmp8_;
	GtkButton* _tmp9_;
	GtkButton* _tmp10_;
	GtkButton* _tmp11_;
	GtkButton* _tmp12_;
	GtkButton* _tmp13_;
	GtkButton* _tmp14_;
	GtkFlowBox* _tmp15_;
	GtkStyleContext* _tmp16_;
	GtkFlowBox* _tmp17_;
	GtkStyleContext* _tmp18_;
	GtkFlowBox* _tmp19_;
	GtkFlowBox* _tmp20_;
	GtkTargetList* image_target_list = NULL;
	GtkTargetList* _tmp21_;
	GtkTargetList* _tmp22_;
	GtkTargetList* _tmp23_;
	parent_class = G_OBJECT_CLASS (fav_image_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_FAV_IMAGE_VIEW, FavImageView);
	gtk_orientable_set_orientation (G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_ORIENTABLE, GtkOrientable), GTK_ORIENTATION_VERTICAL);
	_tmp0_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->scrolled_window);
	self->priv->scrolled_window = _tmp0_;
	_tmp1_ = (GtkFlowBox*) gtk_flow_box_new ();
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->fav_image_list);
	self->priv->fav_image_list = _tmp1_;
	_tmp2_ = self->priv->scrolled_window;
	gtk_widget_set_vexpand (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_widget_get_type (), GtkWidget), TRUE);
	_tmp3_ = self->priv->scrolled_window;
	_tmp4_ = self->priv->fav_image_list;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_widget_get_type (), GtkWidget));
	_tmp5_ = self->priv->scrolled_window;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_widget_get_type (), GtkWidget));
	_tmp6_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
	g_object_ref_sink (_tmp6_);
	_tmp7_ = _tmp6_;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (_tmp7_);
	_tmp8_ = (GtkButton*) gtk_button_new_from_icon_name ("list-add-symbolic", GTK_ICON_SIZE_BUTTON);
	g_object_ref_sink (_tmp8_);
	_g_object_unref0 (self->priv->new_fav_image_button);
	self->priv->new_fav_image_button = _tmp8_;
	_tmp9_ = self->priv->new_fav_image_button;
	gtk_widget_set_halign (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_widget_get_type (), GtkWidget), GTK_ALIGN_START);
	_tmp10_ = self->priv->new_fav_image_button;
	gtk_widget_set_margin_start (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_widget_get_type (), GtkWidget), 6);
	_tmp11_ = self->priv->new_fav_image_button;
	gtk_widget_set_margin_top (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, gtk_widget_get_type (), GtkWidget), 6);
	_tmp12_ = self->priv->new_fav_image_button;
	gtk_widget_set_margin_bottom (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_widget_get_type (), GtkWidget), 6);
	_tmp13_ = self->priv->new_fav_image_button;
	g_signal_connect_object (_tmp13_, "clicked", (GCallback) _fav_image_view_new_fav_image_button_clicked_cb_gtk_button_clicked, self, 0);
	_tmp14_ = self->priv->new_fav_image_button;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, gtk_widget_get_type (), GtkWidget));
	_tmp15_ = self->priv->fav_image_list;
	_tmp16_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_widget_get_type (), GtkWidget));
	gtk_style_context_add_class (_tmp16_, "view");
	_tmp17_ = self->priv->fav_image_list;
	_tmp18_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, gtk_widget_get_type (), GtkWidget));
	gtk_style_context_add_class (_tmp18_, "fav-image-box");
	_tmp19_ = self->priv->fav_image_list;
	g_signal_connect_object (_tmp19_, "child-activated", (GCallback) _fav_image_view_fav_image_list_child_activated_cb_gtk_flow_box_child_activated, self, 0);
	_tmp20_ = self->priv->fav_image_list;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, gtk_widget_get_type (), GtkWidget), "drag-data-received", (GCallback) _fav_image_view_fav_image_list_drag_data_received_cb_gtk_widget_drag_data_received, self, 0);
	_tmp21_ = gtk_target_list_new (NULL, 0);
	image_target_list = _tmp21_;
	_tmp22_ = image_target_list;
	gtk_target_list_add_text_targets (_tmp22_, (guint) 0);
	gtk_drag_dest_set (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), GTK_DEST_DEFAULT_ALL, NULL, 0, GDK_ACTION_COPY);
	_tmp23_ = image_target_list;
	gtk_drag_dest_set_target_list (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), _tmp23_);
	gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_gtk_target_list_unref0 (image_target_list);
	return obj;
}


static void fav_image_view_class_init (FavImageViewClass * klass) {
	fav_image_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FavImageViewPrivate));
	G_OBJECT_CLASS (klass)->constructor = fav_image_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = fav_image_view_finalize;
	fav_image_view_signals[FAV_IMAGE_VIEW_IMAGE_SELECTED_SIGNAL] = g_signal_new ("image_selected", TYPE_FAV_IMAGE_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
}


static void fav_image_view_instance_init (FavImageView * self) {
	self->priv = FAV_IMAGE_VIEW_GET_PRIVATE (self);
	self->priv->gifs_enabled = TRUE;
}


static void fav_image_view_finalize (GObject * obj) {
	FavImageView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_FAV_IMAGE_VIEW, FavImageView);
	_g_object_unref0 (self->priv->scrolled_window);
	_g_object_unref0 (self->priv->fav_image_list);
	_g_object_unref0 (self->priv->new_fav_image_button);
	G_OBJECT_CLASS (fav_image_view_parent_class)->finalize (obj);
}


GType fav_image_view_get_type (void) {
	static volatile gsize fav_image_view_type_id__volatile = 0;
	if (g_once_init_enter (&fav_image_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FavImageViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) fav_image_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FavImageView), 0, (GInstanceInitFunc) fav_image_view_instance_init, NULL };
		GType fav_image_view_type_id;
		fav_image_view_type_id = g_type_register_static (gtk_box_get_type (), "FavImageView", &g_define_type_info, 0);
		g_once_init_leave (&fav_image_view_type_id__volatile, fav_image_view_type_id);
	}
	return fav_image_view_type_id__volatile;
}



