/* CompletionTextView.c generated by valac 0.36.4, the Vala compiler
 * generated from CompletionTextView.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include "CbSnippetManager.h"
#include <gdk/gdk.h>
#include <cairo.h>
#include "CbUserCounter.h"
#include "rest/oauth-proxy.h"
#include "CbUserStream.h"
#include "CbFilter.h"
#include <sqlite3.h>
#include <glib/gi18n-lib.h>
#include <gspell/gspell.h>


#define TYPE_COMPLETION_TEXT_VIEW (completion_text_view_get_type ())
#define COMPLETION_TEXT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPLETION_TEXT_VIEW, CompletionTextView))
#define COMPLETION_TEXT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPLETION_TEXT_VIEW, CompletionTextViewClass))
#define IS_COMPLETION_TEXT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPLETION_TEXT_VIEW))
#define IS_COMPLETION_TEXT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPLETION_TEXT_VIEW))
#define COMPLETION_TEXT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPLETION_TEXT_VIEW, CompletionTextViewClass))

typedef struct _CompletionTextView CompletionTextView;
typedef struct _CompletionTextViewClass CompletionTextViewClass;
typedef struct _CompletionTextViewPrivate CompletionTextViewPrivate;

#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
typedef struct _AccountPrivate AccountPrivate;

#define SQL_TYPE_DATABASE (sql_database_get_type ())
#define SQL_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_DATABASE, SqlDatabase))
#define SQL_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_DATABASE, SqlDatabaseClass))
#define SQL_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_DATABASE))
#define SQL_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_DATABASE))
#define SQL_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_DATABASE, SqlDatabaseClass))

typedef struct _SqlDatabase SqlDatabase;
typedef struct _SqlDatabaseClass SqlDatabaseClass;

#define TYPE_NOTIFICATION_MANAGER (notification_manager_get_type ())
#define NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManager))
#define NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))
#define IS_NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFICATION_MANAGER))
#define IS_NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFICATION_MANAGER))
#define NOTIFICATION_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))

typedef struct _NotificationManager NotificationManager;
typedef struct _NotificationManagerClass NotificationManagerClass;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _CompletionTextView {
	GtkTextView parent_instance;
	CompletionTextViewPrivate * priv;
};

struct _CompletionTextViewClass {
	GtkTextViewClass parent_class;
};

struct _CompletionTextViewPrivate {
	GtkListBox* completion_list;
	GtkWindow* completion_window;
	gint current_match;
	gchar* current_word;
	Account* account;
};

struct _Account {
	GObject parent_instance;
	AccountPrivate * priv;
	gint64 id;
	SqlDatabase* db;
	gchar* screen_name;
	gchar* name;
	gchar* avatar_url;
	gchar* banner_url;
	gchar* website;
	gchar* description;
	OAuthProxy* proxy;
	CbUserStream* user_stream;
	CbUserCounter* user_counter;
	NotificationManager* notifications;
	gint64* friends;
	gint friends_length1;
	gint64* blocked;
	gint blocked_length1;
	gint64* muted;
	gint muted_length1;
	gint64* disabled_rts;
	gint disabled_rts_length1;
	GPtrArray* filters;
};

struct _AccountClass {
	GObjectClass parent_class;
};


static gpointer completion_text_view_parent_class = NULL;
extern CbSnippetManager* corebird_snippet_manager;

GType completion_text_view_get_type (void) G_GNUC_CONST;
GType account_get_type (void) G_GNUC_CONST;
#define COMPLETION_TEXT_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_COMPLETION_TEXT_VIEW, CompletionTextViewPrivate))
enum  {
	COMPLETION_TEXT_VIEW_DUMMY_PROPERTY
};
void completion_text_view_set_account (CompletionTextView* self, Account* account);
static gboolean completion_text_view_insert_snippet (CompletionTextView* self);
static gchar* completion_text_view_get_cursor_word (CompletionTextView* self, GtkTextIter* start_iter, GtkTextIter* end_iter);
static inline gboolean completion_text_view_snippets_configured (CompletionTextView* self);
static gboolean completion_text_view_key_press_event_cb (CompletionTextView* self, GdkEventKey* evt);
static void completion_text_view_insert_completion (CompletionTextView* self, const gchar* compl);
static void completion_text_view_hide_completion_window (CompletionTextView* self);
static void completion_text_view_buffer_changed_cb (CompletionTextView* self);
static GtkTextIter* _gtk_text_iter_dup (GtkTextIter* self);
void tweet_utils_annotate_text (GtkTextBuffer* buffer);
static void completion_text_view_show_completion_window (CompletionTextView* self);
static void __lambda32_ (CompletionTextView* self, GtkWidget* w);
static void ___lambda32__gtk_callback (GtkWidget* widget, gpointer self);
static gboolean completion_text_view_completion_window_focus_out_cb (CompletionTextView* self);
static void completion_text_view_update_completion (CompletionTextView* self);
GType sql_database_get_type (void) G_GNUC_CONST;
GType notification_manager_get_type (void) G_GNUC_CONST;
sqlite3* sql_database_get_sqlite_db (SqlDatabase* self);
static void _vala_CbUserInfo_array_free (CbUserInfo * array, gint array_length);
CompletionTextView* completion_text_view_new (void);
CompletionTextView* completion_text_view_construct (GType object_type);
static GObject * completion_text_view_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gboolean _completion_text_view_completion_window_focus_out_cb_gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self);
#define TWEET_UTILS_NO_SPELL_CHECK "gtksourceview:context-classes:no-spell-check"
static void _completion_text_view_update_completion_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _completion_text_view_buffer_changed_cb_gtk_text_buffer_changed (GtkTextBuffer* _sender, gpointer self);
static gboolean _completion_text_view_key_press_event_cb_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
static void completion_text_view_finalize (GObject * obj);

static const gchar* COMPLETION_TEXT_VIEW_TEXT_TAGS[4] = {"link", "mention", "hashtag", "snippet"};

void completion_text_view_set_account (CompletionTextView* self, Account* account) {
	Account* _tmp0_;
	g_return_if_fail (IS_COMPLETION_TEXT_VIEW (self));
	g_return_if_fail (IS_ACCOUNT (account));
	_tmp0_ = account;
	self->priv->account = _tmp0_;
}


static gunichar string_get_char (const gchar* self, glong index) {
	gunichar result = 0U;
	glong _tmp0_;
	gunichar _tmp1_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = index;
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
	result = _tmp1_;
	return result;
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	glong _tmp8_;
	glong _tmp14_;
	glong _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	gchar* _tmp22_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_;
		glong _tmp4_;
		glong _tmp5_;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_;
		gint _tmp7_;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_;
		glong _tmp10_;
		glong _tmp11_;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_;
		glong _tmp13_;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_;
		glong _tmp16_;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean completion_text_view_insert_snippet (CompletionTextView* self) {
	gboolean result = FALSE;
	GtkTextIter cursor_word_start = {0};
	GtkTextIter cursor_word_end = {0};
	gchar* cursor_word = NULL;
	GtkTextIter _tmp0_ = {0};
	GtkTextIter _tmp1_ = {0};
	gchar* _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_;
	gunichar _tmp6_;
	gchar* snippet = NULL;
	CbSnippetManager* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	const gchar* _tmp20_;
	GtkTextIter start_word_iter = {0};
	GtkTextBuffer* _tmp22_;
	GtkTextBuffer* _tmp23_;
	GtkTextBuffer* _tmp24_;
	GtkTextBuffer* _tmp25_;
	GtkTextIter _tmp26_;
	GtkTextIter _tmp27_;
	GtkTextMark* cursor_mark = NULL;
	GtkTextBuffer* _tmp28_;
	GtkTextBuffer* _tmp29_;
	GtkTextMark* _tmp30_;
	GtkTextMark* _tmp31_;
	GtkTextBuffer* _tmp32_;
	GtkTextBuffer* _tmp33_;
	GtkTextMark* _tmp34_;
	GtkTextIter _tmp35_ = {0};
	GtkTextBuffer* _tmp36_;
	GtkTextBuffer* _tmp37_;
	const gchar* _tmp38_;
	const gchar* _tmp39_;
	gint _tmp40_;
	gint _tmp41_;
	GtkTextBuffer* _tmp42_;
	GtkTextBuffer* _tmp43_;
	g_return_val_if_fail (IS_COMPLETION_TEXT_VIEW (self), FALSE);
	_tmp2_ = completion_text_view_get_cursor_word (self, &_tmp0_, &_tmp1_);
	cursor_word_start = _tmp0_;
	cursor_word_end = _tmp1_;
	cursor_word = _tmp2_;
	_tmp5_ = cursor_word;
	_tmp6_ = string_get_char (_tmp5_, (glong) 0);
	if (_tmp6_ == ((gunichar) ' ')) {
		_tmp4_ = TRUE;
	} else {
		const gchar* _tmp7_;
		gunichar _tmp8_;
		_tmp7_ = cursor_word;
		_tmp8_ = string_get_char (_tmp7_, (glong) 0);
		_tmp4_ = _tmp8_ == ((gunichar) '\t');
	}
	if (_tmp4_) {
		_tmp3_ = TRUE;
	} else {
		const gchar* _tmp9_;
		gunichar _tmp10_;
		_tmp9_ = cursor_word;
		_tmp10_ = string_get_char (_tmp9_, (glong) 0);
		_tmp3_ = _tmp10_ == ((gunichar) '\n');
	}
	if (_tmp3_) {
		const gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp11_ = cursor_word;
		_tmp12_ = string_substring (_tmp11_, (glong) 1, (glong) -1);
		_g_free0 (cursor_word);
		cursor_word = _tmp12_;
		gtk_text_iter_forward_char (&cursor_word_start);
	}
	_tmp13_ = corebird_snippet_manager;
	_tmp14_ = cursor_word;
	_tmp15_ = string_strip (_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = cb_snippet_manager_get_snippet (_tmp13_, _tmp16_);
	_tmp18_ = g_strdup (_tmp17_);
	_tmp19_ = _tmp18_;
	_g_free0 (_tmp16_);
	snippet = _tmp19_;
	_tmp20_ = snippet;
	if (_tmp20_ == NULL) {
		const gchar* _tmp21_;
		_tmp21_ = cursor_word;
		g_debug ("CompletionTextView.vala:133: No snippet for cursor_word '%s' found.", _tmp21_);
		result = FALSE;
		_g_free0 (snippet);
		_g_free0 (cursor_word);
		return result;
	}
	_tmp22_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp23_ = _tmp22_;
	g_object_freeze_notify (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, G_TYPE_OBJECT, GObject));
	_tmp24_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp25_ = _tmp24_;
	_tmp26_ = cursor_word_start;
	_tmp27_ = cursor_word_end;
	g_signal_emit_by_name (_tmp25_, "delete-range", &_tmp26_, &_tmp27_);
	_tmp28_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp29_ = _tmp28_;
	_tmp30_ = gtk_text_buffer_get_insert (_tmp29_);
	_tmp31_ = _g_object_ref0 (_tmp30_);
	cursor_mark = _tmp31_;
	_tmp32_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp33_ = _tmp32_;
	_tmp34_ = cursor_mark;
	gtk_text_buffer_get_iter_at_mark (_tmp33_, &_tmp35_, _tmp34_);
	start_word_iter = _tmp35_;
	_tmp36_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp37_ = _tmp36_;
	_tmp38_ = snippet;
	_tmp39_ = snippet;
	_tmp40_ = strlen (_tmp39_);
	_tmp41_ = _tmp40_;
	g_signal_emit_by_name (_tmp37_, "insert-text", &start_word_iter, _tmp38_, _tmp41_);
	_tmp42_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp43_ = _tmp42_;
	g_object_thaw_notify (G_TYPE_CHECK_INSTANCE_CAST (_tmp43_, G_TYPE_OBJECT, GObject));
	result = TRUE;
	_g_object_unref0 (cursor_mark);
	_g_free0 (snippet);
	_g_free0 (cursor_word);
	return result;
}


static inline gboolean completion_text_view_snippets_configured (CompletionTextView* self) {
	gboolean result = FALSE;
	CbSnippetManager* _tmp0_;
	guint _tmp1_;
	g_return_val_if_fail (IS_COMPLETION_TEXT_VIEW (self), FALSE);
	_tmp0_ = corebird_snippet_manager;
	_tmp1_ = cb_snippet_manager_n_snippets (_tmp0_);
	result = _tmp1_ > ((guint) 0);
	return result;
}


static gboolean completion_text_view_key_press_event_cb (CompletionTextView* self, GdkEventKey* evt) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GdkEventKey* _tmp1_;
	guint _tmp2_;
	GtkWindow* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	gint n_results = 0;
	GtkListBox* _tmp8_;
	GList* _tmp9_;
	GList* _tmp10_;
	guint _tmp11_;
	gint _tmp12_;
	GdkEventKey* _tmp13_;
	guint _tmp14_;
	g_return_val_if_fail (IS_COMPLETION_TEXT_VIEW (self), FALSE);
	g_return_val_if_fail (evt != NULL, FALSE);
	_tmp1_ = evt;
	_tmp2_ = _tmp1_->keyval;
	if (_tmp2_ == ((guint) GDK_KEY_Tab)) {
		gboolean _tmp3_;
		_tmp3_ = completion_text_view_snippets_configured (self);
		_tmp0_ = _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gboolean _tmp4_;
		_tmp4_ = completion_text_view_insert_snippet (self);
		result = _tmp4_;
		return result;
	}
	_tmp5_ = self->priv->completion_window;
	_tmp6_ = gtk_widget_get_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_widget_get_type (), GtkWidget));
	_tmp7_ = _tmp6_;
	if (!_tmp7_) {
		result = GDK_EVENT_PROPAGATE;
		return result;
	}
	_tmp8_ = self->priv->completion_list;
	_tmp9_ = gtk_container_get_children (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_container_get_type (), GtkContainer));
	_tmp10_ = _tmp9_;
	_tmp11_ = g_list_length (_tmp10_);
	_tmp12_ = (gint) _tmp11_;
	_g_list_free0 (_tmp10_);
	n_results = _tmp12_;
	_tmp13_ = evt;
	_tmp14_ = _tmp13_->keyval;
	if (_tmp14_ == ((guint) GDK_KEY_Down)) {
		gint _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		GtkListBoxRow* row = NULL;
		GtkListBox* _tmp18_;
		gint _tmp19_;
		GtkListBoxRow* _tmp20_;
		GtkListBoxRow* _tmp21_;
		GtkListBoxRow* _tmp22_;
		GtkListBox* _tmp23_;
		GtkListBoxRow* _tmp24_;
		_tmp15_ = n_results;
		if (_tmp15_ == 0) {
			result = GDK_EVENT_PROPAGATE;
			return result;
		}
		_tmp16_ = self->priv->current_match;
		_tmp17_ = n_results;
		self->priv->current_match = (_tmp16_ + 1) % _tmp17_;
		_tmp18_ = self->priv->completion_list;
		_tmp19_ = self->priv->current_match;
		_tmp20_ = gtk_list_box_get_row_at_index (_tmp18_, _tmp19_);
		_tmp21_ = _g_object_ref0 (_tmp20_);
		row = _tmp21_;
		_tmp22_ = row;
		gtk_widget_grab_focus (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, gtk_widget_get_type (), GtkWidget));
		_tmp23_ = self->priv->completion_list;
		_tmp24_ = row;
		gtk_list_box_select_row (_tmp23_, _tmp24_);
		result = GDK_EVENT_STOP;
		_g_object_unref0 (row);
		return result;
	} else {
		GdkEventKey* _tmp25_;
		guint _tmp26_;
		_tmp25_ = evt;
		_tmp26_ = _tmp25_->keyval;
		if (_tmp26_ == ((guint) GDK_KEY_Up)) {
			gint _tmp27_;
			gint _tmp28_;
			GtkListBoxRow* row = NULL;
			GtkListBox* _tmp30_;
			gint _tmp31_;
			GtkListBoxRow* _tmp32_;
			GtkListBoxRow* _tmp33_;
			GtkListBoxRow* _tmp34_;
			GtkListBox* _tmp35_;
			GtkListBoxRow* _tmp36_;
			_tmp27_ = self->priv->current_match;
			self->priv->current_match = _tmp27_ - 1;
			_tmp28_ = self->priv->current_match;
			if (_tmp28_ < 0) {
				gint _tmp29_;
				_tmp29_ = n_results;
				self->priv->current_match = _tmp29_ - 1;
			}
			_tmp30_ = self->priv->completion_list;
			_tmp31_ = self->priv->current_match;
			_tmp32_ = gtk_list_box_get_row_at_index (_tmp30_, _tmp31_);
			_tmp33_ = _g_object_ref0 (_tmp32_);
			row = _tmp33_;
			_tmp34_ = row;
			gtk_widget_grab_focus (G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, gtk_widget_get_type (), GtkWidget));
			_tmp35_ = self->priv->completion_list;
			_tmp36_ = row;
			gtk_list_box_select_row (_tmp35_, _tmp36_);
			result = GDK_EVENT_STOP;
			_g_object_unref0 (row);
			return result;
		} else {
			GdkEventKey* _tmp37_;
			guint _tmp38_;
			_tmp37_ = evt;
			_tmp38_ = _tmp37_->keyval;
			if (_tmp38_ == ((guint) GDK_KEY_Return)) {
				gint _tmp39_;
				gint _tmp40_;
				GtkListBoxRow* row = NULL;
				GtkListBox* _tmp41_;
				gint _tmp42_;
				GtkListBoxRow* _tmp43_;
				GtkListBoxRow* _tmp44_;
				gchar* compl = NULL;
				GtkListBoxRow* _tmp45_;
				GtkWidget* _tmp46_;
				const gchar* _tmp47_;
				const gchar* _tmp48_;
				gchar* _tmp49_;
				const gchar* _tmp50_;
				gchar* _tmp51_;
				gchar* _tmp52_;
				_tmp39_ = n_results;
				if (_tmp39_ == 0) {
					result = FALSE;
					return result;
				}
				_tmp40_ = self->priv->current_match;
				if (_tmp40_ == -1) {
					self->priv->current_match = 0;
				}
				_tmp41_ = self->priv->completion_list;
				_tmp42_ = self->priv->current_match;
				_tmp43_ = gtk_list_box_get_row_at_index (_tmp41_, _tmp42_);
				_tmp44_ = _g_object_ref0 (_tmp43_);
				row = _tmp44_;
				_tmp45_ = row;
				_tmp46_ = gtk_bin_get_child (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp45_, gtk_list_box_row_get_type (), GtkListBoxRow), gtk_bin_get_type (), GtkBin));
				_tmp47_ = gtk_label_get_label (G_TYPE_CHECK_INSTANCE_CAST (_tmp46_, gtk_label_get_type (), GtkLabel));
				_tmp48_ = _tmp47_;
				_tmp49_ = g_strdup (_tmp48_);
				compl = _tmp49_;
				_tmp50_ = compl;
				_tmp51_ = string_substring (_tmp50_, (glong) 1, (glong) -1);
				_tmp52_ = _tmp51_;
				completion_text_view_insert_completion (self, _tmp52_);
				_g_free0 (_tmp52_);
				self->priv->current_match = -1;
				completion_text_view_hide_completion_window (self);
				result = GDK_EVENT_STOP;
				_g_free0 (compl);
				_g_object_unref0 (row);
				return result;
			} else {
				GdkEventKey* _tmp53_;
				guint _tmp54_;
				_tmp53_ = evt;
				_tmp54_ = _tmp53_->keyval;
				if (_tmp54_ == ((guint) GDK_KEY_Escape)) {
					completion_text_view_hide_completion_window (self);
					result = GDK_EVENT_STOP;
					return result;
				}
			}
		}
	}
	result = GDK_EVENT_PROPAGATE;
	return result;
}


static GtkTextIter* _gtk_text_iter_dup (GtkTextIter* self) {
	GtkTextIter* dup;
	dup = g_new0 (GtkTextIter, 1);
	memcpy (dup, self, sizeof (GtkTextIter));
	return dup;
}


static gpointer __gtk_text_iter_dup0 (gpointer self) {
	return self ? _gtk_text_iter_dup (self) : NULL;
}


static void completion_text_view_buffer_changed_cb (CompletionTextView* self) {
	GtkTextIter* start_iter = NULL;
	GtkTextIter* end_iter = NULL;
	GtkTextBuffer* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GtkTextIter _tmp2_ = {0};
	GtkTextIter _tmp3_;
	GtkTextIter* _tmp4_;
	GtkTextBuffer* _tmp5_;
	GtkTextBuffer* _tmp6_;
	GtkTextIter _tmp7_ = {0};
	GtkTextIter _tmp8_;
	GtkTextIter* _tmp9_;
	GtkTextTagTable* tag_table = NULL;
	GtkTextBuffer* _tmp10_;
	GtkTextBuffer* _tmp11_;
	GtkTextTagTable* _tmp12_;
	GtkTextTagTable* _tmp13_;
	GtkTextBuffer* _tmp27_;
	GtkTextBuffer* _tmp28_;
	GtkTextBuffer* _tmp29_;
	GtkTextBuffer* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	gint _tmp34_;
	gint _tmp35_;
	gboolean _tmp36_;
	g_return_if_fail (IS_COMPLETION_TEXT_VIEW (self));
	_tmp0_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp1_ = _tmp0_;
	gtk_text_buffer_get_start_iter (_tmp1_, &_tmp2_);
	_g_free0 (start_iter);
	_tmp3_ = _tmp2_;
	_tmp4_ = __gtk_text_iter_dup0 (&_tmp3_);
	start_iter = _tmp4_;
	_tmp5_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp6_ = _tmp5_;
	gtk_text_buffer_get_end_iter (_tmp6_, &_tmp7_);
	_g_free0 (end_iter);
	_tmp8_ = _tmp7_;
	_tmp9_ = __gtk_text_iter_dup0 (&_tmp8_);
	end_iter = _tmp9_;
	_tmp10_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp11_ = _tmp10_;
	_tmp12_ = gtk_text_buffer_get_tag_table (_tmp11_);
	_tmp13_ = _g_object_ref0 (_tmp12_);
	tag_table = _tmp13_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp14_ = FALSE;
			_tmp14_ = TRUE;
			while (TRUE) {
				gint _tmp16_;
				GtkTextBuffer* _tmp17_;
				GtkTextBuffer* _tmp18_;
				GtkTextTagTable* _tmp19_;
				gint _tmp20_;
				const gchar* _tmp21_;
				GtkTextTag* _tmp22_;
				GtkTextIter* _tmp23_;
				GtkTextIter* _tmp24_;
				GtkTextIter _tmp25_;
				GtkTextIter _tmp26_;
				if (!_tmp14_) {
					gint _tmp15_;
					_tmp15_ = i;
					i = _tmp15_ + 1;
				}
				_tmp14_ = FALSE;
				_tmp16_ = i;
				if (!(_tmp16_ < G_N_ELEMENTS (COMPLETION_TEXT_VIEW_TEXT_TAGS))) {
					break;
				}
				_tmp17_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
				_tmp18_ = _tmp17_;
				_tmp19_ = tag_table;
				_tmp20_ = i;
				_tmp21_ = COMPLETION_TEXT_VIEW_TEXT_TAGS[_tmp20_];
				_tmp22_ = gtk_text_tag_table_lookup (_tmp19_, _tmp21_);
				_tmp23_ = start_iter;
				_tmp24_ = end_iter;
				_tmp25_ = *_tmp23_;
				_tmp26_ = *_tmp24_;
				gtk_text_buffer_remove_tag (_tmp18_, _tmp22_, &_tmp25_, &_tmp26_);
			}
		}
	}
	_tmp27_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp28_ = _tmp27_;
	tweet_utils_annotate_text (_tmp28_);
	_tmp29_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp30_ = _tmp29_;
	g_object_get (_tmp30_, "text", &_tmp31_, NULL);
	_tmp32_ = _tmp31_;
	_tmp33_ = _tmp32_;
	_tmp34_ = strlen (_tmp33_);
	_tmp35_ = _tmp34_;
	_tmp36_ = _tmp35_ == 0;
	_g_free0 (_tmp33_);
	if (_tmp36_) {
		GtkWindow* _tmp37_;
		_tmp37_ = self->priv->completion_window;
		gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, gtk_widget_get_type (), GtkWidget));
	}
	_g_object_unref0 (tag_table);
	_g_free0 (end_iter);
	_g_free0 (start_iter);
}


static void __lambda32_ (CompletionTextView* self, GtkWidget* w) {
	GtkListBox* _tmp0_;
	GtkWidget* _tmp1_;
	g_return_if_fail (GTK_IS_WIDGET (w));
	_tmp0_ = self->priv->completion_list;
	_tmp1_ = w;
	gtk_container_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_container_get_type (), GtkContainer), _tmp1_);
}


static void ___lambda32__gtk_callback (GtkWidget* widget, gpointer self) {
	__lambda32_ ((CompletionTextView*) self, widget);
}


static void completion_text_view_show_completion_window (CompletionTextView* self) {
	gboolean _tmp0_;
	gint x = 0;
	gint y = 0;
	GtkAllocation alloc = {0};
	GtkAllocation _tmp1_ = {0};
	GdkWindow* _tmp2_;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_;
	GtkAllocation _tmp6_;
	gint _tmp7_;
	GtkWindow* _tmp8_;
	GtkWindow* _tmp9_;
	GtkWidget* _tmp10_;
	GtkWindow* _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	GtkWindow* _tmp14_;
	GtkAllocation _tmp15_;
	gint _tmp16_;
	GtkListBox* _tmp17_;
	GtkWindow* _tmp18_;
	g_return_if_fail (IS_COMPLETION_TEXT_VIEW (self));
	_tmp0_ = gtk_widget_get_mapped (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	if (!_tmp0_) {
		return;
	}
	g_debug ("CompletionTextView.vala:228: show_completion_window");
	gtk_widget_get_allocation (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), &_tmp1_);
	alloc = _tmp1_;
	_tmp2_ = gtk_text_view_get_window (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView), GTK_TEXT_WINDOW_WIDGET);
	gdk_window_get_origin (_tmp2_, &_tmp3_, &_tmp4_);
	x = _tmp3_;
	y = _tmp4_;
	_tmp5_ = y;
	_tmp6_ = alloc;
	_tmp7_ = _tmp6_.height;
	y = _tmp5_ + _tmp7_;
	_tmp8_ = self->priv->completion_window;
	gtk_window_set_attached_to (_tmp8_, G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_tmp9_ = self->priv->completion_window;
	_tmp10_ = gtk_widget_get_toplevel (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	gtk_window_set_transient_for (_tmp9_, G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_window_get_type (), GtkWindow));
	_tmp11_ = self->priv->completion_window;
	_tmp12_ = x;
	_tmp13_ = y;
	gtk_window_move (_tmp11_, _tmp12_ - 1, _tmp13_);
	_tmp14_ = self->priv->completion_window;
	_tmp15_ = alloc;
	_tmp16_ = _tmp15_.width;
	gtk_window_resize (_tmp14_, _tmp16_ + 2, 50);
	_tmp17_ = self->priv->completion_list;
	gtk_container_foreach (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, gtk_container_get_type (), GtkContainer), ___lambda32__gtk_callback, self);
	_tmp18_ = self->priv->completion_window;
	gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, gtk_widget_get_type (), GtkWidget));
}


static void completion_text_view_hide_completion_window (CompletionTextView* self) {
	GtkWindow* _tmp0_;
	g_return_if_fail (IS_COMPLETION_TEXT_VIEW (self));
	_tmp0_ = self->priv->completion_window;
	gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget));
	_g_free0 (self->priv->current_word);
	self->priv->current_word = NULL;
}


static gboolean completion_text_view_completion_window_focus_out_cb (CompletionTextView* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (IS_COMPLETION_TEXT_VIEW (self), FALSE);
	completion_text_view_hide_completion_window (self);
	result = FALSE;
	return result;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static void _vala_CbUserInfo_array_free (CbUserInfo * array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			cb_user_info_destroy (&array[i]);
		}
	}
	g_free (array);
}


static void completion_text_view_update_completion (CompletionTextView* self) {
	gchar* cur_word = NULL;
	gchar* _tmp0_;
	gint n_chars = 0;
	const gchar* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gchar end_char = '\0';
	const gchar* _tmp4_;
	gint _tmp5_;
	gchar _tmp6_;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	gchar _tmp10_;
	gboolean _tmp11_;
	gboolean word_has_alpha_end = FALSE;
	gboolean _tmp17_ = FALSE;
	gboolean _tmp18_ = FALSE;
	const gchar* _tmp19_;
	gboolean _tmp20_;
	const gchar* _tmp26_;
	gchar* _tmp27_;
	const gchar* _tmp28_;
	const gchar* _tmp29_;
	g_return_if_fail (IS_COMPLETION_TEXT_VIEW (self));
	_tmp0_ = completion_text_view_get_cursor_word (self, NULL, NULL);
	cur_word = _tmp0_;
	_tmp1_ = cur_word;
	_tmp2_ = g_utf8_strlen (_tmp1_, (gssize) -1);
	n_chars = _tmp2_;
	_tmp3_ = n_chars;
	if (_tmp3_ == 0) {
		_g_free0 (cur_word);
		return;
	}
	_tmp4_ = cur_word;
	_tmp5_ = n_chars;
	_tmp6_ = string_get (_tmp4_, (glong) (_tmp5_ - 1));
	end_char = _tmp6_;
	_tmp10_ = end_char;
	_tmp11_ = g_ascii_isalpha (_tmp10_);
	if (_tmp11_) {
		_tmp9_ = TRUE;
	} else {
		gchar _tmp12_;
		gboolean _tmp13_;
		_tmp12_ = end_char;
		_tmp13_ = g_ascii_isdigit (_tmp12_);
		_tmp9_ = _tmp13_;
	}
	if (_tmp9_) {
		gchar _tmp14_;
		gboolean _tmp15_;
		_tmp14_ = end_char;
		_tmp15_ = g_ascii_isgraph (_tmp14_);
		_tmp8_ = _tmp15_;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		_tmp7_ = TRUE;
	} else {
		gchar _tmp16_;
		_tmp16_ = end_char;
		_tmp7_ = _tmp16_ == '@';
	}
	word_has_alpha_end = _tmp7_;
	_tmp19_ = cur_word;
	_tmp20_ = g_str_has_prefix (_tmp19_, "@");
	if (!_tmp20_) {
		_tmp18_ = TRUE;
	} else {
		gboolean _tmp21_;
		_tmp21_ = word_has_alpha_end;
		_tmp18_ = !_tmp21_;
	}
	if (_tmp18_) {
		_tmp17_ = TRUE;
	} else {
		GtkTextBuffer* _tmp22_;
		GtkTextBuffer* _tmp23_;
		gboolean _tmp24_;
		gboolean _tmp25_;
		_tmp22_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
		_tmp23_ = _tmp22_;
		_tmp24_ = gtk_text_buffer_get_has_selection (_tmp23_);
		_tmp25_ = _tmp24_;
		_tmp17_ = _tmp25_;
	}
	if (_tmp17_) {
		completion_text_view_hide_completion_window (self);
		_g_free0 (cur_word);
		return;
	}
	_tmp26_ = cur_word;
	_tmp27_ = string_substring (_tmp26_, (glong) 1, (glong) -1);
	_g_free0 (cur_word);
	cur_word = _tmp27_;
	_tmp28_ = cur_word;
	_tmp29_ = self->priv->current_word;
	if (g_strcmp0 (_tmp28_, _tmp29_) != 0) {
		const gchar* _tmp30_;
		gchar* _tmp31_;
		CbUserInfo* corpus = NULL;
		gint corpus_length1 = 0;
		gint _corpus_size_ = 0;
		Account* _tmp32_;
		CbUserCounter* _tmp33_;
		Account* _tmp34_;
		SqlDatabase* _tmp35_;
		sqlite3* _tmp36_;
		const gchar* _tmp37_;
		CbUserInfo* _tmp38_ = NULL;
		gint _tmp39_;
		CbUserInfo* _tmp55_;
		gint _tmp55__length1;
		GtkListBox* _tmp59_;
		completion_text_view_show_completion_window (self);
		_tmp30_ = cur_word;
		_tmp31_ = g_strdup (_tmp30_);
		_g_free0 (self->priv->current_word);
		self->priv->current_word = _tmp31_;
		_tmp32_ = self->priv->account;
		_tmp33_ = _tmp32_->user_counter;
		_tmp34_ = self->priv->account;
		_tmp35_ = _tmp34_->db;
		_tmp36_ = sql_database_get_sqlite_db (_tmp35_);
		_tmp37_ = cur_word;
		cb_user_counter_query_by_prefix (_tmp33_, _tmp36_, _tmp37_, 10, &_tmp38_, &_tmp39_);
		corpus = (_vala_CbUserInfo_array_free (corpus, corpus_length1), NULL);
		corpus = _tmp38_;
		corpus_length1 = _tmp39_;
		_corpus_size_ = corpus_length1;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp40_ = FALSE;
				_tmp40_ = TRUE;
				while (TRUE) {
					gint _tmp42_;
					CbUserInfo* _tmp43_;
					gint _tmp43__length1;
					GtkLabel* l = NULL;
					CbUserInfo* _tmp44_;
					gint _tmp44__length1;
					gint _tmp45_;
					CbUserInfo _tmp46_;
					const gchar* _tmp47_;
					gchar* _tmp48_;
					gchar* _tmp49_;
					GtkLabel* _tmp50_;
					GtkLabel* _tmp51_;
					GtkLabel* _tmp52_;
					GtkListBox* _tmp53_;
					GtkLabel* _tmp54_;
					if (!_tmp40_) {
						gint _tmp41_;
						_tmp41_ = i;
						i = _tmp41_ + 1;
					}
					_tmp40_ = FALSE;
					_tmp42_ = i;
					_tmp43_ = corpus;
					_tmp43__length1 = corpus_length1;
					if (!(_tmp42_ < _tmp43__length1)) {
						break;
					}
					_tmp44_ = corpus;
					_tmp44__length1 = corpus_length1;
					_tmp45_ = i;
					_tmp46_ = _tmp44_[_tmp45_];
					_tmp47_ = _tmp46_.screen_name;
					_tmp48_ = g_strconcat ("@", _tmp47_, NULL);
					_tmp49_ = _tmp48_;
					_tmp50_ = (GtkLabel*) gtk_label_new (_tmp49_);
					g_object_ref_sink (_tmp50_);
					_tmp51_ = _tmp50_;
					_g_free0 (_tmp49_);
					l = _tmp51_;
					_tmp52_ = l;
					gtk_widget_set_halign (G_TYPE_CHECK_INSTANCE_CAST (_tmp52_, gtk_widget_get_type (), GtkWidget), GTK_ALIGN_START);
					_tmp53_ = self->priv->completion_list;
					_tmp54_ = l;
					gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp53_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp54_, gtk_widget_get_type (), GtkWidget));
					_g_object_unref0 (l);
				}
			}
		}
		_tmp55_ = corpus;
		_tmp55__length1 = corpus_length1;
		if (_tmp55__length1 > 0) {
			GtkListBox* _tmp56_;
			GtkListBox* _tmp57_;
			GtkListBoxRow* _tmp58_;
			_tmp56_ = self->priv->completion_list;
			_tmp57_ = self->priv->completion_list;
			_tmp58_ = gtk_list_box_get_row_at_index (_tmp57_, 0);
			gtk_list_box_select_row (_tmp56_, _tmp58_);
			self->priv->current_match = 0;
		}
		_tmp59_ = self->priv->completion_list;
		gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp59_, gtk_widget_get_type (), GtkWidget));
		corpus = (_vala_CbUserInfo_array_free (corpus, corpus_length1), NULL);
	}
	_g_free0 (cur_word);
}


static gchar* completion_text_view_get_cursor_word (CompletionTextView* self, GtkTextIter* start_iter, GtkTextIter* end_iter) {
	GtkTextIter _vala_start_iter = {0};
	GtkTextIter _vala_end_iter = {0};
	gchar* result = NULL;
	GtkTextMark* cursor_mark = NULL;
	GtkTextBuffer* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GtkTextMark* _tmp2_;
	GtkTextMark* _tmp3_;
	GtkTextIter cursor_iter = {0};
	GtkTextBuffer* _tmp4_;
	GtkTextBuffer* _tmp5_;
	GtkTextMark* _tmp6_;
	GtkTextIter _tmp7_ = {0};
	GtkTextIter test_iter = {0};
	GtkTextIter _tmp8_;
	GtkTextIter _tmp31_;
	GtkTextIter _tmp32_;
	GtkTextIter _tmp33_;
	GtkTextIter _tmp34_;
	GtkTextBuffer* _tmp35_;
	GtkTextBuffer* _tmp36_;
	GtkTextIter _tmp37_;
	GtkTextIter _tmp38_;
	gchar* _tmp39_;
	g_return_val_if_fail (IS_COMPLETION_TEXT_VIEW (self), NULL);
	_tmp0_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp1_ = _tmp0_;
	_tmp2_ = gtk_text_buffer_get_insert (_tmp1_);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	cursor_mark = _tmp3_;
	_tmp4_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp5_ = _tmp4_;
	_tmp6_ = cursor_mark;
	gtk_text_buffer_get_iter_at_mark (_tmp5_, &_tmp7_, _tmp6_);
	cursor_iter = _tmp7_;
	memset (&test_iter, 0, sizeof (GtkTextIter));
	_tmp8_ = cursor_iter;
	gtk_text_iter_assign (&test_iter, &_tmp8_);
	{
		gboolean _tmp9_ = FALSE;
		_tmp9_ = TRUE;
		while (TRUE) {
			GtkTextIter left_iter = {0};
			GtkTextIter _tmp10_;
			GtkTextIter _tmp11_;
			gchar* s = NULL;
			GtkTextBuffer* _tmp12_;
			GtkTextBuffer* _tmp13_;
			GtkTextIter _tmp14_;
			GtkTextIter _tmp15_;
			gchar* _tmp16_;
			gunichar c = 0U;
			const gchar* _tmp17_;
			gunichar _tmp18_;
			gboolean _tmp19_ = FALSE;
			const gchar* _tmp20_;
			gint _tmp21_;
			gboolean _tmp24_;
			gboolean _tmp26_ = FALSE;
			gunichar _tmp27_;
			gboolean _tmp28_;
			GtkTextIter _tmp30_;
			if (!_tmp9_) {
			}
			_tmp9_ = FALSE;
			_tmp10_ = test_iter;
			left_iter = _tmp10_;
			_tmp11_ = test_iter;
			gtk_text_iter_assign (&left_iter, &_tmp11_);
			gtk_text_iter_backward_char (&left_iter);
			_tmp12_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
			_tmp13_ = _tmp12_;
			_tmp14_ = left_iter;
			_tmp15_ = test_iter;
			_tmp16_ = gtk_text_buffer_get_text (_tmp13_, &_tmp14_, &_tmp15_, FALSE);
			s = _tmp16_;
			_tmp17_ = s;
			_tmp18_ = string_get_char (_tmp17_, (glong) 0);
			c = _tmp18_;
			_tmp20_ = s;
			_tmp21_ = g_utf8_strlen (_tmp20_, (gssize) -1);
			if (_tmp21_ == 1) {
				_tmp19_ = TRUE;
			} else {
				const gchar* _tmp22_;
				gint _tmp23_;
				_tmp22_ = s;
				_tmp23_ = g_utf8_strlen (_tmp22_, (gssize) -1);
				_tmp19_ = _tmp23_ == 0;
			}
			_vala_assert (_tmp19_, "s.char_count () == 1 ||               s.char_count () == 0");
			_tmp24_ = gtk_text_iter_is_start (&left_iter);
			if (_tmp24_) {
				GtkTextIter _tmp25_;
				_tmp25_ = left_iter;
				gtk_text_iter_assign (&test_iter, &_tmp25_);
			}
			_tmp27_ = c;
			_tmp28_ = g_unichar_isspace (_tmp27_);
			if (_tmp28_) {
				_tmp26_ = TRUE;
			} else {
				gboolean _tmp29_;
				_tmp29_ = gtk_text_iter_is_start (&left_iter);
				_tmp26_ = _tmp29_;
			}
			if (_tmp26_) {
				_g_free0 (s);
				break;
			}
			_tmp30_ = left_iter;
			gtk_text_iter_assign (&test_iter, &_tmp30_);
			_g_free0 (s);
		}
	}
	_tmp31_ = test_iter;
	_vala_start_iter = _tmp31_;
	_tmp32_ = test_iter;
	gtk_text_iter_assign (&_vala_start_iter, &_tmp32_);
	_tmp33_ = cursor_iter;
	_vala_end_iter = _tmp33_;
	_tmp34_ = cursor_iter;
	gtk_text_iter_assign (&_vala_end_iter, &_tmp34_);
	_tmp35_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp36_ = _tmp35_;
	_tmp37_ = test_iter;
	_tmp38_ = cursor_iter;
	_tmp39_ = gtk_text_buffer_get_text (_tmp36_, &_tmp37_, &_tmp38_, FALSE);
	result = _tmp39_;
	_g_object_unref0 (cursor_mark);
	if (start_iter) {
		*start_iter = _vala_start_iter;
	}
	if (end_iter) {
		*end_iter = _vala_end_iter;
	}
	return result;
}


static void completion_text_view_insert_completion (CompletionTextView* self, const gchar* compl) {
	GtkTextBuffer* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GtkTextIter start_word_iter = {0};
	GtkTextIter end_word_iter = {0};
	gchar* word_to_delete = NULL;
	GtkTextIter _tmp2_ = {0};
	GtkTextIter _tmp3_ = {0};
	gchar* _tmp4_;
	GtkTextBuffer* _tmp5_;
	GtkTextBuffer* _tmp6_;
	GtkTextIter _tmp7_;
	GtkTextIter _tmp8_;
	GtkTextMark* cursor_mark = NULL;
	GtkTextBuffer* _tmp9_;
	GtkTextBuffer* _tmp10_;
	GtkTextMark* _tmp11_;
	GtkTextMark* _tmp12_;
	GtkTextBuffer* _tmp13_;
	GtkTextBuffer* _tmp14_;
	GtkTextIter _tmp15_ = {0};
	GtkTextBuffer* _tmp16_;
	GtkTextBuffer* _tmp17_;
	const gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	const gchar* _tmp23_;
	gint _tmp24_;
	gint _tmp25_;
	GtkTextBuffer* _tmp26_;
	GtkTextBuffer* _tmp27_;
	g_return_if_fail (IS_COMPLETION_TEXT_VIEW (self));
	g_return_if_fail (compl != NULL);
	_tmp0_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp1_ = _tmp0_;
	g_object_freeze_notify (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, G_TYPE_OBJECT, GObject));
	_tmp4_ = completion_text_view_get_cursor_word (self, &_tmp2_, &_tmp3_);
	start_word_iter = _tmp2_;
	end_word_iter = _tmp3_;
	word_to_delete = _tmp4_;
	g_debug ("CompletionTextView.vala:346: Delete word: %s", word_to_delete);
	_tmp5_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp6_ = _tmp5_;
	_tmp7_ = start_word_iter;
	_tmp8_ = end_word_iter;
	g_signal_emit_by_name (_tmp6_, "delete-range", &_tmp7_, &_tmp8_);
	_tmp9_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp10_ = _tmp9_;
	_tmp11_ = gtk_text_buffer_get_insert (_tmp10_);
	_tmp12_ = _g_object_ref0 (_tmp11_);
	cursor_mark = _tmp12_;
	_tmp13_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp14_ = _tmp13_;
	gtk_text_buffer_get_iter_at_mark (_tmp14_, &_tmp15_, cursor_mark);
	start_word_iter = _tmp15_;
	_tmp16_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp17_ = _tmp16_;
	_tmp18_ = compl;
	_tmp19_ = g_strconcat ("@", _tmp18_, NULL);
	_tmp20_ = _tmp19_;
	_tmp21_ = g_strconcat (_tmp20_, " ", NULL);
	_tmp22_ = _tmp21_;
	_tmp23_ = compl;
	_tmp24_ = strlen (_tmp23_);
	_tmp25_ = _tmp24_;
	g_signal_emit_by_name (_tmp17_, "insert-text", &start_word_iter, _tmp22_, _tmp25_ + 2);
	_g_free0 (_tmp22_);
	_g_free0 (_tmp20_);
	_tmp26_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp27_ = _tmp26_;
	g_object_thaw_notify (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, G_TYPE_OBJECT, GObject));
	_g_object_unref0 (cursor_mark);
	_g_free0 (word_to_delete);
}


CompletionTextView* completion_text_view_construct (GType object_type) {
	CompletionTextView * self = NULL;
	self = (CompletionTextView*) g_object_new (object_type, NULL);
	return self;
}


CompletionTextView* completion_text_view_new (void) {
	return completion_text_view_construct (TYPE_COMPLETION_TEXT_VIEW);
}


static gboolean _completion_text_view_completion_window_focus_out_cb_gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self) {
	gboolean result;
	result = completion_text_view_completion_window_focus_out_cb ((CompletionTextView*) self);
	return result;
}


static void _completion_text_view_update_completion_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	completion_text_view_update_completion ((CompletionTextView*) self);
}


static void _completion_text_view_buffer_changed_cb_gtk_text_buffer_changed (GtkTextBuffer* _sender, gpointer self) {
	completion_text_view_buffer_changed_cb ((CompletionTextView*) self);
}


static gboolean _completion_text_view_key_press_event_cb_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = completion_text_view_key_press_event_cb ((CompletionTextView*) self, event);
	return result;
}


static GObject * completion_text_view_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	CompletionTextView * self;
	GtkWindow* _tmp0_;
	GtkWindow* _tmp1_;
	GtkWindow* _tmp2_;
	GtkWindow* _tmp3_;
	GdkScreen* _tmp4_;
	GtkListBox* _tmp5_;
	GtkLabel* placeholder_label = NULL;
	GtkLabel* _tmp6_;
	GtkLabel* _tmp7_;
	GtkStyleContext* _tmp8_;
	GtkLabel* _tmp9_;
	GtkListBox* _tmp10_;
	GtkLabel* _tmp11_;
	GtkScrolledWindow* scroller = NULL;
	GtkScrolledWindow* _tmp12_;
	GtkScrolledWindow* _tmp13_;
	GtkListBox* _tmp14_;
	GtkFrame* frame = NULL;
	GtkFrame* _tmp15_;
	GtkFrame* _tmp16_;
	GtkScrolledWindow* _tmp17_;
	GtkWindow* _tmp18_;
	GtkFrame* _tmp19_;
	GtkStyleContext* style_context = NULL;
	GtkStyleContext* _tmp20_;
	GtkStyleContext* _tmp21_;
	GtkStyleContext* _tmp22_;
	GtkStyleContext* _tmp23_;
	GdkRGBA link_color = {0};
	GtkStyleContext* _tmp24_;
	GtkStyleContext* _tmp25_;
	GtkStateFlags _tmp26_;
	GdkRGBA _tmp27_ = {0};
	GtkStyleContext* _tmp28_;
	gboolean _tmp29_ = FALSE;
	gboolean _tmp30_ = FALSE;
	gboolean _tmp31_ = FALSE;
	GdkRGBA _tmp32_;
	gdouble _tmp33_;
	GdkRGBA snippet_color = {0};
	GdkRGBA _tmp41_ = {0};
	GtkTextBuffer* _tmp42_;
	GtkTextBuffer* _tmp43_;
	const gchar* _tmp44_;
	GdkRGBA _tmp45_;
	GtkTextBuffer* _tmp46_;
	GtkTextBuffer* _tmp47_;
	const gchar* _tmp48_;
	GdkRGBA _tmp49_;
	GtkTextBuffer* _tmp50_;
	GtkTextBuffer* _tmp51_;
	const gchar* _tmp52_;
	GdkRGBA _tmp53_;
	GtkTextBuffer* _tmp54_;
	GtkTextBuffer* _tmp55_;
	const gchar* _tmp56_;
	GdkRGBA _tmp57_;
	GtkTextBuffer* _tmp58_;
	GtkTextBuffer* _tmp59_;
	GtkTextBuffer* _tmp60_;
	GtkTextBuffer* _tmp61_;
	GtkTextBuffer* _tmp62_;
	GtkTextBuffer* _tmp63_;
	GspellTextView* gspell_view = NULL;
	GspellTextView* _tmp64_;
	GspellTextView* _tmp65_;
	GspellTextView* _tmp66_;
	GspellTextBuffer* gspell_buffer = NULL;
	GtkTextBuffer* _tmp67_;
	GtkTextBuffer* _tmp68_;
	GspellTextBuffer* _tmp69_;
	GspellTextBuffer* _tmp70_;
	GspellChecker* checker = NULL;
	GspellLanguage* _tmp71_;
	GspellChecker* _tmp72_;
	GspellTextBuffer* _tmp73_;
	GspellChecker* _tmp74_;
	parent_class = G_OBJECT_CLASS (completion_text_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_COMPLETION_TEXT_VIEW, CompletionTextView);
	_tmp0_ = (GtkWindow*) gtk_window_new (GTK_WINDOW_POPUP);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->completion_window);
	self->priv->completion_window = _tmp0_;
	_tmp1_ = self->priv->completion_window;
	gtk_window_set_type_hint (_tmp1_, GDK_WINDOW_TYPE_HINT_COMBO);
	_tmp2_ = self->priv->completion_window;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_widget_get_type (), GtkWidget), "focus-out-event", (GCallback) _completion_text_view_completion_window_focus_out_cb_gtk_widget_focus_out_event, self, 0);
	_tmp3_ = self->priv->completion_window;
	_tmp4_ = gtk_widget_get_screen (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	gtk_window_set_screen (_tmp3_, _tmp4_);
	_tmp5_ = (GtkListBox*) gtk_list_box_new ();
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->completion_list);
	self->priv->completion_list = _tmp5_;
	_tmp6_ = (GtkLabel*) gtk_label_new (_ ("No users found"));
	g_object_ref_sink (_tmp6_);
	placeholder_label = _tmp6_;
	_tmp7_ = placeholder_label;
	_tmp8_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_widget_get_type (), GtkWidget));
	gtk_style_context_add_class (_tmp8_, "dim-label");
	_tmp9_ = placeholder_label;
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_widget_get_type (), GtkWidget));
	_tmp10_ = self->priv->completion_list;
	_tmp11_ = placeholder_label;
	gtk_list_box_set_placeholder (_tmp10_, G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, gtk_widget_get_type (), GtkWidget));
	_tmp12_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_ref_sink (_tmp12_);
	scroller = _tmp12_;
	_tmp13_ = scroller;
	_tmp14_ = self->priv->completion_list;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, gtk_widget_get_type (), GtkWidget));
	_tmp15_ = (GtkFrame*) gtk_frame_new (NULL);
	g_object_ref_sink (_tmp15_);
	frame = _tmp15_;
	_tmp16_ = frame;
	_tmp17_ = scroller;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, gtk_widget_get_type (), GtkWidget));
	_tmp18_ = self->priv->completion_window;
	_tmp19_ = frame;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, gtk_widget_get_type (), GtkWidget));
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), "focus-out-event", (GCallback) _completion_text_view_completion_window_focus_out_cb_gtk_widget_focus_out_event, self, 0);
	_tmp20_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_tmp21_ = _g_object_ref0 (_tmp20_);
	style_context = _tmp21_;
	_tmp22_ = style_context;
	gtk_style_context_save (_tmp22_);
	_tmp23_ = style_context;
	gtk_style_context_set_state (_tmp23_, GTK_STATE_FLAG_LINK);
	_tmp24_ = style_context;
	_tmp25_ = style_context;
	_tmp26_ = gtk_style_context_get_state (_tmp25_);
	gtk_style_context_get_color (_tmp24_, _tmp26_, &_tmp27_);
	link_color = _tmp27_;
	_tmp28_ = style_context;
	gtk_style_context_restore (_tmp28_);
	_tmp32_ = link_color;
	_tmp33_ = _tmp32_.red;
	if (_tmp33_ == 1.0) {
		GdkRGBA _tmp34_;
		gdouble _tmp35_;
		_tmp34_ = link_color;
		_tmp35_ = _tmp34_.green;
		_tmp31_ = _tmp35_ == 1.0;
	} else {
		_tmp31_ = FALSE;
	}
	if (_tmp31_) {
		GdkRGBA _tmp36_;
		gdouble _tmp37_;
		_tmp36_ = link_color;
		_tmp37_ = _tmp36_.blue;
		_tmp30_ = _tmp37_ == 1.0;
	} else {
		_tmp30_ = FALSE;
	}
	if (_tmp30_) {
		GdkRGBA _tmp38_;
		gdouble _tmp39_;
		_tmp38_ = link_color;
		_tmp39_ = _tmp38_.alpha;
		_tmp29_ = _tmp39_ == 1.0;
	} else {
		_tmp29_ = FALSE;
	}
	if (_tmp29_) {
		GdkRGBA _tmp40_ = {0};
		_tmp40_.red = 0.16470;
		_tmp40_.green = 0.462735;
		_tmp40_.blue = 0.77647;
		_tmp40_.alpha = 1.0;
		link_color = _tmp40_;
	}
	_tmp41_.red = 0.0;
	_tmp41_.green = 0.65;
	_tmp41_.blue = 0.0627;
	_tmp41_.alpha = 1.0;
	snippet_color = _tmp41_;
	_tmp42_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp43_ = _tmp42_;
	_tmp44_ = COMPLETION_TEXT_VIEW_TEXT_TAGS[0];
	_tmp45_ = link_color;
	gtk_text_buffer_create_tag (_tmp43_, _tmp44_, "foreground_rgba", &_tmp45_, NULL, NULL);
	_tmp46_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp47_ = _tmp46_;
	_tmp48_ = COMPLETION_TEXT_VIEW_TEXT_TAGS[1];
	_tmp49_ = link_color;
	gtk_text_buffer_create_tag (_tmp47_, _tmp48_, "foreground_rgba", &_tmp49_, NULL, NULL);
	_tmp50_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp51_ = _tmp50_;
	_tmp52_ = COMPLETION_TEXT_VIEW_TEXT_TAGS[2];
	_tmp53_ = link_color;
	gtk_text_buffer_create_tag (_tmp51_, _tmp52_, "foreground_rgba", &_tmp53_, NULL, NULL);
	_tmp54_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp55_ = _tmp54_;
	_tmp56_ = COMPLETION_TEXT_VIEW_TEXT_TAGS[3];
	_tmp57_ = snippet_color;
	gtk_text_buffer_create_tag (_tmp55_, _tmp56_, "foreground_rgba", &_tmp57_, NULL, NULL);
	_tmp58_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp59_ = _tmp58_;
	gtk_text_buffer_create_tag (_tmp59_, TWEET_UTILS_NO_SPELL_CHECK, NULL, NULL);
	_tmp60_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp61_ = _tmp60_;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp61_, G_TYPE_OBJECT, GObject), "notify::cursor-position", (GCallback) _completion_text_view_update_completion_g_object_notify, self, 0);
	_tmp62_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp63_ = _tmp62_;
	g_signal_connect_object (_tmp63_, "changed", (GCallback) _completion_text_view_buffer_changed_cb_gtk_text_buffer_changed, self, 0);
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), "key-press-event", (GCallback) _completion_text_view_key_press_event_cb_gtk_widget_key_press_event, self, 0);
	gtk_text_view_set_right_margin (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView), 6);
	gtk_text_view_set_left_margin (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView), 6);
	gtk_text_view_set_top_margin (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView), 6);
	gtk_text_view_set_bottom_margin (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView), 6);
	_tmp64_ = gspell_text_view_get_from_gtk_text_view (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp65_ = _g_object_ref0 (_tmp64_);
	gspell_view = _tmp65_;
	_tmp66_ = gspell_view;
	gspell_text_view_set_inline_spell_checking (_tmp66_, TRUE);
	_tmp67_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp68_ = _tmp67_;
	_tmp69_ = gspell_text_buffer_get_from_gtk_text_buffer (_tmp68_);
	_tmp70_ = _g_object_ref0 (_tmp69_);
	gspell_buffer = _tmp70_;
	_tmp71_ = gspell_language_get_default ();
	_tmp72_ = gspell_checker_new (_tmp71_);
	checker = _tmp72_;
	_tmp73_ = gspell_buffer;
	_tmp74_ = checker;
	gspell_text_buffer_set_spell_checker (_tmp73_, _tmp74_);
	_g_object_unref0 (checker);
	_g_object_unref0 (gspell_buffer);
	_g_object_unref0 (gspell_view);
	_g_object_unref0 (style_context);
	_g_object_unref0 (frame);
	_g_object_unref0 (scroller);
	_g_object_unref0 (placeholder_label);
	return obj;
}


static void completion_text_view_class_init (CompletionTextViewClass * klass) {
	completion_text_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (CompletionTextViewPrivate));
	G_OBJECT_CLASS (klass)->constructor = completion_text_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = completion_text_view_finalize;
}


static void completion_text_view_instance_init (CompletionTextView * self) {
	self->priv = COMPLETION_TEXT_VIEW_GET_PRIVATE (self);
	self->priv->current_match = 0;
	self->priv->current_word = NULL;
}


static void completion_text_view_finalize (GObject * obj) {
	CompletionTextView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_COMPLETION_TEXT_VIEW, CompletionTextView);
	_g_object_unref0 (self->priv->completion_list);
	_g_object_unref0 (self->priv->completion_window);
	_g_free0 (self->priv->current_word);
	G_OBJECT_CLASS (completion_text_view_parent_class)->finalize (obj);
}


GType completion_text_view_get_type (void) {
	static volatile gsize completion_text_view_type_id__volatile = 0;
	if (g_once_init_enter (&completion_text_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CompletionTextViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) completion_text_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CompletionTextView), 0, (GInstanceInitFunc) completion_text_view_instance_init, NULL };
		GType completion_text_view_type_id;
		completion_text_view_type_id = g_type_register_static (gtk_text_view_get_type (), "CompletionTextView", &g_define_type_info, 0);
		g_once_init_leave (&completion_text_view_type_id__volatile, completion_text_view_type_id);
	}
	return completion_text_view_type_id__volatile;
}



