/* AccountDialog.c generated by valac 0.34.6, the Vala compiler
 * generated from AccountDialog.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gio/gio.h>
#include <rest/oauth-proxy.h>
#include "CbUserCounter.h"
#include "CbFilter.h"
#include <rest/rest-proxy-call.h>
#include <rest/rest-proxy.h>
#include <cairo.h>
#include <gdk/gdk.h>
#include <glib/gstdio.h>
#include <sqlite3.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>


#define TYPE_ACCOUNT_DIALOG (account_dialog_get_type ())
#define ACCOUNT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT_DIALOG, AccountDialog))
#define ACCOUNT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT_DIALOG, AccountDialogClass))
#define IS_ACCOUNT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT_DIALOG))
#define IS_ACCOUNT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT_DIALOG))
#define ACCOUNT_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT_DIALOG, AccountDialogClass))

typedef struct _AccountDialog AccountDialog;
typedef struct _AccountDialogClass AccountDialogClass;
typedef struct _AccountDialogPrivate AccountDialogPrivate;

#define TYPE_AVATAR_BANNER_WIDGET (avatar_banner_widget_get_type ())
#define AVATAR_BANNER_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AVATAR_BANNER_WIDGET, AvatarBannerWidget))
#define AVATAR_BANNER_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AVATAR_BANNER_WIDGET, AvatarBannerWidgetClass))
#define IS_AVATAR_BANNER_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AVATAR_BANNER_WIDGET))
#define IS_AVATAR_BANNER_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AVATAR_BANNER_WIDGET))
#define AVATAR_BANNER_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AVATAR_BANNER_WIDGET, AvatarBannerWidgetClass))

typedef struct _AvatarBannerWidget AvatarBannerWidget;
typedef struct _AvatarBannerWidgetClass AvatarBannerWidgetClass;

#define TYPE_COMPLETION_TEXT_VIEW (completion_text_view_get_type ())
#define COMPLETION_TEXT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPLETION_TEXT_VIEW, CompletionTextView))
#define COMPLETION_TEXT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPLETION_TEXT_VIEW, CompletionTextViewClass))
#define IS_COMPLETION_TEXT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPLETION_TEXT_VIEW))
#define IS_COMPLETION_TEXT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPLETION_TEXT_VIEW))
#define COMPLETION_TEXT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPLETION_TEXT_VIEW, CompletionTextViewClass))

typedef struct _CompletionTextView CompletionTextView;
typedef struct _CompletionTextViewClass CompletionTextViewClass;

#define TYPE_CROP_WIDGET (crop_widget_get_type ())
#define CROP_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CROP_WIDGET, CropWidget))
#define CROP_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CROP_WIDGET, CropWidgetClass))
#define IS_CROP_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CROP_WIDGET))
#define IS_CROP_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CROP_WIDGET))
#define CROP_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CROP_WIDGET, CropWidgetClass))

typedef struct _CropWidget CropWidget;
typedef struct _CropWidgetClass CropWidgetClass;

#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block74Data Block74Data;
typedef struct _AccountPrivate AccountPrivate;

#define SQL_TYPE_DATABASE (sql_database_get_type ())
#define SQL_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_DATABASE, SqlDatabase))
#define SQL_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_DATABASE, SqlDatabaseClass))
#define SQL_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_DATABASE))
#define SQL_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_DATABASE))
#define SQL_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_DATABASE, SqlDatabaseClass))

typedef struct _SqlDatabase SqlDatabase;
typedef struct _SqlDatabaseClass SqlDatabaseClass;

#define TYPE_USER_STREAM (user_stream_get_type ())
#define USER_STREAM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_USER_STREAM, UserStream))
#define USER_STREAM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_USER_STREAM, UserStreamClass))
#define IS_USER_STREAM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_USER_STREAM))
#define IS_USER_STREAM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_USER_STREAM))
#define USER_STREAM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_USER_STREAM, UserStreamClass))

typedef struct _UserStream UserStream;
typedef struct _UserStreamClass UserStreamClass;

#define TYPE_NOTIFICATION_MANAGER (notification_manager_get_type ())
#define NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManager))
#define NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))
#define IS_NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFICATION_MANAGER))
#define IS_NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFICATION_MANAGER))
#define NOTIFICATION_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))

typedef struct _NotificationManager NotificationManager;
typedef struct _NotificationManagerClass NotificationManagerClass;
typedef struct _Block75Data Block75Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block76Data Block76Data;
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
typedef struct _Block77Data Block77Data;

#define TYPE_COREBIRD (corebird_get_type ())
#define COREBIRD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COREBIRD, Corebird))
#define COREBIRD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COREBIRD, CorebirdClass))
#define IS_COREBIRD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COREBIRD))
#define IS_COREBIRD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COREBIRD))
#define COREBIRD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COREBIRD, CorebirdClass))

typedef struct _Corebird Corebird;
typedef struct _CorebirdClass CorebirdClass;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;
typedef struct _MainWindowPrivate MainWindowPrivate;

#define TYPE_MAIN_WIDGET (main_widget_get_type ())
#define MAIN_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WIDGET, MainWidget))
#define MAIN_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WIDGET, MainWidgetClass))
#define IS_MAIN_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WIDGET))
#define IS_MAIN_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WIDGET))
#define MAIN_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WIDGET, MainWidgetClass))

typedef struct _MainWidget MainWidget;
typedef struct _MainWidgetClass MainWidgetClass;
typedef struct _Block78Data Block78Data;

struct _AccountDialog {
	GtkWindow parent_instance;
	AccountDialogPrivate * priv;
};

struct _AccountDialogClass {
	GtkWindowClass parent_class;
};

struct _AccountDialogPrivate {
	GtkEntry* name_entry;
	AvatarBannerWidget* avatar_banner_widget;
	GtkStack* delete_stack;
	GtkSwitch* autostart_switch;
	GtkEntry* website_entry;
	CompletionTextView* description_text_view;
	CropWidget* crop_widget;
	GtkStack* content_stack;
	GtkBox* info_box;
	GtkLabel* error_label;
	GtkButton* save_button;
	Account* account;
	gchar* old_user_name;
	gchar* old_description;
	gchar* old_website;
	GdkPixbuf* new_avatar;
	GdkPixbuf* new_banner;
	gint old_width;
	gint old_height;
};

struct _Block74Data {
	int _ref_count_;
	AccountDialog* self;
	Account* account;
};

struct _Account {
	GObject parent_instance;
	AccountPrivate * priv;
	gint64 id;
	SqlDatabase* db;
	OAuthProxy* proxy;
	UserStream* user_stream;
	CbUserCounter* user_counter;
	NotificationManager* notifications;
	gint64* friends;
	gint friends_length1;
	gint64* blocked;
	gint blocked_length1;
	gint64* muted;
	gint muted_length1;
	gint64* disabled_rts;
	gint disabled_rts_length1;
	GPtrArray* filters;
};

struct _AccountClass {
	GObjectClass parent_class;
};

struct _Block75Data {
	int _ref_count_;
	AccountDialog* self;
	RestProxyCall* call;
};

struct _Block76Data {
	int _ref_count_;
	AccountDialog* self;
	RestProxyCall* call;
};

struct _Block77Data {
	int _ref_count_;
	AccountDialog* self;
	RestProxyCall* call;
};

struct _MainWindow {
	GtkApplicationWindow parent_instance;
	MainWindowPrivate * priv;
	GtkButton* back_button;
	GtkToggleButton* compose_tweet_button;
	MainWidget* main_widget;
	Account* account;
};

struct _MainWindowClass {
	GtkApplicationWindowClass parent_class;
};

struct _Block78Data {
	int _ref_count_;
	AccountDialog* self;
	GtkFileChooserDialog* filechooser;
};


static gpointer account_dialog_parent_class = NULL;
extern SqlDatabase* corebird_db;

GType account_dialog_get_type (void) G_GNUC_CONST;
GType avatar_banner_widget_get_type (void) G_GNUC_CONST;
GType completion_text_view_get_type (void) G_GNUC_CONST;
GType crop_widget_get_type (void) G_GNUC_CONST;
GType account_get_type (void) G_GNUC_CONST;
#define ACCOUNT_DIALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_ACCOUNT_DIALOG, AccountDialogPrivate))
enum  {
	ACCOUNT_DIALOG_DUMMY_PROPERTY
};
#define ACCOUNT_DIALOG_PAGE_NORMAL "normal"
#define ACCOUNT_DIALOG_PAGE_DELETE "delete"
AccountDialog* account_dialog_new (Account* account);
AccountDialog* account_dialog_construct (GType object_type, Account* account);
static Block74Data* block74_data_ref (Block74Data* _data74_);
static void block74_data_unref (void * _userdata_);
const gchar* account_get_name (Account* self);
void avatar_banner_widget_set_account (AvatarBannerWidget* self, Account* account);
void completion_text_view_set_account (CompletionTextView* self, Account* account);
static void account_dialog_set_transient_data (AccountDialog* self, const gchar* website, const gchar* description);
const gchar* account_get_website (Account* self);
const gchar* account_get_description (Account* self);
GSettings* settings_get (void);
const gchar* account_get_screen_name (Account* self);
static void __lambda138_ (AccountDialog* self, GdkPixbuf* p);
static void ___lambda138__avatar_banner_widget_avatar_changed (AvatarBannerWidget* _sender, GdkPixbuf* new_avatar, gpointer self);
static void __lambda139_ (AccountDialog* self, GdkPixbuf* b);
static void ___lambda139__avatar_banner_widget_banner_changed (AvatarBannerWidget* _sender, GdkPixbuf* new_banner, gpointer self);
GType sql_database_get_type (void) G_GNUC_CONST;
GType user_stream_get_type (void) G_GNUC_CONST;
GType notification_manager_get_type (void) G_GNUC_CONST;
void account_init_proxy (Account* self, gboolean load_secrets, gboolean force);
void account_query_user_info_by_screen_name (Account* self, const gchar* screen_name, GAsyncReadyCallback _callback_, gpointer _user_data_);
void account_query_user_info_by_screen_name_finish (Account* self, GAsyncResult* _res_);
static void ___lambda140_ (Block74Data* _data74_, GObject* obj, GAsyncResult* res);
static void ____lambda140__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void account_dialog_delete_button_clicked_cb (AccountDialog* self);
static void _account_dialog_delete_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void account_dialog_save_data (AccountDialog* self);
static Block75Data* block75_data_ref (Block75Data* _data75_);
static void block75_data_unref (void * _userdata_);
static void ___lambda141_ (Block75Data* _data75_, GObject* obj, GAsyncResult* res);
void utils_show_error_object (const gchar* json_data, const gchar* alternative, gint line, const gchar* file, GtkWindow* transient_for);
static void ____lambda141__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
void account_set_name (Account* self, const gchar* value);
void account_set_description (Account* self, const gchar* value);
void account_set_website (Account* self, const gchar* value);
static Block76Data* block76_data_ref (Block76Data* _data76_);
static void block76_data_unref (void * _userdata_);
static void ___lambda142_ (Block76Data* _data76_, GObject* obj, GAsyncResult* res);
void account_set_new_avatar (Account* self, cairo_surface_t* new_avatar);
static void ____lambda142__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static Block77Data* block77_data_ref (Block77Data* _data77_);
static void block77_data_unref (void * _userdata_);
static void ___lambda143_ (Block77Data* _data77_, GObject* obj, GAsyncResult* res);
static void ____lambda143__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void account_dialog_delete_confirm_button_clicked_cb (AccountDialog* self);
gchar* dirs_config (const gchar* path);
void sql_database_exec (SqlDatabase* self, const gchar* sql, sqlite3_callback callback, void* callback_target);
GType corebird_get_type (void) G_GNUC_CONST;
GType main_window_get_type (void) G_GNUC_CONST;
GType main_widget_get_type (void) G_GNUC_CONST;
void main_window_change_account (MainWindow* self, Account* account);
Account* account_query_account_by_id (gint64 id);
void account_remove_account (const gchar* screen_name);
static void _account_dialog_delete_confirm_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void account_dialog_delete_cancel_button_clicked_cb (AccountDialog* self);
static void _account_dialog_delete_cancel_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void account_dialog_autostart_switch_activate_cb (AccountDialog* self);
static void _account_dialog_autostart_switch_activate_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void account_dialog_show_crop_image_selector (AccountDialog* self);
static Block78Data* block78_data_ref (Block78Data* _data78_);
static void block78_data_unref (void * _userdata_);
static void __lambda149_ (Block78Data* _data78_, gint id);
gdouble crop_widget_get_desired_aspect_ratio (CropWidget* self);
void crop_widget_set_image (CropWidget* self, GdkPixbuf* image);
static void ___lambda149__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static void account_dialog_avatar_clicked_cb (AccountDialog* self);
void crop_widget_set_desired_aspect_ratio (CropWidget* self, gdouble value);
void crop_widget_set_min_size (CropWidget* self, gint min_width);
static void _account_dialog_avatar_clicked_cb_avatar_banner_widget_avatar_clicked (AvatarBannerWidget* _sender, gpointer self);
static void account_dialog_banner_clicked_cb (AccountDialog* self);
static void _account_dialog_banner_clicked_cb_avatar_banner_widget_banner_clicked (AvatarBannerWidget* _sender, gpointer self);
static void account_dialog_cancel_button_clicked_cb (AccountDialog* self);
static void _account_dialog_cancel_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void account_dialog_save_button_clicked_cb (AccountDialog* self);
GdkPixbuf* crop_widget_get_cropped_image (CropWidget* self);
void avatar_banner_widget_set_avatar (AvatarBannerWidget* self, GdkPixbuf* avatar);
void avatar_banner_widget_set_banner (AvatarBannerWidget* self, GdkPixbuf* banner);
static void _account_dialog_save_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void account_dialog_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static Block74Data* block74_data_ref (Block74Data* _data74_) {
	g_atomic_int_inc (&_data74_->_ref_count_);
	return _data74_;
}


static void block74_data_unref (void * _userdata_) {
	Block74Data* _data74_;
	_data74_ = (Block74Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data74_->_ref_count_)) {
		AccountDialog* self;
		self = _data74_->self;
		_g_object_unref0 (_data74_->account);
		_g_object_unref0 (self);
		g_slice_free (Block74Data, _data74_);
	}
}


static void __lambda138_ (AccountDialog* self, GdkPixbuf* p) {
	GdkPixbuf* _tmp0_ = NULL;
	GdkPixbuf* _tmp1_ = NULL;
	g_return_if_fail (GDK_IS_PIXBUF (p));
	_tmp0_ = p;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->new_avatar);
	self->priv->new_avatar = _tmp1_;
}


static void ___lambda138__avatar_banner_widget_avatar_changed (AvatarBannerWidget* _sender, GdkPixbuf* new_avatar, gpointer self) {
	__lambda138_ ((AccountDialog*) self, new_avatar);
}


static void __lambda139_ (AccountDialog* self, GdkPixbuf* b) {
	GdkPixbuf* _tmp0_ = NULL;
	GdkPixbuf* _tmp1_ = NULL;
	g_return_if_fail (GDK_IS_PIXBUF (b));
	_tmp0_ = b;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->new_banner);
	self->priv->new_banner = _tmp1_;
}


static void ___lambda139__avatar_banner_widget_banner_changed (AvatarBannerWidget* _sender, GdkPixbuf* new_banner, gpointer self) {
	__lambda139_ ((AccountDialog*) self, new_banner);
}


static void ___lambda140_ (Block74Data* _data74_, GObject* obj, GAsyncResult* res) {
	AccountDialog* self;
	Account* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	Account* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	self = _data74_->self;
	g_return_if_fail ((obj == NULL) || G_IS_OBJECT (obj));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	_tmp0_ = _data74_->account;
	_tmp1_ = account_get_website (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _data74_->account;
	_tmp4_ = account_get_description (_tmp3_);
	_tmp5_ = _tmp4_;
	account_dialog_set_transient_data (self, _tmp2_, _tmp5_);
}


static void ____lambda140__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	___lambda140_ (self, source_object, res);
	block74_data_unref (self);
}


AccountDialog* account_dialog_construct (GType object_type, Account* account) {
	AccountDialog * self = NULL;
	Block74Data* _data74_;
	Account* _tmp0_ = NULL;
	Account* _tmp1_ = NULL;
	Account* _tmp2_ = NULL;
	GtkEntry* _tmp3_ = NULL;
	Account* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	AvatarBannerWidget* _tmp7_ = NULL;
	Account* _tmp8_ = NULL;
	CompletionTextView* _tmp9_ = NULL;
	Account* _tmp10_ = NULL;
	Account* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	Account* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	GtkSwitch* _tmp17_ = NULL;
	gchar** startup_accounts = NULL;
	GSettings* _tmp18_ = NULL;
	GSettings* _tmp19_ = NULL;
	gchar** _tmp20_ = NULL;
	gchar** _tmp21_ = NULL;
	gchar** _tmp22_ = NULL;
	gint _tmp22__length1 = 0;
	gint startup_accounts_length1 = 0;
	gint _startup_accounts_size_ = 0;
	gchar** _tmp23_ = NULL;
	gint _tmp23__length1 = 0;
	GtkSwitch* _tmp29_ = NULL;
	AvatarBannerWidget* _tmp30_ = NULL;
	AvatarBannerWidget* _tmp31_ = NULL;
	Account* _tmp32_ = NULL;
	OAuthProxy* _tmp33_ = NULL;
	g_return_val_if_fail (IS_ACCOUNT (account), NULL);
	_data74_ = g_slice_new0 (Block74Data);
	_data74_->_ref_count_ = 1;
	_tmp0_ = account;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data74_->account);
	_data74_->account = _tmp1_;
	self = (AccountDialog*) g_object_new (object_type, NULL);
	_data74_->self = g_object_ref (self);
	_tmp2_ = _data74_->account;
	self->priv->account = _tmp2_;
	_tmp3_ = self->priv->name_entry;
	_tmp4_ = _data74_->account;
	_tmp5_ = account_get_name (_tmp4_);
	_tmp6_ = _tmp5_;
	gtk_entry_set_text (_tmp3_, _tmp6_);
	_tmp7_ = self->priv->avatar_banner_widget;
	_tmp8_ = _data74_->account;
	avatar_banner_widget_set_account (_tmp7_, _tmp8_);
	_tmp9_ = self->priv->description_text_view;
	_tmp10_ = _data74_->account;
	completion_text_view_set_account (_tmp9_, _tmp10_);
	_tmp11_ = _data74_->account;
	_tmp12_ = account_get_website (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = _data74_->account;
	_tmp15_ = account_get_description (_tmp14_);
	_tmp16_ = _tmp15_;
	account_dialog_set_transient_data (self, _tmp13_, _tmp16_);
	_tmp17_ = self->priv->autostart_switch;
	g_object_freeze_notify (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, G_TYPE_OBJECT, GObject));
	_tmp18_ = settings_get ();
	_tmp19_ = _tmp18_;
	_tmp21_ = _tmp20_ = g_settings_get_strv (_tmp19_, "startup-accounts");
	_tmp22_ = _tmp21_;
	_tmp22__length1 = _vala_array_length (_tmp20_);
	_g_object_unref0 (_tmp19_);
	startup_accounts = _tmp22_;
	startup_accounts_length1 = _tmp22__length1;
	_startup_accounts_size_ = startup_accounts_length1;
	_tmp23_ = startup_accounts;
	_tmp23__length1 = startup_accounts_length1;
	{
		gchar** acc_collection = NULL;
		gint acc_collection_length1 = 0;
		gint _acc_collection_size_ = 0;
		gint acc_it = 0;
		acc_collection = _tmp23_;
		acc_collection_length1 = _tmp23__length1;
		for (acc_it = 0; acc_it < _tmp23__length1; acc_it = acc_it + 1) {
			const gchar* acc = NULL;
			acc = acc_collection[acc_it];
			{
				const gchar* _tmp24_ = NULL;
				Account* _tmp25_ = NULL;
				const gchar* _tmp26_ = NULL;
				const gchar* _tmp27_ = NULL;
				_tmp24_ = acc;
				_tmp25_ = self->priv->account;
				_tmp26_ = account_get_screen_name (_tmp25_);
				_tmp27_ = _tmp26_;
				if (g_strcmp0 (_tmp24_, _tmp27_) == 0) {
					GtkSwitch* _tmp28_ = NULL;
					_tmp28_ = self->priv->autostart_switch;
					gtk_switch_set_active (_tmp28_, TRUE);
					break;
				}
			}
		}
	}
	_tmp29_ = self->priv->autostart_switch;
	g_object_thaw_notify (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, G_TYPE_OBJECT, GObject));
	_tmp30_ = self->priv->avatar_banner_widget;
	g_signal_connect_object (_tmp30_, "avatar-changed", (GCallback) ___lambda138__avatar_banner_widget_avatar_changed, self, 0);
	_tmp31_ = self->priv->avatar_banner_widget;
	g_signal_connect_object (_tmp31_, "banner-changed", (GCallback) ___lambda139__avatar_banner_widget_banner_changed, self, 0);
	_tmp32_ = _data74_->account;
	_tmp33_ = _tmp32_->proxy;
	if (_tmp33_ == NULL) {
		Account* _tmp34_ = NULL;
		Account* _tmp35_ = NULL;
		_tmp34_ = _data74_->account;
		account_init_proxy (_tmp34_, TRUE, FALSE);
		_tmp35_ = _data74_->account;
		account_query_user_info_by_screen_name (_tmp35_, NULL, ____lambda140__gasync_ready_callback, block74_data_ref (_data74_));
	}
	startup_accounts = (_vala_array_free (startup_accounts, startup_accounts_length1, (GDestroyNotify) g_free), NULL);
	block74_data_unref (_data74_);
	_data74_ = NULL;
	return self;
}


AccountDialog* account_dialog_new (Account* account) {
	return account_dialog_construct (TYPE_ACCOUNT_DIALOG, account);
}


static void account_dialog_set_transient_data (AccountDialog* self, const gchar* website, const gchar* description) {
	const gchar* _tmp0_ = NULL;
	Account* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	GtkEntry* _tmp4_ = NULL;
	Account* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	Account* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	Account* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	Account* _tmp20_ = NULL;
	const gchar* _tmp21_ = NULL;
	const gchar* _tmp22_ = NULL;
	CompletionTextView* _tmp23_ = NULL;
	GtkTextBuffer* _tmp24_ = NULL;
	g_return_if_fail (IS_ACCOUNT_DIALOG (self));
	_tmp1_ = self->priv->account;
	_tmp2_ = account_get_website (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp0_ = _tmp3_;
	if (_tmp0_ == NULL) {
		_tmp0_ = "";
	}
	_tmp4_ = self->priv->website_entry;
	gtk_entry_set_text (_tmp4_, _tmp0_);
	_tmp5_ = self->priv->account;
	_tmp6_ = account_get_name (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strdup (_tmp7_);
	_g_free0 (self->priv->old_user_name);
	self->priv->old_user_name = _tmp8_;
	_tmp10_ = self->priv->account;
	_tmp11_ = account_get_website (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp9_ = _tmp12_;
	if (_tmp9_ == NULL) {
		_tmp9_ = "";
	}
	_tmp13_ = g_strdup (_tmp9_);
	_g_free0 (self->priv->old_website);
	self->priv->old_website = _tmp13_;
	_tmp15_ = self->priv->account;
	_tmp16_ = account_get_description (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp14_ = _tmp17_;
	if (_tmp14_ == NULL) {
		_tmp14_ = "";
	}
	_tmp18_ = g_strdup (_tmp14_);
	_g_free0 (self->priv->old_description);
	self->priv->old_description = _tmp18_;
	_tmp20_ = self->priv->account;
	_tmp21_ = account_get_description (_tmp20_);
	_tmp22_ = _tmp21_;
	_tmp19_ = _tmp22_;
	if (_tmp19_ == NULL) {
		_tmp19_ = "";
	}
	_tmp23_ = self->priv->description_text_view;
	_tmp24_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, gtk_text_view_get_type (), GtkTextView));
	gtk_text_buffer_set_text (_tmp24_, _tmp19_, -1);
}


static void account_dialog_delete_button_clicked_cb (AccountDialog* self) {
	GtkStack* _tmp0_ = NULL;
	g_return_if_fail (IS_ACCOUNT_DIALOG (self));
	_tmp0_ = self->priv->delete_stack;
	gtk_stack_set_visible_child_name (_tmp0_, ACCOUNT_DIALOG_PAGE_DELETE);
}


static void _account_dialog_delete_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	account_dialog_delete_button_clicked_cb ((AccountDialog*) self);
}


static Block75Data* block75_data_ref (Block75Data* _data75_) {
	g_atomic_int_inc (&_data75_->_ref_count_);
	return _data75_;
}


static void block75_data_unref (void * _userdata_) {
	Block75Data* _data75_;
	_data75_ = (Block75Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data75_->_ref_count_)) {
		AccountDialog* self;
		self = _data75_->self;
		_g_object_unref0 (_data75_->call);
		_g_object_unref0 (self);
		g_slice_free (Block75Data, _data75_);
	}
}


static void ___lambda141_ (Block75Data* _data75_, GObject* obj, GAsyncResult* res) {
	AccountDialog* self;
	GError * _inner_error_ = NULL;
	self = _data75_->self;
	g_return_if_fail ((obj == NULL) || G_IS_OBJECT (obj));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	{
		RestProxyCall* _tmp0_ = NULL;
		GAsyncResult* _tmp1_ = NULL;
		_tmp0_ = _data75_->call;
		_tmp1_ = res;
		rest_proxy_call_invoke_finish (_tmp0_, _tmp1_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch89_g_error;
		}
	}
	goto __finally89;
	__catch89_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		RestProxyCall* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_warning ("AccountDialog.vala:135: %s", _tmp3_);
		_tmp4_ = _data75_->call;
		_tmp5_ = rest_proxy_call_get_payload (_tmp4_);
		utils_show_error_object (_tmp5_, "Could not update profile", 137, "AccountDialog.vala", G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow));
		_g_error_free0 (e);
	}
	__finally89:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void ____lambda141__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	___lambda141_ (self, source_object, res);
	block75_data_unref (self);
}


static Block76Data* block76_data_ref (Block76Data* _data76_) {
	g_atomic_int_inc (&_data76_->_ref_count_);
	return _data76_;
}


static void block76_data_unref (void * _userdata_) {
	Block76Data* _data76_;
	_data76_ = (Block76Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data76_->_ref_count_)) {
		AccountDialog* self;
		self = _data76_->self;
		_g_object_unref0 (_data76_->call);
		_g_object_unref0 (self);
		g_slice_free (Block76Data, _data76_);
	}
}


static void ___lambda142_ (Block76Data* _data76_, GObject* obj, GAsyncResult* res) {
	AccountDialog* self;
	cairo_surface_t* s = NULL;
	GdkPixbuf* _tmp4_ = NULL;
	cairo_surface_t* _tmp5_ = NULL;
	Account* _tmp6_ = NULL;
	cairo_surface_t* _tmp7_ = NULL;
	GError * _inner_error_ = NULL;
	self = _data76_->self;
	g_return_if_fail ((obj == NULL) || G_IS_OBJECT (obj));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	{
		RestProxyCall* _tmp0_ = NULL;
		GAsyncResult* _tmp1_ = NULL;
		_tmp0_ = _data76_->call;
		_tmp1_ = res;
		rest_proxy_call_invoke_finish (_tmp0_, _tmp1_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch91_g_error;
		}
		g_debug ("AccountDialog.vala:167: Avatar successfully updated");
	}
	goto __finally91;
	__catch91_g_error:
	{
		GError* e = NULL;
		RestProxyCall* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = _data76_->call;
		_tmp3_ = rest_proxy_call_get_payload (_tmp2_);
		utils_show_error_object (_tmp3_, "Could not update your avatar", 170, "AccountDialog.vala", G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow));
		_g_error_free0 (e);
		return;
	}
	__finally91:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp4_ = self->priv->new_avatar;
	_tmp5_ = gdk_cairo_surface_create_from_pixbuf (_tmp4_, 1, NULL);
	s = _tmp5_;
	_tmp6_ = self->priv->account;
	_tmp7_ = s;
	account_set_new_avatar (_tmp6_, _tmp7_);
	_cairo_surface_destroy0 (s);
}


static void ____lambda142__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	___lambda142_ (self, source_object, res);
	block76_data_unref (self);
}


static Block77Data* block77_data_ref (Block77Data* _data77_) {
	g_atomic_int_inc (&_data77_->_ref_count_);
	return _data77_;
}


static void block77_data_unref (void * _userdata_) {
	Block77Data* _data77_;
	_data77_ = (Block77Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data77_->_ref_count_)) {
		AccountDialog* self;
		self = _data77_->self;
		_g_object_unref0 (_data77_->call);
		_g_object_unref0 (self);
		g_slice_free (Block77Data, _data77_);
	}
}


static void ___lambda143_ (Block77Data* _data77_, GObject* obj, GAsyncResult* res) {
	AccountDialog* self;
	GError * _inner_error_ = NULL;
	self = _data77_->self;
	g_return_if_fail ((obj == NULL) || G_IS_OBJECT (obj));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	{
		RestProxyCall* _tmp0_ = NULL;
		GAsyncResult* _tmp1_ = NULL;
		_tmp0_ = _data77_->call;
		_tmp1_ = res;
		rest_proxy_call_invoke_finish (_tmp0_, _tmp1_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch93_g_error;
		}
		g_debug ("AccountDialog.vala:200: Banner succesfully updated");
	}
	goto __finally93;
	__catch93_g_error:
	{
		GError* e = NULL;
		RestProxyCall* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = _data77_->call;
		_tmp3_ = rest_proxy_call_get_payload (_tmp2_);
		utils_show_error_object (_tmp3_, "Could not update your banner", 203, "AccountDialog.vala", G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow));
		_g_error_free0 (e);
	}
	__finally93:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void ____lambda143__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	___lambda143_ (self, source_object, res);
	block77_data_unref (self);
}


static void account_dialog_save_data (AccountDialog* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_ = NULL;
	GtkEntry* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gboolean needs_save = FALSE;
	gboolean _tmp17_ = FALSE;
	gboolean _tmp18_ = FALSE;
	gboolean _tmp19_ = FALSE;
	gboolean needs_init = FALSE;
	gboolean _tmp22_ = FALSE;
	gboolean _tmp23_ = FALSE;
	gboolean _tmp27_ = FALSE;
	GdkPixbuf* _tmp64_ = NULL;
	GdkPixbuf* _tmp82_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (IS_ACCOUNT_DIALOG (self));
	_tmp2_ = self->priv->old_user_name;
	_tmp3_ = self->priv->name_entry;
	_tmp4_ = gtk_entry_get_text (_tmp3_);
	_tmp5_ = _tmp4_;
	if (g_strcmp0 (_tmp2_, _tmp5_) != 0) {
		_tmp1_ = TRUE;
	} else {
		const gchar* _tmp6_ = NULL;
		CompletionTextView* _tmp7_ = NULL;
		GtkTextBuffer* _tmp8_ = NULL;
		GtkTextBuffer* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		_tmp6_ = self->priv->old_description;
		_tmp7_ = self->priv->description_text_view;
		_tmp8_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_text_view_get_type (), GtkTextView));
		_tmp9_ = _tmp8_;
		g_object_get (_tmp9_, "text", &_tmp10_, NULL);
		_tmp11_ = _tmp10_;
		_tmp12_ = _tmp11_;
		_tmp1_ = g_strcmp0 (_tmp6_, _tmp12_) != 0;
		_g_free0 (_tmp12_);
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp13_ = NULL;
		GtkEntry* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		_tmp13_ = self->priv->old_website;
		_tmp14_ = self->priv->website_entry;
		_tmp15_ = gtk_entry_get_text (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp0_ = g_strcmp0 (_tmp13_, _tmp16_) != 0;
	}
	needs_save = _tmp0_;
	_tmp19_ = needs_save;
	if (_tmp19_) {
		_tmp18_ = TRUE;
	} else {
		GdkPixbuf* _tmp20_ = NULL;
		_tmp20_ = self->priv->new_avatar;
		_tmp18_ = _tmp20_ != NULL;
	}
	if (_tmp18_) {
		_tmp17_ = TRUE;
	} else {
		GdkPixbuf* _tmp21_ = NULL;
		_tmp21_ = self->priv->new_banner;
		_tmp17_ = _tmp21_ != NULL;
	}
	needs_init = _tmp17_;
	_tmp23_ = needs_init;
	if (_tmp23_) {
		Account* _tmp24_ = NULL;
		OAuthProxy* _tmp25_ = NULL;
		_tmp24_ = self->priv->account;
		_tmp25_ = _tmp24_->proxy;
		_tmp22_ = _tmp25_ == NULL;
	} else {
		_tmp22_ = FALSE;
	}
	if (_tmp22_) {
		Account* _tmp26_ = NULL;
		_tmp26_ = self->priv->account;
		account_init_proxy (_tmp26_, TRUE, FALSE);
	}
	_tmp27_ = needs_save;
	if (_tmp27_) {
		Block75Data* _data75_;
		Account* _tmp28_ = NULL;
		OAuthProxy* _tmp29_ = NULL;
		RestProxyCall* _tmp30_ = NULL;
		RestProxyCall* _tmp31_ = NULL;
		RestProxyCall* _tmp32_ = NULL;
		RestProxyCall* _tmp33_ = NULL;
		GtkEntry* _tmp34_ = NULL;
		const gchar* _tmp35_ = NULL;
		const gchar* _tmp36_ = NULL;
		RestProxyCall* _tmp37_ = NULL;
		GtkEntry* _tmp38_ = NULL;
		const gchar* _tmp39_ = NULL;
		const gchar* _tmp40_ = NULL;
		RestProxyCall* _tmp41_ = NULL;
		CompletionTextView* _tmp42_ = NULL;
		GtkTextBuffer* _tmp43_ = NULL;
		GtkTextBuffer* _tmp44_ = NULL;
		gchar* _tmp45_ = NULL;
		gchar* _tmp46_ = NULL;
		gchar* _tmp47_ = NULL;
		RestProxyCall* _tmp48_ = NULL;
		Account* _tmp49_ = NULL;
		GtkEntry* _tmp50_ = NULL;
		const gchar* _tmp51_ = NULL;
		const gchar* _tmp52_ = NULL;
		Account* _tmp53_ = NULL;
		CompletionTextView* _tmp54_ = NULL;
		GtkTextBuffer* _tmp55_ = NULL;
		GtkTextBuffer* _tmp56_ = NULL;
		gchar* _tmp57_ = NULL;
		gchar* _tmp58_ = NULL;
		gchar* _tmp59_ = NULL;
		Account* _tmp60_ = NULL;
		GtkEntry* _tmp61_ = NULL;
		const gchar* _tmp62_ = NULL;
		const gchar* _tmp63_ = NULL;
		_data75_ = g_slice_new0 (Block75Data);
		_data75_->_ref_count_ = 1;
		_data75_->self = g_object_ref (self);
		g_debug ("AccountDialog.vala:124: Saving data...");
		_tmp28_ = self->priv->account;
		_tmp29_ = _tmp28_->proxy;
		_tmp30_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, rest_proxy_get_type (), RestProxy));
		_data75_->call = _tmp30_;
		_tmp31_ = _data75_->call;
		rest_proxy_call_set_function (_tmp31_, "1.1/account/update_profile.json");
		_tmp32_ = _data75_->call;
		rest_proxy_call_set_method (_tmp32_, "POST");
		_tmp33_ = _data75_->call;
		_tmp34_ = self->priv->website_entry;
		_tmp35_ = gtk_entry_get_text (_tmp34_);
		_tmp36_ = _tmp35_;
		rest_proxy_call_add_param (_tmp33_, "url", _tmp36_);
		_tmp37_ = _data75_->call;
		_tmp38_ = self->priv->name_entry;
		_tmp39_ = gtk_entry_get_text (_tmp38_);
		_tmp40_ = _tmp39_;
		rest_proxy_call_add_param (_tmp37_, "name", _tmp40_);
		_tmp41_ = _data75_->call;
		_tmp42_ = self->priv->description_text_view;
		_tmp43_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (_tmp42_, gtk_text_view_get_type (), GtkTextView));
		_tmp44_ = _tmp43_;
		g_object_get (_tmp44_, "text", &_tmp45_, NULL);
		_tmp46_ = _tmp45_;
		_tmp47_ = _tmp46_;
		rest_proxy_call_add_param (_tmp41_, "description", _tmp47_);
		_g_free0 (_tmp47_);
		_tmp48_ = _data75_->call;
		rest_proxy_call_invoke_async (_tmp48_, NULL, ____lambda141__gasync_ready_callback, block75_data_ref (_data75_));
		_tmp49_ = self->priv->account;
		_tmp50_ = self->priv->name_entry;
		_tmp51_ = gtk_entry_get_text (_tmp50_);
		_tmp52_ = _tmp51_;
		account_set_name (_tmp49_, _tmp52_);
		_tmp53_ = self->priv->account;
		_tmp54_ = self->priv->description_text_view;
		_tmp55_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (_tmp54_, gtk_text_view_get_type (), GtkTextView));
		_tmp56_ = _tmp55_;
		g_object_get (_tmp56_, "text", &_tmp57_, NULL);
		_tmp58_ = _tmp57_;
		_tmp59_ = _tmp58_;
		account_set_description (_tmp53_, _tmp59_);
		_g_free0 (_tmp59_);
		_tmp60_ = self->priv->account;
		_tmp61_ = self->priv->website_entry;
		_tmp62_ = gtk_entry_get_text (_tmp61_);
		_tmp63_ = _tmp62_;
		account_set_website (_tmp60_, _tmp63_);
		block75_data_unref (_data75_);
		_data75_ = NULL;
	}
	_tmp64_ = self->priv->new_avatar;
	if (_tmp64_ != NULL) {
		Block76Data* _data76_;
		guint8* buffer = NULL;
		gint buffer_length1 = 0;
		gint _buffer_size_ = 0;
		gchar* b64 = NULL;
		guint8* _tmp70_ = NULL;
		gint _tmp70__length1 = 0;
		gchar* _tmp71_ = NULL;
		Account* _tmp72_ = NULL;
		OAuthProxy* _tmp73_ = NULL;
		RestProxyCall* _tmp74_ = NULL;
		RestProxyCall* _tmp75_ = NULL;
		RestProxyCall* _tmp76_ = NULL;
		RestProxyCall* _tmp77_ = NULL;
		RestProxyCall* _tmp78_ = NULL;
		RestProxyCall* _tmp79_ = NULL;
		const gchar* _tmp80_ = NULL;
		RestProxyCall* _tmp81_ = NULL;
		_data76_ = g_slice_new0 (Block76Data);
		_data76_->_ref_count_ = 1;
		_data76_->self = g_object_ref (self);
		g_debug ("AccountDialog.vala:148: Updating avatar...");
		{
			GdkPixbuf* _tmp65_ = NULL;
			guint8* _tmp66_ = NULL;
			gsize _tmp67_;
			_tmp65_ = self->priv->new_avatar;
			gdk_pixbuf_save_to_buffer (_tmp65_, (gchar**) (&_tmp66_), &_tmp67_, "png", &_inner_error_, NULL, NULL);
			buffer = (g_free (buffer), NULL);
			buffer = _tmp66_;
			buffer_length1 = _tmp67_;
			_buffer_size_ = buffer_length1;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch90_g_error;
			}
		}
		goto __finally90;
		__catch90_g_error:
		{
			GError* e = NULL;
			GError* _tmp68_ = NULL;
			const gchar* _tmp69_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp68_ = e;
			_tmp69_ = _tmp68_->message;
			g_warning ("AccountDialog.vala:153: %s", _tmp69_);
			_g_error_free0 (e);
			buffer = (g_free (buffer), NULL);
			block76_data_unref (_data76_);
			_data76_ = NULL;
			return;
		}
		__finally90:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			buffer = (g_free (buffer), NULL);
			block76_data_unref (_data76_);
			_data76_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp70_ = buffer;
		_tmp70__length1 = buffer_length1;
		_tmp71_ = g_base64_encode (_tmp70_, _tmp70__length1);
		b64 = _tmp71_;
		_tmp72_ = self->priv->account;
		_tmp73_ = _tmp72_->proxy;
		_tmp74_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_tmp73_, rest_proxy_get_type (), RestProxy));
		_data76_->call = _tmp74_;
		_tmp75_ = _data76_->call;
		rest_proxy_call_set_function (_tmp75_, "1.1/account/update_profile_image.json");
		_tmp76_ = _data76_->call;
		rest_proxy_call_set_method (_tmp76_, "POST");
		_tmp77_ = _data76_->call;
		rest_proxy_call_add_param (_tmp77_, "skip_status", "true");
		_tmp78_ = _data76_->call;
		rest_proxy_call_add_param (_tmp78_, "include_entities", "false");
		_tmp79_ = _data76_->call;
		_tmp80_ = b64;
		rest_proxy_call_add_param (_tmp79_, "image", _tmp80_);
		_tmp81_ = _data76_->call;
		rest_proxy_call_invoke_async (_tmp81_, NULL, ____lambda142__gasync_ready_callback, block76_data_ref (_data76_));
		_g_free0 (b64);
		buffer = (g_free (buffer), NULL);
		block76_data_unref (_data76_);
		_data76_ = NULL;
	}
	_tmp82_ = self->priv->new_banner;
	if (_tmp82_ != NULL) {
		Block77Data* _data77_;
		guint8* buffer = NULL;
		gint buffer_length1 = 0;
		gint _buffer_size_ = 0;
		gchar* b64 = NULL;
		guint8* _tmp88_ = NULL;
		gint _tmp88__length1 = 0;
		gchar* _tmp89_ = NULL;
		Account* _tmp90_ = NULL;
		OAuthProxy* _tmp91_ = NULL;
		RestProxyCall* _tmp92_ = NULL;
		RestProxyCall* _tmp93_ = NULL;
		RestProxyCall* _tmp94_ = NULL;
		RestProxyCall* _tmp95_ = NULL;
		const gchar* _tmp96_ = NULL;
		RestProxyCall* _tmp97_ = NULL;
		_data77_ = g_slice_new0 (Block77Data);
		_data77_->_ref_count_ = 1;
		_data77_->self = g_object_ref (self);
		g_debug ("AccountDialog.vala:181: Updating banner...");
		{
			GdkPixbuf* _tmp83_ = NULL;
			guint8* _tmp84_ = NULL;
			gsize _tmp85_;
			_tmp83_ = self->priv->new_banner;
			gdk_pixbuf_save_to_buffer (_tmp83_, (gchar**) (&_tmp84_), &_tmp85_, "png", &_inner_error_, NULL, NULL);
			buffer = (g_free (buffer), NULL);
			buffer = _tmp84_;
			buffer_length1 = _tmp85_;
			_buffer_size_ = buffer_length1;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch92_g_error;
			}
		}
		goto __finally92;
		__catch92_g_error:
		{
			GError* e = NULL;
			GError* _tmp86_ = NULL;
			const gchar* _tmp87_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp86_ = e;
			_tmp87_ = _tmp86_->message;
			g_warning ("AccountDialog.vala:187: %s", _tmp87_);
			_g_error_free0 (e);
			buffer = (g_free (buffer), NULL);
			block77_data_unref (_data77_);
			_data77_ = NULL;
			return;
		}
		__finally92:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			buffer = (g_free (buffer), NULL);
			block77_data_unref (_data77_);
			_data77_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp88_ = buffer;
		_tmp88__length1 = buffer_length1;
		_tmp89_ = g_base64_encode (_tmp88_, _tmp88__length1);
		b64 = _tmp89_;
		_tmp90_ = self->priv->account;
		_tmp91_ = _tmp90_->proxy;
		_tmp92_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_tmp91_, rest_proxy_get_type (), RestProxy));
		_data77_->call = _tmp92_;
		_tmp93_ = _data77_->call;
		rest_proxy_call_set_function (_tmp93_, "1.1/account/update_profile_banner.json");
		_tmp94_ = _data77_->call;
		rest_proxy_call_set_method (_tmp94_, "POST");
		_tmp95_ = _data77_->call;
		_tmp96_ = b64;
		rest_proxy_call_add_param (_tmp95_, "banner", _tmp96_);
		_tmp97_ = _data77_->call;
		rest_proxy_call_invoke_async (_tmp97_, NULL, ____lambda143__gasync_ready_callback, block77_data_ref (_data77_));
		_g_free0 (b64);
		buffer = (g_free (buffer), NULL);
		block77_data_unref (_data77_);
		_data77_ = NULL;
	}
}


static void account_dialog_delete_confirm_button_clicked_cb (AccountDialog* self) {
	gint64 acc_id = 0LL;
	Account* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
	gint64 _tmp2_ = 0LL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gint64 _tmp9_ = 0LL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	gint64 _tmp16_ = 0LL;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	gchar* _tmp22_ = NULL;
	SqlDatabase* _tmp23_ = NULL;
	gint64 _tmp24_ = 0LL;
	gchar* _tmp25_ = NULL;
	gchar* _tmp26_ = NULL;
	gchar* _tmp27_ = NULL;
	gchar* _tmp28_ = NULL;
	gchar** startup_accounts = NULL;
	GSettings* _tmp29_ = NULL;
	GSettings* _tmp30_ = NULL;
	gchar** _tmp31_ = NULL;
	gchar** _tmp32_ = NULL;
	gchar** _tmp33_ = NULL;
	gint _tmp33__length1 = 0;
	gint startup_accounts_length1 = 0;
	gint _startup_accounts_size_ = 0;
	Corebird* cb = NULL;
	GApplication* _tmp72_ = NULL;
	Corebird* _tmp73_ = NULL;
	GList* windows = NULL;
	Corebird* _tmp74_ = NULL;
	GList* _tmp75_ = NULL;
	GtkWindow* account_window = NULL;
	gint n_main_windows = 0;
	GList* _tmp76_ = NULL;
	gint _tmp87_ = 0;
	GtkWindow* _tmp88_ = NULL;
	Account* acc_to_remove = NULL;
	Account* _tmp92_ = NULL;
	gint64 _tmp93_ = 0LL;
	Account* _tmp94_ = NULL;
	Account* _tmp95_ = NULL;
	Corebird* _tmp96_ = NULL;
	Account* _tmp97_ = NULL;
	const gchar* _tmp98_ = NULL;
	const gchar* _tmp99_ = NULL;
	g_return_if_fail (IS_ACCOUNT_DIALOG (self));
	_tmp0_ = self->priv->account;
	_tmp1_ = _tmp0_->id;
	acc_id = _tmp1_;
	_tmp2_ = acc_id;
	_tmp3_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat ("accounts/", _tmp4_, ".db", NULL);
	_tmp6_ = _tmp5_;
	_tmp7_ = dirs_config (_tmp6_);
	_tmp8_ = _tmp7_;
	g_remove (_tmp8_);
	_g_free0 (_tmp8_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	_tmp9_ = acc_id;
	_tmp10_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strconcat ("accounts/", _tmp11_, ".png", NULL);
	_tmp13_ = _tmp12_;
	_tmp14_ = dirs_config (_tmp13_);
	_tmp15_ = _tmp14_;
	g_remove (_tmp15_);
	_g_free0 (_tmp15_);
	_g_free0 (_tmp13_);
	_g_free0 (_tmp11_);
	_tmp16_ = acc_id;
	_tmp17_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = g_strconcat ("accounts/", _tmp18_, "_small.png", NULL);
	_tmp20_ = _tmp19_;
	_tmp21_ = dirs_config (_tmp20_);
	_tmp22_ = _tmp21_;
	g_remove (_tmp22_);
	_g_free0 (_tmp22_);
	_g_free0 (_tmp20_);
	_g_free0 (_tmp18_);
	_tmp23_ = corebird_db;
	_tmp24_ = acc_id;
	_tmp25_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp24_);
	_tmp26_ = _tmp25_;
	_tmp27_ = g_strconcat ("DELETE FROM `accounts` WHERE `id`='", _tmp26_, "';", NULL);
	_tmp28_ = _tmp27_;
	sql_database_exec (_tmp23_, _tmp28_, NULL, NULL);
	_g_free0 (_tmp28_);
	_g_free0 (_tmp26_);
	_tmp29_ = settings_get ();
	_tmp30_ = _tmp29_;
	_tmp32_ = _tmp31_ = g_settings_get_strv (_tmp30_, "startup-accounts");
	_tmp33_ = _tmp32_;
	_tmp33__length1 = _vala_array_length (_tmp31_);
	_g_object_unref0 (_tmp30_);
	startup_accounts = _tmp33_;
	startup_accounts_length1 = _tmp33__length1;
	_startup_accounts_size_ = startup_accounts_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp34_ = FALSE;
			_tmp34_ = TRUE;
			while (TRUE) {
				gint _tmp36_ = 0;
				gchar** _tmp37_ = NULL;
				gint _tmp37__length1 = 0;
				gchar** _tmp38_ = NULL;
				gint _tmp38__length1 = 0;
				gint _tmp39_ = 0;
				const gchar* _tmp40_ = NULL;
				Account* _tmp41_ = NULL;
				const gchar* _tmp42_ = NULL;
				const gchar* _tmp43_ = NULL;
				if (!_tmp34_) {
					gint _tmp35_ = 0;
					_tmp35_ = i;
					i = _tmp35_ + 1;
				}
				_tmp34_ = FALSE;
				_tmp36_ = i;
				_tmp37_ = startup_accounts;
				_tmp37__length1 = startup_accounts_length1;
				if (!(_tmp36_ < _tmp37__length1)) {
					break;
				}
				_tmp38_ = startup_accounts;
				_tmp38__length1 = startup_accounts_length1;
				_tmp39_ = i;
				_tmp40_ = _tmp38_[_tmp39_];
				_tmp41_ = self->priv->account;
				_tmp42_ = account_get_screen_name (_tmp41_);
				_tmp43_ = _tmp42_;
				if (g_strcmp0 (_tmp40_, _tmp43_) == 0) {
					gchar** sa_new = NULL;
					gchar** _tmp44_ = NULL;
					gint _tmp44__length1 = 0;
					gchar** _tmp45_ = NULL;
					gint sa_new_length1 = 0;
					gint _sa_new_size_ = 0;
					GSettings* _tmp69_ = NULL;
					GSettings* _tmp70_ = NULL;
					gchar** _tmp71_ = NULL;
					gint _tmp71__length1 = 0;
					_tmp44_ = startup_accounts;
					_tmp44__length1 = startup_accounts_length1;
					_tmp45_ = g_new0 (gchar*, (_tmp44__length1 - 1) + 1);
					sa_new = _tmp45_;
					sa_new_length1 = _tmp44__length1 - 1;
					_sa_new_size_ = sa_new_length1;
					{
						gint x = 0;
						x = 0;
						{
							gboolean _tmp46_ = FALSE;
							_tmp46_ = TRUE;
							while (TRUE) {
								gint _tmp48_ = 0;
								gint _tmp49_ = 0;
								gchar** _tmp50_ = NULL;
								gint _tmp50__length1 = 0;
								gint _tmp51_ = 0;
								gchar** _tmp52_ = NULL;
								gint _tmp52__length1 = 0;
								gint _tmp53_ = 0;
								const gchar* _tmp54_ = NULL;
								gchar* _tmp55_ = NULL;
								gchar* _tmp56_ = NULL;
								if (!_tmp46_) {
									gint _tmp47_ = 0;
									_tmp47_ = i;
									i = _tmp47_ + 1;
								}
								_tmp46_ = FALSE;
								_tmp48_ = x;
								_tmp49_ = i;
								if (!(_tmp48_ < _tmp49_)) {
									break;
								}
								_tmp50_ = sa_new;
								_tmp50__length1 = sa_new_length1;
								_tmp51_ = x;
								_tmp52_ = startup_accounts;
								_tmp52__length1 = startup_accounts_length1;
								_tmp53_ = x;
								_tmp54_ = _tmp52_[_tmp53_];
								_tmp55_ = g_strdup (_tmp54_);
								_g_free0 (_tmp50_[_tmp51_]);
								_tmp50_[_tmp51_] = _tmp55_;
								_tmp56_ = _tmp50_[_tmp51_];
							}
						}
					}
					{
						gint x = 0;
						gint _tmp57_ = 0;
						_tmp57_ = i;
						x = _tmp57_ + 1;
						{
							gboolean _tmp58_ = FALSE;
							_tmp58_ = TRUE;
							while (TRUE) {
								gint _tmp60_ = 0;
								gchar** _tmp61_ = NULL;
								gint _tmp61__length1 = 0;
								gchar** _tmp62_ = NULL;
								gint _tmp62__length1 = 0;
								gint _tmp63_ = 0;
								gchar** _tmp64_ = NULL;
								gint _tmp64__length1 = 0;
								gint _tmp65_ = 0;
								const gchar* _tmp66_ = NULL;
								gchar* _tmp67_ = NULL;
								gchar* _tmp68_ = NULL;
								if (!_tmp58_) {
									gint _tmp59_ = 0;
									_tmp59_ = x;
									x = _tmp59_ + 1;
								}
								_tmp58_ = FALSE;
								_tmp60_ = x;
								_tmp61_ = startup_accounts;
								_tmp61__length1 = startup_accounts_length1;
								if (!(_tmp60_ < _tmp61__length1)) {
									break;
								}
								_tmp62_ = sa_new;
								_tmp62__length1 = sa_new_length1;
								_tmp63_ = x;
								_tmp64_ = startup_accounts;
								_tmp64__length1 = startup_accounts_length1;
								_tmp65_ = x;
								_tmp66_ = _tmp64_[_tmp65_];
								_tmp67_ = g_strdup (_tmp66_);
								_g_free0 (_tmp62_[_tmp63_]);
								_tmp62_[_tmp63_] = _tmp67_;
								_tmp68_ = _tmp62_[_tmp63_];
							}
						}
					}
					_tmp69_ = settings_get ();
					_tmp70_ = _tmp69_;
					_tmp71_ = sa_new;
					_tmp71__length1 = sa_new_length1;
					g_settings_set_strv (_tmp70_, "startup-accounts", _tmp71_);
					_g_object_unref0 (_tmp70_);
					sa_new = (_vala_array_free (sa_new, sa_new_length1, (GDestroyNotify) g_free), NULL);
				}
			}
		}
	}
	_tmp72_ = g_application_get_default ();
	_tmp73_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp72_, TYPE_COREBIRD, Corebird));
	cb = _tmp73_;
	_tmp74_ = cb;
	_tmp75_ = gtk_application_get_windows (G_TYPE_CHECK_INSTANCE_CAST (_tmp74_, gtk_application_get_type (), GtkApplication));
	windows = _tmp75_;
	account_window = NULL;
	n_main_windows = 0;
	_tmp76_ = windows;
	{
		GList* win_collection = NULL;
		GList* win_it = NULL;
		win_collection = _tmp76_;
		for (win_it = win_collection; win_it != NULL; win_it = win_it->next) {
			GtkWindow* _tmp77_ = NULL;
			GtkWindow* win = NULL;
			_tmp77_ = _g_object_ref0 ((GtkWindow*) win_it->data);
			win = _tmp77_;
			{
				GtkWindow* _tmp78_ = NULL;
				_tmp78_ = win;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp78_, TYPE_MAIN_WINDOW)) {
					gint _tmp79_ = 0;
					GtkWindow* _tmp80_ = NULL;
					Account* _tmp81_ = NULL;
					gint64 _tmp82_ = 0LL;
					Account* _tmp83_ = NULL;
					gint64 _tmp84_ = 0LL;
					_tmp79_ = n_main_windows;
					n_main_windows = _tmp79_ + 1;
					_tmp80_ = win;
					_tmp81_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp80_, TYPE_MAIN_WINDOW, MainWindow)->account;
					_tmp82_ = _tmp81_->id;
					_tmp83_ = self->priv->account;
					_tmp84_ = _tmp83_->id;
					if (_tmp82_ == _tmp84_) {
						GtkWindow* _tmp85_ = NULL;
						GtkWindow* _tmp86_ = NULL;
						_tmp85_ = win;
						_tmp86_ = _g_object_ref0 (_tmp85_);
						_g_object_unref0 (account_window);
						account_window = _tmp86_;
					}
				}
				_g_object_unref0 (win);
			}
		}
	}
	_tmp87_ = n_main_windows;
	g_debug ("AccountDialog.vala:252: Open main windows: %d", _tmp87_);
	_tmp88_ = account_window;
	if (_tmp88_ != NULL) {
		gint _tmp89_ = 0;
		_tmp89_ = n_main_windows;
		if (_tmp89_ > 1) {
			GtkWindow* _tmp90_ = NULL;
			_tmp90_ = account_window;
			gtk_widget_destroy (G_TYPE_CHECK_INSTANCE_CAST (_tmp90_, gtk_widget_get_type (), GtkWidget));
		} else {
			GtkWindow* _tmp91_ = NULL;
			_tmp91_ = account_window;
			main_window_change_account (G_TYPE_CHECK_INSTANCE_CAST (_tmp91_, TYPE_MAIN_WINDOW, MainWindow), NULL);
		}
	}
	_tmp92_ = self->priv->account;
	_tmp93_ = _tmp92_->id;
	_tmp94_ = account_query_account_by_id (_tmp93_);
	_tmp95_ = _g_object_ref0 (_tmp94_);
	acc_to_remove = _tmp95_;
	_tmp96_ = cb;
	g_signal_emit_by_name (_tmp96_, "account-removed", acc_to_remove);
	_tmp97_ = self->priv->account;
	_tmp98_ = account_get_screen_name (_tmp97_);
	_tmp99_ = _tmp98_;
	account_remove_account (_tmp99_);
	gtk_widget_destroy (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (acc_to_remove);
	_g_object_unref0 (account_window);
	_g_object_unref0 (cb);
	startup_accounts = (_vala_array_free (startup_accounts, startup_accounts_length1, (GDestroyNotify) g_free), NULL);
}


static void _account_dialog_delete_confirm_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	account_dialog_delete_confirm_button_clicked_cb ((AccountDialog*) self);
}


static void account_dialog_delete_cancel_button_clicked_cb (AccountDialog* self) {
	GtkStack* _tmp0_ = NULL;
	g_return_if_fail (IS_ACCOUNT_DIALOG (self));
	_tmp0_ = self->priv->delete_stack;
	gtk_stack_set_visible_child_name (_tmp0_, ACCOUNT_DIALOG_PAGE_NORMAL);
}


static void _account_dialog_delete_cancel_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	account_dialog_delete_cancel_button_clicked_cb ((AccountDialog*) self);
}


static void account_dialog_autostart_switch_activate_cb (AccountDialog* self) {
	gboolean active = FALSE;
	GtkSwitch* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gchar** startup_accounts = NULL;
	GSettings* _tmp3_ = NULL;
	GSettings* _tmp4_ = NULL;
	gchar** _tmp5_ = NULL;
	gchar** _tmp6_ = NULL;
	gchar** _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	gint startup_accounts_length1 = 0;
	gint _startup_accounts_size_ = 0;
	gboolean _tmp8_ = FALSE;
	g_return_if_fail (IS_ACCOUNT_DIALOG (self));
	_tmp0_ = self->priv->autostart_switch;
	_tmp1_ = gtk_switch_get_active (_tmp0_);
	_tmp2_ = _tmp1_;
	active = _tmp2_;
	_tmp3_ = settings_get ();
	_tmp4_ = _tmp3_;
	_tmp6_ = _tmp5_ = g_settings_get_strv (_tmp4_, "startup-accounts");
	_tmp7_ = _tmp6_;
	_tmp7__length1 = _vala_array_length (_tmp5_);
	_g_object_unref0 (_tmp4_);
	startup_accounts = _tmp7_;
	startup_accounts_length1 = _tmp7__length1;
	_startup_accounts_size_ = startup_accounts_length1;
	_tmp8_ = active;
	if (_tmp8_) {
		gchar** _tmp9_ = NULL;
		gint _tmp9__length1 = 0;
		gchar** new_startup_accounts = NULL;
		gchar** _tmp14_ = NULL;
		gint _tmp14__length1 = 0;
		gchar** _tmp15_ = NULL;
		gint new_startup_accounts_length1 = 0;
		gint _new_startup_accounts_size_ = 0;
		gint i = 0;
		gchar** _tmp16_ = NULL;
		gint _tmp16__length1 = 0;
		gchar** _tmp23_ = NULL;
		gint _tmp23__length1 = 0;
		gchar** _tmp24_ = NULL;
		gint _tmp24__length1 = 0;
		Account* _tmp25_ = NULL;
		const gchar* _tmp26_ = NULL;
		const gchar* _tmp27_ = NULL;
		gchar* _tmp28_ = NULL;
		gchar* _tmp29_ = NULL;
		GSettings* _tmp30_ = NULL;
		GSettings* _tmp31_ = NULL;
		gchar** _tmp32_ = NULL;
		gint _tmp32__length1 = 0;
		_tmp9_ = startup_accounts;
		_tmp9__length1 = startup_accounts_length1;
		{
			gchar** acc_collection = NULL;
			gint acc_collection_length1 = 0;
			gint _acc_collection_size_ = 0;
			gint acc_it = 0;
			acc_collection = _tmp9_;
			acc_collection_length1 = _tmp9__length1;
			for (acc_it = 0; acc_it < _tmp9__length1; acc_it = acc_it + 1) {
				const gchar* acc = NULL;
				acc = acc_collection[acc_it];
				{
					const gchar* _tmp10_ = NULL;
					Account* _tmp11_ = NULL;
					const gchar* _tmp12_ = NULL;
					const gchar* _tmp13_ = NULL;
					_tmp10_ = acc;
					_tmp11_ = self->priv->account;
					_tmp12_ = account_get_screen_name (_tmp11_);
					_tmp13_ = _tmp12_;
					if (g_strcmp0 (_tmp10_, _tmp13_) == 0) {
						startup_accounts = (_vala_array_free (startup_accounts, startup_accounts_length1, (GDestroyNotify) g_free), NULL);
						return;
					}
				}
			}
		}
		_tmp14_ = startup_accounts;
		_tmp14__length1 = startup_accounts_length1;
		_tmp15_ = g_new0 (gchar*, (_tmp14__length1 + 1) + 1);
		new_startup_accounts = _tmp15_;
		new_startup_accounts_length1 = _tmp14__length1 + 1;
		_new_startup_accounts_size_ = new_startup_accounts_length1;
		i = 0;
		_tmp16_ = startup_accounts;
		_tmp16__length1 = startup_accounts_length1;
		{
			gchar** s_collection = NULL;
			gint s_collection_length1 = 0;
			gint _s_collection_size_ = 0;
			gint s_it = 0;
			s_collection = _tmp16_;
			s_collection_length1 = _tmp16__length1;
			for (s_it = 0; s_it < _tmp16__length1; s_it = s_it + 1) {
				const gchar* s = NULL;
				s = s_collection[s_it];
				{
					gchar** _tmp17_ = NULL;
					gint _tmp17__length1 = 0;
					gint _tmp18_ = 0;
					const gchar* _tmp19_ = NULL;
					gchar* _tmp20_ = NULL;
					gchar* _tmp21_ = NULL;
					gint _tmp22_ = 0;
					_tmp17_ = new_startup_accounts;
					_tmp17__length1 = new_startup_accounts_length1;
					_tmp18_ = i;
					_tmp19_ = s;
					_tmp20_ = g_strdup (_tmp19_);
					_g_free0 (_tmp17_[_tmp18_]);
					_tmp17_[_tmp18_] = _tmp20_;
					_tmp21_ = _tmp17_[_tmp18_];
					_tmp22_ = i;
					i = _tmp22_ + 1;
				}
			}
		}
		_tmp23_ = new_startup_accounts;
		_tmp23__length1 = new_startup_accounts_length1;
		_tmp24_ = new_startup_accounts;
		_tmp24__length1 = new_startup_accounts_length1;
		_tmp25_ = self->priv->account;
		_tmp26_ = account_get_screen_name (_tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = g_strdup (_tmp27_);
		_g_free0 (_tmp23_[_tmp24__length1 - 1]);
		_tmp23_[_tmp24__length1 - 1] = _tmp28_;
		_tmp29_ = _tmp23_[_tmp24__length1 - 1];
		_tmp30_ = settings_get ();
		_tmp31_ = _tmp30_;
		_tmp32_ = new_startup_accounts;
		_tmp32__length1 = new_startup_accounts_length1;
		g_settings_set_strv (_tmp31_, "startup-accounts", _tmp32_);
		_g_object_unref0 (_tmp31_);
		new_startup_accounts = (_vala_array_free (new_startup_accounts, new_startup_accounts_length1, (GDestroyNotify) g_free), NULL);
	} else {
		gchar** new_startup_accounts = NULL;
		gchar** _tmp33_ = NULL;
		gint _tmp33__length1 = 0;
		gchar** _tmp34_ = NULL;
		gint new_startup_accounts_length1 = 0;
		gint _new_startup_accounts_size_ = 0;
		gint i = 0;
		gchar** _tmp35_ = NULL;
		gint _tmp35__length1 = 0;
		GSettings* _tmp46_ = NULL;
		GSettings* _tmp47_ = NULL;
		gchar** _tmp48_ = NULL;
		gint _tmp48__length1 = 0;
		_tmp33_ = startup_accounts;
		_tmp33__length1 = startup_accounts_length1;
		_tmp34_ = g_new0 (gchar*, (_tmp33__length1 - 1) + 1);
		new_startup_accounts = _tmp34_;
		new_startup_accounts_length1 = _tmp33__length1 - 1;
		_new_startup_accounts_size_ = new_startup_accounts_length1;
		i = 0;
		_tmp35_ = startup_accounts;
		_tmp35__length1 = startup_accounts_length1;
		{
			gchar** acc_collection = NULL;
			gint acc_collection_length1 = 0;
			gint _acc_collection_size_ = 0;
			gint acc_it = 0;
			acc_collection = _tmp35_;
			acc_collection_length1 = _tmp35__length1;
			for (acc_it = 0; acc_it < _tmp35__length1; acc_it = acc_it + 1) {
				const gchar* acc = NULL;
				acc = acc_collection[acc_it];
				{
					const gchar* _tmp36_ = NULL;
					Account* _tmp37_ = NULL;
					const gchar* _tmp38_ = NULL;
					const gchar* _tmp39_ = NULL;
					_tmp36_ = acc;
					_tmp37_ = self->priv->account;
					_tmp38_ = account_get_screen_name (_tmp37_);
					_tmp39_ = _tmp38_;
					if (g_strcmp0 (_tmp36_, _tmp39_) != 0) {
						gchar** _tmp40_ = NULL;
						gint _tmp40__length1 = 0;
						gint _tmp41_ = 0;
						const gchar* _tmp42_ = NULL;
						gchar* _tmp43_ = NULL;
						gchar* _tmp44_ = NULL;
						gint _tmp45_ = 0;
						_tmp40_ = new_startup_accounts;
						_tmp40__length1 = new_startup_accounts_length1;
						_tmp41_ = i;
						_tmp42_ = acc;
						_tmp43_ = g_strdup (_tmp42_);
						_g_free0 (_tmp40_[_tmp41_]);
						_tmp40_[_tmp41_] = _tmp43_;
						_tmp44_ = _tmp40_[_tmp41_];
						_tmp45_ = i;
						i = _tmp45_ + 1;
					}
				}
			}
		}
		_tmp46_ = settings_get ();
		_tmp47_ = _tmp46_;
		_tmp48_ = new_startup_accounts;
		_tmp48__length1 = new_startup_accounts_length1;
		g_settings_set_strv (_tmp47_, "startup-accounts", _tmp48_);
		_g_object_unref0 (_tmp47_);
		new_startup_accounts = (_vala_array_free (new_startup_accounts, new_startup_accounts_length1, (GDestroyNotify) g_free), NULL);
	}
	startup_accounts = (_vala_array_free (startup_accounts, startup_accounts_length1, (GDestroyNotify) g_free), NULL);
}


static void _account_dialog_autostart_switch_activate_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	account_dialog_autostart_switch_activate_cb ((AccountDialog*) self);
}


static Block78Data* block78_data_ref (Block78Data* _data78_) {
	g_atomic_int_inc (&_data78_->_ref_count_);
	return _data78_;
}


static void block78_data_unref (void * _userdata_) {
	Block78Data* _data78_;
	_data78_ = (Block78Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data78_->_ref_count_)) {
		AccountDialog* self;
		self = _data78_->self;
		_g_object_unref0 (_data78_->filechooser);
		_g_object_unref0 (self);
		g_slice_free (Block78Data, _data78_);
	}
}


static void __lambda149_ (Block78Data* _data78_, gint id) {
	AccountDialog* self;
	gint _tmp0_ = 0;
	GError * _inner_error_ = NULL;
	self = _data78_->self;
	_tmp0_ = id;
	if (_tmp0_ == ((gint) GTK_RESPONSE_ACCEPT)) {
		gchar* selected_file = NULL;
		gchar* _tmp1_ = NULL;
		GdkPixbuf* image = NULL;
		gint min_width = 0;
		gint min_height = 0;
		CropWidget* _tmp8_ = NULL;
		gdouble _tmp9_ = 0.0;
		gdouble _tmp10_ = 0.0;
		gboolean _tmp11_ = FALSE;
		GdkPixbuf* _tmp12_ = NULL;
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
		_tmp1_ = gtk_file_chooser_get_filename (G_TYPE_CHECK_INSTANCE_CAST (_data78_->filechooser, GTK_TYPE_FILE_CHOOSER, GtkFileChooser));
		selected_file = _tmp1_;
		image = NULL;
		{
			GdkPixbuf* _tmp2_ = NULL;
			const gchar* _tmp3_ = NULL;
			GdkPixbuf* _tmp4_ = NULL;
			GdkPixbuf* _tmp5_ = NULL;
			_tmp3_ = selected_file;
			_tmp4_ = gdk_pixbuf_new_from_file (_tmp3_, &_inner_error_);
			_tmp2_ = _tmp4_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch94_g_error;
			}
			_tmp5_ = _tmp2_;
			_tmp2_ = NULL;
			_g_object_unref0 (image);
			image = _tmp5_;
			_g_object_unref0 (_tmp2_);
		}
		goto __finally94;
		__catch94_g_error:
		{
			GError* e = NULL;
			GError* _tmp6_ = NULL;
			const gchar* _tmp7_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp6_ = e;
			_tmp7_ = _tmp6_->message;
			g_warning ("AccountDialog.vala:327: %s", _tmp7_);
			_g_error_free0 (e);
			_g_object_unref0 (image);
			_g_free0 (selected_file);
			return;
		}
		__finally94:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (image);
			_g_free0 (selected_file);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		min_width = 200;
		min_height = 100;
		_tmp8_ = self->priv->crop_widget;
		_tmp9_ = crop_widget_get_desired_aspect_ratio (_tmp8_);
		_tmp10_ = _tmp9_;
		if (_tmp10_ == 1.0) {
			min_width = 48;
			min_height = 48;
		}
		_tmp12_ = image;
		_tmp13_ = gdk_pixbuf_get_width (_tmp12_);
		_tmp14_ = min_width;
		if (_tmp13_ >= _tmp14_) {
			GdkPixbuf* _tmp15_ = NULL;
			gint _tmp16_ = 0;
			gint _tmp17_ = 0;
			_tmp15_ = image;
			_tmp16_ = gdk_pixbuf_get_height (_tmp15_);
			_tmp17_ = min_height;
			_tmp11_ = _tmp16_ >= _tmp17_;
		} else {
			_tmp11_ = FALSE;
		}
		if (_tmp11_) {
			CropWidget* _tmp18_ = NULL;
			GdkPixbuf* _tmp19_ = NULL;
			GtkButton* _tmp20_ = NULL;
			_tmp18_ = self->priv->crop_widget;
			_tmp19_ = image;
			crop_widget_set_image (_tmp18_, _tmp19_);
			_tmp20_ = self->priv->save_button;
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, gtk_widget_get_type (), GtkWidget), TRUE);
		} else {
			gchar* error_str = NULL;
			gchar* _tmp21_ = NULL;
			const gchar* _tmp22_ = NULL;
			const gchar* _tmp23_ = NULL;
			gchar* _tmp24_ = NULL;
			gchar* _tmp25_ = NULL;
			gchar* _tmp26_ = NULL;
			const gchar* _tmp27_ = NULL;
			gint _tmp28_ = 0;
			const gchar* _tmp29_ = NULL;
			gint _tmp30_ = 0;
			gchar* _tmp31_ = NULL;
			gchar* _tmp32_ = NULL;
			gchar* _tmp33_ = NULL;
			gchar* _tmp34_ = NULL;
			gchar* _tmp35_ = NULL;
			const gchar* _tmp36_ = NULL;
			gint _tmp37_ = 0;
			const gchar* _tmp38_ = NULL;
			gint _tmp39_ = 0;
			gchar* _tmp40_ = NULL;
			gchar* _tmp41_ = NULL;
			gchar* _tmp42_ = NULL;
			GtkLabel* _tmp43_ = NULL;
			const gchar* _tmp44_ = NULL;
			GtkStack* _tmp45_ = NULL;
			GtkLabel* _tmp46_ = NULL;
			GtkButton* _tmp47_ = NULL;
			_tmp21_ = g_strdup ("");
			error_str = _tmp21_;
			_tmp22_ = error_str;
			_tmp23_ = _ ("Image does not meet minimum size requirements:");
			_tmp24_ = g_strconcat (_tmp23_, "\n", NULL);
			_tmp25_ = _tmp24_;
			_tmp26_ = g_strconcat (_tmp22_, _tmp25_, NULL);
			_g_free0 (error_str);
			error_str = _tmp26_;
			_g_free0 (_tmp25_);
			_tmp27_ = error_str;
			_tmp28_ = min_width;
			_tmp29_ = ngettext ("Minimum width: %d pixel", "Minimum width: %d pixels", (gulong) _tmp28_);
			_tmp30_ = min_width;
			_tmp31_ = g_strdup_printf (_tmp29_, _tmp30_);
			_tmp32_ = _tmp31_;
			_tmp33_ = g_strconcat (_tmp32_, "\n", NULL);
			_tmp34_ = _tmp33_;
			_tmp35_ = g_strconcat (_tmp27_, _tmp34_, NULL);
			_g_free0 (error_str);
			error_str = _tmp35_;
			_g_free0 (_tmp34_);
			_g_free0 (_tmp32_);
			_tmp36_ = error_str;
			_tmp37_ = min_height;
			_tmp38_ = ngettext ("Minimum height: %d pixel", "Minimum height: %d pixels", (gulong) _tmp37_);
			_tmp39_ = min_height;
			_tmp40_ = g_strdup_printf (_tmp38_, _tmp39_);
			_tmp41_ = _tmp40_;
			_tmp42_ = g_strconcat (_tmp36_, _tmp41_, NULL);
			_g_free0 (error_str);
			error_str = _tmp42_;
			_g_free0 (_tmp41_);
			_tmp43_ = self->priv->error_label;
			_tmp44_ = error_str;
			gtk_label_set_label (_tmp43_, _tmp44_);
			_tmp45_ = self->priv->content_stack;
			_tmp46_ = self->priv->error_label;
			gtk_stack_set_visible_child (_tmp45_, G_TYPE_CHECK_INSTANCE_CAST (_tmp46_, gtk_widget_get_type (), GtkWidget));
			_tmp47_ = self->priv->save_button;
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp47_, gtk_widget_get_type (), GtkWidget), FALSE);
			_g_free0 (error_str);
		}
		_g_object_unref0 (image);
		_g_free0 (selected_file);
	} else {
		gint _tmp48_ = 0;
		_tmp48_ = id;
		if (_tmp48_ == ((gint) GTK_RESPONSE_CANCEL)) {
			GtkStack* _tmp49_ = NULL;
			GtkBox* _tmp50_ = NULL;
			_tmp49_ = self->priv->content_stack;
			_tmp50_ = self->priv->info_box;
			gtk_stack_set_visible_child (_tmp49_, G_TYPE_CHECK_INSTANCE_CAST (_tmp50_, gtk_widget_get_type (), GtkWidget));
		}
	}
	gtk_widget_destroy (G_TYPE_CHECK_INSTANCE_CAST (_data78_->filechooser, gtk_widget_get_type (), GtkWidget));
}


static void ___lambda149__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	__lambda149_ (self, response_id);
}


static void account_dialog_show_crop_image_selector (AccountDialog* self) {
	Block78Data* _data78_;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GtkFileChooserDialog* _tmp3_ = NULL;
	GtkFileFilter* filter = NULL;
	GtkFileFilter* _tmp4_ = NULL;
	g_return_if_fail (IS_ACCOUNT_DIALOG (self));
	_data78_ = g_slice_new0 (Block78Data);
	_data78_->_ref_count_ = 1;
	_data78_->self = g_object_ref (self);
	_tmp0_ = _ ("Select Banner Image");
	_tmp1_ = _ ("Cancel");
	_tmp2_ = _ ("Open");
	_tmp3_ = (GtkFileChooserDialog*) gtk_file_chooser_dialog_new (_tmp0_, G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), GTK_FILE_CHOOSER_ACTION_OPEN, _tmp1_, GTK_RESPONSE_CANCEL, _tmp2_, GTK_RESPONSE_ACCEPT, NULL);
	g_object_ref_sink (_tmp3_);
	_data78_->filechooser = _tmp3_;
	gtk_file_chooser_set_select_multiple (G_TYPE_CHECK_INSTANCE_CAST (_data78_->filechooser, GTK_TYPE_FILE_CHOOSER, GtkFileChooser), FALSE);
	gtk_window_set_modal (G_TYPE_CHECK_INSTANCE_CAST (_data78_->filechooser, gtk_window_get_type (), GtkWindow), TRUE);
	g_signal_connect_data (G_TYPE_CHECK_INSTANCE_CAST (_data78_->filechooser, gtk_dialog_get_type (), GtkDialog), "response", (GCallback) ___lambda149__gtk_dialog_response, block78_data_ref (_data78_), (GClosureNotify) block78_data_unref, 0);
	_tmp4_ = gtk_file_filter_new ();
	g_object_ref_sink (_tmp4_);
	filter = _tmp4_;
	gtk_file_filter_add_mime_type (filter, "image/png");
	gtk_file_filter_add_mime_type (filter, "image/jpeg");
	gtk_file_chooser_set_filter (G_TYPE_CHECK_INSTANCE_CAST (_data78_->filechooser, GTK_TYPE_FILE_CHOOSER, GtkFileChooser), filter);
	gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (_data78_->filechooser, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (filter);
	block78_data_unref (_data78_);
	_data78_ = NULL;
}


static void account_dialog_avatar_clicked_cb (AccountDialog* self) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	CropWidget* _tmp2_ = NULL;
	CropWidget* _tmp3_ = NULL;
	CropWidget* _tmp4_ = NULL;
	CropWidget* _tmp5_ = NULL;
	GtkStack* _tmp6_ = NULL;
	CropWidget* _tmp7_ = NULL;
	GtkButton* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	g_return_if_fail (IS_ACCOUNT_DIALOG (self));
	gtk_window_get_size (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), &_tmp0_, &_tmp1_);
	self->priv->old_width = _tmp0_;
	self->priv->old_height = _tmp1_;
	gtk_window_resize (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), 400, 400);
	_tmp2_ = self->priv->crop_widget;
	crop_widget_set_image (_tmp2_, NULL);
	_tmp3_ = self->priv->crop_widget;
	gtk_widget_set_size_request (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_widget_get_type (), GtkWidget), -1, 400);
	_tmp4_ = self->priv->crop_widget;
	crop_widget_set_desired_aspect_ratio (_tmp4_, 1.0);
	_tmp5_ = self->priv->crop_widget;
	crop_widget_set_min_size (_tmp5_, 48);
	_tmp6_ = self->priv->content_stack;
	_tmp7_ = self->priv->crop_widget;
	gtk_stack_set_visible_child (_tmp6_, G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_widget_get_type (), GtkWidget));
	account_dialog_show_crop_image_selector (self);
	_tmp8_ = self->priv->save_button;
	_tmp9_ = _ ("Pick");
	gtk_button_set_label (_tmp8_, _tmp9_);
}


static void _account_dialog_avatar_clicked_cb_avatar_banner_widget_avatar_clicked (AvatarBannerWidget* _sender, gpointer self) {
	account_dialog_avatar_clicked_cb ((AccountDialog*) self);
}


static void account_dialog_banner_clicked_cb (AccountDialog* self) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	CropWidget* _tmp2_ = NULL;
	CropWidget* _tmp3_ = NULL;
	CropWidget* _tmp4_ = NULL;
	CropWidget* _tmp5_ = NULL;
	GtkStack* _tmp6_ = NULL;
	CropWidget* _tmp7_ = NULL;
	GtkButton* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	g_return_if_fail (IS_ACCOUNT_DIALOG (self));
	gtk_window_get_size (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), &_tmp0_, &_tmp1_);
	self->priv->old_width = _tmp0_;
	self->priv->old_height = _tmp1_;
	gtk_window_resize (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), 700, 350);
	_tmp2_ = self->priv->crop_widget;
	gtk_widget_set_size_request (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_widget_get_type (), GtkWidget), 700, 350);
	_tmp3_ = self->priv->crop_widget;
	crop_widget_set_image (_tmp3_, NULL);
	_tmp4_ = self->priv->crop_widget;
	crop_widget_set_desired_aspect_ratio (_tmp4_, 2.0);
	_tmp5_ = self->priv->crop_widget;
	crop_widget_set_min_size (_tmp5_, 200);
	_tmp6_ = self->priv->content_stack;
	_tmp7_ = self->priv->crop_widget;
	gtk_stack_set_visible_child (_tmp6_, G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_widget_get_type (), GtkWidget));
	account_dialog_show_crop_image_selector (self);
	_tmp8_ = self->priv->save_button;
	_tmp9_ = _ ("Pick");
	gtk_button_set_label (_tmp8_, _tmp9_);
}


static void _account_dialog_banner_clicked_cb_avatar_banner_widget_banner_clicked (AvatarBannerWidget* _sender, gpointer self) {
	account_dialog_banner_clicked_cb ((AccountDialog*) self);
}


static void account_dialog_cancel_button_clicked_cb (AccountDialog* self) {
	gboolean _tmp0_ = FALSE;
	GtkStack* _tmp1_ = NULL;
	GtkWidget* _tmp2_ = NULL;
	GtkWidget* _tmp3_ = NULL;
	CropWidget* _tmp4_ = NULL;
	g_return_if_fail (IS_ACCOUNT_DIALOG (self));
	_tmp1_ = self->priv->content_stack;
	_tmp2_ = gtk_stack_get_visible_child (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->crop_widget;
	if (_tmp3_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_widget_get_type (), GtkWidget)) {
		_tmp0_ = TRUE;
	} else {
		GtkStack* _tmp5_ = NULL;
		GtkWidget* _tmp6_ = NULL;
		GtkWidget* _tmp7_ = NULL;
		GtkLabel* _tmp8_ = NULL;
		_tmp5_ = self->priv->content_stack;
		_tmp6_ = gtk_stack_get_visible_child (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = self->priv->error_label;
		_tmp0_ = _tmp7_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_widget_get_type (), GtkWidget);
	}
	if (_tmp0_) {
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
		GtkStack* _tmp11_ = NULL;
		GtkBox* _tmp12_ = NULL;
		GtkButton* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		_tmp9_ = self->priv->old_width;
		_tmp10_ = self->priv->old_height;
		gtk_window_resize (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), _tmp9_, _tmp10_);
		self->priv->old_width = 0;
		self->priv->old_height = 0;
		_tmp11_ = self->priv->content_stack;
		_tmp12_ = self->priv->info_box;
		gtk_stack_set_visible_child (_tmp11_, G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_widget_get_type (), GtkWidget));
		_tmp13_ = self->priv->save_button;
		_tmp14_ = _ ("Save");
		gtk_button_set_label (_tmp13_, _tmp14_);
	} else {
		gtk_widget_destroy (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	}
}


static void _account_dialog_cancel_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	account_dialog_cancel_button_clicked_cb ((AccountDialog*) self);
}


static void account_dialog_save_button_clicked_cb (AccountDialog* self) {
	GtkStack* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	GtkWidget* _tmp2_ = NULL;
	CropWidget* _tmp3_ = NULL;
	g_return_if_fail (IS_ACCOUNT_DIALOG (self));
	_tmp0_ = self->priv->content_stack;
	_tmp1_ = gtk_stack_get_visible_child (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->crop_widget;
	if (_tmp2_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_widget_get_type (), GtkWidget)) {
		GdkPixbuf* new_pixbuf = NULL;
		CropWidget* _tmp4_ = NULL;
		GdkPixbuf* _tmp5_ = NULL;
		CropWidget* _tmp6_ = NULL;
		gdouble _tmp7_ = 0.0;
		gdouble _tmp8_ = 0.0;
		GtkButton* _tmp20_ = NULL;
		const gchar* _tmp21_ = NULL;
		GtkStack* _tmp22_ = NULL;
		GtkBox* _tmp23_ = NULL;
		_tmp4_ = self->priv->crop_widget;
		_tmp5_ = crop_widget_get_cropped_image (_tmp4_);
		new_pixbuf = _tmp5_;
		_tmp6_ = self->priv->crop_widget;
		_tmp7_ = crop_widget_get_desired_aspect_ratio (_tmp6_);
		_tmp8_ = _tmp7_;
		if (_tmp8_ == 1.0) {
			AvatarBannerWidget* _tmp9_ = NULL;
			GdkPixbuf* _tmp10_ = NULL;
			GdkPixbuf* _tmp11_ = NULL;
			GdkPixbuf* _tmp12_ = NULL;
			_tmp9_ = self->priv->avatar_banner_widget;
			_tmp10_ = new_pixbuf;
			avatar_banner_widget_set_avatar (_tmp9_, _tmp10_);
			_tmp11_ = new_pixbuf;
			_tmp12_ = _g_object_ref0 (_tmp11_);
			_g_object_unref0 (self->priv->new_avatar);
			self->priv->new_avatar = _tmp12_;
		} else {
			CropWidget* _tmp13_ = NULL;
			gdouble _tmp14_ = 0.0;
			gdouble _tmp15_ = 0.0;
			_tmp13_ = self->priv->crop_widget;
			_tmp14_ = crop_widget_get_desired_aspect_ratio (_tmp13_);
			_tmp15_ = _tmp14_;
			if (_tmp15_ == 2.0) {
				AvatarBannerWidget* _tmp16_ = NULL;
				GdkPixbuf* _tmp17_ = NULL;
				GdkPixbuf* _tmp18_ = NULL;
				GdkPixbuf* _tmp19_ = NULL;
				_tmp16_ = self->priv->avatar_banner_widget;
				_tmp17_ = new_pixbuf;
				avatar_banner_widget_set_banner (_tmp16_, _tmp17_);
				_tmp18_ = new_pixbuf;
				_tmp19_ = _g_object_ref0 (_tmp18_);
				_g_object_unref0 (self->priv->new_banner);
				self->priv->new_banner = _tmp19_;
			} else {
				g_assert_not_reached ();
			}
		}
		_tmp20_ = self->priv->save_button;
		_tmp21_ = _ ("Save");
		gtk_button_set_label (_tmp20_, _tmp21_);
		_tmp22_ = self->priv->content_stack;
		_tmp23_ = self->priv->info_box;
		gtk_stack_set_visible_child (_tmp22_, G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, gtk_widget_get_type (), GtkWidget));
		_g_object_unref0 (new_pixbuf);
	} else {
		account_dialog_save_data (self);
		gtk_widget_destroy (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	}
}


static void _account_dialog_save_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	account_dialog_save_button_clicked_cb ((AccountDialog*) self);
}


static void account_dialog_class_init (AccountDialogClass * klass) {
	gint AccountDialog_private_offset;
	account_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (AccountDialogPrivate));
	G_OBJECT_CLASS (klass)->finalize = account_dialog_finalize;
	AccountDialog_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/baedert/corebird/ui/account-dialog.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "name_entry", FALSE, AccountDialog_private_offset + G_STRUCT_OFFSET (AccountDialogPrivate, name_entry));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "avatar_banner_widget", FALSE, AccountDialog_private_offset + G_STRUCT_OFFSET (AccountDialogPrivate, avatar_banner_widget));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "delete_stack", FALSE, AccountDialog_private_offset + G_STRUCT_OFFSET (AccountDialogPrivate, delete_stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "autostart_switch", FALSE, AccountDialog_private_offset + G_STRUCT_OFFSET (AccountDialogPrivate, autostart_switch));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "website_entry", FALSE, AccountDialog_private_offset + G_STRUCT_OFFSET (AccountDialogPrivate, website_entry));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "description_text_view", FALSE, AccountDialog_private_offset + G_STRUCT_OFFSET (AccountDialogPrivate, description_text_view));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "crop_widget", FALSE, AccountDialog_private_offset + G_STRUCT_OFFSET (AccountDialogPrivate, crop_widget));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "content_stack", FALSE, AccountDialog_private_offset + G_STRUCT_OFFSET (AccountDialogPrivate, content_stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "info_box", FALSE, AccountDialog_private_offset + G_STRUCT_OFFSET (AccountDialogPrivate, info_box));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "error_label", FALSE, AccountDialog_private_offset + G_STRUCT_OFFSET (AccountDialogPrivate, error_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "save_button", FALSE, AccountDialog_private_offset + G_STRUCT_OFFSET (AccountDialogPrivate, save_button));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "delete_button_clicked_cb", G_CALLBACK(_account_dialog_delete_button_clicked_cb_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "delete_confirm_button_clicked_cb", G_CALLBACK(_account_dialog_delete_confirm_button_clicked_cb_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "delete_cancel_button_clicked_cb", G_CALLBACK(_account_dialog_delete_cancel_button_clicked_cb_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "autostart_switch_activate_cb", G_CALLBACK(_account_dialog_autostart_switch_activate_cb_g_object_notify));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "avatar_clicked_cb", G_CALLBACK(_account_dialog_avatar_clicked_cb_avatar_banner_widget_avatar_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "banner_clicked_cb", G_CALLBACK(_account_dialog_banner_clicked_cb_avatar_banner_widget_banner_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "cancel_button_clicked_cb", G_CALLBACK(_account_dialog_cancel_button_clicked_cb_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "save_button_clicked_cb", G_CALLBACK(_account_dialog_save_button_clicked_cb_gtk_button_clicked));
}


static void account_dialog_instance_init (AccountDialog * self) {
	self->priv = ACCOUNT_DIALOG_GET_PRIVATE (self);
	self->priv->new_avatar = NULL;
	self->priv->new_banner = NULL;
	self->priv->old_width = 0;
	self->priv->old_height = 0;
	g_type_ensure (TYPE_AVATAR_BANNER_WIDGET);
	g_type_ensure (TYPE_COMPLETION_TEXT_VIEW);
	g_type_ensure (TYPE_CROP_WIDGET);
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void account_dialog_finalize (GObject* obj) {
	AccountDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ACCOUNT_DIALOG, AccountDialog);
	_g_object_unref0 (self->priv->name_entry);
	_g_object_unref0 (self->priv->avatar_banner_widget);
	_g_object_unref0 (self->priv->delete_stack);
	_g_object_unref0 (self->priv->autostart_switch);
	_g_object_unref0 (self->priv->website_entry);
	_g_object_unref0 (self->priv->description_text_view);
	_g_object_unref0 (self->priv->crop_widget);
	_g_object_unref0 (self->priv->content_stack);
	_g_object_unref0 (self->priv->info_box);
	_g_object_unref0 (self->priv->error_label);
	_g_object_unref0 (self->priv->save_button);
	_g_free0 (self->priv->old_user_name);
	_g_free0 (self->priv->old_description);
	_g_free0 (self->priv->old_website);
	_g_object_unref0 (self->priv->new_avatar);
	_g_object_unref0 (self->priv->new_banner);
	G_OBJECT_CLASS (account_dialog_parent_class)->finalize (obj);
}


GType account_dialog_get_type (void) {
	static volatile gsize account_dialog_type_id__volatile = 0;
	if (g_once_init_enter (&account_dialog_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (AccountDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) account_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AccountDialog), 0, (GInstanceInitFunc) account_dialog_instance_init, NULL };
		GType account_dialog_type_id;
		account_dialog_type_id = g_type_register_static (gtk_window_get_type (), "AccountDialog", &g_define_type_info, 0);
		g_once_init_leave (&account_dialog_type_id__volatile, account_dialog_type_id);
	}
	return account_dialog_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



