/* MentionsTimeline.c generated by valac 0.34.6, the Vala compiler
 * generated from MentionsTimeline.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <json-glib/json-glib.h>
#include <rest/oauth-proxy.h>
#include "CbUserCounter.h"
#include "CbFilter.h"
#include "CbTweet.h"
#include <glib/gi18n-lib.h>
#include <gio/gio.h>


#define TYPE_SCROLL_WIDGET (scroll_widget_get_type ())
#define SCROLL_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCROLL_WIDGET, ScrollWidget))
#define SCROLL_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCROLL_WIDGET, ScrollWidgetClass))
#define IS_SCROLL_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCROLL_WIDGET))
#define IS_SCROLL_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCROLL_WIDGET))
#define SCROLL_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCROLL_WIDGET, ScrollWidgetClass))

typedef struct _ScrollWidget ScrollWidget;
typedef struct _ScrollWidgetClass ScrollWidgetClass;
typedef struct _ScrollWidgetPrivate ScrollWidgetPrivate;

#define TYPE_IPAGE (ipage_get_type ())
#define IPAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IPAGE, IPage))
#define IS_IPAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IPAGE))
#define IPAGE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_IPAGE, IPageIface))

typedef struct _IPage IPage;
typedef struct _IPageIface IPageIface;

#define TYPE_BUNDLE (bundle_get_type ())
#define BUNDLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUNDLE, Bundle))
#define BUNDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUNDLE, BundleClass))
#define IS_BUNDLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUNDLE))
#define IS_BUNDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUNDLE))
#define BUNDLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUNDLE, BundleClass))

typedef struct _Bundle Bundle;
typedef struct _BundleClass BundleClass;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

#define TYPE_DEFAULT_TIMELINE (default_timeline_get_type ())
#define DEFAULT_TIMELINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DEFAULT_TIMELINE, DefaultTimeline))
#define DEFAULT_TIMELINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DEFAULT_TIMELINE, DefaultTimelineClass))
#define IS_DEFAULT_TIMELINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DEFAULT_TIMELINE))
#define IS_DEFAULT_TIMELINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DEFAULT_TIMELINE))
#define DEFAULT_TIMELINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DEFAULT_TIMELINE, DefaultTimelineClass))

typedef struct _DefaultTimeline DefaultTimeline;
typedef struct _DefaultTimelineClass DefaultTimelineClass;
typedef struct _DefaultTimelinePrivate DefaultTimelinePrivate;

#define TYPE_TWEET_LIST_BOX (tweet_list_box_get_type ())
#define TWEET_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET_LIST_BOX, TweetListBox))
#define TWEET_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET_LIST_BOX, TweetListBoxClass))
#define IS_TWEET_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET_LIST_BOX))
#define IS_TWEET_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET_LIST_BOX))
#define TWEET_LIST_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET_LIST_BOX, TweetListBoxClass))

typedef struct _TweetListBox TweetListBox;
typedef struct _TweetListBoxClass TweetListBoxClass;

#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;

#define TYPE_BADGE_RADIO_BUTTON (badge_radio_button_get_type ())
#define BADGE_RADIO_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BADGE_RADIO_BUTTON, BadgeRadioButton))
#define BADGE_RADIO_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BADGE_RADIO_BUTTON, BadgeRadioButtonClass))
#define IS_BADGE_RADIO_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BADGE_RADIO_BUTTON))
#define IS_BADGE_RADIO_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BADGE_RADIO_BUTTON))
#define BADGE_RADIO_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BADGE_RADIO_BUTTON, BadgeRadioButtonClass))

typedef struct _BadgeRadioButton BadgeRadioButton;
typedef struct _BadgeRadioButtonClass BadgeRadioButtonClass;

#define TYPE_IMESSAGE_RECEIVER (imessage_receiver_get_type ())
#define IMESSAGE_RECEIVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IMESSAGE_RECEIVER, IMessageReceiver))
#define IS_IMESSAGE_RECEIVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IMESSAGE_RECEIVER))
#define IMESSAGE_RECEIVER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_IMESSAGE_RECEIVER, IMessageReceiverIface))

typedef struct _IMessageReceiver IMessageReceiver;
typedef struct _IMessageReceiverIface IMessageReceiverIface;

#define TYPE_STREAM_MESSAGE_TYPE (stream_message_type_get_type ())

#define TYPE_MENTIONS_TIMELINE (mentions_timeline_get_type ())
#define MENTIONS_TIMELINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MENTIONS_TIMELINE, MentionsTimeline))
#define MENTIONS_TIMELINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MENTIONS_TIMELINE, MentionsTimelineClass))
#define IS_MENTIONS_TIMELINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MENTIONS_TIMELINE))
#define IS_MENTIONS_TIMELINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MENTIONS_TIMELINE))
#define MENTIONS_TIMELINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MENTIONS_TIMELINE, MentionsTimelineClass))

typedef struct _MentionsTimeline MentionsTimeline;
typedef struct _MentionsTimelineClass MentionsTimelineClass;
typedef struct _MentionsTimelinePrivate MentionsTimelinePrivate;
typedef struct _TweetListBoxPrivate TweetListBoxPrivate;

#define TYPE_DELTA_UPDATER (delta_updater_get_type ())
#define DELTA_UPDATER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DELTA_UPDATER, DeltaUpdater))
#define DELTA_UPDATER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DELTA_UPDATER, DeltaUpdaterClass))
#define IS_DELTA_UPDATER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DELTA_UPDATER))
#define IS_DELTA_UPDATER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DELTA_UPDATER))
#define DELTA_UPDATER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DELTA_UPDATER, DeltaUpdaterClass))

typedef struct _DeltaUpdater DeltaUpdater;
typedef struct _DeltaUpdaterClass DeltaUpdaterClass;

#define TYPE_TWEET_MODEL (tweet_model_get_type ())
#define TWEET_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET_MODEL, TweetModel))
#define TWEET_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET_MODEL, TweetModelClass))
#define IS_TWEET_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET_MODEL))
#define IS_TWEET_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET_MODEL))
#define TWEET_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET_MODEL, TweetModelClass))

typedef struct _TweetModel TweetModel;
typedef struct _TweetModelClass TweetModelClass;
typedef struct _AccountPrivate AccountPrivate;

#define SQL_TYPE_DATABASE (sql_database_get_type ())
#define SQL_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_DATABASE, SqlDatabase))
#define SQL_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_DATABASE, SqlDatabaseClass))
#define SQL_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_DATABASE))
#define SQL_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_DATABASE))
#define SQL_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_DATABASE, SqlDatabaseClass))

typedef struct _SqlDatabase SqlDatabase;
typedef struct _SqlDatabaseClass SqlDatabaseClass;

#define TYPE_USER_STREAM (user_stream_get_type ())
#define USER_STREAM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_USER_STREAM, UserStream))
#define USER_STREAM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_USER_STREAM, UserStreamClass))
#define IS_USER_STREAM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_USER_STREAM))
#define IS_USER_STREAM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_USER_STREAM))
#define USER_STREAM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_USER_STREAM, UserStreamClass))

typedef struct _UserStream UserStream;
typedef struct _UserStreamClass UserStreamClass;

#define TYPE_NOTIFICATION_MANAGER (notification_manager_get_type ())
#define NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManager))
#define NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))
#define IS_NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFICATION_MANAGER))
#define IS_NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFICATION_MANAGER))
#define NOTIFICATION_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))

typedef struct _NotificationManager NotificationManager;
typedef struct _NotificationManagerClass NotificationManagerClass;
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

struct _ScrollWidget {
	GtkScrolledWindow parent_instance;
	ScrollWidgetPrivate * priv;
};

struct _ScrollWidgetClass {
	GtkScrolledWindowClass parent_class;
};

struct _IPageIface {
	GTypeInterface parent_iface;
	void (*on_join) (IPage* self, gint page_id, Bundle* args);
	void (*on_leave) (IPage* self);
	void (*create_radio_button) (IPage* self, GtkRadioButton* group);
	GtkRadioButton* (*get_radio_button) (IPage* self);
	gchar* (*get_title) (IPage* self);
	gboolean (*handles_double_open) (IPage* self);
	void (*double_open) (IPage* self);
	gint (*get_id) (IPage* self);
	void (*set_id) (IPage* self, gint value);
	void (*set_window) (IPage* self, MainWindow* value);
};

struct _DefaultTimeline {
	ScrollWidget parent_instance;
	DefaultTimelinePrivate * priv;
	gboolean initialized;
	MainWindow* main_window;
	TweetListBox* tweet_list;
	Account* account;
	BadgeRadioButton* radio_button;
	guint tweet_remove_timeout;
	gboolean loading;
	GtkWidget* last_focus_widget;
};

struct _DefaultTimelineClass {
	ScrollWidgetClass parent_class;
	void (*on_join) (DefaultTimeline* self, gint page_id, Bundle* args);
	void (*on_leave) (DefaultTimeline* self);
	gchar* (*get_title) (DefaultTimeline* self);
	void (*create_radio_button) (DefaultTimeline* self, GtkRadioButton* group);
	const gchar* (*get_function) (DefaultTimeline* self);
};

typedef enum  {
	STREAM_MESSAGE_TYPE_UNSUPPORTED,
	STREAM_MESSAGE_TYPE_DELETE,
	STREAM_MESSAGE_TYPE_SCRUB_GEO,
	STREAM_MESSAGE_TYPE_LIMIT,
	STREAM_MESSAGE_TYPE_DISCONNECT,
	STREAM_MESSAGE_TYPE_FRIENDS,
	STREAM_MESSAGE_TYPE_EVENT,
	STREAM_MESSAGE_TYPE_WARNING,
	STREAM_MESSAGE_TYPE_DIRECT_MESSAGE,
	STREAM_MESSAGE_TYPE_TWEET,
	STREAM_MESSAGE_TYPE_EVENT_LIST_CREATED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_DESTROYED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_UPDATED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_UNSUBSCRIBED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_SUBSCRIBED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_MEMBER_ADDED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_MEMBER_REMOVED,
	STREAM_MESSAGE_TYPE_EVENT_FAVORITE,
	STREAM_MESSAGE_TYPE_EVENT_UNFAVORITE,
	STREAM_MESSAGE_TYPE_EVENT_FOLLOW,
	STREAM_MESSAGE_TYPE_EVENT_UNFOLLOW,
	STREAM_MESSAGE_TYPE_EVENT_BLOCK,
	STREAM_MESSAGE_TYPE_EVENT_UNBLOCK,
	STREAM_MESSAGE_TYPE_EVENT_MUTE,
	STREAM_MESSAGE_TYPE_EVENT_UNMUTE,
	STREAM_MESSAGE_TYPE_EVENT_USER_UPDATE,
	STREAM_MESSAGE_TYPE_EVENT_QUOTED_TWEET
} StreamMessageType;

struct _IMessageReceiverIface {
	GTypeInterface parent_iface;
	void (*stream_message_received) (IMessageReceiver* self, StreamMessageType type, JsonNode* root_node);
};

struct _MentionsTimeline {
	DefaultTimeline parent_instance;
	MentionsTimelinePrivate * priv;
};

struct _MentionsTimelineClass {
	DefaultTimelineClass parent_class;
};

struct _TweetListBox {
	GtkListBox parent_instance;
	TweetListBoxPrivate * priv;
	DeltaUpdater* delta_updater;
	Account* account;
	TweetModel* model;
};

struct _TweetListBoxClass {
	GtkListBoxClass parent_class;
};

struct _Account {
	GObject parent_instance;
	AccountPrivate * priv;
	gint64 id;
	SqlDatabase* db;
	OAuthProxy* proxy;
	UserStream* user_stream;
	CbUserCounter* user_counter;
	NotificationManager* notifications;
	gint64* friends;
	gint friends_length1;
	gint64* blocked;
	gint blocked_length1;
	gint64* muted;
	gint muted_length1;
	gint64* disabled_rts;
	gint disabled_rts_length1;
	GPtrArray* filters;
};

struct _AccountClass {
	GObjectClass parent_class;
};


static gpointer mentions_timeline_parent_class = NULL;
static IMessageReceiverIface* mentions_timeline_imessage_receiver_parent_iface = NULL;

GType scroll_widget_get_type (void) G_GNUC_CONST;
GType bundle_get_type (void) G_GNUC_CONST;
GType main_window_get_type (void) G_GNUC_CONST;
GType ipage_get_type (void) G_GNUC_CONST;
GType default_timeline_get_type (void) G_GNUC_CONST;
GType tweet_list_box_get_type (void) G_GNUC_CONST;
GType account_get_type (void) G_GNUC_CONST;
GType badge_radio_button_get_type (void) G_GNUC_CONST;
GType stream_message_type_get_type (void) G_GNUC_CONST;
GType imessage_receiver_get_type (void) G_GNUC_CONST;
GType mentions_timeline_get_type (void) G_GNUC_CONST;
enum  {
	MENTIONS_TIMELINE_DUMMY_PROPERTY,
	MENTIONS_TIMELINE_FUNCTION
};
MentionsTimeline* mentions_timeline_new (gint id, Account* account);
MentionsTimeline* mentions_timeline_construct (GType object_type, gint id, Account* account);
DefaultTimeline* default_timeline_construct (GType object_type, gint id);
GType delta_updater_get_type (void) G_GNUC_CONST;
GType tweet_model_get_type (void) G_GNUC_CONST;
static void mentions_timeline_real_stream_message_received (IMessageReceiver* base, StreamMessageType type, JsonNode* root);
static void mentions_timeline_add_tweet (MentionsTimeline* self, JsonNode* root_node);
void default_timeline_delete_tweet (DefaultTimeline* self, gint64 tweet_id);
void default_timeline_toggle_favorite (DefaultTimeline* self, gint64 id, gboolean mode);
GType sql_database_get_type (void) G_GNUC_CONST;
GType user_stream_get_type (void) G_GNUC_CONST;
GType notification_manager_get_type (void) G_GNUC_CONST;
void default_timeline_mark_seen (DefaultTimeline* self, gint64 id);
const gchar* account_get_screen_name (Account* self);
CbTweetState default_timeline_get_rt_flags (DefaultTimeline* self, CbTweet* t);
gboolean account_filter_matches (Account* self, CbTweet* t);
gboolean account_blocked_or_muted (Account* self, gint64 user_id);
void scroll_widget_balance_next_upper_change (ScrollWidget* self, gint mode);
#define TOP 1
void tweet_model_add (TweetModel* self, CbTweet* tweet);
gboolean default_timeline_scroll_up (DefaultTimeline* self, CbTweet* t);
gint default_timeline_get_unread_count (DefaultTimeline* self);
void default_timeline_set_unread_count (DefaultTimeline* self, gint value);
gboolean settings_notify_new_mentions (void);
gchar* utils_unescape_html (const gchar* input);
const gchar* account_get_name (Account* self);
static GVariant* _variant_new1 (gint64 value);
static GVariant* _variant_new2 (gint64 value);
static GVariant* _variant_new3 (gint64 value);
static gchar* mentions_timeline_real_get_title (DefaultTimeline* base);
static void mentions_timeline_real_create_radio_button (DefaultTimeline* base, GtkRadioButton* group);
BadgeRadioButton* badge_radio_button_new (GtkRadioButton* group, const gchar* icon_name, const gchar* text);
BadgeRadioButton* badge_radio_button_construct (GType object_type, GtkRadioButton* group, const gchar* icon_name, const gchar* text);
const gchar* default_timeline_get_function (DefaultTimeline* self);
static void _vala_mentions_timeline_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


MentionsTimeline* mentions_timeline_construct (GType object_type, gint id, Account* account) {
	MentionsTimeline * self = NULL;
	gint _tmp0_ = 0;
	Account* _tmp1_ = NULL;
	TweetListBox* _tmp2_ = NULL;
	Account* _tmp3_ = NULL;
	g_return_val_if_fail (IS_ACCOUNT (account), NULL);
	_tmp0_ = id;
	self = (MentionsTimeline*) default_timeline_construct (object_type, _tmp0_);
	_tmp1_ = account;
	G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->account = _tmp1_;
	_tmp2_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->tweet_list;
	_tmp3_ = account;
	_tmp2_->account = _tmp3_;
	return self;
}


MentionsTimeline* mentions_timeline_new (gint id, Account* account) {
	return mentions_timeline_construct (TYPE_MENTIONS_TIMELINE, id, account);
}


static void mentions_timeline_real_stream_message_received (IMessageReceiver* base, StreamMessageType type, JsonNode* root) {
	MentionsTimeline * self;
	StreamMessageType _tmp0_ = 0;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_MENTIONS_TIMELINE, MentionsTimeline);
	g_return_if_fail (root != NULL);
	_tmp0_ = type;
	if (_tmp0_ == STREAM_MESSAGE_TYPE_TWEET) {
		JsonNode* _tmp1_ = NULL;
		_tmp1_ = root;
		mentions_timeline_add_tweet (self, _tmp1_);
	} else {
		StreamMessageType _tmp2_ = 0;
		_tmp2_ = type;
		if (_tmp2_ == STREAM_MESSAGE_TYPE_DELETE) {
			gint64 id = 0LL;
			JsonNode* _tmp3_ = NULL;
			JsonObject* _tmp4_ = NULL;
			JsonObject* _tmp5_ = NULL;
			JsonObject* _tmp6_ = NULL;
			gint64 _tmp7_ = 0LL;
			gint64 _tmp8_ = 0LL;
			_tmp3_ = root;
			_tmp4_ = json_node_get_object (_tmp3_);
			_tmp5_ = json_object_get_object_member (_tmp4_, "delete");
			_tmp6_ = json_object_get_object_member (_tmp5_, "status");
			_tmp7_ = json_object_get_int_member (_tmp6_, "id");
			id = _tmp7_;
			_tmp8_ = id;
			default_timeline_delete_tweet (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline), _tmp8_);
		} else {
			StreamMessageType _tmp9_ = 0;
			_tmp9_ = type;
			if (_tmp9_ == STREAM_MESSAGE_TYPE_EVENT_FAVORITE) {
				gint64 id = 0LL;
				JsonNode* _tmp10_ = NULL;
				JsonObject* _tmp11_ = NULL;
				JsonObject* _tmp12_ = NULL;
				gint64 _tmp13_ = 0LL;
				gint64 _tmp14_ = 0LL;
				_tmp10_ = root;
				_tmp11_ = json_node_get_object (_tmp10_);
				_tmp12_ = json_object_get_object_member (_tmp11_, "target_object");
				_tmp13_ = json_object_get_int_member (_tmp12_, "id");
				id = _tmp13_;
				_tmp14_ = id;
				default_timeline_toggle_favorite (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline), _tmp14_, TRUE);
			} else {
				StreamMessageType _tmp15_ = 0;
				_tmp15_ = type;
				if (_tmp15_ == STREAM_MESSAGE_TYPE_EVENT_UNFAVORITE) {
					gint64 id = 0LL;
					JsonNode* _tmp16_ = NULL;
					JsonObject* _tmp17_ = NULL;
					JsonObject* _tmp18_ = NULL;
					gint64 _tmp19_ = 0LL;
					gint64 _tmp20_ = 0LL;
					_tmp16_ = root;
					_tmp17_ = json_node_get_object (_tmp16_);
					_tmp18_ = json_object_get_object_member (_tmp17_, "target_object");
					_tmp19_ = json_object_get_int_member (_tmp18_, "id");
					id = _tmp19_;
					_tmp20_ = id;
					default_timeline_toggle_favorite (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline), _tmp20_, FALSE);
				}
			}
		}
	}
}


static gpointer _json_object_ref0 (gpointer self) {
	return self ? json_object_ref (self) : NULL;
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


static GVariant* _variant_new1 (gint64 value) {
	return g_variant_ref_sink (g_variant_new_int64 (value));
}


static GVariant* _variant_new2 (gint64 value) {
	return g_variant_ref_sink (g_variant_new_int64 (value));
}


static GVariant* _variant_new3 (gint64 value) {
	return g_variant_ref_sink (g_variant_new_int64 (value));
}


static void mentions_timeline_add_tweet (MentionsTimeline* self, JsonNode* root_node) {
	JsonObject* root = NULL;
	JsonNode* _tmp0_ = NULL;
	JsonObject* _tmp1_ = NULL;
	JsonObject* _tmp2_ = NULL;
	JsonObject* author = NULL;
	JsonObject* _tmp3_ = NULL;
	JsonObject* _tmp4_ = NULL;
	JsonObject* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	JsonObject* _tmp7_ = NULL;
	gint64 _tmp8_ = 0LL;
	Account* _tmp9_ = NULL;
	gint64 _tmp10_ = 0LL;
	JsonObject* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	Account* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	gboolean _tmp22_ = FALSE;
	gboolean _tmp23_ = FALSE;
	g_return_if_fail (IS_MENTIONS_TIMELINE (self));
	g_return_if_fail (root_node != NULL);
	_tmp0_ = root_node;
	_tmp1_ = json_node_get_object (_tmp0_);
	_tmp2_ = _json_object_ref0 (_tmp1_);
	root = _tmp2_;
	_tmp3_ = root;
	_tmp4_ = json_object_get_object_member (_tmp3_, "user");
	_tmp5_ = _json_object_ref0 (_tmp4_);
	author = _tmp5_;
	_tmp7_ = author;
	_tmp8_ = json_object_get_int_member (_tmp7_, "id");
	_tmp9_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->account;
	_tmp10_ = _tmp9_->id;
	if (_tmp8_ == _tmp10_) {
		JsonObject* _tmp11_ = NULL;
		gboolean _tmp12_ = FALSE;
		_tmp11_ = root;
		_tmp12_ = json_object_get_null_member (_tmp11_, "in_reply_to_status_id");
		_tmp6_ = !_tmp12_;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		JsonObject* _tmp13_ = NULL;
		gint64 _tmp14_ = 0LL;
		_tmp13_ = root;
		_tmp14_ = json_object_get_int_member (_tmp13_, "in_reply_to_status_id");
		default_timeline_mark_seen (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline), _tmp14_);
		_json_object_unref0 (author);
		_json_object_unref0 (root);
		return;
	}
	_tmp15_ = root;
	_tmp16_ = json_object_get_string_member (_tmp15_, "text");
	_tmp17_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->account;
	_tmp18_ = account_get_screen_name (_tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = g_strconcat ("@", _tmp19_, NULL);
	_tmp21_ = _tmp20_;
	_tmp22_ = string_contains (_tmp16_, _tmp21_);
	_tmp23_ = _tmp22_;
	_g_free0 (_tmp21_);
	if (_tmp23_) {
		GDateTime* now = NULL;
		GDateTime* _tmp24_ = NULL;
		CbTweet* t = NULL;
		CbTweet* _tmp25_ = NULL;
		CbTweet* _tmp26_ = NULL;
		JsonNode* _tmp27_ = NULL;
		Account* _tmp28_ = NULL;
		gint64 _tmp29_ = 0LL;
		GDateTime* _tmp30_ = NULL;
		CbTweet* _tmp31_ = NULL;
		gint64 _tmp32_ = 0LL;
		Account* _tmp33_ = NULL;
		gint64 _tmp34_ = 0LL;
		gboolean _tmp35_ = FALSE;
		CbTweet* _tmp36_ = NULL;
		CbMiniTweet* _tmp37_ = NULL;
		Account* _tmp40_ = NULL;
		CbTweet* _tmp41_ = NULL;
		gboolean _tmp42_ = FALSE;
		Account* _tmp43_ = NULL;
		CbTweet* _tmp44_ = NULL;
		gint64 _tmp45_ = 0LL;
		gboolean _tmp46_ = FALSE;
		CbTweet* _tmp47_ = NULL;
		TweetListBox* _tmp48_ = NULL;
		TweetModel* _tmp49_ = NULL;
		CbTweet* _tmp50_ = NULL;
		CbTweet* _tmp51_ = NULL;
		gint _tmp52_ = 0;
		gint _tmp53_ = 0;
		gboolean _tmp54_ = FALSE;
		_tmp24_ = g_date_time_new_now_local ();
		now = _tmp24_;
		_tmp25_ = cb_tweet_new ();
		t = _tmp25_;
		_tmp26_ = t;
		_tmp27_ = root_node;
		_tmp28_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->account;
		_tmp29_ = _tmp28_->id;
		_tmp30_ = now;
		cb_tweet_load_from_json (_tmp26_, _tmp27_, _tmp29_, _tmp30_);
		_tmp31_ = t;
		_tmp32_ = cb_tweet_get_user_id (_tmp31_);
		_tmp33_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->account;
		_tmp34_ = _tmp33_->id;
		if (_tmp32_ == _tmp34_) {
			_g_object_unref0 (t);
			_g_date_time_unref0 (now);
			_json_object_unref0 (author);
			_json_object_unref0 (root);
			return;
		}
		_tmp36_ = t;
		_tmp37_ = _tmp36_->retweeted_tweet;
		if (_tmp37_ != NULL) {
			CbTweet* _tmp38_ = NULL;
			CbTweetState _tmp39_ = 0;
			_tmp38_ = t;
			_tmp39_ = default_timeline_get_rt_flags (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline), _tmp38_);
			_tmp35_ = _tmp39_ > 0;
		} else {
			_tmp35_ = FALSE;
		}
		if (_tmp35_) {
			_g_object_unref0 (t);
			_g_date_time_unref0 (now);
			_json_object_unref0 (author);
			_json_object_unref0 (root);
			return;
		}
		_tmp40_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->account;
		_tmp41_ = t;
		_tmp42_ = account_filter_matches (_tmp40_, _tmp41_);
		if (_tmp42_) {
			_g_object_unref0 (t);
			_g_date_time_unref0 (now);
			_json_object_unref0 (author);
			_json_object_unref0 (root);
			return;
		}
		_tmp43_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->account;
		_tmp44_ = t;
		_tmp45_ = cb_tweet_get_user_id (_tmp44_);
		_tmp46_ = account_blocked_or_muted (_tmp43_, _tmp45_);
		if (_tmp46_) {
			_g_object_unref0 (t);
			_g_date_time_unref0 (now);
			_json_object_unref0 (author);
			_json_object_unref0 (root);
			return;
		}
		scroll_widget_balance_next_upper_change (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SCROLL_WIDGET, ScrollWidget), TOP);
		_tmp47_ = t;
		cb_tweet_set_seen (_tmp47_, FALSE);
		_tmp48_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->tweet_list;
		_tmp49_ = _tmp48_->model;
		_tmp50_ = t;
		tweet_model_add (_tmp49_, _tmp50_);
		_tmp51_ = t;
		default_timeline_scroll_up (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline), _tmp51_);
		_tmp52_ = default_timeline_get_unread_count (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline));
		_tmp53_ = _tmp52_;
		default_timeline_set_unread_count (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline), _tmp53_ + 1);
		_tmp54_ = settings_notify_new_mentions ();
		if (_tmp54_) {
			gchar* text = NULL;
			CbTweet* _tmp55_ = NULL;
			CbMiniTweet* _tmp56_ = NULL;
			gchar* summary = NULL;
			const gchar* _tmp65_ = NULL;
			CbTweet* _tmp66_ = NULL;
			const gchar* _tmp67_ = NULL;
			gchar* _tmp68_ = NULL;
			gchar* _tmp69_ = NULL;
			Account* _tmp70_ = NULL;
			const gchar* _tmp71_ = NULL;
			const gchar* _tmp72_ = NULL;
			gchar* _tmp73_ = NULL;
			gchar* _tmp74_ = NULL;
			gchar* id = NULL;
			Account* _tmp75_ = NULL;
			gint64 _tmp76_ = 0LL;
			gchar* _tmp77_ = NULL;
			gchar* _tmp78_ = NULL;
			gchar* _tmp79_ = NULL;
			gchar* _tmp80_ = NULL;
			GVariant* tuple = NULL;
			Account* _tmp81_ = NULL;
			gint64 _tmp82_ = 0LL;
			GVariant* _tmp83_ = NULL;
			CbTweet* _tmp84_ = NULL;
			gint64 _tmp85_ = 0LL;
			GVariant* _tmp86_ = NULL;
			GVariant** _tmp87_ = NULL;
			GVariant** _tmp88_ = NULL;
			gint _tmp88__length1 = 0;
			GVariant* _tmp89_ = NULL;
			GVariant* _tmp90_ = NULL;
			GNotification* notification = NULL;
			const gchar* _tmp91_ = NULL;
			GNotification* _tmp92_ = NULL;
			GNotification* _tmp93_ = NULL;
			const gchar* _tmp94_ = NULL;
			GNotification* _tmp95_ = NULL;
			Account* _tmp96_ = NULL;
			gint64 _tmp97_ = 0LL;
			GVariant* _tmp98_ = NULL;
			GNotification* _tmp99_ = NULL;
			GVariant* _tmp100_ = NULL;
			GNotification* _tmp101_ = NULL;
			GVariant* _tmp102_ = NULL;
			CbTweet* _tmp103_ = NULL;
			const gchar* _tmp104_ = NULL;
			gchar* _tmp105_ = NULL;
			GApplication* _tmp106_ = NULL;
			const gchar* _tmp107_ = NULL;
			GNotification* _tmp108_ = NULL;
			_tmp55_ = t;
			_tmp56_ = _tmp55_->retweeted_tweet;
			if (_tmp56_ != NULL) {
				CbTweet* _tmp57_ = NULL;
				CbMiniTweet* _tmp58_ = NULL;
				const gchar* _tmp59_ = NULL;
				gchar* _tmp60_ = NULL;
				_tmp57_ = t;
				_tmp58_ = _tmp57_->retweeted_tweet;
				_tmp59_ = (*_tmp58_).text;
				_tmp60_ = utils_unescape_html (_tmp59_);
				_g_free0 (text);
				text = _tmp60_;
			} else {
				CbTweet* _tmp61_ = NULL;
				CbMiniTweet _tmp62_ = {0};
				const gchar* _tmp63_ = NULL;
				gchar* _tmp64_ = NULL;
				_tmp61_ = t;
				_tmp62_ = _tmp61_->source_tweet;
				_tmp63_ = _tmp62_.text;
				_tmp64_ = utils_unescape_html (_tmp63_);
				_g_free0 (text);
				text = _tmp64_;
			}
			_tmp65_ = _ ("%s mentioned %s");
			_tmp66_ = t;
			_tmp67_ = cb_tweet_get_user_name (_tmp66_);
			_tmp68_ = utils_unescape_html (_tmp67_);
			_tmp69_ = _tmp68_;
			_tmp70_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->account;
			_tmp71_ = account_get_name (_tmp70_);
			_tmp72_ = _tmp71_;
			_tmp73_ = g_strdup_printf (_tmp65_, _tmp69_, _tmp72_);
			_tmp74_ = _tmp73_;
			_g_free0 (_tmp69_);
			summary = _tmp74_;
			_tmp75_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->account;
			_tmp76_ = _tmp75_->id;
			_tmp77_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp76_);
			_tmp78_ = _tmp77_;
			_tmp79_ = g_strdup_printf ("%s-%s", _tmp78_, "mention");
			_tmp80_ = _tmp79_;
			_g_free0 (_tmp78_);
			id = _tmp80_;
			_tmp81_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->account;
			_tmp82_ = _tmp81_->id;
			_tmp83_ = _variant_new1 (_tmp82_);
			_tmp84_ = t;
			_tmp85_ = _tmp84_->id;
			_tmp86_ = _variant_new2 (_tmp85_);
			_tmp87_ = g_new0 (GVariant*, 2 + 1);
			_tmp87_[0] = _tmp83_;
			_tmp87_[1] = _tmp86_;
			_tmp88_ = _tmp87_;
			_tmp88__length1 = 2;
			_tmp89_ = g_variant_new_tuple (_tmp88_, 2);
			g_variant_ref_sink (_tmp89_);
			_tmp90_ = _tmp89_;
			_tmp88_ = (_vala_array_free (_tmp88_, _tmp88__length1, (GDestroyNotify) g_variant_unref), NULL);
			tuple = _tmp90_;
			_tmp91_ = summary;
			_tmp92_ = g_notification_new (_tmp91_);
			notification = _tmp92_;
			_tmp93_ = notification;
			_tmp94_ = text;
			g_notification_set_body (_tmp93_, _tmp94_);
			_tmp95_ = notification;
			_tmp96_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->account;
			_tmp97_ = _tmp96_->id;
			_tmp98_ = _variant_new3 (_tmp97_);
			g_notification_set_default_action_and_target_value (_tmp95_, "app.show-window", _tmp98_);
			_g_variant_unref0 (_tmp98_);
			_tmp99_ = notification;
			_tmp100_ = tuple;
			g_notification_add_button_with_target_value (_tmp99_, "Mark read", "app.mark-read", _tmp100_);
			_tmp101_ = notification;
			_tmp102_ = tuple;
			g_notification_add_button_with_target_value (_tmp101_, "Reply", "app.reply-to-tweet", _tmp102_);
			_tmp103_ = t;
			_tmp104_ = id;
			_tmp105_ = g_strdup (_tmp104_);
			_g_free0 (_tmp103_->notification_id);
			_tmp103_->notification_id = _tmp105_;
			_tmp106_ = g_application_get_default ();
			_tmp107_ = id;
			_tmp108_ = notification;
			g_application_send_notification (_tmp106_, _tmp107_, _tmp108_);
			_g_object_unref0 (notification);
			_g_variant_unref0 (tuple);
			_g_free0 (id);
			_g_free0 (summary);
			_g_free0 (text);
		}
		_g_object_unref0 (t);
		_g_date_time_unref0 (now);
	}
	_json_object_unref0 (author);
	_json_object_unref0 (root);
}


static gchar* mentions_timeline_real_get_title (DefaultTimeline* base) {
	MentionsTimeline * self;
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_MENTIONS_TIMELINE, MentionsTimeline);
	_tmp0_ = _ ("Mentions");
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


static void mentions_timeline_real_create_radio_button (DefaultTimeline* base, GtkRadioButton* group) {
	MentionsTimeline * self;
	GtkRadioButton* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	BadgeRadioButton* _tmp2_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_MENTIONS_TIMELINE, MentionsTimeline);
	g_return_if_fail ((group == NULL) || GTK_IS_RADIO_BUTTON (group));
	_tmp0_ = group;
	_tmp1_ = _ ("Mentions");
	_tmp2_ = badge_radio_button_new (_tmp0_, "corebird-mentions-symbolic", _tmp1_);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->radio_button);
	G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->radio_button = _tmp2_;
}


static const gchar* mentions_timeline_real_get_function (DefaultTimeline* base) {
	const gchar* result;
	MentionsTimeline* self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_MENTIONS_TIMELINE, MentionsTimeline);
	result = "1.1/statuses/mentions_timeline.json";
	return result;
}


static void mentions_timeline_class_init (MentionsTimelineClass * klass) {
	mentions_timeline_parent_class = g_type_class_peek_parent (klass);
	((DefaultTimelineClass *) klass)->get_title = (gchar* (*)(DefaultTimeline*)) mentions_timeline_real_get_title;
	((DefaultTimelineClass *) klass)->create_radio_button = (void (*)(DefaultTimeline*, GtkRadioButton*)) mentions_timeline_real_create_radio_button;
	DEFAULT_TIMELINE_CLASS (klass)->get_function = mentions_timeline_real_get_function;
	G_OBJECT_CLASS (klass)->get_property = _vala_mentions_timeline_get_property;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MENTIONS_TIMELINE_FUNCTION, g_param_spec_string ("function", "function", "function", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void mentions_timeline_imessage_receiver_interface_init (IMessageReceiverIface * iface) {
	mentions_timeline_imessage_receiver_parent_iface = g_type_interface_peek_parent (iface);
	iface->stream_message_received = (void (*)(IMessageReceiver*, StreamMessageType, JsonNode*)) mentions_timeline_real_stream_message_received;
}


static void mentions_timeline_instance_init (MentionsTimeline * self) {
}


GType mentions_timeline_get_type (void) {
	static volatile gsize mentions_timeline_type_id__volatile = 0;
	if (g_once_init_enter (&mentions_timeline_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MentionsTimelineClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) mentions_timeline_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MentionsTimeline), 0, (GInstanceInitFunc) mentions_timeline_instance_init, NULL };
		static const GInterfaceInfo imessage_receiver_info = { (GInterfaceInitFunc) mentions_timeline_imessage_receiver_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType mentions_timeline_type_id;
		mentions_timeline_type_id = g_type_register_static (TYPE_DEFAULT_TIMELINE, "MentionsTimeline", &g_define_type_info, 0);
		g_type_add_interface_static (mentions_timeline_type_id, TYPE_IMESSAGE_RECEIVER, &imessage_receiver_info);
		g_once_init_leave (&mentions_timeline_type_id__volatile, mentions_timeline_type_id);
	}
	return mentions_timeline_type_id__volatile;
}


static void _vala_mentions_timeline_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	MentionsTimeline * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MENTIONS_TIMELINE, MentionsTimeline);
	switch (property_id) {
		case MENTIONS_TIMELINE_FUNCTION:
		g_value_set_string (value, default_timeline_get_function (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



