; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; Denormal mode shouldn't matter for f16, check with and without flushing.
; RUN: llc -global-isel -mtriple=amdgcn -mcpu=tahiti -denormal-fp-math=ieee -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX6,GFX6-IEEE %s
; RUN: llc -global-isel -mtriple=amdgcn -mcpu=tahiti -denormal-fp-math=preserve-sign -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX6,GFX6-FLUSH %s

; RUN: llc -global-isel -mtriple=amdgcn -mcpu=fiji -denormal-fp-math=ieee -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX89,GFX8,GFX8-IEEE %s
; RUN: llc -global-isel -mtriple=amdgcn -mcpu=fiji -denormal-fp-math=preserve-sign -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX89,GFX8,GFX8-FLUSH %s

; RUN: llc -global-isel -mtriple=amdgcn -mcpu=gfx900 -denormal-fp-math=ieee -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX89,GFX9,GFX9-IEEE %s
; RUN: llc -global-isel -mtriple=amdgcn -mcpu=gfx900 -denormal-fp-math=preserve-sign -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX89,GFX9,GFX9-FLUSH %s

; RUN: llc -global-isel -mtriple=amdgcn -mcpu=gfx1010 -denormal-fp-math=ieee -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX10PLUS,GFX10,GFX10-IEEE %s
; RUN: llc -global-isel -mtriple=amdgcn -mcpu=gfx1010 -denormal-fp-math=preserve-sign -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX10PLUS,GFX10,GFX10-FLUSH %s

; RUN: llc -global-isel -mtriple=amdgcn -mcpu=gfx1100 -amdgpu-enable-delay-alu=0 -denormal-fp-math=ieee -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX10PLUS,GFX11,GFX11-IEEE %s
; RUN: llc -global-isel -mtriple=amdgcn -mcpu=gfx1100 -amdgpu-enable-delay-alu=0 -denormal-fp-math=preserve-sign -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX10PLUS,GFX11,GFX11-FLUSH %s

define half @v_fdiv_f16(half %a, half %b) {
; GFX6-IEEE-LABEL: v_fdiv_f16:
; GFX6-IEEE:       ; %bb.0:
; GFX6-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX6-IEEE-NEXT:    v_div_scale_f32 v2, s[4:5], v1, v1, v0
; GFX6-IEEE-NEXT:    v_rcp_f32_e32 v3, v2
; GFX6-IEEE-NEXT:    v_div_scale_f32 v4, vcc, v0, v1, v0
; GFX6-IEEE-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX6-IEEE-NEXT:    v_fma_f32 v3, v5, v3, v3
; GFX6-IEEE-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX6-IEEE-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX6-IEEE-NEXT:    v_fma_f32 v5, v6, v3, v5
; GFX6-IEEE-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX6-IEEE-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX6-IEEE-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX6-IEEE-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-FLUSH-LABEL: v_fdiv_f16:
; GFX6-FLUSH:       ; %bb.0:
; GFX6-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v2, s[4:5], v1, v1, v0
; GFX6-FLUSH-NEXT:    v_rcp_f32_e32 v3, v2
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v4, vcc, v0, v1, v0
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-FLUSH-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX6-FLUSH-NEXT:    v_fma_f32 v3, v5, v3, v3
; GFX6-FLUSH-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX6-FLUSH-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX6-FLUSH-NEXT:    v_fma_f32 v5, v6, v3, v5
; GFX6-FLUSH-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX6-FLUSH-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX6-FLUSH-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 2, 2), 0
; GFX6-FLUSH-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-FLUSH-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-IEEE-LABEL: v_fdiv_f16:
; GFX8-IEEE:       ; %bb.0:
; GFX8-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-IEEE-NEXT:    v_cvt_f32_f16_e32 v2, v1
; GFX8-IEEE-NEXT:    v_cvt_f32_f16_e32 v3, v0
; GFX8-IEEE-NEXT:    v_rcp_f32_e32 v4, v2
; GFX8-IEEE-NEXT:    v_mul_f32_e32 v5, v3, v4
; GFX8-IEEE-NEXT:    v_mul_f32_e64 v6, -v2, v5
; GFX8-IEEE-NEXT:    v_add_f32_e32 v6, v6, v3
; GFX8-IEEE-NEXT:    v_mul_f32_e32 v6, v6, v4
; GFX8-IEEE-NEXT:    v_add_f32_e32 v5, v6, v5
; GFX8-IEEE-NEXT:    v_mul_f32_e64 v2, -v2, v5
; GFX8-IEEE-NEXT:    v_add_f32_e32 v2, v2, v3
; GFX8-IEEE-NEXT:    v_mul_f32_e32 v2, v2, v4
; GFX8-IEEE-NEXT:    v_and_b32_e32 v2, 0xff800000, v2
; GFX8-IEEE-NEXT:    v_add_f32_e32 v2, v2, v5
; GFX8-IEEE-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX8-IEEE-NEXT:    v_div_fixup_f16 v0, v2, v1, v0
; GFX8-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-FLUSH-LABEL: v_fdiv_f16:
; GFX8-FLUSH:       ; %bb.0:
; GFX8-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-FLUSH-NEXT:    v_cvt_f32_f16_e32 v2, v1
; GFX8-FLUSH-NEXT:    v_cvt_f32_f16_e32 v3, v0
; GFX8-FLUSH-NEXT:    v_rcp_f32_e32 v4, v2
; GFX8-FLUSH-NEXT:    v_mul_f32_e32 v5, v3, v4
; GFX8-FLUSH-NEXT:    v_mad_f32 v6, -v2, v5, v3
; GFX8-FLUSH-NEXT:    v_mac_f32_e32 v5, v6, v4
; GFX8-FLUSH-NEXT:    v_mad_f32 v2, -v2, v5, v3
; GFX8-FLUSH-NEXT:    v_mul_f32_e32 v2, v2, v4
; GFX8-FLUSH-NEXT:    v_and_b32_e32 v2, 0xff800000, v2
; GFX8-FLUSH-NEXT:    v_add_f32_e32 v2, v2, v5
; GFX8-FLUSH-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX8-FLUSH-NEXT:    v_div_fixup_f16 v0, v2, v1, v0
; GFX8-FLUSH-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-IEEE-LABEL: v_fdiv_f16:
; GFX9-IEEE:       ; %bb.0:
; GFX9-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-IEEE-NEXT:    v_cvt_f32_f16_e32 v2, v1
; GFX9-IEEE-NEXT:    v_cvt_f32_f16_e32 v3, v0
; GFX9-IEEE-NEXT:    v_rcp_f32_e32 v4, v2
; GFX9-IEEE-NEXT:    v_mul_f32_e32 v5, v3, v4
; GFX9-IEEE-NEXT:    v_mul_f32_e64 v6, -v2, v5
; GFX9-IEEE-NEXT:    v_add_f32_e32 v6, v6, v3
; GFX9-IEEE-NEXT:    v_mul_f32_e32 v6, v6, v4
; GFX9-IEEE-NEXT:    v_add_f32_e32 v5, v6, v5
; GFX9-IEEE-NEXT:    v_mul_f32_e64 v2, -v2, v5
; GFX9-IEEE-NEXT:    v_add_f32_e32 v2, v2, v3
; GFX9-IEEE-NEXT:    v_mul_f32_e32 v2, v2, v4
; GFX9-IEEE-NEXT:    v_and_b32_e32 v2, 0xff800000, v2
; GFX9-IEEE-NEXT:    v_add_f32_e32 v2, v2, v5
; GFX9-IEEE-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX9-IEEE-NEXT:    v_div_fixup_f16 v0, v2, v1, v0
; GFX9-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-FLUSH-LABEL: v_fdiv_f16:
; GFX9-FLUSH:       ; %bb.0:
; GFX9-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-FLUSH-NEXT:    v_cvt_f32_f16_e32 v2, v1
; GFX9-FLUSH-NEXT:    v_cvt_f32_f16_e32 v3, v0
; GFX9-FLUSH-NEXT:    v_rcp_f32_e32 v2, v2
; GFX9-FLUSH-NEXT:    v_mul_f32_e32 v3, v3, v2
; GFX9-FLUSH-NEXT:    v_mad_mix_f32 v4, -v1, v3, v0 op_sel_hi:[1,0,1]
; GFX9-FLUSH-NEXT:    v_mac_f32_e32 v3, v4, v2
; GFX9-FLUSH-NEXT:    v_mad_mix_f32 v4, -v1, v3, v0 op_sel_hi:[1,0,1]
; GFX9-FLUSH-NEXT:    v_mul_f32_e32 v2, v4, v2
; GFX9-FLUSH-NEXT:    v_and_b32_e32 v2, 0xff800000, v2
; GFX9-FLUSH-NEXT:    v_add_f32_e32 v2, v2, v3
; GFX9-FLUSH-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX9-FLUSH-NEXT:    v_div_fixup_f16 v0, v2, v1, v0
; GFX9-FLUSH-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-IEEE-LABEL: v_fdiv_f16:
; GFX10-IEEE:       ; %bb.0:
; GFX10-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-IEEE-NEXT:    v_cvt_f32_f16_e32 v2, v1
; GFX10-IEEE-NEXT:    v_cvt_f32_f16_e32 v4, v0
; GFX10-IEEE-NEXT:    v_rcp_f32_e32 v3, v2
; GFX10-IEEE-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX10-IEEE-NEXT:    v_mul_f32_e64 v6, -v2, v5
; GFX10-IEEE-NEXT:    v_add_f32_e32 v6, v6, v4
; GFX10-IEEE-NEXT:    v_mul_f32_e32 v6, v6, v3
; GFX10-IEEE-NEXT:    v_add_f32_e32 v5, v6, v5
; GFX10-IEEE-NEXT:    v_mul_f32_e64 v2, -v2, v5
; GFX10-IEEE-NEXT:    v_add_f32_e32 v2, v2, v4
; GFX10-IEEE-NEXT:    v_mul_f32_e32 v2, v2, v3
; GFX10-IEEE-NEXT:    v_and_b32_e32 v2, 0xff800000, v2
; GFX10-IEEE-NEXT:    v_add_f32_e32 v2, v2, v5
; GFX10-IEEE-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX10-IEEE-NEXT:    v_div_fixup_f16 v0, v2, v1, v0
; GFX10-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-FLUSH-LABEL: v_fdiv_f16:
; GFX10-FLUSH:       ; %bb.0:
; GFX10-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-FLUSH-NEXT:    v_cvt_f32_f16_e32 v2, v1
; GFX10-FLUSH-NEXT:    v_cvt_f32_f16_e32 v4, v0
; GFX10-FLUSH-NEXT:    v_rcp_f32_e32 v3, v2
; GFX10-FLUSH-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX10-FLUSH-NEXT:    v_mad_f32 v6, -v2, v5, v4
; GFX10-FLUSH-NEXT:    v_mac_f32_e32 v5, v6, v3
; GFX10-FLUSH-NEXT:    v_mad_f32 v2, -v2, v5, v4
; GFX10-FLUSH-NEXT:    v_mul_f32_e32 v2, v2, v3
; GFX10-FLUSH-NEXT:    v_and_b32_e32 v2, 0xff800000, v2
; GFX10-FLUSH-NEXT:    v_add_f32_e32 v2, v2, v5
; GFX10-FLUSH-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX10-FLUSH-NEXT:    v_div_fixup_f16 v0, v2, v1, v0
; GFX10-FLUSH-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fdiv_f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_cvt_f32_f16_e32 v2, v1
; GFX11-NEXT:    v_cvt_f32_f16_e32 v3, v0
; GFX11-NEXT:    v_rcp_f32_e32 v2, v2
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_mul_f32_e32 v3, v3, v2
; GFX11-NEXT:    v_fma_mix_f32 v4, -v1, v3, v0 op_sel_hi:[1,0,1]
; GFX11-NEXT:    v_fmac_f32_e32 v3, v4, v2
; GFX11-NEXT:    v_fma_mix_f32 v4, -v1, v3, v0 op_sel_hi:[1,0,1]
; GFX11-NEXT:    v_mul_f32_e32 v2, v4, v2
; GFX11-NEXT:    v_and_b32_e32 v2, 0xff800000, v2
; GFX11-NEXT:    v_add_f32_e32 v2, v2, v3
; GFX11-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX11-NEXT:    v_div_fixup_f16 v0, v2, v1, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %fdiv = fdiv half %a, %b
  ret half %fdiv
}

define half @v_fdiv_f16_afn(half %a, half %b) {
; GFX6-LABEL: v_fdiv_f16_afn:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX6-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-NEXT:    v_rcp_f32_e32 v1, v1
; GFX6-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX6-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX89-LABEL: v_fdiv_f16_afn:
; GFX89:       ; %bb.0:
; GFX89-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX89-NEXT:    v_rcp_f16_e32 v1, v1
; GFX89-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX89-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_fdiv_f16_afn:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_rcp_f16_e32 v1, v1
; GFX10-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fdiv_f16_afn:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_rcp_f16_e32 v1, v1
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %fdiv = fdiv afn half %a, %b
  ret half %fdiv
}

define half @v_fdiv_f16_ulp25(half %a, half %b) {
; GFX6-IEEE-LABEL: v_fdiv_f16_ulp25:
; GFX6-IEEE:       ; %bb.0:
; GFX6-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX6-IEEE-NEXT:    v_div_scale_f32 v2, s[4:5], v1, v1, v0
; GFX6-IEEE-NEXT:    v_rcp_f32_e32 v3, v2
; GFX6-IEEE-NEXT:    v_div_scale_f32 v4, vcc, v0, v1, v0
; GFX6-IEEE-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX6-IEEE-NEXT:    v_fma_f32 v3, v5, v3, v3
; GFX6-IEEE-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX6-IEEE-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX6-IEEE-NEXT:    v_fma_f32 v5, v6, v3, v5
; GFX6-IEEE-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX6-IEEE-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX6-IEEE-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX6-IEEE-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-FLUSH-LABEL: v_fdiv_f16_ulp25:
; GFX6-FLUSH:       ; %bb.0:
; GFX6-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v2, s[4:5], v1, v1, v0
; GFX6-FLUSH-NEXT:    v_rcp_f32_e32 v3, v2
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v4, vcc, v0, v1, v0
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-FLUSH-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX6-FLUSH-NEXT:    v_fma_f32 v3, v5, v3, v3
; GFX6-FLUSH-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX6-FLUSH-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX6-FLUSH-NEXT:    v_fma_f32 v5, v6, v3, v5
; GFX6-FLUSH-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX6-FLUSH-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX6-FLUSH-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 2, 2), 0
; GFX6-FLUSH-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-FLUSH-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-IEEE-LABEL: v_fdiv_f16_ulp25:
; GFX8-IEEE:       ; %bb.0:
; GFX8-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-IEEE-NEXT:    v_cvt_f32_f16_e32 v2, v1
; GFX8-IEEE-NEXT:    v_cvt_f32_f16_e32 v3, v0
; GFX8-IEEE-NEXT:    v_rcp_f32_e32 v4, v2
; GFX8-IEEE-NEXT:    v_mul_f32_e32 v5, v3, v4
; GFX8-IEEE-NEXT:    v_mul_f32_e64 v6, -v2, v5
; GFX8-IEEE-NEXT:    v_add_f32_e32 v6, v6, v3
; GFX8-IEEE-NEXT:    v_mul_f32_e32 v6, v6, v4
; GFX8-IEEE-NEXT:    v_add_f32_e32 v5, v6, v5
; GFX8-IEEE-NEXT:    v_mul_f32_e64 v2, -v2, v5
; GFX8-IEEE-NEXT:    v_add_f32_e32 v2, v2, v3
; GFX8-IEEE-NEXT:    v_mul_f32_e32 v2, v2, v4
; GFX8-IEEE-NEXT:    v_and_b32_e32 v2, 0xff800000, v2
; GFX8-IEEE-NEXT:    v_add_f32_e32 v2, v2, v5
; GFX8-IEEE-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX8-IEEE-NEXT:    v_div_fixup_f16 v0, v2, v1, v0
; GFX8-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-FLUSH-LABEL: v_fdiv_f16_ulp25:
; GFX8-FLUSH:       ; %bb.0:
; GFX8-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-FLUSH-NEXT:    v_cvt_f32_f16_e32 v2, v1
; GFX8-FLUSH-NEXT:    v_cvt_f32_f16_e32 v3, v0
; GFX8-FLUSH-NEXT:    v_rcp_f32_e32 v4, v2
; GFX8-FLUSH-NEXT:    v_mul_f32_e32 v5, v3, v4
; GFX8-FLUSH-NEXT:    v_mad_f32 v6, -v2, v5, v3
; GFX8-FLUSH-NEXT:    v_mac_f32_e32 v5, v6, v4
; GFX8-FLUSH-NEXT:    v_mad_f32 v2, -v2, v5, v3
; GFX8-FLUSH-NEXT:    v_mul_f32_e32 v2, v2, v4
; GFX8-FLUSH-NEXT:    v_and_b32_e32 v2, 0xff800000, v2
; GFX8-FLUSH-NEXT:    v_add_f32_e32 v2, v2, v5
; GFX8-FLUSH-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX8-FLUSH-NEXT:    v_div_fixup_f16 v0, v2, v1, v0
; GFX8-FLUSH-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-IEEE-LABEL: v_fdiv_f16_ulp25:
; GFX9-IEEE:       ; %bb.0:
; GFX9-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-IEEE-NEXT:    v_cvt_f32_f16_e32 v2, v1
; GFX9-IEEE-NEXT:    v_cvt_f32_f16_e32 v3, v0
; GFX9-IEEE-NEXT:    v_rcp_f32_e32 v4, v2
; GFX9-IEEE-NEXT:    v_mul_f32_e32 v5, v3, v4
; GFX9-IEEE-NEXT:    v_mul_f32_e64 v6, -v2, v5
; GFX9-IEEE-NEXT:    v_add_f32_e32 v6, v6, v3
; GFX9-IEEE-NEXT:    v_mul_f32_e32 v6, v6, v4
; GFX9-IEEE-NEXT:    v_add_f32_e32 v5, v6, v5
; GFX9-IEEE-NEXT:    v_mul_f32_e64 v2, -v2, v5
; GFX9-IEEE-NEXT:    v_add_f32_e32 v2, v2, v3
; GFX9-IEEE-NEXT:    v_mul_f32_e32 v2, v2, v4
; GFX9-IEEE-NEXT:    v_and_b32_e32 v2, 0xff800000, v2
; GFX9-IEEE-NEXT:    v_add_f32_e32 v2, v2, v5
; GFX9-IEEE-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX9-IEEE-NEXT:    v_div_fixup_f16 v0, v2, v1, v0
; GFX9-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-FLUSH-LABEL: v_fdiv_f16_ulp25:
; GFX9-FLUSH:       ; %bb.0:
; GFX9-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-FLUSH-NEXT:    v_cvt_f32_f16_e32 v2, v1
; GFX9-FLUSH-NEXT:    v_cvt_f32_f16_e32 v3, v0
; GFX9-FLUSH-NEXT:    v_rcp_f32_e32 v2, v2
; GFX9-FLUSH-NEXT:    v_mul_f32_e32 v3, v3, v2
; GFX9-FLUSH-NEXT:    v_mad_mix_f32 v4, -v1, v3, v0 op_sel_hi:[1,0,1]
; GFX9-FLUSH-NEXT:    v_mac_f32_e32 v3, v4, v2
; GFX9-FLUSH-NEXT:    v_mad_mix_f32 v4, -v1, v3, v0 op_sel_hi:[1,0,1]
; GFX9-FLUSH-NEXT:    v_mul_f32_e32 v2, v4, v2
; GFX9-FLUSH-NEXT:    v_and_b32_e32 v2, 0xff800000, v2
; GFX9-FLUSH-NEXT:    v_add_f32_e32 v2, v2, v3
; GFX9-FLUSH-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX9-FLUSH-NEXT:    v_div_fixup_f16 v0, v2, v1, v0
; GFX9-FLUSH-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-IEEE-LABEL: v_fdiv_f16_ulp25:
; GFX10-IEEE:       ; %bb.0:
; GFX10-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-IEEE-NEXT:    v_cvt_f32_f16_e32 v2, v1
; GFX10-IEEE-NEXT:    v_cvt_f32_f16_e32 v4, v0
; GFX10-IEEE-NEXT:    v_rcp_f32_e32 v3, v2
; GFX10-IEEE-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX10-IEEE-NEXT:    v_mul_f32_e64 v6, -v2, v5
; GFX10-IEEE-NEXT:    v_add_f32_e32 v6, v6, v4
; GFX10-IEEE-NEXT:    v_mul_f32_e32 v6, v6, v3
; GFX10-IEEE-NEXT:    v_add_f32_e32 v5, v6, v5
; GFX10-IEEE-NEXT:    v_mul_f32_e64 v2, -v2, v5
; GFX10-IEEE-NEXT:    v_add_f32_e32 v2, v2, v4
; GFX10-IEEE-NEXT:    v_mul_f32_e32 v2, v2, v3
; GFX10-IEEE-NEXT:    v_and_b32_e32 v2, 0xff800000, v2
; GFX10-IEEE-NEXT:    v_add_f32_e32 v2, v2, v5
; GFX10-IEEE-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX10-IEEE-NEXT:    v_div_fixup_f16 v0, v2, v1, v0
; GFX10-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-FLUSH-LABEL: v_fdiv_f16_ulp25:
; GFX10-FLUSH:       ; %bb.0:
; GFX10-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-FLUSH-NEXT:    v_cvt_f32_f16_e32 v2, v1
; GFX10-FLUSH-NEXT:    v_cvt_f32_f16_e32 v4, v0
; GFX10-FLUSH-NEXT:    v_rcp_f32_e32 v3, v2
; GFX10-FLUSH-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX10-FLUSH-NEXT:    v_mad_f32 v6, -v2, v5, v4
; GFX10-FLUSH-NEXT:    v_mac_f32_e32 v5, v6, v3
; GFX10-FLUSH-NEXT:    v_mad_f32 v2, -v2, v5, v4
; GFX10-FLUSH-NEXT:    v_mul_f32_e32 v2, v2, v3
; GFX10-FLUSH-NEXT:    v_and_b32_e32 v2, 0xff800000, v2
; GFX10-FLUSH-NEXT:    v_add_f32_e32 v2, v2, v5
; GFX10-FLUSH-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX10-FLUSH-NEXT:    v_div_fixup_f16 v0, v2, v1, v0
; GFX10-FLUSH-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fdiv_f16_ulp25:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_cvt_f32_f16_e32 v2, v1
; GFX11-NEXT:    v_cvt_f32_f16_e32 v3, v0
; GFX11-NEXT:    v_rcp_f32_e32 v2, v2
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_mul_f32_e32 v3, v3, v2
; GFX11-NEXT:    v_fma_mix_f32 v4, -v1, v3, v0 op_sel_hi:[1,0,1]
; GFX11-NEXT:    v_fmac_f32_e32 v3, v4, v2
; GFX11-NEXT:    v_fma_mix_f32 v4, -v1, v3, v0 op_sel_hi:[1,0,1]
; GFX11-NEXT:    v_mul_f32_e32 v2, v4, v2
; GFX11-NEXT:    v_and_b32_e32 v2, 0xff800000, v2
; GFX11-NEXT:    v_add_f32_e32 v2, v2, v3
; GFX11-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX11-NEXT:    v_div_fixup_f16 v0, v2, v1, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %fdiv = fdiv half %a, %b
  ret half %fdiv
}

define half @v_neg_rcp_f16(half %x) {
; GFX6-IEEE-LABEL: v_neg_rcp_f16:
; GFX6-IEEE:       ; %bb.0:
; GFX6-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v1, -1.0
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-IEEE-NEXT:    v_div_scale_f32 v2, s[4:5], v0, v0, v1
; GFX6-IEEE-NEXT:    v_rcp_f32_e32 v3, v2
; GFX6-IEEE-NEXT:    v_div_scale_f32 v4, vcc, v1, v0, v1
; GFX6-IEEE-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX6-IEEE-NEXT:    v_fma_f32 v3, v5, v3, v3
; GFX6-IEEE-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX6-IEEE-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX6-IEEE-NEXT:    v_fma_f32 v5, v6, v3, v5
; GFX6-IEEE-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX6-IEEE-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX6-IEEE-NEXT:    v_div_fixup_f32 v0, v2, v0, v1
; GFX6-IEEE-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-FLUSH-LABEL: v_neg_rcp_f16:
; GFX6-FLUSH:       ; %bb.0:
; GFX6-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v1, -1.0
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v2, s[4:5], v0, v0, v1
; GFX6-FLUSH-NEXT:    v_rcp_f32_e32 v3, v2
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v4, vcc, v1, v0, v1
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-FLUSH-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX6-FLUSH-NEXT:    v_fma_f32 v3, v5, v3, v3
; GFX6-FLUSH-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX6-FLUSH-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX6-FLUSH-NEXT:    v_fma_f32 v5, v6, v3, v5
; GFX6-FLUSH-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX6-FLUSH-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX6-FLUSH-NEXT:    v_div_fixup_f32 v0, v2, v0, v1
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 2, 2), 0
; GFX6-FLUSH-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-FLUSH-NEXT:    s_setpc_b64 s[30:31]
;
; GFX89-LABEL: v_neg_rcp_f16:
; GFX89:       ; %bb.0:
; GFX89-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX89-NEXT:    v_rcp_f16_e64 v0, -v0
; GFX89-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10PLUS-LABEL: v_neg_rcp_f16:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10PLUS-NEXT:    v_rcp_f16_e64 v0, -v0
; GFX10PLUS-NEXT:    s_setpc_b64 s[30:31]
  %fdiv = fdiv half -1.0, %x
  ret half %fdiv
}

define half @v_rcp_f16(half %x) {
; GFX6-IEEE-LABEL: v_rcp_f16:
; GFX6-IEEE:       ; %bb.0:
; GFX6-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v1, 1.0
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-IEEE-NEXT:    v_div_scale_f32 v2, s[4:5], v0, v0, v1
; GFX6-IEEE-NEXT:    v_rcp_f32_e32 v3, v2
; GFX6-IEEE-NEXT:    v_div_scale_f32 v4, vcc, v1, v0, v1
; GFX6-IEEE-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX6-IEEE-NEXT:    v_fma_f32 v3, v5, v3, v3
; GFX6-IEEE-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX6-IEEE-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX6-IEEE-NEXT:    v_fma_f32 v5, v6, v3, v5
; GFX6-IEEE-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX6-IEEE-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX6-IEEE-NEXT:    v_div_fixup_f32 v0, v2, v0, v1
; GFX6-IEEE-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-FLUSH-LABEL: v_rcp_f16:
; GFX6-FLUSH:       ; %bb.0:
; GFX6-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v1, 1.0
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v2, s[4:5], v0, v0, v1
; GFX6-FLUSH-NEXT:    v_rcp_f32_e32 v3, v2
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v4, vcc, v1, v0, v1
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-FLUSH-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX6-FLUSH-NEXT:    v_fma_f32 v3, v5, v3, v3
; GFX6-FLUSH-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX6-FLUSH-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX6-FLUSH-NEXT:    v_fma_f32 v5, v6, v3, v5
; GFX6-FLUSH-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX6-FLUSH-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX6-FLUSH-NEXT:    v_div_fixup_f32 v0, v2, v0, v1
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 2, 2), 0
; GFX6-FLUSH-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-FLUSH-NEXT:    s_setpc_b64 s[30:31]
;
; GFX89-LABEL: v_rcp_f16:
; GFX89:       ; %bb.0:
; GFX89-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX89-NEXT:    v_rcp_f16_e32 v0, v0
; GFX89-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10PLUS-LABEL: v_rcp_f16:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10PLUS-NEXT:    v_rcp_f16_e32 v0, v0
; GFX10PLUS-NEXT:    s_setpc_b64 s[30:31]
  %fdiv = fdiv half 1.0, %x
  ret half %fdiv
}

define half @v_rcp_f16_arcp(half %x) {
; GFX6-IEEE-LABEL: v_rcp_f16_arcp:
; GFX6-IEEE:       ; %bb.0:
; GFX6-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v1, 1.0
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-IEEE-NEXT:    v_div_scale_f32 v2, s[4:5], v0, v0, v1
; GFX6-IEEE-NEXT:    v_rcp_f32_e32 v3, v2
; GFX6-IEEE-NEXT:    v_div_scale_f32 v4, vcc, v1, v0, v1
; GFX6-IEEE-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX6-IEEE-NEXT:    v_fma_f32 v3, v5, v3, v3
; GFX6-IEEE-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX6-IEEE-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX6-IEEE-NEXT:    v_fma_f32 v5, v6, v3, v5
; GFX6-IEEE-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX6-IEEE-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX6-IEEE-NEXT:    v_div_fixup_f32 v0, v2, v0, v1
; GFX6-IEEE-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-FLUSH-LABEL: v_rcp_f16_arcp:
; GFX6-FLUSH:       ; %bb.0:
; GFX6-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v1, 1.0
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v2, s[4:5], v0, v0, v1
; GFX6-FLUSH-NEXT:    v_rcp_f32_e32 v3, v2
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v4, vcc, v1, v0, v1
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-FLUSH-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX6-FLUSH-NEXT:    v_fma_f32 v3, v5, v3, v3
; GFX6-FLUSH-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX6-FLUSH-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX6-FLUSH-NEXT:    v_fma_f32 v5, v6, v3, v5
; GFX6-FLUSH-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX6-FLUSH-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX6-FLUSH-NEXT:    v_div_fixup_f32 v0, v2, v0, v1
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 2, 2), 0
; GFX6-FLUSH-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-FLUSH-NEXT:    s_setpc_b64 s[30:31]
;
; GFX89-LABEL: v_rcp_f16_arcp:
; GFX89:       ; %bb.0:
; GFX89-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX89-NEXT:    v_rcp_f16_e32 v0, v0
; GFX89-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10PLUS-LABEL: v_rcp_f16_arcp:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10PLUS-NEXT:    v_rcp_f16_e32 v0, v0
; GFX10PLUS-NEXT:    s_setpc_b64 s[30:31]
  %fdiv = fdiv arcp half 1.0, %x
  ret half %fdiv
}

define half @v_rcp_f16_arcp_afn(half %x) {
; GFX6-LABEL: v_rcp_f16_arcp_afn:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-NEXT:    v_cvt_f32_f16_e32 v1, 1.0
; GFX6-NEXT:    v_rcp_f32_e32 v0, v0
; GFX6-NEXT:    v_mul_f32_e32 v0, v1, v0
; GFX6-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX89-LABEL: v_rcp_f16_arcp_afn:
; GFX89:       ; %bb.0:
; GFX89-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX89-NEXT:    v_rcp_f16_e32 v0, v0
; GFX89-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10PLUS-LABEL: v_rcp_f16_arcp_afn:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10PLUS-NEXT:    v_rcp_f16_e32 v0, v0
; GFX10PLUS-NEXT:    s_setpc_b64 s[30:31]
  %fdiv = fdiv arcp afn half 1.0, %x
  ret half %fdiv
}

define half @v_rcp_f16_ulp25(half %x) {
; GFX6-IEEE-LABEL: v_rcp_f16_ulp25:
; GFX6-IEEE:       ; %bb.0:
; GFX6-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v1, 1.0
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-IEEE-NEXT:    v_div_scale_f32 v2, s[4:5], v0, v0, v1
; GFX6-IEEE-NEXT:    v_rcp_f32_e32 v3, v2
; GFX6-IEEE-NEXT:    v_div_scale_f32 v4, vcc, v1, v0, v1
; GFX6-IEEE-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX6-IEEE-NEXT:    v_fma_f32 v3, v5, v3, v3
; GFX6-IEEE-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX6-IEEE-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX6-IEEE-NEXT:    v_fma_f32 v5, v6, v3, v5
; GFX6-IEEE-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX6-IEEE-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX6-IEEE-NEXT:    v_div_fixup_f32 v0, v2, v0, v1
; GFX6-IEEE-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-FLUSH-LABEL: v_rcp_f16_ulp25:
; GFX6-FLUSH:       ; %bb.0:
; GFX6-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v1, 1.0
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v2, s[4:5], v0, v0, v1
; GFX6-FLUSH-NEXT:    v_rcp_f32_e32 v3, v2
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v4, vcc, v1, v0, v1
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-FLUSH-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX6-FLUSH-NEXT:    v_fma_f32 v3, v5, v3, v3
; GFX6-FLUSH-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX6-FLUSH-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX6-FLUSH-NEXT:    v_fma_f32 v5, v6, v3, v5
; GFX6-FLUSH-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX6-FLUSH-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX6-FLUSH-NEXT:    v_div_fixup_f32 v0, v2, v0, v1
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 2, 2), 0
; GFX6-FLUSH-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-FLUSH-NEXT:    s_setpc_b64 s[30:31]
;
; GFX89-LABEL: v_rcp_f16_ulp25:
; GFX89:       ; %bb.0:
; GFX89-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX89-NEXT:    v_rcp_f16_e32 v0, v0
; GFX89-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10PLUS-LABEL: v_rcp_f16_ulp25:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10PLUS-NEXT:    v_rcp_f16_e32 v0, v0
; GFX10PLUS-NEXT:    s_setpc_b64 s[30:31]
  %fdiv = fdiv half 1.0, %x
  ret half %fdiv
}

define half @v_fdiv_f16_afn_ulp25(half %a, half %b) {
; GFX6-LABEL: v_fdiv_f16_afn_ulp25:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX6-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-NEXT:    v_rcp_f32_e32 v1, v1
; GFX6-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX6-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX89-LABEL: v_fdiv_f16_afn_ulp25:
; GFX89:       ; %bb.0:
; GFX89-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX89-NEXT:    v_rcp_f16_e32 v1, v1
; GFX89-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX89-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_fdiv_f16_afn_ulp25:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_rcp_f16_e32 v1, v1
; GFX10-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fdiv_f16_afn_ulp25:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_rcp_f16_e32 v1, v1
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %fdiv = fdiv afn half %a, %b
  ret half %fdiv
}

define half @v_fdiv_f16_arcp_ulp25(half %a, half %b) {
; GFX6-IEEE-LABEL: v_fdiv_f16_arcp_ulp25:
; GFX6-IEEE:       ; %bb.0:
; GFX6-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX6-IEEE-NEXT:    v_div_scale_f32 v2, s[4:5], v1, v1, v0
; GFX6-IEEE-NEXT:    v_rcp_f32_e32 v3, v2
; GFX6-IEEE-NEXT:    v_div_scale_f32 v4, vcc, v0, v1, v0
; GFX6-IEEE-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX6-IEEE-NEXT:    v_fma_f32 v3, v5, v3, v3
; GFX6-IEEE-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX6-IEEE-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX6-IEEE-NEXT:    v_fma_f32 v5, v6, v3, v5
; GFX6-IEEE-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX6-IEEE-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX6-IEEE-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX6-IEEE-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-FLUSH-LABEL: v_fdiv_f16_arcp_ulp25:
; GFX6-FLUSH:       ; %bb.0:
; GFX6-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v2, s[4:5], v1, v1, v0
; GFX6-FLUSH-NEXT:    v_rcp_f32_e32 v3, v2
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v4, vcc, v0, v1, v0
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-FLUSH-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX6-FLUSH-NEXT:    v_fma_f32 v3, v5, v3, v3
; GFX6-FLUSH-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX6-FLUSH-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX6-FLUSH-NEXT:    v_fma_f32 v5, v6, v3, v5
; GFX6-FLUSH-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX6-FLUSH-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX6-FLUSH-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 2, 2), 0
; GFX6-FLUSH-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-FLUSH-NEXT:    s_setpc_b64 s[30:31]
;
; GFX89-LABEL: v_fdiv_f16_arcp_ulp25:
; GFX89:       ; %bb.0:
; GFX89-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX89-NEXT:    v_rcp_f16_e32 v1, v1
; GFX89-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX89-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_fdiv_f16_arcp_ulp25:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_rcp_f16_e32 v1, v1
; GFX10-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fdiv_f16_arcp_ulp25:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_rcp_f16_e32 v1, v1
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %fdiv = fdiv arcp half %a, %b
  ret half %fdiv
}

define <2 x half> @v_fdiv_v2f16(<2 x half> %a, <2 x half> %b) {
; GFX6-IEEE-LABEL: v_fdiv_v2f16:
; GFX6-IEEE:       ; %bb.0:
; GFX6-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GFX6-IEEE-NEXT:    v_div_scale_f32 v4, s[4:5], v2, v2, v0
; GFX6-IEEE-NEXT:    v_rcp_f32_e32 v5, v4
; GFX6-IEEE-NEXT:    v_div_scale_f32 v6, vcc, v0, v2, v0
; GFX6-IEEE-NEXT:    v_fma_f32 v7, -v4, v5, 1.0
; GFX6-IEEE-NEXT:    v_fma_f32 v5, v7, v5, v5
; GFX6-IEEE-NEXT:    v_mul_f32_e32 v7, v6, v5
; GFX6-IEEE-NEXT:    v_fma_f32 v8, -v4, v7, v6
; GFX6-IEEE-NEXT:    v_fma_f32 v7, v8, v5, v7
; GFX6-IEEE-NEXT:    v_fma_f32 v4, -v4, v7, v6
; GFX6-IEEE-NEXT:    v_div_fmas_f32 v4, v4, v5, v7
; GFX6-IEEE-NEXT:    v_div_fixup_f32 v0, v4, v2, v0
; GFX6-IEEE-NEXT:    v_div_scale_f32 v2, s[4:5], v3, v3, v1
; GFX6-IEEE-NEXT:    v_rcp_f32_e32 v4, v2
; GFX6-IEEE-NEXT:    v_div_scale_f32 v5, vcc, v1, v3, v1
; GFX6-IEEE-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-IEEE-NEXT:    v_fma_f32 v6, -v2, v4, 1.0
; GFX6-IEEE-NEXT:    v_fma_f32 v4, v6, v4, v4
; GFX6-IEEE-NEXT:    v_mul_f32_e32 v6, v5, v4
; GFX6-IEEE-NEXT:    v_fma_f32 v7, -v2, v6, v5
; GFX6-IEEE-NEXT:    v_fma_f32 v6, v7, v4, v6
; GFX6-IEEE-NEXT:    v_fma_f32 v2, -v2, v6, v5
; GFX6-IEEE-NEXT:    v_div_fmas_f32 v2, v2, v4, v6
; GFX6-IEEE-NEXT:    v_div_fixup_f32 v1, v2, v3, v1
; GFX6-IEEE-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX6-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-FLUSH-LABEL: v_fdiv_v2f16:
; GFX6-FLUSH:       ; %bb.0:
; GFX6-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v4, s[4:5], v2, v2, v0
; GFX6-FLUSH-NEXT:    v_rcp_f32_e32 v5, v4
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v6, vcc, v0, v2, v0
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-FLUSH-NEXT:    v_fma_f32 v7, -v4, v5, 1.0
; GFX6-FLUSH-NEXT:    v_fma_f32 v5, v7, v5, v5
; GFX6-FLUSH-NEXT:    v_mul_f32_e32 v7, v6, v5
; GFX6-FLUSH-NEXT:    v_fma_f32 v8, -v4, v7, v6
; GFX6-FLUSH-NEXT:    v_fma_f32 v7, v8, v5, v7
; GFX6-FLUSH-NEXT:    v_fma_f32 v4, -v4, v7, v6
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GFX6-FLUSH-NEXT:    v_div_fmas_f32 v4, v4, v5, v7
; GFX6-FLUSH-NEXT:    v_div_fixup_f32 v0, v4, v2, v0
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 2, 2), 0
; GFX6-FLUSH-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v2, s[4:5], v3, v3, v1
; GFX6-FLUSH-NEXT:    v_rcp_f32_e32 v4, v2
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v5, vcc, v1, v3, v1
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-FLUSH-NEXT:    v_fma_f32 v6, -v2, v4, 1.0
; GFX6-FLUSH-NEXT:    v_fma_f32 v4, v6, v4, v4
; GFX6-FLUSH-NEXT:    v_mul_f32_e32 v6, v5, v4
; GFX6-FLUSH-NEXT:    v_fma_f32 v7, -v2, v6, v5
; GFX6-FLUSH-NEXT:    v_fma_f32 v6, v7, v4, v6
; GFX6-FLUSH-NEXT:    v_fma_f32 v2, -v2, v6, v5
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX6-FLUSH-NEXT:    v_div_fmas_f32 v2, v2, v4, v6
; GFX6-FLUSH-NEXT:    v_div_fixup_f32 v1, v2, v3, v1
; GFX6-FLUSH-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX6-FLUSH-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-IEEE-LABEL: v_fdiv_v2f16:
; GFX8-IEEE:       ; %bb.0:
; GFX8-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-IEEE-NEXT:    v_cvt_f32_f16_e32 v2, v1
; GFX8-IEEE-NEXT:    v_cvt_f32_f16_e32 v4, v0
; GFX8-IEEE-NEXT:    v_lshrrev_b32_e32 v6, 16, v1
; GFX8-IEEE-NEXT:    v_cvt_f32_f16_e32 v8, v6
; GFX8-IEEE-NEXT:    v_rcp_f32_e32 v5, v2
; GFX8-IEEE-NEXT:    v_lshrrev_b32_e32 v3, 16, v0
; GFX8-IEEE-NEXT:    v_cvt_f32_f16_e32 v7, v3
; GFX8-IEEE-NEXT:    v_mul_f32_e32 v9, v4, v5
; GFX8-IEEE-NEXT:    v_mul_f32_e64 v10, -v2, v9
; GFX8-IEEE-NEXT:    v_add_f32_e32 v10, v10, v4
; GFX8-IEEE-NEXT:    v_mul_f32_e32 v10, v10, v5
; GFX8-IEEE-NEXT:    v_add_f32_e32 v9, v10, v9
; GFX8-IEEE-NEXT:    v_mul_f32_e64 v2, -v2, v9
; GFX8-IEEE-NEXT:    v_add_f32_e32 v2, v2, v4
; GFX8-IEEE-NEXT:    v_rcp_f32_e32 v4, v8
; GFX8-IEEE-NEXT:    v_mul_f32_e32 v2, v2, v5
; GFX8-IEEE-NEXT:    v_and_b32_e32 v2, 0xff800000, v2
; GFX8-IEEE-NEXT:    v_add_f32_e32 v2, v2, v9
; GFX8-IEEE-NEXT:    v_mul_f32_e32 v5, v7, v4
; GFX8-IEEE-NEXT:    v_mul_f32_e64 v9, -v8, v5
; GFX8-IEEE-NEXT:    v_add_f32_e32 v9, v9, v7
; GFX8-IEEE-NEXT:    v_mul_f32_e32 v9, v9, v4
; GFX8-IEEE-NEXT:    v_add_f32_e32 v5, v9, v5
; GFX8-IEEE-NEXT:    v_mul_f32_e64 v8, -v8, v5
; GFX8-IEEE-NEXT:    v_add_f32_e32 v7, v8, v7
; GFX8-IEEE-NEXT:    v_mul_f32_e32 v4, v7, v4
; GFX8-IEEE-NEXT:    v_and_b32_e32 v4, 0xff800000, v4
; GFX8-IEEE-NEXT:    v_add_f32_e32 v4, v4, v5
; GFX8-IEEE-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX8-IEEE-NEXT:    v_cvt_f16_f32_e32 v4, v4
; GFX8-IEEE-NEXT:    v_div_fixup_f16 v0, v2, v1, v0
; GFX8-IEEE-NEXT:    v_div_fixup_f16 v1, v4, v6, v3
; GFX8-IEEE-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX8-IEEE-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX8-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-FLUSH-LABEL: v_fdiv_v2f16:
; GFX8-FLUSH:       ; %bb.0:
; GFX8-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-FLUSH-NEXT:    v_cvt_f32_f16_e32 v2, v1
; GFX8-FLUSH-NEXT:    v_cvt_f32_f16_e32 v4, v0
; GFX8-FLUSH-NEXT:    v_lshrrev_b32_e32 v6, 16, v1
; GFX8-FLUSH-NEXT:    v_cvt_f32_f16_e32 v8, v6
; GFX8-FLUSH-NEXT:    v_rcp_f32_e32 v5, v2
; GFX8-FLUSH-NEXT:    v_lshrrev_b32_e32 v3, 16, v0
; GFX8-FLUSH-NEXT:    v_cvt_f32_f16_e32 v7, v3
; GFX8-FLUSH-NEXT:    v_mul_f32_e32 v9, v4, v5
; GFX8-FLUSH-NEXT:    v_mad_f32 v10, -v2, v9, v4
; GFX8-FLUSH-NEXT:    v_mac_f32_e32 v9, v10, v5
; GFX8-FLUSH-NEXT:    v_mad_f32 v2, -v2, v9, v4
; GFX8-FLUSH-NEXT:    v_rcp_f32_e32 v4, v8
; GFX8-FLUSH-NEXT:    v_mul_f32_e32 v2, v2, v5
; GFX8-FLUSH-NEXT:    v_and_b32_e32 v2, 0xff800000, v2
; GFX8-FLUSH-NEXT:    v_add_f32_e32 v2, v2, v9
; GFX8-FLUSH-NEXT:    v_mul_f32_e32 v5, v7, v4
; GFX8-FLUSH-NEXT:    v_mad_f32 v9, -v8, v5, v7
; GFX8-FLUSH-NEXT:    v_mac_f32_e32 v5, v9, v4
; GFX8-FLUSH-NEXT:    v_mad_f32 v7, -v8, v5, v7
; GFX8-FLUSH-NEXT:    v_mul_f32_e32 v4, v7, v4
; GFX8-FLUSH-NEXT:    v_and_b32_e32 v4, 0xff800000, v4
; GFX8-FLUSH-NEXT:    v_add_f32_e32 v4, v4, v5
; GFX8-FLUSH-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX8-FLUSH-NEXT:    v_cvt_f16_f32_e32 v4, v4
; GFX8-FLUSH-NEXT:    v_div_fixup_f16 v0, v2, v1, v0
; GFX8-FLUSH-NEXT:    v_div_fixup_f16 v1, v4, v6, v3
; GFX8-FLUSH-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX8-FLUSH-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX8-FLUSH-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-IEEE-LABEL: v_fdiv_v2f16:
; GFX9-IEEE:       ; %bb.0:
; GFX9-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-IEEE-NEXT:    v_cvt_f32_f16_e32 v2, v1
; GFX9-IEEE-NEXT:    v_cvt_f32_f16_e32 v4, v0
; GFX9-IEEE-NEXT:    v_lshrrev_b32_e32 v6, 16, v1
; GFX9-IEEE-NEXT:    v_cvt_f32_f16_e32 v8, v6
; GFX9-IEEE-NEXT:    v_rcp_f32_e32 v5, v2
; GFX9-IEEE-NEXT:    v_lshrrev_b32_e32 v3, 16, v0
; GFX9-IEEE-NEXT:    v_cvt_f32_f16_e32 v7, v3
; GFX9-IEEE-NEXT:    v_mul_f32_e32 v9, v4, v5
; GFX9-IEEE-NEXT:    v_mul_f32_e64 v10, -v2, v9
; GFX9-IEEE-NEXT:    v_add_f32_e32 v10, v10, v4
; GFX9-IEEE-NEXT:    v_mul_f32_e32 v10, v10, v5
; GFX9-IEEE-NEXT:    v_add_f32_e32 v9, v10, v9
; GFX9-IEEE-NEXT:    v_mul_f32_e64 v2, -v2, v9
; GFX9-IEEE-NEXT:    v_add_f32_e32 v2, v2, v4
; GFX9-IEEE-NEXT:    v_rcp_f32_e32 v4, v8
; GFX9-IEEE-NEXT:    v_mul_f32_e32 v2, v2, v5
; GFX9-IEEE-NEXT:    v_and_b32_e32 v2, 0xff800000, v2
; GFX9-IEEE-NEXT:    v_add_f32_e32 v2, v2, v9
; GFX9-IEEE-NEXT:    v_mul_f32_e32 v5, v7, v4
; GFX9-IEEE-NEXT:    v_mul_f32_e64 v9, -v8, v5
; GFX9-IEEE-NEXT:    v_add_f32_e32 v9, v9, v7
; GFX9-IEEE-NEXT:    v_mul_f32_e32 v9, v9, v4
; GFX9-IEEE-NEXT:    v_add_f32_e32 v5, v9, v5
; GFX9-IEEE-NEXT:    v_mul_f32_e64 v8, -v8, v5
; GFX9-IEEE-NEXT:    v_add_f32_e32 v7, v8, v7
; GFX9-IEEE-NEXT:    v_mul_f32_e32 v4, v7, v4
; GFX9-IEEE-NEXT:    v_and_b32_e32 v4, 0xff800000, v4
; GFX9-IEEE-NEXT:    v_add_f32_e32 v4, v4, v5
; GFX9-IEEE-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX9-IEEE-NEXT:    v_cvt_f16_f32_e32 v4, v4
; GFX9-IEEE-NEXT:    v_div_fixup_f16 v0, v2, v1, v0
; GFX9-IEEE-NEXT:    v_div_fixup_f16 v1, v4, v6, v3
; GFX9-IEEE-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX9-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-FLUSH-LABEL: v_fdiv_v2f16:
; GFX9-FLUSH:       ; %bb.0:
; GFX9-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-FLUSH-NEXT:    v_cvt_f32_f16_e32 v2, v1
; GFX9-FLUSH-NEXT:    v_cvt_f32_f16_e32 v4, v0
; GFX9-FLUSH-NEXT:    v_lshrrev_b32_e32 v5, 16, v1
; GFX9-FLUSH-NEXT:    v_cvt_f32_f16_e32 v7, v5
; GFX9-FLUSH-NEXT:    v_rcp_f32_e32 v2, v2
; GFX9-FLUSH-NEXT:    v_lshrrev_b32_e32 v3, 16, v0
; GFX9-FLUSH-NEXT:    v_cvt_f32_f16_e32 v6, v3
; GFX9-FLUSH-NEXT:    v_rcp_f32_e32 v7, v7
; GFX9-FLUSH-NEXT:    v_mul_f32_e32 v4, v4, v2
; GFX9-FLUSH-NEXT:    v_mad_mix_f32 v8, -v1, v4, v0 op_sel_hi:[1,0,1]
; GFX9-FLUSH-NEXT:    v_mac_f32_e32 v4, v8, v2
; GFX9-FLUSH-NEXT:    v_mad_mix_f32 v8, -v1, v4, v0 op_sel_hi:[1,0,1]
; GFX9-FLUSH-NEXT:    v_mul_f32_e32 v2, v8, v2
; GFX9-FLUSH-NEXT:    v_and_b32_e32 v2, 0xff800000, v2
; GFX9-FLUSH-NEXT:    v_add_f32_e32 v2, v2, v4
; GFX9-FLUSH-NEXT:    v_mul_f32_e32 v4, v6, v7
; GFX9-FLUSH-NEXT:    v_mad_mix_f32 v6, -v1, v4, v0 op_sel:[1,0,1] op_sel_hi:[1,0,1]
; GFX9-FLUSH-NEXT:    v_mac_f32_e32 v4, v6, v7
; GFX9-FLUSH-NEXT:    v_mad_mix_f32 v6, -v1, v4, v0 op_sel:[1,0,1] op_sel_hi:[1,0,1]
; GFX9-FLUSH-NEXT:    v_mul_f32_e32 v6, v6, v7
; GFX9-FLUSH-NEXT:    v_and_b32_e32 v6, 0xff800000, v6
; GFX9-FLUSH-NEXT:    v_add_f32_e32 v4, v6, v4
; GFX9-FLUSH-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX9-FLUSH-NEXT:    v_cvt_f16_f32_e32 v4, v4
; GFX9-FLUSH-NEXT:    v_div_fixup_f16 v0, v2, v1, v0
; GFX9-FLUSH-NEXT:    v_div_fixup_f16 v1, v4, v5, v3
; GFX9-FLUSH-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX9-FLUSH-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-IEEE-LABEL: v_fdiv_v2f16:
; GFX10-IEEE:       ; %bb.0:
; GFX10-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-IEEE-NEXT:    v_lshrrev_b32_e32 v2, 16, v1
; GFX10-IEEE-NEXT:    v_cvt_f32_f16_e32 v3, v1
; GFX10-IEEE-NEXT:    v_lshrrev_b32_e32 v5, 16, v0
; GFX10-IEEE-NEXT:    v_cvt_f32_f16_e32 v8, v0
; GFX10-IEEE-NEXT:    v_cvt_f32_f16_e32 v4, v2
; GFX10-IEEE-NEXT:    v_rcp_f32_e32 v6, v3
; GFX10-IEEE-NEXT:    v_cvt_f32_f16_e32 v9, v5
; GFX10-IEEE-NEXT:    v_rcp_f32_e32 v7, v4
; GFX10-IEEE-NEXT:    v_mul_f32_e32 v10, v8, v6
; GFX10-IEEE-NEXT:    v_mul_f32_e32 v11, v9, v7
; GFX10-IEEE-NEXT:    v_mul_f32_e64 v12, -v3, v10
; GFX10-IEEE-NEXT:    v_mul_f32_e64 v13, -v4, v11
; GFX10-IEEE-NEXT:    v_add_f32_e32 v12, v12, v8
; GFX10-IEEE-NEXT:    v_add_f32_e32 v13, v13, v9
; GFX10-IEEE-NEXT:    v_mul_f32_e32 v12, v12, v6
; GFX10-IEEE-NEXT:    v_mul_f32_e32 v13, v13, v7
; GFX10-IEEE-NEXT:    v_add_f32_e32 v10, v12, v10
; GFX10-IEEE-NEXT:    v_add_f32_e32 v11, v13, v11
; GFX10-IEEE-NEXT:    v_mul_f32_e64 v3, -v3, v10
; GFX10-IEEE-NEXT:    v_mul_f32_e64 v4, -v4, v11
; GFX10-IEEE-NEXT:    v_add_f32_e32 v3, v3, v8
; GFX10-IEEE-NEXT:    v_add_f32_e32 v4, v4, v9
; GFX10-IEEE-NEXT:    v_mul_f32_e32 v3, v3, v6
; GFX10-IEEE-NEXT:    v_mul_f32_e32 v4, v4, v7
; GFX10-IEEE-NEXT:    v_and_b32_e32 v3, 0xff800000, v3
; GFX10-IEEE-NEXT:    v_and_b32_e32 v4, 0xff800000, v4
; GFX10-IEEE-NEXT:    v_add_f32_e32 v3, v3, v10
; GFX10-IEEE-NEXT:    v_add_f32_e32 v4, v4, v11
; GFX10-IEEE-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX10-IEEE-NEXT:    v_cvt_f16_f32_e32 v4, v4
; GFX10-IEEE-NEXT:    v_div_fixup_f16 v0, v3, v1, v0
; GFX10-IEEE-NEXT:    v_div_fixup_f16 v1, v4, v2, v5
; GFX10-IEEE-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX10-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-FLUSH-LABEL: v_fdiv_v2f16:
; GFX10-FLUSH:       ; %bb.0:
; GFX10-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-FLUSH-NEXT:    v_lshrrev_b32_e32 v2, 16, v1
; GFX10-FLUSH-NEXT:    v_cvt_f32_f16_e32 v3, v1
; GFX10-FLUSH-NEXT:    v_lshrrev_b32_e32 v5, 16, v0
; GFX10-FLUSH-NEXT:    v_cvt_f32_f16_e32 v8, v0
; GFX10-FLUSH-NEXT:    v_cvt_f32_f16_e32 v4, v2
; GFX10-FLUSH-NEXT:    v_rcp_f32_e32 v6, v3
; GFX10-FLUSH-NEXT:    v_cvt_f32_f16_e32 v9, v5
; GFX10-FLUSH-NEXT:    v_rcp_f32_e32 v7, v4
; GFX10-FLUSH-NEXT:    v_mul_f32_e32 v10, v8, v6
; GFX10-FLUSH-NEXT:    v_mul_f32_e32 v11, v9, v7
; GFX10-FLUSH-NEXT:    v_mad_f32 v12, -v3, v10, v8
; GFX10-FLUSH-NEXT:    v_mad_f32 v13, -v4, v11, v9
; GFX10-FLUSH-NEXT:    v_mac_f32_e32 v10, v12, v6
; GFX10-FLUSH-NEXT:    v_mac_f32_e32 v11, v13, v7
; GFX10-FLUSH-NEXT:    v_mad_f32 v3, -v3, v10, v8
; GFX10-FLUSH-NEXT:    v_mad_f32 v4, -v4, v11, v9
; GFX10-FLUSH-NEXT:    v_mul_f32_e32 v3, v3, v6
; GFX10-FLUSH-NEXT:    v_mul_f32_e32 v4, v4, v7
; GFX10-FLUSH-NEXT:    v_and_b32_e32 v3, 0xff800000, v3
; GFX10-FLUSH-NEXT:    v_and_b32_e32 v4, 0xff800000, v4
; GFX10-FLUSH-NEXT:    v_add_f32_e32 v3, v3, v10
; GFX10-FLUSH-NEXT:    v_add_f32_e32 v4, v4, v11
; GFX10-FLUSH-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX10-FLUSH-NEXT:    v_cvt_f16_f32_e32 v4, v4
; GFX10-FLUSH-NEXT:    v_div_fixup_f16 v0, v3, v1, v0
; GFX10-FLUSH-NEXT:    v_div_fixup_f16 v1, v4, v2, v5
; GFX10-FLUSH-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX10-FLUSH-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fdiv_v2f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_lshrrev_b32_e32 v2, 16, v1
; GFX11-NEXT:    v_cvt_f32_f16_e32 v3, v1
; GFX11-NEXT:    v_lshrrev_b32_e32 v5, 16, v0
; GFX11-NEXT:    v_cvt_f32_f16_e32 v6, v0
; GFX11-NEXT:    v_cvt_f32_f16_e32 v4, v2
; GFX11-NEXT:    v_rcp_f32_e32 v3, v3
; GFX11-NEXT:    v_cvt_f32_f16_e32 v7, v5
; GFX11-NEXT:    v_rcp_f32_e32 v4, v4
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_dual_mul_f32 v6, v6, v3 :: v_dual_mul_f32 v7, v7, v4
; GFX11-NEXT:    v_fma_mix_f32 v8, -v1, v6, v0 op_sel_hi:[1,0,1]
; GFX11-NEXT:    v_fma_mix_f32 v9, -v1, v7, v0 op_sel:[1,0,1] op_sel_hi:[1,0,1]
; GFX11-NEXT:    v_dual_fmac_f32 v6, v8, v3 :: v_dual_fmac_f32 v7, v9, v4
; GFX11-NEXT:    v_fma_mix_f32 v8, -v1, v6, v0 op_sel_hi:[1,0,1]
; GFX11-NEXT:    v_fma_mix_f32 v9, -v1, v7, v0 op_sel:[1,0,1] op_sel_hi:[1,0,1]
; GFX11-NEXT:    v_dual_mul_f32 v3, v8, v3 :: v_dual_mul_f32 v4, v9, v4
; GFX11-NEXT:    v_and_b32_e32 v3, 0xff800000, v3
; GFX11-NEXT:    v_dual_add_f32 v3, v3, v6 :: v_dual_and_b32 v4, 0xff800000, v4
; GFX11-NEXT:    v_add_f32_e32 v4, v4, v7
; GFX11-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX11-NEXT:    v_cvt_f16_f32_e32 v4, v4
; GFX11-NEXT:    v_div_fixup_f16 v0, v3, v1, v0
; GFX11-NEXT:    v_div_fixup_f16 v1, v4, v2, v5
; GFX11-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %fdiv = fdiv <2 x half> %a, %b
  ret <2 x half> %fdiv
}

define <2 x half> @v_fdiv_v2f16_afn(<2 x half> %a, <2 x half> %b) {
; GFX6-LABEL: v_fdiv_v2f16_afn:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GFX6-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GFX6-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX6-NEXT:    v_rcp_f32_e32 v2, v2
; GFX6-NEXT:    v_rcp_f32_e32 v3, v3
; GFX6-NEXT:    v_mul_f32_e32 v0, v0, v2
; GFX6-NEXT:    v_mul_f32_e32 v1, v1, v3
; GFX6-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_fdiv_v2f16_afn:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_rcp_f16_e32 v2, v1
; GFX8-NEXT:    v_rcp_f16_sdwa v1, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GFX8-NEXT:    v_mul_f16_e32 v2, v0, v2
; GFX8-NEXT:    v_mul_f16_sdwa v0, v0, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_e32 v0, v2, v0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_fdiv_v2f16_afn:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_rcp_f16_e32 v2, v1
; GFX9-NEXT:    v_rcp_f16_sdwa v1, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GFX9-NEXT:    v_mul_f16_e32 v2, v0, v2
; GFX9-NEXT:    v_mul_f16_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    v_pack_b32_f16 v0, v2, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_fdiv_v2f16_afn:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_rcp_f16_e32 v2, v1
; GFX10-NEXT:    v_rcp_f16_sdwa v1, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GFX10-NEXT:    v_mul_f16_e32 v2, v0, v2
; GFX10-NEXT:    v_mul_f16_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX10-NEXT:    v_pack_b32_f16 v0, v2, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fdiv_v2f16_afn:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_lshrrev_b32_e32 v2, 16, v1
; GFX11-NEXT:    v_rcp_f16_e32 v1, v1
; GFX11-NEXT:    v_lshrrev_b32_e32 v3, 16, v0
; GFX11-NEXT:    v_rcp_f16_e32 v2, v2
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX11-NEXT:    v_mul_f16_e32 v1, v3, v2
; GFX11-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %fdiv = fdiv afn <2 x half> %a, %b
  ret <2 x half> %fdiv
}

define <2 x half> @v_fdiv_v2f16_ulp25(<2 x half> %a, <2 x half> %b) {
; GFX6-IEEE-LABEL: v_fdiv_v2f16_ulp25:
; GFX6-IEEE:       ; %bb.0:
; GFX6-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GFX6-IEEE-NEXT:    v_div_scale_f32 v4, s[4:5], v2, v2, v0
; GFX6-IEEE-NEXT:    v_rcp_f32_e32 v5, v4
; GFX6-IEEE-NEXT:    v_div_scale_f32 v6, vcc, v0, v2, v0
; GFX6-IEEE-NEXT:    v_fma_f32 v7, -v4, v5, 1.0
; GFX6-IEEE-NEXT:    v_fma_f32 v5, v7, v5, v5
; GFX6-IEEE-NEXT:    v_mul_f32_e32 v7, v6, v5
; GFX6-IEEE-NEXT:    v_fma_f32 v8, -v4, v7, v6
; GFX6-IEEE-NEXT:    v_fma_f32 v7, v8, v5, v7
; GFX6-IEEE-NEXT:    v_fma_f32 v4, -v4, v7, v6
; GFX6-IEEE-NEXT:    v_div_fmas_f32 v4, v4, v5, v7
; GFX6-IEEE-NEXT:    v_div_fixup_f32 v0, v4, v2, v0
; GFX6-IEEE-NEXT:    v_div_scale_f32 v2, s[4:5], v3, v3, v1
; GFX6-IEEE-NEXT:    v_rcp_f32_e32 v4, v2
; GFX6-IEEE-NEXT:    v_div_scale_f32 v5, vcc, v1, v3, v1
; GFX6-IEEE-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-IEEE-NEXT:    v_fma_f32 v6, -v2, v4, 1.0
; GFX6-IEEE-NEXT:    v_fma_f32 v4, v6, v4, v4
; GFX6-IEEE-NEXT:    v_mul_f32_e32 v6, v5, v4
; GFX6-IEEE-NEXT:    v_fma_f32 v7, -v2, v6, v5
; GFX6-IEEE-NEXT:    v_fma_f32 v6, v7, v4, v6
; GFX6-IEEE-NEXT:    v_fma_f32 v2, -v2, v6, v5
; GFX6-IEEE-NEXT:    v_div_fmas_f32 v2, v2, v4, v6
; GFX6-IEEE-NEXT:    v_div_fixup_f32 v1, v2, v3, v1
; GFX6-IEEE-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX6-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-FLUSH-LABEL: v_fdiv_v2f16_ulp25:
; GFX6-FLUSH:       ; %bb.0:
; GFX6-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v4, s[4:5], v2, v2, v0
; GFX6-FLUSH-NEXT:    v_rcp_f32_e32 v5, v4
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v6, vcc, v0, v2, v0
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-FLUSH-NEXT:    v_fma_f32 v7, -v4, v5, 1.0
; GFX6-FLUSH-NEXT:    v_fma_f32 v5, v7, v5, v5
; GFX6-FLUSH-NEXT:    v_mul_f32_e32 v7, v6, v5
; GFX6-FLUSH-NEXT:    v_fma_f32 v8, -v4, v7, v6
; GFX6-FLUSH-NEXT:    v_fma_f32 v7, v8, v5, v7
; GFX6-FLUSH-NEXT:    v_fma_f32 v4, -v4, v7, v6
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GFX6-FLUSH-NEXT:    v_div_fmas_f32 v4, v4, v5, v7
; GFX6-FLUSH-NEXT:    v_div_fixup_f32 v0, v4, v2, v0
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 2, 2), 0
; GFX6-FLUSH-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v2, s[4:5], v3, v3, v1
; GFX6-FLUSH-NEXT:    v_rcp_f32_e32 v4, v2
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v5, vcc, v1, v3, v1
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-FLUSH-NEXT:    v_fma_f32 v6, -v2, v4, 1.0
; GFX6-FLUSH-NEXT:    v_fma_f32 v4, v6, v4, v4
; GFX6-FLUSH-NEXT:    v_mul_f32_e32 v6, v5, v4
; GFX6-FLUSH-NEXT:    v_fma_f32 v7, -v2, v6, v5
; GFX6-FLUSH-NEXT:    v_fma_f32 v6, v7, v4, v6
; GFX6-FLUSH-NEXT:    v_fma_f32 v2, -v2, v6, v5
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX6-FLUSH-NEXT:    v_div_fmas_f32 v2, v2, v4, v6
; GFX6-FLUSH-NEXT:    v_div_fixup_f32 v1, v2, v3, v1
; GFX6-FLUSH-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX6-FLUSH-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-IEEE-LABEL: v_fdiv_v2f16_ulp25:
; GFX8-IEEE:       ; %bb.0:
; GFX8-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-IEEE-NEXT:    v_cvt_f32_f16_e32 v2, v1
; GFX8-IEEE-NEXT:    v_cvt_f32_f16_e32 v4, v0
; GFX8-IEEE-NEXT:    v_lshrrev_b32_e32 v6, 16, v1
; GFX8-IEEE-NEXT:    v_cvt_f32_f16_e32 v8, v6
; GFX8-IEEE-NEXT:    v_rcp_f32_e32 v5, v2
; GFX8-IEEE-NEXT:    v_lshrrev_b32_e32 v3, 16, v0
; GFX8-IEEE-NEXT:    v_cvt_f32_f16_e32 v7, v3
; GFX8-IEEE-NEXT:    v_mul_f32_e32 v9, v4, v5
; GFX8-IEEE-NEXT:    v_mul_f32_e64 v10, -v2, v9
; GFX8-IEEE-NEXT:    v_add_f32_e32 v10, v10, v4
; GFX8-IEEE-NEXT:    v_mul_f32_e32 v10, v10, v5
; GFX8-IEEE-NEXT:    v_add_f32_e32 v9, v10, v9
; GFX8-IEEE-NEXT:    v_mul_f32_e64 v2, -v2, v9
; GFX8-IEEE-NEXT:    v_add_f32_e32 v2, v2, v4
; GFX8-IEEE-NEXT:    v_rcp_f32_e32 v4, v8
; GFX8-IEEE-NEXT:    v_mul_f32_e32 v2, v2, v5
; GFX8-IEEE-NEXT:    v_and_b32_e32 v2, 0xff800000, v2
; GFX8-IEEE-NEXT:    v_add_f32_e32 v2, v2, v9
; GFX8-IEEE-NEXT:    v_mul_f32_e32 v5, v7, v4
; GFX8-IEEE-NEXT:    v_mul_f32_e64 v9, -v8, v5
; GFX8-IEEE-NEXT:    v_add_f32_e32 v9, v9, v7
; GFX8-IEEE-NEXT:    v_mul_f32_e32 v9, v9, v4
; GFX8-IEEE-NEXT:    v_add_f32_e32 v5, v9, v5
; GFX8-IEEE-NEXT:    v_mul_f32_e64 v8, -v8, v5
; GFX8-IEEE-NEXT:    v_add_f32_e32 v7, v8, v7
; GFX8-IEEE-NEXT:    v_mul_f32_e32 v4, v7, v4
; GFX8-IEEE-NEXT:    v_and_b32_e32 v4, 0xff800000, v4
; GFX8-IEEE-NEXT:    v_add_f32_e32 v4, v4, v5
; GFX8-IEEE-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX8-IEEE-NEXT:    v_cvt_f16_f32_e32 v4, v4
; GFX8-IEEE-NEXT:    v_div_fixup_f16 v0, v2, v1, v0
; GFX8-IEEE-NEXT:    v_div_fixup_f16 v1, v4, v6, v3
; GFX8-IEEE-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX8-IEEE-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX8-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-FLUSH-LABEL: v_fdiv_v2f16_ulp25:
; GFX8-FLUSH:       ; %bb.0:
; GFX8-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-FLUSH-NEXT:    v_cvt_f32_f16_e32 v2, v1
; GFX8-FLUSH-NEXT:    v_cvt_f32_f16_e32 v4, v0
; GFX8-FLUSH-NEXT:    v_lshrrev_b32_e32 v6, 16, v1
; GFX8-FLUSH-NEXT:    v_cvt_f32_f16_e32 v8, v6
; GFX8-FLUSH-NEXT:    v_rcp_f32_e32 v5, v2
; GFX8-FLUSH-NEXT:    v_lshrrev_b32_e32 v3, 16, v0
; GFX8-FLUSH-NEXT:    v_cvt_f32_f16_e32 v7, v3
; GFX8-FLUSH-NEXT:    v_mul_f32_e32 v9, v4, v5
; GFX8-FLUSH-NEXT:    v_mad_f32 v10, -v2, v9, v4
; GFX8-FLUSH-NEXT:    v_mac_f32_e32 v9, v10, v5
; GFX8-FLUSH-NEXT:    v_mad_f32 v2, -v2, v9, v4
; GFX8-FLUSH-NEXT:    v_rcp_f32_e32 v4, v8
; GFX8-FLUSH-NEXT:    v_mul_f32_e32 v2, v2, v5
; GFX8-FLUSH-NEXT:    v_and_b32_e32 v2, 0xff800000, v2
; GFX8-FLUSH-NEXT:    v_add_f32_e32 v2, v2, v9
; GFX8-FLUSH-NEXT:    v_mul_f32_e32 v5, v7, v4
; GFX8-FLUSH-NEXT:    v_mad_f32 v9, -v8, v5, v7
; GFX8-FLUSH-NEXT:    v_mac_f32_e32 v5, v9, v4
; GFX8-FLUSH-NEXT:    v_mad_f32 v7, -v8, v5, v7
; GFX8-FLUSH-NEXT:    v_mul_f32_e32 v4, v7, v4
; GFX8-FLUSH-NEXT:    v_and_b32_e32 v4, 0xff800000, v4
; GFX8-FLUSH-NEXT:    v_add_f32_e32 v4, v4, v5
; GFX8-FLUSH-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX8-FLUSH-NEXT:    v_cvt_f16_f32_e32 v4, v4
; GFX8-FLUSH-NEXT:    v_div_fixup_f16 v0, v2, v1, v0
; GFX8-FLUSH-NEXT:    v_div_fixup_f16 v1, v4, v6, v3
; GFX8-FLUSH-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX8-FLUSH-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX8-FLUSH-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-IEEE-LABEL: v_fdiv_v2f16_ulp25:
; GFX9-IEEE:       ; %bb.0:
; GFX9-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-IEEE-NEXT:    v_cvt_f32_f16_e32 v2, v1
; GFX9-IEEE-NEXT:    v_cvt_f32_f16_e32 v4, v0
; GFX9-IEEE-NEXT:    v_lshrrev_b32_e32 v6, 16, v1
; GFX9-IEEE-NEXT:    v_cvt_f32_f16_e32 v8, v6
; GFX9-IEEE-NEXT:    v_rcp_f32_e32 v5, v2
; GFX9-IEEE-NEXT:    v_lshrrev_b32_e32 v3, 16, v0
; GFX9-IEEE-NEXT:    v_cvt_f32_f16_e32 v7, v3
; GFX9-IEEE-NEXT:    v_mul_f32_e32 v9, v4, v5
; GFX9-IEEE-NEXT:    v_mul_f32_e64 v10, -v2, v9
; GFX9-IEEE-NEXT:    v_add_f32_e32 v10, v10, v4
; GFX9-IEEE-NEXT:    v_mul_f32_e32 v10, v10, v5
; GFX9-IEEE-NEXT:    v_add_f32_e32 v9, v10, v9
; GFX9-IEEE-NEXT:    v_mul_f32_e64 v2, -v2, v9
; GFX9-IEEE-NEXT:    v_add_f32_e32 v2, v2, v4
; GFX9-IEEE-NEXT:    v_rcp_f32_e32 v4, v8
; GFX9-IEEE-NEXT:    v_mul_f32_e32 v2, v2, v5
; GFX9-IEEE-NEXT:    v_and_b32_e32 v2, 0xff800000, v2
; GFX9-IEEE-NEXT:    v_add_f32_e32 v2, v2, v9
; GFX9-IEEE-NEXT:    v_mul_f32_e32 v5, v7, v4
; GFX9-IEEE-NEXT:    v_mul_f32_e64 v9, -v8, v5
; GFX9-IEEE-NEXT:    v_add_f32_e32 v9, v9, v7
; GFX9-IEEE-NEXT:    v_mul_f32_e32 v9, v9, v4
; GFX9-IEEE-NEXT:    v_add_f32_e32 v5, v9, v5
; GFX9-IEEE-NEXT:    v_mul_f32_e64 v8, -v8, v5
; GFX9-IEEE-NEXT:    v_add_f32_e32 v7, v8, v7
; GFX9-IEEE-NEXT:    v_mul_f32_e32 v4, v7, v4
; GFX9-IEEE-NEXT:    v_and_b32_e32 v4, 0xff800000, v4
; GFX9-IEEE-NEXT:    v_add_f32_e32 v4, v4, v5
; GFX9-IEEE-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX9-IEEE-NEXT:    v_cvt_f16_f32_e32 v4, v4
; GFX9-IEEE-NEXT:    v_div_fixup_f16 v0, v2, v1, v0
; GFX9-IEEE-NEXT:    v_div_fixup_f16 v1, v4, v6, v3
; GFX9-IEEE-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX9-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-FLUSH-LABEL: v_fdiv_v2f16_ulp25:
; GFX9-FLUSH:       ; %bb.0:
; GFX9-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-FLUSH-NEXT:    v_cvt_f32_f16_e32 v2, v1
; GFX9-FLUSH-NEXT:    v_cvt_f32_f16_e32 v4, v0
; GFX9-FLUSH-NEXT:    v_lshrrev_b32_e32 v5, 16, v1
; GFX9-FLUSH-NEXT:    v_cvt_f32_f16_e32 v7, v5
; GFX9-FLUSH-NEXT:    v_rcp_f32_e32 v2, v2
; GFX9-FLUSH-NEXT:    v_lshrrev_b32_e32 v3, 16, v0
; GFX9-FLUSH-NEXT:    v_cvt_f32_f16_e32 v6, v3
; GFX9-FLUSH-NEXT:    v_rcp_f32_e32 v7, v7
; GFX9-FLUSH-NEXT:    v_mul_f32_e32 v4, v4, v2
; GFX9-FLUSH-NEXT:    v_mad_mix_f32 v8, -v1, v4, v0 op_sel_hi:[1,0,1]
; GFX9-FLUSH-NEXT:    v_mac_f32_e32 v4, v8, v2
; GFX9-FLUSH-NEXT:    v_mad_mix_f32 v8, -v1, v4, v0 op_sel_hi:[1,0,1]
; GFX9-FLUSH-NEXT:    v_mul_f32_e32 v2, v8, v2
; GFX9-FLUSH-NEXT:    v_and_b32_e32 v2, 0xff800000, v2
; GFX9-FLUSH-NEXT:    v_add_f32_e32 v2, v2, v4
; GFX9-FLUSH-NEXT:    v_mul_f32_e32 v4, v6, v7
; GFX9-FLUSH-NEXT:    v_mad_mix_f32 v6, -v1, v4, v0 op_sel:[1,0,1] op_sel_hi:[1,0,1]
; GFX9-FLUSH-NEXT:    v_mac_f32_e32 v4, v6, v7
; GFX9-FLUSH-NEXT:    v_mad_mix_f32 v6, -v1, v4, v0 op_sel:[1,0,1] op_sel_hi:[1,0,1]
; GFX9-FLUSH-NEXT:    v_mul_f32_e32 v6, v6, v7
; GFX9-FLUSH-NEXT:    v_and_b32_e32 v6, 0xff800000, v6
; GFX9-FLUSH-NEXT:    v_add_f32_e32 v4, v6, v4
; GFX9-FLUSH-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX9-FLUSH-NEXT:    v_cvt_f16_f32_e32 v4, v4
; GFX9-FLUSH-NEXT:    v_div_fixup_f16 v0, v2, v1, v0
; GFX9-FLUSH-NEXT:    v_div_fixup_f16 v1, v4, v5, v3
; GFX9-FLUSH-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX9-FLUSH-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-IEEE-LABEL: v_fdiv_v2f16_ulp25:
; GFX10-IEEE:       ; %bb.0:
; GFX10-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-IEEE-NEXT:    v_lshrrev_b32_e32 v2, 16, v1
; GFX10-IEEE-NEXT:    v_cvt_f32_f16_e32 v3, v1
; GFX10-IEEE-NEXT:    v_lshrrev_b32_e32 v5, 16, v0
; GFX10-IEEE-NEXT:    v_cvt_f32_f16_e32 v8, v0
; GFX10-IEEE-NEXT:    v_cvt_f32_f16_e32 v4, v2
; GFX10-IEEE-NEXT:    v_rcp_f32_e32 v6, v3
; GFX10-IEEE-NEXT:    v_cvt_f32_f16_e32 v9, v5
; GFX10-IEEE-NEXT:    v_rcp_f32_e32 v7, v4
; GFX10-IEEE-NEXT:    v_mul_f32_e32 v10, v8, v6
; GFX10-IEEE-NEXT:    v_mul_f32_e32 v11, v9, v7
; GFX10-IEEE-NEXT:    v_mul_f32_e64 v12, -v3, v10
; GFX10-IEEE-NEXT:    v_mul_f32_e64 v13, -v4, v11
; GFX10-IEEE-NEXT:    v_add_f32_e32 v12, v12, v8
; GFX10-IEEE-NEXT:    v_add_f32_e32 v13, v13, v9
; GFX10-IEEE-NEXT:    v_mul_f32_e32 v12, v12, v6
; GFX10-IEEE-NEXT:    v_mul_f32_e32 v13, v13, v7
; GFX10-IEEE-NEXT:    v_add_f32_e32 v10, v12, v10
; GFX10-IEEE-NEXT:    v_add_f32_e32 v11, v13, v11
; GFX10-IEEE-NEXT:    v_mul_f32_e64 v3, -v3, v10
; GFX10-IEEE-NEXT:    v_mul_f32_e64 v4, -v4, v11
; GFX10-IEEE-NEXT:    v_add_f32_e32 v3, v3, v8
; GFX10-IEEE-NEXT:    v_add_f32_e32 v4, v4, v9
; GFX10-IEEE-NEXT:    v_mul_f32_e32 v3, v3, v6
; GFX10-IEEE-NEXT:    v_mul_f32_e32 v4, v4, v7
; GFX10-IEEE-NEXT:    v_and_b32_e32 v3, 0xff800000, v3
; GFX10-IEEE-NEXT:    v_and_b32_e32 v4, 0xff800000, v4
; GFX10-IEEE-NEXT:    v_add_f32_e32 v3, v3, v10
; GFX10-IEEE-NEXT:    v_add_f32_e32 v4, v4, v11
; GFX10-IEEE-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX10-IEEE-NEXT:    v_cvt_f16_f32_e32 v4, v4
; GFX10-IEEE-NEXT:    v_div_fixup_f16 v0, v3, v1, v0
; GFX10-IEEE-NEXT:    v_div_fixup_f16 v1, v4, v2, v5
; GFX10-IEEE-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX10-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-FLUSH-LABEL: v_fdiv_v2f16_ulp25:
; GFX10-FLUSH:       ; %bb.0:
; GFX10-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-FLUSH-NEXT:    v_lshrrev_b32_e32 v2, 16, v1
; GFX10-FLUSH-NEXT:    v_cvt_f32_f16_e32 v3, v1
; GFX10-FLUSH-NEXT:    v_lshrrev_b32_e32 v5, 16, v0
; GFX10-FLUSH-NEXT:    v_cvt_f32_f16_e32 v8, v0
; GFX10-FLUSH-NEXT:    v_cvt_f32_f16_e32 v4, v2
; GFX10-FLUSH-NEXT:    v_rcp_f32_e32 v6, v3
; GFX10-FLUSH-NEXT:    v_cvt_f32_f16_e32 v9, v5
; GFX10-FLUSH-NEXT:    v_rcp_f32_e32 v7, v4
; GFX10-FLUSH-NEXT:    v_mul_f32_e32 v10, v8, v6
; GFX10-FLUSH-NEXT:    v_mul_f32_e32 v11, v9, v7
; GFX10-FLUSH-NEXT:    v_mad_f32 v12, -v3, v10, v8
; GFX10-FLUSH-NEXT:    v_mad_f32 v13, -v4, v11, v9
; GFX10-FLUSH-NEXT:    v_mac_f32_e32 v10, v12, v6
; GFX10-FLUSH-NEXT:    v_mac_f32_e32 v11, v13, v7
; GFX10-FLUSH-NEXT:    v_mad_f32 v3, -v3, v10, v8
; GFX10-FLUSH-NEXT:    v_mad_f32 v4, -v4, v11, v9
; GFX10-FLUSH-NEXT:    v_mul_f32_e32 v3, v3, v6
; GFX10-FLUSH-NEXT:    v_mul_f32_e32 v4, v4, v7
; GFX10-FLUSH-NEXT:    v_and_b32_e32 v3, 0xff800000, v3
; GFX10-FLUSH-NEXT:    v_and_b32_e32 v4, 0xff800000, v4
; GFX10-FLUSH-NEXT:    v_add_f32_e32 v3, v3, v10
; GFX10-FLUSH-NEXT:    v_add_f32_e32 v4, v4, v11
; GFX10-FLUSH-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX10-FLUSH-NEXT:    v_cvt_f16_f32_e32 v4, v4
; GFX10-FLUSH-NEXT:    v_div_fixup_f16 v0, v3, v1, v0
; GFX10-FLUSH-NEXT:    v_div_fixup_f16 v1, v4, v2, v5
; GFX10-FLUSH-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX10-FLUSH-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fdiv_v2f16_ulp25:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_lshrrev_b32_e32 v2, 16, v1
; GFX11-NEXT:    v_cvt_f32_f16_e32 v3, v1
; GFX11-NEXT:    v_lshrrev_b32_e32 v5, 16, v0
; GFX11-NEXT:    v_cvt_f32_f16_e32 v6, v0
; GFX11-NEXT:    v_cvt_f32_f16_e32 v4, v2
; GFX11-NEXT:    v_rcp_f32_e32 v3, v3
; GFX11-NEXT:    v_cvt_f32_f16_e32 v7, v5
; GFX11-NEXT:    v_rcp_f32_e32 v4, v4
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_dual_mul_f32 v6, v6, v3 :: v_dual_mul_f32 v7, v7, v4
; GFX11-NEXT:    v_fma_mix_f32 v8, -v1, v6, v0 op_sel_hi:[1,0,1]
; GFX11-NEXT:    v_fma_mix_f32 v9, -v1, v7, v0 op_sel:[1,0,1] op_sel_hi:[1,0,1]
; GFX11-NEXT:    v_dual_fmac_f32 v6, v8, v3 :: v_dual_fmac_f32 v7, v9, v4
; GFX11-NEXT:    v_fma_mix_f32 v8, -v1, v6, v0 op_sel_hi:[1,0,1]
; GFX11-NEXT:    v_fma_mix_f32 v9, -v1, v7, v0 op_sel:[1,0,1] op_sel_hi:[1,0,1]
; GFX11-NEXT:    v_dual_mul_f32 v3, v8, v3 :: v_dual_mul_f32 v4, v9, v4
; GFX11-NEXT:    v_and_b32_e32 v3, 0xff800000, v3
; GFX11-NEXT:    v_dual_add_f32 v3, v3, v6 :: v_dual_and_b32 v4, 0xff800000, v4
; GFX11-NEXT:    v_add_f32_e32 v4, v4, v7
; GFX11-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX11-NEXT:    v_cvt_f16_f32_e32 v4, v4
; GFX11-NEXT:    v_div_fixup_f16 v0, v3, v1, v0
; GFX11-NEXT:    v_div_fixup_f16 v1, v4, v2, v5
; GFX11-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %fdiv = fdiv <2 x half> %a, %b
  ret <2 x half> %fdiv
}

define <2 x half> @v_rcp_v2f16(<2 x half> %x) {
; GFX6-IEEE-LABEL: v_rcp_v2f16:
; GFX6-IEEE:       ; %bb.0:
; GFX6-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v2, 1.0
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX6-IEEE-NEXT:    v_div_scale_f32 v3, s[4:5], v0, v0, v2
; GFX6-IEEE-NEXT:    v_rcp_f32_e32 v4, v3
; GFX6-IEEE-NEXT:    v_div_scale_f32 v5, vcc, v2, v0, v2
; GFX6-IEEE-NEXT:    v_fma_f32 v6, -v3, v4, 1.0
; GFX6-IEEE-NEXT:    v_fma_f32 v4, v6, v4, v4
; GFX6-IEEE-NEXT:    v_mul_f32_e32 v6, v5, v4
; GFX6-IEEE-NEXT:    v_fma_f32 v7, -v3, v6, v5
; GFX6-IEEE-NEXT:    v_fma_f32 v6, v7, v4, v6
; GFX6-IEEE-NEXT:    v_fma_f32 v3, -v3, v6, v5
; GFX6-IEEE-NEXT:    v_div_fmas_f32 v3, v3, v4, v6
; GFX6-IEEE-NEXT:    v_div_fixup_f32 v0, v3, v0, v2
; GFX6-IEEE-NEXT:    v_div_scale_f32 v3, s[4:5], v1, v1, v2
; GFX6-IEEE-NEXT:    v_rcp_f32_e32 v4, v3
; GFX6-IEEE-NEXT:    v_div_scale_f32 v5, vcc, v2, v1, v2
; GFX6-IEEE-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-IEEE-NEXT:    v_fma_f32 v6, -v3, v4, 1.0
; GFX6-IEEE-NEXT:    v_fma_f32 v4, v6, v4, v4
; GFX6-IEEE-NEXT:    v_mul_f32_e32 v6, v5, v4
; GFX6-IEEE-NEXT:    v_fma_f32 v7, -v3, v6, v5
; GFX6-IEEE-NEXT:    v_fma_f32 v6, v7, v4, v6
; GFX6-IEEE-NEXT:    v_fma_f32 v3, -v3, v6, v5
; GFX6-IEEE-NEXT:    v_div_fmas_f32 v3, v3, v4, v6
; GFX6-IEEE-NEXT:    v_div_fixup_f32 v1, v3, v1, v2
; GFX6-IEEE-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX6-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-FLUSH-LABEL: v_rcp_v2f16:
; GFX6-FLUSH:       ; %bb.0:
; GFX6-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v2, 1.0
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v3, s[4:5], v0, v0, v2
; GFX6-FLUSH-NEXT:    v_rcp_f32_e32 v4, v3
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v5, vcc, v2, v0, v2
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-FLUSH-NEXT:    v_fma_f32 v6, -v3, v4, 1.0
; GFX6-FLUSH-NEXT:    v_fma_f32 v4, v6, v4, v4
; GFX6-FLUSH-NEXT:    v_mul_f32_e32 v6, v5, v4
; GFX6-FLUSH-NEXT:    v_fma_f32 v7, -v3, v6, v5
; GFX6-FLUSH-NEXT:    v_fma_f32 v6, v7, v4, v6
; GFX6-FLUSH-NEXT:    v_fma_f32 v3, -v3, v6, v5
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX6-FLUSH-NEXT:    v_div_fmas_f32 v3, v3, v4, v6
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v4, 1.0
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX6-FLUSH-NEXT:    v_div_fixup_f32 v0, v3, v0, v2
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 2, 2), 0
; GFX6-FLUSH-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v2, s[4:5], v1, v1, v4
; GFX6-FLUSH-NEXT:    v_rcp_f32_e32 v3, v2
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v5, vcc, v4, v1, v4
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-FLUSH-NEXT:    v_fma_f32 v6, -v2, v3, 1.0
; GFX6-FLUSH-NEXT:    v_fma_f32 v3, v6, v3, v3
; GFX6-FLUSH-NEXT:    v_mul_f32_e32 v6, v5, v3
; GFX6-FLUSH-NEXT:    v_fma_f32 v7, -v2, v6, v5
; GFX6-FLUSH-NEXT:    v_fma_f32 v6, v7, v3, v6
; GFX6-FLUSH-NEXT:    v_fma_f32 v2, -v2, v6, v5
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX6-FLUSH-NEXT:    v_div_fmas_f32 v2, v2, v3, v6
; GFX6-FLUSH-NEXT:    v_div_fixup_f32 v1, v2, v1, v4
; GFX6-FLUSH-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX6-FLUSH-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-IEEE-LABEL: v_rcp_v2f16:
; GFX8-IEEE:       ; %bb.0:
; GFX8-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-IEEE-NEXT:    v_cvt_f32_f16_e32 v1, v0
; GFX8-IEEE-NEXT:    v_lshrrev_b32_e32 v2, 16, v0
; GFX8-IEEE-NEXT:    v_cvt_f32_f16_e32 v4, 1.0
; GFX8-IEEE-NEXT:    v_cvt_f32_f16_e32 v3, v2
; GFX8-IEEE-NEXT:    v_rcp_f32_e32 v5, v1
; GFX8-IEEE-NEXT:    v_rcp_f32_e32 v6, v3
; GFX8-IEEE-NEXT:    v_mul_f32_e32 v7, v4, v5
; GFX8-IEEE-NEXT:    v_mul_f32_e64 v8, -v1, v7
; GFX8-IEEE-NEXT:    v_add_f32_e32 v8, v8, v4
; GFX8-IEEE-NEXT:    v_mul_f32_e32 v8, v8, v5
; GFX8-IEEE-NEXT:    v_add_f32_e32 v7, v8, v7
; GFX8-IEEE-NEXT:    v_mul_f32_e32 v9, v4, v6
; GFX8-IEEE-NEXT:    v_mul_f32_e64 v1, -v1, v7
; GFX8-IEEE-NEXT:    v_mul_f32_e64 v10, -v3, v9
; GFX8-IEEE-NEXT:    v_add_f32_e32 v1, v1, v4
; GFX8-IEEE-NEXT:    v_mul_f32_e32 v1, v1, v5
; GFX8-IEEE-NEXT:    v_add_f32_e32 v5, v10, v4
; GFX8-IEEE-NEXT:    v_mul_f32_e32 v5, v5, v6
; GFX8-IEEE-NEXT:    v_add_f32_e32 v5, v5, v9
; GFX8-IEEE-NEXT:    v_mul_f32_e64 v3, -v3, v5
; GFX8-IEEE-NEXT:    v_add_f32_e32 v3, v3, v4
; GFX8-IEEE-NEXT:    v_mul_f32_e32 v3, v3, v6
; GFX8-IEEE-NEXT:    v_and_b32_e32 v1, 0xff800000, v1
; GFX8-IEEE-NEXT:    v_and_b32_e32 v3, 0xff800000, v3
; GFX8-IEEE-NEXT:    v_add_f32_e32 v1, v1, v7
; GFX8-IEEE-NEXT:    v_add_f32_e32 v3, v3, v5
; GFX8-IEEE-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX8-IEEE-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX8-IEEE-NEXT:    v_div_fixup_f16 v0, v1, v0, 1.0
; GFX8-IEEE-NEXT:    v_div_fixup_f16 v1, v3, v2, 1.0
; GFX8-IEEE-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX8-IEEE-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX8-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-FLUSH-LABEL: v_rcp_v2f16:
; GFX8-FLUSH:       ; %bb.0:
; GFX8-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-FLUSH-NEXT:    v_cvt_f32_f16_e32 v1, v0
; GFX8-FLUSH-NEXT:    v_lshrrev_b32_e32 v2, 16, v0
; GFX8-FLUSH-NEXT:    v_cvt_f32_f16_e32 v3, v2
; GFX8-FLUSH-NEXT:    v_cvt_f32_f16_e32 v4, 1.0
; GFX8-FLUSH-NEXT:    v_rcp_f32_e32 v5, v1
; GFX8-FLUSH-NEXT:    v_rcp_f32_e32 v6, v3
; GFX8-FLUSH-NEXT:    v_mul_f32_e32 v7, v4, v5
; GFX8-FLUSH-NEXT:    v_mad_f32 v8, -v1, v7, v4
; GFX8-FLUSH-NEXT:    v_mul_f32_e32 v9, v4, v6
; GFX8-FLUSH-NEXT:    v_mac_f32_e32 v7, v8, v5
; GFX8-FLUSH-NEXT:    v_mad_f32 v8, -v3, v9, v4
; GFX8-FLUSH-NEXT:    v_mac_f32_e32 v9, v8, v6
; GFX8-FLUSH-NEXT:    v_mad_f32 v1, -v1, v7, v4
; GFX8-FLUSH-NEXT:    v_mad_f32 v3, -v3, v9, v4
; GFX8-FLUSH-NEXT:    v_mul_f32_e32 v1, v1, v5
; GFX8-FLUSH-NEXT:    v_mul_f32_e32 v3, v3, v6
; GFX8-FLUSH-NEXT:    v_and_b32_e32 v1, 0xff800000, v1
; GFX8-FLUSH-NEXT:    v_and_b32_e32 v3, 0xff800000, v3
; GFX8-FLUSH-NEXT:    v_add_f32_e32 v1, v1, v7
; GFX8-FLUSH-NEXT:    v_add_f32_e32 v3, v3, v9
; GFX8-FLUSH-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX8-FLUSH-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX8-FLUSH-NEXT:    v_div_fixup_f16 v0, v1, v0, 1.0
; GFX8-FLUSH-NEXT:    v_div_fixup_f16 v1, v3, v2, 1.0
; GFX8-FLUSH-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX8-FLUSH-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX8-FLUSH-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-IEEE-LABEL: v_rcp_v2f16:
; GFX9-IEEE:       ; %bb.0:
; GFX9-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-IEEE-NEXT:    v_cvt_f32_f16_e32 v1, v0
; GFX9-IEEE-NEXT:    v_lshrrev_b32_e32 v2, 16, v0
; GFX9-IEEE-NEXT:    v_cvt_f32_f16_e32 v4, 1.0
; GFX9-IEEE-NEXT:    v_cvt_f32_f16_e32 v3, v2
; GFX9-IEEE-NEXT:    v_rcp_f32_e32 v5, v1
; GFX9-IEEE-NEXT:    v_rcp_f32_e32 v6, v3
; GFX9-IEEE-NEXT:    v_mul_f32_e32 v7, v4, v5
; GFX9-IEEE-NEXT:    v_mul_f32_e64 v8, -v1, v7
; GFX9-IEEE-NEXT:    v_add_f32_e32 v8, v8, v4
; GFX9-IEEE-NEXT:    v_mul_f32_e32 v8, v8, v5
; GFX9-IEEE-NEXT:    v_add_f32_e32 v7, v8, v7
; GFX9-IEEE-NEXT:    v_mul_f32_e32 v9, v4, v6
; GFX9-IEEE-NEXT:    v_mul_f32_e64 v1, -v1, v7
; GFX9-IEEE-NEXT:    v_mul_f32_e64 v10, -v3, v9
; GFX9-IEEE-NEXT:    v_add_f32_e32 v1, v1, v4
; GFX9-IEEE-NEXT:    v_mul_f32_e32 v1, v1, v5
; GFX9-IEEE-NEXT:    v_add_f32_e32 v5, v10, v4
; GFX9-IEEE-NEXT:    v_mul_f32_e32 v5, v5, v6
; GFX9-IEEE-NEXT:    v_add_f32_e32 v5, v5, v9
; GFX9-IEEE-NEXT:    v_mul_f32_e64 v3, -v3, v5
; GFX9-IEEE-NEXT:    v_add_f32_e32 v3, v3, v4
; GFX9-IEEE-NEXT:    v_mul_f32_e32 v3, v3, v6
; GFX9-IEEE-NEXT:    v_and_b32_e32 v1, 0xff800000, v1
; GFX9-IEEE-NEXT:    v_and_b32_e32 v3, 0xff800000, v3
; GFX9-IEEE-NEXT:    v_add_f32_e32 v1, v1, v7
; GFX9-IEEE-NEXT:    v_add_f32_e32 v3, v3, v5
; GFX9-IEEE-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX9-IEEE-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX9-IEEE-NEXT:    v_div_fixup_f16 v0, v1, v0, 1.0
; GFX9-IEEE-NEXT:    v_div_fixup_f16 v1, v3, v2, 1.0
; GFX9-IEEE-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX9-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-FLUSH-LABEL: v_rcp_v2f16:
; GFX9-FLUSH:       ; %bb.0:
; GFX9-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-FLUSH-NEXT:    v_cvt_f32_f16_e32 v1, v0
; GFX9-FLUSH-NEXT:    v_lshrrev_b32_e32 v2, 16, v0
; GFX9-FLUSH-NEXT:    v_cvt_f32_f16_e32 v3, v2
; GFX9-FLUSH-NEXT:    v_cvt_f32_f16_e32 v4, 1.0
; GFX9-FLUSH-NEXT:    v_rcp_f32_e32 v1, v1
; GFX9-FLUSH-NEXT:    v_rcp_f32_e32 v3, v3
; GFX9-FLUSH-NEXT:    v_mul_f32_e32 v5, v4, v1
; GFX9-FLUSH-NEXT:    v_mad_mix_f32 v6, -v0, v5, 1.0 op_sel_hi:[1,0,1]
; GFX9-FLUSH-NEXT:    v_mac_f32_e32 v5, v6, v1
; GFX9-FLUSH-NEXT:    v_mul_f32_e32 v4, v4, v3
; GFX9-FLUSH-NEXT:    v_mad_mix_f32 v7, -v0, v5, 1.0 op_sel_hi:[1,0,1]
; GFX9-FLUSH-NEXT:    v_mad_mix_f32 v6, -v0, v4, 1.0 op_sel:[1,0,0] op_sel_hi:[1,0,1]
; GFX9-FLUSH-NEXT:    v_mul_f32_e32 v1, v7, v1
; GFX9-FLUSH-NEXT:    v_and_b32_e32 v1, 0xff800000, v1
; GFX9-FLUSH-NEXT:    v_mac_f32_e32 v4, v6, v3
; GFX9-FLUSH-NEXT:    v_add_f32_e32 v1, v1, v5
; GFX9-FLUSH-NEXT:    v_mad_mix_f32 v5, -v0, v4, 1.0 op_sel:[1,0,0] op_sel_hi:[1,0,1]
; GFX9-FLUSH-NEXT:    v_mul_f32_e32 v3, v5, v3
; GFX9-FLUSH-NEXT:    v_and_b32_e32 v3, 0xff800000, v3
; GFX9-FLUSH-NEXT:    v_add_f32_e32 v3, v3, v4
; GFX9-FLUSH-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX9-FLUSH-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX9-FLUSH-NEXT:    v_div_fixup_f16 v0, v1, v0, 1.0
; GFX9-FLUSH-NEXT:    v_div_fixup_f16 v1, v3, v2, 1.0
; GFX9-FLUSH-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX9-FLUSH-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-IEEE-LABEL: v_rcp_v2f16:
; GFX10-IEEE:       ; %bb.0:
; GFX10-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-IEEE-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX10-IEEE-NEXT:    v_cvt_f32_f16_e32 v2, v0
; GFX10-IEEE-NEXT:    v_cvt_f32_f16_e32 v6, 1.0
; GFX10-IEEE-NEXT:    v_cvt_f32_f16_e32 v3, v1
; GFX10-IEEE-NEXT:    v_rcp_f32_e32 v4, v2
; GFX10-IEEE-NEXT:    v_rcp_f32_e32 v5, v3
; GFX10-IEEE-NEXT:    v_mul_f32_e32 v7, v6, v4
; GFX10-IEEE-NEXT:    v_mul_f32_e32 v8, v6, v5
; GFX10-IEEE-NEXT:    v_mul_f32_e64 v9, -v2, v7
; GFX10-IEEE-NEXT:    v_mul_f32_e64 v10, -v3, v8
; GFX10-IEEE-NEXT:    v_add_f32_e32 v9, v9, v6
; GFX10-IEEE-NEXT:    v_add_f32_e32 v10, v10, v6
; GFX10-IEEE-NEXT:    v_mul_f32_e32 v9, v9, v4
; GFX10-IEEE-NEXT:    v_mul_f32_e32 v10, v10, v5
; GFX10-IEEE-NEXT:    v_add_f32_e32 v7, v9, v7
; GFX10-IEEE-NEXT:    v_add_f32_e32 v8, v10, v8
; GFX10-IEEE-NEXT:    v_mul_f32_e64 v2, -v2, v7
; GFX10-IEEE-NEXT:    v_mul_f32_e64 v3, -v3, v8
; GFX10-IEEE-NEXT:    v_add_f32_e32 v2, v2, v6
; GFX10-IEEE-NEXT:    v_add_f32_e32 v3, v3, v6
; GFX10-IEEE-NEXT:    v_mul_f32_e32 v2, v2, v4
; GFX10-IEEE-NEXT:    v_mul_f32_e32 v3, v3, v5
; GFX10-IEEE-NEXT:    v_and_b32_e32 v2, 0xff800000, v2
; GFX10-IEEE-NEXT:    v_and_b32_e32 v3, 0xff800000, v3
; GFX10-IEEE-NEXT:    v_add_f32_e32 v2, v2, v7
; GFX10-IEEE-NEXT:    v_add_f32_e32 v3, v3, v8
; GFX10-IEEE-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX10-IEEE-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX10-IEEE-NEXT:    v_div_fixup_f16 v0, v2, v0, 1.0
; GFX10-IEEE-NEXT:    v_div_fixup_f16 v1, v3, v1, 1.0
; GFX10-IEEE-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX10-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-FLUSH-LABEL: v_rcp_v2f16:
; GFX10-FLUSH:       ; %bb.0:
; GFX10-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-FLUSH-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX10-FLUSH-NEXT:    v_cvt_f32_f16_e32 v2, v0
; GFX10-FLUSH-NEXT:    v_cvt_f32_f16_e32 v6, 1.0
; GFX10-FLUSH-NEXT:    v_cvt_f32_f16_e32 v3, v1
; GFX10-FLUSH-NEXT:    v_rcp_f32_e32 v4, v2
; GFX10-FLUSH-NEXT:    v_rcp_f32_e32 v5, v3
; GFX10-FLUSH-NEXT:    v_mul_f32_e32 v7, v6, v4
; GFX10-FLUSH-NEXT:    v_mul_f32_e32 v8, v6, v5
; GFX10-FLUSH-NEXT:    v_mad_f32 v9, -v2, v7, v6
; GFX10-FLUSH-NEXT:    v_mad_f32 v10, -v3, v8, v6
; GFX10-FLUSH-NEXT:    v_mac_f32_e32 v7, v9, v4
; GFX10-FLUSH-NEXT:    v_mac_f32_e32 v8, v10, v5
; GFX10-FLUSH-NEXT:    v_mad_f32 v2, -v2, v7, v6
; GFX10-FLUSH-NEXT:    v_mad_f32 v3, -v3, v8, v6
; GFX10-FLUSH-NEXT:    v_mul_f32_e32 v2, v2, v4
; GFX10-FLUSH-NEXT:    v_mul_f32_e32 v3, v3, v5
; GFX10-FLUSH-NEXT:    v_and_b32_e32 v2, 0xff800000, v2
; GFX10-FLUSH-NEXT:    v_and_b32_e32 v3, 0xff800000, v3
; GFX10-FLUSH-NEXT:    v_add_f32_e32 v2, v2, v7
; GFX10-FLUSH-NEXT:    v_add_f32_e32 v3, v3, v8
; GFX10-FLUSH-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX10-FLUSH-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX10-FLUSH-NEXT:    v_div_fixup_f16 v0, v2, v0, 1.0
; GFX10-FLUSH-NEXT:    v_div_fixup_f16 v1, v3, v1, 1.0
; GFX10-FLUSH-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX10-FLUSH-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_rcp_v2f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX11-NEXT:    v_cvt_f32_f16_e32 v2, v0
; GFX11-NEXT:    v_cvt_f32_f16_e32 v4, 1.0
; GFX11-NEXT:    v_cvt_f32_f16_e32 v3, v1
; GFX11-NEXT:    v_rcp_f32_e32 v2, v2
; GFX11-NEXT:    v_rcp_f32_e32 v3, v3
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_mul_f32_e32 v5, v4, v2
; GFX11-NEXT:    v_mul_f32_e32 v4, v4, v3
; GFX11-NEXT:    v_fma_mix_f32 v7, -v0, v4, 1.0 op_sel:[1,0,0] op_sel_hi:[1,0,1]
; GFX11-NEXT:    v_fmac_f32_e32 v4, v7, v3
; GFX11-NEXT:    v_fma_mix_f32 v6, -v0, v5, 1.0 op_sel_hi:[1,0,1]
; GFX11-NEXT:    v_fma_mix_f32 v7, -v0, v4, 1.0 op_sel:[1,0,0] op_sel_hi:[1,0,1]
; GFX11-NEXT:    v_fmac_f32_e32 v5, v6, v2
; GFX11-NEXT:    v_mul_f32_e32 v3, v7, v3
; GFX11-NEXT:    v_fma_mix_f32 v6, -v0, v5, 1.0 op_sel_hi:[1,0,1]
; GFX11-NEXT:    v_dual_mul_f32 v2, v6, v2 :: v_dual_and_b32 v3, 0xff800000, v3
; GFX11-NEXT:    v_dual_add_f32 v3, v3, v4 :: v_dual_and_b32 v2, 0xff800000, v2
; GFX11-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX11-NEXT:    v_add_f32_e32 v2, v2, v5
; GFX11-NEXT:    v_div_fixup_f16 v1, v3, v1, 1.0
; GFX11-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX11-NEXT:    v_div_fixup_f16 v0, v2, v0, 1.0
; GFX11-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %fdiv = fdiv <2 x half> <half 1.0, half 1.0>, %x
  ret <2 x half> %fdiv
}

define <2 x half> @v_neg_rcp_v2f16(<2 x half> %x) {
; GFX6-IEEE-LABEL: v_neg_rcp_v2f16:
; GFX6-IEEE:       ; %bb.0:
; GFX6-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v2, -1.0
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX6-IEEE-NEXT:    v_div_scale_f32 v3, s[4:5], v0, v0, v2
; GFX6-IEEE-NEXT:    v_rcp_f32_e32 v4, v3
; GFX6-IEEE-NEXT:    v_div_scale_f32 v5, vcc, v2, v0, v2
; GFX6-IEEE-NEXT:    v_fma_f32 v6, -v3, v4, 1.0
; GFX6-IEEE-NEXT:    v_fma_f32 v4, v6, v4, v4
; GFX6-IEEE-NEXT:    v_mul_f32_e32 v6, v5, v4
; GFX6-IEEE-NEXT:    v_fma_f32 v7, -v3, v6, v5
; GFX6-IEEE-NEXT:    v_fma_f32 v6, v7, v4, v6
; GFX6-IEEE-NEXT:    v_fma_f32 v3, -v3, v6, v5
; GFX6-IEEE-NEXT:    v_div_fmas_f32 v3, v3, v4, v6
; GFX6-IEEE-NEXT:    v_div_fixup_f32 v0, v3, v0, v2
; GFX6-IEEE-NEXT:    v_div_scale_f32 v3, s[4:5], v1, v1, v2
; GFX6-IEEE-NEXT:    v_rcp_f32_e32 v4, v3
; GFX6-IEEE-NEXT:    v_div_scale_f32 v5, vcc, v2, v1, v2
; GFX6-IEEE-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-IEEE-NEXT:    v_fma_f32 v6, -v3, v4, 1.0
; GFX6-IEEE-NEXT:    v_fma_f32 v4, v6, v4, v4
; GFX6-IEEE-NEXT:    v_mul_f32_e32 v6, v5, v4
; GFX6-IEEE-NEXT:    v_fma_f32 v7, -v3, v6, v5
; GFX6-IEEE-NEXT:    v_fma_f32 v6, v7, v4, v6
; GFX6-IEEE-NEXT:    v_fma_f32 v3, -v3, v6, v5
; GFX6-IEEE-NEXT:    v_div_fmas_f32 v3, v3, v4, v6
; GFX6-IEEE-NEXT:    v_div_fixup_f32 v1, v3, v1, v2
; GFX6-IEEE-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX6-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-FLUSH-LABEL: v_neg_rcp_v2f16:
; GFX6-FLUSH:       ; %bb.0:
; GFX6-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v2, -1.0
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v3, s[4:5], v0, v0, v2
; GFX6-FLUSH-NEXT:    v_rcp_f32_e32 v4, v3
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v5, vcc, v2, v0, v2
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-FLUSH-NEXT:    v_fma_f32 v6, -v3, v4, 1.0
; GFX6-FLUSH-NEXT:    v_fma_f32 v4, v6, v4, v4
; GFX6-FLUSH-NEXT:    v_mul_f32_e32 v6, v5, v4
; GFX6-FLUSH-NEXT:    v_fma_f32 v7, -v3, v6, v5
; GFX6-FLUSH-NEXT:    v_fma_f32 v6, v7, v4, v6
; GFX6-FLUSH-NEXT:    v_fma_f32 v3, -v3, v6, v5
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX6-FLUSH-NEXT:    v_div_fmas_f32 v3, v3, v4, v6
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v4, -1.0
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX6-FLUSH-NEXT:    v_div_fixup_f32 v0, v3, v0, v2
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 2, 2), 0
; GFX6-FLUSH-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v2, s[4:5], v1, v1, v4
; GFX6-FLUSH-NEXT:    v_rcp_f32_e32 v3, v2
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v5, vcc, v4, v1, v4
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-FLUSH-NEXT:    v_fma_f32 v6, -v2, v3, 1.0
; GFX6-FLUSH-NEXT:    v_fma_f32 v3, v6, v3, v3
; GFX6-FLUSH-NEXT:    v_mul_f32_e32 v6, v5, v3
; GFX6-FLUSH-NEXT:    v_fma_f32 v7, -v2, v6, v5
; GFX6-FLUSH-NEXT:    v_fma_f32 v6, v7, v3, v6
; GFX6-FLUSH-NEXT:    v_fma_f32 v2, -v2, v6, v5
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX6-FLUSH-NEXT:    v_div_fmas_f32 v2, v2, v3, v6
; GFX6-FLUSH-NEXT:    v_div_fixup_f32 v1, v2, v1, v4
; GFX6-FLUSH-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX6-FLUSH-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-IEEE-LABEL: v_neg_rcp_v2f16:
; GFX8-IEEE:       ; %bb.0:
; GFX8-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-IEEE-NEXT:    v_cvt_f32_f16_e32 v1, v0
; GFX8-IEEE-NEXT:    v_lshrrev_b32_e32 v2, 16, v0
; GFX8-IEEE-NEXT:    v_cvt_f32_f16_e32 v4, -1.0
; GFX8-IEEE-NEXT:    v_cvt_f32_f16_e32 v3, v2
; GFX8-IEEE-NEXT:    v_rcp_f32_e32 v5, v1
; GFX8-IEEE-NEXT:    v_rcp_f32_e32 v6, v3
; GFX8-IEEE-NEXT:    v_mul_f32_e32 v7, v4, v5
; GFX8-IEEE-NEXT:    v_mul_f32_e64 v8, -v1, v7
; GFX8-IEEE-NEXT:    v_add_f32_e32 v8, v8, v4
; GFX8-IEEE-NEXT:    v_mul_f32_e32 v8, v8, v5
; GFX8-IEEE-NEXT:    v_add_f32_e32 v7, v8, v7
; GFX8-IEEE-NEXT:    v_mul_f32_e32 v9, v4, v6
; GFX8-IEEE-NEXT:    v_mul_f32_e64 v1, -v1, v7
; GFX8-IEEE-NEXT:    v_mul_f32_e64 v10, -v3, v9
; GFX8-IEEE-NEXT:    v_add_f32_e32 v1, v1, v4
; GFX8-IEEE-NEXT:    v_mul_f32_e32 v1, v1, v5
; GFX8-IEEE-NEXT:    v_add_f32_e32 v5, v10, v4
; GFX8-IEEE-NEXT:    v_mul_f32_e32 v5, v5, v6
; GFX8-IEEE-NEXT:    v_add_f32_e32 v5, v5, v9
; GFX8-IEEE-NEXT:    v_mul_f32_e64 v3, -v3, v5
; GFX8-IEEE-NEXT:    v_add_f32_e32 v3, v3, v4
; GFX8-IEEE-NEXT:    v_mul_f32_e32 v3, v3, v6
; GFX8-IEEE-NEXT:    v_and_b32_e32 v1, 0xff800000, v1
; GFX8-IEEE-NEXT:    v_and_b32_e32 v3, 0xff800000, v3
; GFX8-IEEE-NEXT:    v_add_f32_e32 v1, v1, v7
; GFX8-IEEE-NEXT:    v_add_f32_e32 v3, v3, v5
; GFX8-IEEE-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX8-IEEE-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX8-IEEE-NEXT:    v_div_fixup_f16 v0, v1, v0, -1.0
; GFX8-IEEE-NEXT:    v_div_fixup_f16 v1, v3, v2, -1.0
; GFX8-IEEE-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX8-IEEE-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX8-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-FLUSH-LABEL: v_neg_rcp_v2f16:
; GFX8-FLUSH:       ; %bb.0:
; GFX8-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-FLUSH-NEXT:    v_cvt_f32_f16_e32 v1, v0
; GFX8-FLUSH-NEXT:    v_lshrrev_b32_e32 v2, 16, v0
; GFX8-FLUSH-NEXT:    v_cvt_f32_f16_e32 v3, v2
; GFX8-FLUSH-NEXT:    v_cvt_f32_f16_e32 v4, -1.0
; GFX8-FLUSH-NEXT:    v_rcp_f32_e32 v5, v1
; GFX8-FLUSH-NEXT:    v_rcp_f32_e32 v6, v3
; GFX8-FLUSH-NEXT:    v_mul_f32_e32 v7, v4, v5
; GFX8-FLUSH-NEXT:    v_mad_f32 v8, -v1, v7, v4
; GFX8-FLUSH-NEXT:    v_mul_f32_e32 v9, v4, v6
; GFX8-FLUSH-NEXT:    v_mac_f32_e32 v7, v8, v5
; GFX8-FLUSH-NEXT:    v_mad_f32 v8, -v3, v9, v4
; GFX8-FLUSH-NEXT:    v_mac_f32_e32 v9, v8, v6
; GFX8-FLUSH-NEXT:    v_mad_f32 v1, -v1, v7, v4
; GFX8-FLUSH-NEXT:    v_mad_f32 v3, -v3, v9, v4
; GFX8-FLUSH-NEXT:    v_mul_f32_e32 v1, v1, v5
; GFX8-FLUSH-NEXT:    v_mul_f32_e32 v3, v3, v6
; GFX8-FLUSH-NEXT:    v_and_b32_e32 v1, 0xff800000, v1
; GFX8-FLUSH-NEXT:    v_and_b32_e32 v3, 0xff800000, v3
; GFX8-FLUSH-NEXT:    v_add_f32_e32 v1, v1, v7
; GFX8-FLUSH-NEXT:    v_add_f32_e32 v3, v3, v9
; GFX8-FLUSH-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX8-FLUSH-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX8-FLUSH-NEXT:    v_div_fixup_f16 v0, v1, v0, -1.0
; GFX8-FLUSH-NEXT:    v_div_fixup_f16 v1, v3, v2, -1.0
; GFX8-FLUSH-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX8-FLUSH-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX8-FLUSH-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-IEEE-LABEL: v_neg_rcp_v2f16:
; GFX9-IEEE:       ; %bb.0:
; GFX9-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-IEEE-NEXT:    v_cvt_f32_f16_e32 v1, v0
; GFX9-IEEE-NEXT:    v_lshrrev_b32_e32 v2, 16, v0
; GFX9-IEEE-NEXT:    v_cvt_f32_f16_e32 v4, -1.0
; GFX9-IEEE-NEXT:    v_cvt_f32_f16_e32 v3, v2
; GFX9-IEEE-NEXT:    v_rcp_f32_e32 v5, v1
; GFX9-IEEE-NEXT:    v_rcp_f32_e32 v6, v3
; GFX9-IEEE-NEXT:    v_mul_f32_e32 v7, v4, v5
; GFX9-IEEE-NEXT:    v_mul_f32_e64 v8, -v1, v7
; GFX9-IEEE-NEXT:    v_add_f32_e32 v8, v8, v4
; GFX9-IEEE-NEXT:    v_mul_f32_e32 v8, v8, v5
; GFX9-IEEE-NEXT:    v_add_f32_e32 v7, v8, v7
; GFX9-IEEE-NEXT:    v_mul_f32_e32 v9, v4, v6
; GFX9-IEEE-NEXT:    v_mul_f32_e64 v1, -v1, v7
; GFX9-IEEE-NEXT:    v_mul_f32_e64 v10, -v3, v9
; GFX9-IEEE-NEXT:    v_add_f32_e32 v1, v1, v4
; GFX9-IEEE-NEXT:    v_mul_f32_e32 v1, v1, v5
; GFX9-IEEE-NEXT:    v_add_f32_e32 v5, v10, v4
; GFX9-IEEE-NEXT:    v_mul_f32_e32 v5, v5, v6
; GFX9-IEEE-NEXT:    v_add_f32_e32 v5, v5, v9
; GFX9-IEEE-NEXT:    v_mul_f32_e64 v3, -v3, v5
; GFX9-IEEE-NEXT:    v_add_f32_e32 v3, v3, v4
; GFX9-IEEE-NEXT:    v_mul_f32_e32 v3, v3, v6
; GFX9-IEEE-NEXT:    v_and_b32_e32 v1, 0xff800000, v1
; GFX9-IEEE-NEXT:    v_and_b32_e32 v3, 0xff800000, v3
; GFX9-IEEE-NEXT:    v_add_f32_e32 v1, v1, v7
; GFX9-IEEE-NEXT:    v_add_f32_e32 v3, v3, v5
; GFX9-IEEE-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX9-IEEE-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX9-IEEE-NEXT:    v_div_fixup_f16 v0, v1, v0, -1.0
; GFX9-IEEE-NEXT:    v_div_fixup_f16 v1, v3, v2, -1.0
; GFX9-IEEE-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX9-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-FLUSH-LABEL: v_neg_rcp_v2f16:
; GFX9-FLUSH:       ; %bb.0:
; GFX9-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-FLUSH-NEXT:    v_cvt_f32_f16_e32 v1, v0
; GFX9-FLUSH-NEXT:    v_lshrrev_b32_e32 v2, 16, v0
; GFX9-FLUSH-NEXT:    v_cvt_f32_f16_e32 v3, v2
; GFX9-FLUSH-NEXT:    v_cvt_f32_f16_e32 v4, -1.0
; GFX9-FLUSH-NEXT:    v_rcp_f32_e32 v1, v1
; GFX9-FLUSH-NEXT:    v_rcp_f32_e32 v3, v3
; GFX9-FLUSH-NEXT:    v_mul_f32_e32 v5, v4, v1
; GFX9-FLUSH-NEXT:    v_mad_mix_f32 v6, -v0, v5, -1.0 op_sel_hi:[1,0,1]
; GFX9-FLUSH-NEXT:    v_mac_f32_e32 v5, v6, v1
; GFX9-FLUSH-NEXT:    v_mul_f32_e32 v4, v4, v3
; GFX9-FLUSH-NEXT:    v_mad_mix_f32 v7, -v0, v5, -1.0 op_sel_hi:[1,0,1]
; GFX9-FLUSH-NEXT:    v_mad_mix_f32 v6, -v0, v4, -1.0 op_sel:[1,0,0] op_sel_hi:[1,0,1]
; GFX9-FLUSH-NEXT:    v_mul_f32_e32 v1, v7, v1
; GFX9-FLUSH-NEXT:    v_and_b32_e32 v1, 0xff800000, v1
; GFX9-FLUSH-NEXT:    v_mac_f32_e32 v4, v6, v3
; GFX9-FLUSH-NEXT:    v_add_f32_e32 v1, v1, v5
; GFX9-FLUSH-NEXT:    v_mad_mix_f32 v5, -v0, v4, -1.0 op_sel:[1,0,0] op_sel_hi:[1,0,1]
; GFX9-FLUSH-NEXT:    v_mul_f32_e32 v3, v5, v3
; GFX9-FLUSH-NEXT:    v_and_b32_e32 v3, 0xff800000, v3
; GFX9-FLUSH-NEXT:    v_add_f32_e32 v3, v3, v4
; GFX9-FLUSH-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX9-FLUSH-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX9-FLUSH-NEXT:    v_div_fixup_f16 v0, v1, v0, -1.0
; GFX9-FLUSH-NEXT:    v_div_fixup_f16 v1, v3, v2, -1.0
; GFX9-FLUSH-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX9-FLUSH-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-IEEE-LABEL: v_neg_rcp_v2f16:
; GFX10-IEEE:       ; %bb.0:
; GFX10-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-IEEE-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX10-IEEE-NEXT:    v_cvt_f32_f16_e32 v2, v0
; GFX10-IEEE-NEXT:    v_cvt_f32_f16_e32 v6, -1.0
; GFX10-IEEE-NEXT:    v_cvt_f32_f16_e32 v3, v1
; GFX10-IEEE-NEXT:    v_rcp_f32_e32 v4, v2
; GFX10-IEEE-NEXT:    v_rcp_f32_e32 v5, v3
; GFX10-IEEE-NEXT:    v_mul_f32_e32 v7, v6, v4
; GFX10-IEEE-NEXT:    v_mul_f32_e32 v8, v6, v5
; GFX10-IEEE-NEXT:    v_mul_f32_e64 v9, -v2, v7
; GFX10-IEEE-NEXT:    v_mul_f32_e64 v10, -v3, v8
; GFX10-IEEE-NEXT:    v_add_f32_e32 v9, v9, v6
; GFX10-IEEE-NEXT:    v_add_f32_e32 v10, v10, v6
; GFX10-IEEE-NEXT:    v_mul_f32_e32 v9, v9, v4
; GFX10-IEEE-NEXT:    v_mul_f32_e32 v10, v10, v5
; GFX10-IEEE-NEXT:    v_add_f32_e32 v7, v9, v7
; GFX10-IEEE-NEXT:    v_add_f32_e32 v8, v10, v8
; GFX10-IEEE-NEXT:    v_mul_f32_e64 v2, -v2, v7
; GFX10-IEEE-NEXT:    v_mul_f32_e64 v3, -v3, v8
; GFX10-IEEE-NEXT:    v_add_f32_e32 v2, v2, v6
; GFX10-IEEE-NEXT:    v_add_f32_e32 v3, v3, v6
; GFX10-IEEE-NEXT:    v_mul_f32_e32 v2, v2, v4
; GFX10-IEEE-NEXT:    v_mul_f32_e32 v3, v3, v5
; GFX10-IEEE-NEXT:    v_and_b32_e32 v2, 0xff800000, v2
; GFX10-IEEE-NEXT:    v_and_b32_e32 v3, 0xff800000, v3
; GFX10-IEEE-NEXT:    v_add_f32_e32 v2, v2, v7
; GFX10-IEEE-NEXT:    v_add_f32_e32 v3, v3, v8
; GFX10-IEEE-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX10-IEEE-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX10-IEEE-NEXT:    v_div_fixup_f16 v0, v2, v0, -1.0
; GFX10-IEEE-NEXT:    v_div_fixup_f16 v1, v3, v1, -1.0
; GFX10-IEEE-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX10-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-FLUSH-LABEL: v_neg_rcp_v2f16:
; GFX10-FLUSH:       ; %bb.0:
; GFX10-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-FLUSH-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX10-FLUSH-NEXT:    v_cvt_f32_f16_e32 v2, v0
; GFX10-FLUSH-NEXT:    v_cvt_f32_f16_e32 v6, -1.0
; GFX10-FLUSH-NEXT:    v_cvt_f32_f16_e32 v3, v1
; GFX10-FLUSH-NEXT:    v_rcp_f32_e32 v4, v2
; GFX10-FLUSH-NEXT:    v_rcp_f32_e32 v5, v3
; GFX10-FLUSH-NEXT:    v_mul_f32_e32 v7, v6, v4
; GFX10-FLUSH-NEXT:    v_mul_f32_e32 v8, v6, v5
; GFX10-FLUSH-NEXT:    v_mad_f32 v9, -v2, v7, v6
; GFX10-FLUSH-NEXT:    v_mad_f32 v10, -v3, v8, v6
; GFX10-FLUSH-NEXT:    v_mac_f32_e32 v7, v9, v4
; GFX10-FLUSH-NEXT:    v_mac_f32_e32 v8, v10, v5
; GFX10-FLUSH-NEXT:    v_mad_f32 v2, -v2, v7, v6
; GFX10-FLUSH-NEXT:    v_mad_f32 v3, -v3, v8, v6
; GFX10-FLUSH-NEXT:    v_mul_f32_e32 v2, v2, v4
; GFX10-FLUSH-NEXT:    v_mul_f32_e32 v3, v3, v5
; GFX10-FLUSH-NEXT:    v_and_b32_e32 v2, 0xff800000, v2
; GFX10-FLUSH-NEXT:    v_and_b32_e32 v3, 0xff800000, v3
; GFX10-FLUSH-NEXT:    v_add_f32_e32 v2, v2, v7
; GFX10-FLUSH-NEXT:    v_add_f32_e32 v3, v3, v8
; GFX10-FLUSH-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX10-FLUSH-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX10-FLUSH-NEXT:    v_div_fixup_f16 v0, v2, v0, -1.0
; GFX10-FLUSH-NEXT:    v_div_fixup_f16 v1, v3, v1, -1.0
; GFX10-FLUSH-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX10-FLUSH-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_neg_rcp_v2f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX11-NEXT:    v_cvt_f32_f16_e32 v2, v0
; GFX11-NEXT:    v_cvt_f32_f16_e32 v4, -1.0
; GFX11-NEXT:    v_cvt_f32_f16_e32 v3, v1
; GFX11-NEXT:    v_rcp_f32_e32 v2, v2
; GFX11-NEXT:    v_rcp_f32_e32 v3, v3
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_mul_f32_e32 v5, v4, v2
; GFX11-NEXT:    v_mul_f32_e32 v4, v4, v3
; GFX11-NEXT:    v_fma_mix_f32 v7, -v0, v4, -1.0 op_sel:[1,0,0] op_sel_hi:[1,0,1]
; GFX11-NEXT:    v_fmac_f32_e32 v4, v7, v3
; GFX11-NEXT:    v_fma_mix_f32 v6, -v0, v5, -1.0 op_sel_hi:[1,0,1]
; GFX11-NEXT:    v_fma_mix_f32 v7, -v0, v4, -1.0 op_sel:[1,0,0] op_sel_hi:[1,0,1]
; GFX11-NEXT:    v_fmac_f32_e32 v5, v6, v2
; GFX11-NEXT:    v_mul_f32_e32 v3, v7, v3
; GFX11-NEXT:    v_fma_mix_f32 v6, -v0, v5, -1.0 op_sel_hi:[1,0,1]
; GFX11-NEXT:    v_dual_mul_f32 v2, v6, v2 :: v_dual_and_b32 v3, 0xff800000, v3
; GFX11-NEXT:    v_dual_add_f32 v3, v3, v4 :: v_dual_and_b32 v2, 0xff800000, v2
; GFX11-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX11-NEXT:    v_add_f32_e32 v2, v2, v5
; GFX11-NEXT:    v_div_fixup_f16 v1, v3, v1, -1.0
; GFX11-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX11-NEXT:    v_div_fixup_f16 v0, v2, v0, -1.0
; GFX11-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %fdiv = fdiv <2 x half> <half -1.0, half -1.0>, %x
  ret <2 x half> %fdiv
}

define <2 x half> @v_rcp_v2f16_fabs(<2 x half> %x) {
; GFX6-IEEE-LABEL: v_rcp_v2f16_fabs:
; GFX6-IEEE:       ; %bb.0:
; GFX6-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-IEEE-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX6-IEEE-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX6-IEEE-NEXT:    v_or_b32_e32 v0, v1, v0
; GFX6-IEEE-NEXT:    v_and_b32_e32 v0, 0x7fff7fff, v0
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v1, 1.0
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v2, v0
; GFX6-IEEE-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX6-IEEE-NEXT:    v_div_scale_f32 v3, s[4:5], v2, v2, v1
; GFX6-IEEE-NEXT:    v_rcp_f32_e32 v4, v3
; GFX6-IEEE-NEXT:    v_div_scale_f32 v5, vcc, v1, v2, v1
; GFX6-IEEE-NEXT:    v_fma_f32 v6, -v3, v4, 1.0
; GFX6-IEEE-NEXT:    v_fma_f32 v4, v6, v4, v4
; GFX6-IEEE-NEXT:    v_mul_f32_e32 v6, v5, v4
; GFX6-IEEE-NEXT:    v_fma_f32 v7, -v3, v6, v5
; GFX6-IEEE-NEXT:    v_fma_f32 v6, v7, v4, v6
; GFX6-IEEE-NEXT:    v_fma_f32 v3, -v3, v6, v5
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v5, v0
; GFX6-IEEE-NEXT:    v_div_fmas_f32 v0, v3, v4, v6
; GFX6-IEEE-NEXT:    v_div_fixup_f32 v0, v0, v2, v1
; GFX6-IEEE-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-IEEE-NEXT:    v_div_scale_f32 v2, s[4:5], v5, v5, v1
; GFX6-IEEE-NEXT:    v_rcp_f32_e32 v3, v2
; GFX6-IEEE-NEXT:    v_div_scale_f32 v4, vcc, v1, v5, v1
; GFX6-IEEE-NEXT:    v_fma_f32 v6, -v2, v3, 1.0
; GFX6-IEEE-NEXT:    v_fma_f32 v3, v6, v3, v3
; GFX6-IEEE-NEXT:    v_mul_f32_e32 v6, v4, v3
; GFX6-IEEE-NEXT:    v_fma_f32 v7, -v2, v6, v4
; GFX6-IEEE-NEXT:    v_fma_f32 v6, v7, v3, v6
; GFX6-IEEE-NEXT:    v_fma_f32 v2, -v2, v6, v4
; GFX6-IEEE-NEXT:    v_div_fmas_f32 v2, v2, v3, v6
; GFX6-IEEE-NEXT:    v_div_fixup_f32 v1, v2, v5, v1
; GFX6-IEEE-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX6-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-FLUSH-LABEL: v_rcp_v2f16_fabs:
; GFX6-FLUSH:       ; %bb.0:
; GFX6-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-FLUSH-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX6-FLUSH-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX6-FLUSH-NEXT:    v_or_b32_e32 v0, v1, v0
; GFX6-FLUSH-NEXT:    v_and_b32_e32 v0, 0x7fff7fff, v0
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v1, 1.0
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v2, v0
; GFX6-FLUSH-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v3, s[4:5], v2, v2, v1
; GFX6-FLUSH-NEXT:    v_rcp_f32_e32 v4, v3
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v5, vcc, v1, v2, v1
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-FLUSH-NEXT:    v_fma_f32 v6, -v3, v4, 1.0
; GFX6-FLUSH-NEXT:    v_fma_f32 v4, v6, v4, v4
; GFX6-FLUSH-NEXT:    v_mul_f32_e32 v6, v5, v4
; GFX6-FLUSH-NEXT:    v_fma_f32 v7, -v3, v6, v5
; GFX6-FLUSH-NEXT:    v_fma_f32 v6, v7, v4, v6
; GFX6-FLUSH-NEXT:    v_fma_f32 v3, -v3, v6, v5
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX6-FLUSH-NEXT:    v_div_fmas_f32 v3, v3, v4, v6
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v4, 1.0
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v5, v0
; GFX6-FLUSH-NEXT:    v_div_fixup_f32 v0, v3, v2, v1
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 2, 2), 0
; GFX6-FLUSH-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v1, s[4:5], v5, v5, v4
; GFX6-FLUSH-NEXT:    v_rcp_f32_e32 v2, v1
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v3, vcc, v4, v5, v4
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-FLUSH-NEXT:    v_fma_f32 v6, -v1, v2, 1.0
; GFX6-FLUSH-NEXT:    v_fma_f32 v2, v6, v2, v2
; GFX6-FLUSH-NEXT:    v_mul_f32_e32 v6, v3, v2
; GFX6-FLUSH-NEXT:    v_fma_f32 v7, -v1, v6, v3
; GFX6-FLUSH-NEXT:    v_fma_f32 v6, v7, v2, v6
; GFX6-FLUSH-NEXT:    v_fma_f32 v1, -v1, v6, v3
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX6-FLUSH-NEXT:    v_div_fmas_f32 v1, v1, v2, v6
; GFX6-FLUSH-NEXT:    v_div_fixup_f32 v1, v1, v5, v4
; GFX6-FLUSH-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX6-FLUSH-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-IEEE-LABEL: v_rcp_v2f16_fabs:
; GFX8-IEEE:       ; %bb.0:
; GFX8-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-IEEE-NEXT:    v_and_b32_e32 v0, 0x7fff7fff, v0
; GFX8-IEEE-NEXT:    v_cvt_f32_f16_e32 v1, v0
; GFX8-IEEE-NEXT:    v_lshrrev_b32_e32 v2, 16, v0
; GFX8-IEEE-NEXT:    v_cvt_f32_f16_e32 v4, 1.0
; GFX8-IEEE-NEXT:    v_cvt_f32_f16_e32 v3, v2
; GFX8-IEEE-NEXT:    v_rcp_f32_e32 v5, v1
; GFX8-IEEE-NEXT:    v_rcp_f32_e32 v6, v3
; GFX8-IEEE-NEXT:    v_mul_f32_e32 v7, v4, v5
; GFX8-IEEE-NEXT:    v_mul_f32_e64 v8, -v1, v7
; GFX8-IEEE-NEXT:    v_add_f32_e32 v8, v8, v4
; GFX8-IEEE-NEXT:    v_mul_f32_e32 v8, v8, v5
; GFX8-IEEE-NEXT:    v_add_f32_e32 v7, v8, v7
; GFX8-IEEE-NEXT:    v_mul_f32_e32 v9, v4, v6
; GFX8-IEEE-NEXT:    v_mul_f32_e64 v1, -v1, v7
; GFX8-IEEE-NEXT:    v_mul_f32_e64 v10, -v3, v9
; GFX8-IEEE-NEXT:    v_add_f32_e32 v1, v1, v4
; GFX8-IEEE-NEXT:    v_mul_f32_e32 v1, v1, v5
; GFX8-IEEE-NEXT:    v_add_f32_e32 v5, v10, v4
; GFX8-IEEE-NEXT:    v_mul_f32_e32 v5, v5, v6
; GFX8-IEEE-NEXT:    v_add_f32_e32 v5, v5, v9
; GFX8-IEEE-NEXT:    v_mul_f32_e64 v3, -v3, v5
; GFX8-IEEE-NEXT:    v_add_f32_e32 v3, v3, v4
; GFX8-IEEE-NEXT:    v_mul_f32_e32 v3, v3, v6
; GFX8-IEEE-NEXT:    v_and_b32_e32 v1, 0xff800000, v1
; GFX8-IEEE-NEXT:    v_and_b32_e32 v3, 0xff800000, v3
; GFX8-IEEE-NEXT:    v_add_f32_e32 v1, v1, v7
; GFX8-IEEE-NEXT:    v_add_f32_e32 v3, v3, v5
; GFX8-IEEE-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX8-IEEE-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX8-IEEE-NEXT:    v_div_fixup_f16 v0, v1, v0, 1.0
; GFX8-IEEE-NEXT:    v_div_fixup_f16 v1, v3, v2, 1.0
; GFX8-IEEE-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX8-IEEE-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX8-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-FLUSH-LABEL: v_rcp_v2f16_fabs:
; GFX8-FLUSH:       ; %bb.0:
; GFX8-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-FLUSH-NEXT:    v_and_b32_e32 v0, 0x7fff7fff, v0
; GFX8-FLUSH-NEXT:    v_cvt_f32_f16_e32 v1, v0
; GFX8-FLUSH-NEXT:    v_lshrrev_b32_e32 v2, 16, v0
; GFX8-FLUSH-NEXT:    v_cvt_f32_f16_e32 v3, v2
; GFX8-FLUSH-NEXT:    v_cvt_f32_f16_e32 v4, 1.0
; GFX8-FLUSH-NEXT:    v_rcp_f32_e32 v5, v1
; GFX8-FLUSH-NEXT:    v_rcp_f32_e32 v6, v3
; GFX8-FLUSH-NEXT:    v_mul_f32_e32 v7, v4, v5
; GFX8-FLUSH-NEXT:    v_mad_f32 v8, -v1, v7, v4
; GFX8-FLUSH-NEXT:    v_mul_f32_e32 v9, v4, v6
; GFX8-FLUSH-NEXT:    v_mac_f32_e32 v7, v8, v5
; GFX8-FLUSH-NEXT:    v_mad_f32 v8, -v3, v9, v4
; GFX8-FLUSH-NEXT:    v_mac_f32_e32 v9, v8, v6
; GFX8-FLUSH-NEXT:    v_mad_f32 v1, -v1, v7, v4
; GFX8-FLUSH-NEXT:    v_mad_f32 v3, -v3, v9, v4
; GFX8-FLUSH-NEXT:    v_mul_f32_e32 v1, v1, v5
; GFX8-FLUSH-NEXT:    v_mul_f32_e32 v3, v3, v6
; GFX8-FLUSH-NEXT:    v_and_b32_e32 v1, 0xff800000, v1
; GFX8-FLUSH-NEXT:    v_and_b32_e32 v3, 0xff800000, v3
; GFX8-FLUSH-NEXT:    v_add_f32_e32 v1, v1, v7
; GFX8-FLUSH-NEXT:    v_add_f32_e32 v3, v3, v9
; GFX8-FLUSH-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX8-FLUSH-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX8-FLUSH-NEXT:    v_div_fixup_f16 v0, v1, v0, 1.0
; GFX8-FLUSH-NEXT:    v_div_fixup_f16 v1, v3, v2, 1.0
; GFX8-FLUSH-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX8-FLUSH-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX8-FLUSH-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-IEEE-LABEL: v_rcp_v2f16_fabs:
; GFX9-IEEE:       ; %bb.0:
; GFX9-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-IEEE-NEXT:    v_and_b32_e32 v0, 0x7fff7fff, v0
; GFX9-IEEE-NEXT:    v_cvt_f32_f16_e32 v1, v0
; GFX9-IEEE-NEXT:    v_lshrrev_b32_e32 v2, 16, v0
; GFX9-IEEE-NEXT:    v_cvt_f32_f16_e32 v4, 1.0
; GFX9-IEEE-NEXT:    v_cvt_f32_f16_e32 v3, v2
; GFX9-IEEE-NEXT:    v_rcp_f32_e32 v5, v1
; GFX9-IEEE-NEXT:    v_rcp_f32_e32 v6, v3
; GFX9-IEEE-NEXT:    v_mul_f32_e32 v7, v4, v5
; GFX9-IEEE-NEXT:    v_mul_f32_e64 v8, -v1, v7
; GFX9-IEEE-NEXT:    v_add_f32_e32 v8, v8, v4
; GFX9-IEEE-NEXT:    v_mul_f32_e32 v8, v8, v5
; GFX9-IEEE-NEXT:    v_add_f32_e32 v7, v8, v7
; GFX9-IEEE-NEXT:    v_mul_f32_e32 v9, v4, v6
; GFX9-IEEE-NEXT:    v_mul_f32_e64 v1, -v1, v7
; GFX9-IEEE-NEXT:    v_mul_f32_e64 v10, -v3, v9
; GFX9-IEEE-NEXT:    v_add_f32_e32 v1, v1, v4
; GFX9-IEEE-NEXT:    v_mul_f32_e32 v1, v1, v5
; GFX9-IEEE-NEXT:    v_add_f32_e32 v5, v10, v4
; GFX9-IEEE-NEXT:    v_mul_f32_e32 v5, v5, v6
; GFX9-IEEE-NEXT:    v_add_f32_e32 v5, v5, v9
; GFX9-IEEE-NEXT:    v_mul_f32_e64 v3, -v3, v5
; GFX9-IEEE-NEXT:    v_add_f32_e32 v3, v3, v4
; GFX9-IEEE-NEXT:    v_mul_f32_e32 v3, v3, v6
; GFX9-IEEE-NEXT:    v_and_b32_e32 v1, 0xff800000, v1
; GFX9-IEEE-NEXT:    v_and_b32_e32 v3, 0xff800000, v3
; GFX9-IEEE-NEXT:    v_add_f32_e32 v1, v1, v7
; GFX9-IEEE-NEXT:    v_add_f32_e32 v3, v3, v5
; GFX9-IEEE-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX9-IEEE-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX9-IEEE-NEXT:    v_div_fixup_f16 v0, v1, v0, 1.0
; GFX9-IEEE-NEXT:    v_div_fixup_f16 v1, v3, v2, 1.0
; GFX9-IEEE-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX9-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-FLUSH-LABEL: v_rcp_v2f16_fabs:
; GFX9-FLUSH:       ; %bb.0:
; GFX9-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-FLUSH-NEXT:    v_and_b32_e32 v1, 0x7fff7fff, v0
; GFX9-FLUSH-NEXT:    v_cvt_f32_f16_e32 v2, v1
; GFX9-FLUSH-NEXT:    v_lshrrev_b32_e32 v3, 16, v1
; GFX9-FLUSH-NEXT:    v_cvt_f32_f16_e32 v4, v3
; GFX9-FLUSH-NEXT:    v_cvt_f32_f16_e32 v5, 1.0
; GFX9-FLUSH-NEXT:    v_rcp_f32_e32 v2, v2
; GFX9-FLUSH-NEXT:    v_rcp_f32_e32 v4, v4
; GFX9-FLUSH-NEXT:    v_mul_f32_e32 v6, v5, v2
; GFX9-FLUSH-NEXT:    v_mad_mix_f32 v7, -v1, v6, 1.0 op_sel_hi:[1,0,1]
; GFX9-FLUSH-NEXT:    v_mul_f32_e32 v5, v5, v4
; GFX9-FLUSH-NEXT:    v_mac_f32_e32 v6, v7, v2
; GFX9-FLUSH-NEXT:    v_mad_mix_f32 v7, -|v0|, v5, 1.0 op_sel:[1,0,0] op_sel_hi:[1,0,1]
; GFX9-FLUSH-NEXT:    v_mac_f32_e32 v5, v7, v4
; GFX9-FLUSH-NEXT:    v_mad_mix_f32 v8, -v1, v6, 1.0 op_sel_hi:[1,0,1]
; GFX9-FLUSH-NEXT:    v_mad_mix_f32 v0, -|v0|, v5, 1.0 op_sel:[1,0,0] op_sel_hi:[1,0,1]
; GFX9-FLUSH-NEXT:    v_mul_f32_e32 v2, v8, v2
; GFX9-FLUSH-NEXT:    v_mul_f32_e32 v0, v0, v4
; GFX9-FLUSH-NEXT:    v_and_b32_e32 v2, 0xff800000, v2
; GFX9-FLUSH-NEXT:    v_and_b32_e32 v0, 0xff800000, v0
; GFX9-FLUSH-NEXT:    v_add_f32_e32 v2, v2, v6
; GFX9-FLUSH-NEXT:    v_add_f32_e32 v0, v0, v5
; GFX9-FLUSH-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX9-FLUSH-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX9-FLUSH-NEXT:    v_div_fixup_f16 v1, v2, v1, 1.0
; GFX9-FLUSH-NEXT:    v_div_fixup_f16 v0, v0, v3, 1.0
; GFX9-FLUSH-NEXT:    v_pack_b32_f16 v0, v1, v0
; GFX9-FLUSH-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-IEEE-LABEL: v_rcp_v2f16_fabs:
; GFX10-IEEE:       ; %bb.0:
; GFX10-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-IEEE-NEXT:    v_and_b32_e32 v0, 0x7fff7fff, v0
; GFX10-IEEE-NEXT:    v_cvt_f32_f16_e32 v6, 1.0
; GFX10-IEEE-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX10-IEEE-NEXT:    v_cvt_f32_f16_e32 v2, v0
; GFX10-IEEE-NEXT:    v_cvt_f32_f16_e32 v3, v1
; GFX10-IEEE-NEXT:    v_rcp_f32_e32 v4, v2
; GFX10-IEEE-NEXT:    v_rcp_f32_e32 v5, v3
; GFX10-IEEE-NEXT:    v_mul_f32_e32 v7, v6, v4
; GFX10-IEEE-NEXT:    v_mul_f32_e32 v8, v6, v5
; GFX10-IEEE-NEXT:    v_mul_f32_e64 v9, -v2, v7
; GFX10-IEEE-NEXT:    v_mul_f32_e64 v10, -v3, v8
; GFX10-IEEE-NEXT:    v_add_f32_e32 v9, v9, v6
; GFX10-IEEE-NEXT:    v_add_f32_e32 v10, v10, v6
; GFX10-IEEE-NEXT:    v_mul_f32_e32 v9, v9, v4
; GFX10-IEEE-NEXT:    v_mul_f32_e32 v10, v10, v5
; GFX10-IEEE-NEXT:    v_add_f32_e32 v7, v9, v7
; GFX10-IEEE-NEXT:    v_add_f32_e32 v8, v10, v8
; GFX10-IEEE-NEXT:    v_mul_f32_e64 v2, -v2, v7
; GFX10-IEEE-NEXT:    v_mul_f32_e64 v3, -v3, v8
; GFX10-IEEE-NEXT:    v_add_f32_e32 v2, v2, v6
; GFX10-IEEE-NEXT:    v_add_f32_e32 v3, v3, v6
; GFX10-IEEE-NEXT:    v_mul_f32_e32 v2, v2, v4
; GFX10-IEEE-NEXT:    v_mul_f32_e32 v3, v3, v5
; GFX10-IEEE-NEXT:    v_and_b32_e32 v2, 0xff800000, v2
; GFX10-IEEE-NEXT:    v_and_b32_e32 v3, 0xff800000, v3
; GFX10-IEEE-NEXT:    v_add_f32_e32 v2, v2, v7
; GFX10-IEEE-NEXT:    v_add_f32_e32 v3, v3, v8
; GFX10-IEEE-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX10-IEEE-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX10-IEEE-NEXT:    v_div_fixup_f16 v0, v2, v0, 1.0
; GFX10-IEEE-NEXT:    v_div_fixup_f16 v1, v3, v1, 1.0
; GFX10-IEEE-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX10-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-FLUSH-LABEL: v_rcp_v2f16_fabs:
; GFX10-FLUSH:       ; %bb.0:
; GFX10-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-FLUSH-NEXT:    v_and_b32_e32 v0, 0x7fff7fff, v0
; GFX10-FLUSH-NEXT:    v_cvt_f32_f16_e32 v6, 1.0
; GFX10-FLUSH-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX10-FLUSH-NEXT:    v_cvt_f32_f16_e32 v2, v0
; GFX10-FLUSH-NEXT:    v_cvt_f32_f16_e32 v3, v1
; GFX10-FLUSH-NEXT:    v_rcp_f32_e32 v4, v2
; GFX10-FLUSH-NEXT:    v_rcp_f32_e32 v5, v3
; GFX10-FLUSH-NEXT:    v_mul_f32_e32 v7, v6, v4
; GFX10-FLUSH-NEXT:    v_mul_f32_e32 v8, v6, v5
; GFX10-FLUSH-NEXT:    v_mad_f32 v9, -v2, v7, v6
; GFX10-FLUSH-NEXT:    v_mad_f32 v10, -v3, v8, v6
; GFX10-FLUSH-NEXT:    v_mac_f32_e32 v7, v9, v4
; GFX10-FLUSH-NEXT:    v_mac_f32_e32 v8, v10, v5
; GFX10-FLUSH-NEXT:    v_mad_f32 v2, -v2, v7, v6
; GFX10-FLUSH-NEXT:    v_mad_f32 v3, -v3, v8, v6
; GFX10-FLUSH-NEXT:    v_mul_f32_e32 v2, v2, v4
; GFX10-FLUSH-NEXT:    v_mul_f32_e32 v3, v3, v5
; GFX10-FLUSH-NEXT:    v_and_b32_e32 v2, 0xff800000, v2
; GFX10-FLUSH-NEXT:    v_and_b32_e32 v3, 0xff800000, v3
; GFX10-FLUSH-NEXT:    v_add_f32_e32 v2, v2, v7
; GFX10-FLUSH-NEXT:    v_add_f32_e32 v3, v3, v8
; GFX10-FLUSH-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX10-FLUSH-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX10-FLUSH-NEXT:    v_div_fixup_f16 v0, v2, v0, 1.0
; GFX10-FLUSH-NEXT:    v_div_fixup_f16 v1, v3, v1, 1.0
; GFX10-FLUSH-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX10-FLUSH-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_rcp_v2f16_fabs:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_cvt_f32_f16_e32 v5, 1.0
; GFX11-NEXT:    v_and_b32_e32 v1, 0x7fff7fff, v0
; GFX11-NEXT:    v_cvt_f32_f16_e32 v3, v1
; GFX11-NEXT:    v_rcp_f32_e32 v3, v3
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_mul_f32_e32 v6, v5, v3
; GFX11-NEXT:    v_lshrrev_b32_e32 v2, 16, v1
; GFX11-NEXT:    v_fma_mix_f32 v7, -v1, v6, 1.0 op_sel_hi:[1,0,1]
; GFX11-NEXT:    v_cvt_f32_f16_e32 v4, v2
; GFX11-NEXT:    v_fmac_f32_e32 v6, v7, v3
; GFX11-NEXT:    v_rcp_f32_e32 v4, v4
; GFX11-NEXT:    v_fma_mix_f32 v7, -v1, v6, 1.0 op_sel_hi:[1,0,1]
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_mul_f32_e32 v5, v5, v4
; GFX11-NEXT:    v_fma_mix_f32 v8, -|v0|, v5, 1.0 op_sel:[1,0,0] op_sel_hi:[1,0,1]
; GFX11-NEXT:    v_fmac_f32_e32 v5, v8, v4
; GFX11-NEXT:    v_fma_mix_f32 v0, -|v0|, v5, 1.0 op_sel:[1,0,0] op_sel_hi:[1,0,1]
; GFX11-NEXT:    v_dual_mul_f32 v3, v7, v3 :: v_dual_mul_f32 v0, v0, v4
; GFX11-NEXT:    v_and_b32_e32 v0, 0xff800000, v0
; GFX11-NEXT:    v_dual_add_f32 v0, v0, v5 :: v_dual_and_b32 v3, 0xff800000, v3
; GFX11-NEXT:    v_add_f32_e32 v3, v3, v6
; GFX11-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX11-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX11-NEXT:    v_div_fixup_f16 v0, v0, v2, 1.0
; GFX11-NEXT:    v_div_fixup_f16 v1, v3, v1, 1.0
; GFX11-NEXT:    v_pack_b32_f16 v0, v1, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %x.fabs = call <2 x half> @llvm.fabs.v2f16(<2 x half> %x)
  %fdiv = fdiv <2 x half> <half 1.0, half 1.0>, %x.fabs
  ret <2 x half> %fdiv
}

define <2 x half> @v_neg_rcp_v2f16_fabs(<2 x half> %x) {
; GFX6-IEEE-LABEL: v_neg_rcp_v2f16_fabs:
; GFX6-IEEE:       ; %bb.0:
; GFX6-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-IEEE-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX6-IEEE-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX6-IEEE-NEXT:    v_or_b32_e32 v0, v1, v0
; GFX6-IEEE-NEXT:    v_and_b32_e32 v0, 0x7fff7fff, v0
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v1, -1.0
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v2, v0
; GFX6-IEEE-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX6-IEEE-NEXT:    v_div_scale_f32 v3, s[4:5], v2, v2, v1
; GFX6-IEEE-NEXT:    v_rcp_f32_e32 v4, v3
; GFX6-IEEE-NEXT:    v_div_scale_f32 v5, vcc, v1, v2, v1
; GFX6-IEEE-NEXT:    v_fma_f32 v6, -v3, v4, 1.0
; GFX6-IEEE-NEXT:    v_fma_f32 v4, v6, v4, v4
; GFX6-IEEE-NEXT:    v_mul_f32_e32 v6, v5, v4
; GFX6-IEEE-NEXT:    v_fma_f32 v7, -v3, v6, v5
; GFX6-IEEE-NEXT:    v_fma_f32 v6, v7, v4, v6
; GFX6-IEEE-NEXT:    v_fma_f32 v3, -v3, v6, v5
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v5, v0
; GFX6-IEEE-NEXT:    v_div_fmas_f32 v0, v3, v4, v6
; GFX6-IEEE-NEXT:    v_div_fixup_f32 v0, v0, v2, v1
; GFX6-IEEE-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-IEEE-NEXT:    v_div_scale_f32 v2, s[4:5], v5, v5, v1
; GFX6-IEEE-NEXT:    v_rcp_f32_e32 v3, v2
; GFX6-IEEE-NEXT:    v_div_scale_f32 v4, vcc, v1, v5, v1
; GFX6-IEEE-NEXT:    v_fma_f32 v6, -v2, v3, 1.0
; GFX6-IEEE-NEXT:    v_fma_f32 v3, v6, v3, v3
; GFX6-IEEE-NEXT:    v_mul_f32_e32 v6, v4, v3
; GFX6-IEEE-NEXT:    v_fma_f32 v7, -v2, v6, v4
; GFX6-IEEE-NEXT:    v_fma_f32 v6, v7, v3, v6
; GFX6-IEEE-NEXT:    v_fma_f32 v2, -v2, v6, v4
; GFX6-IEEE-NEXT:    v_div_fmas_f32 v2, v2, v3, v6
; GFX6-IEEE-NEXT:    v_div_fixup_f32 v1, v2, v5, v1
; GFX6-IEEE-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX6-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-FLUSH-LABEL: v_neg_rcp_v2f16_fabs:
; GFX6-FLUSH:       ; %bb.0:
; GFX6-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-FLUSH-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX6-FLUSH-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX6-FLUSH-NEXT:    v_or_b32_e32 v0, v1, v0
; GFX6-FLUSH-NEXT:    v_and_b32_e32 v0, 0x7fff7fff, v0
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v1, -1.0
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v2, v0
; GFX6-FLUSH-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v3, s[4:5], v2, v2, v1
; GFX6-FLUSH-NEXT:    v_rcp_f32_e32 v4, v3
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v5, vcc, v1, v2, v1
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-FLUSH-NEXT:    v_fma_f32 v6, -v3, v4, 1.0
; GFX6-FLUSH-NEXT:    v_fma_f32 v4, v6, v4, v4
; GFX6-FLUSH-NEXT:    v_mul_f32_e32 v6, v5, v4
; GFX6-FLUSH-NEXT:    v_fma_f32 v7, -v3, v6, v5
; GFX6-FLUSH-NEXT:    v_fma_f32 v6, v7, v4, v6
; GFX6-FLUSH-NEXT:    v_fma_f32 v3, -v3, v6, v5
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX6-FLUSH-NEXT:    v_div_fmas_f32 v3, v3, v4, v6
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v4, -1.0
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v5, v0
; GFX6-FLUSH-NEXT:    v_div_fixup_f32 v0, v3, v2, v1
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 2, 2), 0
; GFX6-FLUSH-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v1, s[4:5], v5, v5, v4
; GFX6-FLUSH-NEXT:    v_rcp_f32_e32 v2, v1
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v3, vcc, v4, v5, v4
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-FLUSH-NEXT:    v_fma_f32 v6, -v1, v2, 1.0
; GFX6-FLUSH-NEXT:    v_fma_f32 v2, v6, v2, v2
; GFX6-FLUSH-NEXT:    v_mul_f32_e32 v6, v3, v2
; GFX6-FLUSH-NEXT:    v_fma_f32 v7, -v1, v6, v3
; GFX6-FLUSH-NEXT:    v_fma_f32 v6, v7, v2, v6
; GFX6-FLUSH-NEXT:    v_fma_f32 v1, -v1, v6, v3
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX6-FLUSH-NEXT:    v_div_fmas_f32 v1, v1, v2, v6
; GFX6-FLUSH-NEXT:    v_div_fixup_f32 v1, v1, v5, v4
; GFX6-FLUSH-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX6-FLUSH-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-IEEE-LABEL: v_neg_rcp_v2f16_fabs:
; GFX8-IEEE:       ; %bb.0:
; GFX8-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-IEEE-NEXT:    v_and_b32_e32 v0, 0x7fff7fff, v0
; GFX8-IEEE-NEXT:    v_cvt_f32_f16_e32 v1, v0
; GFX8-IEEE-NEXT:    v_lshrrev_b32_e32 v2, 16, v0
; GFX8-IEEE-NEXT:    v_cvt_f32_f16_e32 v4, -1.0
; GFX8-IEEE-NEXT:    v_cvt_f32_f16_e32 v3, v2
; GFX8-IEEE-NEXT:    v_rcp_f32_e32 v5, v1
; GFX8-IEEE-NEXT:    v_rcp_f32_e32 v6, v3
; GFX8-IEEE-NEXT:    v_mul_f32_e32 v7, v4, v5
; GFX8-IEEE-NEXT:    v_mul_f32_e64 v8, -v1, v7
; GFX8-IEEE-NEXT:    v_add_f32_e32 v8, v8, v4
; GFX8-IEEE-NEXT:    v_mul_f32_e32 v8, v8, v5
; GFX8-IEEE-NEXT:    v_add_f32_e32 v7, v8, v7
; GFX8-IEEE-NEXT:    v_mul_f32_e32 v9, v4, v6
; GFX8-IEEE-NEXT:    v_mul_f32_e64 v1, -v1, v7
; GFX8-IEEE-NEXT:    v_mul_f32_e64 v10, -v3, v9
; GFX8-IEEE-NEXT:    v_add_f32_e32 v1, v1, v4
; GFX8-IEEE-NEXT:    v_mul_f32_e32 v1, v1, v5
; GFX8-IEEE-NEXT:    v_add_f32_e32 v5, v10, v4
; GFX8-IEEE-NEXT:    v_mul_f32_e32 v5, v5, v6
; GFX8-IEEE-NEXT:    v_add_f32_e32 v5, v5, v9
; GFX8-IEEE-NEXT:    v_mul_f32_e64 v3, -v3, v5
; GFX8-IEEE-NEXT:    v_add_f32_e32 v3, v3, v4
; GFX8-IEEE-NEXT:    v_mul_f32_e32 v3, v3, v6
; GFX8-IEEE-NEXT:    v_and_b32_e32 v1, 0xff800000, v1
; GFX8-IEEE-NEXT:    v_and_b32_e32 v3, 0xff800000, v3
; GFX8-IEEE-NEXT:    v_add_f32_e32 v1, v1, v7
; GFX8-IEEE-NEXT:    v_add_f32_e32 v3, v3, v5
; GFX8-IEEE-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX8-IEEE-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX8-IEEE-NEXT:    v_div_fixup_f16 v0, v1, v0, -1.0
; GFX8-IEEE-NEXT:    v_div_fixup_f16 v1, v3, v2, -1.0
; GFX8-IEEE-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX8-IEEE-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX8-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-FLUSH-LABEL: v_neg_rcp_v2f16_fabs:
; GFX8-FLUSH:       ; %bb.0:
; GFX8-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-FLUSH-NEXT:    v_and_b32_e32 v0, 0x7fff7fff, v0
; GFX8-FLUSH-NEXT:    v_cvt_f32_f16_e32 v1, v0
; GFX8-FLUSH-NEXT:    v_lshrrev_b32_e32 v2, 16, v0
; GFX8-FLUSH-NEXT:    v_cvt_f32_f16_e32 v3, v2
; GFX8-FLUSH-NEXT:    v_cvt_f32_f16_e32 v4, -1.0
; GFX8-FLUSH-NEXT:    v_rcp_f32_e32 v5, v1
; GFX8-FLUSH-NEXT:    v_rcp_f32_e32 v6, v3
; GFX8-FLUSH-NEXT:    v_mul_f32_e32 v7, v4, v5
; GFX8-FLUSH-NEXT:    v_mad_f32 v8, -v1, v7, v4
; GFX8-FLUSH-NEXT:    v_mul_f32_e32 v9, v4, v6
; GFX8-FLUSH-NEXT:    v_mac_f32_e32 v7, v8, v5
; GFX8-FLUSH-NEXT:    v_mad_f32 v8, -v3, v9, v4
; GFX8-FLUSH-NEXT:    v_mac_f32_e32 v9, v8, v6
; GFX8-FLUSH-NEXT:    v_mad_f32 v1, -v1, v7, v4
; GFX8-FLUSH-NEXT:    v_mad_f32 v3, -v3, v9, v4
; GFX8-FLUSH-NEXT:    v_mul_f32_e32 v1, v1, v5
; GFX8-FLUSH-NEXT:    v_mul_f32_e32 v3, v3, v6
; GFX8-FLUSH-NEXT:    v_and_b32_e32 v1, 0xff800000, v1
; GFX8-FLUSH-NEXT:    v_and_b32_e32 v3, 0xff800000, v3
; GFX8-FLUSH-NEXT:    v_add_f32_e32 v1, v1, v7
; GFX8-FLUSH-NEXT:    v_add_f32_e32 v3, v3, v9
; GFX8-FLUSH-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX8-FLUSH-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX8-FLUSH-NEXT:    v_div_fixup_f16 v0, v1, v0, -1.0
; GFX8-FLUSH-NEXT:    v_div_fixup_f16 v1, v3, v2, -1.0
; GFX8-FLUSH-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX8-FLUSH-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX8-FLUSH-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-IEEE-LABEL: v_neg_rcp_v2f16_fabs:
; GFX9-IEEE:       ; %bb.0:
; GFX9-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-IEEE-NEXT:    v_and_b32_e32 v0, 0x7fff7fff, v0
; GFX9-IEEE-NEXT:    v_cvt_f32_f16_e32 v1, v0
; GFX9-IEEE-NEXT:    v_lshrrev_b32_e32 v2, 16, v0
; GFX9-IEEE-NEXT:    v_cvt_f32_f16_e32 v4, -1.0
; GFX9-IEEE-NEXT:    v_cvt_f32_f16_e32 v3, v2
; GFX9-IEEE-NEXT:    v_rcp_f32_e32 v5, v1
; GFX9-IEEE-NEXT:    v_rcp_f32_e32 v6, v3
; GFX9-IEEE-NEXT:    v_mul_f32_e32 v7, v4, v5
; GFX9-IEEE-NEXT:    v_mul_f32_e64 v8, -v1, v7
; GFX9-IEEE-NEXT:    v_add_f32_e32 v8, v8, v4
; GFX9-IEEE-NEXT:    v_mul_f32_e32 v8, v8, v5
; GFX9-IEEE-NEXT:    v_add_f32_e32 v7, v8, v7
; GFX9-IEEE-NEXT:    v_mul_f32_e32 v9, v4, v6
; GFX9-IEEE-NEXT:    v_mul_f32_e64 v1, -v1, v7
; GFX9-IEEE-NEXT:    v_mul_f32_e64 v10, -v3, v9
; GFX9-IEEE-NEXT:    v_add_f32_e32 v1, v1, v4
; GFX9-IEEE-NEXT:    v_mul_f32_e32 v1, v1, v5
; GFX9-IEEE-NEXT:    v_add_f32_e32 v5, v10, v4
; GFX9-IEEE-NEXT:    v_mul_f32_e32 v5, v5, v6
; GFX9-IEEE-NEXT:    v_add_f32_e32 v5, v5, v9
; GFX9-IEEE-NEXT:    v_mul_f32_e64 v3, -v3, v5
; GFX9-IEEE-NEXT:    v_add_f32_e32 v3, v3, v4
; GFX9-IEEE-NEXT:    v_mul_f32_e32 v3, v3, v6
; GFX9-IEEE-NEXT:    v_and_b32_e32 v1, 0xff800000, v1
; GFX9-IEEE-NEXT:    v_and_b32_e32 v3, 0xff800000, v3
; GFX9-IEEE-NEXT:    v_add_f32_e32 v1, v1, v7
; GFX9-IEEE-NEXT:    v_add_f32_e32 v3, v3, v5
; GFX9-IEEE-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX9-IEEE-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX9-IEEE-NEXT:    v_div_fixup_f16 v0, v1, v0, -1.0
; GFX9-IEEE-NEXT:    v_div_fixup_f16 v1, v3, v2, -1.0
; GFX9-IEEE-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX9-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-FLUSH-LABEL: v_neg_rcp_v2f16_fabs:
; GFX9-FLUSH:       ; %bb.0:
; GFX9-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-FLUSH-NEXT:    v_and_b32_e32 v1, 0x7fff7fff, v0
; GFX9-FLUSH-NEXT:    v_cvt_f32_f16_e32 v2, v1
; GFX9-FLUSH-NEXT:    v_lshrrev_b32_e32 v3, 16, v1
; GFX9-FLUSH-NEXT:    v_cvt_f32_f16_e32 v4, v3
; GFX9-FLUSH-NEXT:    v_cvt_f32_f16_e32 v5, -1.0
; GFX9-FLUSH-NEXT:    v_rcp_f32_e32 v2, v2
; GFX9-FLUSH-NEXT:    v_rcp_f32_e32 v4, v4
; GFX9-FLUSH-NEXT:    v_mul_f32_e32 v6, v5, v2
; GFX9-FLUSH-NEXT:    v_mad_mix_f32 v7, -v1, v6, -1.0 op_sel_hi:[1,0,1]
; GFX9-FLUSH-NEXT:    v_mul_f32_e32 v5, v5, v4
; GFX9-FLUSH-NEXT:    v_mac_f32_e32 v6, v7, v2
; GFX9-FLUSH-NEXT:    v_mad_mix_f32 v7, -|v0|, v5, -1.0 op_sel:[1,0,0] op_sel_hi:[1,0,1]
; GFX9-FLUSH-NEXT:    v_mac_f32_e32 v5, v7, v4
; GFX9-FLUSH-NEXT:    v_mad_mix_f32 v8, -v1, v6, -1.0 op_sel_hi:[1,0,1]
; GFX9-FLUSH-NEXT:    v_mad_mix_f32 v0, -|v0|, v5, -1.0 op_sel:[1,0,0] op_sel_hi:[1,0,1]
; GFX9-FLUSH-NEXT:    v_mul_f32_e32 v2, v8, v2
; GFX9-FLUSH-NEXT:    v_mul_f32_e32 v0, v0, v4
; GFX9-FLUSH-NEXT:    v_and_b32_e32 v2, 0xff800000, v2
; GFX9-FLUSH-NEXT:    v_and_b32_e32 v0, 0xff800000, v0
; GFX9-FLUSH-NEXT:    v_add_f32_e32 v2, v2, v6
; GFX9-FLUSH-NEXT:    v_add_f32_e32 v0, v0, v5
; GFX9-FLUSH-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX9-FLUSH-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX9-FLUSH-NEXT:    v_div_fixup_f16 v1, v2, v1, -1.0
; GFX9-FLUSH-NEXT:    v_div_fixup_f16 v0, v0, v3, -1.0
; GFX9-FLUSH-NEXT:    v_pack_b32_f16 v0, v1, v0
; GFX9-FLUSH-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-IEEE-LABEL: v_neg_rcp_v2f16_fabs:
; GFX10-IEEE:       ; %bb.0:
; GFX10-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-IEEE-NEXT:    v_and_b32_e32 v0, 0x7fff7fff, v0
; GFX10-IEEE-NEXT:    v_cvt_f32_f16_e32 v6, -1.0
; GFX10-IEEE-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX10-IEEE-NEXT:    v_cvt_f32_f16_e32 v2, v0
; GFX10-IEEE-NEXT:    v_cvt_f32_f16_e32 v3, v1
; GFX10-IEEE-NEXT:    v_rcp_f32_e32 v4, v2
; GFX10-IEEE-NEXT:    v_rcp_f32_e32 v5, v3
; GFX10-IEEE-NEXT:    v_mul_f32_e32 v7, v6, v4
; GFX10-IEEE-NEXT:    v_mul_f32_e32 v8, v6, v5
; GFX10-IEEE-NEXT:    v_mul_f32_e64 v9, -v2, v7
; GFX10-IEEE-NEXT:    v_mul_f32_e64 v10, -v3, v8
; GFX10-IEEE-NEXT:    v_add_f32_e32 v9, v9, v6
; GFX10-IEEE-NEXT:    v_add_f32_e32 v10, v10, v6
; GFX10-IEEE-NEXT:    v_mul_f32_e32 v9, v9, v4
; GFX10-IEEE-NEXT:    v_mul_f32_e32 v10, v10, v5
; GFX10-IEEE-NEXT:    v_add_f32_e32 v7, v9, v7
; GFX10-IEEE-NEXT:    v_add_f32_e32 v8, v10, v8
; GFX10-IEEE-NEXT:    v_mul_f32_e64 v2, -v2, v7
; GFX10-IEEE-NEXT:    v_mul_f32_e64 v3, -v3, v8
; GFX10-IEEE-NEXT:    v_add_f32_e32 v2, v2, v6
; GFX10-IEEE-NEXT:    v_add_f32_e32 v3, v3, v6
; GFX10-IEEE-NEXT:    v_mul_f32_e32 v2, v2, v4
; GFX10-IEEE-NEXT:    v_mul_f32_e32 v3, v3, v5
; GFX10-IEEE-NEXT:    v_and_b32_e32 v2, 0xff800000, v2
; GFX10-IEEE-NEXT:    v_and_b32_e32 v3, 0xff800000, v3
; GFX10-IEEE-NEXT:    v_add_f32_e32 v2, v2, v7
; GFX10-IEEE-NEXT:    v_add_f32_e32 v3, v3, v8
; GFX10-IEEE-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX10-IEEE-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX10-IEEE-NEXT:    v_div_fixup_f16 v0, v2, v0, -1.0
; GFX10-IEEE-NEXT:    v_div_fixup_f16 v1, v3, v1, -1.0
; GFX10-IEEE-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX10-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-FLUSH-LABEL: v_neg_rcp_v2f16_fabs:
; GFX10-FLUSH:       ; %bb.0:
; GFX10-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-FLUSH-NEXT:    v_and_b32_e32 v0, 0x7fff7fff, v0
; GFX10-FLUSH-NEXT:    v_cvt_f32_f16_e32 v6, -1.0
; GFX10-FLUSH-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX10-FLUSH-NEXT:    v_cvt_f32_f16_e32 v2, v0
; GFX10-FLUSH-NEXT:    v_cvt_f32_f16_e32 v3, v1
; GFX10-FLUSH-NEXT:    v_rcp_f32_e32 v4, v2
; GFX10-FLUSH-NEXT:    v_rcp_f32_e32 v5, v3
; GFX10-FLUSH-NEXT:    v_mul_f32_e32 v7, v6, v4
; GFX10-FLUSH-NEXT:    v_mul_f32_e32 v8, v6, v5
; GFX10-FLUSH-NEXT:    v_mad_f32 v9, -v2, v7, v6
; GFX10-FLUSH-NEXT:    v_mad_f32 v10, -v3, v8, v6
; GFX10-FLUSH-NEXT:    v_mac_f32_e32 v7, v9, v4
; GFX10-FLUSH-NEXT:    v_mac_f32_e32 v8, v10, v5
; GFX10-FLUSH-NEXT:    v_mad_f32 v2, -v2, v7, v6
; GFX10-FLUSH-NEXT:    v_mad_f32 v3, -v3, v8, v6
; GFX10-FLUSH-NEXT:    v_mul_f32_e32 v2, v2, v4
; GFX10-FLUSH-NEXT:    v_mul_f32_e32 v3, v3, v5
; GFX10-FLUSH-NEXT:    v_and_b32_e32 v2, 0xff800000, v2
; GFX10-FLUSH-NEXT:    v_and_b32_e32 v3, 0xff800000, v3
; GFX10-FLUSH-NEXT:    v_add_f32_e32 v2, v2, v7
; GFX10-FLUSH-NEXT:    v_add_f32_e32 v3, v3, v8
; GFX10-FLUSH-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX10-FLUSH-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX10-FLUSH-NEXT:    v_div_fixup_f16 v0, v2, v0, -1.0
; GFX10-FLUSH-NEXT:    v_div_fixup_f16 v1, v3, v1, -1.0
; GFX10-FLUSH-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX10-FLUSH-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_neg_rcp_v2f16_fabs:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_cvt_f32_f16_e32 v5, -1.0
; GFX11-NEXT:    v_and_b32_e32 v1, 0x7fff7fff, v0
; GFX11-NEXT:    v_cvt_f32_f16_e32 v3, v1
; GFX11-NEXT:    v_rcp_f32_e32 v3, v3
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_mul_f32_e32 v6, v5, v3
; GFX11-NEXT:    v_lshrrev_b32_e32 v2, 16, v1
; GFX11-NEXT:    v_fma_mix_f32 v7, -v1, v6, -1.0 op_sel_hi:[1,0,1]
; GFX11-NEXT:    v_cvt_f32_f16_e32 v4, v2
; GFX11-NEXT:    v_fmac_f32_e32 v6, v7, v3
; GFX11-NEXT:    v_rcp_f32_e32 v4, v4
; GFX11-NEXT:    v_fma_mix_f32 v7, -v1, v6, -1.0 op_sel_hi:[1,0,1]
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_mul_f32_e32 v5, v5, v4
; GFX11-NEXT:    v_fma_mix_f32 v8, -|v0|, v5, -1.0 op_sel:[1,0,0] op_sel_hi:[1,0,1]
; GFX11-NEXT:    v_fmac_f32_e32 v5, v8, v4
; GFX11-NEXT:    v_fma_mix_f32 v0, -|v0|, v5, -1.0 op_sel:[1,0,0] op_sel_hi:[1,0,1]
; GFX11-NEXT:    v_dual_mul_f32 v3, v7, v3 :: v_dual_mul_f32 v0, v0, v4
; GFX11-NEXT:    v_and_b32_e32 v0, 0xff800000, v0
; GFX11-NEXT:    v_dual_add_f32 v0, v0, v5 :: v_dual_and_b32 v3, 0xff800000, v3
; GFX11-NEXT:    v_add_f32_e32 v3, v3, v6
; GFX11-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX11-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX11-NEXT:    v_div_fixup_f16 v0, v0, v2, -1.0
; GFX11-NEXT:    v_div_fixup_f16 v1, v3, v1, -1.0
; GFX11-NEXT:    v_pack_b32_f16 v0, v1, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %x.fabs = call <2 x half> @llvm.fabs.v2f16(<2 x half> %x)
  %fdiv = fdiv <2 x half> <half -1.0, half -1.0>, %x.fabs
  ret <2 x half> %fdiv
}

define <2 x half> @v_rcp_v2f16_arcp(<2 x half> %x) {
; GFX6-IEEE-LABEL: v_rcp_v2f16_arcp:
; GFX6-IEEE:       ; %bb.0:
; GFX6-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v2, 1.0
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX6-IEEE-NEXT:    v_div_scale_f32 v3, s[4:5], v0, v0, v2
; GFX6-IEEE-NEXT:    v_rcp_f32_e32 v4, v3
; GFX6-IEEE-NEXT:    v_div_scale_f32 v5, vcc, v2, v0, v2
; GFX6-IEEE-NEXT:    v_fma_f32 v6, -v3, v4, 1.0
; GFX6-IEEE-NEXT:    v_fma_f32 v4, v6, v4, v4
; GFX6-IEEE-NEXT:    v_mul_f32_e32 v6, v5, v4
; GFX6-IEEE-NEXT:    v_fma_f32 v7, -v3, v6, v5
; GFX6-IEEE-NEXT:    v_fma_f32 v6, v7, v4, v6
; GFX6-IEEE-NEXT:    v_fma_f32 v3, -v3, v6, v5
; GFX6-IEEE-NEXT:    v_div_fmas_f32 v3, v3, v4, v6
; GFX6-IEEE-NEXT:    v_div_fixup_f32 v0, v3, v0, v2
; GFX6-IEEE-NEXT:    v_div_scale_f32 v3, s[4:5], v1, v1, v2
; GFX6-IEEE-NEXT:    v_rcp_f32_e32 v4, v3
; GFX6-IEEE-NEXT:    v_div_scale_f32 v5, vcc, v2, v1, v2
; GFX6-IEEE-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-IEEE-NEXT:    v_fma_f32 v6, -v3, v4, 1.0
; GFX6-IEEE-NEXT:    v_fma_f32 v4, v6, v4, v4
; GFX6-IEEE-NEXT:    v_mul_f32_e32 v6, v5, v4
; GFX6-IEEE-NEXT:    v_fma_f32 v7, -v3, v6, v5
; GFX6-IEEE-NEXT:    v_fma_f32 v6, v7, v4, v6
; GFX6-IEEE-NEXT:    v_fma_f32 v3, -v3, v6, v5
; GFX6-IEEE-NEXT:    v_div_fmas_f32 v3, v3, v4, v6
; GFX6-IEEE-NEXT:    v_div_fixup_f32 v1, v3, v1, v2
; GFX6-IEEE-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX6-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-FLUSH-LABEL: v_rcp_v2f16_arcp:
; GFX6-FLUSH:       ; %bb.0:
; GFX6-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v2, 1.0
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v3, s[4:5], v0, v0, v2
; GFX6-FLUSH-NEXT:    v_rcp_f32_e32 v4, v3
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v5, vcc, v2, v0, v2
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-FLUSH-NEXT:    v_fma_f32 v6, -v3, v4, 1.0
; GFX6-FLUSH-NEXT:    v_fma_f32 v4, v6, v4, v4
; GFX6-FLUSH-NEXT:    v_mul_f32_e32 v6, v5, v4
; GFX6-FLUSH-NEXT:    v_fma_f32 v7, -v3, v6, v5
; GFX6-FLUSH-NEXT:    v_fma_f32 v6, v7, v4, v6
; GFX6-FLUSH-NEXT:    v_fma_f32 v3, -v3, v6, v5
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX6-FLUSH-NEXT:    v_div_fmas_f32 v3, v3, v4, v6
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v4, 1.0
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX6-FLUSH-NEXT:    v_div_fixup_f32 v0, v3, v0, v2
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 2, 2), 0
; GFX6-FLUSH-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v2, s[4:5], v1, v1, v4
; GFX6-FLUSH-NEXT:    v_rcp_f32_e32 v3, v2
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v5, vcc, v4, v1, v4
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-FLUSH-NEXT:    v_fma_f32 v6, -v2, v3, 1.0
; GFX6-FLUSH-NEXT:    v_fma_f32 v3, v6, v3, v3
; GFX6-FLUSH-NEXT:    v_mul_f32_e32 v6, v5, v3
; GFX6-FLUSH-NEXT:    v_fma_f32 v7, -v2, v6, v5
; GFX6-FLUSH-NEXT:    v_fma_f32 v6, v7, v3, v6
; GFX6-FLUSH-NEXT:    v_fma_f32 v2, -v2, v6, v5
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX6-FLUSH-NEXT:    v_div_fmas_f32 v2, v2, v3, v6
; GFX6-FLUSH-NEXT:    v_div_fixup_f32 v1, v2, v1, v4
; GFX6-FLUSH-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX6-FLUSH-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_rcp_v2f16_arcp:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_rcp_f16_e32 v1, v0
; GFX8-NEXT:    v_rcp_f16_sdwa v0, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1
; GFX8-NEXT:    v_or_b32_e32 v0, v1, v0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_rcp_v2f16_arcp:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_rcp_f16_e32 v1, v0
; GFX9-NEXT:    v_rcp_f16_sdwa v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GFX9-NEXT:    v_pack_b32_f16 v0, v1, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_rcp_v2f16_arcp:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_rcp_f16_e32 v1, v0
; GFX10-NEXT:    v_rcp_f16_sdwa v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GFX10-NEXT:    v_pack_b32_f16 v0, v1, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_rcp_v2f16_arcp:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX11-NEXT:    v_rcp_f16_e32 v0, v0
; GFX11-NEXT:    v_rcp_f16_e32 v1, v1
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %fdiv = fdiv arcp <2 x half> <half 1.0, half 1.0>, %x
  ret <2 x half> %fdiv
}

define <2 x half> @v_rcp_v2f16_arcp_afn(<2 x half> %x) {
; GFX6-LABEL: v_rcp_v2f16_arcp_afn:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX6-NEXT:    v_cvt_f32_f16_e32 v2, 1.0
; GFX6-NEXT:    v_rcp_f32_e32 v0, v0
; GFX6-NEXT:    v_rcp_f32_e32 v1, v1
; GFX6-NEXT:    v_mul_f32_e32 v0, v2, v0
; GFX6-NEXT:    v_mul_f32_e32 v1, v2, v1
; GFX6-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_rcp_v2f16_arcp_afn:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_rcp_f16_e32 v1, v0
; GFX8-NEXT:    v_rcp_f16_sdwa v0, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1
; GFX8-NEXT:    v_or_b32_e32 v0, v1, v0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_rcp_v2f16_arcp_afn:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_rcp_f16_e32 v1, v0
; GFX9-NEXT:    v_rcp_f16_sdwa v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GFX9-NEXT:    v_pack_b32_f16 v0, v1, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_rcp_v2f16_arcp_afn:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_rcp_f16_e32 v1, v0
; GFX10-NEXT:    v_rcp_f16_sdwa v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GFX10-NEXT:    v_pack_b32_f16 v0, v1, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_rcp_v2f16_arcp_afn:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX11-NEXT:    v_rcp_f16_e32 v0, v0
; GFX11-NEXT:    v_rcp_f16_e32 v1, v1
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %fdiv = fdiv arcp afn <2 x half> <half 1.0, half 1.0>, %x
  ret <2 x half> %fdiv
}

define <2 x half> @v_rcp_v2f16_ulp25(<2 x half> %x) {
; GFX6-IEEE-LABEL: v_rcp_v2f16_ulp25:
; GFX6-IEEE:       ; %bb.0:
; GFX6-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v2, 1.0
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX6-IEEE-NEXT:    v_div_scale_f32 v3, s[4:5], v0, v0, v2
; GFX6-IEEE-NEXT:    v_rcp_f32_e32 v4, v3
; GFX6-IEEE-NEXT:    v_div_scale_f32 v5, vcc, v2, v0, v2
; GFX6-IEEE-NEXT:    v_fma_f32 v6, -v3, v4, 1.0
; GFX6-IEEE-NEXT:    v_fma_f32 v4, v6, v4, v4
; GFX6-IEEE-NEXT:    v_mul_f32_e32 v6, v5, v4
; GFX6-IEEE-NEXT:    v_fma_f32 v7, -v3, v6, v5
; GFX6-IEEE-NEXT:    v_fma_f32 v6, v7, v4, v6
; GFX6-IEEE-NEXT:    v_fma_f32 v3, -v3, v6, v5
; GFX6-IEEE-NEXT:    v_div_fmas_f32 v3, v3, v4, v6
; GFX6-IEEE-NEXT:    v_div_fixup_f32 v0, v3, v0, v2
; GFX6-IEEE-NEXT:    v_div_scale_f32 v3, s[4:5], v1, v1, v2
; GFX6-IEEE-NEXT:    v_rcp_f32_e32 v4, v3
; GFX6-IEEE-NEXT:    v_div_scale_f32 v5, vcc, v2, v1, v2
; GFX6-IEEE-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-IEEE-NEXT:    v_fma_f32 v6, -v3, v4, 1.0
; GFX6-IEEE-NEXT:    v_fma_f32 v4, v6, v4, v4
; GFX6-IEEE-NEXT:    v_mul_f32_e32 v6, v5, v4
; GFX6-IEEE-NEXT:    v_fma_f32 v7, -v3, v6, v5
; GFX6-IEEE-NEXT:    v_fma_f32 v6, v7, v4, v6
; GFX6-IEEE-NEXT:    v_fma_f32 v3, -v3, v6, v5
; GFX6-IEEE-NEXT:    v_div_fmas_f32 v3, v3, v4, v6
; GFX6-IEEE-NEXT:    v_div_fixup_f32 v1, v3, v1, v2
; GFX6-IEEE-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX6-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-FLUSH-LABEL: v_rcp_v2f16_ulp25:
; GFX6-FLUSH:       ; %bb.0:
; GFX6-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v2, 1.0
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v3, s[4:5], v0, v0, v2
; GFX6-FLUSH-NEXT:    v_rcp_f32_e32 v4, v3
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v5, vcc, v2, v0, v2
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-FLUSH-NEXT:    v_fma_f32 v6, -v3, v4, 1.0
; GFX6-FLUSH-NEXT:    v_fma_f32 v4, v6, v4, v4
; GFX6-FLUSH-NEXT:    v_mul_f32_e32 v6, v5, v4
; GFX6-FLUSH-NEXT:    v_fma_f32 v7, -v3, v6, v5
; GFX6-FLUSH-NEXT:    v_fma_f32 v6, v7, v4, v6
; GFX6-FLUSH-NEXT:    v_fma_f32 v3, -v3, v6, v5
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX6-FLUSH-NEXT:    v_div_fmas_f32 v3, v3, v4, v6
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v4, 1.0
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX6-FLUSH-NEXT:    v_div_fixup_f32 v0, v3, v0, v2
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 2, 2), 0
; GFX6-FLUSH-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v2, s[4:5], v1, v1, v4
; GFX6-FLUSH-NEXT:    v_rcp_f32_e32 v3, v2
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v5, vcc, v4, v1, v4
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-FLUSH-NEXT:    v_fma_f32 v6, -v2, v3, 1.0
; GFX6-FLUSH-NEXT:    v_fma_f32 v3, v6, v3, v3
; GFX6-FLUSH-NEXT:    v_mul_f32_e32 v6, v5, v3
; GFX6-FLUSH-NEXT:    v_fma_f32 v7, -v2, v6, v5
; GFX6-FLUSH-NEXT:    v_fma_f32 v6, v7, v3, v6
; GFX6-FLUSH-NEXT:    v_fma_f32 v2, -v2, v6, v5
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX6-FLUSH-NEXT:    v_div_fmas_f32 v2, v2, v3, v6
; GFX6-FLUSH-NEXT:    v_div_fixup_f32 v1, v2, v1, v4
; GFX6-FLUSH-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX6-FLUSH-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-IEEE-LABEL: v_rcp_v2f16_ulp25:
; GFX8-IEEE:       ; %bb.0:
; GFX8-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-IEEE-NEXT:    v_cvt_f32_f16_e32 v1, v0
; GFX8-IEEE-NEXT:    v_lshrrev_b32_e32 v2, 16, v0
; GFX8-IEEE-NEXT:    v_cvt_f32_f16_e32 v4, 1.0
; GFX8-IEEE-NEXT:    v_cvt_f32_f16_e32 v3, v2
; GFX8-IEEE-NEXT:    v_rcp_f32_e32 v5, v1
; GFX8-IEEE-NEXT:    v_rcp_f32_e32 v6, v3
; GFX8-IEEE-NEXT:    v_mul_f32_e32 v7, v4, v5
; GFX8-IEEE-NEXT:    v_mul_f32_e64 v8, -v1, v7
; GFX8-IEEE-NEXT:    v_add_f32_e32 v8, v8, v4
; GFX8-IEEE-NEXT:    v_mul_f32_e32 v8, v8, v5
; GFX8-IEEE-NEXT:    v_add_f32_e32 v7, v8, v7
; GFX8-IEEE-NEXT:    v_mul_f32_e32 v9, v4, v6
; GFX8-IEEE-NEXT:    v_mul_f32_e64 v1, -v1, v7
; GFX8-IEEE-NEXT:    v_mul_f32_e64 v10, -v3, v9
; GFX8-IEEE-NEXT:    v_add_f32_e32 v1, v1, v4
; GFX8-IEEE-NEXT:    v_mul_f32_e32 v1, v1, v5
; GFX8-IEEE-NEXT:    v_add_f32_e32 v5, v10, v4
; GFX8-IEEE-NEXT:    v_mul_f32_e32 v5, v5, v6
; GFX8-IEEE-NEXT:    v_add_f32_e32 v5, v5, v9
; GFX8-IEEE-NEXT:    v_mul_f32_e64 v3, -v3, v5
; GFX8-IEEE-NEXT:    v_add_f32_e32 v3, v3, v4
; GFX8-IEEE-NEXT:    v_mul_f32_e32 v3, v3, v6
; GFX8-IEEE-NEXT:    v_and_b32_e32 v1, 0xff800000, v1
; GFX8-IEEE-NEXT:    v_and_b32_e32 v3, 0xff800000, v3
; GFX8-IEEE-NEXT:    v_add_f32_e32 v1, v1, v7
; GFX8-IEEE-NEXT:    v_add_f32_e32 v3, v3, v5
; GFX8-IEEE-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX8-IEEE-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX8-IEEE-NEXT:    v_div_fixup_f16 v0, v1, v0, 1.0
; GFX8-IEEE-NEXT:    v_div_fixup_f16 v1, v3, v2, 1.0
; GFX8-IEEE-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX8-IEEE-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX8-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-FLUSH-LABEL: v_rcp_v2f16_ulp25:
; GFX8-FLUSH:       ; %bb.0:
; GFX8-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-FLUSH-NEXT:    v_cvt_f32_f16_e32 v1, v0
; GFX8-FLUSH-NEXT:    v_lshrrev_b32_e32 v2, 16, v0
; GFX8-FLUSH-NEXT:    v_cvt_f32_f16_e32 v3, v2
; GFX8-FLUSH-NEXT:    v_cvt_f32_f16_e32 v4, 1.0
; GFX8-FLUSH-NEXT:    v_rcp_f32_e32 v5, v1
; GFX8-FLUSH-NEXT:    v_rcp_f32_e32 v6, v3
; GFX8-FLUSH-NEXT:    v_mul_f32_e32 v7, v4, v5
; GFX8-FLUSH-NEXT:    v_mad_f32 v8, -v1, v7, v4
; GFX8-FLUSH-NEXT:    v_mul_f32_e32 v9, v4, v6
; GFX8-FLUSH-NEXT:    v_mac_f32_e32 v7, v8, v5
; GFX8-FLUSH-NEXT:    v_mad_f32 v8, -v3, v9, v4
; GFX8-FLUSH-NEXT:    v_mac_f32_e32 v9, v8, v6
; GFX8-FLUSH-NEXT:    v_mad_f32 v1, -v1, v7, v4
; GFX8-FLUSH-NEXT:    v_mad_f32 v3, -v3, v9, v4
; GFX8-FLUSH-NEXT:    v_mul_f32_e32 v1, v1, v5
; GFX8-FLUSH-NEXT:    v_mul_f32_e32 v3, v3, v6
; GFX8-FLUSH-NEXT:    v_and_b32_e32 v1, 0xff800000, v1
; GFX8-FLUSH-NEXT:    v_and_b32_e32 v3, 0xff800000, v3
; GFX8-FLUSH-NEXT:    v_add_f32_e32 v1, v1, v7
; GFX8-FLUSH-NEXT:    v_add_f32_e32 v3, v3, v9
; GFX8-FLUSH-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX8-FLUSH-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX8-FLUSH-NEXT:    v_div_fixup_f16 v0, v1, v0, 1.0
; GFX8-FLUSH-NEXT:    v_div_fixup_f16 v1, v3, v2, 1.0
; GFX8-FLUSH-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX8-FLUSH-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX8-FLUSH-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-IEEE-LABEL: v_rcp_v2f16_ulp25:
; GFX9-IEEE:       ; %bb.0:
; GFX9-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-IEEE-NEXT:    v_cvt_f32_f16_e32 v1, v0
; GFX9-IEEE-NEXT:    v_lshrrev_b32_e32 v2, 16, v0
; GFX9-IEEE-NEXT:    v_cvt_f32_f16_e32 v4, 1.0
; GFX9-IEEE-NEXT:    v_cvt_f32_f16_e32 v3, v2
; GFX9-IEEE-NEXT:    v_rcp_f32_e32 v5, v1
; GFX9-IEEE-NEXT:    v_rcp_f32_e32 v6, v3
; GFX9-IEEE-NEXT:    v_mul_f32_e32 v7, v4, v5
; GFX9-IEEE-NEXT:    v_mul_f32_e64 v8, -v1, v7
; GFX9-IEEE-NEXT:    v_add_f32_e32 v8, v8, v4
; GFX9-IEEE-NEXT:    v_mul_f32_e32 v8, v8, v5
; GFX9-IEEE-NEXT:    v_add_f32_e32 v7, v8, v7
; GFX9-IEEE-NEXT:    v_mul_f32_e32 v9, v4, v6
; GFX9-IEEE-NEXT:    v_mul_f32_e64 v1, -v1, v7
; GFX9-IEEE-NEXT:    v_mul_f32_e64 v10, -v3, v9
; GFX9-IEEE-NEXT:    v_add_f32_e32 v1, v1, v4
; GFX9-IEEE-NEXT:    v_mul_f32_e32 v1, v1, v5
; GFX9-IEEE-NEXT:    v_add_f32_e32 v5, v10, v4
; GFX9-IEEE-NEXT:    v_mul_f32_e32 v5, v5, v6
; GFX9-IEEE-NEXT:    v_add_f32_e32 v5, v5, v9
; GFX9-IEEE-NEXT:    v_mul_f32_e64 v3, -v3, v5
; GFX9-IEEE-NEXT:    v_add_f32_e32 v3, v3, v4
; GFX9-IEEE-NEXT:    v_mul_f32_e32 v3, v3, v6
; GFX9-IEEE-NEXT:    v_and_b32_e32 v1, 0xff800000, v1
; GFX9-IEEE-NEXT:    v_and_b32_e32 v3, 0xff800000, v3
; GFX9-IEEE-NEXT:    v_add_f32_e32 v1, v1, v7
; GFX9-IEEE-NEXT:    v_add_f32_e32 v3, v3, v5
; GFX9-IEEE-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX9-IEEE-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX9-IEEE-NEXT:    v_div_fixup_f16 v0, v1, v0, 1.0
; GFX9-IEEE-NEXT:    v_div_fixup_f16 v1, v3, v2, 1.0
; GFX9-IEEE-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX9-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-FLUSH-LABEL: v_rcp_v2f16_ulp25:
; GFX9-FLUSH:       ; %bb.0:
; GFX9-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-FLUSH-NEXT:    v_cvt_f32_f16_e32 v1, v0
; GFX9-FLUSH-NEXT:    v_lshrrev_b32_e32 v2, 16, v0
; GFX9-FLUSH-NEXT:    v_cvt_f32_f16_e32 v3, v2
; GFX9-FLUSH-NEXT:    v_cvt_f32_f16_e32 v4, 1.0
; GFX9-FLUSH-NEXT:    v_rcp_f32_e32 v1, v1
; GFX9-FLUSH-NEXT:    v_rcp_f32_e32 v3, v3
; GFX9-FLUSH-NEXT:    v_mul_f32_e32 v5, v4, v1
; GFX9-FLUSH-NEXT:    v_mad_mix_f32 v6, -v0, v5, 1.0 op_sel_hi:[1,0,1]
; GFX9-FLUSH-NEXT:    v_mac_f32_e32 v5, v6, v1
; GFX9-FLUSH-NEXT:    v_mul_f32_e32 v4, v4, v3
; GFX9-FLUSH-NEXT:    v_mad_mix_f32 v7, -v0, v5, 1.0 op_sel_hi:[1,0,1]
; GFX9-FLUSH-NEXT:    v_mad_mix_f32 v6, -v0, v4, 1.0 op_sel:[1,0,0] op_sel_hi:[1,0,1]
; GFX9-FLUSH-NEXT:    v_mul_f32_e32 v1, v7, v1
; GFX9-FLUSH-NEXT:    v_and_b32_e32 v1, 0xff800000, v1
; GFX9-FLUSH-NEXT:    v_mac_f32_e32 v4, v6, v3
; GFX9-FLUSH-NEXT:    v_add_f32_e32 v1, v1, v5
; GFX9-FLUSH-NEXT:    v_mad_mix_f32 v5, -v0, v4, 1.0 op_sel:[1,0,0] op_sel_hi:[1,0,1]
; GFX9-FLUSH-NEXT:    v_mul_f32_e32 v3, v5, v3
; GFX9-FLUSH-NEXT:    v_and_b32_e32 v3, 0xff800000, v3
; GFX9-FLUSH-NEXT:    v_add_f32_e32 v3, v3, v4
; GFX9-FLUSH-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX9-FLUSH-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX9-FLUSH-NEXT:    v_div_fixup_f16 v0, v1, v0, 1.0
; GFX9-FLUSH-NEXT:    v_div_fixup_f16 v1, v3, v2, 1.0
; GFX9-FLUSH-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX9-FLUSH-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-IEEE-LABEL: v_rcp_v2f16_ulp25:
; GFX10-IEEE:       ; %bb.0:
; GFX10-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-IEEE-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX10-IEEE-NEXT:    v_cvt_f32_f16_e32 v2, v0
; GFX10-IEEE-NEXT:    v_cvt_f32_f16_e32 v6, 1.0
; GFX10-IEEE-NEXT:    v_cvt_f32_f16_e32 v3, v1
; GFX10-IEEE-NEXT:    v_rcp_f32_e32 v4, v2
; GFX10-IEEE-NEXT:    v_rcp_f32_e32 v5, v3
; GFX10-IEEE-NEXT:    v_mul_f32_e32 v7, v6, v4
; GFX10-IEEE-NEXT:    v_mul_f32_e32 v8, v6, v5
; GFX10-IEEE-NEXT:    v_mul_f32_e64 v9, -v2, v7
; GFX10-IEEE-NEXT:    v_mul_f32_e64 v10, -v3, v8
; GFX10-IEEE-NEXT:    v_add_f32_e32 v9, v9, v6
; GFX10-IEEE-NEXT:    v_add_f32_e32 v10, v10, v6
; GFX10-IEEE-NEXT:    v_mul_f32_e32 v9, v9, v4
; GFX10-IEEE-NEXT:    v_mul_f32_e32 v10, v10, v5
; GFX10-IEEE-NEXT:    v_add_f32_e32 v7, v9, v7
; GFX10-IEEE-NEXT:    v_add_f32_e32 v8, v10, v8
; GFX10-IEEE-NEXT:    v_mul_f32_e64 v2, -v2, v7
; GFX10-IEEE-NEXT:    v_mul_f32_e64 v3, -v3, v8
; GFX10-IEEE-NEXT:    v_add_f32_e32 v2, v2, v6
; GFX10-IEEE-NEXT:    v_add_f32_e32 v3, v3, v6
; GFX10-IEEE-NEXT:    v_mul_f32_e32 v2, v2, v4
; GFX10-IEEE-NEXT:    v_mul_f32_e32 v3, v3, v5
; GFX10-IEEE-NEXT:    v_and_b32_e32 v2, 0xff800000, v2
; GFX10-IEEE-NEXT:    v_and_b32_e32 v3, 0xff800000, v3
; GFX10-IEEE-NEXT:    v_add_f32_e32 v2, v2, v7
; GFX10-IEEE-NEXT:    v_add_f32_e32 v3, v3, v8
; GFX10-IEEE-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX10-IEEE-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX10-IEEE-NEXT:    v_div_fixup_f16 v0, v2, v0, 1.0
; GFX10-IEEE-NEXT:    v_div_fixup_f16 v1, v3, v1, 1.0
; GFX10-IEEE-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX10-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-FLUSH-LABEL: v_rcp_v2f16_ulp25:
; GFX10-FLUSH:       ; %bb.0:
; GFX10-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-FLUSH-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX10-FLUSH-NEXT:    v_cvt_f32_f16_e32 v2, v0
; GFX10-FLUSH-NEXT:    v_cvt_f32_f16_e32 v6, 1.0
; GFX10-FLUSH-NEXT:    v_cvt_f32_f16_e32 v3, v1
; GFX10-FLUSH-NEXT:    v_rcp_f32_e32 v4, v2
; GFX10-FLUSH-NEXT:    v_rcp_f32_e32 v5, v3
; GFX10-FLUSH-NEXT:    v_mul_f32_e32 v7, v6, v4
; GFX10-FLUSH-NEXT:    v_mul_f32_e32 v8, v6, v5
; GFX10-FLUSH-NEXT:    v_mad_f32 v9, -v2, v7, v6
; GFX10-FLUSH-NEXT:    v_mad_f32 v10, -v3, v8, v6
; GFX10-FLUSH-NEXT:    v_mac_f32_e32 v7, v9, v4
; GFX10-FLUSH-NEXT:    v_mac_f32_e32 v8, v10, v5
; GFX10-FLUSH-NEXT:    v_mad_f32 v2, -v2, v7, v6
; GFX10-FLUSH-NEXT:    v_mad_f32 v3, -v3, v8, v6
; GFX10-FLUSH-NEXT:    v_mul_f32_e32 v2, v2, v4
; GFX10-FLUSH-NEXT:    v_mul_f32_e32 v3, v3, v5
; GFX10-FLUSH-NEXT:    v_and_b32_e32 v2, 0xff800000, v2
; GFX10-FLUSH-NEXT:    v_and_b32_e32 v3, 0xff800000, v3
; GFX10-FLUSH-NEXT:    v_add_f32_e32 v2, v2, v7
; GFX10-FLUSH-NEXT:    v_add_f32_e32 v3, v3, v8
; GFX10-FLUSH-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX10-FLUSH-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX10-FLUSH-NEXT:    v_div_fixup_f16 v0, v2, v0, 1.0
; GFX10-FLUSH-NEXT:    v_div_fixup_f16 v1, v3, v1, 1.0
; GFX10-FLUSH-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX10-FLUSH-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_rcp_v2f16_ulp25:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX11-NEXT:    v_cvt_f32_f16_e32 v2, v0
; GFX11-NEXT:    v_cvt_f32_f16_e32 v4, 1.0
; GFX11-NEXT:    v_cvt_f32_f16_e32 v3, v1
; GFX11-NEXT:    v_rcp_f32_e32 v2, v2
; GFX11-NEXT:    v_rcp_f32_e32 v3, v3
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_mul_f32_e32 v5, v4, v2
; GFX11-NEXT:    v_mul_f32_e32 v4, v4, v3
; GFX11-NEXT:    v_fma_mix_f32 v7, -v0, v4, 1.0 op_sel:[1,0,0] op_sel_hi:[1,0,1]
; GFX11-NEXT:    v_fmac_f32_e32 v4, v7, v3
; GFX11-NEXT:    v_fma_mix_f32 v6, -v0, v5, 1.0 op_sel_hi:[1,0,1]
; GFX11-NEXT:    v_fma_mix_f32 v7, -v0, v4, 1.0 op_sel:[1,0,0] op_sel_hi:[1,0,1]
; GFX11-NEXT:    v_fmac_f32_e32 v5, v6, v2
; GFX11-NEXT:    v_mul_f32_e32 v3, v7, v3
; GFX11-NEXT:    v_fma_mix_f32 v6, -v0, v5, 1.0 op_sel_hi:[1,0,1]
; GFX11-NEXT:    v_dual_mul_f32 v2, v6, v2 :: v_dual_and_b32 v3, 0xff800000, v3
; GFX11-NEXT:    v_dual_add_f32 v3, v3, v4 :: v_dual_and_b32 v2, 0xff800000, v2
; GFX11-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX11-NEXT:    v_add_f32_e32 v2, v2, v5
; GFX11-NEXT:    v_div_fixup_f16 v1, v3, v1, 1.0
; GFX11-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX11-NEXT:    v_div_fixup_f16 v0, v2, v0, 1.0
; GFX11-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %fdiv = fdiv <2 x half> <half 1.0, half 1.0>, %x
  ret <2 x half> %fdiv
}

define <2 x half> @v_fdiv_v2f16_afn_ulp25(<2 x half> %a, <2 x half> %b) {
; GFX6-LABEL: v_fdiv_v2f16_afn_ulp25:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GFX6-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GFX6-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX6-NEXT:    v_rcp_f32_e32 v2, v2
; GFX6-NEXT:    v_rcp_f32_e32 v3, v3
; GFX6-NEXT:    v_mul_f32_e32 v0, v0, v2
; GFX6-NEXT:    v_mul_f32_e32 v1, v1, v3
; GFX6-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_fdiv_v2f16_afn_ulp25:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_rcp_f16_e32 v2, v1
; GFX8-NEXT:    v_rcp_f16_sdwa v1, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GFX8-NEXT:    v_mul_f16_e32 v2, v0, v2
; GFX8-NEXT:    v_mul_f16_sdwa v0, v0, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_e32 v0, v2, v0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_fdiv_v2f16_afn_ulp25:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_rcp_f16_e32 v2, v1
; GFX9-NEXT:    v_rcp_f16_sdwa v1, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GFX9-NEXT:    v_mul_f16_e32 v2, v0, v2
; GFX9-NEXT:    v_mul_f16_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    v_pack_b32_f16 v0, v2, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_fdiv_v2f16_afn_ulp25:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_rcp_f16_e32 v2, v1
; GFX10-NEXT:    v_rcp_f16_sdwa v1, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GFX10-NEXT:    v_mul_f16_e32 v2, v0, v2
; GFX10-NEXT:    v_mul_f16_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX10-NEXT:    v_pack_b32_f16 v0, v2, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fdiv_v2f16_afn_ulp25:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_lshrrev_b32_e32 v2, 16, v1
; GFX11-NEXT:    v_rcp_f16_e32 v1, v1
; GFX11-NEXT:    v_lshrrev_b32_e32 v3, 16, v0
; GFX11-NEXT:    v_rcp_f16_e32 v2, v2
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX11-NEXT:    v_mul_f16_e32 v1, v3, v2
; GFX11-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %fdiv = fdiv afn <2 x half> %a, %b
  ret <2 x half> %fdiv
}

define <2 x half> @v_fdiv_v2f16_arcp_ulp25(<2 x half> %a, <2 x half> %b) {
; GFX6-IEEE-LABEL: v_fdiv_v2f16_arcp_ulp25:
; GFX6-IEEE:       ; %bb.0:
; GFX6-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GFX6-IEEE-NEXT:    v_div_scale_f32 v4, s[4:5], v2, v2, v0
; GFX6-IEEE-NEXT:    v_rcp_f32_e32 v5, v4
; GFX6-IEEE-NEXT:    v_div_scale_f32 v6, vcc, v0, v2, v0
; GFX6-IEEE-NEXT:    v_fma_f32 v7, -v4, v5, 1.0
; GFX6-IEEE-NEXT:    v_fma_f32 v5, v7, v5, v5
; GFX6-IEEE-NEXT:    v_mul_f32_e32 v7, v6, v5
; GFX6-IEEE-NEXT:    v_fma_f32 v8, -v4, v7, v6
; GFX6-IEEE-NEXT:    v_fma_f32 v7, v8, v5, v7
; GFX6-IEEE-NEXT:    v_fma_f32 v4, -v4, v7, v6
; GFX6-IEEE-NEXT:    v_div_fmas_f32 v4, v4, v5, v7
; GFX6-IEEE-NEXT:    v_div_fixup_f32 v0, v4, v2, v0
; GFX6-IEEE-NEXT:    v_div_scale_f32 v2, s[4:5], v3, v3, v1
; GFX6-IEEE-NEXT:    v_rcp_f32_e32 v4, v2
; GFX6-IEEE-NEXT:    v_div_scale_f32 v5, vcc, v1, v3, v1
; GFX6-IEEE-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-IEEE-NEXT:    v_fma_f32 v6, -v2, v4, 1.0
; GFX6-IEEE-NEXT:    v_fma_f32 v4, v6, v4, v4
; GFX6-IEEE-NEXT:    v_mul_f32_e32 v6, v5, v4
; GFX6-IEEE-NEXT:    v_fma_f32 v7, -v2, v6, v5
; GFX6-IEEE-NEXT:    v_fma_f32 v6, v7, v4, v6
; GFX6-IEEE-NEXT:    v_fma_f32 v2, -v2, v6, v5
; GFX6-IEEE-NEXT:    v_div_fmas_f32 v2, v2, v4, v6
; GFX6-IEEE-NEXT:    v_div_fixup_f32 v1, v2, v3, v1
; GFX6-IEEE-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX6-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-FLUSH-LABEL: v_fdiv_v2f16_arcp_ulp25:
; GFX6-FLUSH:       ; %bb.0:
; GFX6-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v4, s[4:5], v2, v2, v0
; GFX6-FLUSH-NEXT:    v_rcp_f32_e32 v5, v4
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v6, vcc, v0, v2, v0
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-FLUSH-NEXT:    v_fma_f32 v7, -v4, v5, 1.0
; GFX6-FLUSH-NEXT:    v_fma_f32 v5, v7, v5, v5
; GFX6-FLUSH-NEXT:    v_mul_f32_e32 v7, v6, v5
; GFX6-FLUSH-NEXT:    v_fma_f32 v8, -v4, v7, v6
; GFX6-FLUSH-NEXT:    v_fma_f32 v7, v8, v5, v7
; GFX6-FLUSH-NEXT:    v_fma_f32 v4, -v4, v7, v6
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GFX6-FLUSH-NEXT:    v_div_fmas_f32 v4, v4, v5, v7
; GFX6-FLUSH-NEXT:    v_div_fixup_f32 v0, v4, v2, v0
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 2, 2), 0
; GFX6-FLUSH-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v2, s[4:5], v3, v3, v1
; GFX6-FLUSH-NEXT:    v_rcp_f32_e32 v4, v2
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v5, vcc, v1, v3, v1
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-FLUSH-NEXT:    v_fma_f32 v6, -v2, v4, 1.0
; GFX6-FLUSH-NEXT:    v_fma_f32 v4, v6, v4, v4
; GFX6-FLUSH-NEXT:    v_mul_f32_e32 v6, v5, v4
; GFX6-FLUSH-NEXT:    v_fma_f32 v7, -v2, v6, v5
; GFX6-FLUSH-NEXT:    v_fma_f32 v6, v7, v4, v6
; GFX6-FLUSH-NEXT:    v_fma_f32 v2, -v2, v6, v5
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX6-FLUSH-NEXT:    v_div_fmas_f32 v2, v2, v4, v6
; GFX6-FLUSH-NEXT:    v_div_fixup_f32 v1, v2, v3, v1
; GFX6-FLUSH-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX6-FLUSH-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_fdiv_v2f16_arcp_ulp25:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_rcp_f16_e32 v2, v1
; GFX8-NEXT:    v_rcp_f16_sdwa v1, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GFX8-NEXT:    v_mul_f16_e32 v2, v0, v2
; GFX8-NEXT:    v_mul_f16_sdwa v0, v0, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_e32 v0, v2, v0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_fdiv_v2f16_arcp_ulp25:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_rcp_f16_e32 v2, v1
; GFX9-NEXT:    v_rcp_f16_sdwa v1, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GFX9-NEXT:    v_mul_f16_e32 v2, v0, v2
; GFX9-NEXT:    v_mul_f16_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    v_pack_b32_f16 v0, v2, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_fdiv_v2f16_arcp_ulp25:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_rcp_f16_e32 v2, v1
; GFX10-NEXT:    v_rcp_f16_sdwa v1, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GFX10-NEXT:    v_mul_f16_e32 v2, v0, v2
; GFX10-NEXT:    v_mul_f16_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX10-NEXT:    v_pack_b32_f16 v0, v2, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fdiv_v2f16_arcp_ulp25:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_lshrrev_b32_e32 v2, 16, v1
; GFX11-NEXT:    v_rcp_f16_e32 v1, v1
; GFX11-NEXT:    v_lshrrev_b32_e32 v3, 16, v0
; GFX11-NEXT:    v_rcp_f16_e32 v2, v2
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX11-NEXT:    v_mul_f16_e32 v1, v3, v2
; GFX11-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %fdiv = fdiv arcp <2 x half> %a, %b
  ret <2 x half> %fdiv
}

define <2 x half> @v_fdiv_v2f16_arcp_afn_ulp25(<2 x half> %a, <2 x half> %b) {
; GFX6-LABEL: v_fdiv_v2f16_arcp_afn_ulp25:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GFX6-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GFX6-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX6-NEXT:    v_rcp_f32_e32 v2, v2
; GFX6-NEXT:    v_rcp_f32_e32 v3, v3
; GFX6-NEXT:    v_mul_f32_e32 v0, v0, v2
; GFX6-NEXT:    v_mul_f32_e32 v1, v1, v3
; GFX6-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_fdiv_v2f16_arcp_afn_ulp25:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_rcp_f16_e32 v2, v1
; GFX8-NEXT:    v_rcp_f16_sdwa v1, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GFX8-NEXT:    v_mul_f16_e32 v2, v0, v2
; GFX8-NEXT:    v_mul_f16_sdwa v0, v0, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_e32 v0, v2, v0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_fdiv_v2f16_arcp_afn_ulp25:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_rcp_f16_e32 v2, v1
; GFX9-NEXT:    v_rcp_f16_sdwa v1, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GFX9-NEXT:    v_mul_f16_e32 v2, v0, v2
; GFX9-NEXT:    v_mul_f16_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    v_pack_b32_f16 v0, v2, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_fdiv_v2f16_arcp_afn_ulp25:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_rcp_f16_e32 v2, v1
; GFX10-NEXT:    v_rcp_f16_sdwa v1, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GFX10-NEXT:    v_mul_f16_e32 v2, v0, v2
; GFX10-NEXT:    v_mul_f16_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX10-NEXT:    v_pack_b32_f16 v0, v2, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_fdiv_v2f16_arcp_afn_ulp25:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_lshrrev_b32_e32 v2, 16, v1
; GFX11-NEXT:    v_rcp_f16_e32 v1, v1
; GFX11-NEXT:    v_lshrrev_b32_e32 v3, 16, v0
; GFX11-NEXT:    v_rcp_f16_e32 v2, v2
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX11-NEXT:    v_mul_f16_e32 v1, v3, v2
; GFX11-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %fdiv = fdiv afn arcp <2 x half> %a, %b
  ret <2 x half> %fdiv
}

define amdgpu_ps i16 @s_fdiv_f16(i16 inreg %a.arg, i16 inreg %b.arg) {
; GFX6-IEEE-LABEL: s_fdiv_f16:
; GFX6-IEEE:       ; %bb.0:
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v0, s0
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v1, s1
; GFX6-IEEE-NEXT:    v_div_scale_f32 v2, s[0:1], v1, v1, v0
; GFX6-IEEE-NEXT:    v_rcp_f32_e32 v3, v2
; GFX6-IEEE-NEXT:    v_div_scale_f32 v4, vcc, v0, v1, v0
; GFX6-IEEE-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX6-IEEE-NEXT:    v_fma_f32 v3, v5, v3, v3
; GFX6-IEEE-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX6-IEEE-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX6-IEEE-NEXT:    v_fma_f32 v5, v6, v3, v5
; GFX6-IEEE-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX6-IEEE-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX6-IEEE-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX6-IEEE-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-IEEE-NEXT:    v_readfirstlane_b32 s0, v0
; GFX6-IEEE-NEXT:    ; return to shader part epilog
;
; GFX6-FLUSH-LABEL: s_fdiv_f16:
; GFX6-FLUSH:       ; %bb.0:
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v0, s0
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v1, s1
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v2, s[0:1], v1, v1, v0
; GFX6-FLUSH-NEXT:    v_rcp_f32_e32 v3, v2
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v4, vcc, v0, v1, v0
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-FLUSH-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX6-FLUSH-NEXT:    v_fma_f32 v3, v5, v3, v3
; GFX6-FLUSH-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX6-FLUSH-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX6-FLUSH-NEXT:    v_fma_f32 v5, v6, v3, v5
; GFX6-FLUSH-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX6-FLUSH-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX6-FLUSH-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 2, 2), 0
; GFX6-FLUSH-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-FLUSH-NEXT:    v_readfirstlane_b32 s0, v0
; GFX6-FLUSH-NEXT:    ; return to shader part epilog
;
; GFX8-IEEE-LABEL: s_fdiv_f16:
; GFX8-IEEE:       ; %bb.0:
; GFX8-IEEE-NEXT:    v_cvt_f32_f16_e32 v0, s1
; GFX8-IEEE-NEXT:    v_cvt_f32_f16_e32 v1, s0
; GFX8-IEEE-NEXT:    v_rcp_f32_e32 v2, v0
; GFX8-IEEE-NEXT:    v_mul_f32_e32 v3, v1, v2
; GFX8-IEEE-NEXT:    v_mul_f32_e64 v4, -v0, v3
; GFX8-IEEE-NEXT:    v_add_f32_e32 v4, v4, v1
; GFX8-IEEE-NEXT:    v_mul_f32_e32 v4, v4, v2
; GFX8-IEEE-NEXT:    v_add_f32_e32 v3, v4, v3
; GFX8-IEEE-NEXT:    v_mul_f32_e64 v0, -v0, v3
; GFX8-IEEE-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX8-IEEE-NEXT:    v_mul_f32_e32 v0, v0, v2
; GFX8-IEEE-NEXT:    v_and_b32_e32 v0, 0xff800000, v0
; GFX8-IEEE-NEXT:    v_add_f32_e32 v0, v0, v3
; GFX8-IEEE-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX8-IEEE-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-IEEE-NEXT:    v_div_fixup_f16 v0, v0, v1, s0
; GFX8-IEEE-NEXT:    v_readfirstlane_b32 s0, v0
; GFX8-IEEE-NEXT:    ; return to shader part epilog
;
; GFX8-FLUSH-LABEL: s_fdiv_f16:
; GFX8-FLUSH:       ; %bb.0:
; GFX8-FLUSH-NEXT:    v_cvt_f32_f16_e32 v0, s1
; GFX8-FLUSH-NEXT:    v_cvt_f32_f16_e32 v1, s0
; GFX8-FLUSH-NEXT:    v_rcp_f32_e32 v2, v0
; GFX8-FLUSH-NEXT:    v_mul_f32_e32 v3, v1, v2
; GFX8-FLUSH-NEXT:    v_mad_f32 v4, -v0, v3, v1
; GFX8-FLUSH-NEXT:    v_mac_f32_e32 v3, v4, v2
; GFX8-FLUSH-NEXT:    v_mad_f32 v0, -v0, v3, v1
; GFX8-FLUSH-NEXT:    v_mul_f32_e32 v0, v0, v2
; GFX8-FLUSH-NEXT:    v_and_b32_e32 v0, 0xff800000, v0
; GFX8-FLUSH-NEXT:    v_add_f32_e32 v0, v0, v3
; GFX8-FLUSH-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX8-FLUSH-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-FLUSH-NEXT:    v_div_fixup_f16 v0, v0, v1, s0
; GFX8-FLUSH-NEXT:    v_readfirstlane_b32 s0, v0
; GFX8-FLUSH-NEXT:    ; return to shader part epilog
;
; GFX9-IEEE-LABEL: s_fdiv_f16:
; GFX9-IEEE:       ; %bb.0:
; GFX9-IEEE-NEXT:    v_cvt_f32_f16_e32 v0, s1
; GFX9-IEEE-NEXT:    v_cvt_f32_f16_e32 v1, s0
; GFX9-IEEE-NEXT:    v_rcp_f32_e32 v2, v0
; GFX9-IEEE-NEXT:    v_mul_f32_e32 v3, v1, v2
; GFX9-IEEE-NEXT:    v_mul_f32_e64 v4, -v0, v3
; GFX9-IEEE-NEXT:    v_add_f32_e32 v4, v4, v1
; GFX9-IEEE-NEXT:    v_mul_f32_e32 v4, v4, v2
; GFX9-IEEE-NEXT:    v_add_f32_e32 v3, v4, v3
; GFX9-IEEE-NEXT:    v_mul_f32_e64 v0, -v0, v3
; GFX9-IEEE-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX9-IEEE-NEXT:    v_mul_f32_e32 v0, v0, v2
; GFX9-IEEE-NEXT:    v_and_b32_e32 v0, 0xff800000, v0
; GFX9-IEEE-NEXT:    v_add_f32_e32 v0, v0, v3
; GFX9-IEEE-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX9-IEEE-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-IEEE-NEXT:    v_div_fixup_f16 v0, v0, v1, s0
; GFX9-IEEE-NEXT:    v_readfirstlane_b32 s0, v0
; GFX9-IEEE-NEXT:    ; return to shader part epilog
;
; GFX9-FLUSH-LABEL: s_fdiv_f16:
; GFX9-FLUSH:       ; %bb.0:
; GFX9-FLUSH-NEXT:    v_cvt_f32_f16_e32 v0, s1
; GFX9-FLUSH-NEXT:    v_cvt_f32_f16_e32 v1, s0
; GFX9-FLUSH-NEXT:    v_mov_b32_e32 v2, s1
; GFX9-FLUSH-NEXT:    v_rcp_f32_e32 v0, v0
; GFX9-FLUSH-NEXT:    v_mul_f32_e32 v1, v1, v0
; GFX9-FLUSH-NEXT:    v_mad_mix_f32 v3, -v2, v1, s0 op_sel_hi:[1,0,1]
; GFX9-FLUSH-NEXT:    v_mac_f32_e32 v1, v3, v0
; GFX9-FLUSH-NEXT:    v_mad_mix_f32 v3, -v2, v1, s0 op_sel_hi:[1,0,1]
; GFX9-FLUSH-NEXT:    v_mul_f32_e32 v0, v3, v0
; GFX9-FLUSH-NEXT:    v_and_b32_e32 v0, 0xff800000, v0
; GFX9-FLUSH-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX9-FLUSH-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX9-FLUSH-NEXT:    v_div_fixup_f16 v0, v0, v2, s0
; GFX9-FLUSH-NEXT:    v_readfirstlane_b32 s0, v0
; GFX9-FLUSH-NEXT:    ; return to shader part epilog
;
; GFX10-IEEE-LABEL: s_fdiv_f16:
; GFX10-IEEE:       ; %bb.0:
; GFX10-IEEE-NEXT:    v_cvt_f32_f16_e32 v0, s1
; GFX10-IEEE-NEXT:    v_cvt_f32_f16_e32 v2, s0
; GFX10-IEEE-NEXT:    v_rcp_f32_e32 v1, v0
; GFX10-IEEE-NEXT:    v_mul_f32_e32 v3, v2, v1
; GFX10-IEEE-NEXT:    v_mul_f32_e64 v4, -v0, v3
; GFX10-IEEE-NEXT:    v_add_f32_e32 v4, v4, v2
; GFX10-IEEE-NEXT:    v_mul_f32_e32 v4, v4, v1
; GFX10-IEEE-NEXT:    v_add_f32_e32 v3, v4, v3
; GFX10-IEEE-NEXT:    v_mul_f32_e64 v0, -v0, v3
; GFX10-IEEE-NEXT:    v_add_f32_e32 v0, v0, v2
; GFX10-IEEE-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX10-IEEE-NEXT:    v_and_b32_e32 v0, 0xff800000, v0
; GFX10-IEEE-NEXT:    v_add_f32_e32 v0, v0, v3
; GFX10-IEEE-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX10-IEEE-NEXT:    v_div_fixup_f16 v0, v0, s1, s0
; GFX10-IEEE-NEXT:    v_readfirstlane_b32 s0, v0
; GFX10-IEEE-NEXT:    ; return to shader part epilog
;
; GFX10-FLUSH-LABEL: s_fdiv_f16:
; GFX10-FLUSH:       ; %bb.0:
; GFX10-FLUSH-NEXT:    v_cvt_f32_f16_e32 v0, s1
; GFX10-FLUSH-NEXT:    v_cvt_f32_f16_e32 v2, s0
; GFX10-FLUSH-NEXT:    v_rcp_f32_e32 v1, v0
; GFX10-FLUSH-NEXT:    v_mul_f32_e32 v3, v2, v1
; GFX10-FLUSH-NEXT:    v_mad_f32 v4, -v0, v3, v2
; GFX10-FLUSH-NEXT:    v_mac_f32_e32 v3, v4, v1
; GFX10-FLUSH-NEXT:    v_mad_f32 v0, -v0, v3, v2
; GFX10-FLUSH-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX10-FLUSH-NEXT:    v_and_b32_e32 v0, 0xff800000, v0
; GFX10-FLUSH-NEXT:    v_add_f32_e32 v0, v0, v3
; GFX10-FLUSH-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX10-FLUSH-NEXT:    v_div_fixup_f16 v0, v0, s1, s0
; GFX10-FLUSH-NEXT:    v_readfirstlane_b32 s0, v0
; GFX10-FLUSH-NEXT:    ; return to shader part epilog
;
; GFX11-LABEL: s_fdiv_f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    v_cvt_f32_f16_e32 v0, s1
; GFX11-NEXT:    v_cvt_f32_f16_e32 v1, s0
; GFX11-NEXT:    v_rcp_f32_e32 v0, v0
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_mul_f32_e32 v1, v1, v0
; GFX11-NEXT:    v_fma_mix_f32 v2, -s1, v1, s0 op_sel_hi:[1,0,1]
; GFX11-NEXT:    v_fmac_f32_e32 v1, v2, v0
; GFX11-NEXT:    v_fma_mix_f32 v2, -s1, v1, s0 op_sel_hi:[1,0,1]
; GFX11-NEXT:    v_mul_f32_e32 v0, v2, v0
; GFX11-NEXT:    v_and_b32_e32 v0, 0xff800000, v0
; GFX11-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX11-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX11-NEXT:    v_div_fixup_f16 v0, v0, s1, s0
; GFX11-NEXT:    v_readfirstlane_b32 s0, v0
; GFX11-NEXT:    ; return to shader part epilog
  %a = bitcast i16 %a.arg to half
  %b = bitcast i16 %b.arg to half
  %fdiv = fdiv half %a, %b
  %result = bitcast half %fdiv to i16
  ret i16 %result
}

define amdgpu_ps i16 @s_fdiv_f16_arcp(i16 inreg %a.arg, i16 inreg %b.arg) {
; GFX6-IEEE-LABEL: s_fdiv_f16_arcp:
; GFX6-IEEE:       ; %bb.0:
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v0, s0
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v1, s1
; GFX6-IEEE-NEXT:    v_div_scale_f32 v2, s[0:1], v1, v1, v0
; GFX6-IEEE-NEXT:    v_rcp_f32_e32 v3, v2
; GFX6-IEEE-NEXT:    v_div_scale_f32 v4, vcc, v0, v1, v0
; GFX6-IEEE-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX6-IEEE-NEXT:    v_fma_f32 v3, v5, v3, v3
; GFX6-IEEE-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX6-IEEE-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX6-IEEE-NEXT:    v_fma_f32 v5, v6, v3, v5
; GFX6-IEEE-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX6-IEEE-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX6-IEEE-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX6-IEEE-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-IEEE-NEXT:    v_readfirstlane_b32 s0, v0
; GFX6-IEEE-NEXT:    ; return to shader part epilog
;
; GFX6-FLUSH-LABEL: s_fdiv_f16_arcp:
; GFX6-FLUSH:       ; %bb.0:
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v0, s0
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v1, s1
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v2, s[0:1], v1, v1, v0
; GFX6-FLUSH-NEXT:    v_rcp_f32_e32 v3, v2
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v4, vcc, v0, v1, v0
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-FLUSH-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX6-FLUSH-NEXT:    v_fma_f32 v3, v5, v3, v3
; GFX6-FLUSH-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX6-FLUSH-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX6-FLUSH-NEXT:    v_fma_f32 v5, v6, v3, v5
; GFX6-FLUSH-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX6-FLUSH-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX6-FLUSH-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 2, 2), 0
; GFX6-FLUSH-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-FLUSH-NEXT:    v_readfirstlane_b32 s0, v0
; GFX6-FLUSH-NEXT:    ; return to shader part epilog
;
; GFX89-LABEL: s_fdiv_f16_arcp:
; GFX89:       ; %bb.0:
; GFX89-NEXT:    v_rcp_f16_e32 v0, s1
; GFX89-NEXT:    v_mul_f16_e32 v0, s0, v0
; GFX89-NEXT:    v_readfirstlane_b32 s0, v0
; GFX89-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: s_fdiv_f16_arcp:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    v_rcp_f16_e32 v0, s1
; GFX10-NEXT:    v_mul_f16_e32 v0, s0, v0
; GFX10-NEXT:    v_readfirstlane_b32 s0, v0
; GFX10-NEXT:    ; return to shader part epilog
;
; GFX11-LABEL: s_fdiv_f16_arcp:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    v_rcp_f16_e32 v0, s1
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_mul_f16_e32 v0, s0, v0
; GFX11-NEXT:    v_readfirstlane_b32 s0, v0
; GFX11-NEXT:    ; return to shader part epilog
  %a = bitcast i16 %a.arg to half
  %b = bitcast i16 %b.arg to half
  %fdiv = fdiv arcp half %a, %b
  %result = bitcast half %fdiv to i16
  ret i16 %result
}

define amdgpu_ps i16 @s_fdiv_f16_afn(i16 inreg %a.arg, i16 inreg %b.arg) {
; GFX6-LABEL: s_fdiv_f16_afn:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    v_cvt_f32_f16_e32 v0, s1
; GFX6-NEXT:    v_cvt_f32_f16_e32 v1, s0
; GFX6-NEXT:    v_rcp_f32_e32 v0, v0
; GFX6-NEXT:    v_mul_f32_e32 v0, v1, v0
; GFX6-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-NEXT:    v_readfirstlane_b32 s0, v0
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX89-LABEL: s_fdiv_f16_afn:
; GFX89:       ; %bb.0:
; GFX89-NEXT:    v_rcp_f16_e32 v0, s1
; GFX89-NEXT:    v_mul_f16_e32 v0, s0, v0
; GFX89-NEXT:    v_readfirstlane_b32 s0, v0
; GFX89-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: s_fdiv_f16_afn:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    v_rcp_f16_e32 v0, s1
; GFX10-NEXT:    v_mul_f16_e32 v0, s0, v0
; GFX10-NEXT:    v_readfirstlane_b32 s0, v0
; GFX10-NEXT:    ; return to shader part epilog
;
; GFX11-LABEL: s_fdiv_f16_afn:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    v_rcp_f16_e32 v0, s1
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_mul_f16_e32 v0, s0, v0
; GFX11-NEXT:    v_readfirstlane_b32 s0, v0
; GFX11-NEXT:    ; return to shader part epilog
  %a = bitcast i16 %a.arg to half
  %b = bitcast i16 %b.arg to half
  %fdiv = fdiv afn half %a, %b
  %result = bitcast half %fdiv to i16
  ret i16 %result
}

define amdgpu_ps i32 @s_fdiv_v2f16(i32 inreg %a.arg, i32 inreg %b.arg) {
; GFX6-IEEE-LABEL: s_fdiv_v2f16:
; GFX6-IEEE:       ; %bb.0:
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v0, s0
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v1, s1
; GFX6-IEEE-NEXT:    s_lshr_b32 s0, s0, 16
; GFX6-IEEE-NEXT:    s_lshr_b32 s1, s1, 16
; GFX6-IEEE-NEXT:    v_div_scale_f32 v2, s[2:3], v1, v1, v0
; GFX6-IEEE-NEXT:    v_rcp_f32_e32 v3, v2
; GFX6-IEEE-NEXT:    v_div_scale_f32 v4, vcc, v0, v1, v0
; GFX6-IEEE-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX6-IEEE-NEXT:    v_fma_f32 v3, v5, v3, v3
; GFX6-IEEE-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX6-IEEE-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX6-IEEE-NEXT:    v_fma_f32 v5, v6, v3, v5
; GFX6-IEEE-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v4, s0
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v6, s1
; GFX6-IEEE-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX6-IEEE-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX6-IEEE-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-IEEE-NEXT:    v_div_scale_f32 v3, s[0:1], v6, v6, v4
; GFX6-IEEE-NEXT:    v_rcp_f32_e32 v5, v3
; GFX6-IEEE-NEXT:    v_div_scale_f32 v1, vcc, v4, v6, v4
; GFX6-IEEE-NEXT:    v_fma_f32 v2, -v3, v5, 1.0
; GFX6-IEEE-NEXT:    v_fma_f32 v2, v2, v5, v5
; GFX6-IEEE-NEXT:    v_mul_f32_e32 v5, v1, v2
; GFX6-IEEE-NEXT:    v_fma_f32 v7, -v3, v5, v1
; GFX6-IEEE-NEXT:    v_fma_f32 v5, v7, v2, v5
; GFX6-IEEE-NEXT:    v_fma_f32 v1, -v3, v5, v1
; GFX6-IEEE-NEXT:    v_div_fmas_f32 v1, v1, v2, v5
; GFX6-IEEE-NEXT:    v_div_fixup_f32 v1, v1, v6, v4
; GFX6-IEEE-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX6-IEEE-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX6-IEEE-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX6-IEEE-NEXT:    v_readfirstlane_b32 s0, v0
; GFX6-IEEE-NEXT:    ; return to shader part epilog
;
; GFX6-FLUSH-LABEL: s_fdiv_v2f16:
; GFX6-FLUSH:       ; %bb.0:
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v0, s0
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v1, s1
; GFX6-FLUSH-NEXT:    s_lshr_b32 s0, s0, 16
; GFX6-FLUSH-NEXT:    s_lshr_b32 s1, s1, 16
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v2, s[2:3], v1, v1, v0
; GFX6-FLUSH-NEXT:    v_rcp_f32_e32 v3, v2
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v4, vcc, v0, v1, v0
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-FLUSH-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX6-FLUSH-NEXT:    v_fma_f32 v3, v5, v3, v3
; GFX6-FLUSH-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX6-FLUSH-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX6-FLUSH-NEXT:    v_fma_f32 v5, v6, v3, v5
; GFX6-FLUSH-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX6-FLUSH-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v3, s0
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v4, s1
; GFX6-FLUSH-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 2, 2), 0
; GFX6-FLUSH-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v1, s[0:1], v4, v4, v3
; GFX6-FLUSH-NEXT:    v_rcp_f32_e32 v2, v1
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v5, vcc, v3, v4, v3
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-FLUSH-NEXT:    v_fma_f32 v6, -v1, v2, 1.0
; GFX6-FLUSH-NEXT:    v_fma_f32 v2, v6, v2, v2
; GFX6-FLUSH-NEXT:    v_mul_f32_e32 v6, v5, v2
; GFX6-FLUSH-NEXT:    v_fma_f32 v7, -v1, v6, v5
; GFX6-FLUSH-NEXT:    v_fma_f32 v6, v7, v2, v6
; GFX6-FLUSH-NEXT:    v_fma_f32 v1, -v1, v6, v5
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX6-FLUSH-NEXT:    v_div_fmas_f32 v1, v1, v2, v6
; GFX6-FLUSH-NEXT:    v_div_fixup_f32 v1, v1, v4, v3
; GFX6-FLUSH-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX6-FLUSH-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX6-FLUSH-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX6-FLUSH-NEXT:    v_readfirstlane_b32 s0, v0
; GFX6-FLUSH-NEXT:    ; return to shader part epilog
;
; GFX8-IEEE-LABEL: s_fdiv_v2f16:
; GFX8-IEEE:       ; %bb.0:
; GFX8-IEEE-NEXT:    v_cvt_f32_f16_e32 v0, s1
; GFX8-IEEE-NEXT:    v_cvt_f32_f16_e32 v1, s0
; GFX8-IEEE-NEXT:    s_lshr_b32 s3, s1, 16
; GFX8-IEEE-NEXT:    v_cvt_f32_f16_e32 v4, s3
; GFX8-IEEE-NEXT:    v_rcp_f32_e32 v2, v0
; GFX8-IEEE-NEXT:    s_lshr_b32 s2, s0, 16
; GFX8-IEEE-NEXT:    v_cvt_f32_f16_e32 v3, s2
; GFX8-IEEE-NEXT:    v_mul_f32_e32 v5, v1, v2
; GFX8-IEEE-NEXT:    v_mul_f32_e64 v6, -v0, v5
; GFX8-IEEE-NEXT:    v_add_f32_e32 v6, v6, v1
; GFX8-IEEE-NEXT:    v_mul_f32_e32 v6, v6, v2
; GFX8-IEEE-NEXT:    v_add_f32_e32 v5, v6, v5
; GFX8-IEEE-NEXT:    v_mul_f32_e64 v0, -v0, v5
; GFX8-IEEE-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX8-IEEE-NEXT:    v_rcp_f32_e32 v1, v4
; GFX8-IEEE-NEXT:    v_mul_f32_e32 v0, v0, v2
; GFX8-IEEE-NEXT:    v_and_b32_e32 v0, 0xff800000, v0
; GFX8-IEEE-NEXT:    v_add_f32_e32 v0, v0, v5
; GFX8-IEEE-NEXT:    v_mul_f32_e32 v2, v3, v1
; GFX8-IEEE-NEXT:    v_mul_f32_e64 v5, -v4, v2
; GFX8-IEEE-NEXT:    v_add_f32_e32 v5, v5, v3
; GFX8-IEEE-NEXT:    v_mul_f32_e32 v5, v5, v1
; GFX8-IEEE-NEXT:    v_add_f32_e32 v2, v5, v2
; GFX8-IEEE-NEXT:    v_mul_f32_e64 v4, -v4, v2
; GFX8-IEEE-NEXT:    v_add_f32_e32 v3, v4, v3
; GFX8-IEEE-NEXT:    v_mul_f32_e32 v1, v3, v1
; GFX8-IEEE-NEXT:    v_and_b32_e32 v1, 0xff800000, v1
; GFX8-IEEE-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX8-IEEE-NEXT:    v_add_f32_e32 v1, v1, v2
; GFX8-IEEE-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX8-IEEE-NEXT:    v_mov_b32_e32 v2, s1
; GFX8-IEEE-NEXT:    v_div_fixup_f16 v0, v0, v2, s0
; GFX8-IEEE-NEXT:    v_mov_b32_e32 v2, s3
; GFX8-IEEE-NEXT:    v_div_fixup_f16 v1, v1, v2, s2
; GFX8-IEEE-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX8-IEEE-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX8-IEEE-NEXT:    v_readfirstlane_b32 s0, v0
; GFX8-IEEE-NEXT:    ; return to shader part epilog
;
; GFX8-FLUSH-LABEL: s_fdiv_v2f16:
; GFX8-FLUSH:       ; %bb.0:
; GFX8-FLUSH-NEXT:    v_cvt_f32_f16_e32 v0, s1
; GFX8-FLUSH-NEXT:    v_cvt_f32_f16_e32 v1, s0
; GFX8-FLUSH-NEXT:    s_lshr_b32 s3, s1, 16
; GFX8-FLUSH-NEXT:    v_cvt_f32_f16_e32 v4, s3
; GFX8-FLUSH-NEXT:    v_rcp_f32_e32 v2, v0
; GFX8-FLUSH-NEXT:    s_lshr_b32 s2, s0, 16
; GFX8-FLUSH-NEXT:    v_cvt_f32_f16_e32 v3, s2
; GFX8-FLUSH-NEXT:    v_mul_f32_e32 v5, v1, v2
; GFX8-FLUSH-NEXT:    v_mad_f32 v6, -v0, v5, v1
; GFX8-FLUSH-NEXT:    v_mac_f32_e32 v5, v6, v2
; GFX8-FLUSH-NEXT:    v_mad_f32 v0, -v0, v5, v1
; GFX8-FLUSH-NEXT:    v_rcp_f32_e32 v1, v4
; GFX8-FLUSH-NEXT:    v_mul_f32_e32 v0, v0, v2
; GFX8-FLUSH-NEXT:    v_and_b32_e32 v0, 0xff800000, v0
; GFX8-FLUSH-NEXT:    v_add_f32_e32 v0, v0, v5
; GFX8-FLUSH-NEXT:    v_mul_f32_e32 v2, v3, v1
; GFX8-FLUSH-NEXT:    v_mad_f32 v5, -v4, v2, v3
; GFX8-FLUSH-NEXT:    v_mac_f32_e32 v2, v5, v1
; GFX8-FLUSH-NEXT:    v_mad_f32 v3, -v4, v2, v3
; GFX8-FLUSH-NEXT:    v_mul_f32_e32 v1, v3, v1
; GFX8-FLUSH-NEXT:    v_and_b32_e32 v1, 0xff800000, v1
; GFX8-FLUSH-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX8-FLUSH-NEXT:    v_add_f32_e32 v1, v1, v2
; GFX8-FLUSH-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX8-FLUSH-NEXT:    v_mov_b32_e32 v2, s1
; GFX8-FLUSH-NEXT:    v_div_fixup_f16 v0, v0, v2, s0
; GFX8-FLUSH-NEXT:    v_mov_b32_e32 v2, s3
; GFX8-FLUSH-NEXT:    v_div_fixup_f16 v1, v1, v2, s2
; GFX8-FLUSH-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX8-FLUSH-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX8-FLUSH-NEXT:    v_readfirstlane_b32 s0, v0
; GFX8-FLUSH-NEXT:    ; return to shader part epilog
;
; GFX9-IEEE-LABEL: s_fdiv_v2f16:
; GFX9-IEEE:       ; %bb.0:
; GFX9-IEEE-NEXT:    v_cvt_f32_f16_e32 v0, s1
; GFX9-IEEE-NEXT:    v_cvt_f32_f16_e32 v1, s0
; GFX9-IEEE-NEXT:    s_lshr_b32 s3, s1, 16
; GFX9-IEEE-NEXT:    v_cvt_f32_f16_e32 v4, s3
; GFX9-IEEE-NEXT:    v_rcp_f32_e32 v2, v0
; GFX9-IEEE-NEXT:    s_lshr_b32 s2, s0, 16
; GFX9-IEEE-NEXT:    v_cvt_f32_f16_e32 v3, s2
; GFX9-IEEE-NEXT:    v_mul_f32_e32 v5, v1, v2
; GFX9-IEEE-NEXT:    v_mul_f32_e64 v6, -v0, v5
; GFX9-IEEE-NEXT:    v_add_f32_e32 v6, v6, v1
; GFX9-IEEE-NEXT:    v_mul_f32_e32 v6, v6, v2
; GFX9-IEEE-NEXT:    v_add_f32_e32 v5, v6, v5
; GFX9-IEEE-NEXT:    v_mul_f32_e64 v0, -v0, v5
; GFX9-IEEE-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX9-IEEE-NEXT:    v_rcp_f32_e32 v1, v4
; GFX9-IEEE-NEXT:    v_mul_f32_e32 v0, v0, v2
; GFX9-IEEE-NEXT:    v_and_b32_e32 v0, 0xff800000, v0
; GFX9-IEEE-NEXT:    v_add_f32_e32 v0, v0, v5
; GFX9-IEEE-NEXT:    v_mul_f32_e32 v2, v3, v1
; GFX9-IEEE-NEXT:    v_mul_f32_e64 v5, -v4, v2
; GFX9-IEEE-NEXT:    v_add_f32_e32 v5, v5, v3
; GFX9-IEEE-NEXT:    v_mul_f32_e32 v5, v5, v1
; GFX9-IEEE-NEXT:    v_add_f32_e32 v2, v5, v2
; GFX9-IEEE-NEXT:    v_mul_f32_e64 v4, -v4, v2
; GFX9-IEEE-NEXT:    v_add_f32_e32 v3, v4, v3
; GFX9-IEEE-NEXT:    v_mul_f32_e32 v1, v3, v1
; GFX9-IEEE-NEXT:    v_and_b32_e32 v1, 0xff800000, v1
; GFX9-IEEE-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX9-IEEE-NEXT:    v_add_f32_e32 v1, v1, v2
; GFX9-IEEE-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX9-IEEE-NEXT:    v_mov_b32_e32 v2, s1
; GFX9-IEEE-NEXT:    v_div_fixup_f16 v0, v0, v2, s0
; GFX9-IEEE-NEXT:    v_mov_b32_e32 v2, s3
; GFX9-IEEE-NEXT:    v_div_fixup_f16 v1, v1, v2, s2
; GFX9-IEEE-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX9-IEEE-NEXT:    v_readfirstlane_b32 s0, v0
; GFX9-IEEE-NEXT:    ; return to shader part epilog
;
; GFX9-FLUSH-LABEL: s_fdiv_v2f16:
; GFX9-FLUSH:       ; %bb.0:
; GFX9-FLUSH-NEXT:    v_cvt_f32_f16_e32 v0, s1
; GFX9-FLUSH-NEXT:    v_cvt_f32_f16_e32 v1, s0
; GFX9-FLUSH-NEXT:    s_lshr_b32 s3, s1, 16
; GFX9-FLUSH-NEXT:    v_mov_b32_e32 v2, s1
; GFX9-FLUSH-NEXT:    v_rcp_f32_e32 v0, v0
; GFX9-FLUSH-NEXT:    v_cvt_f32_f16_e32 v3, s3
; GFX9-FLUSH-NEXT:    s_lshr_b32 s2, s0, 16
; GFX9-FLUSH-NEXT:    v_mul_f32_e32 v1, v1, v0
; GFX9-FLUSH-NEXT:    v_mad_mix_f32 v4, -v2, v1, s0 op_sel_hi:[1,0,1]
; GFX9-FLUSH-NEXT:    v_mac_f32_e32 v1, v4, v0
; GFX9-FLUSH-NEXT:    v_mad_mix_f32 v4, -v2, v1, s0 op_sel_hi:[1,0,1]
; GFX9-FLUSH-NEXT:    v_mul_f32_e32 v0, v4, v0
; GFX9-FLUSH-NEXT:    v_cvt_f32_f16_e32 v4, s2
; GFX9-FLUSH-NEXT:    v_rcp_f32_e32 v3, v3
; GFX9-FLUSH-NEXT:    v_and_b32_e32 v0, 0xff800000, v0
; GFX9-FLUSH-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX9-FLUSH-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-FLUSH-NEXT:    v_mul_f32_e32 v4, v4, v3
; GFX9-FLUSH-NEXT:    v_mad_mix_f32 v5, -v1, v4, s2 op_sel_hi:[1,0,1]
; GFX9-FLUSH-NEXT:    v_mac_f32_e32 v4, v5, v3
; GFX9-FLUSH-NEXT:    v_mad_mix_f32 v5, -v1, v4, s2 op_sel_hi:[1,0,1]
; GFX9-FLUSH-NEXT:    v_mul_f32_e32 v3, v5, v3
; GFX9-FLUSH-NEXT:    v_and_b32_e32 v3, 0xff800000, v3
; GFX9-FLUSH-NEXT:    v_add_f32_e32 v3, v3, v4
; GFX9-FLUSH-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX9-FLUSH-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX9-FLUSH-NEXT:    v_div_fixup_f16 v0, v0, v2, s0
; GFX9-FLUSH-NEXT:    v_div_fixup_f16 v1, v3, v1, s2
; GFX9-FLUSH-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX9-FLUSH-NEXT:    v_readfirstlane_b32 s0, v0
; GFX9-FLUSH-NEXT:    ; return to shader part epilog
;
; GFX10-IEEE-LABEL: s_fdiv_v2f16:
; GFX10-IEEE:       ; %bb.0:
; GFX10-IEEE-NEXT:    s_lshr_b32 s2, s1, 16
; GFX10-IEEE-NEXT:    v_cvt_f32_f16_e32 v0, s1
; GFX10-IEEE-NEXT:    v_cvt_f32_f16_e32 v1, s2
; GFX10-IEEE-NEXT:    s_lshr_b32 s3, s0, 16
; GFX10-IEEE-NEXT:    v_cvt_f32_f16_e32 v4, s0
; GFX10-IEEE-NEXT:    v_cvt_f32_f16_e32 v5, s3
; GFX10-IEEE-NEXT:    v_rcp_f32_e32 v2, v0
; GFX10-IEEE-NEXT:    v_rcp_f32_e32 v3, v1
; GFX10-IEEE-NEXT:    v_mul_f32_e32 v6, v4, v2
; GFX10-IEEE-NEXT:    v_mul_f32_e32 v7, v5, v3
; GFX10-IEEE-NEXT:    v_mul_f32_e64 v8, -v0, v6
; GFX10-IEEE-NEXT:    v_mul_f32_e64 v9, -v1, v7
; GFX10-IEEE-NEXT:    v_add_f32_e32 v8, v8, v4
; GFX10-IEEE-NEXT:    v_add_f32_e32 v9, v9, v5
; GFX10-IEEE-NEXT:    v_mul_f32_e32 v8, v8, v2
; GFX10-IEEE-NEXT:    v_mul_f32_e32 v9, v9, v3
; GFX10-IEEE-NEXT:    v_add_f32_e32 v6, v8, v6
; GFX10-IEEE-NEXT:    v_add_f32_e32 v7, v9, v7
; GFX10-IEEE-NEXT:    v_mul_f32_e64 v0, -v0, v6
; GFX10-IEEE-NEXT:    v_mul_f32_e64 v1, -v1, v7
; GFX10-IEEE-NEXT:    v_add_f32_e32 v0, v0, v4
; GFX10-IEEE-NEXT:    v_add_f32_e32 v1, v1, v5
; GFX10-IEEE-NEXT:    v_mul_f32_e32 v0, v0, v2
; GFX10-IEEE-NEXT:    v_mul_f32_e32 v1, v1, v3
; GFX10-IEEE-NEXT:    v_and_b32_e32 v0, 0xff800000, v0
; GFX10-IEEE-NEXT:    v_and_b32_e32 v1, 0xff800000, v1
; GFX10-IEEE-NEXT:    v_add_f32_e32 v0, v0, v6
; GFX10-IEEE-NEXT:    v_add_f32_e32 v1, v1, v7
; GFX10-IEEE-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX10-IEEE-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX10-IEEE-NEXT:    v_div_fixup_f16 v0, v0, s1, s0
; GFX10-IEEE-NEXT:    v_div_fixup_f16 v1, v1, s2, s3
; GFX10-IEEE-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX10-IEEE-NEXT:    v_readfirstlane_b32 s0, v0
; GFX10-IEEE-NEXT:    ; return to shader part epilog
;
; GFX10-FLUSH-LABEL: s_fdiv_v2f16:
; GFX10-FLUSH:       ; %bb.0:
; GFX10-FLUSH-NEXT:    s_lshr_b32 s2, s1, 16
; GFX10-FLUSH-NEXT:    v_cvt_f32_f16_e32 v0, s1
; GFX10-FLUSH-NEXT:    v_cvt_f32_f16_e32 v1, s2
; GFX10-FLUSH-NEXT:    s_lshr_b32 s3, s0, 16
; GFX10-FLUSH-NEXT:    v_cvt_f32_f16_e32 v4, s0
; GFX10-FLUSH-NEXT:    v_cvt_f32_f16_e32 v5, s3
; GFX10-FLUSH-NEXT:    v_rcp_f32_e32 v2, v0
; GFX10-FLUSH-NEXT:    v_rcp_f32_e32 v3, v1
; GFX10-FLUSH-NEXT:    v_mul_f32_e32 v6, v4, v2
; GFX10-FLUSH-NEXT:    v_mul_f32_e32 v7, v5, v3
; GFX10-FLUSH-NEXT:    v_mad_f32 v8, -v0, v6, v4
; GFX10-FLUSH-NEXT:    v_mad_f32 v9, -v1, v7, v5
; GFX10-FLUSH-NEXT:    v_mac_f32_e32 v6, v8, v2
; GFX10-FLUSH-NEXT:    v_mac_f32_e32 v7, v9, v3
; GFX10-FLUSH-NEXT:    v_mad_f32 v0, -v0, v6, v4
; GFX10-FLUSH-NEXT:    v_mad_f32 v1, -v1, v7, v5
; GFX10-FLUSH-NEXT:    v_mul_f32_e32 v0, v0, v2
; GFX10-FLUSH-NEXT:    v_mul_f32_e32 v1, v1, v3
; GFX10-FLUSH-NEXT:    v_and_b32_e32 v0, 0xff800000, v0
; GFX10-FLUSH-NEXT:    v_and_b32_e32 v1, 0xff800000, v1
; GFX10-FLUSH-NEXT:    v_add_f32_e32 v0, v0, v6
; GFX10-FLUSH-NEXT:    v_add_f32_e32 v1, v1, v7
; GFX10-FLUSH-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX10-FLUSH-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX10-FLUSH-NEXT:    v_div_fixup_f16 v0, v0, s1, s0
; GFX10-FLUSH-NEXT:    v_div_fixup_f16 v1, v1, s2, s3
; GFX10-FLUSH-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX10-FLUSH-NEXT:    v_readfirstlane_b32 s0, v0
; GFX10-FLUSH-NEXT:    ; return to shader part epilog
;
; GFX11-LABEL: s_fdiv_v2f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_lshr_b32 s2, s1, 16
; GFX11-NEXT:    v_cvt_f32_f16_e32 v0, s1
; GFX11-NEXT:    v_cvt_f32_f16_e32 v1, s2
; GFX11-NEXT:    s_lshr_b32 s3, s0, 16
; GFX11-NEXT:    v_cvt_f32_f16_e32 v2, s0
; GFX11-NEXT:    v_cvt_f32_f16_e32 v3, s3
; GFX11-NEXT:    v_rcp_f32_e32 v0, v0
; GFX11-NEXT:    v_rcp_f32_e32 v1, v1
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_dual_mul_f32 v2, v2, v0 :: v_dual_mul_f32 v3, v3, v1
; GFX11-NEXT:    v_fma_mix_f32 v4, -s1, v2, s0 op_sel_hi:[1,0,1]
; GFX11-NEXT:    v_fma_mix_f32 v5, -s2, v3, s3 op_sel_hi:[1,0,1]
; GFX11-NEXT:    v_dual_fmac_f32 v2, v4, v0 :: v_dual_fmac_f32 v3, v5, v1
; GFX11-NEXT:    v_fma_mix_f32 v4, -s1, v2, s0 op_sel_hi:[1,0,1]
; GFX11-NEXT:    v_fma_mix_f32 v5, -s2, v3, s3 op_sel_hi:[1,0,1]
; GFX11-NEXT:    v_dual_mul_f32 v0, v4, v0 :: v_dual_mul_f32 v1, v5, v1
; GFX11-NEXT:    v_and_b32_e32 v1, 0xff800000, v1
; GFX11-NEXT:    v_dual_add_f32 v1, v1, v3 :: v_dual_and_b32 v0, 0xff800000, v0
; GFX11-NEXT:    v_add_f32_e32 v0, v0, v2
; GFX11-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX11-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX11-NEXT:    v_div_fixup_f16 v1, v1, s2, s3
; GFX11-NEXT:    v_div_fixup_f16 v0, v0, s1, s0
; GFX11-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX11-NEXT:    v_readfirstlane_b32 s0, v0
; GFX11-NEXT:    ; return to shader part epilog
  %a = bitcast i32 %a.arg to <2 x half>
  %b = bitcast i32 %b.arg to <2 x half>
  %fdiv = fdiv <2 x half> %a, %b
  %result = bitcast <2 x half> %fdiv to i32
  ret i32 %result
}

define amdgpu_ps i16 @s_rcp_f16(i16 inreg %a.arg) {
; GFX6-IEEE-LABEL: s_rcp_f16:
; GFX6-IEEE:       ; %bb.0:
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v0, 1.0
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v1, s0
; GFX6-IEEE-NEXT:    v_div_scale_f32 v2, s[0:1], v1, v1, v0
; GFX6-IEEE-NEXT:    v_rcp_f32_e32 v3, v2
; GFX6-IEEE-NEXT:    v_div_scale_f32 v4, vcc, v0, v1, v0
; GFX6-IEEE-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX6-IEEE-NEXT:    v_fma_f32 v3, v5, v3, v3
; GFX6-IEEE-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX6-IEEE-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX6-IEEE-NEXT:    v_fma_f32 v5, v6, v3, v5
; GFX6-IEEE-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX6-IEEE-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX6-IEEE-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX6-IEEE-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-IEEE-NEXT:    v_readfirstlane_b32 s0, v0
; GFX6-IEEE-NEXT:    ; return to shader part epilog
;
; GFX6-FLUSH-LABEL: s_rcp_f16:
; GFX6-FLUSH:       ; %bb.0:
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v0, 1.0
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v1, s0
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v2, s[0:1], v1, v1, v0
; GFX6-FLUSH-NEXT:    v_rcp_f32_e32 v3, v2
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v4, vcc, v0, v1, v0
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-FLUSH-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX6-FLUSH-NEXT:    v_fma_f32 v3, v5, v3, v3
; GFX6-FLUSH-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX6-FLUSH-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX6-FLUSH-NEXT:    v_fma_f32 v5, v6, v3, v5
; GFX6-FLUSH-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX6-FLUSH-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX6-FLUSH-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 2, 2), 0
; GFX6-FLUSH-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-FLUSH-NEXT:    v_readfirstlane_b32 s0, v0
; GFX6-FLUSH-NEXT:    ; return to shader part epilog
;
; GFX89-LABEL: s_rcp_f16:
; GFX89:       ; %bb.0:
; GFX89-NEXT:    v_rcp_f16_e32 v0, s0
; GFX89-NEXT:    v_readfirstlane_b32 s0, v0
; GFX89-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: s_rcp_f16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    v_rcp_f16_e32 v0, s0
; GFX10-NEXT:    v_readfirstlane_b32 s0, v0
; GFX10-NEXT:    ; return to shader part epilog
;
; GFX11-LABEL: s_rcp_f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    v_rcp_f16_e32 v0, s0
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_readfirstlane_b32 s0, v0
; GFX11-NEXT:    ; return to shader part epilog
  %a = bitcast i16 %a.arg to half
  %fdiv = fdiv half 1.0, %a
  %result = bitcast half %fdiv to i16
  ret i16 %result
}

define amdgpu_ps i16 @s_neg_rcp_f16(i16 inreg %a.arg) {
; GFX6-IEEE-LABEL: s_neg_rcp_f16:
; GFX6-IEEE:       ; %bb.0:
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v0, -1.0
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v1, s0
; GFX6-IEEE-NEXT:    v_div_scale_f32 v2, s[0:1], v1, v1, v0
; GFX6-IEEE-NEXT:    v_rcp_f32_e32 v3, v2
; GFX6-IEEE-NEXT:    v_div_scale_f32 v4, vcc, v0, v1, v0
; GFX6-IEEE-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX6-IEEE-NEXT:    v_fma_f32 v3, v5, v3, v3
; GFX6-IEEE-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX6-IEEE-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX6-IEEE-NEXT:    v_fma_f32 v5, v6, v3, v5
; GFX6-IEEE-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX6-IEEE-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX6-IEEE-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX6-IEEE-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-IEEE-NEXT:    v_readfirstlane_b32 s0, v0
; GFX6-IEEE-NEXT:    ; return to shader part epilog
;
; GFX6-FLUSH-LABEL: s_neg_rcp_f16:
; GFX6-FLUSH:       ; %bb.0:
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v0, -1.0
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v1, s0
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v2, s[0:1], v1, v1, v0
; GFX6-FLUSH-NEXT:    v_rcp_f32_e32 v3, v2
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v4, vcc, v0, v1, v0
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-FLUSH-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX6-FLUSH-NEXT:    v_fma_f32 v3, v5, v3, v3
; GFX6-FLUSH-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX6-FLUSH-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX6-FLUSH-NEXT:    v_fma_f32 v5, v6, v3, v5
; GFX6-FLUSH-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX6-FLUSH-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX6-FLUSH-NEXT:    v_div_fixup_f32 v0, v2, v1, v0
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 2, 2), 0
; GFX6-FLUSH-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-FLUSH-NEXT:    v_readfirstlane_b32 s0, v0
; GFX6-FLUSH-NEXT:    ; return to shader part epilog
;
; GFX89-LABEL: s_neg_rcp_f16:
; GFX89:       ; %bb.0:
; GFX89-NEXT:    v_rcp_f16_e64 v0, -s0
; GFX89-NEXT:    v_readfirstlane_b32 s0, v0
; GFX89-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: s_neg_rcp_f16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    v_rcp_f16_e64 v0, -s0
; GFX10-NEXT:    v_readfirstlane_b32 s0, v0
; GFX10-NEXT:    ; return to shader part epilog
;
; GFX11-LABEL: s_neg_rcp_f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    v_rcp_f16_e64 v0, -s0
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_readfirstlane_b32 s0, v0
; GFX11-NEXT:    ; return to shader part epilog
  %a = bitcast i16 %a.arg to half
  %fdiv = fdiv half -1.0, %a
  %result = bitcast half %fdiv to i16
  ret i16 %result
}

define amdgpu_ps i16 @s_rsq_f16(i16 inreg %a.arg) {
; GFX6-IEEE-LABEL: s_rsq_f16:
; GFX6-IEEE:       ; %bb.0:
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v0, s0
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v1, 1.0
; GFX6-IEEE-NEXT:    v_sqrt_f32_e32 v0, v0
; GFX6-IEEE-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-IEEE-NEXT:    v_div_scale_f32 v2, s[0:1], v0, v0, v1
; GFX6-IEEE-NEXT:    v_rcp_f32_e32 v3, v2
; GFX6-IEEE-NEXT:    v_div_scale_f32 v4, vcc, v1, v0, v1
; GFX6-IEEE-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX6-IEEE-NEXT:    v_fma_f32 v3, v5, v3, v3
; GFX6-IEEE-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX6-IEEE-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX6-IEEE-NEXT:    v_fma_f32 v5, v6, v3, v5
; GFX6-IEEE-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX6-IEEE-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX6-IEEE-NEXT:    v_div_fixup_f32 v0, v2, v0, v1
; GFX6-IEEE-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-IEEE-NEXT:    v_readfirstlane_b32 s0, v0
; GFX6-IEEE-NEXT:    ; return to shader part epilog
;
; GFX6-FLUSH-LABEL: s_rsq_f16:
; GFX6-FLUSH:       ; %bb.0:
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v0, s0
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v1, 1.0
; GFX6-FLUSH-NEXT:    v_sqrt_f32_e32 v0, v0
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 2, 2), 0
; GFX6-FLUSH-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v2, s[0:1], v0, v0, v1
; GFX6-FLUSH-NEXT:    v_rcp_f32_e32 v3, v2
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v4, vcc, v1, v0, v1
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-FLUSH-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX6-FLUSH-NEXT:    v_fma_f32 v3, v5, v3, v3
; GFX6-FLUSH-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX6-FLUSH-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX6-FLUSH-NEXT:    v_fma_f32 v5, v6, v3, v5
; GFX6-FLUSH-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX6-FLUSH-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX6-FLUSH-NEXT:    v_div_fixup_f32 v0, v2, v0, v1
; GFX6-FLUSH-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-FLUSH-NEXT:    v_readfirstlane_b32 s0, v0
; GFX6-FLUSH-NEXT:    ; return to shader part epilog
;
; GFX89-LABEL: s_rsq_f16:
; GFX89:       ; %bb.0:
; GFX89-NEXT:    v_rsq_f16_e32 v0, s0
; GFX89-NEXT:    v_readfirstlane_b32 s0, v0
; GFX89-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: s_rsq_f16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    v_rsq_f16_e32 v0, s0
; GFX10-NEXT:    v_readfirstlane_b32 s0, v0
; GFX10-NEXT:    ; return to shader part epilog
;
; GFX11-LABEL: s_rsq_f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    v_rsq_f16_e32 v0, s0
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_readfirstlane_b32 s0, v0
; GFX11-NEXT:    ; return to shader part epilog
  %a = bitcast i16 %a.arg to half
  %sqrt = call contract half @llvm.sqrt.f16(half %a)
  %fdiv = fdiv contract half 1.0, %sqrt
  %result = bitcast half %fdiv to i16
  ret i16 %result
}

define amdgpu_ps i32 @s_rsq_v2f16(i32 inreg %a.arg) {
; GFX6-IEEE-LABEL: s_rsq_v2f16:
; GFX6-IEEE:       ; %bb.0:
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v0, s0
; GFX6-IEEE-NEXT:    s_lshr_b32 s0, s0, 16
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v1, s0
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v2, -1.0
; GFX6-IEEE-NEXT:    v_sqrt_f32_e32 v0, v0
; GFX6-IEEE-NEXT:    v_sqrt_f32_e32 v1, v1
; GFX6-IEEE-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-IEEE-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX6-IEEE-NEXT:    v_div_scale_f32 v3, s[0:1], v0, v0, v2
; GFX6-IEEE-NEXT:    v_rcp_f32_e32 v5, v3
; GFX6-IEEE-NEXT:    v_div_scale_f32 v4, vcc, v2, v0, v2
; GFX6-IEEE-NEXT:    v_div_scale_f32 v6, s[0:1], v1, v1, v2
; GFX6-IEEE-NEXT:    v_fma_f32 v9, -v3, v5, 1.0
; GFX6-IEEE-NEXT:    v_fma_f32 v5, v9, v5, v5
; GFX6-IEEE-NEXT:    v_mul_f32_e32 v9, v4, v5
; GFX6-IEEE-NEXT:    v_rcp_f32_e32 v8, v6
; GFX6-IEEE-NEXT:    v_fma_f32 v10, -v3, v9, v4
; GFX6-IEEE-NEXT:    v_fma_f32 v9, v10, v5, v9
; GFX6-IEEE-NEXT:    v_fma_f32 v3, -v3, v9, v4
; GFX6-IEEE-NEXT:    v_div_fmas_f32 v3, v3, v5, v9
; GFX6-IEEE-NEXT:    v_div_fixup_f32 v0, v3, v0, v2
; GFX6-IEEE-NEXT:    v_fma_f32 v3, -v6, v8, 1.0
; GFX6-IEEE-NEXT:    v_div_scale_f32 v7, s[0:1], v2, v1, v2
; GFX6-IEEE-NEXT:    v_fma_f32 v3, v3, v8, v8
; GFX6-IEEE-NEXT:    v_mul_f32_e32 v4, v7, v3
; GFX6-IEEE-NEXT:    v_fma_f32 v5, -v6, v4, v7
; GFX6-IEEE-NEXT:    v_fma_f32 v4, v5, v3, v4
; GFX6-IEEE-NEXT:    v_fma_f32 v5, -v6, v4, v7
; GFX6-IEEE-NEXT:    s_mov_b64 vcc, s[0:1]
; GFX6-IEEE-NEXT:    v_div_fmas_f32 v3, v5, v3, v4
; GFX6-IEEE-NEXT:    v_div_fixup_f32 v1, v3, v1, v2
; GFX6-IEEE-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX6-IEEE-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-IEEE-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX6-IEEE-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX6-IEEE-NEXT:    v_readfirstlane_b32 s0, v0
; GFX6-IEEE-NEXT:    ; return to shader part epilog
;
; GFX6-FLUSH-LABEL: s_rsq_v2f16:
; GFX6-FLUSH:       ; %bb.0:
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v0, s0
; GFX6-FLUSH-NEXT:    s_lshr_b32 s0, s0, 16
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v1, s0
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v2, -1.0
; GFX6-FLUSH-NEXT:    v_sqrt_f32_e32 v0, v0
; GFX6-FLUSH-NEXT:    v_sqrt_f32_e32 v1, v1
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 2, 2), 0
; GFX6-FLUSH-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-FLUSH-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v3, s[0:1], v0, v0, v2
; GFX6-FLUSH-NEXT:    v_rcp_f32_e32 v4, v3
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v5, vcc, v2, v0, v2
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-FLUSH-NEXT:    v_fma_f32 v6, -v3, v4, 1.0
; GFX6-FLUSH-NEXT:    v_fma_f32 v4, v6, v4, v4
; GFX6-FLUSH-NEXT:    v_mul_f32_e32 v6, v5, v4
; GFX6-FLUSH-NEXT:    v_fma_f32 v7, -v3, v6, v5
; GFX6-FLUSH-NEXT:    v_fma_f32 v6, v7, v4, v6
; GFX6-FLUSH-NEXT:    v_fma_f32 v3, -v3, v6, v5
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX6-FLUSH-NEXT:    v_div_fmas_f32 v3, v3, v4, v6
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v4, -1.0
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX6-FLUSH-NEXT:    v_div_fixup_f32 v0, v3, v0, v2
; GFX6-FLUSH-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v2, s[0:1], v1, v1, v4
; GFX6-FLUSH-NEXT:    v_rcp_f32_e32 v3, v2
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v5, vcc, v4, v1, v4
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-FLUSH-NEXT:    v_fma_f32 v6, -v2, v3, 1.0
; GFX6-FLUSH-NEXT:    v_fma_f32 v3, v6, v3, v3
; GFX6-FLUSH-NEXT:    v_mul_f32_e32 v6, v5, v3
; GFX6-FLUSH-NEXT:    v_fma_f32 v7, -v2, v6, v5
; GFX6-FLUSH-NEXT:    v_fma_f32 v6, v7, v3, v6
; GFX6-FLUSH-NEXT:    v_fma_f32 v2, -v2, v6, v5
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX6-FLUSH-NEXT:    v_div_fmas_f32 v2, v2, v3, v6
; GFX6-FLUSH-NEXT:    v_div_fixup_f32 v1, v2, v1, v4
; GFX6-FLUSH-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX6-FLUSH-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX6-FLUSH-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX6-FLUSH-NEXT:    v_readfirstlane_b32 s0, v0
; GFX6-FLUSH-NEXT:    ; return to shader part epilog
;
; GFX8-IEEE-LABEL: s_rsq_v2f16:
; GFX8-IEEE:       ; %bb.0:
; GFX8-IEEE-NEXT:    v_sqrt_f16_e32 v0, s0
; GFX8-IEEE-NEXT:    s_lshr_b32 s0, s0, 16
; GFX8-IEEE-NEXT:    v_sqrt_f16_e32 v1, s0
; GFX8-IEEE-NEXT:    v_cvt_f32_f16_e32 v4, -1.0
; GFX8-IEEE-NEXT:    v_cvt_f32_f16_e32 v2, v0
; GFX8-IEEE-NEXT:    v_cvt_f32_f16_e32 v3, v1
; GFX8-IEEE-NEXT:    v_rcp_f32_e32 v5, v2
; GFX8-IEEE-NEXT:    v_rcp_f32_e32 v6, v3
; GFX8-IEEE-NEXT:    v_mul_f32_e32 v7, v4, v5
; GFX8-IEEE-NEXT:    v_mul_f32_e64 v8, -v2, v7
; GFX8-IEEE-NEXT:    v_add_f32_e32 v8, v8, v4
; GFX8-IEEE-NEXT:    v_mul_f32_e32 v9, v4, v6
; GFX8-IEEE-NEXT:    v_mul_f32_e32 v8, v8, v5
; GFX8-IEEE-NEXT:    v_mul_f32_e64 v10, -v3, v9
; GFX8-IEEE-NEXT:    v_add_f32_e32 v7, v8, v7
; GFX8-IEEE-NEXT:    v_add_f32_e32 v10, v10, v4
; GFX8-IEEE-NEXT:    v_mul_f32_e64 v2, -v2, v7
; GFX8-IEEE-NEXT:    v_mul_f32_e32 v8, v10, v6
; GFX8-IEEE-NEXT:    v_add_f32_e32 v2, v2, v4
; GFX8-IEEE-NEXT:    v_mul_f32_e32 v2, v2, v5
; GFX8-IEEE-NEXT:    v_add_f32_e32 v5, v8, v9
; GFX8-IEEE-NEXT:    v_mul_f32_e64 v3, -v3, v5
; GFX8-IEEE-NEXT:    v_add_f32_e32 v3, v3, v4
; GFX8-IEEE-NEXT:    v_mul_f32_e32 v3, v3, v6
; GFX8-IEEE-NEXT:    v_and_b32_e32 v3, 0xff800000, v3
; GFX8-IEEE-NEXT:    v_and_b32_e32 v2, 0xff800000, v2
; GFX8-IEEE-NEXT:    v_add_f32_e32 v3, v3, v5
; GFX8-IEEE-NEXT:    v_add_f32_e32 v2, v2, v7
; GFX8-IEEE-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX8-IEEE-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX8-IEEE-NEXT:    v_div_fixup_f16 v1, v3, v1, -1.0
; GFX8-IEEE-NEXT:    v_div_fixup_f16 v0, v2, v0, -1.0
; GFX8-IEEE-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX8-IEEE-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX8-IEEE-NEXT:    v_readfirstlane_b32 s0, v0
; GFX8-IEEE-NEXT:    ; return to shader part epilog
;
; GFX8-FLUSH-LABEL: s_rsq_v2f16:
; GFX8-FLUSH:       ; %bb.0:
; GFX8-FLUSH-NEXT:    v_sqrt_f16_e32 v0, s0
; GFX8-FLUSH-NEXT:    s_lshr_b32 s0, s0, 16
; GFX8-FLUSH-NEXT:    v_sqrt_f16_e32 v1, s0
; GFX8-FLUSH-NEXT:    v_cvt_f32_f16_e32 v4, -1.0
; GFX8-FLUSH-NEXT:    v_cvt_f32_f16_e32 v2, v0
; GFX8-FLUSH-NEXT:    v_cvt_f32_f16_e32 v3, v1
; GFX8-FLUSH-NEXT:    v_rcp_f32_e32 v5, v2
; GFX8-FLUSH-NEXT:    v_rcp_f32_e32 v6, v3
; GFX8-FLUSH-NEXT:    v_mul_f32_e32 v7, v4, v5
; GFX8-FLUSH-NEXT:    v_mad_f32 v8, -v2, v7, v4
; GFX8-FLUSH-NEXT:    v_mul_f32_e32 v9, v4, v6
; GFX8-FLUSH-NEXT:    v_mac_f32_e32 v7, v8, v5
; GFX8-FLUSH-NEXT:    v_mad_f32 v8, -v3, v9, v4
; GFX8-FLUSH-NEXT:    v_mac_f32_e32 v9, v8, v6
; GFX8-FLUSH-NEXT:    v_mad_f32 v3, -v3, v9, v4
; GFX8-FLUSH-NEXT:    v_mad_f32 v2, -v2, v7, v4
; GFX8-FLUSH-NEXT:    v_mul_f32_e32 v3, v3, v6
; GFX8-FLUSH-NEXT:    v_mul_f32_e32 v2, v2, v5
; GFX8-FLUSH-NEXT:    v_and_b32_e32 v3, 0xff800000, v3
; GFX8-FLUSH-NEXT:    v_and_b32_e32 v2, 0xff800000, v2
; GFX8-FLUSH-NEXT:    v_add_f32_e32 v3, v3, v9
; GFX8-FLUSH-NEXT:    v_add_f32_e32 v2, v2, v7
; GFX8-FLUSH-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX8-FLUSH-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX8-FLUSH-NEXT:    v_div_fixup_f16 v1, v3, v1, -1.0
; GFX8-FLUSH-NEXT:    v_div_fixup_f16 v0, v2, v0, -1.0
; GFX8-FLUSH-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX8-FLUSH-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX8-FLUSH-NEXT:    v_readfirstlane_b32 s0, v0
; GFX8-FLUSH-NEXT:    ; return to shader part epilog
;
; GFX9-IEEE-LABEL: s_rsq_v2f16:
; GFX9-IEEE:       ; %bb.0:
; GFX9-IEEE-NEXT:    v_sqrt_f16_e32 v0, s0
; GFX9-IEEE-NEXT:    s_lshr_b32 s0, s0, 16
; GFX9-IEEE-NEXT:    v_sqrt_f16_e32 v1, s0
; GFX9-IEEE-NEXT:    v_cvt_f32_f16_e32 v4, -1.0
; GFX9-IEEE-NEXT:    v_cvt_f32_f16_e32 v2, v0
; GFX9-IEEE-NEXT:    v_cvt_f32_f16_e32 v3, v1
; GFX9-IEEE-NEXT:    v_rcp_f32_e32 v5, v2
; GFX9-IEEE-NEXT:    v_rcp_f32_e32 v6, v3
; GFX9-IEEE-NEXT:    v_mul_f32_e32 v7, v4, v5
; GFX9-IEEE-NEXT:    v_fma_f32 v8, -v2, v7, v4
; GFX9-IEEE-NEXT:    v_mul_f32_e32 v9, v4, v6
; GFX9-IEEE-NEXT:    v_fma_f32 v7, v8, v5, v7
; GFX9-IEEE-NEXT:    v_fma_f32 v8, -v3, v9, v4
; GFX9-IEEE-NEXT:    v_fma_f32 v8, v8, v6, v9
; GFX9-IEEE-NEXT:    v_fma_f32 v2, -v2, v7, v4
; GFX9-IEEE-NEXT:    v_fma_f32 v3, -v3, v8, v4
; GFX9-IEEE-NEXT:    v_mul_f32_e32 v2, v2, v5
; GFX9-IEEE-NEXT:    v_mul_f32_e32 v3, v3, v6
; GFX9-IEEE-NEXT:    v_and_b32_e32 v2, 0xff800000, v2
; GFX9-IEEE-NEXT:    v_and_b32_e32 v3, 0xff800000, v3
; GFX9-IEEE-NEXT:    v_add_f32_e32 v2, v2, v7
; GFX9-IEEE-NEXT:    v_add_f32_e32 v3, v3, v8
; GFX9-IEEE-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX9-IEEE-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX9-IEEE-NEXT:    v_div_fixup_f16 v0, v2, v0, -1.0
; GFX9-IEEE-NEXT:    v_div_fixup_f16 v1, v3, v1, -1.0
; GFX9-IEEE-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX9-IEEE-NEXT:    v_readfirstlane_b32 s0, v0
; GFX9-IEEE-NEXT:    ; return to shader part epilog
;
; GFX9-FLUSH-LABEL: s_rsq_v2f16:
; GFX9-FLUSH:       ; %bb.0:
; GFX9-FLUSH-NEXT:    v_sqrt_f16_e32 v0, s0
; GFX9-FLUSH-NEXT:    s_lshr_b32 s0, s0, 16
; GFX9-FLUSH-NEXT:    v_sqrt_f16_e32 v1, s0
; GFX9-FLUSH-NEXT:    v_cvt_f32_f16_e32 v4, -1.0
; GFX9-FLUSH-NEXT:    v_cvt_f32_f16_e32 v2, v0
; GFX9-FLUSH-NEXT:    v_cvt_f32_f16_e32 v3, v1
; GFX9-FLUSH-NEXT:    v_rcp_f32_e32 v2, v2
; GFX9-FLUSH-NEXT:    v_rcp_f32_e32 v3, v3
; GFX9-FLUSH-NEXT:    v_mul_f32_e32 v5, v4, v2
; GFX9-FLUSH-NEXT:    v_mad_mix_f32 v6, -v0, v5, -1.0 op_sel_hi:[1,0,1]
; GFX9-FLUSH-NEXT:    v_mul_f32_e32 v4, v4, v3
; GFX9-FLUSH-NEXT:    v_mac_f32_e32 v5, v6, v2
; GFX9-FLUSH-NEXT:    v_mad_mix_f32 v6, -v1, v4, -1.0 op_sel_hi:[1,0,1]
; GFX9-FLUSH-NEXT:    v_mac_f32_e32 v4, v6, v3
; GFX9-FLUSH-NEXT:    v_mad_mix_f32 v7, -v0, v5, -1.0 op_sel_hi:[1,0,1]
; GFX9-FLUSH-NEXT:    v_mad_mix_f32 v6, -v1, v4, -1.0 op_sel_hi:[1,0,1]
; GFX9-FLUSH-NEXT:    v_mul_f32_e32 v2, v7, v2
; GFX9-FLUSH-NEXT:    v_mul_f32_e32 v3, v6, v3
; GFX9-FLUSH-NEXT:    v_and_b32_e32 v2, 0xff800000, v2
; GFX9-FLUSH-NEXT:    v_and_b32_e32 v3, 0xff800000, v3
; GFX9-FLUSH-NEXT:    v_add_f32_e32 v2, v2, v5
; GFX9-FLUSH-NEXT:    v_add_f32_e32 v3, v3, v4
; GFX9-FLUSH-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX9-FLUSH-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX9-FLUSH-NEXT:    v_div_fixup_f16 v0, v2, v0, -1.0
; GFX9-FLUSH-NEXT:    v_div_fixup_f16 v1, v3, v1, -1.0
; GFX9-FLUSH-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX9-FLUSH-NEXT:    v_readfirstlane_b32 s0, v0
; GFX9-FLUSH-NEXT:    ; return to shader part epilog
;
; GFX10-IEEE-LABEL: s_rsq_v2f16:
; GFX10-IEEE:       ; %bb.0:
; GFX10-IEEE-NEXT:    s_lshr_b32 s1, s0, 16
; GFX10-IEEE-NEXT:    v_sqrt_f16_e32 v0, s0
; GFX10-IEEE-NEXT:    v_sqrt_f16_e32 v1, s1
; GFX10-IEEE-NEXT:    v_cvt_f32_f16_e32 v4, -1.0
; GFX10-IEEE-NEXT:    v_cvt_f32_f16_e32 v2, v0
; GFX10-IEEE-NEXT:    v_cvt_f32_f16_e32 v3, v1
; GFX10-IEEE-NEXT:    v_rcp_f32_e32 v2, v2
; GFX10-IEEE-NEXT:    v_rcp_f32_e32 v3, v3
; GFX10-IEEE-NEXT:    v_mul_f32_e32 v5, v4, v2
; GFX10-IEEE-NEXT:    v_mul_f32_e32 v4, v4, v3
; GFX10-IEEE-NEXT:    v_fma_mix_f32 v6, -v0, v5, -1.0 op_sel_hi:[1,0,1]
; GFX10-IEEE-NEXT:    v_fma_mix_f32 v7, -v1, v4, -1.0 op_sel_hi:[1,0,1]
; GFX10-IEEE-NEXT:    v_fmac_f32_e32 v5, v6, v2
; GFX10-IEEE-NEXT:    v_fmac_f32_e32 v4, v7, v3
; GFX10-IEEE-NEXT:    v_fma_mix_f32 v6, -v0, v5, -1.0 op_sel_hi:[1,0,1]
; GFX10-IEEE-NEXT:    v_fma_mix_f32 v7, -v1, v4, -1.0 op_sel_hi:[1,0,1]
; GFX10-IEEE-NEXT:    v_mul_f32_e32 v2, v6, v2
; GFX10-IEEE-NEXT:    v_mul_f32_e32 v3, v7, v3
; GFX10-IEEE-NEXT:    v_and_b32_e32 v2, 0xff800000, v2
; GFX10-IEEE-NEXT:    v_and_b32_e32 v3, 0xff800000, v3
; GFX10-IEEE-NEXT:    v_add_f32_e32 v2, v2, v5
; GFX10-IEEE-NEXT:    v_add_f32_e32 v3, v3, v4
; GFX10-IEEE-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX10-IEEE-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX10-IEEE-NEXT:    v_div_fixup_f16 v0, v2, v0, -1.0
; GFX10-IEEE-NEXT:    v_div_fixup_f16 v1, v3, v1, -1.0
; GFX10-IEEE-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX10-IEEE-NEXT:    v_readfirstlane_b32 s0, v0
; GFX10-IEEE-NEXT:    ; return to shader part epilog
;
; GFX10-FLUSH-LABEL: s_rsq_v2f16:
; GFX10-FLUSH:       ; %bb.0:
; GFX10-FLUSH-NEXT:    s_lshr_b32 s1, s0, 16
; GFX10-FLUSH-NEXT:    v_sqrt_f16_e32 v0, s0
; GFX10-FLUSH-NEXT:    v_sqrt_f16_e32 v1, s1
; GFX10-FLUSH-NEXT:    v_cvt_f32_f16_e32 v6, -1.0
; GFX10-FLUSH-NEXT:    v_cvt_f32_f16_e32 v2, v0
; GFX10-FLUSH-NEXT:    v_cvt_f32_f16_e32 v3, v1
; GFX10-FLUSH-NEXT:    v_rcp_f32_e32 v4, v2
; GFX10-FLUSH-NEXT:    v_rcp_f32_e32 v5, v3
; GFX10-FLUSH-NEXT:    v_mul_f32_e32 v7, v6, v4
; GFX10-FLUSH-NEXT:    v_mul_f32_e32 v8, v6, v5
; GFX10-FLUSH-NEXT:    v_mad_f32 v9, -v2, v7, v6
; GFX10-FLUSH-NEXT:    v_mad_f32 v10, -v3, v8, v6
; GFX10-FLUSH-NEXT:    v_mac_f32_e32 v7, v9, v4
; GFX10-FLUSH-NEXT:    v_mac_f32_e32 v8, v10, v5
; GFX10-FLUSH-NEXT:    v_mad_f32 v2, -v2, v7, v6
; GFX10-FLUSH-NEXT:    v_mad_f32 v3, -v3, v8, v6
; GFX10-FLUSH-NEXT:    v_mul_f32_e32 v2, v2, v4
; GFX10-FLUSH-NEXT:    v_mul_f32_e32 v3, v3, v5
; GFX10-FLUSH-NEXT:    v_and_b32_e32 v2, 0xff800000, v2
; GFX10-FLUSH-NEXT:    v_and_b32_e32 v3, 0xff800000, v3
; GFX10-FLUSH-NEXT:    v_add_f32_e32 v2, v2, v7
; GFX10-FLUSH-NEXT:    v_add_f32_e32 v3, v3, v8
; GFX10-FLUSH-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX10-FLUSH-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX10-FLUSH-NEXT:    v_div_fixup_f16 v0, v2, v0, -1.0
; GFX10-FLUSH-NEXT:    v_div_fixup_f16 v1, v3, v1, -1.0
; GFX10-FLUSH-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX10-FLUSH-NEXT:    v_readfirstlane_b32 s0, v0
; GFX10-FLUSH-NEXT:    ; return to shader part epilog
;
; GFX11-LABEL: s_rsq_v2f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_lshr_b32 s1, s0, 16
; GFX11-NEXT:    v_sqrt_f16_e32 v0, s0
; GFX11-NEXT:    v_sqrt_f16_e32 v1, s1
; GFX11-NEXT:    v_cvt_f32_f16_e32 v4, -1.0
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_cvt_f32_f16_e32 v2, v0
; GFX11-NEXT:    v_cvt_f32_f16_e32 v3, v1
; GFX11-NEXT:    v_rcp_f32_e32 v2, v2
; GFX11-NEXT:    v_rcp_f32_e32 v3, v3
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_mul_f32_e32 v5, v4, v2
; GFX11-NEXT:    v_mul_f32_e32 v4, v4, v3
; GFX11-NEXT:    v_fma_mix_f32 v7, -v1, v4, -1.0 op_sel_hi:[1,0,1]
; GFX11-NEXT:    v_fmac_f32_e32 v4, v7, v3
; GFX11-NEXT:    v_fma_mix_f32 v6, -v0, v5, -1.0 op_sel_hi:[1,0,1]
; GFX11-NEXT:    v_fma_mix_f32 v7, -v1, v4, -1.0 op_sel_hi:[1,0,1]
; GFX11-NEXT:    v_fmac_f32_e32 v5, v6, v2
; GFX11-NEXT:    v_mul_f32_e32 v3, v7, v3
; GFX11-NEXT:    v_fma_mix_f32 v6, -v0, v5, -1.0 op_sel_hi:[1,0,1]
; GFX11-NEXT:    v_dual_mul_f32 v2, v6, v2 :: v_dual_and_b32 v3, 0xff800000, v3
; GFX11-NEXT:    v_dual_add_f32 v3, v3, v4 :: v_dual_and_b32 v2, 0xff800000, v2
; GFX11-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX11-NEXT:    v_add_f32_e32 v2, v2, v5
; GFX11-NEXT:    v_div_fixup_f16 v1, v3, v1, -1.0
; GFX11-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX11-NEXT:    v_div_fixup_f16 v0, v2, v0, -1.0
; GFX11-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX11-NEXT:    v_readfirstlane_b32 s0, v0
; GFX11-NEXT:    ; return to shader part epilog
  %a = bitcast i32 %a.arg to <2 x half>
  %sqrt = call contract <2 x half> @llvm.sqrt.v2f16(<2 x half> %a)
  %fdiv = fdiv contract <2 x half> <half -1.0, half -1.0>, %sqrt
  %result = bitcast <2 x half> %fdiv to i32
  ret i32 %result
}

define half @v_rsq_f16(half %a) {
; GFX6-IEEE-LABEL: v_rsq_f16:
; GFX6-IEEE:       ; %bb.0:
; GFX6-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v1, 1.0
; GFX6-IEEE-NEXT:    v_sqrt_f32_e32 v0, v0
; GFX6-IEEE-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-IEEE-NEXT:    v_div_scale_f32 v2, s[4:5], v0, v0, v1
; GFX6-IEEE-NEXT:    v_rcp_f32_e32 v3, v2
; GFX6-IEEE-NEXT:    v_div_scale_f32 v4, vcc, v1, v0, v1
; GFX6-IEEE-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX6-IEEE-NEXT:    v_fma_f32 v3, v5, v3, v3
; GFX6-IEEE-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX6-IEEE-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX6-IEEE-NEXT:    v_fma_f32 v5, v6, v3, v5
; GFX6-IEEE-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX6-IEEE-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX6-IEEE-NEXT:    v_div_fixup_f32 v0, v2, v0, v1
; GFX6-IEEE-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-FLUSH-LABEL: v_rsq_f16:
; GFX6-FLUSH:       ; %bb.0:
; GFX6-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v1, 1.0
; GFX6-FLUSH-NEXT:    v_sqrt_f32_e32 v0, v0
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 2, 2), 0
; GFX6-FLUSH-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v2, s[4:5], v0, v0, v1
; GFX6-FLUSH-NEXT:    v_rcp_f32_e32 v3, v2
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v4, vcc, v1, v0, v1
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-FLUSH-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX6-FLUSH-NEXT:    v_fma_f32 v3, v5, v3, v3
; GFX6-FLUSH-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX6-FLUSH-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX6-FLUSH-NEXT:    v_fma_f32 v5, v6, v3, v5
; GFX6-FLUSH-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX6-FLUSH-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX6-FLUSH-NEXT:    v_div_fixup_f32 v0, v2, v0, v1
; GFX6-FLUSH-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-FLUSH-NEXT:    s_setpc_b64 s[30:31]
;
; GFX89-LABEL: v_rsq_f16:
; GFX89:       ; %bb.0:
; GFX89-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX89-NEXT:    v_rsq_f16_e32 v0, v0
; GFX89-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10PLUS-LABEL: v_rsq_f16:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10PLUS-NEXT:    v_rsq_f16_e32 v0, v0
; GFX10PLUS-NEXT:    s_setpc_b64 s[30:31]
  %sqrt = call contract half @llvm.sqrt.f16(half %a)
  %fdiv = fdiv contract half 1.0, %sqrt
  ret half %fdiv
}

define half @v_neg_rsq_f16(half %a) {
; GFX6-IEEE-LABEL: v_neg_rsq_f16:
; GFX6-IEEE:       ; %bb.0:
; GFX6-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v1, -1.0
; GFX6-IEEE-NEXT:    v_sqrt_f32_e32 v0, v0
; GFX6-IEEE-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-IEEE-NEXT:    v_div_scale_f32 v2, s[4:5], v0, v0, v1
; GFX6-IEEE-NEXT:    v_rcp_f32_e32 v3, v2
; GFX6-IEEE-NEXT:    v_div_scale_f32 v4, vcc, v1, v0, v1
; GFX6-IEEE-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX6-IEEE-NEXT:    v_fma_f32 v3, v5, v3, v3
; GFX6-IEEE-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX6-IEEE-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX6-IEEE-NEXT:    v_fma_f32 v5, v6, v3, v5
; GFX6-IEEE-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX6-IEEE-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX6-IEEE-NEXT:    v_div_fixup_f32 v0, v2, v0, v1
; GFX6-IEEE-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-FLUSH-LABEL: v_neg_rsq_f16:
; GFX6-FLUSH:       ; %bb.0:
; GFX6-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v1, -1.0
; GFX6-FLUSH-NEXT:    v_sqrt_f32_e32 v0, v0
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 2, 2), 0
; GFX6-FLUSH-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v2, s[4:5], v0, v0, v1
; GFX6-FLUSH-NEXT:    v_rcp_f32_e32 v3, v2
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v4, vcc, v1, v0, v1
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-FLUSH-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX6-FLUSH-NEXT:    v_fma_f32 v3, v5, v3, v3
; GFX6-FLUSH-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX6-FLUSH-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX6-FLUSH-NEXT:    v_fma_f32 v5, v6, v3, v5
; GFX6-FLUSH-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX6-FLUSH-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX6-FLUSH-NEXT:    v_div_fixup_f32 v0, v2, v0, v1
; GFX6-FLUSH-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-FLUSH-NEXT:    s_setpc_b64 s[30:31]
;
; GFX89-LABEL: v_neg_rsq_f16:
; GFX89:       ; %bb.0:
; GFX89-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX89-NEXT:    v_sqrt_f16_e32 v0, v0
; GFX89-NEXT:    v_rcp_f16_e64 v0, -v0
; GFX89-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_neg_rsq_f16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_sqrt_f16_e32 v0, v0
; GFX10-NEXT:    v_rcp_f16_e64 v0, -v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_neg_rsq_f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_sqrt_f16_e32 v0, v0
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_rcp_f16_e64 v0, -v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %sqrt = call contract half @llvm.sqrt.f16(half %a)
  %fdiv = fdiv contract half -1.0, %sqrt
  ret half %fdiv
}

define { half, half } @v_rsq_f16_multi_use(half %a) {
; GFX6-IEEE-LABEL: v_rsq_f16_multi_use:
; GFX6-IEEE:       ; %bb.0:
; GFX6-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v1, 1.0
; GFX6-IEEE-NEXT:    v_sqrt_f32_e32 v0, v0
; GFX6-IEEE-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v2, v0
; GFX6-IEEE-NEXT:    v_div_scale_f32 v3, s[4:5], v2, v2, v1
; GFX6-IEEE-NEXT:    v_rcp_f32_e32 v4, v3
; GFX6-IEEE-NEXT:    v_div_scale_f32 v5, vcc, v1, v2, v1
; GFX6-IEEE-NEXT:    v_fma_f32 v6, -v3, v4, 1.0
; GFX6-IEEE-NEXT:    v_fma_f32 v4, v6, v4, v4
; GFX6-IEEE-NEXT:    v_mul_f32_e32 v6, v5, v4
; GFX6-IEEE-NEXT:    v_fma_f32 v7, -v3, v6, v5
; GFX6-IEEE-NEXT:    v_fma_f32 v6, v7, v4, v6
; GFX6-IEEE-NEXT:    v_fma_f32 v3, -v3, v6, v5
; GFX6-IEEE-NEXT:    v_div_fmas_f32 v3, v3, v4, v6
; GFX6-IEEE-NEXT:    v_div_fixup_f32 v1, v3, v2, v1
; GFX6-IEEE-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX6-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-FLUSH-LABEL: v_rsq_f16_multi_use:
; GFX6-FLUSH:       ; %bb.0:
; GFX6-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v1, 1.0
; GFX6-FLUSH-NEXT:    v_sqrt_f32_e32 v0, v0
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 2, 2), 0
; GFX6-FLUSH-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v2, v0
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v3, s[4:5], v2, v2, v1
; GFX6-FLUSH-NEXT:    v_rcp_f32_e32 v4, v3
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v5, vcc, v1, v2, v1
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-FLUSH-NEXT:    v_fma_f32 v6, -v3, v4, 1.0
; GFX6-FLUSH-NEXT:    v_fma_f32 v4, v6, v4, v4
; GFX6-FLUSH-NEXT:    v_mul_f32_e32 v6, v5, v4
; GFX6-FLUSH-NEXT:    v_fma_f32 v7, -v3, v6, v5
; GFX6-FLUSH-NEXT:    v_fma_f32 v6, v7, v4, v6
; GFX6-FLUSH-NEXT:    v_fma_f32 v3, -v3, v6, v5
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX6-FLUSH-NEXT:    v_div_fmas_f32 v3, v3, v4, v6
; GFX6-FLUSH-NEXT:    v_div_fixup_f32 v1, v3, v2, v1
; GFX6-FLUSH-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX6-FLUSH-NEXT:    s_setpc_b64 s[30:31]
;
; GFX89-LABEL: v_rsq_f16_multi_use:
; GFX89:       ; %bb.0:
; GFX89-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX89-NEXT:    v_sqrt_f16_e32 v2, v0
; GFX89-NEXT:    v_rsq_f16_e32 v1, v0
; GFX89-NEXT:    v_mov_b32_e32 v0, v2
; GFX89-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_rsq_f16_multi_use:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_sqrt_f16_e32 v2, v0
; GFX10-NEXT:    v_rsq_f16_e32 v1, v0
; GFX10-NEXT:    v_mov_b32_e32 v0, v2
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_rsq_f16_multi_use:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_sqrt_f16_e32 v2, v0
; GFX11-NEXT:    v_rsq_f16_e32 v1, v0
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_mov_b32_e32 v0, v2
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %sqrt = call contract half @llvm.sqrt.f16(half %a)
  %insert.0 = insertvalue { half, half } poison, half %sqrt, 0
  %fdiv = fdiv contract half 1.0, %sqrt
  %insert.1 = insertvalue { half, half } %insert.0, half %fdiv, 1
  ret { half, half } %insert.1
}

define half @v_rsq_f16_missing_contract0(half %a) {
; GFX6-IEEE-LABEL: v_rsq_f16_missing_contract0:
; GFX6-IEEE:       ; %bb.0:
; GFX6-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v1, 1.0
; GFX6-IEEE-NEXT:    v_sqrt_f32_e32 v0, v0
; GFX6-IEEE-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-IEEE-NEXT:    v_div_scale_f32 v2, s[4:5], v0, v0, v1
; GFX6-IEEE-NEXT:    v_rcp_f32_e32 v3, v2
; GFX6-IEEE-NEXT:    v_div_scale_f32 v4, vcc, v1, v0, v1
; GFX6-IEEE-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX6-IEEE-NEXT:    v_fma_f32 v3, v5, v3, v3
; GFX6-IEEE-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX6-IEEE-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX6-IEEE-NEXT:    v_fma_f32 v5, v6, v3, v5
; GFX6-IEEE-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX6-IEEE-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX6-IEEE-NEXT:    v_div_fixup_f32 v0, v2, v0, v1
; GFX6-IEEE-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-FLUSH-LABEL: v_rsq_f16_missing_contract0:
; GFX6-FLUSH:       ; %bb.0:
; GFX6-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v1, 1.0
; GFX6-FLUSH-NEXT:    v_sqrt_f32_e32 v0, v0
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 2, 2), 0
; GFX6-FLUSH-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v2, s[4:5], v0, v0, v1
; GFX6-FLUSH-NEXT:    v_rcp_f32_e32 v3, v2
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v4, vcc, v1, v0, v1
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-FLUSH-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX6-FLUSH-NEXT:    v_fma_f32 v3, v5, v3, v3
; GFX6-FLUSH-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX6-FLUSH-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX6-FLUSH-NEXT:    v_fma_f32 v5, v6, v3, v5
; GFX6-FLUSH-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX6-FLUSH-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX6-FLUSH-NEXT:    v_div_fixup_f32 v0, v2, v0, v1
; GFX6-FLUSH-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-FLUSH-NEXT:    s_setpc_b64 s[30:31]
;
; GFX89-LABEL: v_rsq_f16_missing_contract0:
; GFX89:       ; %bb.0:
; GFX89-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX89-NEXT:    v_sqrt_f16_e32 v0, v0
; GFX89-NEXT:    v_rcp_f16_e32 v0, v0
; GFX89-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_rsq_f16_missing_contract0:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_sqrt_f16_e32 v0, v0
; GFX10-NEXT:    v_rcp_f16_e32 v0, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_rsq_f16_missing_contract0:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_sqrt_f16_e32 v0, v0
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_rcp_f16_e32 v0, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %sqrt = call half @llvm.sqrt.f16(half %a)
  %fdiv = fdiv contract half 1.0, %sqrt
  ret half %fdiv
}

define half @v_rsq_f16_missing_contract1(half %a) {
; GFX6-IEEE-LABEL: v_rsq_f16_missing_contract1:
; GFX6-IEEE:       ; %bb.0:
; GFX6-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v1, 1.0
; GFX6-IEEE-NEXT:    v_sqrt_f32_e32 v0, v0
; GFX6-IEEE-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-IEEE-NEXT:    v_div_scale_f32 v2, s[4:5], v0, v0, v1
; GFX6-IEEE-NEXT:    v_rcp_f32_e32 v3, v2
; GFX6-IEEE-NEXT:    v_div_scale_f32 v4, vcc, v1, v0, v1
; GFX6-IEEE-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX6-IEEE-NEXT:    v_fma_f32 v3, v5, v3, v3
; GFX6-IEEE-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX6-IEEE-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX6-IEEE-NEXT:    v_fma_f32 v5, v6, v3, v5
; GFX6-IEEE-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX6-IEEE-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX6-IEEE-NEXT:    v_div_fixup_f32 v0, v2, v0, v1
; GFX6-IEEE-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-FLUSH-LABEL: v_rsq_f16_missing_contract1:
; GFX6-FLUSH:       ; %bb.0:
; GFX6-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v1, 1.0
; GFX6-FLUSH-NEXT:    v_sqrt_f32_e32 v0, v0
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 2, 2), 0
; GFX6-FLUSH-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v2, s[4:5], v0, v0, v1
; GFX6-FLUSH-NEXT:    v_rcp_f32_e32 v3, v2
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v4, vcc, v1, v0, v1
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-FLUSH-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX6-FLUSH-NEXT:    v_fma_f32 v3, v5, v3, v3
; GFX6-FLUSH-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX6-FLUSH-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX6-FLUSH-NEXT:    v_fma_f32 v5, v6, v3, v5
; GFX6-FLUSH-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX6-FLUSH-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX6-FLUSH-NEXT:    v_div_fixup_f32 v0, v2, v0, v1
; GFX6-FLUSH-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-FLUSH-NEXT:    s_setpc_b64 s[30:31]
;
; GFX89-LABEL: v_rsq_f16_missing_contract1:
; GFX89:       ; %bb.0:
; GFX89-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX89-NEXT:    v_sqrt_f16_e32 v0, v0
; GFX89-NEXT:    v_rcp_f16_e32 v0, v0
; GFX89-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_rsq_f16_missing_contract1:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_sqrt_f16_e32 v0, v0
; GFX10-NEXT:    v_rcp_f16_e32 v0, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_rsq_f16_missing_contract1:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_sqrt_f16_e32 v0, v0
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_rcp_f16_e32 v0, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %sqrt = call contract half @llvm.sqrt.f16(half %a)
  %fdiv = fdiv half 1.0, %sqrt
  ret half %fdiv
}

define half @v_neg_rsq_f16_missing_contract0(half %a) {
; GFX6-IEEE-LABEL: v_neg_rsq_f16_missing_contract0:
; GFX6-IEEE:       ; %bb.0:
; GFX6-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v1, -1.0
; GFX6-IEEE-NEXT:    v_sqrt_f32_e32 v0, v0
; GFX6-IEEE-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-IEEE-NEXT:    v_div_scale_f32 v2, s[4:5], v0, v0, v1
; GFX6-IEEE-NEXT:    v_rcp_f32_e32 v3, v2
; GFX6-IEEE-NEXT:    v_div_scale_f32 v4, vcc, v1, v0, v1
; GFX6-IEEE-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX6-IEEE-NEXT:    v_fma_f32 v3, v5, v3, v3
; GFX6-IEEE-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX6-IEEE-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX6-IEEE-NEXT:    v_fma_f32 v5, v6, v3, v5
; GFX6-IEEE-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX6-IEEE-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX6-IEEE-NEXT:    v_div_fixup_f32 v0, v2, v0, v1
; GFX6-IEEE-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-FLUSH-LABEL: v_neg_rsq_f16_missing_contract0:
; GFX6-FLUSH:       ; %bb.0:
; GFX6-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v1, -1.0
; GFX6-FLUSH-NEXT:    v_sqrt_f32_e32 v0, v0
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 2, 2), 0
; GFX6-FLUSH-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v2, s[4:5], v0, v0, v1
; GFX6-FLUSH-NEXT:    v_rcp_f32_e32 v3, v2
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v4, vcc, v1, v0, v1
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-FLUSH-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX6-FLUSH-NEXT:    v_fma_f32 v3, v5, v3, v3
; GFX6-FLUSH-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX6-FLUSH-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX6-FLUSH-NEXT:    v_fma_f32 v5, v6, v3, v5
; GFX6-FLUSH-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX6-FLUSH-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX6-FLUSH-NEXT:    v_div_fixup_f32 v0, v2, v0, v1
; GFX6-FLUSH-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-FLUSH-NEXT:    s_setpc_b64 s[30:31]
;
; GFX89-LABEL: v_neg_rsq_f16_missing_contract0:
; GFX89:       ; %bb.0:
; GFX89-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX89-NEXT:    v_sqrt_f16_e32 v0, v0
; GFX89-NEXT:    v_rcp_f16_e64 v0, -v0
; GFX89-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_neg_rsq_f16_missing_contract0:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_sqrt_f16_e32 v0, v0
; GFX10-NEXT:    v_rcp_f16_e64 v0, -v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_neg_rsq_f16_missing_contract0:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_sqrt_f16_e32 v0, v0
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_rcp_f16_e64 v0, -v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %sqrt = call half @llvm.sqrt.f16(half %a)
  %fdiv = fdiv contract half -1.0, %sqrt
  ret half %fdiv
}

define half @v_neg_rsq_f16_missing_contract1(half %a) {
; GFX6-IEEE-LABEL: v_neg_rsq_f16_missing_contract1:
; GFX6-IEEE:       ; %bb.0:
; GFX6-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v1, -1.0
; GFX6-IEEE-NEXT:    v_sqrt_f32_e32 v0, v0
; GFX6-IEEE-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-IEEE-NEXT:    v_div_scale_f32 v2, s[4:5], v0, v0, v1
; GFX6-IEEE-NEXT:    v_rcp_f32_e32 v3, v2
; GFX6-IEEE-NEXT:    v_div_scale_f32 v4, vcc, v1, v0, v1
; GFX6-IEEE-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX6-IEEE-NEXT:    v_fma_f32 v3, v5, v3, v3
; GFX6-IEEE-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX6-IEEE-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX6-IEEE-NEXT:    v_fma_f32 v5, v6, v3, v5
; GFX6-IEEE-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX6-IEEE-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX6-IEEE-NEXT:    v_div_fixup_f32 v0, v2, v0, v1
; GFX6-IEEE-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-FLUSH-LABEL: v_neg_rsq_f16_missing_contract1:
; GFX6-FLUSH:       ; %bb.0:
; GFX6-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v1, -1.0
; GFX6-FLUSH-NEXT:    v_sqrt_f32_e32 v0, v0
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 2, 2), 0
; GFX6-FLUSH-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v2, s[4:5], v0, v0, v1
; GFX6-FLUSH-NEXT:    v_rcp_f32_e32 v3, v2
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v4, vcc, v1, v0, v1
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-FLUSH-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX6-FLUSH-NEXT:    v_fma_f32 v3, v5, v3, v3
; GFX6-FLUSH-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX6-FLUSH-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX6-FLUSH-NEXT:    v_fma_f32 v5, v6, v3, v5
; GFX6-FLUSH-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX6-FLUSH-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX6-FLUSH-NEXT:    v_div_fixup_f32 v0, v2, v0, v1
; GFX6-FLUSH-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-FLUSH-NEXT:    s_setpc_b64 s[30:31]
;
; GFX89-LABEL: v_neg_rsq_f16_missing_contract1:
; GFX89:       ; %bb.0:
; GFX89-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX89-NEXT:    v_sqrt_f16_e32 v0, v0
; GFX89-NEXT:    v_rcp_f16_e64 v0, -v0
; GFX89-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_neg_rsq_f16_missing_contract1:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_sqrt_f16_e32 v0, v0
; GFX10-NEXT:    v_rcp_f16_e64 v0, -v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_neg_rsq_f16_missing_contract1:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_sqrt_f16_e32 v0, v0
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_rcp_f16_e64 v0, -v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %sqrt = call contract half @llvm.sqrt.f16(half %a)
  %fdiv = fdiv half -1.0, %sqrt
  ret half %fdiv
}

define half @v_neg_rsq_f16_fabs(half %a) {
; GFX6-IEEE-LABEL: v_neg_rsq_f16_fabs:
; GFX6-IEEE:       ; %bb.0:
; GFX6-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e64 v0, |v0|
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v1, -1.0
; GFX6-IEEE-NEXT:    v_sqrt_f32_e32 v0, v0
; GFX6-IEEE-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-IEEE-NEXT:    v_div_scale_f32 v2, s[4:5], v0, v0, v1
; GFX6-IEEE-NEXT:    v_rcp_f32_e32 v3, v2
; GFX6-IEEE-NEXT:    v_div_scale_f32 v4, vcc, v1, v0, v1
; GFX6-IEEE-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX6-IEEE-NEXT:    v_fma_f32 v3, v5, v3, v3
; GFX6-IEEE-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX6-IEEE-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX6-IEEE-NEXT:    v_fma_f32 v5, v6, v3, v5
; GFX6-IEEE-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX6-IEEE-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX6-IEEE-NEXT:    v_div_fixup_f32 v0, v2, v0, v1
; GFX6-IEEE-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-FLUSH-LABEL: v_neg_rsq_f16_fabs:
; GFX6-FLUSH:       ; %bb.0:
; GFX6-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e64 v0, |v0|
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v1, -1.0
; GFX6-FLUSH-NEXT:    v_sqrt_f32_e32 v0, v0
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 2, 2), 0
; GFX6-FLUSH-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v2, s[4:5], v0, v0, v1
; GFX6-FLUSH-NEXT:    v_rcp_f32_e32 v3, v2
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v4, vcc, v1, v0, v1
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-FLUSH-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX6-FLUSH-NEXT:    v_fma_f32 v3, v5, v3, v3
; GFX6-FLUSH-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX6-FLUSH-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX6-FLUSH-NEXT:    v_fma_f32 v5, v6, v3, v5
; GFX6-FLUSH-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX6-FLUSH-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX6-FLUSH-NEXT:    v_div_fixup_f32 v0, v2, v0, v1
; GFX6-FLUSH-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-FLUSH-NEXT:    s_setpc_b64 s[30:31]
;
; GFX89-LABEL: v_neg_rsq_f16_fabs:
; GFX89:       ; %bb.0:
; GFX89-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX89-NEXT:    v_sqrt_f16_e64 v0, |v0|
; GFX89-NEXT:    v_rcp_f16_e64 v0, -v0
; GFX89-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_neg_rsq_f16_fabs:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_sqrt_f16_e64 v0, |v0|
; GFX10-NEXT:    v_rcp_f16_e64 v0, -v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_neg_rsq_f16_fabs:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_sqrt_f16_e64 v0, |v0|
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_rcp_f16_e64 v0, -v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %a.fabs = call half @llvm.fabs.f16(half %a)
  %sqrt = call contract half @llvm.sqrt.f16(half %a.fabs)
  %fdiv = fdiv contract half -1.0, %sqrt
  ret half %fdiv
}

define half @v_rsq_f16_arcp(half %a) {
; GFX6-IEEE-LABEL: v_rsq_f16_arcp:
; GFX6-IEEE:       ; %bb.0:
; GFX6-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v1, 1.0
; GFX6-IEEE-NEXT:    v_sqrt_f32_e32 v0, v0
; GFX6-IEEE-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-IEEE-NEXT:    v_div_scale_f32 v2, s[4:5], v0, v0, v1
; GFX6-IEEE-NEXT:    v_rcp_f32_e32 v3, v2
; GFX6-IEEE-NEXT:    v_div_scale_f32 v4, vcc, v1, v0, v1
; GFX6-IEEE-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX6-IEEE-NEXT:    v_fma_f32 v3, v5, v3, v3
; GFX6-IEEE-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX6-IEEE-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX6-IEEE-NEXT:    v_fma_f32 v5, v6, v3, v5
; GFX6-IEEE-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX6-IEEE-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX6-IEEE-NEXT:    v_div_fixup_f32 v0, v2, v0, v1
; GFX6-IEEE-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-FLUSH-LABEL: v_rsq_f16_arcp:
; GFX6-FLUSH:       ; %bb.0:
; GFX6-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v1, 1.0
; GFX6-FLUSH-NEXT:    v_sqrt_f32_e32 v0, v0
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 2, 2), 0
; GFX6-FLUSH-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v2, s[4:5], v0, v0, v1
; GFX6-FLUSH-NEXT:    v_rcp_f32_e32 v3, v2
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v4, vcc, v1, v0, v1
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-FLUSH-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX6-FLUSH-NEXT:    v_fma_f32 v3, v5, v3, v3
; GFX6-FLUSH-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX6-FLUSH-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX6-FLUSH-NEXT:    v_fma_f32 v5, v6, v3, v5
; GFX6-FLUSH-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX6-FLUSH-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX6-FLUSH-NEXT:    v_div_fixup_f32 v0, v2, v0, v1
; GFX6-FLUSH-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-FLUSH-NEXT:    s_setpc_b64 s[30:31]
;
; GFX89-LABEL: v_rsq_f16_arcp:
; GFX89:       ; %bb.0:
; GFX89-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX89-NEXT:    v_rsq_f16_e32 v0, v0
; GFX89-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10PLUS-LABEL: v_rsq_f16_arcp:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10PLUS-NEXT:    v_rsq_f16_e32 v0, v0
; GFX10PLUS-NEXT:    s_setpc_b64 s[30:31]
  %sqrt = call contract half @llvm.sqrt.f16(half %a)
  %fdiv = fdiv contract arcp half 1.0, %sqrt
  ret half %fdiv
}

define half @v_neg_rsq_f16_arcp(half %a) {
; GFX6-IEEE-LABEL: v_neg_rsq_f16_arcp:
; GFX6-IEEE:       ; %bb.0:
; GFX6-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v1, -1.0
; GFX6-IEEE-NEXT:    v_sqrt_f32_e32 v0, v0
; GFX6-IEEE-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-IEEE-NEXT:    v_div_scale_f32 v2, s[4:5], v0, v0, v1
; GFX6-IEEE-NEXT:    v_rcp_f32_e32 v3, v2
; GFX6-IEEE-NEXT:    v_div_scale_f32 v4, vcc, v1, v0, v1
; GFX6-IEEE-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX6-IEEE-NEXT:    v_fma_f32 v3, v5, v3, v3
; GFX6-IEEE-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX6-IEEE-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX6-IEEE-NEXT:    v_fma_f32 v5, v6, v3, v5
; GFX6-IEEE-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX6-IEEE-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX6-IEEE-NEXT:    v_div_fixup_f32 v0, v2, v0, v1
; GFX6-IEEE-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-FLUSH-LABEL: v_neg_rsq_f16_arcp:
; GFX6-FLUSH:       ; %bb.0:
; GFX6-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v1, -1.0
; GFX6-FLUSH-NEXT:    v_sqrt_f32_e32 v0, v0
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 2, 2), 0
; GFX6-FLUSH-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v2, s[4:5], v0, v0, v1
; GFX6-FLUSH-NEXT:    v_rcp_f32_e32 v3, v2
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v4, vcc, v1, v0, v1
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-FLUSH-NEXT:    v_fma_f32 v5, -v2, v3, 1.0
; GFX6-FLUSH-NEXT:    v_fma_f32 v3, v5, v3, v3
; GFX6-FLUSH-NEXT:    v_mul_f32_e32 v5, v4, v3
; GFX6-FLUSH-NEXT:    v_fma_f32 v6, -v2, v5, v4
; GFX6-FLUSH-NEXT:    v_fma_f32 v5, v6, v3, v5
; GFX6-FLUSH-NEXT:    v_fma_f32 v2, -v2, v5, v4
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX6-FLUSH-NEXT:    v_div_fmas_f32 v2, v2, v3, v5
; GFX6-FLUSH-NEXT:    v_div_fixup_f32 v0, v2, v0, v1
; GFX6-FLUSH-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-FLUSH-NEXT:    s_setpc_b64 s[30:31]
;
; GFX89-LABEL: v_neg_rsq_f16_arcp:
; GFX89:       ; %bb.0:
; GFX89-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX89-NEXT:    v_sqrt_f16_e32 v0, v0
; GFX89-NEXT:    v_rcp_f16_e64 v0, -v0
; GFX89-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_neg_rsq_f16_arcp:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_sqrt_f16_e32 v0, v0
; GFX10-NEXT:    v_rcp_f16_e64 v0, -v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_neg_rsq_f16_arcp:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_sqrt_f16_e32 v0, v0
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_rcp_f16_e64 v0, -v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %sqrt = call contract half @llvm.sqrt.f16(half %a)
  %fdiv = fdiv contract arcp half -1.0, %sqrt
  ret half %fdiv
}

define half @v_rsq_f16_afn(half %a) {
; GFX6-LABEL: v_rsq_f16_afn:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-NEXT:    v_cvt_f32_f16_e32 v1, 1.0
; GFX6-NEXT:    v_sqrt_f32_e32 v0, v0
; GFX6-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-NEXT:    v_rcp_f32_e32 v0, v0
; GFX6-NEXT:    v_mul_f32_e32 v0, v1, v0
; GFX6-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX89-LABEL: v_rsq_f16_afn:
; GFX89:       ; %bb.0:
; GFX89-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX89-NEXT:    v_rsq_f16_e32 v0, v0
; GFX89-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10PLUS-LABEL: v_rsq_f16_afn:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10PLUS-NEXT:    v_rsq_f16_e32 v0, v0
; GFX10PLUS-NEXT:    s_setpc_b64 s[30:31]
  %sqrt = call contract half @llvm.sqrt.f16(half %a)
  %fdiv = fdiv afn contract half 1.0, %sqrt
  ret half %fdiv
}

define half @v_rsq_f16_afn_nocontract(half %a) {
; GFX6-LABEL: v_rsq_f16_afn_nocontract:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-NEXT:    v_cvt_f32_f16_e32 v1, 1.0
; GFX6-NEXT:    v_sqrt_f32_e32 v0, v0
; GFX6-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-NEXT:    v_rcp_f32_e32 v0, v0
; GFX6-NEXT:    v_mul_f32_e32 v0, v1, v0
; GFX6-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX89-LABEL: v_rsq_f16_afn_nocontract:
; GFX89:       ; %bb.0:
; GFX89-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX89-NEXT:    v_sqrt_f16_e32 v0, v0
; GFX89-NEXT:    v_rcp_f16_e32 v0, v0
; GFX89-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_rsq_f16_afn_nocontract:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_sqrt_f16_e32 v0, v0
; GFX10-NEXT:    v_rcp_f16_e32 v0, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_rsq_f16_afn_nocontract:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_sqrt_f16_e32 v0, v0
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_rcp_f16_e32 v0, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %sqrt = call half @llvm.sqrt.f16(half %a)
  %fdiv = fdiv afn half 1.0, %sqrt
  ret half %fdiv
}

define <2 x half> @v_rsq_v2f16(<2 x half> %a) {
; GFX6-IEEE-LABEL: v_rsq_v2f16:
; GFX6-IEEE:       ; %bb.0:
; GFX6-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v2, 1.0
; GFX6-IEEE-NEXT:    v_sqrt_f32_e32 v0, v0
; GFX6-IEEE-NEXT:    v_sqrt_f32_e32 v1, v1
; GFX6-IEEE-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-IEEE-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX6-IEEE-NEXT:    v_div_scale_f32 v3, s[4:5], v0, v0, v2
; GFX6-IEEE-NEXT:    v_rcp_f32_e32 v6, v3
; GFX6-IEEE-NEXT:    v_div_scale_f32 v4, vcc, v2, v0, v2
; GFX6-IEEE-NEXT:    v_div_scale_f32 v5, s[4:5], v1, v1, v2
; GFX6-IEEE-NEXT:    v_fma_f32 v9, -v3, v6, 1.0
; GFX6-IEEE-NEXT:    v_fma_f32 v6, v9, v6, v6
; GFX6-IEEE-NEXT:    v_mul_f32_e32 v9, v4, v6
; GFX6-IEEE-NEXT:    v_rcp_f32_e32 v8, v5
; GFX6-IEEE-NEXT:    v_fma_f32 v10, -v3, v9, v4
; GFX6-IEEE-NEXT:    v_fma_f32 v9, v10, v6, v9
; GFX6-IEEE-NEXT:    v_fma_f32 v3, -v3, v9, v4
; GFX6-IEEE-NEXT:    v_div_fmas_f32 v3, v3, v6, v9
; GFX6-IEEE-NEXT:    v_div_fixup_f32 v0, v3, v0, v2
; GFX6-IEEE-NEXT:    v_fma_f32 v3, -v5, v8, 1.0
; GFX6-IEEE-NEXT:    v_div_scale_f32 v7, s[4:5], v2, v1, v2
; GFX6-IEEE-NEXT:    v_fma_f32 v3, v3, v8, v8
; GFX6-IEEE-NEXT:    v_mul_f32_e32 v4, v7, v3
; GFX6-IEEE-NEXT:    v_fma_f32 v6, -v5, v4, v7
; GFX6-IEEE-NEXT:    v_fma_f32 v4, v6, v3, v4
; GFX6-IEEE-NEXT:    v_fma_f32 v5, -v5, v4, v7
; GFX6-IEEE-NEXT:    s_mov_b64 vcc, s[4:5]
; GFX6-IEEE-NEXT:    v_div_fmas_f32 v3, v5, v3, v4
; GFX6-IEEE-NEXT:    v_div_fixup_f32 v1, v3, v1, v2
; GFX6-IEEE-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-IEEE-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX6-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-FLUSH-LABEL: v_rsq_v2f16:
; GFX6-FLUSH:       ; %bb.0:
; GFX6-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v2, 1.0
; GFX6-FLUSH-NEXT:    v_sqrt_f32_e32 v0, v0
; GFX6-FLUSH-NEXT:    v_sqrt_f32_e32 v1, v1
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 2, 2), 0
; GFX6-FLUSH-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-FLUSH-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v3, s[4:5], v0, v0, v2
; GFX6-FLUSH-NEXT:    v_rcp_f32_e32 v4, v3
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v5, vcc, v2, v0, v2
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-FLUSH-NEXT:    v_fma_f32 v6, -v3, v4, 1.0
; GFX6-FLUSH-NEXT:    v_fma_f32 v4, v6, v4, v4
; GFX6-FLUSH-NEXT:    v_mul_f32_e32 v6, v5, v4
; GFX6-FLUSH-NEXT:    v_fma_f32 v7, -v3, v6, v5
; GFX6-FLUSH-NEXT:    v_fma_f32 v6, v7, v4, v6
; GFX6-FLUSH-NEXT:    v_fma_f32 v3, -v3, v6, v5
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX6-FLUSH-NEXT:    v_div_fmas_f32 v3, v3, v4, v6
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v4, 1.0
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX6-FLUSH-NEXT:    v_div_fixup_f32 v0, v3, v0, v2
; GFX6-FLUSH-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v2, s[4:5], v1, v1, v4
; GFX6-FLUSH-NEXT:    v_rcp_f32_e32 v3, v2
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v5, vcc, v4, v1, v4
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-FLUSH-NEXT:    v_fma_f32 v6, -v2, v3, 1.0
; GFX6-FLUSH-NEXT:    v_fma_f32 v3, v6, v3, v3
; GFX6-FLUSH-NEXT:    v_mul_f32_e32 v6, v5, v3
; GFX6-FLUSH-NEXT:    v_fma_f32 v7, -v2, v6, v5
; GFX6-FLUSH-NEXT:    v_fma_f32 v6, v7, v3, v6
; GFX6-FLUSH-NEXT:    v_fma_f32 v2, -v2, v6, v5
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX6-FLUSH-NEXT:    v_div_fmas_f32 v2, v2, v3, v6
; GFX6-FLUSH-NEXT:    v_div_fixup_f32 v1, v2, v1, v4
; GFX6-FLUSH-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX6-FLUSH-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-IEEE-LABEL: v_rsq_v2f16:
; GFX8-IEEE:       ; %bb.0:
; GFX8-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-IEEE-NEXT:    v_sqrt_f16_e32 v1, v0
; GFX8-IEEE-NEXT:    v_sqrt_f16_sdwa v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GFX8-IEEE-NEXT:    v_cvt_f32_f16_e32 v4, 1.0
; GFX8-IEEE-NEXT:    v_cvt_f32_f16_e32 v2, v1
; GFX8-IEEE-NEXT:    v_cvt_f32_f16_e32 v3, v0
; GFX8-IEEE-NEXT:    v_rcp_f32_e32 v5, v2
; GFX8-IEEE-NEXT:    v_rcp_f32_e32 v6, v3
; GFX8-IEEE-NEXT:    v_mul_f32_e32 v7, v4, v5
; GFX8-IEEE-NEXT:    v_mul_f32_e32 v8, v4, v6
; GFX8-IEEE-NEXT:    v_mul_f32_e64 v10, -v3, v8
; GFX8-IEEE-NEXT:    v_mul_f32_e64 v9, -v2, v7
; GFX8-IEEE-NEXT:    v_add_f32_e32 v10, v10, v4
; GFX8-IEEE-NEXT:    v_add_f32_e32 v9, v9, v4
; GFX8-IEEE-NEXT:    v_mul_f32_e32 v10, v10, v6
; GFX8-IEEE-NEXT:    v_mul_f32_e32 v9, v9, v5
; GFX8-IEEE-NEXT:    v_add_f32_e32 v8, v10, v8
; GFX8-IEEE-NEXT:    v_add_f32_e32 v7, v9, v7
; GFX8-IEEE-NEXT:    v_mul_f32_e64 v3, -v3, v8
; GFX8-IEEE-NEXT:    v_mul_f32_e64 v2, -v2, v7
; GFX8-IEEE-NEXT:    v_add_f32_e32 v3, v3, v4
; GFX8-IEEE-NEXT:    v_add_f32_e32 v2, v2, v4
; GFX8-IEEE-NEXT:    v_mul_f32_e32 v3, v3, v6
; GFX8-IEEE-NEXT:    v_mul_f32_e32 v2, v2, v5
; GFX8-IEEE-NEXT:    v_and_b32_e32 v3, 0xff800000, v3
; GFX8-IEEE-NEXT:    v_and_b32_e32 v2, 0xff800000, v2
; GFX8-IEEE-NEXT:    v_add_f32_e32 v3, v3, v8
; GFX8-IEEE-NEXT:    v_add_f32_e32 v2, v2, v7
; GFX8-IEEE-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX8-IEEE-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX8-IEEE-NEXT:    v_div_fixup_f16 v0, v3, v0, 1.0
; GFX8-IEEE-NEXT:    v_div_fixup_f16 v1, v2, v1, 1.0
; GFX8-IEEE-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX8-IEEE-NEXT:    v_or_b32_e32 v0, v1, v0
; GFX8-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-FLUSH-LABEL: v_rsq_v2f16:
; GFX8-FLUSH:       ; %bb.0:
; GFX8-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-FLUSH-NEXT:    v_sqrt_f16_e32 v1, v0
; GFX8-FLUSH-NEXT:    v_sqrt_f16_sdwa v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GFX8-FLUSH-NEXT:    v_cvt_f32_f16_e32 v4, 1.0
; GFX8-FLUSH-NEXT:    v_cvt_f32_f16_e32 v2, v1
; GFX8-FLUSH-NEXT:    v_cvt_f32_f16_e32 v3, v0
; GFX8-FLUSH-NEXT:    v_rcp_f32_e32 v5, v2
; GFX8-FLUSH-NEXT:    v_rcp_f32_e32 v6, v3
; GFX8-FLUSH-NEXT:    v_mul_f32_e32 v7, v4, v5
; GFX8-FLUSH-NEXT:    v_mul_f32_e32 v8, v4, v6
; GFX8-FLUSH-NEXT:    v_mad_f32 v10, -v3, v8, v4
; GFX8-FLUSH-NEXT:    v_mad_f32 v9, -v2, v7, v4
; GFX8-FLUSH-NEXT:    v_mac_f32_e32 v8, v10, v6
; GFX8-FLUSH-NEXT:    v_mac_f32_e32 v7, v9, v5
; GFX8-FLUSH-NEXT:    v_mad_f32 v3, -v3, v8, v4
; GFX8-FLUSH-NEXT:    v_mad_f32 v2, -v2, v7, v4
; GFX8-FLUSH-NEXT:    v_mul_f32_e32 v3, v3, v6
; GFX8-FLUSH-NEXT:    v_mul_f32_e32 v2, v2, v5
; GFX8-FLUSH-NEXT:    v_and_b32_e32 v3, 0xff800000, v3
; GFX8-FLUSH-NEXT:    v_and_b32_e32 v2, 0xff800000, v2
; GFX8-FLUSH-NEXT:    v_add_f32_e32 v3, v3, v8
; GFX8-FLUSH-NEXT:    v_add_f32_e32 v2, v2, v7
; GFX8-FLUSH-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX8-FLUSH-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX8-FLUSH-NEXT:    v_div_fixup_f16 v0, v3, v0, 1.0
; GFX8-FLUSH-NEXT:    v_div_fixup_f16 v1, v2, v1, 1.0
; GFX8-FLUSH-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX8-FLUSH-NEXT:    v_or_b32_e32 v0, v1, v0
; GFX8-FLUSH-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-IEEE-LABEL: v_rsq_v2f16:
; GFX9-IEEE:       ; %bb.0:
; GFX9-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-IEEE-NEXT:    v_sqrt_f16_e32 v1, v0
; GFX9-IEEE-NEXT:    v_sqrt_f16_sdwa v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GFX9-IEEE-NEXT:    v_cvt_f32_f16_e32 v4, 1.0
; GFX9-IEEE-NEXT:    v_cvt_f32_f16_e32 v2, v1
; GFX9-IEEE-NEXT:    v_cvt_f32_f16_e32 v3, v0
; GFX9-IEEE-NEXT:    v_rcp_f32_e32 v5, v2
; GFX9-IEEE-NEXT:    v_rcp_f32_e32 v6, v3
; GFX9-IEEE-NEXT:    v_mul_f32_e32 v7, v4, v5
; GFX9-IEEE-NEXT:    v_mul_f32_e32 v8, v4, v6
; GFX9-IEEE-NEXT:    v_fma_f32 v9, -v2, v7, v4
; GFX9-IEEE-NEXT:    v_fma_f32 v10, -v3, v8, v4
; GFX9-IEEE-NEXT:    v_fma_f32 v7, v9, v5, v7
; GFX9-IEEE-NEXT:    v_fma_f32 v8, v10, v6, v8
; GFX9-IEEE-NEXT:    v_fma_f32 v2, -v2, v7, v4
; GFX9-IEEE-NEXT:    v_fma_f32 v3, -v3, v8, v4
; GFX9-IEEE-NEXT:    v_mul_f32_e32 v2, v2, v5
; GFX9-IEEE-NEXT:    v_mul_f32_e32 v3, v3, v6
; GFX9-IEEE-NEXT:    v_and_b32_e32 v2, 0xff800000, v2
; GFX9-IEEE-NEXT:    v_and_b32_e32 v3, 0xff800000, v3
; GFX9-IEEE-NEXT:    v_add_f32_e32 v2, v2, v7
; GFX9-IEEE-NEXT:    v_add_f32_e32 v3, v3, v8
; GFX9-IEEE-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX9-IEEE-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX9-IEEE-NEXT:    v_div_fixup_f16 v1, v2, v1, 1.0
; GFX9-IEEE-NEXT:    v_div_fixup_f16 v0, v3, v0, 1.0
; GFX9-IEEE-NEXT:    v_pack_b32_f16 v0, v1, v0
; GFX9-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-FLUSH-LABEL: v_rsq_v2f16:
; GFX9-FLUSH:       ; %bb.0:
; GFX9-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-FLUSH-NEXT:    v_sqrt_f16_e32 v1, v0
; GFX9-FLUSH-NEXT:    v_sqrt_f16_sdwa v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GFX9-FLUSH-NEXT:    v_cvt_f32_f16_e32 v4, 1.0
; GFX9-FLUSH-NEXT:    v_cvt_f32_f16_e32 v2, v1
; GFX9-FLUSH-NEXT:    v_cvt_f32_f16_e32 v3, v0
; GFX9-FLUSH-NEXT:    v_rcp_f32_e32 v2, v2
; GFX9-FLUSH-NEXT:    v_rcp_f32_e32 v3, v3
; GFX9-FLUSH-NEXT:    v_mul_f32_e32 v5, v4, v2
; GFX9-FLUSH-NEXT:    v_mul_f32_e32 v4, v4, v3
; GFX9-FLUSH-NEXT:    v_mad_mix_f32 v6, -v1, v5, 1.0 op_sel_hi:[1,0,1]
; GFX9-FLUSH-NEXT:    v_mad_mix_f32 v7, -v0, v4, 1.0 op_sel_hi:[1,0,1]
; GFX9-FLUSH-NEXT:    v_mac_f32_e32 v5, v6, v2
; GFX9-FLUSH-NEXT:    v_mac_f32_e32 v4, v7, v3
; GFX9-FLUSH-NEXT:    v_mad_mix_f32 v6, -v1, v5, 1.0 op_sel_hi:[1,0,1]
; GFX9-FLUSH-NEXT:    v_mad_mix_f32 v7, -v0, v4, 1.0 op_sel_hi:[1,0,1]
; GFX9-FLUSH-NEXT:    v_mul_f32_e32 v2, v6, v2
; GFX9-FLUSH-NEXT:    v_mul_f32_e32 v3, v7, v3
; GFX9-FLUSH-NEXT:    v_and_b32_e32 v2, 0xff800000, v2
; GFX9-FLUSH-NEXT:    v_and_b32_e32 v3, 0xff800000, v3
; GFX9-FLUSH-NEXT:    v_add_f32_e32 v2, v2, v5
; GFX9-FLUSH-NEXT:    v_add_f32_e32 v3, v3, v4
; GFX9-FLUSH-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX9-FLUSH-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX9-FLUSH-NEXT:    v_div_fixup_f16 v1, v2, v1, 1.0
; GFX9-FLUSH-NEXT:    v_div_fixup_f16 v0, v3, v0, 1.0
; GFX9-FLUSH-NEXT:    v_pack_b32_f16 v0, v1, v0
; GFX9-FLUSH-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-IEEE-LABEL: v_rsq_v2f16:
; GFX10-IEEE:       ; %bb.0:
; GFX10-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-IEEE-NEXT:    v_sqrt_f16_e32 v1, v0
; GFX10-IEEE-NEXT:    v_sqrt_f16_sdwa v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GFX10-IEEE-NEXT:    v_cvt_f32_f16_e32 v4, 1.0
; GFX10-IEEE-NEXT:    v_cvt_f32_f16_e32 v2, v1
; GFX10-IEEE-NEXT:    v_cvt_f32_f16_e32 v3, v0
; GFX10-IEEE-NEXT:    v_rcp_f32_e32 v2, v2
; GFX10-IEEE-NEXT:    v_rcp_f32_e32 v3, v3
; GFX10-IEEE-NEXT:    v_mul_f32_e32 v5, v4, v2
; GFX10-IEEE-NEXT:    v_mul_f32_e32 v4, v4, v3
; GFX10-IEEE-NEXT:    v_fma_mix_f32 v6, -v1, v5, 1.0 op_sel_hi:[1,0,1]
; GFX10-IEEE-NEXT:    v_fma_mix_f32 v7, -v0, v4, 1.0 op_sel_hi:[1,0,1]
; GFX10-IEEE-NEXT:    v_fmac_f32_e32 v5, v6, v2
; GFX10-IEEE-NEXT:    v_fmac_f32_e32 v4, v7, v3
; GFX10-IEEE-NEXT:    v_fma_mix_f32 v6, -v1, v5, 1.0 op_sel_hi:[1,0,1]
; GFX10-IEEE-NEXT:    v_fma_mix_f32 v7, -v0, v4, 1.0 op_sel_hi:[1,0,1]
; GFX10-IEEE-NEXT:    v_mul_f32_e32 v2, v6, v2
; GFX10-IEEE-NEXT:    v_mul_f32_e32 v3, v7, v3
; GFX10-IEEE-NEXT:    v_and_b32_e32 v2, 0xff800000, v2
; GFX10-IEEE-NEXT:    v_and_b32_e32 v3, 0xff800000, v3
; GFX10-IEEE-NEXT:    v_add_f32_e32 v2, v2, v5
; GFX10-IEEE-NEXT:    v_add_f32_e32 v3, v3, v4
; GFX10-IEEE-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX10-IEEE-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX10-IEEE-NEXT:    v_div_fixup_f16 v1, v2, v1, 1.0
; GFX10-IEEE-NEXT:    v_div_fixup_f16 v0, v3, v0, 1.0
; GFX10-IEEE-NEXT:    v_pack_b32_f16 v0, v1, v0
; GFX10-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-FLUSH-LABEL: v_rsq_v2f16:
; GFX10-FLUSH:       ; %bb.0:
; GFX10-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-FLUSH-NEXT:    v_sqrt_f16_e32 v1, v0
; GFX10-FLUSH-NEXT:    v_sqrt_f16_sdwa v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GFX10-FLUSH-NEXT:    v_cvt_f32_f16_e32 v6, 1.0
; GFX10-FLUSH-NEXT:    v_cvt_f32_f16_e32 v2, v1
; GFX10-FLUSH-NEXT:    v_cvt_f32_f16_e32 v3, v0
; GFX10-FLUSH-NEXT:    v_rcp_f32_e32 v4, v2
; GFX10-FLUSH-NEXT:    v_rcp_f32_e32 v5, v3
; GFX10-FLUSH-NEXT:    v_mul_f32_e32 v7, v6, v4
; GFX10-FLUSH-NEXT:    v_mul_f32_e32 v8, v6, v5
; GFX10-FLUSH-NEXT:    v_mad_f32 v9, -v2, v7, v6
; GFX10-FLUSH-NEXT:    v_mad_f32 v10, -v3, v8, v6
; GFX10-FLUSH-NEXT:    v_mac_f32_e32 v7, v9, v4
; GFX10-FLUSH-NEXT:    v_mac_f32_e32 v8, v10, v5
; GFX10-FLUSH-NEXT:    v_mad_f32 v2, -v2, v7, v6
; GFX10-FLUSH-NEXT:    v_mad_f32 v3, -v3, v8, v6
; GFX10-FLUSH-NEXT:    v_mul_f32_e32 v2, v2, v4
; GFX10-FLUSH-NEXT:    v_mul_f32_e32 v3, v3, v5
; GFX10-FLUSH-NEXT:    v_and_b32_e32 v2, 0xff800000, v2
; GFX10-FLUSH-NEXT:    v_and_b32_e32 v3, 0xff800000, v3
; GFX10-FLUSH-NEXT:    v_add_f32_e32 v2, v2, v7
; GFX10-FLUSH-NEXT:    v_add_f32_e32 v3, v3, v8
; GFX10-FLUSH-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX10-FLUSH-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX10-FLUSH-NEXT:    v_div_fixup_f16 v1, v2, v1, 1.0
; GFX10-FLUSH-NEXT:    v_div_fixup_f16 v0, v3, v0, 1.0
; GFX10-FLUSH-NEXT:    v_pack_b32_f16 v0, v1, v0
; GFX10-FLUSH-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_rsq_v2f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX11-NEXT:    v_sqrt_f16_e32 v0, v0
; GFX11-NEXT:    v_cvt_f32_f16_e32 v4, 1.0
; GFX11-NEXT:    v_sqrt_f16_e32 v1, v1
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_cvt_f32_f16_e32 v2, v0
; GFX11-NEXT:    v_cvt_f32_f16_e32 v3, v1
; GFX11-NEXT:    v_rcp_f32_e32 v2, v2
; GFX11-NEXT:    v_rcp_f32_e32 v3, v3
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_mul_f32_e32 v5, v4, v2
; GFX11-NEXT:    v_mul_f32_e32 v4, v4, v3
; GFX11-NEXT:    v_fma_mix_f32 v7, -v1, v4, 1.0 op_sel_hi:[1,0,1]
; GFX11-NEXT:    v_fmac_f32_e32 v4, v7, v3
; GFX11-NEXT:    v_fma_mix_f32 v6, -v0, v5, 1.0 op_sel_hi:[1,0,1]
; GFX11-NEXT:    v_fma_mix_f32 v7, -v1, v4, 1.0 op_sel_hi:[1,0,1]
; GFX11-NEXT:    v_fmac_f32_e32 v5, v6, v2
; GFX11-NEXT:    v_mul_f32_e32 v3, v7, v3
; GFX11-NEXT:    v_fma_mix_f32 v6, -v0, v5, 1.0 op_sel_hi:[1,0,1]
; GFX11-NEXT:    v_dual_mul_f32 v2, v6, v2 :: v_dual_and_b32 v3, 0xff800000, v3
; GFX11-NEXT:    v_dual_add_f32 v3, v3, v4 :: v_dual_and_b32 v2, 0xff800000, v2
; GFX11-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX11-NEXT:    v_add_f32_e32 v2, v2, v5
; GFX11-NEXT:    v_div_fixup_f16 v1, v3, v1, 1.0
; GFX11-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX11-NEXT:    v_div_fixup_f16 v0, v2, v0, 1.0
; GFX11-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %sqrt = call contract <2 x half> @llvm.sqrt.v2f16(<2 x half> %a)
  %fdiv = fdiv contract <2 x half> <half 1.0, half 1.0>, %sqrt
  ret <2 x half> %fdiv
}

define <2 x half> @v_neg_rsq_v2f16(<2 x half> %a) {
; GFX6-IEEE-LABEL: v_neg_rsq_v2f16:
; GFX6-IEEE:       ; %bb.0:
; GFX6-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v2, -1.0
; GFX6-IEEE-NEXT:    v_sqrt_f32_e32 v0, v0
; GFX6-IEEE-NEXT:    v_sqrt_f32_e32 v1, v1
; GFX6-IEEE-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-IEEE-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-IEEE-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX6-IEEE-NEXT:    v_div_scale_f32 v3, s[4:5], v0, v0, v2
; GFX6-IEEE-NEXT:    v_rcp_f32_e32 v6, v3
; GFX6-IEEE-NEXT:    v_div_scale_f32 v4, vcc, v2, v0, v2
; GFX6-IEEE-NEXT:    v_div_scale_f32 v5, s[4:5], v1, v1, v2
; GFX6-IEEE-NEXT:    v_fma_f32 v9, -v3, v6, 1.0
; GFX6-IEEE-NEXT:    v_fma_f32 v6, v9, v6, v6
; GFX6-IEEE-NEXT:    v_mul_f32_e32 v9, v4, v6
; GFX6-IEEE-NEXT:    v_rcp_f32_e32 v8, v5
; GFX6-IEEE-NEXT:    v_fma_f32 v10, -v3, v9, v4
; GFX6-IEEE-NEXT:    v_fma_f32 v9, v10, v6, v9
; GFX6-IEEE-NEXT:    v_fma_f32 v3, -v3, v9, v4
; GFX6-IEEE-NEXT:    v_div_fmas_f32 v3, v3, v6, v9
; GFX6-IEEE-NEXT:    v_div_fixup_f32 v0, v3, v0, v2
; GFX6-IEEE-NEXT:    v_fma_f32 v3, -v5, v8, 1.0
; GFX6-IEEE-NEXT:    v_div_scale_f32 v7, s[4:5], v2, v1, v2
; GFX6-IEEE-NEXT:    v_fma_f32 v3, v3, v8, v8
; GFX6-IEEE-NEXT:    v_mul_f32_e32 v4, v7, v3
; GFX6-IEEE-NEXT:    v_fma_f32 v6, -v5, v4, v7
; GFX6-IEEE-NEXT:    v_fma_f32 v4, v6, v3, v4
; GFX6-IEEE-NEXT:    v_fma_f32 v5, -v5, v4, v7
; GFX6-IEEE-NEXT:    s_mov_b64 vcc, s[4:5]
; GFX6-IEEE-NEXT:    v_div_fmas_f32 v3, v5, v3, v4
; GFX6-IEEE-NEXT:    v_div_fixup_f32 v1, v3, v1, v2
; GFX6-IEEE-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-IEEE-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX6-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-FLUSH-LABEL: v_neg_rsq_v2f16:
; GFX6-FLUSH:       ; %bb.0:
; GFX6-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v2, -1.0
; GFX6-FLUSH-NEXT:    v_sqrt_f32_e32 v0, v0
; GFX6-FLUSH-NEXT:    v_sqrt_f32_e32 v1, v1
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 2, 2), 0
; GFX6-FLUSH-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-FLUSH-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v3, s[4:5], v0, v0, v2
; GFX6-FLUSH-NEXT:    v_rcp_f32_e32 v4, v3
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v5, vcc, v2, v0, v2
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-FLUSH-NEXT:    v_fma_f32 v6, -v3, v4, 1.0
; GFX6-FLUSH-NEXT:    v_fma_f32 v4, v6, v4, v4
; GFX6-FLUSH-NEXT:    v_mul_f32_e32 v6, v5, v4
; GFX6-FLUSH-NEXT:    v_fma_f32 v7, -v3, v6, v5
; GFX6-FLUSH-NEXT:    v_fma_f32 v6, v7, v4, v6
; GFX6-FLUSH-NEXT:    v_fma_f32 v3, -v3, v6, v5
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX6-FLUSH-NEXT:    v_div_fmas_f32 v3, v3, v4, v6
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v4, -1.0
; GFX6-FLUSH-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX6-FLUSH-NEXT:    v_div_fixup_f32 v0, v3, v0, v2
; GFX6-FLUSH-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v2, s[4:5], v1, v1, v4
; GFX6-FLUSH-NEXT:    v_rcp_f32_e32 v3, v2
; GFX6-FLUSH-NEXT:    v_div_scale_f32 v5, vcc, v4, v1, v4
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 3
; GFX6-FLUSH-NEXT:    v_fma_f32 v6, -v2, v3, 1.0
; GFX6-FLUSH-NEXT:    v_fma_f32 v3, v6, v3, v3
; GFX6-FLUSH-NEXT:    v_mul_f32_e32 v6, v5, v3
; GFX6-FLUSH-NEXT:    v_fma_f32 v7, -v2, v6, v5
; GFX6-FLUSH-NEXT:    v_fma_f32 v6, v7, v3, v6
; GFX6-FLUSH-NEXT:    v_fma_f32 v2, -v2, v6, v5
; GFX6-FLUSH-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 4, 2), 0
; GFX6-FLUSH-NEXT:    v_div_fmas_f32 v2, v2, v3, v6
; GFX6-FLUSH-NEXT:    v_div_fixup_f32 v1, v2, v1, v4
; GFX6-FLUSH-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX6-FLUSH-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-IEEE-LABEL: v_neg_rsq_v2f16:
; GFX8-IEEE:       ; %bb.0:
; GFX8-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-IEEE-NEXT:    v_sqrt_f16_e32 v1, v0
; GFX8-IEEE-NEXT:    v_sqrt_f16_sdwa v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GFX8-IEEE-NEXT:    v_cvt_f32_f16_e32 v4, -1.0
; GFX8-IEEE-NEXT:    v_cvt_f32_f16_e32 v2, v1
; GFX8-IEEE-NEXT:    v_cvt_f32_f16_e32 v3, v0
; GFX8-IEEE-NEXT:    v_rcp_f32_e32 v5, v2
; GFX8-IEEE-NEXT:    v_rcp_f32_e32 v6, v3
; GFX8-IEEE-NEXT:    v_mul_f32_e32 v7, v4, v5
; GFX8-IEEE-NEXT:    v_mul_f32_e32 v8, v4, v6
; GFX8-IEEE-NEXT:    v_mul_f32_e64 v10, -v3, v8
; GFX8-IEEE-NEXT:    v_mul_f32_e64 v9, -v2, v7
; GFX8-IEEE-NEXT:    v_add_f32_e32 v10, v10, v4
; GFX8-IEEE-NEXT:    v_add_f32_e32 v9, v9, v4
; GFX8-IEEE-NEXT:    v_mul_f32_e32 v10, v10, v6
; GFX8-IEEE-NEXT:    v_mul_f32_e32 v9, v9, v5
; GFX8-IEEE-NEXT:    v_add_f32_e32 v8, v10, v8
; GFX8-IEEE-NEXT:    v_add_f32_e32 v7, v9, v7
; GFX8-IEEE-NEXT:    v_mul_f32_e64 v3, -v3, v8
; GFX8-IEEE-NEXT:    v_mul_f32_e64 v2, -v2, v7
; GFX8-IEEE-NEXT:    v_add_f32_e32 v3, v3, v4
; GFX8-IEEE-NEXT:    v_add_f32_e32 v2, v2, v4
; GFX8-IEEE-NEXT:    v_mul_f32_e32 v3, v3, v6
; GFX8-IEEE-NEXT:    v_mul_f32_e32 v2, v2, v5
; GFX8-IEEE-NEXT:    v_and_b32_e32 v3, 0xff800000, v3
; GFX8-IEEE-NEXT:    v_and_b32_e32 v2, 0xff800000, v2
; GFX8-IEEE-NEXT:    v_add_f32_e32 v3, v3, v8
; GFX8-IEEE-NEXT:    v_add_f32_e32 v2, v2, v7
; GFX8-IEEE-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX8-IEEE-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX8-IEEE-NEXT:    v_div_fixup_f16 v0, v3, v0, -1.0
; GFX8-IEEE-NEXT:    v_div_fixup_f16 v1, v2, v1, -1.0
; GFX8-IEEE-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX8-IEEE-NEXT:    v_or_b32_e32 v0, v1, v0
; GFX8-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-FLUSH-LABEL: v_neg_rsq_v2f16:
; GFX8-FLUSH:       ; %bb.0:
; GFX8-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-FLUSH-NEXT:    v_sqrt_f16_e32 v1, v0
; GFX8-FLUSH-NEXT:    v_sqrt_f16_sdwa v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GFX8-FLUSH-NEXT:    v_cvt_f32_f16_e32 v4, -1.0
; GFX8-FLUSH-NEXT:    v_cvt_f32_f16_e32 v2, v1
; GFX8-FLUSH-NEXT:    v_cvt_f32_f16_e32 v3, v0
; GFX8-FLUSH-NEXT:    v_rcp_f32_e32 v5, v2
; GFX8-FLUSH-NEXT:    v_rcp_f32_e32 v6, v3
; GFX8-FLUSH-NEXT:    v_mul_f32_e32 v7, v4, v5
; GFX8-FLUSH-NEXT:    v_mul_f32_e32 v8, v4, v6
; GFX8-FLUSH-NEXT:    v_mad_f32 v10, -v3, v8, v4
; GFX8-FLUSH-NEXT:    v_mad_f32 v9, -v2, v7, v4
; GFX8-FLUSH-NEXT:    v_mac_f32_e32 v8, v10, v6
; GFX8-FLUSH-NEXT:    v_mac_f32_e32 v7, v9, v5
; GFX8-FLUSH-NEXT:    v_mad_f32 v3, -v3, v8, v4
; GFX8-FLUSH-NEXT:    v_mad_f32 v2, -v2, v7, v4
; GFX8-FLUSH-NEXT:    v_mul_f32_e32 v3, v3, v6
; GFX8-FLUSH-NEXT:    v_mul_f32_e32 v2, v2, v5
; GFX8-FLUSH-NEXT:    v_and_b32_e32 v3, 0xff800000, v3
; GFX8-FLUSH-NEXT:    v_and_b32_e32 v2, 0xff800000, v2
; GFX8-FLUSH-NEXT:    v_add_f32_e32 v3, v3, v8
; GFX8-FLUSH-NEXT:    v_add_f32_e32 v2, v2, v7
; GFX8-FLUSH-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX8-FLUSH-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX8-FLUSH-NEXT:    v_div_fixup_f16 v0, v3, v0, -1.0
; GFX8-FLUSH-NEXT:    v_div_fixup_f16 v1, v2, v1, -1.0
; GFX8-FLUSH-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX8-FLUSH-NEXT:    v_or_b32_e32 v0, v1, v0
; GFX8-FLUSH-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-IEEE-LABEL: v_neg_rsq_v2f16:
; GFX9-IEEE:       ; %bb.0:
; GFX9-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-IEEE-NEXT:    v_sqrt_f16_e32 v1, v0
; GFX9-IEEE-NEXT:    v_sqrt_f16_sdwa v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GFX9-IEEE-NEXT:    v_cvt_f32_f16_e32 v4, -1.0
; GFX9-IEEE-NEXT:    v_cvt_f32_f16_e32 v2, v1
; GFX9-IEEE-NEXT:    v_cvt_f32_f16_e32 v3, v0
; GFX9-IEEE-NEXT:    v_rcp_f32_e32 v5, v2
; GFX9-IEEE-NEXT:    v_rcp_f32_e32 v6, v3
; GFX9-IEEE-NEXT:    v_mul_f32_e32 v7, v4, v5
; GFX9-IEEE-NEXT:    v_mul_f32_e32 v8, v4, v6
; GFX9-IEEE-NEXT:    v_fma_f32 v9, -v2, v7, v4
; GFX9-IEEE-NEXT:    v_fma_f32 v10, -v3, v8, v4
; GFX9-IEEE-NEXT:    v_fma_f32 v7, v9, v5, v7
; GFX9-IEEE-NEXT:    v_fma_f32 v8, v10, v6, v8
; GFX9-IEEE-NEXT:    v_fma_f32 v2, -v2, v7, v4
; GFX9-IEEE-NEXT:    v_fma_f32 v3, -v3, v8, v4
; GFX9-IEEE-NEXT:    v_mul_f32_e32 v2, v2, v5
; GFX9-IEEE-NEXT:    v_mul_f32_e32 v3, v3, v6
; GFX9-IEEE-NEXT:    v_and_b32_e32 v2, 0xff800000, v2
; GFX9-IEEE-NEXT:    v_and_b32_e32 v3, 0xff800000, v3
; GFX9-IEEE-NEXT:    v_add_f32_e32 v2, v2, v7
; GFX9-IEEE-NEXT:    v_add_f32_e32 v3, v3, v8
; GFX9-IEEE-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX9-IEEE-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX9-IEEE-NEXT:    v_div_fixup_f16 v1, v2, v1, -1.0
; GFX9-IEEE-NEXT:    v_div_fixup_f16 v0, v3, v0, -1.0
; GFX9-IEEE-NEXT:    v_pack_b32_f16 v0, v1, v0
; GFX9-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-FLUSH-LABEL: v_neg_rsq_v2f16:
; GFX9-FLUSH:       ; %bb.0:
; GFX9-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-FLUSH-NEXT:    v_sqrt_f16_e32 v1, v0
; GFX9-FLUSH-NEXT:    v_sqrt_f16_sdwa v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GFX9-FLUSH-NEXT:    v_cvt_f32_f16_e32 v4, -1.0
; GFX9-FLUSH-NEXT:    v_cvt_f32_f16_e32 v2, v1
; GFX9-FLUSH-NEXT:    v_cvt_f32_f16_e32 v3, v0
; GFX9-FLUSH-NEXT:    v_rcp_f32_e32 v2, v2
; GFX9-FLUSH-NEXT:    v_rcp_f32_e32 v3, v3
; GFX9-FLUSH-NEXT:    v_mul_f32_e32 v5, v4, v2
; GFX9-FLUSH-NEXT:    v_mul_f32_e32 v4, v4, v3
; GFX9-FLUSH-NEXT:    v_mad_mix_f32 v6, -v1, v5, -1.0 op_sel_hi:[1,0,1]
; GFX9-FLUSH-NEXT:    v_mad_mix_f32 v7, -v0, v4, -1.0 op_sel_hi:[1,0,1]
; GFX9-FLUSH-NEXT:    v_mac_f32_e32 v5, v6, v2
; GFX9-FLUSH-NEXT:    v_mac_f32_e32 v4, v7, v3
; GFX9-FLUSH-NEXT:    v_mad_mix_f32 v6, -v1, v5, -1.0 op_sel_hi:[1,0,1]
; GFX9-FLUSH-NEXT:    v_mad_mix_f32 v7, -v0, v4, -1.0 op_sel_hi:[1,0,1]
; GFX9-FLUSH-NEXT:    v_mul_f32_e32 v2, v6, v2
; GFX9-FLUSH-NEXT:    v_mul_f32_e32 v3, v7, v3
; GFX9-FLUSH-NEXT:    v_and_b32_e32 v2, 0xff800000, v2
; GFX9-FLUSH-NEXT:    v_and_b32_e32 v3, 0xff800000, v3
; GFX9-FLUSH-NEXT:    v_add_f32_e32 v2, v2, v5
; GFX9-FLUSH-NEXT:    v_add_f32_e32 v3, v3, v4
; GFX9-FLUSH-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX9-FLUSH-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX9-FLUSH-NEXT:    v_div_fixup_f16 v1, v2, v1, -1.0
; GFX9-FLUSH-NEXT:    v_div_fixup_f16 v0, v3, v0, -1.0
; GFX9-FLUSH-NEXT:    v_pack_b32_f16 v0, v1, v0
; GFX9-FLUSH-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-IEEE-LABEL: v_neg_rsq_v2f16:
; GFX10-IEEE:       ; %bb.0:
; GFX10-IEEE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-IEEE-NEXT:    v_sqrt_f16_e32 v1, v0
; GFX10-IEEE-NEXT:    v_sqrt_f16_sdwa v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GFX10-IEEE-NEXT:    v_cvt_f32_f16_e32 v4, -1.0
; GFX10-IEEE-NEXT:    v_cvt_f32_f16_e32 v2, v1
; GFX10-IEEE-NEXT:    v_cvt_f32_f16_e32 v3, v0
; GFX10-IEEE-NEXT:    v_rcp_f32_e32 v2, v2
; GFX10-IEEE-NEXT:    v_rcp_f32_e32 v3, v3
; GFX10-IEEE-NEXT:    v_mul_f32_e32 v5, v4, v2
; GFX10-IEEE-NEXT:    v_mul_f32_e32 v4, v4, v3
; GFX10-IEEE-NEXT:    v_fma_mix_f32 v6, -v1, v5, -1.0 op_sel_hi:[1,0,1]
; GFX10-IEEE-NEXT:    v_fma_mix_f32 v7, -v0, v4, -1.0 op_sel_hi:[1,0,1]
; GFX10-IEEE-NEXT:    v_fmac_f32_e32 v5, v6, v2
; GFX10-IEEE-NEXT:    v_fmac_f32_e32 v4, v7, v3
; GFX10-IEEE-NEXT:    v_fma_mix_f32 v6, -v1, v5, -1.0 op_sel_hi:[1,0,1]
; GFX10-IEEE-NEXT:    v_fma_mix_f32 v7, -v0, v4, -1.0 op_sel_hi:[1,0,1]
; GFX10-IEEE-NEXT:    v_mul_f32_e32 v2, v6, v2
; GFX10-IEEE-NEXT:    v_mul_f32_e32 v3, v7, v3
; GFX10-IEEE-NEXT:    v_and_b32_e32 v2, 0xff800000, v2
; GFX10-IEEE-NEXT:    v_and_b32_e32 v3, 0xff800000, v3
; GFX10-IEEE-NEXT:    v_add_f32_e32 v2, v2, v5
; GFX10-IEEE-NEXT:    v_add_f32_e32 v3, v3, v4
; GFX10-IEEE-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX10-IEEE-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX10-IEEE-NEXT:    v_div_fixup_f16 v1, v2, v1, -1.0
; GFX10-IEEE-NEXT:    v_div_fixup_f16 v0, v3, v0, -1.0
; GFX10-IEEE-NEXT:    v_pack_b32_f16 v0, v1, v0
; GFX10-IEEE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-FLUSH-LABEL: v_neg_rsq_v2f16:
; GFX10-FLUSH:       ; %bb.0:
; GFX10-FLUSH-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-FLUSH-NEXT:    v_sqrt_f16_e32 v1, v0
; GFX10-FLUSH-NEXT:    v_sqrt_f16_sdwa v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GFX10-FLUSH-NEXT:    v_cvt_f32_f16_e32 v6, -1.0
; GFX10-FLUSH-NEXT:    v_cvt_f32_f16_e32 v2, v1
; GFX10-FLUSH-NEXT:    v_cvt_f32_f16_e32 v3, v0
; GFX10-FLUSH-NEXT:    v_rcp_f32_e32 v4, v2
; GFX10-FLUSH-NEXT:    v_rcp_f32_e32 v5, v3
; GFX10-FLUSH-NEXT:    v_mul_f32_e32 v7, v6, v4
; GFX10-FLUSH-NEXT:    v_mul_f32_e32 v8, v6, v5
; GFX10-FLUSH-NEXT:    v_mad_f32 v9, -v2, v7, v6
; GFX10-FLUSH-NEXT:    v_mad_f32 v10, -v3, v8, v6
; GFX10-FLUSH-NEXT:    v_mac_f32_e32 v7, v9, v4
; GFX10-FLUSH-NEXT:    v_mac_f32_e32 v8, v10, v5
; GFX10-FLUSH-NEXT:    v_mad_f32 v2, -v2, v7, v6
; GFX10-FLUSH-NEXT:    v_mad_f32 v3, -v3, v8, v6
; GFX10-FLUSH-NEXT:    v_mul_f32_e32 v2, v2, v4
; GFX10-FLUSH-NEXT:    v_mul_f32_e32 v3, v3, v5
; GFX10-FLUSH-NEXT:    v_and_b32_e32 v2, 0xff800000, v2
; GFX10-FLUSH-NEXT:    v_and_b32_e32 v3, 0xff800000, v3
; GFX10-FLUSH-NEXT:    v_add_f32_e32 v2, v2, v7
; GFX10-FLUSH-NEXT:    v_add_f32_e32 v3, v3, v8
; GFX10-FLUSH-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX10-FLUSH-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX10-FLUSH-NEXT:    v_div_fixup_f16 v1, v2, v1, -1.0
; GFX10-FLUSH-NEXT:    v_div_fixup_f16 v0, v3, v0, -1.0
; GFX10-FLUSH-NEXT:    v_pack_b32_f16 v0, v1, v0
; GFX10-FLUSH-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_neg_rsq_v2f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX11-NEXT:    v_sqrt_f16_e32 v0, v0
; GFX11-NEXT:    v_cvt_f32_f16_e32 v4, -1.0
; GFX11-NEXT:    v_sqrt_f16_e32 v1, v1
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_cvt_f32_f16_e32 v2, v0
; GFX11-NEXT:    v_cvt_f32_f16_e32 v3, v1
; GFX11-NEXT:    v_rcp_f32_e32 v2, v2
; GFX11-NEXT:    v_rcp_f32_e32 v3, v3
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_mul_f32_e32 v5, v4, v2
; GFX11-NEXT:    v_mul_f32_e32 v4, v4, v3
; GFX11-NEXT:    v_fma_mix_f32 v7, -v1, v4, -1.0 op_sel_hi:[1,0,1]
; GFX11-NEXT:    v_fmac_f32_e32 v4, v7, v3
; GFX11-NEXT:    v_fma_mix_f32 v6, -v0, v5, -1.0 op_sel_hi:[1,0,1]
; GFX11-NEXT:    v_fma_mix_f32 v7, -v1, v4, -1.0 op_sel_hi:[1,0,1]
; GFX11-NEXT:    v_fmac_f32_e32 v5, v6, v2
; GFX11-NEXT:    v_mul_f32_e32 v3, v7, v3
; GFX11-NEXT:    v_fma_mix_f32 v6, -v0, v5, -1.0 op_sel_hi:[1,0,1]
; GFX11-NEXT:    v_dual_mul_f32 v2, v6, v2 :: v_dual_and_b32 v3, 0xff800000, v3
; GFX11-NEXT:    v_dual_add_f32 v3, v3, v4 :: v_dual_and_b32 v2, 0xff800000, v2
; GFX11-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX11-NEXT:    v_add_f32_e32 v2, v2, v5
; GFX11-NEXT:    v_div_fixup_f16 v1, v3, v1, -1.0
; GFX11-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX11-NEXT:    v_div_fixup_f16 v0, v2, v0, -1.0
; GFX11-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %sqrt = call contract <2 x half> @llvm.sqrt.v2f16(<2 x half> %a)
  %fdiv = fdiv contract <2 x half> <half -1.0, half -1.0>, %sqrt
  ret <2 x half> %fdiv
}

declare half @llvm.fabs.f16(half)
declare half @llvm.sqrt.f16(half)
declare <2 x half> @llvm.fabs.v2f16(<2 x half>)
declare <2 x half> @llvm.sqrt.v2f16(<2 x half>)

;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; GFX11-FLUSH: {{.*}}
; GFX11-IEEE: {{.*}}
