# Test the pg_logicalinspect functions: that needs some permutation to
# ensure that we are creating at least one snapshot that contains ongoing and
# committed catalogs changes.
setup
{
    DROP TABLE IF EXISTS tbl1;
    DROP TABLE IF EXISTS tbl2;
    CREATE TABLE tbl1 (val1 integer, val2 integer);
    CREATE EXTENSION pg_logicalinspect;
}

teardown
{
    DROP TABLE tbl1;
    DROP TABLE tbl2;
    SELECT 'stop' FROM pg_drop_replication_slot('isolation_slot');
    DROP EXTENSION pg_logicalinspect;
}

session "s0"
setup { SET synchronous_commit=on; }
step "s0_init" { SELECT 'init' FROM pg_create_logical_replication_slot('isolation_slot', 'test_decoding'); }
step "s0_begin" { BEGIN; }
step "s0_savepoint" { SAVEPOINT sp1; }
step "s0_truncate" { TRUNCATE tbl1; }
step "s0_commit" { COMMIT; }

session "s1"
setup { SET synchronous_commit=on; }
step "s1_checkpoint" { CHECKPOINT; }
step "s1_create_table" { CREATE TABLE tbl2 (val1 integer, val2 integer); }
step "s1_get_changes" { SELECT data FROM pg_logical_slot_get_changes('isolation_slot', NULL, NULL, 'skip-empty-xacts', '1', 'include-xids', '0'); }
step "s1_check_snapshot_meta" { SELECT count(meta.*) > 0 AS has_meta from pg_ls_logicalsnapdir(), pg_get_logical_snapshot_meta(name) as meta; }
step "s1_check_snapshot_info" { SELECT count(*) > 0 as has_info FROM pg_ls_logicalsnapdir(), pg_get_logical_snapshot_info(name) AS info where info.catchange_count >= 2 and array_length(info.catchange_xip,1) >= 2 and info.committed_count >= 1 and array_length(info.committed_xip,1) >= 1; }


# Both s0 and s1 execute catalog-change transactions. When "s1_get_changes" is
# executed, s0's transaction is still in progress, while s1's transaction has
# already completed. Consequently, the logical decoding produces a snapshot at
# the point where a RUNNING_XACTS record is generated by "s1_checkpoint".
# This snapshot contains both two ongoing catalog-change transactions (from s0's
# top-level and sub transactions) and one completed transaction (from s1).
# "s1_check_snapshot_info" verifies whether the logical snapshot contains at
# least the expected number of transactions, accounting for potential
# additional catalog changes that may occur due to concurrent autoanalyze.
permutation "s0_init" "s0_begin" "s0_savepoint" "s0_truncate" "s1_create_table" "s1_checkpoint" "s1_get_changes" "s1_check_snapshot_info" "s1_check_snapshot_meta" "s0_commit"
