// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
/**
 * @class   vtkIndexedSignedCharArray
 * @brief   indexed implicit array of signed char.
 *
 * vtkIndexedSignedCharArray is an indexed implicit array of values of type signed char.
 * see vtkIndexedArray, vtkIndexedImplicitBackend
 *
 * This file is generated by vtkImplicitArrays.cmake
 */

#ifndef vtkIndexedSignedCharArray_h
#define vtkIndexedSignedCharArray_h

#include "vtkIndexedArray.h" // Real Superclass
#include "vtkCommonCoreModule.h"     // For export macro
#include "vtkDataArray.h"

// Fake the superclass for the wrappers.
#ifndef __VTK_WRAP__
#define vtkDataArray vtkIndexedArray<signed char>
#endif
VTK_ABI_NAMESPACE_BEGIN
class VTKCOMMONCORE_EXPORT vtkIndexedSignedCharArray : public vtkDataArray
{
public:
  vtkImplicitArrayTypeMacro(vtkIndexedSignedCharArray, vtkDataArray);
#ifndef __VTK_WRAP__
#undef vtkDataArray
#endif

  static vtkIndexedSignedCharArray* New();
  static vtkIndexedSignedCharArray* ExtendedNew();
  void PrintSelf(ostream& os, vtkIndent indent) override;

  // This macro expands to the set of method declarations that
  // make up the interface of vtkImplicitArray, which is ignored
  // by the wrappers.
#if defined(__VTK_WRAP__) || defined(__WRAP_GCCXML__)
  vtkCreateReadOnlyWrappedArrayInterface(signed char);
#endif

  /**
   * A faster alternative to SafeDownCast for downcasting vtkAbstractArrays.
   */
  static vtkIndexedSignedCharArray* FastDownCast(vtkAbstractArray* source)
  {
    return static_cast<vtkIndexedSignedCharArray*>(Superclass::FastDownCast(source));
  }

  ///@{
  /**
   * Set which indexes from array should be exposed.
   */
  void ConstructBackend(vtkIdList* indexes, vtkDataArray* array);
  void ConstructBackend(vtkDataArray* indexes, vtkDataArray* array);
  ///@}

protected:
  vtkIndexedSignedCharArray();
  ~vtkIndexedSignedCharArray() override;

private:
  typedef vtkIndexedArray<signed char> RealSuperclass;

  vtkIndexedSignedCharArray(const vtkIndexedSignedCharArray&) = delete;
  void operator=(const vtkIndexedSignedCharArray&) = delete;
};

// Define vtkArrayDownCast implementation:
vtkArrayDownCast_FastCastMacro(vtkIndexedSignedCharArray);

VTK_ABI_NAMESPACE_END
#endif
// VTK-HeaderTest-Exclude: TYPEMACRO
