\name{SmoothingRecursiveGaussianImageFilter}
\alias{SmoothingRecursiveGaussianImageFilter}
\title{SmoothingRecursiveGaussianImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Computes the smoothing of an image by convolution with the Gaussian
kernels implemented as IIR filters.
SmoothingRecursiveGaussianImageFilter}
\details{
This filter is implemented using the recursive gaussian filters. For
multi-component images, the filter works on each component
independently.
For this filter to be able to run in-place the input and output image
types need to be the same and/or the same type as the RealImageType.
See:
SmoothingRecursiveGaussian for the procedural interface
itk::SmoothingRecursiveGaussianImageFilter for the Doxygen on the original ITK class.
SmoothingRecursiveGaussianImageFilter}
%C++ includes: sitkSmoothingRecursiveGaussianImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image1):}{}
\item{Image Execute(Image &&image1):}{
Execute the filter on the input image
}
\item{std::string GetName() const:}{
Name of this class
}
\item{bool GetNormalizeAcrossScale() const:}{
     Set/Get the flag for normalizing the Gaussian over scale-space.
This method does not effect the output of this filter.
See:
RecursiveGaussianImageFilter::SetNormalizeAcrossScale
}
\item{std::vector< double > GetSigma() const:}{
Get the Sigma scalar. If the Sigma is anisotropic, we will just return
the Sigma along the first dimension.
}
\item{Self NormalizeAcrossScaleOff():}{}
\item{Self NormalizeAcrossScaleOn():}{
Set the value of NormalizeAcrossScale to true or false respectfully.
}
\item{Self SetNormalizeAcrossScale(bool NormalizeAcrossScale):}{
     Set/Get the flag for normalizing the Gaussian over scale-space.
This method does not effect the output of this filter.
See:
RecursiveGaussianImageFilter::SetNormalizeAcrossScale
}
\item{Self SetSigma(double value):}{
Set the values of the Sigma vector all to value
}
\item{Self SetSigma(std::vector< double > Sigma):}{
Set the standard deviation of the Gaussian used for smoothing. Sigma
is measured in the units of image spacing. You may use the method
SetSigma to set the same value across each axis or use the method
SetSigmaArray if you need different values along each axis.
}
\item{ SmoothingRecursiveGaussianImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~SmoothingRecursiveGaussianImageFilter():}{
Destructor
}
}
}
