import ast
import sys
from _typeshed import Incomplete
from collections.abc import Callable, Generator
from typing import Any, TypeVar

_T = TypeVar("_T")

class TranslationError(Exception): ...

pre_method_caches: dict[type[ASTTranslator], dict[type[ast.AST], Callable[..., Any]]]
post_method_caches: dict[type[ASTTranslator], dict[type[ast.AST], Callable[..., Any]]]

class ASTTranslator:
    tree: Incomplete
    def __init__(translator, tree) -> None: ...
    def dispatch(translator, node: ast.AST) -> None: ...
    def call(translator, method: Callable[[ASTTranslator, ast.AST], _T], node: ast.AST) -> _T | None: ...
    def default_pre(translator, node: ast.AST) -> None: ...
    def default_post(translator, node: ast.AST) -> None: ...

def priority(p: int): ...
def binop_src(op: str, node) -> str: ...
def ast2src(tree): ...
def get_child_nodes(node: ast.AST) -> Generator[ast.AST]: ...

class PythonTranslator(ASTTranslator):
    def __init__(translator, tree) -> None: ...
    def call(translator, method, node) -> None: ...
    def default_pre(translator, node: ast.AST): ...
    def default_post(translator, node: ast.AST) -> None: ...
    def postGeneratorExp(translator, node: ast.GeneratorExp) -> str: ...
    def postcomprehension(translator, node: ast.comprehension) -> str: ...
    def postGenExprIf(translator, node) -> str: ...
    def postExpr(translator, node: ast.Expr) -> str: ...
    def postIfExp(translator, node: ast.IfExp) -> str: ...
    def postLambda(translator, node: ast.Lambda) -> str: ...
    def postarguments(translator, node: ast.arguments) -> str: ...
    def postarg(translator, node: ast.arg) -> str: ...
    def postOr(translator, node: ast.Or) -> str: ...
    def postAnd(translator, node: ast.And) -> str: ...
    def postNot(translator, node: ast.Not) -> str: ...
    def postCompare(translator, node: ast.Compare) -> str: ...
    def postEq(translator, node: ast.Eq) -> str: ...
    def postNotEq(translator, node: ast.NotEq) -> str: ...
    def postLt(translator, node: ast.Lt) -> str: ...
    def postLtE(translator, node: ast.LtE) -> str: ...
    def postGt(translator, node: ast.Gt) -> str: ...
    def postGtE(translator, node: ast.GtE) -> str: ...
    def postIs(translator, node: ast.Is) -> str: ...
    def postIsNot(translator, node: ast.IsNot) -> str: ...
    def postIn(translator, node: ast.In) -> str: ...
    def postNotIn(translator, node: ast.NotIn) -> str: ...
    def postBitOr(translator, node: ast.BitOr) -> str: ...
    def postBitXor(translator, node: ast.BitXor) -> str: ...
    def postBitAnd(translator, node: ast.BitAnd) -> str: ...
    def postLShift(translator, node: ast.LShift) -> str: ...
    def postRShift(translator, node: ast.RShift) -> str: ...
    def postAdd(translator, node: ast.Add) -> str: ...
    def postSub(translator, node: ast.Sub) -> str: ...
    def postMult(translator, node: ast.Mult): ...
    def postMatMult(translator, node: ast.MatMult) -> None: ...
    def postDiv(translator, node: ast.Div) -> str: ...
    def postFloorDiv(translator, node: ast.FloorDiv) -> str: ...
    def postMod(translator, node: ast.Mod) -> str: ...
    def postUSub(translator, node: ast.USub) -> str: ...
    def postUAdd(translator, node: ast.UAdd) -> str: ...
    def postInvert(translator, node: ast.Invert) -> str: ...
    def postPow(translator, node: ast.Pow) -> str: ...
    def postAttribute(translator, node: ast.Attribute) -> str: ...
    def postCall(translator, node: ast.Call) -> str: ...
    def postkeyword(translator, node: ast.keyword) -> str: ...
    def postStarred(translator, node: ast.Starred) -> str: ...
    def postSubscript(translator, node: ast.Subscript) -> str: ...
    def postIndex(translator, node: ast.Index) -> str: ...
    def postSlice(translator, node: ast.Slice) -> str: ...
    def postConstant(translator, node: ast.Constant) -> str: ...
    if sys.version_info >= (3, 14):
        def postNameConstant(translator, node: ast.Constant) -> str: ...
        def postNum(translator, node: ast.Constant) -> str: ...
        def postStr(translator, node: ast.Constant) -> str: ...
        def postBytes(translator, node: ast.Constant) -> str: ...
    else:
        def postNameConstant(translator, node: ast.NameConstant) -> str: ...
        def postNum(translator, node: ast.Num) -> str: ...
        def postStr(translator, node: ast.Str) -> str: ...
        def postBytes(translator, node: ast.Bytes) -> str: ...

    def postList(translator, node: ast.List) -> str: ...
    def postTuple(translator, node: ast.Tuple) -> str: ...
    def postDict(translator, node: ast.Dict) -> str: ...
    def postSet(translator, node: ast.Set) -> str: ...
    def postName(translator, node: ast.Name) -> str: ...
    def postJoinedStr(self, node: ast.JoinedStr) -> str: ...
    def postFormattedValue(self, node: ast.FormattedValue) -> str: ...

nonexternalizable_types: tuple[type[ast.AST], ...]

class PreTranslator(ASTTranslator):
    def __init__(translator, tree, globals, locals, special_functions, const_functions, outer_names=()) -> None: ...
    def dispatch(translator, node) -> None: ...
    def preGeneratorExp(translator, node: ast.GeneratorExp) -> bool: ...
    def preLambda(translator, node: ast.Lambda) -> bool: ...
    def postName(translator, node: ast.Name) -> None: ...
    def postSlice(translator, node: ast.Slice) -> None: ...
    def postStarred(translator, node: ast.Starred) -> None: ...
    def postConstant(translator, node: ast.Constant) -> None: ...
    if sys.version_info >= (3, 14):
        def postNum(translator, node: ast.Constant) -> None: ...
        def postStr(translator, node: ast.Constant) -> None: ...
        def postBytes(translator, node: ast.Constant) -> None: ...
    else:
        def postNum(translator, node: ast.Num) -> None: ...
        def postStr(translator, node: ast.Str) -> None: ...
        def postBytes(translator, node: ast.Bytes) -> None: ...

    def postDict(translator, node: ast.Dict) -> None: ...
    def postList(translator, node: ast.List) -> None: ...
    def postkeyword(translator, node: ast.keyword) -> None: ...
    def postIndex(translator, node: ast.Index) -> None: ...
    def postCall(translator, node: ast.Call) -> None: ...
    def postCompare(translator, node: ast.Compare) -> None: ...
    def post_binop(translator, node: ast.BinOp) -> None: ...
    def postBitOr(translator, node: ast.BitOr) -> None: ...
    def postBitXor(translator, node: ast.BitXor) -> None: ...
    def postBitAnd(translator, node: ast.BitAnd) -> None: ...
    def postLShift(translator, node: ast.LShift) -> None: ...
    def postRShift(translator, node: ast.RShift) -> None: ...
    def postAdd(translator, node: ast.Add) -> None: ...
    def postSub(translator, node: ast.Sub) -> None: ...
    def postMult(translator, node: ast.Mult) -> None: ...
    def postMatMult(translator, node: ast.MatMult) -> None: ...
    def postDiv(translator, node: ast.Div) -> None: ...
    def postFloorDiv(translator, node: ast.FloorDiv) -> None: ...
    def postMod(translator, node: ast.Mod) -> None: ...

extractors_cache: dict[str | int, tuple[Incomplete, dict[Incomplete, Incomplete]]]

def create_extractors(code_key: str | int, tree, globals, locals, special_functions, const_functions, outer_names=()): ...
