/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extractors;

import com.intellij.database.DataGridBundle;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.HierarchicalColumnsDataGridModel;
import com.intellij.database.extractors.DataExtractor;
import com.intellij.database.extractors.DefaultValuesExtractor;
import com.intellij.database.extractors.ExtractionConfig;
import com.intellij.database.extractors.ExtractionConfigKt;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.extractors.ObjectFormatterConfig;
import com.intellij.database.util.Out;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridExtractorsUtilCore {
    public static int[] getNonEmptySelection(@NotNull List<? extends GridColumn> allColumns, int[] providedSelection) {
        if (allColumns == null) {
            GridExtractorsUtilCore.$$$reportNull$$$0(0);
        }
        if (providedSelection.length != 0) {
            if (ContainerUtil.and(allColumns, c -> !(c instanceof HierarchicalColumnsDataGridModel.ExtractorHierarchicalGridColumn))) {
                return providedSelection;
            }
            Set<Integer> hierarchicalSelection = GridExtractorsUtilCore.modifySelectionOfHierarchicalColumns(allColumns);
            return GridExtractorsUtilCore.intSetToArray(hierarchicalSelection);
        }
        int[] selection = new int[allColumns.size()];
        for (int i = 0; i < allColumns.size(); ++i) {
            selection[i] = allColumns.get(i).getColumnNumber();
        }
        return selection;
    }

    @NotNull
    private static Set<Integer> modifySelectionOfHierarchicalColumns(@NotNull List<? extends GridColumn> allColumns) {
        if (allColumns == null) {
            GridExtractorsUtilCore.$$$reportNull$$$0(1);
        }
        LinkedHashSet<Integer> resultIdxs = new LinkedHashSet<Integer>();
        for (GridColumn gridColumn : allColumns) {
            HierarchicalColumnsDataGridModel.ExtractorHierarchicalGridColumn hierarchical = (HierarchicalColumnsDataGridModel.ExtractorHierarchicalGridColumn)gridColumn;
            if (!hierarchical.isMatchesSelection()) continue;
            resultIdxs.add(hierarchical.getColumnNumber());
        }
        LinkedHashSet<Integer> linkedHashSet = resultIdxs;
        if (linkedHashSet == null) {
            GridExtractorsUtilCore.$$$reportNull$$$0(2);
        }
        return linkedHashSet;
    }

    public static <T extends GridColumn> Int2ObjectMap<T> getColumnNumsToColumnsMapping(@NotNull List<T> columns) {
        if (columns == null) {
            GridExtractorsUtilCore.$$$reportNull$$$0(3);
        }
        Int2ObjectOpenHashMap m = new Int2ObjectOpenHashMap(columns.size());
        for (GridColumn column : columns) {
            m.put(column.getColumnNumber(), (Object)column);
        }
        return m;
    }

    public static Set<Integer> intArrayToSet(int[] array) {
        HashSet<Integer> set = new HashSet<Integer>();
        for (int element : array) {
            set.add(element);
        }
        return set;
    }

    private static int[] intSetToArray(Set<Integer> set) {
        int[] array = new int[set.size()];
        int index = 0;
        for (Integer num : set) {
            array[index++] = num;
        }
        return array;
    }

    @NotNull
    public static Out extract(@NotNull Out out, @NotNull List<? extends GridColumn> allColumns, @NotNull DataExtractor extractor, @NotNull List<? extends GridRow> rows, int ... selectedColumns) {
        if (out == null) {
            GridExtractorsUtilCore.$$$reportNull$$$0(4);
        }
        if (allColumns == null) {
            GridExtractorsUtilCore.$$$reportNull$$$0(5);
        }
        if (extractor == null) {
            GridExtractorsUtilCore.$$$reportNull$$$0(6);
        }
        if (rows == null) {
            GridExtractorsUtilCore.$$$reportNull$$$0(7);
        }
        return GridExtractorsUtilCore.extract(out, ExtractionConfigKt.DEFAULT_CONFIG, allColumns, extractor, rows, selectedColumns);
    }

    @NotNull
    public static Out extract(@NotNull Out out, @NotNull ExtractionConfig config, @NotNull List<? extends GridColumn> allColumns, @NotNull DataExtractor extractor, @NotNull List<? extends GridRow> rows, int ... selectedColumns) {
        if (out == null) {
            GridExtractorsUtilCore.$$$reportNull$$$0(8);
        }
        if (config == null) {
            GridExtractorsUtilCore.$$$reportNull$$$0(9);
        }
        if (allColumns == null) {
            GridExtractorsUtilCore.$$$reportNull$$$0(10);
        }
        if (extractor == null) {
            GridExtractorsUtilCore.$$$reportNull$$$0(11);
        }
        if (rows == null) {
            GridExtractorsUtilCore.$$$reportNull$$$0(12);
        }
        DataExtractor.Extraction e = extractor.startExtraction(out, allColumns, "", config, selectedColumns);
        e.addData(rows);
        e.complete();
        Out out2 = out;
        if (out2 == null) {
            GridExtractorsUtilCore.$$$reportNull$$$0(13);
        }
        return out2;
    }

    @NotNull
    public static Out extractWithProgress(@NotNull Project project, @NotNull Out out, @NotNull ExtractionConfig config, @NotNull List<? extends GridColumn> allColumns, @NotNull DataExtractor extractor, @NotNull List<? extends GridRow> rows, int ... selectedColumns) {
        if (project == null) {
            GridExtractorsUtilCore.$$$reportNull$$$0(14);
        }
        if (out == null) {
            GridExtractorsUtilCore.$$$reportNull$$$0(15);
        }
        if (config == null) {
            GridExtractorsUtilCore.$$$reportNull$$$0(16);
        }
        if (allColumns == null) {
            GridExtractorsUtilCore.$$$reportNull$$$0(17);
        }
        if (extractor == null) {
            GridExtractorsUtilCore.$$$reportNull$$$0(18);
        }
        if (rows == null) {
            GridExtractorsUtilCore.$$$reportNull$$$0(19);
        }
        DataExtractor.Extraction e = extractor.startExtraction(out, allColumns, "", config, selectedColumns);
        boolean ok = ProgressManager.getInstance().runProcessWithProgressSynchronously((Runnable)new ExtractionRunnable(e, rows), DataGridBundle.message("dialog.title.extraction.with.progress", new Object[0]), true, project);
        if (ok) {
            e.complete();
        }
        Out out2 = out;
        if (out2 == null) {
            GridExtractorsUtilCore.$$$reportNull$$$0(20);
        }
        return out2;
    }

    public static DataExtractor getSingleValueExtractor(@NotNull ObjectFormatter converter, final Function<? super Integer, ObjectFormatterConfig> configProvider) {
        if (converter == null) {
            GridExtractorsUtilCore.$$$reportNull$$$0(21);
        }
        return new DefaultValuesExtractor(converter){

            @Override
            protected boolean isStringLiteral(@Nullable GridRow row, @Nullable GridColumn column) {
                return false;
            }

            @Override
            public boolean supportsText() {
                return true;
            }

            @Override
            public DefaultValuesExtractor.DefaultExtraction startExtraction(final @NotNull Out out, @NotNull List<? extends GridColumn> allColumns, @NotNull String query, @NotNull ExtractionConfig config, int ... selectedColumns) {
                if (out == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (allColumns == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (query == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (config == null) {
                    1.$$$reportNull$$$0(3);
                }
                return new DefaultValuesExtractor.DefaultExtraction(out, ExtractionConfigKt.DEFAULT_CONFIG, allColumns, query, selectedColumns){

                    @Override
                    protected void appendData(List<? extends GridRow> rows) {
                        Int2ObjectMap columnsMap = GridExtractorsUtilCore.getColumnNumsToColumnsMapping(this.myAllColumns);
                        int[] selection = GridExtractorsUtilCore.getNonEmptySelection(this.myAllColumns, this.mySelectedColumnIndices);
                        if (rows.isEmpty() || selection.length == 0) {
                            return;
                        }
                        int selectedColumn = selection[0];
                        GridColumn column = (GridColumn)columnsMap.get(selectedColumn);
                        if (column == null) {
                            return;
                        }
                        GridRow row = rows.get(0);
                        ObjectFormatterConfig config = (ObjectFormatterConfig)configProvider.apply(column.getColumnNumber());
                        out.appendText(this.getValueLiteral(row, column, config));
                    }
                };
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "out";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "allColumns";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "query";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[0] = "config";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/extractors/GridExtractorsUtilCore$1";
                objectArray[2] = "startExtraction";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    public static String prepareFileName(@NotNull String name) {
        if (name == null) {
            GridExtractorsUtilCore.$$$reportNull$$$0(22);
        }
        return StringUtil.trimEnd((String)FileUtil.sanitizeFileName((String)name), (String)"_");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 13, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allColumns";
                break;
            }
            case 2: 
            case 13: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/extractors/GridExtractorsUtilCore";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
            case 4: 
            case 8: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 6: 
            case 11: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extractor";
                break;
            }
            case 7: 
            case 12: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rows";
                break;
            }
            case 9: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "converter";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/extractors/GridExtractorsUtilCore";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "modifySelectionOfHierarchicalColumns";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "extract";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "extractWithProgress";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getNonEmptySelection";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "modifySelectionOfHierarchicalColumns";
                break;
            }
            case 2: 
            case 13: 
            case 20: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getColumnNumsToColumnsMapping";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "extract";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "extractWithProgress";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getSingleValueExtractor";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "prepareFileName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 13, 20 -> new IllegalStateException(string);
        };
    }

    private static class ExtractionRunnable
    implements Runnable {
        private final DataExtractor.Extraction extraction;
        private final List<? extends GridRow> rows;

        private ExtractionRunnable(@NotNull DataExtractor.Extraction extraction, @NotNull List<? extends GridRow> rows) {
            if (extraction == null) {
                ExtractionRunnable.$$$reportNull$$$0(0);
            }
            if (rows == null) {
                ExtractionRunnable.$$$reportNull$$$0(1);
            }
            this.extraction = extraction;
            this.rows = rows;
        }

        @Override
        public void run() {
            this.extraction.addData(this.rows);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "extraction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "rows";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/extractors/GridExtractorsUtilCore$ExtractionRunnable";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

