/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.indexstatemanagement.util;

import java.time.Instant;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.OpenSearchParseException;
import org.opensearch.action.support.clustermanager.ClusterManagerNodeRequest;
import org.opensearch.common.logging.DeprecationLogger;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.indexmanagement.indexstatemanagement.model.ChangePolicy;
import org.opensearch.indexmanagement.indexstatemanagement.util.FailedIndex;
import org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.rest.RestRequest;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001c\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&\u001a\u0010\u0010(\u001a\u00020$2\b\u0010)\u001a\u0004\u0018\u00010*\u001a\u001e\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\"\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u000e\u0010\u000b\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\r\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000e\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000f\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0010\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0011\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0012\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0013\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0014\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0015\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0016\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0017\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0018\u001a\u00020\u0019X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001a\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001b\u001a\u00020\u0019X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001c\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001d\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001e\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001f\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010 \u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010+\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010,\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"WITH_TYPE", "", "WITH_USER", "XCONTENT_WITHOUT_TYPE", "Lorg/opensearch/core/xcontent/ToXContent$MapParams;", "getXCONTENT_WITHOUT_TYPE", "()Lorg/opensearch/core/xcontent/ToXContent$MapParams;", "XCONTENT_WITHOUT_USER", "getXCONTENT_WITHOUT_USER", "XCONTENT_WITHOUT_TYPE_AND_USER", "getXCONTENT_WITHOUT_TYPE_AND_USER", "FAILURES", "FAILED_INDICES", "UPDATED_INDICES", "TOTAL_MANAGED_INDICES", "ISM_TEMPLATE_FIELD", "MANAGED_INDEX_FIELD", "MANAGED_INDEX_NAME_KEYWORD_FIELD", "MANAGED_INDEX_INDEX_FIELD", "MANAGED_INDEX_INDEX_UUID_FIELD", "MANAGED_INDEX_POLICY_ID_FIELD", "DEFAULT_JOB_SORT_FIELD", "DEFAULT_POLICY_SORT_FIELD", "SHOW_POLICY_QUERY_PARAM", "DEFAULT_EXPLAIN_SHOW_POLICY", "", "SHOW_VALIDATE_ACTION", "DEFAULT_EXPLAIN_VALIDATE_ACTION", "INDEX_HIDDEN", "INDEX_NUMBER_OF_SHARDS", "INDEX_NUMBER_OF_REPLICAS", "TYPE_PARAM_KEY", "DEFAULT_INDEX_TYPE", "buildInvalidIndexResponse", "", "builder", "Lorg/opensearch/core/xcontent/XContentBuilder;", "failedIndices", "", "Lorg/opensearch/indexmanagement/indexstatemanagement/util/FailedIndex;", "getPartialChangePolicyBuilder", "changePolicy", "Lorg/opensearch/indexmanagement/indexstatemanagement/model/ChangePolicy;", "MASTER_TIMEOUT_DEPRECATED_MESSAGE", "DUPLICATE_PARAMETER_ERROR_MESSAGE", "parseClusterManagerTimeout", "Lorg/opensearch/common/unit/TimeValue;", "request", "Lorg/opensearch/rest/RestRequest;", "deprecationLogger", "Lorg/opensearch/common/logging/DeprecationLogger;", "restActionName", "opensearch-index-management"})
public final class RestHandlerUtilsKt {
    @NotNull
    public static final String WITH_TYPE = "with_type";
    @NotNull
    public static final String WITH_USER = "with_user";
    @NotNull
    private static final ToXContent.MapParams XCONTENT_WITHOUT_TYPE = new ToXContent.MapParams(MapsKt.mapOf((Pair)TuplesKt.to((Object)"with_type", (Object)"false")));
    @NotNull
    private static final ToXContent.MapParams XCONTENT_WITHOUT_USER = new ToXContent.MapParams(MapsKt.mapOf((Pair)TuplesKt.to((Object)"with_user", (Object)"false")));
    @NotNull
    private static final ToXContent.MapParams XCONTENT_WITHOUT_TYPE_AND_USER;
    @NotNull
    public static final String FAILURES = "failures";
    @NotNull
    public static final String FAILED_INDICES = "failed_indices";
    @NotNull
    public static final String UPDATED_INDICES = "updated_indices";
    @NotNull
    public static final String TOTAL_MANAGED_INDICES = "total_managed_indices";
    @NotNull
    public static final String ISM_TEMPLATE_FIELD = "policy.ism_template";
    @NotNull
    public static final String MANAGED_INDEX_FIELD = "managed_index";
    @NotNull
    public static final String MANAGED_INDEX_NAME_KEYWORD_FIELD = "managed_index.name.keyword";
    @NotNull
    public static final String MANAGED_INDEX_INDEX_FIELD = "managed_index.index";
    @NotNull
    public static final String MANAGED_INDEX_INDEX_UUID_FIELD = "managed_index.index_uuid";
    @NotNull
    public static final String MANAGED_INDEX_POLICY_ID_FIELD = "managed_index.policy_id";
    @NotNull
    public static final String DEFAULT_JOB_SORT_FIELD = "managed_index.index";
    @NotNull
    public static final String DEFAULT_POLICY_SORT_FIELD = "policy.policy_id.keyword";
    @NotNull
    public static final String SHOW_POLICY_QUERY_PARAM = "show_policy";
    public static final boolean DEFAULT_EXPLAIN_SHOW_POLICY = false;
    @NotNull
    public static final String SHOW_VALIDATE_ACTION = "validate_action";
    public static final boolean DEFAULT_EXPLAIN_VALIDATE_ACTION = false;
    @NotNull
    public static final String INDEX_HIDDEN = "index.hidden";
    @NotNull
    public static final String INDEX_NUMBER_OF_SHARDS = "index.number_of_shards";
    @NotNull
    public static final String INDEX_NUMBER_OF_REPLICAS = "index.number_of_replicas";
    @NotNull
    public static final String TYPE_PARAM_KEY = "type";
    @NotNull
    public static final String DEFAULT_INDEX_TYPE = "_default";
    @NotNull
    public static final String MASTER_TIMEOUT_DEPRECATED_MESSAGE = "Parameter [master_timeout] is deprecated and will be removed in 3.0. To support inclusive language, please use [cluster_manager_timeout] instead.";
    @NotNull
    public static final String DUPLICATE_PARAMETER_ERROR_MESSAGE = "Please only use one of the request parameters [master_timeout, cluster_manager_timeout].";

    @NotNull
    public static final ToXContent.MapParams getXCONTENT_WITHOUT_TYPE() {
        return XCONTENT_WITHOUT_TYPE;
    }

    @NotNull
    public static final ToXContent.MapParams getXCONTENT_WITHOUT_USER() {
        return XCONTENT_WITHOUT_USER;
    }

    @NotNull
    public static final ToXContent.MapParams getXCONTENT_WITHOUT_TYPE_AND_USER() {
        return XCONTENT_WITHOUT_TYPE_AND_USER;
    }

    public static final void buildInvalidIndexResponse(@NotNull XContentBuilder builder, @NotNull List<FailedIndex> failedIndices) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter(failedIndices, (String)"failedIndices");
        if (!((Collection)failedIndices).isEmpty()) {
            builder.field(FAILURES, true);
            builder.startArray(FAILED_INDICES);
            for (FailedIndex failedIndex : failedIndices) {
                ToXContent.Params params = ToXContent.EMPTY_PARAMS;
                Intrinsics.checkNotNullExpressionValue((Object)params, (String)"EMPTY_PARAMS");
                failedIndex.toXContent(builder, params);
            }
            v1 = builder.endArray();
        } else {
            builder.field(FAILURES, false);
            v1 = builder.startArray(FAILED_INDICES).endArray();
        }
    }

    @NotNull
    public static final XContentBuilder getPartialChangePolicyBuilder(@Nullable ChangePolicy changePolicy) {
        XContentBuilder xContentBuilder = XContentFactory.jsonBuilder().startObject().startObject(MANAGED_INDEX_FIELD);
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"startObject(...)");
        XContentBuilder builder = OpenSearchExtensionsKt.optionalTimeField(xContentBuilder, "last_updated_time", Instant.now()).field("change_policy", (ToXContent)changePolicy);
        XContentBuilder xContentBuilder2 = builder.endObject().endObject();
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder2, (String)"endObject(...)");
        return xContentBuilder2;
    }

    @NotNull
    public static final TimeValue parseClusterManagerTimeout(@NotNull RestRequest request, @NotNull DeprecationLogger deprecationLogger, @NotNull String restActionName) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)deprecationLogger, (String)"deprecationLogger");
        Intrinsics.checkNotNullParameter((Object)restActionName, (String)"restActionName");
        TimeValue timeout = request.paramAsTime("cluster_manager_timeout", ClusterManagerNodeRequest.DEFAULT_CLUSTER_MANAGER_NODE_TIMEOUT);
        if (request.hasParam("master_timeout")) {
            deprecationLogger.deprecate(restActionName + "_master_timeout_parameter", MASTER_TIMEOUT_DEPRECATED_MESSAGE, new Object[0]);
            if (request.hasParam("cluster_manager_timeout")) {
                throw new OpenSearchParseException(DUPLICATE_PARAMETER_ERROR_MESSAGE, new Object[0]);
            }
            timeout = request.paramAsTime("master_timeout", timeout);
        }
        TimeValue timeValue = timeout;
        Intrinsics.checkNotNull((Object)timeValue);
        return timeValue;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)WITH_TYPE, (Object)"false"), TuplesKt.to((Object)WITH_USER, (Object)"false")};
        XCONTENT_WITHOUT_TYPE_AND_USER = new ToXContent.MapParams(MapsKt.mapOf((Pair[])pairArray));
    }
}

