"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createReportDefinition = void 0;
var _uiToBackend = require("../utils/converters/uiToBackend");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const createReportDefinition = async (request, context, reportDefinition) => {
  // @ts-ignore
  const opensearchReportsClient = context.reporting_plugin.opensearchReportsClient.asScoped(request);
  // create report definition
  const reqBody = {
    reportDefinition: (0, _uiToBackend.uiToBackendReportDefinition)(reportDefinition)
  };
  const opensearchResp = await opensearchReportsClient.callAsCurrentUser('opensearch_reports.createReportDefinition', {
    body: reqBody
  });
  return opensearchResp;
};
exports.createReportDefinition = createReportDefinition;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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