/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.painter;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import org.jdesktop.swingx.painter.AbstractAreaPainter;
import org.jdesktop.swingx.painter.PainterUtils;
import org.jdesktop.swingx.painter.effects.AreaEffect;

public class ShapePainter
extends AbstractAreaPainter<Object> {
    private Shape shape;

    public ShapePainter() {
        this.shape = new Ellipse2D.Double(0.0, 0.0, 100.0, 100.0);
        this.setBorderWidth(3.0f);
        this.setFillPaint(Color.RED);
        this.setBorderPaint(Color.BLACK);
    }

    public ShapePainter(Shape shape) {
        this.shape = shape;
    }

    public ShapePainter(Shape shape, Paint paint) {
        this.shape = shape;
        this.setFillPaint(paint);
    }

    public ShapePainter(Shape shape, Paint paint, AbstractAreaPainter.Style style) {
        this.shape = shape;
        this.setFillPaint(paint);
        this.setStyle(style == null ? AbstractAreaPainter.Style.BOTH : style);
    }

    public void setShape(Shape s2) {
        Shape old = this.getShape();
        this.shape = s2;
        this.setDirty(true);
        this.firePropertyChange("shape", old, this.getShape());
    }

    public Shape getShape() {
        return this.shape;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void doPaint(Graphics2D g2, Object component, int w, int h2) {
        g2.setStroke(new BasicStroke(this.getBorderWidth()));
        if (this.getShape() == null) return;
        Shape s2 = this.provideShape(g2, component, w, h2);
        Rectangle bounds = s2.getBounds();
        Rectangle rect = this.calculateLayout(bounds.width, bounds.height, w, h2);
        g2 = (Graphics2D)g2.create();
        try {
            g2.translate(rect.x, rect.y);
            this.drawPathEffects(g2, s2, rect.width, rect.height);
            switch (this.getStyle()) {
                case BOTH: {
                    this.drawShape(g2, s2, component, rect.width, rect.height);
                    this.fillShape(g2, s2, component, rect.width, rect.height);
                    return;
                }
                case FILLED: {
                    this.fillShape(g2, s2, component, rect.width, rect.height);
                    return;
                }
                case OUTLINE: {
                    this.drawShape(g2, s2, component, rect.width, rect.height);
                    return;
                }
            }
            return;
        }
        finally {
            g2.dispose();
        }
    }

    private void drawShape(Graphics2D g2, Shape s2, Object component, int w, int h2) {
        g2.setPaint(this.calculateStrokePaint(component, w, h2));
        g2.draw(s2);
    }

    private void fillShape(Graphics2D g2, Shape s2, Object component, int w, int h2) {
        g2.setPaint(this.calculateFillPaint(component, w, h2));
        g2.fill(s2);
    }

    @Override
    protected Shape provideShape(Graphics2D g2, Object comp, int width, int height) {
        return this.getShape();
    }

    private Paint calculateStrokePaint(Object component, int width, int height) {
        Paint p = PainterUtils.getForegroundPaint(this.getBorderPaint(), component);
        if (this.isPaintStretched()) {
            p = this.calculateSnappedPaint(p, width, height);
        }
        return p;
    }

    private Paint calculateFillPaint(Object component, int width, int height) {
        Paint p = PainterUtils.getBackgroundPaint(this.getFillPaint(), component);
        if (this.isPaintStretched()) {
            p = this.calculateSnappedPaint(p, width, height);
        }
        return p;
    }

    private void drawPathEffects(Graphics2D g2, Shape s2, int w, int h2) {
        if (this.getAreaEffects() != null) {
            for (AreaEffect ef : this.getAreaEffects()) {
                ef.apply(g2, s2, w, h2);
            }
        }
    }
}

