/*
 * Decompiled with CFR 0.152.
 */
package jspecview.java;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.List;
import javajs.util.PT;
import org.jmol.api.PlatformViewer;
import org.jmol.util.Logger;

public class FileDropperJmol
implements DropTargetListener {
    private String fd_oldFileName = "";
    private PropertyChangeSupport fd_propSupport = new PropertyChangeSupport(this);
    public static final String FD_PROPERTY_INLINE = "inline";
    PropertyChangeListener pcl = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            FileDropperJmol.this.doDrop(evt);
        }
    };

    public FileDropperJmol(PlatformViewer viewer) {
        this.addPropertyChangeListener(this.pcl);
    }

    public void dispose() {
        this.removePropertyChangeListener(this.pcl);
    }

    private void loadFile(String fname) {
        if ((fname = fname.replace('\\', '/').trim()).indexOf("://") < 0) {
            fname = (fname.startsWith("/") ? "file://" : "file:///") + fname;
        }
    }

    private void loadFiles(List<File> fileList) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < fileList.size(); ++i) {
            File f = fileList.get(i);
            String fname = f.getAbsolutePath();
            fname = fname.replace('\\', '/').trim();
            fname = (fname.startsWith("/") ? "file://" : "file:///") + fname;
            sb.append("load ").append(i == 0 ? "" : "APPEND ").append(PT.esc(fname)).append(";\n");
        }
        sb.append("frame *;reset;");
    }

    protected void doDrop(PropertyChangeEvent evt) {
        if (evt.getPropertyName() == FD_PROPERTY_INLINE) {
            // empty if block
        }
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener l) {
        this.fd_propSupport.addPropertyChangeListener(l);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener l) {
        this.fd_propSupport.removePropertyChangeListener(l);
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        if (Logger.debugging) {
            Logger.debug("DropOver detected...");
        }
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        if (Logger.debugging) {
            Logger.debug("DropEnter detected...");
        }
        dtde.acceptDrag(3);
    }

    @Override
    public void dragExit(DropTargetEvent dtde) {
        if (Logger.debugging) {
            Logger.debug("DropExit detected...");
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        DataFlavor[] df;
        if (Logger.debugging) {
            Logger.debug("Drop detected...");
        }
        Transferable t = dtde.getTransferable();
        boolean isAccepted = false;
        if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            Object o = null;
            try {
                dtde.acceptDrop(3);
                o = t.getTransferData(DataFlavor.javaFileListFlavor);
                isAccepted = true;
            }
            catch (Exception e) {
                Logger.error("transfer failed");
            }
            if (o instanceof List) {
                List fileList = (List)o;
                int length = fileList.size();
                if (length == 1) {
                    String fileName = ((File)fileList.get(0)).getAbsolutePath().trim();
                    if (!fileName.endsWith(".bmp")) {
                        dtde.getDropTargetContext().dropComplete(true);
                        this.loadFile(fileName);
                        return;
                    }
                } else {
                    dtde.getDropTargetContext().dropComplete(true);
                    this.loadFiles(fileList);
                    return;
                }
            }
        }
        if (Logger.debugging) {
            Logger.debug("browsing supported flavours to find something useful...");
        }
        if ((df = t.getTransferDataFlavors()) == null || df.length == 0) {
            return;
        }
        for (int i = 0; i < df.length; ++i) {
            DataFlavor flavor = df[i];
            Object o = null;
            Logger.info("df " + i + " flavor " + flavor);
            Logger.info("  class: " + flavor.getRepresentationClass().getName());
            Logger.info("  mime : " + flavor.getMimeType());
            if (flavor.getMimeType().startsWith("text/uri-list") && flavor.getRepresentationClass().getName().equals("java.lang.String")) {
                try {
                    if (!isAccepted) {
                        dtde.acceptDrop(3);
                    }
                    isAccepted = true;
                    o = t.getTransferData(flavor);
                }
                catch (Exception e) {
                    Logger.errorEx(null, e);
                }
                if (!(o instanceof String)) continue;
                if (Logger.debugging) {
                    Logger.debug("  String: " + o.toString());
                }
                this.loadFile(o.toString());
                dtde.getDropTargetContext().dropComplete(true);
                return;
            }
            if (!flavor.getMimeType().equals("application/x-java-serialized-object; class=java.lang.String")) continue;
            try {
                if (!isAccepted) {
                    dtde.acceptDrop(3);
                }
                isAccepted = true;
                o = t.getTransferData(df[i]);
            }
            catch (Exception e) {
                Logger.errorEx(null, e);
            }
            if (!(o instanceof String)) continue;
            String content = (String)o;
            if (Logger.debugging) {
                Logger.debug("  String: " + content);
            }
            if (content.startsWith("file:/")) {
                this.loadFile(content);
            } else {
                PropertyChangeEvent pce = new PropertyChangeEvent(this, FD_PROPERTY_INLINE, this.fd_oldFileName, content);
                this.fd_propSupport.firePropertyChange(pce);
            }
            dtde.getDropTargetContext().dropComplete(true);
            return;
        }
        if (!isAccepted) {
            dtde.rejectDrop();
        }
    }
}

