/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.graph;

import com.google.common.base.Supplier;
import com.google.common.collect.Ordering;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.MultiGraph;
import edu.uci.ics.jung.graph.OrderedSparseMultigraph;
import edu.uci.ics.jung.graph.util.Pair;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

public class SortedSparseMultigraph<V, E>
extends OrderedSparseMultigraph<V, E>
implements MultiGraph<V, E> {
    protected Comparator<V> vertex_comparator;
    protected Comparator<E> edge_comparator;

    public static <V, E> Supplier<Graph<V, E>> getFactory() {
        return new Supplier<Graph<V, E>>(){

            public Graph<V, E> get() {
                return new SortedSparseMultigraph();
            }
        };
    }

    public SortedSparseMultigraph(Comparator<V> vertex_comparator, Comparator<E> edge_comparator) {
        this.vertex_comparator = vertex_comparator;
        this.edge_comparator = edge_comparator;
        this.vertices = new TreeMap(vertex_comparator);
        this.edges = new TreeMap(edge_comparator);
        this.directedEdges = new TreeSet<E>(edge_comparator);
    }

    public SortedSparseMultigraph() {
        this((Comparator<V>)new Ordering<V>(){

            public int compare(V v1, V v2) {
                return ((Comparable)v1).compareTo(v2);
            }
        }, (Comparator<E>)new Ordering<E>(){

            public int compare(E e1, E e2) {
                return ((Comparable)e1).compareTo(e2);
            }
        });
    }

    public void setVertexComparator(Comparator<V> vertex_comparator) {
        this.vertex_comparator = vertex_comparator;
        TreeMap tmp_vertices = new TreeMap(vertex_comparator);
        for (Map.Entry entry : this.vertices.entrySet()) {
            tmp_vertices.put(entry.getKey(), entry.getValue());
        }
        this.vertices = tmp_vertices;
    }

    @Override
    public boolean addVertex(V vertex) {
        if (vertex == null) {
            throw new IllegalArgumentException("vertex may not be null");
        }
        if (!this.containsVertex(vertex)) {
            this.vertices.put(vertex, new Pair<TreeSet<E>>(new TreeSet<E>(this.edge_comparator), new TreeSet<E>(this.edge_comparator)));
            return true;
        }
        return false;
    }
}

