/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

public class MaximizeSpecificColumnGridLayout
implements LayoutManager {
    private int vgap;
    private int hgap;
    private final int columnCount;
    private boolean[] maximizedColumns;

    public MaximizeSpecificColumnGridLayout(int columnCount) {
        this(0, 0, columnCount);
    }

    public MaximizeSpecificColumnGridLayout(int vgap, int hgap, int columnCount) {
        this.vgap = vgap;
        this.hgap = hgap;
        if (columnCount <= 0) {
            columnCount = 1;
        }
        this.columnCount = columnCount;
        this.maximizedColumns = new boolean[columnCount];
    }

    public void maximizeColumn(int column) {
        this.maximizedColumns[column] = true;
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        int componentCount = parent.getComponentCount();
        int rowCount = (componentCount + (this.columnCount - 1)) / this.columnCount;
        Insets insets = parent.getInsets();
        Dimension d = new Dimension(0, 0);
        int totalComponentHeight = 0;
        for (int i = 0; i < rowCount; ++i) {
            totalComponentHeight += this.getRowHeight(parent, i);
        }
        int[] desiredColumnWidths = this.getDesiredColumnWidths(parent);
        int totalComponentWidth = this.getTotalWidth(desiredColumnWidths);
        d.width = totalComponentWidth + this.hgap * (this.columnCount - 1) + insets.left + insets.right;
        d.height = totalComponentHeight + this.vgap * (rowCount - 1) + insets.top + insets.bottom;
        return d;
    }

    private int getRowHeight(Container parent, int row) {
        int rowHeight = 0;
        int componentCount = parent.getComponentCount();
        for (int i = 0; i < this.columnCount; ++i) {
            int ordinal = row * this.columnCount + i;
            if (ordinal >= componentCount) {
                return rowHeight;
            }
            Component component = parent.getComponent(ordinal);
            Dimension d = component.getPreferredSize();
            rowHeight = Math.max(rowHeight, d.height);
        }
        return rowHeight;
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    @Override
    public void layoutContainer(Container parent) {
        int componentCount = parent.getComponentCount();
        int rowCount = (componentCount + (this.columnCount - 1)) / this.columnCount;
        Dimension d = parent.getSize();
        Insets insets = parent.getInsets();
        int width = d.width - (insets.left + insets.right);
        int[] desiredColumnWidths = this.getDesiredColumnWidths(parent);
        int totalDesiredWidth = this.getTotalWidth(desiredColumnWidths);
        int offset = totalDesiredWidth < width ? (width - totalDesiredWidth) / 2 : 0;
        int[] computedColumnWidths = this.getComputedColumnWidths(width, desiredColumnWidths);
        int y = insets.top;
        for (int i = 0; i < rowCount; ++i) {
            int ordinal;
            int x = insets.left + offset;
            int rowHeight = this.getRowHeight(parent, i);
            for (int j = 0; j < this.columnCount && (ordinal = i * this.columnCount + j) < componentCount; ++j) {
                Component component = parent.getComponent(ordinal);
                component.setBounds(x, y, computedColumnWidths[j], rowHeight);
                x += computedColumnWidths[j] + this.hgap;
            }
            y += rowHeight + this.vgap;
        }
    }

    private int getTotalWidth(int[] individualWidths) {
        int total = 0;
        for (int i = 0; i < individualWidths.length; ++i) {
            total += individualWidths[i];
        }
        return total;
    }

    private int[] getComputedColumnWidths(int width, int[] desiredColumnWidths) {
        int i;
        int[] computedColumnWidths = new int[desiredColumnWidths.length];
        int remainingColumnCount = desiredColumnWidths.length;
        int remainingWidth = width - this.hgap * (desiredColumnWidths.length - 1);
        int maximizedCount = this.getMaximizedCount();
        if (maximizedCount > 0) {
            int desiredMaximizedWidth = this.getDesiredMaximizedWidth(desiredColumnWidths);
            if (desiredMaximizedWidth >= width) {
                int i2;
                int remainingMaximizedWidth = width;
                int averageMaximizedWidth = remainingMaximizedWidth / maximizedCount;
                int remainingMaximizedCount = maximizedCount;
                boolean foundOne = true;
                while (foundOne) {
                    foundOne = false;
                    for (i2 = 0; i2 < computedColumnWidths.length; ++i2) {
                        if (!this.maximizedColumns[i2] || computedColumnWidths[i2] != 0 || desiredColumnWidths[i2] >= averageMaximizedWidth) continue;
                        computedColumnWidths[i2] = desiredColumnWidths[i2];
                        remainingMaximizedWidth -= computedColumnWidths[i2];
                        --remainingMaximizedCount;
                        foundOne = true;
                    }
                    averageMaximizedWidth = remainingMaximizedCount > 0 ? remainingMaximizedWidth / remainingMaximizedCount : 0;
                }
                for (i2 = 0; i2 < computedColumnWidths.length; ++i2) {
                    if (!this.maximizedColumns[i2] || computedColumnWidths[i2] != 0) continue;
                    computedColumnWidths[i2] = averageMaximizedWidth;
                    remainingMaximizedWidth -= computedColumnWidths[i2];
                    --remainingMaximizedCount;
                }
                return computedColumnWidths;
            }
            for (int i3 = 0; i3 < desiredColumnWidths.length; ++i3) {
                if (!this.maximizedColumns[i3]) continue;
                computedColumnWidths[i3] = desiredColumnWidths[i3];
                remainingWidth -= computedColumnWidths[i3];
                --remainingColumnCount;
            }
        }
        int averageColumnWidth = remainingColumnCount > 0 ? remainingWidth / remainingColumnCount : 0;
        boolean foundOne = true;
        while (foundOne) {
            foundOne = false;
            for (i = 0; i < computedColumnWidths.length; ++i) {
                if (computedColumnWidths[i] != 0 || desiredColumnWidths[i] >= averageColumnWidth) continue;
                computedColumnWidths[i] = desiredColumnWidths[i];
                remainingWidth -= computedColumnWidths[i];
                --remainingColumnCount;
                foundOne = true;
            }
            averageColumnWidth = remainingColumnCount > 0 ? remainingWidth / remainingColumnCount : 0;
        }
        for (i = 0; i < computedColumnWidths.length; ++i) {
            if (computedColumnWidths[i] != 0) continue;
            computedColumnWidths[i] = averageColumnWidth;
        }
        return computedColumnWidths;
    }

    private int getMaximizedCount() {
        int count = 0;
        for (int i = 0; i < this.maximizedColumns.length; ++i) {
            if (!this.maximizedColumns[i]) continue;
            ++count;
        }
        return count;
    }

    private int[] getDesiredColumnWidths(Container parent) {
        int[] columnWidths = new int[this.columnCount];
        int componentCount = parent.getComponentCount();
        int rowCount = (componentCount + (this.columnCount - 1)) / this.columnCount;
        for (int i = 0; i < rowCount; ++i) {
            int ordinal;
            for (int j = 0; j < this.columnCount && (ordinal = i * this.columnCount + j) < componentCount; ++j) {
                Component component = parent.getComponent(ordinal);
                columnWidths[j] = Math.max(columnWidths[j], component.getPreferredSize().width);
            }
        }
        return columnWidths;
    }

    private int getDesiredMaximizedWidth(int[] desiredWidths) {
        int width = 0;
        for (int i = 0; i < desiredWidths.length; ++i) {
            if (!this.maximizedColumns[i]) continue;
            width += desiredWidths[i];
        }
        return width;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }
}

