/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.cramfs;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class CramFsInfo
implements StructConverter {
    private int crc;
    private int edition;
    private int blocks;
    private int files;

    public CramFsInfo(BinaryReader reader) throws IOException {
        this.crc = reader.readNextInt();
        this.edition = reader.readNextInt();
        this.blocks = reader.readNextInt();
        this.files = reader.readNextInt();
    }

    public int getCrc() {
        return this.crc;
    }

    public int getEdition() {
        return this.edition;
    }

    public int getBlocks() {
        return this.blocks;
    }

    public int getFiles() {
        return this.files;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("cramfs_info", 0);
        struct.add(DWORD, "crc", null);
        struct.add(DWORD, "edition", null);
        struct.add(DWORD, "blocks", null);
        struct.add(DWORD, "files", null);
        return struct;
    }
}

