/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.graph;

import ghidra.util.graph.DirectedGraph;
import ghidra.util.graph.Edge;
import ghidra.util.graph.KeyedObject;
import ghidra.util.graph.Vertex;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.Stack;

@Deprecated(since="10.2")
public class DepthFirstSearch {
    private DirectedGraph graph;
    private List<Vertex> seedsUsed;
    private Set<Vertex> unseen;
    private Set<Vertex> finished;
    private Stack<KeyedObject> pending;
    private LinkedList<Vertex> finishListInReverseOrder;
    private List<Edge> backEdges;
    private List<Edge> treeEdges;

    public DepthFirstSearch(DirectedGraph graph, Vertex[] initialSeeds, boolean getAdditionalSeedsIfNeeded, boolean goForward, boolean goBackward) {
        if (!goForward && !goBackward) {
            return;
        }
        this.graph = graph;
        this.seedsUsed = new ArrayList<Vertex>();
        this.unseen = graph.vertices().toSet();
        this.finished = new HashSet<Vertex>(graph.numVertices());
        this.pending = new Stack();
        this.finishListInReverseOrder = new LinkedList();
        this.backEdges = new ArrayList<Edge>(graph.numEdges() / 5);
        this.treeEdges = new ArrayList<Edge>(graph.numEdges() / 5);
        Set<Edge> edges = null;
        boolean done = true;
        Vertex[] seeds = initialSeeds;
        if (goForward && !goBackward) {
            do {
                for (Vertex seed : seeds) {
                    Vertex v = seed;
                    if (!this.isUnseen(v)) continue;
                    this.seedsUsed.add(v);
                    this.pending.push(v);
                    this.unseen.remove(v);
                    while (!this.pending.isEmpty()) {
                        KeyedObject o = this.pending.peek();
                        if (o instanceof Vertex) {
                            v = (Vertex)o;
                            edges = graph.getOutgoingEdges(v);
                            Iterator<Edge> edgeIter = edges.iterator();
                            while (edgeIter.hasNext()) {
                                this.pending.push(edgeIter.next());
                            }
                            if (edges.size() != 0) continue;
                            this.finished.add(v);
                            this.finishListInReverseOrder.addFirst(v);
                            this.pending.pop();
                            continue;
                        }
                        Edge e = (Edge)this.pending.pop();
                        v = e.to();
                        if (this.isUnseen(v)) {
                            this.pending.push(e);
                            this.pending.push(v);
                            this.treeEdges.add(e);
                            this.unseen.remove(v);
                            continue;
                        }
                        if (this.isCompleted(v)) {
                            if (!(this.pending.peek() instanceof Vertex)) continue;
                            v = (Vertex)this.pending.pop();
                            this.finished.add(v);
                            this.finishListInReverseOrder.addFirst(v);
                            continue;
                        }
                        this.backEdges.add(e);
                        if (!(this.pending.peek() instanceof Vertex)) continue;
                        v = (Vertex)this.pending.pop();
                        this.finished.add(v);
                        this.finishListInReverseOrder.addFirst(v);
                    }
                }
                done = true;
                if (!getAdditionalSeedsIfNeeded || this.unseen.isEmpty()) continue;
                seeds = this.unseen.toArray(new Vertex[this.unseen.size()]);
                done = false;
            } while (!done);
        } else if (!goForward && goBackward) {
            do {
                for (Vertex seed : seeds) {
                    Vertex v = seed;
                    if (!this.isUnseen(v)) continue;
                    this.seedsUsed.add(v);
                    this.pending.push(v);
                    this.unseen.remove(v);
                    while (!this.pending.isEmpty()) {
                        KeyedObject o = this.pending.peek();
                        if (o instanceof Vertex) {
                            v = (Vertex)o;
                            edges = graph.getIncomingEdges(v);
                            Iterator<Edge> edgeIter = edges.iterator();
                            while (edgeIter.hasNext()) {
                                this.pending.push(edgeIter.next());
                            }
                            if (edges.size() != 0) continue;
                            this.finished.add(v);
                            this.finishListInReverseOrder.addFirst(v);
                            this.pending.pop();
                            continue;
                        }
                        Edge e = (Edge)this.pending.pop();
                        v = e.from();
                        if (this.isUnseen(v)) {
                            this.pending.push(e);
                            this.pending.push(v);
                            this.treeEdges.add(e);
                            this.unseen.remove(v);
                            continue;
                        }
                        if (this.isCompleted(v)) {
                            if (!(this.pending.peek() instanceof Vertex)) continue;
                            v = (Vertex)this.pending.pop();
                            this.finished.add(v);
                            this.finishListInReverseOrder.addFirst(v);
                            continue;
                        }
                        this.backEdges.add(e);
                        if (!(this.pending.peek() instanceof Vertex)) continue;
                        v = (Vertex)this.pending.pop();
                        this.finished.add(v);
                        this.finishListInReverseOrder.addFirst(v);
                    }
                }
                done = true;
                if (!getAdditionalSeedsIfNeeded || this.unseen.isEmpty()) continue;
                seeds = this.unseen.toArray(new Vertex[this.unseen.size()]);
                done = false;
            } while (!done);
        } else {
            do {
                for (Vertex seed : seeds) {
                    Vertex v = seed;
                    if (!this.isUnseen(v)) continue;
                    this.seedsUsed.add(v);
                    this.pending.push(v);
                    this.unseen.remove(v);
                    while (!this.pending.isEmpty()) {
                        KeyedObject o = this.pending.peek();
                        if (o instanceof Vertex) {
                            v = (Vertex)o;
                            edges = graph.getOutgoingEdges(v);
                            edges.addAll(graph.getIncomingEdges(v));
                            Iterator<Edge> edgeIter = edges.iterator();
                            while (edgeIter.hasNext()) {
                                this.pending.push(edgeIter.next());
                            }
                            if (edges.size() != 0) continue;
                            this.finished.add(v);
                            this.finishListInReverseOrder.addFirst(v);
                            this.pending.pop();
                            continue;
                        }
                        Edge e = (Edge)this.pending.pop();
                        ListIterator li = this.pending.listIterator(this.pending.size());
                        v = null;
                        while (li.hasPrevious() && v == null) {
                            o = li.previous();
                            if (!(o instanceof Vertex)) continue;
                            v = (Vertex)o;
                        }
                        if (this.isUnseen(v)) {
                            this.pending.push(e);
                            this.pending.push(v);
                            this.treeEdges.add(e);
                            this.unseen.remove(v);
                            continue;
                        }
                        if (this.isCompleted(v)) {
                            if (!(this.pending.peek() instanceof Vertex)) continue;
                            v = (Vertex)this.pending.pop();
                            this.finished.add(v);
                            this.finishListInReverseOrder.addFirst(v);
                            continue;
                        }
                        this.backEdges.add(e);
                        if (!(this.pending.peek() instanceof Vertex)) continue;
                        v = (Vertex)this.pending.pop();
                        this.finished.add(v);
                        this.finishListInReverseOrder.addFirst(v);
                    }
                }
                done = true;
                if (!getAdditionalSeedsIfNeeded || this.unseen.isEmpty()) continue;
                seeds = this.unseen.toArray(new Vertex[this.unseen.size()]);
                done = false;
            } while (!done);
        }
    }

    public boolean isUnseen(Vertex v) {
        return this.unseen.contains(v);
    }

    public boolean isCompleted(Vertex v) {
        return this.finished.contains(v);
    }

    public Edge[] backEdges() {
        return this.backEdges.toArray(new Edge[this.backEdges.size()]);
    }

    public Edge[] treeEdges() {
        return this.treeEdges.toArray(new Edge[this.treeEdges.size()]);
    }

    public boolean isAcyclic() {
        return this.backEdges.isEmpty();
    }

    public boolean isTree() {
        return this.treeEdges.size() == this.graph.numEdges();
    }

    public Vertex[] topologicalSort() {
        return this.finishListInReverseOrder.toArray(new Vertex[this.finishListInReverseOrder.size()]);
    }

    List<Vertex> seedsUsed() {
        return this.seedsUsed;
    }

    public DirectedGraph spanningTree() {
        DirectedGraph g = new DirectedGraph(this.treeEdges.size() + 1, this.treeEdges.size());
        Iterator<Edge> iter = this.treeEdges.iterator();
        while (iter.hasNext()) {
            g.add(iter.next());
        }
        return g;
    }
}

