/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.connection;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ResourceLocator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.connection.DBPDriverSubstitutionDescriptor;
import org.jkiss.dbeaver.model.connection.DataSourceVariableResolver;
import org.jkiss.dbeaver.registry.DataSourceDescriptor;
import org.jkiss.dbeaver.registry.DataSourceProviderRegistry;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.IVariableResolver;
import org.jkiss.dbeaver.runtime.ui.UIServiceSecurity;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.IDataSourceConnectionEditor;
import org.jkiss.dbeaver.ui.IDataSourceConnectionEditorSite;
import org.jkiss.dbeaver.ui.ShellUtils;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.VariablesHintLabel;
import org.jkiss.dbeaver.ui.dialogs.AcceptLicenseDialog;
import org.jkiss.dbeaver.ui.dialogs.IConnectionWizard;
import org.jkiss.dbeaver.ui.internal.UIConnectionMessages;
import org.jkiss.dbeaver.utils.HelpUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public abstract class ConnectionPageAbstract
extends DialogPage
implements IDataSourceConnectionEditor {
    public static final String PROP_DRIVER_SUBSTITUTION = "driver-substitution";
    protected static final String GROUP_CONNECTION_MODE = "connectionMode";
    protected static final String GROUP_CONNECTION = "connection";
    protected static final String GROUP_URL = "url";
    protected static final List<String> GROUP_CONNECTION_ARR = List.of("connection");
    protected static final List<String> GROUP_URL_ARR = List.of("url");
    @NotNull
    protected final Map<String, Set<Control>> propGroupMap = new HashMap<String, Set<Control>>();
    protected IDataSourceConnectionEditorSite site;
    protected Text driverText;
    protected Text passwordText;
    protected Button savePasswordCheck;
    protected ToolBar userManagementToolbar;
    private VariablesHintLabel variablesHintLabel;
    @Nullable
    protected Button typeManualRadio;
    @Nullable
    protected Button typeURLRadio;
    private Combo driverSubstitutionCombo;
    private ImageDescriptor curImageDescriptor;
    private Button licenseButton;
    @Nullable
    private Control databaseDocumentationInfoLabel;

    public IDataSourceConnectionEditorSite getSite() {
        return this.site;
    }

    public void dispose() {
        super.dispose();
    }

    public void setSite(@NotNull IDataSourceConnectionEditorSite site) {
        this.site = site;
    }

    protected boolean isCustomURL() {
        return this.typeURLRadio != null && this.typeURLRadio.getSelection();
    }

    public void loadSettings() {
        DBPDriver driver = this.site.getDriver();
        if (driver != null && this.driverText != null) {
            this.driverText.setText(CommonUtils.toString((Object)driver.getFullName()));
        }
        if (this.licenseButton != null) {
            UIUtils.setControlVisible((Control)this.licenseButton, (driver != null && !CommonUtils.isEmpty((String)driver.getLicense()) ? 1 : 0) != 0);
        }
        DataSourceDescriptor dataSource = (DataSourceDescriptor)this.getSite().getActiveDataSource();
        if (this.savePasswordCheck != null) {
            if (dataSource != null) {
                this.savePasswordCheck.setSelection(dataSource.isSavePassword());
            } else {
                this.savePasswordCheck.setSelection(true);
            }
        }
        if (this.variablesHintLabel != null) {
            if (dataSource != null) {
                this.variablesHintLabel.setResolver((IVariableResolver)new DataSourceVariableResolver((DBPDataSourceContainer)dataSource, dataSource.getConnectionConfiguration()));
            } else {
                this.variablesHintLabel.setResolver(null);
            }
        }
        if (driver != null && this.databaseDocumentationInfoLabel != null) {
            this.databaseDocumentationInfoLabel.setVisible(CommonUtils.isNotEmpty((String)driver.getDatabaseDocumentationSuffixURL()));
        }
        if (this.driverSubstitutionCombo != null) {
            DBPDriverSubstitutionDescriptor driverSubstitution = dataSource.getDriverSubstitution();
            if (driverSubstitution != null) {
                Object[] substitutions = DataSourceProviderRegistry.getInstance().getAllDriverSubstitutions();
                this.driverSubstitutionCombo.select(ArrayUtils.indexOf((Object[])substitutions, (Object)driverSubstitution) + 1);
            } else {
                this.driverSubstitutionCombo.select(0);
            }
        }
        if (this.databaseDocumentationInfoLabel != null) {
            UIUtils.setInfoLinkText((Control)this.databaseDocumentationInfoLabel, (String)(this.site.getDriver().getFullName() + " "));
        }
    }

    public void saveSettings(DBPDataSourceContainer dataSource) {
        this.saveConnectionURL(dataSource.getConnectionConfiguration());
        if (this.savePasswordCheck != null) {
            DataSourceDescriptor descriptor = (DataSourceDescriptor)dataSource;
            descriptor.setSavePassword(this.savePasswordCheck.getSelection());
            if (!descriptor.isSavePassword()) {
                descriptor.resetPassword();
            }
        }
        if (this.driverSubstitutionCombo != null) {
            int substitutionIndex = this.driverSubstitutionCombo.getSelectionIndex();
            if (substitutionIndex > 0) {
                DBPDriverSubstitutionDescriptor[] substitutions = DataSourceProviderRegistry.getInstance().getAllDriverSubstitutions();
                dataSource.setDriverSubstitution(substitutions[substitutionIndex - 1]);
            } else {
                dataSource.setDriverSubstitution(null);
            }
        }
    }

    protected void saveConnectionURL(DBPConnectionConfiguration connectionInfo) {
        if (!this.isCustomURL()) {
            connectionInfo.setUrl(this.site.getDriver().getConnectionURL(connectionInfo));
        }
    }

    protected void createDriverPanel(Composite parent) {
        Composite panel = UIUtils.createComposite((Composite)parent, (int)5);
        GridData gd = new GridData(776);
        gd.horizontalSpan = ((GridLayout)parent.getLayout()).numColumns;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        panel.setLayoutData((Object)gd);
        if (DBWorkbench.getPlatform().getPreferenceStore().getBoolean("database.connect.processEnvVars")) {
            this.variablesHintLabel = new VariablesHintLabel(panel, UIConnectionMessages.dialog_connection_edit_connection_settings_variables_hint_label, UIConnectionMessages.dialog_connection_edit_connection_settings_variables_hint_label, DBPConnectionConfiguration.INTERNAL_CONNECT_VARIABLES, false);
            ((GridData)this.variablesHintLabel.getInfoLabel().getLayoutData()).horizontalSpan = 2;
        } else {
            UIUtils.createFormPlaceholder((Composite)panel, (int)2, (int)1);
        }
        this.formDatabaseDocumentationInfoLabel(panel);
        if (this.site.isNew()) {
            Button advSettingsButton = UIUtils.createDialogButton((Composite)panel, (String)UIConnectionMessages.dialog_connection_edit_wizard_conn_conf_general_link, (SelectionListener)SelectionListener.widgetSelectedAdapter(e -> {
                boolean bl = this.site.openSettingsPage("ConnectionPageGeneral");
            }));
            advSettingsButton.setLayoutData((Object)new GridData(128));
        } else {
            UIUtils.createEmptyLabel((Composite)panel, (int)1, (int)1);
        }
        UIUtils.createLabelSeparator((Composite)panel, (int)256, (int)5);
        Composite driverInfoComp = UIUtils.createComposite((Composite)panel, (int)5);
        gd = new GridData(768);
        gd.horizontalSpan = 5;
        driverInfoComp.setLayoutData((Object)gd);
        Label driverLabel = new Label(driverInfoComp, 0);
        driverLabel.setText(UIConnectionMessages.dialog_connection_driver);
        driverLabel.setLayoutData((Object)new GridData(32));
        this.driverText = new Text(driverInfoComp, 8);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.driverText.setLayoutData((Object)gd);
        if (DBWorkbench.getPlatform().getWorkspace().hasRealmPermission("driver-manager")) {
            Button driverButton = UIUtils.createDialogButton((Composite)driverInfoComp, (String)UIConnectionMessages.dialog_connection_edit_driver_button, (SelectionListener)SelectionListener.widgetSelectedAdapter(e -> {
                if (this.site.openDriverEditor()) {
                    this.updateDriverInfo(this.site.getDriver());
                }
            }));
            driverButton.setLayoutData((Object)new GridData(128));
        } else {
            UIUtils.createEmptyLabel((Composite)driverInfoComp, (int)1, (int)1);
        }
        this.licenseButton = UIUtils.createDialogButton((Composite)driverInfoComp, (String)UIConnectionMessages.dialog_edit_driver_text_driver_license, (SelectionListener)SelectionListener.widgetSelectedAdapter(e -> {
            String driverLicense = this.site.getDriver().getLicense();
            if (CommonUtils.isEmpty((String)driverLicense)) {
                driverLicense = "N/A";
            }
            AcceptLicenseDialog licenseDialog = new AcceptLicenseDialog(this.getShell(), this.site.getDriver().getFullName(), driverLicense);
            licenseDialog.setViewMode(true);
            licenseDialog.open();
        }));
        this.licenseButton.setLayoutData((Object)new GridData(128));
    }

    private void formDatabaseDocumentationInfoLabel(Composite panel) {
        this.databaseDocumentationInfoLabel = UIUtils.createInfoLabel((Composite)panel, (String)(this.site.getDriver().getFullName() + " "), () -> {
            String databaseDocumentationSuffixURL = this.site.getDriver().getDatabaseDocumentationSuffixURL();
            ShellUtils.launchProgram((String)HelpUtils.getHelpExternalReference((String)databaseDocumentationSuffixURL));
        });
        this.databaseDocumentationInfoLabel.setToolTipText(UIConnectionMessages.dialog_connection_database_documentation);
        this.databaseDocumentationInfoLabel.setLayoutData((Object)new GridData(128));
        this.databaseDocumentationInfoLabel.setVisible(CommonUtils.isNotEmpty((String)this.site.getDriver().getDatabaseDocumentationSuffixURL()));
    }

    protected void updateDriverInfo(DBPDriver driver) {
    }

    public void setImageDescriptor(ImageDescriptor desc) {
        if (this.curImageDescriptor != desc) {
            super.setImageDescriptor(desc);
            this.curImageDescriptor = desc;
        }
    }

    protected Text createPasswordText(Composite parent, String label) {
        if (label != null) {
            UIUtils.createControlLabel((Composite)parent, (String)label);
        }
        Composite ph = UIUtils.createPlaceholder((Composite)parent, (int)1);
        ph.setLayoutData((Object)new GridData(768));
        this.passwordText = new Text(ph, 0x400800);
        this.passwordText.setLayoutData((Object)new GridData(768));
        return this.passwordText;
    }

    protected void createPasswordControls(Composite parent) {
        this.createPasswordControls(parent, 1);
    }

    protected void createPasswordControls(Composite parent, int hSpan) {
        UIServiceSecurity serviceSecurity = (UIServiceSecurity)DBWorkbench.getService(UIServiceSecurity.class);
        boolean supportsPasswordView = serviceSecurity != null;
        Composite panel = UIUtils.createComposite((Composite)parent, (int)(supportsPasswordView ? 2 : 1));
        GridData gd = new GridData(32);
        if (hSpan > 1) {
            gd.horizontalSpan = hSpan;
        }
        panel.setLayoutData((Object)gd);
        DataSourceDescriptor dataSource = (DataSourceDescriptor)this.getSite().getActiveDataSource();
        this.savePasswordCheck = UIUtils.createCheckbox((Composite)panel, (String)UIConnectionMessages.dialog_connection_wizard_final_checkbox_save_password, (dataSource == null || dataSource.isSavePassword() ? 1 : 0) != 0);
        this.savePasswordCheck.setToolTipText(UIConnectionMessages.dialog_connection_wizard_final_checkbox_save_password);
        if (supportsPasswordView) {
            this.userManagementToolbar = new ToolBar(panel, 256);
            ToolItem showPasswordLabel = new ToolItem(this.userManagementToolbar, 0);
            showPasswordLabel.setToolTipText("Show password on screen");
            showPasswordLabel.setImage(DBeaverIcons.getImage((DBPImage)UIIcon.SHOW_ALL_DETAILS));
            showPasswordLabel.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.showPasswordText(serviceSecurity)));
        }
    }

    private void showPasswordText(UIServiceSecurity serviceSecurity) {
        boolean passHidden;
        boolean bl = passHidden = (this.passwordText.getStyle() & 0x400000) == 0x400000;
        if (passHidden && !serviceSecurity.validatePassword((DBPProject)this.site.getProject(), "Enter project password", "Enter project password to unlock connection password view", true)) {
            return;
        }
        this.passwordText = UIUtils.recreateTextControl((Text)this.passwordText, (int)(passHidden ? 2048 : 0x400800));
    }

    protected Image createImage(String imageFilePath) {
        ImageDescriptor imageDescriptor = ResourceLocator.imageDescriptorFromBundle(((Object)((Object)this)).getClass(), (String)imageFilePath).orElse(null);
        return imageDescriptor == null ? null : imageDescriptor.createImage();
    }

    protected void createConnectionModeSwitcher(Composite parent, SelectionListener typeSwitcher) {
        Label cnnTypeLabel = UIUtils.createControlLabel((Composite)parent, (String)UIConnectionMessages.dialog_connection_mode_label);
        cnnTypeLabel.setLayoutData((Object)new GridData(32));
        Composite modeGroup = UIUtils.createComposite((Composite)parent, (int)3);
        this.typeManualRadio = UIUtils.createRadioButton((Composite)modeGroup, (String)UIConnectionMessages.dialog_connection_host_label, (Object)false, (SelectionListener)typeSwitcher);
        this.typeURLRadio = UIUtils.createRadioButton((Composite)modeGroup, (String)UIConnectionMessages.dialog_connection_url_label, (Object)true, (SelectionListener)typeSwitcher);
        modeGroup.setLayoutData((Object)GridDataFactory.fillDefaults().span(3, 1).create());
        if (this.supportsDriverSubstitution()) {
            this.createDriverSubstitutionControls(modeGroup);
        }
        this.addControlToGroup(GROUP_CONNECTION_MODE, new Control[]{cnnTypeLabel});
        this.addControlToGroup(GROUP_CONNECTION_MODE, new Control[]{modeGroup});
    }

    protected void createDriverSubstitutionControls(@NotNull Composite parent) {
        DBPDriverSubstitutionDescriptor[] driverSubstitutions = DataSourceProviderRegistry.getInstance().getAllDriverSubstitutions();
        if (driverSubstitutions.length > 0) {
            Composite substitutionGroup = UIUtils.createComposite((Composite)parent, (int)2);
            substitutionGroup.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).align(0x1000008, 1).create());
            this.driverSubstitutionCombo = UIUtils.createLabelCombo((Composite)substitutionGroup, (String)"Driver type", (String)NLS.bind((String)"Replaces the current driver ({0}) with the selected one.\nProvides all functionality of the original driver but driven by the substituting driver.", (Object)this.site.getActiveDataSource().getDriver().getFullName()), (int)12);
            this.driverSubstitutionCombo.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
                int index = this.driverSubstitutionCombo.getSelectionIndex();
                DBPDriverSubstitutionDescriptor driverSubstitution = index > 0 ? driverSubstitutions[index - 1] : null;
                IConnectionWizard wizard = (IConnectionWizard)this.site.getWizard();
                if (wizard != null) {
                    wizard.firePropertyChangeEvent(PROP_DRIVER_SUBSTITUTION, (Object)wizard.getDriverSubstitution(), (Object)driverSubstitution);
                }
            }));
            this.driverSubstitutionCombo.add("JDBC");
            DBPDriverSubstitutionDescriptor[] dBPDriverSubstitutionDescriptorArray = driverSubstitutions;
            int n = driverSubstitutions.length;
            int n2 = 0;
            while (n2 < n) {
                DBPDriverSubstitutionDescriptor descriptor = dBPDriverSubstitutionDescriptorArray[n2];
                this.driverSubstitutionCombo.add(descriptor.getName());
                ++n2;
            }
        }
    }

    protected boolean isHideNonApplicableControls() {
        return false;
    }

    protected void setupConnectionModeSelection(@NotNull Text urlText, boolean useUrl, @NotNull Collection<String> nonUrlPropGroups) {
        this.addControlToGroup(GROUP_URL, new Control[]{urlText});
        this.setupConnectionModeSelection(useUrl, Collections.singleton(GROUP_URL), nonUrlPropGroups);
    }

    protected void setupConnectionModeSelection(boolean useUrl, @NotNull Collection<String> urlPropGroups, @NotNull Collection<String> nonUrlPropGroups) {
        Control shellControl;
        if (this.typeURLRadio != null) {
            this.typeURLRadio.setSelection(useUrl);
        }
        if (this.typeManualRadio != null) {
            this.typeManualRadio.setSelection(!useUrl);
        }
        this.updateConnectionModeControlsVisibility(urlPropGroups, useUrl);
        this.updateConnectionModeControlsVisibility(nonUrlPropGroups, !useUrl);
        if (this.isHideNonApplicableControls() && (shellControl = this.getControl()) instanceof Composite) {
            Composite shc = (Composite)shellControl;
            shc.layout(true, true);
        }
    }

    private void updateConnectionModeControlsVisibility(@NotNull Collection<String> nonUrlPropGroups, boolean enable) {
        for (String groupName : nonUrlPropGroups) {
            Set<Control> controls = this.propGroupMap.get(groupName);
            if (controls == null) continue;
            for (Control control : controls) {
                control.setEnabled(enable);
                if (control instanceof Text) {
                    Text text = (Text)control;
                    text.setEditable(enable);
                }
                if (!this.isHideNonApplicableControls()) continue;
                UIUtils.setControlVisible((Control)control, (boolean)enable);
            }
        }
    }

    protected void addControlToGroup(@NotNull String group, Control ... list) {
        Set controls = this.propGroupMap.computeIfAbsent(group, k -> new HashSet());
        Collections.addAll(controls, list);
    }

    protected void updateUrlFromSettings(Text urlText) {
        DBPDataSourceContainer dataSourceContainer = this.site.getActiveDataSource();
        urlText.setText(dataSourceContainer.getDriver().getConnectionURL(this.site.getActiveDataSource().getConnectionConfiguration()));
    }

    protected boolean supportsDriverSubstitution() {
        return true;
    }
}

