/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search2.internal.ui.text2;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search.ui.text.TextSearchQueryProvider;
import org.eclipse.search2.internal.ui.SearchMessages;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.texteditor.ITextEditor;

public abstract class RetrieverAction
extends Action {
    public void run() {
        IWorkbenchPage page = this.getWorkbenchPage();
        if (page == null) {
            return;
        }
        TextSearchQueryProvider provider = TextSearchQueryProvider.getPreferred();
        String searchForString = this.getSearchForString(page);
        if (searchForString.isEmpty()) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)SearchMessages.RetrieverAction_dialog_title, (String)SearchMessages.RetrieverAction_empty_selection);
            return;
        }
        try {
            ISearchQuery query = this.createQuery(provider, searchForString);
            if (query != null) {
                NewSearchUI.runQueryInBackground(query);
            }
        }
        catch (OperationCanceledException query) {
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)this.getShell(), (String)SearchMessages.RetrieverAction_error_title, (String)SearchMessages.RetrieverAction_error_message, (IStatus)e.getStatus());
        }
    }

    private IWorkbenchPart getActivePart() {
        IWorkbenchPage page = this.getWorkbenchPage();
        if (page != null) {
            return page.getActivePart();
        }
        return null;
    }

    private Shell getShell() {
        IWorkbenchPart part = this.getActivePart();
        if (part != null) {
            return part.getSite().getShell();
        }
        return SearchPlugin.getActiveWorkbenchShell();
    }

    protected abstract IWorkbenchPage getWorkbenchPage();

    protected abstract ISearchQuery createQuery(TextSearchQueryProvider var1, String var2) throws CoreException;

    protected final String extractSearchTextFromEditor(IEditorPart editor) {
        if (editor != null) {
            ISelection s;
            ITextSelection selection = null;
            ISelectionProvider provider = editor.getEditorSite().getSelectionProvider();
            if (provider != null && (s = provider.getSelection()) instanceof ITextSelection) {
                selection = (ITextSelection)s;
            }
            if (selection != null) {
                ITextEditor txtEditor;
                if (selection.getLength() == 0 && (txtEditor = this.getTextEditor(editor)) != null) {
                    IDocument document = txtEditor.getDocumentProvider().getDocument((Object)txtEditor.getEditorInput());
                    selection = this.expandSelection(selection, document, null);
                }
                if (selection.getLength() > 0 && selection.getText() != null) {
                    return this.trimSearchString(selection.getText());
                }
            }
        }
        return null;
    }

    protected final String extractSearchTextFromSelection(ISelection sel) {
        IWorkbenchAdapter wbAdapter;
        Object firstElement;
        if (sel instanceof ITextSelection) {
            String text = ((ITextSelection)sel).getText();
            if (text != null) {
                return this.trimSearchString(text);
            }
        } else if (sel instanceof IStructuredSelection && (firstElement = ((IStructuredSelection)sel).getFirstElement()) instanceof IAdaptable && (wbAdapter = (IWorkbenchAdapter)((IAdaptable)firstElement).getAdapter(IWorkbenchAdapter.class)) != null) {
            return wbAdapter.getLabel(firstElement);
        }
        return null;
    }

    protected final String extractSearchTextFromWidget(Control control) {
        List list;
        Object[] s;
        Point selection;
        Combo combo;
        String sel = null;
        if (control instanceof Combo) {
            combo = (Combo)control;
            sel = combo.getText();
            selection = combo.getSelection();
            sel = sel.substring(selection.x, selection.y);
        }
        if (control instanceof CCombo) {
            combo = (CCombo)control;
            sel = combo.getText();
            selection = combo.getSelection();
            sel = sel.substring(selection.x, selection.y);
        } else if (control instanceof Text) {
            text = (Text)control;
            sel = text.getSelectionText();
        } else if (control instanceof FormText) {
            text = (FormText)control;
            sel = text.getSelectionText();
        } else if (control instanceof StyledText) {
            text = (StyledText)control;
            sel = text.getSelectionText();
        } else if (control instanceof Tree) {
            tree = (Tree)control;
            s = tree.getSelection();
            if (s.length > 0) {
                sel = s[0].getText();
            }
        } else if (control instanceof Table) {
            tree = (Table)control;
            s = tree.getSelection();
            if (s.length > 0) {
                sel = s[0].getText();
            }
        } else if (control instanceof List && (s = (list = (List)control).getSelection()).length > 0) {
            sel = s[0];
        }
        if (sel != null) {
            sel = this.trimSearchString(sel);
        }
        return sel;
    }

    private String trimSearchString(String text) {
        text = text.trim();
        int idx = text.indexOf(10);
        int idx2 = text.indexOf(13);
        if (idx2 >= 0 && idx2 < idx) {
            idx = idx2;
        }
        if (idx >= 0) {
            text = text.substring(0, idx);
        }
        return text;
    }

    private ITextEditor getTextEditor(IEditorPart editor) {
        FormEditor me;
        if (editor instanceof ITextEditor) {
            return (ITextEditor)editor;
        }
        if (editor instanceof FormEditor && (editor = (me = (FormEditor)editor).getActiveEditor()) instanceof ITextEditor) {
            return (ITextEditor)editor;
        }
        return null;
    }

    private ITextSelection expandSelection(ITextSelection sel, IDocument document, String stopChars) {
        int a;
        int offset = sel.getOffset();
        int length = sel.getLength();
        if (length == 0) {
            char chr = '\u0000';
            char chl = '\u0000';
            try {
                chr = document.getChar(offset);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            try {
                chl = document.getChar(offset - 1);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            if (this.isPartOfIdentifier(chr)) {
                length = 1;
            } else if (this.isPartOfIdentifier(chl)) {
                --offset;
                length = 1;
            } else if (stopChars != null && stopChars.indexOf(chr) == -1) {
                length = 1;
            } else if (stopChars != null && stopChars.indexOf(chl) == -1) {
                --offset;
                length = 1;
            } else {
                return sel;
            }
        }
        int z = a = offset + length - 1;
        try {
            char ch = document.getChar(z);
            while (this.isValidChar(stopChars, ch)) {
                ch = document.getChar(++z);
            }
        }
        catch (BadLocationException ch) {
            // empty catch block
        }
        try {
            char ch = document.getChar(a);
            while (this.isValidChar(stopChars, ch)) {
                ch = document.getChar(--a);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        if (a == z) {
            offset = a;
            length = 0;
        } else {
            offset = a + 1;
            length = z - a - 1;
        }
        return new TextSelection(document, offset, length);
    }

    private boolean isValidChar(String stopChars, char ch) {
        return stopChars == null ? this.isPartOfIdentifier(ch) : stopChars.indexOf(ch) == -1;
    }

    private boolean isPartOfIdentifier(char ch) {
        return Character.isLetterOrDigit(ch) || ch == '_';
    }

    protected String getSearchForString(IWorkbenchPage page) {
        String searchFor = this.extractSearchTextFromSelection(page.getSelection());
        if (searchFor == null || searchFor.isEmpty()) {
            Control focus;
            IWorkbenchPart activePart = page.getActivePart();
            if (activePart instanceof IEditorPart) {
                searchFor = this.extractSearchTextFromEditor((IEditorPart)activePart);
            }
            if (searchFor == null && (focus = page.getWorkbenchWindow().getShell().getDisplay().getFocusControl()) != null) {
                searchFor = this.extractSearchTextFromWidget(focus);
            }
        }
        return searchFor == null ? "" : searchFor;
    }
}

