/* VpnMenuItem.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from VpnMenuItem.vala, do not modify */

/*
* SPDX-License-Identifier: LGPL-2.1-or-later
* SPDX-FileCopyrightText: 2017-2023 elementary, Inc. (https://elementary.io)
*/

#include "network.h"
#include <NetworkManager.h>
#include <gio/gio.h>
#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	NETWORK_VPN_MENU_ITEM_0_PROPERTY,
	NETWORK_VPN_MENU_ITEM_REMOTE_CONNECTION_PROPERTY,
	NETWORK_VPN_MENU_ITEM_VPN_CONNECTION_PROPERTY,
	NETWORK_VPN_MENU_ITEM_NUM_PROPERTIES
};
static GParamSpec* network_vpn_menu_item_properties[NETWORK_VPN_MENU_ITEM_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _NetworkVpnMenuItemPrivate {
	NMRemoteConnection* _remote_connection;
	NMActiveConnection* _vpn_connection;
	NetworkSettingsToggle* toggle_button;
	GSimpleAction* toggle_action;
};

static gint NetworkVpnMenuItem_private_offset;
static gpointer network_vpn_menu_item_parent_class = NULL;

static void network_vpn_menu_item_update_state (NetworkVpnMenuItem* self);
static void _network_vpn_menu_item_update_state_nm_vpn_connection_vpn_state_changed (NMVpnConnection* _sender,
                                                                              guint object,
                                                                              guint p0,
                                                                              gpointer self);
static void _network_vpn_menu_item_update_state_nm_active_connection_state_changed (NMActiveConnection* _sender,
                                                                             guint state,
                                                                             guint reason,
                                                                             gpointer self);
static GObject * network_vpn_menu_item_constructor (GType type,
                                             guint n_construct_properties,
                                             GObjectConstructParam * construct_properties);
static void _network_vpn_menu_item___lambda24_ (NetworkVpnMenuItem* self);
static void __network_vpn_menu_item___lambda24__g_simple_action_activate (GSimpleAction* _sender,
                                                                   GVariant* parameter,
                                                                   gpointer self);
static void _network_vpn_menu_item___lambda25_ (NetworkVpnMenuItem* self);
static void __network_vpn_menu_item___lambda25__nm_connection_changed (NMConnection* _sender,
                                                                gpointer self);
static void network_vpn_menu_item_finalize (GObject * obj);
static GType network_vpn_menu_item_get_type_once (void);
static void _vala_network_vpn_menu_item_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void _vala_network_vpn_menu_item_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec);

static inline gpointer
network_vpn_menu_item_get_instance_private (NetworkVpnMenuItem* self)
{
	return G_STRUCT_MEMBER_P (self, NetworkVpnMenuItem_private_offset);
}

NetworkVpnMenuItem*
network_vpn_menu_item_construct (GType object_type,
                                 NMRemoteConnection* remote_connection)
{
	NetworkVpnMenuItem * self = NULL;
	g_return_val_if_fail (remote_connection != NULL, NULL);
	self = (NetworkVpnMenuItem*) g_object_new (object_type, "remote-connection", remote_connection, NULL);
	return self;
}

NetworkVpnMenuItem*
network_vpn_menu_item_new (NMRemoteConnection* remote_connection)
{
	return network_vpn_menu_item_construct (NETWORK_TYPE_VPN_MENU_ITEM, remote_connection);
}

static void
network_vpn_menu_item_update_state (NetworkVpnMenuItem* self)
{
	NMActiveConnection* _tmp0_;
	const gchar* connection_type = NULL;
	NMActiveConnection* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_vpn_connection;
	if (_tmp0_ == NULL) {
		NetworkSettingsToggle* _tmp1_;
		GSimpleAction* _tmp2_;
		GVariant* _tmp3_;
		GVariant* _tmp4_;
		_tmp1_ = self->priv->toggle_button;
		network_settings_toggle_set_icon_name (_tmp1_, "panel-network-vpn-disconnected-symbolic");
		_tmp2_ = self->priv->toggle_action;
		_tmp3_ = g_variant_new_boolean (FALSE);
		g_variant_ref_sink (_tmp3_);
		_tmp4_ = _tmp3_;
		g_simple_action_set_state (_tmp2_, _tmp4_);
		_g_variant_unref0 (_tmp4_);
		return;
	}
	_tmp5_ = self->priv->_vpn_connection;
	_tmp6_ = nm_active_connection_get_connection_type (_tmp5_);
	connection_type = _tmp6_;
	_tmp7_ = connection_type;
	if (g_strcmp0 (_tmp7_, NM_SETTING_VPN_SETTING_NAME) == 0) {
		NMActiveConnection* _tmp8_;
		NMVpnConnectionState _tmp9_;
		NMVpnConnectionState _tmp10_;
		_tmp8_ = self->priv->_vpn_connection;
		_tmp9_ = nm_vpn_connection_get_vpn_state (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, nm_vpn_connection_get_type (), NMVpnConnection));
		_tmp10_ = _tmp9_;
		switch (_tmp10_) {
			case NM_VPN_CONNECTION_STATE_CONNECT:
			case NM_VPN_CONNECTION_STATE_IP_CONFIG_GET:
			case NM_VPN_CONNECTION_STATE_NEED_AUTH:
			case NM_VPN_CONNECTION_STATE_PREPARE:
			{
				NetworkSettingsToggle* _tmp11_;
				GSimpleAction* _tmp12_;
				GVariant* _tmp13_;
				GVariant* _tmp14_;
				_tmp11_ = self->priv->toggle_button;
				network_settings_toggle_set_icon_name (_tmp11_, "panel-network-vpn-acquiring-symbolic");
				_tmp12_ = self->priv->toggle_action;
				_tmp13_ = g_variant_new_boolean (TRUE);
				g_variant_ref_sink (_tmp13_);
				_tmp14_ = _tmp13_;
				g_simple_action_set_state (_tmp12_, _tmp14_);
				_g_variant_unref0 (_tmp14_);
				break;
			}
			case NM_VPN_CONNECTION_STATE_ACTIVATED:
			{
				NetworkSettingsToggle* _tmp15_;
				GSimpleAction* _tmp16_;
				GVariant* _tmp17_;
				GVariant* _tmp18_;
				_tmp15_ = self->priv->toggle_button;
				network_settings_toggle_set_icon_name (_tmp15_, "panel-network-vpn-connected-symbolic");
				_tmp16_ = self->priv->toggle_action;
				_tmp17_ = g_variant_new_boolean (TRUE);
				g_variant_ref_sink (_tmp17_);
				_tmp18_ = _tmp17_;
				g_simple_action_set_state (_tmp16_, _tmp18_);
				_g_variant_unref0 (_tmp18_);
				break;
			}
			case NM_VPN_CONNECTION_STATE_DISCONNECTED:
			{
				NetworkSettingsToggle* _tmp19_;
				GSimpleAction* _tmp20_;
				GVariant* _tmp21_;
				GVariant* _tmp22_;
				_tmp19_ = self->priv->toggle_button;
				network_settings_toggle_set_icon_name (_tmp19_, "panel-network-vpn-disconnected-symbolic");
				_tmp20_ = self->priv->toggle_action;
				_tmp21_ = g_variant_new_boolean (FALSE);
				g_variant_ref_sink (_tmp21_);
				_tmp22_ = _tmp21_;
				g_simple_action_set_state (_tmp20_, _tmp22_);
				_g_variant_unref0 (_tmp22_);
				break;
			}
			case NM_VPN_CONNECTION_STATE_FAILED:
			case NM_VPN_CONNECTION_STATE_UNKNOWN:
			{
				NetworkSettingsToggle* _tmp23_;
				GSimpleAction* _tmp24_;
				GVariant* _tmp25_;
				GVariant* _tmp26_;
				_tmp23_ = self->priv->toggle_button;
				network_settings_toggle_set_icon_name (_tmp23_, "panel-network-vpn-error-symbolic");
				_tmp24_ = self->priv->toggle_action;
				_tmp25_ = g_variant_new_boolean (FALSE);
				g_variant_ref_sink (_tmp25_);
				_tmp26_ = _tmp25_;
				g_simple_action_set_state (_tmp24_, _tmp26_);
				_g_variant_unref0 (_tmp26_);
				break;
			}
			default:
			break;
		}
	} else {
		const gchar* _tmp27_;
		_tmp27_ = connection_type;
		if (g_strcmp0 (_tmp27_, NM_SETTING_WIREGUARD_SETTING_NAME) == 0) {
			NMActiveConnection* _tmp28_;
			_tmp28_ = self->priv->_vpn_connection;
			switch (nm_active_connection_get_state (_tmp28_)) {
				case NM_ACTIVE_CONNECTION_STATE_UNKNOWN:
				{
					NetworkSettingsToggle* _tmp29_;
					GSimpleAction* _tmp30_;
					GVariant* _tmp31_;
					GVariant* _tmp32_;
					_tmp29_ = self->priv->toggle_button;
					network_settings_toggle_set_icon_name (_tmp29_, "panel-network-vpn-error-symbolic");
					_tmp30_ = self->priv->toggle_action;
					_tmp31_ = g_variant_new_boolean (FALSE);
					g_variant_ref_sink (_tmp31_);
					_tmp32_ = _tmp31_;
					g_simple_action_set_state (_tmp30_, _tmp32_);
					_g_variant_unref0 (_tmp32_);
					break;
				}
				case NM_ACTIVE_CONNECTION_STATE_DEACTIVATED:
				case NM_ACTIVE_CONNECTION_STATE_DEACTIVATING:
				{
					NetworkSettingsToggle* _tmp33_;
					GSimpleAction* _tmp34_;
					GVariant* _tmp35_;
					GVariant* _tmp36_;
					_tmp33_ = self->priv->toggle_button;
					network_settings_toggle_set_icon_name (_tmp33_, "panel-network-vpn-disconnected-symbolic");
					_tmp34_ = self->priv->toggle_action;
					_tmp35_ = g_variant_new_boolean (FALSE);
					g_variant_ref_sink (_tmp35_);
					_tmp36_ = _tmp35_;
					g_simple_action_set_state (_tmp34_, _tmp36_);
					_g_variant_unref0 (_tmp36_);
					break;
				}
				case NM_ACTIVE_CONNECTION_STATE_ACTIVATING:
				{
					NetworkSettingsToggle* _tmp37_;
					GSimpleAction* _tmp38_;
					GVariant* _tmp39_;
					GVariant* _tmp40_;
					_tmp37_ = self->priv->toggle_button;
					network_settings_toggle_set_icon_name (_tmp37_, "panel-network-vpn-acquiring-symbolic");
					_tmp38_ = self->priv->toggle_action;
					_tmp39_ = g_variant_new_boolean (TRUE);
					g_variant_ref_sink (_tmp39_);
					_tmp40_ = _tmp39_;
					g_simple_action_set_state (_tmp38_, _tmp40_);
					_g_variant_unref0 (_tmp40_);
					break;
				}
				case NM_ACTIVE_CONNECTION_STATE_ACTIVATED:
				{
					NetworkSettingsToggle* _tmp41_;
					GSimpleAction* _tmp42_;
					GVariant* _tmp43_;
					GVariant* _tmp44_;
					_tmp41_ = self->priv->toggle_button;
					network_settings_toggle_set_icon_name (_tmp41_, "panel-network-vpn-connected-symbolic");
					_tmp42_ = self->priv->toggle_action;
					_tmp43_ = g_variant_new_boolean (TRUE);
					g_variant_ref_sink (_tmp43_);
					_tmp44_ = _tmp43_;
					g_simple_action_set_state (_tmp42_, _tmp44_);
					_g_variant_unref0 (_tmp44_);
					break;
				}
				default:
				break;
			}
		}
	}
}

NMRemoteConnection*
network_vpn_menu_item_get_remote_connection (NetworkVpnMenuItem* self)
{
	NMRemoteConnection* result;
	NMRemoteConnection* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_remote_connection;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
network_vpn_menu_item_set_remote_connection (NetworkVpnMenuItem* self,
                                             NMRemoteConnection* value)
{
	NMRemoteConnection* old_value;
	g_return_if_fail (self != NULL);
	old_value = network_vpn_menu_item_get_remote_connection (self);
	if (old_value != value) {
		NMRemoteConnection* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_remote_connection);
		self->priv->_remote_connection = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, network_vpn_menu_item_properties[NETWORK_VPN_MENU_ITEM_REMOTE_CONNECTION_PROPERTY]);
	}
}

NMActiveConnection*
network_vpn_menu_item_get_vpn_connection (NetworkVpnMenuItem* self)
{
	NMActiveConnection* result;
	NMActiveConnection* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_vpn_connection;
	result = _tmp0_;
	return result;
}

static void
_network_vpn_menu_item_update_state_nm_vpn_connection_vpn_state_changed (NMVpnConnection* _sender,
                                                                         guint object,
                                                                         guint p0,
                                                                         gpointer self)
{
	network_vpn_menu_item_update_state ((NetworkVpnMenuItem*) self);
}

static void
_network_vpn_menu_item_update_state_nm_active_connection_state_changed (NMActiveConnection* _sender,
                                                                        guint state,
                                                                        guint reason,
                                                                        gpointer self)
{
	network_vpn_menu_item_update_state ((NetworkVpnMenuItem*) self);
}

void
network_vpn_menu_item_set_vpn_connection (NetworkVpnMenuItem* self,
                                          NMActiveConnection* value)
{
	NMActiveConnection* _tmp3_;
	NetworkSettingsToggle* _tmp9_;
	GSimpleAction* _tmp10_;
	GVariant* _tmp11_;
	GVariant* _tmp12_;
	g_return_if_fail (self != NULL);
	if (value != NULL) {
		NMActiveConnection* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_vpn_connection);
		self->priv->_vpn_connection = _tmp0_;
		if (nm_active_connection_get_vpn (value)) {
			NMActiveConnection* _tmp1_;
			_tmp1_ = self->priv->_vpn_connection;
			g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, nm_vpn_connection_get_type (), NMVpnConnection), "vpn-state-changed", (GCallback) _network_vpn_menu_item_update_state_nm_vpn_connection_vpn_state_changed, self, 0);
		} else {
			NMActiveConnection* _tmp2_;
			_tmp2_ = self->priv->_vpn_connection;
			g_signal_connect_object (_tmp2_, "state-changed", (GCallback) _network_vpn_menu_item_update_state_nm_active_connection_state_changed, self, 0);
		}
		network_vpn_menu_item_update_state (self);
		return;
	}
	_tmp3_ = self->priv->_vpn_connection;
	if (_tmp3_ != NULL) {
		NMActiveConnection* _tmp4_;
		_tmp4_ = self->priv->_vpn_connection;
		if (nm_active_connection_get_vpn (_tmp4_)) {
			NMActiveConnection* _tmp5_;
			guint _tmp6_;
			_tmp5_ = self->priv->_vpn_connection;
			g_signal_parse_name ("vpn-state-changed", nm_vpn_connection_get_type (), &_tmp6_, NULL, FALSE);
			g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, nm_vpn_connection_get_type (), NMVpnConnection), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp6_, 0, NULL, (GCallback) _network_vpn_menu_item_update_state_nm_vpn_connection_vpn_state_changed, self);
		} else {
			NMActiveConnection* _tmp7_;
			guint _tmp8_;
			_tmp7_ = self->priv->_vpn_connection;
			g_signal_parse_name ("state-changed", nm_active_connection_get_type (), &_tmp8_, NULL, FALSE);
			g_signal_handlers_disconnect_matched (_tmp7_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp8_, 0, NULL, (GCallback) _network_vpn_menu_item_update_state_nm_active_connection_state_changed, self);
		}
		_g_object_unref0 (self->priv->_vpn_connection);
		self->priv->_vpn_connection = NULL;
	}
	_tmp9_ = self->priv->toggle_button;
	network_settings_toggle_set_icon_name (_tmp9_, "panel-network-vpn-disconnected-symbolic");
	_tmp10_ = self->priv->toggle_action;
	_tmp11_ = g_variant_new_boolean (FALSE);
	g_variant_ref_sink (_tmp11_);
	_tmp12_ = _tmp11_;
	g_simple_action_set_state (_tmp10_, _tmp12_);
	_g_variant_unref0 (_tmp12_);
	g_object_notify_by_pspec ((GObject *) self, network_vpn_menu_item_properties[NETWORK_VPN_MENU_ITEM_VPN_CONNECTION_PROPERTY]);
}

static void
_network_vpn_menu_item___lambda24_ (NetworkVpnMenuItem* self)
{
	g_signal_emit_by_name ((GtkFlowBoxChild*) self, "activate");
}

static void
__network_vpn_menu_item___lambda24__g_simple_action_activate (GSimpleAction* _sender,
                                                              GVariant* parameter,
                                                              gpointer self)
{
	_network_vpn_menu_item___lambda24_ ((NetworkVpnMenuItem*) self);
}

static void
_network_vpn_menu_item___lambda25_ (NetworkVpnMenuItem* self)
{
	NetworkSettingsToggle* _tmp0_;
	NMRemoteConnection* _tmp1_;
	const gchar* _tmp2_;
	_tmp0_ = self->priv->toggle_button;
	_tmp1_ = self->priv->_remote_connection;
	_tmp2_ = nm_connection_get_id ((NMConnection*) _tmp1_);
	network_settings_toggle_set_text (_tmp0_, _tmp2_);
}

static void
__network_vpn_menu_item___lambda25__nm_connection_changed (NMConnection* _sender,
                                                           gpointer self)
{
	_network_vpn_menu_item___lambda25_ ((NetworkVpnMenuItem*) self);
}

static GObject *
network_vpn_menu_item_constructor (GType type,
                                   guint n_construct_properties,
                                   GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	NetworkVpnMenuItem * self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	NMRemoteConnection* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	NetworkSettingsToggle* _tmp6_ = NULL;
	NetworkSettingsToggle* _tmp7_;
	GVariant* _tmp8_;
	GVariant* _tmp9_;
	GSimpleAction* _tmp10_;
	GSimpleAction* _tmp11_;
	GSimpleActionGroup* action_group = NULL;
	GSimpleActionGroup* _tmp12_;
	GSimpleActionGroup* _tmp13_;
	GSimpleAction* _tmp14_;
	GSimpleActionGroup* _tmp15_;
	NMRemoteConnection* _tmp16_;
	parent_class = G_OBJECT_CLASS (network_vpn_menu_item_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETWORK_TYPE_VPN_MENU_ITEM, NetworkVpnMenuItem);
	_tmp0_ = g_strdup ("vpn.toggle");
	_tmp1_ = g_strdup ("panel-network-vpn-disconnected-symbolic");
	_tmp2_ = g_strdup ("settings://network/vpn");
	_tmp3_ = self->priv->_remote_connection;
	_tmp4_ = nm_connection_get_id ((NMConnection*) _tmp3_);
	_tmp5_ = g_strdup (_tmp4_);
	_tmp6_ = network_settings_toggle_new ();
	network_settings_toggle_set_action_name (_tmp6_, _tmp0_);
	_g_free0 (_tmp0_);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp6_, TRUE);
	network_settings_toggle_set_icon_name (_tmp6_, _tmp1_);
	_g_free0 (_tmp1_);
	network_settings_toggle_set_settings_uri (_tmp6_, _tmp2_);
	_g_free0 (_tmp2_);
	network_settings_toggle_set_text (_tmp6_, _tmp5_);
	_g_free0 (_tmp5_);
	g_object_ref_sink (_tmp6_);
	_g_object_unref0 (self->priv->toggle_button);
	self->priv->toggle_button = _tmp6_;
	gtk_widget_set_can_focus ((GtkWidget*) self, FALSE);
	_tmp7_ = self->priv->toggle_button;
	g_object_set ((GtkContainer*) self, "child", (GtkWidget*) _tmp7_, NULL);
	_tmp8_ = g_variant_new_boolean (FALSE);
	g_variant_ref_sink (_tmp8_);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_simple_action_new_stateful ("toggle", NULL, _tmp9_);
	_g_object_unref0 (self->priv->toggle_action);
	self->priv->toggle_action = _tmp10_;
	_g_variant_unref0 (_tmp9_);
	_tmp11_ = self->priv->toggle_action;
	g_signal_connect_object (_tmp11_, "activate", (GCallback) __network_vpn_menu_item___lambda24__g_simple_action_activate, self, 0);
	_tmp12_ = g_simple_action_group_new ();
	action_group = _tmp12_;
	_tmp13_ = action_group;
	_tmp14_ = self->priv->toggle_action;
	g_action_map_add_action ((GActionMap*) _tmp13_, (GAction*) _tmp14_);
	_tmp15_ = action_group;
	gtk_widget_insert_action_group ((GtkWidget*) self, "vpn", (GActionGroup*) _tmp15_);
	_tmp16_ = self->priv->_remote_connection;
	g_signal_connect_object ((NMConnection*) _tmp16_, "changed", (GCallback) __network_vpn_menu_item___lambda25__nm_connection_changed, self, 0);
	_g_object_unref0 (action_group);
	return obj;
}

static void
network_vpn_menu_item_class_init (NetworkVpnMenuItemClass * klass,
                                  gpointer klass_data)
{
	network_vpn_menu_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &NetworkVpnMenuItem_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_network_vpn_menu_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_network_vpn_menu_item_set_property;
	G_OBJECT_CLASS (klass)->constructor = network_vpn_menu_item_constructor;
	G_OBJECT_CLASS (klass)->finalize = network_vpn_menu_item_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETWORK_VPN_MENU_ITEM_REMOTE_CONNECTION_PROPERTY, network_vpn_menu_item_properties[NETWORK_VPN_MENU_ITEM_REMOTE_CONNECTION_PROPERTY] = g_param_spec_object ("remote-connection", "remote-connection", "remote-connection", nm_remote_connection_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETWORK_VPN_MENU_ITEM_VPN_CONNECTION_PROPERTY, network_vpn_menu_item_properties[NETWORK_VPN_MENU_ITEM_VPN_CONNECTION_PROPERTY] = g_param_spec_object ("vpn-connection", "vpn-connection", "vpn-connection", nm_active_connection_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
network_vpn_menu_item_instance_init (NetworkVpnMenuItem * self,
                                     gpointer klass)
{
	self->priv = network_vpn_menu_item_get_instance_private (self);
	self->cancellable = NULL;
	self->priv->_vpn_connection = NULL;
}

static void
network_vpn_menu_item_finalize (GObject * obj)
{
	NetworkVpnMenuItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETWORK_TYPE_VPN_MENU_ITEM, NetworkVpnMenuItem);
	_g_object_unref0 (self->priv->_remote_connection);
	_g_object_unref0 (self->cancellable);
	_g_object_unref0 (self->priv->_vpn_connection);
	_g_object_unref0 (self->priv->toggle_button);
	_g_object_unref0 (self->priv->toggle_action);
	G_OBJECT_CLASS (network_vpn_menu_item_parent_class)->finalize (obj);
}

static GType
network_vpn_menu_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (NetworkVpnMenuItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) network_vpn_menu_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetworkVpnMenuItem), 0, (GInstanceInitFunc) network_vpn_menu_item_instance_init, NULL };
	GType network_vpn_menu_item_type_id;
	network_vpn_menu_item_type_id = g_type_register_static (gtk_flow_box_child_get_type (), "NetworkVpnMenuItem", &g_define_type_info, 0);
	NetworkVpnMenuItem_private_offset = g_type_add_instance_private (network_vpn_menu_item_type_id, sizeof (NetworkVpnMenuItemPrivate));
	return network_vpn_menu_item_type_id;
}

GType
network_vpn_menu_item_get_type (void)
{
	static volatile gsize network_vpn_menu_item_type_id__once = 0;
	if (g_once_init_enter (&network_vpn_menu_item_type_id__once)) {
		GType network_vpn_menu_item_type_id;
		network_vpn_menu_item_type_id = network_vpn_menu_item_get_type_once ();
		g_once_init_leave (&network_vpn_menu_item_type_id__once, network_vpn_menu_item_type_id);
	}
	return network_vpn_menu_item_type_id__once;
}

static void
_vala_network_vpn_menu_item_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	NetworkVpnMenuItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NETWORK_TYPE_VPN_MENU_ITEM, NetworkVpnMenuItem);
	switch (property_id) {
		case NETWORK_VPN_MENU_ITEM_REMOTE_CONNECTION_PROPERTY:
		g_value_set_object (value, network_vpn_menu_item_get_remote_connection (self));
		break;
		case NETWORK_VPN_MENU_ITEM_VPN_CONNECTION_PROPERTY:
		g_value_set_object (value, network_vpn_menu_item_get_vpn_connection (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_network_vpn_menu_item_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec)
{
	NetworkVpnMenuItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NETWORK_TYPE_VPN_MENU_ITEM, NetworkVpnMenuItem);
	switch (property_id) {
		case NETWORK_VPN_MENU_ITEM_REMOTE_CONNECTION_PROPERTY:
		network_vpn_menu_item_set_remote_connection (self, g_value_get_object (value));
		break;
		case NETWORK_VPN_MENU_ITEM_VPN_CONNECTION_PROPERTY:
		network_vpn_menu_item_set_vpn_connection (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

