/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSSVGLength.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsSVGLengthPrototypeFunction_newValueSpecifiedUnits);
static JSC_DECLARE_HOST_FUNCTION(jsSVGLengthPrototypeFunction_convertToSpecifiedUnits);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsSVGLengthConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGLength_unitType);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGLength_value);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGLength_value);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGLength_valueInSpecifiedUnits);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGLength_valueInSpecifiedUnits);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGLength_valueAsString);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGLength_valueAsString);

class JSSVGLengthPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSSVGLengthPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSSVGLengthPrototype* ptr = new (NotNull, JSC::allocateCell<JSSVGLengthPrototype>(vm)) JSSVGLengthPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSVGLengthPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSSVGLengthPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSVGLengthPrototype, JSSVGLengthPrototype::Base);

using JSSVGLengthDOMConstructor = JSDOMConstructorNotConstructable<JSSVGLength>;

/* Hash table for constructor */

static const std::array<HashTableValue, 11> JSSVGLengthConstructorTableValues {
    HashTableValue { "SVG_LENGTHTYPE_UNKNOWN"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0 } },
    HashTableValue { "SVG_LENGTHTYPE_NUMBER"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 1 } },
    HashTableValue { "SVG_LENGTHTYPE_PERCENTAGE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 2 } },
    HashTableValue { "SVG_LENGTHTYPE_EMS"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 3 } },
    HashTableValue { "SVG_LENGTHTYPE_EXS"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 4 } },
    HashTableValue { "SVG_LENGTHTYPE_PX"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 5 } },
    HashTableValue { "SVG_LENGTHTYPE_CM"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 6 } },
    HashTableValue { "SVG_LENGTHTYPE_MM"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 7 } },
    HashTableValue { "SVG_LENGTHTYPE_IN"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 8 } },
    HashTableValue { "SVG_LENGTHTYPE_PT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 9 } },
    HashTableValue { "SVG_LENGTHTYPE_PC"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 10 } },
};

static_assert(SVGLength::SVG_LENGTHTYPE_UNKNOWN == 0, "SVG_LENGTHTYPE_UNKNOWN in SVGLength does not match value from IDL");
static_assert(SVGLength::SVG_LENGTHTYPE_NUMBER == 1, "SVG_LENGTHTYPE_NUMBER in SVGLength does not match value from IDL");
static_assert(SVGLength::SVG_LENGTHTYPE_PERCENTAGE == 2, "SVG_LENGTHTYPE_PERCENTAGE in SVGLength does not match value from IDL");
static_assert(SVGLength::SVG_LENGTHTYPE_EMS == 3, "SVG_LENGTHTYPE_EMS in SVGLength does not match value from IDL");
static_assert(SVGLength::SVG_LENGTHTYPE_EXS == 4, "SVG_LENGTHTYPE_EXS in SVGLength does not match value from IDL");
static_assert(SVGLength::SVG_LENGTHTYPE_PX == 5, "SVG_LENGTHTYPE_PX in SVGLength does not match value from IDL");
static_assert(SVGLength::SVG_LENGTHTYPE_CM == 6, "SVG_LENGTHTYPE_CM in SVGLength does not match value from IDL");
static_assert(SVGLength::SVG_LENGTHTYPE_MM == 7, "SVG_LENGTHTYPE_MM in SVGLength does not match value from IDL");
static_assert(SVGLength::SVG_LENGTHTYPE_IN == 8, "SVG_LENGTHTYPE_IN in SVGLength does not match value from IDL");
static_assert(SVGLength::SVG_LENGTHTYPE_PT == 9, "SVG_LENGTHTYPE_PT in SVGLength does not match value from IDL");
static_assert(SVGLength::SVG_LENGTHTYPE_PC == 10, "SVG_LENGTHTYPE_PC in SVGLength does not match value from IDL");

template<> const ClassInfo JSSVGLengthDOMConstructor::s_info = { "SVGLength"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGLengthDOMConstructor) };

template<> JSValue JSSVGLengthDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSSVGLengthDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "SVGLength"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSSVGLength::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
    reifyStaticProperties(vm, JSSVGLength::info(), JSSVGLengthConstructorTableValues, *this);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 18> JSSVGLengthPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGLengthConstructor, 0 } },
    HashTableValue { "unitType"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGLength_unitType, 0 } },
    HashTableValue { "value"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGLength_value, setJSSVGLength_value } },
    HashTableValue { "valueInSpecifiedUnits"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGLength_valueInSpecifiedUnits, setJSSVGLength_valueInSpecifiedUnits } },
    HashTableValue { "valueAsString"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGLength_valueAsString, setJSSVGLength_valueAsString } },
    HashTableValue { "newValueSpecifiedUnits"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSVGLengthPrototypeFunction_newValueSpecifiedUnits, 2 } },
    HashTableValue { "convertToSpecifiedUnits"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSVGLengthPrototypeFunction_convertToSpecifiedUnits, 1 } },
    HashTableValue { "SVG_LENGTHTYPE_UNKNOWN"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0 } },
    HashTableValue { "SVG_LENGTHTYPE_NUMBER"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 1 } },
    HashTableValue { "SVG_LENGTHTYPE_PERCENTAGE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 2 } },
    HashTableValue { "SVG_LENGTHTYPE_EMS"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 3 } },
    HashTableValue { "SVG_LENGTHTYPE_EXS"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 4 } },
    HashTableValue { "SVG_LENGTHTYPE_PX"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 5 } },
    HashTableValue { "SVG_LENGTHTYPE_CM"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 6 } },
    HashTableValue { "SVG_LENGTHTYPE_MM"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 7 } },
    HashTableValue { "SVG_LENGTHTYPE_IN"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 8 } },
    HashTableValue { "SVG_LENGTHTYPE_PT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 9 } },
    HashTableValue { "SVG_LENGTHTYPE_PC"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 10 } },
};

const ClassInfo JSSVGLengthPrototype::s_info = { "SVGLength"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGLengthPrototype) };

void JSSVGLengthPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSSVGLength::info(), JSSVGLengthPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSSVGLength::s_info = { "SVGLength"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGLength) };

JSSVGLength::JSSVGLength(Structure* structure, JSDOMGlobalObject& globalObject, Ref<SVGLength>&& impl)
    : JSDOMWrapper<SVGLength>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, SVGLength>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSSVGLength::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSSVGLengthPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSSVGLengthPrototype::create(vm, &globalObject, structure);
}

JSObject* JSSVGLength::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSSVGLength>(vm, globalObject);
}

JSValue JSSVGLength::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGLengthDOMConstructor, DOMConstructorID::SVGLength>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSSVGLength::destroy(JSC::JSCell* cell)
{
    JSSVGLength* thisObject = static_cast<JSSVGLength*>(cell);
    thisObject->JSSVGLength::~JSSVGLength();
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGLengthConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSSVGLengthPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSSVGLength::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsSVGLength_unitTypeGetter(JSGlobalObject& lexicalGlobalObject, JSSVGLength& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedShort>(lexicalGlobalObject, throwScope, impl.unitType())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGLength_unitType, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGLength>::get<jsSVGLength_unitTypeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSVGLength_valueGetter(JSGlobalObject& lexicalGlobalObject, JSSVGLength& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLFloat>(lexicalGlobalObject, throwScope, impl.valueForBindings())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGLength_value, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGLength>::get<jsSVGLength_valueGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGLength_valueSetter(JSGlobalObject& lexicalGlobalObject, JSSVGLength& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLFloat>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setValueForBindings(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGLength_value, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGLength>::set<setJSSVGLength_valueSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGLength_valueInSpecifiedUnitsGetter(JSGlobalObject& lexicalGlobalObject, JSSVGLength& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLFloat>(lexicalGlobalObject, throwScope, impl.valueInSpecifiedUnits())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGLength_valueInSpecifiedUnits, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGLength>::get<jsSVGLength_valueInSpecifiedUnitsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGLength_valueInSpecifiedUnitsSetter(JSGlobalObject& lexicalGlobalObject, JSSVGLength& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLFloat>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setValueInSpecifiedUnits(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGLength_valueInSpecifiedUnits, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGLength>::set<setJSSVGLength_valueInSpecifiedUnitsSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGLength_valueAsStringGetter(JSGlobalObject& lexicalGlobalObject, JSSVGLength& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.valueAsString())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGLength_valueAsString, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGLength>::get<jsSVGLength_valueAsStringGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGLength_valueAsStringSetter(JSGlobalObject& lexicalGlobalObject, JSSVGLength& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLDOMString>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setValueAsString(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGLength_valueAsString, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGLength>::set<setJSSVGLength_valueAsStringSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSC::EncodedJSValue jsSVGLengthPrototypeFunction_newValueSpecifiedUnitsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSVGLength>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 2) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto unitTypeConversionResult = convert<IDLUnsignedShort>(*lexicalGlobalObject, argument0.value());
    if (unitTypeConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto valueInSpecifiedUnitsConversionResult = convert<IDLFloat>(*lexicalGlobalObject, argument1.value());
    if (valueInSpecifiedUnitsConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.newValueSpecifiedUnits(unitTypeConversionResult.releaseReturnValue(), valueInSpecifiedUnitsConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsSVGLengthPrototypeFunction_newValueSpecifiedUnits, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSVGLength>::call<jsSVGLengthPrototypeFunction_newValueSpecifiedUnitsBody>(*lexicalGlobalObject, *callFrame, "newValueSpecifiedUnits");
}

static inline JSC::EncodedJSValue jsSVGLengthPrototypeFunction_convertToSpecifiedUnitsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSVGLength>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto unitTypeConversionResult = convert<IDLUnsignedShort>(*lexicalGlobalObject, argument0.value());
    if (unitTypeConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.convertToSpecifiedUnits(unitTypeConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsSVGLengthPrototypeFunction_convertToSpecifiedUnits, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSVGLength>::call<jsSVGLengthPrototypeFunction_convertToSpecifiedUnitsBody>(*lexicalGlobalObject, *callFrame, "convertToSpecifiedUnits");
}

JSC::GCClient::IsoSubspace* JSSVGLength::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSSVGLength, UseCustomHeapCellType::No>(vm, "JSSVGLength"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForSVGLength.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForSVGLength = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForSVGLength.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForSVGLength = std::forward<decltype(space)>(space); }
    );
}

void JSSVGLength::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSSVGLength*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSSVGLengthOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSSVGLengthOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsSVGLength = static_cast<JSSVGLength*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsSVGLength->protectedWrapped().ptr(), jsSVGLength);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7SVGLength@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore9SVGLengthE[]; }
#endif
template<std::same_as<SVGLength> T>
static inline void verifyVTable(SVGLength* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7SVGLength@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore9SVGLengthE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // SVGLength has subclasses. If SVGLength has subclasses that get passed
        // to toJS() we currently require SVGLength you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<SVGLength>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<SVGLength>(impl.ptr());
#endif
    return createWrapper<SVGLength>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, SVGLength& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

SVGLength* JSSVGLength::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSSVGLength*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
