/* Drivers.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Drivers.vala, do not modify */

/*
 * Copyright 2024 elementary, Inc. (https://elementary.io)
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 * Authored by: Leonhard Kargl <leo.kargl@proton.me>
 */

#include "system.h"
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	DRIVERS_STATE_CHANGED_SIGNAL,
	DRIVERS_NUM_SIGNALS
};
static guint drivers_signals[DRIVERS_NUM_SIGNALS] = {0};
typedef GDBusProxy DriversProxy;
typedef GDBusProxyClass DriversProxyClass;
typedef struct _DriversGetCurrentStateReadyData DriversGetCurrentStateReadyData;
typedef struct _DriversGetAvailableDriversReadyData DriversGetAvailableDriversReadyData;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _DriversCancelReadyData DriversCancelReadyData;
typedef struct _DriversCheckForDriversReadyData DriversCheckForDriversReadyData;
typedef struct _DriversInstallReadyData DriversInstallReadyData;

struct _DriversGetCurrentStateReadyData {
	GDBusMethodInvocation* _invocation_;
};

struct _DriversGetAvailableDriversReadyData {
	GDBusMethodInvocation* _invocation_;
};

struct _DriversCancelReadyData {
	GDBusMethodInvocation* _invocation_;
};

struct _DriversCheckForDriversReadyData {
	GDBusMethodInvocation* _invocation_;
	gboolean notify;
};

struct _DriversInstallReadyData {
	GDBusMethodInvocation* _invocation_;
	gchar* name;
};

static GType drivers_get_type_once (void);
static void drivers_proxy_g_signal (GDBusProxy* proxy,
                             const gchar* sender_name,
                             const gchar* signal_name,
                             GVariant* parameters);
static void _dbus_handle_drivers_state_changed (Drivers* self,
                                         GVariant* parameters);
static void _vala_g_async_ready_callback (GObject *source_object,
                                   GAsyncResult *res,
                                   void *user_data);
static void drivers_proxy_get_current_state_async (Drivers* self,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_);
static void drivers_proxy_get_current_state_finish (Drivers* self,
                                             GAsyncResult* _res_,
                                             DriversCurrentState* result,
                                             GError** error);
static void drivers_proxy_get_available_drivers_async (Drivers* self,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_);
static GHashTable* drivers_proxy_get_available_drivers_finish (Drivers* self,
                                                        GAsyncResult* _res_,
                                                        GError** error);
static void drivers_proxy_cancel_async (Drivers* self,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_);
static void drivers_proxy_cancel_finish (Drivers* self,
                                  GAsyncResult* _res_,
                                  GError** error);
static void drivers_proxy_check_for_drivers_async (Drivers* self,
                                            gboolean notify,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_);
static void drivers_proxy_check_for_drivers_finish (Drivers* self,
                                             GAsyncResult* _res_,
                                             GError** error);
static void drivers_proxy_install_async (Drivers* self,
                                  const gchar* name,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_);
static void drivers_proxy_install_finish (Drivers* self,
                                   GAsyncResult* _res_,
                                   GError** error);
static void drivers_proxy_drivers_interface_init (DriversIface* iface);
static void _dbus_drivers_get_current_state (Drivers* self,
                                      GVariant* _parameters_,
                                      GDBusMethodInvocation* invocation);
static void _dbus_drivers_get_current_state_ready (GObject * source_object,
                                            GAsyncResult * _res_,
                                            gpointer _user_data_);
static void _dbus_drivers_get_available_drivers (Drivers* self,
                                          GVariant* _parameters_,
                                          GDBusMethodInvocation* invocation);
static void _dbus_drivers_get_available_drivers_ready (GObject * source_object,
                                                GAsyncResult * _res_,
                                                gpointer _user_data_);
static void _dbus_drivers_cancel (Drivers* self,
                           GVariant* _parameters_,
                           GDBusMethodInvocation* invocation);
static void _dbus_drivers_cancel_ready (GObject * source_object,
                                 GAsyncResult * _res_,
                                 gpointer _user_data_);
static void _dbus_drivers_check_for_drivers (Drivers* self,
                                      GVariant* _parameters_,
                                      GDBusMethodInvocation* invocation);
static void _dbus_drivers_check_for_drivers_ready (GObject * source_object,
                                            GAsyncResult * _res_,
                                            gpointer _user_data_);
static void _dbus_drivers_install (Drivers* self,
                            GVariant* _parameters_,
                            GDBusMethodInvocation* invocation);
static void _dbus_drivers_install_ready (GObject * source_object,
                                  GAsyncResult * _res_,
                                  gpointer _user_data_);
static void drivers_dbus_interface_method_call (GDBusConnection* connection,
                                         const gchar* sender,
                                         const gchar* object_path,
                                         const gchar* interface_name,
                                         const gchar* method_name,
                                         GVariant* parameters,
                                         GDBusMethodInvocation* invocation,
                                         gpointer user_data);
static GVariant* drivers_dbus_interface_get_property (GDBusConnection* connection,
                                               const gchar* sender,
                                               const gchar* object_path,
                                               const gchar* interface_name,
                                               const gchar* property_name,
                                               GError** error,
                                               gpointer user_data);
static gboolean drivers_dbus_interface_set_property (GDBusConnection* connection,
                                              const gchar* sender,
                                              const gchar* object_path,
                                              const gchar* interface_name,
                                              const gchar* property_name,
                                              GVariant* value,
                                              GError** error,
                                              gpointer user_data);
static void _dbus_drivers_state_changed (GObject* _sender,
                                  gpointer* _data);
static void _drivers_unregister_object (gpointer user_data);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static const GDBusArgInfo _drivers_dbus_arg_info_get_current_state_result = {-1, "result", "(is)", NULL};
static const GDBusArgInfo * const _drivers_dbus_arg_info_get_current_state_in[] = {NULL};
static const GDBusArgInfo * const _drivers_dbus_arg_info_get_current_state_out[] = {&_drivers_dbus_arg_info_get_current_state_result, NULL};
static const GDBusMethodInfo _drivers_dbus_method_info_get_current_state = {-1, "GetCurrentState", (GDBusArgInfo **) (&_drivers_dbus_arg_info_get_current_state_in), (GDBusArgInfo **) (&_drivers_dbus_arg_info_get_current_state_out), NULL};
static const GDBusArgInfo _drivers_dbus_arg_info_get_available_drivers_result = {-1, "result", "a{sa{sb}}", NULL};
static const GDBusArgInfo * const _drivers_dbus_arg_info_get_available_drivers_in[] = {NULL};
static const GDBusArgInfo * const _drivers_dbus_arg_info_get_available_drivers_out[] = {&_drivers_dbus_arg_info_get_available_drivers_result, NULL};
static const GDBusMethodInfo _drivers_dbus_method_info_get_available_drivers = {-1, "GetAvailableDrivers", (GDBusArgInfo **) (&_drivers_dbus_arg_info_get_available_drivers_in), (GDBusArgInfo **) (&_drivers_dbus_arg_info_get_available_drivers_out), NULL};
static const GDBusArgInfo * const _drivers_dbus_arg_info_cancel_in[] = {NULL};
static const GDBusArgInfo * const _drivers_dbus_arg_info_cancel_out[] = {NULL};
static const GDBusMethodInfo _drivers_dbus_method_info_cancel = {-1, "Cancel", (GDBusArgInfo **) (&_drivers_dbus_arg_info_cancel_in), (GDBusArgInfo **) (&_drivers_dbus_arg_info_cancel_out), NULL};
static const GDBusArgInfo _drivers_dbus_arg_info_check_for_drivers_notify = {-1, "notify", "b", NULL};
static const GDBusArgInfo * const _drivers_dbus_arg_info_check_for_drivers_in[] = {&_drivers_dbus_arg_info_check_for_drivers_notify, NULL};
static const GDBusArgInfo * const _drivers_dbus_arg_info_check_for_drivers_out[] = {NULL};
static const GDBusMethodInfo _drivers_dbus_method_info_check_for_drivers = {-1, "CheckForDrivers", (GDBusArgInfo **) (&_drivers_dbus_arg_info_check_for_drivers_in), (GDBusArgInfo **) (&_drivers_dbus_arg_info_check_for_drivers_out), NULL};
static const GDBusArgInfo _drivers_dbus_arg_info_install_name = {-1, "name", "s", NULL};
static const GDBusArgInfo * const _drivers_dbus_arg_info_install_in[] = {&_drivers_dbus_arg_info_install_name, NULL};
static const GDBusArgInfo * const _drivers_dbus_arg_info_install_out[] = {NULL};
static const GDBusMethodInfo _drivers_dbus_method_info_install = {-1, "Install", (GDBusArgInfo **) (&_drivers_dbus_arg_info_install_in), (GDBusArgInfo **) (&_drivers_dbus_arg_info_install_out), NULL};
static const GDBusMethodInfo * const _drivers_dbus_method_info[] = {&_drivers_dbus_method_info_get_current_state, &_drivers_dbus_method_info_get_available_drivers, &_drivers_dbus_method_info_cancel, &_drivers_dbus_method_info_check_for_drivers, &_drivers_dbus_method_info_install, NULL};
static const GDBusArgInfo * const _drivers_dbus_arg_info_state_changed[] = {NULL};
static const GDBusSignalInfo _drivers_dbus_signal_info_state_changed = {-1, "StateChanged", (GDBusArgInfo **) (&_drivers_dbus_arg_info_state_changed), NULL};
static const GDBusSignalInfo * const _drivers_dbus_signal_info[] = {&_drivers_dbus_signal_info_state_changed, NULL};
static const GDBusPropertyInfo * const _drivers_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _drivers_dbus_interface_info = {-1, "io.elementary.settings_daemon.Drivers", (GDBusMethodInfo **) (&_drivers_dbus_method_info), (GDBusSignalInfo **) (&_drivers_dbus_signal_info), (GDBusPropertyInfo **) (&_drivers_dbus_property_info), NULL};
static const GDBusInterfaceVTable _drivers_dbus_interface_vtable = {drivers_dbus_interface_method_call, drivers_dbus_interface_get_property, drivers_dbus_interface_set_property};

 G_GNUC_NO_INLINE static GType
drivers_state_get_type_once (void)
{
	static const GEnumValue values[] = {{DRIVERS_STATE_UP_TO_DATE, "DRIVERS_STATE_UP_TO_DATE", "up-to-date"}, {DRIVERS_STATE_CHECKING, "DRIVERS_STATE_CHECKING", "checking"}, {DRIVERS_STATE_AVAILABLE, "DRIVERS_STATE_AVAILABLE", "available"}, {DRIVERS_STATE_DOWNLOADING, "DRIVERS_STATE_DOWNLOADING", "downloading"}, {DRIVERS_STATE_RESTART_REQUIRED, "DRIVERS_STATE_RESTART_REQUIRED", "restart-required"}, {DRIVERS_STATE_ERROR, "DRIVERS_STATE_ERROR", "error"}, {0, NULL, NULL}};
	GType drivers_state_type_id;
	drivers_state_type_id = g_enum_register_static ("DriversState", values);
	return drivers_state_type_id;
}

GType
drivers_state_get_type (void)
{
	static volatile gsize drivers_state_type_id__once = 0;
	if (g_once_init_enter (&drivers_state_type_id__once)) {
		GType drivers_state_type_id;
		drivers_state_type_id = drivers_state_get_type_once ();
		g_once_init_leave (&drivers_state_type_id__once, drivers_state_type_id);
	}
	return drivers_state_type_id__once;
}

void
drivers_get_current_state (Drivers* self,
                           GAsyncReadyCallback _callback_,
                           gpointer _user_data_)
{
	DriversIface* _iface_;
	_iface_ = DRIVERS_GET_INTERFACE (self);
	if (_iface_->get_current_state) {
		_iface_->get_current_state (self, _callback_, _user_data_);
	}
}

void
drivers_get_current_state_finish (Drivers* self,
                                  GAsyncResult* _res_,
                                  DriversCurrentState* result,
                                  GError** error)
{
	DriversIface* _iface_;
	_iface_ = DRIVERS_GET_INTERFACE (self);
	if (_iface_->get_current_state_finish) {
		_iface_->get_current_state_finish (self, _res_, result, error);
	}
	return;
}

void
drivers_get_available_drivers (Drivers* self,
                               GAsyncReadyCallback _callback_,
                               gpointer _user_data_)
{
	DriversIface* _iface_;
	_iface_ = DRIVERS_GET_INTERFACE (self);
	if (_iface_->get_available_drivers) {
		_iface_->get_available_drivers (self, _callback_, _user_data_);
	}
}

GHashTable*
drivers_get_available_drivers_finish (Drivers* self,
                                      GAsyncResult* _res_,
                                      GError** error)
{
	DriversIface* _iface_;
	_iface_ = DRIVERS_GET_INTERFACE (self);
	if (_iface_->get_available_drivers_finish) {
		return _iface_->get_available_drivers_finish (self, _res_, error);
	}
	return NULL;
}

void
drivers_cancel (Drivers* self,
                GAsyncReadyCallback _callback_,
                gpointer _user_data_)
{
	DriversIface* _iface_;
	_iface_ = DRIVERS_GET_INTERFACE (self);
	if (_iface_->cancel) {
		_iface_->cancel (self, _callback_, _user_data_);
	}
}

void
drivers_cancel_finish (Drivers* self,
                       GAsyncResult* _res_,
                       GError** error)
{
	DriversIface* _iface_;
	_iface_ = DRIVERS_GET_INTERFACE (self);
	if (_iface_->cancel_finish) {
		_iface_->cancel_finish (self, _res_, error);
	}
}

void
drivers_check_for_drivers (Drivers* self,
                           gboolean notify,
                           GAsyncReadyCallback _callback_,
                           gpointer _user_data_)
{
	DriversIface* _iface_;
	_iface_ = DRIVERS_GET_INTERFACE (self);
	if (_iface_->check_for_drivers) {
		_iface_->check_for_drivers (self, notify, _callback_, _user_data_);
	}
}

void
drivers_check_for_drivers_finish (Drivers* self,
                                  GAsyncResult* _res_,
                                  GError** error)
{
	DriversIface* _iface_;
	_iface_ = DRIVERS_GET_INTERFACE (self);
	if (_iface_->check_for_drivers_finish) {
		_iface_->check_for_drivers_finish (self, _res_, error);
	}
}

void
drivers_install (Drivers* self,
                 const gchar* name,
                 GAsyncReadyCallback _callback_,
                 gpointer _user_data_)
{
	DriversIface* _iface_;
	_iface_ = DRIVERS_GET_INTERFACE (self);
	if (_iface_->install) {
		_iface_->install (self, name, _callback_, _user_data_);
	}
}

void
drivers_install_finish (Drivers* self,
                        GAsyncResult* _res_,
                        GError** error)
{
	DriversIface* _iface_;
	_iface_ = DRIVERS_GET_INTERFACE (self);
	if (_iface_->install_finish) {
		_iface_->install_finish (self, _res_, error);
	}
}

void
drivers_current_state_copy (const DriversCurrentState* self,
                            DriversCurrentState* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	(*dest).state = (*self).state;
	_tmp0_ = (*self).message;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).message);
	(*dest).message = _tmp1_;
}

void
drivers_current_state_destroy (DriversCurrentState* self)
{
	_g_free0 ((*self).message);
}

DriversCurrentState*
drivers_current_state_dup (const DriversCurrentState* self)
{
	DriversCurrentState* dup;
	dup = g_new0 (DriversCurrentState, 1);
	drivers_current_state_copy (self, dup);
	return dup;
}

void
drivers_current_state_free (DriversCurrentState* self)
{
	drivers_current_state_destroy (self);
	g_free (self);
}

 G_GNUC_NO_INLINE static GType
drivers_current_state_get_type_once (void)
{
	GType drivers_current_state_type_id;
	drivers_current_state_type_id = g_boxed_type_register_static ("DriversCurrentState", (GBoxedCopyFunc) drivers_current_state_dup, (GBoxedFreeFunc) drivers_current_state_free);
	return drivers_current_state_type_id;
}

GType
drivers_current_state_get_type (void)
{
	static volatile gsize drivers_current_state_type_id__once = 0;
	if (g_once_init_enter (&drivers_current_state_type_id__once)) {
		GType drivers_current_state_type_id;
		drivers_current_state_type_id = drivers_current_state_get_type_once ();
		g_once_init_leave (&drivers_current_state_type_id__once, drivers_current_state_type_id);
	}
	return drivers_current_state_type_id__once;
}

static void
drivers_default_init (DriversIface * iface,
                      gpointer iface_data)
{
	drivers_signals[DRIVERS_STATE_CHANGED_SIGNAL] = g_signal_new ("state-changed", TYPE_DRIVERS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

 G_GNUC_NO_INLINE static GType
drivers_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DriversIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) drivers_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType drivers_type_id;
	drivers_type_id = g_type_register_static (G_TYPE_INTERFACE, "Drivers", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (drivers_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (drivers_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) drivers_proxy_get_type);
	g_type_set_qdata (drivers_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "io.elementary.settings_daemon.Drivers");
	g_type_set_qdata (drivers_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_drivers_dbus_interface_info));
	g_type_set_qdata (drivers_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) drivers_register_object);
	return drivers_type_id;
}

GType
drivers_get_type (void)
{
	static volatile gsize drivers_type_id__once = 0;
	if (g_once_init_enter (&drivers_type_id__once)) {
		GType drivers_type_id;
		drivers_type_id = drivers_get_type_once ();
		g_once_init_leave (&drivers_type_id__once, drivers_type_id);
	}
	return drivers_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (DriversProxy, drivers_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_DRIVERS, drivers_proxy_drivers_interface_init) )
static void
drivers_proxy_class_init (DriversProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = drivers_proxy_g_signal;
}

static void
_dbus_handle_drivers_state_changed (Drivers* self,
                                    GVariant* parameters)
{
	GVariantIter _arguments_iter;
	g_variant_iter_init (&_arguments_iter, parameters);
	g_signal_emit_by_name (self, "state-changed");
}

static void
drivers_proxy_g_signal (GDBusProxy* proxy,
                        const gchar* sender_name,
                        const gchar* signal_name,
                        GVariant* parameters)
{
	if (strcmp (signal_name, "StateChanged") == 0) {
		_dbus_handle_drivers_state_changed ((Drivers*) proxy, parameters);
	}
}

static void
drivers_proxy_init (DriversProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_drivers_dbus_interface_info));
}

static void
_vala_g_async_ready_callback (GObject *source_object,
                              GAsyncResult *res,
                              void *user_data)
{
	g_task_return_pointer (user_data, g_object_ref (res), g_object_unref);
	g_object_unref (user_data);
}

static void
drivers_proxy_get_current_state_async (Drivers* self,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	G_DBUS_ERROR;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "io.elementary.settings_daemon.Drivers", "GetCurrentState");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	if (_callback_ != NULL) {
		g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_task_new ((GObject *) self, NULL, _callback_, _user_data_));
	} else {
		g_dbus_message_set_flags (_message, G_DBUS_MESSAGE_FLAGS_NO_REPLY_EXPECTED);
		g_dbus_connection_send_message (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	}
	g_object_unref (_message);
}

static void
drivers_proxy_get_current_state_finish (Drivers* self,
                                        GAsyncResult* _res_,
                                        DriversCurrentState* result,
                                        GError** error)
{
	GAsyncResult *_inner_res;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	GVariant* _tmp32_;
	DriversCurrentState _tmp33_;
	GVariantIter _tmp34_;
	GVariant* _tmp35_;
	GVariant* _tmp36_;
	_inner_res = g_task_propagate_pointer ((GTask *) _res_, NULL);
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), _inner_res, error);
	g_object_unref (_inner_res);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp32_ = g_variant_iter_next_value (&_reply_iter);
	g_variant_iter_init (&_tmp34_, _tmp32_);
	_tmp35_ = g_variant_iter_next_value (&_tmp34_);
	_tmp33_.state = g_variant_get_int32 (_tmp35_);
	g_variant_unref (_tmp35_);
	_tmp36_ = g_variant_iter_next_value (&_tmp34_);
	_tmp33_.message = g_variant_dup_string (_tmp36_, NULL);
	g_variant_unref (_tmp36_);
	*result = _tmp33_;
	g_variant_unref (_tmp32_);
	g_object_unref (_reply_message);
}

static void
drivers_proxy_get_available_drivers_async (Drivers* self,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	G_DBUS_ERROR;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "io.elementary.settings_daemon.Drivers", "GetAvailableDrivers");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	if (_callback_ != NULL) {
		g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_task_new ((GObject *) self, NULL, _callback_, _user_data_));
	} else {
		g_dbus_message_set_flags (_message, G_DBUS_MESSAGE_FLAGS_NO_REPLY_EXPECTED);
		g_dbus_connection_send_message (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	}
	g_object_unref (_message);
}

static GHashTable*
drivers_proxy_get_available_drivers_finish (Drivers* self,
                                            GAsyncResult* _res_,
                                            GError** error)
{
	GAsyncResult *_inner_res;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	GHashTable* _result = NULL;
	GVariant* _tmp37_;
	GHashTable* _tmp38_;
	GVariantIter _tmp39_;
	GVariant* _tmp40_;
	GVariant* _tmp41_;
	_inner_res = g_task_propagate_pointer ((GTask *) _res_, NULL);
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), _inner_res, error);
	g_object_unref (_inner_res);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp37_ = g_variant_iter_next_value (&_reply_iter);
	_tmp38_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, (GDestroyNotify) g_hash_table_unref);
	g_variant_iter_init (&_tmp39_, _tmp37_);
	while (g_variant_iter_loop (&_tmp39_, "{?*}", &_tmp40_, &_tmp41_)) {
		GHashTable* _tmp42_;
		GVariantIter _tmp43_;
		GVariant* _tmp44_;
		GVariant* _tmp45_;
		_tmp42_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, NULL);
		g_variant_iter_init (&_tmp43_, _tmp41_);
		while (g_variant_iter_loop (&_tmp43_, "{?*}", &_tmp44_, &_tmp45_)) {
			g_hash_table_insert (_tmp42_, g_variant_dup_string (_tmp44_, NULL), (gpointer) ((gintptr) g_variant_get_boolean (_tmp45_)));
		}
		g_hash_table_insert (_tmp38_, g_variant_dup_string (_tmp40_, NULL), _tmp42_);
	}
	_result = _tmp38_;
	g_variant_unref (_tmp37_);
	g_object_unref (_reply_message);
	return _result;
}

static void
drivers_proxy_cancel_async (Drivers* self,
                            GAsyncReadyCallback _callback_,
                            gpointer _user_data_)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	G_DBUS_ERROR;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "io.elementary.settings_daemon.Drivers", "Cancel");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	if (_callback_ != NULL) {
		g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_task_new ((GObject *) self, NULL, _callback_, _user_data_));
	} else {
		g_dbus_message_set_flags (_message, G_DBUS_MESSAGE_FLAGS_NO_REPLY_EXPECTED);
		g_dbus_connection_send_message (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	}
	g_object_unref (_message);
}

static void
drivers_proxy_cancel_finish (Drivers* self,
                             GAsyncResult* _res_,
                             GError** error)
{
	GAsyncResult *_inner_res;
	GDBusMessage *_reply_message;
	_inner_res = g_task_propagate_pointer ((GTask *) _res_, NULL);
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), _inner_res, error);
	g_object_unref (_inner_res);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
drivers_proxy_check_for_drivers_async (Drivers* self,
                                       gboolean notify,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	G_DBUS_ERROR;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "io.elementary.settings_daemon.Drivers", "CheckForDrivers");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_boolean (notify));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	if (_callback_ != NULL) {
		g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_task_new ((GObject *) self, NULL, _callback_, _user_data_));
	} else {
		g_dbus_message_set_flags (_message, G_DBUS_MESSAGE_FLAGS_NO_REPLY_EXPECTED);
		g_dbus_connection_send_message (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	}
	g_object_unref (_message);
}

static void
drivers_proxy_check_for_drivers_finish (Drivers* self,
                                        GAsyncResult* _res_,
                                        GError** error)
{
	GAsyncResult *_inner_res;
	GDBusMessage *_reply_message;
	_inner_res = g_task_propagate_pointer ((GTask *) _res_, NULL);
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), _inner_res, error);
	g_object_unref (_inner_res);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
drivers_proxy_install_async (Drivers* self,
                             const gchar* name,
                             GAsyncReadyCallback _callback_,
                             gpointer _user_data_)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	G_DBUS_ERROR;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "io.elementary.settings_daemon.Drivers", "Install");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (name));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	if (_callback_ != NULL) {
		g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_task_new ((GObject *) self, NULL, _callback_, _user_data_));
	} else {
		g_dbus_message_set_flags (_message, G_DBUS_MESSAGE_FLAGS_NO_REPLY_EXPECTED);
		g_dbus_connection_send_message (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	}
	g_object_unref (_message);
}

static void
drivers_proxy_install_finish (Drivers* self,
                              GAsyncResult* _res_,
                              GError** error)
{
	GAsyncResult *_inner_res;
	GDBusMessage *_reply_message;
	_inner_res = g_task_propagate_pointer ((GTask *) _res_, NULL);
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), _inner_res, error);
	g_object_unref (_inner_res);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
drivers_proxy_drivers_interface_init (DriversIface* iface)
{
	iface->get_current_state = drivers_proxy_get_current_state_async;
	iface->get_current_state_finish = drivers_proxy_get_current_state_finish;
	iface->get_available_drivers = drivers_proxy_get_available_drivers_async;
	iface->get_available_drivers_finish = drivers_proxy_get_available_drivers_finish;
	iface->cancel = drivers_proxy_cancel_async;
	iface->cancel_finish = drivers_proxy_cancel_finish;
	iface->check_for_drivers = drivers_proxy_check_for_drivers_async;
	iface->check_for_drivers_finish = drivers_proxy_check_for_drivers_finish;
	iface->install = drivers_proxy_install_async;
	iface->install_finish = drivers_proxy_install_finish;
}

static void
_dbus_drivers_get_current_state (Drivers* self,
                                 GVariant* _parameters_,
                                 GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	DriversGetCurrentStateReadyData* _ready_data;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (DriversGetCurrentStateReadyData);
	_ready_data->_invocation_ = invocation;
	drivers_get_current_state (self, (GAsyncReadyCallback) _dbus_drivers_get_current_state_ready, _ready_data);
}

static void
_dbus_drivers_get_current_state_ready (GObject * source_object,
                                       GAsyncResult * _res_,
                                       gpointer _user_data_)
{
	DriversGetCurrentStateReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	DriversCurrentState result = {0};
	GVariantBuilder _tmp46_;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	drivers_get_current_state_finish ((Drivers*) source_object, _res_, &result, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_init (&_tmp46_, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_tmp46_, g_variant_new_int32 (result.state));
	g_variant_builder_add_value (&_tmp46_, g_variant_new_string (result.message));
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp46_));
	drivers_current_state_destroy (&result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	g_slice_free (DriversGetCurrentStateReadyData, _ready_data);
}

static void
_dbus_drivers_get_available_drivers (Drivers* self,
                                     GVariant* _parameters_,
                                     GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	DriversGetAvailableDriversReadyData* _ready_data;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (DriversGetAvailableDriversReadyData);
	_ready_data->_invocation_ = invocation;
	drivers_get_available_drivers (self, (GAsyncReadyCallback) _dbus_drivers_get_available_drivers_ready, _ready_data);
}

static void
_dbus_drivers_get_available_drivers_ready (GObject * source_object,
                                           GAsyncResult * _res_,
                                           gpointer _user_data_)
{
	DriversGetAvailableDriversReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	GHashTable* result;
	GVariantBuilder _tmp47_;
	GHashTableIter _tmp48_;
	gpointer _tmp49_;
	gpointer _tmp50_;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	result = drivers_get_available_drivers_finish ((Drivers*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_hash_table_iter_init (&_tmp48_, result);
	g_variant_builder_init (&_tmp47_, G_VARIANT_TYPE ("a{sa{sb}}"));
	while (g_hash_table_iter_next (&_tmp48_, &_tmp49_, &_tmp50_)) {
		gchar* _key;
		GHashTable* _value;
		GVariantBuilder _tmp51_;
		GHashTableIter _tmp52_;
		gpointer _tmp53_;
		gpointer _tmp54_;
		_key = (gchar*) _tmp49_;
		_value = (GHashTable*) _tmp50_;
		g_hash_table_iter_init (&_tmp52_, _value);
		g_variant_builder_init (&_tmp51_, G_VARIANT_TYPE ("a{sb}"));
		while (g_hash_table_iter_next (&_tmp52_, &_tmp53_, &_tmp54_)) {
			gchar* _key;
			gboolean _value;
			_key = (gchar*) _tmp53_;
			_value = (gboolean) ((gintptr) _tmp54_);
			g_variant_builder_add (&_tmp51_, "{?*}", g_variant_new_string (_key), g_variant_new_boolean (_value));
		}
		g_variant_builder_add (&_tmp47_, "{?*}", g_variant_new_string (_key), g_variant_builder_end (&_tmp51_));
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp47_));
	_g_hash_table_unref0 (result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	g_slice_free (DriversGetAvailableDriversReadyData, _ready_data);
}

static void
_dbus_drivers_cancel (Drivers* self,
                      GVariant* _parameters_,
                      GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	DriversCancelReadyData* _ready_data;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (DriversCancelReadyData);
	_ready_data->_invocation_ = invocation;
	drivers_cancel (self, (GAsyncReadyCallback) _dbus_drivers_cancel_ready, _ready_data);
}

static void
_dbus_drivers_cancel_ready (GObject * source_object,
                            GAsyncResult * _res_,
                            gpointer _user_data_)
{
	DriversCancelReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	drivers_cancel_finish ((Drivers*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	g_slice_free (DriversCancelReadyData, _ready_data);
}

static void
_dbus_drivers_check_for_drivers (Drivers* self,
                                 GVariant* _parameters_,
                                 GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	DriversCheckForDriversReadyData* _ready_data;
	GVariant* _tmp55_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (DriversCheckForDriversReadyData);
	_ready_data->_invocation_ = invocation;
	_tmp55_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->notify = g_variant_get_boolean (_tmp55_);
	g_variant_unref (_tmp55_);
	drivers_check_for_drivers (self, _ready_data->notify, (GAsyncReadyCallback) _dbus_drivers_check_for_drivers_ready, _ready_data);
}

static void
_dbus_drivers_check_for_drivers_ready (GObject * source_object,
                                       GAsyncResult * _res_,
                                       gpointer _user_data_)
{
	DriversCheckForDriversReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	drivers_check_for_drivers_finish ((Drivers*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	g_slice_free (DriversCheckForDriversReadyData, _ready_data);
}

static void
_dbus_drivers_install (Drivers* self,
                       GVariant* _parameters_,
                       GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	DriversInstallReadyData* _ready_data;
	GVariant* _tmp56_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (DriversInstallReadyData);
	_ready_data->_invocation_ = invocation;
	_tmp56_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->name = g_variant_dup_string (_tmp56_, NULL);
	g_variant_unref (_tmp56_);
	drivers_install (self, _ready_data->name, (GAsyncReadyCallback) _dbus_drivers_install_ready, _ready_data);
	_error:
	;
}

static void
_dbus_drivers_install_ready (GObject * source_object,
                             GAsyncResult * _res_,
                             gpointer _user_data_)
{
	DriversInstallReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	drivers_install_finish ((Drivers*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (_ready_data->name);
	g_slice_free (DriversInstallReadyData, _ready_data);
}

static void
drivers_dbus_interface_method_call (GDBusConnection* connection,
                                    const gchar* sender,
                                    const gchar* object_path,
                                    const gchar* interface_name,
                                    const gchar* method_name,
                                    GVariant* parameters,
                                    GDBusMethodInvocation* invocation,
                                    gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "GetCurrentState") == 0) {
		_dbus_drivers_get_current_state (object, parameters, invocation);
	} else if (strcmp (method_name, "GetAvailableDrivers") == 0) {
		_dbus_drivers_get_available_drivers (object, parameters, invocation);
	} else if (strcmp (method_name, "Cancel") == 0) {
		_dbus_drivers_cancel (object, parameters, invocation);
	} else if (strcmp (method_name, "CheckForDrivers") == 0) {
		_dbus_drivers_check_for_drivers (object, parameters, invocation);
	} else if (strcmp (method_name, "Install") == 0) {
		_dbus_drivers_install (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
drivers_dbus_interface_get_property (GDBusConnection* connection,
                                     const gchar* sender,
                                     const gchar* object_path,
                                     const gchar* interface_name,
                                     const gchar* property_name,
                                     GError** error,
                                     gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
drivers_dbus_interface_set_property (GDBusConnection* connection,
                                     const gchar* sender,
                                     const gchar* object_path,
                                     const gchar* interface_name,
                                     const gchar* property_name,
                                     GVariant* value,
                                     GError** error,
                                     gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

static void
_dbus_drivers_state_changed (GObject* _sender,
                             gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "io.elementary.settings_daemon.Drivers", "StateChanged", _arguments, NULL);
}

guint
drivers_register_object (gpointer object,
                         GDBusConnection* connection,
                         const gchar* path,
                         GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_drivers_dbus_interface_info), &_drivers_dbus_interface_vtable, data, _drivers_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "state-changed", (GCallback) _dbus_drivers_state_changed, data);
	return result;
}

static void
_drivers_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_drivers_state_changed, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

