/* BottomBar.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from BottomBar.vala, do not modify */

/*-
 * Copyright 2013-2021 elementary, Inc. (https://elementary.io)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Corentin Noël <corentin@elementaryos.org>
 *              Artem Anufrij <artem.anufrij@live.de>
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <granite-7.h>
#include <gdk/gdk.h>
#include <cairo-gobject.h>

#define AUDIENCE_APP_ACTION_PLAY_PAUSE "action-play-pause"
#define AUDIENCE_APP_ACTION_PREFIX "app."
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define AUDIENCE_WIDGETS_TYPE_BOTTOM_BAR (audience_widgets_bottom_bar_get_type ())
#define AUDIENCE_WIDGETS_BOTTOM_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AUDIENCE_WIDGETS_TYPE_BOTTOM_BAR, AudienceWidgetsBottomBar))
#define AUDIENCE_WIDGETS_BOTTOM_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AUDIENCE_WIDGETS_TYPE_BOTTOM_BAR, AudienceWidgetsBottomBarClass))
#define AUDIENCE_WIDGETS_IS_BOTTOM_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AUDIENCE_WIDGETS_TYPE_BOTTOM_BAR))
#define AUDIENCE_WIDGETS_IS_BOTTOM_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AUDIENCE_WIDGETS_TYPE_BOTTOM_BAR))
#define AUDIENCE_WIDGETS_BOTTOM_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AUDIENCE_WIDGETS_TYPE_BOTTOM_BAR, AudienceWidgetsBottomBarClass))

typedef struct _AudienceWidgetsBottomBar AudienceWidgetsBottomBar;
typedef struct _AudienceWidgetsBottomBarClass AudienceWidgetsBottomBarClass;
typedef struct _AudienceWidgetsBottomBarPrivate AudienceWidgetsBottomBarPrivate;

#define AUDIENCE_WIDGETS_TYPE_PREVIEW_POPOVER (audience_widgets_preview_popover_get_type ())
#define AUDIENCE_WIDGETS_PREVIEW_POPOVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AUDIENCE_WIDGETS_TYPE_PREVIEW_POPOVER, AudienceWidgetsPreviewPopover))
#define AUDIENCE_WIDGETS_PREVIEW_POPOVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AUDIENCE_WIDGETS_TYPE_PREVIEW_POPOVER, AudienceWidgetsPreviewPopoverClass))
#define AUDIENCE_WIDGETS_IS_PREVIEW_POPOVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AUDIENCE_WIDGETS_TYPE_PREVIEW_POPOVER))
#define AUDIENCE_WIDGETS_IS_PREVIEW_POPOVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AUDIENCE_WIDGETS_TYPE_PREVIEW_POPOVER))
#define AUDIENCE_WIDGETS_PREVIEW_POPOVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AUDIENCE_WIDGETS_TYPE_PREVIEW_POPOVER, AudienceWidgetsPreviewPopoverClass))

typedef struct _AudienceWidgetsPreviewPopover AudienceWidgetsPreviewPopover;
typedef struct _AudienceWidgetsPreviewPopoverClass AudienceWidgetsPreviewPopoverClass;

#define AUDIENCE_WIDGETS_TYPE_PLAYLIST_POPOVER (audience_widgets_playlist_popover_get_type ())
#define AUDIENCE_WIDGETS_PLAYLIST_POPOVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AUDIENCE_WIDGETS_TYPE_PLAYLIST_POPOVER, AudienceWidgetsPlaylistPopover))
#define AUDIENCE_WIDGETS_PLAYLIST_POPOVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AUDIENCE_WIDGETS_TYPE_PLAYLIST_POPOVER, AudienceWidgetsPlaylistPopoverClass))
#define AUDIENCE_WIDGETS_IS_PLAYLIST_POPOVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AUDIENCE_WIDGETS_TYPE_PLAYLIST_POPOVER))
#define AUDIENCE_WIDGETS_IS_PLAYLIST_POPOVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AUDIENCE_WIDGETS_TYPE_PLAYLIST_POPOVER))
#define AUDIENCE_WIDGETS_PLAYLIST_POPOVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AUDIENCE_WIDGETS_TYPE_PLAYLIST_POPOVER, AudienceWidgetsPlaylistPopoverClass))

typedef struct _AudienceWidgetsPlaylistPopover AudienceWidgetsPlaylistPopover;
typedef struct _AudienceWidgetsPlaylistPopoverClass AudienceWidgetsPlaylistPopoverClass;

#define AUDIENCE_WIDGETS_TYPE_SETTINGS_POPOVER (audience_widgets_settings_popover_get_type ())
#define AUDIENCE_WIDGETS_SETTINGS_POPOVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AUDIENCE_WIDGETS_TYPE_SETTINGS_POPOVER, AudienceWidgetsSettingsPopover))
#define AUDIENCE_WIDGETS_SETTINGS_POPOVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AUDIENCE_WIDGETS_TYPE_SETTINGS_POPOVER, AudienceWidgetsSettingsPopoverClass))
#define AUDIENCE_WIDGETS_IS_SETTINGS_POPOVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AUDIENCE_WIDGETS_TYPE_SETTINGS_POPOVER))
#define AUDIENCE_WIDGETS_IS_SETTINGS_POPOVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AUDIENCE_WIDGETS_TYPE_SETTINGS_POPOVER))
#define AUDIENCE_WIDGETS_SETTINGS_POPOVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AUDIENCE_WIDGETS_TYPE_SETTINGS_POPOVER, AudienceWidgetsSettingsPopoverClass))

typedef struct _AudienceWidgetsSettingsPopover AudienceWidgetsSettingsPopover;
typedef struct _AudienceWidgetsSettingsPopoverClass AudienceWidgetsSettingsPopoverClass;
enum  {
	AUDIENCE_WIDGETS_BOTTOM_BAR_0_PROPERTY,
	AUDIENCE_WIDGETS_BOTTOM_BAR_SHOULD_STAY_REVEALED_PROPERTY,
	AUDIENCE_WIDGETS_BOTTOM_BAR_NUM_PROPERTIES
};
static GParamSpec* audience_widgets_bottom_bar_properties[AUDIENCE_WIDGETS_BOTTOM_BAR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

#define AUDIENCE_TYPE_PLAYBACK_MANAGER (audience_playback_manager_get_type ())
#define AUDIENCE_PLAYBACK_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AUDIENCE_TYPE_PLAYBACK_MANAGER, AudiencePlaybackManager))
#define AUDIENCE_PLAYBACK_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AUDIENCE_TYPE_PLAYBACK_MANAGER, AudiencePlaybackManagerClass))
#define AUDIENCE_IS_PLAYBACK_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AUDIENCE_TYPE_PLAYBACK_MANAGER))
#define AUDIENCE_IS_PLAYBACK_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AUDIENCE_TYPE_PLAYBACK_MANAGER))
#define AUDIENCE_PLAYBACK_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AUDIENCE_TYPE_PLAYBACK_MANAGER, AudiencePlaybackManagerClass))

typedef struct _AudiencePlaybackManager AudiencePlaybackManager;
typedef struct _AudiencePlaybackManagerClass AudiencePlaybackManagerClass;
typedef struct _Block15Data Block15Data;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _AudienceWidgetsBottomBar {
	GtkBox parent_instance;
	AudienceWidgetsBottomBarPrivate * priv;
};

struct _AudienceWidgetsBottomBarClass {
	GtkBoxClass parent_class;
};

struct _AudienceWidgetsBottomBarPrivate {
	AudienceWidgetsPreviewPopover* preview_popover;
	gdouble playback_duration;
	AudienceWidgetsPlaylistPopover* playlist_popover;
	AudienceWidgetsSettingsPopover* settings_popover;
	gboolean hovered;
};

struct _Block15Data {
	int _ref_count_;
	AudienceWidgetsBottomBar* self;
	GtkButton* play_button;
	GtkLabel* progression_label;
	GtkLabel* duration_label;
	GtkScale* scale;
	AudiencePlaybackManager* playback_manager;
};

static gint AudienceWidgetsBottomBar_private_offset;
static gpointer audience_widgets_bottom_bar_parent_class = NULL;

VALA_EXTERN GType audience_widgets_bottom_bar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AudienceWidgetsBottomBar, g_object_unref)
VALA_EXTERN GType audience_widgets_preview_popover_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AudienceWidgetsPreviewPopover, g_object_unref)
VALA_EXTERN GType audience_widgets_playlist_popover_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AudienceWidgetsPlaylistPopover, g_object_unref)
VALA_EXTERN GType audience_widgets_settings_popover_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AudienceWidgetsSettingsPopover, g_object_unref)
VALA_EXTERN void audience_widgets_bottom_bar_hide_popovers (AudienceWidgetsBottomBar* self);
VALA_EXTERN void audience_widgets_preview_popover_schedule_hide (AudienceWidgetsPreviewPopover* self);
VALA_EXTERN AudienceWidgetsBottomBar* audience_widgets_bottom_bar_new (void);
VALA_EXTERN AudienceWidgetsBottomBar* audience_widgets_bottom_bar_construct (GType object_type);
VALA_EXTERN gboolean audience_widgets_bottom_bar_get_should_stay_revealed (AudienceWidgetsBottomBar* self);
static GObject * audience_widgets_bottom_bar_constructor (GType type,
                                                   guint n_construct_properties,
                                                   GObjectConstructParam * construct_properties);
VALA_EXTERN GType audience_playback_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AudiencePlaybackManager, g_object_unref)
static Block15Data* block15_data_ref (Block15Data* _data15_);
static void block15_data_unref (void * _userdata_);
VALA_EXTERN AudienceWidgetsPlaylistPopover* audience_widgets_playlist_popover_new (void);
VALA_EXTERN AudienceWidgetsPlaylistPopover* audience_widgets_playlist_popover_construct (GType object_type);
VALA_EXTERN AudienceWidgetsSettingsPopover* audience_widgets_settings_popover_new (void);
VALA_EXTERN AudienceWidgetsSettingsPopover* audience_widgets_settings_popover_construct (GType object_type);
VALA_EXTERN AudienceWidgetsPreviewPopover* audience_widgets_preview_popover_new (void);
VALA_EXTERN AudienceWidgetsPreviewPopover* audience_widgets_preview_popover_construct (GType object_type);
static void _audience_widgets_bottom_bar___lambda47_ (AudienceWidgetsBottomBar* self);
static void __audience_widgets_bottom_bar___lambda47__gtk_event_controller_motion_enter (GtkEventControllerMotion* _sender,
                                                                                  gdouble x,
                                                                                  gdouble y,
                                                                                  gpointer self);
static void _audience_widgets_bottom_bar___lambda48_ (AudienceWidgetsBottomBar* self);
static void __audience_widgets_bottom_bar___lambda48__gtk_event_controller_motion_leave (GtkEventControllerMotion* _sender,
                                                                                  gpointer self);
static void _audience_widgets_bottom_bar___lambda49_ (AudienceWidgetsBottomBar* self);
static void __audience_widgets_bottom_bar___lambda49__g_object_notify (GObject* _sender,
                                                                GParamSpec* pspec,
                                                                gpointer self);
static void _audience_widgets_bottom_bar___lambda50_ (AudienceWidgetsBottomBar* self);
static void __audience_widgets_bottom_bar___lambda50__g_object_notify (GObject* _sender,
                                                                GParamSpec* pspec,
                                                                gpointer self);
static void _audience_widgets_bottom_bar___lambda51_ (Block15Data* _data15_,
                                               const gchar* name,
                                               GVariant* new_state);
static void __audience_widgets_bottom_bar___lambda51__g_action_group_action_state_changed (GActionGroup* _sender,
                                                                                    const gchar* action_name,
                                                                                    GVariant* state,
                                                                                    gpointer self);
VALA_EXTERN AudiencePlaybackManager* audience_playback_manager_get_default (void);
static void _audience_widgets_bottom_bar___lambda52_ (Block15Data* _data15_);
VALA_EXTERN gint64 audience_playback_manager_get_position (AudiencePlaybackManager* self);
static void __audience_widgets_bottom_bar___lambda52__g_object_notify (GObject* _sender,
                                                                GParamSpec* pspec,
                                                                gpointer self);
static void _audience_widgets_bottom_bar___lambda53_ (Block15Data* _data15_);
VALA_EXTERN gint64 audience_playback_manager_get_duration (AudiencePlaybackManager* self);
VALA_EXTERN gchar* audience_playback_manager_get_uri (AudiencePlaybackManager* self);
VALA_EXTERN void audience_widgets_preview_popover_set_playback_uri (AudienceWidgetsPreviewPopover* self,
                                                        const gchar* value);
static void __audience_widgets_bottom_bar___lambda53__g_object_notify (GObject* _sender,
                                                                GParamSpec* pspec,
                                                                gpointer self);
VALA_EXTERN void audience_widgets_preview_popover_schedule_show (AudienceWidgetsPreviewPopover* self);
static void _audience_widgets_preview_popover_schedule_show_gtk_event_controller_motion_enter (GtkEventControllerMotion* _sender,
                                                                                        gdouble x,
                                                                                        gdouble y,
                                                                                        gpointer self);
static void _audience_widgets_preview_popover_schedule_hide_gtk_event_controller_motion_leave (GtkEventControllerMotion* _sender,
                                                                                        gpointer self);
static void _audience_widgets_bottom_bar___lambda54_ (Block15Data* _data15_,
                                               gdouble x,
                                               gdouble y);
VALA_EXTERN void audience_widgets_preview_popover_set_preview_position (AudienceWidgetsPreviewPopover* self,
                                                            gint64 position,
                                                            gboolean loop);
VALA_EXTERN gboolean audience_playback_manager_get_playing (AudiencePlaybackManager* self);
static void __audience_widgets_bottom_bar___lambda54__gtk_event_controller_motion_motion (GtkEventControllerMotion* _sender,
                                                                                   gdouble x,
                                                                                   gdouble y,
                                                                                   gpointer self);
static gboolean _audience_widgets_bottom_bar___lambda55_ (Block15Data* _data15_,
                                                   GtkScrollType scroll,
                                                   gdouble new_value);
VALA_EXTERN void audience_playback_manager_seek (AudiencePlaybackManager* self,
                                     gint64 position);
static gboolean __audience_widgets_bottom_bar___lambda55__gtk_range_change_value (GtkRange* _sender,
                                                                           GtkScrollType scroll,
                                                                           gdouble new_value,
                                                                           gpointer self);
static void audience_widgets_bottom_bar_finalize (GObject * obj);
static GType audience_widgets_bottom_bar_get_type_once (void);
static void _vala_audience_widgets_bottom_bar_get_property (GObject * object,
                                                     guint property_id,
                                                     GValue * value,
                                                     GParamSpec * pspec);

static inline gpointer
audience_widgets_bottom_bar_get_instance_private (AudienceWidgetsBottomBar* self)
{
	return G_STRUCT_MEMBER_P (self, AudienceWidgetsBottomBar_private_offset);
}

void
audience_widgets_bottom_bar_hide_popovers (AudienceWidgetsBottomBar* self)
{
	AudienceWidgetsPlaylistPopover* _tmp0_;
	AudienceWidgetsPreviewPopover* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->playlist_popover;
	gtk_popover_popdown ((GtkPopover*) _tmp0_);
	_tmp1_ = self->priv->preview_popover;
	audience_widgets_preview_popover_schedule_hide (_tmp1_);
}

AudienceWidgetsBottomBar*
audience_widgets_bottom_bar_construct (GType object_type)
{
	AudienceWidgetsBottomBar * self = NULL;
	self = (AudienceWidgetsBottomBar*) g_object_new (object_type, NULL);
	return self;
}

AudienceWidgetsBottomBar*
audience_widgets_bottom_bar_new (void)
{
	return audience_widgets_bottom_bar_construct (AUDIENCE_WIDGETS_TYPE_BOTTOM_BAR);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

gboolean
audience_widgets_bottom_bar_get_should_stay_revealed (AudienceWidgetsBottomBar* self)
{
	gboolean result;
	GAction* play_pause_action = NULL;
	GApplication* _tmp0_;
	GAction* _tmp1_;
	GAction* _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = g_application_get_default ();
	_tmp1_ = g_action_map_lookup_action ((GActionMap*) _tmp0_, AUDIENCE_APP_ACTION_PLAY_PAUSE);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	play_pause_action = _tmp2_;
	if (self->priv->hovered) {
		_tmp5_ = TRUE;
	} else {
		AudienceWidgetsPlaylistPopover* _tmp6_;
		gboolean _tmp7_;
		gboolean _tmp8_;
		_tmp6_ = self->priv->playlist_popover;
		_tmp7_ = gtk_widget_get_visible ((GtkWidget*) _tmp6_);
		_tmp8_ = _tmp7_;
		_tmp5_ = _tmp8_;
	}
	if (_tmp5_) {
		_tmp4_ = TRUE;
	} else {
		AudienceWidgetsSettingsPopover* _tmp9_;
		gboolean _tmp10_;
		gboolean _tmp11_;
		_tmp9_ = self->priv->settings_popover;
		_tmp10_ = gtk_widget_get_visible ((GtkWidget*) _tmp9_);
		_tmp11_ = _tmp10_;
		_tmp4_ = _tmp11_;
	}
	if (_tmp4_) {
		_tmp3_ = TRUE;
	} else {
		GAction* _tmp12_;
		GVariant* _tmp13_;
		GVariant* _tmp14_;
		_tmp12_ = play_pause_action;
		_tmp13_ = g_action_get_state (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp3_ = !g_variant_get_boolean (_tmp14_);
		_g_variant_unref0 (_tmp14_);
	}
	result = _tmp3_;
	_g_object_unref0 (play_pause_action);
	return result;
}

static Block15Data*
block15_data_ref (Block15Data* _data15_)
{
	g_atomic_int_inc (&_data15_->_ref_count_);
	return _data15_;
}

static void
block15_data_unref (void * _userdata_)
{
	Block15Data* _data15_;
	_data15_ = (Block15Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data15_->_ref_count_)) {
		AudienceWidgetsBottomBar* self;
		self = _data15_->self;
		_g_object_unref0 (_data15_->playback_manager);
		_g_object_unref0 (_data15_->scale);
		_g_object_unref0 (_data15_->duration_label);
		_g_object_unref0 (_data15_->progression_label);
		_g_object_unref0 (_data15_->play_button);
		_g_object_unref0 (self);
		g_slice_free (Block15Data, _data15_);
	}
}

static void
_audience_widgets_bottom_bar___lambda47_ (AudienceWidgetsBottomBar* self)
{
	self->priv->hovered = TRUE;
	g_object_notify ((GObject*) self, "should-stay-revealed");
}

static void
__audience_widgets_bottom_bar___lambda47__gtk_event_controller_motion_enter (GtkEventControllerMotion* _sender,
                                                                             gdouble x,
                                                                             gdouble y,
                                                                             gpointer self)
{
	_audience_widgets_bottom_bar___lambda47_ ((AudienceWidgetsBottomBar*) self);
}

static void
_audience_widgets_bottom_bar___lambda48_ (AudienceWidgetsBottomBar* self)
{
	self->priv->hovered = FALSE;
	g_object_notify ((GObject*) self, "should-stay-revealed");
}

static void
__audience_widgets_bottom_bar___lambda48__gtk_event_controller_motion_leave (GtkEventControllerMotion* _sender,
                                                                             gpointer self)
{
	_audience_widgets_bottom_bar___lambda48_ ((AudienceWidgetsBottomBar*) self);
}

static void
_audience_widgets_bottom_bar___lambda49_ (AudienceWidgetsBottomBar* self)
{
	g_object_notify ((GObject*) self, "should-stay-revealed");
}

static void
__audience_widgets_bottom_bar___lambda49__g_object_notify (GObject* _sender,
                                                           GParamSpec* pspec,
                                                           gpointer self)
{
	_audience_widgets_bottom_bar___lambda49_ ((AudienceWidgetsBottomBar*) self);
}

static void
_audience_widgets_bottom_bar___lambda50_ (AudienceWidgetsBottomBar* self)
{
	g_object_notify ((GObject*) self, "should-stay-revealed");
}

static void
__audience_widgets_bottom_bar___lambda50__g_object_notify (GObject* _sender,
                                                           GParamSpec* pspec,
                                                           gpointer self)
{
	_audience_widgets_bottom_bar___lambda50_ ((AudienceWidgetsBottomBar*) self);
}

static void
_audience_widgets_bottom_bar___lambda51_ (Block15Data* _data15_,
                                          const gchar* name,
                                          GVariant* new_state)
{
	AudienceWidgetsBottomBar* self;
	self = _data15_->self;
	g_return_if_fail (name != NULL);
	g_return_if_fail (new_state != NULL);
	if (g_strcmp0 (name, AUDIENCE_APP_ACTION_PLAY_PAUSE) == 0) {
		if (g_variant_get_boolean (new_state) == FALSE) {
			GtkButton* _tmp0_;
			GtkButton* _tmp1_;
			_tmp0_ = _data15_->play_button;
			gtk_button_set_icon_name (_tmp0_, "media-playback-start-symbolic");
			_tmp1_ = _data15_->play_button;
			gtk_widget_set_tooltip_text ((GtkWidget*) _tmp1_, _ ("Play"));
		} else {
			GtkButton* _tmp2_;
			GtkButton* _tmp3_;
			_tmp2_ = _data15_->play_button;
			gtk_button_set_icon_name (_tmp2_, "media-playback-pause-symbolic");
			_tmp3_ = _data15_->play_button;
			gtk_widget_set_tooltip_text ((GtkWidget*) _tmp3_, _ ("Pause"));
		}
		g_object_notify ((GObject*) self, "should-stay-revealed");
	}
}

static void
__audience_widgets_bottom_bar___lambda51__g_action_group_action_state_changed (GActionGroup* _sender,
                                                                               const gchar* action_name,
                                                                               GVariant* state,
                                                                               gpointer self)
{
	_audience_widgets_bottom_bar___lambda51_ (self, action_name, state);
}

static void
_audience_widgets_bottom_bar___lambda52_ (Block15Data* _data15_)
{
	AudienceWidgetsBottomBar* self;
	GtkLabel* _tmp0_;
	AudiencePlaybackManager* _tmp1_;
	gint64 _tmp2_;
	gint64 _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GtkScale* _tmp6_;
	AudiencePlaybackManager* _tmp7_;
	gint64 _tmp8_;
	gint64 _tmp9_;
	self = _data15_->self;
	_tmp0_ = _data15_->progression_label;
	_tmp1_ = _data15_->playback_manager;
	_tmp2_ = audience_playback_manager_get_position (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = granite_date_time_seconds_to_time ((gint) (_tmp3_ / 1000000000));
	_tmp5_ = _tmp4_;
	gtk_label_set_label (_tmp0_, _tmp5_);
	_g_free0 (_tmp5_);
	_tmp6_ = _data15_->scale;
	_tmp7_ = _data15_->playback_manager;
	_tmp8_ = audience_playback_manager_get_position (_tmp7_);
	_tmp9_ = _tmp8_;
	gtk_range_set_value ((GtkRange*) _tmp6_, (gdouble) _tmp9_);
}

static void
__audience_widgets_bottom_bar___lambda52__g_object_notify (GObject* _sender,
                                                           GParamSpec* pspec,
                                                           gpointer self)
{
	_audience_widgets_bottom_bar___lambda52_ (self);
}

static void
_audience_widgets_bottom_bar___lambda53_ (Block15Data* _data15_)
{
	AudienceWidgetsBottomBar* self;
	AudiencePlaybackManager* _tmp0_;
	gint64 _tmp1_;
	gint64 _tmp2_;
	GtkScale* _tmp3_;
	GtkLabel* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GtkScale* _tmp7_;
	AudiencePlaybackManager* _tmp8_;
	gint64 _tmp9_;
	gint64 _tmp10_;
	gboolean _tmp11_;
	gboolean _tmp12_;
	self = _data15_->self;
	_tmp0_ = _data15_->playback_manager;
	_tmp1_ = audience_playback_manager_get_duration (_tmp0_);
	_tmp2_ = _tmp1_;
	self->priv->playback_duration = (gdouble) _tmp2_;
	if (self->priv->playback_duration < ((gdouble) 0)) {
		g_debug ("BottomBar.vala:127: Duration value less than zero, duration set to 0.0");
		self->priv->playback_duration = (gdouble) 0;
	}
	_tmp3_ = _data15_->scale;
	gtk_range_set_range ((GtkRange*) _tmp3_, (gdouble) 0, self->priv->playback_duration);
	_tmp4_ = _data15_->duration_label;
	_tmp5_ = granite_date_time_seconds_to_time ((gint) (self->priv->playback_duration / 1000000000));
	_tmp6_ = _tmp5_;
	gtk_label_set_label (_tmp4_, _tmp6_);
	_g_free0 (_tmp6_);
	_tmp7_ = _data15_->scale;
	_tmp8_ = _data15_->playback_manager;
	_tmp9_ = audience_playback_manager_get_position (_tmp8_);
	_tmp10_ = _tmp9_;
	gtk_range_set_value ((GtkRange*) _tmp7_, (gdouble) _tmp10_);
	gtk_widget_set_sensitive ((GtkWidget*) self, self->priv->playback_duration > ((gdouble) 0));
	_tmp11_ = gtk_widget_get_sensitive ((GtkWidget*) self);
	_tmp12_ = _tmp11_;
	if (_tmp12_) {
		AudienceWidgetsPreviewPopover* _tmp13_;
		AudiencePlaybackManager* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		_tmp13_ = self->priv->preview_popover;
		_tmp14_ = _data15_->playback_manager;
		_tmp15_ = audience_playback_manager_get_uri (_tmp14_);
		_tmp16_ = _tmp15_;
		audience_widgets_preview_popover_set_playback_uri (_tmp13_, _tmp16_);
		_g_free0 (_tmp16_);
	}
}

static void
__audience_widgets_bottom_bar___lambda53__g_object_notify (GObject* _sender,
                                                           GParamSpec* pspec,
                                                           gpointer self)
{
	_audience_widgets_bottom_bar___lambda53_ (self);
}

static void
_audience_widgets_preview_popover_schedule_show_gtk_event_controller_motion_enter (GtkEventControllerMotion* _sender,
                                                                                   gdouble x,
                                                                                   gdouble y,
                                                                                   gpointer self)
{
	audience_widgets_preview_popover_schedule_show ((AudienceWidgetsPreviewPopover*) self);
}

static void
_audience_widgets_preview_popover_schedule_hide_gtk_event_controller_motion_leave (GtkEventControllerMotion* _sender,
                                                                                   gpointer self)
{
	audience_widgets_preview_popover_schedule_hide ((AudienceWidgetsPreviewPopover*) self);
}

static void
_audience_widgets_bottom_bar___lambda54_ (Block15Data* _data15_,
                                          gdouble x,
                                          gdouble y)
{
	AudienceWidgetsBottomBar* self;
	AudienceWidgetsPreviewPopover* _tmp0_;
	GdkRectangle _tmp1_ = {0};
	AudienceWidgetsPreviewPopover* _tmp2_;
	GtkScale* _tmp3_;
	AudiencePlaybackManager* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	self = _data15_->self;
	_tmp0_ = self->priv->preview_popover;
	memset (&_tmp1_, 0, sizeof (GdkRectangle));
	_tmp1_.x = (gint) x;
	g_object_set ((GtkPopover*) _tmp0_, "pointing-to", &_tmp1_, NULL);
	_tmp2_ = self->priv->preview_popover;
	_tmp3_ = _data15_->scale;
	_tmp4_ = _data15_->playback_manager;
	_tmp5_ = audience_playback_manager_get_playing (_tmp4_);
	_tmp6_ = _tmp5_;
	audience_widgets_preview_popover_set_preview_position (_tmp2_, (gint64) ((x / gtk_widget_get_allocated_width ((GtkWidget*) _tmp3_)) * self->priv->playback_duration), !_tmp6_);
}

static void
__audience_widgets_bottom_bar___lambda54__gtk_event_controller_motion_motion (GtkEventControllerMotion* _sender,
                                                                              gdouble x,
                                                                              gdouble y,
                                                                              gpointer self)
{
	_audience_widgets_bottom_bar___lambda54_ (self, x, y);
}

static gboolean
_audience_widgets_bottom_bar___lambda55_ (Block15Data* _data15_,
                                          GtkScrollType scroll,
                                          gdouble new_value)
{
	AudienceWidgetsBottomBar* self;
	AudiencePlaybackManager* _tmp0_;
	gboolean result;
	self = _data15_->self;
	_tmp0_ = _data15_->playback_manager;
	audience_playback_manager_seek (_tmp0_, (gint64) new_value);
	result = TRUE;
	return result;
}

static gboolean
__audience_widgets_bottom_bar___lambda55__gtk_range_change_value (GtkRange* _sender,
                                                                  GtkScrollType scroll,
                                                                  gdouble new_value,
                                                                  gpointer self)
{
	gboolean result;
	result = _audience_widgets_bottom_bar___lambda55_ (self, scroll, new_value);
	return result;
}

static GObject *
audience_widgets_bottom_bar_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	AudienceWidgetsBottomBar * self;
	Block15Data* _data15_;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GtkButton* _tmp2_ = NULL;
	AudienceWidgetsPlaylistPopover* _tmp3_;
	GtkMenuButton* playlist_button = NULL;
	gchar* _tmp4_;
	AudienceWidgetsPlaylistPopover* _tmp5_;
	GtkPopover* _tmp6_;
	gchar* _tmp7_;
	GtkMenuButton* _tmp8_ = NULL;
	AudienceWidgetsSettingsPopover* _tmp9_;
	GtkMenuButton* settings_button = NULL;
	gchar* _tmp10_;
	AudienceWidgetsSettingsPopover* _tmp11_;
	GtkPopover* _tmp12_;
	gchar* _tmp13_;
	GtkMenuButton* _tmp14_ = NULL;
	gchar* _tmp15_;
	gchar* _tmp16_;
	GtkLabel* _tmp17_;
	GtkLabel* _tmp18_;
	GtkLabel* _tmp19_;
	GtkScale* _tmp20_ = NULL;
	AudienceWidgetsPreviewPopover* _tmp21_;
	AudienceWidgetsPreviewPopover* _tmp22_;
	GtkScale* _tmp23_;
	GtkButton* _tmp24_;
	GtkLabel* _tmp25_;
	GtkScale* _tmp26_;
	GtkLabel* _tmp27_;
	GtkMenuButton* _tmp28_;
	GtkMenuButton* _tmp29_;
	GtkEventControllerMotion* motion_controller = NULL;
	GtkEventControllerMotion* _tmp30_;
	GtkEventControllerMotion* _tmp31_;
	GtkEventController* _tmp32_;
	GtkEventControllerMotion* _tmp33_;
	GtkEventControllerMotion* _tmp34_;
	AudienceWidgetsPlaylistPopover* _tmp35_;
	AudienceWidgetsSettingsPopover* _tmp36_;
	GApplication* _tmp37_;
	AudiencePlaybackManager* _tmp38_;
	AudiencePlaybackManager* _tmp39_;
	AudiencePlaybackManager* _tmp40_;
	AudiencePlaybackManager* _tmp41_;
	GtkEventControllerMotion* scale_motion_controller = NULL;
	GtkEventControllerMotion* _tmp42_;
	GtkScale* _tmp43_;
	GtkEventControllerMotion* _tmp44_;
	GtkEventController* _tmp45_;
	GtkEventControllerMotion* _tmp46_;
	AudienceWidgetsPreviewPopover* _tmp47_;
	GtkEventControllerMotion* _tmp48_;
	AudienceWidgetsPreviewPopover* _tmp49_;
	GtkEventControllerMotion* _tmp50_;
	GtkScale* _tmp51_;
	parent_class = G_OBJECT_CLASS (audience_widgets_bottom_bar_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, AUDIENCE_WIDGETS_TYPE_BOTTOM_BAR, AudienceWidgetsBottomBar);
	_data15_ = g_slice_new0 (Block15Data);
	_data15_->_ref_count_ = 1;
	_data15_->self = g_object_ref (self);
	_tmp0_ = g_strdup (AUDIENCE_APP_ACTION_PREFIX AUDIENCE_APP_ACTION_PLAY_PAUSE);
	_tmp1_ = g_strdup (_ ("Play"));
	_tmp2_ = (GtkButton*) gtk_button_new_from_icon_name ("media-playback-start-symbolic");
	gtk_actionable_set_action_name ((GtkActionable*) _tmp2_, _tmp0_);
	_g_free0 (_tmp0_);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp2_, _tmp1_);
	_g_free0 (_tmp1_);
	g_object_ref_sink (_tmp2_);
	_data15_->play_button = _tmp2_;
	_tmp3_ = audience_widgets_playlist_popover_new ();
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->playlist_popover);
	self->priv->playlist_popover = _tmp3_;
	_tmp4_ = g_strdup ("view-list-symbolic");
	_tmp5_ = self->priv->playlist_popover;
	_tmp6_ = _g_object_ref0 ((GtkPopover*) _tmp5_);
	_tmp7_ = g_strdup (_ ("Playlist"));
	_tmp8_ = (GtkMenuButton*) gtk_menu_button_new ();
	gtk_menu_button_set_icon_name (_tmp8_, _tmp4_);
	_g_free0 (_tmp4_);
	gtk_menu_button_set_popover (_tmp8_, _tmp6_);
	_g_object_unref0 (_tmp6_);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp8_, _tmp7_);
	_g_free0 (_tmp7_);
	gtk_menu_button_set_direction (_tmp8_, GTK_ARROW_UP);
	g_object_ref_sink (_tmp8_);
	playlist_button = _tmp8_;
	_tmp9_ = audience_widgets_settings_popover_new ();
	g_object_ref_sink (_tmp9_);
	_g_object_unref0 (self->priv->settings_popover);
	self->priv->settings_popover = _tmp9_;
	_tmp10_ = g_strdup ("open-menu-symbolic");
	_tmp11_ = self->priv->settings_popover;
	_tmp12_ = _g_object_ref0 ((GtkPopover*) _tmp11_);
	_tmp13_ = g_strdup_printf ("%s\n" GRANITE_TOOLTIP_SECONDARY_TEXT_MARKUP, _ ("Settings"), "F10");
	_tmp14_ = (GtkMenuButton*) gtk_menu_button_new ();
	gtk_menu_button_set_icon_name (_tmp14_, _tmp10_);
	_g_free0 (_tmp10_);
	gtk_menu_button_set_popover (_tmp14_, _tmp12_);
	_g_object_unref0 (_tmp12_);
	gtk_menu_button_set_primary (_tmp14_, TRUE);
	gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp14_, _tmp13_);
	_g_free0 (_tmp13_);
	gtk_menu_button_set_direction (_tmp14_, GTK_ARROW_UP);
	g_object_ref_sink (_tmp14_);
	settings_button = _tmp14_;
	_tmp15_ = granite_date_time_seconds_to_time (0);
	_tmp16_ = _tmp15_;
	_tmp17_ = (GtkLabel*) gtk_label_new (_tmp16_);
	g_object_ref_sink (_tmp17_);
	_tmp18_ = _tmp17_;
	_g_free0 (_tmp16_);
	_data15_->progression_label = _tmp18_;
	_tmp19_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp19_);
	_data15_->duration_label = _tmp19_;
	_tmp20_ = (GtkScale*) gtk_scale_new (GTK_ORIENTATION_HORIZONTAL, NULL);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp20_, TRUE);
	gtk_scale_set_draw_value (_tmp20_, FALSE);
	gtk_widget_set_can_focus ((GtkWidget*) _tmp20_, FALSE);
	g_object_ref_sink (_tmp20_);
	_data15_->scale = _tmp20_;
	_tmp21_ = audience_widgets_preview_popover_new ();
	g_object_ref_sink (_tmp21_);
	_g_object_unref0 (self->priv->preview_popover);
	self->priv->preview_popover = _tmp21_;
	_tmp22_ = self->priv->preview_popover;
	_tmp23_ = _data15_->scale;
	gtk_widget_set_parent ((GtkWidget*) _tmp22_, (GtkWidget*) _tmp23_);
	_tmp24_ = _data15_->play_button;
	gtk_box_append ((GtkBox*) self, (GtkWidget*) _tmp24_);
	_tmp25_ = _data15_->progression_label;
	gtk_box_append ((GtkBox*) self, (GtkWidget*) _tmp25_);
	_tmp26_ = _data15_->scale;
	gtk_box_append ((GtkBox*) self, (GtkWidget*) _tmp26_);
	_tmp27_ = _data15_->duration_label;
	gtk_box_append ((GtkBox*) self, (GtkWidget*) _tmp27_);
	_tmp28_ = settings_button;
	gtk_box_append ((GtkBox*) self, (GtkWidget*) _tmp28_);
	_tmp29_ = playlist_button;
	gtk_box_append ((GtkBox*) self, (GtkWidget*) _tmp29_);
	_tmp30_ = (GtkEventControllerMotion*) gtk_event_controller_motion_new ();
	motion_controller = _tmp30_;
	_tmp31_ = motion_controller;
	_tmp32_ = _g_object_ref0 ((GtkEventController*) _tmp31_);
	gtk_widget_add_controller ((GtkWidget*) self, _tmp32_);
	_tmp33_ = motion_controller;
	g_signal_connect_object (_tmp33_, "enter", (GCallback) __audience_widgets_bottom_bar___lambda47__gtk_event_controller_motion_enter, self, 0);
	_tmp34_ = motion_controller;
	g_signal_connect_object (_tmp34_, "leave", (GCallback) __audience_widgets_bottom_bar___lambda48__gtk_event_controller_motion_leave, self, 0);
	_tmp35_ = self->priv->playlist_popover;
	g_signal_connect_object ((GObject*) _tmp35_, "notify::visible", (GCallback) __audience_widgets_bottom_bar___lambda49__g_object_notify, self, 0);
	_tmp36_ = self->priv->settings_popover;
	g_signal_connect_object ((GObject*) _tmp36_, "notify::visible", (GCallback) __audience_widgets_bottom_bar___lambda50__g_object_notify, self, 0);
	_tmp37_ = g_application_get_default ();
	g_signal_connect_data ((GActionGroup*) _tmp37_, "action-state-changed", (GCallback) __audience_widgets_bottom_bar___lambda51__g_action_group_action_state_changed, block15_data_ref (_data15_), (GClosureNotify) block15_data_unref, 0);
	_tmp38_ = audience_playback_manager_get_default ();
	_tmp39_ = _g_object_ref0 (_tmp38_);
	_data15_->playback_manager = _tmp39_;
	_tmp40_ = _data15_->playback_manager;
	g_signal_connect_data ((GObject*) _tmp40_, "notify::position", (GCallback) __audience_widgets_bottom_bar___lambda52__g_object_notify, block15_data_ref (_data15_), (GClosureNotify) block15_data_unref, 0);
	_tmp41_ = _data15_->playback_manager;
	g_signal_connect_data ((GObject*) _tmp41_, "notify::duration", (GCallback) __audience_widgets_bottom_bar___lambda53__g_object_notify, block15_data_ref (_data15_), (GClosureNotify) block15_data_unref, 0);
	_tmp42_ = (GtkEventControllerMotion*) gtk_event_controller_motion_new ();
	scale_motion_controller = _tmp42_;
	_tmp43_ = _data15_->scale;
	_tmp44_ = scale_motion_controller;
	_tmp45_ = _g_object_ref0 ((GtkEventController*) _tmp44_);
	gtk_widget_add_controller ((GtkWidget*) _tmp43_, _tmp45_);
	_tmp46_ = scale_motion_controller;
	_tmp47_ = self->priv->preview_popover;
	g_signal_connect_object (_tmp46_, "enter", (GCallback) _audience_widgets_preview_popover_schedule_show_gtk_event_controller_motion_enter, _tmp47_, 0);
	_tmp48_ = scale_motion_controller;
	_tmp49_ = self->priv->preview_popover;
	g_signal_connect_object (_tmp48_, "leave", (GCallback) _audience_widgets_preview_popover_schedule_hide_gtk_event_controller_motion_leave, _tmp49_, 0);
	_tmp50_ = scale_motion_controller;
	g_signal_connect_data (_tmp50_, "motion", (GCallback) __audience_widgets_bottom_bar___lambda54__gtk_event_controller_motion_motion, block15_data_ref (_data15_), (GClosureNotify) block15_data_unref, 0);
	_tmp51_ = _data15_->scale;
	g_signal_connect_data ((GtkRange*) _tmp51_, "change-value", (GCallback) __audience_widgets_bottom_bar___lambda55__gtk_range_change_value, block15_data_ref (_data15_), (GClosureNotify) block15_data_unref, 0);
	_g_object_unref0 (scale_motion_controller);
	_g_object_unref0 (motion_controller);
	_g_object_unref0 (settings_button);
	_g_object_unref0 (playlist_button);
	block15_data_unref (_data15_);
	_data15_ = NULL;
	return obj;
}

static void
audience_widgets_bottom_bar_base_init (AudienceWidgetsBottomBarClass * klass)
{
	gtk_widget_class_set_css_name (GTK_WIDGET_CLASS (klass), "mediacontrols");
}

static void
audience_widgets_bottom_bar_class_init (AudienceWidgetsBottomBarClass * klass,
                                        gpointer klass_data)
{
	audience_widgets_bottom_bar_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &AudienceWidgetsBottomBar_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_audience_widgets_bottom_bar_get_property;
	G_OBJECT_CLASS (klass)->constructor = audience_widgets_bottom_bar_constructor;
	G_OBJECT_CLASS (klass)->finalize = audience_widgets_bottom_bar_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), AUDIENCE_WIDGETS_BOTTOM_BAR_SHOULD_STAY_REVEALED_PROPERTY, audience_widgets_bottom_bar_properties[AUDIENCE_WIDGETS_BOTTOM_BAR_SHOULD_STAY_REVEALED_PROPERTY] = g_param_spec_boolean ("should-stay-revealed", "should-stay-revealed", "should-stay-revealed", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
audience_widgets_bottom_bar_instance_init (AudienceWidgetsBottomBar * self,
                                           gpointer klass)
{
	self->priv = audience_widgets_bottom_bar_get_instance_private (self);
}

static void
audience_widgets_bottom_bar_finalize (GObject * obj)
{
	AudienceWidgetsBottomBar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, AUDIENCE_WIDGETS_TYPE_BOTTOM_BAR, AudienceWidgetsBottomBar);
	_g_object_unref0 (self->priv->preview_popover);
	_g_object_unref0 (self->priv->playlist_popover);
	_g_object_unref0 (self->priv->settings_popover);
	G_OBJECT_CLASS (audience_widgets_bottom_bar_parent_class)->finalize (obj);
}

static GType
audience_widgets_bottom_bar_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AudienceWidgetsBottomBarClass), (GBaseInitFunc) audience_widgets_bottom_bar_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) audience_widgets_bottom_bar_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AudienceWidgetsBottomBar), 0, (GInstanceInitFunc) audience_widgets_bottom_bar_instance_init, NULL };
	GType audience_widgets_bottom_bar_type_id;
	audience_widgets_bottom_bar_type_id = g_type_register_static (gtk_box_get_type (), "AudienceWidgetsBottomBar", &g_define_type_info, 0);
	AudienceWidgetsBottomBar_private_offset = g_type_add_instance_private (audience_widgets_bottom_bar_type_id, sizeof (AudienceWidgetsBottomBarPrivate));
	return audience_widgets_bottom_bar_type_id;
}

GType
audience_widgets_bottom_bar_get_type (void)
{
	static volatile gsize audience_widgets_bottom_bar_type_id__once = 0;
	if (g_once_init_enter (&audience_widgets_bottom_bar_type_id__once)) {
		GType audience_widgets_bottom_bar_type_id;
		audience_widgets_bottom_bar_type_id = audience_widgets_bottom_bar_get_type_once ();
		g_once_init_leave (&audience_widgets_bottom_bar_type_id__once, audience_widgets_bottom_bar_type_id);
	}
	return audience_widgets_bottom_bar_type_id__once;
}

static void
_vala_audience_widgets_bottom_bar_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec)
{
	AudienceWidgetsBottomBar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, AUDIENCE_WIDGETS_TYPE_BOTTOM_BAR, AudienceWidgetsBottomBar);
	switch (property_id) {
		case AUDIENCE_WIDGETS_BOTTOM_BAR_SHOULD_STAY_REVEALED_PROPERTY:
		g_value_set_boolean (value, audience_widgets_bottom_bar_get_should_stay_revealed (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

