/* CameraView.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from CameraView.vala, do not modify */

/*
 * Copyright (c) 2011-2019 elementary, inc. (https://elementary.io)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA.
 *
 * Authored by: Marcus Wichelmann <marcus.wichelmann@hotmail.de>
 *              Corentin Noël <corentin@elementary.io>
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <granite-7.h>
#include <gst/gst.h>
#include <gst/video/video.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <gst/pbutils/pbutils.h>
#include <canberra.h>

#define CAMERA_WIDGETS_CAMERA_VIEW_VIDEO_SRC_NAME "v4l2src"
#define CAMERA_MAIN_WINDOW_ACTION_CHANGE_CAMERA "change_camera"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define CAMERA_WIDGETS_TYPE_CAMERA_VIEW (camera_widgets_camera_view_get_type ())
#define CAMERA_WIDGETS_CAMERA_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CAMERA_WIDGETS_TYPE_CAMERA_VIEW, CameraWidgetsCameraView))
#define CAMERA_WIDGETS_CAMERA_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CAMERA_WIDGETS_TYPE_CAMERA_VIEW, CameraWidgetsCameraViewClass))
#define CAMERA_WIDGETS_IS_CAMERA_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CAMERA_WIDGETS_TYPE_CAMERA_VIEW))
#define CAMERA_WIDGETS_IS_CAMERA_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CAMERA_WIDGETS_TYPE_CAMERA_VIEW))
#define CAMERA_WIDGETS_CAMERA_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CAMERA_WIDGETS_TYPE_CAMERA_VIEW, CameraWidgetsCameraViewClass))

typedef struct _CameraWidgetsCameraView CameraWidgetsCameraView;
typedef struct _CameraWidgetsCameraViewClass CameraWidgetsCameraViewClass;
typedef struct _CameraWidgetsCameraViewPrivate CameraWidgetsCameraViewPrivate;
enum  {
	CAMERA_WIDGETS_CAMERA_VIEW_0_PROPERTY,
	CAMERA_WIDGETS_CAMERA_VIEW_N_CAMERAS_PROPERTY,
	CAMERA_WIDGETS_CAMERA_VIEW_RECORDING_PROPERTY,
	CAMERA_WIDGETS_CAMERA_VIEW_HORIZONTAL_FLIP_PROPERTY,
	CAMERA_WIDGETS_CAMERA_VIEW_NUM_PROPERTIES
};
static GParamSpec* camera_widgets_camera_view_properties[CAMERA_WIDGETS_CAMERA_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define CAMERA_TYPE_MAIN_WINDOW (camera_main_window_get_type ())
#define CAMERA_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CAMERA_TYPE_MAIN_WINDOW, CameraMainWindow))
#define CAMERA_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CAMERA_TYPE_MAIN_WINDOW, CameraMainWindowClass))
#define CAMERA_IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CAMERA_TYPE_MAIN_WINDOW))
#define CAMERA_IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CAMERA_TYPE_MAIN_WINDOW))
#define CAMERA_MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CAMERA_TYPE_MAIN_WINDOW, CameraMainWindowClass))

typedef struct _CameraMainWindow CameraMainWindow;
typedef struct _CameraMainWindowClass CameraMainWindowClass;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _gst_caps_unref0(var) ((var == NULL) ? NULL : (var = (gst_caps_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block6Data Block6Data;
typedef enum  {
	CAMERA_UTILS_ACTION_TYPE_PHOTO,
	CAMERA_UTILS_ACTION_TYPE_VIDEO
} CameraUtilsActionType;

#define CAMERA_UTILS_TYPE_ACTION_TYPE (camera_utils_action_type_get_type ())
#define _ca_context_destroy0(var) ((var == NULL) ? NULL : (var = (ca_context_destroy (var), NULL)))
#define _ca_proplist_destroy0(var) ((var == NULL) ? NULL : (var = (ca_proplist_destroy (var), NULL)))
enum  {
	CAMERA_WIDGETS_CAMERA_VIEW_RECORDING_FINISHED_SIGNAL,
	CAMERA_WIDGETS_CAMERA_VIEW_CAMERA_ADDED_SIGNAL,
	CAMERA_WIDGETS_CAMERA_VIEW_CAMERA_REMOVED_SIGNAL,
	CAMERA_WIDGETS_CAMERA_VIEW_NUM_SIGNALS
};
static guint camera_widgets_camera_view_signals[CAMERA_WIDGETS_CAMERA_VIEW_NUM_SIGNALS] = {0};

struct _CameraWidgetsCameraView {
	GtkBox parent_instance;
	CameraWidgetsCameraViewPrivate * priv;
};

struct _CameraWidgetsCameraViewClass {
	GtkBoxClass parent_class;
};

struct _CameraWidgetsCameraViewPrivate {
	GtkStack* stack;
	GtkBox* status_box;
	GranitePlaceholder* no_device_view;
	GtkLabel* status_label;
	GtkPicture* picture;
	GstPipeline* pipeline;
	GstElement* tee;
	GstColorBalance* color_balance;
	GstVideoDirection* hflip;
	GstBin* record_bin;
	GstDevice* current_device;
	guint init_device_timeout_id;
	gint picture_width;
	gint picture_height;
	GstDeviceMonitor* monitor;
	gboolean _recording;
};

struct _Block6Data {
	int _ref_count_;
	CameraWidgetsCameraView* self;
	GstPipeline* picture_pipeline;
};

static gint CameraWidgetsCameraView_private_offset;
static gpointer camera_widgets_camera_view_parent_class = NULL;

VALA_EXTERN GType camera_widgets_camera_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CameraWidgetsCameraView, g_object_unref)
static void camera_widgets_camera_view_on_camera_added (CameraWidgetsCameraView* self,
                                                 GstDevice* device);
VALA_EXTERN void camera_widgets_camera_view_change_camera (CameraWidgetsCameraView* self,
                                               GstDevice* camera);
static void camera_widgets_camera_view_on_camera_removed (CameraWidgetsCameraView* self,
                                                   GstDevice* device);
VALA_EXTERN guint camera_widgets_camera_view_get_n_cameras (CameraWidgetsCameraView* self);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static gboolean camera_widgets_camera_view_on_bus_message (CameraWidgetsCameraView* self,
                                                    GstBus* bus,
                                                    GstMessage* message);
VALA_EXTERN void camera_widgets_camera_view_start (CameraWidgetsCameraView* self);
static void __lambda5_ (CameraWidgetsCameraView* self,
                 GstDevice* dev);
static void ___lambda5__gfunc (gconstpointer data,
                        gpointer self);
VALA_EXTERN gboolean camera_widgets_camera_view_get_recording (CameraWidgetsCameraView* self);
VALA_EXTERN void camera_widgets_camera_view_stop_recording (CameraWidgetsCameraView* self);
static void camera_widgets_camera_view_create_pipeline (CameraWidgetsCameraView* self,
                                                 GstDevice* camera);
VALA_EXTERN GType camera_main_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CameraMainWindow, g_object_unref)
static void _gtk_window_destroy_gtk_dialog_response (GtkDialog* _sender,
                                              gint response_id,
                                              gpointer self);
VALA_EXTERN void camera_widgets_camera_view_change_color_balance (CameraWidgetsCameraView* self,
                                                      gdouble brightnesss,
                                                      gdouble contrast);
VALA_EXTERN void camera_widgets_camera_view_take_photo (CameraWidgetsCameraView* self);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static void camera_widgets_camera_view_set_recording (CameraWidgetsCameraView* self,
                                               gboolean value);
VALA_EXTERN gboolean camera_widgets_camera_view_get_horizontal_flip (CameraWidgetsCameraView* self);
VALA_EXTERN GType camera_utils_action_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gchar* camera_utils_get_new_media_filename (CameraUtilsActionType action_type);
static GstPadProbeReturn __lambda6_ (Block6Data* _data6_,
                              GstPad* pad,
                              GstPadProbeInfo* info);
static gboolean ___lambda7_ (Block6Data* _data6_);
static void camera_widgets_camera_view_play_shutter_sound (void);
static gboolean ____lambda7__gsource_func (gpointer self);
static GstPadProbeReturn ___lambda6__gst_pad_probe_callback (GstPad* pad,
                                                      GstPadProbeInfo* info,
                                                      gpointer self);
VALA_EXTERN void camera_widgets_camera_view_start_recording (CameraWidgetsCameraView* self);
static void _vala_array_add1 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add2 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add3 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add4 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add5 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add6 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add7 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void ___lambda8_ (CameraWidgetsCameraView* self,
                  GstInstallPluginsReturn _result_);
static void ____lambda8__gst_install_plugins_result_func (GstInstallPluginsReturn _result_,
                                                   gpointer self);
VALA_EXTERN CameraWidgetsCameraView* camera_widgets_camera_view_new (void);
VALA_EXTERN CameraWidgetsCameraView* camera_widgets_camera_view_construct (GType object_type);
VALA_EXTERN void camera_widgets_camera_view_set_horizontal_flip (CameraWidgetsCameraView* self,
                                                     gboolean value);
static GObject * camera_widgets_camera_view_constructor (GType type,
                                                  guint n_construct_properties,
                                                  GObjectConstructParam * construct_properties);
static gboolean _camera_widgets_camera_view_on_bus_message_gst_bus_func (GstBus* bus,
                                                                  GstMessage* message,
                                                                  gpointer self);
static gboolean _camera_widgets_camera_view___lambda9_ (CameraWidgetsCameraView* self);
static gboolean __camera_widgets_camera_view___lambda9__gsource_func (gpointer self);
static void camera_widgets_camera_view_finalize (GObject * obj);
static GType camera_widgets_camera_view_get_type_once (void);
static void _vala_camera_widgets_camera_view_get_property (GObject * object,
                                                    guint property_id,
                                                    GValue * value,
                                                    GParamSpec * pspec);
static void _vala_camera_widgets_camera_view_set_property (GObject * object,
                                                    guint property_id,
                                                    const GValue * value,
                                                    GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
camera_widgets_camera_view_get_instance_private (CameraWidgetsCameraView* self)
{
	return G_STRUCT_MEMBER_P (self, CameraWidgetsCameraView_private_offset);
}

static void
camera_widgets_camera_view_on_camera_added (CameraWidgetsCameraView* self,
                                            GstDevice* device)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (device != NULL);
	if (self->priv->init_device_timeout_id > ((guint) 0)) {
		g_source_remove (self->priv->init_device_timeout_id);
		self->priv->init_device_timeout_id = (guint) 0;
	}
	g_signal_emit (self, camera_widgets_camera_view_signals[CAMERA_WIDGETS_CAMERA_VIEW_CAMERA_ADDED_SIGNAL], 0, device);
	camera_widgets_camera_view_change_camera (self, device);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
camera_widgets_camera_view_on_camera_removed (CameraWidgetsCameraView* self,
                                              GstDevice* device)
{
	guint _tmp0_;
	guint _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (device != NULL);
	g_signal_emit (self, camera_widgets_camera_view_signals[CAMERA_WIDGETS_CAMERA_VIEW_CAMERA_REMOVED_SIGNAL], 0, device);
	_tmp0_ = camera_widgets_camera_view_get_n_cameras (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == ((guint) 0)) {
		GranitePlaceholder* _tmp2_;
		GtkStack* _tmp3_;
		GranitePlaceholder* _tmp4_;
		_tmp2_ = self->priv->no_device_view;
		gtk_widget_show ((GtkWidget*) _tmp2_);
		_tmp3_ = self->priv->stack;
		_tmp4_ = self->priv->no_device_view;
		gtk_stack_set_visible_child (_tmp3_, (GtkWidget*) _tmp4_);
	} else {
		GstDeviceMonitor* _tmp5_;
		GList* _tmp6_;
		GList* _tmp7_;
		gconstpointer _tmp8_;
		_tmp5_ = self->priv->monitor;
		_tmp6_ = gst_device_monitor_get_devices (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_list_nth_data (_tmp7_, (guint) 0);
		camera_widgets_camera_view_change_camera (self, (GstDevice*) _tmp8_);
		(_tmp7_ == NULL) ? NULL : (_tmp7_ = (_g_list_free__g_object_unref0_ (_tmp7_), NULL));
	}
}

static gboolean
camera_widgets_camera_view_on_bus_message (CameraWidgetsCameraView* self,
                                           GstBus* bus,
                                           GstMessage* message)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (bus != NULL, FALSE);
	g_return_val_if_fail (message != NULL, FALSE);
	switch (message->type) {
		case GST_MESSAGE_DEVICE_ADDED:
		{
			GstDevice* device = NULL;
			GstDevice* _tmp0_ = NULL;
			GstDevice* _tmp1_;
			gst_message_parse_device_added (message, &_tmp0_);
			_g_object_unref0 (device);
			device = _tmp0_;
			_tmp1_ = device;
			camera_widgets_camera_view_on_camera_added (self, _tmp1_);
			_g_object_unref0 (device);
			break;
		}
		case GST_MESSAGE_DEVICE_CHANGED:
		{
			GstDevice* device = NULL;
			GstDevice* changed_device = NULL;
			GstDevice* _tmp2_ = NULL;
			GstDevice* _tmp3_ = NULL;
			GstDevice* _tmp4_;
			GstDevice* _tmp5_;
			gst_message_parse_device_changed (message, &_tmp2_, &_tmp3_);
			_g_object_unref0 (device);
			device = _tmp2_;
			_g_object_unref0 (changed_device);
			changed_device = _tmp3_;
			_tmp4_ = changed_device;
			camera_widgets_camera_view_on_camera_removed (self, _tmp4_);
			_tmp5_ = device;
			camera_widgets_camera_view_on_camera_added (self, _tmp5_);
			_g_object_unref0 (changed_device);
			_g_object_unref0 (device);
			break;
		}
		case GST_MESSAGE_DEVICE_REMOVED:
		{
			GstDevice* device = NULL;
			GstDevice* _tmp6_ = NULL;
			GstDevice* _tmp7_;
			gst_message_parse_device_removed (message, &_tmp6_);
			_g_object_unref0 (device);
			device = _tmp6_;
			_tmp7_ = device;
			camera_widgets_camera_view_on_camera_removed (self, _tmp7_);
			_g_object_unref0 (device);
			break;
		}
		default:
		{
			break;
		}
	}
	result = G_SOURCE_CONTINUE;
	return result;
}

static void
__lambda5_ (CameraWidgetsCameraView* self,
            GstDevice* dev)
{
	g_return_if_fail (dev != NULL);
	camera_widgets_camera_view_on_camera_added (self, dev);
}

static void
___lambda5__gfunc (gconstpointer data,
                   gpointer self)
{
	__lambda5_ ((CameraWidgetsCameraView*) self, (GstDevice*) data);
}

void
camera_widgets_camera_view_start (CameraWidgetsCameraView* self)
{
	GstDeviceMonitor* _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
	GstDeviceMonitor* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->monitor;
	_tmp1_ = gst_device_monitor_get_devices (_tmp0_);
	_tmp2_ = _tmp1_;
	g_list_foreach (_tmp2_, ___lambda5__gfunc, self);
	(_tmp2_ == NULL) ? NULL : (_tmp2_ = (_g_list_free__g_object_unref0_ (_tmp2_), NULL));
	_tmp3_ = self->priv->monitor;
	gst_device_monitor_start (_tmp3_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
camera_widgets_camera_view_change_camera (CameraWidgetsCameraView* self,
                                          GstDevice* camera)
{
	GtkStack* _tmp0_;
	GtkBox* _tmp1_;
	GtkLabel* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gboolean _tmp8_;
	GstBin* _tmp9_;
	GstPipeline* _tmp13_;
	GstDevice* _tmp17_;
	GtkRoot* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	GVariant* _tmp22_;
	GVariant* _tmp23_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (camera != NULL);
	_tmp0_ = self->priv->stack;
	_tmp1_ = self->priv->status_box;
	gtk_stack_set_visible_child (_tmp0_, (GtkWidget*) _tmp1_);
	_tmp2_ = self->priv->status_label;
	_tmp3_ = gst_device_get_display_name (camera);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strdup_printf (_ ("Connecting to \"%s\"…"), _tmp5_);
	_tmp7_ = _tmp6_;
	gtk_label_set_label (_tmp2_, _tmp7_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	_tmp8_ = self->priv->_recording;
	if (_tmp8_) {
		camera_widgets_camera_view_stop_recording (self);
	}
	_tmp9_ = self->priv->record_bin;
	if (_tmp9_ != NULL) {
		GstBin* _tmp10_;
		GstBin* _tmp11_;
		GstBin* _tmp12_;
		_tmp10_ = self->priv->record_bin;
		gst_element_set_state ((GstElement*) _tmp10_, GST_STATE_NULL);
		_tmp11_ = self->priv->record_bin;
		gst_element_sync_state_with_parent ((GstElement*) _tmp11_);
		_tmp12_ = self->priv->record_bin;
		gst_bin_sync_children_states (_tmp12_);
	}
	_tmp13_ = self->priv->pipeline;
	if (_tmp13_ != NULL) {
		GstPipeline* _tmp14_;
		GstPipeline* _tmp15_;
		GstPipeline* _tmp16_;
		_tmp14_ = self->priv->pipeline;
		gst_element_set_state ((GstElement*) _tmp14_, GST_STATE_NULL);
		_tmp15_ = self->priv->pipeline;
		gst_bin_sync_children_states ((GstBin*) _tmp15_);
		_tmp16_ = self->priv->pipeline;
		GST_DEBUG_BIN_TO_DOT_FILE ((GstBin*) _tmp16_, GST_DEBUG_GRAPH_SHOW_VERBOSE, "changing");
	}
	camera_widgets_camera_view_create_pipeline (self, camera);
	_tmp17_ = _g_object_ref0 (camera);
	_g_object_unref0 (self->priv->current_device);
	self->priv->current_device = _tmp17_;
	_tmp18_ = gtk_widget_get_root ((GtkWidget*) self);
	_tmp19_ = gst_object_get_name ((GstObject*) camera);
	_tmp20_ = _tmp19_;
	_tmp21_ = _tmp20_;
	_tmp22_ = g_variant_new_string (_tmp21_);
	g_variant_ref_sink (_tmp22_);
	_tmp23_ = _tmp22_;
	g_action_group_change_action_state ((GActionGroup*) G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, CAMERA_TYPE_MAIN_WINDOW, CameraMainWindow), CAMERA_MAIN_WINDOW_ACTION_CHANGE_CAMERA, _tmp23_);
	_g_variant_unref0 (_tmp23_);
	_g_free0 (_tmp21_);
}

static void
_gtk_window_destroy_gtk_dialog_response (GtkDialog* _sender,
                                         gint response_id,
                                         gpointer self)
{
	gtk_window_destroy ((GtkWindow*) self);
}

static void
camera_widgets_camera_view_create_pipeline (CameraWidgetsCameraView* self,
                                            GstDevice* camera)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (camera != NULL);
	{
		GstCaps* caps = NULL;
		GstCaps* _tmp0_;
		gint max_area = 0;
		GstElement* device_src = NULL;
		GstElement* _tmp12_;
		GstElement* _tmp13_;
		GstElement* _tmp14_ = NULL;
		GstElement* _tmp15_;
		GstPipeline* _tmp16_;
		GstPipeline* _tmp17_;
		GstPipeline* _tmp18_;
		GstElement* _tmp19_;
		GstElement* _tmp20_;
		GstPipeline* _tmp21_;
		GstElement* _tmp22_;
		GstPipeline* _tmp23_;
		GstElement* _tmp24_;
		GstVideoDirection* _tmp25_;
		GstPipeline* _tmp26_;
		GstElement* _tmp27_;
		GstColorBalance* _tmp28_;
		GstElement* videorate = NULL;
		GstPipeline* _tmp29_;
		GstElement* _tmp30_;
		GstElement* _tmp31_;
		GstElement* _tmp32_;
		GstElement* gtksink = NULL;
		GstElement* _tmp33_;
		GstPipeline* _tmp34_;
		GstElement* _tmp35_;
		GstPipeline* _tmp36_;
		GstElement* _tmp37_;
		GstElement* _tmp38_;
		GstElement* _tmp39_;
		GdkPaintable* gst_video_widget = NULL;
		GstElement* _tmp40_;
		GdkPaintable* _tmp41_ = NULL;
		GtkPicture* _tmp42_;
		GdkPaintable* _tmp43_;
		GtkStack* _tmp44_;
		GtkPicture* _tmp45_;
		GstPipeline* _tmp46_;
		_tmp0_ = gst_device_get_caps (camera);
		caps = _tmp0_;
		self->priv->picture_width = 640;
		self->priv->picture_height = 480;
		max_area = self->priv->picture_width * self->priv->picture_height;
		{
			guint i = 0U;
			i = (guint) 0;
			{
				gboolean _tmp1_ = FALSE;
				_tmp1_ = TRUE;
				while (TRUE) {
					GstCaps* _tmp3_;
					GstStructure* s = NULL;
					GstCaps* _tmp4_;
					GstStructure* _tmp5_;
					GstStructure* _tmp6_;
					const gchar* _tmp7_;
					if (!_tmp1_) {
						guint _tmp2_;
						_tmp2_ = i;
						i = _tmp2_ + 1;
					}
					_tmp1_ = FALSE;
					_tmp3_ = caps;
					if (!(i < gst_caps_get_size (_tmp3_))) {
						break;
					}
					_tmp4_ = caps;
					_tmp5_ = gst_caps_get_structure (_tmp4_, i);
					s = _tmp5_;
					_tmp6_ = s;
					_tmp7_ = gst_structure_get_name (_tmp6_);
					if (g_strcmp0 (_tmp7_, "image/jpeg") == 0) {
						gint w = 0;
						gint h = 0;
						GstStructure* _tmp8_;
						gint _tmp9_ = 0;
						GstStructure* _tmp10_;
						gint _tmp11_ = 0;
						_tmp8_ = s;
						gst_structure_get_int (_tmp8_, "width", &_tmp9_);
						w = _tmp9_;
						_tmp10_ = s;
						gst_structure_get_int (_tmp10_, "height", &_tmp11_);
						h = _tmp11_;
						if ((w * h) > max_area) {
							self->priv->picture_width = w;
							self->priv->picture_height = h;
							max_area = w * h;
						}
					}
				}
			}
		}
		_tmp12_ = gst_device_create_element (camera, CAMERA_WIDGETS_CAMERA_VIEW_VIDEO_SRC_NAME);
		_tmp13_ = _g_object_ref0 (_tmp12_);
		device_src = _tmp13_;
		_tmp15_ = gst_parse_launch_full ("decodebin name=decodebin ! " "videoflip method=horizontal-flip name=hflip ! " "videobalance name=balance ! " "tee name=tee ! " "videorate name=videorate ! " "queue leaky=downstream max-size-buffers=10 ! " "videoconvert ! " "videoscale name=videoscale", NULL, GST_PARSE_FLAG_NONE, &_inner_error0_);
		if (_tmp15_ != NULL) {
			g_object_ref_sink (_tmp15_);
		}
		_tmp14_ = _tmp15_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (device_src);
			_gst_caps_unref0 (caps);
			goto __catch0_g_error;
		}
		_tmp16_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, gst_pipeline_get_type (), GstPipeline));
		_g_object_unref0 (self->priv->pipeline);
		self->priv->pipeline = _tmp16_;
		_tmp17_ = self->priv->pipeline;
		gst_bin_add ((GstBin*) _tmp17_, device_src);
		_tmp18_ = self->priv->pipeline;
		_tmp19_ = gst_bin_get_by_name ((GstBin*) _tmp18_, "decodebin");
		_tmp20_ = _tmp19_;
		gst_element_link (device_src, _tmp20_);
		_g_object_unref0 (_tmp20_);
		_tmp21_ = self->priv->pipeline;
		_tmp22_ = gst_bin_get_by_name ((GstBin*) _tmp21_, "tee");
		_g_object_unref0 (self->priv->tee);
		self->priv->tee = _tmp22_;
		_tmp23_ = self->priv->pipeline;
		_tmp24_ = gst_bin_get_by_name ((GstBin*) _tmp23_, "hflip");
		_tmp25_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp24_, gst_video_direction_get_type ()) ? ((GstVideoDirection*) _tmp24_) : NULL;
		if (_tmp25_ == NULL) {
			_g_object_unref0 (_tmp24_);
		}
		_g_object_unref0 (self->priv->hflip);
		self->priv->hflip = _tmp25_;
		_tmp26_ = self->priv->pipeline;
		_tmp27_ = gst_bin_get_by_name ((GstBin*) _tmp26_, "balance");
		_tmp28_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp27_, gst_color_balance_get_type ()) ? ((GstColorBalance*) _tmp27_) : NULL;
		if (_tmp28_ == NULL) {
			_g_object_unref0 (_tmp27_);
		}
		_g_object_unref0 (self->priv->color_balance);
		self->priv->color_balance = _tmp28_;
		_tmp29_ = self->priv->pipeline;
		_tmp30_ = gst_bin_get_by_name ((GstBin*) _tmp29_, "videorate");
		videorate = _tmp30_;
		_tmp31_ = videorate;
		g_object_set (_tmp31_, "max-rate", 30, NULL);
		_tmp32_ = videorate;
		g_object_set (_tmp32_, "drop-only", TRUE, NULL);
		_tmp33_ = gst_element_factory_make ("gtk4paintablesink", "sink");
		if (_tmp33_ != NULL) {
			g_object_ref_sink (_tmp33_);
		}
		gtksink = _tmp33_;
		_tmp34_ = self->priv->pipeline;
		_tmp35_ = gtksink;
		gst_bin_add ((GstBin*) _tmp34_, _tmp35_);
		_tmp36_ = self->priv->pipeline;
		_tmp37_ = gst_bin_get_by_name ((GstBin*) _tmp36_, "videoscale");
		_tmp38_ = _tmp37_;
		_tmp39_ = gtksink;
		gst_element_link (_tmp38_, _tmp39_);
		_g_object_unref0 (_tmp38_);
		_tmp40_ = gtksink;
		g_object_get ((GObject*) _tmp40_, "paintable", &_tmp41_, NULL);
		_g_object_unref0 (gst_video_widget);
		gst_video_widget = _tmp41_;
		_tmp42_ = self->priv->picture;
		_tmp43_ = gst_video_widget;
		gtk_picture_set_paintable (_tmp42_, _tmp43_);
		_tmp44_ = self->priv->stack;
		_tmp45_ = self->priv->picture;
		gtk_stack_set_visible_child (_tmp44_, (GtkWidget*) _tmp45_);
		_tmp46_ = self->priv->pipeline;
		gst_element_set_state ((GstElement*) _tmp46_, GST_STATE_PLAYING);
		_g_object_unref0 (gst_video_widget);
		_g_object_unref0 (gtksink);
		_g_object_unref0 (videorate);
		_g_object_unref0 (_tmp14_);
		_g_object_unref0 (device_src);
		_gst_caps_unref0 (caps);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GraniteMessageDialog* dialog = NULL;
		GError* _tmp47_;
		const gchar* _tmp48_;
		GraniteMessageDialog* _tmp49_;
		GraniteMessageDialog* _tmp50_;
		GraniteMessageDialog* _tmp51_;
		GraniteMessageDialog* _tmp52_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp47_ = e;
		_tmp48_ = _tmp47_->message;
		_tmp49_ = granite_message_dialog_new_with_image_from_icon_name (_ ("Unable To View Camera"), _tmp48_, "dialog-error", GTK_BUTTONS_CLOSE);
		g_object_ref_sink (_tmp49_);
		dialog = _tmp49_;
		_tmp50_ = dialog;
		gtk_window_present ((GtkWindow*) _tmp50_);
		_tmp51_ = dialog;
		_tmp52_ = dialog;
		g_signal_connect_object ((GtkDialog*) _tmp51_, "response", (GCallback) _gtk_window_destroy_gtk_dialog_response, (GtkWindow*) _tmp52_, 0);
		_g_object_unref0 (dialog);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
camera_widgets_camera_view_change_color_balance (CameraWidgetsCameraView* self,
                                                 gdouble brightnesss,
                                                 gdouble contrast)
{
	GstColorBalance* _tmp0_;
	GValue _tmp1_ = {0};
	GstColorBalance* _tmp2_;
	GValue _tmp3_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->color_balance;
	g_value_init (&_tmp1_, G_TYPE_DOUBLE);
	g_value_set_double (&_tmp1_, brightnesss);
	g_object_set_property ((GObject*) _tmp0_, "brightness", &_tmp1_);
	G_IS_VALUE (&_tmp1_) ? (g_value_unset (&_tmp1_), NULL) : NULL;
	_tmp2_ = self->priv->color_balance;
	g_value_init (&_tmp3_, G_TYPE_DOUBLE);
	g_value_set_double (&_tmp3_, contrast);
	g_object_set_property ((GObject*) _tmp2_, "contrast", &_tmp3_);
	G_IS_VALUE (&_tmp3_) ? (g_value_unset (&_tmp3_), NULL) : NULL;
}

static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		CameraWidgetsCameraView* self;
		self = _data6_->self;
		_g_object_unref0 (_data6_->picture_pipeline);
		_g_object_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}

static gchar*
double_to_string (gdouble self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	_tmp0_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = G_ASCII_DTOSTR_BUF_SIZE;
	_tmp2_ = g_ascii_dtostr (_tmp1_, (gint) G_ASCII_DTOSTR_BUF_SIZE, self);
	_tmp3_ = g_strdup (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp1_ = (g_free (_tmp1_), NULL);
	result = _tmp4_;
	return result;
}

static gboolean
___lambda7_ (Block6Data* _data6_)
{
	CameraWidgetsCameraView* self;
	GstPipeline* _tmp0_;
	GstDevice* _tmp1_;
	gboolean result;
	self = _data6_->self;
	_tmp0_ = _data6_->picture_pipeline;
	gst_element_set_state ((GstElement*) _tmp0_, GST_STATE_NULL);
	camera_widgets_camera_view_play_shutter_sound ();
	_tmp1_ = self->priv->current_device;
	camera_widgets_camera_view_create_pipeline (self, _tmp1_);
	camera_widgets_camera_view_set_recording (self, FALSE);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
____lambda7__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda7_ (self);
	return result;
}

static GstPadProbeReturn
__lambda6_ (Block6Data* _data6_,
            GstPad* pad,
            GstPadProbeInfo* info)
{
	CameraWidgetsCameraView* self;
	GstEvent* _tmp0_;
	GstPadProbeReturn result;
	self = _data6_->self;
	g_return_val_if_fail (pad != NULL, 0);
	g_return_val_if_fail (info != NULL, 0);
	_tmp0_ = gst_pad_probe_info_get_event (info);
	if (_tmp0_->type == GST_EVENT_EOS) {
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ____lambda7__gsource_func, block6_data_ref (_data6_), block6_data_unref);
		result = GST_PAD_PROBE_REMOVE;
		return result;
	}
	result = GST_PAD_PROBE_PASS;
	return result;
}

static GstPadProbeReturn
___lambda6__gst_pad_probe_callback (GstPad* pad,
                                    GstPadProbeInfo* info,
                                    gpointer self)
{
	GstPadProbeReturn result;
	result = __lambda6_ (self, pad, info);
	return result;
}

void
camera_widgets_camera_view_take_photo (CameraWidgetsCameraView* self)
{
	Block6Data* _data6_;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	GstPipeline* _tmp3_;
	GstPipeline* _tmp4_;
	GstElement* preview_video_src = NULL;
	GstPipeline* _tmp5_;
	GstElement* _tmp6_;
	gchar* device_path = NULL;
	GstElement* _tmp7_;
	gchar* _tmp8_ = NULL;
	GValue brightness_value = {0};
	GValue _tmp9_ = {0};
	GstColorBalance* _tmp10_;
	GValue contrast_value = {0};
	GValue _tmp11_ = {0};
	GstColorBalance* _tmp12_;
	GstElement* filesink = NULL;
	GstPipeline* _tmp47_;
	GstElement* _tmp48_;
	GstElement* _tmp49_;
	GstPad* _tmp50_;
	GstPad* _tmp51_;
	GstPipeline* _tmp52_;
	GstPipeline* _tmp53_;
	GstPipeline* _tmp54_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_data6_ = g_slice_new0 (Block6Data);
	_data6_->_ref_count_ = 1;
	_data6_->self = g_object_ref (self);
	_tmp1_ = self->priv->_recording;
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		GstPipeline* _tmp2_;
		_tmp2_ = self->priv->pipeline;
		_tmp0_ = _tmp2_ == NULL;
	}
	if (_tmp0_) {
		block6_data_unref (_data6_);
		_data6_ = NULL;
		return;
	}
	camera_widgets_camera_view_set_recording (self, TRUE);
	_tmp3_ = self->priv->pipeline;
	gst_element_set_state ((GstElement*) _tmp3_, GST_STATE_NULL);
	_tmp4_ = self->priv->pipeline;
	gst_bin_sync_children_states ((GstBin*) _tmp4_);
	_tmp5_ = self->priv->pipeline;
	_tmp6_ = gst_bin_get_by_name ((GstBin*) _tmp5_, CAMERA_WIDGETS_CAMERA_VIEW_VIDEO_SRC_NAME);
	preview_video_src = G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gst_element_get_type (), GstElement);
	_tmp7_ = preview_video_src;
	g_object_get ((GObject*) _tmp7_, "device", &_tmp8_, NULL);
	_g_free0 (device_path);
	device_path = _tmp8_;
	g_value_init (&_tmp9_, G_TYPE_DOUBLE);
	brightness_value = _tmp9_;
	_tmp10_ = self->priv->color_balance;
	g_object_get_property ((GObject*) _tmp10_, "brightness", &brightness_value);
	g_value_init (&_tmp11_, G_TYPE_DOUBLE);
	contrast_value = _tmp11_;
	_tmp12_ = self->priv->color_balance;
	g_object_get_property ((GObject*) _tmp12_, "contrast", &contrast_value);
	{
		const gchar* _tmp13_ = NULL;
		gboolean _tmp14_;
		gboolean _tmp15_;
		GstElement* _tmp16_ = NULL;
		const gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		gchar* _tmp33_;
		gchar* _tmp34_;
		gchar* _tmp35_;
		gchar* _tmp36_;
		gchar* _tmp37_;
		gchar* _tmp38_;
		gchar* _tmp39_;
		gchar* _tmp40_;
		gchar* _tmp41_;
		GstElement* _tmp42_;
		GstElement* _tmp43_;
		GstPipeline* _tmp44_;
		_tmp14_ = camera_widgets_camera_view_get_horizontal_flip (self);
		_tmp15_ = _tmp14_;
		if (_tmp15_) {
			_tmp13_ = "horizontal-flip";
		} else {
			_tmp13_ = "none";
		}
		_tmp17_ = device_path;
		_tmp18_ = g_strdup_printf ("v4l2src device=%s name=%s num-buffers=1 !", _tmp17_, CAMERA_WIDGETS_CAMERA_VIEW_VIDEO_SRC_NAME);
		_tmp19_ = _tmp18_;
		_tmp20_ = g_strdup_printf ("videoscale ! video/x-raw, width=%d, height=%d !", self->priv->picture_width, self->priv->picture_height);
		_tmp21_ = _tmp20_;
		_tmp22_ = g_strconcat (_tmp19_, _tmp21_, NULL);
		_tmp23_ = _tmp22_;
		_tmp24_ = g_strdup_printf ("videoflip method=%s !", _tmp13_);
		_tmp25_ = _tmp24_;
		_tmp26_ = g_strconcat (_tmp23_, _tmp25_, NULL);
		_tmp27_ = _tmp26_;
		_tmp28_ = double_to_string (g_value_get_double (&brightness_value));
		_tmp29_ = _tmp28_;
		_tmp30_ = double_to_string (g_value_get_double (&contrast_value));
		_tmp31_ = _tmp30_;
		_tmp32_ = g_strdup_printf ("videobalance brightness=%s contrast=%s !", _tmp29_, _tmp31_);
		_tmp33_ = _tmp32_;
		_tmp34_ = g_strconcat (_tmp27_, _tmp33_, NULL);
		_tmp35_ = _tmp34_;
		_tmp36_ = camera_utils_get_new_media_filename (CAMERA_UTILS_ACTION_TYPE_PHOTO);
		_tmp37_ = _tmp36_;
		_tmp38_ = g_strdup_printf ("jpegenc ! filesink location=%s name=filesink", _tmp37_);
		_tmp39_ = _tmp38_;
		_tmp40_ = g_strconcat (_tmp35_, _tmp39_, NULL);
		_tmp41_ = _tmp40_;
		_tmp42_ = gst_parse_launch_full (_tmp41_, NULL, GST_PARSE_FLAG_NONE, &_inner_error0_);
		if (_tmp42_ != NULL) {
			g_object_ref_sink (_tmp42_);
		}
		_tmp43_ = _tmp42_;
		_g_free0 (_tmp41_);
		_g_free0 (_tmp39_);
		_g_free0 (_tmp37_);
		_g_free0 (_tmp35_);
		_g_free0 (_tmp33_);
		_g_free0 (_tmp31_);
		_g_free0 (_tmp29_);
		_g_free0 (_tmp27_);
		_g_free0 (_tmp25_);
		_g_free0 (_tmp23_);
		_g_free0 (_tmp21_);
		_g_free0 (_tmp19_);
		_tmp16_ = _tmp43_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp44_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, gst_pipeline_get_type (), GstPipeline));
		_g_object_unref0 (_data6_->picture_pipeline);
		_data6_->picture_pipeline = _tmp44_;
		_g_object_unref0 (_tmp16_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp45_;
		const gchar* _tmp46_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp45_ = e;
		_tmp46_ = _tmp45_->message;
		g_warning ("CameraView.vala:304: Could not make picture pipeline for photo - %s", _tmp46_);
		_g_error_free0 (e);
		G_IS_VALUE (&contrast_value) ? (g_value_unset (&contrast_value), NULL) : NULL;
		G_IS_VALUE (&brightness_value) ? (g_value_unset (&brightness_value), NULL) : NULL;
		_g_free0 (device_path);
		_g_object_unref0 (preview_video_src);
		block6_data_unref (_data6_);
		_data6_ = NULL;
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		G_IS_VALUE (&contrast_value) ? (g_value_unset (&contrast_value), NULL) : NULL;
		G_IS_VALUE (&brightness_value) ? (g_value_unset (&brightness_value), NULL) : NULL;
		_g_free0 (device_path);
		_g_object_unref0 (preview_video_src);
		block6_data_unref (_data6_);
		_data6_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp47_ = _data6_->picture_pipeline;
	_tmp48_ = gst_bin_get_by_name ((GstBin*) _tmp47_, "filesink");
	filesink = _tmp48_;
	_tmp49_ = filesink;
	_tmp50_ = gst_element_get_static_pad (_tmp49_, "sink");
	_tmp51_ = _tmp50_;
	gst_pad_add_probe (_tmp51_, GST_PAD_PROBE_TYPE_EVENT_DOWNSTREAM, ___lambda6__gst_pad_probe_callback, block6_data_ref (_data6_), block6_data_unref);
	_g_object_unref0 (_tmp51_);
	_tmp52_ = _data6_->picture_pipeline;
	gst_element_set_state ((GstElement*) _tmp52_, GST_STATE_PLAYING);
	_tmp53_ = _data6_->picture_pipeline;
	gst_bin_sync_children_states ((GstBin*) _tmp53_);
	_tmp54_ = self->priv->pipeline;
	GST_DEBUG_BIN_TO_DOT_FILE ((GstBin*) _tmp54_, GST_DEBUG_GRAPH_SHOW_VERBOSE, "snapshot");
	_g_object_unref0 (filesink);
	G_IS_VALUE (&contrast_value) ? (g_value_unset (&contrast_value), NULL) : NULL;
	G_IS_VALUE (&brightness_value) ? (g_value_unset (&brightness_value), NULL) : NULL;
	_g_free0 (device_path);
	_g_object_unref0 (preview_video_src);
	block6_data_unref (_data6_);
	_data6_ = NULL;
}

static void
_vala_array_add1 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add2 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add3 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add4 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add5 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add6 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add7 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
___lambda8_ (CameraWidgetsCameraView* self,
             GstInstallPluginsReturn _result_)
{
}

static void
____lambda8__gst_install_plugins_result_func (GstInstallPluginsReturn _result_,
                                              gpointer self)
{
	___lambda8_ ((CameraWidgetsCameraView*) self, _result_);
	g_object_unref (self);
}

void
camera_widgets_camera_view_start_recording (CameraWidgetsCameraView* self)
{
	gboolean _tmp0_;
	GstBin* _tmp1_;
	gchar** missing_messages = NULL;
	gchar** _tmp2_;
	gint missing_messages_length1;
	gint _missing_messages_size_;
	GstElement* queue = NULL;
	GstElement* _tmp3_;
	GstElement* videoconvert = NULL;
	GstElement* _tmp4_;
	GstElement* _tmp5_;
	GstElement* encoder = NULL;
	GstElement* _tmp7_;
	GstElement* _tmp8_;
	GstElement* muxer = NULL;
	GstElement* _tmp10_;
	GstElement* _tmp11_;
	GstElement* alsasrc = NULL;
	GstElement* _tmp13_;
	GstElement* _tmp14_;
	GstElement* audio_queue = NULL;
	GstElement* _tmp16_;
	GstElement* audio_convert = NULL;
	GstElement* _tmp17_;
	GstElement* _tmp18_;
	GstElement* audio_vorbis = NULL;
	GstElement* _tmp20_;
	GstElement* _tmp21_;
	GstElement* filesink = NULL;
	GstElement* _tmp23_;
	GstElement* _tmp24_;
	gchar** _tmp29_;
	gint _tmp29__length1;
	GstBin* _tmp31_;
	GstElement* _tmp32_;
	GstElement* _tmp33_;
	GstElement* _tmp34_;
	GstElement* _tmp35_;
	GstElement* _tmp36_;
	GstElement* _tmp37_;
	GstElement* _tmp38_;
	GstElement* _tmp39_;
	GstElement* _tmp40_;
	GstElement* _tmp41_;
	GstBin* _tmp42_;
	GstElement* _tmp43_;
	GstElement* _tmp44_;
	GstElement* _tmp45_;
	GstElement* _tmp46_;
	GstElement* _tmp47_;
	GstElement* _tmp48_;
	GstElement* _tmp49_;
	GstElement* _tmp50_;
	GstElement* _tmp51_;
	GstGhostPad* ghostpad = NULL;
	GstElement* _tmp52_;
	GstPad* _tmp53_;
	GstPad* _tmp54_;
	GstGhostPad* _tmp55_;
	GstGhostPad* _tmp56_;
	GstBin* _tmp57_;
	GstGhostPad* _tmp58_;
	GstPipeline* _tmp59_;
	GstPipeline* _tmp60_;
	GstBin* _tmp61_;
	GstBin* _tmp62_;
	GstElement* _tmp63_;
	GstBin* _tmp64_;
	GstPipeline* _tmp65_;
	GstPipeline* _tmp66_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_recording;
	if (_tmp0_) {
		return;
	}
	camera_widgets_camera_view_set_recording (self, TRUE);
	_tmp1_ = (GstBin*) gst_bin_new (NULL);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->record_bin);
	self->priv->record_bin = _tmp1_;
	_tmp2_ = g_new0 (gchar*, 0 + 1);
	missing_messages = _tmp2_;
	missing_messages_length1 = 0;
	_missing_messages_size_ = missing_messages_length1;
	_tmp3_ = gst_element_factory_make ("queue", NULL);
	if (_tmp3_ != NULL) {
		g_object_ref_sink (_tmp3_);
	}
	queue = _tmp3_;
	_tmp4_ = gst_element_factory_make ("videoconvert", NULL);
	if (_tmp4_ != NULL) {
		g_object_ref_sink (_tmp4_);
	}
	videoconvert = _tmp4_;
	_tmp5_ = videoconvert;
	if (_tmp5_ == NULL) {
		gchar* _tmp6_;
		_tmp6_ = gst_missing_element_installer_detail_new ("videoconvert");
		_vala_array_add1 (&missing_messages, &missing_messages_length1, &_missing_messages_size_, _tmp6_);
	}
	_tmp7_ = gst_element_factory_make ("vp8enc", NULL);
	if (_tmp7_ != NULL) {
		g_object_ref_sink (_tmp7_);
	}
	encoder = _tmp7_;
	_tmp8_ = encoder;
	if (_tmp8_ == NULL) {
		gchar* _tmp9_;
		_tmp9_ = gst_missing_element_installer_detail_new ("vp8enc");
		_vala_array_add2 (&missing_messages, &missing_messages_length1, &_missing_messages_size_, _tmp9_);
	}
	_tmp10_ = gst_element_factory_make ("webmmux", NULL);
	if (_tmp10_ != NULL) {
		g_object_ref_sink (_tmp10_);
	}
	muxer = _tmp10_;
	_tmp11_ = muxer;
	if (_tmp11_ == NULL) {
		gchar* _tmp12_;
		_tmp12_ = gst_missing_element_installer_detail_new ("webmmux");
		_vala_array_add3 (&missing_messages, &missing_messages_length1, &_missing_messages_size_, _tmp12_);
	}
	_tmp13_ = gst_element_factory_make ("alsasrc", NULL);
	if (_tmp13_ != NULL) {
		g_object_ref_sink (_tmp13_);
	}
	alsasrc = _tmp13_;
	_tmp14_ = alsasrc;
	if (_tmp14_ == NULL) {
		gchar* _tmp15_;
		_tmp15_ = gst_missing_element_installer_detail_new ("alsasrc");
		_vala_array_add4 (&missing_messages, &missing_messages_length1, &_missing_messages_size_, _tmp15_);
	}
	_tmp16_ = gst_element_factory_make ("queue", NULL);
	if (_tmp16_ != NULL) {
		g_object_ref_sink (_tmp16_);
	}
	audio_queue = _tmp16_;
	_tmp17_ = gst_element_factory_make ("audioconvert", NULL);
	if (_tmp17_ != NULL) {
		g_object_ref_sink (_tmp17_);
	}
	audio_convert = _tmp17_;
	_tmp18_ = audio_convert;
	if (_tmp18_ == NULL) {
		gchar* _tmp19_;
		_tmp19_ = gst_missing_element_installer_detail_new ("audioconvert");
		_vala_array_add5 (&missing_messages, &missing_messages_length1, &_missing_messages_size_, _tmp19_);
	}
	_tmp20_ = gst_element_factory_make ("vorbisenc", NULL);
	if (_tmp20_ != NULL) {
		g_object_ref_sink (_tmp20_);
	}
	audio_vorbis = _tmp20_;
	_tmp21_ = audio_vorbis;
	if (_tmp21_ == NULL) {
		gchar* _tmp22_;
		_tmp22_ = gst_missing_element_installer_detail_new ("vorbisenc");
		_vala_array_add6 (&missing_messages, &missing_messages_length1, &_missing_messages_size_, _tmp22_);
	}
	_tmp23_ = gst_element_factory_make ("filesink", "filesink");
	if (_tmp23_ != NULL) {
		g_object_ref_sink (_tmp23_);
	}
	filesink = _tmp23_;
	_tmp24_ = filesink;
	if (_tmp24_ == NULL) {
		gchar* _tmp25_;
		_tmp25_ = gst_missing_element_installer_detail_new ("filesink");
		_vala_array_add7 (&missing_messages, &missing_messages_length1, &_missing_messages_size_, _tmp25_);
	} else {
		GstElement* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		_tmp26_ = filesink;
		_tmp27_ = camera_utils_get_new_media_filename (CAMERA_UTILS_ACTION_TYPE_VIDEO);
		_tmp28_ = _tmp27_;
		g_object_set ((GObject*) _tmp26_, "location", _tmp28_, NULL);
		_g_free0 (_tmp28_);
	}
	_tmp29_ = missing_messages;
	_tmp29__length1 = missing_messages_length1;
	if (_tmp29__length1 > 0) {
		gchar** _tmp30_;
		gint _tmp30__length1;
		_tmp30_ = missing_messages;
		_tmp30__length1 = missing_messages_length1;
		gst_install_plugins_async (_tmp30_, NULL, ____lambda8__gst_install_plugins_result_func, g_object_ref (self));
		camera_widgets_camera_view_set_recording (self, FALSE);
		_g_object_unref0 (filesink);
		_g_object_unref0 (audio_vorbis);
		_g_object_unref0 (audio_convert);
		_g_object_unref0 (audio_queue);
		_g_object_unref0 (alsasrc);
		_g_object_unref0 (muxer);
		_g_object_unref0 (encoder);
		_g_object_unref0 (videoconvert);
		_g_object_unref0 (queue);
		missing_messages = (_vala_array_free (missing_messages, missing_messages_length1, (GDestroyNotify) g_free), NULL);
		return;
	}
	_tmp31_ = self->priv->record_bin;
	_tmp32_ = queue;
	_tmp33_ = videoconvert;
	_tmp34_ = encoder;
	_tmp35_ = muxer;
	_tmp36_ = filesink;
	gst_bin_add_many (_tmp31_, _tmp32_, _tmp33_, _tmp34_, _tmp35_, _tmp36_, NULL);
	_tmp37_ = queue;
	_tmp38_ = videoconvert;
	_tmp39_ = encoder;
	_tmp40_ = muxer;
	_tmp41_ = filesink;
	gst_element_link_many (_tmp37_, _tmp38_, _tmp39_, _tmp40_, _tmp41_, NULL);
	_tmp42_ = self->priv->record_bin;
	_tmp43_ = alsasrc;
	_tmp44_ = audio_queue;
	_tmp45_ = audio_convert;
	_tmp46_ = audio_vorbis;
	gst_bin_add_many (_tmp42_, _tmp43_, _tmp44_, _tmp45_, _tmp46_, NULL);
	_tmp47_ = alsasrc;
	_tmp48_ = audio_queue;
	_tmp49_ = audio_convert;
	_tmp50_ = audio_vorbis;
	_tmp51_ = muxer;
	gst_element_link_many (_tmp47_, _tmp48_, _tmp49_, _tmp50_, _tmp51_, NULL);
	_tmp52_ = queue;
	_tmp53_ = gst_element_get_static_pad (_tmp52_, "sink");
	_tmp54_ = _tmp53_;
	_tmp55_ = (GstGhostPad*) gst_ghost_pad_new (NULL, _tmp54_);
	g_object_ref_sink (_tmp55_);
	_tmp56_ = _tmp55_;
	_g_object_unref0 (_tmp54_);
	ghostpad = _tmp56_;
	_tmp57_ = self->priv->record_bin;
	_tmp58_ = ghostpad;
	gst_element_add_pad ((GstElement*) _tmp57_, (GstPad*) _tmp58_);
	_tmp59_ = self->priv->pipeline;
	gst_element_set_state ((GstElement*) _tmp59_, GST_STATE_PAUSED);
	_tmp60_ = self->priv->pipeline;
	_tmp61_ = self->priv->record_bin;
	gst_bin_add ((GstBin*) _tmp60_, (GstElement*) _tmp61_);
	_tmp62_ = self->priv->record_bin;
	gst_element_sync_state_with_parent ((GstElement*) _tmp62_);
	_tmp63_ = self->priv->tee;
	_tmp64_ = self->priv->record_bin;
	gst_element_link (_tmp63_, (GstElement*) _tmp64_);
	_tmp65_ = self->priv->pipeline;
	gst_element_set_state ((GstElement*) _tmp65_, GST_STATE_PLAYING);
	_tmp66_ = self->priv->pipeline;
	GST_DEBUG_BIN_TO_DOT_FILE ((GstBin*) _tmp66_, GST_DEBUG_GRAPH_SHOW_VERBOSE, "recording");
	_g_object_unref0 (ghostpad);
	_g_object_unref0 (filesink);
	_g_object_unref0 (audio_vorbis);
	_g_object_unref0 (audio_convert);
	_g_object_unref0 (audio_queue);
	_g_object_unref0 (alsasrc);
	_g_object_unref0 (muxer);
	_g_object_unref0 (encoder);
	_g_object_unref0 (videoconvert);
	_g_object_unref0 (queue);
	missing_messages = (_vala_array_free (missing_messages, missing_messages_length1, (GDestroyNotify) g_free), NULL);
}

void
camera_widgets_camera_view_stop_recording (CameraWidgetsCameraView* self)
{
	gboolean _tmp0_;
	GstPipeline* _tmp1_;
	GstElement* _tmp2_;
	GstBin* _tmp3_;
	GstElement* filesink = NULL;
	GstBin* _tmp4_;
	GstElement* _tmp5_;
	GstElement* _tmp6_;
	GstPipeline* _tmp12_;
	GstBin* _tmp13_;
	GstPipeline* _tmp14_;
	GstBin* _tmp15_;
	GstBin* _tmp16_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_recording;
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = self->priv->pipeline;
	gst_element_set_state ((GstElement*) _tmp1_, GST_STATE_PAUSED);
	_tmp2_ = self->priv->tee;
	_tmp3_ = self->priv->record_bin;
	gst_element_unlink (_tmp2_, (GstElement*) _tmp3_);
	_tmp4_ = self->priv->record_bin;
	_tmp5_ = gst_bin_get_by_name (_tmp4_, "filesink");
	filesink = _tmp5_;
	_tmp6_ = filesink;
	if (_tmp6_ != NULL) {
		GValue locationval = {0};
		GValue _tmp7_ = {0};
		GstElement* _tmp8_;
		gchar* location = NULL;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		const gchar* _tmp11_;
		g_value_init (&_tmp7_, G_TYPE_STRING);
		locationval = _tmp7_;
		_tmp8_ = filesink;
		g_object_get_property ((GObject*) _tmp8_, "location", &locationval);
		_tmp9_ = g_value_get_string (&locationval);
		_tmp10_ = g_strdup (_tmp9_);
		location = _tmp10_;
		_tmp11_ = location;
		g_signal_emit (self, camera_widgets_camera_view_signals[CAMERA_WIDGETS_CAMERA_VIEW_RECORDING_FINISHED_SIGNAL], 0, _tmp11_);
		_g_free0 (location);
		G_IS_VALUE (&locationval) ? (g_value_unset (&locationval), NULL) : NULL;
	}
	_tmp12_ = self->priv->pipeline;
	_tmp13_ = self->priv->record_bin;
	gst_bin_remove ((GstBin*) _tmp12_, (GstElement*) _tmp13_);
	_tmp14_ = self->priv->pipeline;
	gst_element_set_state ((GstElement*) _tmp14_, GST_STATE_PLAYING);
	_tmp15_ = self->priv->record_bin;
	gst_element_set_state ((GstElement*) _tmp15_, GST_STATE_NULL);
	_tmp16_ = self->priv->record_bin;
	g_object_run_dispose ((GObject*) _tmp16_);
	camera_widgets_camera_view_set_recording (self, FALSE);
	_g_object_unref0 (filesink);
}

static void
camera_widgets_camera_view_play_shutter_sound (void)
{
	ca_context* context = NULL;
	ca_proplist* props = NULL;
	ca_context* _tmp0_ = NULL;
	ca_proplist* _tmp1_ = NULL;
	ca_context_create (&_tmp0_);
	_ca_context_destroy0 (context);
	context = _tmp0_;
	ca_proplist_create (&_tmp1_);
	_ca_proplist_destroy0 (props);
	props = _tmp1_;
	ca_proplist_sets (props, CA_PROP_EVENT_ID, "camera-shutter");
	ca_proplist_sets (props, CA_PROP_EVENT_DESCRIPTION, _ ("Photo taken"));
	ca_proplist_sets (props, CA_PROP_CANBERRA_CACHE_CONTROL, "permanent");
	ca_proplist_sets (props, CA_PROP_MEDIA_ROLE, "event");
	ca_context_play_full (context, (guint32) 0, props, NULL, NULL);
	_ca_proplist_destroy0 (props);
	_ca_context_destroy0 (context);
}

CameraWidgetsCameraView*
camera_widgets_camera_view_construct (GType object_type)
{
	CameraWidgetsCameraView * self = NULL;
	self = (CameraWidgetsCameraView*) g_object_new (object_type, NULL);
	return self;
}

CameraWidgetsCameraView*
camera_widgets_camera_view_new (void)
{
	return camera_widgets_camera_view_construct (CAMERA_WIDGETS_TYPE_CAMERA_VIEW);
}

guint
camera_widgets_camera_view_get_n_cameras (CameraWidgetsCameraView* self)
{
	guint result;
	GstDeviceMonitor* _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
	guint _tmp3_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->monitor;
	_tmp1_ = gst_device_monitor_get_devices (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_list_length (_tmp2_);
	(_tmp2_ == NULL) ? NULL : (_tmp2_ = (_g_list_free__g_object_unref0_ (_tmp2_), NULL));
	result = _tmp3_;
	return result;
}

gboolean
camera_widgets_camera_view_get_recording (CameraWidgetsCameraView* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_recording;
	return result;
}

static void
camera_widgets_camera_view_set_recording (CameraWidgetsCameraView* self,
                                          gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = camera_widgets_camera_view_get_recording (self);
	if (old_value != value) {
		self->priv->_recording = value;
		g_object_notify_by_pspec ((GObject *) self, camera_widgets_camera_view_properties[CAMERA_WIDGETS_CAMERA_VIEW_RECORDING_PROPERTY]);
	}
}

gboolean
camera_widgets_camera_view_get_horizontal_flip (CameraWidgetsCameraView* self)
{
	gboolean result;
	GstVideoDirection* _tmp0_;
	GstVideoDirection* _tmp1_;
	GstVideoOrientationMethod _tmp2_;
	GstVideoOrientationMethod _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->hflip;
	if (_tmp0_ == NULL) {
		result = TRUE;
		return result;
	}
	_tmp1_ = self->priv->hflip;
	g_object_get (_tmp1_, "video-direction", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	result = _tmp3_ == GST_VIDEO_ORIENTATION_HORIZ;
	return result;
}

void
camera_widgets_camera_view_set_horizontal_flip (CameraWidgetsCameraView* self,
                                                gboolean value)
{
	GstVideoDirection* _tmp0_;
	GstVideoDirection* _tmp1_;
	GstVideoOrientationMethod _tmp2_;
	GstVideoOrientationMethod _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->hflip;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->hflip;
	g_object_get (_tmp1_, "video-direction", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == GST_VIDEO_ORIENTATION_IDENTITY) {
		GstVideoDirection* _tmp4_;
		_tmp4_ = self->priv->hflip;
		g_object_set (_tmp4_, "video-direction", GST_VIDEO_ORIENTATION_HORIZ, NULL);
	} else {
		GstVideoDirection* _tmp5_;
		_tmp5_ = self->priv->hflip;
		g_object_set (_tmp5_, "video-direction", GST_VIDEO_ORIENTATION_IDENTITY, NULL);
	}
	g_object_notify_by_pspec ((GObject *) self, camera_widgets_camera_view_properties[CAMERA_WIDGETS_CAMERA_VIEW_HORIZONTAL_FLIP_PROPERTY]);
}

static gboolean
_camera_widgets_camera_view_on_bus_message_gst_bus_func (GstBus* bus,
                                                         GstMessage* message,
                                                         gpointer self)
{
	gboolean result;
	result = camera_widgets_camera_view_on_bus_message ((CameraWidgetsCameraView*) self, bus, message);
	return result;
}

static gboolean
_camera_widgets_camera_view___lambda9_ (CameraWidgetsCameraView* self)
{
	guint _tmp0_;
	guint _tmp1_;
	gboolean result;
	_tmp0_ = camera_widgets_camera_view_get_n_cameras (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == ((guint) 0)) {
		GranitePlaceholder* _tmp2_;
		GtkStack* _tmp3_;
		GranitePlaceholder* _tmp4_;
		_tmp2_ = self->priv->no_device_view;
		gtk_widget_show ((GtkWidget*) _tmp2_);
		_tmp3_ = self->priv->stack;
		_tmp4_ = self->priv->no_device_view;
		gtk_stack_set_visible_child (_tmp3_, (GtkWidget*) _tmp4_);
	}
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
__camera_widgets_camera_view___lambda9__gsource_func (gpointer self)
{
	gboolean result;
	result = _camera_widgets_camera_view___lambda9_ ((CameraWidgetsCameraView*) self);
	return result;
}

static GObject *
camera_widgets_camera_view_constructor (GType type,
                                        guint n_construct_properties,
                                        GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	CameraWidgetsCameraView * self;
	GtkSpinner* spinner = NULL;
	GtkSpinner* _tmp0_ = NULL;
	GtkLabel* _tmp1_;
	GtkBox* _tmp2_ = NULL;
	GtkBox* _tmp3_;
	GtkSpinner* _tmp4_;
	GtkBox* _tmp5_;
	GtkLabel* _tmp6_;
	gchar* _tmp7_;
	GranitePlaceholder* _tmp8_ = NULL;
	GtkPicture* _tmp9_ = NULL;
	GtkStack* _tmp10_;
	GtkStack* _tmp11_;
	GtkBox* _tmp12_;
	GtkStack* _tmp13_;
	GranitePlaceholder* _tmp14_;
	GtkStack* _tmp15_;
	GtkPicture* _tmp16_;
	GstDeviceMonitor* _tmp17_;
	GstBus* _tmp18_;
	GstBus* _tmp19_;
	GtkStack* _tmp20_;
	GstCaps* caps = NULL;
	GstCaps* _tmp21_;
	GstCaps* _tmp22_;
	GstCaps* _tmp23_;
	GstDeviceMonitor* _tmp24_;
	GstCaps* _tmp25_;
	parent_class = G_OBJECT_CLASS (camera_widgets_camera_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CAMERA_WIDGETS_TYPE_CAMERA_VIEW, CameraWidgetsCameraView);
	_tmp0_ = (GtkSpinner*) gtk_spinner_new ();
	gtk_spinner_set_spinning (_tmp0_, TRUE);
	g_object_ref_sink (_tmp0_);
	spinner = _tmp0_;
	_tmp1_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->status_label);
	self->priv->status_label = _tmp1_;
	_tmp2_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	gtk_widget_set_halign ((GtkWidget*) _tmp2_, GTK_ALIGN_CENTER);
	gtk_widget_set_valign ((GtkWidget*) _tmp2_, GTK_ALIGN_CENTER);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->status_box);
	self->priv->status_box = _tmp2_;
	_tmp3_ = self->priv->status_box;
	_tmp4_ = spinner;
	gtk_box_append (_tmp3_, (GtkWidget*) _tmp4_);
	_tmp5_ = self->priv->status_box;
	_tmp6_ = self->priv->status_label;
	gtk_box_append (_tmp5_, (GtkWidget*) _tmp6_);
	_tmp7_ = g_strdup (_ ("Connect a webcam or other supported video device to take photos and vi" \
"deo."));
	_tmp8_ = granite_placeholder_new (_ ("No Supported Camera Found"));
	granite_placeholder_set_description (_tmp8_, _tmp7_);
	_g_free0 (_tmp7_);
	g_object_ref_sink (_tmp8_);
	_g_object_unref0 (self->priv->no_device_view);
	self->priv->no_device_view = _tmp8_;
	_tmp9_ = (GtkPicture*) gtk_picture_new ();
	gtk_picture_set_content_fit (_tmp9_, GTK_CONTENT_FIT_CONTAIN);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp9_, TRUE);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp9_, TRUE);
	g_object_ref_sink (_tmp9_);
	_g_object_unref0 (self->priv->picture);
	self->priv->picture = _tmp9_;
	_tmp10_ = (GtkStack*) gtk_stack_new ();
	g_object_ref_sink (_tmp10_);
	_g_object_unref0 (self->priv->stack);
	self->priv->stack = _tmp10_;
	_tmp11_ = self->priv->stack;
	_tmp12_ = self->priv->status_box;
	gtk_stack_add_child (_tmp11_, (GtkWidget*) _tmp12_);
	_tmp13_ = self->priv->stack;
	_tmp14_ = self->priv->no_device_view;
	gtk_stack_add_child (_tmp13_, (GtkWidget*) _tmp14_);
	_tmp15_ = self->priv->stack;
	_tmp16_ = self->priv->picture;
	gtk_stack_add_child (_tmp15_, (GtkWidget*) _tmp16_);
	_tmp17_ = self->priv->monitor;
	_tmp18_ = gst_device_monitor_get_bus (_tmp17_);
	_tmp19_ = _tmp18_;
	gst_bus_add_watch_full (_tmp19_, G_PRIORITY_DEFAULT, _camera_widgets_camera_view_on_bus_message_gst_bus_func, g_object_ref (self), g_object_unref);
	_g_object_unref0 (_tmp19_);
	_tmp20_ = self->priv->stack;
	gtk_box_append ((GtkBox*) self, (GtkWidget*) _tmp20_);
	_tmp21_ = gst_caps_new_empty_simple ("video/x-raw");
	caps = _tmp21_;
	_tmp22_ = caps;
	_tmp23_ = gst_caps_new_empty_simple ("image/jpeg");
	gst_caps_append (_tmp22_, _tmp23_);
	_tmp24_ = self->priv->monitor;
	_tmp25_ = caps;
	gst_device_monitor_add_filter (_tmp24_, "Video/Source", _tmp25_);
	self->priv->init_device_timeout_id = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 2, __camera_widgets_camera_view___lambda9__gsource_func, g_object_ref (self), g_object_unref);
	_gst_caps_unref0 (caps);
	_g_object_unref0 (spinner);
	return obj;
}

static void
camera_widgets_camera_view_class_init (CameraWidgetsCameraViewClass * klass,
                                       gpointer klass_data)
{
	camera_widgets_camera_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &CameraWidgetsCameraView_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_camera_widgets_camera_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_camera_widgets_camera_view_set_property;
	G_OBJECT_CLASS (klass)->constructor = camera_widgets_camera_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = camera_widgets_camera_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CAMERA_WIDGETS_CAMERA_VIEW_N_CAMERAS_PROPERTY, camera_widgets_camera_view_properties[CAMERA_WIDGETS_CAMERA_VIEW_N_CAMERAS_PROPERTY] = g_param_spec_uint ("n-cameras", "n-cameras", "n-cameras", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CAMERA_WIDGETS_CAMERA_VIEW_RECORDING_PROPERTY, camera_widgets_camera_view_properties[CAMERA_WIDGETS_CAMERA_VIEW_RECORDING_PROPERTY] = g_param_spec_boolean ("recording", "recording", "recording", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CAMERA_WIDGETS_CAMERA_VIEW_HORIZONTAL_FLIP_PROPERTY, camera_widgets_camera_view_properties[CAMERA_WIDGETS_CAMERA_VIEW_HORIZONTAL_FLIP_PROPERTY] = g_param_spec_boolean ("horizontal-flip", "horizontal-flip", "horizontal-flip", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	camera_widgets_camera_view_signals[CAMERA_WIDGETS_CAMERA_VIEW_RECORDING_FINISHED_SIGNAL] = g_signal_new ("recording-finished", CAMERA_WIDGETS_TYPE_CAMERA_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	camera_widgets_camera_view_signals[CAMERA_WIDGETS_CAMERA_VIEW_CAMERA_ADDED_SIGNAL] = g_signal_new ("camera-added", CAMERA_WIDGETS_TYPE_CAMERA_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, gst_device_get_type ());
	camera_widgets_camera_view_signals[CAMERA_WIDGETS_CAMERA_VIEW_CAMERA_REMOVED_SIGNAL] = g_signal_new ("camera-removed", CAMERA_WIDGETS_TYPE_CAMERA_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, gst_device_get_type ());
}

static void
camera_widgets_camera_view_instance_init (CameraWidgetsCameraView * self,
                                          gpointer klass)
{
	GstDeviceMonitor* _tmp0_;
	self->priv = camera_widgets_camera_view_get_instance_private (self);
	self->priv->current_device = NULL;
	self->priv->init_device_timeout_id = (guint) 0;
	_tmp0_ = gst_device_monitor_new ();
	g_object_ref_sink (_tmp0_);
	self->priv->monitor = _tmp0_;
	self->priv->_recording = FALSE;
}

static void
camera_widgets_camera_view_finalize (GObject * obj)
{
	CameraWidgetsCameraView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CAMERA_WIDGETS_TYPE_CAMERA_VIEW, CameraWidgetsCameraView);
	_g_object_unref0 (self->priv->stack);
	_g_object_unref0 (self->priv->status_box);
	_g_object_unref0 (self->priv->no_device_view);
	_g_object_unref0 (self->priv->status_label);
	_g_object_unref0 (self->priv->picture);
	_g_object_unref0 (self->priv->pipeline);
	_g_object_unref0 (self->priv->tee);
	_g_object_unref0 (self->priv->color_balance);
	_g_object_unref0 (self->priv->hflip);
	_g_object_unref0 (self->priv->record_bin);
	_g_object_unref0 (self->priv->current_device);
	_g_object_unref0 (self->priv->monitor);
	G_OBJECT_CLASS (camera_widgets_camera_view_parent_class)->finalize (obj);
}

static GType
camera_widgets_camera_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (CameraWidgetsCameraViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) camera_widgets_camera_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CameraWidgetsCameraView), 0, (GInstanceInitFunc) camera_widgets_camera_view_instance_init, NULL };
	GType camera_widgets_camera_view_type_id;
	camera_widgets_camera_view_type_id = g_type_register_static (gtk_box_get_type (), "CameraWidgetsCameraView", &g_define_type_info, 0);
	CameraWidgetsCameraView_private_offset = g_type_add_instance_private (camera_widgets_camera_view_type_id, sizeof (CameraWidgetsCameraViewPrivate));
	return camera_widgets_camera_view_type_id;
}

GType
camera_widgets_camera_view_get_type (void)
{
	static volatile gsize camera_widgets_camera_view_type_id__once = 0;
	if (g_once_init_enter (&camera_widgets_camera_view_type_id__once)) {
		GType camera_widgets_camera_view_type_id;
		camera_widgets_camera_view_type_id = camera_widgets_camera_view_get_type_once ();
		g_once_init_leave (&camera_widgets_camera_view_type_id__once, camera_widgets_camera_view_type_id);
	}
	return camera_widgets_camera_view_type_id__once;
}

static void
_vala_camera_widgets_camera_view_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec)
{
	CameraWidgetsCameraView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CAMERA_WIDGETS_TYPE_CAMERA_VIEW, CameraWidgetsCameraView);
	switch (property_id) {
		case CAMERA_WIDGETS_CAMERA_VIEW_N_CAMERAS_PROPERTY:
		g_value_set_uint (value, camera_widgets_camera_view_get_n_cameras (self));
		break;
		case CAMERA_WIDGETS_CAMERA_VIEW_RECORDING_PROPERTY:
		g_value_set_boolean (value, camera_widgets_camera_view_get_recording (self));
		break;
		case CAMERA_WIDGETS_CAMERA_VIEW_HORIZONTAL_FLIP_PROPERTY:
		g_value_set_boolean (value, camera_widgets_camera_view_get_horizontal_flip (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_camera_widgets_camera_view_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec)
{
	CameraWidgetsCameraView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CAMERA_WIDGETS_TYPE_CAMERA_VIEW, CameraWidgetsCameraView);
	switch (property_id) {
		case CAMERA_WIDGETS_CAMERA_VIEW_RECORDING_PROPERTY:
		camera_widgets_camera_view_set_recording (self, g_value_get_boolean (value));
		break;
		case CAMERA_WIDGETS_CAMERA_VIEW_HORIZONTAL_FLIP_PROPERTY:
		camera_widgets_camera_view_set_horizontal_flip (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

