{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Generated during 'GI.Gdk.Enums.InputSourceTabletPad' button presses and releases.
-- 
-- /Since: 3.22/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gdk.Structs.EventPadButton
    ( 

-- * Exported types
    EventPadButton(..)                      ,
    newZeroEventPadButton                   ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveEventPadButtonMethod             ,
#endif



 -- * Properties


-- ** button #attr:button#
-- | The pad button that was pressed.

#if defined(ENABLE_OVERLOADING)
    eventPadButton_button                   ,
#endif
    getEventPadButtonButton                 ,
    setEventPadButtonButton                 ,


-- ** group #attr:group#
-- | the pad group the button belongs to. A 'GI.Gdk.Enums.InputSourceTabletPad' device
--   may have one or more groups containing a set of buttons\/rings\/strips each.

#if defined(ENABLE_OVERLOADING)
    eventPadButton_group                    ,
#endif
    getEventPadButtonGroup                  ,
    setEventPadButtonGroup                  ,


-- ** mode #attr:mode#
-- | The current mode of /@group@/. Different groups in a 'GI.Gdk.Enums.InputSourceTabletPad'
--   device may have different current modes.

#if defined(ENABLE_OVERLOADING)
    eventPadButton_mode                     ,
#endif
    getEventPadButtonMode                   ,
    setEventPadButtonMode                   ,


-- ** sendEvent #attr:sendEvent#
-- | 'P.True' if the event was sent explicitly.

#if defined(ENABLE_OVERLOADING)
    eventPadButton_sendEvent                ,
#endif
    getEventPadButtonSendEvent              ,
    setEventPadButtonSendEvent              ,


-- ** time #attr:time#
-- | the time of the event in milliseconds.

#if defined(ENABLE_OVERLOADING)
    eventPadButton_time                     ,
#endif
    getEventPadButtonTime                   ,
    setEventPadButtonTime                   ,


-- ** type #attr:type#
-- | the type of the event ('GI.Gdk.Enums.EventTypePadButtonPress' or 'GI.Gdk.Enums.EventTypePadButtonRelease').

#if defined(ENABLE_OVERLOADING)
    eventPadButton_type                     ,
#endif
    getEventPadButtonType                   ,
    setEventPadButtonType                   ,


-- ** window #attr:window#
-- | the window which received the event.

    clearEventPadButtonWindow               ,
#if defined(ENABLE_OVERLOADING)
    eventPadButton_window                   ,
#endif
    getEventPadButtonWindow                 ,
    setEventPadButtonWindow                 ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Enums as Cairo.Enums
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.Cairo.Structs.Pattern as Cairo.Pattern
import qualified GI.Cairo.Structs.Region as Cairo.Region
import qualified GI.Cairo.Structs.Surface as Cairo.Surface
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Callbacks as Gdk.Callbacks
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Flags as Gdk.Flags
import {-# SOURCE #-} qualified GI.Gdk.Objects.AppLaunchContext as Gdk.AppLaunchContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Device as Gdk.Device
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceManager as Gdk.DeviceManager
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceTool as Gdk.DeviceTool
import {-# SOURCE #-} qualified GI.Gdk.Objects.Display as Gdk.Display
import {-# SOURCE #-} qualified GI.Gdk.Objects.DragContext as Gdk.DragContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.DrawingContext as Gdk.DrawingContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import {-# SOURCE #-} qualified GI.Gdk.Objects.GLContext as Gdk.GLContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Monitor as Gdk.Monitor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Screen as Gdk.Screen
import {-# SOURCE #-} qualified GI.Gdk.Objects.Seat as Gdk.Seat
import {-# SOURCE #-} qualified GI.Gdk.Objects.Visual as Gdk.Visual
import {-# SOURCE #-} qualified GI.Gdk.Objects.Window as Gdk.Window
import {-# SOURCE #-} qualified GI.Gdk.Structs.Atom as Gdk.Atom
import {-# SOURCE #-} qualified GI.Gdk.Structs.Color as Gdk.Color
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventAny as Gdk.EventAny
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventButton as Gdk.EventButton
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventConfigure as Gdk.EventConfigure
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventCrossing as Gdk.EventCrossing
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventDND as Gdk.EventDND
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventExpose as Gdk.EventExpose
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventFocus as Gdk.EventFocus
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventGrabBroken as Gdk.EventGrabBroken
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventKey as Gdk.EventKey
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventMotion as Gdk.EventMotion
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventOwnerChange as Gdk.EventOwnerChange
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadAxis as Gdk.EventPadAxis
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadGroupMode as Gdk.EventPadGroupMode
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventProperty as Gdk.EventProperty
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventProximity as Gdk.EventProximity
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventScroll as Gdk.EventScroll
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSelection as Gdk.EventSelection
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSequence as Gdk.EventSequence
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSetting as Gdk.EventSetting
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouch as Gdk.EventTouch
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouchpadPinch as Gdk.EventTouchpadPinch
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouchpadSwipe as Gdk.EventTouchpadSwipe
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventVisibility as Gdk.EventVisibility
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventWindowState as Gdk.EventWindowState
import {-# SOURCE #-} qualified GI.Gdk.Structs.FrameTimings as Gdk.FrameTimings
import {-# SOURCE #-} qualified GI.Gdk.Structs.Geometry as Gdk.Geometry
import {-# SOURCE #-} qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import {-# SOURCE #-} qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import {-# SOURCE #-} qualified GI.Gdk.Structs.WindowAttr as Gdk.WindowAttr
import {-# SOURCE #-} qualified GI.Gdk.Unions.Event as Gdk.Event
import qualified GI.GdkPixbuf.Objects.Pixbuf as GdkPixbuf.Pixbuf
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Objects.AppLaunchContext as Gio.AppLaunchContext

#else
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Objects.Window as Gdk.Window

#endif

-- | Memory-managed wrapper type.
newtype EventPadButton = EventPadButton (SP.ManagedPtr EventPadButton)
    deriving (Eq)

instance SP.ManagedPtrNewtype EventPadButton where
    toManagedPtr (EventPadButton p) = p

instance BoxedPtr EventPadButton where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 40 >=> B.ManagedPtr.wrapPtr EventPadButton)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr EventPadButton where
    boxedPtrCalloc = callocBytes 40


-- | Construct a t'EventPadButton' struct initialized to zero.
newZeroEventPadButton :: MonadIO m => m EventPadButton
newZeroEventPadButton = liftIO $ boxedPtrCalloc >>= wrapPtr EventPadButton

instance tag ~ 'AttrSet => Constructible EventPadButton tag where
    new _ attrs = do
        o <- newZeroEventPadButton
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@type@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventPadButton #type
-- @
getEventPadButtonType :: MonadIO m => EventPadButton -> m Gdk.Enums.EventType
getEventPadButtonType s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO CInt
    let val' = (toEnum . fromIntegral) val
    return val'

-- | Set the value of the “@type@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventPadButton [ #type 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventPadButtonType :: MonadIO m => EventPadButton -> Gdk.Enums.EventType -> m ()
setEventPadButtonType s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = (fromIntegral . fromEnum) val
    poke (ptr `plusPtr` 0) (val' :: CInt)

#if defined(ENABLE_OVERLOADING)
data EventPadButtonTypeFieldInfo
instance AttrInfo EventPadButtonTypeFieldInfo where
    type AttrBaseTypeConstraint EventPadButtonTypeFieldInfo = (~) EventPadButton
    type AttrAllowedOps EventPadButtonTypeFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventPadButtonTypeFieldInfo = (~) Gdk.Enums.EventType
    type AttrTransferTypeConstraint EventPadButtonTypeFieldInfo = (~)Gdk.Enums.EventType
    type AttrTransferType EventPadButtonTypeFieldInfo = Gdk.Enums.EventType
    type AttrGetType EventPadButtonTypeFieldInfo = Gdk.Enums.EventType
    type AttrLabel EventPadButtonTypeFieldInfo = "type"
    type AttrOrigin EventPadButtonTypeFieldInfo = EventPadButton
    attrGet = getEventPadButtonType
    attrSet = setEventPadButtonType
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventPadButton.type"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Structs-EventPadButton.html#g:attr:type"
        })

eventPadButton_type :: AttrLabelProxy "type"
eventPadButton_type = AttrLabelProxy

#endif


-- | Get the value of the “@window@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventPadButton #window
-- @
getEventPadButtonWindow :: MonadIO m => EventPadButton -> m (Maybe Gdk.Window.Window)
getEventPadButtonWindow s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 8) :: IO (Ptr Gdk.Window.Window)
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- (newObject Gdk.Window.Window) val'
        return val''
    return result

-- | Set the value of the “@window@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventPadButton [ #window 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventPadButtonWindow :: MonadIO m => EventPadButton -> Ptr Gdk.Window.Window -> m ()
setEventPadButtonWindow s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (val :: Ptr Gdk.Window.Window)

-- | Set the value of the “@window@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #window
-- @
clearEventPadButtonWindow :: MonadIO m => EventPadButton -> m ()
clearEventPadButtonWindow s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (FP.nullPtr :: Ptr Gdk.Window.Window)

#if defined(ENABLE_OVERLOADING)
data EventPadButtonWindowFieldInfo
instance AttrInfo EventPadButtonWindowFieldInfo where
    type AttrBaseTypeConstraint EventPadButtonWindowFieldInfo = (~) EventPadButton
    type AttrAllowedOps EventPadButtonWindowFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint EventPadButtonWindowFieldInfo = (~) (Ptr Gdk.Window.Window)
    type AttrTransferTypeConstraint EventPadButtonWindowFieldInfo = (~)(Ptr Gdk.Window.Window)
    type AttrTransferType EventPadButtonWindowFieldInfo = (Ptr Gdk.Window.Window)
    type AttrGetType EventPadButtonWindowFieldInfo = Maybe Gdk.Window.Window
    type AttrLabel EventPadButtonWindowFieldInfo = "window"
    type AttrOrigin EventPadButtonWindowFieldInfo = EventPadButton
    attrGet = getEventPadButtonWindow
    attrSet = setEventPadButtonWindow
    attrConstruct = undefined
    attrClear = clearEventPadButtonWindow
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventPadButton.window"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Structs-EventPadButton.html#g:attr:window"
        })

eventPadButton_window :: AttrLabelProxy "window"
eventPadButton_window = AttrLabelProxy

#endif


-- | Get the value of the “@send_event@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventPadButton #sendEvent
-- @
getEventPadButtonSendEvent :: MonadIO m => EventPadButton -> m Int8
getEventPadButtonSendEvent s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 16) :: IO Int8
    return val

-- | Set the value of the “@send_event@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventPadButton [ #sendEvent 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventPadButtonSendEvent :: MonadIO m => EventPadButton -> Int8 -> m ()
setEventPadButtonSendEvent s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (val :: Int8)

#if defined(ENABLE_OVERLOADING)
data EventPadButtonSendEventFieldInfo
instance AttrInfo EventPadButtonSendEventFieldInfo where
    type AttrBaseTypeConstraint EventPadButtonSendEventFieldInfo = (~) EventPadButton
    type AttrAllowedOps EventPadButtonSendEventFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventPadButtonSendEventFieldInfo = (~) Int8
    type AttrTransferTypeConstraint EventPadButtonSendEventFieldInfo = (~)Int8
    type AttrTransferType EventPadButtonSendEventFieldInfo = Int8
    type AttrGetType EventPadButtonSendEventFieldInfo = Int8
    type AttrLabel EventPadButtonSendEventFieldInfo = "send_event"
    type AttrOrigin EventPadButtonSendEventFieldInfo = EventPadButton
    attrGet = getEventPadButtonSendEvent
    attrSet = setEventPadButtonSendEvent
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventPadButton.sendEvent"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Structs-EventPadButton.html#g:attr:sendEvent"
        })

eventPadButton_sendEvent :: AttrLabelProxy "sendEvent"
eventPadButton_sendEvent = AttrLabelProxy

#endif


-- | Get the value of the “@time@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventPadButton #time
-- @
getEventPadButtonTime :: MonadIO m => EventPadButton -> m Word32
getEventPadButtonTime s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 20) :: IO Word32
    return val

-- | Set the value of the “@time@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventPadButton [ #time 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventPadButtonTime :: MonadIO m => EventPadButton -> Word32 -> m ()
setEventPadButtonTime s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 20) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data EventPadButtonTimeFieldInfo
instance AttrInfo EventPadButtonTimeFieldInfo where
    type AttrBaseTypeConstraint EventPadButtonTimeFieldInfo = (~) EventPadButton
    type AttrAllowedOps EventPadButtonTimeFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventPadButtonTimeFieldInfo = (~) Word32
    type AttrTransferTypeConstraint EventPadButtonTimeFieldInfo = (~)Word32
    type AttrTransferType EventPadButtonTimeFieldInfo = Word32
    type AttrGetType EventPadButtonTimeFieldInfo = Word32
    type AttrLabel EventPadButtonTimeFieldInfo = "time"
    type AttrOrigin EventPadButtonTimeFieldInfo = EventPadButton
    attrGet = getEventPadButtonTime
    attrSet = setEventPadButtonTime
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventPadButton.time"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Structs-EventPadButton.html#g:attr:time"
        })

eventPadButton_time :: AttrLabelProxy "time"
eventPadButton_time = AttrLabelProxy

#endif


-- | Get the value of the “@group@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventPadButton #group
-- @
getEventPadButtonGroup :: MonadIO m => EventPadButton -> m Word32
getEventPadButtonGroup s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 24) :: IO Word32
    return val

-- | Set the value of the “@group@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventPadButton [ #group 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventPadButtonGroup :: MonadIO m => EventPadButton -> Word32 -> m ()
setEventPadButtonGroup s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 24) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data EventPadButtonGroupFieldInfo
instance AttrInfo EventPadButtonGroupFieldInfo where
    type AttrBaseTypeConstraint EventPadButtonGroupFieldInfo = (~) EventPadButton
    type AttrAllowedOps EventPadButtonGroupFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventPadButtonGroupFieldInfo = (~) Word32
    type AttrTransferTypeConstraint EventPadButtonGroupFieldInfo = (~)Word32
    type AttrTransferType EventPadButtonGroupFieldInfo = Word32
    type AttrGetType EventPadButtonGroupFieldInfo = Word32
    type AttrLabel EventPadButtonGroupFieldInfo = "group"
    type AttrOrigin EventPadButtonGroupFieldInfo = EventPadButton
    attrGet = getEventPadButtonGroup
    attrSet = setEventPadButtonGroup
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventPadButton.group"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Structs-EventPadButton.html#g:attr:group"
        })

eventPadButton_group :: AttrLabelProxy "group"
eventPadButton_group = AttrLabelProxy

#endif


-- | Get the value of the “@button@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventPadButton #button
-- @
getEventPadButtonButton :: MonadIO m => EventPadButton -> m Word32
getEventPadButtonButton s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 28) :: IO Word32
    return val

-- | Set the value of the “@button@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventPadButton [ #button 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventPadButtonButton :: MonadIO m => EventPadButton -> Word32 -> m ()
setEventPadButtonButton s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 28) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data EventPadButtonButtonFieldInfo
instance AttrInfo EventPadButtonButtonFieldInfo where
    type AttrBaseTypeConstraint EventPadButtonButtonFieldInfo = (~) EventPadButton
    type AttrAllowedOps EventPadButtonButtonFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventPadButtonButtonFieldInfo = (~) Word32
    type AttrTransferTypeConstraint EventPadButtonButtonFieldInfo = (~)Word32
    type AttrTransferType EventPadButtonButtonFieldInfo = Word32
    type AttrGetType EventPadButtonButtonFieldInfo = Word32
    type AttrLabel EventPadButtonButtonFieldInfo = "button"
    type AttrOrigin EventPadButtonButtonFieldInfo = EventPadButton
    attrGet = getEventPadButtonButton
    attrSet = setEventPadButtonButton
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventPadButton.button"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Structs-EventPadButton.html#g:attr:button"
        })

eventPadButton_button :: AttrLabelProxy "button"
eventPadButton_button = AttrLabelProxy

#endif


-- | Get the value of the “@mode@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventPadButton #mode
-- @
getEventPadButtonMode :: MonadIO m => EventPadButton -> m Word32
getEventPadButtonMode s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 32) :: IO Word32
    return val

-- | Set the value of the “@mode@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventPadButton [ #mode 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventPadButtonMode :: MonadIO m => EventPadButton -> Word32 -> m ()
setEventPadButtonMode s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 32) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data EventPadButtonModeFieldInfo
instance AttrInfo EventPadButtonModeFieldInfo where
    type AttrBaseTypeConstraint EventPadButtonModeFieldInfo = (~) EventPadButton
    type AttrAllowedOps EventPadButtonModeFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventPadButtonModeFieldInfo = (~) Word32
    type AttrTransferTypeConstraint EventPadButtonModeFieldInfo = (~)Word32
    type AttrTransferType EventPadButtonModeFieldInfo = Word32
    type AttrGetType EventPadButtonModeFieldInfo = Word32
    type AttrLabel EventPadButtonModeFieldInfo = "mode"
    type AttrOrigin EventPadButtonModeFieldInfo = EventPadButton
    attrGet = getEventPadButtonMode
    attrSet = setEventPadButtonMode
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventPadButton.mode"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Structs-EventPadButton.html#g:attr:mode"
        })

eventPadButton_mode :: AttrLabelProxy "mode"
eventPadButton_mode = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList EventPadButton
type instance O.AttributeList EventPadButton = EventPadButtonAttributeList
type EventPadButtonAttributeList = ('[ '("type", EventPadButtonTypeFieldInfo), '("window", EventPadButtonWindowFieldInfo), '("sendEvent", EventPadButtonSendEventFieldInfo), '("time", EventPadButtonTimeFieldInfo), '("group", EventPadButtonGroupFieldInfo), '("button", EventPadButtonButtonFieldInfo), '("mode", EventPadButtonModeFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveEventPadButtonMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveEventPadButtonMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveEventPadButtonMethod t EventPadButton, O.OverloadedMethod info EventPadButton p) => OL.IsLabel t (EventPadButton -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveEventPadButtonMethod t EventPadButton, O.OverloadedMethod info EventPadButton p, R.HasField t EventPadButton p) => R.HasField t EventPadButton p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveEventPadButtonMethod t EventPadButton, O.OverloadedMethodInfo info EventPadButton) => OL.IsLabel t (O.MethodProxy info EventPadButton) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


