/* util-ascii.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from util-ascii.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

static guint8 __lambda13_ (guint8 b);
static guint8 ___lambda13__geary_collection_byte_transformer (guint8 b,
                                                       gpointer self);

gint
geary_ascii_index_of (const gchar* str,
                      gchar ch)
{
	gint ret = 0;
	gchar* strptr = NULL;
	gint i = 0;
	gint result;
	g_return_val_if_fail (str != NULL, 0);
	ret = -1;
	strptr = str;
	i = 0;
	while (TRUE) {
		gchar* _tmp0_;
		gchar* _tmp1_;
		gchar _tmp2_;
		gint _tmp3_;
		_tmp0_ = strptr;
		if (!((*_tmp0_) != GEARY_STRING_EOS)) {
			break;
		}
		_tmp1_ = strptr;
		strptr = _tmp1_ + 1;
		_tmp2_ = ch;
		if ((*_tmp1_) == _tmp2_) {
			ret = i;
			break;
		}
		_tmp3_ = i;
		i = _tmp3_ + 1;
	}
	result = ret;
	return result;
}

gint
geary_ascii_last_index_of (const gchar* str,
                           gchar ch)
{
	gint ret = 0;
	gchar* strptr = NULL;
	gint i = 0;
	gint result;
	g_return_val_if_fail (str != NULL, 0);
	ret = -1;
	strptr = str;
	i = 0;
	while (TRUE) {
		gchar* _tmp0_;
		gchar* _tmp1_;
		gchar _tmp2_;
		gint _tmp3_;
		_tmp0_ = strptr;
		if (!((*_tmp0_) != GEARY_STRING_EOS)) {
			break;
		}
		_tmp1_ = strptr;
		strptr = _tmp1_ + 1;
		_tmp2_ = ch;
		if ((*_tmp1_) == _tmp2_) {
			ret = i;
		}
		_tmp3_ = i;
		i = _tmp3_ + 1;
	}
	result = ret;
	return result;
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

gboolean
geary_ascii_get_next_char (const gchar* str,
                           gint* index,
                           gchar* ch)
{
	gchar _vala_ch = '\0';
	gint _tmp0_;
	gboolean result;
	g_return_val_if_fail (str != NULL, FALSE);
	_tmp0_ = *index;
	*index = _tmp0_ + 1;
	_vala_ch = string_get (str, (glong) _tmp0_);
	result = _vala_ch != GEARY_STRING_EOS;
	if (ch) {
		*ch = _vala_ch;
	}
	return result;
}

inline gint
geary_ascii_strcmp (const gchar* a,
                    const gchar* b)
{
	GCompareFunc _tmp0_;
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = ((GCompareFunc) g_strcmp0);
	result = _tmp0_ (a, b);
	return result;
}

inline gint
geary_ascii_stricmp (const gchar* a,
                     const gchar* b)
{
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	result = g_ascii_strcasecmp (a, b);
	return result;
}

inline gboolean
geary_ascii_str_equal (const gchar* a,
                       const gchar* b)
{
	gboolean result;
	g_return_val_if_fail (a != NULL, FALSE);
	g_return_val_if_fail (b != NULL, FALSE);
	result = g_strcmp0 (a, b) == 0;
	return result;
}

inline gboolean
geary_ascii_stri_equal (const gchar* a,
                        const gchar* b)
{
	gboolean result;
	g_return_val_if_fail (a != NULL, FALSE);
	g_return_val_if_fail (b != NULL, FALSE);
	result = g_ascii_strcasecmp (a, b) == 0;
	return result;
}

gboolean
geary_ascii_nullable_stri_equal (const gchar* a,
                                 const gchar* b)
{
	gboolean result;
	if (a == NULL) {
		result = b == NULL;
		return result;
	}
	if (b == NULL) {
		result = FALSE;
		return result;
	}
	result = geary_ascii_stri_equal (a, b);
	return result;
}

guint
geary_ascii_str_hash (const gchar* str)
{
	guint result;
	g_return_val_if_fail (str != NULL, 0U);
	result = geary_collection_hash_memory_stream ((gchar*) str, (guint8) GEARY_STRING_EOS, NULL, NULL);
	return result;
}

static guint8
__lambda13_ (guint8 b)
{
	guint8 result;
	result = (guint8) g_ascii_tolower ((gchar) b);
	return result;
}

static guint8
___lambda13__geary_collection_byte_transformer (guint8 b,
                                                gpointer self)
{
	guint8 result;
	result = __lambda13_ (b);
	return result;
}

guint
geary_ascii_stri_hash (const gchar* str)
{
	guint result;
	g_return_val_if_fail (str != NULL, 0U);
	result = geary_collection_hash_memory_stream ((gchar*) str, (guint8) GEARY_STRING_EOS, ___lambda13__geary_collection_byte_transformer, NULL);
	return result;
}

guint
geary_ascii_nullable_stri_hash (const gchar* str)
{
	guint _tmp0_ = 0U;
	guint result;
	if (str != NULL) {
		_tmp0_ = geary_ascii_stri_hash (str);
	} else {
		_tmp0_ = (guint) 0;
	}
	result = _tmp0_;
	return result;
}

inline gchar*
geary_ascii_strdown (const gchar* str)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (str != NULL, NULL);
	_tmp0_ = g_ascii_strdown (str, (gssize) -1);
	result = _tmp0_;
	return result;
}

inline gchar*
geary_ascii_strup (const gchar* str)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (str != NULL, NULL);
	_tmp0_ = g_ascii_strup (str, (gssize) -1);
	result = _tmp0_;
	return result;
}

/**
 * Returns true if the ASCII string contains only whitespace and at least one numeric character.
 */
gboolean
geary_ascii_is_numeric (const gchar* str)
{
	gboolean numeric_found = FALSE;
	gchar* strptr = NULL;
	gboolean result;
	g_return_val_if_fail (str != NULL, FALSE);
	numeric_found = FALSE;
	strptr = str;
	{
		gboolean _tmp0_ = FALSE;
		_tmp0_ = TRUE;
		while (TRUE) {
			gchar ch = '\0';
			gchar* _tmp1_;
			if (!_tmp0_) {
			}
			_tmp0_ = FALSE;
			_tmp1_ = strptr;
			strptr = _tmp1_ + 1;
			ch = *_tmp1_;
			if (ch == GEARY_STRING_EOS) {
				break;
			}
			if (g_ascii_isdigit (ch)) {
				numeric_found = TRUE;
			} else {
				if (!g_ascii_isspace (ch)) {
					result = FALSE;
					return result;
				}
			}
		}
	}
	result = numeric_found;
	return result;
}

/**
 * Returns char from 0 to 9 converted to an int.  If a non-numeric value, -1 is returned.
 */
inline gint
geary_ascii_digit_to_int (gchar ch)
{
	gint _tmp0_ = 0;
	gint result;
	if (g_ascii_isdigit (ch)) {
		_tmp0_ = (gint) (ch - '0');
	} else {
		_tmp0_ = -1;
	}
	result = _tmp0_;
	return result;
}

