/* db-transaction-async-job.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from db-transaction-async-job.vala, do not modify */

/*
 * Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define GEARY_DB_TYPE_TRANSACTION_ASYNC_JOB (geary_db_transaction_async_job_get_type ())
#define GEARY_DB_TRANSACTION_ASYNC_JOB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_DB_TYPE_TRANSACTION_ASYNC_JOB, GearyDbTransactionAsyncJob))
#define GEARY_DB_TRANSACTION_ASYNC_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEARY_DB_TYPE_TRANSACTION_ASYNC_JOB, GearyDbTransactionAsyncJobClass))
#define GEARY_DB_IS_TRANSACTION_ASYNC_JOB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_DB_TYPE_TRANSACTION_ASYNC_JOB))
#define GEARY_DB_IS_TRANSACTION_ASYNC_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEARY_DB_TYPE_TRANSACTION_ASYNC_JOB))
#define GEARY_DB_TRANSACTION_ASYNC_JOB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEARY_DB_TYPE_TRANSACTION_ASYNC_JOB, GearyDbTransactionAsyncJobClass))

typedef struct _GearyDbTransactionAsyncJob GearyDbTransactionAsyncJob;
typedef struct _GearyDbTransactionAsyncJobClass GearyDbTransactionAsyncJobClass;
typedef struct _GearyDbTransactionAsyncJobPrivate GearyDbTransactionAsyncJobPrivate;
enum  {
	GEARY_DB_TRANSACTION_ASYNC_JOB_0_PROPERTY,
	GEARY_DB_TRANSACTION_ASYNC_JOB_DEFAULT_CX_PROPERTY,
	GEARY_DB_TRANSACTION_ASYNC_JOB_CANCELLABLE_PROPERTY,
	GEARY_DB_TRANSACTION_ASYNC_JOB_NUM_PROPERTIES
};
static GParamSpec* geary_db_transaction_async_job_properties[GEARY_DB_TRANSACTION_ASYNC_JOB_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _GearyDbTransactionAsyncJobWaitForCompletionAsyncData GearyDbTransactionAsyncJobWaitForCompletionAsyncData;

struct _GearyDbTransactionAsyncJob {
	GearyBaseObject parent_instance;
	GearyDbTransactionAsyncJobPrivate * priv;
};

struct _GearyDbTransactionAsyncJobClass {
	GearyBaseObjectClass parent_class;
};

struct _GearyDbTransactionAsyncJobPrivate {
	GearyDbDatabaseConnection* _default_cx;
	GCancellable* _cancellable;
	GearyDbTransactionType type;
	GearyDbTransactionMethod cb;
	gpointer cb_target;
	GearyNonblockingEvent* completed;
	GearyDbTransactionOutcome outcome;
	GError* caught_err;
};

struct _GearyDbTransactionAsyncJobWaitForCompletionAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyDbTransactionAsyncJob* self;
	GearyDbTransactionOutcome result;
	GearyNonblockingEvent* _tmp0_;
	GError* _tmp1_;
	GError* _tmp2_;
	GError* _tmp3_;
	GError* _inner_error0_;
};

static gint GearyDbTransactionAsyncJob_private_offset;
static gpointer geary_db_transaction_async_job_parent_class = NULL;

VALA_EXTERN GType geary_db_transaction_async_job_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GearyDbDatabaseConnection* geary_db_transaction_async_job_get_default_cx (GearyDbTransactionAsyncJob* self);
static void geary_db_transaction_async_job_set_default_cx (GearyDbTransactionAsyncJob* self,
                                                    GearyDbDatabaseConnection* value);
VALA_EXTERN GCancellable* geary_db_transaction_async_job_get_cancellable (GearyDbTransactionAsyncJob* self);
static void geary_db_transaction_async_job_set_cancellable (GearyDbTransactionAsyncJob* self,
                                                     GCancellable* value);
VALA_EXTERN GearyDbTransactionAsyncJob* geary_db_transaction_async_job_new (GearyDbDatabaseConnection* default_cx,
                                                                GearyDbTransactionType type,
                                                                GearyDbTransactionMethod cb,
                                                                gpointer cb_target,
                                                                GCancellable* cancellable);
VALA_EXTERN GearyDbTransactionAsyncJob* geary_db_transaction_async_job_construct (GType object_type,
                                                                      GearyDbDatabaseConnection* default_cx,
                                                                      GearyDbTransactionType type,
                                                                      GearyDbTransactionMethod cb,
                                                                      gpointer cb_target,
                                                                      GCancellable* cancellable);
VALA_EXTERN gboolean geary_db_transaction_async_job_is_cancelled (GearyDbTransactionAsyncJob* self);
VALA_EXTERN void geary_db_transaction_async_job_execute (GearyDbTransactionAsyncJob* self,
                                             GearyDbDatabaseConnection* cx);
static void geary_db_transaction_async_job_schedule_completion (GearyDbTransactionAsyncJob* self);
VALA_EXTERN void geary_db_transaction_async_job_failed (GearyDbTransactionAsyncJob* self,
                                            GError* err);
static gboolean geary_db_transaction_async_job_on_notify_completed (GearyDbTransactionAsyncJob* self);
static gboolean _geary_db_transaction_async_job_on_notify_completed_gsource_func (gpointer self);
static void geary_db_transaction_async_job_wait_for_completion_async_data_free (gpointer _data);
VALA_EXTERN void geary_db_transaction_async_job_wait_for_completion_async (GearyDbTransactionAsyncJob* self,
                                                               GAsyncReadyCallback _callback_,
                                                               gpointer _user_data_);
VALA_EXTERN GearyDbTransactionOutcome geary_db_transaction_async_job_wait_for_completion_finish (GearyDbTransactionAsyncJob* self,
                                                                                     GAsyncResult* _res_,
                                                                                     GError** error);
static gboolean geary_db_transaction_async_job_wait_for_completion_async_co (GearyDbTransactionAsyncJobWaitForCompletionAsyncData* _data_);
static void geary_db_transaction_async_job_wait_for_completion_async_ready (GObject* source_object,
                                                                     GAsyncResult* _res_,
                                                                     gpointer _user_data_);
static void geary_db_transaction_async_job_finalize (GObject * obj);
static GType geary_db_transaction_async_job_get_type_once (void);
static void _vala_geary_db_transaction_async_job_get_property (GObject * object,
                                                        guint property_id,
                                                        GValue * value,
                                                        GParamSpec * pspec);
static void _vala_geary_db_transaction_async_job_set_property (GObject * object,
                                                        guint property_id,
                                                        const GValue * value,
                                                        GParamSpec * pspec);

static inline gpointer
geary_db_transaction_async_job_get_instance_private (GearyDbTransactionAsyncJob* self)
{
	return G_STRUCT_MEMBER_P (self, GearyDbTransactionAsyncJob_private_offset);
}

GearyDbDatabaseConnection*
geary_db_transaction_async_job_get_default_cx (GearyDbTransactionAsyncJob* self)
{
	GearyDbDatabaseConnection* result;
	GearyDbDatabaseConnection* _tmp0_;
	g_return_val_if_fail (GEARY_DB_IS_TRANSACTION_ASYNC_JOB (self), NULL);
	_tmp0_ = self->priv->_default_cx;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
geary_db_transaction_async_job_set_default_cx (GearyDbTransactionAsyncJob* self,
                                               GearyDbDatabaseConnection* value)
{
	GearyDbDatabaseConnection* old_value;
	g_return_if_fail (GEARY_DB_IS_TRANSACTION_ASYNC_JOB (self));
	old_value = geary_db_transaction_async_job_get_default_cx (self);
	if (old_value != value) {
		GearyDbDatabaseConnection* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_default_cx);
		self->priv->_default_cx = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_db_transaction_async_job_properties[GEARY_DB_TRANSACTION_ASYNC_JOB_DEFAULT_CX_PROPERTY]);
	}
}

GCancellable*
geary_db_transaction_async_job_get_cancellable (GearyDbTransactionAsyncJob* self)
{
	GCancellable* result;
	GCancellable* _tmp0_;
	g_return_val_if_fail (GEARY_DB_IS_TRANSACTION_ASYNC_JOB (self), NULL);
	_tmp0_ = self->priv->_cancellable;
	result = _tmp0_;
	return result;
}

static void
geary_db_transaction_async_job_set_cancellable (GearyDbTransactionAsyncJob* self,
                                                GCancellable* value)
{
	GCancellable* old_value;
	g_return_if_fail (GEARY_DB_IS_TRANSACTION_ASYNC_JOB (self));
	old_value = geary_db_transaction_async_job_get_cancellable (self);
	if (old_value != value) {
		GCancellable* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_cancellable);
		self->priv->_cancellable = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_db_transaction_async_job_properties[GEARY_DB_TRANSACTION_ASYNC_JOB_CANCELLABLE_PROPERTY]);
	}
}

GearyDbTransactionAsyncJob*
geary_db_transaction_async_job_construct (GType object_type,
                                          GearyDbDatabaseConnection* default_cx,
                                          GearyDbTransactionType type,
                                          GearyDbTransactionMethod cb,
                                          gpointer cb_target,
                                          GCancellable* cancellable)
{
	GearyDbTransactionAsyncJob * self = NULL;
	GCancellable* _tmp0_ = NULL;
	GCancellable* _tmp1_;
	GearyNonblockingEvent* _tmp3_;
	g_return_val_if_fail ((default_cx == NULL) || GEARY_DB_IS_DATABASE_CONNECTION (default_cx), NULL);
	g_return_val_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()), NULL);
	self = (GearyDbTransactionAsyncJob*) geary_base_object_construct (object_type);
	geary_db_transaction_async_job_set_default_cx (self, default_cx);
	self->priv->type = type;
	self->priv->cb = cb;
	self->priv->cb_target = cb_target;
	_tmp1_ = _g_object_ref0 (cancellable);
	_tmp0_ = _tmp1_;
	if (_tmp0_ == NULL) {
		GCancellable* _tmp2_;
		_tmp2_ = g_cancellable_new ();
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp2_;
	}
	geary_db_transaction_async_job_set_cancellable (self, _tmp0_);
	_tmp3_ = geary_nonblocking_event_new (NULL);
	_g_object_unref0 (self->priv->completed);
	self->priv->completed = _tmp3_;
	_g_object_unref0 (_tmp0_);
	return self;
}

GearyDbTransactionAsyncJob*
geary_db_transaction_async_job_new (GearyDbDatabaseConnection* default_cx,
                                    GearyDbTransactionType type,
                                    GearyDbTransactionMethod cb,
                                    gpointer cb_target,
                                    GCancellable* cancellable)
{
	return geary_db_transaction_async_job_construct (GEARY_DB_TYPE_TRANSACTION_ASYNC_JOB, default_cx, type, cb, cb_target, cancellable);
}

gboolean
geary_db_transaction_async_job_is_cancelled (GearyDbTransactionAsyncJob* self)
{
	GCancellable* _tmp0_;
	gboolean result;
	g_return_val_if_fail (GEARY_DB_IS_TRANSACTION_ASYNC_JOB (self), FALSE);
	_tmp0_ = self->priv->_cancellable;
	result = g_cancellable_is_cancelled (_tmp0_);
	return result;
}

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

void
geary_db_transaction_async_job_execute (GearyDbTransactionAsyncJob* self,
                                        GearyDbDatabaseConnection* cx)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (GEARY_DB_IS_TRANSACTION_ASYNC_JOB (self));
	g_return_if_fail (GEARY_DB_IS_DATABASE_CONNECTION (cx));
	{
		GearyDbTransactionOutcome _tmp1_ = 0;
		GearyDbTransactionMethod _tmp2_;
		gpointer _tmp2__target;
		GCancellable* _tmp3_;
		if (geary_db_transaction_async_job_is_cancelled (self)) {
			GError* _tmp0_;
			_tmp0_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_CANCELLED, "Async transaction cancelled");
			_inner_error0_ = _tmp0_;
			goto __catch0_g_error;
		}
		_tmp2_ = self->priv->cb;
		_tmp2__target = self->priv->cb_target;
		_tmp3_ = self->priv->_cancellable;
		_tmp1_ = geary_db_database_connection_exec_transaction (cx, self->priv->type, _tmp2_, _tmp2__target, _tmp3_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		self->priv->outcome = _tmp1_;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp4_;
		GError* _tmp7_;
		GError* _tmp8_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = err;
		if (!g_error_matches (_tmp4_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
			GError* _tmp5_;
			const gchar* _tmp6_;
			_tmp5_ = err;
			_tmp6_ = _tmp5_->message;
			g_debug ("db-transaction-async-job.vala:47: AsyncJob: transaction completed with" \
" error: %s", _tmp6_);
		}
		_tmp7_ = err;
		_tmp8_ = _g_error_copy0 (_tmp7_);
		_g_error_free0 (self->priv->caught_err);
		self->priv->caught_err = _tmp8_;
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	geary_db_transaction_async_job_schedule_completion (self);
}

void
geary_db_transaction_async_job_failed (GearyDbTransactionAsyncJob* self,
                                       GError* err)
{
	GError* _tmp0_;
	g_return_if_fail (GEARY_DB_IS_TRANSACTION_ASYNC_JOB (self));
	g_return_if_fail (err != NULL);
	_tmp0_ = _g_error_copy0 (err);
	_g_error_free0 (self->priv->caught_err);
	self->priv->caught_err = _tmp0_;
	geary_db_transaction_async_job_schedule_completion (self);
}

static gboolean
_geary_db_transaction_async_job_on_notify_completed_gsource_func (gpointer self)
{
	gboolean result;
	result = geary_db_transaction_async_job_on_notify_completed ((GearyDbTransactionAsyncJob*) self);
	return result;
}

static void
geary_db_transaction_async_job_schedule_completion (GearyDbTransactionAsyncJob* self)
{
	g_return_if_fail (GEARY_DB_IS_TRANSACTION_ASYNC_JOB (self));
	g_object_ref (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject));
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _geary_db_transaction_async_job_on_notify_completed_gsource_func, g_object_ref (self), g_object_unref);
}

static gboolean
geary_db_transaction_async_job_on_notify_completed (GearyDbTransactionAsyncJob* self)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (GEARY_DB_IS_TRANSACTION_ASYNC_JOB (self), FALSE);
	{
		GearyNonblockingEvent* _tmp0_;
		_tmp0_ = self->priv->completed;
		geary_nonblocking_lock_notify (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEARY_NONBLOCKING_TYPE_LOCK, GearyNonblockingLock), &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		gboolean _tmp1_ = FALSE;
		GError* _tmp2_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = self->priv->caught_err;
		if (_tmp2_ != NULL) {
			GError* _tmp3_;
			_tmp3_ = self->priv->caught_err;
			_tmp1_ = !g_error_matches (_tmp3_, G_IO_ERROR, G_IO_ERROR_CANCELLED);
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			GError* _tmp4_;
			const gchar* _tmp5_;
			GError* _tmp6_;
			const gchar* _tmp7_;
			_tmp4_ = self->priv->caught_err;
			_tmp5_ = _tmp4_->message;
			_tmp6_ = err;
			_tmp7_ = _tmp6_->message;
			g_debug ("db-transaction-async-job.vala:78: Unable to notify AsyncTransaction ha" \
"s completed w/ err %s: %s", _tmp5_, _tmp7_);
		} else {
			GError* _tmp8_;
			const gchar* _tmp9_;
			_tmp8_ = err;
			_tmp9_ = _tmp8_->message;
			g_debug ("db-transaction-async-job.vala:81: Unable to notify AsyncTransaction ha" \
"s completed w/o err: %s", _tmp9_);
		}
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp10_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp10_;
	}
	g_object_unref (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject));
	result = FALSE;
	return result;
}

static void
geary_db_transaction_async_job_wait_for_completion_async_data_free (gpointer _data)
{
	GearyDbTransactionAsyncJobWaitForCompletionAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyDbTransactionAsyncJobWaitForCompletionAsyncData, _data_);
}

void
geary_db_transaction_async_job_wait_for_completion_async (GearyDbTransactionAsyncJob* self,
                                                          GAsyncReadyCallback _callback_,
                                                          gpointer _user_data_)
{
	GearyDbTransactionAsyncJobWaitForCompletionAsyncData* _data_;
	GearyDbTransactionAsyncJob* _tmp0_;
	g_return_if_fail (GEARY_DB_IS_TRANSACTION_ASYNC_JOB (self));
	_data_ = g_slice_new0 (GearyDbTransactionAsyncJobWaitForCompletionAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_db_transaction_async_job_wait_for_completion_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	geary_db_transaction_async_job_wait_for_completion_async_co (_data_);
}

GearyDbTransactionOutcome
geary_db_transaction_async_job_wait_for_completion_finish (GearyDbTransactionAsyncJob* self,
                                                           GAsyncResult* _res_,
                                                           GError** error)
{
	GearyDbTransactionOutcome result;
	GearyDbTransactionAsyncJobWaitForCompletionAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return 0;
	}
	result = _data_->result;
	return result;
}

static void
geary_db_transaction_async_job_wait_for_completion_async_ready (GObject* source_object,
                                                                GAsyncResult* _res_,
                                                                gpointer _user_data_)
{
	GearyDbTransactionAsyncJobWaitForCompletionAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_db_transaction_async_job_wait_for_completion_async_co (_data_);
}

static gboolean
geary_db_transaction_async_job_wait_for_completion_async_co (GearyDbTransactionAsyncJobWaitForCompletionAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->completed;
	_data_->_state_ = 1;
	geary_nonblocking_lock_wait_async (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp0_, GEARY_NONBLOCKING_TYPE_LOCK, GearyNonblockingLock), NULL, geary_db_transaction_async_job_wait_for_completion_async_ready, _data_);
	return FALSE;
	_state_1:
	geary_nonblocking_lock_wait_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp0_, GEARY_NONBLOCKING_TYPE_LOCK, GearyNonblockingLock), _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = _data_->self->priv->caught_err;
	if (_data_->_tmp1_ != NULL) {
		_data_->_tmp2_ = _data_->self->priv->caught_err;
		_data_->_tmp3_ = _g_error_copy0 (_data_->_tmp2_);
		_data_->_inner_error0_ = _data_->_tmp3_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = _data_->self->priv->outcome;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_db_transaction_async_job_class_init (GearyDbTransactionAsyncJobClass * klass,
                                           gpointer klass_data)
{
	geary_db_transaction_async_job_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyDbTransactionAsyncJob_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_db_transaction_async_job_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_geary_db_transaction_async_job_set_property;
	G_OBJECT_CLASS (klass)->finalize = geary_db_transaction_async_job_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_DB_TRANSACTION_ASYNC_JOB_DEFAULT_CX_PROPERTY, geary_db_transaction_async_job_properties[GEARY_DB_TRANSACTION_ASYNC_JOB_DEFAULT_CX_PROPERTY] = g_param_spec_object ("default-cx", "default-cx", "default-cx", GEARY_DB_TYPE_DATABASE_CONNECTION, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_DB_TRANSACTION_ASYNC_JOB_CANCELLABLE_PROPERTY, geary_db_transaction_async_job_properties[GEARY_DB_TRANSACTION_ASYNC_JOB_CANCELLABLE_PROPERTY] = g_param_spec_object ("cancellable", "cancellable", "cancellable", g_cancellable_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
geary_db_transaction_async_job_instance_init (GearyDbTransactionAsyncJob * self,
                                              gpointer klass)
{
	self->priv = geary_db_transaction_async_job_get_instance_private (self);
	self->priv->outcome = GEARY_DB_TRANSACTION_OUTCOME_ROLLBACK;
	self->priv->caught_err = NULL;
}

static void
geary_db_transaction_async_job_finalize (GObject * obj)
{
	GearyDbTransactionAsyncJob * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_DB_TYPE_TRANSACTION_ASYNC_JOB, GearyDbTransactionAsyncJob);
	_g_object_unref0 (self->priv->_default_cx);
	_g_object_unref0 (self->priv->_cancellable);
	_g_object_unref0 (self->priv->completed);
	_g_error_free0 (self->priv->caught_err);
	G_OBJECT_CLASS (geary_db_transaction_async_job_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
geary_db_transaction_async_job_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyDbTransactionAsyncJobClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_db_transaction_async_job_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyDbTransactionAsyncJob), 0, (GInstanceInitFunc) geary_db_transaction_async_job_instance_init, NULL };
	GType geary_db_transaction_async_job_type_id;
	geary_db_transaction_async_job_type_id = g_type_register_static (GEARY_TYPE_BASE_OBJECT, "GearyDbTransactionAsyncJob", &g_define_type_info, 0);
	GearyDbTransactionAsyncJob_private_offset = g_type_add_instance_private (geary_db_transaction_async_job_type_id, sizeof (GearyDbTransactionAsyncJobPrivate));
	return geary_db_transaction_async_job_type_id;
}

GType
geary_db_transaction_async_job_get_type (void)
{
	static gsize geary_db_transaction_async_job_type_id__once = 0;
	if (g_once_init_enter (&geary_db_transaction_async_job_type_id__once)) {
		GType geary_db_transaction_async_job_type_id;
		geary_db_transaction_async_job_type_id = geary_db_transaction_async_job_get_type_once ();
		g_once_init_leave (&geary_db_transaction_async_job_type_id__once, geary_db_transaction_async_job_type_id);
	}
	return geary_db_transaction_async_job_type_id__once;
}

static void
_vala_geary_db_transaction_async_job_get_property (GObject * object,
                                                   guint property_id,
                                                   GValue * value,
                                                   GParamSpec * pspec)
{
	GearyDbTransactionAsyncJob * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_DB_TYPE_TRANSACTION_ASYNC_JOB, GearyDbTransactionAsyncJob);
	switch (property_id) {
		case GEARY_DB_TRANSACTION_ASYNC_JOB_DEFAULT_CX_PROPERTY:
		g_value_set_object (value, geary_db_transaction_async_job_get_default_cx (self));
		break;
		case GEARY_DB_TRANSACTION_ASYNC_JOB_CANCELLABLE_PROPERTY:
		g_value_set_object (value, geary_db_transaction_async_job_get_cancellable (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_geary_db_transaction_async_job_set_property (GObject * object,
                                                   guint property_id,
                                                   const GValue * value,
                                                   GParamSpec * pspec)
{
	GearyDbTransactionAsyncJob * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_DB_TYPE_TRANSACTION_ASYNC_JOB, GearyDbTransactionAsyncJob);
	switch (property_id) {
		case GEARY_DB_TRANSACTION_ASYNC_JOB_DEFAULT_CX_PROPERTY:
		geary_db_transaction_async_job_set_default_cx (self, g_value_get_object (value));
		break;
		case GEARY_DB_TRANSACTION_ASYNC_JOB_CANCELLABLE_PROPERTY:
		geary_db_transaction_async_job_set_cancellable (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

