/* InternalUtils.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from InternalUtils.vala, do not modify */

/*
 * Copyright 2012 Tom Beckmann
 * Copyright 2012 Rico Tzschichholz
 * Copyright 2023-2025 elementary, Inc. <https://elementary.io>
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include <glib-object.h>
#include <meta/display.h>
#include <glib.h>
#include <meta/util.h>
#include <X11/Xlib.h>
#include <mtk/mtk.h>
#include <meta/meta-x11-display.h>
#include <X11/extensions/Xfixes.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>
#include <X11/Xregion.h>
#include <meta/window.h>
#include <meta/meta-window-actor.h>
#include <meta/compositor-mutter.h>
#include <meta/workspace.h>
#include <float.h>
#include <math.h>
#include <clutter/clutter.h>
#include <string.h>
#include "gala.h"
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef enum  {
	GALA_INPUT_AREA_NONE,
	GALA_INPUT_AREA_FULLSCREEN,
	GALA_INPUT_AREA_MULTITASKING_VIEW,
	GALA_INPUT_AREA_DEFAULT
} GalaInputArea;

#define GALA_TYPE_INPUT_AREA (gala_input_area_get_type ())

#define GALA_TYPE_INTERNAL_UTILS (gala_internal_utils_get_type ())
#define GALA_INTERNAL_UTILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_INTERNAL_UTILS, GalaInternalUtils))
#define GALA_INTERNAL_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_INTERNAL_UTILS, GalaInternalUtilsClass))
#define GALA_IS_INTERNAL_UTILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_INTERNAL_UTILS))
#define GALA_IS_INTERNAL_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_INTERNAL_UTILS))
#define GALA_INTERNAL_UTILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_INTERNAL_UTILS, GalaInternalUtilsClass))

typedef struct _GalaInternalUtils GalaInternalUtils;
typedef struct _GalaInternalUtilsClass GalaInternalUtilsClass;
typedef struct _GalaInternalUtilsPrivate GalaInternalUtilsPrivate;

#define GALA_TYPE_SHELL_CLIENTS_MANAGER (gala_shell_clients_manager_get_type ())
#define GALA_SHELL_CLIENTS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_SHELL_CLIENTS_MANAGER, GalaShellClientsManager))
#define GALA_SHELL_CLIENTS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_SHELL_CLIENTS_MANAGER, GalaShellClientsManagerClass))
#define GALA_IS_SHELL_CLIENTS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_SHELL_CLIENTS_MANAGER))
#define GALA_IS_SHELL_CLIENTS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_SHELL_CLIENTS_MANAGER))
#define GALA_SHELL_CLIENTS_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_SHELL_CLIENTS_MANAGER, GalaShellClientsManagerClass))

typedef struct _GalaShellClientsManager GalaShellClientsManager;
typedef struct _GalaShellClientsManagerClass GalaShellClientsManagerClass;
#define __vala_MtkRectangle_free0(var) ((var == NULL) ? NULL : (var = (_vala_MtkRectangle_free (var), NULL)))

#define GALA_TYPE_PLUGIN_MANAGER (gala_plugin_manager_get_type ())
#define GALA_PLUGIN_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_PLUGIN_MANAGER, GalaPluginManager))
#define GALA_PLUGIN_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_PLUGIN_MANAGER, GalaPluginManagerClass))
#define GALA_IS_PLUGIN_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_PLUGIN_MANAGER))
#define GALA_IS_PLUGIN_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_PLUGIN_MANAGER))
#define GALA_PLUGIN_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_PLUGIN_MANAGER, GalaPluginManagerClass))

typedef struct _GalaPluginManager GalaPluginManager;
typedef struct _GalaPluginManagerClass GalaPluginManagerClass;

#define GALA_TYPE_WORKSPACE_MANAGER (gala_workspace_manager_get_type ())
#define GALA_WORKSPACE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_WORKSPACE_MANAGER, GalaWorkspaceManager))
#define GALA_WORKSPACE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_WORKSPACE_MANAGER, GalaWorkspaceManagerClass))
#define GALA_IS_WORKSPACE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_WORKSPACE_MANAGER))
#define GALA_IS_WORKSPACE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_WORKSPACE_MANAGER))
#define GALA_WORKSPACE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_WORKSPACE_MANAGER, GalaWorkspaceManagerClass))

typedef struct _GalaWorkspaceManager GalaWorkspaceManager;
typedef struct _GalaWorkspaceManagerClass GalaWorkspaceManagerClass;
typedef void (*GalaInternalUtilsWindowActorReadyCallback) (MetaWindowActor* window_actor, gpointer user_data);
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block2Data Block2Data;
typedef struct _Block3Data Block3Data;
typedef struct _Block4Data Block4Data;
typedef struct _Block5Data Block5Data;
typedef struct _GalaParamSpecInternalUtils GalaParamSpecInternalUtils;

struct _GalaInternalUtils {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GalaInternalUtilsPrivate * priv;
};

struct _GalaInternalUtilsClass {
	GTypeClass parent_class;
	void (*finalize) (GalaInternalUtils *self);
};

struct _Block2Data {
	int _ref_count_;
	MetaWindowActor* window_actor;
	MetaWindow* window;
	GalaInternalUtilsWindowActorReadyCallback callback;
	gpointer callback_target;
	GDestroyNotify callback_target_destroy_notify;
};

struct _Block3Data {
	int _ref_count_;
	GalaInternalUtilsWindowActorReadyCallback callback;
	gpointer callback_target;
	GDestroyNotify callback_target_destroy_notify;
};

struct _Block4Data {
	int _ref_count_;
	Block3Data * _data3_;
	MetaWindowActor* window_actor;
};

struct _Block5Data {
	int _ref_count_;
	Block4Data * _data4_;
	gulong show_handler;
};

struct _GalaParamSpecInternalUtils {
	GParamSpec parent_instance;
};

static gpointer gala_internal_utils_parent_class = NULL;

VALA_EXTERN GType gala_input_area_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gpointer gala_internal_utils_ref (gpointer instance);
VALA_EXTERN void gala_internal_utils_unref (gpointer instance);
VALA_EXTERN GParamSpec* gala_param_spec_internal_utils (const gchar* name,
                                            const gchar* nick,
                                            const gchar* blurb,
                                            GType object_type,
                                            GParamFlags flags);
VALA_EXTERN void gala_value_set_internal_utils (GValue* value,
                                    gpointer v_object);
VALA_EXTERN void gala_value_take_internal_utils (GValue* value,
                                     gpointer v_object);
VALA_EXTERN gpointer gala_value_get_internal_utils (const GValue* value);
VALA_EXTERN GType gala_internal_utils_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaInternalUtils, gala_internal_utils_unref)
VALA_EXTERN void gala_internal_utils_set_input_area (MetaDisplay* display,
                                         GalaInputArea area);
VALA_EXTERN GType gala_shell_clients_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaShellClientsManager, g_object_unref)
VALA_EXTERN GalaShellClientsManager* gala_shell_clients_manager_get_instance (void);
VALA_EXTERN MtkRectangle* gala_shell_clients_manager_get_shell_client_rect (GalaShellClientsManager* self);
static void _vala_MtkRectangle_free (MtkRectangle* self);
VALA_EXTERN GType gala_plugin_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaPluginManager, g_object_unref)
VALA_EXTERN GalaPluginManager* gala_plugin_manager_get_default (void);
VALA_EXTERN XRectangle* gala_plugin_manager_get_regions (GalaPluginManager* self,
                                             gint* result_length1);
static void _vala_array_add5 (XRectangle* * array,
                       gint* length,
                       gint* size,
                       XRectangle value);
VALA_EXTERN void gala_internal_utils_insert_workspace_with_window (gint index,
                                                       MetaWindow* new_window);
VALA_EXTERN GType gala_workspace_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWorkspaceManager, g_object_unref)
VALA_EXTERN GalaWorkspaceManager* gala_workspace_manager_get_default (void);
VALA_EXTERN void gala_workspace_manager_freeze_remove (GalaWorkspaceManager* self);
VALA_EXTERN void gala_workspace_manager_thaw_remove (GalaWorkspaceManager* self);
VALA_EXTERN void gala_internal_utils_actor_box_from_rect (gfloat x,
                                              gfloat y,
                                              gfloat width,
                                              gfloat height,
                                              ClutterActorBox* result);
VALA_EXTERN void gala_internal_utils_wait_for_window_actor (MetaWindow* window,
                                                GalaInternalUtilsWindowActorReadyCallback callback,
                                                gpointer callback_target,
                                                GDestroyNotify callback_target_destroy_notify);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static gboolean __lambda11_ (Block2Data* _data2_);
static gboolean ___lambda11__gsource_func (gpointer self);
VALA_EXTERN void gala_internal_utils_wait_for_window_actor_visible (MetaWindow* window,
                                                        GalaInternalUtilsWindowActorReadyCallback callback,
                                                        gpointer callback_target,
                                                        GDestroyNotify callback_target_destroy_notify);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void __lambda21_ (Block3Data* _data3_,
                  MetaWindowActor* window_actor);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void ___lambda22_ (Block5Data* _data5_);
static void ____lambda22__clutter_actor_show (ClutterActor* _sender,
                                       gpointer self);
static void ___lambda21__gala_internal_utils_window_actor_ready_callback (MetaWindowActor* window_actor,
                                                                   gpointer self);
VALA_EXTERN void gala_internal_utils_clutter_actor_reparent (ClutterActor* actor,
                                                 ClutterActor* new_parent);
VALA_EXTERN void gala_internal_utils_bell_notify (MetaDisplay* display);
VALA_EXTERN gboolean gala_internal_utils_get_x11_in_fullscreen (MetaDisplay* display);
VALA_EXTERN MetaWindow* gala_internal_utils_get_mru_window (MetaWorkspace* workspace,
                                                MetaWindow** any_window);
static gint __lambda18_ (MetaWindow* a,
                  MetaWindow* b);
static gint ___lambda18__gcompare_func (gconstpointer a,
                                 gconstpointer b);
VALA_EXTERN GalaInternalUtils* gala_internal_utils_new (void);
VALA_EXTERN GalaInternalUtils* gala_internal_utils_construct (GType object_type);
static void gala_internal_utils_finalize (GalaInternalUtils * obj);
static GType gala_internal_utils_get_type_once (void);

 G_GNUC_NO_INLINE static GType
gala_input_area_get_type_once (void)
{
	static const GEnumValue values[] = {{GALA_INPUT_AREA_NONE, "GALA_INPUT_AREA_NONE", "none"}, {GALA_INPUT_AREA_FULLSCREEN, "GALA_INPUT_AREA_FULLSCREEN", "fullscreen"}, {GALA_INPUT_AREA_MULTITASKING_VIEW, "GALA_INPUT_AREA_MULTITASKING_VIEW", "multitasking-view"}, {GALA_INPUT_AREA_DEFAULT, "GALA_INPUT_AREA_DEFAULT", "default"}, {0, NULL, NULL}};
	GType gala_input_area_type_id;
	gala_input_area_type_id = g_enum_register_static ("GalaInputArea", values);
	return gala_input_area_type_id;
}

GType
gala_input_area_get_type (void)
{
	static gsize gala_input_area_type_id__once = 0;
	if (g_once_init_enter (&gala_input_area_type_id__once)) {
		GType gala_input_area_type_id;
		gala_input_area_type_id = gala_input_area_get_type_once ();
		g_once_init_leave (&gala_input_area_type_id__once, gala_input_area_type_id);
	}
	return gala_input_area_type_id__once;
}

/**
         * set the area where clutter can receive events
         **/
static void
_vala_MtkRectangle_free (MtkRectangle* self)
{
	g_boxed_free (mtk_rectangle_get_type (), self);
}

static void
_vala_array_add5 (XRectangle* * array,
                  gint* length,
                  gint* size,
                  XRectangle value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (XRectangle, *array, *size);
	}
	(*array)[(*length)++] = value;
}

void
gala_internal_utils_set_input_area (MetaDisplay* display,
                                    GalaInputArea area)
{
	XRectangle* rects = NULL;
	XRectangle* _tmp0_;
	gint rects_length1;
	gint _rects_size_;
	MetaX11Display* x11display = NULL;
	MetaX11Display* _tmp35_;
	XserverRegion xregion = {0};
	MetaX11Display* _tmp36_;
	Display* _tmp37_;
	XRectangle* _tmp38_;
	gint _tmp38__length1;
	MetaX11Display* _tmp39_;
	g_return_if_fail (display != NULL);
	if (meta_is_wayland_compositor ()) {
		return;
	}
	_tmp0_ = g_new0 (XRectangle, 0);
	rects = _tmp0_;
	rects_length1 = 0;
	_rects_size_ = rects_length1;
	switch (area) {
		case GALA_INPUT_AREA_FULLSCREEN:
		{
			gint width = 0;
			gint height = 0;
			gint _tmp1_ = 0;
			gint _tmp2_ = 0;
			XRectangle rect = {0};
			XRectangle _tmp3_ = {0};
			XRectangle* _tmp4_;
			meta_display_get_size (display, &_tmp1_, &_tmp2_);
			width = _tmp1_;
			height = _tmp2_;
			_tmp3_.x = (gshort) 0;
			_tmp3_.y = (gshort) 0;
			_tmp3_.width = (gushort) width;
			_tmp3_.height = (gushort) height;
			rect = _tmp3_;
			_tmp4_ = g_new0 (XRectangle, 1);
			_tmp4_[0] = rect;
			rects = (g_free (rects), NULL);
			rects = _tmp4_;
			rects_length1 = 1;
			_rects_size_ = rects_length1;
			break;
		}
		case GALA_INPUT_AREA_MULTITASKING_VIEW:
		{
			MtkRectangle* shell_client_rect = NULL;
			GalaShellClientsManager* _tmp5_;
			MtkRectangle* _tmp6_;
			gint width = 0;
			gint height = 0;
			gint _tmp7_ = 0;
			gint _tmp8_ = 0;
			MtkRectangle* _tmp9_;
			_tmp5_ = gala_shell_clients_manager_get_instance ();
			_tmp6_ = gala_shell_clients_manager_get_shell_client_rect (_tmp5_);
			shell_client_rect = _tmp6_;
			meta_display_get_size (display, &_tmp7_, &_tmp8_);
			width = _tmp7_;
			height = _tmp8_;
			_tmp9_ = shell_client_rect;
			if (_tmp9_ != NULL) {
				XRectangle left_rect = {0};
				MtkRectangle* _tmp10_;
				XRectangle _tmp11_ = {0};
				XRectangle right_rect = {0};
				MtkRectangle* _tmp12_;
				MtkRectangle* _tmp13_;
				MtkRectangle* _tmp14_;
				MtkRectangle* _tmp15_;
				XRectangle _tmp16_ = {0};
				XRectangle top_rect = {0};
				MtkRectangle* _tmp17_;
				MtkRectangle* _tmp18_;
				MtkRectangle* _tmp19_;
				XRectangle _tmp20_ = {0};
				XRectangle bottom_rect = {0};
				MtkRectangle* _tmp21_;
				MtkRectangle* _tmp22_;
				MtkRectangle* _tmp23_;
				MtkRectangle* _tmp24_;
				MtkRectangle* _tmp25_;
				MtkRectangle* _tmp26_;
				XRectangle _tmp27_ = {0};
				XRectangle* _tmp28_;
				_tmp10_ = shell_client_rect;
				_tmp11_.x = (gshort) 0;
				_tmp11_.y = (gshort) 0;
				_tmp11_.width = (gushort) (*_tmp10_).x;
				_tmp11_.height = (gushort) height;
				left_rect = _tmp11_;
				_tmp12_ = shell_client_rect;
				_tmp13_ = shell_client_rect;
				_tmp14_ = shell_client_rect;
				_tmp15_ = shell_client_rect;
				_tmp16_.x = (gshort) ((*_tmp12_).x + (*_tmp13_).width);
				_tmp16_.y = (gshort) 0;
				_tmp16_.width = (gushort) ((width - (*_tmp14_).x) - (*_tmp15_).width);
				_tmp16_.height = (gushort) height;
				right_rect = _tmp16_;
				_tmp17_ = shell_client_rect;
				_tmp18_ = shell_client_rect;
				_tmp19_ = shell_client_rect;
				_tmp20_.x = (gshort) (*_tmp17_).x;
				_tmp20_.y = (gshort) 0;
				_tmp20_.width = (gushort) (*_tmp18_).width;
				_tmp20_.height = (gushort) (*_tmp19_).y;
				top_rect = _tmp20_;
				_tmp21_ = shell_client_rect;
				_tmp22_ = shell_client_rect;
				_tmp23_ = shell_client_rect;
				_tmp24_ = shell_client_rect;
				_tmp25_ = shell_client_rect;
				_tmp26_ = shell_client_rect;
				_tmp27_.x = (gshort) (*_tmp21_).x;
				_tmp27_.y = (gshort) ((*_tmp22_).y + (*_tmp23_).height);
				_tmp27_.width = (gushort) (*_tmp24_).width;
				_tmp27_.height = (gushort) ((height - (*_tmp25_).y) - (*_tmp26_).height);
				bottom_rect = _tmp27_;
				_tmp28_ = g_new0 (XRectangle, 4);
				_tmp28_[0] = left_rect;
				_tmp28_[1] = right_rect;
				_tmp28_[2] = top_rect;
				_tmp28_[3] = bottom_rect;
				rects = (g_free (rects), NULL);
				rects = _tmp28_;
				rects_length1 = 4;
				_rects_size_ = rects_length1;
			} else {
				XRectangle rect = {0};
				XRectangle _tmp29_ = {0};
				XRectangle* _tmp30_;
				_tmp29_.x = (gshort) 0;
				_tmp29_.y = (gshort) 0;
				_tmp29_.width = (gushort) width;
				_tmp29_.height = (gushort) height;
				rect = _tmp29_;
				_tmp30_ = g_new0 (XRectangle, 1);
				_tmp30_[0] = rect;
				rects = (g_free (rects), NULL);
				rects = _tmp30_;
				rects_length1 = 1;
				_rects_size_ = rects_length1;
			}
			__vala_MtkRectangle_free0 (shell_client_rect);
			break;
		}
		case GALA_INPUT_AREA_DEFAULT:
		{
			GalaPluginManager* _tmp31_;
			gint _tmp32_ = 0;
			XRectangle* _tmp33_;
			_tmp31_ = gala_plugin_manager_get_default ();
			_tmp33_ = gala_plugin_manager_get_regions (_tmp31_, &_tmp32_);
			{
				XRectangle* rect_collection = NULL;
				gint rect_collection_length1 = 0;
				gint _rect_collection_size_ = 0;
				gint rect_it = 0;
				rect_collection = _tmp33_;
				rect_collection_length1 = _tmp32_;
				for (rect_it = 0; rect_it < rect_collection_length1; rect_it = rect_it + 1) {
					XRectangle rect = {0};
					rect = rect_collection[rect_it];
					{
						_vala_array_add5 (&rects, &rects_length1, &_rects_size_, rect);
					}
				}
			}
			break;
		}
		default:
		case GALA_INPUT_AREA_NONE:
		{
			XRectangle* _tmp34_;
			_tmp34_ = g_new0 (XRectangle, 0);
			rects = (g_free (rects), NULL);
			rects = _tmp34_;
			rects_length1 = 0;
			_rects_size_ = rects_length1;
			break;
		}
	}
	_tmp35_ = meta_display_get_x11_display (display);
	x11display = _tmp35_;
	_tmp36_ = x11display;
	_tmp37_ = meta_x11_display_get_xdisplay (_tmp36_);
	_tmp38_ = rects;
	_tmp38__length1 = rects_length1;
	xregion = XFixesCreateRegion (_tmp37_, _tmp38_, (gint) _tmp38__length1);
	_tmp39_ = x11display;
	meta_x11_display_set_stage_input_region (_tmp39_, xregion);
	rects = (g_free (rects), NULL);
}

/**
         * Inserts a workspace at the given index. To ensure the workspace is not immediately
         * removed again when in dynamic workspaces, the window is first placed on it.
         *
         * @param index  The index at which to insert the workspace
         * @param new_window A window that should be moved to the new workspace
         */
void
gala_internal_utils_insert_workspace_with_window (gint index,
                                                  MetaWindow* new_window)
{
	GalaWorkspaceManager* workspace_manager = NULL;
	GalaWorkspaceManager* _tmp0_;
	GalaWorkspaceManager* _tmp1_;
	GList* actors = NULL;
	MetaDisplay* _tmp2_;
	GList* _tmp3_;
	GList* _tmp4_;
	GalaWorkspaceManager* _tmp16_;
	g_return_if_fail (new_window != NULL);
	_tmp0_ = gala_workspace_manager_get_default ();
	workspace_manager = _tmp0_;
	_tmp1_ = workspace_manager;
	gala_workspace_manager_freeze_remove (_tmp1_);
	meta_window_change_workspace_by_index (new_window, index, FALSE);
	_tmp2_ = meta_window_get_display (new_window);
	_tmp3_ = meta_get_window_actors (_tmp2_);
	actors = _tmp3_;
	_tmp4_ = actors;
	{
		GList* actor_collection = NULL;
		GList* actor_it = NULL;
		actor_collection = _tmp4_;
		for (actor_it = actor_collection; actor_it != NULL; actor_it = actor_it->next) {
			MetaWindowActor* actor = NULL;
			actor = (MetaWindowActor*) actor_it->data;
			{
				MetaWindowActor* _tmp5_;
				MetaWindow* window = NULL;
				MetaWindowActor* _tmp6_;
				MetaWindow* _tmp7_;
				MetaWindow* _tmp8_;
				gint current_index = 0;
				MetaWindow* _tmp9_;
				MetaWorkspace* _tmp10_;
				gboolean _tmp11_ = FALSE;
				_tmp5_ = actor;
				if (meta_window_actor_is_destroyed (_tmp5_)) {
					continue;
				}
				_tmp6_ = actor;
				_tmp7_ = meta_window_actor_get_meta_window (_tmp6_);
				window = _tmp7_;
				_tmp8_ = window;
				if (_tmp8_ == new_window) {
					continue;
				}
				_tmp9_ = window;
				_tmp10_ = meta_window_get_workspace (_tmp9_);
				current_index = meta_workspace_index (_tmp10_);
				if (current_index >= index) {
					MetaWindow* _tmp12_;
					gboolean _tmp13_;
					gboolean _tmp14_;
					_tmp12_ = window;
					g_object_get (_tmp12_, "on-all-workspaces", &_tmp13_, NULL);
					_tmp14_ = _tmp13_;
					_tmp11_ = !_tmp14_;
				} else {
					_tmp11_ = FALSE;
				}
				if (_tmp11_) {
					MetaWindow* _tmp15_;
					_tmp15_ = window;
					meta_window_change_workspace_by_index (_tmp15_, current_index + 1, TRUE);
				}
			}
		}
	}
	_tmp16_ = workspace_manager;
	gala_workspace_manager_thaw_remove (_tmp16_);
}

void
gala_internal_utils_actor_box_from_rect (gfloat x,
                                         gfloat y,
                                         gfloat width,
                                         gfloat height,
                                         ClutterActorBox* result)
{
	ClutterActorBox actor_box = {0};
	memset (&actor_box, 0, sizeof (ClutterActorBox));
	clutter_actor_box_init_rect (&actor_box, x, y, width, height);
	clutter_actor_box_clamp_to_pixel (&actor_box);
	*result = actor_box;
	return;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		_g_object_unref0 (_data2_->window);
		(_data2_->callback_target_destroy_notify == NULL) ? NULL : (_data2_->callback_target_destroy_notify (_data2_->callback_target), NULL);
		_data2_->callback = NULL;
		_data2_->callback_target = NULL;
		_data2_->callback_target_destroy_notify = NULL;
		g_slice_free (Block2Data, _data2_);
	}
}

static gboolean
__lambda11_ (Block2Data* _data2_)
{
	GObject* _tmp0_;
	MetaWindowActor* _tmp1_;
	gboolean result;
	_tmp0_ = meta_window_get_compositor_private (_data2_->window);
	_data2_->window_actor = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, meta_window_actor_get_type (), MetaWindowActor);
	_tmp1_ = _data2_->window_actor;
	if (_tmp1_ != NULL) {
		MetaWindowActor* _tmp2_;
		_tmp2_ = _data2_->window_actor;
		_data2_->callback (_tmp2_, _data2_->callback_target);
	}
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda11__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda11_ (self);
	return result;
}

void
gala_internal_utils_wait_for_window_actor (MetaWindow* window,
                                           GalaInternalUtilsWindowActorReadyCallback callback,
                                           gpointer callback_target,
                                           GDestroyNotify callback_target_destroy_notify)
{
	Block2Data* _data2_;
	MetaWindow* _tmp0_;
	GObject* _tmp1_;
	MetaWindowActor* _tmp2_;
	g_return_if_fail (window != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_tmp0_ = _g_object_ref0 (window);
	_g_object_unref0 (_data2_->window);
	_data2_->window = _tmp0_;
	(_data2_->callback_target_destroy_notify == NULL) ? NULL : (_data2_->callback_target_destroy_notify (_data2_->callback_target), NULL);
	_data2_->callback = NULL;
	_data2_->callback_target = NULL;
	_data2_->callback_target_destroy_notify = NULL;
	_data2_->callback = callback;
	_data2_->callback_target = callback_target;
	_data2_->callback_target_destroy_notify = callback_target_destroy_notify;
	_tmp1_ = meta_window_get_compositor_private (_data2_->window);
	_data2_->window_actor = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, meta_window_actor_get_type (), MetaWindowActor);
	_tmp2_ = _data2_->window_actor;
	if (_tmp2_ != NULL) {
		MetaWindowActor* _tmp3_;
		_tmp3_ = _data2_->window_actor;
		_data2_->callback (_tmp3_, _data2_->callback_target);
		block2_data_unref (_data2_);
		_data2_ = NULL;
		return;
	}
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda11__gsource_func, block2_data_ref (_data2_), block2_data_unref);
	block2_data_unref (_data2_);
	_data2_ = NULL;
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		(_data3_->callback_target_destroy_notify == NULL) ? NULL : (_data3_->callback_target_destroy_notify (_data3_->callback_target), NULL);
		_data3_->callback = NULL;
		_data3_->callback_target = NULL;
		_data3_->callback_target_destroy_notify = NULL;
		g_slice_free (Block3Data, _data3_);
	}
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		_g_object_unref0 (_data4_->window_actor);
		block3_data_unref (_data4_->_data3_);
		_data4_->_data3_ = NULL;
		g_slice_free (Block4Data, _data4_);
	}
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		block4_data_unref (_data5_->_data4_);
		_data5_->_data4_ = NULL;
		g_slice_free (Block5Data, _data5_);
	}
}

static void
___lambda22_ (Block5Data* _data5_)
{
	Block4Data* _data4_;
	Block3Data* _data3_;
	_data4_ = _data5_->_data4_;
	_data3_ = _data4_->_data3_;
	g_signal_handler_disconnect ((GObject*) _data4_->window_actor, _data5_->show_handler);
	_data3_->callback (_data4_->window_actor, _data3_->callback_target);
}

static void
____lambda22__clutter_actor_show (ClutterActor* _sender,
                                  gpointer self)
{
	___lambda22_ (self);
}

static void
__lambda21_ (Block3Data* _data3_,
             MetaWindowActor* window_actor)
{
	Block4Data* _data4_;
	MetaWindowActor* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (window_actor != NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->_data3_ = block3_data_ref (_data3_);
	_tmp0_ = _g_object_ref0 (window_actor);
	_g_object_unref0 (_data4_->window_actor);
	_data4_->window_actor = _tmp0_;
	g_object_get ((ClutterActor*) _data4_->window_actor, "visible", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		_data3_->callback (_data4_->window_actor, _data3_->callback_target);
	} else {
		Block5Data* _data5_;
		gulong _tmp3_;
		_data5_ = g_slice_new0 (Block5Data);
		_data5_->_ref_count_ = 1;
		_data5_->_data4_ = block4_data_ref (_data4_);
		_data5_->show_handler = (gulong) 0;
		_tmp3_ = g_signal_connect_data ((ClutterActor*) _data4_->window_actor, "show", (GCallback) ____lambda22__clutter_actor_show, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
		_data5_->show_handler = _tmp3_;
		block5_data_unref (_data5_);
		_data5_ = NULL;
	}
	block4_data_unref (_data4_);
	_data4_ = NULL;
}

static void
___lambda21__gala_internal_utils_window_actor_ready_callback (MetaWindowActor* window_actor,
                                                              gpointer self)
{
	__lambda21_ (self, window_actor);
}

void
gala_internal_utils_wait_for_window_actor_visible (MetaWindow* window,
                                                   GalaInternalUtilsWindowActorReadyCallback callback,
                                                   gpointer callback_target,
                                                   GDestroyNotify callback_target_destroy_notify)
{
	Block3Data* _data3_;
	g_return_if_fail (window != NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	(_data3_->callback_target_destroy_notify == NULL) ? NULL : (_data3_->callback_target_destroy_notify (_data3_->callback_target), NULL);
	_data3_->callback = NULL;
	_data3_->callback_target = NULL;
	_data3_->callback_target_destroy_notify = NULL;
	_data3_->callback = callback;
	_data3_->callback_target = callback_target;
	_data3_->callback_target_destroy_notify = callback_target_destroy_notify;
	gala_internal_utils_wait_for_window_actor (window, ___lambda21__gala_internal_utils_window_actor_ready_callback, block3_data_ref (_data3_), block3_data_unref);
	block3_data_unref (_data3_);
	_data3_ = NULL;
}

void
gala_internal_utils_clutter_actor_reparent (ClutterActor* actor,
                                            ClutterActor* new_parent)
{
	ClutterActor* _tmp0_;
	g_return_if_fail (actor != NULL);
	g_return_if_fail (new_parent != NULL);
	if (actor == new_parent) {
		return;
	}
	g_object_ref ((GObject*) actor);
	_tmp0_ = clutter_actor_get_parent (actor);
	clutter_actor_remove_child (_tmp0_, actor);
	clutter_actor_add_child (new_parent, actor);
	g_object_unref ((GObject*) actor);
}

void
gala_internal_utils_bell_notify (MetaDisplay* display)
{
	ClutterBackend* _tmp0_;
	ClutterSeat* _tmp1_;
	g_return_if_fail (display != NULL);
	_tmp0_ = clutter_get_default_backend ();
	_tmp1_ = clutter_backend_get_default_seat (_tmp0_);
	clutter_seat_bell_notify (_tmp1_);
}

gboolean
gala_internal_utils_get_x11_in_fullscreen (MetaDisplay* display)
{
	gint primary_monitor = 0;
	gboolean is_in_fullscreen = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (display != NULL, FALSE);
	primary_monitor = meta_display_get_primary_monitor (display);
	is_in_fullscreen = meta_display_get_monitor_in_fullscreen (display, primary_monitor);
	if (!meta_is_wayland_compositor ()) {
		_tmp0_ = is_in_fullscreen;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

/**
         * Returns the most recently used "normal" window (as gotten via {@link get_window_is_normal}) in the given workspace.
         * If there is a not normal but more recent window (e.g. a menu/tooltip) any_window will be set to that window otherwise
         * it will be set to the same window that is returned.
         */
static inline gboolean
vala_g_list_is_empty (GList* self)
{
	gboolean result;
	result = ((GList*) self) == NULL;
	return result;
}

static gint
__lambda18_ (MetaWindow* a,
             MetaWindow* b)
{
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	result = ((gint) meta_window_get_user_time (b)) - ((gint) meta_window_get_user_time (a));
	return result;
}

static gint
___lambda18__gcompare_func (gconstpointer a,
                            gconstpointer b)
{
	gint result;
	result = __lambda18_ ((MetaWindow*) a, (MetaWindow*) b);
	return result;
}

MetaWindow*
gala_internal_utils_get_mru_window (MetaWorkspace* workspace,
                                    MetaWindow** any_window)
{
	MetaWindow* _vala_any_window = NULL;
	GList* list = NULL;
	GList* _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
	MetaWindow* result;
	g_return_val_if_fail (workspace != NULL, NULL);
	_g_object_unref0 (_vala_any_window);
	_vala_any_window = NULL;
	_tmp0_ = meta_workspace_list_windows (workspace);
	list = _tmp0_;
	_tmp1_ = list;
	if (vala_g_list_is_empty (_tmp1_)) {
		result = NULL;
		(list == NULL) ? NULL : (list = (g_list_free (list), NULL));
		if (any_window) {
			*any_window = _vala_any_window;
		} else {
			_g_object_unref0 (_vala_any_window);
		}
		return result;
	}
	list = g_list_sort (list, ___lambda18__gcompare_func);
	_tmp2_ = list;
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
		window_collection = _tmp2_;
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			MetaWindow* window = NULL;
			window = (MetaWindow*) window_it->data;
			{
				MetaWindow* _tmp3_;
				MetaWindow* _tmp4_;
				MetaWindowType _tmp5_;
				MetaWindowType _tmp6_;
				MetaWindow* _tmp7_;
				MetaWindow* _tmp10_;
				MetaWindow* _tmp11_;
				MetaWindow* _tmp12_;
				_tmp3_ = window;
				_tmp4_ = meta_window_find_root_ancestor (_tmp3_);
				_tmp5_ = meta_window_get_window_type (_tmp4_);
				_tmp6_ = _tmp5_;
				if (_tmp6_ == META_WINDOW_DOCK) {
					continue;
				}
				_tmp7_ = _vala_any_window;
				if (_tmp7_ == NULL) {
					MetaWindow* _tmp8_;
					MetaWindow* _tmp9_;
					_tmp8_ = window;
					_tmp9_ = _g_object_ref0 (_tmp8_);
					_g_object_unref0 (_vala_any_window);
					_vala_any_window = _tmp9_;
				}
				_tmp10_ = window;
				if (!gala_utils_get_window_is_normal (_tmp10_)) {
					continue;
				}
				_tmp11_ = window;
				_tmp12_ = _g_object_ref0 (_tmp11_);
				result = _tmp12_;
				(list == NULL) ? NULL : (list = (g_list_free (list), NULL));
				if (any_window) {
					*any_window = _vala_any_window;
				} else {
					_g_object_unref0 (_vala_any_window);
				}
				return result;
			}
		}
	}
	result = NULL;
	(list == NULL) ? NULL : (list = (g_list_free (list), NULL));
	if (any_window) {
		*any_window = _vala_any_window;
	} else {
		_g_object_unref0 (_vala_any_window);
	}
	return result;
}

GalaInternalUtils*
gala_internal_utils_construct (GType object_type)
{
	GalaInternalUtils* self = NULL;
	self = (GalaInternalUtils*) g_type_create_instance (object_type);
	return self;
}

GalaInternalUtils*
gala_internal_utils_new (void)
{
	return gala_internal_utils_construct (GALA_TYPE_INTERNAL_UTILS);
}

static void
gala_value_internal_utils_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
gala_value_internal_utils_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		gala_internal_utils_unref (value->data[0].v_pointer);
	}
}

static void
gala_value_internal_utils_copy_value (const GValue* src_value,
                                      GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = gala_internal_utils_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
gala_value_internal_utils_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
gala_value_internal_utils_collect_value (GValue* value,
                                         guint n_collect_values,
                                         GTypeCValue* collect_values,
                                         guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		GalaInternalUtils * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = gala_internal_utils_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
gala_value_internal_utils_lcopy_value (const GValue* value,
                                       guint n_collect_values,
                                       GTypeCValue* collect_values,
                                       guint collect_flags)
{
	GalaInternalUtils ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = gala_internal_utils_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
gala_param_spec_internal_utils (const gchar* name,
                                const gchar* nick,
                                const gchar* blurb,
                                GType object_type,
                                GParamFlags flags)
{
	GalaParamSpecInternalUtils* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GALA_TYPE_INTERNAL_UTILS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
gala_value_get_internal_utils (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GALA_TYPE_INTERNAL_UTILS), NULL);
	return value->data[0].v_pointer;
}

void
gala_value_set_internal_utils (GValue* value,
                               gpointer v_object)
{
	GalaInternalUtils * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GALA_TYPE_INTERNAL_UTILS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GALA_TYPE_INTERNAL_UTILS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		gala_internal_utils_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gala_internal_utils_unref (old);
	}
}

void
gala_value_take_internal_utils (GValue* value,
                                gpointer v_object)
{
	GalaInternalUtils * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GALA_TYPE_INTERNAL_UTILS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GALA_TYPE_INTERNAL_UTILS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gala_internal_utils_unref (old);
	}
}

static void
gala_internal_utils_class_init (GalaInternalUtilsClass * klass,
                                gpointer klass_data)
{
	gala_internal_utils_parent_class = g_type_class_peek_parent (klass);
	((GalaInternalUtilsClass *) klass)->finalize = gala_internal_utils_finalize;
}

static void
gala_internal_utils_instance_init (GalaInternalUtils * self,
                                   gpointer klass)
{
	self->ref_count = 1;
}

static void
gala_internal_utils_finalize (GalaInternalUtils * obj)
{
	GalaInternalUtils * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_INTERNAL_UTILS, GalaInternalUtils);
	g_signal_handlers_destroy (self);
}

 G_GNUC_NO_INLINE static GType
gala_internal_utils_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { gala_value_internal_utils_init, gala_value_internal_utils_free_value, gala_value_internal_utils_copy_value, gala_value_internal_utils_peek_pointer, "p", gala_value_internal_utils_collect_value, "p", gala_value_internal_utils_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (GalaInternalUtilsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_internal_utils_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaInternalUtils), 0, (GInstanceInitFunc) gala_internal_utils_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType gala_internal_utils_type_id;
	gala_internal_utils_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GalaInternalUtils", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return gala_internal_utils_type_id;
}

GType
gala_internal_utils_get_type (void)
{
	static gsize gala_internal_utils_type_id__once = 0;
	if (g_once_init_enter (&gala_internal_utils_type_id__once)) {
		GType gala_internal_utils_type_id;
		gala_internal_utils_type_id = gala_internal_utils_get_type_once ();
		g_once_init_leave (&gala_internal_utils_type_id__once, gala_internal_utils_type_id);
	}
	return gala_internal_utils_type_id__once;
}

gpointer
gala_internal_utils_ref (gpointer instance)
{
	GalaInternalUtils * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
gala_internal_utils_unref (gpointer instance)
{
	GalaInternalUtils * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GALA_INTERNAL_UTILS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

