/* auto-generated, do not modify */
#include "config.h"

#include "fu-amd-gpu-atom-struct.h"
#include "fu-byte-array.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"

/* getters */
/**
 * fu_struct_vbios_date_get_month: (skip):
 **/
gchar *
fu_struct_vbios_date_get_month(const FuStructVbiosDate *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->data, st->len, 0, 2, NULL);
}
/**
 * fu_struct_vbios_date_get_day: (skip):
 **/
gchar *
fu_struct_vbios_date_get_day(const FuStructVbiosDate *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->data, st->len, 3, 2, NULL);
}
/**
 * fu_struct_vbios_date_get_year: (skip):
 **/
gchar *
fu_struct_vbios_date_get_year(const FuStructVbiosDate *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->data, st->len, 6, 2, NULL);
}
/**
 * fu_struct_vbios_date_get_hours: (skip):
 **/
gchar *
fu_struct_vbios_date_get_hours(const FuStructVbiosDate *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->data, st->len, 9, 2, NULL);
}
/**
 * fu_struct_vbios_date_get_minutes: (skip):
 **/
gchar *
fu_struct_vbios_date_get_minutes(const FuStructVbiosDate *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->data, st->len, 12, 2, NULL);
}
/**
 * fu_struct_vbios_date_get_seconds: (skip):
 **/
gchar *
fu_struct_vbios_date_get_seconds(const FuStructVbiosDate *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->data, st->len, 15, 2, NULL);
}

/* setters */
/**
 * fu_struct_vbios_date_to_string: (skip):
 **/
static gchar *
fu_struct_vbios_date_to_string(const FuStructVbiosDate *st)
{
    g_autoptr(GString) str = g_string_new("FuStructVbiosDate:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        g_autofree gchar *tmp = fu_struct_vbios_date_get_month(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  month: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_vbios_date_get_day(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  day: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_vbios_date_get_year(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  year: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_vbios_date_get_hours(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  hours: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_vbios_date_get_minutes(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  minutes: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_vbios_date_get_seconds(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  seconds: %s\n", tmp);
    }
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_vbios_date_validate_internal(FuStructVbiosDate *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
/* getters */
/**
 * fu_struct_atom_image_get_signature: (skip):
 **/
guint16
fu_struct_atom_image_get_signature(const FuStructAtomImage *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 0, G_BIG_ENDIAN);
}
/**
 * fu_struct_atom_image_get_size: (skip):
 **/
guint16
fu_struct_atom_image_get_size(const FuStructAtomImage *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 2, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_atom_image_get_pcir_loc: (skip):
 **/
guint16
fu_struct_atom_image_get_pcir_loc(const FuStructAtomImage *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 24, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_atom_image_get_compat_sig: (skip):
 **/
static gchar *
fu_struct_atom_image_get_compat_sig(const FuStructAtomImage *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->data, st->len, 30, 3, NULL);
}
/**
 * fu_struct_atom_image_get_checksum: (skip):
 **/
guint8
fu_struct_atom_image_get_checksum(const FuStructAtomImage *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[33];
}
/**
 * fu_struct_atom_image_get_num_strings: (skip):
 **/
guint8
fu_struct_atom_image_get_num_strings(const FuStructAtomImage *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[47];
}
/**
 * fu_struct_atom_image_get_rom_loc: (skip):
 **/
guint16
fu_struct_atom_image_get_rom_loc(const FuStructAtomImage *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 72, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_atom_image_get_vbios_date: (skip):
 **/
FuStructVbiosDate *
fu_struct_atom_image_get_vbios_date(const FuStructAtomImage *st)
{
    g_autoptr(GByteArray) buf = g_byte_array_new();
    g_return_val_if_fail(st != NULL, NULL);
    g_byte_array_append(buf, st->data + FU_STRUCT_ATOM_IMAGE_OFFSET_VBIOS_DATE, 18);
    return g_steal_pointer(&buf);
}
/**
 * fu_struct_atom_image_get_oem: (skip):
 **/
guint16
fu_struct_atom_image_get_oem(const FuStructAtomImage *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 98, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_atom_image_get_str_loc: (skip):
 **/
guint32
fu_struct_atom_image_get_str_loc(const FuStructAtomImage *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 110, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_atom_image_to_string: (skip):
 **/
static gchar *
fu_struct_atom_image_to_string(const FuStructAtomImage *st)
{
    g_autoptr(GString) str = g_string_new("FuStructAtomImage:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  signature: 0x%x\n",
                           (guint) fu_struct_atom_image_get_signature(st));
    g_string_append_printf(str, "  size: 0x%x\n",
                           (guint) fu_struct_atom_image_get_size(st));
    g_string_append_printf(str, "  pcir_loc: 0x%x\n",
                           (guint) fu_struct_atom_image_get_pcir_loc(st));
    g_string_append_printf(str, "  checksum: 0x%x\n",
                           (guint) fu_struct_atom_image_get_checksum(st));
    g_string_append_printf(str, "  num_strings: 0x%x\n",
                           (guint) fu_struct_atom_image_get_num_strings(st));
    g_string_append_printf(str, "  rom_loc: 0x%x\n",
                           (guint) fu_struct_atom_image_get_rom_loc(st));
    {
        g_autoptr(GByteArray) st_tmp = fu_struct_atom_image_get_vbios_date(st);
        g_autofree gchar *tmp = fu_struct_vbios_date_to_string(st_tmp);
        g_string_append_printf(str, "  vbios_date: %s\n", tmp);
    }
    g_string_append_printf(str, "  oem: 0x%x\n",
                           (guint) fu_struct_atom_image_get_oem(st));
    g_string_append_printf(str, "  str_loc: 0x%x\n",
                           (guint) fu_struct_atom_image_get_str_loc(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_atom_image_validate_internal(FuStructAtomImage *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (strncmp((const gchar *) (st->data + 30), "IBM", 3) != 0) {
        g_autofree gchar *str = fu_struct_atom_image_get_compat_sig(st);
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuStructAtomImage.compat_sig was not valid, "
                    "expected 'IBM' and got '%s'",
                    str);
        return FALSE;
    }
    {
        GByteArray st_tmp = {
            .data = (guint8*) st->data + 0x50,
            .len = 18,
        };
        if (!fu_struct_vbios_date_validate_internal(&st_tmp, error))
            return FALSE;
    }
    return TRUE;
}
static gboolean
fu_struct_atom_image_parse_internal(FuStructAtomImage *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_atom_image_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_atom_image_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_atom_image_parse_stream: (skip):
 **/
FuStructAtomImage *
fu_struct_atom_image_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = NULL;
    st = fu_input_stream_read_byte_array(stream, offset, 114, NULL, error);
    if (st == NULL) {
        g_prefix_error(error, "FuStructAtomImage failed read of 0x%x: ", (guint) 114);
        return NULL;
    }
    if (st->len != 114) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructAtomImage requested 0x%x and got 0x%x",
                    (guint) 114,
                    (guint) st->len);
        return NULL;
    }
    if (!fu_struct_atom_image_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/* getters */
/**
 * fu_struct_atom_header_common_get_size: (skip):
 **/
guint16
fu_struct_atom_header_common_get_size(const FuStructAtomHeaderCommon *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_atom_header_common_get_format_rev: (skip):
 **/
guint8
fu_struct_atom_header_common_get_format_rev(const FuStructAtomHeaderCommon *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[2];
}
/**
 * fu_struct_atom_header_common_get_content_rev: (skip):
 **/
guint8
fu_struct_atom_header_common_get_content_rev(const FuStructAtomHeaderCommon *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[3];
}

/* setters */
/**
 * fu_struct_atom_header_common_to_string: (skip):
 **/
static gchar *
fu_struct_atom_header_common_to_string(const FuStructAtomHeaderCommon *st)
{
    g_autoptr(GString) str = g_string_new("FuStructAtomHeaderCommon:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  size: 0x%x\n",
                           (guint) fu_struct_atom_header_common_get_size(st));
    g_string_append_printf(str, "  format_rev: 0x%x\n",
                           (guint) fu_struct_atom_header_common_get_format_rev(st));
    g_string_append_printf(str, "  content_rev: 0x%x\n",
                           (guint) fu_struct_atom_header_common_get_content_rev(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_atom_header_common_validate_internal(FuStructAtomHeaderCommon *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
/* getters */
/**
 * fu_struct_atom_rom21_header_get_header: (skip):
 **/
FuStructAtomHeaderCommon *
fu_struct_atom_rom21_header_get_header(const FuStructAtomRom21Header *st)
{
    g_autoptr(GByteArray) buf = g_byte_array_new();
    g_return_val_if_fail(st != NULL, NULL);
    g_byte_array_append(buf, st->data + FU_STRUCT_ATOM_ROM21_HEADER_OFFSET_HEADER, 4);
    return g_steal_pointer(&buf);
}
/**
 * fu_struct_atom_rom21_header_get_signature: (skip):
 **/
static gchar *
fu_struct_atom_rom21_header_get_signature(const FuStructAtomRom21Header *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->data, st->len, 4, 4, NULL);
}
/**
 * fu_struct_atom_rom21_header_get_bios_runtime_seg_addr: (skip):
 **/
guint16
fu_struct_atom_rom21_header_get_bios_runtime_seg_addr(const FuStructAtomRom21Header *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 8, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_atom_rom21_header_get_protected_mode_info_offset: (skip):
 **/
guint16
fu_struct_atom_rom21_header_get_protected_mode_info_offset(const FuStructAtomRom21Header *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 10, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_atom_rom21_header_get_config_filename_offset: (skip):
 **/
guint16
fu_struct_atom_rom21_header_get_config_filename_offset(const FuStructAtomRom21Header *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 12, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_atom_rom21_header_get_crc_block_offset: (skip):
 **/
guint16
fu_struct_atom_rom21_header_get_crc_block_offset(const FuStructAtomRom21Header *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 14, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_atom_rom21_header_get_bios_bootup_message_offset: (skip):
 **/
guint16
fu_struct_atom_rom21_header_get_bios_bootup_message_offset(const FuStructAtomRom21Header *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 16, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_atom_rom21_header_get_int10_offset: (skip):
 **/
guint16
fu_struct_atom_rom21_header_get_int10_offset(const FuStructAtomRom21Header *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 18, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_atom_rom21_header_get_pci_bus_dev_init_code: (skip):
 **/
guint16
fu_struct_atom_rom21_header_get_pci_bus_dev_init_code(const FuStructAtomRom21Header *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 20, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_atom_rom21_header_get_io_base_addr: (skip):
 **/
guint16
fu_struct_atom_rom21_header_get_io_base_addr(const FuStructAtomRom21Header *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 22, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_atom_rom21_header_get_subsystem_vendor_id: (skip):
 **/
guint16
fu_struct_atom_rom21_header_get_subsystem_vendor_id(const FuStructAtomRom21Header *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 24, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_atom_rom21_header_get_subsystem_id: (skip):
 **/
guint16
fu_struct_atom_rom21_header_get_subsystem_id(const FuStructAtomRom21Header *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 26, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_atom_rom21_header_get_pci_info_offset: (skip):
 **/
guint16
fu_struct_atom_rom21_header_get_pci_info_offset(const FuStructAtomRom21Header *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 28, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_atom_rom21_header_get_master_command_table_offset: (skip):
 **/
guint16
fu_struct_atom_rom21_header_get_master_command_table_offset(const FuStructAtomRom21Header *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 30, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_atom_rom21_header_get_master_data_table_offset: (skip):
 **/
guint16
fu_struct_atom_rom21_header_get_master_data_table_offset(const FuStructAtomRom21Header *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 32, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_atom_rom21_header_get_extended_function_code: (skip):
 **/
guint8
fu_struct_atom_rom21_header_get_extended_function_code(const FuStructAtomRom21Header *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[34];
}
/**
 * fu_struct_atom_rom21_header_get_psp_dir_table_offset: (skip):
 **/
guint32
fu_struct_atom_rom21_header_get_psp_dir_table_offset(const FuStructAtomRom21Header *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 36, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_atom_rom21_header_to_string: (skip):
 **/
static gchar *
fu_struct_atom_rom21_header_to_string(const FuStructAtomRom21Header *st)
{
    g_autoptr(GString) str = g_string_new("FuStructAtomRom21Header:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        g_autoptr(GByteArray) st_tmp = fu_struct_atom_rom21_header_get_header(st);
        g_autofree gchar *tmp = fu_struct_atom_header_common_to_string(st_tmp);
        g_string_append_printf(str, "  header: %s\n", tmp);
    }
    g_string_append_printf(str, "  bios_runtime_seg_addr: 0x%x\n",
                           (guint) fu_struct_atom_rom21_header_get_bios_runtime_seg_addr(st));
    g_string_append_printf(str, "  protected_mode_info_offset: 0x%x\n",
                           (guint) fu_struct_atom_rom21_header_get_protected_mode_info_offset(st));
    g_string_append_printf(str, "  config_filename_offset: 0x%x\n",
                           (guint) fu_struct_atom_rom21_header_get_config_filename_offset(st));
    g_string_append_printf(str, "  crc_block_offset: 0x%x\n",
                           (guint) fu_struct_atom_rom21_header_get_crc_block_offset(st));
    g_string_append_printf(str, "  bios_bootup_message_offset: 0x%x\n",
                           (guint) fu_struct_atom_rom21_header_get_bios_bootup_message_offset(st));
    g_string_append_printf(str, "  int10_offset: 0x%x\n",
                           (guint) fu_struct_atom_rom21_header_get_int10_offset(st));
    g_string_append_printf(str, "  pci_bus_dev_init_code: 0x%x\n",
                           (guint) fu_struct_atom_rom21_header_get_pci_bus_dev_init_code(st));
    g_string_append_printf(str, "  io_base_addr: 0x%x\n",
                           (guint) fu_struct_atom_rom21_header_get_io_base_addr(st));
    g_string_append_printf(str, "  subsystem_vendor_id: 0x%x\n",
                           (guint) fu_struct_atom_rom21_header_get_subsystem_vendor_id(st));
    g_string_append_printf(str, "  subsystem_id: 0x%x\n",
                           (guint) fu_struct_atom_rom21_header_get_subsystem_id(st));
    g_string_append_printf(str, "  pci_info_offset: 0x%x\n",
                           (guint) fu_struct_atom_rom21_header_get_pci_info_offset(st));
    g_string_append_printf(str, "  master_command_table_offset: 0x%x\n",
                           (guint) fu_struct_atom_rom21_header_get_master_command_table_offset(st));
    g_string_append_printf(str, "  master_data_table_offset: 0x%x\n",
                           (guint) fu_struct_atom_rom21_header_get_master_data_table_offset(st));
    g_string_append_printf(str, "  extended_function_code: 0x%x\n",
                           (guint) fu_struct_atom_rom21_header_get_extended_function_code(st));
    g_string_append_printf(str, "  psp_dir_table_offset: 0x%x\n",
                           (guint) fu_struct_atom_rom21_header_get_psp_dir_table_offset(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_atom_rom21_header_validate_internal(FuStructAtomRom21Header *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (strncmp((const gchar *) (st->data + 4), "ATOM", 4) != 0) {
        g_autofree gchar *str = fu_struct_atom_rom21_header_get_signature(st);
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuStructAtomRom21Header.signature was not valid, "
                    "expected 'ATOM' and got '%s'",
                    str);
        return FALSE;
    }
    {
        GByteArray st_tmp = {
            .data = (guint8*) st->data + 0x0,
            .len = 4,
        };
        if (!fu_struct_atom_header_common_validate_internal(&st_tmp, error))
            return FALSE;
    }
    return TRUE;
}
/**
 * fu_struct_atom_rom21_header_validate_stream: (skip):
 **/
gboolean
fu_struct_atom_rom21_header_validate_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = NULL;
    g_return_val_if_fail(G_IS_INPUT_STREAM(stream), FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    st = fu_input_stream_read_byte_array(stream, offset, 40, NULL, error);
    if (st == NULL) {
        g_prefix_error(error, "FuStructAtomRom21Header failed read of 0x%x: ", (guint) 40);
        return FALSE;
    }
    if (st->len != 40) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructAtomRom21Header requested 0x%x and got 0x%x",
                    (guint) 40,
                    (guint) st->len);
        return FALSE;
    }
    return fu_struct_atom_rom21_header_validate_internal(st, error);
}
static gboolean
fu_struct_atom_rom21_header_parse_internal(FuStructAtomRom21Header *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_atom_rom21_header_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_atom_rom21_header_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_atom_rom21_header_parse_stream: (skip):
 **/
FuStructAtomRom21Header *
fu_struct_atom_rom21_header_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = NULL;
    st = fu_input_stream_read_byte_array(stream, offset, 40, NULL, error);
    if (st == NULL) {
        g_prefix_error(error, "FuStructAtomRom21Header failed read of 0x%x: ", (guint) 40);
        return NULL;
    }
    if (st->len != 40) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructAtomRom21Header requested 0x%x and got 0x%x",
                    (guint) 40,
                    (guint) st->len);
        return NULL;
    }
    if (!fu_struct_atom_rom21_header_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
