/* VpnMenuItem.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from VpnMenuItem.vala, do not modify */

/*
 * Copyright (c) 2017-2018 elementary LLC (https://elementary.io)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "networkapplet.h"
#include <glib.h>
#include <NetworkManager.h>
#include <gtk/gtk.h>
#include <glib-object.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	NETWORK_VPN_MENU_ITEM_0_PROPERTY,
	NETWORK_VPN_MENU_ITEM_CONNECTION_PROPERTY,
	NETWORK_VPN_MENU_ITEM_ID_PROPERTY,
	NETWORK_VPN_MENU_ITEM_VPN_STATE_PROPERTY,
	NETWORK_VPN_MENU_ITEM_RADIO_BUTTON_PROPERTY,
	NETWORK_VPN_MENU_ITEM_NUM_PROPERTIES
};
static GParamSpec* network_vpn_menu_item_properties[NETWORK_VPN_MENU_ITEM_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
typedef struct _NetworkVpnMenuItemNapData NetworkVpnMenuItemNapData;
typedef struct _NetworkVpnMenuItemCheckVpnConnectivityData NetworkVpnMenuItemCheckVpnConnectivityData;
enum  {
	NETWORK_VPN_MENU_ITEM_USER_ACTION_SIGNAL,
	NETWORK_VPN_MENU_ITEM_NUM_SIGNALS
};
static guint network_vpn_menu_item_signals[NETWORK_VPN_MENU_ITEM_NUM_SIGNALS] = {0};

struct _NetworkVpnMenuItemPrivate {
	gboolean checking_vpn_connectivity;
	NMRemoteConnection* _connection;
	NetworkState _vpn_state;
	GtkRadioButton* _radio_button;
	GtkSpinner* spinner;
	GtkImage* error_img;
};

struct _Block1Data {
	int _ref_count_;
	NetworkVpnMenuItem* self;
	gpointer _async_data_;
};

struct _NetworkVpnMenuItemNapData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	NetworkVpnMenuItem* self;
	guint interval;
	gint priority;
	Block1Data* _data1_;
};

struct _NetworkVpnMenuItemCheckVpnConnectivityData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	NetworkVpnMenuItem* self;
	gint i;
	gboolean _tmp0_;
	gint _tmp1_;
	NetworkState _tmp2_;
	GtkSpinner* _tmp3_;
};

static gint NetworkVpnMenuItem_private_offset;
static gpointer network_vpn_menu_item_parent_class = NULL;
static GtkRadioButton* network_vpn_menu_item_blank_button;
static GtkRadioButton* network_vpn_menu_item_blank_button = NULL;
static GType network_vpn_menu_item_type_id = 0;

static void network_vpn_menu_item_set_connection (NetworkVpnMenuItem* self,
                                           NMRemoteConnection* value);
static void network_vpn_menu_item_update (NetworkVpnMenuItem* self);
static void _network_vpn_menu_item_update_nm_connection_changed (NMConnection* _sender,
                                                          gpointer self);
static void network_vpn_menu_item_set_radio_button (NetworkVpnMenuItem* self,
                                             GtkRadioButton* value);
static gboolean __lambda29_ (NetworkVpnMenuItem* self,
                      GtkWidget* b,
                      GdkEventButton* ev);
static gboolean ___lambda29__gtk_widget_button_release_event (GtkWidget* _sender,
                                                       GdkEventButton* event,
                                                       gpointer self);
static void _network_vpn_menu_item_update_g_object_notify (GObject* _sender,
                                                    GParamSpec* pspec,
                                                    gpointer self);
static void network_vpn_menu_item_hide_item (NetworkVpnMenuItem* self,
                                      GtkWidget* w);
static void network_vpn_menu_item_show_item (NetworkVpnMenuItem* self,
                                      GtkWidget* w);
static void network_vpn_menu_item_check_vpn_connectivity (NetworkVpnMenuItem* self,
                                                   GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_);
static void network_vpn_menu_item_check_vpn_connectivity_finish (NetworkVpnMenuItem* self,
                                                          GAsyncResult* _res_);
static void network_vpn_menu_item_nap_data_free (gpointer _data);
static void network_vpn_menu_item_nap (NetworkVpnMenuItem* self,
                                guint interval,
                                gint priority,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_);
static void network_vpn_menu_item_nap_finish (NetworkVpnMenuItem* self,
                                       GAsyncResult* _res_);
static gboolean network_vpn_menu_item_nap_co (NetworkVpnMenuItemNapData* _data_);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static gboolean __lambda28_ (Block1Data* _data1_);
static gboolean ___lambda28__gsource_func (gpointer self);
static void network_vpn_menu_item_check_vpn_connectivity_data_free (gpointer _data);
static gboolean network_vpn_menu_item_check_vpn_connectivity_co (NetworkVpnMenuItemCheckVpnConnectivityData* _data_);
static void network_vpn_menu_item_check_vpn_connectivity_ready (GObject* source_object,
                                                         GAsyncResult* _res_,
                                                         gpointer _user_data_);
static void network_vpn_menu_item_finalize (GObject * obj);
static void _vala_network_vpn_menu_item_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void _vala_network_vpn_menu_item_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec);

static inline gpointer
network_vpn_menu_item_get_instance_private (NetworkVpnMenuItem* self)
{
	return G_STRUCT_MEMBER_P (self, NetworkVpnMenuItem_private_offset);
}

static void
_network_vpn_menu_item_update_nm_connection_changed (NMConnection* _sender,
                                                     gpointer self)
{
	network_vpn_menu_item_update ((NetworkVpnMenuItem*) self);
}

static gboolean
__lambda29_ (NetworkVpnMenuItem* self,
             GtkWidget* b,
             GdkEventButton* ev)
{
	gboolean result;
	g_return_val_if_fail (b != NULL, FALSE);
	g_return_val_if_fail (ev != NULL, FALSE);
	g_signal_emit (self, network_vpn_menu_item_signals[NETWORK_VPN_MENU_ITEM_USER_ACTION_SIGNAL], 0);
	result = FALSE;
	return result;
}

static gboolean
___lambda29__gtk_widget_button_release_event (GtkWidget* _sender,
                                              GdkEventButton* event,
                                              gpointer self)
{
	gboolean result;
	result = __lambda29_ ((NetworkVpnMenuItem*) self, _sender, event);
	return result;
}

static void
_network_vpn_menu_item_update_g_object_notify (GObject* _sender,
                                               GParamSpec* pspec,
                                               gpointer self)
{
	network_vpn_menu_item_update ((NetworkVpnMenuItem*) self);
}

NetworkVpnMenuItem*
network_vpn_menu_item_construct (GType object_type,
                                 NMRemoteConnection* _connection)
{
	NetworkVpnMenuItem * self = NULL;
	NMRemoteConnection* _tmp0_;
	GtkBox* main_box = NULL;
	GtkBox* _tmp1_;
	GtkBox* _tmp2_;
	GtkBox* _tmp3_;
	GtkRadioButton* _tmp4_;
	GtkRadioButton* _tmp5_;
	GtkRadioButton* _tmp6_;
	GtkRadioButton* _tmp9_;
	GtkImage* _tmp10_;
	GtkImage* _tmp11_;
	GtkImage* _tmp12_;
	GtkSpinner* _tmp13_;
	GtkSpinner* _tmp14_;
	GtkSpinner* _tmp15_;
	GtkSpinner* _tmp16_;
	GtkSpinner* _tmp17_;
	gboolean _tmp18_;
	gboolean _tmp19_;
	GtkBox* _tmp20_;
	GtkRadioButton* _tmp21_;
	GtkBox* _tmp22_;
	GtkSpinner* _tmp23_;
	GtkBox* _tmp24_;
	GtkImage* _tmp25_;
	GtkRadioButton* _tmp26_;
	GtkBox* _tmp27_;
	GtkStyleContext* _tmp28_;
	self = (NetworkVpnMenuItem*) g_object_new (object_type, NULL);
	network_vpn_menu_item_set_connection (self, _connection);
	_tmp0_ = self->priv->_connection;
	g_signal_connect_object ((NMConnection*) _tmp0_, "changed", (GCallback) _network_vpn_menu_item_update_nm_connection_changed, self, 0);
	_tmp1_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	g_object_ref_sink (_tmp1_);
	main_box = _tmp1_;
	_tmp2_ = main_box;
	_tmp3_ = main_box;
	gtk_widget_set_margin_end ((GtkWidget*) _tmp3_, 6);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp2_, 6);
	_tmp4_ = (GtkRadioButton*) gtk_radio_button_new (NULL);
	g_object_ref_sink (_tmp4_);
	_tmp5_ = _tmp4_;
	network_vpn_menu_item_set_radio_button (self, _tmp5_);
	_g_object_unref0 (_tmp5_);
	_tmp6_ = network_vpn_menu_item_blank_button;
	if (_tmp6_ != NULL) {
		GtkRadioButton* _tmp7_;
		GtkRadioButton* _tmp8_;
		_tmp7_ = self->priv->_radio_button;
		_tmp8_ = network_vpn_menu_item_blank_button;
		gtk_radio_button_join_group (_tmp7_, _tmp8_);
	}
	_tmp9_ = self->priv->_radio_button;
	g_signal_connect_object ((GtkWidget*) _tmp9_, "button-release-event", (GCallback) ___lambda29__gtk_widget_button_release_event, self, 0);
	_tmp10_ = (GtkImage*) gtk_image_new_from_icon_name ("process-error-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp10_);
	_g_object_unref0 (self->priv->error_img);
	self->priv->error_img = _tmp10_;
	_tmp11_ = self->priv->error_img;
	gtk_widget_set_margin_start ((GtkWidget*) _tmp11_, 6);
	_tmp12_ = self->priv->error_img;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp12_, _ ("This Virtual Private Network could not be connected to."));
	_tmp13_ = (GtkSpinner*) gtk_spinner_new ();
	g_object_ref_sink (_tmp13_);
	_g_object_unref0 (self->priv->spinner);
	self->priv->spinner = _tmp13_;
	_tmp14_ = self->priv->spinner;
	gtk_spinner_start (_tmp14_);
	_tmp15_ = self->priv->spinner;
	gtk_widget_set_visible ((GtkWidget*) _tmp15_, FALSE);
	_tmp16_ = self->priv->spinner;
	_tmp17_ = self->priv->spinner;
	_tmp18_ = gtk_widget_get_visible ((GtkWidget*) _tmp17_);
	_tmp19_ = _tmp18_;
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp16_, !_tmp19_);
	_tmp20_ = main_box;
	_tmp21_ = self->priv->_radio_button;
	gtk_box_pack_start (_tmp20_, (GtkWidget*) _tmp21_, TRUE, TRUE, (guint) 0);
	_tmp22_ = main_box;
	_tmp23_ = self->priv->spinner;
	gtk_box_pack_start (_tmp22_, (GtkWidget*) _tmp23_, FALSE, FALSE, (guint) 0);
	_tmp24_ = main_box;
	_tmp25_ = self->priv->error_img;
	gtk_box_pack_start (_tmp24_, (GtkWidget*) _tmp25_, FALSE, FALSE, (guint) 0);
	g_signal_connect_object ((GObject*) self, "notify::vpn_state", (GCallback) _network_vpn_menu_item_update_g_object_notify, self, 0);
	_tmp26_ = self->priv->_radio_button;
	g_signal_connect_object ((GObject*) _tmp26_, "notify::active", (GCallback) _network_vpn_menu_item_update_g_object_notify, self, 0);
	_tmp27_ = main_box;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp27_);
	_tmp28_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp28_, "menuitem");
	network_vpn_menu_item_update (self);
	_g_object_unref0 (main_box);
	return self;
}

NetworkVpnMenuItem*
network_vpn_menu_item_new (NMRemoteConnection* _connection)
{
	return network_vpn_menu_item_construct (NETWORK_TYPE_VPN_MENU_ITEM, _connection);
}

/**
    * Only used for an item which is not displayed: hacky way to have no radio button selected.
    **/
NetworkVpnMenuItem*
network_vpn_menu_item_construct_blank (GType object_type)
{
	NetworkVpnMenuItem * self = NULL;
	GtkRadioButton* _tmp0_;
	GtkRadioButton* _tmp1_;
	GtkRadioButton* _tmp2_;
	self = (NetworkVpnMenuItem*) g_object_new (object_type, NULL);
	_tmp0_ = (GtkRadioButton*) gtk_radio_button_new (NULL);
	g_object_ref_sink (_tmp0_);
	_tmp1_ = _tmp0_;
	network_vpn_menu_item_set_radio_button (self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = self->priv->_radio_button;
	network_vpn_menu_item_blank_button = _tmp2_;
	return self;
}

NetworkVpnMenuItem*
network_vpn_menu_item_new_blank (void)
{
	return network_vpn_menu_item_construct_blank (NETWORK_TYPE_VPN_MENU_ITEM);
}

static void
network_vpn_menu_item_update (NetworkVpnMenuItem* self)
{
	GtkRadioButton* _tmp0_;
	NMRemoteConnection* _tmp1_;
	const gchar* _tmp2_;
	GtkImage* _tmp3_;
	GtkSpinner* _tmp4_;
	NetworkState _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_radio_button;
	_tmp1_ = self->priv->_connection;
	_tmp2_ = nm_connection_get_id ((NMConnection*) _tmp1_);
	gtk_button_set_label ((GtkButton*) _tmp0_, _tmp2_);
	_tmp3_ = self->priv->error_img;
	network_vpn_menu_item_hide_item (self, (GtkWidget*) _tmp3_);
	_tmp4_ = self->priv->spinner;
	network_vpn_menu_item_hide_item (self, (GtkWidget*) _tmp4_);
	_tmp5_ = self->priv->_vpn_state;
	switch (_tmp5_) {
		case NETWORK_STATE_FAILED_VPN:
		{
			GtkImage* _tmp6_;
			_tmp6_ = self->priv->error_img;
			network_vpn_menu_item_show_item (self, (GtkWidget*) _tmp6_);
			break;
		}
		case NETWORK_STATE_CONNECTING_VPN:
		{
			GtkSpinner* _tmp7_;
			GtkRadioButton* _tmp8_;
			gboolean _tmp9_;
			gboolean _tmp10_;
			_tmp7_ = self->priv->spinner;
			network_vpn_menu_item_show_item (self, (GtkWidget*) _tmp7_);
			_tmp8_ = self->priv->_radio_button;
			_tmp9_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp8_);
			_tmp10_ = _tmp9_;
			if (!_tmp10_) {
				g_critical ("VpnMenuItem.vala:95: An VPN is being connected but not active.");
			}
			network_vpn_menu_item_check_vpn_connectivity (self, NULL, NULL);
			break;
		}
		default:
		break;
	}
}

void
network_vpn_menu_item_set_active (NetworkVpnMenuItem* self,
                                  gboolean active)
{
	GtkRadioButton* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_radio_button;
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp0_, active);
}

static void
network_vpn_menu_item_show_item (NetworkVpnMenuItem* self,
                                 GtkWidget* w)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (w != NULL);
	gtk_widget_set_visible (w, TRUE);
	_tmp0_ = gtk_widget_get_visible (w);
	_tmp1_ = _tmp0_;
	gtk_widget_set_no_show_all (w, _tmp1_);
}

static void
network_vpn_menu_item_hide_item (NetworkVpnMenuItem* self,
                                 GtkWidget* w)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (w != NULL);
	gtk_widget_set_visible (w, FALSE);
	_tmp0_ = gtk_widget_get_visible (w);
	_tmp1_ = _tmp0_;
	gtk_widget_set_no_show_all (w, !_tmp1_);
	gtk_widget_hide (w);
}

static void
network_vpn_menu_item_nap_data_free (gpointer _data)
{
	NetworkVpnMenuItemNapData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (NetworkVpnMenuItemNapData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
network_vpn_menu_item_nap (NetworkVpnMenuItem* self,
                           guint interval,
                           gint priority,
                           GAsyncReadyCallback _callback_,
                           gpointer _user_data_)
{
	NetworkVpnMenuItemNapData* _data_;
	NetworkVpnMenuItem* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (NetworkVpnMenuItemNapData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, network_vpn_menu_item_nap_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->interval = interval;
	_data_->priority = priority;
	network_vpn_menu_item_nap_co (_data_);
}

static void
network_vpn_menu_item_nap_finish (NetworkVpnMenuItem* self,
                                  GAsyncResult* _res_)
{
	NetworkVpnMenuItemNapData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		NetworkVpnMenuItem* self;
		self = _data1_->self;
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static gboolean
__lambda28_ (Block1Data* _data1_)
{
	NetworkVpnMenuItem* self;
	gboolean result;
	self = _data1_->self;
	network_vpn_menu_item_nap_co (_data1_->_async_data_);
	result = FALSE;
	return result;
}

static gboolean
___lambda28__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda28_ (self);
	return result;
}

static gboolean
network_vpn_menu_item_nap_co (NetworkVpnMenuItemNapData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data1_ = g_slice_new0 (Block1Data);
	_data_->_data1_->_ref_count_ = 1;
	_data_->_data1_->self = g_object_ref (_data_->self);
	_data_->_data1_->_async_data_ = _data_;
	g_timeout_add_full (_data_->priority, _data_->interval, ___lambda28__gsource_func, block1_data_ref (_data_->_data1_), block1_data_unref);
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	block1_data_unref (_data_->_data1_);
	_data_->_data1_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
network_vpn_menu_item_check_vpn_connectivity_data_free (gpointer _data)
{
	NetworkVpnMenuItemCheckVpnConnectivityData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (NetworkVpnMenuItemCheckVpnConnectivityData, _data_);
}

static void
network_vpn_menu_item_check_vpn_connectivity (NetworkVpnMenuItem* self,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_)
{
	NetworkVpnMenuItemCheckVpnConnectivityData* _data_;
	NetworkVpnMenuItem* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (NetworkVpnMenuItemCheckVpnConnectivityData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, network_vpn_menu_item_check_vpn_connectivity_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	network_vpn_menu_item_check_vpn_connectivity_co (_data_);
}

static void
network_vpn_menu_item_check_vpn_connectivity_finish (NetworkVpnMenuItem* self,
                                                     GAsyncResult* _res_)
{
	NetworkVpnMenuItemCheckVpnConnectivityData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

/**
    * Uses a timeout to check VPN connectivity
    **/
static void
network_vpn_menu_item_check_vpn_connectivity_ready (GObject* source_object,
                                                    GAsyncResult* _res_,
                                                    gpointer _user_data_)
{
	NetworkVpnMenuItemCheckVpnConnectivityData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	network_vpn_menu_item_check_vpn_connectivity_co (_data_);
}

static gboolean
network_vpn_menu_item_check_vpn_connectivity_co (NetworkVpnMenuItemCheckVpnConnectivityData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (!_data_->self->priv->checking_vpn_connectivity) {
		_data_->self->priv->checking_vpn_connectivity = TRUE;
		{
			_data_->i = 0;
			{
				_data_->_tmp0_ = TRUE;
				while (TRUE) {
					if (!_data_->_tmp0_) {
						_data_->_tmp1_ = _data_->i;
						_data_->i = _data_->_tmp1_ + 1;
					}
					_data_->_tmp0_ = FALSE;
					if (!(_data_->i < 20)) {
						break;
					}
					_data_->_tmp2_ = _data_->self->priv->_vpn_state;
					if (_data_->_tmp2_ == NETWORK_STATE_CONNECTED_VPN) {
						_data_->_tmp3_ = _data_->self->priv->spinner;
						network_vpn_menu_item_hide_item (_data_->self, (GtkWidget*) _data_->_tmp3_);
						_data_->self->priv->checking_vpn_connectivity = FALSE;
						g_task_return_pointer (_data_->_async_result, _data_, NULL);
						if (_data_->_state_ != 0) {
							while (!g_task_get_completed (_data_->_async_result)) {
								g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
							}
						}
						g_object_unref (_data_->_async_result);
						return FALSE;
					}
					_data_->_state_ = 1;
					network_vpn_menu_item_nap (_data_->self, (guint) 500, G_PRIORITY_DEFAULT, network_vpn_menu_item_check_vpn_connectivity_ready, _data_);
					return FALSE;
					_state_1:
					network_vpn_menu_item_nap_finish (_data_->self, _data_->_res_);
				}
			}
		}
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

NMRemoteConnection*
network_vpn_menu_item_get_connection (NetworkVpnMenuItem* self)
{
	NMRemoteConnection* result;
	NMRemoteConnection* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_connection;
	result = _tmp0_;
	return result;
}

static void
network_vpn_menu_item_set_connection (NetworkVpnMenuItem* self,
                                      NMRemoteConnection* value)
{
	NMRemoteConnection* old_value;
	g_return_if_fail (self != NULL);
	old_value = network_vpn_menu_item_get_connection (self);
	if (old_value != value) {
		NMRemoteConnection* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_connection);
		self->priv->_connection = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, network_vpn_menu_item_properties[NETWORK_VPN_MENU_ITEM_CONNECTION_PROPERTY]);
	}
}

const gchar*
network_vpn_menu_item_get_id (NetworkVpnMenuItem* self)
{
	const gchar* result;
	NMRemoteConnection* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_connection;
	_tmp1_ = nm_connection_get_id ((NMConnection*) _tmp0_);
	result = _tmp1_;
	return result;
}

NetworkState
network_vpn_menu_item_get_vpn_state (NetworkVpnMenuItem* self)
{
	NetworkState result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_vpn_state;
	return result;
}

void
network_vpn_menu_item_set_vpn_state (NetworkVpnMenuItem* self,
                                     NetworkState value)
{
	NetworkState old_value;
	g_return_if_fail (self != NULL);
	old_value = network_vpn_menu_item_get_vpn_state (self);
	if (old_value != value) {
		self->priv->_vpn_state = value;
		g_object_notify_by_pspec ((GObject *) self, network_vpn_menu_item_properties[NETWORK_VPN_MENU_ITEM_VPN_STATE_PROPERTY]);
	}
}

GtkRadioButton*
network_vpn_menu_item_get_radio_button (NetworkVpnMenuItem* self)
{
	GtkRadioButton* result;
	GtkRadioButton* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_radio_button;
	result = _tmp0_;
	return result;
}

static void
network_vpn_menu_item_set_radio_button (NetworkVpnMenuItem* self,
                                        GtkRadioButton* value)
{
	GtkRadioButton* old_value;
	g_return_if_fail (self != NULL);
	old_value = network_vpn_menu_item_get_radio_button (self);
	if (old_value != value) {
		GtkRadioButton* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_radio_button);
		self->priv->_radio_button = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, network_vpn_menu_item_properties[NETWORK_VPN_MENU_ITEM_RADIO_BUTTON_PROPERTY]);
	}
}

static void
network_vpn_menu_item_class_init (NetworkVpnMenuItemClass * klass,
                                  gpointer klass_data)
{
	network_vpn_menu_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &NetworkVpnMenuItem_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_network_vpn_menu_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_network_vpn_menu_item_set_property;
	G_OBJECT_CLASS (klass)->finalize = network_vpn_menu_item_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETWORK_VPN_MENU_ITEM_CONNECTION_PROPERTY, network_vpn_menu_item_properties[NETWORK_VPN_MENU_ITEM_CONNECTION_PROPERTY] = g_param_spec_object ("connection", "connection", "connection", nm_remote_connection_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETWORK_VPN_MENU_ITEM_ID_PROPERTY, network_vpn_menu_item_properties[NETWORK_VPN_MENU_ITEM_ID_PROPERTY] = g_param_spec_string ("id", "id", "id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETWORK_VPN_MENU_ITEM_VPN_STATE_PROPERTY, network_vpn_menu_item_properties[NETWORK_VPN_MENU_ITEM_VPN_STATE_PROPERTY] = g_param_spec_enum ("vpn-state", "vpn-state", "vpn-state", NETWORK_TYPE_STATE, NETWORK_STATE_DISCONNECTED, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETWORK_VPN_MENU_ITEM_RADIO_BUTTON_PROPERTY, network_vpn_menu_item_properties[NETWORK_VPN_MENU_ITEM_RADIO_BUTTON_PROPERTY] = g_param_spec_object ("radio-button", "radio-button", "radio-button", gtk_radio_button_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	network_vpn_menu_item_signals[NETWORK_VPN_MENU_ITEM_USER_ACTION_SIGNAL] = g_signal_new ("user-action", NETWORK_TYPE_VPN_MENU_ITEM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
network_vpn_menu_item_instance_init (NetworkVpnMenuItem * self,
                                     gpointer klass)
{
	self->priv = network_vpn_menu_item_get_instance_private (self);
	self->priv->checking_vpn_connectivity = FALSE;
	self->priv->_vpn_state = NETWORK_STATE_DISCONNECTED;
}

static void
network_vpn_menu_item_finalize (GObject * obj)
{
	NetworkVpnMenuItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETWORK_TYPE_VPN_MENU_ITEM, NetworkVpnMenuItem);
	_g_object_unref0 (self->priv->_connection);
	_g_object_unref0 (self->priv->_radio_button);
	_g_object_unref0 (self->priv->spinner);
	_g_object_unref0 (self->priv->error_img);
	G_OBJECT_CLASS (network_vpn_menu_item_parent_class)->finalize (obj);
}

GType
network_vpn_menu_item_get_type (void)
{
	return network_vpn_menu_item_type_id;
}

GType
network_vpn_menu_item_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (NetworkVpnMenuItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) network_vpn_menu_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetworkVpnMenuItem), 0, (GInstanceInitFunc) network_vpn_menu_item_instance_init, NULL };
	network_vpn_menu_item_type_id = g_type_module_register_type (module, gtk_list_box_row_get_type (), "NetworkVpnMenuItem", &g_define_type_info, 0);
	NetworkVpnMenuItem_private_offset = sizeof (NetworkVpnMenuItemPrivate);
	return network_vpn_menu_item_type_id;
}

static void
_vala_network_vpn_menu_item_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	NetworkVpnMenuItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NETWORK_TYPE_VPN_MENU_ITEM, NetworkVpnMenuItem);
	switch (property_id) {
		case NETWORK_VPN_MENU_ITEM_CONNECTION_PROPERTY:
		g_value_set_object (value, network_vpn_menu_item_get_connection (self));
		break;
		case NETWORK_VPN_MENU_ITEM_ID_PROPERTY:
		g_value_set_string (value, network_vpn_menu_item_get_id (self));
		break;
		case NETWORK_VPN_MENU_ITEM_VPN_STATE_PROPERTY:
		g_value_set_enum (value, network_vpn_menu_item_get_vpn_state (self));
		break;
		case NETWORK_VPN_MENU_ITEM_RADIO_BUTTON_PROPERTY:
		g_value_set_object (value, network_vpn_menu_item_get_radio_button (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_network_vpn_menu_item_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec)
{
	NetworkVpnMenuItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NETWORK_TYPE_VPN_MENU_ITEM, NetworkVpnMenuItem);
	switch (property_id) {
		case NETWORK_VPN_MENU_ITEM_CONNECTION_PROPERTY:
		network_vpn_menu_item_set_connection (self, g_value_get_object (value));
		break;
		case NETWORK_VPN_MENU_ITEM_VPN_STATE_PROPERTY:
		network_vpn_menu_item_set_vpn_state (self, g_value_get_enum (value));
		break;
		case NETWORK_VPN_MENU_ITEM_RADIO_BUTTON_PROPERTY:
		network_vpn_menu_item_set_radio_button (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

