/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import org.apache.jasper.compiler.Localizer;

public class AttributeParser {
    private final String input;
    private final char quote;
    private final boolean isELIgnored;
    private final boolean isDeferredSyntaxAllowedAsLiteral;
    private final boolean strict;
    private final boolean quoteAttributeEL;
    private final char type;
    private final int size;
    private int i = 0;
    private boolean lastChEscaped = false;
    private final StringBuilder result;

    public static String getUnquoted(String string, char c, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        return new AttributeParser(string, c, bl, bl2, bl3, bl4).getUnquoted();
    }

    private AttributeParser(String string, char c, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.input = string;
        this.quote = c;
        this.isELIgnored = bl;
        this.isDeferredSyntaxAllowedAsLiteral = bl2;
        this.strict = bl3;
        this.quoteAttributeEL = bl4;
        this.type = this.getType(string);
        this.size = string.length();
        this.result = new StringBuilder(this.size);
    }

    private String getUnquoted() {
        while (this.i < this.size) {
            this.parseLiteral();
            this.parseEL();
        }
        return this.result.toString();
    }

    private void parseLiteral() {
        boolean bl = false;
        while (this.i < this.size && !bl) {
            char c = this.nextChar();
            if (!this.isELIgnored && c == '\\') {
                if (this.type == '\u0000') {
                    this.result.append("\\");
                    continue;
                }
                this.result.append(this.type);
                this.result.append("{'\\\\'}");
                continue;
            }
            if (!this.isELIgnored && c == '$' && this.lastChEscaped) {
                if (this.type == '\u0000') {
                    this.result.append("\\$");
                    continue;
                }
                this.result.append(this.type);
                this.result.append("{'$'}");
                continue;
            }
            if (!this.isELIgnored && c == '#' && this.lastChEscaped) {
                if (this.type == '\u0000') {
                    this.result.append("\\#");
                    continue;
                }
                this.result.append(this.type);
                this.result.append("{'#'}");
                continue;
            }
            if (c == this.type) {
                if (this.i < this.size) {
                    char c2 = this.input.charAt(this.i);
                    if (c2 == '{') {
                        bl = true;
                        --this.i;
                        continue;
                    }
                    this.result.append(c);
                    continue;
                }
                this.result.append(c);
                continue;
            }
            this.result.append(c);
        }
    }

    private void parseEL() {
        boolean bl = false;
        boolean bl2 = false;
        char c = '\u0000';
        while (this.i < this.size && !bl) {
            char c2 = this.quoteAttributeEL ? this.nextChar() : this.input.charAt(this.i++);
            if (c2 == '\'' || c2 == '\"') {
                if (bl2) {
                    if (c == c2) {
                        bl2 = false;
                    }
                } else {
                    bl2 = true;
                    c = c2;
                }
                this.result.append(c2);
                continue;
            }
            if (c2 == '\\') {
                this.result.append(c2);
                if (!bl2 || this.size >= this.i) continue;
                c2 = this.quoteAttributeEL ? this.nextChar() : this.input.charAt(this.i++);
                this.result.append(c2);
                continue;
            }
            if (c2 == '}') {
                if (!bl2) {
                    bl = true;
                }
                this.result.append(c2);
                continue;
            }
            this.result.append(c2);
        }
    }

    private char nextChar() {
        this.lastChEscaped = false;
        char c = this.input.charAt(this.i);
        if (c == '&') {
            if (this.i + 5 < this.size && this.input.charAt(this.i + 1) == 'a' && this.input.charAt(this.i + 2) == 'p' && this.input.charAt(this.i + 3) == 'o' && this.input.charAt(this.i + 4) == 's' && this.input.charAt(this.i + 5) == ';') {
                c = '\'';
                this.i += 6;
            } else if (this.i + 5 < this.size && this.input.charAt(this.i + 1) == 'q' && this.input.charAt(this.i + 2) == 'u' && this.input.charAt(this.i + 3) == 'o' && this.input.charAt(this.i + 4) == 't' && this.input.charAt(this.i + 5) == ';') {
                c = '\"';
                this.i += 6;
            } else {
                ++this.i;
            }
        } else if (c == '\\' && this.i + 1 < this.size) {
            c = this.input.charAt(this.i + 1);
            if (c == '\\' || c == '\"' || c == '\'' || !this.isELIgnored && (c == '$' || !this.isDeferredSyntaxAllowedAsLiteral && c == '#')) {
                this.i += 2;
                this.lastChEscaped = true;
            } else {
                c = '\\';
                ++this.i;
            }
        } else {
            if (c == '<' && this.i + 2 < this.size && this.input.charAt(this.i + 1) == '\\' && this.input.charAt(this.i + 2) == '%') {
                this.result.append('<');
                this.i += 3;
                return '%';
            }
            if (c == '%' && this.i + 2 < this.size && this.input.charAt(this.i + 1) == '\\' && this.input.charAt(this.i + 2) == '>') {
                this.result.append('%');
                this.i += 3;
                return '>';
            }
            if (c == this.quote && this.strict) {
                String string = Localizer.getMessage("jsp.error.attribute.noescape", this.input, "" + this.quote);
                throw new IllegalArgumentException(string);
            }
            ++this.i;
        }
        return (char)c;
    }

    private char getType(String string) {
        if (string == null) {
            return '\u0000';
        }
        if (this.isELIgnored) {
            return '\u0000';
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '\\') {
                ++i;
                continue;
            }
            if (c == '#' && !this.isDeferredSyntaxAllowedAsLiteral) {
                if (i >= n - 1 || string.charAt(i + 1) != '{') continue;
                return '#';
            }
            if (c != '$' || i >= n - 1 || string.charAt(i + 1) != '{') continue;
            return '$';
        }
        return '\u0000';
    }
}

