/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jaybird.util;

import java.sql.SQLException;
import java.util.Objects;
import java.util.function.Function;
import org.firebirdsql.jaybird.util.SQLExceptionThrowingFunction;
import org.firebirdsql.jaybird.util.UncheckedSQLException;
import org.jspecify.annotations.NullUnmarked;

@NullUnmarked
final class FunctionWrappingSQLExceptionThrowingFunction<T, R>
implements Function<T, R> {
    private final SQLExceptionThrowingFunction<T, R> wrapped;

    FunctionWrappingSQLExceptionThrowingFunction(SQLExceptionThrowingFunction<T, R> wrapped) {
        this.wrapped = Objects.requireNonNull(wrapped, "wrapped");
    }

    @Override
    public R apply(T t) {
        try {
            return this.wrapped.apply(t);
        }
        catch (SQLException e) {
            throw new UncheckedSQLException(e);
        }
    }

    SQLExceptionThrowingFunction<T, R> unwrap() {
        return this.wrapped;
    }
}

