/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.query_dsl;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch._types.query_dsl.QueryVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class RangeQuery
implements QueryVariant,
PlainJsonSerializable,
ToCopyableBuilder<Builder, RangeQuery> {
    @Nullable
    private final Float boost;
    @Nonnull
    private final String field;
    @Nullable
    private final String format;
    @Nullable
    private final JsonData from;
    @Nullable
    private final JsonData gt;
    @Nullable
    private final JsonData gte;
    @Nullable
    private final JsonData lt;
    @Nullable
    private final JsonData lte;
    @Nullable
    private final String name;
    @Nullable
    private final String relation;
    @Nullable
    private final String timeZone;
    @Nullable
    private final JsonData to;
    public static final JsonpDeserializer<RangeQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RangeQuery::setupRangeQueryDeserializer);

    private RangeQuery(Builder builder) {
        this.boost = builder.boost;
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.format = builder.format;
        this.from = builder.from;
        this.gt = builder.gt;
        this.gte = builder.gte;
        this.lt = builder.lt;
        this.lte = builder.lte;
        this.name = builder.name;
        this.relation = builder.relation;
        this.timeZone = builder.timeZone;
        this.to = builder.to;
    }

    public static RangeQuery of(Function<Builder, ObjectBuilder<RangeQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Query.Kind _queryKind() {
        return Query.Kind.Range;
    }

    @Nullable
    public final Float boost() {
        return this.boost;
    }

    @Nonnull
    public final String field() {
        return this.field;
    }

    @Nullable
    public final String format() {
        return this.format;
    }

    @Nullable
    public final JsonData from() {
        return this.from;
    }

    @Nullable
    public final JsonData gt() {
        return this.gt;
    }

    @Nullable
    public final JsonData gte() {
        return this.gte;
    }

    @Nullable
    public final JsonData lt() {
        return this.lt;
    }

    @Nullable
    public final JsonData lte() {
        return this.lte;
    }

    @Nullable
    public final String name() {
        return this.name;
    }

    @Nullable
    public final String relation() {
        return this.relation;
    }

    @Nullable
    public final String timeZone() {
        return this.timeZone;
    }

    @Nullable
    public final JsonData to() {
        return this.to;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject(this.field);
        if (this.boost != null) {
            generator.writeKey("boost");
            generator.write((double)this.boost.floatValue());
        }
        if (this.format != null) {
            generator.writeKey("format");
            generator.write(this.format);
        }
        if (this.from != null) {
            generator.writeKey("from");
            this.from.serialize(generator, mapper);
        }
        if (this.gt != null) {
            generator.writeKey("gt");
            this.gt.serialize(generator, mapper);
        }
        if (this.gte != null) {
            generator.writeKey("gte");
            this.gte.serialize(generator, mapper);
        }
        if (this.lt != null) {
            generator.writeKey("lt");
            this.lt.serialize(generator, mapper);
        }
        if (this.lte != null) {
            generator.writeKey("lte");
            this.lte.serialize(generator, mapper);
        }
        if (this.name != null) {
            generator.writeKey("_name");
            generator.write(this.name);
        }
        if (this.relation != null) {
            generator.writeKey("relation");
            generator.write(this.relation);
        }
        if (this.timeZone != null) {
            generator.writeKey("time_zone");
            generator.write(this.timeZone);
        }
        if (this.to != null) {
            generator.writeKey("to");
            this.to.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupRangeQueryDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::boost, JsonpDeserializer.floatDeserializer(), "boost");
        op.add(Builder::format, JsonpDeserializer.stringDeserializer(), "format");
        op.add(Builder::from, JsonData._DESERIALIZER, "from");
        op.add(Builder::gt, JsonData._DESERIALIZER, "gt");
        op.add(Builder::gte, JsonData._DESERIALIZER, "gte");
        op.add(Builder::lt, JsonData._DESERIALIZER, "lt");
        op.add(Builder::lte, JsonData._DESERIALIZER, "lte");
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "_name");
        op.add(Builder::relation, JsonpDeserializer.stringDeserializer(), "relation");
        op.add(Builder::timeZone, JsonpDeserializer.stringDeserializer(), "time_zone");
        op.add(Builder::to, JsonData._DESERIALIZER, "to");
        op.setKey(Builder::field, JsonpDeserializer.stringDeserializer());
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.boost);
        result = 31 * result + this.field.hashCode();
        result = 31 * result + Objects.hashCode(this.format);
        result = 31 * result + Objects.hashCode(this.from);
        result = 31 * result + Objects.hashCode(this.gt);
        result = 31 * result + Objects.hashCode(this.gte);
        result = 31 * result + Objects.hashCode(this.lt);
        result = 31 * result + Objects.hashCode(this.lte);
        result = 31 * result + Objects.hashCode(this.name);
        result = 31 * result + Objects.hashCode(this.relation);
        result = 31 * result + Objects.hashCode(this.timeZone);
        result = 31 * result + Objects.hashCode(this.to);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RangeQuery other = (RangeQuery)o;
        return Objects.equals(this.boost, other.boost) && this.field.equals(other.field) && Objects.equals(this.format, other.format) && Objects.equals(this.from, other.from) && Objects.equals(this.gt, other.gt) && Objects.equals(this.gte, other.gte) && Objects.equals(this.lt, other.lt) && Objects.equals(this.lte, other.lte) && Objects.equals(this.name, other.name) && Objects.equals(this.relation, other.relation) && Objects.equals(this.timeZone, other.timeZone) && Objects.equals(this.to, other.to);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, RangeQuery> {
        @Nullable
        private Float boost;
        private String field;
        @Nullable
        private String format;
        @Nullable
        private JsonData from;
        @Nullable
        private JsonData gt;
        @Nullable
        private JsonData gte;
        @Nullable
        private JsonData lt;
        @Nullable
        private JsonData lte;
        @Nullable
        private String name;
        @Nullable
        private String relation;
        @Nullable
        private String timeZone;
        @Nullable
        private JsonData to;

        public Builder() {
        }

        private Builder(RangeQuery o) {
            this.boost = o.boost;
            this.field = o.field;
            this.format = o.format;
            this.from = o.from;
            this.gt = o.gt;
            this.gte = o.gte;
            this.lt = o.lt;
            this.lte = o.lte;
            this.name = o.name;
            this.relation = o.relation;
            this.timeZone = o.timeZone;
            this.to = o.to;
        }

        private Builder(Builder o) {
            this.boost = o.boost;
            this.field = o.field;
            this.format = o.format;
            this.from = o.from;
            this.gt = o.gt;
            this.gte = o.gte;
            this.lt = o.lt;
            this.lte = o.lte;
            this.name = o.name;
            this.relation = o.relation;
            this.timeZone = o.timeZone;
            this.to = o.to;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder boost(@Nullable Float value) {
            this.boost = value;
            return this;
        }

        @Nonnull
        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        @Nonnull
        public final Builder format(@Nullable String value) {
            this.format = value;
            return this;
        }

        @Nonnull
        public final Builder from(@Nullable JsonData value) {
            this.from = value;
            return this;
        }

        @Nonnull
        public final Builder gt(@Nullable JsonData value) {
            this.gt = value;
            return this;
        }

        @Nonnull
        public final Builder gte(@Nullable JsonData value) {
            this.gte = value;
            return this;
        }

        @Nonnull
        public final Builder lt(@Nullable JsonData value) {
            this.lt = value;
            return this;
        }

        @Nonnull
        public final Builder lte(@Nullable JsonData value) {
            this.lte = value;
            return this;
        }

        @Nonnull
        public final Builder name(@Nullable String value) {
            this.name = value;
            return this;
        }

        @Nonnull
        public final Builder relation(@Nullable String value) {
            this.relation = value;
            return this;
        }

        @Nonnull
        public final Builder timeZone(@Nullable String value) {
            this.timeZone = value;
            return this;
        }

        @Nonnull
        public final Builder to(@Nullable JsonData value) {
            this.to = value;
            return this;
        }

        @Override
        @Nonnull
        public RangeQuery build() {
            this._checkSingleUse();
            return new RangeQuery(this);
        }
    }
}

