/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.classification.example;

import java.util.ArrayList;
import java.util.List;
import org.tribuo.Example;
import org.tribuo.Output;
import org.tribuo.classification.Label;
import org.tribuo.classification.example.DemoLabelDataSource;
import org.tribuo.impl.ArrayExample;

public final class InterlockingCrescentsDataSource
extends DemoLabelDataSource {
    private InterlockingCrescentsDataSource() {
    }

    public InterlockingCrescentsDataSource(int numSamples) {
        super(numSamples, 12345L);
        this.postConfig();
    }

    @Override
    protected List<Example<Label>> generate() {
        int i;
        ArrayList<Example<Label>> list = new ArrayList<Example<Label>>();
        for (i = 0; i < this.numSamples / 2; ++i) {
            double[] values = new double[]{Math.cos(Math.PI * (double)i / (double)(this.numSamples / 2 - 1)), Math.sin(Math.PI * (double)i / (double)(this.numSamples / 2 - 1))};
            list.add((Example<Label>)new ArrayExample((Output)FIRST_CLASS, FEATURE_NAMES, values));
        }
        for (i = this.numSamples / 2; i < this.numSamples; ++i) {
            int j = i - this.numSamples / 2;
            double[] values = new double[]{1.0 - Math.cos(Math.PI * (double)j / (double)(this.numSamples / 2 - 1)), 0.5 - Math.sin(Math.PI * (double)j / (double)(this.numSamples / 2 - 1))};
            list.add((Example<Label>)new ArrayExample((Output)SECOND_CLASS, FEATURE_NAMES, values));
        }
        return list;
    }

    public String toString() {
        return "InterlockingCrescents(numSamples=" + this.numSamples + ")";
    }
}

