/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.rest;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.ml.common.memorycontainer.MemoryType;
import org.opensearch.ml.common.settings.MLCommonsSettings;
import org.opensearch.ml.common.settings.MLFeatureEnabledSetting;
import org.opensearch.ml.common.transport.memorycontainer.memory.MLSearchMemoriesAction;
import org.opensearch.ml.common.transport.memorycontainer.memory.MLSearchMemoriesInput;
import org.opensearch.ml.common.transport.memorycontainer.memory.MLSearchMemoriesRequest;
import org.opensearch.ml.utils.RestActionUtils;
import org.opensearch.ml.utils.TenantAwareHelper;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.transport.client.node.NodeClient;

public class RestMLSearchMemoriesAction
extends BaseRestHandler {
    private static final String ML_SEARCH_MEMORIES_ACTION = "ml_search_memories_action";
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;

    public RestMLSearchMemoriesAction(MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    public String getName() {
        return ML_SEARCH_MEMORIES_ACTION;
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.POST, "/_plugins/_ml/memory_containers/{memory_container_id}/memories/{memory_type}/_search"), (Object)new RestHandler.Route(RestRequest.Method.GET, "/_plugins/_ml/memory_containers/{memory_container_id}/memories/{memory_type}/_search"));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        if (!this.mlFeatureEnabledSetting.isAgenticMemoryEnabled()) {
            throw new OpenSearchStatusException(MLCommonsSettings.ML_COMMONS_AGENTIC_MEMORY_DISABLED_MESSAGE, RestStatus.FORBIDDEN, new Object[0]);
        }
        MLSearchMemoriesRequest mlSearchMemoriesRequest = this.getRequest(request);
        return channel -> client.execute((ActionType)MLSearchMemoriesAction.INSTANCE, (ActionRequest)mlSearchMemoriesRequest, (ActionListener)new RestToXContentListener(channel));
    }

    @VisibleForTesting
    MLSearchMemoriesRequest getRequest(RestRequest request) throws IOException {
        if (!request.hasContent()) {
            throw new IllegalArgumentException("Search memories request has empty body");
        }
        String memoryContainerId = RestActionUtils.getParameterId(request, "memory_container_id");
        String memoryTypeStr = RestActionUtils.getParameterId(request, "memory_type");
        MemoryType memoryType = MemoryType.fromString((String)memoryTypeStr);
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.parseXContent(request.contentOrSourceParamParser());
        searchSourceBuilder.fetchSource(RestActionUtils.getSourceContext(request, searchSourceBuilder));
        searchSourceBuilder.seqNoAndPrimaryTerm(Boolean.valueOf(true)).version(Boolean.valueOf(true));
        String tenantId = TenantAwareHelper.getTenantID(this.mlFeatureEnabledSetting.isMultiTenancyEnabled(), request);
        MLSearchMemoriesInput mlSearchMemoriesInput = MLSearchMemoriesInput.builder().memoryContainerId(memoryContainerId).memoryType(memoryType).searchSourceBuilder(searchSourceBuilder).build();
        return new MLSearchMemoriesRequest(mlSearchMemoriesInput, tenantId);
    }
}

